<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Ligipääs piiratud';
$string['accounts'] = 'Kontod';
$string['addcategory'] = 'Lisa kategooria';
$string['additionalhtml'] = 'Täiendav HTML';
$string['additionalhtml_desc'] = 'Need seaded lubavad ära määrata HTMLi mida lisatakse igale lehel. Saad ära määrata HTMLi mis lisatakse HEADi, kohe pärast BODY avanemist või just enne kui BODY suletakse. <br />Need sätted lubavad teil lisada kohandatud päiseid(head) või jaluseid(footer) igale lehele või lisada veebiteenus nagu Google Analytics väga kerge vaevaga, sõltumatta valitud kujundusest.';
$string['additionalhtmlfooter'] = 'Enne kui BODY suletakse';
$string['additionalhtmlfooter_desc'] = 'Siia lisatud sisu, lisatakse igale lehele enne kui BODY suletakse.';
$string['additionalhtmlhead'] = 'Päisesse (HEAD)';
$string['additionalhtmlhead_desc'] = 'Siia lisatud sisu, lisatakse igale lehele HEAD tagi lõppu.';
$string['additionalhtml_heading'] = 'Täiendav HTML mis lisatakse kõigile lehtedele';
$string['additionalhtmltopofbody'] = 'Kui BODY avaneb';
$string['additionalhtmltopofbody_desc'] = 'Siia lisatud sisu, lisatakse kõigile lehtedele kohe pärast BODY tagi avanemist.';
$string['admincategory'] = 'Kategooria: {$a}';
$string['adminseesall'] = 'Administraatorid näevad kõike';
$string['adminseesallevents'] = 'Administraator näeb kõiki sündmusi';
$string['adminseesownevents'] = 'Administraatorid on nagu kõik teised kasutajad';
$string['advancedfeatures'] = 'Erivalikud';
$string['allcountrycodes'] = 'Kõikide riikide koodid';
$string['allowbeforeblock'] = 'Lubatud nimekiri töödeldakse enne';
$string['allowbeforeblockdesc'] = 'Vaikimisi, blokeeritud IP´de nimekirja kirjeid, võrreldakse kõige esimesena. Kui see seade on lubatud, kirjed lubatud IP´de nimekirjast töödeldakse enne blokeeritud IP´de nimekirja.';
$string['allowblockstodock'] = 'Luba plokkidel kasutada dokki';
$string['allowcategorythemes'] = 'Luba kategooriate mallid';
$string['allowcoursethemes'] = 'Luba kursuse kujundused';
$string['allowediplist'] = 'Lubatud IP\'de nimekiri';
$string['allowemailaddresses'] = 'Lubatud e-mailidomeenid';
$string['allowframembedding'] = 'Luba raami sisse vistutamist';
$string['allowframembedding_help'] = 'Lubab käesoleva saidi vistutamist raami sisse välisel veebilehel. Selle võimaluse lubamine ei ole turvakaalutlustel soovitatav.';
$string['allowguestmymoodle'] = 'Luba külaliskasutajatel näha Minu Moodle lehte';
$string['allowobjectembed'] = 'Luba EMBED ja OBJECT märgendid';
$string['allowthemechangeonurl'] = 'Luba kujunduse muutusi URL-s';
$string['allowuserblockhiding'] = 'Luba kasutajatel peita plokke';
$string['allowuserswitchrolestheycantassign'] = 'Luba kasutajaid, kel pole "määra rollid" õigust, vahetada rolle.';
$string['allowuserthemes'] = 'Luba kasutaja kujundused';
$string['antivirus'] = 'Anti-Viirus';
$string['appearance'] = 'Kujundus';
$string['aspellpath'] = 'aspell rada';
$string['authentication'] = 'Autentimine';
$string['authpreventaccountcreation'] = 'Keela ära kontode loomine autentimise käigus';
$string['authpreventaccountcreation_help'] = 'Kui kasutaja autentib, siis luuakse automaatselt konto, kui seda pole. Kui kasutatakse välist autentimis meetodit nagu LDAP, aga soovite anda ligipääsu ainult nendele kasutajatele kellel on juba LDAPis konto olemas, siis peaksite lubama selle meetodi. Uusi kontosi saab käsitsi luua või lae üles kasutajad failist võimaluse abil. Märkus: See seade ei kehti MNet autentimise puhul.';
$string['authsettings'] = 'Autentimise haldus';
$string['autolang'] = 'Keele detekteerimine';
$string['autologinguests'] = 'Külaliste automaatne sisenemine';
$string['availablelicenses'] = 'Saadaval litsentsid';
$string['availableto'] = 'Saadaval';
$string['backgroundcolour'] = 'Läbipaistev värv';
$string['backups'] = 'Varukoopiad';
$string['backup_shortname'] = 'Kasuta kursuse nime varukoopia failinimes';
$string['backup_shortnamehelp'] = 'Kasuta kursuse nime osada varukoopia faili nimest.';
$string['badwordsconfig'] = 'Sisesta oma halbade sõnade nimekiri eraldatud komadega.';
$string['badwordsdefault'] = 'Kui kohandatud nimekiri on tühi, siis kasutatakse keelepakis olevat nimekirja.';
$string['badwordslist'] = 'Vaikimisi halbade sõnade nimekiri';
$string['blockediplist'] = 'Blokeeritud IP-aadresside nimekiri';
$string['blockeditingmenu'] = 'Ploki muutmise menüüd';
$string['blockeditingmenu_desc'] = 'Kui lubatud, siis mitmed plokkide muutmise ikoonid kuvatakse rippmenüüna. See vähendab ekraanil näidatavate elementide hulka kuni neid ei kasutata.';
$string['blockinstances'] = 'Eksemplarid';
$string['blockmultiple'] = 'Mitmekordne';
$string['blockprotect'] = 'Kaitse kustutamise eest';
$string['blockprotect_help'] = 'Kui lukustad teatud ploki, siis ei ole kellegil võimalik selle eksemplare lisada ega kustutada. (Muidugi võid ploki lahti lukustada, kui mõnda selle eksemplari on vaja muuta.)

See valik on mõeldud selleks, et kaitsta näiteks navigatsiooni ja sätete plokke, mida on kustutamise järel keeruline tagasi saada.';
$string['blocksettings'] = 'Halda plokke';
$string['blockunprotect'] = 'Kaitsetu';
$string['bloglevel'] = 'Veebipäeviku nähtavus';
$string['bookmarkadded'] = 'Järjehoidja lisatud.';
$string['bookmarkalreadyexists'] = 'Lehe järjehoidja juba olemas.';
$string['bookmarkdeleted'] = 'Järjehoidja kustutatud';
$string['bookmarkthispage'] = 'Lisa see leht järjehoidjasse';
$string['cacheapplication'] = 'Rakenduse puhver';
$string['cacheapplicationhelp'] = 'Puhverdatud elemendid on jagatud kõigile kasutajatele ja nende aegumine on määratletud aegumissätetes.';
$string['cachejs'] = 'Puhverda Javascript';
$string['cachejs_help'] = 'Javascripti puhverdamine ja pakkimine suuresti kiirendab laadimise jõudlust. Tugevalt soovitatav töös olevates keskkondades. Arendajad tõenäoliselt soovivad välja lülitada selle võimaluse.';
$string['cacherequest'] = 'Päringute puhver';
$string['cacherequesthelp'] = 'Kasutja päringuga seotud puhver aegub päringu lõppemisel. Loodud asendama staatilist sisu.';
$string['cachesession'] = 'Sessiooni puhver';
$string['cachesessionhelp'] = 'Kasutjaga seotud puhver, mis aegub sessiooni lõppedes.';
$string['cachesettings'] = 'Puhvri sätted';
$string['cachetext'] = 'Teksti vahemälu eluiga';
$string['caching'] = 'Puhverdamine';
$string['calendarexportsalt'] = 'Kalendri ekspordi sool';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendri tüüp';
$string['calendartype_desc'] = 'Vali vaikimisi kalendri tüüp kogu saidile. See seade on muudetav kursuse seadetes või kasutaja seadetes isiklikus profiilis.';
$string['calendar_weekend'] = 'Nädalavahetuse päevad';
$string['cannotdeletemodfilter'] = 'Sa ei saa maha installeerida filtrit \'{$a->filter}\', sest see on osa moodulist \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} ei saa maha installeerida';
$string['cfgwwwrootslashwarning'] = 'Oled kirjeldanud $CFG->wwwroot vigaselt oma config.php failis. Oled lisanud aadressi lõppu \'/\' märgi. Palun eemalda see, et vältida selliseid vigu:<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Oled kirjeldanud $CFG->wwwroot vigaselt oma config.php failis. See ei kattu lingig, mida kasutad leheni jõudmiseks. Palun paranda see viga et välitad selliseid vigu:<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'muuda';
$string['checkboxno'] = 'Ei';
$string['checkboxyes'] = 'Jah';
$string['choosefiletoedit'] = 'Vali fail keeleliseks toimetamiseks ülemisest kastikesest';
$string['clamfailureonupload'] = 'Clam AV tõrke korral';
$string['cleanup'] = 'Andmete säilitamine';
$string['clianswerno'] = 'ei';
$string['cliansweryes'] = 'jah';
$string['cliincorrectvalueerror'] = 'Viga, vigane väärtus "{$a->value}" "{$a->option}"-le';
$string['cliincorrectvalueretry'] = 'Vale väärtus(value), palun proovige uuesti';
$string['clistatusdisabled'] = 'Staatus: keelatud';
$string['clistatusenabled'] = 'Staatus: lubatud';
$string['clistatusenabledlater'] = 'staatus: CLI hooldsrežiim lülitatakse sisse {$a}';
$string['clitypevalue'] = 'tüübi väärtus';
$string['clitypevaluedefault'] = 'sisesta väärtus, vajuta Enter kasutamaks vaikeväärtust ({$a})';
$string['cliunknowoption'] = 'Tundmatud valikud:
   {$a}
Palun kasuta --help valikut.';
$string['cliupgradefinished'] = 'Käsurea põhine uuendus toimus edukalt.';
$string['cliupgradenoneed'] = 'Versioonile {$a} uuendusi ei ole. Tänan, et läbi astusid!';
$string['cliyesnoprompt'] = 'kirjuta y (tähendab jah) või n (tähendab ei)';
$string['commentsperpage'] = 'Kommentaare lehe kohta';
$string['commonfiltersettings'] = 'Üldised filtri seaded';
$string['commonsettings'] = 'Üldised seaded';
$string['componentinstalled'] = 'Komponent installeeritud';
$string['computedfromlogs'] = 'Arvutatud logidest alates {$a}';
$string['condifmodeditdefaults'] = 'Määratavad väärtused hakkavad olema vaikimisi väärtused, kui luuakse kursusel uus tegevus. Samuti saate määrata millised tegevuse seaded loetakse "Näita rohkem" seadete alla.';
$string['confeditorhidebuttons'] = 'Vali nupud, mis peaksid olema peidetud HTML-toimetis.';
$string['configallcountrycodes'] = 'Siin on nimekiri riikidest, mida on võimalik valida erinevates kohtades, nagu näiteks kasutaja profiilis. Kui jätta tühjaks, siis kasutatakse vaikimisi standard valikut mis Inglisekeele keelepakis on kasutusel. See on nimekiri mis vastab ISO 3166-1 standardile. Teisel juhul saate lisada ise riigi koodid, komaga eraldatult. Näiteks \'GB,FR,ES\'. Kui soovite lisada uut, mitte standard koodi, peate lisama selle countries.php faili mis asub \'en\' kataloogis, teie valitud keele paketis.';
$string['configallowassign'] = 'Saate lubada kasutajaid kellel on vasakul poolel olev roll, määrata rolle teistele kasutajatele.';
$string['configallowblockstodock'] = 'Kui on lubatud ja kujundusmall toetab, siis kasutajad saavad paigutada plokke spetsiaalsesse dokkimis piirkonda.';
$string['configallowcategorythemes'] = 'Kui see on lubatud, siis kujundusi saab määrata kategooria tasemel. See mõjutab kõiki alam kategooriaid ja kursusi, juhul kui pole teist kujundust määratud nende seadetest. HOIATUS: Kategooria tasemel kujunduste määramine võib mõjutada jõudlust.';
$string['configallowcoursethemes'] = 'Kui sa lubad selle, siis saavad kursused seada oma kujundust. Kursuste kujundused on ülimuslikud kõigi teiste kujustuste valikute (õpikeskkond, kasutaja, sessioon) suhtes.';
$string['configallowemailaddresses'] = 'Kui sa tahad kõiki uusi e-posti aadresse kitsendada teatud domeenideni, siis loetle domeenid siia, eraldades need tühikutega. Kõik ülejäänud domeenid keelatakse. Näide: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Kui lubatud, siis saavad külaliskasutajad näha Minu Moodle lehte. Vastasel juhul suunatakse külaliskasutajad saidi avalehele.';
$string['configallowobjectembed'] = 'Vaikimisi turvalisuse abinõu on, et tavakasutajad ei saa siduda multimeediat (nt. Flash\'i objekte)tekstiga, kasutades EMBED ja OBJECT märgendeid oma HTML koodis (kuigi antud toimingut saab edukalt teha, kasutades meediapistikute filtrit). Kui sa soovid neid märgendeid siiski võimaldada, siis lülita see valik sisse.';
$string['configallowoverride'] = 'Saad lubada vasakul pool toodud rollides kasutajtel muuta osasid veerus toodud rolle';
$string['configallowoverride2'] = 'Valige milliseid rolle saavad õigusi ülekatta, rollid mis asuvad vasakus tulbas.<br /> Teadmiseks, et need seaded mõjuvad ainult nendele kasutajatele, kellel on  moodle/role:override või moodle/role:safeoverride õigus lubatud.';
$string['configallowswitch'] = 'Valige millistesse rollidesse kasutaja saab ennast valida, lisaks rollidele mis neil juba on. Lisaks sellele kirjele peab kasutajal olema moodle/role:switchroles õigus, et rolli vahetada. <br /> Teadmiseks, et ainult seda rolli saab valida millel on moodle/course:view õigus ja millel pole moodle/site:doanything õigust.';
$string['configallowthemechangeonurl'] = 'Kui võimaldatud, siis kujundust saab muuta, lisades Moodle URL-i theme={kujunduse nimi}';
$string['configallowuserblockhiding'] = 'Kas soovid võimaldada kasutajatel peita ja nähtavaks teha küljeplokke kogu õpikeskkonna ulatuses? See võimalus kasutab Javascripti ja küpsiseid, et meelde jätta iga kokkupandava ploki olekut, ja mõjutab ainult kasutaja enda vaadet.';
$string['configallowuserthemes'] = 'Kui sa lubad selle, siis kasutajatel on võimalik määrata ise kujundust. Kasutaja kujundus on ülimuslikud õpikeskkonna kujunduste suhtes (aga mitte kursuse kujunduste suhtes).';
$string['configallusersaresitestudents'] = 'Kas õpikeskkonna esilehel olevate tegevuste jaoks loetakse kõiki kasutajaid õpilasteks? Kui sa vastad "Jah", siis iga kinnitatud kontot lubatakse neil tegevustel õpilasena osaleda. Kui sa vastad "Ei", siis ainult kasutajad, kes juba osalevad vähemalt ühel kursusel, võivad osa võtta esilehe tegevustest. Ainult administraatorid ja spetsiaalselt määratud õpetajad saavad osaleda esilehe tegevustes õpetajatena.';
$string['configauthenticationplugins'] = 'Palun valige autentimise meetodid, mida soovite kasutada ja reastage need, arvestades sisenemise meetodi olulisust.';
$string['configautolang'] = 'Detekteerib keele brauseri seadetest, kui väljas, siis kasutatakse vaikimisi keelt.';
$string['configautologinguests'] = 'Kas peaks tundmatud kasutajad automaatselt sisse logima külaliskasutajana, kui nad sisenevad kursusele?';
$string['configbloglevel'] = 'See seade lubab määrata, millisel tasemel kasutaja blogisi on võimalik näha. Märkuseks, et see kehtib ainult VAATAJA kohta, mitte postitaja või blogi tüübi kohta. Blogid saab üldse täielikult ära keelata kui neid ei soovi.';
$string['configcachetext'] = 'Suurematel lehtedel ja lehtedel, mis kasutavad tekstifiltreid, võib see seade asju kiirendada. Tekstide koopiaid hoitakse töödeldavas vormis antud lahtris määratud aja jooksul. Seades aja liiga väikeseks, võib see asju isegi veidi aeglustada, kuid liiga suureks määrates võtab teksti uuendus liiga kaua aega (nt uute linkide puhul).';
$string['configcalendarcustomexport'] = 'Luba kuupäevade vahemiku valimine kalendri ekspordil';
$string['configcalendarexportsalt'] = 'See juhuslik tekst on kasutusel, et tõsta turvalisust, näiteks kalendri eksportimisel. Teadmiseks: Kui kõik hetkel olevad turvalisuse sümbolid mis on kasutusel, muutuvad kehtetuks kui muudad antud hashi';
$string['configclamactlikevirus'] = 'Kohtle faile kui viiruseid';
$string['configclamdonothing'] = 'Kohtle failie kui "OK"';
$string['configclamfailureonupload'] = 'Kui sa oled konfigureerinud Clam\'i üles laetud failide kontrollimiseks, aga Clam on valesti konfigureeritud või tõrgub mingil muul põhjusel, mis siis peaks tegema? Kui sa valid "Kohtle faile kui viiruseid", siis nad eemaldatakse karantiinikataloogi või kustutatakse. Kui sa valid "Kohtle faile kui "OK"", siis failid liigutatakse tavapärasel moel sihtpunkti kataloogi. Ükskõik kumma variandi valid, teavitatakse administraatoreid igal juhul, et Clam\'iga oli mingi viga. Kui sa valid "Kohtle faile kui viiruseid" ja Clam tõrgub töötamast, siis KÕIK sinu üles laetud failid liigutatakse karantiinikataloogi või kustutatakse. Ole selle valikuga ettevaatlik.';
$string['configconvertformat'] = 'Kui <i>latex</i>, <i>dvips</i> ja <i>convert</i> on kättesaadaval, pildid luuakse kasutades määratud formaati. Kui ei ole, siis kasutatakse mimeTeX\'i ja ta teeb GIF pilte.';
$string['configcookiehttponly'] = 'Võimaldab uue PHP 5.2.0 võimaluse - veebilehitsejad saadavad ainult küpsiseid päris http päringute puhul. Küpsised ei tohiks olla ligipääsetavad skriptimis keeltele. Seda võimalust ei toeta kõik veebilehitsejad ja see ei pruugi olla ühilduv hetke koodiga. See aitab ära hoida teatud tüüpe XSS rünnakuid.';
$string['configcookiesecure'] = 'Kui server lubab ainult https ühendusi siis on soovitatav lubada saata ainult turvalisi küpsiseid. Kui lubatud siis palun veenduge, et veebiserver aktsepteeriks ainult https:// ühendusi ja oleks ümber suunatud http:// ühenduse pealt. Kui <em>wwwroot</em> aadress ei alga http:// siis see seade on automaatselt välja lülitatud.';
$string['configcountry'] = 'Kui siia sisestada riik, siis valitakse see riik vaikimisi uutele kasutajakontodele. Et kasutajat sundida riiki valima, jäta siia riik valimata.';
$string['configcourseoverviewfilesext'] = 'Komaga eraldatud nimekiri lubatud laienditest kursuse kokkuvõtte faili jaoks.';
$string['configcourseoverviewfileslimit'] = 'Kursuse kokkuvõttele manustatavate failide maksimum arv.';
$string['configcourserequestnotify'] = 'Sisesta kasutajanimi, keda teavitatakse uue kursuse tellimisel.';
$string['configcourserequestnotify2'] = 'Kasutajad, keda teavitatakse, kui kursuse taotlus esitati. Siin kuvatakse ainult kasutajad, kes saavad kursuste taotlemisi kinnitada.';
$string['configcoursesperpage'] = 'Sisesta number, mitu kursust kuvatakse kursuste loendi leheküljel';
$string['configcourseswithsummarieslimit'] = 'Maksimaalne kursuste arv, mida kuvatakse kursuste nimekirjas koos kokkuvõtetega enne lihtsustatud listile tagasiminekut.';
$string['configcronclionly'] = 'Kui see on valitud, siis saab cron\'i skripti käivitada ainult käsurealt ja mitte veebist. See kirjutab üle allpool asuvad cron parooli seaded.';
$string['configcronremotepassword'] = 'See tähendab, et cron.php skripti ei saa käivitada veebibrauserist ilma salasõnata. Salasõna saab edastada URL\'i kaudu kujul:<pre>
http://site.example.com/admin/cron.php?password=minusalasõna
</pre>Kui see on jäetud tühjaks, siis salasõna ei nõuta.';
$string['configcurlcache'] = 'cURL puhvri aega elada, sekundites.';
$string['configcustommenuitems'] = 'Sa saad seadistada kohandatud menüü, näidatuna kujunduste poolt. Iga rida sisaldab mõnda menüüteksti linki (fakultatiivne) ja  vihje (fakultatiivne), eraldatuna püstkriipsudega. Sa saad määrata struktuuri kasutades sidekriipse. Näiteks: <pre>
Moodle kogukond|http://moodle.org
-Moodle vaba toetus|http://moodle.org/support -Moodle arendus|http://moodle.org/development
--Moodle jälgija|http://tracker.moodle.org --Moodle Dokumentatsioon|http://docs.moodle.org -Moodle Uudised|http://moodle.org/news Moodle kompanii
-Moodle kommertsiaalne majutus|http://moodle.com/hosting
-Moodle kommertsiaalne toetus|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'Sisse lülituna kasutab see seadistus andmebaasi, kuhu salvestatakse kogu informatsioon hetke sessioonide kohta. See on eriti kasulik suurte/hõvatud veebilehtede või serverite klastritele ehitatud lehtede korral. Enamiku veebilehtede jaoks peaks see valik jääma välja lülitatuna. Pane tähele, et selle seadistuse vahetamine logib välja kõik kasutajad (kaasa arvatud sinu).';
$string['configdebug'] = 'Kui see sisse lülitada, siis PHP veateadete hulk suureneb, nii et trükitakse rohkem hoiatusi. See on vajalik üksnes tarkvaraarendajatele.';
$string['configdebugdisplay'] = 'Sea sisse, kui soovid, et veateated väljastatakse HTML-lehele. See on praktiline, kuid teeb katki XHTML, JS, küpsised ja HTTP päised. Seades välja, siis saadetakse väljund Sinu serveri logisse, võimaldades paremat silumist. PHP seadistus error_log kontrollib, mis logisse ta läheb.';
$string['configdebugpageinfo'] = 'Kui soovite lehe informatsiooni kuvada jaluses siis lubage antud seade.';
$string['configdebugsmtp'] = 'Võimalda silumisinfo e-mailide saatmisel SMTP serverile';
$string['configdebugvalidators'] = 'Lülitage sisse kui soovite näha jaluses linke, välistele koodi valideerimis lehtedele. Teil võibolla vajalik luua uus kasutaja, kasutajatunnusega <em>w3cvalidator</em> ja lubada külalis ligipääs. Need muudatused võimaldavad autentimatta ligipääsu lehele, seda ei tasuks sisselülitada reaalsetes keskkondades.';
$string['configdefaulthomepage'] = 'Määrab ära esilehe sisseloginud kasutajatele.';
$string['configdefaultrequestcategory'] = 'Kasutajate kursususte taotlused automaatselt pannakse sellesse kategooriasse.';
$string['configdefaultrequestedcategory'] = 'Vaikimisi kategooria uute kursuste taotlemisel.';
$string['configdefaultuserroleid'] = 'Kõigile sisseloginud kasutajad määratakse vastavasse rolli, mille siin määrad, keskkonna tasemel, LISAKS teistele rollidele mis neil juba on. Vaikimisi roll on "Sisenenud kasutajad". Märkus: See ei tekita konflikte teiste rollidega juhul kui mingeid õigusi ära ei keela, see kindlustab, et kõigil kasutajatel on vaikimisi õigused mida ei ole võimalik kursuse tasemel määrata (näiteks blogi postituste vaatamine, kalendri haldamine jne)';
$string['configdeleteincompleteusers'] = 'Peale seda aega mitte täielikult täidetud kontod kustutatakse';
$string['configdeleteunconfirmed'] = 'Kui kasutusel on e-posti kaudu autentimine, siis siin määratud ajavahemiku jooksul aksepteeritakse kasutajate vastuseid. Selle aja möödumisel kinnitamata kontod kustutatakse.';
$string['configdenyemailaddresses'] = 'Et keelata e-posti aadresse kindlatelt domeenidelt, loetle need siia samal moel. Kõiki teised domeenid on lubatud. Näide: <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Keela ära kasutajatel profiili pildi muutmine.';
$string['configdisplayloginfailures'] = 'See kuvab valitud kasutajatele informatsiooni varasematest ebaõnnestunud sisselogimistest.';
$string['configdndallowtextandlinks'] = 'Luba või keela tekstide ja linkide lohistamine ja asetamine kursuse lehele lisaks failidele. Pane tähele, et teksti lohistamine Firefox veebilehitseja aknasse või erinevate veebilehitsejate vahel võib viia üleslaadimise katkemiseni või muuta üleslaetava teksti kõlbmatuks.';
$string['configdocroot'] = 'Määrab ära Moodle Docs lingi. Kui soovite ise viidata oma online dokumentatsioonile, siis muutke see ära. Kui teete seda siis veenduge, et teie dokumentatsiooni formaat oleks sarnane sellele mis on http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Selle võimaldades, Moodle Docs lingid kuvatakse uues aknas.';
$string['configeditordictionary'] = 'Seda väärtust kasutatakse, kui tõlkes puudub sõnastik kasutaja keele jaoks.';
$string['configeditorfontlist'] = 'Vali milliseid fonte kuvatakse tekstiredaktori fondi nimekirjas';
$string['configemailchangeconfirmation'] = 'Nõua e-maili kinnituse sammu, kui kasutaja soovib vahetada oma profiili e-mailiaadressi.';
$string['configenableajax'] = 'See seadistus lubab kontrollida AJAX (advanced client/server interfaces using Javascript) kasutust üle kogu saidi. AJAX on vajalik teatud saidi funktsionaalsuste toimimiseks nagu näiteks lohistamine ja asetamine.';
$string['configenableblogs'] = 'See';
$string['configenablecalendarexport'] = 'Luba kalendrite eksportimine või jälgimine.';
$string['configenablecomments'] = 'Luba kommentaarid';
$string['configenablecourserequests'] = 'Võimaldab igal kasutajal taotleda kursuse loomist.';
$string['configenabledevicedetection'] = 'Võimaldab mobiilide, nutitelefonide ja teiste seadmete ära tundmist antud kujundusele ja teiste võimaluste suhtes.';
$string['configenablegroupmembersonly'] = 'Kui lubatud, siis ligipääsu tegevustele saab piirata ainult rühma liikmetele. See võib koormata serverit. Lisaks hinderaamatu kategooriad peavad olema loodud teistmoodi, et tegevused oleksid peidetud liikmete eest kes pole üheski rühmas.';
$string['configenablemobilewebservice'] = 'Luba mobiilne teenus, ametliku Moodle rakenduse või teiste rakenduste jaoks mis nõuavad seda. Rohkem informatsiooni saab lugeda sellekohta {$a}';
$string['configenablerssfeeds'] = 'See lülitab sisse RSS toite õpikeskkonnas. Et näha muudatusi, pead sa RSS toite sisse lülitama ka inviduaalsetel moodulitel. Mine moodulite seadistusse, kasutates administraatori konfiguratsiooni.';
$string['configenablerssfeedsdisabled'] = 'See ei ole kättesaadaval, kuna RSS toide on välja lülitatud kogu keskkonnast. Sisse lülitamiseks mine muutujate seadistusse, mis asub administraatori konfiguratsiooni all.';
$string['configenablerssfeedsdisabled2'] = 'RSS-söötmed on mittevõimaldatud serveri tasemel. Võimaldamiseks Sa vajad esiteks server/RSS\'s.';
$string['configenablesafebrowserintegration'] = 'See lisab valiku "Safe Exam Browser" - veebilehitseja turvalisus(Browser Security) väljale, testi seadete vormi. Külastage http://www.safeexambrowser.org/ , et näha rohkem informatsiooni.';
$string['configenablestats'] = 'Kui valid siin "jah", siis Moodle cronjob töötleb läbi logid ja kogub statistikat. Olenevalt veebiliiklusest lehel võib selle genereerimine üksjagu aega võtta. Kui lubad selle, siis kuvatakse huvitavaid graafikuid ja statistikat iga kursuse või terve keskkonna kohta.';
$string['configenabletrusttext'] = 'Vaikimisi Moodle alati puhastab teksti, mida kasutajad sisestavad ja eemaldab igasugused kahtlased/ohtlikud skriptid, meedia jne.. mis võivad põhjustada turvariske. Trusted Content süsteem võimaldab, teatud kasutajatele, keda usaldad, anda võimaluse lisada neid võimalusi sisusse, ilma segamatta. Selleks, et see võimaldada, tuleb sisse lülitada see seade ja seejärel anda Trusted Content õigus mingile Moodle rollile. Kõik selles rollis olevad kasutajad, kes loovad või laadivad üles tekste, nende tekste ei puhastata.';
$string['configenablewebservices'] = 'Veebiteenused võimaldavad teistel süsteemidel siseneda Moodle´isse ja teostada tegevusi. Lisa turvalisuse jaoks, tuleks see seade hoida keelatuna, kui just tõsiselt ei plaani kasutada.';
$string['configenablewsdocumentation'] = 'Luba automaatne dokumentatsiooni genereerimine veebiteenuste kohta. Kasutaja saab ligipääsu oma dokumentatsiooni lehele, oma turva võtmete lehele {$a}. See kuvab dokumentatsiooni, lubatud protokollide kohta ainult.';
$string['configerrorlevel'] = 'Vali PHP hoiatuste hulk, mida soovid kuvada. Parim valik on enamasti Normal.';
$string['configexportlookahead'] = 'Eksportimisel ettepoole arvestatavate päevade arv';
$string['configexportlookback'] = 'Eksportimisel tagasi arvestatavate päevade arv';
$string['configextendedusernamechars'] = 'Lülita see seadistus sisse kui soovid, et õppijad saaksid oma kasutajanimedes kasutada igasuguseid sümboleid. Vaikimisi on see "false" peal, mis tähendab, et kasutajanimedes on lubatud ainult tärgid.';
$string['configextramemorylimit'] = 'Mõned skriptid, nagu otsing, varukoopia/taastus ja cron, vajavad rohkem mälu. Seadista suuremad väärtused suurema saidi jaoks.';
$string['configfilterall'] = 'Filtreeri kõiki stringe, kaasa arvatud päiseid, pealkirju, navigatsiooniribasid jne. See omab mõtet, kui kasutad mitmekeelsuse filtrit, vastasel juhul tekitab ainult lisakoormust veebilehele.';
$string['configfiltermatchoneperpage'] = 'Automaatne lingi filtreerimine genereerib lingi ainult esimesel teksti sobivusel, teistel juhtudel jäetakse vahele.';
$string['configfiltermatchonepertext'] = 'Automaatne linkimine filtreerimine ainult genereerib ühe lingi esimese leitud vastava teksti esinemise kohta iga elemendi kohta tekstis (nt. ressurss, plokk) lehel. Kõiki muid ignoreeritakse. See seadistus on ignoreeritud kui üks lehe kohta on <i>Jah</i>';
$string['configfilteruploadedfiles'] = 'Selle seade lubamisel laseb Moodle enne näitamist kõik üleslaetud HTML- ja tekstifailid läbi filtrite.';
$string['configforcelogin'] = 'Tavaliselt on avaleht ja kursuste nimekirjad (mitte kursused ise) nähatavad ka sisenemata. Kui tahad, et kasutajad enne ÜKSKÕIK mis tegevust siseneksid, luba see seadistus.';
$string['configforceloginforprofiles'] = 'Lülita see seadistus sisse, kui soovid sundida inimesi sisenema reaalse kontoga (mitte külalisena), et nad saaksid kasutajate andmeid vaadata. Vaikimisi on see seadistus välja lülitatud. Seega saavad tulevased õppijad iga kursuse õpetajate kohta infot lugeda, aga see tähendab ka seda, et vastavat infot on otsingumootorites näha.';
$string['configfrontpage'] = 'Eespool märgitud komponente näidatakse õpikeskkonna esilehel.';
$string['configfrontpagecourselimit'] = 'Maksimaalne kursuste arv';
$string['configfrontpagecourselimithelp'] = 'Maksimaalne kursuste arv, mis kuvatakse saidi avalehel kursuste loetelus.';
$string['configfrontpageloggedin'] = 'Eespool märgitud komponente näidatakse õpikeskkonna esilehel pärast seda, kui kasutaja on sisenenud.';
$string['configfullnamedisplay'] = 'See määrab ära, kuidas kuvatakse täielikud nimed. Enamikule üks-keelsetele lehtedele on parim valik vaikeväärtus "Eesnimi + Perenimi", kuid võid peita perenimed või jätta seadistuse keelepaketi otsustada (mõnedel keeltel on teistsugused esitusviisid).';
$string['configgeoipfile'] = 'GeoIP City binaarandmete faili asukoht. See fail ei ole osa Moodle distributsioonist ja pead olema hangitud eraldi saidilt<a href="http://www.maxmind.com/">MaxMind</a>. Sa saad osta ärilise või kasutada vaba versiooni.<br />Lihtsalt tõmba alla <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> ja paki lahti "{$a}" kataloogi oma serveris.';
$string['configgetremoteaddrconf'] = 'Kui su server asub pöördproksi taga, siis sa saad kasutada seda seadistust määramaks mis HTTP päiseid saab usaldada sisaldamas välist IP-aadressi. Päiseid loetakse järjekorras, kasutades esimest kättesaadavat.';
$string['configgradebookroles'] = 'See seade lubab ära määrata keda kuvatakse hinderaamatus. Kasutajad peavad olema vähemalt ühes neis rollis kursusel, et neid näidataks kursuse hinderaamatus.';
$string['configgradeexport'] = 'Valige milline hinderaamatu ekspordi formaat oleks peamine. Valitud vidinad määravad ja tekitavad ühe "viimati eksporditud" välja iga hinde jaoks. Näiteks selle abil võib ära määrata kas kirjed on "uued" või "uuendatud". Kui olete ebakindel valikute tegemises jätke kõik tühjaks.';
$string['confighiddenuserfields'] = 'Vali milline kasutajate info väljad soovid peita teiste kasutajate eest (v.a. kursuse õppejõud ja administraatorid. Selliselt saab suurendada õpilaste privaatsust. Hoia all CTRL klahvi valimaks mitut välja.';
$string['configidnumber'] = 'See seade määrab, kas (a) Kasutajatelt ei küsita ID numbrit üldse,(b) Kasutajatelt küsitakse ID numbrit, kuid nad saavad selle välja tühjaks jätta või (c) Kasutajatelt küsitakse ID numbrit ja välja ei saa tühjaks jätta. Kasutajate ID numbrit näidatakse tema profiilis, kui nii on seadistatud.';
$string['configintro'] = 'Sellel lehel võid täpsustada konfiguratsioonide muutujate hulka, mis panevad Moodle\'i sinu serveris korralikult tööle. Ära liialt pabista - vaikeseaded töötavad enamasti hästi sa võid alati sellele lehele tagasi tulla ja seadeid muuta.';
$string['configintroadmin'] = 'Sellel lehel sa peaksid konfigureerima peamise administraatori konto, mis kontrollib kogu õpikeskkonda. Veendu, et kasutajanimi ja salasõna on turvalised ning e-posti aadress kehtib. Hiljem võid administraatori kontosid veel juurde luua.';
$string['configintrosite'] = 'See leht võimaldab konfigureerida käesoleva uue õpikeskkonna esilehte ja nime. Võid hiljem siia igal ajal tagasi tulla, et seadeid muuta, klikkides kodulehel lingile "Õpikeskkonna seaded".';
$string['configiplookup'] = 'Kui vajutad IP-aadressil (nt. 34.12.222.93), näiteks logides, siis kuvatakse kaart, kus antud IP-aadress arvatavasti peaks asuma. Kasutada on võimalik erinevaid pluginaid, millel igaühel on oma plussid ja miinused.';
$string['configkeeptagnamecase'] = 'Märkige ära, kui soovite märksõnade nimes hoida originaal tõstutundlikust, nende kasutajate poolt kes need sisestavad.';
$string['configlang'] = 'Vali vaikeseade keel kogu õpikeskkonna jaoks. Kasutajad võivad seda seadet hiljem oma äranägemise järgi muuta.';
$string['configlanglist'] = 'Jäta see lahter tühjaks, et võimaldada kasutajatel valida kõigi keelte hulgast, mis on sinu  Moodle\'i installatsioonis. Keelte menüüd võid siiski lühendada, sisestades komaga eraldatud nimekirja keelte koodidest, mida soovid kasutada. Näiteks: en,es_es,fr,it';
$string['configlangmenu'] = 'Vali, kas üldist keelte menüüd kodulehel, sisenemislehel jne kuvada või mitte. See seadistus ei mõjuta kasutajate võimalust valida eelistatud keelt nende oma profiilis.';
$string['configlangstringcache'] = 'Puhverdab kõik keele tõlked, kompileeritud faili andmete kataloogis. Kui parasjagu tõlgid Moodle´it või muudad tõlkeid Moodle lähtekoodis siis tasuks see seade välja lülitada, teistel juhtudel tuleks see sees hoida, tõstab jõudlust.';
$string['configlatinexcelexport'] = 'Vali kodeering Excel\'i ekspordile.';
$string['configlocale'] = 'Vali kogu õpikeskkonna geograafiline asukoht - see mõjutab kuupäevade formaati ja keelt. Sul peab olema see lokaalandmestik installeeritud operatsioonisüsteemi. (nt en_US või es_ES). Kui sa ei tea, mida valida, jäta see tühjaks.';
$string['configloginhttps'] = 'Selle sisse lülitamine paneb Moodle\'it kasutama turvalist https ühendust ainult sisenemise jaoks. Peale seda pöördutakse tagasi normaalse http URL-i juurde. Hoiatus: See seadistus vajab https spetsiaalset sisselülitamist veebiserverist. Kui see nii ei ole siis VÕID SA ENNAST ENDA LEHELT VÄLJA LUKUSTADA.';
$string['configloglifetime'] = 'See määrab ajavahemiku pikkuse, mille jooksul soovid säilitada logifaili kasutajate tegevuse kohta. Logid, mis on sellest vanemad, kustutatakse automaatselt. Parim lahendus on hoida logifaile nii kaua kui võimalik, juhuks, kui neid vaja läheb, kuid väga koormatud serveri ja toimimisprobleemide puhul võiks logifailide eluiga lühendada.';
$string['configlookahead'] = 'Ette nähtavad päevad';
$string['configmaxbytes'] = 'Määrab üleslaaditavate failide maksimaalse suuruse terves õpikeskkonnas. See seadistus on piiratud PHP seadistuse upload_max_filesize ja Apache seadistuse LimitRequestBody poolt. \'maxbytes\' omakorda piirab ka kursuse ja mooduli tasemel valitavat suuruste vahemikku.';
$string['configmaxconsecutiveidentchars'] = 'Salasõnades ei tohiks esineda enam kui märgitud arv identseid sümboleid järjest. Sisesta siia 0, et seda kontrolli mitte rakendada.';
$string['configmaxeditingtime'] = 'Määrab aja, mille jooksul inimesed peavad ümber muutma foorumipostitusi, sõnastiku kommentaare jne. Enamasti on 30 minutit piisav väärtus.';
$string['configmaxevents'] = 'Tulevased sündmused';
$string['configmaxusersperpage'] = 'Kasutajate valikus kuvatav maksimaalne kasutajate arv.';
$string['configmessaging'] = 'Kas sõnumite süsteem peaks õpikeskkonna kasutajate vahel olema sisse lülitatud?';
$string['configmessagingallowemailoverride'] = 'Luba kasutajatel saada e-kirju kasutaja profiilis toodud e-posti aadressist erinevale aadressile';
$string['configmessagingdeletereadnotificationsdelay'] = 'Loetuse teavitused saab kustutada, et hoida kokku ruumi. Kui palju pärast teavitust on loetud, ta saab kustutada?';
$string['configmessaginghidereadnotifications'] = 'Peida loetuse teavitusi nagu näiteks foorumi postitused, mil vaadatakse sõnumivahetuse ajalugu';
$string['configminpassworddigits'] = 'Salasõnad peavad sisaldama vähemalt nii palju numbreid.';
$string['configminpasswordlength'] = 'Salasõnad peavad sisaldama vähemalt nii tähemärki pikad.';
$string['configminpasswordlower'] = 'Salasõnad peavad sisaldama vähemalt nii palju väiketähti.';
$string['configminpasswordnonalphanum'] = 'Salasõnad peavad sisaldama vähemalt nii palju mitte numbreid ja tähti.';
$string['configminpasswordupper'] = 'Salasõnad peavad sisaldama vähemalt nii palju suurtähti.';
$string['configmobilecssurl'] = 'CSS fail, et muuta oma mobiilse APP-i välimust.';
$string['configmodchooserdefault'] = 'Kas tegevuste valik peaks olema kasutajatele vaikimisi kuvatud?';
$string['configmycoursesperpage'] = 'Maksimaalne kasutaja kursuste nimekirjas kuvatav kursuste arv';
$string['configmypagelocked'] = 'Need seaded piiravad vaikimisi lehe muutmist mitte-administraatorite poolt.';
$string['confignavcourselimit'] = 'Piirab ära kursuste arvu kuvamise kasutajatele, kes pole sisseloginud või kes pole ühelgi kursusel osaleja.';
$string['confignavshowallcourses'] = 'Selle seade määramisel, kuvatakse kõik kursused alati avalikult.';
$string['confignavshowcategories'] = 'Kuva kursuste kategooriad navigeerimis ribal ja plokis. See ei kehti kursustega millesse kasutaja on registreerunud, need kuvatakse endiselt "Minu kursuste" all ilma kategooriateta.';
$string['confignotifyloginfailures'] = 'Kui sisselogimise ebaõnnestumisi registreeritakse, saadetakse e-kirjaga teade. Kes neid teateid nägema peaks?';
$string['confignotifyloginthreshold'] = 'Kui sisselogimiste ebaõnnestumiste teated on aktiviseeritud, siis kui palju sisselogimise katseid peaks ühelt kasutajalt või IP aadressilt tulema, enne kui teade saadetakse?';
$string['confignotloggedinroleid'] = 'Kasutajad kes pole sisenenud keskkonda, neid koheldakse nii nagu neil oleks see roll keskkonna kontekstis. Üldjuhul Külalis roll on siinkohal kõige otstarbekam aga võimalik, et soovid luua lisa rolli millel on rohkem õigusi. Teatud asjadel nagu postituste loomine, nõuavad endiselt kasutajalt sisselogimist.';
$string['configopentogoogle'] = 'Selle seadistuse sisse lülitamisel lubatakse Google\'il õpikeskkonda külalisena siseneda. Lisaks kõik Google otsingu kaudu õpikeskkonnani jõudnud inimesed logitakse automaatselt sisse külalistena. See pakub vaid nähtamatut ligipääsu kursustele, kus külaliste juurdepääs on juba lubatud.';
$string['configoverride'] = 'Defineeritud failis config.php';
$string['configpasswordpolicy'] = 'Selle lubamisel, hakkab Moodle kontrollima kasutajate paroolide puhul parooli tingimusi. Kasutage all olevaid seadeid, et ära määrata paroolide tingimused (paroolide tingimusi eiratakse kui see seade on "Ei"(No))';
$string['configpasswordresettime'] = 'See määrab ära aja hulga, mille jooksul tuleb kinnitada oma parooli taastamine enne, kui see aegub. Harilikult on 30 min piisav aeg.';
$string['configpathtoclam'] = 'Clam AV asukoht. Tõenäoliselt midagi sarnast nagu /usr/bin/clamscan või /usr/bin/clamdscan. Sa vajad seda Clam AV käima panemiseks.';
$string['configpathtodu'] = 'Tõenäoliselt /usr/bin/du. Kui lisada, siis kaustade sisu kuvavad lehed jooksevad palju kiiremini, kus on palju faile';
$string['configperfdebug'] = 'Kui sisse lülitatud, siis kuvatakse jaluses jõudlusinfo';
$string['configprofileroles'] = 'Rollide nimekiri mis on nähtav kasutaja profiilis ja osalejate lehel.';
$string['configprofilesforenrolledusersonly'] = 'Kaitseks spämmerite eest, profiili kirjeldused kasutajate kohta kes pole ühelgi kursusel registreerunud, on peidetud. Uued kasutajad peavad registreeruma vähemalt ühele kursusele, et nad saaksid muuta oma profiili kirjeldust.';
$string['configprotectusernames'] = 'Vaikimisi forget_password.php ei kuva mingeid vihjeid, mis võiks aidata ära arvata kasutajatunnuseid või e-maili aadresse.';
$string['configproxybypass'] = 'Komaga eraldatud konkreetsete hostide või IP-de nimekiri, mis peab läbi laskma proksist (nt., 192.168., .minudomeen.ee)';
$string['configproxyhost'] = 'Kui sellel <B>serveril</B> on tarvis kasutada puhverarvutit (näiteks tulemüüri) internetti pääsemiseks, siis varusta see puhver siin hostinime ja pordiga. Vastasel juhul jäta lahter tühjaks.';
$string['configproxypassword'] = 'Parool on vajalik, et pääseda internetti läbi proxy aadressi, jätke see väli tühjaks, kui puudub (PHP cURL laiendus on vajalik).';
$string['configproxyport'] = 'Kui antud server vajab vahendajat (proxy), siis märgi siia port.';
$string['configproxytype'] = 'Veebiproksi tüüp (PHP5 ja cURL laiendus nõuavad SOCKS5 toetust).';
$string['configproxyuser'] = 'Kasutajatunnus on vajalik, et pääseda internetti läbi proxy aadressi, jätke see väli tühjaks, kui puudub (PHP cURL laiendus on vajalik).';
$string['configquarantinedir'] = 'Kui sa soovid, et Clam AV liigutaks nakatunud failid karantiinikataloogi, siis sisesta kataloog siin. See peab olema kirjutatav veebiserveri poolt. Kui sa jätad selle lahtri tühjaks või kui sa sisestad kataloogi, mis ei eksisteeri või ei oma kirjutusõigust, siis nakatunud failid kustutatakse.';
$string['configrecaptchaprivatekey'] = 'Sõna mida kasutatase, et suhelda Moodle ja reCAPTCHA serveri vahel. Selle saamiseks tuleb minna aadressile http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Sõna mida kuvatakse reCAPTCHA elemendis, registreerimis vormis. See genereeritakse http://www.google.com/recaptcha poolt';
$string['configrequestcategoryselection'] = 'Luba kursuse taotlemisel kategooria valimist.';
$string['configrequestedstudentname'] = 'Õpilase nimetus tellitud kursusel';
$string['configrequestedstudentsname'] = 'Õpilaste nimetus tellitud kursusel';
$string['configrequestedteachername'] = 'Õpetaja nimetus tellitud kursusel';
$string['configrequestedteachersname'] = 'Õpetajate nimetus tellitud kursusel';
$string['configrequiremodintro'] = 'Keela see valik, kui soovid, et kasutajad ei peaks iga tegevus vahendi juurde kirjeldust lisama.';
$string['configrunclamavonupload'] = 'Kui võimaldatud, siis clam AV kasutatakse kõikide üleslaetud failide skänneerimiseks.';
$string['configrunclamonupload'] = 'Käivita Clam AV failide üles laadimisel? Sul on vaja õiget asukohta \'pathtoclam\'-is, kui soovid antud funktsionaalsust tööle saada. (Clam AV on tasuta viirusteotsija, mille võid hankida aadressilt http://www.clamav.net/)';
$string['configsectioninterface'] = 'Kasutajaliides';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Andmete säilitamine';
$string['configsectionmisc'] = 'Varia';
$string['configsectionoperatingsystem'] = 'Operatsioonisüsteem';
$string['configsectionpermissions'] = 'Õigused';
$string['configsectionrequestedcourse'] = 'Kursuste taotlused';
$string['configsectionsecurity'] = 'Turvalisus';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Kasutajad';
$string['configsecureforms'] = 'Moodle saab kasutada lisaturvatasandit veebivormidelt andmete vastuvõtmisel. Kui see on lubatud, siis brauseri HTTP_REFERER muutujat kontrollitakse antud vormi aadressiga võrreldes. Mõnel üksikul juhul võib see põhjustada probleeme, kui kasutaja kasutab tulemüüri (näiteks Zonealarm), mis on konfigureeritud HTTP_REFERER oma võrguliiklusest maha võtma.  Sümptomiteks on vormi "kinni kiilumine". Kui sinu kasutajatel on selliseid probleeme (näiteks) sisenemislehega, siis võid sa tahta seda seadistust ilmselt blokeeerida, ehkki see võib jätta sinu õpikeskkonna kaitsetuks jõulistele salasõna-rünnakutele. Kui kahtled, jäta siia seadeks "Jah".';
$string['configsessioncookie'] = 'See seade kohandab Moodle\'i sessiooni küpsiste nime. Valikuline ja kasulik vaid siis, kui samal lehel jookseb mitu Moodle\'i koopiat ja küpsised võivad segamini minna.';
$string['configsessioncookiedomain'] = 'See lubab muuta domeeni, milles Moodle küpsised on kättesaadavad. See on kasutatav Moodle kohandamiseks (nt. autentimine või registreerumise pluginad), mis vajavad Moodle seansside info jagamist teistes alamdomeenides asuvate veebirakendustega. <strong>HOIATUS: see on tugevalt soovitatav jätta see seadistus vaikeväärtuseks (tühjaks) - vale väärtus piirab kõik sisse logimised saidile.</strong>';
$string['configsessioncookiepath'] = 'Kui on vaja ära määrata kuidas Moodle kasutab küpsiseid(cookies), võite muuta seda seadet, et ära määrata alamkataloog oma domeenis. Üldjuhul vaikimisi "/" peaks sobima.';
$string['configsessiontimeout'] = 'Kui õpikeskkonda sisenenud inimesed on kauemat aega tegevuseta (lehti ei laadi), siis nad logitakse automaatselt välja (nende sessioon lõpetatakse). See muutuja määrab, kui pikk peaks tegevusetuse aeg olema, et toimuks väljalogimine.';
$string['configshowcommentscount'] = 'Kuvada kommentaaride arvu, see teeb lisapäringu andmebaasi kui kuvatakse kommentaaride link.';
$string['configshowicalsource'] = 'Kuva allika info iCal sündmuste juurde';
$string['configshowsiteparticipantslist'] = 'Kõik õpikeskkonna õppijad ja õpetajad kuvatakse õpikeskkonnas osalejate listis. Kellel on õigust näha seda osalejate listi?';
$string['configsitedefaultlicense'] = 'Vaikimisi litsents';
$string['configsitedefaultlicensehelp'] = 'Vaikimisi litsents sisu avaldamiseks keskkonnas';
$string['configsitemaxcategorydepth'] = 'Maksimaalne kategooria sügavus';
$string['configsitemaxcategorydepthhelp'] = 'See määrab maksimaalse kuvatavate kategooriate sügavuse. Sügavamad kategooriad kuvatakse linkide kujul ja kasutajad saavad neid AJAX päringute kaudu avada.';
$string['configslasharguments'] = 'Failide (piltide, üleslaaditud materjali jne)hankimine toimub läbi skripti, mis kasutab meetodit \'slash arguments\' (kaldkriipsu argumendid), siin menüüs teine valik. See meetod võimaldab faile lihtsamalt veebibrauserite, puhverserverite jne vahemällu salvestada. Kahjuks mõned PHP serverid seda meetodit ei võimalda, nii et kui esineb probleeme üleslaetud failide või piltide vaatamisel, vali menüüst muutuja esimene variant.';
$string['configstartwday'] = 'Nädala algus';
$string['configstatsfirstrun'] = 'See määrab kui kaugele tagasi logitöötlusega peaks minema <b>esimesel korral</b> cronjob statistika töötlemisel. Kui saidil on palju liiklust ja see on majutatud jagatud pinnale, siis pole tõenäoliselt hea mõte minna ajas liialt kaugele, sest see võib võtta kaua aega ja olla üpris ressursimahukas. (Pane tähele, et siin seadetes 1 kuu = 28 päeva. Graafikutel ja genereeritud raportitel 1 kuu = 1 kalendrikuu.)';
$string['configstatsmaxruntime2'] = 'Statistika töötlemine võib olla üsna ressursimahukas tegevus. Seadista maksimaalne aeg, mis võib kuluda ühe päeva jagu statistika töötlemiseks. Ühe korraga on cron\'ga lubatud töödelda kuni 31 päeva jagu statistikat.';
$string['configstatsmaxruntime3'] = 'See määrab ära maksimaalse aja, mis on lubatud ühe päeva jagu statistika genereerimiseks korraga. Tasub meeles pidada, et statistika genereerimine koormab serverit. Maksimaalse päevade arvu, mida töödeldakse ühes cron\'is, saab määrata allpool.';
$string['configstatsruntimedays'] = 'See määrab maksimaalse päevade arvu, mida iga statistika kogumise ajal töödeldakse. Kui statistika on ajakohane (up-to-date), siis töödeldakse korraga vaid üks päev - seega määrake see väärtus vastavalt oma serveri jõudlusele ja vajadusel vähendage seda kui vajate lühemaid cron\'i käivitusaegu.';
$string['configstatsruntimestart'] = 'Mis kella ajal peaks statistikat genereeriv cronjob alustama? Palun määrake erinevad ajad, kui ühes serveris töötavad mitu erinevat Moodle´it.';
$string['configstatsuserthreshold'] = 'See seade määrab ära minimaalse kasutajate arvu kursustel, mida arvestatakse statistika genereerimisel.';
$string['configstrictformsrequired'] = 'Kui lubatud, siis kasutajatel on keelatud sisestada tühikuid või reavahetusi nõutud väljadel.';
$string['configstripalltitletags'] = 'Eemalda linnuke lubamaks HTML-märgendeid tegevuste ja ressurside nimedes.';
$string['configsupportemail'] = 'See e-posti aadress kuvatakse kasutajatele selliselt, et see on üldise abi saamiseks. Näiteks: Kui kasutaja loob uut kontot. Kui see e-posti aadressi väli jätta tühjaks siis seda ei kuvata.';
$string['configsupportname'] = 'Tema on isik või miski muu, mis pakub abi e-maili või veebilehe abil.';
$string['configsupportpage'] = 'Seda veebiaadressi näidatakse kasutajatele, kui neil on vaja üldist abi (näiteks kui kasutaja loob oma konto). Kui see aadress jäetakse tühjaks, siis linki ei kuvata.';
$string['configthemedesignermode'] = 'Tavaliselt kõik kujundus pildid ja stiilid on puhverdatud vahemällu veebilehitsejates ja serveris pikaks ajaks, jõudluse nimel. Kui lood uut kujundust või programmeerid koodi, siis tasuks see välja lülitada, et sa ei näeks keskkonda puhverdatud kujul. Hoiatus: See teeb lehe aeglasemaks kõikide kasutajate jaoks! Alternatiivina, saad samas ka käsitsi vahemälu tühjendada Kujunduse valimise lehelt.';
$string['configthemelist'] = 'Jäta see lahter tühjaks, kui soovid, et kasutada oleks võimalik iga olemasolevat kujundust. Kui soovid kujunduste menüüd lühendada, võid määrata komadega eraldatud nimekirja kujundustest siin (ära kasuta tühikuid!). Näide: standard,orangewhite.';
$string['configtimezone'] = 'Määra vaikimisi seatud ajavöönd siin. See on vaid vaikeväärtus kuupäevade näitamiseks. Iga kasutaja saab määrata oma profiilis sobiva ajavööndi. "Serveri kohalik aeg" siin määrab Moodle\'i kella vastavalt operatsioonisüsteemi seadele, kuid "Serveri kohalik aeg" kasutaja profiilis seab kasutajale siin lahtris määratud ajatsooni.';
$string['configuseblogassociations'] = 'Kas kasutajatel peaks olema võimalik organiseerida oma blogi sisestusi kursuste ja kursuste vahenditega';
$string['configuseexternalyui'] = 'Selle asemel, et kasutada lokaalseid faile, kasutatakse online faile Yahoo serveritest. HOIATUS: See nõuab interneti ühendust, vastasel juhul AJAX ei toimi.';
$string['configuserquota'] = 'Mitu baiti kasutaja hoiustada oma privaatses failialas. {$a->bytes} baiti == {$a->displaysize}';
$string['configusetags'] = 'Kas märksõnade funktsionaalsus peaks olema lubatud terves keskkonnas?';
$string['configvariables'] = 'Konfigureeri muutujad';
$string['configverifychangedemail'] = 'Lubab kasutajate emaili kinnituse vastavalt lubatud või keelatud emaili domeeni seadetele. Kui see seade on keelatud, siis domeene kontrollitakse ainult uute kasutajate loomisel.';
$string['configvisiblecourses'] = 'Näita kursuseid peidetud kategooriates';
$string['configwarning'] = 'Ole ettevaatlik nende seadistuste muutmisel - valed väärtused võivad tekitada tõsiseid probleeme.';
$string['configyuicomboloading'] = 'See seade võimaldab kombineeritud moel failide laadimise optimeerimist YUI teekidega. See seade peaks olema lubatud reaalsetes keskkondades.';
$string['confirmation'] = 'Kinnitus';
$string['confirmdeletecomments'] = 'Olete kustutamas kommentaare, kas olete kindel?';
$string['confirmed'] = 'Kinnitatud';
$string['convertformat'] = '<i>convert</i> väljundformaat';
$string['cookiehttponly'] = 'Ainult http küpsised';
$string['cookiesecure'] = 'Ainult turvalised küpsised';
$string['country'] = 'Vaikimisi riik';
$string['coursecontact'] = 'Kursuse haldajad';
$string['coursecontact_desc'] = 'See seade lubab määrata ära, keda kuvatakse kursuse kirjelduses. Kasutajatel peab vähemalt olema üks nendest rollidest, et nende nimed kuvatakse kursuse kirjelduses.';
$string['coursemgmt'] = 'Halda kursuseid ja kategooriaid';
$string['courseoverview'] = 'Kursuse ülevaade';
$string['courserequestnotify'] = 'Kursuse taotlemise teavitus';
$string['courserequestnotifyemail'] = 'Kasutaja {$a->user} taotles uut kursust ({$a->link})';
$string['courserequests'] = 'Kursuste taotlused';
$string['courserequestspending'] = 'Kursuse taotlus on ootel';
$string['courses'] = 'Kursused';
$string['coursesperpage'] = 'Kursused lehekülgede kaupa';
$string['creatornewroleid'] = 'Loojate roll uutes kursustes';
$string['creatornewroleid_help'] = 'Kui kasutajal puuduvad õigused hallata uut kursust siis kasutaja lisatakse kursusele automaatselt sellesse rolli.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Cron käivitamine ainult käsurealt';
$string['cronerrorclionly'] = 'Vabandust, kuid ligipääs vastavale Interneti lehele on keelatud administraatori poolt.';
$string['cronerrorpassword'] = 'Vabandust, kuid sa ei pakkunud sellele veebilehele ligipääsuks õiget salasõna selele';
$string['cron_help'] = 'cron.php hooldus script aitab mõnedel Moodle moodulitel sooritada plaaneeritult tegevusi, nagu näiteks foorumi postituste kohta e-kirjade välja saatmine. Mehhanism on vajalik, et see skript käivituks regulaarsel, näiteks iga 5 minuti järel.';
$string['cronremotepassword'] = 'Cron salasõna kaugligipääsuks';
$string['cronwarning'] = '<a href="cron.php">cron.php hooldusskript</a> pole vähemalt 24 tundi käivitunud.';
$string['ctyperecommended'] = 'valikulise ctype PHP laienduse installeerimine on väga soovitatav, selleks, et tõsta keskkonna jõudlust ja pakkuda mitmekeelsust.';
$string['ctyperequired'] = 'ctype PHP laiendus on nõutud Moodles, selleks, et tõsta keskkonna jõudlust ja pakkuda mitmekeelsust.';
$string['curlcache'] = 'cURL puhvri aega elada';
$string['curlrecommended'] = 'Fakultatiivse Curl teegi installeerimine on väga soovitatav, millega võimaldatakse Moodle võrgunduse funktsionaalsus.';
$string['curlrequired'] = 'cURL PHP laiendus on nõutud Moodles, selleks, et suhelda teiste Moodle repositooriumitega.';
$string['curltimeoutkbitrate'] = 'Bitisagedus mida kasutada kui arvutatakse cURL aegumist(Kbps)';
$string['curltimeoutkbitrate_help'] = 'Seda seadet kasutatakse arvutamaks suurte cURL päringute aegumist. Osaliselt arvutatakse HTTP HEAD päringu abil, et leida sisu suurus. Kui see seade määrata 0´iks siis keelatakse ära selle päringu tegemine.';
$string['currenttheme'] = 'Praegune kujundus';
$string['customcheck'] = 'Muud kontrollid';
$string['custommenu'] = 'Kohandatud menüü';
$string['custommenuitems'] = 'Kohandatud menüü elemendid';
$string['datarootsecurityerror'] = '<p><strong>TURVA HOIATUS!</strong></p><p>Data kataloog on vales asukohas ja on kättesaadav veebist. See tähendab, et kõik privaatsed failid on kättesaadavad kõigile ja mõnda neist võib kasutada häkker, et saada ligipääs administratiivsetele õigustele sinu keskkonnas!</p><p>Sa <em>pead</em> liigutama data kataloogi({$a}) uude asukohta, mis ei oleks avalikus veebikataloogis ja uuendama <code>$CFG->dataroot</code> seadet config.php failis.</p>';
$string['datarootsecuritywarning'] = 'Sul on turvaprobleem õpikeskkonna seadistuses. Andmete juurkataloog ({$a}) ei tohiks olla veebist ligipääsetavas kataloogis.';
$string['dbmigrate'] = 'Moodle andmebaasi migreerimine';
$string['dbmigrateconnecerror'] = 'Ei õnnestunud luua ühendust, määratud andmebaasiga.';
$string['dbmigratewarning'] = 'Enne antud protseduuri alustamist kontrolli, et oled varundanud oma Moodle\'i andmebaasi. Kui sa pole kindel, kuidas seda teha, siis võta ühendust oma süsteemiadministratoriga. Kui migreerimisprotsess on alanud pannakse sinu Moodle\'i veebisait hooldusrežiimi.';
$string['dbmigrationdupfailed'] = 'Andmebaasi dubleerimine ebaõnnestus. Võimalik viga: <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Kasuta sessioonide hoidmiseks andmebaasi';
$string['debug'] = 'Silumisteated';
$string['debugall'] = 'KÕIK: Kuva kõik põhjendatud PHP silumisteated';
$string['debugdeveloper'] = 'ARENDAJA: ekstra Moodle silumisteated arendajatele';
$string['debugdisplay'] = 'Kuva silumisteated';
$string['debugging'] = 'Silumine';
$string['debugminimal'] = 'MINIMAALNE: Kuva ainult fataalsed vead';
$string['debugnone'] = 'POLE: Ära kuva vigu ega hoiatusi';
$string['debugnormal'] = 'NORMAALNE: Kuva vead, hoiatused ja märguanded';
$string['debugpageinfo'] = 'Näita lehe informatsiooni';
$string['debugsmtp'] = 'E-maili saatmise silumine';
$string['debugstringids'] = 'Kuva keelte sõnede allikas';
$string['debugvalidators'] = 'Kuva validaatori lingid';
$string['defaultcity'] = 'Vaikimisi linn';
$string['defaultcity_help'] = 'Sisestatud linn on vaikimisi linn uutele kasutajatele.';
$string['defaulthomepage'] = 'Vaikimisi kodulehekülg kasutajatele';
$string['defaultrequestcategory'] = 'Vaikimisi kategooria kursuse taotlustel';
$string['defaultsettinginfo'] = 'Vaikimisi:';
$string['defaultuserroleid'] = 'Vaikimisi roll kõikidele kasutajatele';
$string['deleteincompleteusers'] = 'Kustuta mitte täielikult registreerunud kasutajad pärast';
$string['deleteunconfirmed'] = 'Kustuta kinnituseta kasutajad peale';
$string['deleteuser'] = 'Kustuta kasutaja';
$string['density'] = 'Tihedus';
$string['denyemailaddresses'] = 'Keelatud e-maili aadressidomeenid';
$string['development'] = 'Arendus';
$string['devicedetectregex'] = 'Seadme ära tundmiste regulaaravaldised';
$string['devicedetectregex_desc'] = '<p>Vaikimisi Moodle saab detekteerida seadmete tüüpi (lauaarvuti, sülearvuti jne), mobiil (telefonid ja väiksed käes hoitavad seadmed), tahvelarvuti (iPad\'d, Android tahvelarvutid) ja legaate (Internet Explorer 6 kasutajad). Kujunduse valijat saab kasutada rakendades eristatult neile kujundusi. See seadistus võimaldab regulaaravalisi, mis võimaldavad detekteerida defineerimata seadmete tüüpe (need on eelistatud vaikimisi tüüpidele).</p> <p>Näiteks võid sisestada regulaaravaldise \'/(MIDP-1.0|Maemo|Windows CE)/\' detekteerimaks mõnda põhiliselt kasutatavaid tunnusjoontega telefone, lisades tagastuse väärtuse \'featurephone\'. See lisab \'featurephone\' kujunduse valikusse, mis võimaldab valida kujunduse, mida vastava seadme puhul kasutada. Muud telefonide tüübid ikka kasutavad teema valikut mobiilseadmete tüübile.</p>';
$string['devicedetectregexexpression'] = 'Regulaar avaldis';
$string['devicedetectregexvalue'] = 'Tagastuse väärtus';
$string['devicetype'] = 'Seadme tüüp';
$string['disableuserimages'] = 'Keela kasutajate profiili pildid.';
$string['displayerrorswarning'] = 'PHP seadistuse <em>display_errors</em> võimaldamine ei ole soovitatav, sest võib paljastada tundlikku infot Sinu serveri kohta.';
$string['displayloginfailures'] = 'Kuvada ebaõnnestunud sisselogimised järgmistele rollidele';
$string['dndallowtextandlinks'] = 'Teksti/linkide lisamine lohistamise ja asetamise teel';
$string['docroot'] = 'Moodle Docs dokumendide juurasukoht';
$string['doctonewwindow'] = 'Ava uues aknas';
$string['download'] = 'Tõmba alla';
$string['edithelpdocs'] = 'Muuda abidokumente';
$string['editlang'] = '<b>Redigeeri</b>';
$string['editorbackgroundcolor'] = 'Taustavärv';
$string['editordictionary'] = 'Toimeti sõnastik';
$string['editorfontfamily'] = 'Fondi perekond';
$string['editorfontlist'] = 'Fondi nimekiri';
$string['editorfontsize'] = 'Fondi suurus';
$string['editorhidebuttons'] = 'Peidetud nupud';
$string['editorkillword'] = 'Word\'i formaadi filter';
$string['editorspelling'] = 'Redaktori õigekiri';
$string['editorspellinghelp'] = 'Võimalda või mittevõimaldab õigekirjakontrolli. Kui võimaldatud, siis serveris peab olema installeeritud <strong>aspell</strong>';
$string['editstrings'] = 'Muuda sõnu või fraase';
$string['emailchangeconfirmation'] = 'E-maili muutmise kinnitus';
$string['emoticonalt'] = 'Alternatiiv tekst';
$string['emoticoncomponent'] = 'Pildi komponent';
$string['emoticonimagename'] = 'Pildi nimi';
$string['emoticons'] = 'Emotikoonid';
$string['emoticons_desc'] = 'See vorm defineerib emotikoonid (või smile\'d) kasutatuna sinu saidil. Eemaldamaks rida tabelist, salvesta vorm tühja väärtusega igas nõutud väljas. Registreerimaks uut emotikooni, täida väljad lõpus olevas tühjas reas. Lähtestamaks kõiki väljasid vaikeväärtusteks, mine üleval olevale lingile.

* Tekst (nõutav) - See tekst asendatakse emotikooni pildiga. Ta peab olema vähemalt kahe märgiline.
* Pildi nimi (nõutav) - Emotikooni pildi failinimi ilma laiendita, relatiivne komponendi pix kaustaga.
* Pildi komponent (nõutav) - ikooni pakkuv komponent.
* Alternatiivne tekst (fakultatiivne) - Sõne identifikaator ja emotikooni alternatiivse teksti komponent.';
$string['emoticonsreset'] = 'Lähtesta emotikoonide seadet vaikeväärtusteks';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Tühi';
$string['enableajax'] = 'Võimalda AJAX';
$string['enableblogs'] = 'Luba veebipäevikud';
$string['enablecalendarexport'] = 'Võimalda kalendri eksport';
$string['enablecomments'] = 'Luba kommentaarid';
$string['enablecourserequests'] = 'Võimalda kursuse taotlused';
$string['enablecssoptimiser'] = 'Luba CSS optimiseerija';
$string['enabled'] = 'Lubatud';
$string['enabledevicedetection'] = 'Luba seadme tuvastus';
$string['enablegravatar'] = 'Luba Gravatar';
$string['enablegroupmembersonly'] = 'Võimalda ainult grupi liikmetele';
$string['enablemobilewebservice'] = 'Luba veebiteenused mobiilseadmetele';
$string['enablerssfeeds'] = 'Võimalda RSS toited';
$string['enablesafebrowserintegration'] = 'Võimalda Safe Exam Browser integreerimine';
$string['enablestats'] = 'Luba statistika';
$string['enabletgzbackups'] = 'Luba uus varukoopia formaat';
$string['enabletrusttext'] = 'Lülita sisse usaldatud sisu';
$string['enablewebservices'] = 'Võimalda veebiteenused';
$string['enablewsdocumentation'] = 'Veebiteenuste dokumentatsioon';
$string['enrolinstancedefaults'] = 'Registreerumiste vaikeväärtused';
$string['enrolinstancedefaults_desc'] = 'Vaikimisi registreerumise seaded uues kursuses.';
$string['enrolmultipleusers'] = 'Registreeri kasutajad';
$string['environment'] = 'Keskkond';
$string['environmenterrortodo'] = 'Sa pead lahendama kõik keskkonna probleemid (vead), mis leiti ülal, et hakata installeerima vastavat Moodle versiooni!';
$string['environmentmustfixsetting'] = 'PHP seadistus peab olema muudetud.';
$string['environmentok'] = 'Sinu serveri keskkond täidab kõiki miinimumnõudeid.';
$string['environmentrecommendcustomcheck'] = 'kui see test ebaõnnestub, siis see võib saada potentsiaalseks probleemiks';
$string['environmentrecommendinstall'] = 'on soovitatav, et oleks installeeritud ja võimaldatud';
$string['environmentrecommendversion'] = 'versioon {$a->needed} on soovitatav ja Sinul  töötab {$a->current}';
$string['environmentrequirecustomcheck'] = 'see test peab olema edukalt läbitud';
$string['environmentrequireinstall'] = 'on nõutud, et oleks installeeritud ja võimaldatud';
$string['environmentrequireversion'] = 'versioon {$a->needed} on nõutud, Sinul on jooksmas versioon {$a->current}';
$string['environmentsettingok'] = 'soovituslikud seaded olemas';
$string['environmentshouldfixsetting'] = 'PHP seadistus peaks olema muudetud.';
$string['environmentxmlerror'] = 'Viga lugedes keskkonna andmeid ({$a->error_code})';
$string['errordeletingconfig'] = '\'{$a}\' vahendi seadete kustutamisel esines viga.';
$string['errorsetting'] = 'Ei saa salvestada seadeid:';
$string['errorwithsettings'] = 'Vea tõttu mõnesid seadeid ei muudetud:';
$string['everyonewhocan'] = 'Igaüks, kes saab \'{$a}';
$string['exceptions'] = 'erandid';
$string['experimental'] = 'Eksperimentaalne';
$string['experimentalsettings'] = 'Eksperimentaalsed seaded';
$string['extendedusernamechars'] = 'Luba laiendatud tähemärke kasutajanimedes';
$string['extramemorylimit'] = 'Ekstra PHP mälu limiit';
$string['fatalmagicquotesruntime'] = '<p>Esines tõsine konfiguratsiooni viga, palun teavitage administraatorit.</p><p> Moodle´is on vaja, et administraator muudaks seadeid.</p><p><code>session.auto_start</code> peab olema määratud <code>off</code>.</p><p>Seda seadet saab muuta <code>php.ini</code> failis, Apache/IIS <br />konfiguratsioonis või <code>.htaccess</code> failis serveris.</p>';
$string['fatalsessionautostart'] = '<p>Esines tõsine konfiguratsiooni viga, palun teavitage administraatorit.</p><p> Moodle´is on vaja, et administraator muudaks seadeid.</p><p><code>session.auto_start</code> peab olema määratud <code>off</code>.</p><p>Seda seadet saab muuta <code>php.ini</code> failis, Apache/IIS <br />konfiguratsioonis või <code>.htaccess</code> failis serveris.</p>';
$string['filecreated'] = 'Uus fail loodud';
$string['filestoredin'] = 'Salvesta fail kausta:';
$string['filestoredinhelp'] = 'Kus faili hoitakse';
$string['filterall'] = 'Filtreeri kõiki stringe';
$string['filtermatchoneperpage'] = 'Kasuta filtrit lehe kohta üks kord';
$string['filtermatchonepertext'] = 'Filtri sobivus korra teksti kohta';
$string['filters'] = 'Filtrid';
$string['filtersettings'] = 'Halda filtreid';
$string['filtersettingsgeneral'] = 'Üldised filtrite seaded';
$string['filteruploadedfiles'] = 'Filtreeri üleslaaditavaid faile';
$string['forcelogin'] = 'Sunni kasutajaid sisse logima';
$string['forceloginforprofileimage'] = 'Sunni kasutajad sisse logima, et näha kasutaja pilti';
$string['forceloginforprofiles'] = 'Profiili vaatamiseks peab olema sisse logitud';
$string['forcetimezone'] = 'Vaikimisi ajatsooni sundimine';
$string['frontpage'] = 'Esileht';
$string['frontpagebackup'] = 'Esilehe varukoopia';
$string['frontpagedefaultrole'] = 'Vaikimisi esilehe roll';
$string['frontpagefilters'] = 'Esilehe filtrid';
$string['frontpageloggedin'] = 'Esilehe kujundus pärast sisenemist';
$string['frontpagequestions'] = 'Esilehe küsimused';
$string['frontpagerestore'] = 'Esilehe taastamine';
$string['frontpageroles'] = 'Esilehe rollid';
$string['frontpagesettings'] = 'Esilehe seaded';
$string['fullnamedisplay'] = 'Täisnime formaat';
$string['fullnamedisplayprivate'] = 'Täisnime formaat - privaatne';
$string['gdrecommended'] = 'GD laiendust kasutatakse piltide konverteerimisel, mõned võimalused, nagu kasutajate profiili pildid pole saadaval, kui antud laiendus on puudu.';
$string['gdrequired'] = 'GD laiendus on nüüdsest Moodle poolt nõutud piltide konverteerimiseks.';
$string['generalsettings'] = 'Üldised seaded';
$string['geoipfile'] = 'GeoIP linnade andmefail';
$string['getremoteaddrconf'] = 'Logitud IP-aadressi allikas';
$string['globalswarning'] = '<p><strong>TURVALISUSE HOIATUS!</strong></p><p>Õieti opereerimiseks , Moodle nõuab, <br />et teeksid vastavad muudatused oma PHP seadetes.</p><p>Sa <em>pead</em> seadma <code>register_globals=off</code>.</p><p>See seadistus on muudetav faili <code>php.ini</code> muutes, Apache/IIS <br />seadistuses või <code>.htaccess</code> failis.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 võti';
$string['gotofirst'] = 'Mine esimese puuduva stringi juurde';
$string['gradebook'] = 'Hinneteleht';
$string['gradebookroles'] = 'Hinnatavad rollid';
$string['gradeexport'] = 'Primaar';
$string['groupenrolmentkeypolicy'] = 'Grupi registreerimise võtme tingimused';
$string['groupenrolmentkeypolicy_desc'] = 'Selle lubamisel, hakkab Moodle kontrollima rühma võtmete määramisel üleüldisi parooli tingimusi.';
$string['guestroleid'] = 'Roll külaliskasutajale';
$string['guestroleid_help'] = 'See roll määratakse automaatselt külaliskasutajale. See määratakse samuti kasutajatele, kes sisenevad kursusele, külalis registreerumis plugina abil.';
$string['helpadminseesall'] = 'Kas administraatorid näevad kõiki kalendri sündmusi või ainult selliseid, mis on nende jaoks?';
$string['helpforcetimezone'] = 'Sa võid lubada kasutajatel ise määrata oma ajatsooni või sundida ühe ajatsooni kõigi jaoks.';
$string['helpsitemaintenance'] = 'Uuenduste ja muu töö jaoks';
$string['helpstartofweek'] = 'Mis päevaga algab nädal kalendris?';
$string['helpupcominglookahead'] = 'Mitu päeva ette peaks vaikimisi seadistatud  kalender sündmusi otsima ?';
$string['helpupcomingmaxevents'] = 'Kui palju sündmusi(maksimaalselt) näidatakse vaikimisi?';
$string['helpweekenddays'] = 'Millised päevad nädalas on nädalavahetus ja näidatakse punase värviga?';
$string['hiddenuserfields'] = 'Peidetavad kasutajate väljad';
$string['hidefromall'] = 'Peida kõikide kasutajate eest';
$string['hidefromnone'] = 'Ära varja kellegi eest';
$string['hidefromstudents'] = 'Peida õpilaste eest';
$string['htmleditor'] = 'HTML redaktor';
$string['htmleditorsettings'] = 'HTML-redaktori seaded';
$string['htmlsettings'] = 'HTML-seaded';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP turve';
$string['iconvrecommended'] = 'Fakultatiivse ICONV teegi installeerimine on tungivalt soovitatav tõstmaks õpikeskkonna jõudlust, eriti kui õpikeskkond toetab mitte ladinatähistikuga keeli (näiteks eesti keelt).';
$string['iconvrequired'] = 'Vajalik on ICONV laienduse installeerimine.';
$string['ignore'] = 'Ignoreeri';
$string['includemoduleuserdata'] = 'Kaasa mooduli kasutaja andmed';
$string['incompatibleblocks'] = 'Mitteühilduvad plokid';
$string['installhijacked'] = 'Installeerimine peab olema lõpetatud algse IP-aadressi pealt';
$string['installsessionerror'] = 'Ei saa alustada PHP seanssi, palun kontrolli, kas su brauser lubab küpsiseid.';
$string['intlrecommended'] = 'Laiendus Intl kasutatakse internatsionaliseerimise toetuseks parandamiseks, nagu näiteks keelepõhiseks sorteerimiseks.';
$string['invalidsection'] = 'Vigane sektsioon.';
$string['invaliduserchangeme'] = 'Kasutajanimi "changeme" on reserveeritud -- sa ei saa luua sellenimelist kontot.';
$string['ipblocked'] = 'See said ei ole praegu kättesaadav';
$string['ipblocker'] = 'IP-blokeerja';
$string['ipblockersyntax'] = 'Pane iga kirje ühele reale. Korrektsed kirjed on kas täis-IP-aadress (snagu <b>192.168.10.1</b>) mis vastab ühele hostile; või osaline aadress (nagu <b>192.168.</b>) mis vastab igale aadressile, mis algavad nende nubmritega; või CIDR notatsioon (nagu <b>231.54.211.0/20</b>); või IP-aadresside vahemik (nagu <b>231.3.56.10-20</b>) kus vahemik rakendub viimasele aadressi osale. Domeeni nimed (nagu \'naide.ee\') ei ole toetatud. Tühjasid ridu ignoreeritakse.';
$string['iplookup'] = 'IP aadressi otsing';
$string['iplookupinfo'] = 'Vaikimisi moodle kasutaba tasuta online NetGeo andmebaasi, et järelevaadata IP aadressite asukohta, paraku seda andmebaasi ei hallata rohkem ja võib esineda väga <em>ebatäpseid tulemusi</em>.
Soovitatav on kohalikult installeerida koopia GeoLite City andmebaasist, mis kuulub MaxMind firmale. IP aadressi asukoht kuvatakse lihtsal kaardil või Google Mapsil. Kui on olemas Google konto siis saate lisada ka tasuta Google Maps API võtme, et võimaldada interaktiivseid kaarte.';
$string['iplookupmaxmindnote'] = 'See produkt sisaldab GeoLite andmeid loodud MaxMind poolt, kättesaadav <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Hoia märksõnade tõstutundlikkust';
$string['lang'] = 'Keel vaikimisi';
$string['langcache'] = 'Puhverda keele menüü';
$string['langcache_desc'] = 'Puhverda keele menüü. Kui lubatud siis kõik tõlked paigaldatakse vahemällu. Vahemälu automaatselt uuendatakse, kui te installeerite või kustutate keelepaketi sisse ehitatud keelehaldus vahendi abil. Kui te installeerite käsitsi keelepaketi, siis peate kasutama "Tühjenda kogu vahemälu" võimalust, et värskendada keele menüü.';
$string['langlist'] = 'Keeled keele menüüs';
$string['langmenu'] = 'Näita keelemenüüd';
$string['langpackwillbeupdated'] = 'MÄRKUS: Uuenduse käigus üritab Moodle automaatselt alla laadida ja asendada kõik tõlkefailid.';
$string['langstringcache'] = 'Puhverda kõiki keele sõnesid';
$string['languagesettings'] = 'Keele seaded';
$string['latexpreamble'] = 'LaTeX preambula';
$string['latexsettings'] = 'LaTeX renderdaja seaded';
$string['latinexcelexport'] = 'Excel\'i kodeering';
$string['legacyfilesinnewcourses'] = 'Pärand kursuse failid, uutes kursustes';
$string['legacyfilesinnewcourses_help'] = 'Vaikimisi pärand kursuse faili piirkonnad on saadaval ainult uuendatud kursustes. Märkus: Mõned võimalused nagu ühe tegevuse varukoopia/taastamine, ei ühildu selle seadega.';
$string['licensesettings'] = 'Litsentsi seaded';
$string['loading'] = 'Laeb';
$string['localetext'] = 'Saidiülene lokaat (locale)';
$string['localstringcustomization'] = 'Kohalikud keelekohandused';
$string['location'] = 'Asukoht';
$string['locationsettings'] = 'Asukoha seaded';
$string['locked'] = 'Lukustatud';
$string['lockoutduration'] = 'Konto lukustamise kestvus';
$string['lockoutduration_desc'] = 'Lukustatud konto avatakse peale märgitud aega automaatselt.';
$string['lockoutemailbody'] = 'Sinu konto kasutajanimega {$a->username} serveris \'{$a->sitename}\'
lukustati peale mitut ebaõnnestunud sisselogimise katset.

Oma konto koheseks avamiseks mine järgmisele aadressile

{$a->link}

Üldjuhul peaks antud aadress ilmuma sinu jaoks sinise klõpsatava lingina aga kui see ei toimi, siis lihtsalt kopeeri ja kleebi ülel nähtav aadress oma veebibrauseri aadressiribale.

Kui vaja abi, siis võta ühendust administraatoriga,
{$a->admin}';
$string['lockoutemailsubject'] = 'Sinu konto serveris {$a} lukustati';
$string['log'] = 'Logid';
$string['logguests'] = 'Logi külalis ligipääs';
$string['logguests_help'] = 'See seadistus lülitab sisse külaliskontode ja mitte loginud kasutajate tegevuste logimise. Suure koormusega saitidel sa võid soovide välja lülitada seda logimist jõudluse huvides. Soovitatav on töös olevas saidis hoida seda seadistust sisse lülitatuna.';
$string['loginhttps'] = 'Kasuta sisse logimiseks HTTPS';
$string['loginpageautofocus'] = 'Automaatselt fookusessse sisse logimislehel vorm';
$string['loginpageautofocus_help'] = 'Selle seade lubamine tõstab sisenemise lehe kasutatavust, aga automaatne väljade fokuseerimine loetakse ligipääsetavuse probleemiks.';
$string['loginpasswordautocomplete'] = 'Keela parooli meeldejätmine sisselogimisel.';
$string['loginpasswordautocomplete_help'] = 'Kui see on välja lülitatud siis kasutajatel on võimalik salvestada paroole oma veebilehitsejas. Selle seade sisselülitamisel, ei järgi leht enam XHTML strict valideerimis reegleid.';
$string['loglifetime'] = 'Logide hoidmise aeg';
$string['longtimewarning'] = '<b>Tähelepanu, see toimingu teostamiseks võib kuluda palju aega.</b>';
$string['maintenancemode'] = 'Hooldus režhiimis';
$string['maintenancemodeisscheduled'] = 'Süsteem siirdub {$a} minuti pärast hooldusrežiimi';
$string['maintfileopenerror'] = 'Viga hooldusrežiimi failide avamisel!';
$string['maintinprogress'] = 'Toimub süsteemi hooldus...';
$string['manageformats'] = 'Halda kursuse formaate';
$string['managelang'] = 'Halda';
$string['managelicenses'] = 'Halda litsentse';
$string['manageqbehaviours'] = 'Halda küsimuste toimimist';
$string['manageqtypes'] = 'Halda küsimuste tüüpe';
$string['maturity100'] = 'Beeta';
$string['maturity150'] = 'Väljalaste kandidaat';
$string['maturity200'] = 'Stabiilne versioon';
$string['maturity50'] = 'Alfa';
$string['maturitycoreinfo'] = 'Keskkond kasutab hetkel ebastabiilset "{$a}" arendus koodi.';
$string['maturitycorewarning'] = 'Installeeritav Moodle versioon sisaldab endas, ebastabiilset "{$a}" arendus koodi, mis ei ole sobiv kõikide reaalsete keskkondadega. Kui te ei soovinud seda paigaldada, siis veenduge, et uuendate Moodle´it stabiilsest(STABLE branch) harust. Vaadake Moodle dokumentatsiooni, et näha rohkem informatsiooni.';
$string['maxbytes'] = 'Maksimaalne üleslükatava faili suurus';
$string['maxconsecutiveidentchars'] = 'Järjestikulisi identseid märke';
$string['maxeditingtime'] = 'Maksimaalne aeg postituste redigeerimiseks';
$string['maxusersperpage'] = 'Maksimaalne arv kasutajaid ühel lehel';
$string['mbstringrecommended'] = 'Fakultatiivse MBSTRING teegi installeerimine on tugevast soovitatav, et parandada õpikeskkonna jõudlust, eriti kui Su õpikeskkond toetab ka mitteladina tähestikuga keeli (eesti keel ei kasuta ainult ladina tähestikku, seega soovitatav eesti keele toetuse jaoks)';
$string['mediapluginavi'] = 'Võimalda .avi filter';
$string['mediapluginflv'] = 'Võimalda .flv filter';
$string['mediapluginimg'] = 'Luba automaatne lingitud piltide manustamine';
$string['mediapluginmov'] = 'Võimalda .mov filter';
$string['mediapluginmp3'] = 'Võimalda .mp3 filter';
$string['mediapluginmpg'] = 'Võimalda .mpg filter';
$string['mediapluginogg'] = 'Võimalda .ogg filter';
$string['mediapluginogv'] = 'Võimalda .ogv filter';
$string['mediapluginram'] = 'Võimalda .ram filter';
$string['mediapluginrm'] = 'Võimalda .rm filter';
$string['mediapluginrpm'] = 'Võimalda .rpm filter';
$string['mediapluginswf'] = 'Võimalda .swf filter';
$string['mediapluginswfnote'] = 'Vaikimisi turva nõudena on soovitatav, et tavalistel kasutajatel poleks võimalik embeedida swf flash faile.';
$string['mediapluginwmv'] = 'Võimalda .wmv filter';
$string['mediapluginyoutube'] = 'Võimalda YouTube linkide filter';
$string['messaging'] = 'Võimalda teavitamissüsteem';
$string['messagingallowemailoverride'] = 'Teavitus e-kirjade üle kirjutamine';
$string['messagingdeletereadnotificationsdelay'] = 'Kustuta loetud teavitused';
$string['messaginghidereadnotifications'] = 'Peida loetud teavitused';
$string['minpassworddigits'] = 'Numbrid';
$string['minpasswordlength'] = 'Salasõna pikkus';
$string['minpasswordlower'] = 'Väiketähed';
$string['minpasswordnonalphanum'] = 'Mitte tähed ega numbrid';
$string['minpasswordupper'] = 'Suurtähed';
$string['misc'] = 'Varia';
$string['mnetrestore_extusers_admin'] = '<strong>Märkus:</strong> See varukoopia fail paistab, et on pärit erinevast Moodle installatsioonist ja sisaldab Moodle Network kasutajakontosi. Taastamisprotsess püüab kokku sobitada Moodle Networki hoste, kõikide loodavate kasutajate vahel. Neid keda ei õnnestu kokku sobitada, neile määratakse "Käsitsi loodud konto" autentimis meetod(mneti asemel). Taastamisprotsessi logi teavitab sellest.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Märkus:</strong> See varukoopia fail paistab, et on pärit erinevast Moodle installatsioonist ja sisaldab Moodle Network kasutajakontosi. Teil pole õigusi käivitada seda tüüpi taastamisprotsessi. Palun võtke ühendust administraatoriga või alternatiivina proovige taastada see kursus ilma kasutajaandmeteta(moodulid, failid).';
$string['mobile'] = 'Mobiil';
$string['mobilecssurl'] = 'CSS';
$string['modeditdefaults'] = 'Tegevuste seadete vaikimisi väärtused';
$string['modsettings'] = 'Halda tegevusi';
$string['modulesecurity'] = 'Mooduli turve';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Sunni vana multilang süntaks: &lt;span&gt; ilma class="multilang" ja &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika pole sellel saidil veel lubatud.';
$string['mycoursesperpage'] = 'Kursusi';
$string['mymoodle'] = 'Minu Moodle';
$string['mymoodleredirect'] = 'Sunni kasutajaid kasutama Minu Moodle lehte';
$string['mypage'] = 'Vaikimisi Minu Moodle leht';
$string['myprofile'] = 'Vaikimisi profiili leht';
$string['mysql416bypassed'] = 'Kuid, kui Sinu õpikeskkond kasutab AINULT iso-8859-1 (latin) tähestikuga keelt, Sa võid jätkata praegu installeeritud MySQL versiooniga 4.1.12 (või uuem).';
$string['mysql416required'] = 'MySQL 4.1.16 on minimaalne versioon, mis on nõutud Moodle 1.6 poolt, et tagada kõik andmed saaksid konverteeritud UTF-8 kodeeringusse.';
$string['navcourselimit'] = 'Kursuste limiit';
$string['navigationupgrade'] = 'See uuendus sisaldab kahte uut navigeerimis plokki mis asendavad järgmised plokid: Administreerimine, Kursused, Tegevused ja Osalejad. Kui teil oli eelnevalt ära määratud spetsiaalsed õigused nendele plokkidele, peaksite kontrollima üle, et kas kõik toimib nii nagu vaja.';
$string['navshowallcourses'] = 'Näita kõiki kursusi';
$string['navshowcategories'] = 'Näita kursuste kategooriaid';
$string['navshowfrontpagemods'] = 'Kuva avalehe tegevused navigatsiooni menüüs';
$string['navshowfullcoursenames'] = 'Kuva kursuste täisnimed';
$string['navshowmycoursecategories'] = 'Kuva minu kursuste kategooriad';
$string['navsortmycoursessort'] = 'Sorteeri minu kursuseid';
$string['neverdeleteruns'] = 'Ära kunagi kustuta käivitumisi';
$string['nobookmarksforuser'] = 'Sul ei ole mitte ühtegi järjehoidjat.';
$string['nodatabase'] = 'Andmebaas puudub';
$string['nohttpsformobilewarning'] = 'Soovitatav on lubada HTTPS protokoll, kehtiva sertifikaadiga. Moodle rakendus üritab alati kasutada esmalt turvalist ühendust.';
$string['nomissingstrings'] = 'Pole puuduvaid sõnesid';
$string['nonewsettings'] = 'Uusi seadeid ei ole lisatud selle täienduse käigus.';
$string['nonexistentbookmark'] = 'Küsitud järjehoidjat ei ole olemas.';
$string['noresults'] = 'Tulemusi ei olnud.';
$string['noroles'] = 'Rollid puuduvad';
$string['notifications'] = 'Märkused';
$string['notifyloginfailures'] = 'E-maili logimise ebaõnnestumistest kuhu';
$string['notifyloginthreshold'] = 'E-mailiteavituste künnis';
$string['notloggedinroleid'] = 'Roll külastajatele';
$string['numberofmissingstrings'] = 'Puudu olevaid sõnesid: {$a}';
$string['numberofstrings'] = 'Sõnesid kokku: {$a->strings}<br />Puudu: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Fakultatiivse OpenSSL teegi installeerimine on väga soovitatav, millega võimaldatakse Moodle võrgunduse funktsionaalsus.';
$string['opentogoogle'] = 'Ava Google\'s';
$string['optionalmaintenancemessage'] = 'Valikuline hoolduse teade';
$string['order1'] = 'Esimene';
$string['order2'] = 'Teine';
$string['order3'] = 'Kolmas';
$string['order4'] = 'Neljas';
$string['passwordpolicy'] = 'Salasõna tingimused';
$string['passwordresettime'] = 'Maksimaalne aeg, mille jooksul peab salasõna lähtestamise valideerima';
$string['pathconvert'] = 'Rada programmini <i>convert</i>';
$string['pathdvips'] = 'Rada programmini <i>dvips</i>';
$string['pathlatex'] = 'Rada programmini <i>latex</i>';
$string['pathtoclam'] = 'clam AV rada';
$string['pathtodot'] = 'dot\'i rada';
$string['pathtodot_help'] = 'Rada dot\'ni. Tõenäoliselt midagi sarnast /usr/bin/dot. Võimaldamaks genereerida graafikafaile DOT-failidest, sul peab olema installeeritud dot programm ja siin suunama sellele. Pane tähele, et nüüd on kasutatud ainult Moodle\'sse sisse ehitatud profileerimise funktsioone (Arendus->Profileerimine).';
$string['pathtodu'] = 'du rada';
$string['pathtopgdump'] = 'pg_dump rada';
$string['pathtopgdumpdesc'] = 'See on vajalik ainult siis sisestada, kui süsteemis on mitu pg_dump installeerimist (näiteks, kui Sa oled installeerinud mitu erinevat postgresql versiooni)';
$string['pathtopgdumpinvalid'] = 'Vigane pg_dump rada - kas vigane rada või ei ole käivitatav';
$string['pathtopsql'] = 'psql rada';
$string['pathtopsqldesc'] = 'See on vajalik ainult siis sisestada, kui süsteemis on mitu psql installeerimist (näiteks, kui Sa oled installeerinud mitu erinevat postgresql versiooni)';
$string['pathtopsqlinvalid'] = 'Vigane psql rada - kas vigane rada või ei ole käivitatav';
$string['perfdebug'] = 'Jõudlusinfo';
$string['performance'] = 'Jõudlus';
$string['pgcluster'] = 'PostgreSQL kluster';
$string['pgclusterdescription'] = 'PostgreSQL versioon/klaster parameeter for käsurea operatsioonideks. Kui Sul on süsteemis ainult üks postgresql või Sa ei ole kindel, mis see on, siis jäta tühjaks.';
$string['php50restricted'] = 'PHP 5.0.x omab mitmeid probleeme. Palun uuenda 5.1.x või lase tagasi 4.3.x or 4.4.x PHP versioonile';
$string['php533warning'] = 'PHP 5.3.3 ja ülespoole on soovitatavad';
$string['phpfloatproblem'] = 'Esines ootamatu probleem PHP float numbrite käsitlemisel - {$a}';
$string['pleaseregister'] = 'Palun registreeri oma veebileht, siis kaob ka see nupp';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Moodulid';
$string['pluginscheck'] = 'Moodulite sõltuvuste kontroll';
$string['pluginscheckfailed'] = 'Sõltuvuste kontroll ebaõnnestus järgmis(t)e mooduli(te) kohta {$a->pluginslist}';
$string['pluginschecktodo'] = 'Sa pead lahendama kõik moodulite nõuded enne selle Moodle versiooni installatsiooniga jätkamist!';
$string['pluginsoverview'] = 'Pluginate ülevaade';
$string['profilecategory'] = 'Kategooria';
$string['profilecategoryname'] = 'Kategooria nimi (nimi peab olema unikaalne)';
$string['profilecategorynamenotunique'] = 'See kategooria nimetus on juba kasutusel';
$string['profilecommonsettings'] = 'Üldised seaded';
$string['profileconfirmfielddeletion'] = '{$a} kasutajal on see väli täidetud.<br />Olete kindel, et soovite selle välja kustutada?';
$string['profilecreatecategory'] = 'Loo uus profiilikategooria';
$string['profilecreatefield'] = 'Loo uus profiili väli:';
$string['profilecreatenewcategory'] = 'Uue kategooria loomine';
$string['profilecreatenewfield'] = 'Profiili uue &quot;{$a}&quot; välja loomine';
$string['profiledefaultcategory'] = 'Muud väljad';
$string['profiledefaultchecked'] = 'Vaikimisi märgitud';
$string['profiledefaultdata'] = 'Vaikimisi väärtus';
$string['profiledeletecategory'] = 'Katefooria kustutamine';
$string['profiledeletefield'] = 'Välja kustutamine';
$string['profiledescription'] = 'Välja kirjeldus';
$string['profiledscript'] = 'See skript on profileeritud';
$string['profiledscriptview'] = 'Vaata profileerimise infot selle skripti kohta';
$string['profileeditcategory'] = 'Kategooria redigeerimine: {$a}';
$string['profileeditfield'] = 'Proviilivälja "{$a}" toimetamine';
$string['profilefield'] = 'Profiili väli';
$string['profilefieldcolumns'] = 'Veerud';
$string['profilefieldispassword'] = 'Kas see on salasõna väli?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Teisendamaks teksti lingiks, sisesta URL, sisaldades $$, kus $$ asendatakse tekstiga. Näiteks, teisendamaks Twitter\'i ID lingiks, sisesta http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Lingi siht';
$string['profilefieldmaxlength'] = 'Maksimaalne pikkus';
$string['profilefieldrows'] = 'Read';
$string['profilefields'] = 'Kasutaja profiili väljad';
$string['profilefieldsize'] = 'Lahtri suurus';
$string['profileforceunique'] = 'Kas andmed peavad olema unikaalsed?';
$string['profileinvaliddata'] = 'Vigane väärtus';
$string['profilelocked'] = 'Kas väli on lukustatud?';
$string['profilemenudefaultnotinoptions'] = 'Vaikimisi väärtus ei ole üks valikutest';
$string['profilemenunooptions'] = 'Puuduvad etteantud menüü valikud';
$string['profilemenuoptions'] = 'Menüü valikud (iga valik eraldi reale)';
$string['profilemenutoofewoptions'] = 'Sa pead pakkuma vähemalt kaks valikut';
$string['profilename'] = 'Nimi';
$string['profilenofieldsdefined'] = 'Välju ei ole defineeritud';
$string['profilerequired'] = 'Kas väli on kohustuslik?';
$string['profileroles'] = 'Profileeri nähtavaid rolle';
$string['profilesforenrolledusersonly'] = 'Profiilid ainult registreerunud kasutajatele';
$string['profileshortname'] = 'Lühinimi (peab olema unikaalne)';
$string['profileshortnamenotunique'] = 'See lühinimi on juba kasutusel';
$string['profilesignup'] = 'Kuvada registreerumis lehel?';
$string['profilespecificsettings'] = 'Spetsiifilise seaded';
$string['profilevisible'] = 'Kellele väli on nähtav?';
$string['profilevisibleall'] = 'Nähtav kõigile';
$string['profilevisible_help'] = '* Pole nähtav(Not visible) - privaatsed andmed, mida näeb ainult administraator
* Nähtav kasutajale(Visible to user) - privaatsed andmed mida näevad kasutaja ise ja administraator
* Nähtav kõigile(Visible to everyone) - Avalikult nähtav';
$string['profilevisiblenone'] = 'Mitte nähtav';
$string['profilevisibleprivate'] = 'Nähtav kasutajale';
$string['profiling'] = 'Profileerimine';
$string['profilingallowall'] = 'Jätkuv profileerimine';
$string['profilingallowall_help'] = 'Kui sa lülitad sisse selle seadistuse, siis igal momendil sa saad kasutada PROFILEALL parameetrit igal pool (PGC) võimaldades profileerimise kõikide käivitatud skriptide kohta Moodle seansi elu jooksul. Analoogselt sa saad kasutada PROFILEALLSTOP parameetrit peatamaks seda.';
$string['profilingallowme'] = 'Valikuline profileerimine';
$string['profilingallowme_help'] = 'Kui sa lülitad sisse selle seadistuse, siis valikuliselt sa saad kasutada PROFILEME parameetrit igal pool (PGC) ja profileerida, mis skriptiga juhtub. Analoogselt, sa saad kasutada DONTPROFILEME parameetrit, et vältida profileerimist';
$string['profilingautofrec'] = 'Automaatne profileerimine';
$string['profilingautofrec_help'] = 'Konfigureerides selle seadistuse, mõned päringud (juhuslikult, baseerudes määratud sagedusel - 1/XXX) valitakse ja automaatselt profileeritakse, hoiustades tulemused edasisteks analüüsideks. Pane tähele, et selline profileerimise tee võtab arvesse  kaasa/välista seadeid. Sea see 0-ks, et lülitada välja automaatne profileerimine.';
$string['profilingenabled'] = 'Lülita sisse profileerimine';
$string['profilingenabled_help'] = 'Kui lülitad sisse selle seade, siis profiilimine on saadaval keskkonnas ja sa saad ära määrata selle toimumise, seadistades järgmisi valikuid.';
$string['profilingexcluded'] = 'Jäta välja profileerimisest';
$string['profilingexcluded_help'] = 'Nimekiri (komaga eraldatult, absoluut aadress jäetakse vahele wwwroot, välja kutsutav) URL\'idest mis jäetakse kõrvale profileerimisest, nendest mis on ära määratud \'Profileeri need(Profile these)\' seades.';
$string['profilingincluded'] = 'Profileeri neid';
$string['profilingincluded_help'] = 'Nimekiri (komaga eraldatult, absoluut aadress jäetakse vahele wwwroot, välja kutsutav)  URL aadressitest mis automaatselt profileeritakse. Näiteks: /index.php, /course/view.php. Samuti saab lisada ka "*"(kõik) märgistust. Näiteks: /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'Hoia profileerimiste käivitumisi';
$string['profilinglifetime_help'] = 'Määra aeg, kui kaua soovid hoida vanade profileerimiste käivitumiste kohta. Vanemaid pügatakse perioodiliselt. Märkus, siit jäetakse välja profileerimise käivitumised, mis on märgutud kui \'Referents käivitumine';
$string['protectusernames'] = 'Kaitse kasutajatunnuseid';
$string['proxybypass'] = 'Proxy möödaviik(bypass) hostidest';
$string['proxyhost'] = 'Proksi host';
$string['proxypassword'] = 'Proksi salasõna';
$string['proxyport'] = 'Proksi port';
$string['proxytype'] = 'Proksi tüüp';
$string['proxyuser'] = 'Proksi kasutaja nimi';
$string['purgecaches'] = 'Tühjenda kõik puhvrid';
$string['purgecachesconfirm'] = 'Moodle võimaldab puhverdada kujundust, javascripti, keele faile, filtreeritud tekste, rss vooge ja veel väga mitmeid erinevaid andmeid. Nende vahemälude puhastamine kustutab kõik andmed ja kõik brauserid peavad uuesti andmed alla laadima. Vahemälu puhastamisega ei kaasne mingit ohtu, aga leht võib laadida aeglasemalt, kuna server ja kasutajate veebibrauserid uut infot vahemälusse puhverdavad.';
$string['purgecachesfinished'] = 'Kõik puhvrid on tühjendatud.';
$string['qtyperqpwillberemoved'] = 'Uuenduse käigus, RQP tüüpi küsimused eemaldatakse. Kuna antud küsimuste tüüp polnud kasutusel, ei tohiks probleeme esineda.';
$string['qtyperqpwillberemovedanyway'] = 'Uuenduse käigus, RQP tüüpi küsimused eemaldatakse. Antud küsimuste tüübid on kasutusel, ja need ei tööta enam, juhul kui te ei reinstalleeri uut koodi aadressilt: http://moodle.org/mod/data/view.php?d=13&amp;rid=797 enne uuenduse jätkamist.';
$string['quarantinedir'] = 'Karantiini kataloog';
$string['question'] = 'Küsimus';
$string['questionbehaviours'] = 'Küsimuste toimimised';
$string['questioncwqpfsok'] = 'Väga hea. Pole kasutusel ühtegi \'random\'(suvalise valikuga) küsimusi testides, mis valiksid kokku erinevatest küsimuste kategooriatest küsimusi.';
$string['questiontype'] = 'Küsimuse tüüp';
$string['questiontypes'] = 'Küsimuste tüübid';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privaatne võti';
$string['recaptchapublickey'] = 'ReCAPTCHA avalik võti';
$string['register'] = 'Registreeri enda sait';
$string['registermoodleorgli2'] = 'Statistika sinu saidi kohta lisatakse ülemaailmse Moodle kogukonna lehele {$a}.';
$string['registerwithmoodleorg'] = 'Registreeri leht Moodle.org\'is';
$string['registration'] = 'Registreerimine';
$string['registration_help'] = 'Saidi registreerimine Moodle.org süsteemis on soovitatav turvateavituste saamiseks, <a href="http://moodle.org/stats">Moodle kasutusstatistika</a> jagamiseks ja kursuste levitamiseks <a href="http://moodle.net/">Moodle.net</a> lehe kaudu.';
$string['registrationwarning'] = 'Sinu leht ei ole veel registreeritud.';
$string['releasenoteslink'] = 'Antud Moodle versiooni kohta informatsiooni palun vaata leheküljelt <a target="_new" href="{$a}">Väljalaske märkmed</a>';
$string['rememberusername'] = 'Jäta kasutajanimi meelde';
$string['reportsmanage'] = 'Halda raporteid';
$string['requestcategoryselection'] = 'Luba kategooria valimin';
$string['requiredentrieschanged'] = '<strong>TÄHTIS - PALUN LOA<br/>(See hoiatusteade kuvatakse ainult versioonitäienduse (upgrade) käigus)</strong><br/>Puugi parandamise tõttu andmebaasi tegevuste toimivused, mis kasutavad \'Nõutud sissekandeid\' and \'Required entries before viewing settings\' seadeid võidakse muuta. Detailsemad muudatuse selgitustest saab lugeda <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">andmebaasi mooduli foorumist</a>. Ootatud nende seadete toimivusest sa saad lugeda samuti <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle dokumentatsioonist</a>.<br/><br/>See muudatus mõjutab järgmisi andmebaase sinu süsteemis: (Palun salvesta see nimekiri praegu ja pärast versioonitäienduse lõppemist kontrolli nende tegevuste toimivust, nagu õpetaja ette nägi.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Nõua tegevuse kirjeldust';
$string['requires'] = 'Nõudmised';
$string['reverseproxy'] = 'Vastand proksi';
$string['riskconfig'] = 'Kasutajad saaksid muuta keskkonna konfiguratsiooni ja toimimist';
$string['riskconfigshort'] = 'Konfiguratsiooni risk';
$string['riskdataloss'] = 'Kasutajad saaksid kustutada suurtes kogustes sisu või informatsiooni';
$string['riskdatalossshort'] = 'Andmete kaotamise risk';
$string['riskmanagetrust'] = 'Kasutajad saaksid muuta usalduse seadeid teiste kasutajate kohta.';
$string['riskpersonal'] = 'Kasutajad võivad saada ligipääsu teiste kasutajate privaatsele informatsioonile';
$string['riskpersonalshort'] = 'Privaatsusrisk';
$string['riskspam'] = 'Kasutajad võivad saata rämpskirju õpikeskkonna kasutajatele või teistele';
$string['riskspamshort'] = 'Spämmirisk';
$string['riskxss'] = 'Kasutajad võivad lisada faile ja tekste, mis võimaldab XSS (Cross-Site Scripting) ründeid';
$string['riskxssshort'] = 'XSS risk';
$string['rssglobaldisabled'] = 'Mitte võimaldatud serveri tasemel';
$string['runclamavonupload'] = 'Kasuta clam AV üles laaditud failide kontrollimiseks';
$string['save'] = 'Salvesta';
$string['savechanges'] = 'Salvesta muudatused';
$string['search'] = 'Otsi';
$string['searchinsettings'] = 'Otsi seadetest';
$string['searchresults'] = 'Otsingu tulemused';
$string['sectionerror'] = 'Sektsiooni viga!';
$string['secureforms'] = 'Kasuta täiendavat vormi turvet';
$string['security'] = 'Turve';
$string['selectdevice'] = 'Vali seade';
$string['selecttheme'] = 'Vali kujundus seadmele {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serveri kontrollid';
$string['serverlimit'] = 'Serveri limiit';
$string['sessionautostartwarning'] = '<p>Esines tõsine konfiguratsiooni viga, palun teavitage administraatorit.</p><p> Moodle´is on vaja, et administraator muudaks seadeid.</p><p><code>session.auto_start</code> peab olema määratud <code>off</code>.</p><p>Seda seadet saab muuta <code>php.ini</code> failis, Apache/IIS <br />konfiguratsioonis või <code>.htaccess</code> failis serveris.</p>';
$string['sessioncookie'] = 'Küpsise prefiks';
$string['sessioncookiedomain'] = 'Küpsisedomeen';
$string['sessioncookiepath'] = 'Küpsise rada';
$string['sessionhandling'] = 'Sessiooni käsitlemine';
$string['sessiontimeout'] = 'Aegumine';
$string['settingfileuploads'] = 'Failide üleslaadimine peab olema lubatud PHP konfiguratsioonis.';
$string['settingmemorylimit'] = 'Ebapiisav mälu hulk, palun suurenda PHP mälulimiidi seadeid.';
$string['settingsafemode'] = 'Moodle pole täielikult ühilduv "safe mode" režhiimis, palun paluge administraatoril see kinni keerata. Moodle töö "safe mode" režhiimis pole toetatud, võib esineda erinevaid probleeme.';
$string['showcommentscount'] = 'Näita kommentaaride arvu';
$string['showdetails'] = 'Kuva detailid';
$string['simplexmlrequired'] = 'SimpleXML PHP laiendus on nüüd nõutud Moodle poolt.';
$string['sitemaintenance'] = 'Õpikeskkond ei ole hooldustööde tõttu praegu kättesaadav';
$string['sitemaintenancemode'] = 'Hooldusrežiim';
$string['sitemaintenanceoff'] = 'Hooldusrežiim on välja lülitatud ja õpikeskkond töötab jälle normaalselt';
$string['sitemaintenanceon'] = 'Sinu õpikeskkond on hetkel hooldusrežiimis (ainult administraatorid saavad siseneda ja keskkonda kasutada)';
$string['sitemaintenancewarning'] = 'Sinu õpikeskkond on hetkel hooldusrežiimis(ainult administraatorid saavad siseneda). Et pöörduda tagasi normaalsesse olekusse, <a href="maintenance.php">lülita hooldusrežiim välja</a>.';
$string['sitemaintenancewarning2'] = 'Keskkond on hetkel hooldusrežhiimis(ainult administraatorid saavad sisselogida). Selleks, et keskkond töötaks jälle normaalselt, tuleb minna <a href="{$a}">keela hooldusrežhiim</a>.';
$string['sitepolicies'] = 'Õpikeskkonna poliisid';
$string['sitepolicy'] = 'Õpikeskkonna poliisi URL';
$string['sitepolicyguest'] = 'Keskkonna tingimuste URL külalistele';
$string['sitepolicyguest_help'] = 'Kui keskkonnas on ära määratud tingimused, millega külalised peavad enne tutvuma ja nõustuma, siis määrake veebiaadress siia, teistel juhtudel jätke see väli tühjaks. See väli võib sisaldada igasugust avalikku veebiaadressi. Märkus: Ligipääsu mitte sisseloginud kasutajatele saab keelata ka forcelogin seadega.';
$string['sitepolicy_help'] = 'Kui teil on veebilehel poliis, millega kõik kasutajad peavad nõustuma, enne kui nad õpikeskkonda kasutada saavad, siis kirjuta siia poliisi URL, vastasel korral jäta lahter tühjaks. URL võib viidata kuhu iganes - üks otstarbekas koht oleks teatud fail sinu veebilehel, näiteks http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Kui märgitud, siis näidatakse õpikeskkonna kujunduste esimesest sektsiooni';
$string['slasharguments'] = 'Kasuta slash argumente';
$string['smartpix'] = 'Smart pix otsing';
$string['soaprecommended'] = 'Fakultatiivse SOAP laienduse installeerimine on tarvilik veebiteenuste ja kolmanda osapoole moodulite juures.';
$string['sort_fullname'] = 'Kursuse täisnimi';
$string['sort_idnumber'] = 'Kursuse ID number';
$string['sort_shortname'] = 'Kursuse lühinimi';
$string['sort_sortorder'] = 'Sorteerimise järjekord';
$string['spellengine'] = 'Õigekirja mootor';
$string['splrequired'] = 'SPL PHP laiendus on nüüd nõutud Moodle poolt.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimaalne käituse intervall';
$string['statsmaxruntime'] = 'Maksimaalne käitusaeg';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Päevi töödelda';
$string['statsruntimestart'] = 'Alustamise kellaaeg';
$string['statsuserthreshold'] = 'Kasutajate lävi';
$string['stickyblocks'] = 'Kleepuvplokid';
$string['stickyblockscourseview'] = 'Kursuse leht';
$string['stickyblocksmymoodle'] = 'Minu Moodle';
$string['strictformsrequired'] = 'Nõutud väljade range valideerimine';
$string['stripalltitletags'] = 'Eemalda HTML-märgendid kõikidest tegevuste nimedest';
$string['supportcontact'] = 'Kasutajatoe kontakt';
$string['supportemail'] = 'Kasutajatoe e-mail';
$string['supportname'] = 'Kasutajatoe nimi';
$string['supportpage'] = 'Kasutajatoe leht';
$string['suspenduser'] = 'Peata kasutajakonto';
$string['switchlang'] = 'Vaheta keelekausta';
$string['systempaths'] = 'Süsteemirajad';
$string['tablenosave'] = 'Muudatused üleval olevas tabelis salvestatakse automaatselt.';
$string['tabselectedtofront'] = 'Kas sakkidega tabelite puhul peaks hetkel valitud sakiga rida paigutuma esiplaanile?';
$string['themedesignermode'] = 'Malli kujundaja režhiim';
$string['themelist'] = 'Kujunduste loend';
$string['themenoselected'] = 'Malli pole valitud';
$string['themeresetcaches'] = 'Puhasta kujunduse vahemälu';
$string['themeselect'] = 'Vali kujundus';
$string['themeselector'] = 'Kujunduse valikud';
$string['themesettings'] = 'Kujunduse seaded';
$string['therewereerrors'] = 'Sinu andmetes ei olnud vigu';
$string['thirdpartylibrarylocation'] = 'Asukoht';
$string['timezone'] = 'Vaikimisi ajatsoon';
$string['timezoneforced'] = 'See on sunnitud õpikeskkonna administraatori poolt';
$string['timezoneisforcedto'] = 'Sunni kõiki kasutajaid kasutama';
$string['timezonenotforced'] = 'Kasutajad saavad ise valida endale ajatsooni';
$string['tokenizerrecommended'] = 'Fakultatiivse PHP Tokenizer laienduse installeerimine on soovitatav -- sellega parandatakse Moodle Networking funktsionaalsust.';
$string['tools'] = 'Administraatori tööriistad';
$string['toolsmanage'] = 'Halda administraatori tööriistu';
$string['unattendedoperation'] = 'Ära kuva tegevusi';
$string['unbookmarkthispage'] = 'Eemalda see leht järjehoidjast';
$string['unicoderecommended'] = 'Soovitatav on kõikide andmete salvestamine UTF-8\'s (unicode). Uued paigaldamised peaksid olema tehtud andmebaasi, mille vaikimisi kodeering on Unicode. Kui uuendada, siis peaksid teostama UTF-8\'sse üleviimise protsessi (vaata Admin lehte).';
$string['unicoderequired'] = 'On nõutav, et Sa hoiaksid kõiki andmeid Unicode (UTF-8) kodeeringus. Uued installeerimised peavad olema tehtud andmebaasi, mille vaikekodeering (character set) on Unicode. Kui oled Moodle uuendamisel, siis peaksid teostama UTF-8 migreerimisprotsessi (vaata admin lehte).';
$string['uninstallplugin'] = 'Installeeri maha';
$string['unlockaccount'] = 'Lukusta konto lahti';
$string['unsupported'] = 'Ei toetata';
$string['unsuspenduser'] = 'Aktiveeri kasutajakonto';
$string['updateaccounts'] = 'Uuenda olemas olevaid kontosid';
$string['updateautocheck'] = 'Kontrolli saadaolevaid uuendusi automaatselt';
$string['updateautodeploy'] = 'Luba uuenduste rakendamine';
$string['updateavailable'] = 'Moodle´st on saadaval uuem versioon!';
$string['updateavailabledetailslink'] = 'Vaata täpsemat infot aadressil {$a->url}';
$string['updateavailableforplugin'] = 'Mõnede sinu pluginate jaoks on saadaval uuendused!';
$string['updateavailableinstall'] = 'Installeeri see uuendus';
$string['updateavailable_moreinfo'] = 'Lisainfo...';
$string['updateavailablenot'] = 'Sinu Moodle kood on ajakohane!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versioon {$a}';
$string['updatecomponent'] = 'Uuenda komponent';
$string['updatenotifications'] = 'Uuenduste teavitused';
$string['updatenotificationsubject'] = 'Mõned Moodle uuendused on saadaval ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Teavita uutest alam-versioonidest';
$string['upgradeerror'] = 'Esines tundmatu viga {$a->plugin} uuendamisel {$a->version} versiooniks, ei saa jätkata.';
$string['upgradeforumread'] = 'Moodle 1.5-le on lisatud võimalus jälgida loetud/lugemata foorumipostitusi.<br />Selle võimaluse kasutamiseks pead a href="{$a}">uuendama oma tabeleid</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5-le on lisatud võimalus jälgida loetud/lugemata foorumipostitusi. Selle võimaluse kasutamiseks pead uuendama oma tabeleid kogu olemasolevate postituste jälgimisinfoga. Sõltuvalt sinu veebilehe suurusest võib see võtta kaua aega (tunde) ja võib olla küllaltki koormav andmebaasile, nii et uuendust on soovitatav teha rahulikul perioodil. Sinu veebileht jätkab uuenduste tegemise ajal töötamist ja kasutajaid see ei mõjuta. Kui uuenduse protsess on käivitatud, peaks laskma tal lõpetada (hoides veebilehitseja akna lahti). Aga kui sa ka peatad protsessi, sulgedes akna, siis ära muretse, sa saad algusest peale hakata.<br /><br />Kas soovid nüüd alustada uuendamisega?';
$string['upgradelogs'] = 'Täisfunktsionaalsuse saavutamiseks pead vanad logid uuendama. <a href="{$a}">Rohkem informatsiooni</a>';
$string['upgradelogsinfo'] = 'Logide säilitamise seadetesse on tehtud muudatusi. Et vaadata kõiki vanu logisid tegevuste põhjal, peab  vanu logisid uuendama. Olenevalt leheküljest võib see kaua aega võtta (isegi tunde) ja võib olla suhteliselt koormav suurte andmebaasidega lehtedele. Kui see protsess on käivitatud, peaks laskma tal lõpetada (hoides veebilehitseja akna lahti). Ära muretse - veebileht töötab korralikult teistele inimestele, kui logisid uuendatakse.<br /><br />Kas soovid logisid uuendada?';
$string['upgradepluginsfirst'] = 'Soovituslik on esmalt installeerida kõik saadaolevad uuendused';
$string['upgradepluginsinfo'] = 'Uuendan mooduleid';
$string['upgradesettings'] = 'Uued seaded';
$string['upgradesettingsintro'] = 'Allpool olevad seaded on lisatud uue Moodle täiendusega. Tee sobivad muudatusi vaikeväärtustele ja siis vajuta lehe allservas olevat nuppu &quot;Salvesta seaded&quot;';
$string['upgradestart'] = 'Uuenda nüüd Moodle andmebaasi';
$string['upgradesure'] = 'Sinu Moodle failid on muudetud ja sa automaatselt uuendad oma serveri versiooniks <p><b>{$a}</b></p><p>Uuendust tehes ei saa sa enam tagasi minna.</p><p>Oled sa kindel, et soovid serverit uuendada selleks versiooniks?</p> versiooni';
$string['upgradetimedout'] = 'Uuendamine ebaõnnestus, palun proovige uuesti';
$string['upgradingdata'] = 'Andmete uuendamine';
$string['upgradinglogs'] = 'Logide uuendamine';
$string['upgradingversion'] = 'Uuendamine uuele versioonile';
$string['upwards'] = 'ja kõrgemad';
$string['useblogassociations'] = 'Võimalda määrangud';
$string['useexternalyui'] = 'Kasuta online YUI teeke';
$string['user'] = 'Kasutaja';
$string['userbulk'] = 'Hulgi kasutajate tegevused';
$string['userlist'] = 'Kasutajate nimekiri';
$string['userpolicies'] = 'Kasutaja õigused';
$string['userpreference'] = 'Kasutaja eelistus';
$string['userquota'] = 'Kasutaja ruumilimiit';
$string['users'] = 'Kasutajad';
$string['usetags'] = 'Võimalda märksõnade funktsionaalsus';
$string['validateerror'] = 'See väärtus ei olenud lubatav:';
$string['verifychangedemail'] = 'Keela domeenid, kui vahetatakse emaili';
$string['warningcurrentsetting'] = 'Vigane praegune väärtus: {$a}';
$string['webproxy'] = 'Veebiproksi';
$string['webproxyinfo'] = 'Täida järgmised valikud, kui Moodle server ei saa ühenduda otse internetti. Interneti ühendust on vaja, et alla laadida uusi andmeid, keele faile, RSS vooge, ajavööndeid, jne<br /><em>PHP cURL laiendus on väga soovituslik paigaldada.</em>';
$string['xmlrpcrecommended'] = 'Laiendus XMLRPC vajalik jaotur-kommunikatsiooniks ja tarvilik veebiteenuste ning Moodle võrgustiku jaoks';
$string['yuicomboloading'] = 'YUI javascripti kombo laadimine';
$string['ziprequired'] = 'Zip PHP laiendus on nüüd Moodle poolt nõutud. Info-ZIP binaare või PclZip teeke ei kasutata enam.';
$string['zlibenabled'] = 'zlib on lubatud';
