<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accés denegat';
$string['accounts'] = 'Comptes';
$string['addcategory'] = 'Afegeix una categoria';
$string['additionalhtml'] = 'HTML complementari';
$string['additionalhtml_desc'] = 'Aquests paràmetres us permeten especificar codi HTML que s\'afegirà a cada pàgina. Podeu determinar que el codi s\'afegeixi dins de l\'etiqueta HEAD de la pàgina, immediatament després que s\'obri l\'etiqueta BODY, o just abans que es tanqui l\'etiqueta BODY. <br />Això us permet afegir capçaleres o peus personalitzats a cada pàgina o habilitar el suport per a serveis com el Google Analytics, molt fàcilment i amb independència del tema triat.';
$string['additionalhtmlfooter'] = 'Abans del tancament del cos de text (/BODY)';
$string['additionalhtmlfooter_desc'] = 'El contingut que indiqueu aquí s\'afegirà a cada pàgina just abans de l\'etiqueta de tancament del cos de text (/BODY). ';
$string['additionalhtmlhead'] = 'Dins de la capçalera (HEAD)';
$string['additionalhtmlhead_desc'] = 'El contingut que indiqueu aquí s\'afegirà a cada pàgina just abans de l\'etiqueta de tancament de la capçalera (/HEAD). ';
$string['additionalhtml_heading'] = 'Contingut HTML addicional per afegir a cada pàgina.';
$string['additionalhtmltopofbody'] = 'Quan s\'obre el cos de text (BODY)';
$string['additionalhtmltopofbody_desc'] = 'Aquest contingut s\'afegirà a cada pàgina immediatament després de l\'etiqueta d\'obertura del cos (<BODY>).';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Els administradors ho veuen tot';
$string['adminseesallevents'] = 'Els administradors veuen tots els esdeveniments';
$string['adminseesownevents'] = 'Els administradors són com els altres usuaris';
$string['advancedfeatures'] = 'Característiques avançades';
$string['allcountrycodes'] = 'Tots els codis de país';
$string['allowbeforeblock'] = 'La llista de permeses es processa inicialment';
$string['allowbeforeblockdesc'] = 'Per defecte, les entrades de la llista d\'IP blocades es comprova primer. Si s\'activa aquesta opció, es processen abans les entrades de la llista d\'IP permeses que la llista de les blocades.';
$string['allowblockstodock'] = 'Permet que els blocs utilitzin la barra lateral';
$string['allowcategorythemes'] = 'Permet temes per categories';
$string['allowcoursethemes'] = 'Permet temes per curs';
$string['allowediplist'] = 'Llista d\'IP permeses';
$string['allowemailaddresses'] = 'Dominis de correu permesos';
$string['allowframembedding'] = 'Permet la incrustació dins el marc';
$string['allowframembedding_help'] = 'Permet la incrustació d\'aquest lloc en marcs de llocs externs. Habilitar aquesta funcionalitat no és recomanable per raons de seguretat.';
$string['allowguestmymoodle'] = 'Permet l\'accés de visitants a «La meva pàgina inicial»';
$string['allowobjectembed'] = 'Permet etiquetes EMBED i OBJECT';
$string['allowthemechangeonurl'] = 'Permet canvis de tema des de l\'URL';
$string['allowuserblockhiding'] = 'Permet que els usuaris ocultin blocs';
$string['allowuserswitchrolestheycantassign'] = 'Permet que els usuaris sense la capacitat d\'assignar rols commutin rols';
$string['allowuserthemes'] = 'Permet temes d\'usuari';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Aparença';
$string['aspellpath'] = 'Camí d\'aspell';
$string['authentication'] = 'Autenticació';
$string['authpreventaccountcreation'] = 'Evita la creació de nous comptes durant el procediment d\'autenticació';
$string['authpreventaccountcreation_help'] = 'Quan un usuari s\'autentica, es crea automàticament un compte si encara no existeix. Si s\'utilitza una base de dades externa, com el LDAP, però voleu restringir l\'accés al lloc només pels usuaris que disposen d\'un compte, aleshores heu d\'activar aquesta opció.
Els nous comptes s\'hauran de crear manualment o bé mitjançant la càrrega d\'usuaris. Tingueu en compte que aquest ajust no s\'aplica a l\'autenticació MNet.';
$string['authsettings'] = 'Gestió de l\'autenticació';
$string['autolang'] = 'Detecció automàtica d\'idioma';
$string['autologinguests'] = 'Entrada automàtica de visitants';
$string['availablelicenses'] = 'Tipus de llicències de materials disponibles';
$string['availableto'] = 'Disponible per a ';
$string['backgroundcolour'] = 'Color transparent';
$string['backups'] = 'Còpies';
$string['backup_shortname'] = 'Utilitza el nom del curs en el nom de fitxer de la còpia de seguretat';
$string['backup_shortnamehelp'] = 'Utilitza el nom del curs com a part del nom de fitxer de la còpia de seguretat.';
$string['badwordsconfig'] = 'Introduïu la vostra llista de paraules censurades, separades per comes.';
$string['badwordsdefault'] = 'Si la llista personalitzada és buida, s\'utilitzarà la llista per defecte inclosa en el paquet d\'idioma.';
$string['badwordslist'] = 'Llista personalitzada de paraules censurades';
$string['blockediplist'] = 'Llista d\'adreces IP blocades';
$string['blockeditingmenu'] = 'Menús d\'edició de blocs';
$string['blockeditingmenu_desc'] = 'Si s\'habilita aquesta opció, moltes de les icones d\'edició de blocs que es visualitzen quan l\'edició està activa es mostraran dins d\'un menú desplegable. Això redueix el contingut en pantalla tot ocultant les icones fins que es necessitin.';
$string['blockinstances'] = 'Instàncies';
$string['blockmultiple'] = 'Múltiple';
$string['blockprotect'] = 'Protegeix instàncies';
$string['blockprotect_help'] = 'Si bloquegeu un tipus particular de bloc ningú no podrà afegir-ne o esborrar-ne instàncies. (Podeu, naturalment, desbloquejar-lo de nou si us cal editar instàncies.)

Això es fa amb l\'objectiu de protegir blocs com ara els de configuració i de navegació que serien molt difícils de recuperar si s\'esborren per accident.';
$string['blocksettings'] = 'Gestió de blocs';
$string['blockunprotect'] = 'Desprotegeix';
$string['bloglevel'] = 'Visibilitat dels blogs';
$string['bookmarkadded'] = 'S\'ha afegit la drecera.';
$string['bookmarkalreadyexists'] = 'Ja havíeu afegit aquesta drecera.';
$string['bookmarkdeleted'] = 'S\'ha suprimit la drecera.';
$string['bookmarkthispage'] = 'Afegeix una drecera a aquesta pàgina';
$string['cacheapplication'] = 'Memòria cau d\'aplicació';
$string['cacheapplicationhelp'] = 'Els elements emmagatzemats en la memòria cau són compartits entre tots els usuaris i vencen després d\'un TTL determinat.';
$string['cachejs'] = 'Memòria cau del Javascript';
$string['cachejs_help'] = 'La caixè de Javascript i la compressió milloren molt la càrrega de pàgines. Es recomana que s\'utilitzin en instal·lacions de producció. Les persones que es dediquin a desenvolupar possiblement voldran desactivar aquestes característiques.';
$string['cacherequest'] = 'Memòria cau de sol·licitud';
$string['cacherequesthelp'] = 'Memòria cau específica de l\'usuari que venç quan la sol·licitud s\'ha completat. Dissenyada per a reemplaçar àrees en què estem utilitzant magatzems estàtics.';
$string['cachesession'] = 'Memòria cau de sessió';
$string['cachesessionhelp'] = 'Memòria cau específica de l\'usuari que venç en finalitzar la sessió de l\'usuari. Dissenyada per a alleugerir una sessió inflada/pesada.';
$string['cachesettings'] = 'Paràmetres de memòria cau';
$string['cachetext'] = 'Durada de la memòria cau de text';
$string['caching'] = 'S\'està emmagatzemant en la memòria cau.';
$string['calendarexportsalt'] = 'Exportació criptogràfica del calendari';
$string['calendarsettings'] = 'Calendari';
$string['calendartype'] = 'Tipus de calendari';
$string['calendartype_desc'] = 'Escolliu un tipus de calendari pel lloc sencer. Aquest paràmetre es pot rectificar en la configuració de cada curs o en el perfil personal de cada usuari.';
$string['calendar_weekend'] = 'Dies de cap de setmana';
$string['cannotdeletemodfilter'] = 'No podeu desinstal·lar el filtre {$a->filter} perquè forma part del mòdul ';
$string['cannotuninstall'] = '{$a} no és pot desinstal·lar.';
$string['cfgwwwrootslashwarning'] = 'Heu definit incorrectament $CFG->wwwroot en el fitxer config.php. Heu inclòs un caràcter \'/\' al final. Si no el suprimiu, experimentareu errors estranys com aquests: <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Heu definit incorrectament $CFG->wwwroot en el fitxer config.php. No coincideix amb l\'URL que esteu utilitzant per accedir a aquesta pàgina. Si no ho corregiu, experimentareu errors estranys com aquests: <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'Canvia';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Sí';
$string['choosefiletoedit'] = 'Trieu el fitxer que voleu editar';
$string['clamfailureonupload'] = 'Si falla el clam AV';
$string['cleanup'] = 'Neteja';
$string['clianswerno'] = 'No';
$string['cliansweryes'] = 'Sí';
$string['cliincorrectvalueerror'] = 'Error, valor incorrecte "{$a->value}" per a "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorrecte, si us plau, torneu-ho a provar.';
$string['clistatusdisabled'] = 'Estat: desactivat';
$string['clistatusenabled'] = 'Estat: activat';
$string['clistatusenabledlater'] = 'estat: el mode de manteniment CLI s\'habilitarà en {$a}';
$string['clitypevalue'] = 'Valor de tipus';
$string['clitypevaluedefault'] = 'valor de tipus, premeu Intro per fer servir un valor per defecte ({$a})';
$string['cliunknowoption'] = 'Opcions invàlides:
 {$a}
L\'opció --help us orientarà.';
$string['cliupgradefinished'] = 'L\'actualització per línia d\'ordres s\'ha completat de forma satisfactòria.';
$string['cliupgradenoneed'] = 'No es necessita actualitzar per a la versió instal·lada {$a}.';
$string['cliyesnoprompt'] = 'Escriu y (significa Sí) o n (significa No)';
$string['commentsperpage'] = 'Comentaris per pàgina';
$string['commonfiltersettings'] = 'Caracterísitques comunes de fitxers';
$string['commonsettings'] = 'Paràmetres comuns';
$string['componentinstalled'] = 'S\'ha instal·lat el component';
$string['computedfromlogs'] = 'Comprovats els registres des de {$a}.';
$string['condifmodeditdefaults'] = 'Els valors per defecte s\'utilitzaran en el formulari de paràmetres quan creeu una nova activitat o recurs.';
$string['confeditorhidebuttons'] = 'Seleccioneu els botons que voleu ocultar en l\'editor HTML.';
$string['configallcountrycodes'] = 'Aquesta és la llista de països que es pot seleccionar en alguns punts, per exemple en un perfil d\'usuari. Si es deixa en blanc (per defecte) s\'utilitza la llista del fitxer <i>countries.php</i> que hi ha al paquet d\'idioma anglès estàndard. Aquesta llista és la que hi ha a l\'ISO 3166-1.<br />
Podeu escriure una llista de codis separats amb comes, per exemple \'CT, FR_ES\'. Si n\'hi afegiu de nous, que no són estàndards, els haureu d\'afegir a la llista <i>countries.php</i> del vostre paquet d\'idioma i al paquet \'en\' (és el cas de l\'exemple CT, que no està inclòs a les llistes de països).';
$string['configallowassign'] = 'Permet a la gent que té els rols de l\'esquerra assignar a altra gent alguns dels rols de les columnes';
$string['configallowblockstodock'] = 'Permet que els usuaris puguin minimitzar els blocs a la barra especial si el tema seleccionat té habilitada aquesta opció i en permet l\'ús.';
$string['configallowcategorythemes'] = 'Si habiliteu aquesta opció, es podran definir temes diferents per a cada categoria de cursos. El tema definit per a una categoria s\'aplicarà a tots els cursos i a totes les subcategories dins d\'aquesta categoria, tret que es defineixin temes específics per a un curs o una subcategoria. AVÍS: pot afectar el rendiment del servidor.';
$string['configallowcoursethemes'] = 'Si habiliteu aquesta opció, cada curs podrà definir el seu tema. Els temes dels cursos tenen prioritat sobre qualsevol altre tema seleccionat: tema del lloc, de l\'usuari o de la sessió.';
$string['configallowemailaddresses'] = 'Si voleu limitar les noves adreces de correu a certs dominis, especifiqueu-los aquí separats per espais. Tots els altres dominis seran rebutjats. Per a permetre subdominis, afegiu el domini precedit pel punt \'.\'. P. ex. <strong>xtec.cat edu.gva.es .uji.es .upc.es</strong>';
$string['configallowguestmymoodle'] = 'Si s\'habilita, els visitants podran accedir a «El meu Moodle». Si no, es redirigiran a la pàgina principal.';
$string['configallowobjectembed'] = 'Com a mesura de seguretat per defecte, no es permet que els usuaris normals incrustin multimèdia (p. ex. Flash) dins dels textos usant explícitament etiquetes EMBED i OBJECT en l\'HTML (encara que poden fer-ho sense problemes de seguretat per mitjà del filtre multimèdia). Si voleu permetre aquestes etiquetes habiliteu aquesta opció.';
$string['configallowoverride'] = 'Permet que la gent amb rols a l\'esquerra invalidi alguns rols en la columna de rols';
$string['configallowoverride2'] = 'Seleccioneu quins rols poden ser redefinits per cada rol de la columna de l\'esquerra. <br /> Fixeu-vos que aquesta configuració només s\'aplica als usuaris que tinguin permeses les capacitats «moodle/rol: invalidar» o «moodle/rol: invalidar de forma segura».';
$string['configallowswitch'] = 'Seleccioneu a quins rols pot canviar un usuari, basant-se en el rol que tenen definit. A més d\'això, un usuari ha de tenir la capacitat moodle/role:switchroles activa per poder canviar.<br/>Penseu que només es podrà canviar a rols que tenen concedida la capacitat moodle/course:view, i que no tenen la capacitat moodle/site:doanything. Per tant, algunes columnes d\'aquesta taula queden inhabilitades.';
$string['configallowthemechangeonurl'] = 'Si està habilitat, el tema es pot canviar així:<br />afegint ?theme=themename a qualsevol URL de Moodle (p. ex. elmeumoodle.cat/?theme=afterburner) o<br />afegint &theme=themename a qualsevol URL intern de Moodle (elmeumoodle.cat/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Voleu que els usuaris puguin ocultar/mostrar els blocs laterals arreu d\'aquest lloc? Aquesta característica fa servir Javascript i galetes per recordar l\'estat de cada bloc. Només afecta la visualització de cada usuari.';
$string['configallowuserswitchrolestheycantassign'] = 'Per defecte, moodle/role:assign és necessari per als usuaris per canviar rols. Activar aquest paràmetre treu aquest requisit, i això fa que els rols disponibles al menú desplegable «Canvia els rols de» depenguin sols dels paràmetres de la taula «Permet assignació de rols».
És recomanable que els paràmetres de la taula «Permet l\'assignació de rols» no permetin als usuaris canviar cap a rols amb més capacitats que el que tenen en aqueix moment.';
$string['configallowuserthemes'] = 'Si habiliteu aquesta opció, els usuaris podran definir els seus temes. Els temes dels usuaris tenen més prioritat sobre el tema del lloc (però no sobre els temes dels cursos).';
$string['configallusersaresitestudents'] = 'Cal considerar com a estudiants TOTS els usuaris en les activitats de la pàgina inicial d\'aquest lloc? Si la resposta és «Sí», llavors qualsevol usuari amb un compte confirmat podrà participar com a estudiant en aquestes activitats. Si la resposta és «No», llavors només els usuaris que ja siguin membres d\'almenys un curs podran participar en aquestes activitats de la pàgina inicial. Només els administradors i els professors que hi hagin estat assignats poden actuar com a professors d\'aquestes activitats.';
$string['configauthenticationplugins'] = 'Trieu els connectors d\'autenticació que vulgueu utilitzar i disposeu-los per ordre de preferència.';
$string['configautolang'] = 'Configura l\'idioma per defecte segons el del navegador. Si inhabiliteu aquest paràmetre s\'utilitzarà l\'idioma per defecte del lloc.';
$string['configautologinguests'] = 'Cal fer entrar automàticament com a visitants els usuaris externs que intenten entrar en un curs que permet l\'accés de visitants?';
$string['configbloglevel'] = 'Aquest paràmetre us permet limitar l\'àmbit de visualització dels blocs d\'usuaris d\'aquest lloc. Fixeu-vos que aquest paràmetre determina el context més ampli en què es poden VISUALITZAR els blogs. No té res a veure amb tipus d\'autors o tipus de missatges. També podeu inhabilitar completament els blogs si no voleu que s\'utilitzin en absolut.';
$string['configcachetext'] = 'Aquest paràmetre pot agilitzar el funcionament de llocs amb molts usuaris o llocs que utilitzen filtres de text. Durant el temps que s\'especifica aquí es reté una còpia del text ja filtrat. Teniu en compte que si el temps especificat és massa breu el funcionament es podria alentir i tot, i que un temps massa prolongat podria implicar que els textos triguessin massa a actualitzar-se.';
$string['configcalendarcustomexport'] = 'Habilita l\'exportació d\'intervals personalitzats de dates del calendari.';
$string['configcalendarexportsalt'] = 'Aquest text aleatori és utilitzat per provar la seguretat d\'un testimoni d\'autenticació utilitzat en l\'exportació de calendaris. Si us plau fixeu-vos que tots els testimonis actuals seran invalidats si canvieu la funció sal criptogràfica (text generat).';
$string['configclamactlikevirus'] = 'Tracta els fitxers com a virus';
$string['configclamdonothing'] = 'Dóna els fitxers per bons';
$string['configclamfailureonupload'] = 'Si heu configurat el clam per escanejar els fitxers que es pengin, però està configurat incorrectament o no es pot executar per alguna raó desconeguda, com s\'hauria de comportar? Si trieu «Tracta els fitxers com a virus», tots els fitxers es mouran a l\'àrea de quarantena, o seran suprimits. Si trieu «Dóna els fitxers per bons», els fitxers es mouran al seu directori de destinació com és normal.
De qualsevol forma, els administradors seran alertats que clam ha fallat.
Si escolliu «Tracta els fitxers com a virus» i per alguna raó clam no s\'executa (normalment perquè heu introduït un camí invalid per a clam), TOTS els fitxers seran moguts a l\'àrea de quarantena, o esborrats. Sigueu curosos amb aquest paràmetre.';
$string['configconvertformat'] = 'Si <i>latex</i>, <i>dvips</i> i <i>convert</i> estan disponibles, les imatges seran creades utilitzant el format especificat. Si no ho és, el tipus TeX serà utilitzat i es crearan imatges GIF.';
$string['configcookiehttponly'] = 'Habilita una nova característica del PHP 5.2.0. Es demana als navegadors que només envien la galeta amb sol·licituds HTTP reals: els llenguatges script no haurien de tenir accés a les galetes. Tanmateix això no funciona en tots els navegadors i pot no ser compatible amb el codi actual. Ajuda a impedir alguns tipus d\'atacs XSS.';
$string['configcookiesecure'] = 'Si el servidor només accepta connexions HTTPS, es recomana habilitar l\'enviament de galetes segures. En cas que habiliteu aquest paràmetre, assegureu-vos que el servidor web no accepta http:// o configureu una redirecció permanent a adreces https://. Si l\'adreça <em>wwwroot</em> no comença per https:// aquest paràmetre es desactiva automàticament.';
$string['configcountry'] = 'Si definiu un país aquí, llavors aquest país quedarà seleccionat per defecte en els nous comptes d\'usuari. Si voleu que els usuaris triïn obligatòriament un país, no n\'especifiqueu cap aquí.';
$string['configcourseoverviewfilesext'] = 'Una llista separada per comes d\'extensions de fitxers permeses per als resums de cursos.';
$string['configcourseoverviewfileslimit'] = 'El nombre màxim de fitxers que poden adjuntar-se al resum del curs.';
$string['configcourserequestnotify'] = 'Escriviu el nom d\'usuari de l\'usuari a qui s\'ha de notificar la sol·licitud d\'un nou curs.';
$string['configcourserequestnotify2'] = 'Usuaris que seran notificats quan es demani un nou curs. Sols els usuaris que poden aprovar peticions de cursos són aquí.';
$string['configcoursesperpage'] = 'Introduïu el nombre de cursos que es visualitzaran per pàgina en un llistat de cursos.';
$string['configcourseswithsummarieslimit'] = 'El nombre màxim de cursos que es mostren en una llista de cursos amb resums abans de retornar a la llista simple.';
$string['configcronclionly'] = 'Si habiliteu aquest paràmetre, la seqüència del cron només podrà executar-se des de la línia d\'ordres i no via web. En aquest cas s\'ignorarà la contrasenya del cron definida al dessota.';
$string['configcronremotepassword'] = 'La seqüència cron.php no es podrà executar des d\'una interfície web sense proporcionar aquesta contrasenya en un URL d\'aquesta forma:<pre>
http://www.exemple.com/admin/cron.php?password=sesamobret
</pre>Si deixeu la contrasenya en blanc no caldrà utilitzar-ne cap.';
$string['configcurlcache'] = 'Temps de vida per al cau de cURL, en segons.';
$string['configcustommenuitems'] = 'Podeu preparar un menú personalitzat que es mostrarà per temes. Cada línia consisteix en un text de menú, un enllaç URL (opcional), un consell (opcional) i un codi de llengua o llista de codis separada per comes (opcional, per tal de mostrar-ho només als usuaris d\'aquell idioma), tot això separat per barres verticals. Podeu marcar l\'estructura amb guions. Per exemple:
<pre>
Comunitat Moodle|http://moodle.org
-Suport gratuït del Moodle|http://moodle.org/support
-Desenvolupament del Moodle|http://moodle.org/development
--Seguiment del Moodle|https://tracker.moodle.org
--Documentació del Moodle|http://docs.moodle.org|Moodle Docs
--Documentació en Català del Moodle|http://docs.moodle.org/ca|Documentació|ca
-Novetats del Moodle|http://moodle.org/news
</pre>';
$string['configdbsessions'] = 'Si habiliteu aquest paràmetre, la base de dades emmagatzemarà la informació de les sessions dels usuaris. Això és especialment útil en llocs amb molts usuaris o en llocs que funcionen en clústers de servidors. Per a la majoria de llocs probablement és millor no habilitar-lo i utilitzar el disc del servidor en lloc de la base de dades. Teniu en compte que si canvieu ara aquest paràmetre tancareu les sessions de tots els usuaris (la vostra inclosa). Si utilitzeu MySQL assegureu-vos que el paràmetre \'max_allowed_packet\' de my.cnf (o my.ini) és com a mínim 4M.';
$string['configdebug'] = 'Si activeu aquest paràmetre s\'incrementarà l\'error_reporting del PHP, de manera que es visualitzaran més avisos. Útil només per a desenvolupadors.';
$string['configdebugdisplay'] = 'Si activeu aquest paràmetre els informes d\'errors s\'inclouran a la pàgina HTML. Això pot ser pràctic, però espatlla l\'XHTML, el Javascript, les galetes i les capçaleres HTTP. Si està desactivat, la sortida s\'enviarà als registres del servidor per facilitar la depuració. El paràmetre del PHP error_log controla a quin registre s\'envia.';
$string['configdebugpageinfo'] = 'Activeu-lo si voleu presentar informació de la pàgina al peu.';
$string['configdebugsmtp'] = 'Habilita el mode verbós de depuració durant l\'enviament de missatges de correu al servidor SMTP.';
$string['configdebugvalidators'] = 'Habiliteu aquesta opció si voleu tenir enllaços a servidors externs de validació a peu de pàgina. Potser us caldrà crear un nou usuari amb nom d\'usuari <em>w3cvalidator</em> i habilitar l\'accés per a visitants. Aquests canvis poden facilitar accessos no autoritzats al servidor, així que és millor no habilitar l\'opció en llocs en producció.';
$string['configdefaulthomepage'] = 'Això determina la pàgina inicial per als usuaris que han entrat.';
$string['configdefaultrequestcategory'] = 'Els cursos sol·licitats per usuaris es col·locaran automàticament en aquesta categoria.';
$string['configdefaultrequestedcategory'] = 'Categoria per defecte on es posen els cursos sol·licitats, si s\'aprova la sol·licitud.';
$string['configdefaultuserroleid'] = 'A tots els usuaris que hagin entrat se\'ls assignaran les capacitats del rol que especifiqueu aquí, al nivel del lloc, A MÉS A MÉS de qualsevol altre rol que se\'ls hagi assignat. El valor per defecte és el rol d\'usuari autenticat. Fixeu-vos que aquest rol per defecte no entrarà en conflicte amb cap altre rol que tinguin. Simplement assegura que tots els usuaris tenen unes capacitats no assignables en el nivell de curs (p. ex. publicar entrades al seu blog, gestionar el seu calendari propi, etc.).';
$string['configdeleteincompleteusers'] = 'Després d\'aquest període, se suprimiran els comptes vells que romanguin incomplets.';
$string['configdeleteunconfirmed'] = 'Si esteu utilitzant l\'autenticació per correu electrònic, aquest és el període dins del qual s\'acceptarà la resposta dels usuaris. Després d\'aquest període, els comptes no confirmats se suprimeixen.';
$string['configdenyemailaddresses'] = 'Per refusar les adreces de correu de certs dominis, especifiqueu-les aquí precedides d\'un punt \'.\' . Tots els altres dominis seran acceptats. P. ex. <strong>.hotmail.com .yahoo.com .live.com</strong>';
$string['configdisableuserimages'] = 'Inhabilita la possibilitat que els usuaris canviïn les seves imatges al perfil.';
$string['configdisplayloginfailures'] = 'Aquest paràmetre permet que usuaris seleccionats visualitzin informació sobre intents d\'entrada erronis.';
$string['configdndallowtextandlinks'] = 'Habilita o inhabilita arrossegar i deixar anar text i enllaços dins de la pàgina principal del curs, així com arrossegar i deixar anar fitxers. Fixeu-vos que arrossegar text en Firefox o entre diferents navegadors no és fiable i poden no carregar-se dades o carregar-se text corrupte.';
$string['configdocroot'] = 'Defineix el camí de Moodle Docs. Podeu canviar-lo si voleu tenir la vostra documentació personalitzada en línia. Però, si ho feu, assegureu-vos que els camins dins la vostra documentació segueixen el mateix format que en http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Si habiliteu aquesta opció, els enllaços a Moodle Docs s\'obriran en una finestra nova.';
$string['configeditordictionary'] = 'Aquest valor s\'utilitzarà si aspell no té un diccionari per a l\'idioma de l\'usuari.';
$string['configeditorfontlist'] = 'Seleccioneu els tipus de lletra que haurien d\'aparèixer en la llista desplegable de l\'editor.';
$string['configemailchangeconfirmation'] = 'Requereix un correu de confirmació quan els usuaris canviïn la seva adreça de correu al perfil.';
$string['configenableajax'] = 'Aquest paràmetre us permet controlar l\'ús d\'AJAX (interfícies avançades client-servidor mitjançant JavaScript) arreu del lloc. Si habiliteu aquest paràmetre, els usuaris podran triar en el seu perfil si utilitzen AJAX o no. Si no habiliteu el paràmetre, l\'AJAX restarà inhabilitat per a tothom.';
$string['configenableblogs'] = 'Aquesta opció proporciona a tots els usuaris del lloc el seu propi blog.';
$string['configenablecalendarexport'] = 'Habiliteu l\'exportació o subscripció a calendaris.';
$string['configenablecomments'] = 'Habiliteu els comentaris';
$string['configenablecourserequests'] = 'Això permetrà que qualsevol usuari sol·liciti la creació d\'un curs.';
$string['configenabledevicedetection'] = 'Habilita la detecció de mòbils, telèfons intel·ligents (<em>smartphones</em>), tauletes tàctils o altres dispositius (ordinadors de taula, portàtils, etc.) per a l\'aplicació de temes i altres funcionalitats.';
$string['configenablegroupmembersonly'] = 'Si habiliteu aquesta opció, l\'accés a les activitats es restringirà als membres del grup. Això pot comportar un increment de la càrrega del servidor. A més a més, haureu de configurar les categories del llibre de qualificacions per a assegurar-vos que que les activitats romanen ocultes per als que no són membres del grup.';
$string['configenablemobilewebservice'] = 'Habilita els serveis mòbils per a l\'aplicació oficial de Moodle o per a altres que ho demanin. Per a més informació, llegiu {$a}';
$string['configenablerssfeeds'] = 'Aquest commutador habilita l\'RSS per a tot el lloc. Per a utilitzar realment l\'RSS, l\'haureu d\'activar també en cada mòdul. Aneu als paràmetres dels mòduls en Administració > Configuració.';
$string['configenablerssfeedsdisabled'] = 'No està disponible perquè l\'RSS està inhabilitat per a tot el lloc. Per habilitar-lo, aneu a la pantalla de variables en Administració > Configuració.';
$string['configenablerssfeedsdisabled2'] = 'Els canals RSS estan inhabilitats al nivell del servidor. Heu d\'habilitar-los abans en Servidor/RSS.';
$string['configenablesafebrowserintegration'] = 'Això afegeix l\'opció \'Requereix navegador segur\' al camp \'navegació segura\' al formulari de preguntes. Mireu http://www.safeexambrowser.org/ per cercar més informació.';
$string['configenablestats'] = 'Si trieu \'sí\', la tasca del cron de Moodle processarà els registres i recollirà algunes estadístiques. Això pot durar una estona, segons el tràfic del lloc. Si habiliteu aquesta opció podreu veure algunes gràfiques i estadístiques interessants referents a cada curs i al lloc complet.';
$string['configenabletrusttext'] = 'Per defecte Moodle sempre netejarà a fons el text provinent dels usuaris a fi d\'eliminar tota mena de codi que suposi un risc de seguretat. El sistema de Contingut de Confiança és una manera de concedir, només a usuaris en els quals confieu, la capacitat d\'incloure sense interferències característiques avançades als seus continguts. Per a habilitar aquest sistema, en primer lloc heu d\'habilitar aquest paràmetre i després atorgar el permís Contingut de Confiança a un rol específic de Moodle. Els textos creats o penjats per usuaris que tinguin aquest rol es marcaran com a fiables i no es netejaran abans de ser visualitzats.';
$string['configenablewebservices'] = 'Serveis web habilita altres sistemes per entrar al Moodle i fer operacions. Per raons de seguretat aquesta característica està inhabilitada llevat que l\'activeu.';
$string['configenablewsdocumentation'] = 'Habilita l\'autogeneració de serveis de documentació web. Un usuari pot accedir a la seva pròpia documentació en la pàgina de claus de seguretat {$a}. Això mostra la documentació sols per als protocols habilitats.';
$string['configerrorlevel'] = 'Trieu el nivell d\'avisos del PHP que voleu visualitzar. Generalment \'Normal\' és la millor opció.';
$string['configexportlookahead'] = 'Dies per davant en l\'exportació';
$string['configexportlookback'] = 'Dies enrere en l\'exportació';
$string['configextendedusernamechars'] = 'Habiliteu aquest paràmetre perquè els estudiants puguin usar qualsevol caràcter en el seu nom d\'usuari (no afecta els noms actuals). El valor per defecte és «fals», la qual cosa restringeix els noms d\'usuari a tindre caràcters alfanumèrics, guió baix (_), guió alt (-), punt (.) o el símbol arrova (@).';
$string['configextramemorylimit'] = 'Alguns scripts com cerca, còpia de seguretat/restaura o cron requereixen més memòria. Poseu valors elevats per a webs grans.';
$string['configfilterall'] = 'Filtra totes les cadenes, inclosos encapçalaments, títols, barres de navegació, etc. Útil sobretot amb el filtre multilingüe. Si no, pot crear una càrrega extra al servidor sense guanyar res a canvi.';
$string['configfiltermatchoneperpage'] = 'Els filtres que creen enllaços automàtics generaran només un enllaç per pàgina, en la primera coincidència que trobin, i n\'ignoraran la resta.';
$string['configfiltermatchonepertext'] = 'Els filtres que creen enllaços automàtics generaran només un enllaç per cada element de text (p. ex. recurs, bloc) en la primera coincidència que trobin, i n\'ignoraran la resta. Aquest paràmetre s\'ignorarà si habiliteu el paràmetre «per pàgina».';
$string['configfilteruploadedfiles'] = 'Habilitar aquest paràmetre fa que Moodle processi amb els filtres, abans de visualitzar-los, tots els fitxers de text i HTML que es pengin.';
$string['configforcelogin'] = 'Normalment la pàgina inicial del lloc i la llista de cursos es poden llegir sense entrar-hi amb nom d\'usuari i contrasenya. Si voleu imposar que els usuari entrin abans de veure o fer RES en aquest lloc, habiliteu aquest paràmetre.';
$string['configforceloginforprofiles'] = 'Habiliteu aquest paràmetre per imposar que els usuaris entrin amb un compte real (no com a visitants) abans que puguin veure els perfils d\'usuaris. Si teniu inhabilitat aquest paràmetre, us podeu trobar que alguns usuaris posen publicitat (brossa) o continguts inadequats als seus perfils i llavors això és visible per a tothom.';
$string['configfrontpage'] = 'Els elements marcats a dalt es visualitzaran a la primera plana del lloc.';
$string['configfrontpagecourselimit'] = 'Nombre màxim de cursos';
$string['configfrontpagecourselimithelp'] = 'Nombre màxim de cursos que es mostren en el llistat de cursos de la pàgina principal del lloc.';
$string['configfrontpageloggedin'] = 'Els elements marcats a dalt es visualitzaran a la primera plana del lloc només si l\'usuari ha entrat.';
$string['configfullnamedisplay'] = 'Aquest paràmetre defineix el format dels noms quan es visualitzen complets. En la majoria de llocs el valor per defecte és el més adequat: «Nom + Cognoms». Però si voleu podeu ocultar els cognoms, o deixar que el paquet d\'idioma decideixi el format (alguns idiomes tenen convencions diferents).';
$string['configgeoipfile'] = 'Ubicació del fitxer binari de dades de GeoIP City. Aquest fitxer no és part de la distribució de Moodle i cal obtenir-lo de <a href="http://www.maxmind.com/">MaxMind</a> per separat. Podeu comprar la versió comercial o utilitzar la versió gratuïta.<br />Simplement baixeu <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> i descomprimiu-lo dins del directori "{$a}" del vostre servidor.';
$string['configgetremoteaddrconf'] = 'Si el vostre servidor està darrere un proxy, podeu modificar aquest paràmetre per especificar quines capçaleres HTTP són de confiança per contenir adreces IP remotes. Les capçaleres es llegeixen en ordre, utilitzant la primera que sigui disponible.';
$string['configgradebookroles'] = 'Aquest paràmetre us permet controlar qui apareix al butlletí de qualificacions. Els usuaris que tinguin assignat almenys un d\'aquests rols en un curs apareixeran al butlletí de qualificacions d\'aquest curs.';
$string['configgradeexport'] = 'Trieu quins formats voleu com a mètodes primaris d\'exportació del butlletí de qualificacions. Els connectors que trieu definiran i actualitzaran un camp de «darrera exportació» per a cada qualificació. Això tindrà com a conseqüència, per exemple, que els registres exportats s\'identifiquin com a «nous» o «actualitzats». Si no esteu segur podeu deixar totes les opcions desactivades.';
$string['confighiddenuserfields'] = 'Seleccioneu quins camps d\'informació de l\'usuari voleu ocultar als usuaris que no siguin professors o administradors. Això protegirà la intimitat de l\'estudiantat. Utilitzeu la tecla CTRL per seleccionar múltiples camps.';
$string['configidnumber'] = 'Aquesta opció especifica si: a) no es demana cap número d\'identificació als usuaris; b) es demana un número d\'identificació als usuaris però poden deixar-lo en blanc o c) es demana un número d\'identificació als usuaris i no poden deixar-lo en blanc. Si l\'usuari ha donat un número d\'identificació, aquest número es mostra al seu perfil.';
$string['configintro'] = 'En aquesta pàgina podeu especificar un gran nombre de variables de configuració que contribueixen a fer funcionar Moodle de la manera adequada en el vostre servidor. Però no cal que us amoïneu: els valors per defecte solen anar molt bé i sempre podeu tornar-hi més tard per fer canvis en aquests paràmetres.';
$string['configintroadmin'] = 'En aquesta pàgina heu de configurar el compte de l\'administrador principal que tindrà control complet sobre aquest lloc. Doneu-li un nom i una contrasenya segurs i una adreça de correu electrònic vàlida. Després podreu crear més comptes d\'administració.';
$string['configintrosite'] = 'Aquesta pàgina us permet configurar la pàgina inicial i el nom d\'aquest lloc. Podeu tornar-hi després en qualsevol moment per canviar aquests paràmetres, per mitjà de l\'enllaç «Paràmetres del lloc» de la pàgina inicial.';
$string['configiplookup'] = 'Quan feu clic en una adreça IP (com ara 34.12.222.93), per exemple als registres d\'activitat, se us mostra en un mapa la ubicació probable d\'aquesta adreça. Podeu triar amb quin connector se cercarà la ubicació. Cada un té avantatges i inconvenients.';
$string['configkeeptagnamecase'] = 'Activeu aquest paràmetre si voleu que els noms de les etiquetes mantinguin les majúscules/minúscules, tal com les escrigui el primer usuari que creï l\'etiqueta.';
$string['configlang'] = 'Escolliu l\'idioma per omissió de tot el lloc. Casa usuari pot redefinir aquest paràmetre utilitzant el menú d\'idioma o el paràmetre corresponent del seu perfil personal.';
$string['configlanglist'] = 'Deixeu en blanc aquest camp per tal que els usuaris puguin triar qualsevol idioma instal·lat. Si voleu abreujar el menú d\'idiomes, introduïu aquí una llista de codis separats per comes. Per exemple: ca,es_es,en,fr,it.';
$string['configlangmenu'] = 'Trieu si voleu visualitzar o no el menú d\'idioma a la pàgina inicial, pàgina d\'entrada, etc. No impedeix que l\'usuari pugui definir el seu idioma preferit en el seu perfil.';
$string['configlangstringcache'] = 'Manté totes les cadenes d\'idioma dins de fitxers compilats ubicats al directori de dades. Si esteu traduint el Moodle, o canviant cadenes de text dins del codi del Moodle és probable que vulgueu desactivar aquesta opció. Altrament és molt recomanable que estigui activada per millorar el rendiment.';
$string['configlatinexcelexport'] = 'Trieu la codificació per a les exportacions en format Excel.';
$string['configlocale'] = 'Escolliu un <em>locale</em> per a tot el lloc. Afecta el format i l\'idioma de les dates de tots els paquets d\'idioma (excepte els noms dels dies al calendari). Heu de tenir instal·lades les dades d\'aquest <em>locale</em> en el vostre sistema operatiu. (p ex.: ca_ES.UTF-8, es_ES.UTF-8 o en_US en sistemes GNU/Linux). En la majoria de casos haureu de deixar aquest camp en blanc.';
$string['configloginhttps'] = 'Activar aquest paràmetre fa que Moodle utilitzi una connexió HTTPS segura en la pàgina d\'entrada, tot proporcionant així una entrada segura, i després torni als URL normals amb HTTP per a mantenir la velocitat normal. ALERTA: aquest paràmetre requereix que l\'HTTPS estigui habilitat en el vostre servidor. Si no està habilitat US PODRÍEU QUEDAR FORA SENSE POSSIBILITAT D\'ENTRAR AL VOSTRE LLOC.';
$string['configloglifetime'] = 'Aquest paràmetre especifica quant temps voleu mantenir els registres d\'activitat dels usuaris. Els registres més vells se suprimiran automàticament. És millor mantenir els registres tant temps com sigui possible, per si els necessiteu, però si el vostre servidor té molts usuaris i teniu problemes de rendiment, potser preferireu rebaixar la duració dels registres.';
$string['configlookahead'] = 'Quants dies';
$string['configmaxbytes'] = 'Aquest paràmetre especifica la mida màxima dels fitxers que es poden penjar al lloc. El límit màxim està definit pel paràmetre del PHP upload_max_filesize i pel paràmetre de l\'Apache LimitRequestBody. Al seu torn, maxbytes limita la mida màxima que es pot triar dins d\'un curs o dins d\'un mòdul.';
$string['configmaxconsecutiveidentchars'] = 'Una contrasenya no hauria de tenir repetits consecutivament més caràcters dels que s\'indiquen aquí. Si indiqueu 0 es desactiva aquesta comprovació.';
$string['configmaxeditingtime'] = 'Aquest paràmetre especifica quant temps tenen els usuaris per anar a editar els seus missatges dels fòrums, la retroacció dels diaris, etc. Generalment 30 minuts és un temps suficient.';
$string['configmaxevents'] = 'Quants esdeveniments';
$string['configmaxusersperpage'] = 'Nombre màxim d\'usuaris que es mostren en el selector d\'usuaris en cursos, grups, cohorts, serveis web, etc.';
$string['configmessaging'] = 'Cal habilitar el sistema de missatgeria entre usuaris del lloc?';
$string['configmessagingallowemailoverride'] = 'Permet als usuaris tenir missatges de notificació de correu electrònic enviats a una adreça de correu diferent de l\'adreça del seu perfil.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Missatges llegits que poden ser esborrats per estalviar espai. Quan temps ha d\'haver passat des que un missatge es llegeix per poder-lo esborrar ?';
$string['configmessaginghidereadnotifications'] = 'Amaga missatges llegits o successos com missatges de fòrums quan es veu l\'historial de missatges.';
$string['configminpassworddigits'] = 'Les contrasenyes han de tenir almenys aquests dígits.';
$string['configminpasswordlength'] = 'Les contrasenyes han de tenir almenys aquest nombre de caràcters.';
$string['configminpasswordlower'] = 'Les contrasenyes han de tenir almenys aquest nombre de minúscules.';
$string['configminpasswordnonalphanum'] = 'Les contrasenyes han de tenir almenys aquest nombre de caràcters no alfanumèrics.';
$string['configminpasswordupper'] = 'Les contrasenyes han de tenir almenys aquest nombre de majúscules.';
$string['configmobilecssurl'] = 'Un fitxer CSS per a personalitzar la vostra interfície d\'aplicacions mòbils.';
$string['configmodchooserdefault'] = 'Cal presentar per defecte el selector d\'activitats als usuaris?';
$string['configmycoursesperpage'] = 'Nombre màxim de cursos que es mostren en qualsevol llista de cursos d\'un usuari.';
$string['configmymoodleredirect'] = 'Aquest paràmetre fa que els usuaris no administradors siguin redirigits a /my en entrar i que se substitueixi per /my el camí que es mostra al capdamunt de la pàgina.';
$string['configmypagelocked'] = 'Aquest paràmetre impedeix que la pàgina per defecte l\'editin persones no administradores.';
$string['confignavcourselimit'] = 'Limita el nombre de cursos que es mostren a l\'usuari quan no han entrat o no estan inscrits en cap curs.';
$string['confignavshowallcourses'] = 'Quan s\'habilita, els usuaris poden veure tots els cursos en què estan incrits tant dins de la branca «Els meus cursos» com dins de l\'estructura del curs. Quan s\'inhabilita, els usuaris amb inscripcions només poden veure la branca de navegació «Els meus cursos». El nombre de curs que es mostra estaria limitat igualment pel paràmetre «Límit de curs(navcourselimit)» si l\'usuari no ha entrat o no està inscrit en cap curs.';
$string['confignavshowcategories'] = 'Mostra les categories de cursos a la barra de navegació i als blocs. No passa en cursos en què l\'usuari estigui inscrit: apareixeran a la llista d\'Els meus cursos sense categories.';
$string['confignotifyloginfailures'] = 'Si s\'estan registrant les entrades errònies, se\'n poden enviar notificacions per correu electrònic. Qui hauria de veure aquestes notificacions?';
$string['confignotifyloginthreshold'] = 'Si s\'han activat les notificacions d\'entrades errònies, quants intents erronis del mateix usuari o de la mateixa adreça IP cal esperar per enviar la notificació?';
$string['confignotloggedinroleid'] = 'Els usuaris que no hagin iniciat sessió seran tractats com si se\'ls hagués atorgat aquest rol al nivell del lloc. Generalment se\'ls dóna el rol Visitant, però igualment podríeu crear un rol que fos més o menys restrictiu. En tot cas, certes accions com ara enviar un missatge en un fòrum requereixen sempre que l\'usuari hagi iniciat sessió.';
$string['configopentogoogle'] = 'Si habiliteu aquest paràmetre, es permetrà que Google entri en el vostre lloc com a visitant. A més a més, la gent que entri al vostre lloc a través d\'una cerca de Google, hi entrarà automàticament com a visitant. Teniu en compte que això proporciona un accés transparent als cursos que permeten l\'accés de visitants.';
$string['configoverride'] = 'Definit en config.php';
$string['configpasswordpolicy'] = 'Si activeu aquesta opció, Moodle comprovarà que les contrasenyes d\'usuari compleixen una normativa de contrasenyes vàlida. Utilitzeu els paràmetres següents per definir la vostra normativa (els paràmetres s\'ignoraran si poseu \'No\' en aquesta opció).';
$string['configpasswordresettime'] = 'Aquesta opció especifica el temps màxim que té la gent per a validar una sol·licitud de restabliment de contrasenya abans que venci. Normalment, 30 minuts és un valor raonable.';
$string['configpathtoclam'] = 'Camí del clam AV. Probablement quelcom semblant a /usr/bin/clamscan o /usr/bin/clamdscan. Necessari per fer funcionar el clam AV.';
$string['configpathtodu'] = 'Camí de du. Probablement /usr/bin/du o alguna cosa semblant. Si definiu aquest paràmetre, les pàgines que visualitzen el contingut d\'un directori amb molts fitxers funcionaran més ràpides.';
$string['configperfdebug'] = 'Si activeu aquesta opció, la informació de rendiment s\'inclourà en el peu de pàgina del tema estàndard.';
$string['configprofileroles'] = 'Llista de rols que són visibles als perfils dels usuaris i pàgina de participants.';
$string['configprofilesforenrolledusersonly'] = 'Per prevenir un ús inadequat dels emissors de correu brossa, la descripció dels perfils dels usuaris que no formen part de cap curs és oculta. Els nous usuaris han d\'estar en un curs abans de poder afegir una descripció del seu perfil.';
$string['configprotectusernames'] = 'Per defecte forget_password.php no mostra cap indicació que permeti endevinar noms d\'usuari o adreces de correu.';
$string['configproxybypass'] = 'Llista separada per comes d\'adreces o noms IP (parcials) per als quals no s\'utilitzarà el servidor intermediari (p. ex. 192.168., .domini-local.cat)';
$string['configproxyhost'] = 'Si aquest <b>servidor</b> necessita usar un ordinador intermediari (p. ex. un tallafoc) per accedir a Internet, introduïu aquí el nom i el port de l\'intermediari. Si no, deixeu-lo en blanc.';
$string['configproxypassword'] = 'Contrasenya requerida per a accedir a Internet a través d\'un intermediari. Si no, deixeu el paràmetre en blanc (extensió PHP cURL necessària).';
$string['configproxyport'] = 'Si aquest servidor necessita utilitzar un ordinador intermediari, introduïu aquí el seu port.';
$string['configproxytype'] = 'Tipus d\'intermediari web (PHP5 i extensió cURL necessaris per a funcionar amb SOCKS5).';
$string['configproxyuser'] = 'Nom d\'usuari requerit per a accedir a Internet a través d\'un intermediari. Si no, deixeu el paràmetre en blanc (extensió PHP cURL necessària).';
$string['configquarantinedir'] = 'Si voleu que ClamAV mogui els fitxers infectats a un directori de quarantena, definiu el directori aquí. El servidor web ha de tenir permís d\'escriptura en aquest directori. Si el deixeu en blanc, o introduïu un directori que no existeix, o no s\'hi pot escriure, llavors els fitxers infectats se suprimiran. No inclogueu una barra final.';
$string['configrecaptchaprivatekey'] = 'Cadena de caràcters utilitzada per a la comunicació entre el vostre servidor Moodle i el servidor recaptcha.net. Podeu obtenir-la en http://recaptcha.net';
$string['configrecaptchapublickey'] = 'Cadena de caràcters utilitzada per visualitzar l\'element reCAPTCHA en el formulari de registre. Generada per http://recaptcha.net';
$string['configrequestcategoryselection'] = 'Permet la selecció d\'una categoria quan se sol·licita un curs.';
$string['configrequestedstudentname'] = 'Paraula per a «estudiant» en els cursos sol·licitats';
$string['configrequestedstudentsname'] = 'Paraula per a «estudiants» en els cursos sol·licitats';
$string['configrequestedteachername'] = 'Paraula per a «professor» en els cursos sol·licitats';
$string['configrequestedteachersname'] = 'Paraula per a «professors» en els cursos sol·licitats';
$string['configrequiremodintro'] = 'Inhabiliteu aquesta opció si no voleu forçar els usuaris a escriure la descripció de cada activitat.';
$string['configrunclamavonupload'] = 'Si habiliteu aquest paràmetre, s\'utilitzarà clam AV per examinar tots els fitxers que es pengin.';
$string['configrunclamonupload'] = 'Voleu executar el clam AV quan es pengin fitxers? Proporcioneu un camí correcte en pathtoclam perquè funcioni. (Clam AV és un escanejador de virus lliure que podeu obtenir en http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interfície';
$string['configsectionmail'] = 'Correu';
$string['configsectionmaintenance'] = 'Manteniment';
$string['configsectionmisc'] = 'Miscel·lània';
$string['configsectionoperatingsystem'] = 'Sistema operatiu';
$string['configsectionpermissions'] = 'Permisos';
$string['configsectionrequestedcourse'] = 'Sol·licituds de cursos';
$string['configsectionsecurity'] = 'Seguretat';
$string['configsectionstats'] = 'Estadístiques';
$string['configsectionuser'] = 'Usuari';
$string['configsecureforms'] = 'Moodle pot fer servir un nivell addicional de seguretat quan accepta dades de formularis web. Si habiliteu aquesta opció, la variable HTTP_REFERER del navegador es compara amb l\'adreça real del formulari. En casos excepcionals això pot causar problemes si l\'usuari està utilitzant un tallafoc (p. ex. Zonealarm) configurat per suprimir l\'HTTP_REFERER del tràfic web. El símptoma habitual consisteix a quedar-se \'enganxat\' en un formulari. Si els vostres usuaris tenen problemes, per exemple, amb la pàgina d\'entrada, potser haureu d\'inhabilitar aquest paràmetre, tot i que llavors podríeu deixar el vostre lloc més obert a intents de desxifrar contrasenyes per força bruta. En cas de dubte, deixeu-lo en \'Sí\'.';
$string['configsessioncookie'] = 'Aquest paràmetre personalitza el nom de la galeta utilitzada per a les sessions de Moodle. És opcional i només resulta útil per evitar que les galetes es confonguin quan s\'executen diferents còpies de Moodle en el mateix lloc web.';
$string['configsessioncookiedomain'] = 'Això us permet canviar la disponibilitat de les galetes de Moodle. És útil per a personalitzacions de Moodle (ex. autenticacions o connectors d\'inscripció) que requereixen que Moodle comparteixi informació de la sessió amb una aplicació web o un altre subdomini. <strong>ATENCIÓ: Es recomana fortament deixar aquest paràmetre per defecte (buit)- un ús incorrecte pot comprometre totes les contrasenyes del lloc.</strong>';
$string['configsessioncookiepath'] = 'Si necessiteu canviar el lloc on els navegadors envien les galetes de Moodle, podeu especificar un subdirectori del vostre web en aquest paràmetre. Si no, deixeu el directori \'/\' per defecte.';
$string['configsessiontimeout'] = 'Si els usuaris que entren en aquest lloc estan inactius durant molt temps (no carreguen pàgines) se\'ls farà sortir automàticament (s\'acabarà la seva sessió). Aquesta variable especifica després de quant temps passa això.';
$string['configshowcommentscount'] = 'Els comentaris mostrats compten, costaran una pregunta més quan es mostri l\'enllaç de comentaris';
$string['configshowicalsource'] = 'Mostra la font d\'informació per als esdeveniments iCal.';
$string['configshowsiteparticipantslist'] = 'Tots els estudiants d\'aquest lloc i tots els professors d\'aquest lloc apareixerà a la llista de participants del lloc. A qui se li permet veure la llista de participants del lloc?';
$string['configsitedefaultlicense'] = 'Llicència del lloc web';
$string['configsitedefaultlicensehelp'] = 'La llicència per defecte per al contingut publicat en aquesta web';
$string['configsitemaxcategorydepth'] = 'Profunditat màxima de subcategories';
$string['configsitemaxcategorydepthhelp'] = 'La profunditat màxima de subcategories que es mostren.';
$string['configslasharguments'] = 'Els fitxers (imatges, etc.) són servits per mitjà d\'un programa que utilitza «arguments en barra» (la segona opció aquí). Aquest mètode permet que els fitxers s\'emmagatzemin més fàcilment a la memòria cau dels navegadors, servidors intermediaris, etc. Malauradament alguns servidors PHP no permeten aquest mètode, de manera que si teniu problemes per a veure els fitxers penjats o imatges (p. ex. les imatges dels usuaris), deixeu aquesta variable en la primera opció.';
$string['configsmartpix'] = 'Amb aquest paràmetre habilitat, les icones se serviran per mitjà d\'un guió PHP que cerca el tema actual, després tots els temes pare i finalment la carpeta /pix de Moodle. Això redueix la necessitat de duplicar fitxers d\'imatges en els temes, però també té un lleuger cost de rendiment.';
$string['configstartwday'] = 'Començament de la setmana';
$string['configstatsfirstrun'] = 'Aquest paràmetre especifica des de quina data cal processar els registres <b>la primera vegada</b> que el cron processi les estadístiques. Si teniu molt tràfic i esteu en un servidor compartit, probablement no seria bona idea començar des de molt enrere, ja que podria costar molt temps i consumir molts recursos. (Teniu en compte que en aquest paràmetre 1 mes = 28 dies. En les gràfiques i informes que es generin, un mes serà un mes real del calendari.)';
$string['configstatsmaxruntime'] = 'El processament de les estadístiques pot ser bastant intensiu. Utilitzeu una combinació d\'aquest camp i el següent per especificar quan s\'executa i quant temps.';
$string['configstatsmaxruntime2'] = 'El processament de les estadístiques pot consumir bastants recursos del servidor. Especifiqueu un temps màxim permès per a computar les estadístiques d\'un dia. En cada execució del cron es processaran com a màxim 31 dies.';
$string['configstatsmaxruntime3'] = 'Especifiqueu el temps màxim permès per a computar les estadístiques d\'un dia. Teniu en compte que el processament de les estadístiques pot carregar molt el servidor. El nombre màxim de dies processats en una execució del cron es pot especificar més avall.';
$string['configstatsruntimedays'] = 'Especifiqueu el nombre màxim de dies que es poden processar en cada execució de les estadístiques. Quan les estadístiques estiguin actualitzades només es processarà un dia. Ajusteu aquest valor segons la càrrega del servidor. Reduïu-lo si cal escurçar el temps d\'execució dels processos del cron.';
$string['configstatsruntimestart'] = 'A quina hora ha de <b>començar</b> la tasca del cron que processa les estadístiques? Especifiqueu temps diferents si teniu múltiples Moodles en un mateix servidor físic.';
$string['configstatsuserthreshold'] = 'Aquest paràmetre especifica el nombre mínim d\'usuaris inscrits en un curs per fer càlculs estadístics. ';
$string['configstrictformsrequired'] = 'Si està habilitat, als usuaris se\'ls impedeix introduir un espai o un salt de línia només en els camps requerits en els formularis.';
$string['configstripalltitletags'] = 'Desactiveu aquest paràmetre per permetre l\'ús d\'etiquetes HTML en els noms de recursos i activitats.';
$string['configsupportemail'] = 'Aquesta adreça de correu es mostra als usuaris del lloc quan necessiten ajuda genèrica (p. ex. quan un usuari nou crea el seu compte). Si aquesta adreça es deixa en blanc, no es mostrarà cap adreça d\'ajuda.';
$string['configsupportname'] = 'Aquest és el nom d\'una persona, o entitat etc., que ofereix ajuda als usuaris per correu electrònic o a través d\'una pàgina web.';
$string['configsupportpage'] = 'Aquesta adreça web es mostra als usuaris del lloc per informar-los d\'on poden obtenir ajuda genèrica (p. ex. quan un usuari nou crea el seu compte). Si aquesta adreça es deixa en blanc, no es mostrarà cap enllaç d\'ajuda.';
$string['configthemedesignermode'] = 'Normalment totes les imatges i els fitxers d\'estils dels temes es mantenen a la memòria cau dels navegadors i del servidor durant molt de temps, amb l\'objectiu de millorar el rendiment. Si dissenyeu temes o desenvolupeu codi és probable que vulgueu activar aquest mode per no utilitzar les versions de la memòria cau.
Avís: activar aquest paràmetre farà que la càrrega de les pàgines sigui més lenta per a tothom! Com a alternativa podeu buidar la memòria cau del tema manualment des de la pàgina de selecció de temes.';
$string['configthemelist'] = 'Deixeu en blanc aquesta opció per a permetre l\'ús de qualsevol tema vàlid. Si voleu abreujar el menú de temes, especifiqueu aquí una llista de noms separats per comes (no utilitzeu espais).
Per exemple: standard,orangewhite';
$string['configtimezone'] = 'Podeu definir aquí la zona horària per defecte. Només és la zona horària PER DEFECTE per a la visualització de dates: cada usuari pot definir la seva en el seu perfil. Aquí «Hora del servidor» vol dir que Moodle agafarà la zona horària del sistema operatiu del servidor. En el perfil de l\'usuari, «Hora del servidor» vol dir que l\'usuari agafa la zona horària definida en aquest paràmetre de Moodle.';
$string['configuseblogassociations'] = 'Els usuaris podran organitzar el seu blog mantenint associacions de les seves entrades amb els cursos i els mòduls de cursos?';
$string['configuseexternalyui'] = 'En lloc d\'utilitzar fitxers locals, utilitza fitxers disponibles als servidors de Yahoo. COMPTE: la connexió a Internet ha d\'estar establerta, o no treballaran les característiques d\'AJAX al vostre lloc.';
$string['configuserquota'] = 'Nombre màxim de bytes que un usuari pot emmagatzemar a la seva pròpia àrea privada de fitxers. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Si està habilitat el nom curt del lloc s\'utilitzarà en la navegació per les pàgines del node en comptes d\'utilitzar \'Pàgines del lloc\'';
$string['configusetags'] = 'Cal habilitar la funcionalitat d\'etiquetes arreu del lloc?';
$string['configvariables'] = 'Variables';
$string['configverifychangedemail'] = 'Habilita la verificació del canvi d\'adreces de correu mitjançant els paràmetres de dominis autoritzats i denegats. Si inhabiliteu aquest paràmetre, la verificació dels dominis només es realitzarà quan es creen usuaris nous.';
$string['configvisiblecourses'] = 'Visualitza de la manera normal els cursos en categories ocultes.';
$string['configwarning'] = 'Aneu amb compte amb aquests paràmetres: uns valors incorrectes podrien causar problemes.';
$string['configyuicomboloading'] = 'Aquesta opció habilita la càrrega de fitxers combinats per les llibreries YUI. Aquest paràmetre hauria d\'estar habilitat en llocs de producció per raons de funcionament òptim.';
$string['confirmation'] = 'Confirmació';
$string['confirmdeletecomments'] = 'Ara esborrareu comentaris, segur que voleu fer-ho?';
$string['confirmed'] = 'Confirmat';
$string['convertformat'] = '	
<i>converteix</i> format de sortida';
$string['cookiehttponly'] = 'Només galetes HTTP';
$string['cookiesecure'] = 'Només galetes segures';
$string['country'] = 'País per defecte';
$string['coursecontact'] = 'Administradors de curs';
$string['coursecontact_desc'] = 'Aquest paràmetre us permet controlar qui apareix a la descripció dels cursos. Els usuaris que tinguin almenys un d\'aquests rols en un curs apareixeran en la descripció d\'aquest curs.';
$string['courselistshortnames'] = 'Mostra els noms curts';
$string['courselistshortnames_desc'] = 'Si està activat, en la llista de cursos es mostrarà el nom curt dels cursos a més a més del nom complet. Si cal, els noms de cursos perllongats poden ser personalitzats mitjançant l\'edició de la cadena de llengua \'courseextendednamedisplay\' utilitzant la funció de personalització d\'idioma.';
$string['coursemgmt'] = 'Gestiona cursos i categories';
$string['courseoverview'] = 'Resum del curs';
$string['courserequestnotify'] = 'Notificació de sol·licitud de curs';
$string['courserequestnotifyemail'] = 'L\'usuari {$a->user} ha sol·licitat un nou curs: {$a->link}';
$string['courserequests'] = 'Sol·licitud de cursos';
$string['courserequestspending'] = 'Sol·licituds de cursos pendents';
$string['courses'] = 'Cursos';
$string['coursesperpage'] = 'Cursos per pàgina';
$string['courseswithsummarieslimit'] = 'Límit de cursos amb resum';
$string['creatornewroleid'] = 'Rol del creador en nous cursos';
$string['creatornewroleid_help'] = 'Si l\'usuari no té el permís per gestionar el nou curs, l\'usuari s\'inscriurà utilitzant aquest rol.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Execució del cron només des de la línia d\'ordres';
$string['cronerrorclionly'] = 'L\'administrador ha inhabilitat l\'accés a aquesta pàgina per Internet.';
$string['cronerrorpassword'] = 'No heu proporcionat una contrasenya vàlida per a accedir a aquesta pàgina';
$string['cron_help'] = 'L\'script de manteniment de cron ajuda en alguns mòduls de Moodle a fer tasques sobre una base programada, com enviament de correus de fòrums o enviaments nous. Es requereix un mecanisme per executar l\'script cada 5 minuts.';
$string['cronremotepassword'] = 'Contrasenya d\'accés remot al cron';
$string['cronwarning'] = 'La <a href="cron.php">seqüència de manteniment cron.php</a> no s\'ha executat en les darreres 24 hores com a mínim.';
$string['ctyperecommended'] = 'Es recomana instal·lar l\'extensió de PHP ctype a fi de millorar el rendiment del lloc, especialment si teniu usuaris que treballen amb idiomes no occidentals.';
$string['ctyperequired'] = 'A hores d\'ara Moodle requereix l\'extensió de PHP ctype, a fi de millorar el rendiment del lloc i oferir compatibilitat amb diferents idiomes.';
$string['curlcache'] = 'cURL memòria cau TTL';
$string['curlrecommended'] = 'Es recomana instal·lar la biblioteca opcional cURL a fi d\'habilitar la funcionalitat de Moodle en Xarxa.';
$string['curlrequired'] = 'L\'extensió de PHP cURL és ara necessària per a comunicar-se amb repositoris Moodle.';
$string['curltimeoutkbitrate'] = 'Taxa de bits a utilitzar en el càlcul de temps d\'espera cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Aquesta configuració s\'utilitza per calcular el temps d\'espera adequat durant peticions cURL pesades. Com a part d\'aquest càlcul es fa una sol·licitud HTTP HEAD per determinar la mida del contingut. Configurar aquest valor a 0 desactiva que es faci aquesta sol·licitud.';
$string['currenttheme'] = 'Tema actual';
$string['customcheck'] = 'Altres comprovacions';
$string['custommenu'] = 'Menú personalitzat';
$string['custommenuitems'] = 'Elements del menú personalitzat';
$string['datarootsecurityerror'] = '<p><strong>AVÍS DE SEGURETAT</strong></p><p>El vostre directori de dades es troba en una ubicació incorrecta i està exposat al web. Això vol dir que tots els vostres fitxers privats són accessibles per a tothom i alguns poden ser utilitzats per pirates a fi d\'obtenir accés administratiu no autoritzat al vostre lloc.</p>
<p><em>Cal</em> que traslladeu el directori de dades ({$a}) a una altra ubicació que no estigui dins del directori web públic i actualitzeu el paràmetre <code>$CFG->dataroot</code> del config.php.</p>';
$string['datarootsecuritywarning'] = 'La configuració d\'aquest lloc podria no ser segura. Cercioreu-vos que el directori de dades ({$a}) no és accessible directament via web.';
$string['dbmigrate'] = 'Migració de la base de dades de Moodle';
$string['dbmigrateconnecerror'] = 'No s\'ha pogut establir la connexió amb la base de dades especificada.';
$string['dbmigrateencodingerror'] = 'La base de dades especificada té la codificació {$a} en lloc d\'Unicode/UTF-8, que és la requerida.<br />Especifiqueu-ne una altra.';
$string['dbmigratepostgres'] = 'Sembla que esteu utilitzant PostgreSQL com a servidor de base de dades. Per continuar el procés de migració necessiteu crear manualment una nova base de dades amb codificació «UNICODE» (PostgreSQL 7) o «UTF8» (PostgreSQL 8), on s\'emmagatzemaran les dades migrades. Introduïu aquí baix els paràmetres de connexió de la nova base de dades:';
$string['dbmigratewarning'] = 'Abans de començar aquest procediment, cercioreu-vos que teniu una còpia de seguretat de la base de dades de Moodle. Contacteu amb l\'administrador del vostre sistema si no sabeu com es fa. Quan engegueu el procés de migració, aquest lloc commutarà al mode de manteniment.';
$string['dbmigratewarning2'] = '<b>Avís: ara engegareu el procés de migració de la base de dades. Cercioreu-vos que teniu una còpia de seguretat de la base de dades de Moodle.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Aquesta base de dades s\'ha migrat a una nova base de dades UTF8 i ja no serveix. Editeu el fitxer config.php i utilitzeu la nova base de dades amb aquest moodle.</font>';
$string['dbmigrationdupfailed'] = 'La duplicació de la base de dades ha fallat amb aquest possible error:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Utilitza la base de dades per a informació de sessions';
$string['debug'] = 'Missatges de depuració';
$string['debugall'] = 'TOT: mostra tots els missatges raonables de depuració del PHP';
$string['debugdeveloper'] = 'DESENVOLUPADOR: missatge de depuració extra del Moodle per a desenvolupadors';
$string['debugdisplay'] = 'Visualitza missatges de depuració';
$string['debugging'] = 'Depuració';
$string['debugminimal'] = 'MÍNIM: mostra només els errors fatals';
$string['debugnone'] = 'RES: No mostris cap error o avís';
$string['debugnormal'] = 'NORMAL: Mostra errors i avisos';
$string['debugpageinfo'] = 'Mostra informació de la pàgina';
$string['debugsmtp'] = 'Depuració de l\'enviament de correu';
$string['debugstringids'] = 'Mostra l\'origen de les cadenes d\'idioma';
$string['debugstringids_desc'] = 'Aquesta opció està dissenyada per ajudar els traductors. Quan aquesta opció està activada, si s\'agrega el paràmetre strings=1 per a una petició URL, es mostrarà el fitxer d\'idioma i el número identificador de la cadena al costat de cada cadena que s\'envia.';
$string['debugvalidators'] = 'Mostra els enllaços validats';
$string['defaultcity'] = 'Ciutat per defecte';
$string['defaultcity_help'] = 'La ciutat que introduïu aquí serà la ciutat per defecte en la creació de nous comptes d\'usuari.';
$string['defaultformatnotset'] = 'S\'ha produït un error en determinar el format per defecte del curs. Comproveu els paràmetres del lloc.';
$string['defaulthomepage'] = 'Pàgina d\'inici per als usuaris';
$string['defaultrequestcategory'] = 'Categoria per defecte per a sol·licituds de cursos';
$string['defaultsettinginfo'] = 'Per defecte: {$a}';
$string['defaultuserroleid'] = 'Rol per defecte per a tots els usuaris';
$string['deleteincompleteusers'] = 'Suprimeix els comptes incomplets després de';
$string['deleteunconfirmed'] = 'Suprimeix els usuaris no confirmats després de';
$string['deleteuser'] = 'Suprimeix usuari';
$string['density'] = 'Densitat';
$string['denyemailaddresses'] = 'Dominis de correu denegats';
$string['development'] = 'Desenvolupament';
$string['devicedetectregex'] = 'Expressions regulars per la detecció de dispositius';
$string['devicedetectregex_desc'] = '<p>Per defecte, Moodle pot detectar dispositius del tipus per defecte (PC de taula, portàtils, etc.), mòbils (telèfons i dispositius petits de mà), tauletes tàctils (iPads, tauletes tàctils amb Android) i antigues (usuaris d\'Internet Explorer 6). El selector de tema es pot utilitzar per aplicar temes específics per a tots aquests. Aquesta configuració permet expressions regulars que permeten la detecció de tipus de dispositiu extra (aquests tenen prioritat sobre els tipus per defecte).</p>
<p>Per exemple, pot escriure l\'expressió regular \'/(MIDP-1.0|Maemo|Windows CE)/\' per a detectar telèfons amb funcions d\'ús comú afegeixi el valor de retorn \'featurephone\'. Això afegeix \'featurephone\' al selector de tema que li permet afegir un tema que s\'utilitzaria en aquests dispositius. Altres telèfons encara utilitzaran el tema seleccionat per al tipus de dispositiu mòbil.</p>';
$string['devicedetectregexexpression'] = 'Expressió regular';
$string['devicedetectregexvalue'] = 'Valor de retorn';
$string['devicetype'] = 'Tipus de dispositiu';
$string['disableuserimages'] = 'Inhabilita imatges en els perfils d\'usuari';
$string['displayerrorswarning'] = 'Es recomana no habilitar el paràmetre de PHP <em>display_errors</em> en llocs en producció perquè alguns missatges d\'error poden mostrar informació important sobre el vostre servidor.';
$string['displayloginfailures'] = 'Mostra entrades errònies a';
$string['dndallowtextandlinks'] = 'Arrossega i deixa anar càrrega de text i enllaços';
$string['docroot'] = 'Arrel de documents de Moodle Docs';
$string['doctonewwindow'] = 'Obre en una finestra nova';
$string['download'] = 'Baixa';
$string['edithelpdocs'] = 'Edita documents d\'ajuda';
$string['editingnoncorelangfile'] = 'Esteu modificant la traducció d\'un connector o mòdul afegit. Les traduccions de mòduls de terceres parts només es poden desar a la carpeta _local. Potser voldreu moure el fitxer de la traducció al directori d\'idiomes del mòdul i/o enviar-lo als responsables d\'aquest mòdul.';
$string['editlang'] = '<b>Edició</b>';
$string['editorbackgroundcolor'] = 'Color de fons';
$string['editordictionary'] = 'Diccionari de l\'editor';
$string['editorfontfamily'] = 'Família de fonts';
$string['editorfontlist'] = 'Llista de fonts';
$string['editorfontsize'] = 'Mida de font';
$string['editorhidebuttons'] = 'Botons ocults';
$string['editorkillword'] = 'Filtre format Word';
$string['editorspelling'] = 'Verificació de l\'ortografia en l\'editor';
$string['editorspellinghelp'] = 'Habiliteu o inhabiliteu la verificació de l\'ortografia. Si l\'habiliteu, cal tenir instal·lat <strong>aspell</strong> al servidor.';
$string['editstrings'] = 'Edita paraules o frases';
$string['emailchangeconfirmation'] = 'Confirmació de canvi de correu';
$string['emoticonalt'] = 'Text alternatiu';
$string['emoticoncomponent'] = 'Component de la imatge';
$string['emoticonimagename'] = 'Nom de la imatge';
$string['emoticons'] = 'Emoticones';
$string['emoticons_desc'] = 'Aquest formulari defineix les emoticones utilitzades al lloc web. Per suprimir un fila des d\'una taula, desa el formulari amb un valor buit en qualsevol dels camps. Per registrar un emoticona nova, omple el camps de la darrera fila buida. Per reinicialitzar tots els camps als valors per defecte, seguiu l\'enllaç de sota.

*Text (obligatori)- Aquest text serà reemplaçat per la icona de l\'emoticona. Cal que tingui almenys dos caràcters.
*Nom de la imatge (obligatori)- El nom de la imatge de l\'emoticona sense extensió.
*Component de la imatge (obligatori)- El component que proporciona la icona.
*Text alternatiu (opcional)- Cadena alternativa que identifica l\'emoticona.';
$string['emoticonsreset'] = 'Reinicialitza el paràmetre al valor per defecte.';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Buit';
$string['enableajax'] = 'Habilita AJAX';
$string['enableblogs'] = 'Habilita blogs';
$string['enablecalendarexport'] = 'Habilitació de l\'exportació de calendaris';
$string['enablecomments'] = 'Permet comentaris';
$string['enablecourserequests'] = 'Habilita sol·licituds de cursos';
$string['enablecssoptimiser'] = 'Habilita l\'optimitzador de CSS';
$string['enablecssoptimiser_desc'] = 'Quan s\'habiliti el CSS s\'executarà un procés d\'optimització abans de ser emmagatzemat en la memòria cau. L\'optimitzador processa el CSS suprimint estils i regles duplicats, així com l\'espai en blanc suprimible i canviant el format. Tingueu en compte que si l\'activeu al mateix temps que el mode de dissenyador de pàgines serà terrible per al rendiment però ajudarà els dissenyadors de temes a crear CSS optimitzats.';
$string['enabled'] = 'Habilitat';
$string['enabledevicedetection'] = 'Permet la detecció de dispositius';
$string['enablegravatar'] = 'Permet Gravatar';
$string['enablegravatar_help'] = 'Quan s\'habilita Moodle intentarà trobar una imatge de perfil d\'usuari de Gravatar si l\'usuari no ha penjat una imatge.';
$string['enablegroupmembersonly'] = 'Habilita sols membres del grup';
$string['enablemobilewebservice'] = 'Habilita els serveis web per als dispositius mòbils';
$string['enablerecordcache'] = 'Habilita la memòria cau de registres';
$string['enablerssfeeds'] = 'Habilita canals RSS';
$string['enablesafebrowserintegration'] = 'Habilita la integració de navegadors segurs.';
$string['enablestats'] = 'Habilita estadístiques';
$string['enabletgzbackups'] = 'Habilita el nou format de còpia de seguretat';
$string['enabletgzbackups_desc'] = 'Si s\'habilita, les properes còpies de seguretat es crearan en un nou format de fitxer .mbz (emmagatzemat internament com un fitxer .tar.gz). Així s\'elimina la restricció de mida de 4GB de les còpies de seguretat i pot millorar el rendiment. La restauració funciona amb tots dos formats, de manera que no hauria d\'haver-hi diferència per als usuaris.';
$string['enabletgzbackups_nozlib'] = 'L\'extensió de PHP ‘zlib’  no està disponible. El nou format de còpia de seguretat requereix aquesta extensió i romandrà inhabilitat fins que l\'instal·leu i l\'habiliteu.';
$string['enabletrusttext'] = 'Habilita el contingut de confiança';
$string['enablewebservices'] = 'Habilita els serveis web';
$string['enablewsdocumentation'] = 'Documentació de serveis web';
$string['enrolinstancedefaults'] = 'Instància d\'inscripció per defecte';
$string['enrolinstancedefaults_desc'] = 'Paràmetres d\'inscripció per defecte per als cursos nous.';
$string['enrolmultipleusers'] = 'Inscriu els usuaris';
$string['environment'] = 'Entorn';
$string['environmenterrortodo'] = 'Abans d\'instal·lar aquesta versió de Moodle heu de resoldre tots els problemes d\'entorn (errors) que s\'han trobat.';
$string['environmenterrorupgrade'] = 'Avís: hauríeu de resoldre tots els problemes d\'entorn (errors) descrits més amunt abans de continuar l\'actualització d\'aquesta versió de Moodle. Fer l\'actualització sense solucionar els requeriments podria causar problemes, p. ex. perdre dades. Segur que voleu continuar l\'actualització?';
$string['environmentmustfixsetting'] = 'Cal canviar el paràmetre PHP.';
$string['environmentok'] = 'L\'entorn del vostre servidor compleix tots els requeriments mínims.';
$string['environmentrecommendcustomcheck'] = 'si aquesta prova falla, això indica un problema en potència';
$string['environmentrecommendinstall'] = 's\'hauria d\'instal·lar i habilitar per aconseguir el millor funcionament';
$string['environmentrecommendversion'] = 'esteu executant la versió {$a->current} i es recomana la {$a->needed}';
$string['environmentrequirecustomcheck'] = 'cal passar aquesta prova';
$string['environmentrequireinstall'] = 'cal instal·lar-lo i habilitar-lo';
$string['environmentrequireversion'] = 'esteu executant la versió {$a->current} i es requereix la {$a->needed}';
$string['environmentsettingok'] = 'paràmetre recomanat detectat';
$string['environmentshouldfixsetting'] = 'S\'hauria de canviar el paràmetre PHP';
$string['environmentxmlerror'] = 'S\'ha produït un error en llegir les dades de l\'entorn ({$a->error_code})';
$string['errordeletingconfig'] = 'S\'ha produït un error mentre se suprimien les dades de configuració del connector \'{$a}\'.';
$string['errorsetting'] = 'No s\'ha pogut desar el paràmetre:';
$string['errorwithsettings'] = 'Alguns paràmetres no s\'han canviat a causa d\'un error.';
$string['everyonewhocan'] = 'Cadascú pot  \'{$a}\'';
$string['exceptions'] = 'excepcions ';
$string['execpathnotallowed'] = 'La definició de camins dels executables està inhabilitada en config.php.';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Paràmetres experimentals';
$string['extendedusernamechars'] = 'Permet caràcters estesos en els noms d\'usuari';
$string['extramemorylimit'] = 'Memòria límit extra PHP';
$string['fatalmagicquotesruntime'] = '<p>S\'ha detectat un error greu de configuració, notifiqueu-ho a l\'administrador del servidor.</p><p> Per poder funcionar correctament, Moodle necessita que l\'administrador canviï la configuració del PHP.</p><p>cal que el paràmetre <code>magic_quotes_runtime</code> estigui establert a <code>off</code>.</p><p>Aquest paràmetre es controla editant el fitxer <code>php.ini</code>, la configuració <br />de l\'Apache/IIS o el fitxer <code>.htaccess</code> del servidor.</p>';
$string['fatalsessionautostart'] = '<p>S\'ha detectat un error greu de configuració, notifiqueu-ho a l\'administrador del servidor.</p><p> Per poder funcionar correctament, Moodle necessita que l\'administrador canviï la configuració del PHP.</p><p>cal que el paràmetre <code>session.auto_start</code> estigui establert a <code>off</code>.</p><p>Aquest paràmetre es controla editant el fitxer <code>php.ini</code>, la configuració <br />de l\'Apache/IIS o el fitxer <code>.htaccess</code> del servidor.</p>';
$string['filecreated'] = 'S\'ha creat un nou fitxer';
$string['filestoredin'] = 'Desa el fitxer a la carpeta:';
$string['filestoredinhelp'] = 'On s\'emmagatzemarà el fitxer';
$string['filterall'] = 'Filtra totes les cadenes';
$string['filtermatchoneperpage'] = 'El filtre processa una coincidència per pàgina';
$string['filtermatchonepertext'] = 'El filtre processa una coincidència per text';
$string['filters'] = 'Filtres';
$string['filtersettings'] = 'Gestiona els filtres';
$string['filtersettingsgeneral'] = 'Paràmetres generals dels filtres';
$string['filteruploadedfiles'] = 'Filtra fitxers penjats';
$string['forcelogin'] = 'Obliga els usuaris a iniciar una sessió';
$string['forceloginforprofileimage'] = 'Obliga els usuaris a iniciar una sessió per veure les imatges dels usuaris';
$string['forceloginforprofileimage_help'] = 'Si està habilitat, els usuaris hauran d\'iniciar una sessió per veure les imatges del perfil dels usuaris, i s\'utilitzarà la imatge d\'usuari per defecte en les notificacions per correu electrònic.';
$string['forceloginforprofiles'] = 'Obliga els usuaris a iniciar una sessió per veure els perfils';
$string['forcetimezone'] = 'Imposa la zona horària';
$string['formatuninstallwithcourses'] = 'Hi ha {$a->count} cursos que utilitzen {$a->format}. El seu format canviarà a {$a->defaultformat}  (el format per defecte d\'aquest lloc). Algunes dades específiques del format es podrien perdre. Esteu segur que voleu continuar?';
$string['frontpage'] = 'Primera plana';
$string['frontpagebackup'] = 'Còpia de seguretat de la primera plana';
$string['frontpagedefaultrole'] = 'Rol per defecte per a la pàgina inicial';
$string['frontpagefilters'] = 'Filtres de la pàgina de portada';
$string['frontpageloggedin'] = 'Elements de la primera plana si l\'usuari ha iniciat una sessió';
$string['frontpageoverrides'] = 'Sobreescriu el permís de la primera plana';
$string['frontpagequestions'] = 'Preguntes de la primera plana';
$string['frontpagerestore'] = 'Restauració de la primera plana';
$string['frontpageroles'] = 'Rols de la primera plana';
$string['frontpagesettings'] = 'Paràmetres de la primera plana';
$string['fullnamedisplay'] = 'Format del nom complet';
$string['fullnamedisplayprivate'] = 'Format de nom complet - privat';
$string['gdrecommended'] = 'L\'extensió GD s\'utilitza per a la manipulació d\'imatges. Algunes característiques com ara les imatges dels perfils d\'usuari podrien no estar disponibles si falta aquesta extensió.';
$string['gdrequired'] = 'L\'extensió GD és necessària per a la conversió d\'imatges en Moodle.';
$string['generalsettings'] = 'Paràmetres generals';
$string['geoipfile'] = 'Fitxer de dades de ciutats GeoIP';
$string['getremoteaddrconf'] = 'Font de l\'adreça IP anotada';
$string['globalswarning'] = '<p><strong>AVÍS DE SEGURETAT</strong></p><p>Per a operar adequadament, Moodle necessita <br />que feu certs canvis en els paràmetres actuals del PHP.</p><p><em>Cal</em> que establiu <code>register_globals=off</code>.<p>Aquest paràmetre està definit en el fitxer <code>php.ini</code>, en la configuració d\'Apache/IIS<br />o en el fitxer <code>.htaccess</code>.</p>';
$string['googlemapkey3'] = 'Clau de l\'API de Google Maps V3';
$string['googlemapkey3_help'] = 'Heu d\'introduir una clau especial per a utilitzar Google Maps en la visualització de la cerca d\'adreces IP. Podeu obtenir la clau gratuïtament en <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Primera cadena no traduïda';
$string['gradebook'] = 'Butlletí de qualificacions';
$string['gradebookroles'] = 'Rols qualificats';
$string['gradeexport'] = 'Mètodes primaris d\'exportació de qualificacions';
$string['gravatardefaulturl'] = 'URL de la imatge per defecte per a Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar necessita una imatge per defecte que es visualitzarà quan no pugui trobar una imatge d\'un usuari determinat. Proporcioneu l\'URL complet d\'una imatge. Si deixeu aquest camp buit, Moodle intentarà utilitzar la imatge més apropiada per a la pàgina que estigueu veient. Fixeu-vos que Gravatar té un nombre de codis que poden utilitzar-se per a <a href="https://en.gravatar.com/site/implement/images/#default-image">generar imatges per defecte</a>.';
$string['groupenrolmentkeypolicy'] = 'Política de contrasenyes per a les inscripcions de grups';
$string['groupenrolmentkeypolicy_desc'] = 'Activar això farà que el Moodle comprovi que les contrasenyes d\'inscripcions en grup s\'ajusten a una política de contrasenyes vàlida.';
$string['guestroleid'] = 'Rol per a visitants';
$string['guestroleid_help'] = 'Aquest rol s\'assigna automàticament a l\'usuari convidat. També s\'assigna temporalment als usuaris no inscrits que entren al curs a través del connector d\'inscripció de convidats.';
$string['helpadminseesall'] = 'Veuen els administradors tots els esdeveniments o només aquells que se\'ls apliquin?';
$string['helpcalendarcustomexport'] = 'Habilita l\'opció d\'exportació d\'intervals personalitzats de dates en l\'exportació de calendaris. L\'exportació de calendaris ha d\'estar habilitada perquè aquesta opció sigui efectiva.';
$string['helpexportlookahead'] = 'Quants dies en el futur s\'han de buscar esdeveniments en el calendari amb l\'opció d\'exportació personalitzada?';
$string['helpexportlookback'] = 'Quants dies en el passat s\'han de buscar esdeveniments en el calendari amb l\'opció d\'exportació personalitzada?';
$string['helpforcetimezone'] = 'Podeu permetre que els usuaris seleccionin individualment la seva zona horària, o imposar una zona horària a tothom.';
$string['helpshowicalsource'] = 'Si s\'habilita, es mostrarà el nom de l\'enllaç de la subscripció en els esdeveniments importats via iCal.';
$string['helpsitemaintenance'] = 'Per a actualitzacions i altres tasques';
$string['helpstartofweek'] = 'Quin dia comença la setmana?';
$string['helpupcominglookahead'] = 'Quants dies per endavant considera el calendari per determinar els esdeveniments propers?';
$string['helpupcomingmaxevents'] = 'Quin nombre màxim d\'esdeveniments propers es mostra per defecte als usuaris?';
$string['helpweekenddays'] = 'Quins dies de la setmana es consideren «cap de setmana» i es mostren amb un color diferent?';
$string['hiddenuserfields'] = 'Camps d\'usuari ocults';
$string['hidefromall'] = 'Oculta a tothom';
$string['hidefromnone'] = 'No ocultis a ningú';
$string['hidefromstudents'] = 'Oculta a l\'estudiantat';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Paràmetres de l\'editor HTML';
$string['htmlsettings'] = 'Paràmetres HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Seguretat HTTP';
$string['hubs'] = 'Concentradors';
$string['iconvrecommended'] = 'És summament recomanable instal·lar la biblioteca opcional ICONV a fi de millorar el rendiment del lloc, especialment si el vostre lloc utilitza llengües no romàniques.';
$string['iconvrequired'] = 'Cal instal·lar l\'extensió ICONV.';
$string['ignore'] = 'Ignora';
$string['includemoduleuserdata'] = 'Inclou dades d\'usuari dels mòduls';
$string['incompatibleblocks'] = 'Blocs incompatibles';
$string['installhijacked'] = 'Cal que acabeu la instal·lació des de l\'adreça IP original.';
$string['installsessionerror'] = 'No s\'ha pogut inicialitzar la sessió PHP. Verifiqueu que el vostre navegador accepta galetes.';
$string['intlrecommended'] = 'L\'extensió Intl s\'utilitza per a millorar el suport d\'internacionalització, com ara l\'ordenació en funció de la llengua.';
$string['invalidsection'] = 'La secció no és vàlida';
$string['invaliduserchangeme'] = 'El nom d\'usuari «changeme» està reservat. No podeu crear un compte amb aquest nom.';
$string['ipblocked'] = 'Aquest lloc no està disponible actualment.';
$string['ipblocker'] = 'Blocatge d\'IP';
$string['ipblockersyntax'] = 'Poseu cada entrada en una línia. Les entrades vàlides són o bé adreces IP completes (com ara <b>192.168.10.1</b>) que concorden amb un únic servidor; o adreces parcials (com ara <b>192.168.</b>) que concorden amb qualsevol adreça que comenci amb aquests números; o bé la notació CIDR (com ara <b>231.54.211.0/20</b>); o bé un interval d\'adreces IP (com ara <b>231.3.56.10-20</b>) on l\'interval s\'aplica a la part final de l\'adreça. Els noms de domini textuals (del tipus \'xtec.cat\') no s\'admeten. Les línies en blanc s\'ignoren.';
$string['iplookup'] = 'Cerca d\'adreça IP';
$string['iplookupgeoplugin'] = 'El servei <a href="http://www.geoplugin.com">geoPlugin</a> s\'està utilitzant actualment per a cercar informació geogràfica. Per a resultats més detallats us recomanem instal·lar una còpia local de la base de dades MaxMind GeoLite.';
$string['iplookupinfo'] = 'Per defecte Moodle utilitza el servidor lliure NetGeo (The Internet Geographic Database) per cercar la ubicació geogràfica d\'adreces IP. Malauradament aquesta base de dades ja no és mantinguda i pot tornar dades <em>totalment incorrectes</em>. Es recomana instal·lar una còpia local de la base de dades gratuïta GeoLite City de MaxMind.<br />La ubicació d\'adreces IP es mostra en un mapa simple o mitjançant Google Maps. Teniu en compte que Google Maps requereix tenir un compte de Google i demanar una clau de l\'API de Google Maps.';
$string['iplookupmaxmindnote'] = 'Aquest producte inclou dades de GeoLite creades per MaxMind, disponibles en <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Conserva majúscules i minúscules en les etiquetes';
$string['lang'] = 'Idioma per defecte';
$string['langcache'] = 'Memòria cau del menú d\'idioma';
$string['langcache_desc'] = 'Emmagatzema el menú d\'idiomes a la memòria cau. Si està habilitat, la llista de traduccions disponibles s\'emmagatzema en la memòria cau. La memòria cau s\'actualitza automàticament quan s\'instal·la o elimina un paquet d\'idioma a través de l\'eina de gestió integrada dels paquets d\'idioma. Si instal·leu manualment un nou paquet d\'idioma feu servir la característica \'Purga de la memòria cau\' per actualitzar la llista en la memòria cau.';
$string['langlist'] = 'Idiomes al menú d\'idioma';
$string['langmenu'] = 'Mostra el menú d\'idioma';
$string['langpackwillbeupdated'] = 'Nota per a traductors: durant l\'actualització, Moodle intentarà actualitzar el vostre paquet d\'idioma. ';
$string['langstringcache'] = 'Posa al cau totes les cadenes d\'idioma';
$string['languagesettings'] = 'Paràmetres d\'idioma';
$string['latexpreamble'] = 'Preàmbul LaTeX';
$string['latexsettings'] = 'Paràmetres del renderitzador de LaTeX';
$string['latinexcelexport'] = 'Codificació per a Excel';
$string['legacyfilesaddallowed'] = 'Permet afegir als fitxers de curs heretats';
$string['legacyfilesaddallowed_help'] = 'Si el curs té fitxers de curs heretats, permet afegir-hi nous fitxers i carpetes.';
$string['legacyfilesinnewcourses'] = 'Fitxers de curs heretats en cursos nous';
$string['legacyfilesinnewcourses_help'] = 'Per omissió les àrees heretades de fitxers de curs només estan disponibles en cursos provinents d\'actualitzacions. Pareu esment que algunes característiques com la còpia de seguretat/restauració d\'activitats individuals no són compatibles amb aquest paràmetre.';
$string['licensesettings'] = 'Paràmetres de llicència';
$string['linkadmincategories'] = 'Enllaça categories de l\'administració';
$string['linkadmincategories_help'] = 'Si s\'activa, les categories dels paràmetres de l\'administració es mostraran com a enllaços en la navegació i conduiran a les pàgines de categoria d\'administració';
$string['loading'] = 'S\'està carregant...';
$string['localetext'] = 'Configuració local per a tot el lloc';
$string['localstringcustomization'] = 'Personalització local d\'idioma';
$string['location'] = 'Ubicació';
$string['locationsettings'] = 'Paràmetres d\'ubicació';
$string['locked'] = 'Bloquejat';
$string['lockoutduration'] = 'Durada del bloqueig del compte';
$string['lockoutduration_desc'] = 'El compte bloquejat es desbloqueja automàticament després d\'aquest període.';
$string['lockoutemailbody'] = 'El vostre compte amb nom d\'usuari {$a->username} al servidor \'{$a->sitename}\' ha estat blocat després de múltiples intents d\'accés no vàlids.

Per desbloquejar el compte immediatament aneu a l\'adreça {$a->link}

En molts programes de correu, això apareixerà com un enllaç blau que podeu prémer. Si això no funciona llavors copieu i enganxeu l\'adreça a la finestra de navegació al vostre navegador.

Si us cal ajuda contacteu amb el vostre administrador, {$a->admin}';
$string['lockoutemailsubject'] = 'El vostre compte a {$a} ha estat blocat';
$string['lockouterrorunlock'] = 'La informació subministrada per desblocar el compte no és vàlida.';
$string['lockoutthreshold'] = 'Llindar d\'intents per bloqueig del compte';
$string['lockoutthreshold_desc'] = 'Seleccioneu el nombre d\'intents fallits que comporten el bloqueig del compte. Aquesta característica pot ser objecte d\'abús en atacs de denegació de servei.';
$string['lockoutwindow'] = 'Finestra d\'observació del bloqueig del compte';
$string['lockoutwindow_desc'] = 'El temps d\'observació per al llindar de bloqueig. Si no hi ha intents fallits el comptador es restableix després d\'aquest temps.';
$string['log'] = 'Registres';
$string['logguests'] = 'Anota l\'accés de convidats';
$string['logguests_help'] = 'Aquest paràmetre habilita l\'anotació de les accions del compte de convidat i dels usuaris no identificats. Els llocs amb molt tràfic potser voldran inhabilitar-lo per raons de rendiment. Es recomana mantenir aquesta opció habilitada en entorns de producció.';
$string['loginhttps'] = 'Utilitza HTTPS per a les entrades';
$string['loginpageautofocus'] = 'Autofocus en el formulari de la pàgina d\'entrada';
$string['loginpageautofocus_help'] = 'En activar aquesta opció, es millora la usabilitat de la pàgina d\'inici de sessió, però els camps que enfoca automàticament es poden considerar un problema d\'accessibilitat.';
$string['loginpasswordautocomplete'] = 'Evita la compleció automàtica de la contrasenya en el formulari d\'entrada.';
$string['loginpasswordautocomplete_help'] = 'Si teniu desactivada aquesta opció els usuaris podran desar la contrasenya del compte en el seu navegador. Si activeu  aquesta opció el vostre lloc ja no seguirà les normes de validació XHTML estricte.';
$string['loglifetime'] = 'Manté els registres';
$string['longtimewarning'] = '<b>Teniu en compte que aquest procés pot costar molt de temps.</b>';
$string['maintenancemode'] = 'En mode manteniment';
$string['maintenancemodeisscheduled'] = 'El lloc canviarà al mode manteniment en {$a} minuts.';
$string['maintfileopenerror'] = 'S\'ha produït un error en obrir els fitxers de manteniment';
$string['maintinprogress'] = 'El manteniment està en curs...';
$string['manageformats'] = 'Gestiona els formats de curs';
$string['manageformatsgotosettings'] = 'El format per defecte pot canviar-se en {$a}';
$string['managelang'] = 'Gestió';
$string['managelicenses'] = 'Gestiona les llicències';
$string['manageqbehaviours'] = 'Gestiona el comportament de les preguntes';
$string['manageqtypes'] = 'Gestiona els tipus de preguntes';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Candidat per ser publicat';
$string['maturity200'] = 'Versió estable';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Consell: És possible que vulgueu executar aquest script amb l\'opció --allow-unstable';
$string['maturitycoreinfo'] = 'El vostre lloc està executant codi de desenvolupament inestable «{$a}».';
$string['maturitycorewarning'] = 'La versió de Moodle que ara instal·lareu o actualitzareu conté codi de desenvolupament inestable «{$ a}» que no és adequat per al seu ús en la majoria dels llocs de producció.
Si això no és el que voleu assegureu-vos d\'actualitzar a partir d\'una branca ESTABLE del codi de Moodle. Vegeu la documentació de Moodle per a més detalls.';
$string['maxbytes'] = 'Mida màxima de fitxer penjat';
$string['maxconsecutiveidentchars'] = 'Caràcters consecutius idèntics';
$string['maxeditingtime'] = 'Límit de temps per a editar missatges';
$string['maxusersperpage'] = 'Nombre màxim d\'usuaris per pàgina';
$string['mbstringrecommended'] = 'És summament recomanable instal·lar la biblioteca opcional MBSTRING a fi de millorar el rendiment del lloc, especialment si el vostre lloc utilitza llengües no romàniques.';
$string['mediapluginavi'] = 'Habilita el filtre .avi';
$string['mediapluginflv'] = 'Habilita el filtre .flv';
$string['mediapluginimg'] = 'Habilita l\'autoincrustació d\'imatges enllaçades';
$string['mediapluginmov'] = 'Habilita el filtre .mov';
$string['mediapluginmp3'] = 'Habilita el filtre .mp3';
$string['mediapluginmpg'] = 'Habilita el filtre .mpg';
$string['mediapluginogg'] = 'Habilita el filtre .ogg';
$string['mediapluginogv'] = 'Habilita el filtre .ogv';
$string['mediapluginram'] = 'Habilita el filtre .ram';
$string['mediapluginrm'] = 'Habilita el filtre .rm';
$string['mediapluginrpm'] = 'Habilita el filtre .rpm';
$string['mediapluginswf'] = 'Habilita el filtre .swf';
$string['mediapluginswfnote'] = 'Com a mesura de seguretat per defecte, els usuaris normals no poden incrustar fitxers Flash swf.';
$string['mediapluginwmv'] = 'Habilita el filtre .wmv';
$string['mediapluginyoutube'] = 'Habilita filtres per enllaçar YouTube';
$string['messaging'] = 'Habilita el sistema de missatgeria';
$string['messagingallowemailoverride'] = 'Notificació per correu electrònic sobreescrita';
$string['messagingdeletereadnotificationsdelay'] = 'Suprimeix notificacions llegides';
$string['messaginghidereadnotifications'] = 'Amaga notificacions llegides';
$string['minpassworddigits'] = 'Dígits';
$string['minpasswordlength'] = 'Mida de la contrasenya';
$string['minpasswordlower'] = 'Minúscules';
$string['minpasswordnonalphanum'] = 'Caràcters NO alfanumèrics';
$string['minpasswordupper'] = 'Majúscules';
$string['misc'] = 'Miscel·lània';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> aquesta còpia de seguretat conté comptes d\'usuari remots de Moodle en Xarxa que es restauraran durant el procés.';
$string['mnetrestore_extusers_admin'] = '<strong>Avís:</strong> Aquesta còpia de seguretat sembla provenir d\'una instal·lació diferent de Moodle i conté comptes d\'usuaris d\'un Moodle remot. El procés de restauració intentarà trobar tos els servidors de Moodle per als usuaris creats. Aquells que no concordin seran inhabilitats amb autenticació interna (en lloc de la xarxa primer). El registre de restauració us informarà sobre aquest procés.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> aparentment aquesta còpia de seguretat s\'ha originat en una altra instal·lació de Moodle i conté comptes d\'usuari remots de Moodle en Xarxa que potser no es podran restaurar. Aquest tipus d\'operació no està implementada. Si esteu segur que la còpia es va crear en aquesta instal·lació de Moodle, o us podeu assegurar que estan configurats tots els amfitrions necessaris de Moodle en Xarxa, potser tot i això voldreu intentar la restauració.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Avís:</strong> Aquesta còpia de seguretat sembla provenir d\'una instal·lació diferent de Moodle i conté comptes d\'usuaris d\'un Moodle remot. No esteu habilitats per executar aquest tipus de restauració. Contacteu amb l\'administrador del lloc o, de forma alternativa, restaureu aquest curs sense informació d\'usuaris (mòduls, fitxers...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Usuaris remots de Moodle {$a->username} (que vénen de {$a->mnethosturl} ) canviats a usuaris locals {$a->auth} autenticats.';
$string['mobile'] = 'Mòbil';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Selector d\'activitat per defecte';
$string['modeditdefaults'] = 'Paràmetres per defecte per a la configuració d\'activitats.';
$string['modeditingmenu'] = 'Menús d\'edició d\'activitats';
$string['modeditingmenu_desc'] = 'Si s\'habilita aquesta opció moltes de les icones d\'edició d\'activitats visualitzades quan es mostra un curs amb l\'edició activada es mostraran dins d\'un menú desplegable. Així es redueix el contingut en pantalla mentre s\'edita un curs tot ocultant les icones fins que es necessitin.';
$string['modsettings'] = 'Gestió d\'activitats';
$string['modulesecurity'] = 'Seguretat dels mòduls';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Imposa la sintaxi antiga de continguts multilingües: <span> sense class="multilang" i <lang>';
$string['mustenablestats'] = 'Les estadístiques encara no han estat habilitades en aquest lloc.';
$string['mycoursesperpage'] = 'Nombre de cursos';
$string['mydashboard'] = 'Tauler d\'eines per defecte del sistema';
$string['mymoodle'] = 'El meu Moodle';
$string['mymoodleredirect'] = 'Obliga els usuaris a utilitzar «El meu Moodle»';
$string['mypage'] = 'Pàgina per defecte d\'«El meu Moodle»';
$string['mypagelocked'] = 'Bloqueja la pàgina per defecte.';
$string['myprofile'] = 'Perfil de la pàgina per defecte';
$string['mysql416bypassed'] = 'Tanmateix, si el vostre lloc fa servir NOMÉS llengües romàniques (iso-8859-1), podeu seguir utilitzant el MySQL 4.1.12 (o superior) instal·lat.';
$string['mysql416required'] = 'MySQL 4.1.16 és la versió mínima requerida per Moodle 1.6 a fi de garantir la conversió de totes les dades a UTF-8 en el futur.';
$string['navadduserpostslinks'] = 'Afegir enllaços per veure els missatges de l\'usuari';
$string['navadduserpostslinks_help'] = 'Si habiliteu aquesta opció s\'afegiran dos enllaços a la navegació de cada usuari on veure les discussions que ha començat i els missatges que ha fet en els fòrums en tot el lloc o en cursos específics.';
$string['navcourselimit'] = 'Límit del curs';
$string['navigationupgrade'] = 'Aquesta actualització introdueix dos nous blocs de navegació que substituiran aquests blocs: Administració, Cursos, Activitats i Participants. Si teniu algun permís especial en aquestos blocs hauríeu de comprovar que tot està com volíeu.';
$string['navshowallcourses'] = 'Mostra tots els cursos';
$string['navshowcategories'] = 'Mostra les categories dels cursos';
$string['navshowfrontpagemods'] = 'Mostra les activitats de la pàgina principal en la navegació';
$string['navshowfrontpagemods_help'] = 'Si s\'activa, les activitats de la pàgina principal del curs es mostraran en la navegació a les pàgines del lloc.';
$string['navshowfullcoursenames'] = 'Mostra el noms llargs dels cursos';
$string['navshowfullcoursenames_help'] = 'Si s\'habilita es mostraran el cursos a la barra de navegació amb el seu nom complet en lloc del seu nom curt.';
$string['navshowmycoursecategories'] = 'Mostra les meves categories de curs';
$string['navshowmycoursecategories_help'] = 'Si hi ha cursos habilitats en usuaris, mostra la meva branca de cursos en categories.';
$string['navsortmycoursessort'] = 'Ordena els meus cursos';
$string['navsortmycoursessort_help'] = 'Determina com s\'ordenaran els cursos en la branca «Els meus cursos» dins de la navegació. Per defecte s\'usa l\'ordre predeterminat.';
$string['neverdeleteruns'] = 'No elimineu mai les execucions.';
$string['nobookmarksforuser'] = 'No teniu cap drecera.';
$string['nodatabase'] = 'Cap base de dades';
$string['nohttpsformobilewarning'] = 'Es recomana activar HTTPS amb un certificat vàlid. Moodle sempre tracta d\'utilitzar en primer lloc una connexió segura.';
$string['nomissingstrings'] = 'No hi ha cadenes per traduir';
$string['nonewsettings'] = 'No s\'han afegit nous paràmetres en aquesta actualització.';
$string['nonexistentbookmark'] = 'La drecera que heu sol·licitat no existeix.';
$string['noresults'] = 'No s\'han trobat resultats';
$string['noroles'] = 'Cap perfil';
$string['notifications'] = 'Notificacions';
$string['notifyloginfailures'] = 'Envia les entrades errònies per correu a';
$string['notifyloginthreshold'] = 'Llindar de les notificacions per correu';
$string['notloggedinroleid'] = 'Rol per a usuaris que no hagin iniciat una sessió';
$string['numberofmissingstrings'] = 'Nombre de cadenes per traduir: {$a}';
$string['numberofstrings'] = 'Nombre total de cadenes: {$a->strings}<br />Per traduir: {$a->missing} ({$a->missingpercent} %)';
$string['opcacherecommended'] = 'El sistema de memòria cau de PHP opcode millora el rendiment i redueix els requisits de memòria. L\'extensió OPcache es recomana i és totalment compatible.';
$string['opensslrecommended'] = 'Es recomana instal·lar la biblioteca OpenSSL per habilitar la funcionalitat de Moodle en Xarxa.';
$string['opentogoogle'] = 'Obert a Google';
$string['optionalmaintenancemessage'] = 'Missatge opcional de manteniment';
$string['order1'] = 'Primer';
$string['order2'] = 'Segon';
$string['order3'] = 'Tercer';
$string['order4'] = 'Quart';
$string['passwordpolicy'] = 'Normativa de contrasenyes';
$string['passwordresettime'] = 'Temps màxim per a validar la sol·licitud de restabliment de contrasenya';
$string['pathconvert'] = 'Camí del binari del <i>convert</i>';
$string['pathdvips'] = 'Camí del binari del <i>dvips</i>';
$string['pathlatex'] = 'Camí del binari del <i>latex</i>';
$string['pathtoclam'] = 'Camí de clam AV';
$string['pathtodot'] = 'Camí a dot';
$string['pathtodot_help'] = 'Camí a dot. Probablement alguna cosa com /usr/bin/dot. Per poder generar gràfics des de fitxers DOT, us cal tindre instal·lat l\'executable dot i anotar-lo aquí. Fixeu-vos que, per ara, això sols s\'utilitza per les característiques dels perfils (Desenvolupament -> Perfils ) construïts dins de Moodle.';
$string['pathtodu'] = 'Camí de du';
$string['pathtopgdump'] = 'Camí de pg_dump';
$string['pathtopgdumpdesc'] = 'Només cal definir aquest paràmetre en cas que tingueu diferents pg_dump en el vostre sistema (per exemple si teniu instal·lades diferents versions de postgresql)';
$string['pathtopgdumpinvalid'] = 'El camí de pg_dump no és vàlid. El fitxer no es troba en aquest camí o no és executable.';
$string['pathtopsql'] = 'Camí de psql';
$string['pathtopsqldesc'] = 'Només cal definir aquest paràmetre en cas que tingueu diferents psql en el vostre sistema (per exemple si teniu instal·lades diferents versions de postgresql)';
$string['pathtopsqlinvalid'] = 'El camí de psql no és vàlid. El fitxer no es troba en aquest camí o no és executable.';
$string['pcreunicodewarning'] = 'És molt recomanable utilitzar l\'extensió PCRE de PHP que és compatible amb caràcters Unicode.';
$string['perfdebug'] = 'Informació d\'execució';
$string['performance'] = 'Execució';
$string['pgcluster'] = 'Grup PostgreSQL';
$string['pgclusterdescription'] = '<pre>Paràmetre de grup/versió PostgreSQL
per a operacions de línia de comandament.
Si només teniu un postgresql en el vostre
sistema o no esteu segur de què significa
això, deixeu el paràmetre en blanc.</pre>';
$string['php50restricted'] = 'PHP 5.0 té alguns problemes coneguts. Actualitzeu-vos a 5.1.x o torneu a 4.3.x o 4.4.x';
$string['php533warning'] = 'Es recomana el PHP 5.3.3 i posterior';
$string['phpfloatproblem'] = 'S\'ha detectat un problema inesperat en la manipulació de números en coma flotant dins del PHP - {$a}';
$string['pleaserefreshregistration'] = 'El vostre lloc està registrat en moodle.org. Considereu la possibilitat d\'actualitzar el registre si hi ha hagut canvis significatius des de la darrera actualització ({$a}).';
$string['pleaseregister'] = 'Registreu el vostre lloc per eliminar aquest botó';
$string['plugin'] = 'Connector';
$string['plugins'] = 'Connectors';
$string['pluginscheck'] = 'Comprovació de dependències del connector';
$string['pluginscheckfailed'] = 'La comprovació de dependències ha fallat per a {$a->pluginslist}';
$string['pluginschecktodo'] = 'Cal que resolgueu tots els requeriments del connector abans d\'instal·lar aquesta versió de Moodle.';
$string['pluginsoverview'] = 'Visualització dels connectors';
$string['pluginsoverviewsee'] = 'Per a més informació vegeu la pàgina de <a href="{$a->url}">resum de connectors </a>.';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nom de la categoria (ha de ser únic)';
$string['profilecategorynamenotunique'] = 'Aquest nom ja s\'està utilitzant per a una altra categoria';
$string['profilecommonsettings'] = 'Paràmetres comuns';
$string['profileconfirmcategorydeletion'] = 'Hi ha {$a} camp/s en aquesta categoria que es mouran a la categoria anterior (o a la següent, si es tracta de la primera categoria).<br />Segur que voleu suprimir aquesta categoria?';
$string['profileconfirmfielddeletion'] = 'Hi ha {$a} registres d\'usuari per a aquest camp que seran suprimits.<br />Segur que voleu suprimir aquest camp?';
$string['profilecreatecategory'] = 'Crea una nova categoria de perfil';
$string['profilecreatefield'] = 'Crea un nou camp de perfil:';
$string['profilecreatenewcategory'] = 'S\'està creant una nova categoria';
$string['profilecreatenewfield'] = 'Crea un nou camp «{$a}» de rendiment';
$string['profiledefaultcategory'] = 'Altres camps';
$string['profiledefaultchecked'] = 'Marcat per defecte';
$string['profiledefaultdata'] = 'Valor per defecte';
$string['profiledeletecategory'] = 'S\'està suprimint una categoria';
$string['profiledeletefield'] = 'S\'està suprimint el camp «{$a}»';
$string['profiledescription'] = 'Descripció del camp';
$string['profiledscript'] = 'Aquest script s\'ha perfilat';
$string['profiledscriptview'] = 'Visualitza la informació del perfil per aquest script';
$string['profileeditcategory'] = 'S\'està editant la categoria: {$a}';
$string['profileeditfield'] = 'S\'està editant el camp de perfil: {$a}';
$string['profilefield'] = 'Camp de rendiment';
$string['profilefieldcolumns'] = 'Columnes';
$string['profilefieldispassword'] = 'És un camp de contrasenya?';
$string['profilefieldlink'] = 'Enllaç';
$string['profilefieldlink_help'] = 'Per transformar el text en un enllaç, introduïu un URL que contingui $$, on $$ és reemplaçat pel text. Per exemple, per transformar un ID de Twitter en un enllaç, introduïu http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Objectiu de l\'enllaç';
$string['profilefieldmaxlength'] = 'Longitud màxima';
$string['profilefieldrows'] = 'Files';
$string['profilefields'] = 'Camps del perfil d\'usuari';
$string['profilefieldsize'] = 'Mida de visualització';
$string['profileforceunique'] = 'Dades úniques?';
$string['profileinvaliddata'] = 'El valor no és vàlid';
$string['profilelocked'] = 'Està blocat aquest camp?';
$string['profilemenudefaultnotinoptions'] = 'El valor per defecte no és una de les opcions';
$string['profilemenunooptions'] = 'No heu proporcionat opcions';
$string['profilemenuoptions'] = 'Opcions del menú (una per línia)';
$string['profilemenutoofewoptions'] = 'Heu de proporcionar almenys dues opcions';
$string['profilename'] = 'Nom';
$string['profilenofieldsdefined'] = 'No s\'han definit camps';
$string['profilerequired'] = 'Aquest camp és obligatori?';
$string['profileroles'] = 'Rols visibles dels perfils';
$string['profilesforenrolledusersonly'] = 'Perfils sols dels usuaris enregistrats';
$string['profileshortname'] = 'Nom curt (ha de ser únic)';
$string['profileshortnamenotunique'] = 'Aquest nom curt ja existeix';
$string['profilesignup'] = 'Cal visualitzar a la pàgina de registre?';
$string['profilespecificsettings'] = 'Paràmetres específics';
$string['profilevisible'] = 'Per a qui és visible aquest camp?';
$string['profilevisibleall'] = 'Visible per a tothom';
$string['profilevisible_help'] = '* No visible - Dades privades sols visibles per als administradors
* Visible per als usuaris - Dades privades sols visibles per als usuaris i administradors
* Visible per a tothom';
$string['profilevisiblenone'] = 'Invisible';
$string['profilevisibleprivate'] = 'Visible per a usuaris';
$string['profiling'] = 'Anàlisi de rendiment';
$string['profilingallowall'] = 'Anàlisi de rendiment continuat';
$string['profilingallowall_help'] = 'Si habiliteu aquest paràmetre,  de moment podreu utilitzar el paràmetre PROFILEALL en qualsevol lloc (PGC) per activar l\'anàlisi de rendiment per tots els scripts executats per la sessió de Moodle actual. De forma anàloga podeu utilitzar el paràmetre  PROFILEALLSTOP per aturar-lo.';
$string['profilingallowme'] = 'Anàlisi de rendiment selectiu';
$string['profilingallowme_help'] = 'Si habiliteu aquest paràmetre, podreu utilitzar el paràmetre PROFILEME en qualsevol lloc (PGC) i analitzar el rendiment de forma selectiva dels scripts. De forma anàloga podeu utilitzar el paràmetre DONTPROFILEME per impedir l\'anàlisi de rendiment.';
$string['profilingautofrec'] = 'Anàlisi de rendiment automàtic';
$string['profilingautofrec_help'] = 'Configurant aquest paràmetre, s\'escolliran algunes peticions (de forma aleatòria i basades en la freqüència especificada - 1 de N) i s\'analitzarà el rendiment de forma automàtica; els resultats s\'emmagatzemaran per a anàlisis addicionals. Noteu que aquesta forma d\'anàlisi de rendiment compleix el paràmetres inclou/exclou. Poseu aquest paràmetre a 0 per inhabilitar l\'anàlisi de rendiment automàtic.';
$string['profilingenabled'] = 'Habilita l\'anàlisi de rendiment';
$string['profilingenabled_help'] = 'Si habiliteu aquest paràmetre, llavors l\'anàlisi de rendiment estarà disponible en aquest lloc i podreu definir el comportament configurant les següents opcions.';
$string['profilingexcluded'] = 'Exclou l\'anàlisi de rendiment';
$string['profilingexcluded_help'] = 'Llista d\'URL (separats per comes, excloent wwwrot, accessibles) que seran exclosos de l\'anàlisi de rendiment definit pel paràmetre \'anàlisi de rendiment de\'';
$string['profilingimportprefix'] = 'Prefix per la importació de rendiments';
$string['profilingimportprefix_desc'] = 'Per a una fàcil detecció, totes les anàlisis de rendiment tindran el prefix especificat aquí.';
$string['profilingincluded'] = 'Anàlisi de rendiment de';
$string['profilingincluded_help'] = 'Llista d\'URL (separats per comes, excloent wwwrot, accessibles) que seran inclosos de forma automàtica en l\'anàlisi de rendiment. Exemples: /index.php, /course/view.php. També accepta el caràcter asterisc  en qualsevol posició. Exemples: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Manteniu el perfil que s\'executa';
$string['profilinglifetime_help'] = 'Especifiqueu la data sobre la qual  mantenir informació de l\'execució dels perfils antics. Els més antics es purguen de forma periòdica. Fixeu-vos que això exclou qualsevol perfil marcat com a \'execució de referència\'.';
$string['protectusernames'] = 'Protegeix els noms d\'usuari';
$string['proxybypass'] = 'Adreces sense intermediari';
$string['proxyhost'] = 'Ordinador intermediari';
$string['proxypassword'] = 'Contrasenya de l\'intermediari';
$string['proxyport'] = 'Port intermediari';
$string['proxytype'] = 'Tipus d\'intermediari';
$string['proxyuser'] = 'Nom d\'usuari de l\'intermediari';
$string['purgecaches'] = 'Buida totes les memòries cau';
$string['purgecachesconfirm'] = 'Moodle pot desar a la memòria cau temes, javascript, cadenes d\'idioma, text filtrat, canals RSS i moltes altres porcions de dades calculades. En esborrar aquests elements de la memòria cau, us assegureu que els navegadors estan recollint les versions més actualitzades produïdes pel codi actual. Esborrar la memòria cau no suposa cap perill, però el vostre lloc pot resultar més lent durant un temps fins que les noves dades s\'hagin computat i desat a la memòria cau.';
$string['purgecachesfinished'] = 'S\'han buidat totes les memòries cau';
$string['qtyperqpwillberemoved'] = 'Durant l\'actualització, el tipus de pregunta RPQ se suprimirà. No estàveu utilitzant aquest tipus de pregunta, de manera que no hauríeu d\'experimentar cap problema.';
$string['qtyperqpwillberemovedanyway'] = 'Durant l\'actualització, el tipus de pregunta RPQ se suprimirà. Teniu algunes preguntes RQP en la base de dades que deixaran de funcionar si no reinstal·leu el codi de http://moodle.org/mod/data/view.php?d=13&amp;rid=797 abans de prosseguir l\'actualització.';
$string['quarantinedir'] = 'Directori de quarantena';
$string['question'] = 'Pregunta';
$string['questionbehaviours'] = 'Comportament de les preguntes';
$string['questioncwqpfscheck'] = 'Una o més preguntes «aleatòries» d\'algun qüestionari s\'han definit per seleccionar preguntes d\'una barreja de categories compartides i no compartides. Vegeu-ne informació més detallada <a href="{$a->reporturl}">aquí</a>. Vegeu també aquesta <a href="{$a->docsurl}">pàgina</a> de Moodle Docs.';
$string['questioncwqpfsok'] = 'D\'acord. No teniu cap pregunta «aleatòria» en els vostres qüestionaris que seleccioni preguntes d\'una barreja de categories compartides i no compartides.';
$string['questiontype'] = 'Tipus de pregunta';
$string['questiontypes'] = 'Tipus de preguntes';
$string['quizattemptsupgradedmessage'] = 'En la versió Moodle 2.1 va haver-hi una actualització important de les preguntes. Llavors era possible ajornar l\'actualització d\'una part de la base dades. Abans d\'actualitzar a Moodle 2.7 cal completar aquesta actualització.';
$string['recaptchaprivatekey'] = 'Clau privada de ReCAPTCHA';
$string['recaptchapublickey'] = 'Clau pública de ReCAPTCHA';
$string['register'] = 'Registreu el vostre lloc';
$string['registermoodleorg'] = 'Quan registreu el vostre lloc amb {$a}';
$string['registermoodleorgli1'] = 'Heu estat afegits en una llista de correu de baix volum per a notificacions importants com ara alertes de seguretat i nous llançaments de Moodle';
$string['registermoodleorgli2'] = 'Les estadístiques sobre el vostre lloc s\'afegiran a les {$a} de la comunitat Moodle de tot el món.';
$string['registermoodleorgli3'] = 'El vostre lloc també està registrat a Moodle.net ({$a}), la qual cosa permet als usuaris amb la capacitat de publicar cursos (per defecte, només els administradors) l\'opció de publicar cursos a Moodle.net.';
$string['registerwithmoodleorg'] = 'Registra en Moodle.org';
$string['registration'] = 'Registre';
$string['registration_help'] = 'Us recomanem registrar-vos a Moodle.org per rebre les alertes de seguretat per correu electrònic, per contribuir a les <a href="http://moodle.org/stats">estadístiques d\'ús de Moodle</a>, o per poder compartir cursos en <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'El vostre lloc encara no està registrat.';
$string['releasenoteslink'] = 'Consulteu la informació sobre aquesta versió de Moodle en les <a target="_new" href="{$a}">Notes de llançament</a>';
$string['rememberusername'] = 'Recorda el nom d\'usuari';
$string['rememberusername_desc'] = 'Habiliteu aquesta opció si voleu guardar les galetes permanents amb els noms d\'usuari durant l\'inici de sessió. Les galetes permanents poden ser considerades un problema de privacitat si s\'utilitzen sense el seu consentiment.';
$string['reportsmanage'] = 'Gestiona informes';
$string['requestcategoryselection'] = 'Habilita la selecció de categories';
$string['requiredentrieschanged'] = '<strong>IMPORTANT - LLEGIU<br/>(Aquest avís sols es mostra durant l\'actualització)</strong><br/> A causa d\'un un error, el comportament de les activitats quan s\'utilitzen els paràmetres \'entrades requerides\' i \'entrades requerides abans de veure els paràmetres\' han canviat. Podeu llegir una explicació més detallada dels canvis al  <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">mòdul fòrum de la base de dades</a>. El comportament esperat d\'aquests canvis pot llegir-se als <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">documents de Moodle</a>. <br/><br/>Aquest canvi afecta les següents bases de dades del vostre sistema: (Anomeneu i deseu aquesta llista ara, i després de l\'actualització comproveu que aquestes activitats encara funcionen de la forma que els professors esperen.) <br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Requereix una descripció de l\'activitat';
$string['requires'] = 'Requereix';
$string['restorernewroleid'] = 'Rol de Restaurador als cursos';
$string['restorernewroleid_help'] = 'Si l\'usuari no té el permís per administrar el curs acabat de restaurar, se li assigna automàticament aquesta funció i se l\'inscriu al curs si fos necessari. Seleccioneu «Cap» si no voleu que els restauradors puguin gestionar tots els cursos restaurats.';
$string['reverseproxy'] = 'Proxy invers';
$string['riskconfig'] = 'Els usuaris podrien canviar la configuració i comportament del lloc';
$string['riskconfigshort'] = 'Risc de configuració';
$string['riskdataloss'] = 'Els usuaris podrien destruir grans quantitats de contingut o d\'informació';
$string['riskdatalossshort'] = 'Risc de pèrdua de dades';
$string['riskmanagetrust'] = 'Els usuaris podrien canviar paràmetres de confiança d\'altres usuaris';
$string['riskmanagetrustshort'] = 'Gestiona confiança';
$string['riskpersonal'] = 'Els usuaris podrien obtenir accés a informació privada d\'altres usuaris';
$string['riskpersonalshort'] = 'Risc de privadesa';
$string['riskspam'] = 'Els usuaris podrien enviar correu brossa a usuaris del lloc o a altres';
$string['riskspamshort'] = 'Risc de brossa';
$string['riskxss'] = 'Els usuaris podrien afegir textos i fitxers que permetessin cross-site scripting (XSS)';
$string['riskxssshort'] = 'Risc XSS';
$string['roleswithexceptions'] = '{$a->roles}, amb {$a->exceptions}';
$string['rssglobaldisabled'] = 'Inhabilitat al nivell del servidor';
$string['runclamavonupload'] = 'Utilitza clam AV en els fitxers que es pengin';
$string['save'] = 'Desa';
$string['savechanges'] = 'Desa els canvis';
$string['search'] = 'Cerca';
$string['searchinsettings'] = 'Cerca en paràmetres';
$string['searchresults'] = 'Resultats de la cerca';
$string['sectionerror'] = 'Error en la secció!';
$string['secureforms'] = 'Utilitza seguretat addicional als formularis';
$string['security'] = 'Seguretat';
$string['selectdevice'] = 'Selecciona dispositiu';
$string['selecttheme'] = 'Selecciona tema per al dispositiu {$a}';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Comprovacions del servidor';
$string['serverlimit'] = 'Límit del servidor';
$string['sessionautostartwarning'] = '<p>S\'ha detectat un greu error de configuració, notifiqueu-ho a l\'administrador del servidor.</p> Perquè funcioni correctament, Moodle requereix que l\'administrador modifiqui la configuració de PHP.</p><code> session.auto_start </ code> s\'ha d\'establir a <code>off</code>.</p> Aquesta configuració es controla editant el fitxer <code>php.ini</code>, la configuració Apache/IIS <br /> o el fitxer <code>.htaccess</code> al servidor.</p>';
$string['sessioncookie'] = 'Prefix de la galeta';
$string['sessioncookiedomain'] = 'Domini de galeta';
$string['sessioncookiepath'] = 'Camí de la galeta';
$string['sessionhandling'] = 'Gestió de sessions';
$string['sessiontimeout'] = 'Temps d\'espera';
$string['settingfileuploads'] = 'L\'enviament de fitxers és necessari per a un funcionament normal. Habiliteu-lo en els paràmetres de PHP.';
$string['settingmemorylimit'] = 'S\'ha detectat una mida de memòria insuficient. Establiu un límit de memòria més alt als paràmetres del PHP.';
$string['settingsafemode'] = 'Moodle no és del tot compatible amb el mode segur. Demaneu a l\'administrador del servidor que el desactivi. Executar Moodle sota el mode segur no està admès. Si ho feu podeu esperar diversos problemes.';
$string['showcommentscount'] = 'Mostra el nombre de comentaris';
$string['showdetails'] = 'Mostra els detalls';
$string['showuseridentity'] = 'Mostra la identitat de l\'usuari';
$string['showuseridentity_desc'] = 'Es poden mostrar aquests camps, a més del seu nom complet, quan se seleccionin o busquin usuaris i quan es mostrin llistes d\'usuaris.  Els camps només es mostren als usuaris que tenen el permís moodle/site:viewuseridentity; per defecte, els professors i els administradors de curs. (Aquesta opció té més sentit si trieu un o dos camps obligatoris de la vostra institució.)';
$string['simplexmlrequired'] = 'Ara Moodle requereix l\'extensió de PHP SimpleXML.';
$string['sitemaintenance'] = 'S\'estan executant tasques de manteniment i el lloc no està disponible';
$string['sitemaintenancemode'] = 'Mode de manteniment';
$string['sitemaintenanceoff'] = 'El mode de manteniment ha estat inhabilitat i el lloc torna a funcionar amb normalitat';
$string['sitemaintenanceon'] = 'El vostre lloc està en mode de manteniment (només poden entrar-hi els administradors)';
$string['sitemaintenanceoncli'] = 'El vostre lloc està en mode de manteniment CLI, i no es permet cap accés web.';
$string['sitemaintenancewarning'] = 'El vostre lloc està en mode de manteniment (només poden entrar-hi els administradors). Per tornar al mode d\'operació normal, <a href="maintenance.php">desactiveu el mode mateniment</a>.';
$string['sitemaintenancewarning2'] = 'El vostre lloc està actualment en mode de manteniment (només poden entrar-hi els administradors). Per tal de tornar el lloc al seu funcionament normal, <a href="{$a}">inhabiliteu el mode de manteniment</a>.';
$string['sitepolicies'] = 'Normatives del lloc';
$string['sitepolicy'] = 'URL de la normativa del lloc';
$string['sitepolicyguest'] = 'URL de la política del lloc per a convidats';
$string['sitepolicyguest_help'] = 'Si teniu una política de lloc que tots els convidats hagin de veure i acceptar abans d\'usar el lloc, especifiqueu aquí l\'URL que hi apunta. Altrament deixeu aquest camp en blanc. Aquest paràmetre poc contenir qualsevol URL públic. Nota: pot passar que el paràmetre \'forcelogin\' impedeixi l\'accés als usuaris no registrats.';
$string['sitepolicy_help'] = 'Si teniu unes normes del lloc que tots els usuaris han de veure i signar abans d\'usar el lloc, especifiqueu-ne aquí l\'URL. Si no, deixeu el camp en blanc. L\'URL pot ser una adreça qualsevol, p. ex. l\'adreça d\'un fitxer dels fitxers del lloc, p. ex. http://elvostrelloc/file.php/1/normes.html';
$string['sitesectionhelp'] = 'Si activeu aquesta opció, es mostrarà una secció de tema a la primera plana del lloc.';
$string['slasharguments'] = 'Utilitza arguments en barra';
$string['smartpix'] = 'Cerca intel·ligent d\'imatges';
$string['soaprecommended'] = 'Instal·lar l\'extensió opcional SOAP és útil per als serveis web i alguns mòduls no oficials.';
$string['sort_fullname'] = 'Nom complet del curs';
$string['sort_idnumber'] = 'Número ID del curs';
$string['sort_shortname'] = 'Nom curt del curs';
$string['sort_sortorder'] = 'Ordre';
$string['spellengine'] = 'Motor d\'ortografia';
$string['spelllanguagelist'] = 'Llista d\'idiomes';
$string['splrequired'] = 'Ara el Moodle requereix l\'extensió de PHP SPL.';
$string['stats'] = 'Estadístiques';
$string['statsfirstrun'] = 'Interval màxim de processament';
$string['statsmaxruntime'] = 'Temps màxim d\'execució';
$string['statsmoodleorg'] = 'estadístiques';
$string['statsruntimedays'] = 'Dies a processar';
$string['statsruntimestart'] = 'Executat en';
$string['statsuserthreshold'] = 'Llindar d\'usuari';
$string['stickyblocks'] = 'Blocs fixos';
$string['stickyblockscourseview'] = 'Pàgina de curs';
$string['stickyblocksduplicatenotice'] = 'Si qualsevol bloc que afegiu aquí ja és present en una pàgina, en resultarà un duplicat.<br />Només el bloc fix serà no editable. El duplicat sí que es podrà editar.';
$string['stickyblocksmymoodle'] = 'El meu Moodle';
$string['stickyblockspagetype'] = 'Tipus de pàgina a configurar';
$string['strictformsrequired'] = 'Validació estricta dels camps obligatoris';
$string['stripalltitletags'] = 'Elimina les etiquetes HTML de tots els noms de les activitats';
$string['supportcontact'] = 'Contacte de suport';
$string['supportemail'] = 'Correu de suport';
$string['supportname'] = 'Nom de suport';
$string['supportpage'] = 'Pàgina de suport';
$string['suspenduser'] = 'Suspendre el compte d\'usuari';
$string['switchlang'] = 'Commuta directori d\'idioma';
$string['systempaths'] = 'Camins del sistema';
$string['tablenosave'] = 'Els canvis a la taula de dalt es desen de manera automàtica.';
$string['tablesnosave'] = 'Els canvis a les taules de dalt es desen de manera automàtica.';
$string['tabselectedtofront'] = 'En taules amb tabulacions, la fila amb l\'etiqueta seleccionada s\'hauria de posar davant';
$string['tabselectedtofronttext'] = 'Passa davant la fila seleccionada';
$string['testsiteupgradewarning'] = 'Esteu utilitzant el lloc de prova {$a}. Per a actualitzar de forma correcta utilitzeu l\'eina d\'interfície de línia d\'ordres.';
$string['themedesignermode'] = 'Mode de dissenyador de temes';
$string['themelist'] = 'Llista de temes';
$string['themenoselected'] = 'No hi ha cap tema seleccionat ';
$string['themeresetcaches'] = 'Buida la memòria cau dels temes';
$string['themeselect'] = 'Canvia el tema';
$string['themeselector'] = 'Selector de temes';
$string['themesettings'] = 'Paràmetres de tema';
$string['therewereerrors'] = 'Hi ha errors en aquestes dades';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Ubicació';
$string['thirdpartylibs'] = 'Biblioteques de tercers';
$string['timezone'] = 'Zona horària per defecte';
$string['timezoneforced'] = 'Imposada per l\'administrador del lloc';
$string['timezoneisforcedto'] = 'Imposa a tots els usuaris';
$string['timezonenotforced'] = 'Els usuaris poden triar la seva zona horària';
$string['tokenizerrecommended'] = 'Es recomana instal·lar l\'extensió opcional PHP Tokenizer per millorar la funcionalitat de Moodle en Xarxa.';
$string['tools'] = 'Eines d\'administrador';
$string['toolsmanage'] = 'Gestiona les eines d\'administrador';
$string['unattendedoperation'] = 'Operació no interactiva';
$string['unbookmarkthispage'] = 'Suprimeix aquesta drecera';
$string['unicoderecommended'] = 'Es recomana emmagatzemar totes les dades en Unicode (UTF-8). Les noves instal·lacions s\'haurien de realitzar en bases de dades que tinguin definit com a Unicode el conjunt de caràcters per defecte. Si esteu fent una actualització, hauríeu de passar el procés de migració a UTF-8 (vg. la pàgina d\'Administració).';
$string['unicoderequired'] = 'Es requereix emmagatzemar totes les dades en format Unicode (UTF-8). Les noves instal·lacions s\'han de realitzar en bases de dades que tinguin definit com a Unicode el conjunt de caràcters per defecte. Si esteu fent una actualització, hauríeu de passar el procés de migració a UTF-8 (vg. la pàgina d\'Administració).';
$string['uninstallplugin'] = 'Desinstal·la';
$string['unlockaccount'] = 'Desbloca el compte';
$string['unsettheme'] = 'Inhabilita el tema';
$string['unsupported'] = 'No implementat';
$string['unsuspenduser'] = 'Activeu el compte d\'usuari';
$string['updateaccounts'] = 'Actualitza els comptes existents';
$string['updateautocheck'] = 'Comprova automàticament si hi ha actualitzacions disponibles';
$string['updateautocheck_desc'] = 'Si està activat, el vostre lloc comprovarà automàticament si hi ha actualitzacions disponibles per al codi de Moodle i per a tots els connectors addicionals. Si hi ha una nova actualització disponible, s\'enviarà una notificació als administradors del lloc.';
$string['updateautodeploy'] = 'Habilita el desplegament d\'actualitzacions';
$string['updateautodeploy_desc'] = 'Si s\'habilita, podreu baixar i instal·lar actualitzacions disponibles directament des de les pàgines d\'administració de Moodle. Fixeu-vos que, perquè això funcioni, el procés del vostre servidor web ha de tenir permís d\'escriptura en les carpetes d\'instal·lació de Moodle. Això és un risc de seguretat en potència.';
$string['updateavailable'] = 'Hi ha disponible una versió de Moodle més recent!';
$string['updateavailabledetailslink'] = 'Vegeu {$a->url} per obtenir més detalls';
$string['updateavailableforplugin'] = 'Hi ha disponible una versió més recent d\'alguns dels vostres connectors!';
$string['updateavailableinstall'] = 'Instal·la aquesta actualització';
$string['updateavailable_moreinfo'] = 'Més informació...';
$string['updateavailablenot'] = 'El codi del vostre Moodle està actualitzat!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versió {$a}';
$string['updatecomponent'] = 'Actualitza component';
$string['updateminmaturity'] = 'Maduresa del codi requerida';
$string['updateminmaturity_desc'] = 'Notifica les actualitzacions disponibles només si el codi disponible té el nivell de maduresa seleccionat com a mínim. Les actualitzacions per als connectors que no declaren el seu nivell de maduresa de codi es comuniquen sempre sense tenir en compte aquest paràmetre.';
$string['updatenotificationfooter'] = 'El vostre lloc Moodle {$a->siteurl} està configurat per a comprovar automàticament si hi ha actualitzacions disponibles. Rebeu aquest missatge com a administrador del lloc. Podeu desactivar la comprovació automàtica d\'actualitzacions disponibles a l\'apartat d\'Administració del lloc, del bloc de Configuració. Podeu personalitzar el lliurament d\'aquest missatge des de la vostra Missatgeria a l\'apartat Configuració del meu perfil, del bloc Configuració.';
$string['updatenotifications'] = 'Notificacions d\'actualització';
$string['updatenotificationsubject'] = 'Hi ha actualitzacions de Moodle disponibles ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notifica\'m l\'aparició de noves compilacions';
$string['updatenotifybuilds_desc'] = 'Si s\'habilita, s\'informarà quan hi hagi una actualització per Moodle que sigui una nova compilació de la versió actual. Les compilacions són millores contínues d\'una versió de Moodle. En general s\'alliberen setmanalment. Si s\'inhabilita sols s\'informarà quan una nova versió de Moodle hagi estat alliberada. La comprovació de connectors no està afectada per aquest paràmetre.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 conté un nombre de millores de seguretat a les contrasenyes dels usuaris i a les còpies de seguretat per protegir les dades d\'usuari del vostre lloc web. En conseqüència han canviat alguns dels paràmetres i permisos de les còpies de seguretat. <br /> Mireu les <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">notes de llançament de Moodle 1.9.7 </a> per llegir tots els detalls.</p>
';
$string['upgrade197noticesubject'] = 'Avisos d\'actualització de seguretat  de Moodle 1.9.7';
$string['upgrade197salt'] = 'Per reduir el risc de furt de la contrasenya, es recomana de forma seriosa que configureu una contrasenya forta. <br />Mireu la <a href="{$a}" target="_blank">documentació de contrasenyes xifrades </a> per a més informació.';
$string['upgradeerror'] = 'Error d\'actualització desconegut. L\'actualització de la versió {$a->plugin} a la versió {$a->version} no pot continuar.';
$string['upgradeforumread'] = 'S\'ha afegit una nova característica en Moodle 1.5 per fer el seguiment dels missatges llegits/no llegits dels fòrums.<br />Per utilitzar aquesta funcionalitat necessiteu <a href="{$a}">actualitzar les taules</a>.';
$string['upgradeforumreadinfo'] = 'S\'ha afegit una nova característica en Moodle 1.5 per fer el seguiment dels missatges llegits/no llegits dels fòrums. Per utilitzar aquesta funcionalitat necessiteu actualitzar les taules amb tota la informació de seguiment dels missatges actuals. Segons la mida del vostre lloc això pot durar una bona estona (hores) i pot carregar bastant la base de dades, així que és millor fer-ho durant un període tranquil. Tanmateix el vostre lloc continuarà funcionant durant l\'actualització i els els usuaris no es veuran afectats. Una vegada hàgiu engegat aquest procés haureu de deixar que acabi (mantenint oberta la finestra del navegador). Però si atureu el procés tancant la finestra, no cal que us amoïneu: podeu iniciar el procés una altra vegada.<br /><br />Voleu iniciar ara el procés d\'actualització?';
$string['upgradelogs'] = 'Per a disposar de totes les funcionalitats, els vostres registres s\'han d\'actualitzar. <a href="{$a}">Més informació</a>';
$string['upgradelogsinfo'] = 'S\'han introduït alguns canvis en la manera d\'emmagatzemar els registres. Per tal de poder veure tots els vostres registres vells per activitat, els vostres registres vells s\'han d\'actualitzar. Depenent del vostre servidor això pot trigar una bona estona (unes quantes hores) i en una instal·lació gran pot carregar una mica la base de dades. Una vegada hàgiu engegat aquest procés haureu de deixar que acabi (mantenint la finestra del navegador oberta). No us amoïneu: el vostre lloc seguirà actiu per als usuaris mentre els registres s\'actualitzen. <br /><br />Voleu actualitzar els registres ara?';
$string['upgradepluginsfirst'] = 'Heu de descarregar i instal·lar les actualitzacions disponibles manualment';
$string['upgradepluginsinfo'] = 'S\'estan actualitzant els connectors';
$string['upgradepluginsinfo_help'] = 'Hi ha actualitzacions disponibles per a alguns dels vostres connectors. Hauríeu d\'instal·lar-los tots abans d\'actualitzar la base de dades de Moodle. Si el vostre lloc no admet el desplegament automàtic d\'actualitzacions, haureu de descarregar les noves versions dels connectors i instal·lar-les al vostre servidor de forma manual.';
$string['upgradesettings'] = 'Nous paràmetres';
$string['upgradesettingsintro'] = 'Els paràmetres que es mostren a continuació han estat afegits en la darrera actualització de Moodle. Feu els canvis necessaris en els valors per defecte i tot seguit feu clic a «Desa els paràmetres» al capdavall de la pàgina.';
$string['upgradestalefiles'] = 'S\'han detectat fitxers d\'instal·lació no vàlids, l\'actualització no pot continuar.';
$string['upgradestalefilesinfo'] = 'El procés d\'actualització de Moodle s\'ha aturat perquè s\'han detectat scripts PHP d\'almenys dues versions diferents de Moodle en el directori Moodle.

Això pot causar problemes significatius més endavant, de manera que, abans de continuar, us heu d\'assegurar que el directori Moodle només conté fitxers d\'una sola versió de Moodle.

La manera recomanada de netejar el directori Moodle és la següent:

* Canvieu el nom del directori Moodle actual a «moodle_old»
* Creeu un directori Moodle nou que contingui només els fitxers nous d\'un paquet estàndard de baixada de Moodle o dels repositoris CVS o GIT
* Traslladeu el fitxer config.php original i qualssevol connectors no estàndard des del directori «moodle_old» al nou directori Moodle

Quan tingueu un directori Moodle net, refresqueu aquesta pàgina per reprendre el procés d\'actualització de Moodle.

Aquesta advertència és sovint causada per haver descomprimit un paquet estàndard de Moodle damunt d\'una versió anterior de Moodle. Per a actualitzacions menors això no té cap importància, però es desaconsella per a actualitzacions importants de Moodle.

Aquesta advertència també pot ser causada per una transacció incompleta des del repositori Git, en el qual cas és possible que simplement hàgiu d\'esperar que l\'operació es completi, o potser executar l\'ordre de neteja corresponent i tornar a intentar l\'operació.

Podeu trobar més informació en la documentació d\'actualització a <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Actualitza la base de dades de Moodle ara';
$string['upgradesure'] = 'Els vostres fitxers de Moodle han canviat i ara actualitzareu automàticament el servidor a aquesta versió:<p><b>{$a}</b></p><p>Després de fer això no podreu tornar enrere.</p><p>Esteu segur que voleu actualitzar aquest servidor a aquesta versió?</p>';
$string['upgradetimedout'] = 'L\'actualització ha exhaurit el temps d\'espera. Reinicieu-la.';
$string['upgradingdata'] = 'S\'estan actualitzant les dades';
$string['upgradinglogs'] = 'S\'estan actualitzant els registres';
$string['upgradingversion'] = 'S\'està actualitzant a la nova versió';
$string['upwards'] = 'cap amunt';
$string['useblogassociations'] = 'Habilita les associacions';
$string['useexternalyui'] = 'Utilitza les llibreries YUI en línia';
$string['user'] = 'Usuari';
$string['userbulk'] = 'Accions amb usuaris en bloc';
$string['userlist'] = 'Explora la llista d\'usuaris';
$string['userpolicies'] = 'Política d\'usuaris';
$string['userpreference'] = 'Preferència d\'usuari';
$string['userquota'] = 'Quota d\'usuari';
$string['users'] = 'Usuaris';
$string['usesitenameforsitepages'] = 'Utilitza el nom del lloc per a les pàgines del lloc';
$string['usetags'] = 'Habilita la funcionalitat d\'etiquetes';
$string['validateerror'] = 'Aquest valor no és vàlid:';
$string['verifychangedemail'] = 'Restringeix els dominis quan es canviï el correu electrònic';
$string['warningcurrentsetting'] = 'Valor actual no vàlid: {$a}';
$string['warningiconvbuggy'] = 'La vostra versió de la llibreria iconv no és compatible amb el modificador //IGNORE. En lloc seu hauríeu d\'instal·lar l\'extensió mbstring que pot utilitzar-se per netejar cadenes que continguin caràcters UTF-8 no vàlids.';
$string['webproxy'] = 'Intermediari web';
$string['webproxyinfo'] = 'Empleneu les opcions següents si el vostre servidor Moodle no pot accedir directament a Internet. L\'accés a Internet és necessari per baixar dades d\'entorn, paquets d\'idioma, canals RSS, zones horàries, etc.<br /><em>Es recomana l\'extensió de PHP cURL</em>.';
$string['xmlrpcrecommended'] = 'Us cal l\'extensió xmlrpc per a les comunicacions amb el concentrador (<em>hub</em>), i també és útil per als serveis web i les xarxes Moodle.';
$string['yuicomboloading'] = 'Carregant el combinat YUI';
$string['ziprequired'] = 'Us cal l\'extensió Zip de PHP a Moodle, no es poden utilitzar els binaris info-ZIP o la llibreria PclZip.';
$string['zlibenabled'] = 'zlib habilitada';
