<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'es_mx', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Primera alerta';
$string['alert2'] = 'Segunda alerta';
$string['alert3'] = 'Tercera alerta';
$string['alert_general'] = 'Anuncio';
$string['alert_info'] = 'Información';
$string['alertsdesc'] = 'Esto mostrará una (o múltiples) alerta(s) en tres diferentes estilos a sus usuarios en la portada de Moodle. Por favor, recuerde deshabilitarlas cuando ya no las necesite.';
$string['alertsheading'] = 'Alertas a usuarios';
$string['alertsheadingsub'] = 'Mostrar mensajes importantes a sus usuarios en la portada';
$string['alerttext'] = 'Texto de la alerta';
$string['alerttextdesc'] = '¿ Cual es el texto a mostrar en su alerta ?';
$string['alerttitle'] = 'Título';
$string['alerttitledesc'] = 'Título/encabezado principal para su alerta.';
$string['alerttype'] = 'Nivel';
$string['alerttypedesc'] = 'Configure el nivel/tipo de alerta apropiado para informar mejor a sus usuarios.';
$string['alert_warning'] = 'Advertencia';
$string['allclasses'] = 'Todas las clases';
$string['allcourses'] = 'Todos los cursos';
$string['allmodules'] = 'Todos los módulos';
$string['allunits'] = 'Todas las unidades';
$string['alternativecolors'] = 'Colores Alternos {$a}';
$string['alternativethemecolor'] = 'Color de Tema Alterno {$a}';
$string['alternativethemecolordesc'] = '¿De qué color debería de ser su tema para los colores alternos del tema {$a} ?.';
$string['alternativethemecolorname'] = 'Nombre del conjunto de colores alternos {$a}';
$string['alternativethemecolornamedesc'] = 'Proporcione un nombre reconocible para este conjunto de colores alternos del tema';
$string['alternativethemecolors'] = 'Colores alternos del tema';
$string['alternativethemecolorsdesc'] = 'Define colores alternos que el usuario puede seleccionar para el tema.';
$string['alternativethemehovercolor'] = 'Color alterno del tema al pasar el ratón encima {$a}';
$string['alternativethemehovercolordesc'] = '¿De qué color debería de ser al pasar el ratón encima para los colores alternos del tema  {$a} ?.';
$string['alternativethemename'] = 'Nombre del Esquema de Color';
$string['alternativethemenamedesc'] = 'Proporcione un nombre para sus colores alternos del tema';
$string['alternativethemetextcolor'] = 'Color del texto alterno {$a}';
$string['alternativethemetextcolordesc'] = 'Configure el color para su texto  alterno{$a}';
$string['alternativethemeurlcolor'] = 'Color alterno del enlace {$a}';
$string['alternativethemeurlcolordesc'] = 'Configure el color para su texto enlazado alterno {$a}';
$string['alwaysdisplay'] = 'Mostrar siempre';
$string['analytics'] = 'Análisis';
$string['analyticscleanurl'] = 'URLs limpias';
$string['analyticscleanurldesc'] = 'Generar URL limpia para seguimiento avanzado';
$string['analyticsdesc'] = 'Elija el tipo de Análisis que desea insertar y guárdelo para habilitar las otras opciones.';
$string['analyticsenabled'] = 'Habilitado';
$string['analyticsenableddesc'] = 'Habilitar Análisis para Moodle';
$string['analyticsguniversal'] = 'Análisis Universal de Google';
$string['analyticsheadingsub'] = 'Análisis poderosos para Moodle';
$string['analyticsimagetrack'] = 'Seguimiento de Imágenes';
$string['analyticsimagetrackdesc'] = 'Habilitar Seguimiento de Imágenes para navegadores con JavaScript desactivado.';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'ID del sitio';
$string['analyticssiteiddesc'] = 'Escriba la ID de su sitio';
$string['analyticssiteurl'] = 'URL de Análisis';
$string['analyticssiteurldesc'] = 'Escriba la URL de su Análisis Piwik sin http(s) o una diagonal final. Por ejemplo  "misitio.com/analytics".';
$string['analyticstrackadmin'] = 'Siguiendo Admins';
$string['analyticstrackadmindesc'] = 'Habilitar seguimiento de usuarios Admin (no recomendado)';
$string['analyticstrackingid'] = 'ID del sitio';
$string['analyticstrackingiddesc'] = 'Escriba su ID de Seguimiento';
$string['android'] = 'Androide (Google Play)';
$string['androiddesc'] = 'Proporcione una URL hacia su App para móvil en la tienda de Google Play. Si Usted no tiene una App propia allí, por favor considere enlazar a la App Movil Moodle oficial.  (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['backgroundstylefixed'] = 'Fijo';
$string['backgroundstylestretch'] = 'Estirar';
$string['backgroundstyletiled'] = 'Mosaico';
$string['backtotop'] = 'Regresar a la parte superior';
$string['badgepreferences'] = 'Preferencias de Insignia';
$string['blogpreferences'] = 'Preferencias de Blog';
$string['bootstrapcdn'] = 'Font Awesome desde CDN';
$string['bootstrapcdndesc'] = 'Si se habilita esto, se cargará el tipo de letra (Font) Awesome desde el orígen de Bootstrap CDN en línea. Habilite ésto si Usted está experimentando problemas para que se muestren los íconos del Font Awesome en su sitio.';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'Estilo migajas de pan';
$string['breadcrumbstyled'] = 'Elegante';
$string['breadcrumbstyledesc'] = 'Aquí puede Usted cambiar el estilo de las migas de pan';
$string['breadcrumbstylednocollapse'] = 'Elegante sin colapsar';
$string['breadcrumbthin'] = 'Delgado';
$string['cachesused'] = 'Se usó lo cacheado';
$string['categoryiconcategory'] = 'El ícono para la categoría: {$a->category}.';
$string['categoryicondesc'] = 'Si se habilita, esto le permitirá configurar íconos para cada categoría de cursos.';
$string['categoryiconheading'] = 'Íconos por Categoría';
$string['categoryiconheadingsub'] = 'Usar íconos para representar sus categorías';
$string['categoryiconinfo'] = 'Configurar íconos personalizados para Categorías';
$string['categoryiconinfodesc'] = 'Escriba el nombre del ícono que Usted desea usar. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que está después de "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Acerca de Essential</h3>
<p>Essential está basado en el tema Bootstrap, que fuera creado para Moodle 2.5, con la ayuda de :<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>TCréditos del tema</h3>
<p>Autor Original: Julian Ridden<br>
El trabajo fue continuado a partir de io del 2014 por:<br>
Gareth J. Barnard<br>
David Bezemer<br>
</p>
<h3>Donativos</h3>
<p>Este tema se le proporciona a Usted gratuitamente, y si desea expresar su gratitud por usar este tema, considere por favor hacer un donativo al
<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=themmai%40gmail%2ecom&lc=GB&item_name=Essential%20Theme%20Fund¤cy_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_LG%2egif%3aNonHosted" target="_blank">
haciendo click aquí para donar.
</a><br>Los donativos nos permitiran proporcionarle a Usted una o más características mejores en menos tiempo.</p>
</div></div>';
$string['colordesc'] = 'Aquí puede encontrar varias configuraciones para cambiar muchos de los colores encontrados en este tema.';
$string['colorheading'] = 'Color';
$string['colorheadingsub'] = 'Configure los colores usados en su tema';
$string['configtitle'] = 'Esencial (Essential)';
$string['contactinfo'] = 'Información de contacto';
$string['contactinfodesc'] = 'Escriba su información de contacto';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'El nombre de su organización';
$string['coursegrades'] = 'Calificaciones del curso';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que añada a esta área de texto se reflejarán en todas las páginas, lo que hace más simple la personalización de este tema.';
$string['dbqueries'] = 'Leer/Escribir de/a BasedeDatos';
$string['defaultcategoryicon'] = 'Íconos por Defecto para Categorías';
$string['defaultcategoryicondesc'] = 'Configurar un ícono por defecto para categoría';
$string['defaultcolors'] = 'Colores por defecto';
$string['displayafterlogin'] = 'Mostrar solamente después de ingresar';
$string['displaybeforelogin'] = 'Mostrar solamente antes de ingresar';
$string['displaymycourses'] = 'Mostrar cursos inscritos';
$string['displaymycoursesdesc'] = 'Mostrar cursos inscritos para los usuarios en el Menú Personalizado';
$string['donate_desc'] = 'Por favor,  {$a->url} para financiar el desarrollo de Essential, o simplemente expresar su gratitud.';
$string['donate_desc2'] = 'para mantener andando el desarrollo de Essential, o simplemente para expresar su gratitud.';
$string['donate_title'] = 'Donativos a Essential';
$string['dontdisplay'] = 'Nunca mostrar';
$string['enablealert'] = 'Habilitar alertas';
$string['enablealertdesc'] = 'Habilitar o deshabilitar alerta';
$string['enablealternativethemecolors'] = 'Habilitar colores alternos del tema {$a}';
$string['enablealternativethemecolorsdesc'] = 'Si se habilita, el usuario podrá elegir los colores alternos del tema {$a}.';
$string['enablecategoryicon'] = 'Habilitar íconos por categorías';
$string['enablecategoryicondesc'] = 'Si se habilita, Usted podrá seleccionar íconos de categorías  después de elegir "Guardar cambios".';
$string['enablecustomcategoryicon'] = 'Habilitar íconos por categorías';
$string['enablecustomcategoryicondesc'] = 'Si se habilita, debajo de esta sección Usted verá una categoría con una opción personalizable debajo de cada categoría. Por favor, guarde después de habilitar o deshabilitar esta opción.';
$string['extperfinfoheading'] = 'Información Extensiva sobre Desempeño';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Escriba la URL de su página de Facebook. (por ejemplo: https://es-es.facebook.com/UNAM.MX.Oficial o https://www.facebook.com/ipn.mx o https://www.facebook.com/UAMXochimilco)';
$string['few'] = 'Unos pocos';
$string['fitvids'] = 'Usar FitVids';
$string['fitvidsdesc'] = 'Habilitar FitVids (fitvidsjs.com) para hacer sus videos incrustados responsivos. Si FitVids está activado y Usted quiere que un  video sea excluido, entonces añada  \'class="fitvidsignore"\' a la etiqueta (\'\'tag\'\') \'iframe\' en el  modo HTML del editor. Por ejemplo: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Ancho Fijo - Angosto';
$string['fixedwidthnormal'] = 'Ancho fijo - Normal';
$string['fixedwidthwide'] = 'Ancho Fijo - Ancho';
$string['flattr_click'] = 'donar mediante Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Escriba la URL de su página de Flickr. (por ejemplo: http://www.flickr.com/people/ciecounam/)';
$string['fontcharacterset'] = 'Conjunto de caracteres adicionales de Tipos de letras de Google';
$string['fontcharactersetcyrillic'] = 'Cirílico';
$string['fontcharactersetcyrillicext'] = 'Cirílico extendido';
$string['fontcharactersetdesc'] = 'Elija conjuntos de caracteres adicionales para diferentes idiomas. Al usar muchos conjuntos de caracteres se puede alentar su Moodle, por lo que se le recomienda que solamente seleccione los conjuntos de caracteres que reaalmente necesita.';
$string['fontcharactersetgreek'] = 'Griego';
$string['fontcharactersetgreekext'] = 'Griego extendido';
$string['fontcharactersetlatinext'] = 'Latín extendido';
$string['fontcharactersetvietnamese'] = 'Vietnamita';
$string['fontfileeotbody'] = 'Archivo del tipo de letra (\'\'font\'\') EOT del cuerpo (\'\'body\'\')';
$string['fontfileeotheading'] = 'Archivo del tipo de letra (\'\'font\'\') EOT del encabezado (\'\'heading\'\')';
$string['fontfileotfbody'] = 'Archivo del tipo de letra (\'\'font\'\') OTF del cuerpo (\'\'body\'\')';
$string['fontfileotfheading'] = 'Archivo del tipo de letra (\'\'font\'\') OTF del encabezado (\'\'heading\'\')';
$string['fontfiles'] = 'Archivos de \'Fonts\'';
$string['fontfilesdesc'] = 'Suba aquí sus archivos de \'fonts\'.';
$string['fontfilesvgbody'] = 'Archivo de tipo de letra (\'\'font\'\') SVG del cuerpo (\'\'body\'\')';
$string['fontfilesvgheading'] = 'Archivo de tipo de letra (\'\'font\'\') SVG del encabezado (\'\'heading\'\')';
$string['fontfilettfbody'] = 'Archivo de font TTF para cuerpo';
$string['fontfilettfheading'] = 'Archivo de font TTF para encabezado';
$string['fontfilewoffbody'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF del encabezado (\'\'heading\'\')';
$string['fontfilewoffheading'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF del encabezado (\'\'heading\'\')';
$string['fontfilewofftwobody'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF2 del cuerpo (\'\'body\'\')';
$string['fontfilewofftwoheading'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF2 del encabezado (\'\'heading\'\')';
$string['fontheadingdesc'] = 'Seleccione y escriba los tipos de letra (\'\'fonts\'\') que quiera usar en su ambiente Moodle';
$string['fontheadingsub'] = 'Configuraciones del tipo de letra (\'\'font\'\')';
$string['fontnamebody'] = 'Font para texto';
$string['fontnamebodydesc'] = 'Escriba el nombre exacto del \'font\' a usar para todo el demás texto.';
$string['fontnameheading'] = 'Font para encabezado';
$string['fontnameheadingdesc'] = 'Escriba el nombre exacto del \'font\' a usar para encabezados.';
$string['fontselect'] = 'Selector de tipos de letras (Fonts)';
$string['fontselectdesc'] = 'Elija de la lista de tipos de letra (fonts) disponibles. Por favor, elija \'Guardar\' para mostrar las opciones para elegir.';
$string['fontsettings'] = 'Tipo de letra (\'\'font\'\')';
$string['fonttypecustom'] = '\'Font\' personalizado';
$string['fonttypegoogle'] = '\'Fonts\' de web de Google';
$string['fonttypestandard'] = '\'Fonts\' estándar';
$string['footercolor'] = 'Color del Fondo del Pie de página';
$string['footercolordesc'] = 'Configure de qué color debería de ser la caja del Pie de Página.';
$string['footercolors'] = 'Colores del pie de página';
$string['footercolorsdesc'] = 'Cambiar los colores del pie de página';
$string['footerheading'] = 'Pie de página';
$string['footerheadingcolor'] = 'Color del Encabezado del Pie de Página';
$string['footerheadingcolordesc'] = 'Configure el color para los encabezados del bloque en el Pie de Página.';
$string['footerhovercolor'] = 'Color al pasar Ratón encima para Enlace del Pie de Página';
$string['footerhovercolordesc'] = 'Configure el Color para el Texto Enlazado cuando le pase el ratón por encima en el Pie de Página';
$string['footersepcolor'] = 'Color de Separador del Pie de Página';
$string['footersepcolordesc'] = 'Los separadores son líneas usadas para separar contenidos. Configure aquí sus colores.';
$string['footertextcolor'] = 'Color del Texto del Pie de página';
$string['footertextcolordesc'] = 'Configure el color que quiera para el texto del Pie de Página';
$string['footerurlcolor'] = 'Color del enlace del Pie de Página';
$string['footerurlcolordesc'] = 'Configure el color que quiera para el texto enlazado del Pie de Página.';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Lo que añada a esta área de texto se reflejará en el pie de página de todo su sitio Moodle.';
$string['frontcontent'] = 'Habilitar área de contenido en Portada';
$string['frontcontentarea'] = 'Contenidos del área de contenidos de la Portada';
$string['frontcontentareadesc'] = 'Todo lo que escriba en esta caja se mostrará a todo lo ancho de la página entre el carrusel de imágenes y los Bloques Publicitarios.';
$string['frontcontentdesc'] = 'Si se habilita, esto añade un área de contenido personalizado, entre la presentación de imágenes y las cajas de Anuncios, para su propio contenido personalizado';
$string['frontcontentheading'] = 'Área de contenidos de la Portada';
$string['frontpageblocks'] = 'Alineación de bloques de la portada';
$string['frontpageblocksdesc'] = 'Aquí puede Usted determinar si los bloques estándar en la portada se alinean a la izquierda o a la derecha.';
$string['frontpageblocksheading'] = 'Bloques de la página de Portada';
$string['frontpageheading'] = 'Página de Portada';
$string['frontpageheadingdesc'] = 'Configure aquí los ítems adicionales que desee mostrar en la página de la Portada.';
$string['frontpagemiddleblocks'] = 'Habilitar bloques adicionales enmedio de la portada';
$string['frontpagemiddleblocksdesc'] = 'Si se habilita, esto mostrará tres nuevas localizaciones para bloques, justo debajo de los Bloques Publicitarios';
$string['fullname'] = 'Nombre completo del sitio';
$string['fullnamesummary'] = 'Nombre completo y resumen';
$string['generalheadingdesc'] = 'Configure aquí las configuraciones globales para el tema. Usted encontrará aquí tanto opciones de diseño como visuales.';
$string['generalheadingsub'] = 'Configuraciones generales';
$string['genericsettings'] = 'Generales';
$string['googleplus'] = 'URL de Google +';
$string['googleplusdesc'] = 'Escriba la URL de su perfil de Google+ (por ejemplo:http://plus.google.com/107817105228930159735)';
$string['headerheading'] = 'Encabezado';
$string['headertitle'] = 'Título del encabezado';
$string['headertitledesc'] = 'Configure aquí el título a mostrar en el encabezado.';
$string['helplink'] = 'Enlace de ayuda';
$string['helplinkdesc'] = 'Si USted elige la URL de arriba, llenela URL completa hacia la ayuda de su sitio (debe incluir http:// o https://). Si Usted elige una dirección de Email, ponga su dirección de Email.';
$string['helplinktype'] = 'Habilitar enlace de ayuda en el menú';
$string['helplinktypedesc'] = 'Elija si es que desea habilitar una opción para ayuda en el menú del usuario; Usted puede elegir si proporciona una URL que se abrirá en una nueva ventana o una dirección de Email.';
$string['hideonphone'] = 'Ocultar presentación con imágenes en dispositivos móviles';
$string['hideonphonedesc'] = 'Elija si desea deshabilitar o no  la presentación con imágenes en dispositivos móviles.';
$string['hideontablet'] = 'Ocultar presentación con imágenes en tabletas';
$string['hideontabletdesc'] = 'Elija si Usted desea deshabilitar la presentación con imágenes en tabletas.';
$string['included'] = 'Archivos incluidos';
$string['instagram'] = 'URL de Instagram';
$string['instagramdesc'] = 'Escriba la URL de su pagina de Instagram. (ejemplo: http://instagram.com/micolegio)';
$string['ios'] = 'iPhone/iPad (Tienda de App)';
$string['iosdesc'] = 'Proporciona una URL para su App de dispositivo móvil en la Tienda de Apple. Si Usted no tiene una App propia, puede considerar enlazar a la App oficial de Moodle para móvil (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Íconos de pantalla para Hogar para IOs';
$string['iosicondesc'] = 'El tema proporciona un ícono por defecto para la pantalla de hogar para  IOs y Androide . Usted puede subir sus íconos personalizados si lo desea.';
$string['ipadicon'] = 'Ícono de Ipad (No Retina)';
$string['ipadicondesc'] = 'Los íconos deberían de ser archivos PNG de 72 pixeles por 72 pixeles.';
$string['ipadretinaicon'] = 'Ícono de Ipad (Retina)';
$string['ipadretinaicondesc'] = 'Los íconos deberían de ser archivos PNG de 144 pixeles por 144 pixeles.';
$string['iphoneicon'] = 'Ícono de iPhone/iPod Touch (No Retina)';
$string['iphoneicondesc'] = 'Los íconos deberían de ser archivos PNG de 57 pixeles por 57 pixeles.';
$string['iphoneretinaicon'] = 'Ícono de iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Los íconos deberían de ser archivos PNG de 114 pixeles por 114 pixeles.';
$string['layout'] = 'Usar un diseño gráfico de curso estándar';
$string['layoutdesc'] = 'Este tema está diseñado para poner ambas columnas de bloques al lado. Si Usted prefiere el diseño gráfico estándar de Moodle, Usted puede seleccionar esta casilla y regresar al diseño gráfico antiguo y aburrido de tres columnas.';
$string['left'] = 'Izquierda';
$string['linkedin'] = 'URL de Linkedln';
$string['linkedindesc'] = 'Escriba la URL de su perfil en Linkedln aquí (por ejemplo: http://www.linkedin.com/company/unam-los-angeles)';
$string['loadtime'] = 'Tiempo para subir';
$string['loggedinas'] = 'Ingresado como';
$string['loggedinfrom'] = 'Ingresado desde';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Por favor suba su logo personalizado aquí si desea añadirlo al encabezado.<br>La imagen debería de  ser de 65 pixeles de alto y de cualquier ancho razonable que funcione.<br>Si Usted sube un logo, remplazará al ícono estándar y el nombre que se muestran por defecto.';
$string['marketing1'] = 'Bloque Publicitario Uno';
$string['marketing2'] = 'Bloque Publicitario Dos';
$string['marketing3'] = 'Bloque Publicitario Tres';
$string['marketingbuttontext'] = 'Texto del Enlace';
$string['marketingbuttontextdesc'] = 'Texto que aparecerá en el botón';
$string['marketingbuttonurl'] = 'URL a enlazar';
$string['marketingbuttonurldesc'] = 'URL a donde apuntará el botón';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en la caja de Anuncio. Hágalo corto y dulce.';
$string['marketingdesc'] = 'Este tema proporciona la opción para habilitar tres puntos de "anuncio" o "promoción" justo debajo de la presentación de imágenes. Estos puntos le premiten identificar facilmente información básica para sus usuarios, y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Bloques Publicitarios';
$string['marketingheadingsub'] = 'Tres lugares en la portada para añadir información y enlaces';
$string['marketingheight'] = 'Altura de imágenes de Anuncios';
$string['marketingheightdesc'] = 'Si Usted quiere mostrar imágenes en las cajas de Anuncios, aquí puede especificar sus alturas.';
$string['marketingicon'] = 'Ícono';
$string['marketingicondesc'] = 'Nombre del ícono que Usted desea usar. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "icon-".';
$string['marketingimage'] = 'Imagen';
$string['marketingimagedesc'] = 'Esto proporciona la opción para mostrar una imagen arriba del texto en el Bloque Publicitario';
$string['marketinginfodesc'] = 'Escriba las configuraciones para su Bloque Publicitario.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en el Bloque Publicitario';
$string['marketingurltarget'] = 'Enlazar destino';
$string['marketingurltargetdesc'] = 'Elegir cómo debiera abrirse el enlace';
$string['marketingurltargetnew'] = 'Página nueva';
$string['marketingurltargetparent'] = 'Marco Padre';
$string['marketingurltargetself'] = 'Página Actual';
$string['memused'] = 'Memoria utilizada';
$string['messagepreferences'] = 'Preferencias de mensajería';
$string['mobileappsdesc'] = '¿ Tiene Usted una App Web en la Tienda de Apps o la Tienda de Google Play ? Proporcione aquí un enlace, para que sus usuarios puedan adquirir las Apps en línea';
$string['mobileappsheading'] = 'Apps';
$string['mobileappsheadingsub'] = 'Enlace a su App para que sus alumnos usen dispositivos móviles';
$string['myclasses'] = 'Mis Clases';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursesinfo'] = 'Menú de Cursos inscritos';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica de cursos inscritos para el usuario';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el enlace a "Mis Cursos" en el menú desplegable';
$string['mygrades'] = 'Mis calificaciones';
$string['mymodules'] = 'Mis Módulos';
$string['myunits'] = 'Mis Unidades';
$string['navbartitle'] = 'Título de Barra de Navegación';
$string['navbartitledesc'] = 'Configure aquí el título a usar en la barra de navegación.';
$string['nextsection'] = 'Sección Siguiente';
$string['nobreadcrumb'] = 'Ocultar';
$string['noenrolments'] = 'Usted no tiene inscripciones vigentes';
$string['nomessagesfound'] = 'No se encontraron mensajes';
$string['noslidetitle'] = 'No tiene título la imágen {$a->slide}';
$string['notitle'] = 'Sin título';
$string['numberofslides'] = 'Número de imágenes';
$string['numberofslides_desc'] = 'Número de imágenes en el pasador de imágenes';
$string['oldnavbar'] = 'Use la posición de la antigua Barra de Navegación';
$string['oldnavbardesc'] = 'Habilite esta opción para usar la posición de la antigua Barra de Navegación.';
$string['pagebackground'] = 'Imágenes de Fondo de la Página';
$string['pagebackgrounddesc'] = 'Suba su propia imagen de fondo. Seleccione debajo el estilo de la imagen.';
$string['pagebackgroundstyle'] = 'Estilo del fondo de la página';
$string['pagebackgroundstyledesc'] = 'Seleccione el estilo para la imagen subida.';
$string['pagewidth'] = 'Configurar Ancho de Página';
$string['pagewidthdesc'] = 'Elija de entre la lista de anchos de página disponibles para su sitio.';
$string['peakmem'] = 'Pico de Memoria';
$string['perfinfo'] = 'Modo de Información de Desempeño';
$string['perfinfodesc'] = 'Muchos sitios no necesitan la información detallada completa sobre el desempeño, especialmente cuando los ven los usuarios. Cuando se habilita, ésto muestra un formato mínimo arreglado, con información básica acerca de carga de la página.';
$string['perfinfoheading'] = 'Información del Desempeño';
$string['perf_max'] = 'Detallada';
$string['perf_min'] = 'Mínima';
$string['pinterest'] = 'URL de Pinterest';
$string['pinterestdesc'] = 'Escriba la URL de su página de Pinterest. (ejemplo: http://pinterest.com/micolegio)';
$string['pluginname'] = 'Esencial';
$string['previoussection'] = 'Sección Anterior';
$string['profilebarcustomtitle'] = 'Título personalizado del Bloque de Barra de Perfil';
$string['profilebarcustomtitledesc'] = 'Título para el bloque personalizado de la Barra de Perfil.';
$string['readme_click'] = 'haga click para README.txt';
$string['readme_desc'] = 'Por favor, haga click sobre de \'{$a->url}\' para más información acerca del tema Essential.';
$string['readme_title'] = 'Lee-me de Essential';
$string['readmore'] = 'Leer Más';
$string['region-footer-left'] = 'Pie de página (Izquierdo)';
$string['region-footer-middle'] = 'Pie de página (Medio)';
$string['region-footer-right'] = 'Pie de página (Derecho)';
$string['region-hidden-dock'] = 'Oculto a los usuarios';
$string['region-home-left'] = 'Home (Izquierda)';
$string['region-home-middle'] = 'Home (Centro)';
$string['region-home-right'] = 'Home (Derecha)';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['right'] = 'Derecha';
$string['serverload'] = 'Carga del servidor';
$string['sessionsize'] = 'Tamaño de la sesión';
$string['shortname'] = 'Nombre corto del sitio';
$string['shortnamesummary'] = 'Nombre corto y resumen';
$string['siteicon'] = 'Ícono del sitio';
$string['siteicondesc'] = '¿No tiene un logo propio? Escriba el nombre del ícono que desea usar. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "fa-".';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Escriba el nombre_de_usuario Skype de su cuenta Skype institucional';
$string['slidebuttoncolor'] = 'Color del Botón de Presentación';
$string['slidebuttoncolordesc'] = '¿ De qué color debería de ser el botón para "leer más" ?';
$string['slidebuttonhovercolor'] = 'Color al pasar ratón encima para el botón del desplazador de imágenes';
$string['slidebuttonhovercolordesc'] = '¿De qué color debería de ser al pasar el ratón encima el botón de navegación de imágenes';
$string['slidecaption'] = 'Subtítulo de la imagen';
$string['slidecaptionbelow'] = 'Subtítulos debajo de la imágen';
$string['slidecaptionbelowdesc'] = 'Si los subtítulos deberían estar debajo de la imagen.';
$string['slidecaptioncentred'] = 'Subtítulo de la diapositiva centrado';
$string['slidecaptioncentreddesc'] = 'Si es que el subtítulo de la diapositiva debería ir centrado.';
$string['slidecaptiondesc'] = 'Escriba el texto del subtítulo a emplear para la imagen';
$string['slidecolor'] = 'Color del Texto de Diapositiva';
$string['slidecolordesc'] = '¿ De qué color debería de ser el texto de la Diapositiva ?';
$string['slideimage'] = 'Imágen de presentación';
$string['slideimagedesc'] = 'La imagen funciona mejor si es transparente.';
$string['slideinterval'] = 'Intervalo entre imágenes';
$string['slideintervaldesc'] = 'Intervalo de transciciónentre imágenes, en milisegundos.';
$string['slideno'] = 'Imagen {$a->slide}';
$string['slidenodesc'] = 'Escriba las configuraciones para la imagen {$a->slide}.';
$string['slideshowdesc'] = 'Esto crea un carrusel dinámico
This creates a dynamic slide show of up to sixteen slides for you to promote important elements of your site. The show is responsive where image height is set according to screen size. The recommended height is 300px. The width is set at 100% and therefore the actual height will be smaller if the width is greater than the screen size. At smaller screen sizes the height is reduced dynamically without the need to provide separate images. For reference screen width < 767px = height 165px, width between 768px and 979px = height 225px and width > 980px = height 300px. If no image is selected for a slide, then the default_slide image in the pix folder is used.';
$string['slideshowheading'] = 'Carrusel';
$string['slideshowheadingsub'] = 'Presentación dinámica de imágenes para la Portada';
$string['slidetitle'] = 'Título de la imagen';
$string['slidetitledesc'] = 'Escriba un título descriptivo para su imagen.';
$string['slideurl'] = 'Enlace de imagen';
$string['slideurldesc'] = 'Escriba el destino para el enlace de la primera imagen';
$string['slideurltarget'] = 'Enlazar Destino';
$string['slideurltargetdesc'] = 'Elegir cómo debiera abrirse el enlace';
$string['slideurltargetnew'] = 'Página Nueva';
$string['slideurltargetparent'] = 'Marco Padre';
$string['slideurltargetself'] = 'Página Actual';
$string['socialdesc'] = 'Proporciona enlaces directos hacia las principales redes sociales que promueven su marca/empresa/institución. Estos aparecerán en el encabezado de cada página.';
$string['socialheading'] = 'Redes sociales';
$string['socialheadingsub'] = 'Atrape a sus usuarios con Redes Sociales';
$string['socialnetworks'] = 'Redes sociales';
$string['themecolor'] = 'Color del tema';
$string['themecolordesc'] = 'De qué color debería ser su tema. Esto cambiará varios componentes para producir el color que Usted desea en todo el sitio Moodle.';
$string['themecolors'] = 'Colores del Tema';
$string['themehovercolor'] = 'Color del tema al pasar el ratón encima';
$string['themehovercolordesc'] = 'De qué color deberá ser cuando pasa el ratón encima. Esto se usa para enlaces, menús, etc.';
$string['themeiconcolor'] = 'color del ícono';
$string['themeiconcolordesc'] = 'Configure el color para todos los íconos';
$string['themenavcolor'] = 'Color de navegación';
$string['themenavcolordesc'] = 'Configure el color para la navegación. Esto es la Barra de Navegación y la pista de migajas de estilo elegante.';
$string['themetextcolor'] = 'Color del texto';
$string['themetextcolordesc'] = 'Configure el color para su texto.';
$string['themeurlcolor'] = 'Color del enlace';
$string['themeurlcolordesc'] = 'Configure el color para su texto enlazado';
$string['togglemarketing'] = 'Alternar visibilidad de Bloque Publicitario';
$string['togglemarketingdesc'] = 'Elija si quiere mostrar, o si prefiere ocultar, los 3  Bloques Publicitarios.';
$string['toggleslideshow'] = 'Alternar visualización de Presentación de imágenes';
$string['toggleslideshowdesc'] = 'Decida si desea mostrar u ocultar la presentación de imágenes';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter (ejemplo: https://twitter.com/unam_mx o https://twitter.com/IPN_MX o https://twitter.com/uamx).';
$string['unreadnewnotification'] = 'Notificaciones nuevas';
$string['usecategoryicon'] = 'Habilitar Íconos de Categorías';
$string['usecategoryicondesc'] = 'Usar íconos personalizados para categorías';
$string['variablewidth'] = 'Ancho Variable';
$string['visibleadminonly'] = 'Los bloque movidos dentro del área inferior solamente serán vistos por Administradores';
$string['vk'] = 'URL de VKontakte';
$string['vkdesc'] = 'Escriba la URL de su página de Vkontakte page. (ejemplo: http://www.vk.com/micolegio)';
$string['website'] = 'URL Página Web';
$string['websitedesc'] = 'Escriba la URL de su propio sitio web. (ejemplo: http://www.unam.mx)';
$string['windows'] = 'Escritorio de Windows';
$string['windowsdesc'] = 'Proporcione una URL hacia su App para dispositivos móviles en la Tienda de Windows (\'\'Windows Store\'\'). Si Usted no tiene una App propia, considere enlazar hacia la App para móviles oficial de Moodle. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Proporcione una URL hacia su App para dispositivos móviles en la \'Google Play Store\'. Si Usted no tiene una App propia, considere enlazar hacia la App para móviles oficial de Moodle. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Escriba la URL de su canal de YouTube (por ejemplo: http://www.youtube.com/unam o http://www.youtube.com/user/CanalOnceIPN).';
