<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pl', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Możesz obejrzeć ten quiz, ale gdyby to była prawdziwa próba, zostałbyś zablokowany, ponieważ:';
$string['action'] = 'Akcja';
$string['activityoverview'] = 'Masz otwarte, nieukończone quizy';
$string['adaptive'] = 'Tryb adaptacyjny';
$string['adaptive_help'] = 'Jeśli aktywne, dopuszczalne będzie wielokrotne udzielenie odpowiedzi na to samo pytanie podczas jednego podejścia do quizu. Na przykład, jeśli student udzieli nieprawidłowej odpowiedzi, będzie mógł natychmiast spróbować ponownie. Jednak, w zależności od ustawienia punktów karnych, za każdą złą odpowiedź punkty karne zostaną odjęte od końcowego wyniku.';
$string['addaquestion'] = 'Dodaj pytanie...';
$string['addarandomquestion'] = 'Dodaj losowe pytanie...';
$string['addarandomquestion_help'] = 'Losowo wybierane pytanie z danej kategorii jest dodawane do quizu. Oznacza to, że różni studenci najprawdopodobniej mogą uzyskać inny zestaw pytań, a kiedy quizu pozwala na wiele podejść, każde następne może zawierać nowy dobór pytań.';
$string['adddescriptionlabel'] = 'Dodaj opis / etykietę';
$string['addingquestion'] = 'Dodawanie pytania';
$string['addingquestions'] = 'Po prawej znajduje się baza pytań. Pytania przechowywane są w kategoriach w celu ułatwienia ich organizacji. Pytania mogą być wykorzystane nie tylko w dowolnym quizie wchodzącym w skład kursu, lecz również w innych kursach, jeśli zostaną opublikowane. <br /><br /> Po wybraniu lub utworzeniu kategorii, można tworzyć i edytować pytania. Każde z tych pytań można następnie dodać do quizu - lewa część strony.';
$string['addmoreoverallfeedbacks'] = 'Dodaj {no} pola odpowiedzi zwrotnej';
$string['addnewgroupoverride'] = 'Ustaw grupowe warunki quizu';
$string['addnewpagesafterselected'] = 'Dodaj nowe strony po zaznaczonych pytaniach';
$string['addnewquestionsqbank'] = 'Dodaj pytanie do kategorii {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Ustaw indywidualne warunki quizu';
$string['addpagehere'] = 'Dodaj tutaj stronę ';
$string['addquestion'] = 'Dodaj pytanie';
$string['addquestions'] = 'Dodaj pytania';
$string['addquestionstoquiz'] = 'Dodaj pytania do tego quizu';
$string['addrandom'] = 'Dodaj {$a} losowe pytania';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'pytania losowe';
$string['addrandomfromcategory'] = 'Dodaj losowe pytania z kategorii:';
$string['addrandomquestion'] = 'Dodaj losowe pytanie';
$string['addrandomquestiontoquiz'] = 'Dodaj losowe pytanie do quizu {$a}';
$string['addselectedtoquiz'] = 'Dodaj wybrane do quizu';
$string['addtoquiz'] = 'Dodaj do quizu';
$string['affectedstudents'] = 'Affected {$a}';
$string['aftereachquestion'] = 'Po dodaniu każdego pytania';
$string['afternquestions'] = 'Po dodaniu {$a} pytań';
$string['age'] = 'wiek';
$string['allattempts'] = 'Wszystkie podejścia';
$string['allinone'] = 'Bez ograniczeń';
$string['allowreview'] = 'Udostępnij przegląd';
$string['alreadysubmitted'] = 'Najprawdopodobniej zakończyłeś już to podejście do quizu';
$string['alternativeunits'] = 'Alternatywne jednostki';
$string['alwaysavailable'] = 'Zawsze dostępne';
$string['analysisoptions'] = 'Opcje analizy';
$string['analysistitle'] = 'Pozycje tablicy analizy';
$string['answer'] = 'Odpowiedź';
$string['answered'] = 'Udzielono odpowiedzi';
$string['answerhowmany'] = 'Jedna lub wiele odpowiedzi?';
$string['answers'] = 'Poprawne odpowiedzi';
$string['answersingleno'] = 'Odpowiedź wielokrotna jest dozwolona';
$string['answersingleyes'] = 'Wyłącznie jedna odpowiedź';
$string['answertoolong'] = 'Zbyt długa odpowiedź (maks. 255 znaków)';
$string['aon'] = 'Format AON';
$string['areyousureremoveselected'] = 'Czy na pewno chcesz usunąć wszystkie wybrane pytania?';
$string['asshownoneditscreen'] = 'Jak pokazano w oknie edycji';
$string['attempt'] = 'Próba {$a}';
$string['attemptalreadyclosed'] = 'To podejście zostało już zakończone.';
$string['attemptclosed'] = 'Próba nie została jeszcze zakończona';
$string['attemptduration'] = 'Czas wykonania';
$string['attemptedon'] = 'Data rozwiązania';
$string['attempterror'] = 'Nie możesz podejść do próby w tym teście teraz, ponieważ: {$a}';
$string['attemptfirst'] = 'Pierwsze podejście';
$string['attemptincomplete'] = 'Podejście {$a} nie zostało zakończone';
$string['attemptlast'] = 'Ostatnie podejście';
$string['attemptnumber'] = 'Próba';
$string['attemptquiznow'] = 'Spróbuj teraz rozwiązać quiz';
$string['attempts'] = 'Podejścia';
$string['attemptsallowed'] = 'Dostępne podejścia';
$string['attemptsdeleted'] = 'Podejścia usunięte';
$string['attemptselection'] = 'Podejścia do analizy wybrane przez użytkownika';
$string['attemptsexist'] = 'Nie możesz dodawać ani usuwać pytań z quizu';
$string['attemptsnum'] = 'Podejść: {$a}';
$string['attemptsnumthisgroup'] = 'Podejść: {$a->total} ({$a->group} z tej grupy)';
$string['attemptsnumyourgroups'] = 'Podejść: {$a->total} ({$a->group} z twoich grup)';
$string['attemptsonly'] = 'Pokaż tylko studentów, którzy podeszli do quizu';
$string['attemptstate'] = 'Stan';
$string['attemptstillinprogress'] = 'Podejście jeszcze w toku';
$string['attemptsunlimited'] = 'Nielimitowana liczba podejść';
$string['autosaveperiod'] = 'Okres automatycznego zapisu';
$string['autosaveperiod_desc'] = 'Odpowiedzi uczniów mogą być automatycznie zapisywane co kilka minut podczas rozwiązywania testu. Wiąże się to z kompromisem: zapisywanie odpowiedzi zwiększa obciążenie serwera, ale zmniejsza szansę, że uczniowie stracą swoją pracę.';
$string['back'] = 'Powrót do podglądu pytania';
$string['backtocourse'] = 'Powrót do kursu';
$string['backtoquestionlist'] = 'Wróć do listy pytań';
$string['backtoquiz'] = 'Powrót do edycji quizu';
$string['basicideasofquiz'] = 'Podstawowe zasady tworzenia quizu';
$string['bestgrade'] = 'Najlepsza ocena';
$string['bothattempts'] = 'Pokaż wszystkich studentów';
$string['browsersecurity'] = 'Zabezpieczenia przeglądarki';
$string['browsersecurity_help'] = 'Jeśli &quot;Pełny ekran pop-up zabezpieczony przez JavaScript &quot; jest zaznaczony,

* quiz uruchomi się tylko wtedy, gdy student ma włączoną obsługę JavaScript w przeglądarce internetowej

* quiz pojawi się w oknie popup na pełnym ekranie, który zakrywa wszystkie inne okna i nie ma elementów sterujących nawigacją

* Studenci nie mają możliwości, o ile jest to możliwe, korzystania z udogodnień, takich jak kopiowanie i wklejanie';
$string['calculated'] = 'Obliczeniowe';
$string['calculatedquestion'] = 'Obliczeniowe pytanie nie dopuszczalne w linii {$a}. Pytanie zostanie zignorowane.';
$string['cannotcreatepath'] = 'Ścieżka nie może zostać utworzona ({$a})';
$string['cannoteditafterattempts'] = 'Nie można dodawać ani usuwać pytań (były już jakieś podejścia). ({$a})';
$string['cannotfindprevattempt'] = 'Nie znaleziono poprzednich podejść na których można się oprzeć.';
$string['cannotfindquestionregard'] = 'Nie znajduje pytań do ponownej oceny!';
$string['cannotinsert'] = 'Nie można wstawić pytania';
$string['cannotinsertrandomquestion'] = 'Nie udało się wstawić nowego, losowo wybranego pytania!';
$string['cannotloadquestion'] = 'Nie udało się załadować opcji dla pytania';
$string['cannotloadtypeinfo'] = 'Nie udało się załadować informacji szczegółowych dla tego typu pytania';
$string['cannotopen'] = 'Nie można otworzyć pliku do exportu';
$string['cannotrestore'] = 'Nie udało się przywrócić sesji pytań';
$string['cannotreviewopen'] = 'Nie możesz przeglądać tego podejścia, jest ono nadal otwarte.';
$string['cannotsavelayout'] = 'Nie można zapisać schematu wyglądu';
$string['cannotsavenumberofquestion'] = 'Nie można zapisać liczby pytań na stronę';
$string['cannotsavequestion'] = 'Nie można zapisać listy pytań';
$string['cannotsetgrade'] = 'Nie udało się ustawić oceny maksymalnej dla quizu';
$string['cannotsetsumgrades'] = 'Nie udało się ustawić sumy ocen';
$string['cannotstartgradesmismatch'] = 'Nie można rozpocząć podejścia. Quiz musi zostać oceniony z {$a->grade}, lecz żadne z pytań w quizie nie ma ustawionej oceny. Można to naprawić na stronie edycji quizu.';
$string['cannotstartmissingquestion'] = 'Nie można uruchomić quizu. Definicja quizu zawiera pytanie, które nie istnieje.';
$string['cannotstartnoquestions'] = 'Nie można uruchomić quizu. Nie dodano jeszcze żadnych pytań.';
$string['cannotwrite'] = 'Nie można zapisać pliku do eksportu ({$a})';
$string['caseno'] = 'Nie, wielkość liter jest nieważna';
$string['casesensitive'] = 'Uwzględnianie wielkości liter';
$string['caseyes'] = 'Tak, wielkość liter musi się zgadzać';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategoria';
$string['categoryadded'] = 'Kategoria \'{$a}\' została dodana';
$string['categorydeleted'] = 'Kategoria \'{$a}\' została usunięta';
$string['categorynoedit'] = 'Nie możesz edtować kategorii \'{$a}\'';
$string['categoryupdated'] = 'Kategoria została poprawnie pobrana';
$string['close'] = 'Zamknij okno';
$string['closebeforeopen'] = 'Nie można zmieniać quizu. Data zamknięcia jest wcześniejsza niż data otwarcia quizu.';
$string['closed'] = 'Zamknięty';
$string['closepreview'] = 'Zamknij podgląd';
$string['closereview'] = 'Zamknij przegląd';
$string['comment'] = 'Komentarz';
$string['commentorgrade'] = 'Skomentuj lub zmień ocenę';
$string['comments'] = 'Komentarze';
$string['completedon'] = 'Ukończono';
$string['configadaptive'] = 'Jeśli wybierzesz \'Tak\', student będzie mógł udzielić wielu odpowiedzi na to samo pytanie, nawet w ciągu tego samego podejścia do quizu.';
$string['configattemptsallowed'] = 'Ograniczenie liczby podejść do quizu.';
$string['configdecimaldigits'] = 'Liczba cyfr po przecinku w ocenie.';
$string['configdecimalplaces'] = 'Liczba cyfr po przecinku w ocenie quizu.';
$string['configdecimalplacesquestion'] = 'Liczba cyfr po przecinku w ocenie indywidualnego pytania.';
$string['configdelay1'] = 'Tu można ustawić opóźnienie czasowe, po którym student może podjąć drugie podejście do quizu';
$string['configdelay1st2nd'] = 'Opcja określa czas, który student musi przeczekać zanim po raz drugi podejdzie do quizu.';
$string['configdelay2'] = 'Tu można ustawić opóźnienia czasowe, po którym student może podjąć trzeci i dalsze podejście do quizu';
$string['configdelaylater'] = 'Opcja określa czas, który student musi przeczekać zanim po raz trzeci i kolejny podejdzie do quizu.';
$string['configeachattemptbuildsonthelast'] = 'Jeśli wielokrotne podejścia są dozwolone,  każde nowe podejście zawiera wyniki poprzedniego.';
$string['configgrademethod'] = 'Która metoda powinna być użyta do wyznaczenia końcowej oceny za quiz w przypadku wielokrotnych podejść.';
$string['configintro'] = 'Tu można zdefiniować wartości domyślne, które są używane  podczas tworzenia nowego quizu. Można również wskazać, które z ustawień należą do zaawansowanych.';
$string['configmaximumgrade'] = 'Domyślna ocena maksymalna, do której ocena z quizu będzie skalowana.';
$string['confignewpageevery'] = 'Znaki nowej strony będą automatycznie wstawiane podczas dodawania pytań do quizu, zgodnie z niniejszym ustawieniem.';
$string['configpenaltyscheme'] = 'Kara odejmowana za każdą błędną odpowiedź w trybie adaptacyjnym.';
$string['configpopup'] = 'Otwórz osobne okno i używaj JavaScript, aby zablokować kopiowanie i wklejanie itp. podczas wypełniania quizu.';
$string['configrequirepassword'] = 'Studenci muszą wpisać to hasło, zanim będą mogli rozpocząć quiz.';
$string['configrequiresubnet'] = 'Studenci mogą tylko próbować rozwiązać quiz z tych komputerów.';
$string['configreviewoptions'] = 'Opcje te kontrolują to, co użytkownicy mogą zobaczyć kiedy przeglądają próby quizu lub raport quizu.';
$string['configshowblocks'] = 'Pokaż bloki kursu podczas rozwiązywania quizu';
$string['configshowuserpicture'] = 'Pokaż na ekranie zdjęcie użytkownika  w czasie prób.';
$string['configshufflequestions'] = 'Jeśli włączysz tę opcję, kolejność pytań danego quizu będą każdorazowo losowana.';
$string['configshufflewithin'] = 'Jeśli włączysz tę opcję,  poszczególne odpowiedzi do danego pytania będą każdorazowo losowo wymieszane, o ile opcja jest również włączona w ustawieniach pytania.';
$string['configtimelimit'] = 'Domyślny czas na rozwiązanie quizu (w minutach). 0 oznacza brak limitu.';
$string['configtimelimitsec'] = 'Domyślny czas dla quizów w sekundach. 0 - oznacza brak limitu czasowego.';
$string['configurerandomquestion'] = 'Konfiguruj pytanie';
$string['confirmclose'] = 'Zakończenie podejścia. Jeżeli zakończysz to podejście, nie będziesz mógł zmienić swoich odpowiedzi.';
$string['confirmserverdelete'] = 'Czy na pewno chcesz usunąć serwer <b>{$a}</b> z listy?';
$string['confirmstartattemptlimit'] = 'Ten quiz ma ograniczoną liczbę podejść {$a}. Zaraz rozpoczniesz kolejne. Chcesz kontynuować?';
$string['confirmstartattempttimelimit'] = 'Ten quiz ma limit czasowy i jest ograniczony do {$a} podejść. Zaraz rozpoczniesz kolejne. Chcesz kontynuować?';
$string['confirmstarttimelimit'] = 'Ten quiz ma limit czasowy. Czy na pewno chcesz rozpocząć?';
$string['connectionok'] = 'Połączenie sieciowe przywrócone. Możesz kontynuować bezpiecznie.';
$string['containercategorycreated'] = 'Do tej kategorii zostały przeniesione wszystkie dotychczasowe kategorie z przyczyn wyszczególnionych poniżej.';
$string['continueattemptquiz'] = 'Kontynuuj ostatnie podejście';
$string['continuepreview'] = 'Kontynuuj ostatni podgląd';
$string['copyingfrom'] = 'Utwórz kopię pytania \'{$a}\'';
$string['copyingquestion'] = 'Kopiowanie pytania';
$string['correct'] = 'Poprawnie';
$string['correctanswer'] = 'Poprawna odpowiedź';
$string['correctanswerformula'] = 'Poprawna formuła odpowiedzi';
$string['correctansweris'] = 'Poprawna odpowiedź: {$a}';
$string['correctanswerlength'] = 'Poprawna długość odpowiedzi';
$string['correctanswers'] = 'Poprawne odpowiedzi';
$string['correctanswershows'] = 'Pokaż poprawne odpowiedzi';
$string['corrresp'] = 'Właściwa odpowiedź';
$string['countdown'] = 'Odliczanie';
$string['countdownfinished'] = 'Quiz jest zamykany. Wyślij teraz swoje odpowiedzi.';
$string['countdowntenminutes'] = 'Quiz zostanie zamknięty za 10 minut';
$string['coursetestmanager'] = 'Format Menedżera Testów Kursu';
$string['createcategoryandaddrandomquestion'] = 'Utwórz kategorię i dodaj losowe pytanie';
$string['createfirst'] = 'Musisz utworzyć najpierw pytania \'krótka odpowiedź\'.';
$string['createmultiple'] = 'Utwórz wiele pytań';
$string['createnewquestion'] = 'Utwórz nowe pytanie';
$string['createquestionandadd'] = 'Utwórz nowe pytanie i dodaj je do quizu.';
$string['custom'] = 'Niestandardowy format';
$string['dataitemneed'] = 'Musisz dodać co najmniej jeden zestaw aby utworzyć prawidłowe pytanie.';
$string['datasetdefinitions'] = 'Zestawy wielokrotnego użytku dla kategorii {$a}';
$string['datasetnumber'] = 'Liczba';
$string['daysavailable'] = 'Dni dostępności';
$string['decimaldigits'] = 'Cyfry dziesiętne w ocenie';
$string['decimalplaces'] = 'Miejsca dziesiętne w ocenach';
$string['decimalplaces_help'] = 'Przez użycie tej opcji można wybierać liczbę cyfr dziesiętnych pokazywanych w ocenie dla każdej próby. Ustawienie wpływa tylko na sposób wyświetlania ocen. Nie wpływa na wartości przechowywane w bazie danych ani obliczenia, które są prowadzone na pełnej dokładności.';
$string['decimalplacesquestion'] = 'Miejsca dziesiętne w ocenie pytania';
$string['decimalplacesquestion_help'] = 'To ustawienie określa liczbę cyfr po przecinku pokazywanych w ocenie poszczególnych pytań.';
$string['decimalpoints'] = 'Punkty dziesiętne';
$string['default'] = 'Domyślny';
$string['defaultgrade'] = 'Domyślna ocena za pytanie';
$string['defaultinfo'] = 'Domyślna kategoria pytań';
$string['delay1'] = 'Czas pomiędzy pierwszym a drugim podejściem';
$string['delay1st2nd'] = 'Wymuszone opóźnienie między 1 i 2 próbą';
$string['delay1st2nd_help'] = 'Jeśli opcja jest włączona, uczeń musi odczekać określony czas, zanim będzie mógł próbować rozwiązać quiz po raz drugi.';
$string['delay2'] = 'Czas pomiędzy kolejnymi podejściami';
$string['delaylater'] = 'Wymuszone opóźnienie między późniejszymi próbami';
$string['delaylater_help'] = 'Jeśli opcja jest włączona, uczeń musi odczekać określony czas, zanim będzie mógł próbować rozwiązać quiz po raz trzeci i kolejny raz.';
$string['deleteattemptcheck'] = 'Czy jesteś pewien, że chcesz usunąć te podejścia?';
$string['deleteselected'] = 'Usuń wybrane';
$string['deletingquestionattempts'] = 'Usuwanie podejść do pytania';
$string['description'] = 'Opis';
$string['disabled'] = 'Nieaktywny';
$string['displayoptions'] = 'Wyświetl opcje';
$string['donotuseautosave'] = 'Nie używaj auto-zapisu';
$string['download'] = 'Pobierz plik z kategoriami';
$string['downloadextra'] = '(Plik jest przechowywany w plikach kursu/katalogu quizu)';
$string['duplicateresponse'] = 'Ta próba jest zignorowana, ponieważ podałeś wcześniej równoważne odpowiedzi';
$string['eachattemptbuildsonthelast'] = 'Każda nowa próba na podstawie poprzedniej';
$string['eachattemptbuildsonthelast_help'] = '<p>Jeżeli dozwolone są wielokrotne próby, a ta opcja ustawiona jest na <B>Tak</B>, wtedy każda nowa próba będzie  już zawierać rozwiązania z poprzedniej próby. Pozwala to na wypełnienie quizu w kilku podejściach.</p>
<p>Aby każdą  próbę rozpocząć od czystego quizy, wybierz <B>Nie</B> dla tego ustawienia.</p>';
$string['editcategories'] = 'Edytuj kategorie';
$string['editcategory'] = 'Edytuj kategorię';
$string['editcatquestions'] = 'Edytuj pytania kategorii';
$string['editingquestion'] = 'Edycja pytania';
$string['editingquiz'] = 'Edycja quizu';
$string['editingquiz_help'] = 'Główne pojęcia dotyczące quizów:

* Quiz zawiera  jedną lub więcej stron wypełnionych pytaniami

 * Bank pytań, który przechowuje wszystkie pytania podzielone na kategorie

* Pytania Losowe - student dostaje różne pytania za każdym razem, gdy rozwiązuje  quiz jak i różni studenci mogą dostać różne pytania';
$string['editingquizx'] = 'Edycja quizu: {$a}';
$string['editoverride'] = 'Edytuj wyjątki';
$string['editqcats'] = 'Edytuj kategorie pytań';
$string['editquestions'] = 'Edytuj pytania';
$string['editquiz'] = 'Edytuj zawartość quizu';
$string['editquizquestions'] = 'Edycja pytań quizu';
$string['emailconfirmbody'] = 'Drogi {$a->username},

Dziękuję za udzielenie odpowiedzi w quizie "{$a->quizname}" w kursie "{$a->coursename}" o {$a->submissiontime}.

Ten e-mail potwierdza prawidłowy odbiór pytań w systemie.

Quiz jest dostępny na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Dziękujemy za przesłanie odpowiedzi dot. \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potwierdzenie przesłania: {$a->quizname}.';
$string['emailnotifybody'] = 'Drogi {$a->username},

{$a->studentname} ukończył quiz "{$a->quizname}" ({$a->quizurl}) w kursie "{$a->coursename}".

Możesz przejrzeć udzielone odpowiedzi na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} zakończył(a) {$a->quizname}. Zobacz {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ukończył {$a->quizname}.';
$string['empty'] = 'Puste';
$string['enabled'] = 'Włączone';
$string['endtest'] = 'Zapisz podejście ...';
$string['erroraccessingreport'] = 'Nie masz dostępu do tego raportu';
$string['errorinquestion'] = 'Błąd w pytaniu';
$string['errormissingquestion'] = 'Błąd: System opuścił pytanie z ID {$a}';
$string['errornotnumbers'] = 'Błąd - odpowiedź musi być liczbą';
$string['errorunexpectedevent'] = 'Nieoczekiwany kod zdarzenia {$a->event} znaleziono dla pytania {$a->questionid} w podejściu {$a->attemptid}.';
$string['essay'] = 'Dłuższa odpowiedź';
$string['essayquestions'] = 'Pytania';
$string['everynquestions'] = 'Wszystkie {$a} pytania';
$string['everyquestion'] = 'Każde pytanie';
$string['everythingon'] = 'Wszystko włączone';
$string['export'] = 'Eksport';
$string['exportcategory'] = 'eksport kategorii';
$string['exporterror'] = 'Błąd podczas eksportu';
$string['exportingquestions'] = 'pytania są wyeksportowane do pliku';
$string['exportname'] = 'Nazwa pliku';
$string['exportquestions'] = 'Wyeksportuj pytania do pliku';
$string['extraattemptrestrictions'] = 'Dodatkowe ograniczenia podejść do quizu';
$string['false'] = 'Fałsz';
$string['feedback'] = 'Informacja zwrotna';
$string['feedbackerrorboundaryformat'] = 'Granica oceny musi być wartością liczbową lub procentową. Wartość granicy 1 nie została rozpoznana.';
$string['feedbackerrorboundaryoutofrange'] = 'Granica oceny musi zawierać się w przedziale od 0% do 100%. Wartość granicy 1 jest poza zakresem.';
$string['feedbackerrorjunkinboundary'] = 'Musisz podać granice ocen bez przerw (luk).';
$string['feedbackerrorjunkinfeedback'] = 'Musisz wypełnić pola informacji zwrotnych bez przerw (luk).';
$string['feedbackerrororder'] = 'Granice ocen muszą być uporządkowane (najpierw najwyższa). Wartość wprowadzona w granicy {$a} jest w niewłaściwej kolejności.';
$string['file'] = 'Plik';
$string['fileformat'] = 'Format pliku';
$string['fillcorrect'] = 'Wypełnij poprawnymi';
$string['filloutnumericalanswer'] = 'Musisz podać co najmniej jedną możliwą odpowiedź i tolerancję. Punktacja i informacja zwrotna zostanie określona na podstawie pierwszej pasującej odpowiedzi. Na końcu możesz podać informację zwrotną bez odpowiedzi. Zostanie ona pokazana uczniom, których odpowiedź nie została przewidziana.';
$string['filloutoneanswer'] = 'Musisz stworzyć przynajmniej jedną odpowiedź. Pola odpowiedzi pozostawione puste będą ignorowane. Znak "*" może być stosowany jako symbol wieloznaczny zastępujący dowolna literę. Pierwsza pasująca odpowiedź będzie użyta do określenia oceny i informacji zwrotnej.';
$string['filloutthreequestions'] = 'Musisz wpisać przynajmniej trzy odpowiedzi. Pola odpowiedzi pozostawione puste będą ignorowane';
$string['fillouttwochoices'] = 'Musisz wpisać przynajmniej dwie odpowiedzi. Pola odpowiedzi pozostawione puste będą ignorowane';
$string['finishattemptdots'] = 'Zakończ próbę ...';
$string['finishreview'] = 'Zakończ ocenianie.';
$string['forceregeneration'] = 'wymuś regenerację';
$string['formatnotfound'] = 'Formatu importu/exportu {$a} nie znaleziono';
$string['formatnotimplemented'] = 'Format nie był poprawny, sprawdź wysłany raport błędów';
$string['formulaerror'] = 'Błąd formuły!';
$string['fractionsaddwrong'] = 'Wybrane odpowiedzi pozytywne nie sumują się do 100% <br />Teraz sumują się do {$a}% <br />Czy chcesz wrócić i poprawić pytanie?';
$string['fractionsnomax'] = 'Jedna z odpowiedzi powinna być warta 100% tak,<br />aby można było uzyskać maksymalną ocenę za to pytanie.<br />Czy chcesz wrócić i poprawić pytanie?';
$string['fromfile'] = 'z pliku:';
$string['functiondisabledbysecuremode'] = 'Ta funkcjonalność jest obecnie wyłączona';
$string['generalfeedback'] = 'Ogólna informacja zwrotna';
$string['generalfeedback_help'] = 'Ogólna informacja zwrotna to tekst wyświetlany po udzieleniu odpowiedzi na pytanie. W przeciwieństwie do informacji zwrotnej, która zależy od udzielonej odpowiedzi, ta informacja jest wyświetlana zawsze.';
$string['graceperiod'] = 'Okres karencji';
$string['graceperiod_help'] = 'Okres karencji można ustawić gdy opcja "Po upływie czasu" jest zaznaczona na istnienie okresu karencji w którym uczestnik ma możliwość zatwierdzenia swoich prób.';
$string['graceperiodmin'] = 'Okres karencji';
$string['graceperiodtoosmall'] = 'Okres karencji musi wynosić więcej niż {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceń wszystkie';
$string['gradeaverage'] = 'Średnia ocena';
$string['gradeboundary'] = 'Granica oceny';
$string['gradeessays'] = 'Ocena pytania \'Dłuższa odpowiedź\'';
$string['gradehighest'] = 'Najwyższa ocena';
$string['grademethod'] = 'Metoda oceniania';
$string['grademethod_help'] = '<P ALIGN=CENTER><B>Metoda oceniania</B></P>

<P>Jeżeli dozwolone są wielokrotne próby rozwiązania quizu, to istnieją różne sposoby wykorzystania ocen za poszczególne próby do obliczenia ostatecznej oceny za rozwiązanie quizu.

<P><B>Ocena najwyższa</B><P>
<UL>
<P>Oceną ostateczną jest najwyższa (najlepsza) ocena spośród wszystkich ocen za poszczególne próby.
</UL>

<P><B>Ocena średnia</B><P>
<UL>
<P>Oceną ostateczną jest średnia ocen za wszystkie próby.
</UL>

<P><B>Ocena pierwsza</B><P>
<UL>
<P>Oceną ostateczną jest ocena za pierwszą próbę rozwiązania (inne próby są zignorowane).
</UL>

<P><B>Ocena ostatnia</B><P>
<UL>
<P>Oceną ostateczną jest ocena przyznana za ostatnią próbę rozwiązania.
</UL>';
$string['gradesdeleted'] = 'Oceny quizu usunięte';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}';
$string['gradingdetails'] = 'Ocena dla tego zadania: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Z poprzednimi karami to daje <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'To podejście otrzymuje karę {$a}.';
$string['gradingdetailszeropenalty'] = 'Nie dostałeś kary za to zadanie.';
$string['gradingmethod'] = 'Metoda oceniania: {$a}';
$string['groupoverrides'] = 'Wyjątki grupowe';
$string['groupsnone'] = 'Brak grup w tym kursie';
$string['guestsno'] = 'Goście nie mogą oglądać ani rozwiązywać quizów';
$string['hidebreaks'] = 'Ukryj podział stron';
$string['hidereordertool'] = 'Ukryj narzędzie do porządkowania';
$string['history'] = 'Historia odpowiedzi:';
$string['howquestionsbehave_desc'] = 'Domyślne ustawienia dla zachowań pytań w quizie.';
$string['imagedisplay'] = 'Obrazek do wyświetlenia';
$string['import'] = 'Import';
$string['importcategory'] = 'importuj kategorię';
$string['importerror'] = 'Błąd podczas importu pliku';
$string['importfilearea'] = 'Importuj z pliku znajdującego się w plikach kursu';
$string['importfileupload'] = 'Import z pobranego pliku';
$string['importfromthisfile'] = 'Import z tego pliku';
$string['import_help'] = 'Funkcja ta pozwala na importowanie pytań z zewnętrznych plików tekstowych. Jeśli plik zawiera znaki spoza ASCII,  musi używać kodowania UTF-8. Bądź szczególnie ostrożny z plikami generowanych przez Microsoft Office, ponieważ często używają specjalnego kodowania, które nie będą prawidłowo obsługiwane. Import i eksport obsługiwane są przez wtyczki. Wiele opcjonalne formatów jest dostępnych w bazie modułów i wtyczek.';
$string['importingquestions'] = 'Importowanie {$a} pytań z pliku';
$string['importmax10error'] = 'Tu jest błąd w pytaniu. Nie można mieć więcej niż 10 odpowiedzi.';
$string['importmaxerror'] = 'W pytaniu występuje błąd. Zbyt dużo odpowiedzi.';
$string['importquestions'] = 'Importuj pytania z pliku';
$string['inactiveoverridehelp'] = '* Student nie ma poprawnej grupy lub roli aby rozwiązać quiz';
$string['incorrect'] = 'Niepoprawnie';
$string['indivresp'] = 'Indywidualne odpowiedzi na dane pytanie';
$string['info'] = 'Informacja';
$string['infoshort'] = 'info';
$string['inprogress'] = 'W toku';
$string['introduction'] = 'Wprowadzenie';
$string['invalidattemptid'] = 'Identyfikator próby nie istnieje';
$string['invalidcategory'] = 'ID kategorii jest niewłaściwe';
$string['invalidnumericanswer'] = 'Jedna z wprowadzonych odpowiedzi nie jest poprawną liczbą.';
$string['invalidnumerictolerance'] = 'Jedna z wprowadzonych tolerancji nie jest poprawną liczbą.';
$string['invalidoverrideid'] = 'Nieprawidłowe ID przy nadpisywaniu';
$string['invalidquestionid'] = 'Nieprawidłowe id pytania';
$string['invalidquizid'] = 'Nieprawidłowe ID quizu';
$string['invalidsource'] = 'Dane źródło nie są prawidłowe';
$string['invalidsourcetype'] = 'Niepoprawne dane źródłowe';
$string['invalidstateid'] = 'Niepoprawny status ID';
$string['lastanswer'] = 'Twoja ostatnia odpowiedź to';
$string['layout'] = 'Wygląd';
$string['layoutasshown'] = 'Układ strony jak widać';
$string['layoutasshownwithpages'] = 'Układ strony jak widać. <small>(Automatyczna nowa strona co {$a} pytań.)</small>';
$string['layoutshuffledandpaged'] = 'Ułóż pytania losowo, umieść {$a} pytań na stronę.';
$string['layoutshuffledsinglepage'] = 'Ułóż pytania losowo, wszystkie na jednej stronie.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista pytań w quizie';
$string['literal'] = 'Znak';
$string['loadingquestionsfailed'] = 'Przesyłanie pytań zakończone niepowodzeniem: {$a}';
$string['makecopy'] = 'Zachowaj jako nowe pytanie';
$string['managetypes'] = 'Edytuj typy pytań i serwery';
$string['manualgrading'] = 'Ocenianie';
$string['mark'] = 'Zatwierdź';
$string['markall'] = 'Zatwierdź stronę';
$string['marks'] = 'Punkty';
$string['marks_help'] = 'Punkty przyznane za odpowiedź na poszczególne pytania oraz wynik ogólny w ramach próby podejścia do testu.';
$string['match'] = 'Dopasuj odpowiedź';
$string['matchanswer'] = 'Pasująca odpowiedź';
$string['matchanswerno'] = 'Pasująca odpowiedź {$a}';
$string['max'] = 'Max.';
$string['messageprovider:attempt_overdue'] = 'Ostrzeżenie o przedawnieniu podejścia do quizu';
$string['messageprovider:confirmation'] = 'Powiadomienie o wypełnieniu twojego quizu';
$string['messageprovider:submission'] = 'Powiadomienie o wypełnieniu quizu';
$string['min'] = 'Min.';
$string['minutes'] = 'Minuty';
$string['missingcorrectanswer'] = 'Poprawna odpowiedź musi być określona';
$string['missingitemtypename'] = 'Pominięto nazwę';
$string['missingquestion'] = 'Wygląda na to, że to pytanie nie istnieje';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Moduł Quiz pozwala nauczycielowi na tworzenie testów składających się z pytań wielokrotnego wyboru, prawda-fałsz, dopasowywań i inne rodzajów. Każde podejście jest automatycznie oceniane, a prowadzący może decydować, czy wyświetlać informacje zwrotne i/lub poprawne odpowiedzi.';
$string['modulenameplural'] = 'Quizy';
$string['moveselectedonpage'] = 'Przesuń zaznaczone pytania na stronę: {$a}';
$string['multichoice'] = 'Wielokrotny wybór';
$string['multipleanswers'] = 'Wybierz co najmniej jedną odpowiedź';
$string['multiplier'] = 'Mnożnik';
$string['mustbesubmittedby'] = 'Próba musi być wykonana przez {$a}.';
$string['name'] = 'Imię';
$string['navmethod'] = 'Metoda nawigacji';
$string['navmethod_free'] = 'Dowolny';
$string['navmethod_help'] = 'W sekwencyjnym trybie nawigacji, student musi przejść przez quiz w określonej kolejności pytań, nie może wrócić do poprzedniego pytania, ani przeskoczyć do przodu';
$string['navmethod_seq'] = 'Sekwencyjny';
$string['navnojswarning'] = 'Uwaga: te linki nie zapiszą twoich odpowiedzi. Użyj następnego przycisku na dole strony.';
$string['neverallononepage'] = 'Nigdy, wszystkie pytania na jednej stronie';
$string['newattemptfail'] = 'Błąd: Nie można uruchomić na nowo quizu.';
$string['newpage'] = 'Nowa strona';
$string['newpageevery'] = 'Automatycznie rozpocznij nową stronę';
$string['newpage_help'] = '<p>Dla dłuższych quizów można podzielić quiz na strony. Przy wstawianiu pytania podział na strony będzie tworzony automatycznie zgodnie z tym ustawieniem. Można później ręcznie zmieniać granice strony.</p>';
$string['noanswers'] = 'Nie wybrano odpowiedzi!';
$string['noattempts'] = 'Nie ma podejść do quizu';
$string['noattemptsfound'] = 'Nie znaleziono prób.';
$string['noattemptstoshow'] = 'Nie ma żadnych podejść do pokazania';
$string['nocategory'] = 'Nieprawidłowa lub nieokreślona kategoria';
$string['noclose'] = 'Brak daty zamknięcia';
$string['nocommentsyet'] = 'Nie ma jeszcze komentarzy';
$string['noconnection'] = 'Nie ma obecnie łączności z serwerem, który może sprawdzić te pytanie. Proszę skontaktować się z administratorem.';
$string['nodataset'] = 'nic - to nie jest symbol specjalny';
$string['nodatasubmitted'] = 'Nie przesłano żadnych danych';
$string['noessayquestionsfound'] = 'Nie znaleziono ręcznie ocenionych pytań';
$string['nogradewarning'] = 'Ten quiz nie jest oceniany, więc nie można wprowadzić ogólnej informacji zwrotnej, która zależy od oceny.';
$string['nomoreattempts'] = 'Dalsze podejścia nie są dostępne';
$string['none'] = 'Żaden';
$string['noopen'] = 'Brak daty otwarcia';
$string['nooverridedata'] = 'Musisz nadpisać przynajmniej jedno z ustawień quizu.';
$string['nopossibledatasets'] = 'Brak zestawów';
$string['noquestionintext'] = 'Tekst pytania nie zawiera żadnych zamieszczonych pytań';
$string['noquestions'] = 'Nie dodano jeszcze żadnego pytania';
$string['noquestionsfound'] = 'Nie można znaleźć pytań';
$string['noquestionsinquiz'] = 'Brak pytań w tym quizie.';
$string['noquestionsnotinuse'] = 'To losowe pytanie nie może być użyte, odkąd jego kategoria jest pusta.';
$string['noquestionsonpage'] = 'Pusta strona';
$string['noresponse'] = 'Brak odpowiedzi';
$string['noreview'] = 'Nie możesz przeglądać tego quizu';
$string['noreviewattempt'] = 'Nie masz uprawnień do dokonania przeglądu tej próby.';
$string['noreviewshort'] = 'Niedozwolone';
$string['noreviewuntil'] = 'Nie możesz przeglądać tego quizu do {$a}';
$string['noreviewuntilshort'] = 'Dostępny {$a}';
$string['noscript'] = 'JavaScript musi być włączony, aby można było kontynuować!';
$string['notavailabletostudents'] = 'Uwaga: Ten quiz jest obecnie niedostępny dla studentów.';
$string['notenoughrandomquestions'] = 'Niestety nie ma wystarczająco dużo pytań w kategorii {$a->category}, by utworzyć pytanie {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nie zdefiniowano wystarczającej liczby podpunktów pytań! <br /> Czy chcesz wrócić i poprawić pytanie?';
$string['notimedependentitems'] = 'Czynniki zależne czasowo nie są w tej chwili wspierane przez moduł quizu. Tak jak dla całości pracy ustaw limit czasu dla całego quizu. Chcesz wybrać inny czynnik (lub mimo to używać obecnego)?';
$string['notyetgraded'] = 'Jeszcze nie ocenione';
$string['notyetviewed'] = 'Jeszcze nie wyświetlany';
$string['notyourattempt'] = 'To nie jest Twoja próba!';
$string['noview'] = 'Zalogowany użytkownik nie może zobaczyć tego quizu';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} wykonał {$a->attemptnum} podejść';
$string['numattemptsmade'] = 'Ten quiz próbowano rozwiązać {$a} razy.';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeryczne';
$string['numquestionsx'] = 'Pytania:  {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Tylko nauczyciele może eksportować pytania';
$string['onlyteachersimport'] = 'Tylko nauczyciele z prawami edycji mogą importować pytania';
$string['onthispage'] = 'Ta strona';
$string['open'] = 'Nie udzielono odpowiedzi';
$string['openclosedatesupdated'] = 'Zaktualizowano daty rozpoczęcia i zakończenia quizu.';
$string['optional'] = 'opcjonalny';
$string['orderandpaging'] = 'Zmiana układu stron i porządkowanie';
$string['orderandpaging_help'] = 'Numery 10, 20, 30, ... przy pytanich określają kolejność pytań. Odstępy co 10 pozwalają wstawić dodatkowe pytań pomiędzy. Aby zmienić kolejność pytań, należy zmienić numery, a następnie kliknąć przycisk "Zmiana kolejności pytań". Aby dodać podziały stron po poszczególnych pytaniach, zaznacz pola wyboru obok tych pytań, następnie kliknij przycisk "Dodaj nowe strony po zaznaczonych pytaniach".
Aby inaczej podzielić pytania na strony, kliknij przycisk \'Zmień układ stron\' i wybierz żądaną liczbę pytań na stronę.';
$string['orderingquiz'] = 'Zmiana układu stron i porządkowanie';
$string['orderingquizx'] = 'Zmiana układu stron i kolejności: {$a}';
$string['outof'] = '{$a->grade} z możliwych do uzyskania {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} z możliwych do uzyskania {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Całościowa informacja zwrotna';
$string['overallfeedback_help'] = '"Całościowa informacja zwrotna" to tekst wyświetlany po zakończeniu podejścia do quizu. Można wyświetlać różne informacje, w zależności od osiągniętych ocen, podając przedziały ocen (jako procenty lub liczby).';
$string['overdue'] = 'Zaległy';
$string['overduehandling'] = 'Po upływie czasu';
$string['overduehandlingautoabandon'] = 'Próby muszą być zatwierdzone przed upływem czasu lub nie są liczone';
$string['overduehandlingautosubmit'] = 'Otwarte podejścia są zapisywane automatycznie';
$string['overduehandling_desc'] = 'Co powinno się zdarzyć, jeśli uczeń nie zatwierdzi quizu przed upływem czasu.';
$string['overduehandlinggraceperiod'] = 'Istnieje okres karencji, gdy otwarte próby muszą być zatwierdzone, ale nie jest możliwe odpowiadanie na kolejne pytania.';
$string['overduehandling_help'] = 'Za pomocą tego ustawienia można zadecydować o tym co się stanie gdy uczestnik nie zatwierdzi próby a skończy się czas przydzielony na rozwiązanie tego testu. Jeśli uczestnik nadal pracuje w teście - wszelkie podejścia zostaną zapisane. Jeśli natomiast nastąpi wylogowanie się - wtedy za pomocą tego ustawienia możemy precyzyjnie określić - jakiego działania oczekujemy.';
$string['override'] = 'Wyjątki';
$string['overridedeletegroupsure'] = 'Czy jesteś pewien, że chcesz usunąć specjalne warunki quizu dla grupy {$a}?';
$string['overridedeleteusersure'] = 'Czy jesteś pewien, że chcesz usunąć specjalne warunki quizu dla użytkownika {$a}?';
$string['overridegroup'] = 'Nadpisz grupę';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}
';
$string['overrides'] = 'Nadpisywanie';
$string['overrideuser'] = 'Użytkownicy objęci zmianami';
$string['overrideusereventname'] = '{$a->quiz} - nadpisanie';
$string['page-mod-quiz-edit'] = 'Strona edycji quizu';
$string['page-mod-quiz-x'] = 'Dowolna strona quizu';
$string['pagesize'] = 'Liczba podejść na stronę:';
$string['parent'] = 'Nadrzędny';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parsingquestions'] = 'Przetwarzanie pytań z importowanego pliku.';
$string['partiallycorrect'] = 'Częściowo poprawnie';
$string['penalty'] = 'Kara';
$string['penaltyscheme'] = 'Zastosuj kary';
$string['penaltyscheme_help'] = '<p> Jeżeli quiz jest uruchomiaony w odpowiednim trybie student może spróbować ponownie rozwiązać quiz po tym jak źle odpowie. W tym przypadku można chciać nakładać kary dla złych odpowiedzi odejmowane od końcowej oceny za pytanie. Ilość sankcji karnej jest wybierana indywidualnie dla każdego pytania podczas tworzenia albo edycji pytania. </p>

<p>Ustawienie nie ma żadnego wpływu jeżeli quiz nie jest uruchomiony w odpowiednim trybie.</p>';
$string['percentcorrect'] = 'Procent poprawnych odpowiedzi';
$string['pleaseclose'] = 'Żądanie zostało wykonane. Można już zamknąć okno.';
$string['pluginadministration'] = 'Administracja quizu';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Pokaż quiz w "bezpiecznym" oknie';
$string['popupblockerwarning'] = 'Być może będziesz musiał rozwiązać quiz w bezpiecznym oknie. Wyłącz blokadę okien wyskakujących.';
$string['popupnotice'] = 'Studenci będą widzieć ten quiz w "bezpiecznym" oknie';
$string['preprocesserror'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['preview'] = 'Podgląd';
$string['previewquestion'] = 'Podgląd pytania';
$string['previewquiz'] = 'Podgląd {$a}';
$string['previewquiznow'] = 'Pokaż podgląd quizu';
$string['previous'] = 'Poprzedni stan';
$string['publish'] = 'Opublikuj';
$string['publishedit'] = 'Musisz mieć odpowiednie uprawnienia w kursie aby dodawać lub edytować pytania w tej kategorii';
$string['qbrief'] = 'Pyt. {$a}';
$string['qname'] = 'nazwa';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'typ, nazwa';
$string['question'] = 'Pytanie';
$string['questionbankcontents'] = 'Zawartość bazy pytań';
$string['questionbankmanagement'] = 'Zarządzanie pytaniami';
$string['questionbehaviour'] = 'Zachowanie pytań';
$string['questioncats'] = 'Kategorie pytań';
$string['questiondeleted'] = 'To pytanie zostało usunięte. Skontaktuj się ze swoim nauczycielem';
$string['questioninuse'] = 'Pytanie \'{$a->questionname}\' jest używane w: <br />{$a->quiznames}<br />To pytanie nie zostanie usunięte z tych quizów, lecz tylko z listy kategorii.';
$string['questionname'] = 'Nazwa pytania';
$string['questionnonav'] = '<span class="accesshide">Pytanie </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacja</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pytanie {$a} nie zostało załadowane z bazy danych';
$string['questionorder'] = 'Kolejność pytań';
$string['questionposition'] = 'Nowe położenie na liście pytania {$a}';
$string['questions'] = 'Pytania';
$string['questionsinclhidden'] = 'Pytania (również ukryte)';
$string['questionsinthisquiz'] = 'Pytania tego quizu';
$string['questionsperpage'] = 'Pytań na stronie';
$string['questionsperpageselected'] = 'Liczba pytań na stronie została ustawiona, co wymusza podział na strony. Dlatego kontrolni podziału na strony są nieaktywne. Można to zmienić w {$a}';
$string['questionsperpagex'] = 'Pytań na stonę: {$a}';
$string['questiontext'] = 'Tekst pytania';
$string['questiontextisempty'] = '[Pusty tekst pytania]';
$string['questiontype'] = 'Pytanie typu {$a}';
$string['questiontypesetupoptions'] = 'Ustawienia dla typów pytań:';
$string['quiz:addinstance'] = 'Dodaj nowy quiz';
$string['quiz:attempt'] = 'Rozwiąż quizy';
$string['quizavailable'] = 'Quiz jest dostępny do: {$a}';
$string['quizclose'] = 'Zamknij quiz';
$string['quizclosed'] = 'Ten quiz został zamknięty {$a}';
$string['quizcloses'] = 'Quiz kończy się';
$string['quizcloseson'] = 'Ten quiz zakończy się {$a}';
$string['quiz:deleteattempts'] = 'Usuń podejścia do quizów';
$string['quiz:emailconfirmsubmission'] = 'Potwierdź e-mailem wysłanie swojego podejścia';
$string['quiz:emailnotifysubmission'] = 'Powiadom e-mailem, że wysłano podejście';
$string['quiz:emailwarnoverdue'] = 'Otrzymuje informację kiedy czas podejścia się się kończy i należy zakończyć quiz.';
$string['quiz:grade'] = 'Oceniaj quizy ręcznie';
$string['quiz:ignoretimelimits'] = 'Ignoruje limit czasu w quizach';
$string['quizisclosed'] = 'Ten quiz jest zamknięty';
$string['quizisclosedwillopen'] = 'Quiz zamknięty (zostanie otwarty {$a})';
$string['quizisopen'] = 'Ten quiz jest otwarty';
$string['quizisopenwillclose'] = 'Quiz otwarty (do {$a})';
$string['quiz:manage'] = 'Zarządzaj quizami';
$string['quiz:manageoverrides'] = 'Zarządzaj nadpisywaniem warunków quizu';
$string['quiznavigation'] = 'Nawigacja w quizie';
$string['quizopen'] = 'Otwórz quiz';
$string['quizopenclose'] = 'Daty otwarcia i zamknięcia';
$string['quizopenclose_help'] = 'Studenci mogą zacząć podejścia po dacie otwarcia, muszę je skończyć przed datą zamknięcia.';
$string['quizopened'] = 'Ten quiz jest otwarty.';
$string['quizopenedon'] = 'Ten quiz zostanie otwarty {$a}';
$string['quizopens'] = 'Quiz się otwiera';
$string['quizopenwillclose'] = 'Ten quiz jest otwarty (zostanie zamknięty {$a})';
$string['quiz:preview'] = 'Podgląd quizów';
$string['quiz:regrade'] = 'Oceń ponownie podejścia';
$string['quiz:reviewmyattempts'] = 'Zobacz swoje rozwiązania';
$string['quizsettings'] = 'Ustawienia quizu';
$string['quiztimer'] = 'Stoper quizu';
$string['quiz:view'] = 'Pokaż informacje o quizie';
$string['quiz:viewreports'] = 'Oglądaj raporty quizów';
$string['quizwillopen'] = 'Ten quiz zostanie otwarty {$a}';
$string['random'] = 'Pytanie wybierane losowo';
$string['randomcreate'] = 'Utwórz pytania wybierane losowo';
$string['randomfromcategory'] = 'Pytanie wybierane losowo z kategorii:';
$string['randomfromexistingcategory'] = 'Pytanie wybierane losowo z istniejącej kategorii';
$string['randomnosubcat'] = 'Pytania tylko z tej kategorii, z wyłączeniem subkategorii';
$string['randomquestionusinganewcategory'] = 'Pytanie wybierane losowo wykorzystujące nową kategorię';
$string['randomwithsubcat'] = 'Pytania z tej kategorii i jej podkategorii.';
$string['readytosend'] = 'Za chwilę twoje podejście do quizu zostanie przesłane do ocenienia. Czy chcesz kontynuować?';
$string['reattemptquiz'] = 'Ponownie rozwiąż quiz';
$string['recentlyaddedquestion'] = 'Ostatnio dodane pytanie!';
$string['recurse'] = 'Uwzględnij również pytania z podkategorii';
$string['regrade'] = 'Ponownie oceń wszystkie próby';
$string['regradecomplete'] = 'Wszystkie próby zostały ponownie ocenione';
$string['regradecount'] = 'Zmieniono {$a->changed} z {$a->attempt} ocen';
$string['regradedisplayexplanation'] = 'Próby, które zostały zmienione podczas ponownego oceniania, są pokazane jako łącza';
$string['regradenotallowed'] = 'Nie masz uprawnień do ponownej oceny tego quizu.';
$string['regradingquestion'] = 'Oceń ponownie "{$a}"';
$string['regradingquiz'] = 'Oceń ponownie quiz "{$a}"';
$string['remove'] = 'Usuń';
$string['removeallquizattempts'] = 'Usuń wszystkie podejścia';
$string['removeemptypage'] = 'Usuń pustą stronę';
$string['removeselected'] = 'Usuń zaznaczone';
$string['rename'] = 'Zmień nazwę';
$string['renderingserverconnectfailed'] = 'Serwer {$a} jest niedostępny. Sprawdź, czy adres URL jest poprawny.';
$string['reorderquestions'] = 'Zmień kolejność pytań';
$string['reordertool'] = 'Pokaż narzędzia do reorganizacji';
$string['repaginate'] = 'Zmień układ stron na {$a} pytań na stronę';
$string['repaginatecommand'] = 'Zmień układ stron';
$string['repaginatenow'] = 'Zmień układ stron teraz';
$string['replace'] = 'Zastąp';
$string['replacementoptions'] = 'Zmień opcje';
$string['report'] = 'Raporty';
$string['reportanalysis'] = 'Analiza elementów';
$string['reportattemptsfrom'] = 'Podejścia od';
$string['reportattemptsthatare'] = 'Podejścia które są';
$string['reportdisplayoptions'] = 'Wyświetl opcje';
$string['reportfullstat'] = 'Szczegółowe statystyki';
$string['reportmulti_percent'] = 'Multi-Procenty*';
$string['reportmulti_q_x_student'] = 'Wybory wielu studentów';
$string['reportmulti_resp'] = 'Indywidualne odpowiedzi';
$string['reportmustselectstate'] = 'Musisz wybrać przynajmniej jeden stan.';
$string['reportnotfound'] = 'Nieznany raport ({$a})';
$string['reportoverview'] = 'Przegląd';
$string['reportregrade'] = 'Ponownie oceń próby';
$string['reportresponses'] = 'Szczegółowe odpowiedzi';
$string['reports'] = 'Raporty';
$string['reportshowonly'] = 'Pokaż tylko podejścia';
$string['reportsimplestat'] = 'Proste statystyki';
$string['reportusersall'] = 'wszyscy użytkownicy, którzy próbowali rozwiązać quiz';
$string['reportuserswith'] = 'zapisani użytkownicy, którzy próbowali rozwiązać quiz';
$string['reportuserswithorwithout'] = 'zapisani użytkownicy, którzy próbowali, lub nie, rozwiązać quiz';
$string['reportuserswithout'] = 'zapisani użytkownicy, którzy nie próbowali rozwiązać quizu';
$string['reportwhattoinclude'] = 'Co zawrzeć w raporcie';
$string['requirepassword'] = 'Wymagane hasło';
$string['requirepassword_help'] = '<p>To pole jest opcjonalne</p>

<p>Jeśli wpiszesz tutaj hasło, studenci bedą musieli je podać aby
wypełnić quiz.</p>';
$string['requiresubnet'] = 'Potrzebny adres sieci';
$string['requiresubnet_help'] = '<p align=center><b>Wymagaj adresu w sieci</b></p>

<p>To pole jest opcjonalne.</p>

<p>Możesz ograniczyć dostęp do quizu do konkretnych studentów
łączących się za pomocą sieci LAN lub Internetu definiując listę oddzielonych przecinkami pełnych lub częściowych adresów IP.</p>

<p>Przykład:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Są dostępne trzy sposoby zapisu adresu IP (nie możesz używać
nazwy hostów czy domeny, tylko adresy IP):
<ol>
<li>Pełen adres IP, taki jak <b>192.168.10.1</b> który jest przypisany do jednego komputera lub do serwera proxy.</li>
<li>Częściowy adres, taki jak <b>192.168</b>, który wpuści wszystkie adresy zaczynające się od tych cyfr.</li>
<li>Zapis CIDR, taki jak <b>231.54.211.0/20</b>, który zezwala Ci na zdefiniowanie konkretnych podsieci.</li>
</ol>
</p>

<p>Spacje są ignorowane.</p>';
$string['response'] = 'Odpowiedź';
$string['responses'] = 'Udzielone odpowiedzi';
$string['results'] = 'Wyniki';
$string['returnattempt'] = 'Powrót do podejścia';
$string['reuseifpossible'] = 'ponownie użyj poprzednio skasowane';
$string['reverttodefaults'] = 'Przywróć domyślne ustawienia quizu';
$string['review'] = 'Przegląd';
$string['reviewafter'] = 'Pozwól przeglądać po zamknięciu quizu';
$string['reviewalways'] = 'Pozwól przeglądać w dowolnym momencie';
$string['reviewattempt'] = 'Przegląd podejścia';
$string['reviewbefore'] = 'Pozwól przeglądać, gdy quiz jest otwarty';
$string['reviewclosed'] = 'Po zamknięciu quizu';
$string['reviewduring'] = 'Podczas próby';
$string['reviewimmediately'] = 'Natychmiast po próbie';
$string['reviewnever'] = 'Nigdy nie pozwalaj przeglądać';
$string['reviewofattempt'] = 'Przerzyj próbę {$a}';
$string['reviewofpreview'] = 'Przegląd podglądu';
$string['reviewopen'] = 'Później, gdy quiz jest wciąż otwarty';
$string['reviewoptions'] = 'Student może przeglądać';
$string['reviewoptionsheading'] = 'Opcje przeglądu';
$string['reviewoptionsheading_help'] = 'Opcje te decydują, jaką informację i kiedy mogą zobaczyć studenci, gdy przeglądają podejścia do quizu lub raporty quizu.

"Natychmiast po próbie" oznacza w ciągu dwóch minut po zakończeniu. "Później, gdy quiz jest wciąż otwarty" oznacza po dwóch minutach, a przed datą zamknięcia quizu. "Po zamknięciu quizu" oznacza czas, gdy data zamknięcia quizu minęła. Jeżeli quiz nie ma daty zamknięcia, ten stan nie zostanie nigdy osiągnięty.';
$string['reviewoverallfeedback'] = 'Całościowa informacja zwrotna';
$string['reviewoverallfeedback_help'] = 'Informacja zwrotna wyświetlana na końcu podejścia, w zależności od osiągniętej oceny';
$string['reviewresponse'] = 'Przejrzyj odpowiedzi';
$string['reviewresponsetoq'] = 'Przejrzyj odpowiedź (pytanie {$a})';
$string['reviewthisattempt'] = 'Przejrzyj Twoje odpowiedzi w tym podejściu';
$string['rqp'] = 'Obce (zdalne) pytanie';
$string['rqps'] = 'Obce (zdalne) pytania';
$string['sameasoverall'] = 'Takie same ustawienia jak dla ocen całkowitych';
$string['save'] = 'Zapisz';
$string['saveandedit'] = 'Zapisz zmiany i edytuj pytania';
$string['saveattemptfailed'] = 'Nie udało się zapisać bieżącej próby rozwiązania testu';
$string['savedfromdeletedcourse'] = 'Zachowany z usuniętego kursu "{$a}"';
$string['savegrades'] = 'Zapisz oceny';
$string['savemyanswers'] = 'Zapisz moje odpowiedzi';
$string['savenosubmit'] = 'Zapisz bez wysyłania rozwiązania';
$string['saveoverrideandstay'] = 'Zapisz i wprowadzaj następne zmiany';
$string['savequiz'] = 'Zapisz cały quiz';
$string['saving'] = 'Zapisywanie';
$string['savingnewgradeforquestion'] = 'Zapisywanie nowej oceny dla pytania o id {$a}.';
$string['savingnewmaximumgrade'] = 'Zapisywanie nowej maksymalnej oceny.';
$string['score'] = 'Wynik';
$string['scores'] = 'Punkty';
$string['select'] = 'Wybierz';
$string['selectall'] = 'Wybierz wszystkie';
$string['selectcategory'] = 'Wybierz kategorię';
$string['selectedattempts'] = 'Wybrane podejścia...';
$string['selectnone'] = 'Odznacz wszystkie';
$string['selectquestiontype'] = '-- Wybierz typ pytania --';
$string['serveradded'] = 'Dodaj serwer';
$string['serveridentifier'] = 'Identyfikator';
$string['serverinfo'] = 'Informacje serwera';
$string['servers'] = 'Serwery';
$string['serverurl'] = 'Adres URL serwera';
$string['settingsoverrides'] = 'Nadpisywanie ustawień';
$string['shortanswer'] = 'Krótka odpowiedź';
$string['show'] = 'Pokaż';
$string['showall'] = 'Pokaż wszystkie pytania na stronie';
$string['showblocks'] = 'Pokaż bloki kursu podczas rozwiązywania quizu';
$string['showblocks_help'] = 'Jeśli aktywne, normalne bloki będą wyświetlane podczas rozwiązywania quizu';
$string['showbreaks'] = 'Pokaż granice strony';
$string['showcategorycontents'] = 'Pokaż zawartość kategorii {$a->arrow}';
$string['showcorrectanswer'] = 'Czy informacja zwrotna ma zawierać poprawne odpowiedzi?';
$string['showdetailedmarks'] = 'Pokaż szczegóły';
$string['showeachpage'] = 'Pokaż jedną stronę na raz';
$string['showfeedback'] = 'Wyświetlić informację zwrotną po udzieleniu odpowiedzi?';
$string['showinsecurepopup'] = 'Pokaż quiz w \'bezpiecznym\' oknie';
$string['showlargeimage'] = 'Duże zdjęcie';
$string['shownoattempts'] = 'Pokaż studentów, którzy nie podeszli do quizu';
$string['shownoattemptsonly'] = 'Pokaż tylko tych studentów, którzy nie podeszli do quizu';
$string['shownoimage'] = 'Bez zdjęcia';
$string['showreport'] = 'Pokaż raport';
$string['showsmallimage'] = 'Małe zdjęcie';
$string['showteacherattempts'] = 'Pokaż próby';
$string['showuserpicture'] = 'Pokaż zdjęcie użytkownika';
$string['showuserpicture_help'] = 'Jeśli opcja jest włączona, nazwisko i zdjęcie studenta pojawi się na ekranie w czasie rozwiązywania quizu, dzięki czemu łatwiej będzie sprawdzić tożsamość  studenta.';
$string['shuffle'] = 'Zmień kolejność';
$string['shuffleanswers'] = 'Zmień kolejność odpowiedzi';
$string['shuffledrandomly'] = 'Ułóż losowo';
$string['shufflequestions'] = 'Zmień kolejność pytań';
$string['shufflequestionsselected'] = 'Losowa kolejność pytań jest aktywna, więc pewne operacje na stronach nie są dostępne. Aby zmienić ustawienie losowej kolejności, {$a}';
$string['shufflewithin'] = 'Zmień kolejność wewnątrz pytania';
$string['shufflewithin_help'] = 'Jeśli opcja jest włączona, możliwe odpowiedzi do każdego pytania będą losowo wymieszane, o ile opcja ta jest także włączona w ustawieniach samego pytania. To ustawienie ma zastosowanie tylko do pytań, które mają wiele wariantów odpowiedzi, takich jak wielokrotny wybór lub dopasowanie.';
$string['singleanswer'] = 'Wybierz odpowiedź';
$string['sortage'] = 'Sortuj według wieku';
$string['sortalpha'] = 'Sortuj według nazwy';
$string['sortquestionsbyx'] = 'Sortuj pytania wg: {$a}';
$string['sortsubmit'] = 'Sortuj pytania';
$string['sorttypealpha'] = 'Sortuj według typu, nazwy';
$string['specificapathnotonquestion'] = 'Tej ścieżki do pliku nie ma w tym pytaniu';
$string['specificquestionnotonquiz'] = 'Tego pytania nie ma w tym quizie.';
$string['startagain'] = 'Zacznij od nowa';
$string['startattempt'] = 'Rozpocznij próbę';
$string['startedon'] = 'Rozpoczęto';
$string['startnewpreview'] = 'Rozpocznij nowy podgląd';
$string['stateabandoned'] = 'Nigdy nie złożony';
$string['statefinished'] = 'Zakończony';
$string['statefinisheddetails'] = 'Złożony {$a}';
$string['stateinprogress'] = 'W toku';
$string['statenotloaded'] = 'Stan pytania {$ a} nie został załadowany z bazy danych';
$string['stateoverdue'] = 'Zaległe';
$string['stateoverduedetails'] = 'Musi być przesłane przez {$a}';
$string['status'] = 'Stan';
$string['stoponerror'] = 'Zatrzymaj na błędzie';
$string['submitallandfinish'] = 'Zatwierdź wszystkie i zakończ';
$string['subneterror'] = 'Możesz podejść do quizu tylko z pewnych miejsc. Obecnie twój komputer nie znajduje się w takim miejscu.';
$string['subnetnotice'] = 'Możesz podejść do quizu tylko z pewnych miejsc. Obecnie twój komputer znajduje się w takim miejscu. Jako nauczyciel, możesz jednak dokonać podglądu quizu.';
$string['subplugintype_quiz'] = 'Raport';
$string['subplugintype_quizaccess'] = 'Reguła dostępu';
$string['subplugintype_quizaccess_plural'] = 'Reguły dostępu';
$string['subplugintype_quiz_plural'] = 'Raporty';
$string['substitutedby'] = 'zastanie zastąpiony przez';
$string['summaryofattempt'] = 'Podsumowanie próby';
$string['summaryofattempts'] = 'Podsumowanie twoich poprzednich podejść';
$string['temporaryblocked'] = 'Tymczasowo nie możesz ponownie rozwiązać quizu. Będziesz miał taka możliwość za:';
$string['theattempt'] = 'Próba';
$string['theattempt_help'] = 'W tym ustawieniu można zadecydować o tym czy uczestnik może mieć wgląd w swoje próby podejścia do testu.';
$string['time'] = 'Czas';
$string['timecompleted'] = 'Zakończono';
$string['timedelay'] = 'Nie możesz rozpocząć quizu, gdyż nie upłynął ustalony czas pomiędzy kolejnymi quizami';
$string['timeleft'] = 'Pozostały czas';
$string['timelimit'] = 'Limit czasu';
$string['timelimitexeeded'] = 'Upłynął limit czasu!';
$string['timelimit_help'] = '<p align="center"><strong>Ograniczenie czasowe</strong></p>

<p>Domyślnie quizy nie mają ograniczenia czasowego. Student więc ma tyle czasu ile mu potrzeba na wypełnienie quizu.

<p>Jeśli ustalisz ograniczenie czasowe, Moodle robi kilka rzeczy aby
zapewnić jego przestrzeganie:</p>

<ul>
  <li>Wymagana jest obsługa JS w przeglądarce - dzięki temu działa stoper.</li>
  <li>Na stronie pokazuje się stoper odliczający czas.</li>
  <li>Gdy czas dobiegnie końca, quiz jest automatycznie wysyłany z takimi odpowiedziami,
  jakich udzielił do tej pory student.</li>
  <li>Jeśli studentowi udało się oszukać i poświęcił na quiz więcej niż 60 sekund ponad limit, otrzyma ocenę równą 0.</li>
</ul>';
$string['timelimitmin'] = 'Limit czasu (w minutach)';
$string['timelimitsec'] = 'Limit czasu (w sekundach)';
$string['timestr'] = '%H:%M:%S na %d/%m/%y';
$string['timesup'] = 'Koniec czasu';
$string['timetaken'] = 'Wykorzystany czas';
$string['timing'] = 'Czas';
$string['tofile'] = 'do pliku';
$string['tolerance'] = 'Tolerancja';
$string['toomanyrandom'] = 'Liczba potrzebnych pytań wybieranych losowo jest większa od liczby pytań w tej kategorii! ({$a})';
$string['top'] = 'Góra';
$string['totalmarksx'] = 'Łączna punktacja: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Łącznie {$a} pytań w kategorii.';
$string['true'] = 'Prawda';
$string['truefalse'] = 'Prawda/Fałsz';
$string['type'] = 'Typ';
$string['unfinished'] = 'otwórz';
$string['ungraded'] = 'Nie ocenione';
$string['unit'] = 'Jednostka';
$string['unknowntype'] = 'Nie można odnaleźć tego typu pytania w linii {$a}. Pytanie zostanie zignorowane.';
$string['unusedcategorydeleted'] = 'Kategoria została usunięta, gdyż, po usunięciu kursu jej pytania nie były wykorzystane.';
$string['updatesettings'] = 'Uaktualnij ustawienia quizu';
$string['updatingatttemptgrades'] = 'Uaktualnienie ocen podejść';
$string['updatingfinalgrades'] = 'Uaktualnienie ocen końcowych';
$string['updatingthegradebook'] = 'Uaktualnienie dziennika ocen';
$string['upgradesure'] = '<div style="color: red;">Moduł quiz przeszedł szereg zmian. Uaktualnienie quizów nie zostało jeszcze dostatecznie sprawdzone. Dla bezpieczeństwa zalecamy zrobienie kopii zapasowych tabel z quizami przed przystąpieniem do uaktualnienia.</div>';
$string['upgradingquizattempts'] = 'Uaktualniam podejścia do quizu {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Uaktualniam bardzo stare podejścia do quizu {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Kategoria zostanie zachowana i przesunięta, ponieważ jej pytania są używane w innych kursach.';
$string['useroverrides'] = 'Wyjątki użytkownika';
$string['usersnone'] = 'Studenci nie mają dostępu do tego quizu';
$string['validate'] = 'Sprawdź';
$string['viewallanswers'] = 'Przeglądaj {$a} ukończonych quizów';
$string['viewallreports'] = 'Obejrzyj raporty dla {$a} podejść';
$string['viewed'] = 'Wyświetlony';
$string['warningmissingtype'] = '<p><b>Ten typ pytania nie jest jeszcze zainstalowany<br/>Poinformuj o tym Administratora Platformy Moodle.</b></p>';
$string['wheregrade'] = 'Gdzie jest moja ocena?';
$string['wildcard'] = 'Symbol specjalny';
$string['windowclosing'] = 'To okno zostanie niedługo zamknięte';
$string['withsummary'] = 'wraz z ogólną statystyką';
$string['wronguse'] = 'Nie można wyświetlić strony';
$string['xhtml'] = 'Format XHTML';
$string['youneedtoenrol'] = 'Aby móc rozwiązywać ten quiz, musisz najpierw zapisać się do tego kursu.';
$string['yourfinalgradeis'] = 'Twoja końcowa ocena za ten quiz wynosi {$a}';
