<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'pl', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'zostanie za chwilę zainstalowany';
$string['action'] = 'Akcja';
$string['actionchoice'] = 'Co chcesz zrobić z plikiem \'{$a}\'?';
$string['actions'] = 'Akcje';
$string['active'] = 'Aktywny(a)';
$string['activeusers'] = 'Aktywni użytkownicy';
$string['activities'] = 'Aktywności';
$string['activities_help'] = 'Aktywności, takie jak forum quizy i wiki umożliwiają dodanie interaktywnych treści do kursu.';
$string['activity'] = 'Aktywność';
$string['activityclipboard'] = 'Przenoszenie aktywności: {$a}';
$string['activityiscurrentlyhidden'] = 'Ta aktywność jest obecnie ukryta';
$string['activitymodule'] = 'Moduł aktywności';
$string['activitymodules'] = 'Moduły aktywności';
$string['activityreport'] = 'Raport aktywności';
$string['activityreports'] = 'Raporty aktywności';
$string['activityselect'] = 'Wybierz aktywność, która ma być przeniesiona';
$string['activitysince'] = 'Aktywność od {$a}';
$string['activityweighted'] = 'Aktywności na użytkownika';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj składową...';
$string['addactivitytosection'] = 'Dodaj aktywność do sekcji \'{$a}\'';
$string['addadmin'] = 'Dodaj administratora';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentarz ...';
$string['addcountertousername'] = 'Utwórz użytkownika poprzez dodanie liczby do nazwy użytkownika';
$string['addcreator'] = 'Dodaj autora kursu';
$string['adddots'] = 'Dodaj ...';
$string['added'] = 'Dodano {$a}';
$string['addedrecip'] = 'Dodano {$a} nowego odbiorcę';
$string['addedrecips'] = 'Dodano {$a} nowych odbiorców';
$string['addedtogroup'] = 'Dodano do grupy {$a}';
$string['addedtogroupnot'] = 'Nie dodano do grupy {$a}';
$string['addedtogroupnotenrolled'] = 'Nie dodano do grupy {$a}, ponieważ ta osoba nie jest uczestnikiem kursu';
$string['addfilehere'] = 'Dodaj plik(i) tutaj';
$string['addinganew'] = 'Dodawanie: {$a}';
$string['addinganewto'] = 'Dodawanie nowego {$a->what} do {$a->to}';
$string['addingdatatoexisting'] = 'Dodawanie danych do istniejących';
$string['additionalnames'] = 'Dodatkowe nazwy';
$string['addlinkhere'] = 'Dodaj link tutaj';
$string['addnewcategory'] = 'Dodaj nową kategorię';
$string['addnewcourse'] = 'Dodaj nowy kurs';
$string['addnewuser'] = 'Dodaj nowego użytkownika';
$string['addnousersrecip'] = 'Dodaj użytkowników, którzy nie uzyskali dostępu do {$a} do listy odbiorców';
$string['addpagehere'] = 'Dodaj tekst tutaj';
$string['addresource'] = 'Dodaj zasób...';
$string['addresourceoractivity'] = 'Dodaj aktywność lub zasób';
$string['addresourcetosection'] = 'Dodaj zasób do sekcji \'{$a}\'';
$string['address'] = 'Adres';
$string['addstudent'] = 'Dodaj studenta';
$string['addsubcategory'] = 'Dodaj podkategorię';
$string['addteacher'] = 'Dodaj prowadzącego';
$string['admin'] = 'Administracja';
$string['adminhelpaddnewuser'] = 'Aby ręcznie utworzyć nowe konto użytkownika';
$string['adminhelpassignadmins'] = 'Administratorzy mogą zmieniać wszystkie ustawienia i dowolnie się przemieszczać w obrębie tego serwisu';
$string['adminhelpassigncreators'] = 'Autorzy kursów mogą tworzyć nowe kursy';
$string['adminhelpassignsiteroles'] = 'Przypisz zdefiniowane role w serwisie konkretnym użytkownikom';
$string['adminhelpassignstudents'] = 'Przejdź do kursu i dodaj studentów w menu Administracja';
$string['adminhelpauthentication'] = 'Możesz korzystać z wewnętrznych kont użytkowników lub z zewnętrznej bazy danych';
$string['adminhelpbackup'] = 'Skonfiguruj opcje automatycznego tworzenia kopii zapasowych';
$string['adminhelpconfiguration'] = 'Konfiguracja wyglądu i działania serwisu';
$string['adminhelpconfigvariables'] = 'Konfiguracja zmiennych odpowiedzialnych za działanie serwisu';
$string['adminhelpcourses'] = 'Zdefiniuj kursy i kategorie, dodaj do nich użytkowników, edytuj kursy oczekujące';
$string['adminhelpeditorsettings'] = 'Zdefiniuj podstawowe parametry edytora HTML';
$string['adminhelpedituser'] = 'Przeglądaj listę kont użytkowników i modyfikuj dowolne z nich';
$string['adminhelpenvironment'] = 'Sprawdź, czy Twój serwer spełnia wymaganiom bieżącej i przyszłej instalacji';
$string['adminhelpfailurelogs'] = 'Przeglądaj logi nieudanych logowań';
$string['adminhelplanguage'] = 'Do sprawdzania i edycji aktualnego pakietu językowego';
$string['adminhelplogs'] = 'Przejrzyj logi wszystkich działań w obrębie serwisu';
$string['adminhelpmanageblocks'] = 'Zarządzaj zainstalowanymi blokami i ich ustawieniami';
$string['adminhelpmanagedatabase'] = 'Bezpośredni dostęp do bazy danych (ostrożnie!)';
$string['adminhelpmanagefilters'] = 'Określ filtry tekstu i inne parametry';
$string['adminhelpmanagemodules'] = 'Zarządzaj zainstalowanymi modułami i ich ustawieniami';
$string['adminhelpmanageroles'] = 'Utwórz i zdefiniuj role, które mogą być przypisane użytkownikom';
$string['adminhelpmymoodle'] = 'Konfiguruj blok \'Mój Moodle\' dla użytkowników';
$string['adminhelpreports'] = 'Ranking kursów z uwzględnieniem różnorodnych kryteriów';
$string['adminhelpsitefiles'] = 'Do publikowania plików ogólnych lub przesyłania zewnętrznych kopii zapasowych';
$string['adminhelpsitesettings'] = 'Definiuj wygląd strony głównej serwisu';
$string['adminhelpstickyblocks'] = 'Skonfiguruj wymuszone bloki Moodle';
$string['adminhelpthemes'] = 'Zdefiniuj wyglądu serwisu (kolory, czcionki itp.)';
$string['adminhelpuploadusers'] = 'Importuj konta użytkowników z pliku tekstowego';
$string['adminhelpusers'] = 'Zdefiniuj użytkowników i mechanizm uwierzytelniania';
$string['adminhelpxmldbeditor'] = 'Interfejs do edycji plików XMLDB.';
$string['administration'] = 'Administracja';
$string['administrationsite'] = 'Administracja serwisu';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorzy mogą robić wszystko we wszystkich kursach w obrębie serwisu';
$string['administrators'] = 'Administratorzy';
$string['administratorsall'] = 'Wszyscy administratorzy';
$string['administratorsandteachers'] = 'Administratorzy i nauczyciele';
$string['advanced'] = 'Zaawansowane';
$string['advancedfilter'] = 'Zaawansowane wyszukiwanie';
$string['advancedsettings'] = 'Ustawienia zaawansowane';
$string['afterresource'] = 'Po zasobie "{$a}"';
$string['aftersection'] = 'Po sekcji "{$a}"';
$string['again'] = 'ponownie';
$string['aimid'] = 'Identyfikator AIM';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Wszystkie';
$string['allactions'] = 'Wszystkie czynności';
$string['allactivities'] = 'Wszystkie składowe kursu';
$string['allcategories'] = 'Wszystkie kategorie';
$string['allchanges'] = 'Wszystkie zmiany';
$string['alldays'] = 'Wszystkie dni';
$string['allfieldsrequired'] = 'Należy wypełnić wszystkie pola';
$string['allfiles'] = 'Wszystkie pliki';
$string['allgroups'] = 'Wszystkie grupy';
$string['alllogs'] = 'Wszystkie logi';
$string['allmods'] = 'Wszystkie {$a}';
$string['allow'] = 'Zezwól';
$string['allowinternal'] = 'Zezwól również na wewnętrzne metody';
$string['allownone'] = 'Nie zezwalaj nikomu';
$string['allownot'] = 'Nie zezwalaj';
$string['allparticipants'] = 'Wszyscy uczestnicy';
$string['allteachers'] = 'Wszyscy nauczyciele';
$string['alphanumerical'] = 'Może zawierać wyłącznie litery alfabetu i cyfry, myślnik (-) oraz kropkę (.)';
$string['alreadyconfirmed'] = 'Rejestracja została już potwierdzona';
$string['alternatename'] = 'Alternatywna nazwa';
$string['always'] = 'Zawsze';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odpowiedz';
$string['any'] = 'Którykolwiek';
$string['appearance'] = 'Wygląd';
$string['approve'] = 'Zatwierdź';
$string['areyousure'] = 'Jesteś pewien?';
$string['areyousuretorestorethis'] = 'Czy chcesz kontynuować?';
$string['areyousuretorestorethisinfo'] = 'W dalszej części tego procesu będziesz miał możliwość dodania zawartości tej kopii zapasowej do istniejącego kursu lub utworzenia zupełnie nowego kursu.';
$string['asc'] = 'Rosnące';
$string['assessment'] = 'Ocena';
$string['assignadmins'] = 'Przypisz administratorów';
$string['assigncreators'] = 'Przypisz autorów kursów';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Przypisz role w obrębie całego serwisu';
$string['authenticateduser'] = 'Uwierzytelniony użytkownik';
$string['authenticateduserdescription'] = 'Wszyscy zalogowani użytkownicy';
$string['authentication'] = 'Uwierzytelnianie';
$string['authenticationplugins'] = 'Wtyczki uwierzytelniania';
$string['autosubscribe'] = 'Automatyczny zapis na forum';
$string['autosubscribeno'] = 'Nie, nie zapisuj mnie automatycznie na fora';
$string['autosubscribeyes'] = 'Tak, zapisuj mnie automatycznie na fora, na których piszę';
$string['availability'] = 'Dostępność';
$string['availablecourses'] = 'Dostępne kursy';
$string['back'] = 'Wstecz';
$string['backto'] = 'Wróć do: {$a}';
$string['backtocourselisting'] = 'Powrót do listy kursów';
$string['backtopageyouwereon'] = 'Powrót do poprzedniej strony';
$string['backtoparticipants'] = 'Powrót do listy uczestników';
$string['backup'] = 'Kopia zapasowa';
$string['backupactivehelp'] = 'Zaznacz, aby kopie zapasowe były tworzone automatycznie.';
$string['backupcancelled'] = 'Tworzenie kopii zapasowej zostało anulowane';
$string['backupcoursefileshelp'] = 'Zaznacz, aby dołączać pliki kursu do kopii zapasowej.';
$string['backupdate'] = 'Data kopii zapasowej';
$string['backupdatenew'] = '&nbsp; {$a->TAG} jest teraz {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} był {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Szczegóły kopii zapasowej';
$string['backupexecuteathelp'] = 'Wybierz, o której godzinie mają być tworzone automatyczne kopie zapasowe.';
$string['backupfailed'] = 'Niektóre kursy nie zostały zachowane';
$string['backupfilename'] = 'kopia zapasowa';
$string['backupfinished'] = 'Tworzenie kopii zapasowej zakończyło się sukcesem';
$string['backupfromthissite'] = 'Czy robiłeś już kopię zapasową?';
$string['backupgradebookhistoryhelp'] = 'Ustawienie tej opcji jako aktywnej spowoduję, że zmiany w dzienniku ocen znajdą się w automatycznie tworzonej kopii zapasowej. Zauważ, że historia ocen nie może być wyłączona w ustawieniach serwera aby bieżąca opcja działała.';
$string['backupincludemoduleshelp'] = 'Zaznacz, aby dane z modułów kursów były zapisywane w automatycznych kopiach zapasowych.';
$string['backupincludemoduleuserdatahelp'] = 'Zaznacz, aby dane użytkowników były zapisywane w automatycznych kopiach zapasowych.';
$string['backupkeephelp'] = 'Określ, ile ma zostać zachowanych ostatnich kopii bezpieczeństwa dla każdego kursu? (starsze kopie będą automatycznie usuwane)';
$string['backuplogdetailed'] = 'Szczegółowy dziennik wykonań';
$string['backuploglaststatus'] = 'Ostatni dziennik wykonań';
$string['backupmissinguserinfoperms'] = 'Uwaga: Ta kopia zapasowa nie zawiera danych użytkownika. Ćwiczenia i warsztaty nie zostaną uwzględnione w kopii zapasowej, ponieważ moduły te nie są zgodne z tym typem kopii zapasowej.';
$string['backupnext'] = 'Następna kopia zapasowa';
$string['backupnonisowarning'] = 'Uwaga: Ta kopia pochodzi z innej niż Unicode wersji Moodle (przed 1.6). Jeżeli kopia zawiera teksty o innym kodowaniu niż ISO-8859-1, mogą zostać one USZKODZONE podczas próby odtwarzania ich w obecnej wersji Unicode Moodle. Zobacz <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>  dla uzyskania większej ilości informacji o poprawnym odtwarzaniu kopii zapasowych dla tej wersji.';
$string['backupnotyetrun'] = 'Oczekująca automatyczna kopia zapasowa';
$string['backuporiginalname'] = 'Nazwa kopii zapasowej';
$string['backuproleassignments'] = 'Archiwizuj przydzielone role dla tych ról';
$string['backupsavetohelp'] = 'Pełna ścieżka dostępu do katalogu, w którym chcesz zapisać pliki kopii zapasowej<br />(pozostaw puste, jeśli chcesz zapisywać kopie zapasowe w kursach w domyślnym katalogu).';
$string['backupsitefileshelp'] = 'Jeśli włączysz, wtedy pliki głównej strony użyte w kursach będą dołączane do automatycznych kopii zapasowych.';
$string['backuptakealook'] = 'Sprawdź logi kopii zapasowej w:
{$a}';
$string['backupuserfileshelp'] = 'Określ, czy pliki użytkownika (np. zdjęcie) mają być zapisane w automatycznej kopii zapasowej';
$string['backupversion'] = 'Wersja kopii zapasowej';
$string['badges'] = 'Odznaki';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurowanie bloku {$a}';
$string['blockconfigbad'] = 'Ten blok nie został poprawnie wprowadzony i dlatego nie może udostępnić interfejsu konfiguracji.';
$string['blocks'] = 'Bloki';
$string['blocksaddedit'] = 'Dodaj/Modyfikuj blok';
$string['blockseditoff'] = 'Wyłącz edycję bloków';
$string['blocksediton'] = 'Włącz edycję bloków';
$string['blocksetup'] = 'Tworzenie tabeli bloków';
$string['blocksuccess'] = '{$a} tabele zostały poprawnie utworzone';
$string['brief'] = 'Krótka';
$string['bulkactions'] = 'Zbiorcze działania';
$string['bulkactionselect'] = '{$a} wybrane masowe działanie';
$string['bulkmovecoursessuccess'] = 'Pomyślnie przeniesiono {$a->courses} kurs(y) do {$a->category}';
$string['bycourseorder'] = 'Według kursów';
$string['byname'] = 'Według {$a}';
$string['bypassed'] = 'Ominięty';
$string['cachecontrols'] = 'Kontrola cache\'u';
$string['cancel'] = 'Anuluj';
$string['cancelled'] = 'Anulowane';
$string['categories'] = 'Kategorie kursów';
$string['categoriesandcoures'] = 'Kursy i kategorie kursu';
$string['category'] = 'Kategoria';
$string['categoryadded'] = 'Kategoria \'{$a}\' została dodana';
$string['categorybulkaction'] = 'Działania masowe dla wybranych kategorii';
$string['categorycontents'] = 'Podkategorie i kursy';
$string['categorycurrentcontents'] = 'Zawartość {$a}';
$string['categorydeleted'] = 'Kategoria \'{$a}\' została usunięta';
$string['categoryduplicate'] = 'Kategoria o nazwie \'{$a}\' już istnieje!';
$string['categorymodifiedcancel'] = 'Kategoria zostanie zmieniona. Wybierz Anuluj aby tego nie robić.';
$string['categoryname'] = 'Nazwa kategorii';
$string['categorysubcategoryof'] = '{$a->category} - podkategoria {$a->parentcategory}';
$string['categoryupdated'] = 'Kategoria \'{$a}\' została zaktualizowana';
$string['changedpassword'] = 'Hasło zostało zmienione';
$string['changepassword'] = 'Zmień hasło';
$string['changesmadereallygoaway'] = 'Dokonano zmian. Czy na pewno chcesz nawigować dalej i utracić swoje zmiany?';
$string['changessaved'] = 'Zmiany zostały zapisane';
$string['check'] = 'Sprawdź';
$string['checkall'] = 'Sprawdź wszystko';
$string['checkingbackup'] = 'Sprawdzanie kopii zapasowej';
$string['checkingcourse'] = 'Sprawdzanie kursu';
$string['checkingforbbexport'] = 'Sprawdzanie wersji dla platformy e-learning BlackBoard';
$string['checkinginstances'] = 'Sprawdzanie instancji';
$string['checkingsections'] = 'Sprawdzanie sekcji';
$string['checklanguage'] = 'Sprawdzanie języka';
$string['checknone'] = 'Nic nie sprawdzaj';
$string['childcoursenotfound'] = 'Nie znaleziono potomnego kursu';
$string['childcourses'] = 'Kursy podrzędne';
$string['choose'] = 'Wybierz';
$string['choosecourse'] = 'Wybierz kurs';
$string['choosedots'] = 'Wybierz ...';
$string['chooselivelogs'] = 'Lub przejrzyj obecną aktywność';
$string['chooselogs'] = 'Wybierz logi, które chcesz obejrzeć';
$string['choosereportfilter'] = 'Wybierz filtr dla raportu';
$string['choosetheme'] = 'Wybierz temat';
$string['chooseuser'] = 'Wybierz użytkownika';
$string['city'] = 'Miasto';
$string['clambroken'] = 'Administrator włączył ochronę wirusową dla przesyłanych plików, lecz z błędem w konfiguracji.<br/>Plik nie może zostać przesłany. Administrator zostanie poinformowany e-mailem i spróbuje usunąć błąd.<br/> Spróbuj później przesłać ten plik.';
$string['clamdeletedfile'] = 'Plik został usunięty';
$string['clamdeletedfilefailed'] = 'Plik nie może być usunięty';
$string['clamemailsubject'] = '{$a}: Informacja programu antywirusowego Clam AV';
$string['clamfailed'] = 'Clam AV nie został poprawnie uruchomiony. Wiadomość o błędzie była {$a}. Tu jest odpowiedź z Clam:';
$string['clamlost'] = 'Platforma jest skonfigurowana tak, aby po każdym przesłaniu pliku został uruchomiony Clam AV, lecz ścieżka dostępu do Clam AV, {$a}, jest błędna.';
$string['clamlostandactinglikevirus'] = 'System Moodle jest skonfigurowany tak, że jeżeli Clam AV nie wystartuje, wszystkie pliki są traktowane jak wirusy. Studenci nie będą mogli przesłać żadnego pliku, dopóki błąd nie zostanie usunięty.';
$string['clammovedfile'] = 'Plik został przesunięty do katalogu objętego kwarantanną; nowa lokalizacja pliku to {$a}.';
$string['clammovedfilebasic'] = 'Plik zostanie poddany kwarantannie';
$string['clamquarantinedirfailed'] = 'Nie można przesunąć pliku do katalogu objętego kwarantanną, {$a}. Trzeba to naprawić, gdyż zainfekowane pliki zostaną usunięte.';
$string['clamunknownerror'] = 'Nieznany błąd z Clam';
$string['cleaningtempdata'] = 'Usuwanie danych tymczasowych';
$string['clear'] = 'Wyczyść';
$string['clickhelpiconformoreinfo'] = '... dalej ... Kliknij ikonę pomocy by przeczytać cały artykuł.';
$string['clickhere'] = 'Kliknij tutaj ...';
$string['clicktochangeinbrackets'] = '{$a} (Kliknij, aby zmienić)';
$string['clicktohideshow'] = 'Kliknij, aby rozwinąć lub zwinąć';
$string['closebuttontitle'] = 'Zamknij';
$string['closewindow'] = 'Zamknij to okno';
$string['collapse'] = 'Minimalizuj';
$string['collapseall'] = 'Zwiń wszystko';
$string['collapsecategory'] = 'Zwiń {$a}';
$string['commentincontext'] = 'Znajdź ten komentarz w kontekście';
$string['comments'] = 'Komentarze';
$string['commentsnotenabled'] = 'Funkcja Komentarze nie jest włączona';
$string['commentsrequirelogin'] = 'Musisz się zalogować, aby zobaczyć komentarze';
$string['comparelanguage'] = 'Przejrzyj i edytuj bieżący język';
$string['complete'] = 'Pełna wersja';
$string['completereport'] = 'Pełny raport';
$string['configuration'] = 'Konfiguracja';
$string['confirm'] = 'Potwierdź';
$string['confirmcheckfull'] = 'Czy masz absolutną pewność, że chcesz potwierdzić {$a} ?';
$string['confirmcoursemove'] = 'Czy na pewno chcesz przenieść ten kurs ({$a->course}) do tej kategorii ({$a->category})?';
$string['confirmed'] = 'Twoja rejestracja została potwierdzona';
$string['confirmednot'] = 'Twoja rejestracja nie została jeszcze potwierdzona';
$string['content'] = 'Zawartość';
$string['continue'] = 'Kontynuuj';
$string['continuetocourse'] = 'Kliknij tutaj, aby wejść do kursu';
$string['convertingwikitomarkdown'] = 'Konwersja formatu WIKI do formatu Markdown';
$string['cookiesenabled'] = 'Przyjmowanie cookies (ciasteczek) musi być włączone w Twojej przeglądarce';
$string['cookiesenabled_help'] = '<p>Ta strona korzysta z dwóch cookies.</p>

<p>Bardzo istotnym jest ten poświęcony sesjom, nazwany zazwyczaj <b>MoodleSession</b>. Musisz zezwolić przeglądarce na umieszczenie tego cookie aby zachować ciągłość pracy, a także aby zachować twoje zalogowanie przy przechodzeniu między stronami. Kiedy się wylogowujesz, lub kończysz działanie przeglądarki ten cookie zostaje usunięty (z Twojej przeglądarki i z serwera).</p>

<p>Drugi cookie jest używany dla czystej wygody i zazwyczaj nazywany jest <b>MOODLEID</b>. Zapamiętana w nim jest twoja nazwa użytkownika. Oznacza to, że jeśli wrócisz na tą stronę pole \'nazwa użytkownika\' na ekranie logowania będzie automatycznie uzupełniane. Możesz spokojnie zrezygnować z tego cookie - będziesz po prostu musiał każdorazowo wprowadzać swoją nazwę użytkownika podczas procesu logowania.</p>';
$string['cookiesnotenabled'] = 'Obsługa cookies (ciasteczek) nie jest włączona w Twojej przeglądarce';
$string['copy'] = 'kopiuj';
$string['copyasnoun'] = 'kopiuj';
$string['copyingcoursefiles'] = 'Kopiowanie plików kursów';
$string['copyingsitefiles'] = 'Kopiowanie plików strony głównej użytych w kursie';
$string['copyinguserfiles'] = 'Kopiowanie plików użytkowników';
$string['copyingzipfile'] = 'Kopiowanie archiwów zip';
$string['copyrightnotice'] = 'Prawa autorskie';
$string['coresystem'] = 'System';
$string['cost'] = 'Koszt';
$string['costdefault'] = 'Domyślny koszt';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Kraj';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administracja kursem';
$string['courseapprovedemail'] = 'Zamówienie na kurs {$a->name} zostało zrealizowane, a Ty zostałeś przypisany jako {$a->teacher}. Aby uzyskać dostęp do kursu, przejdź do {$a->url}';
$string['courseapprovedemail2'] = 'Żądanie utworzenia kursu {$a->name} zostało zatwierdzone. Aby uzyskać dostęp do nowego kursu proszę kliknąć na link: {$a->url}';
$string['courseapprovedfailed'] = 'Nieudana próba zatwierdzenia kursu';
$string['courseapprovedsubject'] = 'Kurs został zatwierdzony.';
$string['courseavailable'] = 'Ten kurs jest dostępny dla studentów';
$string['courseavailablenot'] = 'Ten kurs nie jest dostępny dla studentów';
$string['coursebackup'] = 'Kopia zapasowa kursu';
$string['coursebulkaction'] = 'Masowe działania dla wybranych kursów';
$string['coursecategories'] = 'Kategorie kursów';
$string['coursecategory'] = 'Kategoria kursu';
$string['coursecategorydeleted'] = 'Kategoria {$a} została usunięta';
$string['coursecategory_help'] = '<P ALIGN=CENTER><B>Kategorie kursów</B></P>

<P>Administrator Twojej platformy Moodle mógł określić kilka kategorii kursów.</p>

<P>Przykładowo: &quot;Nauki Ścisłe&quot;, &quot;Nauki humanistyczne&quot;, &quot;Ochrona zdrowia&quot; itp.</p>

<P>Wybierz kategorię najbardziej odpowiednią dla Twojego kursu. Twój wybór będzie miał wpływ na to gdzie kurs będzie się znajdował na liście kursów i może ułatwić studentom jego odnalezienie.</p>';
$string['coursecatmanagement'] = 'Zarządzanie kursami i kategoriami';
$string['coursecompletion'] = 'Ukończenie kursu';
$string['coursecompletions'] = 'Ukończenie kursu';
$string['coursecreators'] = 'Autor kursu';
$string['coursecreatorsdescription'] = 'Autorzy kursów mogą tworzyć nowe kursy.';
$string['coursedeleted'] = 'Kurs {$a} usunięty';
$string['coursedisplay'] = 'Układ kursu';
$string['coursedisplay_help'] = 'Opcja ta decyduje czy cały kurs zostanie wyświetlony na jednej czy kilku stronach.';
$string['coursedisplay_multi'] = 'Pokaż jedną sekcję na stronę';
$string['coursedisplay_single'] = 'Pokaż wszystkie sekcje na jednej stronie';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Pliki kursu';
$string['coursefilesedit'] = 'Edytuj pliki przynależne do kursu';
$string['coursefileswarning'] = 'Sekcja "Pliki kursu" jest przestarzała.';
$string['coursefileswarning_help'] = 'Sekcja "Pliki kursu" została wycofana począwszy od wersji 2.0. Należy tak dalece jak to możliwe używać zewnętrznych repozytoriów plików.';
$string['courseformatdata'] = 'Dane formatu kursu';
$string['courseformatoptions'] = 'Opcje formatowania dla {$a}';
$string['courseformats'] = 'Formaty kursu';
$string['courseformatudpate'] = 'Aktualizacja formatu';
$string['coursegrades'] = 'Oceny kursu';
$string['coursehelpcategory'] = 'Wstaw kurs na listę kursów, co ułatwi studentom znalezienie go.';
$string['coursehelpforce'] = 'Wymuś tryb grup do każdej aktywności w tym kursie.';
$string['coursehelpformat'] = 'Głowna strona kursu będzie wyświetlana w tym formacie.';
$string['coursehelphiddensections'] = 'Jak ukryta sekcja kursu jest widoczna dla studentów.';
$string['coursehelpmaximumupload'] = 'Zdefiniuj największy rozmiar pliku jaki można przesłać do tego kursu, ograniczony przez ustawienia globalne.';
$string['coursehelpnewsitemsnumber'] = 'Liczba ostatnich wpisów pojawiających się na stronie głównej, w bloku wiadomości u dołu po prawej stronie (0 oznacza, że blok nie pojawi się wcale)';
$string['coursehelpnumberweeks'] = 'Liczba tematów/tygodni wyświetlana na głównej stronie kursu.';
$string['coursehelpshowgrades'] = 'Włącz wyswietlanie dziennika ocen. To nie zapobiega wyświetlaniu ocen wewnątrz poszczególnych aktywności.';
$string['coursehidden'] = 'Ten kurs jest obecnie niedostępny dla studentów';
$string['courseinfo'] = 'Informacje o kursie';
$string['courselegacyfiles'] = 'Pliki kursu (stary format)';
$string['courselegacyfiles_help'] = 'Obszar plików kursu zapewnia pewną wsteczną kompatybilność z Moodlem 1.9 i jego wcześniejszymi wersjami. Wszystkie pliki w tym obszarze są dostępne dla wszystkich uczestników kursu (niezależnie, czy są podlinkowane czy nie) i nie jest możliwe stwierdzenie, gdzie te pliki są używane w Moodlu.

Jeżeli używasz tego obszaru do przechowywania plików wystawiasz się na szereg ryzyk związanych z prywatnością i bezpieczeństwem oraz możesz doświadczyć problemów wynikających z pominięcia plików w kopiach archiwalnych i importach danych oraz faktu, że treści są dowolnie współdzielone i wykorzystywane. Nie używaj tej funkcjonalności, chyba, że naprawdę dobrze wiesz co robisz.';
$string['courselegacyfilesofcourse'] = 'Odziedziczone pliki kursu: {$a}';
$string['coursemessage'] = 'Wiadomość dla użytkowników kursu';
$string['coursenotaccessible'] = 'Ten kurs nie jest ogólnodostępny';
$string['courseoverview'] = 'Podgląd kursu';
$string['courseoverviewfiles'] = 'Pliki podsumowania kursu';
$string['courseoverviewfilesext'] = 'Rozszerzenia plików podsumowania kursu';
$string['courseoverviewfiles_help'] = 'Pliki podsumowania kursu, tj. obrazy, są wyświetlane na liście kursów razem z podsumowaniem.';
$string['courseoverviewfileslimit'] = 'Ograniczenie plików podsumowania kursu';
$string['courseoverviewgraph'] = 'Wykres podglądu kursu';
$string['courseprofiles'] = 'Twoje kursy';
$string['coursereasonforrejecting'] = 'Powód odrzucenia zamówienia na nowy kurs';
$string['coursereasonforrejectingemail'] = 'Zostało wysłane do zamawiającego';
$string['coursereject'] = 'Odrzuć zamówienie na kurs';
$string['courserejected'] = 'Zamówienie zostało odrzucone, a wnioskodawca został poinformowany.';
$string['courserejectemail'] = 'Przepraszamy, ale kurs, na który złożono zamówienie, został odrzucony. Uzasadnienie: {$a}';
$string['courserejectreason'] = 'Wytłumaczenie powodów, dla których zamówienie zostało odrzucone<br />(wpisane tutaj uzasadnienie zostanie wysłane e-mailem do wnioskodawcy).';
$string['courserejectsubject'] = 'Kurs został odrzucony';
$string['coursereport'] = 'Raport kursu';
$string['coursereports'] = 'Raport kursu';
$string['courserequest'] = 'Zamawianie kursu';
$string['courserequestdetails'] = 'Szczegóły zamawianego kursu';
$string['courserequestfailed'] = 'Twoje zamówienie nie zostało zapisane';
$string['courserequestintro'] = 'Użyj formularza, aby zamówić utworzenie kursu. Zamieść jak najwięcej informacji tak, aby administratorzy poznali cel utworzenia tego kursu.';
$string['courserequestreason'] = 'Kurs jest potrzebny do...';
$string['courserequestsuccess'] = 'Prośba dotycząca kursu została wysłana. W ciągu kilku dni proszę oczekiwać e-maila z odpowiedzią.';
$string['courserequestsupport'] = 'Dodatkowe informacje dla administratora na temat zamawianego kursu';
$string['courserestore'] = 'Odtworzenie kursu';
$string['courses'] = 'Kursy';
$string['coursesectionsummaries'] = 'Streszczenie sekcji kursu';
$string['coursesettings'] = 'Domyślne ustawienia kursu';
$string['coursesmovedout'] = 'Kurs przeniesiony z {$a}';
$string['coursespending'] = 'Kursy oczekujące na zatwierdzenie';
$string['coursestart'] = 'Rozpoczęcie kursu';
$string['coursesummary'] = 'Podsumowanie kursu';
$string['coursesummary_help'] = 'Streszczenie kursu wyświetlane jest na liście kursów. Wyszukiwarka poza nazwami kursów przeszukuje także te streszczenia.';
$string['courseupdates'] = 'Aktualizacje w kursach';
$string['create'] = 'Utwórz';
$string['createaccount'] = 'Utwórz moje nowe konto';
$string['createcategory'] = 'Utwórz kategorię';
$string['createfolder'] = 'Utwórz folder w {$a}';
$string['createnew'] = 'Utwórz nową';
$string['createnewcategory'] = 'Utwórz nową kategorię';
$string['createnewcourse'] = 'Utwórz nowy kurs';
$string['createnewsubcategory'] = 'Utwórz nową podkategorię';
$string['createsubcategoryof'] = 'Utwórz podkategorię dla {$a}';
$string['createuser'] = 'Stwórz użytkownika';
$string['createuserandpass'] = 'Wybierz nazwę użytkownika oraz hasło, które będą używane do logowania';
$string['createziparchive'] = 'Utwórz archiwum zip';
$string['creatingblocks'] = 'Tworzenie bloków';
$string['creatingblocksroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie bloku';
$string['creatingblogsinfo'] = 'Tworzenie informacji o blogach';
$string['creatingcategoriesandquestions'] = 'Tworzenie kategorii i pytań';
$string['creatingcoursemodules'] = 'Tworzenie modułów kursu';
$string['creatingcourseroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie kursu';
$string['creatingevents'] = 'Tworzenie zdarzeń';
$string['creatinggradebook'] = 'Tworzenie dziennika ocen';
$string['creatinggroupings'] = 'Tworzenie grup nadrzędnych';
$string['creatinggroupingsgroups'] = 'Dodawanie grup do grup nadrzędnych';
$string['creatinggroups'] = 'Tworzenie grup';
$string['creatinglogentries'] = 'Tworzenie logów';
$string['creatingmessagesinfo'] = 'Tworzenie informacji o wiadomościach';
$string['creatingmodroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie modułu';
$string['creatingnewcourse'] = 'Tworzenie nowego kursu';
$string['creatingrolesdefinitions'] = 'Tworzenie definicji ról';
$string['creatingscales'] = 'Tworzenie skal ocen';
$string['creatingsections'] = 'Tworzenie sekcji';
$string['creatingtemporarystructures'] = 'Tworzenie struktur tymczasowych';
$string['creatinguserroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie użytkownika';
$string['creatingusers'] = 'Tworzenie użytkowników';
$string['creatingxmlfile'] = 'Tworzenie pliku XML';
$string['currency'] = 'Waluta';
$string['currentcourse'] = 'Bieżący kurs';
$string['currentcourseadding'] = 'Dodaj dane do bieżącego kursu bez usuwania jego zawartości';
$string['currentcoursedeleting'] = 'Dodaj dane do bieżącego kursu, usuwając wpierw jego zawartość';
$string['currentlanguage'] = 'Aktualny język';
$string['currentlocaltime'] = 'twój aktualny czas lokalny';
$string['currentlyselectedusers'] = 'Aktualnie wybrani użytkownicy';
$string['currentpicture'] = 'Aktualne zdjęcie';
$string['currentrelease'] = 'Informacje o aktualnej wersji';
$string['currentversion'] = 'Aktualna wersja';
$string['databasechecking'] = 'Aktualizacja bazy danych Moodle z wersji {$a->oldversion} do {$a->newversion}...';
$string['databaseperformance'] = 'Wydajność bazy danych';
$string['databasesetup'] = 'Tworzenie bazy danych';
$string['databasesuccess'] = 'Baza danych została poprawnie zaktualizowana';
$string['databaseupgradebackups'] = '{$a} wersja kopii zapasowej';
$string['databaseupgradeblocks'] = '{$a} wersja bloków';
$string['databaseupgradegroups'] = '{$a} wersja grup';
$string['databaseupgradelocal'] = 'Obecnie dostosowana wersja lokalnej bazy danych to {$a}';
$string['databaseupgrades'] = 'Aktualizacja bazy danych';
$string['date'] = 'Data';
$string['datechanged'] = 'Data zmieniona';
$string['datemostrecentfirst'] = 'Daty - od najświeższej';
$string['datemostrecentlast'] = 'Daty - od najstarszej';
$string['day'] = 'dzień';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Odkodowywanie linków wewnętrznych';
$string['default'] = 'Domyślny';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenci mają z zasady mniej uprawnień w kursach.';
$string['defaultcoursestudents'] = 'Studenci';
$string['defaultcoursesummary'] = 'Wpisz tutaj krótki opis kursu';
$string['defaultcourseteacher'] = 'Prowadzący';
$string['defaultcourseteacherdescription'] = 'Prowadzący mogą robić wszystko w kursie, np. zmieniać składowe czy oceniać studentów';
$string['defaultcourseteachers'] = 'Prowadzący';
$string['defaulteditor'] = 'Domyślny edytor';
$string['delete'] = 'Usuń';
$string['deleteablock'] = 'Usuń blok';
$string['deleteall'] = 'Usuń wszystko';
$string['deleteallcannotundo'] = 'Usuń wszystko - nie da się cofnąć';
$string['deleteallcomments'] = 'Usuń wszystkie komentarze';
$string['deleteallratings'] = 'Usuń wszystkie oceny';
$string['deletecategory'] = 'Usuń kategorię {$a}';
$string['deletecategorycheck'] = 'Czy na pewno chcesz usunąć kategorię <b>\'{$a}\'</b>?<br/>Spowoduje to przesunięcie wszystkich kursów do kategorii nadrzędnej lub kategorii "Inne".';
$string['deletecategorycheck2'] = 'Gdy usuwasz tą kategorię, musisz wybrać co zrobić z kursami i podkategoriami które zawiera.';
$string['deletecategoryempty'] = 'Ta kategoria jest pusta';
$string['deletecheck'] = 'Usunąć {$a}?';
$string['deletecheckfiles'] = 'Czy na pewno chcesz usunąć te pliki?';
$string['deletecheckfull'] = 'Czy na pewno chcesz usunąć {$a}?';
$string['deletechecktype'] = 'Czy na pewno chcesz usunąć {$a->type}?';
$string['deletechecktypename'] = 'Czy na pewno chcesz usunąć {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Te pliki zostaną zaraz usunięte';
$string['deletecomment'] = 'Usuń ten komentarz';
$string['deletecompletely'] = 'Usuń całkowicie';
$string['deletecourse'] = 'Usuń kurs';
$string['deletecoursecheck'] = 'Czy na pewno chcesz całkowicie usunąć ten kurs i wszystkie zawarte w nim dane?';
$string['deleted'] = 'Usunięto';
$string['deletedactivity'] = 'Usunięto {$a}';
$string['deletedcourse'] = '{$a} został całkowicie usunięty.';
$string['deletednot'] = 'Nie można usunąć {$a}!';
$string['deletelogs'] = 'Usuń logi';
$string['deleteselected'] = 'Usuń zaznaczone';
$string['deleteselectedkey'] = 'Usuń wybrany klucz';
$string['deletingcourse'] = 'Usuwanie {$a}';
$string['deletingexistingcoursedata'] = 'Usuwanie istniejących danych kursu';
$string['deletingolddata'] = 'Kasowanie starych danych';
$string['department'] = 'Wydział';
$string['desc'] = 'Malejące';
$string['description'] = 'Opis';
$string['deselectall'] = 'Odznacz wszystkie';
$string['detailedless'] = 'Mniej szczegółowo';
$string['detailedmore'] = 'Bardziej szczegółowo';
$string['directory'] = 'Katalog';
$string['disable'] = 'Wyłącz';
$string['disabledcomments'] = 'Komentarze są wyłączone';
$string['displayingfirst'] = 'Tylko pierwszych {$a->count} elementów jest wyświetlanych';
$string['displayingrecords'] = 'Wyświetlanie {$a} rekordów';
$string['displayingusers'] = 'Wyświetlanie użytkowników od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Wyświetl na stronie';
$string['dndcourse'] = 'Możesz przeciągać i upuszczać ten kurs, w celu sortowania lub przeniesienia do innej kategorii.';
$string['dndenabled_inbox'] = 'Możesz przeciągnąć i upuścić pliki tutaj, aby je dodać.';
$string['dndnotsupported'] = 'Funkcja przeciągnij i upuść nie jest wspierana';
$string['dndnotsupported_help'] = 'Twoja przeglądarka nie obsługuje opcji przeciągnij i  upuść. <br /> Ta funkcja jest dostępna we wszystkich nowych wersjach Chrome, Firefox i Safari, a także Internet Explorer v.10 i nowszych.';
$string['dndnotsupported_insentence'] = 'funkcja przeciągnij i upuść nie jest wspierana';
$string['dnduploadwithoutcontent'] = 'Ten upload nie ma żadnej zawartości';
$string['dndworkingfile'] = 'Przeciągnij i upuść pliki do sekcji kursu, aby je załadować';
$string['dndworkingfilelink'] = 'Przeciągnij i upuść pliki lub linki do sekcji kursu, aby je załadować';
$string['dndworkingfiletext'] = 'Przeciągnij i upuść pliki lub tekst do sekcji kursu, aby je załadować';
$string['dndworkingfiletextlink'] = 'Przeciągnij i upuść pliki, tekst lub linki do sekcji kursu, aby je załadować';
$string['dndworkinglink'] = 'Przeciągnij i upuść linki do sekcji kursu, aby je załadować';
$string['dndworkingtext'] = 'Przeciągnij i upuść tekst do sekcji kursu, aby je załadować';
$string['dndworkingtextlink'] = 'Przeciągnij i upuść tekst lub linki do sekcji kursu, aby je załadować';
$string['documentation'] = 'Dokumentacja Moodle';
$string['dontsortcategories'] = 'Nie sortuj kategorii';
$string['dontsortcourses'] = 'Nie sortuj kursów';
$string['down'] = 'W dół';
$string['download'] = 'Pobierz';
$string['downloadall'] = 'Pobierz wszystkie';
$string['downloadexcel'] = 'Ściągnij w formacie Excela';
$string['downloadfile'] = 'Pobierz plik';
$string['downloadods'] = 'Ściągnij w formacie ODS';
$string['downloadtext'] = 'Ściągnij w formacie tekstowym';
$string['doyouagree'] = 'Czy przeczytałeś(aś) warunki i rozumiesz je?';
$string['droptoupload'] = 'Upuścić pliki tutaj, aby je przesłać';
$string['duplicate'] = 'Duplikuj';
$string['duplicateconfirm'] = 'Czy na pewno chcesz powielić {$a->modtype} \'{$a->modname}\'?';
$string['duplicatecontcourse'] = 'Wróć do kursu';
$string['duplicatecontedit'] = 'Edytuj nową kopię';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' został powielony';
$string['duplicatinga'] = 'Duplikowanie: {$a}';
$string['edhelpaspellpath'] = 'Aby sprawdzać pisownię w tym edytorze, musisz mieć zainstalowany słownik <strong> aspell</strong> w wersji co najmniej 0.5. Musi być ustawiona ścieżka dostępu; w systemach Unix/Linux jest to najczęściej<strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Ustaw kolor tła w polu edycji.<br /> Poprawną wartością jest np. #FFFFFF lub white';
$string['edhelpcleanword'] = 'To ustawienie włącza lub wyłącza filtrowanie formatów charakterystyczne dla Worda.';
$string['edhelpenablespelling'] = 'Włącz lub wyłącz sprawdzanie pisowni. Jeśli włączone, <strong>aspell</strong> musi być zainstalowany na serwerze.';
$string['edhelpfontfamily'] = 'Zmienna rodziny czcionek to lista czcionek. Kolejne nazwy czcionek muszą być oddzielone przecinkami.';
$string['edhelpfontlist'] = 'Zdefiniuj czcionki dostępne na rozwijanej liście edytora.';
$string['edhelpfontsize'] = 'Domyślny parametr font-size ustawia wielkość czcionki.<br />Poprawnymi wartościami są: medium, large, smaller, larger, 10px, 11px.';
$string['edit'] = 'Modyfikuj';
$string['edita'] = 'Modyfikuj {$a}';
$string['editcategorysettings'] = 'Modyfikuj ustawienia kategorii';
$string['editcategorythis'] = 'Modyfikuj tą kategorię';
$string['editcoursesettings'] = 'Zmień ustawienia kursu';
$string['editfiles'] = 'Edytuj pliki';
$string['editgroupprofile'] = 'Edytuj profil grupy';
$string['editinga'] = 'Trwa edycja {$a}';
$string['editingteachershort'] = 'Edytor';
$string['editlock'] = 'Ta wartość nie może być modyfikowana';
$string['editmyprofile'] = 'Modyfikuj profil';
$string['editorbgcolor'] = 'Kolor tła';
$string['editorcleanonpaste'] = 'Wyczyść formatowanie Worda przy wklejaniu';
$string['editorcommonsettings'] = 'Domyślne ustawienia';
$string['editordefaultfont'] = 'Domyślna czcionka';
$string['editorenablespelling'] = 'Włącz sprawdzanie pisowni';
$string['editorfontlist'] = 'Lista czcionek';
$string['editorfontsize'] = 'Domyślny rozmiar czcionki';
$string['editorresettodefaults'] = 'Przywróć ustawienia domyślne';
$string['editorsettings'] = 'Ustawienia edytora tekstu';
$string['editorshortcutkeys'] = 'Klawisze skrótu edytora';
$string['editsettings'] = 'Edytuj ustawienia';
$string['editsummary'] = 'Zmień streszczenie';
$string['editthisactivity'] = 'Zmień składową';
$string['editthiscategory'] = 'Zmień kategorię';
$string['edittitle'] = 'Edytuj tytuł';
$string['edittitleinstructions'] = 'Naciśnij Escape aby anulować, Enter aby zakończyć';
$string['edituser'] = 'Zmień konta użytkowników';
$string['email'] = 'E-mail';
$string['emailactive'] = 'Aktywowany e-mail';
$string['emailagain'] = 'E-mail (jeszcze raz)';
$string['emailalreadysent'] = 'Email resetowania hasła został wysłany.';
$string['emailcharset'] = 'Kodowanie znaków w e-mail';
$string['emailconfirm'] = 'Potwierdź konto';
$string['emailconfirmation'] = 'Witaj {$a->firstname}.

W serwisie \'{$a->sitename}\' zgłoszono żądanie utworzenia nowego konta z użyciem twojego adresu e-mail. Aby potwierdzić zamiar utworzenia konta przejdź na stronę:

{$a->link}

W większości programów istnieje możliwość przejścia do powyższego adresu poprzez kliknięcie go. Jeżeli to nie działa, skopiuj adres do pola adresowego przeglądarki internetowej i naciśnij enter.

Pozdrowienia od administratora
{$a->admin}';
$string['emailconfirmationsubject'] = 'Potwierdzenie dla konta {$a}';
$string['emailconfirmsent'] = '<p>Został do Ciebie wysłany e-mail pod adres <b>{$a}</b>.</p><p>Zawiera on prostą instrukcję, jak dokończyć rejestrację.</p><p>Jeżeli nadal będziesz mieć kłopoty, skontaktuj się z administratorem serwisu.</p>';
$string['emaildigest'] = 'Typ streszczenia wysyłanego mailem';
$string['emaildigestcomplete'] = 'Pełny (jeden e-mail dziennie ze wszystkimi wpisami)';
$string['emaildigest_help'] = 'To jest ustawienie codziennego streszczenia, którego forum używa domyślnie.

* Brak streszczenia - otrzymujesz jeden email na jedną wiadomość na forum;
* Streszczenie - wiadomości kompletne - otrzymujesz streszczenie codziennie emailem, zawierające kompletną zawartość każdej wiadomości na forum;
* Streszczenie - tylko tematy - otrzymujesz streszczenie codziennie emailem, zawierające tylko tematy każdej wiadomości na forum.

Możesz wybrać według własnego życzenia różne ustawienia dla każdego forum.';
$string['emaildigestoff'] = 'Bez streszczenia (jeden e-mail na każdy wpis)';
$string['emaildigestsubjects'] = 'Tematy (codzienny e-mail tylko z tematami)';
$string['emaildisable'] = 'Ten e-mail jest dezaktywowany';
$string['emaildisableclick'] = 'Kliknij tutaj, aby dezaktywować wysyłanie maili na ten adres.';
$string['emaildisplay'] = 'Wyświetlanie adresu e-mail';
$string['emaildisplaycourse'] = 'Tylko inni uczestnicy kursu mogą zobaczyć mój adres e-mail';
$string['emaildisplayhidden'] = 'Email ukryty';
$string['emaildisplayno'] = 'Ukryj mój adres e-mail przed wszystkimi';
$string['emaildisplayyes'] = 'Pokaż wszystkim mój adres e-mail';
$string['emailenable'] = 'Ten mail jest uaktywniony';
$string['emailenableclick'] = 'Kliknij tutaj, aby uaktywnić wysyłanie maili na ten adres';
$string['emailexists'] = 'Ten adres e-mail jest już zarejestrowany';
$string['emailformat'] = 'Format e-mail';
$string['emailmustbereal'] = 'Uwaga: Twój adres e-mail musi być prawdziwy';
$string['emailnotallowed'] = 'Niedozwolona domena adresu e-mail ({$a})';
$string['emailnotfound'] = 'Adres e-mail nie został znaleziony w bazie danych';
$string['emailonlyallowed'] = 'Niedozwolony adres e-mail ({$a})';
$string['emailpasswordchangeinfo'] = 'Witaj {$a->firstname},

Została zgłoszona prośba o zmianę hasła do twojego konta na \'{$a->sitename}\'.

Aby zmienić hasło, kliknij na poniższy link:

{$a->link}

Jeśli link nie jest niebieski i nie odsyła do kolejnej strony, należy skopiować go i wkleić do okna adresowego w górnej części przeglądarki.

Jeśli potrzebujesz pomocy, skontaktuj się z administratorem serwisu, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Witaj {$a->firstname},

Została zgłoszona prośba o zmianę hasła do twojego konta na \'{$a->sitename}\'.

Niestety, Twoje konto w tej witrynie jest zablokowane, więc niemożliwe jest dokonanie zmiany hasła. Skontaktuj się z administratorem: {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Witaj {$a->firstname},

Została zgłoszona prośba o zmianę hasła do twojego konta na \'{$a->sitename}\'.

Niestety w tym serwisie hasła nie mogą być zmieniane. Skontaktuj się z administratorem serwisu, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Zmień informacje dotyczące hasła';
$string['emailpasswordconfirmation'] = 'Witaj {$a->firstname}.

Została zgłoszona prośba o zmianę hasła do twojego konta na \'{$a->sitename}\'. Aby to potwierdzić i otrzymać nowe hasło za pośrednictwem poczty elektronicznej, przejdź na następującą stronę:

{$a->link}

Jeśli link nie jest niebieski i nie odsyła do kolejnej strony, należy skopiować go i wkleić do okna adresowego w górnej części przeglądarki.

Jeśli potrzebujesz pomocy, skontaktuj się z administratorem,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = 'Potwierdzenie zmiany hasła dla : {$a}';
$string['emailpasswordconfirmmaybesent'] = '<p>Jeśli wpisałeś właściwą nazwę użytkownika lub adres e-mail, na twoją skrzynkę zostanie wysłana wiadomość.</p>
<p>Znajdziesz w niej łatwą instrukcję zmiany hasła. W razie problemów skontaktuj się z administratorem serwisu.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Konto użytkownika, które podałeś nie ma zapisanego adresu emailowego.</p>
<p>Proszę skontaktować się z administratorem strony.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Szczegóły użytkownika, które dostarczyłeś nie identyfikują istniejącego konta użytkownika.</p>
<p>Proszę sprawdzić informacje, które wprowadziłeś, i spróbować ponownie.
Jeżeli w dalszym ciągu będziesz miał trudności, skontaktuj się z administratorem serwisu.</p>';
$string['emailpasswordconfirmsent'] = 'Został do Ciebie wysłany e-mail na adres <b>{$a}</b>.<br />Zawiera on prostą instrukcję jak potwierdzić i zakończyć zmianę hasła. Jeśli nadal będziesz miał problemy, skontaktuj się z administratorem.';
$string['emailpasswordsent'] = 'Dziękujemy za potwierdzenie zmiany hasła. <br />E-mail zawierający twoje nowe hasło został przesłany na twój adres <b>{$a->email}</b>. <br /> Nowe hasło zostało wygenerowane w sposób automatyczny  - możesz je <a href="{$a->link}"> zmienić</a> na łatwiejsze do zapamiętania.';
$string['emailresetconfirmation'] = 'Witaj {$a->firstname},

Zażądano zresetowanie hasła dla twojego konta \'{$a->username}\' na {$a->sitename}.

Aby potwierdzić to żądanie i ustawić nowe hasło dla swojego konta, prosimy przejść do poniższego adresu internetowego:

{$a->link}
(Ten link jest poprawny przez {$a->resetminutes} minut od momentu zażądania zresetowania hasła)

Jeżeli nie zażyczyłeś sobie zresetowania hasła, zignoruj tą wiadomość.

Jeżeli potrzebujesz pomocy, skontaktuj się z administratorem strony,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: żądanie zresetowania hasła';
$string['emailresetconfirmsent'] = 'Email został wysłany na twój adres <b>{$a}</b>.
<br />Zawiera prostą instrukcję do potwierdzenia zmiany hasła.
Jeżeli w dalszym ciągu będziesz miał trudności, skontaktuj się z administratorem serwisu.';
$string['emptydragdropregion'] = 'pusty obszar';
$string['enable'] = 'Włącz';
$string['encryptedcode'] = 'Zaszyfrowany kod';
$string['english'] = 'angielski';
$string['enrolmentmethods'] = 'Metody zapisu';
$string['entercourse'] = 'Kliknij, aby wejść do kursu';
$string['enteremail'] = 'Wprowadź swój adres e-mail';
$string['enteremailaddress'] = 'Wprowadź swój adres e-mail, aby wykasować twoje hasło i otrzymać pocztą elektroniczną nowe.';
$string['enterusername'] = 'Wprowadź swoją nazwę użytkownika';
$string['entries'] = 'Wpisy';
$string['error'] = 'Błąd';
$string['errorcreatingactivity'] = 'Nie można utworzyć instancji aktywności \'{$a}\'';
$string['errorfiletoobig'] = 'Plik był większy niż limit bajtów {$a}';
$string['errornouploadrepo'] = 'Dla tej strony nie aktywowano żadnego repozytorium plików';
$string['errorwhenconfirming'] = 'Potwierdzenie nie zostało przesłane z powodu wystąpienia błędu. Jeśli kliknąłeś na link w mailu, upewnij się, że nie odwoływał się on do nieistniejącej strony albo że jego dalszy ciąg nie znajdował się w następnej linii wiadomości.';
$string['eventcontentviewed'] = 'Oglądana zawartość';
$string['eventcoursecategorydeleted'] = 'Kategoria usunięta';
$string['eventcoursecontentdeleted'] = 'Zawartość kursu skasowana';
$string['eventcoursecreated'] = 'Kurs utworzony';
$string['eventcoursedeleted'] = 'Kurs usunięty';
$string['eventcoursemodulecreated'] = 'Moduł kursu utworzony';
$string['eventcoursemoduledeleted'] = 'Moduł kursu usunięty';
$string['eventcoursemoduleupdated'] = 'Moduł kursu zaktualizowany';
$string['eventcourseresetended'] = 'Resetowanie kursu zakończone';
$string['eventcourseresetstarted'] = 'Resetowanie kursu rozpoczęte';
$string['eventcourserestored'] = 'Kurs przywrócony';
$string['eventcoursesectionupdated'] = 'Sekcja kursu zaktualizowana';
$string['eventcourseupdated'] = 'Kurs zaktualizowany';
$string['eventusercreated'] = 'Użytkownik utworzony';
$string['eventuserdeleted'] = 'Użytkownik usunięty';
$string['eventuserlistviewed'] = 'Oglądana lista użytkownika';
$string['eventuserloggedout'] = 'Użytkownik wylogowany';
$string['eventuserprofileviewed'] = 'Oglądany profil użytkownika';
$string['eventuserupdated'] = 'Użytkownik zaktualizowany';
$string['everybody'] = 'Wszyscy';
$string['executeat'] = 'Wykonaj';
$string['existing'] = 'Istniejące';
$string['existingadmins'] = 'Istniejący administratorzy';
$string['existingcourse'] = 'Istniejące kursy';
$string['existingcourseadding'] = 'Istniejący kurs, dodawanie danych do niego';
$string['existingcoursedeleting'] = 'Istniejący kurs, po jego uprzednim wykasowaniu';
$string['existingcreators'] = 'Istniejący autorzy kursów';
$string['existingstudents'] = 'Zapisani studenci';
$string['existingteachers'] = 'Istniejący nauczyciele';
$string['expand'] = 'Rozszerzać';
$string['expandall'] = 'Rozwiń wszystko';
$string['expandcategory'] = 'Rozwiń {$a}';
$string['explanation'] = 'Wyjaśnienie';
$string['extendenrol'] = 'Rozszerz zapisy (indywidualne)';
$string['extendperiod'] = 'Przedłużony okres';
$string['failedloginattempts'] = '{$a->attempts} nieudanych prób logowania od Twojego ostatniego logowania';
$string['failedloginattemptsall'] = '{$a->attempts} nieudanych prób logowania do {$a->accounts} kont.';
$string['feedback'] = 'Informacja zwrotna';
$string['file'] = 'Plik';
$string['fileexists'] = 'Istnieje już plik o nazwie {$a}';
$string['filemissing'] = 'brak {$a}';
$string['files'] = 'Pliki';
$string['filesanduploads'] = 'Pliki i przesyłanie';
$string['filesfolders'] = 'Pliki/foldery';
$string['filetoolarge'] = 'jest zbyt duży do przesłania';
$string['fileuploadwithcontent'] = 'Wgrywanie pliku nie zawiera parametru treści';
$string['filloutallfields'] = 'Należy wypełnić wszystkie pola formularza';
$string['filter'] = 'Filtr';
$string['findmorecourses'] = 'Znajdź więcej kursów ...';
$string['first'] = 'Pierwszy';
$string['firstaccess'] = 'Pierwsze wejście';
$string['firstname'] = 'Imię';
$string['firstnamephonetic'] = 'Imię - fonetyczne';
$string['firstsiteaccess'] = 'Pierwszy dostęp do strony';
$string['firsttime'] = 'Czy jesteś w tym serwisie po raz pierwszy?';
$string['folder'] = 'Folder';
$string['folderclosed'] = 'Zamknięty folder';
$string['folderopened'] = 'Otwarty folder';
$string['followingoptional'] = 'Następujące punkty są opcjonalne';
$string['followingrequired'] = 'Następujące punkty są wymagane';
$string['for'] = 'Dla';
$string['force'] = 'Wymuś';
$string['forcelanguage'] = 'Wymuś język';
$string['forceno'] = 'Nie wymuszaj';
$string['forcepasswordchange'] = 'Wymuś zmianę hasła';
$string['forcepasswordchangecheckfull'] = 'Czy jesteś absolutnie pewny(a), że chcesz wymusić zmianę hasła dla {$a} ?';
$string['forcepasswordchange_help'] = 'Jeśli to pole zostanie zaznaczone, użytkownik zostanie poproszony o zmianę hasła przy następnym logowaniu';
$string['forcepasswordchangenot'] = 'Nie udało się wymusić zmiany hasła dla {$a}';
$string['forcepasswordchangenotice'] = 'W celu kontynuacji musisz zmienić swoje hasło';
$string['forcetheme'] = 'Wymuś temat';
$string['forgotaccount'] = 'Zapomniałeś hasła?';
$string['forgotten'] = 'Zapomniałeś(aś) nazwy użytkownika lub hasła?';
$string['forgottenduplicate'] = 'Ten adres e-mail należy do kilku kont. Wpisz nazwę użytkownika.';
$string['forgotteninvalidurl'] = 'Link do zmiany hasła wygasł';
$string['format'] = 'Format';
$string['format_help'] = '<P ALIGN=CENTER><B>Formaty kursów w Moodle</B></P>

<P><B>Format tygodniowy</B></P>

<UL>
Kurs zorganizowany jest w cyklu tygodniowym z dokładnie określoną datą rozpoczęcia i zakończenia. Każdy tydzień składa się z pewnej liczby składowych kursu. Niektóre z nich, takie jak dzienniki, mogą mieć czasowo ograniczone &quot;okno dostępu&quot;, czyli okres trwający np. dwa tygodnie, po zakończeniu którego przestają być dostępne.
</UL>


<P><B>Format tematyczny</B></P>
<UL>
Format ten jest bardzo zbliżony do formatu tygodniowego, z wyjątkiem tego, że kurs zamiast na tygodnie podzielony jest na tematy. Tematy nie mają żadnych ograniczeń czasowych i nie musisz podawać żadnych dat.
</UL>


<P><B>Format towarzyski</B></P>
<UL>
Jest to format zorientowany na jedno główne forum - Forum towarzyskie - które wyświetlone jest na stronie głównej. Format ten jest przydatny w sytuacjach, w których forma działania nie jest sprecyzowana. Nie muszą być to nawet kursy, przykładowym zastosowaniem jest wydziałowa tablica ogłoszeń.
</UL>';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format tekstu zwykłego';
$string['formattext'] = 'Automatyczny format Moodle';
$string['formattexttype'] = 'Formatowanie';
$string['framesetinfo'] = 'Ramka dokumentu zawiera:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Lista wyboru';
$string['frontpagecategorynames'] = 'Pokaż listę kategorii';
$string['frontpagecourselist'] = 'Pokaż listę kursów';
$string['frontpagecoursesearch'] = 'Wyszukiwarka kursów';
$string['frontpagedescription'] = 'Opis strony głównej';
$string['frontpagedescriptionhelp'] = 'Opis strony zostanie wyświetlony na głównej stronie';
$string['frontpageenrolledcourselist'] = 'Kursy przypisane';
$string['frontpageformat'] = 'Układ strony głównej';
$string['frontpageformatloggedin'] = 'Format strony głównej po zalogowaniu';
$string['frontpagenews'] = 'Pokaż nowości';
$string['frontpagesettings'] = 'Ustawienia strony głównej';
$string['fulllistofcourses'] = 'Wszystkie kursy';
$string['fullname'] = 'Pełna nazwa';
$string['fullnamecourse'] = 'Pełna nazwa';
$string['fullnamecourse_help'] = 'Pełna nazwa kursu wyświetlana jest na górze każdej strony w kursie oraz na liście kursów';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Pełna nazwa';
$string['fullprofile'] = 'Pełny profil';
$string['fullsitename'] = 'Pełna nazwa serwisu';
$string['functiondisabled'] = 'Ta funkcja jest obecnie wyłączona';
$string['general'] = 'Ogólne';
$string['geolocation'] = 'szerokość - długość geograficzna';
$string['gettheselogs'] = 'Pobierz logi';
$string['go'] = 'Wykonaj';
$string['gpl'] = 'Niniejsze oprogramowanie jest oprogramowaniem darmowym; dozwolone jest jego dalsze rozpowszechnianie i/lub modyfikowanie zgodnie z warunkami Powszechnej Licencji Publicznej GNU opublikowanej przez Free Software Foundation, wersja 2 lub dowolna późniejsza. Oprogramowanie to jest rozpowszechniane przy założeniu, że będzie przydatne ale BEZ UDZIELANIA JAKIEJKOLWIEK GWARANCJI, nawet domniemanej gwarancji JAKOŚCI HANDLOWEJ lub PRZYDATNOŚCI DO OKREŚLONEGO CELU. Szczegółowe informacje znajdują się w Powszechnej Licencji Publicznej GNU dostępnej na stronie http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Niniejsze oprogramowanie jest oprogramowaniem darmowym; dozwolone jest jego dalsze rozpowszechnianie i/lub modyfikowanie zgodnie z warunkami Powszechnej Licencji Publicznej GNU opublikowanej przez Free Software Foundation, wersja 3 lub dowolna późniejsza.

Oprogramowanie to jest rozpowszechniane przy założeniu, że będzie przydatne ale BEZ UDZIELANIA JAKIEJKOLWIEK GWARANCJI, nawet domniemanej gwarancji JAKOŚCI HANDLOWEJ lub PRZYDATNOŚCI DO OKREŚLONEGO CELU.

Szczegółowe informacje znajdują się w Powszechnej Licencji Publicznej GNU dostępnej na stronie http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'Licencja GPL';
$string['grade'] = 'Ocena';
$string['grades'] = 'Oceny';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> jest włączona dla tej witryny. Jeśli nie wstawiłeś swojego zdjęcia w profilu  Moodle  będzie próbował załadować zdjęcie profilowe z serwisu Gravatar.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodaj nową grupę';
$string['groupaddusers'] = 'Dodaj do grupy';
$string['groupextendenrol'] = 'Rozszerz zapisy (powszechne)';
$string['groupfor'] = 'dla grupy';
$string['groupinfo'] = 'Informacje o wybranej grupie';
$string['groupinfoedit'] = 'Edytuj ustawienia grup';
$string['groupinfomembers'] = 'Informacje o wybranych członkach';
$string['groupinfopeople'] = 'Informacje o wybranych ludziach';
$string['groupmembers'] = 'Członkowie grupy';
$string['groupmemberssee'] = 'Zobacz członków grupy';
$string['groupmembersselected'] = 'Członkowie wybranych grup';
$string['groupmode'] = 'Rodzaj grup';
$string['groupmodeforce'] = 'Wymuś grupy';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Uczestnicy nie w mojej grupie';
$string['groupnotamember'] = 'Nie jesteś przypisany do tej grupy';
$string['grouprandomassign'] = 'Losowo przypisz wszystkich do grup';
$string['groupremove'] = 'Usuń zaznaczoną grupę';
$string['groupremovemembers'] = 'Usuń zaznaczonych członków';
$string['groups'] = 'Grupy';
$string['groupsnone'] = 'Bez grup';
$string['groupsseparate'] = 'Osobne grupy';
$string['groupsvisible'] = 'Widoczne grupy';
$string['guest'] = 'Gość';
$string['guestdescription'] = 'Goście mają niewiele uprawnień i przeważnie nie mogą nigdzie nic wpisywać.';
$string['guestskey'] = 'Zezwól gościom posiadającym klucz';
$string['guestsno'] = 'Wejście dla gości nie jest dozwolone';
$string['guestsnotallowed'] = 'Niestety, kurs \'{$a}\' nie jest dostępny dla gości.';
$string['guestsyes'] = 'Wejście dla gości bez klucza jest dozwolone';
$string['guestuser'] = 'Gość';
$string['guestuserinfo'] = 'To jest specjalny użytkownik, który posiada prawa dostępu do niektórych kursów wyłącznie w trybie \'do odczytu\'.';
$string['help'] = 'Pomoc';
$string['helpprefix2'] = 'Pomoc z {$a}';
$string['helpwiththis'] = 'Pomóż z tym';
$string['hiddenassign'] = 'Ukryte zadanie';
$string['hiddenfromstudents'] = 'Ukryte przed studentami';
$string['hiddensections'] = 'Ukryte sekcje';
$string['hiddensectionscollapsed'] = 'Ukryte sekcje są pokazane w zminimalizowanej postaci';
$string['hiddensections_help'] = '<P>Opcja ta pozwala Ci zdecydować, jak mają być wyświetlane studentom ukryte sekcje.</p>

<p>Domyślnie mały obszar (zwinięty, zwykle szary) jest pokazany w miejscu ukrytej sekcji. Student nie może zobaczyć ukrytych składowych i tekstów. Szczególnie użyteczna jest ta forma w formacie tygodniowym.
</p>

<p>Jeśli chcesz, możesz kompletnie ukryć sekcje, tak że studenci nie wiedzą nawet, że coś jest ukryte.</p>';
$string['hiddensectionsinvisible'] = 'Ukryte sekcje są całkowicie niewidoczne';
$string['hide'] = 'Ukryj';
$string['hideadvancedsettings'] = 'Ukryj ustawienia zaawansowane';
$string['hidepicture'] = 'Ukryj obraz';
$string['hidesection'] = 'Ukryj sekcję {$a}';
$string['hidesettings'] = 'Ukryj ustawienia';
$string['hideshowblocks'] = 'Ukryj lub pokaż bloki';
$string['hits'] = 'Wyświetlenia';
$string['hitsoncourse'] = 'Wyświetlenia {$a->coursename} przez {$a->username}';
$string['hitsoncoursetoday'] = 'Dzisiejsze wyświetlenia w {$a->coursename} przez {$a->username}';
$string['home'] = 'Strona główna';
$string['hour'] = 'godz.';
$string['hours'] = 'godz.';
$string['howtomakethemes'] = 'Jak utworzyć nowy temat';
$string['htmleditor'] = 'Użyj edytora HTML';
$string['htmleditoravailable'] = 'Edytor HTML jest dostępny';
$string['htmleditordisabled'] = 'Masz wyłączony edytor HTML w swoim profilu użytkownika';
$string['htmleditordisabledadmin'] = 'Administrator wyłączył edytor HTML w tym serwisie';
$string['htmleditordisabledbrowser'] = 'Edytor HTML jest niedostępny ponieważ nie używasz Internet Explorera 5.5 lub nowszego.';
$string['htmlfilesonly'] = 'Tylko pliki HTML';
$string['htmlformat'] = 'Pełny format HTML';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'Numer ICQ';
$string['idnumber'] = 'Numer ID';
$string['idnumbercourse'] = 'ID kursu';
$string['idnumbercoursecategory'] = 'ID kategorii';
$string['idnumbercoursecategory_help'] = 'Numer ID kategorii kursu jest używany przy współpracy z zewnętrznymi systemami i nie jest nigdzie wyświetlany. Jeśli kategoria ma oficjalna nazwę kodową, może być wprowadzona. W przeciwnym razie polo może zostać puste.';
$string['idnumbercourse_help'] = '<P ALIGN=CENTER><B>Numer ID kursu</B></P>

<P>Wartość używana tylko w przypadku zewnętrznej kontroli zapisu. Nie ujrzysz jej nigdy w Moodle. Jeśli masz jakiś oficjalny kod dla kursu, użyj go tutaj.</p>';
$string['idnumbergroup'] = 'Numer ID grupy';
$string['idnumbergroup_help'] = 'Nr grupy jest tylko używane podczas dopasowania grupy przed zewnętrznymi systemami i nie jest nigdzie wyświetlane na stronie. Jeżeli grupa ma oficjalną nazwę kodu, można ją wprowadzić, inaczej pole powinno pozostać puste.';
$string['idnumbergrouping'] = 'Numer ID grupy nadrzędnej';
$string['idnumbergrouping_help'] = 'Nr ID grupy nadrzędnej jest używany tylko podczas dopasowania grupy nadrzędnej z zewnętrznymi systemami i nie jest nigdzie wyświetlane na stronie. Jeżeli grupa nadrzędna ma oficjalną nazwę kodu, można ją wprowadzić, inaczej pole powinno pozostać puste.';
$string['idnumbermod'] = 'Numer ID';
$string['idnumbermod_help'] = 'Ustawienie numeru ID stanowi sposób na identyfikowanie aktywności w obliczeniach ocen. Jeżeli aktywność nie jest wykorzystywana w obliczeniach ocen, numer ID może pozostać pusty.';
$string['idnumbertaken'] = 'Ten numer ID jest już zajęty';
$string['imagealt'] = 'Opis zdjęcia';
$string['import'] = 'Import';
$string['importdata'] = 'Importuj dane kursu';
$string['importdataexported'] = 'Eksport danych kompletny.<br/> Kliknij \'Kontynuuj\', aby importować je do wskazanego kursu.';
$string['importdatafinished'] = 'Import kompletny. Powróć do kursu';
$string['importdatafrom'] = 'Znajdź kurs, z którego chcesz importować dane:';
$string['inactive'] = 'Nieaktywne';
$string['include'] = 'Uwzględnij';
$string['includeallusers'] = 'Uwzględnij wszystkich użytkowników';
$string['includecoursefiles'] = 'Uwzględnij pliki kursu';
$string['includecourseusers'] = 'Uwzględnij użytkowników kursu';
$string['included'] = 'Uwzględniono';
$string['includelogentries'] = 'Uwzględnij logi';
$string['includemodules'] = 'Uwzględnij moduły';
$string['includemoduleuserdata'] = 'Uwzględnij dane użytkowników modułu';
$string['includeneededusers'] = 'Uwzględnij potrzebnych użytkowników';
$string['includenoneusers'] = 'Nie uwzględniaj żadnych użytkowników';
$string['includeroleassignments'] = 'Uwzględnij przypisania ról';
$string['includesitefiles'] = 'Dołącz pliki strony głównej użyte w tym kursie';
$string['includeuserfiles'] = 'Uwzględnij pliki użytkowników';
$string['increasesections'] = 'Zwiększ liczbę sekcji';
$string['info'] = 'Informacja';
$string['institution'] = 'Instytucja';
$string['instudentview'] = 'widok studenta';
$string['interests'] = 'Zainteresowania';
$string['interestslist'] = 'Lista zainteresowań';
$string['interestslist_help'] = 'Wpisz swoje zainteresowanie oddzielając je przecinkami. Twoje zainteresowania będą wyświetlane na stronie Twojego profilu jako tagi.';
$string['invalidemail'] = 'Niewłaściwy adres e-mail';
$string['invalidlogin'] = 'Niewłaściwa nazwa użytkownika lub hasło, spróbuj ponownie';
$string['invalidusername'] = 'Nazwa użytkownika może zawierać tylko znaki alfanumeryczne: małe litery, podkreślenia ( _ ), łączniki ( - ), podziały ( . ) lub symbol ( @ )';
$string['invalidusernameupload'] = 'Niepoprawna nazwa użytkownika';
$string['ip_address'] = 'Adres IP';
$string['jump'] = 'Przejdź';
$string['jumpto'] = 'Przejdź do...';
$string['keep'] = 'Przechowaj';
$string['keepsearching'] = 'Zatrzymaj szukanie';
$string['langltr'] = 'Kierunek języka od lewej do prawej';
$string['langrtl'] = 'Kierunek języka od prawej do lewej';
$string['language'] = 'Język';
$string['languagegood'] = 'Ten pakiet językowy jest aktualny';
$string['last'] = 'Ostatni';
$string['lastaccess'] = 'Ostatni dostęp';
$string['lastcourseaccess'] = 'Ostatni dostęp do kursu';
$string['lastedited'] = 'Ostatnia modyfikacja';
$string['lastlogin'] = 'Ostanie zalogowanie';
$string['lastmodified'] = 'Ostatnia modyfikacja';
$string['lastname'] = 'Nazwisko';
$string['lastnamephonetic'] = 'Nazwisko - fonetyczne';
$string['lastsiteaccess'] = 'Ostatni dostęp do strony';
$string['lastyear'] = 'Zeszły rok';
$string['latestlanguagepack'] = 'Szukaj najnowszego pakietu językowego na moodle.org';
$string['layouttable'] = 'Układ tabeli';
$string['leavetokeep'] = 'Pozostaw puste, aby zachować dotychczasowe hasło';
$string['legacythemeinuse'] = 'Ta strona wyświetlana jest w trybie zgodności ponieważ Twoja przeglądarka jest zbyt stara.';
$string['license'] = 'Licencja';
$string['licenses'] = 'Licencje';
$string['liketologin'] = 'Czy chcesz sie zalogować z pełnymi prawami użytkownika?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista plików w {$a}';
$string['listofallpeople'] = 'Lista wszystkich osób';
$string['listofcourses'] = 'Wykaz kursów';
$string['loadinghelp'] = 'Ładowanie ...';
$string['local'] = 'Lokalny';
$string['localplugins'] = 'Wtyczki lokalne';
$string['localpluginsmanage'] = 'Zarządzaj wtyczkami lokalnymi';
$string['location'] = 'Lokalizacja';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Jesteś zalogowany(a) jako {$a}';
$string['loggedinasguest'] = 'Jesteś zalogowany jako gość';
$string['loggedinnot'] = 'Nie jesteś zalogowany(a)';
$string['login'] = 'Zaloguj się';
$string['loginalready'] = 'Jesteś już zarejestrowany';
$string['loginas'] = 'Zaloguj się jako';
$string['loginaspasswordexplain'] = '<p>Wprawadź specjalny "loginas password", aby uzyskać dostęp do tego ustawienia.<br/>';
$string['login_failure_logs'] = 'Logi nieudanych prób logowania';
$string['loginguest'] = 'Zaloguj się jako gość';
$string['loginsite'] = 'Zaloguj się do serwisu';
$string['loginsteps'] = '<p>Witaj!</p>
<p>Aby otrzymać pełny dostęp do kursów, musisz stworzyć konto w tym serwisie. </p>
<p>Każdy z kursów może wymagać podania jednorazowego "klucza dostępu do kursu", który będzie potrzebny tylko przy zapisywaniu się na kurs. </p><p>Oto kroki, które musisz wykonać: <ol> <li>Wypełnij formularz <a href="{$a}">Nowe konto</a> swoimi danymi. </li><li>Po chwili na podany przez Ciebie adres zostanie wysłany e-mail.</li><li>Otwórz wiadomość i kliknij zawarty tam link. </li><li>Twoje konto zostanie potwierdzone i będziesz mógł się zalogować. </li><li>Wybierz kurs, w którym chcesz wziąć udział.   </li><li>Jeżeli zostaniesz poproszony(a) o podanie "klucza dostępu do kursu" - wpisz otrzymany od prowadzącego klucz. W ten sposób zapiszesz się na kurs. </li><li>Od tego momentu będziesz mieć dostęp do kursu. Aby zalogować się i uzyskać dostęp do kursów, na które się zapisałeś, konieczne będzie tylko wpisanie Twojej nazwy użytkownika i hasła (w formularzu na tej stronie).</li></ol>';
$string['loginstepsnone'] = 'Dla uzyskania pełnego dostępu do kursów niezbędne jest utworzenie konta.<br />Utwórz nazwę użytkownika i hasło oraz użyj tych danych w formularza na tej stronie!<br /> Jeżeli ktoś inny wybrał już taką nazwę użytkownika, będziesz musiał(a) powtórzyć operację używając innej nazwy.';
$string['loginto'] = 'Zaloguj do {$a}';
$string['logout'] = 'Wyloguj';
$string['logoutconfirm'] = 'Czy chcesz się wylogować?';
$string['logs'] = 'Logi';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">więcej</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">więcej</a> ]';
$string['lookback'] = 'Zobacz poprzednie';
$string['mailadmins'] = 'Powiadom administratorów';
$string['mailstudents'] = 'Powiadom studentów';
$string['mailteachers'] = 'Powiadom nauczycieli';
$string['maincoursepage'] = 'Strona główna kursu';
$string['makeafolder'] = 'Utwórz folder';
$string['makeeditable'] = 'Jeżeli umożliwisz edycję \'{$a}\' przez proces serwera WWW (np. Apache), możesz dokonać edycji tego pliku bezpośrednio z tej strony.';
$string['makethismyhome'] = 'Ustaw jako domyślną stronę główną';
$string['manageblocks'] = 'Bloki';
$string['managecategorythis'] = 'Zarządzaj tą kategorią';
$string['managecourses'] = 'Zarządzaj kursami';
$string['managedatabase'] = 'Zarządzaj bazą danych';
$string['manageeditorfiles'] = 'Zarządzaj plikami używanymi przez edytor';
$string['managefilters'] = 'Filtry';
$string['managemodules'] = 'Zarządzaj modułami';
$string['manageroles'] = 'Role i uprawnienia';
$string['markedthistopic'] = 'Ten temat jest wybrany jako temat aktualny';
$string['markthistopic'] = 'Zaznacz ten temat jako aktualny';
$string['matchingsearchandrole'] = 'Pasujące: \'{$a->search}\' i {$a->role}';
$string['maxareabytesreached'] = 'Plik (lub całkowity rozmiar kilku plików) jest większy niż pozostałe miejsce w tym obszarze.';
$string['maxbytesforfile'] = 'Plik {$a} jest większy niż maksymalny dopuszczalny rozmiar.';
$string['maxfilesize'] = 'Maksymalny rozmiar dla nowych plików: {$a}';
$string['maxfilesreached'] = 'Możesz dołączyć maksymalnie {$a} plik(i)(ów) do tej pozycji';
$string['maximumchars'] = 'Maksymalnie {$a} znaków';
$string['maximumgrade'] = 'Maksymalna ocena';
$string['maximumgradex'] = 'Maksymalna ocena: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maksymalny rozmiar pliku';
$string['maximumupload_help'] = '<P ALIGN=CENTER><B>Maksymalny dopuszczalny rozmiar pliku w ramach jednego kursu.</B></P>

<P>Ten paramter definiuje największy dopuszczalny rozmiar pliku
który może być przesłany przez studenta w ramach danego kursu.
Ten paramter nie może przekroczyć parametru maksymalnej wielkości pliku dla całej strony internetowej,
którego sprecyzowanie należy do zadań administratora sieci.

<P>Możliwe jest dalsze ograniczenie rozmiaru pliku poprzez odpowiednie zmiany
ustawień w ramach każdego modułu aktywności (activity module).';
$string['maxnumberweeks'] = 'Maksymalna liczba sekcji';
$string['maxnumberweeks_desc'] = 'Ta opcja steruje maksymalnymi wartościami opcji, które pojawiają się w ustawieniach "Liczba tygodni/tematów" w kursach';
$string['maxnumcoursesincombo'] = 'Przeglądaj <a href="{$a->link}">{$a->numberofcourses} kursy(ów)</a>.';
$string['maxsize'] = 'Maksymalny rozmiar: {$a}';
$string['maxsizeandareasize'] = 'Maksymalny rozmiar dla nowych plików: {$a->size}, ogólny limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksymalny rozmiar dla nowych plików: {$a->size}, maksimum załączników: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksymalny rozmiar dla nowych plików: {$a->size}, maksymalnie załączników: {$a->attachments}, ogólny limit: {$a->areasize}';
$string['memberincourse'] = 'Zapisani na kurs';
$string['messagebody'] = 'Treść wiadomości';
$string['messagedselectedusers'] = 'Zaznacz użytkowników, do których została wysłana wiadomość i wyczyść listę odbiorców.';
$string['messagedselectedusersfailed'] = 'Nastąpił błąd podczas przesyłania wiadomości do zaznaczonych użytkowników. Część z nich mogła otrzymać ten e-mail.';
$string['messageprovider:availableupdate'] = 'Powiadomienia o dostępnych aktualizacjach';
$string['messageprovider:backup'] = 'Powiadomienie o kopii zapasowej';
$string['messageprovider:badgecreatornotice'] = 'Powiadomienia twórcy odznaki';
$string['messageprovider:badgerecipientnotice'] = 'Powiadomienia odbiorcy odznaki';
$string['messageprovider:courserequestapproved'] = 'Powiadomienie o zatwierdzeniu prośby o utworzenie kursu';
$string['messageprovider:courserequested'] = 'Powiadomienie o prośbie o utworzenie kursu';
$string['messageprovider:courserequestrejected'] = 'Powiadomienie o odrzuceniu prośby o utworzenie kursu';
$string['messageprovider:errors'] = 'Ważne błędy z witryny';
$string['messageprovider:errors_help'] = 'Są to istotne błędy, o których powinien wiedzieć administrator.';
$string['messageprovider:instantmessage'] = 'Osobiste wiadomości między użytkownikami';
$string['messageprovider:instantmessage_help'] = 'W tej sekcji można skonfigurować, co dzieje się z wiadomościami przesyłanymi przez innych użytkowników.';
$string['messageprovider:notices'] = 'Powiadomienia o drobnych problemach';
$string['messageprovider:notices_help'] = 'Są to powiadomienia, którymi mógłby się zainteresować administrator.';
$string['messageselect'] = 'Zaznacz tego użytkownika jako odbiorcę e-mail\'a';
$string['messageselectadd'] = 'Wyślij wiadomość';
$string['middlename'] = 'Drugie imię';
$string['migratinggrades'] = 'Przenoszenie ocen';
$string['min'] = 'min';
$string['mins'] = 'min.';
$string['minute'] = 'minuta';
$string['minutes'] = 'minuty';
$string['miscellaneous'] = 'Inne';
$string['missingcategory'] = 'Musisz wybrać kategorię';
$string['missingcity'] = 'Pominięto miejscowość';
$string['missingcountry'] = 'Pominięto kraj';
$string['missingdescription'] = 'Pominięto opis';
$string['missingemail'] = 'Pominięto adres e-mail';
$string['missingfirstname'] = 'Pominięto imię';
$string['missingfromdisk'] = 'Pominięto plik z dysku';
$string['missingfullname'] = 'Pominięto pełną nazwę';
$string['missinglastname'] = 'Pominięto nazwisko';
$string['missingname'] = 'Pominięto imię';
$string['missingnewpassword'] = 'Pominięto nowe hasło';
$string['missingpassword'] = 'Pominięto hasło';
$string['missingrecaptchachallengefield'] = 'Nie wpisano tekstu reCAPTCHA';
$string['missingreqreason'] = 'Pominięto powód';
$string['missingshortname'] = 'Pominięto nazwę skróconą';
$string['missingshortsitename'] = 'Pominięto skróconą nazwę serwisu';
$string['missingsitedescription'] = 'Pominięto opis serwisu';
$string['missingsitename'] = 'Pominięto nazwę serwisu';
$string['missingstrings'] = 'Poszukaj brakujących łańcuchów znaków';
$string['missingstudent'] = 'Należy coś wybrać';
$string['missingsummary'] = 'Pominięto streszczenie';
$string['missingteacher'] = 'Należy coś wybrać';
$string['missingurl'] = 'Pominięto adres URL';
$string['missingusername'] = 'Pominięto nazwę użytkownika';
$string['modchooserdisable'] = 'Wybór aktywności wyłączony';
$string['modchooserenable'] = 'Wybór aktywności włączony';
$string['moddoesnotsupporttype'] = 'Moduł {$a->modname} nie pozwala na przesyłanie treści typu {$a->type}';
$string['modified'] = 'Zmodyfikowano';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Tworzenie tablic modułów';
$string['modulesuccess'] = 'tablice dla modułu {$a} utworzono poprawnie';
$string['modulesused'] = 'Używane moduły';
$string['month'] = 'miesiąc';
$string['months'] = 'miesiące';
$string['moodledocs'] = 'Dokumentacja Moodle';
$string['moodledocslink'] = 'Dokumentacja Moodle dla tej strony';
$string['moodlerelease'] = 'Wydanie Moodle';
$string['moodleversion'] = 'Wersja Moodle';
$string['more'] = 'więcej';
$string['morehelp'] = 'Więcej pomocy';
$string['moreinformation'] = 'Więcej informacji o tym błędzie';
$string['moreprofileinfoneeded'] = 'Proszę, napisz coś więcej o sobie.';
$string['mostrecently'] = 'najświeższe';
$string['move'] = 'Przenieś';
$string['movecategoriessuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do kategorii \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do nadrzędnego poziomu';
$string['movecategorycontentto'] = 'Przenieś do';
$string['movecategorysuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do kategorii \'{$a->to}\'';
$string['movecategoryto'] = 'Przenieś kategorię do:';
$string['movecategorytotopsuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do nadrzędnego poziomu';
$string['movecontent'] = 'Przenieś {$a}';
$string['movecontentstoanothercategory'] = 'Przenieś zawartość do innej kategorii';
$string['movecoursemodule'] = 'Przenieś zasób';
$string['movecoursesection'] = 'Przenieś sekcję';
$string['movecourseto'] = 'Przenieś kurs do:';
$string['movedown'] = 'Przesuń w dół';
$string['movefilestohere'] = 'Przesuń pliki tutaj';
$string['movefull'] = 'Przenieś {$a} do tej lokacji';
$string['movehere'] = 'Przenieś tutaj';
$string['moveleft'] = 'Przenieś na lewo';
$string['moveright'] = 'Przenieś na prawo';
$string['movesection'] = 'Przenieś sekcję {$a}';
$string['moveselectedcategoriesto'] = 'Przenieś wybrane kategorie do';
$string['moveselectedcoursesto'] = 'Przenieś zaznaczone kursy do...';
$string['movetoanotherfolder'] = 'Przesuń do innego folderu';
$string['moveup'] = 'Przesuń w górę';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nowe hasło musi być inne niż aktualnie używane.';
$string['mustconfirm'] = 'Musisz potwierdzić swoją nazwę użytkownika';
$string['mycourses'] = 'Moje kursy';
$string['myfiles'] = 'Moje prywatne pliki';
$string['myfilesmanage'] = 'Zarządzaj plikami prywatnymi';
$string['myhome'] = 'Moja strona domowa';
$string['mymoodledashboard'] = 'Mój ekran ustawień Moodle';
$string['myprofile'] = 'Mój profil';
$string['name'] = 'Nazwa';
$string['nameforlink'] = 'Jak chcesz nazwać łącze?';
$string['nameforpage'] = 'Nazwa';
$string['navigation'] = 'Nawigacja';
$string['needed'] = 'Wymagane';
$string['never'] = 'Nigdy';
$string['neverdeletelogs'] = 'Nigdy nie usuwaj logów';
$string['new'] = 'Nowy';
$string['newaccount'] = 'Nowe konto';
$string['newcourse'] = 'Nowy kurs';
$string['newpassword'] = 'Nowe hasło';
$string['newpasswordfromlost'] = '<strong>NOTICE:</strong> Twoje <strong>obecne hasło</strong> zostanie do Ciebie wysłane w dwóch
mailach. Po otrzymaniu nowego hasła będziesz mógł skorzystać z tej strony.';
$string['newpassword_help'] = 'Wprowadź nowe hasło lub pozostaw puste pole by zachować obecne hasło.';
$string['newpasswordtext'] = 'Witaj {$a->firstname}.

Twoje dotychczasowe hasło w serwisie \'{$a->sitename}\' zostało usunięte.

Twoje obecne dane do logowania są następujące:

nazwa użytkownika: {$a->username}
hasło: {$a->newpassword}

Aby zmienić to hasło, kliknij na ten link: {$a->link}

W większości skrzyenk mailowych ten adres powinien wyświetlać się jako niebieski link. Kliknięcie na niego przeniesie automatycznie na stronę zmiany hasła. W przeciwnym razie skopiuj podany adres do pola adresowego przeglądarki internetowej i naciśnij enter.

Pozdrowienia od administratora
{$a->signoff}';
$string['newpicture'] = 'Nowy obraz';
$string['newpicture_help'] = '<P ALIGN=CENTER><B>Przesyłanie grafiki</B></P>

<P>Możesz przesłać na ten serwer plik graficzny ze swojego komputera.  Plik ten będzie Cię reprezentował w różnych miejscach.
<P>Z podanego powyżej powodu najlepszym wizerunkiem będzie Twój portret z bliska, ale możesz wykorzystać dowolną inną grafikę.
<P>Plik graficzny musi mieć format JPG lub PNG (tzn. jego nazwa powinna mieć rozszerzenie .jpg lub .png).
<P>Są cztery sposoby uzyskania pliku graficznego:

<OL>
<LI>Zdjęcia wykonane cyfrowym aparatem fotograficznym zapisane w Twoim komputerze najprawdopodobniej będą już we właściwym formacie.
<LI>Możesz zeskanować odbitkę fotograficzną - pamiętaj o zapisaniu pliku w formacie JPG lub PNG.
<LI>Jeżeli masz zdolności artystyczne, możesz sam zrobić rysunek używając programu do malowania.
<LI>Możesz &quot;podkraść&quot; plik graficzny z sieci WWW.  <A TARGET=google HREF="http://images.google.com/">http://images.google.com</A> to znakomite miejsce do szukania grafiki. Po znalezieniu odpowiedniego pliku, kliknij prawym przyciskiem myszy i wybierz polecenie &quot;Zapisz rysunek&quot; z menu (procedura ta może się trochę różnić w zależności od komputera).
</OL>

<P>W celu przesłania pliku graficznego, kliknij przycisk &quot;Przeglądaj&quot; na niniejszej stronie edycji i wybierz odpowiedni plik z twardego dysku.</p>
<P>UWAGA: Upewnij się że plik ten nie przekracza podanego maksymalnego rozmiaru, w przeciwnym razie nie zostanie on przesłany.</p>
<P>Następnie kliknij &quot;Aktualizuj mój profil&quot; na dole ekranu  - obraz zostanie przycięty i zmniejszony do rozmiaru 100 na 100 pikseli.</p>
<P>Gdy powrócisz na stronę profilu, być może nie zmieni się wygląd reprezentującej Cię grafiki. W takim przypadku kliknij w swojej przeglądarce przycisk &quot;Odśwież&quot;.</p>';
$string['newsitem'] = 'Wiadomość';
$string['newsitems'] = 'Wiadomości';
$string['newsitemsnumber'] = 'Wiadomości do pokazania';
$string['newsitemsnumber_help'] = '<P ALIGN=CENTER><B>Aktualności kursu</B></P>

<P>Specjalne forum &quot;Aktualności&quot; pojawia się w kursach o formacie tygodniowym lub tematycznym. Jest to dobre miejsce do umieszczania wiadomości przeznaczonych dla wszystkich studentów. (W ustawieniu domyślnym wszyscy studenci są zapisani na to forum i otrzymują Twoje wiadomości pocztą elektroniczną.)</p>

<P>Funkcja ta określa ile ostatnich pozycji wyświetlanych jest na stronie głównej Twojego kursu, w ramce najświeższe wiadomości w prawym górnym narożniku ekranu.</p>

<P>Ustawienie tej funkcji na &quot;0 aktualności&quot; sprawi, że ramka najświeższe wiadomości w ogóle się nie pojawi.</p>';
$string['newuser'] = 'Nowy użytkownik';
$string['newusernewpasswordsubj'] = 'Nowe konto użytkownika';
$string['newusernewpasswordtext'] = 'Cześć {$a->firstname}

Nowe konto zostało stworzone dla Ciebie na \'{$a->sitename}\' i zostałeś wprowadzony z tymczasowym hasłem.
Twoje obecne dane do logowania są następujące:
Nazwa użytkownika: {$a->username}
Hasło: {$a->newpassword}
(należy zmienić hasło podczas pierwszego logowania)
Aby użyć \'{$a->sitename}\' zaloguj się na  {$a->link}

W większości programów pocztowych mail’owych, powinno to pojawić się jako niebieski link, który można kliknąć. Jeśli to nie zadziała, wówczas wytnij i wklej adres w linię adresu w górnej części okna Twojej przeglądarki Web.

Pozdrowienia od \'{$a->sitename}\'Administratora
{$a->signoff}';
$string['newusers'] = 'Nowi użytkownicy';
$string['newwindow'] = 'nowe okno';
$string['next'] = 'Dalej';
$string['nextsection'] = 'Następna sekcja';
$string['no'] = 'Nie';
$string['noblockstoaddhere'] = 'Nie ma bloków, które można dodać do tej strony.';
$string['nobody'] = 'Nikt';
$string['nochange'] = 'Bez zmian';
$string['nocomments'] = 'Brak komentarzy';
$string['nocourses'] = 'żadnego kursu';
$string['nocoursesfound'] = 'Nie znaleziono kursów zawierających słowa \'{$a}\'';
$string['nocoursesyet'] = 'Brak kursów w tej kategorii';
$string['nodstpresets'] = 'Administrator nie umożliwił stosowania czasu letniego (DST)';
$string['nofilesselected'] = 'Nie wybrano żadnych plików do odtworzenia';
$string['nofilesyet'] = 'Nie przesłano jeszcze żadnych plików w związku z tym kursem';
$string['nograde'] = 'Brak oceny';
$string['nohelpforactivityorresource'] = 'Obecnie nie ma jeszcze pomocy związanej z tym zasobem lub aktywnością';
$string['noimagesyet'] = 'Żadnych obrazów nie przesłano do twojego kursu';
$string['nologsfound'] = 'Nie znaleziono logów';
$string['nomatchingusers'] = 'Brak pasujących użytkowników  \'{$a}\'';
$string['nomorecourses'] = 'Nie znaleziono więcej pasujących kursów';
$string['nomoreidnumber'] = 'Nie użyto numeru id żeby unikać kolizji';
$string['none'] = 'Żaden';
$string['noneditingteacher'] = 'Nauczyciel bez praw edycji';
$string['noneditingteacherdescription'] = 'Nauczyciele bez praw edycji mogą uczyć w kursach i oceniać studentów, ale nie mogą wprowadzać zmian edycyjnych.';
$string['nonstandard'] = 'Niestandardowe';
$string['nopendingcourses'] = 'Brak kursów oczekujących na zatwierdzenie';
$string['nopotentialadmins'] = 'Brak potencjalnych administratorów';
$string['nopotentialcreators'] = 'Brak potencjalnych autorów kursów';
$string['nopotentialstudents'] = 'Brak potencjalnych studentów';
$string['nopotentialteachers'] = 'Brak potencjalnych prowadzących';
$string['norecentactivity'] = 'Brak ostatnich aktywności';
$string['noreplybouncemessage'] = 'Odpowiedziałeś na mail wysłany z adresu, który nie przyjmuje odpowiedzi. Jeżeli chcesz odpowiedzieć na wiadomość z forum, musisz to zrobić na forum {$a}.

Poniżej jest treść Twojego listu:';
$string['noreplybouncesubject'] = '{$a} - mail odrzucony';
$string['noreplyname'] = 'Nie odpowiadaj na ten mail';
$string['noresetrecord'] = 'Nie ma żadnego zapisanego żądania resetowania. Proszę zainicjować nowe żądanie resetowania hasła.';
$string['noresults'] = 'Brak wyników';
$string['normal'] = 'Zwykły';
$string['normalfilter'] = 'Normalny filtr';
$string['nosite'] = 'Nie znaleziono kursu strony głównej.';
$string['nostudentsfound'] = 'Nie znaleziono studenta {$a}';
$string['nostudentsingroup'] = 'Studenci nie są przypisani do grup';
$string['nostudentsyet'] = 'Na ten kurs nie zapisali się studenci';
$string['nosuchemail'] = 'Nie ma takiego adresu e-mail';
$string['notavailable'] = 'Niedostępne';
$string['noteachersyet'] = 'Brak nauczycieli kurs';
$string['notenrolled'] = '{$a} nie jest jeszcze zapisany na kurs';
$string['notenrolledprofile'] = 'Ten profil jest niedostępny, gdyż ten użytkownik nie jest zapisany do kursu.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Uwaga:</strong> Możliwość przesunięcia daty podczas przywracania tej kopii zapasowej została wyłączona, ponieważ nie posiadasz wymaganych uprawnień.';
$string['noteuserschangednonetocourse'] = 'Uwaga: Podczas odtwarzania danych użytkowników użytkownicy kursu muszą zostać odtworzeni. To ustawienie zostało zmienione dla Ciebie.';
$string['nothingnew'] = 'Brak zmian od ostatniego zalogowania';
$string['nothingtodisplay'] = 'Brak danych do wyświetlenia';
$string['notice'] = 'Powiadomienie';
$string['noticenewerbackup'] = 'Ta kopia zapasowa została stworzona przez Moodle {$a->backuprelease} ({$a->backupversion}) i jest nowsza niż obecnie zainstalowany Moodle {$a->serverrelease} ({$a->serverversion}). Odtworzenie tej kopii może być przyczyną różnych błędów, ponieważ nie ma gwarancji wstecznej kompatybilności kopii zapasowych.';
$string['notifications'] = 'Powiadomienia';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Użytkownik: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Możesz zobaczyć te logi na {$a}/course/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Oto lista nieudanych prób logowania do {$a} od ostatniego powiadomienia';
$string['notifyloginfailuressubject'] = '{$a} :: Powiadomienie o błędnych próbach logowania';
$string['notincluded'] = 'Nie uwzględniono';
$string['notingroup'] = 'Musisz należeć do grupy, aby przeglądać tą aktywność';
$string['notpublic'] = 'Nie publiczne!';
$string['nousersfound'] = 'Nie znaleziono użytkowników';
$string['nousersmatching'] = 'Nie znaleziono użytkowników pasujących do \'{$a}\'';
$string['nousersyet'] = 'Brak użytkowników (jak dotąd)';
$string['novalidcourses'] = 'Brak odpowiednich kursów do wyświetlenia';
$string['now'] = 'teraz';
$string['numattempts'] = '{$a} nieudanych prób logowania';
$string['numberofcourses'] = 'Liczba kursów';
$string['numberweeks'] = 'Liczba tygodni/tematów';
$string['numdays'] = '{$a} dni';
$string['numhours'] = '{$a} godz.';
$string['numletters'] = '{$a} listy';
$string['numminutes'] = '{$a} min.';
$string['nummonths'] = '{$a} miesiące';
$string['numseconds'] = '{$a} sek.';
$string['numviews'] = '{$a} wglądów';
$string['numweeks'] = '{$a} tygodni';
$string['numwords'] = '{$a} słów';
$string['numyears'] = '{$a} lat';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Bieżące hasło';
$string['olduserdirectory'] = 'To jest stary katalog użytkowników i nie jest już potrzebny. Możesz go usunąć. Pliki które zawiera będą skopiowane do nowego katalogu.';
$string['opentoguests'] = 'Dostęp gościa';
$string['optional'] = 'opcjonalne';
$string['options'] = 'opcje';
$string['order'] = 'Kolejność';
$string['originalpath'] = 'Oryginalna ścieżka';
$string['orphanedactivitiesinsectionno'] = 'Osierocone aktywności (sekcja {$a})';
$string['other'] = 'Inne';
$string['outline'] = 'Skrócona wersja';
$string['outlinereport'] = 'Streszczenie raportu';
$string['page'] = 'Strona';
$string['pagea'] = 'Strona {$a}';
$string['pageheaderconfigablock'] = 'Skonfiguruj blok %fullname%';
$string['pagepath'] = 'Ścieżka do strony';
$string['pageshouldredirect'] = 'Ta strona powinna się automatycznie przeładować. Jeśli nic się nie zmienia proszę użyć hiperłącza "Kontynuuj" umieszczonego poniżej.';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parentcoursenotfound'] = 'Nie znaleziono kursu!';
$string['parentfolder'] = 'Katalog nadrzędny';
$string['participants'] = 'Uczestnicy';
$string['participantslist'] = 'Lista uczestników';
$string['participationratio'] = 'Procent udziału';
$string['participationreport'] = 'Raport uczestnictwa';
$string['password'] = 'Hasło';
$string['passwordchanged'] = 'Hasło zostało zmienione';
$string['passwordconfirmchange'] = 'Potwierdź zmianę hasła';
$string['passwordextlink'] = 'Ten link służy do odzyskiwania straconego hasła. Klikając na link, wyjdziesz z Moodle.';
$string['passwordforgotten'] = 'Zapomniane hasło';
$string['passwordforgotteninstructions'] = 'Twoje dane charakterystyczne muszą być najpierw znalezione w bazie danych użytkowników. Wprowadź swoją nazwę użytkownika w Moodle  <strong>albo</strong> zarejestrowany adres e-mail w odpowiednie pole. Nie ma konieczności wprowadzania obu.';
$string['passwordforgotteninstructions2'] = 'Aby zresetować hasło, wprowadź poniżej swoją nazwę użytkownika lub adres e-mail. Jeżeli uda nam się znaleźć Twoje dane w bazie danych, zostanie wysłana wiadomość na Twój adres e-mail z instrukcją jak uzyskać ponownie dostęp.';
$string['passwordnohelp'] = 'Nie ma możliwości pomocy w celu odnalezienia Twojego zagubionego hasła. Proszę skontaktować się za swoim administratorem Moodle.';
$string['passwordrecovery'] = 'Tak, pomóż mi zalogować się';
$string['passwordsdiffer'] = 'Podane hasła różnią się';
$string['passwordsent'] = 'Hasło zostało wysłane';
$string['passwordsenttext'] = '<p>Twoje hasło zostało wysłane mailem na adres {$a->email}. </p><p> Nowe hasło zostało wygenerowane w sposób automatyczny, możesz je <a href="{$a->link}"> zmienić </a> na łatwiejsze do zapamiętania.';
$string['passwordset'] = 'Twoje hasło zostało zmienione.';
$string['path'] = 'Ścieżka';
$string['pathnotexists'] = 'Ścieżka nie istnieje';
$string['pathslasherror'] = 'Ścieżka nie może kończyć się slashem!';
$string['paymentinstant'] = 'Użyj poniższego przycisku, aby zapłacić i zapisać się na kurs w ciągu kilku minut!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> w ciągu</small>)';
$string['paymentrequired'] = 'Ten kurs wymaga opłaty';
$string['payments'] = 'Opłata';
$string['paymentsorry'] = 'Dziękujemy za wpłatę. Niestety nie została ona jeszcze potwierdzona i nie możesz jeszcze zapisać się na kurs "{$a->fullname}". Spróbuj ponownie za kilka minut. Jeśli problem będzie się powtarzał, skontaktuj się z {$a->teacher} lub administratorem.';
$string['paymentthanks'] = 'Dziękujemy za opłatę! Jesteś już zapisany na kurs:<br />"{$a}"';
$string['pendingrequests'] = 'W trakcie realizacji';
$string['periodending'] = 'Koniec okresu';
$string['perpage'] = 'Na stronę';
$string['perpagea'] = 'Na stronę: {$a}';
$string['personal'] = 'Osobisty';
$string['personalprofile'] = 'Profil osobisty';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Tel. komórkowy';
$string['phpinfo'] = 'Informacje o PHP';
$string['pictureof'] = 'Obraz {$a}';
$string['pictureofuser'] = 'Zdjęcie użytkownika';
$string['pleaseclose'] = 'Proszę zamknij teraz to okno';
$string['pleasesearchmore'] = 'Wyszukaj trochę więcej';
$string['pleaseusesearch'] = 'Proszę użyć wyszukiwarki';
$string['plugin'] = 'Wtyczka';
$string['plugincheck'] = 'Sprawdzanie wtyczek';
$string['plugindeletefiles'] = 'Wszystkie dane związane z wtyczką\'{$a->name}\' zostały usunięte z bazy danych. Aby zapobiec ponownej instalacji wtyczki, należy teraz usunąć z serwera ten folder: {$a->directory}';
$string['pluginsetup'] = 'Ustawianie tablic plugin\'ów';
$string['policyaccept'] = 'Rozumiem i zgadzam się';
$string['policyagree'] = 'Musisz zaakceptować te zasady, żeby używać strony. Czy zgadzasz się?';
$string['policyagreement'] = 'Zasady użytkowania serwisu';
$string['policyagreementclick'] = 'Kliknij tutaj, żeby poznać zasady użytkowania serwisu';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Otwórz w nowym oknie';
$string['popupwindowname'] = 'Okienko popup';
$string['post'] = 'Wpis';
$string['posts'] = 'Wpisy';
$string['potentialadmins'] = 'Potencjalni administratorzy';
$string['potentialcreators'] = 'Potencjalni autorzy kursów';
$string['potentialstudents'] = 'Potencjalni studenci';
$string['potentialteachers'] = 'Potencjalni prowadzący';
$string['preferences'] = 'Ustawienia';
$string['preferredlanguage'] = 'Preferowany język';
$string['preferredtheme'] = 'Preferowany wygląd strony';
$string['preprocessingbackupfile'] = 'Wstępne przetwarzanie pliku kopii zapasowej';
$string['prev'] = 'Poprzedni';
$string['preview'] = 'Podgląd';
$string['previewhtml'] = 'Podgląd formatu HTML';
$string['previeworchoose'] = 'Przejrzyj lub wybierz temat';
$string['previous'] = 'Poprzedni';
$string['previouslyselectedusers'] = 'Wybrani wcześniej użytkownicy nie pasują \'{$a}\'';
$string['previoussection'] = 'Poprzednia sekcja';
$string['primaryadminsetup'] = 'Ustawienia konta administratora';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Opis w profilu nie będzie pokazany dopóki ta osoba nie zapisze się do co najmniej jednego kursu.';
$string['publicprofile'] = 'Profil publiczny';
$string['publicsitefileswarning'] = 'Uwaga: Pliki zamieszczone w tym miejscu są dostępne dla wszystkich';
$string['publicsitefileswarning2'] = 'Ostrzeżenie: Pliki umieszczone tutaj mogą być dostępne dla każdego, kto zna (lub odgadnie) URL. Ze względów bezpieczeństwa zaleca się, aby wszelakie kopie zapasowe plików zostały usuwane natychmiast po ich przywróceniu.';
$string['publicsitefileswarning3'] = 'Ostrzeżenie: Pliki umieszczone tutaj mogą być dostępne dla każdego, kto zna (lub odgadnie) URL. <br />Ze względów bezpieczeństwa, pliki kopii zapasowej powinny być zapisywane tylko w bezpiecznym folderze backupdata.';
$string['publish'] = 'Opublikuj';
$string['question'] = 'Pytanie';
$string['questionsinthequestionbank'] = 'Pytania w banku pytań';
$string['readinginfofrombackup'] = 'Odczyt danych z kopii zapasowej';
$string['readme'] = 'README';
$string['recentactivity'] = 'Co się ostatnio działo?';
$string['recentactivityreport'] = 'Raport ostatniej aktywności';
$string['recipientslist'] = 'Lista odbiorców';
$string['recreatedcategory'] = 'Tworzenie na nowo kategorii {$a}';
$string['redirect'] = 'Przekierowanie';
$string['reducesections'] = 'Zredukuj liczbę sekcji';
$string['refresh'] = 'Odśwież';
$string['refreshingevents'] = 'Odświeżanie';
$string['registration'] = 'Rejestracja Moodle';
$string['registrationcontact'] = 'Kontakt publiczny';
$string['registrationcontactno'] = 'Nie chcę formularza kontaktowego w liście serwisu.';
$string['registrationcontactyes'] = 'Tak, chcę skorzystać z formularza do kontaktów z użytkownikami Moodle.';
$string['registrationemail'] = 'Powiadamianie e-mail';
$string['registrationinfo'] = '<p> Ta strona umożliwia rejestrację twojego serwisu na stronie moodle.org. Rejestracja jest bezpłatna. Główną zaletą rejestracji, jest to, że zostaniesz dodany do listy pocztowej zawierającej istotne zawiadomienia, np. alarmy ochrony czy nowe wersje Moodle. </p><p> Domyślnie twoje dane będą prywatne i nie zostaną udostępnione lub odsprzedane nikomu innemu. Jedyną przyczyną zbierania tych danych jest budowanie statystycznego obrazu populacji użytkowników Moodle.</p> <p> Jeśli chcesz, możesz zezwolić, by nazwa twojego serwisu, kraj oraz URL zostały dodane do ogólnodostępnej listy serwisów Moodle.</p><p>Wszystkie nowe rejestracje są sprawdzane ręcznie przed wprowadzeniem ich na listę. Później możesz uaktualnić swoją rejestrację (i wpis na liście), wysyłając ponownie ten formularz.</p>';
$string['registrationinfotitle'] = 'Informacje o rejestracji';
$string['registrationno'] = 'Nie, nie chcę otrzymywać maili';
$string['registrationsend'] = 'Prześlij informacje rejestracyjne do moodle.org';
$string['registrationyes'] = 'Tak, proszę mnie powiadamiać o istotnych wydarzeniach.';
$string['reject'] = 'Odrzuć';
$string['rejectdots'] = 'Odrzuć...';
$string['reload'] = 'Odśwież';
$string['remoteappuser'] = 'Zdalny użytkownik {$a}';
$string['remove'] = 'Usuń';
$string['removeadmin'] = 'Usuń administratora';
$string['removecreator'] = 'Usuń autora kursu';
$string['removestudent'] = 'Usuń studenta';
$string['removeteacher'] = 'Usuń prowadzącego';
$string['rename'] = 'Zmień nazwę';
$string['renamefileto'] = 'Zmień <b>{$a}</b> na';
$string['report'] = 'Raport';
$string['reports'] = 'Raporty';
$string['repositories'] = 'Repozytoria';
$string['requestcourse'] = 'Wniosek o kurs';
$string['requestedby'] = 'Zawnioskowane przez.';
$string['requestedcourses'] = 'Prośby o kursy';
$string['requestreason'] = 'Powód złożenia wniosku';
$string['required'] = 'Wymagane';
$string['requirespayment'] = 'Ten kurs wymaga opłaty';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Składnik';
$string['resetcourse'] = 'Resetuj kurs';
$string['resetinfo'] = 'Ta strona pozwala wyczyścić kurs z danych użytkowników z zachowaniem składowych kursu i innych ustawień. Uwaga - po wybraniu i zatwierdzeniu tej strony nie ma możliwości odzyskania danych użytkowników.';
$string['resetnotimplemented'] = 'Resetowanie nie zaimplementowane';
$string['resetrecordexpired'] = 'Ważność linku resetowania hasła, którego użyłeś ma więcej niż {$a} minut i przez to wygasł. Proszę zainicjować nowe resetowanie hasła.';
$string['resetstartdate'] = 'Resetuj datę początkową';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Zadanie';
$string['resettodefaults'] = 'Przywrócenie domyślnych ustawień';
$string['resortbyfullname'] = 'Przez pełną nazwę';
$string['resortbyidnumber'] = 'Według numeru ID';
$string['resortbyshortname'] = 'Przez krótką nazwę';
$string['resortcourses'] = 'Uporządkuj kursy';
$string['resortsubcategoriesbyidnumber'] = 'Ponowne przesortowanie podkategorii według numeru id';
$string['resortsubcategoriesbyname'] = 'Ponowne przesortowanie podkategorii według nazwy';
$string['resource'] = 'Zasób';
$string['resourcedisplayauto'] = 'Automatycznie';
$string['resourcedisplaydownload'] = 'Wymuś pobieranie';
$string['resourcedisplayembed'] = 'Osadzone';
$string['resourcedisplayframe'] = 'W ramce';
$string['resourcedisplaynew'] = 'Nowe okno';
$string['resourcedisplayopen'] = 'Otwórz';
$string['resourcedisplaypopup'] = 'W wyskakującym oknie';
$string['resources'] = 'Zasoby';
$string['resources_help'] = 'Zasoby umożliwiają zamieszczenie w kursie niemal dowolnych treści stron www.';
$string['restore'] = 'Odtwórz';
$string['restorecancelled'] = 'Anulowano odtwarzanie';
$string['restorecannotassignroles'] = 'Odtworzenie wymaga przypisania ról, a ty nie masz do tego uprawnień';
$string['restorecannotcreateorassignroles'] = 'Odtworzenie wymaga utworzenia lub przypisania ról, a ty nie masz do tego uprawnień.';
$string['restorecannotcreateuser'] = 'Procedura odtwarzania wymaga utworzenia użytkownika \'{$a}\' z pliku kopii zapasowej, a ty nie masz uprawnień aby to wykonać';
$string['restorecannotoverrideperms'] = 'Przywracanie nadpisze uprawnienia, a ty nie masz stosownych uprawnień do tego.';
$string['restorecoursenow'] = 'Odtwórz ten kurs teraz!';
$string['restoredaccount'] = 'Przywrócone konto';
$string['restoredaccountinfo'] = 'To konto zostało zaimportowane z innego serwera i hasło zostało utracone. Aby ustawić nowe hasło przez e-mail, kliknij napis "Kontynuuj"';
$string['restorefinished'] = 'Odtwarzanie kopii zapasowej zakończone sukcesem';
$string['restoreto'] = 'Odtwórz do ...';
$string['restoretositeadding'] = 'Ostrzeżenie: zamierzasz przywrócić główną stronę, dodając do niej dane!';
$string['restoretositedeleting'] = 'Ostrzeżenie: zamierzasz przywrócić główną stronę, usuwając z niej dane!';
$string['restoreuserconflict'] = 'Próba przywrócenia konta użytkownika \'{$a}\' z pliku kopii zapasowej spowoduje wystąpienie konfliktu';
$string['restoreuserinfofailed'] = 'Proces przywracania został zatrzymany, ponieważ nie masz uprawnień, aby przywrócić dane użytkownika.';
$string['restoreusersprecheck'] = 'Sprawdzanie danych użytkownika';
$string['restoreusersprecheckerror'] = 'Zostały wykryte problemy podczas sprawdzania danych użytkownika';
$string['restricted'] = 'Ograniczony';
$string['returningtosite'] = 'Powracasz na tę stronę WWW?';
$string['returntooriginaluser'] = 'Wróć do {$a}';
$string['revert'] = 'Przywróć';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Przypisanie ról';
$string['rolemappings'] = 'Mapowanie ról';
$string['rolerenaming'] = 'Zmiana nazwy ról';
$string['rolerenaming_help'] = 'To ustawienie pozwala zmienić wyświetlane nazwy ról w kursie. Zmieniona zostanie tylko wyświetlana nazwa - uprawnienia roli nie będą naruszone. Nowe nazwy ról pojawią się na wszystkich stronach w ramach kursu. Jeśli zmieniona będzie nazwa roli managera kursu, to nowa nazwa roli pojawi się także na liście kursów.';
$string['roles'] = 'Role';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Ilość ostatnich artykułów RSS';
$string['rsserror'] = 'Błąd odczytu danych RSS';
$string['rsserrorauth'] = 'Twój link RSS nie zawiera prawidłowego tokena uwierzytelniania.';
$string['rsserrorguest'] = 'Ten kanał używa praw gościa, aby pobrać dane, ale gość nie ma uprawnień do odczytu danych. Odwiedź oryginalną lokalizację źródła jako poprawny użytkownik i uzyskaj stamtąd nowy link RSS .';
$string['rsskeyshelp'] = 'Aby zapewnić bezpieczeństwo i prywatność, URL kanału RSS zawiera specjalny znacznik, który identyfikuje użytkownika, dla któego jest przeznaczony. Uniemożliwia to innym użytkownikom Moodle\'a dostęp do obszarów, do których nie powinni mieć dostępu przez kanały RSS. </p><p> Token ten jest tworzony automatycznie podczas pierwszego dostępu do obszaru Moodle, gdzie produkuje się kanał RSS. Jeśli uważasz, że Twój token RSS zostało w jakiś sposób upubliczniony, możesz uzyskać nowy, klikając link Resetuj. Należy pamiętać, że aktualnie używane URLe RSS staną się wtedy nieważne.';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['saveandnext'] = 'Zachowaj i pokaż następne';
$string['savechanges'] = 'Zapisz zmiany';
$string['savechangesanddisplay'] = 'Zapisz i wyświetl';
$string['savechangesandreturntocourse'] = 'Zapisz i wróć do kursu';
$string['savecomment'] = 'Zapisz komentarz';
$string['savedat'] = 'Zachowane w:';
$string['savepreferences'] = 'Zapisz ustawienia';
$string['saveto'] = 'Zapisz do';
$string['scale'] = 'Skala';
$string['scale_help'] = '<p>Prowadzący mogą tworzyć nowe, niestandardowe skale ocen, które mogą zostać następnie wykorzystane do wystawiania ocen w dowolnej składowej kursu.</p>

<p>Nazwa skali powinna być słowem lub zwrotem, który jasno określa skalę : będzie ona widoczna ma liście wyboru skali, a także na wrażliwych na kontekst przyciskach pomocy.</p>

<p>Sama skala jest określana za pomocą uporządkowanej liście wartości. Zacząć należy od najbardziej negatywnej, a skończyć na najbardziej pozytywnej wartości. Kolejne pozycje powinny być określane przecinkami. Przykładowo : </p>

<blockquote><i>
   Niedostateczny, Dopuszczający, Dostateczny, Dobry, Bardzo Dobry, Celujący
</i></blockquote>

<p>Skala powinna zawierać również dokładny opis znaczenia poszczególnych ocen, a także sposobu jej użycia. Opis ten będzie dostępny na stronach pomocy zarówno dla prowadzących jak i studentów.</p>

<p>Dodatkowo może istnieć kilka skal \'Standardowych\', określanych przez administratora. Będą one dostępne we wszystkich kursach w obrębie tego serwisu.</p>';
$string['scales'] = 'Skale';
$string['scalescustom'] = 'Niestandardowe skale';
$string['scalescustomcreate'] = 'Dodaj nową skalę';
$string['scalescustomno'] = 'Nie utworzono żadnych niestandardowych skali';
$string['scalesstandard'] = 'Skale standardowe';
$string['scalestandard'] = 'Skala standardowa';
$string['scalestandard_help'] = 'Standardowa skala jest dostępna na całej witrynie, dla wszystkich kursów.';
$string['scalestip'] = 'Aby stworzyć własne skale, użyj linku "Skale" w menu Administracja kursu.';
$string['scalestip2'] = 'Aby utworzyć własne skale, kliknij na link Oceny w menu Administracja kursem, a następnie wybierz opcję Edycja, Skale.';
$string['schedule'] = 'Harmonogram';
$string['screenshot'] = 'Zrzut ekranu';
$string['search'] = 'Wyszukaj';
$string['searchagain'] = 'Wyszukaj ponownie';
$string['searchbyemail'] = 'Wyszukaj po adresach e-mail';
$string['searchbyusername'] = 'Wyszukaj po nazwie użytkownika';
$string['searchcourses'] = 'Przeszukaj kursy';
$string['searchhelp'] = 'Możesz szukać kilku słów jednocześnie. : <br /> słowo : szukaj każdego miejsca, w którym to słowo występuje w tekście <br /> +słowo : tylko słowa dokładnie pasujące zostaną znalezione <br /> -słowo : nie pokazuj wyników zawierających to słowo';
$string['search_help'] = 'Aby wyszukać jedno lub więcej słów w tekście, po prostu wpisz je oddzielone spacjami. Liczą się wszystkie słowa dłuższe niż dwa znaki.

Naciśnij przycisk przeszukiwania bez wypełniania pola wyszukiwania, aby przejść do formularza wyszukiwania zaawansowanego.';
$string['searchoptions'] = 'Opcje wyszukiwania';
$string['searchresults'] = 'Wyniki wyszukiwania';
$string['sec'] = 'sek';
$string['seconds'] = 'sekund';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dni';
$string['secondstotime518400'] = '6 dni';
$string['secondstotime604800'] = '1 tydzień';
$string['secondstotime86400'] = '1 dzień';
$string['secretalreadyused'] = 'Link do potwierdzenia zmiany hasła został już użyty. Hasło nie zostało zmienione.';
$string['secs'] = 'sek.';
$string['section'] = 'Sekcja';
$string['sectionname'] = 'Nazwa sekcji';
$string['sections'] = 'Sekcje';
$string['sectionusedefaultname'] = 'Użyj domyślnej nazwy sekcji';
$string['seealsostats'] = 'Patrz również: statystyki';
$string['selctauser'] = 'Wybierz użytkownika';
$string['select'] = 'Zaznacz';
$string['selectacategory'] = 'Proszę wybrać kategorię';
$string['selectacountry'] = 'Wybierz kraj';
$string['selectacourse'] = 'Wybierz kurs';
$string['selectacoursesite'] = 'Wybierz kurs lub stronę';
$string['selectagroup'] = 'Wybierz grupę';
$string['selectall'] = 'Wybierz wszystko';
$string['selectamodule'] = 'Proszę wybrać moduły aktywności';
$string['selectanaction'] = 'Wybierz akcję';
$string['selectanoptions'] = 'Wybierz opcję';
$string['selectaregion'] = 'Wybierz obszar';
$string['selectcategorysort'] = 'Które kategorie chcesz posortować?';
$string['selectcategorysortby'] = 'Wybierz, jak chcesz posortować kategorie';
$string['selectcoursesortby'] = 'Wybierz, jak chcesz posortować kursy';
$string['selectdefault'] = 'Wybierz domyślne';
$string['selectedcategories'] = 'Wybrane kategorie';
$string['selectedfile'] = 'Wybrany plik';
$string['selectednowmove'] = '{$a} plików zaznaczonych w celu przeniesienia. Przejdź teraz do miejsca docelowego i wybierz \'Przenieś pliki tutaj\'';
$string['selectfiles'] = 'Wybierz pliki';
$string['selectmoduletoviewhelp'] = 'Wybierz moduł, aby wyświetlić pomoc na jego temat.';
$string['selectnos'] = 'Wybierz wszystkie "nie"';
$string['selectperiod'] = 'Wybierz okres';
$string['senddetails'] = 'Wyślij mi moje dane e-mail\'em';
$string['separate'] = 'Osobne';
$string['separateandconnected'] = 'Odrębne i powiązane sposoby poznania';
$string['separateandconnectedinfo'] = 'Skala opiera się na teorii oddzielonego i połączonego poznania. Ta teoria opisuje dwa różne sposoby, które możemy ocenić i nauczyć się o tym co widzimy i słyszymy.<ul><li><strong>Osobni znawcy</strong> pozostają jak najbardziej obiektywni, bez włączania uczuć i emocji. W dyskusji z innymi ludźmi, lubią bronić swoich racji używając logiki do znajdywania luk w idei przeciwnika.</li><li><strong>Podłączeni znawcy</strong> są bardzo wrażliwi na innych ludzi. Mają rozwiniętą empatię i tendencję do słuchania i zadawania pytań, dopóki nie poczują, że mogą być połączeni i "rozumieją sprawy z ich punktu widzenia". Uczą się poprzez próbę wymiany doświadczeń, które doprowadziły do tej wiedzy, którą znajdują u innych ludzi.</li></ul>';
$string['servererror'] = 'Wystąpił błąd podczas komunikacji z serwerem';
$string['serverlocaltime'] = 'Lokalny czas serwera';
$string['setcategorytheme'] = 'Wybierz temat graficzny dla kategorii';
$string['setpassword'] = 'Ustaw hasło';
$string['setpasswordinstructions'] = 'Proszę poniżej wprowadzić i powtórzyć swoje nowe hasło, wtedy należy kliknąć "Ustaw hasło". <br/> Twoje nowe hasło zostanie zapisane i będziesz się mógł zalogować.';
$string['settings'] = 'Ustawienia';
$string['shortname'] = 'Skrócona nazwa';
$string['shortnamecollisionwarning'] = 'Ten skrót jest już używany w kursie i należy go zmienić.';
$string['shortnamecourse'] = 'Krótka nazwa kursu';
$string['shortnamecourse_help'] = '<P ALIGN=CENTER><B>Skrócona nazwa kursu</B></P>

<P>Wiele instytucji stosuje skrócone nazwy kursów, np. BP102 lub COMMS. Nawet jeżeli nie wprowadziłeś dotychczas skróconej nazwy swojego kursu, zrób to tutaj. Nazwa skrócona będzie wykorzystywana w kilku miejscach, w których pełna nazwa nie byłaby odpowiednia (np. w temacie wiadomości e-mail).</P>';
$string['shortnametaken'] = 'Nazwa skrócona jest już wykorzystana przez inny kurs ({$a})';
$string['shortnameuser'] = 'Krótka nazwa użytkownika';
$string['shortsitename'] = 'Skrócona nazwa serwisu';
$string['show'] = 'Pokaż';
$string['showactions'] = 'Pokaż aktywności';
$string['showadvancedsettings'] = 'Pokaż ustawienia zaawansowane';
$string['showall'] = 'Pokaż wszystkie {$a}';
$string['showallcourses'] = 'Pokaż wszystkie kursy';
$string['showallusers'] = 'Pokaż wszystkich użytkowników';
$string['showblockcourse'] = 'Pokaż listę kursów zawierających blok';
$string['showcategory'] = 'Pokaż {$a}';
$string['showcomments'] = 'Pokaż/ukryj komentarze';
$string['showcommentsnonjs'] = 'Pokaż komentarze';
$string['showdescription'] = 'Wyświetl opis na strone kursu';
$string['showdescription_help'] = 'Jeśli opcja jest włączona, wprowadzenie / opis będzie wyświetlany na stronie kursu tuż poniżej linku z aktywnością / zasobami.';
$string['showgrades'] = 'Pokaż dziennik ocen studentom';
$string['showgrades_help'] = '<P>Wiele składowych kursów umożliwia wystawianie studentom ocen.</p>

<p>Domyślnie wszystkie oceny wystawione na danym kursie są widoczne na stronie \'oceny\' dostępnej z poziomu głównej strony kursu.</p>

<p>Jeśli prowadzący nie chce używać ocen w swoim kursie, lub nie chce ujawniać ich studentom, to istnieje możliwość wyłączenia wyświetlania ocen w Ustawieniach Kursu. Nie uniemożliwia to wystawiania ocen za poszczególne składowe, a jedynie wyłącza opcję pokazywania ocen studentom.</p>';
$string['showingacourses'] = 'Pokazywanie wszystkich {$a} kursów';
$string['showingxofycourses'] = 'Pokazywanie kursów {$a->start} do {$a->end} z {$a->total} kursów';
$string['showlistofcourses'] = 'Pokaż listę kursów';
$string['showmodulecourse'] = 'Pokaż listę kursów zawierających składową';
$string['showonly'] = 'Wyświetl tylko';
$string['showperpage'] = 'Pokaż {$a} na stronę';
$string['showrecent'] = 'Pokaż ostatnie wydarzenia';
$string['showreports'] = 'Pokaż raporty aktywności';
$string['showreports_help'] = '<P>Raporty aktywności są dostępne dla każdego z partycypujących w kursie.
 Raporty te zawierają dzienniki dostępu użytkownika a także informacje dotyczace aktywności użytkownika.</p>

<p>Nauczyciele zawsze mają dostęp do tych raportów, używąc przycisku znajdującego się na stronie na której
znajduje się profil danego studenta.<p>

<p>Z kolei dostęp studentów do tych raportów kontrolowany jest przez nauczycieli. W przypadku niektórych kursów
 umożliwienie takiego dostępu może okazać się bardzo pomocne, ponieważ pokaże to  studentowi jego wysiłek i wkład w pracę online.
Jednakże w przypadku niektórych kursów studenci mogą mieć ten dostęp ograniczony.
 Ponadto, udostępnienie tych raportów studentom spowoduje dodatkowe obciążenie serwera co w przypadku licznych klas czy dłuższych
 kursów może skłonić administratora do wyłączenia tej opcji.</p>';
$string['showsettings'] = 'Pokaż ustawienia';
$string['showtheselogs'] = 'Pokaż te logi';
$string['showthishelpinlanguage'] = 'Pokaż tą pomoc w języku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od ostatniego logowania';
$string['site'] = 'Serwis';
$string['sitedefault'] = 'Wartość domyślna obowiązująca na witrynie';
$string['siteerrors'] = 'Błędy w serwisie';
$string['sitefiles'] = 'Pliki serwisu';
$string['sitefilesused'] = 'Pliki serwisu, które są użyte w tym kursie';
$string['sitehome'] = 'Strona główna';
$string['sitelegacyfiles'] = 'Stare pliki strony';
$string['sitelogs'] = 'Logi serwisu';
$string['sitemessage'] = 'Powiadom użytkowników';
$string['sitenews'] = 'Aktualności';
$string['sitepages'] = 'Strony';
$string['sitepartlist'] = 'Nie masz wymaganych uprawnień, aby oglądać listę użytkowników';
$string['sitepartlist0'] = 'Musisz być nauczycielem na poziomie serwisu, aby móc oglądać listy użytkowników serwisu';
$string['sitepartlist1'] = 'Musisz być nauczycielem, aby móc oglądać listy użytkowników serwisu';
$string['sites'] = 'Serwisy';
$string['sitesection'] = 'Dodaj sekcję tematyczną';
$string['sitesettings'] = 'Ustawienia serwisu';
$string['siteteachers'] = 'Nauczyciele w serwisie';
$string['size'] = 'Rozmiar';
$string['sizeb'] = 'bajtów';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Pominięto';
$string['skiptocategorylisting'] = 'Przejdź do listy kategorii';
$string['skiptocoursedetails'] = 'Przejdź do szczegółowych informacji o kursie';
$string['skiptocourselisting'] = 'Przejdź do listy kursów';
$string['skypeid'] = 'ID Skype';
$string['socialheadline'] = 'Forum towarzyskie - ostatnie tematy';
$string['someallowguest'] = 'Niektóre kursy dostępne są dla użytkowników zalogowanych jako goście.';
$string['someerrorswerefound'] = 'Część informacji została pominięta lub jest niepoprawna. Poniżej znajdziesz szczegóły.';
$string['sort'] = 'Sortuj';
$string['sortby'] = 'Posortuj według';
$string['sortbyx'] = 'Sortuj {$a} rosnąco';
$string['sortbyxreverse'] = 'Sortuj {$a} malejąco';
$string['sortcategoriesbyidnumber'] = 'Sortuj kategorie wg. numeru ID';
$string['sortcategoriesbyname'] = 'Sortuj kategorie wg. nazwy';
$string['sortcoursesbyfullname'] = 'Sortuj kursy wg. pełnej nazwy';
$string['sortcoursesbyidnumber'] = 'Sortuj kursy wg. numeru ID';
$string['sortcoursesbyshortname'] = 'Sortuj kursy wg. nazwy skróconej';
$string['sorting'] = 'Sortowanie';
$string['sourcerole'] = 'Rola pierwotna';
$string['specifyname'] = 'Musisz podać imię.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = Zatwierdzenie kursu oczekującego)';
$string['startdate'] = 'Data rozpoczęcia kursu';
$string['startdate_help'] = '<P ALIGN=CENTER><B>Data rozpoczęcia kursu</B></P>

<P>W tym miejscu określasz termin rozpoczęcia kursu (w swojej strefie czasowej).</p>

<P>Jeżeli stosujesz tygodniowy format kursu, ustawienie daty rozpoczęcia będzie miało wpływ na sposób wyświetlania poszczególnych tygodni. Pierwszy tydzień rozpocznie się w dniu określonym tutaj.</p>

<P>Ustawienie to nie będzie miało wpływu na kursy stosujące format towarzyski lub tematyczny.</p>

<P>Wpłynie ono jednak na wyświetlanie logów, które przyjmują podaną tu datę jako najwcześniejszą możliwą do wyświetlenia.</p>

<P>Zasadniczo, jeżeli Twój kurs ma faktyczną datę rozpoczęcia, warto ją tutaj wprowadzić bez względu na to jaki format kursu stosujesz.</p>';
$string['startingfrom'] = 'Rozpoczynający się od';
$string['startsignup'] = 'Zacznij teraz od utworzenia nowego konta!';
$string['state'] = 'Stan/prowincja';
$string['statistics'] = 'Statystyki';
$string['statisticsgraph'] = 'Graf statystyk';
$string['stats'] = 'Statystyki';
$string['statslogins'] = 'Logowania';
$string['statsmodedetailed'] = 'Widok szczegółowy (użytkownika)';
$string['statsmodegeneral'] = 'Widok ogólny';
$string['statsnodata'] = 'Brak możliwości stworzenia takiej kombinacji kursu i przedziału czasowego.';
$string['statsnodatauser'] = 'Brak możliwości stworzenia takiej kombinacji kursu, użytkownika i przedziału czasowego.';
$string['statsoff'] = 'Statystyki nie są obecnie aktywne';
$string['statsreads'] = 'Otwarcia';
$string['statsreport1'] = 'Logowania';
$string['statsreport10'] = 'Aktywność użytkownika';
$string['statsreport11'] = 'Najbardziej aktywne kursy';
$string['statsreport12'] = 'Najbardziej aktywne kursy (ważone)';
$string['statsreport13'] = 'Najbardziej uczęszczane kursy (zapisy)';
$string['statsreport14'] = 'Najbardziej uczęszczane kursy (wyświetlenia/wpisy)';
$string['statsreport2'] = 'Wyświetlenia (wszystkie role)';
$string['statsreport3'] = 'Wpisy (wszystkie role)';
$string['statsreport4'] = 'Wszystkie aktywności (wszystkie role)';
$string['statsreport5'] = 'Wszystkie aktywności (wyświetlenia i posty)';
$string['statsreport7'] = 'Aktywności użytkownika (wyświetlenia i posty)';
$string['statsreport8'] = 'Aktywności wszystkich użytkowników';
$string['statsreport9'] = 'Logowania (strona kursu)';
$string['statsreportactivity'] = 'Wszystkie aktywności (nauczyciele i studenci)';
$string['statsreportactivitybyrole'] = 'Wszystkie aktywności (otwarcia i wpisy)';
$string['statsreportforuser'] = 'dla';
$string['statsreportlogins'] = 'Logowania';
$string['statsreportreads'] = 'Wyświetlenia (nauczyciele i studenci)';
$string['statsreporttype'] = 'Typ raportu';
$string['statsreportwrites'] = 'Wpisy (nauczycieli i studentów)';
$string['statsstudentactivity'] = 'Aktywności studenta';
$string['statsstudentreads'] = 'Wyświetlenia studenta';
$string['statsstudentwrites'] = 'Wpisy studenta';
$string['statsteacheractivity'] = 'Aktywności nauczyciela';
$string['statsteacherreads'] = 'Wyświetlenia nauczyciela';
$string['statsteacherwrites'] = 'Wpisy nauczyciela';
$string['statstimeperiod'] = 'Okres czasu - ostatni:';
$string['statsuniquelogins'] = 'Unique logins';
$string['statsuseractivity'] = 'Wszystkie aktywności';
$string['statsuserlogins'] = 'Logowania';
$string['statsuserreads'] = 'Wyświetlenia';
$string['statsuserwrites'] = 'Wpisy';
$string['statswrites'] = 'Wpisy';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Następujące łańcuchy znaków nie są zdefiniowane w {$a}';
$string['studentnotallowed'] = 'Nie możesz wejść do kursu jako \'{$a}\'';
$string['students'] = 'Studenci';
$string['studentsandteachers'] = 'Studenci i nauczyciele';
$string['subcategories'] = 'Podkategorie';
$string['subcategory'] = 'Podkategorię';
$string['subcategoryof'] = 'Podkategoria {$a}';
$string['submit'] = 'Prześlij';
$string['success'] = 'Gotowe';
$string['summary'] = 'Streszczenie';
$string['summary_help'] = '<p align=center><b>Streszczenia tematu/tygodnia</b></p>

<p>Streszczenia mogą być krótkimi tekstami mającymi przygotować studentów do zajęć prowadzonych w ramach danego tematu (lub tygodnia)</p>

<p>Streszczenia powinny być stosunkowo krótkie, by nie zwiększać niepotrzebnie rozmiaru strony głównej kursu</p>

<p> Jeśli chcesz na wstępie przekazać więcej informacji, rozważ dodanie zasobu opisującego dany temat. Przykładowo pierwszą składową kursu może być strona zatytułowana <b>Na temat tego tygodnia ... </b>
</p>';
$string['summaryof'] = 'Streszczenie {$a}';
$string['supplyinfo'] = 'Proszę wpisać kilka informacji o sobie';
$string['suspended'] = 'Zawieszony';
$string['suspendedusers'] = 'Zawieszeni użytkownicy';
$string['switchdevicedefault'] = 'Przełącz na standardowy schemat graficzny';
$string['switchdevicerecommended'] = 'Przełącz na zalecany dla twojego urządzenia schemat graficzny';
$string['switchrolereturn'] = 'Powróć do mojej standardowej roli';
$string['switchroleto'] = 'Zmień rolę na...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Ten tag już istnieje';
$string['tagmanagement'] = 'Dodaj/usuń tag ...';
$string['tags'] = 'Tagi';
$string['targetrole'] = 'Rola docelowa';
$string['teacheronly'] = 'wyłącznie dla {$a}';
$string['teacherroles'] = '{$a} tytułu';
$string['teachers'] = 'Prowadzący';
$string['textediting'] = 'Edytor tekstu';
$string['texteditor'] = 'Użyj standardowych formularzy WWW';
$string['textformat'] = 'Zwykły tekst';
$string['thanks'] = 'Dziękuję';
$string['theme'] = 'Temat';
$string['themes'] = 'Tematy';
$string['themesaved'] = 'Nowy temat został zapisany';
$string['therearecourses'] = 'Istnieje {$a} kursów';
$string['thereareno'] = 'Nie ma {$a} w tym kursie';
$string['thiscategory'] = 'W tej kategorii';
$string['thiscategorycontains'] = 'Ta kategoria zawiera';
$string['time'] = 'Czas';
$string['timezone'] = 'Strefa czasowa';
$string['to'] = 'Do';
$string['tocontent'] = 'Do pozycji "{$a}"';
$string['tocreatenewaccount'] = 'Pomiń tworzenie nowego konta';
$string['today'] = 'Dzisiaj';
$string['todaylogs'] = 'Dzisiejsze logi';
$string['toeveryone'] = 'Wszyscy';
$string['toomanybounces'] = 'Ten adres e-mail został odrzucony zbyt wiele razy.<b> Musisz </B> to zmienić żeby kontynuować.';
$string['toomanytoshow'] = 'Zbyt wielu użytkowników do pokazania';
$string['toomanyusersmatchsearch'] = 'Zbyt wielu użytkowników ({$a->count}) pasuje \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Zbyt wielu użytkowników ({$a})do wyświetlenia';
$string['toonly'] = 'tylko dla {$a}';
$string['top'] = 'Góra';
$string['topic'] = 'Temat';
$string['topichide'] = 'Ukryj ten temat przed {$a}';
$string['topicoutline'] = 'Tematyka';
$string['topicshow'] = 'Pokaż ten temat {$a}';
$string['toplevelcategory'] = 'Kategoria poziomu nadrzędnego';
$string['total'] = 'Razem';
$string['totopofsection'] = 'Na górę sekcji "{$a}"';
$string['trackforums'] = 'Obserwuj forum';
$string['trackforumsno'] = 'Nie: Nie obserwuj forum';
$string['trackforumsyes'] = 'Tak: Podświetl nowe wypowiedzi do mnie';
$string['trysearching'] = 'Poszukaj jeszcze raz.';
$string['turneditingoff'] = 'Wyłącz tryb edycji';
$string['turneditingon'] = 'Włącz tryb edycji';
$string['undecided'] = 'Nie zdecydowano';
$string['unfinished'] = 'Nie ukończono';
$string['unknowncategory'] = 'Nieznana kategoria';
$string['unknownerror'] = 'Nieznany błąd';
$string['unlimited'] = 'Nieograniczone';
$string['unpacking'] = 'Rozpakowywanie {$a}';
$string['unsafepassword'] = 'Hasło nie jest bezpieczne - wybierz inne';
$string['untilcomplete'] = 'Aż będzie kompletne';
$string['unusedaccounts'] = 'Konta nie używane przez ponad {$a} dni są automatycznie wypisywane z kursu';
$string['unzip'] = 'Rozpakuj';
$string['unzippingbackup'] = 'Rozpakowywanie kopii zapasowej';
$string['up'] = 'Do góry';
$string['update'] = 'Dokonaj zmian';
$string['updated'] = 'Zmieniono {$a}';
$string['updatemymoodleoff'] = 'Tryb normalny';
$string['updatemymoodleon'] = 'Edytuj tę stronę';
$string['updatemyprofile'] = 'Zmień profil';
$string['updatesevery'] = 'Zapisywanie zmian co {$a} sekund';
$string['updatethis'] = 'Zmień {$a}';
$string['updatethiscourse'] = 'Dokonaj zmian w tym kursie';
$string['updatinga'] = 'Zapisywanie zmian w {$a}';
$string['updatingain'] = 'Zmień {$a->what} w {$a->in}';
$string['upload'] = 'Prześlij';
$string['uploadafile'] = 'Prześlij plik';
$string['uploadcantwrite'] = 'Nie udało się zapisać plik na dysku';
$string['uploadedfile'] = 'Przesyłanie pliku zakończone';
$string['uploadedfileto'] = 'Przesłano {$a->file} do {$a->directory}';
$string['uploadedfiletoobig'] = 'Plik jest za duży (maksymalny rozmiar jest {$a} bajtów)';
$string['uploadextension'] = 'Przesyłanie plików przerwane z powodu rozszerzenia';
$string['uploadfailednotrecovering'] = 'Plik nie został przesłany, ponieważ wystąpił problem z plikiem {$a->name}. <br/> Tutaj jest zapis w logu odnośnie tego problemu:<br/>{$a->problem}';
$string['uploadfilelog'] = 'Prześlij log dla pliku {$a}';
$string['uploadformlimit'] = 'Przesłany plik przewyższa maksymalny rozmiar';
$string['uploadlabel'] = 'Tytuł:';
$string['uploadlimitwithsize'] = '{$a->contextname} limit wysyłania ({$a->displaysize})';
$string['uploadnewfile'] = 'Prześlij nowy plik';
$string['uploadnofilefound'] = 'Nie znaleziono żadnego pliku. Czy na pewno zaznaczyłeś plik do przesłania?';
$string['uploadnotallowed'] = 'Przesyłanie plików jest zakazane';
$string['uploadnotempdir'] = 'Na serwerze brak katalogu tymczasowego do przesyłania plików';
$string['uploadoldfilesdeleted'] = 'Stare pliki zostały usunięte';
$string['uploadpartialfile'] = 'Przesłano tylko część pliku';
$string['uploadproblem'] = 'Pojawił się nieznany błąd podczas przesyłania pliku \'{$a}\' (być może plik był za duży)';
$string['uploadrenamedchars'] = 'Zmieniono nazwę pliku z {$a->oldname} na {$a->newname} ponieważ użyto niedozwolonych znaków';
$string['uploadrenamedcollision'] = 'Zmieniono nazwę pliku z {$a->oldname} na {$a->newname}, ponieważ był konflikt nazw.';
$string['uploadserverlimit'] = 'Plik ma większy rozmiar niż dopuszczalny maksymalny rozmiar';
$string['uploadthisfile'] = 'Prześlij ten plik';
$string['url'] = 'URL';
$string['used'] = 'Użyte';
$string['usedinnplaces'] = 'Użyte w {$a} miejscach';
$string['usemessageform'] = 'lub użyj formularza w celu wysłania wiadomości do zaznaczonych uczestników';
$string['user'] = 'Użytkownik';
$string['userconfirmed'] = '{$a} został potwierdzony';
$string['usercurrentsettings'] = 'Ustawienia mojego profilu';
$string['userdata'] = 'Dane użytkownika';
$string['userdeleted'] = 'To konto użytkownika zostało usunięte';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'To pole umożliwia wprowadzanie tekstu o sobie, który następnie zostanie umieszczony na stronie Twojego profilu, aby inni mogli go zobaczyć.';
$string['userdetails'] = 'Szczegóły użytkownika';
$string['userfiles'] = 'Pliki użytkowników';
$string['userlist'] = 'Lista użytkowników';
$string['username'] = 'Nazwa użytkownika';
$string['usernameemailmatch'] = 'Nazwa użytkownika i adres e-mail nie odnoszą się do tego samego użytkownika.';
$string['usernameexists'] = 'Ta nazwa użytkownika już istnieje. Wybierz inną.';
$string['usernamelowercase'] = 'Dopuszczalne tylko małe litery';
$string['usernamenotfound'] = 'Nazwa użytkownika nie została odnaleziona w bazie danych';
$string['usernameoremail'] = 'Wpisz nazwę użytkownika lub adres e-mail';
$string['usernotconfirmed'] = '{$a} nie został potwierdzony';
$string['userpic'] = 'Zdjęcie użytkownika';
$string['users'] = 'Użytkownicy';
$string['userselectorautoselectunique'] = 'Jeżeli tylko jeden użytkownik odpowiada kryteriom wyszukiwania, wybierz go automatycznie';
$string['userselectorpreserveselected'] = 'Zachowaj wybranych użytkowników, nawet jeśli nie pasują już do kryteriów wyszukiwania';
$string['userselectorsearchanywhere'] = 'Dopasuj szukany tekst gdziekolwiek w nazwie użytkownika';
$string['usersnew'] = 'Nowi użytkownicy';
$string['usersnoaccesssince'] = 'Nieaktywni przez więcej niż';
$string['userswithfiles'] = 'Użytkownicy z plikami';
$string['useruploadtype'] = 'Użytkownik załądował typ: ($a}';
$string['userviewingsettings'] = 'Ustawienia profilu dla {$a}';
$string['userzones'] = 'Strefy użytkowników';
$string['usetheme'] = 'Użyj ten temat';
$string['usingexistingcourse'] = 'Korzystanie z istniejącego kursu';
$string['valuealreadyused'] = 'Ta wartość jest już w użyciu.';
$string['version'] = 'Wersja';
$string['view'] = 'Wejście';
$string['viewallcourses'] = 'Zobacz wszystkie kursy';
$string['viewallcoursescategories'] = 'Zobacz wszystkie kursy i kategorie';
$string['viewallsubcategories'] = 'Zobacz wszystkie podkategorie';
$string['viewfileinpopup'] = 'Zobacz plik w wyskakującym oknie';
$string['viewing'] = 'Wyświetlanie:';
$string['viewmore'] = 'Zobacz więcej';
$string['viewprofile'] = 'Zobacz profil';
$string['views'] = 'Wejścia';
$string['viewsolution'] = 'zobacz rozwiązanie';
$string['virusfound'] = 'Uwaga!! Clam AV znalazł wirusa w przesyłanym pliku przez użytkownika {$a->user} dla kursu {$a->course}. Tutaj jest informacja od programu antywirusowego:';
$string['virusfoundlater'] = 'Plik przesyłany na {$a->date} o nazwie {$a->filename} dla kursu {$a->course} zawiera wirusa. Tu jest opis tego, co się stało z Twoim plikiem:

{$a->action}.

Jeżeli to jest zadanie do przesłania, powinieneś przesłać jeszcze raz, aby prowadzący mógł zobaczyć.';
$string['virusfoundlateradmin'] = 'Plik przesyłany na {$a->date} o nazwie {$a->filename} dla kursu {$a->course} zawiera wirusa. Tu jest opis tego, co się stało z Twoim plikiem:

{$a->action}.

Użytkownik także został powiadomiony.';
$string['virusfoundlateradminnolog'] = 'Przesyłany plik o nazwie {$a->filename} zawiera wirusa. Moodle nie był w stanie przesłać pliku z powrotem do użytkownika.

Tu jest opis tego, co się stało z plikiem:

{$a->action}.';
$string['virusfoundsubject'] = '{$a}: Znaleziono wirusa';
$string['virusfounduser'] = 'Przesyłany plik {$a->filename} został przeskanowany przez program antywirusowy, który znalazł w nim wirusa. Plik nie został przesłany.';
$string['virusplaceholder'] = 'Plik który był przesyłany zawiera wirusa i został przesunięty lub usunięty. Użytkownik został powiadomiony.';
$string['visible'] = 'Widoczny';
$string['visible_help'] = 'Ta opcja określa, czy kurs będzie widoczny na liście kursów. Poza nauczycielami i administratorami, użytkownicy nie są uprawnieni do wejścia na kurs';
$string['visibletostudents'] = 'Widoczny dla {$a}';
$string['warning'] = 'Ostrzeżenie';
$string['warningdeleteresource'] = 'Uwaga: {$a} jest wskazywany w zasobie. Czy chcesz uaktualnić ten zasób?';
$string['webpage'] = 'Strona WWW';
$string['week'] = 'Tydzień';
$string['weekhide'] = 'Ukryj ten tydzień przed {$a}';
$string['weeklyoutline'] = 'Plan tygodniowy';
$string['weeks'] = 'tygodnie';
$string['weekshow'] = 'Pokaż ten tydzień {$a}';
$string['welcometocourse'] = 'Witaj w {$a}';
$string['welcometocoursetext'] = 'Witaj w kursie {$a->coursename}!

Jedną z pierwszych rzeczy, którą możesz zrobić, jest zmodyfikowanie swojego profilu, aby inni mogli dowiedzieć się więcej o Tobie:

{$a->profileurl}';
$string['whatforlink'] = 'Co chcesz zrobić z linkiem?';
$string['whatforpage'] = 'Co chcesz zrobić z tekstem?';
$string['whattocallzip'] = 'Jak chcesz nazwać ten plik zip?';
$string['whattodo'] = 'Co zrobić';
$string['windowclosing'] = 'To okno powinno zamknąć się automatycznie. Jeśli się nie zamknęło, zamknij je teraz.';
$string['withchosenfiles'] = 'Z wybranymi plikami';
$string['withdisablednote'] = '{$a} (wyłączone)';
$string['withoutuserdata'] = 'bez danych o użytkowniku';
$string['withselectedusers'] = 'Z zaznaczonymi użytkownikami';
$string['withselectedusers_help'] = '* Wyślij wiadomość - wysyła wiadomość do jednego lub więcej uczestników
* Dodaj nową notatkę - dodaje notatkę do wybranego uczestnika
* Dodaj wspólną notatkę - dodaje tą samą notatkę do więcej niż jednego uczestnika';
$string['withuserdata'] = 'z danymi o użytkownikach';
$string['wordforstudent'] = 'Twój odpowiednik słowa Student';
$string['wordforstudenteg'] = 'np. Student, Uczestnik itd.';
$string['wordforstudents'] = 'Twój odpowiednik słowa Studenci';
$string['wordforstudentseg'] = 'np. Studenci, Uczestnicy itd.';
$string['wordforteacher'] = 'Twój odpowiednik słowa Prowadzący';
$string['wordforteachereg'] = 'np. Prowadzący, Nauczyciel, Trener itp.';
$string['wordforteachers'] = 'Twój odpowiednik słowa Prowadzący (l. mnoga)';
$string['wordforteacherseg'] = 'np. Prowadzący, Nauczyciele itp.';
$string['writingblogsinfo'] = 'Zapis informacji o blogach';
$string['writingcategoriesandquestions'] = 'Zapis kategorii i pytań';
$string['writingcoursedata'] = 'Zapis danych kursu';
$string['writingeventsinfo'] = 'Zapis informacji o zdarzeniach';
$string['writinggeneralinfo'] = 'Zapis informacji ogólnych';
$string['writinggradebookinfo'] = 'Zapis informacji w menu \'Oceny\'';
$string['writinggroupingsgroupsinfo'] = 'Zapis informacji o grupach nadrzędnych';
$string['writinggroupingsinfo'] = 'Zapis informacji o grupach nadrzędnych';
$string['writinggroupsinfo'] = 'Zapis informacji o grupach';
$string['writingheader'] = 'Zapis nagłówka';
$string['writingloginfo'] = 'Zapis informacji logów';
$string['writingmessagesinfo'] = 'Zapis informacji o wiadomościach';
$string['writingmoduleinfo'] = 'Zapis informacji o modułach';
$string['writingscalesinfo'] = 'Zapis informacji o skalach';
$string['writinguserinfo'] = 'Zapis informacji o użytkownikach';
$string['wrongpassword'] = 'Błędne hasło dla tej nazwy użytkownika';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'rok';
$string['years'] = 'lata';
$string['yes'] = 'Tak';
$string['youareabouttocreatezip'] = 'Masz zamiar utworzyć archiwum zip zawierające:';
$string['youaregoingtorestorefrom'] = 'Za chwilę rozpoczniesz odtwarzanie kursu';
$string['youneedtoenrol'] = 'Aby to zrobić, musisz być zapisany na kursie';
$string['yourlastlogin'] = 'Ostatnie logowanie';
$string['yourself'] = 'samodzielnie';
$string['yourteacher'] = 'twój {$a}';
$string['yourwordforx'] = 'Twój odpowiednik słowa: \'{$a}\'';
$string['zippingbackup'] = 'Archiwizacja kopii zapasowej';
