<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'pl', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Zaakceptuj';
$string['accept_grades'] = 'Zaakceptuj oceny z narzędzia';
$string['accept_grades_admin'] = 'Zaakceptuj oceny z narzędzia';
$string['accept_grades_admin_help'] = 'Określ, czy dostawca treści może dodawać, aktualizować, czytać i usuwać oceny związane z tym egzemplarzem modułu.

Niektórzy dostawcy treści umożliwiają wysyłanie z powrotem do Moodle ocen działań wykonywanych w zdalnym module, co pozwala doświadczyć jeszcze pełniejszej integracji.';
$string['accept_grades_help'] = 'Określ, czy dostawca treści może dodawać, aktualizować, czytać i usuwać oceny związane z tym egzemplarzem modułu.

Niektórzy dostawcy treści umożliwiają wysyłanie z powrotem do Moodle ocen działań wykonywanych w zdalnym module, co pozwala doświadczyć jeszcze pełniejszej integracji.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['action'] = 'Akcja';
$string['active'] = 'Aktywny';
$string['activity'] = 'Aktywność';
$string['addnewapp'] = 'Włącz aplikacje zewnętrzne';
$string['addserver'] = 'Dodaj nowy zaufany serwer';
$string['addtype'] = 'Dodaj konfigurację zewnętrznego modułu';
$string['allow'] = 'Zezwól';
$string['allowinstructorcustom'] = 'Zezwól nauczycielom dodawać własne parametry';
$string['allowsetting'] = 'Pozwól, aby narzędzie przechowywało do 8 KB ustawień w Moodle';
$string['always'] = 'Zawsze';
$string['automatic'] = 'Automatyczna, na podstawie adresu URL uruchamiania';
$string['baseurl'] = 'Podstawowy URL';
$string['basiclti'] = 'Learning Tools Interoperability (LTI)';
$string['basicltiactivities'] = 'Aktywności LTI';
$string['basiclti_base_string'] = 'Bazowy ciąg LTI OAuth';
$string['basiclti_endpoint'] = 'Punkt wywołania LTI';
$string['basicltifieldset'] = 'Przykładowy zestaw pól';
$string['basiclti_in_new_window'] = 'Twoja aktywność została otwarta w nowym oknie';
$string['basicltiintro'] = 'Opis aktywności';
$string['basicltiname'] = 'Nazwa aktywności';
$string['basiclti_parameters'] = 'Parametry wywołania LTI';
$string['basicltisettings'] = 'Ustawienia podstawowe narzędzia LTI';
$string['cannot_delete'] = 'Nie możesz usunąć tej konfiguracji narzędzia.';
$string['cannot_edit'] = 'Nie możesz edytować tej konfiguracji narzędzia.';
$string['comment'] = 'Komentarz';
$string['configpassword'] = 'Domyślne hasło zdalnego modułu*';
$string['configpreferheight'] = 'Domyślna preferowana wysokość';
$string['configpreferwidget'] = 'Ustaw widget jako domyślny';
$string['configpreferwidth'] = 'Domyślna preferowana szerokość';
$string['configresourceurl'] = 'Domyślny URL zasobu';
$string['configtoolurl'] = 'Domyślny URL zdalnego modułu';
$string['configtypes'] = 'Włącz Aplikacje LTI';
$string['courseid'] = 'id kursu';
$string['coursemisconf'] = 'Kurs jest źle skonfigurowany';
$string['course_tool_types'] = 'Typy narzędzi kursu*';
$string['createdon'] = 'Utworzono';
$string['curllibrarymissing'] = 'Biblioteka PHP Curl musi być zainstalowana, aby używać LTI';
$string['custom'] = 'Parametry niestandardowe';
$string['custom_config'] = 'Użyj własnej konfiguracji narzędzia.';
$string['custom_help'] = 'Parametry niestandardowe to parametry wykorzystywane przez dostawcę treści. Na przykład taki parametr może wskazywać określony zasób u dostawcy do wyświetlenia. Bezpiecznie jest pozostawić to pole bez zmian, chyba że dostawca określi inaczej.';
$string['custominstr'] = 'Parametry niestandardowe';
$string['debuglaunch'] = 'Opcja debug';
$string['debuglaunchoff'] = 'Normalne uruchomienie';
$string['debuglaunchon'] = 'Uruchomienie z debugowaniem';
$string['default'] = 'Domyślnie';
$string['default_launch_container'] = 'Domyślny sposób wyświetlenia';
$string['default_launch_container_help'] = 'Domyślny sposób wyświetlenia określa, w jakiej formie na ekranie pokaże się zawartość modułu.

* **Domyślnie** - użyje okna określonego przez konfigurację narzędzia.
* **Wbudowane** - moduł jest wyświetlany w oknie Moodle\'a jak większość innych aktywności.
* **Wbudowane bez bloków** - moduł jest wyświetlany w bieżącym oknie Moodle\'a, bez innych bloków, z kontrolkami nawigacji na górze strony.
* **Nowe okno** - moduł otwiera się w nowym oknie, zajmując całą dostępną przestrzeń. W zależności od przeglądarki, otworzy się nowa karta lub okno popup. Przeglądarka może zablokować otwarcie nowego okna.';
$string['delegate'] = 'Przekaż nauczycielowi';
$string['delete'] = 'Usuń';
$string['delete_confirmation'] = 'Czy na pewno chcesz usunąć tę konfigurację zewnętrznego modułu?';
$string['deletetype'] = 'Usuń konfigurację zewnętrznego modułu';
$string['display_description'] = 'Wyświetl opis aktywności podczas jej uruchamiania';
$string['display_description_help'] = 'Jeśli zaznaczono, opis aktywności (określony powyżej) będzie wyświetlany nad treścią dostawcy.

Opis może być wykorzystane w celu udzielenia dodatkowych instrukcji użytkownikom narzędzia, ale nie jest to wymagane.

Opis nie jest wyświetlany, gdy moduł wyświetlany jest w nowym oknie.';
$string['display_name'] = 'Wyświetl nazwę aktywności podczas jej uruchamiania';
$string['display_name_help'] = 'Jeśli zaznaczono, nazwa aktywności (określona powyżej) będzie wyświetlany powyżej treści z serwera.

Możliwe, że w treści również wyświetlany jest tytułu. Przy pomocy tej opcja można zapewnić jednokrotne wyświetlanie tytułu.

Tytuł nie jest wyświetlany, gdy treść z serwera wyświetlana jest w nowym oknie.';
$string['domain_mismatch'] = 'Domena URL wywołania nie pasuje do konfiguracji narzędzia.';
$string['donot'] = 'Nie wysłano';
$string['donotaccept'] = 'Nie zostało zaakceptowane';
$string['donotallow'] = 'Nie wolno';
$string['edittype'] = 'Edycja konfiguracji zewnętrznych modułów';
$string['embed'] = 'Wbudowane';
$string['embed_no_blocks'] = 'Wbudowane bez bloków';
$string['enableemailnotification'] = 'Wyślij powiadomienia e-mail';
$string['enableemailnotification_help'] = 'Jeśli opcja jest włączona, studenci będą otrzymywać powiadomienia e-mail, gdy ich prace w tym module będą ocenione.';
$string['errormisconfig'] = 'Źle skonfigurowane narzędzie. Poproś administratora Moodle, aby poprawił konfigurację.';
$string['extensions'] = 'Usługi rozszerzeń LTI';
$string['external_tool_type'] = 'Typ zewnętrznego modułu';
$string['external_tool_type_help'] = 'Głównym celem konfiguracji narzędzia jest stworzenie bezpiecznego kanału komunikacyjnego pomiędzy Moodle a zdalnym dostawcą treści. Można tu ustalić wartości domyślne konfiguracji oraz włączyć dodatkowe funkcje świadczonych przez dostawcę.

* **Automatyczny, wg URL wywołania** - To ustawienie powinno być stosowane w prawie wszystkich przypadkach. Moodle wybierze najbardziej odpowiednią konfigurację narzędzia na podstawie URL wywołania. Użyte będą narzędzia skonfigurowane zarówno przez administratora jak w ramach tego kursu. Gdy określi się URL wywołania, Moodle poinformuje czy go rozpoznaje. Jeśli nie - być może trzeba wprowadzić dane konfiguracyjne narzędzia ręcznie.
* **Specjalny typ** - wybierając konkretny typ konfiguracji narzędzia, można spowodować użycie tej konfiguracji podczas komunikowania się z zewnętrznym dostawcą treści. Jeśli adres URL wywołania wydaje się nie należeć do dostawcy, pojawi się komunikat ostrzegawczy. W niektórych przypadkach nie jest konieczne wprowadzać URL wywołania, gdy wybrano specjalny typ (o ile nie wywołuje się konkretnego zasobu u danego dostawcy).
*** Niestandardowa konfiguracja ** - Aby skonfigurować ten egzemplarz narzędzia niestandardowo, wyświetl Zaawansowane opcje, a następnie wprowadź klucz klienta i wspólne tajne hasło samodzielnie. Jeśli nie masz klucza klienta i wspólnego tajnego hasła, może je pobrać od dostawcy treści. Nie wszystkie narzędzia wymagają klucza i hasła, w tym przypadku pola mogą być puste.

### Edycja typów narzędzia

Trzy ikony dostępne są za rozwijaną listą zewnętrznej typu narzędzia :

* **Dodaj** - Tworzy konfigurację narzędzia na poziomie kursu. Wszystkie egzemplarze modułu zewnętrznego w tym kursie mogą użyć tej konfiguracji.
* **Edytuj** - Wybierz konfigurację narzędzia na poziomie kursu z listy rozwijanej, a następnie kliknij tę ikonę. Możesz wtedy edytować szczegóły konfiguracji.
* **Usuń** - Usuwa wybraną konfigurację z poziomu kursu.';
$string['external_tool_types'] = 'Kategorie zewnętrznych modułów';
$string['failedtoconnect'] = 'Moodle nie było w stanie komunikować się z systemem "{$a}"';
$string['filter_basiclti_configlink'] = 'Skonfiguruj ulubione witryny i ich hasła';
$string['filter_basiclti_password'] = 'Hasło jest obowiązkowe';
$string['filterconfig'] = 'Administracja LTI';
$string['filtername'] = 'Learning Tools Interoperability';
$string['fixexistingconf'] = 'Zastosuj istniejącej konfiguracji do źle skonfigurowanego egzemplarza';
$string['fixnew'] = 'Nowa konfiguracja';
$string['fixnewconf'] = 'Zdefiniuj nową konfigurację dla źle skonfigurowanego egzemplarza';
$string['fixold'] = 'Użyj istniejącego';
$string['forced_help'] = 'Ta opcja została określona na poziomie konfiguracji kursu lub witryny. Nie można jej zmienić na tej stronie.';
$string['force_ssl'] = 'Wymuś SSL';
$string['force_ssl_help'] = 'Wybór tej opcji wymusza użycie SSL przy każdym wywołaniu dostawcy tego modułu.

Ponadto, wszystkie wywołania internetowe od tego dostawcy będą używać SSL.

Gdy włączasz tę opcję, upewnij się, że ta strona Moodle oraz dostawca obsługuje SSL.';
$string['global_tool_types'] = 'Globalne typy narzędzi';
$string['grading'] = 'Przekazywanie ocen';
$string['icon_url'] = 'Ikona URL';
$string['icon_url_help'] = 'Pole to pozwala zmienić ikonę, która jest pokazywana w liście kursów przy tej aktywności. Zamiast używać domyślnej ikony LTI, można wskazać ikonę, która kojarzy się z typem aktywności';
$string['id'] = 'id';
$string['invalidid'] = 'Identyfikator LTI był niepoprawny';
$string['launch_in_moodle'] = 'Uruchom moduł w Moodle';
$string['launchinpopup'] = 'Okno uruchomienia';
$string['launch_in_popup'] = 'Uruchom moduł w oknie wyskakującym (popup)';
$string['launchinpopup_help'] = 'Domyślny sposób wyświetlenia określa, w jakiej formie na ekranie pokaże się zawartość modułu.

* **Domyślnie** - użyje okna określonego przez konfigurację narzędzia.
* **Wbudowane** - moduł jest wyświetlany w oknie Moodle\'a jak większość innych aktywności.
* **Wbudowane bez bloków** - moduł jest wyświetlany w bieżącym oknie Moodle\'a, bez innych bloków, z kontrolkami nawigacji na górze strony.
* **Nowe okno** - moduł otwiera się w nowym oknie, zajmując całą dostępną przestrzeń. W zależności od przeglądarki, otworzy się nowa karta lub okno popup. Przeglądarka może zablokować otwarcie nowego okna.';
$string['launchoptions'] = 'Opcje wywołania';
$string['launch_url'] = 'URL wywołania';
$string['launch_url_help'] = 'URL wywołania wskazuje adres internetowy zewnętrznego narzędzia, i może zawierać dodatkowe informacje, takie jak zasób do pokazania. Jeśli nie jesteś pewien, co wpisać do tego pola, poszukaj więcej informacji u dostawcy treści.

Jeśli wybrałeś konkretny rodzaj narzędzia, to możliwe, że nie trzeba wpisywać adresu wywołania. Tak będzie prawdopodobnie w przypadku, gdy link służy tylko do uruchomienia dostawcy treści, a nie wskazania konkretnego zasobu.';
$string['lti'] = 'Learning Tools Interoperability';
$string['lti:addcoursetool'] = 'Ocena aktywności LTI';
$string['lti:addinstance'] = 'Dodaj nową aktywność LTI';
$string['lti_administration'] = 'Administracja LTI';
$string['lti_errormsg'] = 'Narzędzie zwróciło następujący komunikat błędu: "{$a}"';
$string['lti:grade'] = 'Ocena aktywności LTI';
$string['lti_launch_error'] = 'Wystąpił błąd podczas uruchamiania zdalnego modułu:';
$string['lti_launch_error_tool_request'] = '<p> Aby poprosić administratora, o dokończenie konfiguracji narzędzia, kliknij <a href="{$a->admin_request_url}" target="_top">tutaj</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>
Ten błąd może być wynikiem braku klucza klienta i wspólnego tajnego hasła dla dostawcy treści.</p>
<p>
Jeśli masz klucz klienta i wspólnego tajne hasło, możesz je wprowadzić podczas edycji egzemplarza zewnętrznego modułu (upewnij się, że zaawansowane opcje są widoczne). <br />
Alternatywnie, można utworzyć konfigurację dostawcy na poziomie kursu <a href="{$a->course_tool_editor}">tutaj</a>.
</p>';
$string['lti:manage'] = 'Edytuj aktywność LTI';
$string['lti:requesttooladd'] = 'Prześlij do administratorów prośbę o konfigurację narzędzia';
$string['lti_tool_request_added'] = 'Prośba o konfigurację narzędzia pomyślnie wysłana. Być może trzeba będzie skontaktować się z administratorem, aby dokończyć konfigurację narzędzia.';
$string['lti_tool_request_existing'] = 'Prośba o konfigurację tego narzędzia była już wcześniej wysłana.';
$string['lti:view'] = 'Zobacz aktywności LTI';
$string['main_admin'] = 'Ogólna pomoc';
$string['main_admin_help'] = 'Narzędzie Zewnętrzny Moduł pozwala witrynie Moodle bezproblemowo i płynnie korzystać z zasobów edukacyjnych na zdalnych serwerach. Poprzez specjalny protokół uruchomienia, narzędzie zdalne będzie miało dostęp do pewnych ogólnych informacji na temat użytkownika, który je wywołał. Na przykład: nazwa instytucji, id kursu, id użytkownika i inne informacje, takie jak nazwa użytkownika lub adres e-mail.
Narzędzia wymienione na tej stronie są podzielone na trzy kategorie:
* ** Aktywne ** - Ci dostawcy treści zostali zatwierdzeni i skonfigurowani przez administratora. Mogą być  wykorzystani w dowolnym kursie na tej witrynie Moodle. Jeśli wprowadzi się klucz klienta i wspólne tajne hasło, nawiązywane jest zaufane połączenie między tym Moodle i zdalnym serwerem, zapewniając bezpieczny kanał komunikacji.
* ** Oczekujące ** - Ci dostawcy zostali zainstalowani poprzez import pakietów, ale nie zostali skonfigurowane przez administratora. Nauczyciele mogą korzystać z modułów od tych dostawców, jeśli mają klucz klienta i wspólnego tajne hasło, albo jeśli nie są one wymagane.
* ** Odrzucone ** - Ci dostawcy są oznaczeni jako ci, których administrator nie ma zamiaru udostępniać całej witrynie Moodle. Nauczyciele mogą korzystać z modułów od tych dostawców, jeśli mają klucz klienta i wspólnego tajne hasło, albo jeśli nie są one wymagane.';
$string['miscellaneous'] = 'Różne';
$string['misconfiguredtools'] = 'Wykryto źle skonfigurowane narzędzia';
$string['missingparameterserror'] = 'Strona jest źle skonfigurowana: &quot;{$a}&quot;';
$string['module_class_type'] = 'Typ modułu Moodle';
$string['modulename'] = 'Zewnętrzny moduł';
$string['modulename_help'] = 'Zewnętrzne moduły pozwalają użytkownikom Moodle na interakcję z zasobami dydaktycznymi na innych stronach. Na przykład, zewnętrzne moduł może zapewnić dostęp do nowego rodzaju aktywności lub materiałów dydaktycznych od wydawcy.

Aby skonfigurować egzemplarz zewnętrznego modułu, niezbędny jest dostawca treści, który obsługuje LTI (Learning Tools Interoperability). Jeśli znajdziesz  dostawcę treści, który obsługuje LTI, powinnien on dostarczyć informację, jak skonfigurować egzemplarz zewnętrznego modułu. Dodatkowo, typy skonfigurowane przez administratora strony będą również dostępne.

Moduły zewnętrzne różnią się od zasobów URL na kilka sposobów:
* **Kontekst** - Moduły zewnętrzne mają dostęp do informacji na temat użytkownika, który uruchomił narzędzie, takich jak instytucja, kurs, nazwa i inne.
* **Głęboka integracja** - Moduły zewnętrzne obsługują odczyt, aktualizację i usuwanie ocen związanych z aktywnością. Więcej punktów integracyjnych jest planowanych w przyszłych wydaniach.
* **Bezpieczeństwo** - konfiguracje Zewnętrznych modułów zapewniają bezpieczne połączenie między Moodle i dostawca treści.';
$string['modulenameplural'] = 'Zewnętrzne moduły';
$string['modulenamepluralformatted'] = 'Egzemplarze LTI';
$string['never'] = 'Nigdy';
$string['new_window'] = 'Nowe okno';
$string['noattempts'] = 'W tym egzemplarzu modułu nie wykonano żadnych prób';
$string['no_lti_configured'] = 'Brak aktywnych skonfigurowanych modułów zewnętrznych';
$string['no_lti_pending'] = 'Brak oczekujących modułów zewnętrznych';
$string['no_lti_rejected'] = 'Brak odrzuconych modułów zewnętrznych';
$string['noltis'] = 'Brak egzemplarzy LTI';
$string['noservers'] = 'Nie znaleziono serwerów';
$string['notypes'] = 'Obecnie brak zainstalowanych narzędzi LTI w tym Moodle. Kliknij link powyżej, aby dodać.';
$string['noviewusers'] = 'Nie znaleziono użytkowników z uprawieniami do użycia tego narzędzia';
$string['optionalsettings'] = 'Ustawienia opcjonalne';
$string['organization'] = 'Szczegóły organizacyjne';
$string['organizationdescr'] = 'Opis organizacji';
$string['organizationid'] = 'Identyfikator organizacji';
$string['organizationid_help'] = 'Unikalny identyfikator dla tej witryny Moodle. Zazwyczaj używana jest nazwa DNS organizacji.

Jeśli to pole jest puste, nazwa hosta Moodle będzie używana jako wartość domyślna.';
$string['organizationurl'] = 'Adres URL organizacji';
$string['organizationurl_help'] = 'Bazowy adres URL tej instancji Moodle.

Jeśli to pole jest puste, będzie używana wartość domyślna z konfiguracji witryny.';
$string['pagesize'] = 'Zgłoszeń na stronie';
$string['password'] = 'Wspólne tajne hasło';
$string['password_admin'] = 'Wspólne tajne hasło';
$string['password_admin_help'] = 'Wspólne tajne hasło można traktować jako hasło używane do uwierzytelniania dostępu do narzędzia.
Należy go użyć wraz z kluczem klienta uzyskanym od dostawcy narzędzia.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać wspólnego tajnego hasła.';
$string['password_help'] = 'W przypadku narzędzi wstępnie skonfigurowanych, nie jest konieczne wprowadzanie wspólnego tajnego hasła tutaj, ponieważ zrobiono to już w ramach procesu konfiguracji.

To pole należy wypełnić w przypadku tworzenia łącza do dostawcy, który nie jest jeszcze skonfigurowany. Jeśli dostawca ma być użyty wiele razy w tym kursie, dobrym pomysłem jest dodanie konfiguracji narzędzia na poziomie kursu.

Wspólne tajne hasło można traktować jako hasło używane do uwierzytelniania dostępu do narzędzia.
Należy go użyć wraz z kluczem klienta uzyskanym od dostawcy narzędzia.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać wspólnego tajnego hasła.';
$string['pending'] = 'Oczekujące';
$string['pluginadministration'] = 'Administracja LTI';
$string['pluginname'] = 'Learning Tools Interoperability';
$string['preferheight'] = 'Preferowana wysokość';
$string['preferwidth'] = 'Preferowana szerokość';
$string['press_to_submit'] = 'Naciśnij, aby uruchomić tę aktywność';
$string['privacy'] = 'Prywatność';
$string['quickgrade'] = 'Zezwól na szybkie ocenianie';
$string['quickgrade_help'] = 'Jeśli opcja jest włączona, wiele ocen może być wystawianych na jednym formularzu. Wpisz oceny i komentarze, a następnie kliknij przycisk "Zapisz wszystkie moje opinie", aby zapisać wszystkie zmiany z tej strony.';
$string['redirect'] = 'Zostaniesz przekierowany w ciągu kilku sekund. Jeśli nie, naciśnij przycisk.';
$string['reject'] = 'Odrzuć';
$string['rejected'] = 'Odrzucone';
$string['resource'] = 'Zasób';
$string['resourcekey'] = 'Klucz klienta';
$string['resourcekey_admin'] = 'Klucz klienta';
$string['resourcekey_admin_help'] = 'Klucz klienta można traktować jako nazwę użytkownika używaną do uwierzytelniania dostępu do narzędzia. Może być użyty przez dostawcę treści, aby jednoznacznie zidentyfikować witrynę Moodle, a której użytkownik wywołał narzędzie.

Klucz klienta musi być dostarczony przez dostawcę treści. Sposób uzyskania klucza różni się u różnych dostawców. Może być zautomatyzowany lub wymagać dialogu z dostawcą.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać klucza klienta.';
$string['resourcekey_help'] = 'W przypadku narzędzi wstępnie skonfigurowanych, nie jest konieczne wprowadzanie klucza zasobu tutaj, ponieważ zrobiono to już w ramach procesu konfiguracji.

To pole należy wypełnić w przypadku tworzenia łącza do dostawcy, który nie jest jeszcze skonfigurowany. Jeśli dostawca ma być użyty wiele razy w tym kursie, dobrym pomysłem jest dodanie konfiguracji narzędzia na poziomie kursu.

Klucz klienta można traktować jako nazwę użytkownika używaną do uwierzytelniania dostępu do narzędzia. Może być użyty przez dostawcę treści, aby jednoznacznie zidentyfikować witrynę Moodle, a której użytkownik wywołał narzędzie.

Klucz klienta musi być dostarczony przez dostawcę treści. Sposób uzyskania klucza różni się u różnych dostawców. Może być zautomatyzowany lub wymagać dialogu z dostawcą.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać klucza zasobu.';
$string['resourceurl'] = 'URL zasobu';
$string['return_to_course'] = 'Kliknij <a href="{$a->link}" target="_top">tutaj</a> , aby powrócić do kursu.';
$string['saveallfeedback'] = 'Zapisz wszystkie moje opinie';
$string['secure_icon_url'] = 'Ikona URL dla SSL';
$string['secure_icon_url_help'] = 'Pole używane zamiast ikony URL, jeśli użytkownik łączy się z Moodle przez SSL. Głównym celem tego pola jest to, żeby zapobiec ostrzeżeniom przeglądarki o wyświetlaniu niezabezpieczonych obrazów na stronie zabezpieczonej przez SSL.';
$string['secure_launch_url'] = 'URL wywołania dla SSL';
$string['secure_launch_url_help'] = 'Zastępuje URL wywołania, gdy wymagany jest wysoki poziom bezpieczeństwa.
Moodle będzie używać bezpiecznego URL wywołania zamiast zwykłego, jeśli witryna Moodle jest wywołana poprzez protokół SSL, lub jeśli w konfiguracja narzędzia jest ustawione uruchamianie poprzez SSL.

Zwykły URL wywołania może być także ustawiony na adres https:, wtedy użyte będzie SSL, a to pole może być puste.';
$string['send'] = 'Wyślij';
$string['setupoptions'] = 'Opcje konfiguracji';
$string['share_email'] = 'Udostępnij dostawcy email użytkownika';
$string['share_email_admin'] = 'Udostępnij dostawcy email użytkownika';
$string['share_email_admin_help'] = 'Określ, czy adres e-mail użytkownika, który wywołał zdalny moduł będzie udostępniony dostawcy treści. Dostawca treści może wymagać adresu e-mail, aby rozróżnić użytkowników o tej samej nazwie wyświetlanej lub wysłać e-mail do użytkowników w związku z funkcjami tego narzędzia.';
$string['share_email_help'] = 'Określ, czy adres e-mail użytkownika, który wywołał zdalny moduł będzie udostępniony dostawcy treści. Dostawca treści może wymagać adresu e-mail, aby rozróżnić użytkowników o tej samej nazwie wyświetlanej lub wysłać e-mail do użytkowników w związku z funkcjami tego narzędzia.
Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji narzędzia.';
$string['share_name'] = 'Udostępnij dostawcy nazwę użytkownika';
$string['share_name_admin'] = 'Udostępnij dostawcy nazwę użytkownika';
$string['share_name_admin_help'] = 'Określ, czy pełna nazwa użytkownika, który wywołał zdalny moduł, będzie udostępniona dostawcy treści. Dostawca treści może wymagać tych nazw, aby wyświetlić informacje w sposób zrozumiały.';
$string['share_name_help'] = 'Określ, czy pełna nazwa użytkownika, który wywołał zdalny moduł, będzie udostępniona dostawcy treści. Dostawca treści może wymagać tych nazw, aby wyświetlić informacje w sposób zrozumiały.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['share_roster'] = 'Zezwól zdalnemu narzędziu na dostęp do listy użytkowników kursu.';
$string['share_roster_admin'] = 'Narzędzie ma dostęp do listy użytkowników';
$string['share_roster_admin_help'] = 'Określ, czy narzędzie ma dostęp do listy użytkowników zapisanych w kursie, z którego jest uruchomione.';
$string['share_roster_help'] = 'Określ, czy narzędzie ma dostęp do listy użytkowników zapisanych w tym kursie.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['show_in_course'] = 'Pokaż ten typ przy tworzeniu egzemplarza narzędzia';
$string['show_in_course_help'] = 'Jeśli zaznaczono, ta konfiguracja pojawi się w liście rozwijanej "typ zewnętrznego modułu", gdy nauczyciele konfigurują zewnętrzne moduły w ramach kursów.

W większości przypadków nie ma potrzeby zaznaczać tej opcji.
Nauczyciele mogą korzystać z tej konfiguracji, gdy URL wywołania będzie zgodny z bazowym adres URL narzędzia, i to jest metodą preferowaną.

W jedynym przypadku ta opcja powinna być zaznaczona: jeśli konfiguracja jest przeznaczona do logowania single sign on. Na przykład jeśli wszystkie odwołania do dostawcy tylko przenoszą każdego użytkownika do strony docelowej, a nie do konkretnego zasobu.';
$string['size'] = 'Parametry rozmiaru';
$string['submission'] = 'Praca';
$string['submissions'] = 'Oddane prace';
$string['toggle_debug_data'] = 'Przełączanie danych debugowania';
$string['tool_config_not_found'] = 'Nie znaleziono konfiguracji narzędzia dla tego adresu URL.';
$string['tool_settings'] = 'Ustawienia narzędzia';
$string['toolsetup'] = 'Konfiguracja zewnętrznego modułu';
$string['toolurl'] = 'Bazowy URL narzędzia';
$string['toolurl_help'] = 'Bazowy URL narzędzie służy do dopasowania adresów wywołania do odpowiedniej konfiguracji narzędzia. Użycie profiksu http(s) jest opcjonalne.

Ponadto, bazowy adres URL jest używany jako URL wywołania, jeśli tamten nie jest określony w egzemplarzu zewnętrznego modułu.

<table> <thead> <tr> <td> <b>Bazowy URL</b> </td> <td> <b>Pasuje do</b> </td> </tr> </thead> <tbody> <tr> <td> tool.com </td> <td> tool.com, tool.com/quizzes, tool.com/quizzes/quiz.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> www.tool.com/quizzes </td> <td> tool.com/quizzes, tool.com/quizzes/take.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> quiz.tool.com </td> <td> quiz.tool.com, quiz.tool.com/take.php?id=10 </td> </tr> </tbody> </table>

Jeśli dwie różne konfiguracje dotyczą tej samej domeny, bardziej szczegółowa będzie użyta.';
$string['typename'] = 'Nazwa narzędzia*';
$string['typename_help'] = 'Nazwa narzędzia jest używana do identyfikacji dostawcy treści w Moodle. Wprowadzona tu nazwa będzie widoczna dla nauczycieli podczas dodawania zewnętrznych treści do kursów.';
$string['types'] = 'Typy';
$string['update'] = 'Aktualizuj';
$string['using_tool_configuration'] = 'Użyto konfiguracji:';
$string['validurl'] = 'Prawidłowy adres URL musi zaczynać się od http(s)://';
$string['viewsubmissions'] = 'Zobacz prace i ekran oceniania';
