<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'pl', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktywności';
$string['addcategory'] = 'Dodaj kategorię';
$string['addcategoryerror'] = 'Nie można dodać kategorii';
$string['addexceptionerror'] = 'Błąd podczas dodawania wyjątku dla userid:gradeitem';
$string['addfeedback'] = 'Dodaj informację zwrotną';
$string['addgradeletter'] = 'Dodaj nazwę oceny';
$string['addidnumbers'] = 'Dodaj numery identyfikacyjne';
$string['additem'] = 'Dodaj pozycję oceny';
$string['addoutcome'] = 'Dodaj efekt kształcenia';
$string['addoutcomeitem'] = 'Dodaj pozycje efektu kształcenia';
$string['addscale'] = 'Dodaj skalę';
$string['aggregateextracreditmean'] = 'Średnia ocen (z dodatkowymi punktami)';
$string['aggregatemax'] = 'Najwyższa ocena';
$string['aggregatemean'] = 'Średnia ocen';
$string['aggregatemedian'] = 'Mediana ocen';
$string['aggregatemin'] = 'Najniższa ocena';
$string['aggregatemode'] = 'Dominanta (wartość najczęstsza)';
$string['aggregateonlygraded'] = 'Zestawienie niepustych ocen';
$string['aggregateonlygraded_help'] = 'W dzienniku ocen mogą znajdować się pozycje niewypełnione. Mogą to być zadania jeszcze nie ocenione lub quizy, których jeszcze nie rozwiązano.
To opcja określa, czy puste oceny mają nie być uwzględniane w podsumowaniu lub czy mają być liczone jako minimalne oceny, np. jako 0 jeśli skala oceniania to 0-100.';
$string['aggregateoutcomes'] = 'Zawrzeć efekty kształcenia w podsumowaniu';
$string['aggregateoutcomes_help'] = 'Jeśli włączone, efekty kształcenia będą zawarte w podsumowaniu. Może to spowodować nieoczekiwaną sumę kategorii.';
$string['aggregatesonly'] = 'Tylko oceny wynikowe';
$string['aggregatesubcats'] = 'Podsumowanie uwzględniające podkategorie';
$string['aggregatesubcats_help'] = 'To ustawienie określa, czy oceny z podkategorii są włączane do podsumowania.';
$string['aggregatesum'] = 'Suma ocen';
$string['aggregateweightedmean'] = 'Średnia ważona ocen';
$string['aggregateweightedmean2'] = 'Prosta średnia ważona ocen';
$string['aggregation'] = 'Zestawienie';
$string['aggregationcoef'] = 'Współczynnik agregacji';
$string['aggregationcoefextra'] = 'Extra kredyt';
$string['aggregationcoefextra_help'] = 'Jeśli ocena wynikowa jest obliczana jako Suma lub Prosta średnia ważona, a pole Extra kredyt jest zaznaczone, maksymalna ocena tej pozycji nie jest dodawana do maksymalnej oceny w kategorii i w związku z tym można osiągnąć ocenę maksymalną w kategorii (lub nawet ją przekroczyć, jeśli zezwoli na to administrator) nie mając maksimum we wszystkich ocenach składowych.
Jeśli wyliczana jest \'Średnia ocen (z dodatkowymi punktami)\' i Extra kredyt jest ustawiony na wartość większą od zera, jest on mnożnikiem, przez który mnoży się ocenę przed dodaniem jej do oceny końcowej po obliczeniu średniej.';
$string['aggregationcoefextrasum'] = 'Ekstra kredyt';
$string['aggregationcoefextrasum_help'] = 'Jeśli pole Extra kredyt jest zaznaczone, maksymalna ocena tej pozycji nie jest dodawana do maksymalnej oceny w kategorii i w związku z tym można osiągnąć ocenę maksymalną w kategorii (lub nawet ją przekroczyć, jeśli zezwoli na to administrator) nie mając maksimum we wszystkich ocenach składowych.';
$string['aggregationcoefextraweight'] = 'Waga Ekstra kredytu';
$string['aggregationcoefextraweight_help'] = 'Jeśli waga Ekstra kredytu jest większa niż 0, ocena liczy się jako dodatkowa, "nadobowiązkowa" ocena w podsumowaniu. Wartość wagi jest mnożnikiem, przez który mnoży się ocenę przed dodaniem jej  w celu obliczenia średniej.';
$string['aggregationcoefweight'] = 'Waga pozycji';
$string['aggregationcoefweight_help'] = 'Waga pozycji określa wagę, z jaką dana pozycja wchodzi do obliczeń oceny wynikowej w kategorii.';
$string['aggregation_help'] = 'Sposób agregacji (wyliczania oceny wynikowej) określa, w jaką metodą wyznacza się ocenę wynikową:

* średnia ocen - suma wszystkich ocen podzielona przez ich liczbę
* mediana ocen - wartość środkowa, ocena znajdująca się w połowie ciągu po jego posortowaniu
* najniższa ocena
* najwyższa ocena
* dominanta (wartość najczęstsza)
* suma ocen - suma wszystkich ocen liczbowych, oceny z innych skal są ignorowane';
$string['aggregationposition'] = 'Pozycja kolumny podsumowania';
$string['aggregationposition_help'] = 'To ostawienie określa, czy kolumny podsumowania kategorii oraz kursu są wyświetlane w raporcie dziennika ocen jako pierwsze, czy jako ostatnie.';
$string['aggregationsvisible'] = 'Dostępne typy zestawień';
$string['aggregationsvisiblehelp'] = 'Wybierz wszystkie typy podsumowań, które powinny być dostępne. Przytrzymaj klawisz CTRL aby wybrać wiele pozycji.';
$string['allgrades'] = 'Wszystkie stopnie w kategorii';
$string['allstudents'] = 'Wszyscy studenci';
$string['allusers'] = 'Wszyscy';
$string['autosort'] = 'Automatyczne sortowanie';
$string['availableidnumbers'] = 'Dostępne identyfikatory';
$string['average'] = 'Średnia';
$string['averagesdecimalpoints'] = 'Liczba miejsc po przecinku w kolumnie średnich';
$string['averagesdecimalpoints_help'] = 'Ustawienie to określa liczbę miejsc po przecinku wyświetlaną w kolumnie  średniej.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['averagesdisplaytype'] = 'Postać kolumny średnich';
$string['averagesdisplaytype_help'] = 'To ustawienie określa, w jakiej postaci wyświetlana jest średnia: wartości rzeczywiste, procenty, literowo.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['backupwithoutgradebook'] = 'Kopia zapasowa nie zawiera konfiguracji dziennika.';
$string['badgrade'] = 'Wprowadzona ocena jest niepoprawna';
$string['badlyformattedscale'] = 'Proszę wprowadzić rozdzielaną przecinkami listę wartości (minimum dwie wartości są wymagane)';
$string['baduser'] = 'Wprowadzona nazwa użytkownika jest niepoprawna';
$string['bonuspoints'] = 'Punkty bonusowe';
$string['bulkcheckboxes'] = 'Zbiorcze pola wyboru';
$string['calculatedgrade'] = 'Ocena obliczona';
$string['calculation'] = 'Obliczenie';
$string['calculationadd'] = 'Dodaj obliczenie';
$string['calculationedit'] = 'Edytuj obliczenie';
$string['calculation_help'] = 'Obliczenie to formuła służąca do wyliczenia oceny w niestandardowy sposób. Formuła zaczyna się znakiem równości (=) i może zawierać powszechnie stosowane operatory matematyczne takie jak max, min, czy sum . Jeśli to niezbędne, inne oceny mogą być uwzględnione w obliczeniu poprzez wpisanie ich identyfikatorów (ID) w podwójnych nawiasach kwadratowych.';
$string['calculationsaved'] = 'Obliczenie zapisane';
$string['calculationview'] = 'Pokaż obliczenie';
$string['cannotaccessgroup'] = 'Nie można uzyskać dostępu do ocen wybranej grupy, przepraszamy.';
$string['categories'] = 'Kategorie';
$string['categoriesanditems'] = 'Kategorie i elementy';
$string['categoriesedit'] = 'Edytuj kategorie i elementy';
$string['category'] = 'Kategoria';
$string['categoryedit'] = 'Edytuj kategorię';
$string['categoryname'] = 'Nazwa kategorii';
$string['categorytotal'] = 'Razem w kategorii';
$string['categorytotalfull'] = 'Suma {$a->category}';
$string['categorytotalname'] = 'Nazwa sumy kategorii';
$string['changedefaults'] = 'Zmień domyślne';
$string['changereportdefaults'] = 'Zmień domyślne ustawienia raportowania';
$string['chooseaction'] = 'Wybierz akcję';
$string['choosecategory'] = 'Wybierz kategorię';
$string['combo'] = 'Karty i rozwijane menu';
$string['compact'] = 'Kompaktuj';
$string['componentcontrolsvisibility'] = 'Czy to, czy ocena jest ukryta jest określane przez ustawienia aktywności.';
$string['contract'] = 'Zwiń kategorię';
$string['controls'] = 'Kontrolki';
$string['courseavg'] = 'Średnia kursu';
$string['coursegradecategory'] = 'Kategoria oceny';
$string['coursegradedisplaytype'] = 'Sposób wyświetlania oceny';
$string['coursegradedisplayupdated'] = 'Uaktualniono sposób wyświetlania oceny';
$string['coursegradesettings'] = 'Ustawienia ocen w kursie';
$string['coursename'] = 'Nazwa kursu';
$string['coursescales'] = 'Skale w kursach';
$string['coursesettings'] = 'Ustawienia kursu';
$string['coursesettingsexplanation'] = 'Ustawienia kursu określają, w jaki sposób dziennik ocen jest wyświetlany dla uczestników kursu.';
$string['coursetotal'] = 'W całym kursie';
$string['createcategory'] = 'Utwórz kategorię';
$string['createcategoryerror'] = 'Nie można utworzyć nowej kategorii';
$string['creatinggradebooksettings'] = 'Tworzenie ustawień dziennika ocen';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Agregacja z kategorii nadrzędnej';
$string['curveto'] = 'Zaokrąglaj do';
$string['decimalpoints'] = 'Ogółem miejsc po przecinku';
$string['decimalpoints_help'] = 'To ustawienie określa liczbę wyświetlanych miejsc dziesiętnych w ocenie. To nie ma jednak wpływu na obliczenia ocen, które dokonywane są z 5 miejscami po przecinku.';
$string['default'] = 'Domyślnie';
$string['defaultprev'] = 'Domyślnie ({$a})';
$string['deletecategory'] = 'Usuń kategorię';
$string['disablegradehistory'] = 'Wyłącz historię dziennika';
$string['disablegradehistory_help'] = 'Wyłącz śledzenie historii zmian w tabelach dotyczących oceniania. To nieco przyśpieszy pracę serwera i zmniejszy bazę danych.';
$string['displaylettergrade'] = 'Pokazuj stopnie';
$string['displaypercent'] = 'Pokazuj procenty';
$string['displaypoints'] = 'Pokazuj punkty';
$string['displayweighted'] = 'Pokazuj ważone stopnie';
$string['dropdown'] = 'Menu rozwijane';
$string['droplow'] = 'Odrzuć najniższe';
$string['droplowestvalue'] = 'Ustaw upuszczanie najniższej wartości oceny';
$string['droplow_help'] = 'To ustawienie umożliwia wyłączenie z podsumowania określonej liczby najniższych ocen.';
$string['dropped'] = 'Usunięto';
$string['dropxlowest'] = 'Usuń \'n\' najniższych';
$string['dropxlowestwarning'] = 'Wskazówka:Ilość odrzuconych dla danej kategorii powinna mieć taką samą wartość, w przeciwnym razie wyniki mogą być niedokładne.';
$string['duplicatescale'] = 'Zduplikuj skalę';
$string['edit'] = 'Edytuj';
$string['editcalculation'] = 'Edytuj obliczenie';
$string['editcalculationverbose'] = 'Edytuj obliczenie dla {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Edytuj informację zwrotną';
$string['editgrade'] = 'Edytuj ocenę';
$string['editgradeletters'] = 'Edytuj nazwy stopni';
$string['editoutcome'] = 'Edytuj efekt kształcenia';
$string['editoutcomes'] = 'Edytuj efekt kształcenia';
$string['editscale'] = 'Edytuj skalę';
$string['edittree'] = 'Kategorie i elementy';
$string['editverbose'] = 'Edytuj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Włącz AJAX';
$string['enableajax_help'] = 'Dodaje do raportu dziennika warstwę funkcjonalności AJAX, upraszczając i przyspieszając częste operacje. Wymaga włączonej obsługi JavaScript w przeglądarce użytkownika.';
$string['enableoutcomes'] = 'Włącz efekty kształcenia';
$string['enableoutcomes_help'] = 'Włączenie efektów kształcenia (zwanych także kompetencjami, celami kształcenia, standardami lub kryteriami) oznacza, że możemy oceniać w skalach związanych z efektami kształcenia. Po włączeniu takie specjalne skale są dostępne w całym serwisie.';
$string['encoding'] = 'Kodowanie';
$string['errorcalculationbroken'] = 'Prawdopodobnie odwołanie cykliczne lub uszkodzony wzór obliczeniowy';
$string['errorcalculationnoequal'] = 'Wyrażenie musi rozpoczynać się znakiem równości (=1+2)';
$string['errorcalculationunknown'] = 'Niepoprawne wyrażenie';
$string['errorgradevaluenonnumeric'] = 'Otrzymano nienumeryczną wartość dla najniższej i najwyższej oceny';
$string['errornocalculationallowed'] = 'Obliczenia nie są dozwolone dla tej pozycji';
$string['errornocategorisedid'] = 'Nie udało się znaleźć id bez kategorii!';
$string['errornocourse'] = 'Brak informacji o kursie';
$string['errorreprintheadersnonnumeric'] = 'Otrzymano nienumeryczną wartość dla powtórzeń nagłówka';
$string['errorsavegrade'] = 'Nie można zapisać oceny, przepraszamy.';
$string['errorsettinggrade'] = 'Błąd zapisu "{$a->itemname}" oceny dla użytkownika o identyfikatorze {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Błąd aktualizacji ustawień "Aggregate only non-empty grades" kategorii {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Błąd aktualizacji ustawień "Include outcomes in aggregation" kategorii {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Błąd aktualizacji ustawień "Aggregate including subcategories" kategorii {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Błąd aktualizacji typu podsumowania kategorii {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Błąd aktualizacji współczynnika agregacji (wagi lub extra kredytu) oceny {$a->id}';
$string['excluded'] = 'Wykluczony';
$string['excluded_help'] = 'Jeśli będzie zaznaczone, oceny nie będą uwzględniane żadnym zestawieniu.';
$string['expand'] = 'Rozszerz kategorię';
$string['export'] = 'Eksportuj';
$string['exportalloutcomes'] = 'Eksportuj wszystkie efekty kształcenia';
$string['exportfeedback'] = 'Uwzględnij opinie zwrotne';
$string['exportonlyactive'] = 'Wyklucz zawieszonych użytkowników';
$string['exportonlyactive_help'] = 'Włączenie tylko studentów, których zapis jest aktywny i nie zostali zawieszeni.';
$string['exportplugins'] = 'Eksportuj wtyczki';
$string['exportsettings'] = 'Eksportuj ustawienia';
$string['exportto'] = 'Eksportuj do';
$string['extracreditvalue'] = 'Wartość dodatkowego kredytu dla {$a}';
$string['extracreditwarning'] = 'Uwaga: ustawienie wszystkich danych jako opcji dodatkowej dla wyszczególnionej kategorii może skutkować niespodziewanymi wynikami. Nie będzie uwzględniony w wyniku ogólnym.';
$string['feedback'] = 'Informacja zwrotna';
$string['feedbackadd'] = 'Dodaj informację zwrotną';
$string['feedbackedit'] = 'Edytuj informację zwrotną';
$string['feedbackforgradeitems'] = 'Odpowiedź zwrotna dla {$a}';
$string['feedback_help'] = 'W tym polu można wpisać   jakiekolwiek uwagi czy komentarze na temat oceny.';
$string['feedbacks'] = 'Odpowiedzi zwrotne';
$string['feedbacksaved'] = 'Informacja zwrotna  zapisana';
$string['feedbackview'] = 'Zobacz informację zwrotną';
$string['finalgrade'] = 'Ocena końcowa';
$string['finalgrade_help'] = 'Jeżeli pole "nadpisane" jest zaznaczone ocena może być dodana lub zmodyfikowana.';
$string['fixedstudents'] = 'Statyczna kolumna studentów';
$string['fixedstudents_help'] = 'Pozwala na przewijanie poziome bez utraty widoczności kolumny studentów, poprzez spowodowanie, aby była statyczna.';
$string['forceoff'] = 'Wymuś: wyłączone';
$string['forceon'] = 'Wymuś: włączone';
$string['forelementtypes'] = 'dla wybranych {$a}';
$string['forstudents'] = 'Dla studentów';
$string['full'] = 'Pełny';
$string['fullmode'] = 'Widok pełny';
$string['fullview'] = 'Widok pełny';
$string['generalsettings'] = 'Ustawienia ogólne';
$string['grade'] = 'Ocena';
$string['gradeadministration'] = 'Administracja ocenami';
$string['gradeanalysis'] = 'Analiza ocen';
$string['gradebook'] = 'Dziennik ocen';
$string['gradebookhiddenerror'] = 'Dziennik ocen jest obecnie niedostępny dla studentów.';
$string['gradebookhistories'] = 'Historia ocen';
$string['gradeboundary'] = 'granica stopnia';
$string['gradeboundary_help'] = 'To ustawienie określa minimalne progi procentowe, którym odpowiadają oceny literowe.';
$string['gradecategories'] = 'Kategorie ocen';
$string['gradecategory'] = 'Kategoria ocen';
$string['gradecategoryonmodform'] = 'Kategoria ocen';
$string['gradecategoryonmodform_help'] = 'To ustawienie określa, w której kategorii dziennika jest umieszczana ocena tej aktywności.';
$string['gradecategorysettings'] = 'Ustawienia kategorii ocen';
$string['gradedisplay'] = 'Wyświetl oceny';
$string['gradedisplaytype'] = 'Typ wyświetlanej oceny';
$string['gradedisplaytype_help'] = 'To ustawienie określa w jaki sposób wyświetlane są oceny w dzienniku oraz w raporcie użytkownika.

* Punkty - aktualne oceny punktowe
* Procentowo
* Nazwa stopnia - litery lub słowa wykorzystywane w zakresie oceniania';
$string['gradedon'] = 'Ocenienione: {$a}';
$string['gradeexport'] = 'Eksport ocen';
$string['gradeexportcustomprofilefields'] = 'Niestandardowe pola profilu eksportu ocen';
$string['gradeexportcustomprofilefields_desc'] = 'Uwzględnij te niestandardowe pola profilu w eksporcie oceny, oddzielone przecinkami.';
$string['gradeexportdecimalpoints'] = 'Miejsca dziesiętne podczas eksportu ocen';
$string['gradeexportdecimalpoints_desc'] = 'Liczba miejsc dziesiętnych podczas eksportu ocen. Można tę wartość zmienić podczas eksportu.';
$string['gradeexportdisplaytype'] = 'Typ wyświetlania ocen podczas eksportu';
$string['gradeexportdisplaytype_desc'] = 'Podczas eksportu oceny mogą być wyświetlane w postaci liczb rzeczywistych, wartości procentowych (w odniesieniu do najmniejszej i największej oceny) lub jako litery (A, B, C itd.). Ustawienie to może być zmienione podczas eksportu.';
$string['gradeexportuserprofilefields'] = 'Pola profilu użytkownika eksportu ocen';
$string['gradeexportuserprofilefields_desc'] = 'Uwzględnij te pola profilu użytkownika podczas eksportu ocen, rozdzielając je przecinkami.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Pomoc do ocen';
$string['gradehistorylifetime'] = 'Czas przechowywania historii ocen.';
$string['gradehistorylifetime_help'] = 'Ten parametr określa okres czasu, przez który należy zachować historię zmian w ocenach. Zaleca się, aby ustawić jak najdłuższy czas. Jeśli wystąpią problemy z wydajnością lub mamy ograniczoną pojemność bazy danych, można ustawić niższą wartość.';
$string['gradeimport'] = 'Import ocen';
$string['gradeimportfailed'] = 'Importowanie oceny nie powiodło się podczas zatwierdzania. Szczegóły:';
$string['gradeitem'] = 'Oceniany element';
$string['gradeitemaddusers'] = 'Wyklucz z listy ocenianych';
$string['gradeitemadvanced'] = 'Zaawansowane opcje oceny';
$string['gradeitemadvanced_help'] = 'Wybierz wszystkie elementy, które powinny być wyświetlane w trybie zaawansowanym, podczas edycji pozycji ocen.';
$string['gradeitemislocked'] = 'Ta aktywność jest zablokowana w dzienniku ocen. Zmiany dokonane w ocenach tej aktywności nie zostaną skopiowane do dziennika ocen dopóki nie zostanie ona odblokowana.';
$string['gradeitemlocked'] = 'Ocenianie zablokowane';
$string['gradeitemmembersselected'] = 'Wykluczeni z listy ocenianych';
$string['gradeitemnonmembers'] = 'Lista ocenianych';
$string['gradeitemremovemembers'] = 'Dołącz do listy ocenianych';
$string['gradeitems'] = 'Oceny';
$string['gradeitemsettings'] = 'Ustawienia pozycji ocen';
$string['gradeitemsinc'] = 'Uwzględnij oceny z:';
$string['gradeletter'] = 'Nazwa stopnia';
$string['gradeletter_help'] = 'Nazwy stopni to litery A, B, C,..., lub słowa, np. Bardzo dobry, dobry, dostateczny,.... używane do wyrażenia zakresu ocen.';
$string['gradeletternote'] = 'Żeby usunąć literowe stopnie, zostaw puste pole i kliknij "Zachowaj zmiany".';
$string['gradeletters'] = 'Nazwy stopni';
$string['gradelocked'] = 'Ocena jest zablokowana';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Ocena maksymalna';
$string['grademax_help'] = 'To pole określa maksymalną ocenę tej pozycji w przypadku ocen liczbowych.
Maksymalną ocenę za aktywność (np. zadanie) ustawia się na stronie ustawień tej aktywności.';
$string['grademin'] = 'Ocena minimalna';
$string['grademin_help'] = 'To pole określa minimalną ocenę tej pozycji w przypadku ocen liczbowych.';
$string['gradeoutcomeitem'] = 'Efekt kształcenia';
$string['gradeoutcomes'] = 'Efekty kształcenia';
$string['gradeoutcomescourses'] = 'Efekty kształcenia kursu';
$string['gradepass'] = 'Próg zaliczeniowy';
$string['gradepass_help'] = 'To ustawienie określa minimalną ocenę wymaganą do zaliczenia. Ta wartość jest wykorzystywana w śledzeniu zaliczenia aktywności i kursu (completion tracking) oraz w dzienniku ocen, w którym oceny w kolorze zielonym oznaczają zaliczenie a czerwone jego brak.';
$string['gradepreferences'] = 'Właściwości oceny';
$string['gradepreferenceshelp'] = 'Pomoc do właściwości oceny';
$string['gradepublishing'] = 'Włącz publikowanie';
$string['gradepublishing_help'] = 'Włącz publikowanie podczas eksportu i importu. Oceny wyeksportowane publicznie mogą być dostępne przez URL, bez logowanie do Moodle. Oceny mogą być zaimportowane przy użyciu takiego URLa (czyli Moodle może importować oceny opublikowane przez inną witrynę). Domyślnie tylko administratorzy mogę użyć tej opcji. Prawa tego nie powinno się przekazywać niezaawansowanym użytkownikom (ryzyko utraty bezpieczeństwa danych itp.)';
$string['gradereport'] = 'Raport ocen';
$string['graderreport'] = 'Raport dziennika';
$string['grades'] = 'Stopnie';
$string['gradesforuser'] = 'Oceny dla {$a->user}';
$string['gradesonly'] = 'Tylko oceny';
$string['gradessettings'] = 'Ustawienia oceny';
$string['gradetype'] = 'Typ oceny';
$string['gradetype_help'] = 'Są 4 typy ocen:

Brak - brak mozliwości oceniania
Wartość  - wartość numeryczna z minimum i maximum
Skala - pozycja ze skali ocen
Tekst - tylko informacja zwrotna .

Tylko typy Wartość i Skala pozwalają na podsumowania. Typ oceny dla ocen wynikających z aktywności są ustawiane w ustawieniach aktywności.';
$string['gradeview'] = 'Pokaż ocenę';
$string['gradewasmodifiedduringediting'] = 'Wprowadzona ocena {$a->itemname} dla {$a->username} został a zignorowana, ponieważ została ona ostatnia zaktualizowana przez kogoś innego.';
$string['gradeweighthelp'] = 'Pomoc do wag stopni';
$string['groupavg'] = 'Średnia grupy';
$string['hidden'] = 'Ukryte';
$string['hiddenasdate'] = 'Pokaż datę wysłania ukrytych ocen';
$string['hiddenasdate_help'] = 'W miejscach ukrytych ocen pokazuj datę wysłania zamiast znaku \'-\'.';
$string['hidden_help'] = 'Jeśli zaznaczone, oceny są ukryte przed studentami. Można ustawić datę, do której oceny mają być ukryte, aby pokazać je dopiero po zakończeniu oceniania.';
$string['hiddenuntil'] = 'Ukryty do';
$string['hiddenuntildate'] = 'Ukryty do: {$a}';
$string['hideadvanced'] = 'Ukryj zaawansowane cechy';
$string['hideaverages'] = 'Ukryj średnie';
$string['hidecalculations'] = 'Ukryj obliczenia';
$string['hidecategory'] = 'Ukryj';
$string['hideeyecons'] = 'Ukryj ikony pokazywania/ukrywania';
$string['hidefeedback'] = 'Ukryj informację zwrotną';
$string['hideforcedsettings'] = 'Ukryj wymuszone ustwienia';
$string['hideforcedsettings_help'] = 'Nie pokazuj ustawień wymuszonych w intefejsie użytkownika używanym do oceniania.';
$string['hidegroups'] = 'Ukryj grupy';
$string['hidelocks'] = 'Ukryj blokady';
$string['hidenooutcomes'] = 'Pokaż efekty kształcenia';
$string['hidequickfeedback'] = 'Ukryj szybką informację zwrotną.';
$string['hideranges'] = 'Ukryj zakresy';
$string['hidetotalifhiddenitems'] = 'Ukryj sumy, jeżeli zawierają ukryte pozycje.';
$string['hidetotalifhiddenitems_help'] = 'Ta opcja określa, czy oceny wynikowe, które obejmują oceny ukryte są widoczne dla studentów lub zastępowane myślnikiem (-). Jeżeli są wyświetlane, ocena wynikowa może być obliczana z uwzględnieniem lub bez uwzględnienia ukrytych elementów.

Jeśli ukryte oceny nie są uwzględniane, ocena łączna będzie inna dla studenta i nauczyciela, ponieważ nauczyciel zawsze widzi wszystkie elementy. Jeśli ukryte oceny są uwzględniane, studenci mogą być w stanie wyliczyć ukryte oceny na podstawie pozostałych.';
$string['hidetotalshowexhiddenitems'] = 'Wyświetl sumy pomijając ukryte pozycje.';
$string['hidetotalshowinchiddenitems'] = 'Wyświetl sumy włączając ukryte pozycje.';
$string['hideverbose'] = 'Ukryj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sortuj wg najwyższych stopni rosnąco';
$string['highgradedescending'] = 'Sortuj wg najwyższych stopni malejąco';
$string['highgradeletter'] = 'Do';
$string['identifier'] = 'Identyfikuj użytkowników przez';
$string['idnumbers'] = 'Numery ID';
$string['ignore'] = 'Ignoruj';
$string['import'] = 'Importuj';
$string['importcsv'] = 'Importuj CSV';
$string['importcustom'] = 'Importu jako własne efekty kształcenia (tylko w tym kursie)';
$string['importerror'] = 'Błąd, wywołano skrypt z błędnymi parametrami.';
$string['importfailed'] = 'Importowanie nie powiodło się';
$string['importfeedback'] = 'Importuj informację zwrotną';
$string['importfile'] = 'Importuj plik';
$string['importfilemissing'] = 'Nie pobrano pliku, wróć do formularza i załaduj poprawny plik.';
$string['importfrom'] = 'Importuj z';
$string['importoutcomenofile'] = 'Przesłany plik jest pusty lub uszkodzony. Proszę sprawdzić czy jest to prawidłowy plik. Problem został wykryty w linii {$a}.
Błąd jest sygnalizowany, gdy linie danych nie mają tylu kolumn, ile w pierwszym wierszu (wierszu nagłówka), lub gdy w pliku brakuje oczekiwanych nagłówków. Prawidłowe nagłówki znajdziesz w pliku wyeksportowanym.';
$string['importoutcomes'] = 'Importuj efekty kształcenia';
$string['importoutcomes_help'] = 'Efekty kształcenia mogą być zaimportowane poprzez plik cvs w takim samym formacie w jakim są eksportowane.';
$string['importoutcomesuccess'] = 'Zaimportowany efekt kształcenia  "{$a->name}" z identyfikatorem  {$a->id}';
$string['importplugins'] = 'Importuj wtyczkę (plugin)';
$string['importpreview'] = 'Importuj podgląd';
$string['importsettings'] = 'Importuj ustawienia';
$string['importskippednomanagescale'] = 'Nie masz uprawnień, aby dodać nową skalę ocen, a efekt kształcenia "{$a}" wymaga stworzenia nowej skali, zatem został on pominięty.';
$string['importskippedoutcome'] = 'Efekt kształcenia o krótkiej nazwie "{$a}" już istnieje w tym kontekście, dlatego ten z importowanego pliku został pominięty.';
$string['importstandard'] = 'Zaimportuj jako standardowe efekty kształcenia';
$string['importsuccess'] = 'Import ocen zakończony pomyślnie';
$string['importxml'] = 'Import XML';
$string['includescalesinaggregation'] = 'Uwzględnij skale w zestawieniu';
$string['includescalesinaggregation_help'] = 'Tu możesz ustalić, czy oceny w skalach symbolicznych będą przeliczane na liczby i uwzględniane  wszystkich wynikowych ocenach we wszystkich dziennikach ocen we wszystkich kursach. UWAGA: Zmiana tego ustawienia spowoduje przeliczenie wszystkich wynikowych ocen.';
$string['incorrectcourseid'] = 'ID kursu był niepoprawny';
$string['incorrectcustomscale'] = '(Niepoprawna skala własna, należy zmienić.)';
$string['incorrectminmax'] = 'Minimum musi być mniejsze niż maksimum';
$string['inherit'] = 'dziedzicz';
$string['intersectioninfo'] = 'Informacja o studencie/ocenie';
$string['item'] = 'Pozycja';
$string['iteminfo'] = 'Informacje o elemencie';
$string['iteminfo_help'] = 'To jest miejsce na dodatkowy opis tej pozycji, Informacja nie jest wyświetlana nigdzie indziej.';
$string['itemname'] = 'Nazwa pozycji';
$string['itemnamehelp'] = 'Nazwa pozycji, ustalona wewnętrznie.';
$string['items'] = 'Pozycje';
$string['itemsedit'] = 'Modyfikuj pozycję oceny';
$string['keephigh'] = 'Zachowaj najwyższe';
$string['keephigh_help'] = 'Ta opcja zatrzyma X najwyższych ocen, odrzucając resztę. X jest wybraną wartością.';
$string['keymanager'] = 'Menedżer kluczy';
$string['lessthanmin'] = 'Ocena wprowadzona w {$a->itemname} dla użytkownika {$a->username} jest mniejsza od najmniejszej dopuszczalnej.';
$string['letter'] = 'Nazwa stopnia';
$string['lettergrade'] = 'Nazwy stopni';
$string['lettergradenonnumber'] = 'Niska i/lub wysoka ocena dla nienumerycznych';
$string['letterpercentage'] = 'Nazwa stopnia (procentowo)';
$string['letterreal'] = 'Nazwa stopnia (punkty)';
$string['letters'] = 'Nazwy stopni';
$string['linkedactivity'] = 'Powiązana aktywność';
$string['linkedactivity_help'] = 'Tu określona jest aktywność, z którą efekt kształcenia jest powiązany. W ten sposób można ocenić osiągnięcia studenta nie objęte oceną z aktywności.';
$string['linktoactivity'] = 'Link do aktywności: {$a->name}';
$string['lock'] = 'Zablokuj';
$string['locked'] = 'Zablokowany';
$string['locked_help'] = 'Jeśli zaznaczone, oceny nie mogą być aktualizowane powiązana aktywność.';
$string['locktime'] = 'Zablokuj po';
$string['locktimedate'] = 'Zablokowany po: {$a}';
$string['lockverbose'] = 'Zablokuj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najniższy';
$string['lowgradeletter'] = 'Od';
$string['manualitem'] = 'Pozycja wstawiona ręcznie';
$string['mapfrom'] = 'Mapuj z';
$string['mappings'] = 'Mapowania pozycji ocen';
$string['mapto'] = 'Mapuj do';
$string['max'] = 'Najwyższy';
$string['maxgrade'] = 'Maksymalna ocena';
$string['meanall'] = 'Wszystkie stopnie';
$string['meangraded'] = 'Niepuste stopnie';
$string['meanselection'] = 'Oceny brane do wyliczenia średniej';
$string['meanselection_help'] = 'Określ, typy ocen zawartych w kolumnie średnich. Komórki nie zawierające ocen będą ignorowane albo traktowane jakby zawierały zero (domyślnie).';
$string['median'] = 'Środkowy';
$string['min'] = 'Najniższy';
$string['missingscale'] = 'Skala musi być określona';
$string['mode'] = 'Tryb';
$string['morethanmax'] = 'Ocena wprowadzona w {$a->itemname} dla użytkownika {$a->username} jest większa od największej dopuszczalnej.';
$string['moveselectedto'] = 'Przenieś zaznaczone elementy do';
$string['movingelement'] = 'Przenoszenie {$a}';
$string['multfactor'] = 'Mnożnik';
$string['multfactor_help'] = 'Jest to mnożnik, przez który wszystkie oceny w tej pozycji będą pomnożone, przy czym wynik nie przekroczy górnej granicy skali.
Na przykład, jeżeli mnożnik wynosi 2 a maksymalna ocena to 100, wszystkie oceny mniejsze niż 50 będą pomnożone przez 2, a 50 i powyżej będą zmieniony na 100.';
$string['multfactorvalue'] = 'Wartość mnożnika dla {$a}';
$string['mypreferences'] = 'Moje ustawienia';
$string['myreportpreferences'] = 'Preferencje raportowania';
$string['navmethod'] = 'Metoda nawigacji';
$string['neverdeletehistory'] = 'Nigdy nie kasuj historii';
$string['newcategory'] = 'Nowa kategoria';
$string['newitem'] = 'Nowa pozycja oceny';
$string['newoutcomeitem'] = 'Nowa pozycja efektu kształcenia';
$string['no'] = 'Nie';
$string['nocategories'] = 'Kategoria stopni nie może zostać dodana lub znaleziona dla tego kursu';
$string['nocategoryname'] = 'Nie podano nazwy kategorii';
$string['nocategoryview'] = 'Nie ma kategorii do wyświetlenia';
$string['nocourses'] = 'Nie ma jeszcze żadnych kursów';
$string['noforce'] = 'Nie wymuszaj';
$string['nogradeletters'] = 'Nie ustawiono nazw stopni';
$string['nogradesreturned'] = 'Brak stopni';
$string['noidnumber'] = 'Brak numeru ID';
$string['nolettergrade'] = 'Brak nazwy stopnia dla';
$string['nomode'] = 'Bez trybu';
$string['nonnumericweight'] = 'Otrzymano nienumeryczną wartość';
$string['nonunlockableverbose'] = 'Ta ocena nie może być odblokowana dopóki {$a->itemname} jest zablokowane.';
$string['nonweightedpct'] = 'Nieważony %';
$string['nooutcome'] = 'Brak efektu kształcenia';
$string['nooutcomes'] = 'Pozycje efektów kształcenia muszą być powiązane z efektami kształcenia dla tego kursu. Czy chcesz je dodać?';
$string['nopublish'] = 'Nie publikuj';
$string['norolesdefined'] = 'Nie zdefiniowano ról w Administracja serwisu > Oceny > Ustawienia ogólne > Oceniane role';
$string['noscales'] = 'Wyniki muszą być powiązane ze skalą kursu lub skalą globalną, ale ich nie zdefiniowano. Czy chcesz teraz dodać skalę?';
$string['noselectedcategories'] = 'nie wybrano kategorii';
$string['noselecteditems'] = 'nie wybrano pozycji';
$string['notteachererror'] = 'Tej opcji może używać tylko nauczyciel';
$string['nousersloaded'] = 'Nie załadowano żadnych użytkowników';
$string['numberofgrades'] = 'Ilość ocen';
$string['onascaleof'] = 'Na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacje';
$string['options'] = 'Opcje';
$string['others'] = 'Inne';
$string['outcome'] = 'Wynik';
$string['outcomeassigntocourse'] = 'Przypisz inny efekt kształcenia do tego kursu';
$string['outcomecategory'] = 'Utwórz efekty kształcenia w kategorii';
$string['outcomecategorynew'] = 'Nowa kategoria';
$string['outcomeconfirmdelete'] = 'Czy na pewno chcesz usunąć wynik "{$a}"?';
$string['outcomecreate'] = 'Dodaj nowy efekt kształcenia';
$string['outcomedelete'] = 'Usuń efekt kształcenia';
$string['outcomefullname'] = 'Pełna nazwa';
$string['outcome_help'] = 'To ustawienie określa efekt kształcenia, który ta ocena będzie reprezentować w dzienniku ocen.';
$string['outcomeitem'] = 'Pozycja efektu kształcenia';
$string['outcomeitemsedit'] = 'Edytuj efekt kształcenia';
$string['outcomereport'] = 'Raport efektów kształcenia';
$string['outcomes'] = 'Efekty kształcenia';
$string['outcomescourse'] = 'Efekty kształcenia użyte w kursie';
$string['outcomescoursecustom'] = 'Użyte własne (brak możliwości usunięcia)';
$string['outcomescoursenotused'] = 'Standardowy nie został użyty';
$string['outcomescourseused'] = 'Użyty standardowy (brak możliwości usunięcia)';
$string['outcomescustom'] = 'Własne efekty kształcenia';
$string['outcomeshortname'] = 'Skrócona nazwa';
$string['outcomesstandard'] = 'Standardowe efekty kształcenia';
$string['outcomesstandardavailable'] = 'Dostępne standardowe efekty kształcenia';
$string['outcomestandard'] = 'Standardowy efekt kształcenia';
$string['outcomestandard_help'] = 'Standardowy efekt kształcenia jest dostępny w całym Moodlu, dla wszystkich kursów.';
$string['overallaverage'] = 'Ogólna średnia';
$string['overridden'] = 'Nadpisane ręcznie';
$string['overridden_help'] = 'Jeśli zaznaczone, ocena nie może być zmieniona przez powiązaną z nią aktywność. Jeśli oceny są modyfikowane w raporcie ocen, pole "Nadpisana ręcznie" jest zaznaczane automatycznie. Jednakże zaznaczenie można zdjąć, aby umożliwić aktualizację oceny przez aktywność.';
$string['overriddennotice'] = 'Twoja ocena końcowa z tej aktywności została ręcznie zmieniona';
$string['overridesitedefaultgradedisplaytype'] = 'Nadpisz ustawienia domyślne witryny';
$string['overridesitedefaultgradedisplaytype_help'] = 'Jeśli zaznaczono, litery i limity punktacji stopni można ustawić w ramach kursu, zamiast używać ustawień z całej witryny.';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['pctoftotalgrade'] = '% z całości oceny';
$string['percent'] = 'procent';
$string['percentage'] = 'Procentowo';
$string['percentageletter'] = 'Procentowo (nazwa stopnia)';
$string['percentagereal'] = 'Procentowo (punkty)';
$string['percentascending'] = 'Sortuj wg procentów rosnąco';
$string['percentdescending'] = 'Sortuj wg procentów malejąco';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Poprawka';
$string['plusfactor_help'] = 'Poprawka to liczba dodawana do każdej oceny w tej pozycji po zastosowaniu mnożnika.';
$string['plusfactorvalue'] = 'Wartość przesunięcia dla {$a}';
$string['points'] = 'punkty';
$string['pointsascending'] = 'Sortuj wg punktów rosnąco';
$string['pointsdescending'] = 'Sortuj wg punktów malejąco';
$string['positionfirst'] = 'Pierwszy';
$string['positionlast'] = 'Ostatni';
$string['preferences'] = 'Preferencje';
$string['prefgeneral'] = 'Ogólny';
$string['prefletters'] = 'Nazwy stopni i granice';
$string['prefrows'] = 'Wiersze specjalne';
$string['prefshow'] = 'Pokaż / ukryj';
$string['previewrows'] = 'Podgląd wierszy';
$string['profilereport'] = 'Raport w  profilu użytkownika';
$string['profilereport_help'] = 'Raport ocen wyświetlany na stronie profilu użytkownika.';
$string['publishing'] = 'Publikowane';
$string['quickfeedback'] = 'Szybka informacja zwrotna';
$string['quickgrading'] = 'Szybkie ocenianie';
$string['quickgrading_help'] = 'Jeśli włączone, w trybie edycji każda ocena jest w polu tekstowym i może być zmieniana na tym formularzu. Zmiany są zapisywane i podświetlone, gdy przycisk aktualizacja zostanie kliknięty. Zauważ, że gdy ocena jest zmieniona w dzienniku ocen, flaga \'Nadpisane ręcznie\' jest ustawiana, co oznacza, że ocena nie może być już zmieniana z poziomu aktywności.';
$string['range'] = 'Zakres';
$string['rangedecimals'] = 'Zakres wartości dziesiętnych';
$string['rangedecimals_help'] = 'Liczba miejsc dziesiętnych do wyświetlania dla zakresu.';
$string['rangesdecimalpoints'] = 'Miejsc dziesiętnych pokazywanych w zakresie';
$string['rangesdecimalpoints_help'] = 'Ustawienie to określa liczbę miejsc po przecinku wyświetlaną w zakresie.
\'Dziedzicz\' oznacza przyjęcie ustawienia z kategorii.';
$string['rangesdisplaytype'] = 'Typ wyświetlania zakresu';
$string['rangesdisplaytype_help'] = 'To ustawienie określa, czy zakres jest wyświetlany w postaci liczbowej punktów, procentów czy liter. \'Dziedzicz\'  oznacza, że używany jest typ wyświetlania z kategorii lub elementu.';
$string['rank'] = 'Pozycja na tle grupy';
$string['rawpct'] = 'Bez ocen %';
$string['real'] = 'Punkty';
$string['realletter'] = 'Punkty (nazwa stopnia)';
$string['realpercentage'] = 'Punkty (procentowo)';
$string['recovergradesdefault'] = 'Przywracanie domyślnych ocen';
$string['recovergradesdefault_help'] = 'Przywraca domyślne stare oceny, kiedy następuje ponowne zapisanie użytkowników w kursie.';
$string['regradeanyway'] = 'Przelicz oceny mimo wszystko';
$string['removeallcoursegrades'] = 'Wymaż wszystkie oceny';
$string['removeallcourseitems'] = 'Usuń wszystkie elementy i kategorie';
$string['report'] = 'Raport';
$string['reportdefault'] = 'Raport domyślny ({$a})';
$string['reportplugins'] = 'Wtyczki raportu';
$string['reportsettings'] = 'Ustawienia raportu';
$string['reprintheaders'] = 'Powtórzenie nagłówków';
$string['respectingcurrentdata'] = 'pozostawienie obecnej konfiguracji';
$string['rowpreviewnum'] = 'Podgląd wierszy';
$string['savechanges'] = 'Zachowaj zmiany';
$string['savepreferences'] = 'Zachowaj ustawienia';
$string['scaleconfirmdelete'] = 'Czy na pewno chcesz usunąć skalę "{$a}"?';
$string['scaledpct'] = 'Skala %';
$string['seeallcoursegrades'] = 'Zobacz oceny w całym kursie';
$string['select'] = 'Wybierz {$a}';
$string['selectalloroneuser'] = 'Pokaż oceny dla wszystkich lub jednej osoby';
$string['selectauser'] = 'Wybierz użytkownika';
$string['selectdestination'] = 'Wybierz miejsce docelowe dla {$a}';
$string['separator'] = 'Separator';
$string['sepcolon'] = 'dwukropek';
$string['sepcomma'] = 'Przecinek';
$string['sepsemicolon'] = 'średnik';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Ustaw kategorię';
$string['setcategorieserror'] = 'Najpierw musisz ustawić kategorię, zanim nadasz wagi.';
$string['setgradeletters'] = 'Ustaw nazwy stopni';
$string['setpreferences'] = 'Ustaw preferencje';
$string['setting'] = 'Ustawienie';
$string['settings'] = 'Ustawienia';
$string['setweights'] = 'Ustal wagi';
$string['showactivityicons'] = 'Pokaż ikony aktywności';
$string['showactivityicons_help'] = 'Jeśli włączone ikony aktywności są wyświetlane za ich nazwami.';
$string['showallhidden'] = 'Pokaż ukryte';
$string['showallstudents'] = 'Pokaż wszystkich studentów';
$string['showanalysisicon'] = 'Pokaż ikonę analizy ocen';
$string['showanalysisicon_desc'] = 'Czy pokazywać ikonę analizy oceny domyślnie.
Jeśli moduł aktywności na to pozwala, ikona prowadzi do strony z bardziej szczegółowym wyjaśnieniem sposobu wyznaczania oceny.';
$string['showanalysisicon_help'] = 'Jeśli moduł aktywności na to pozwala, ikona prowadzi do strony z bardziej szczegółowym wyjaśnieniem sposobu wyznaczania oceny.';
$string['showaverage'] = 'Pokaż średnie';
$string['showaverage_help'] = 'Czy pokazywać kolumnę średnich? Studenci mogą być w stanie oszacować oceny innych osób, jeśli średnia jest obliczana z małej liczby ocen. Ze względu na wydajność średnia jest przybliżona, jeżeli obejmuje elementy ukryte.';
$string['showaverages'] = 'Pokaż wiersz średnich';
$string['showaverages_help'] = 'Pokazuje dodatkowy wiersz zawierający średnie z poszczególnych kolumn.';
$string['showcalculations'] = 'Pokaż obliczenia';
$string['showcalculations_help'] = 'Jeśli włączone, w trybie edycji przy każdej ocenie i kategorii widoczna jest ikona kalkulatora, która pozwala na edycję obliczeń.';
$string['showeyecons'] = 'Pokaż ikony pokazywania/ukrywania';
$string['showeyecons_help'] = 'Jeśli włączone, w trybie edycji przy każdej ocenie  widoczna jest ikona oka, która pozwala na włączanie/wyłączanie widoczności oceny dla studenta';
$string['showfeedback'] = 'Pokaż informacje zwrotne';
$string['showfeedback_help'] = 'Wyświetlić kolumnę informacji zwrotnej';
$string['showgrade'] = 'Pokaż oceny';
$string['showgrade_help'] = 'Wyświetlić kolumnę ocen?';
$string['showgroups'] = 'Pokaż grupy';
$string['showhiddenitems'] = 'Pokaż ukryte pozycje';
$string['showhiddenitems_help'] = 'Tu ustalamy, czy ukrytych oceny są całkowicie ukryte, czy nazwy ocen ukrytych są widoczne dla studentów.
* Pokaż ukryte - nazwy elementów są widoczne, ale oceny studentów są ukryte
* Ukryte dopóki - oceny są całkowicie ukryte, aż do określonego dnia, po którym są w pełni wyświetlane
* Nie pokazuj - oceny są całkowicie ukryte';
$string['showhiddenuntilonly'] = 'Ukryte dopóki';
$string['showlettergrade'] = 'Pokaż nazwy stopni';
$string['showlettergrade_help'] = 'Pokazać kolumnę z nazwą stopnia?';
$string['showlocks'] = 'Pokaż zablokowane';
$string['showlocks_help'] = 'Jeśli włączone, w trybie edycji przy każdej ocenie i kategorii widoczna jest ikona kłódki, która określa, czy ocena może być automatycznie uaktualniana przez aktywność, z której pochodzi.';
$string['shownohidden'] = 'Nie pokazuj';
$string['shownooutcomes'] = 'Ukryj efekty kształcenia';
$string['shownumberofgrades'] = 'Pokaż liczbę ocen w średniej';
$string['shownumberofgrades_help'] = 'Liczba ocen składowych do obliczenia średniej jest wyświetlana w nawiasach po każdej średniej.';
$string['showonlyactiveenrol'] = 'Pokaż tylko aktywne rejestracje';
$string['showonlyactiveenrol_help'] = 'To ustawienie określa, czy tylko aktywni spośród zapisanych użytkowników powinni być widoczni w raporcie dziennika ocen. Jeżeli włączono, zawieszeni użytkownicy nie będą pokazywani w dzienniku ocen.';
$string['showpercentage'] = 'Pokaż procentowo';
$string['showpercentage_help'] = 'Pokazać wartość procentową przy każdej pozycji oceny?';
$string['showquickfeedback'] = 'Pokaz szybką informację zwrotną';
$string['showquickfeedback_help'] = 'Jeśli włączone, w trybie edycji przy każdej ocenie pojawia się pole w kropkowanej ramce, w której można wpisywać informację zwrotną na temat oceny. Zmiany są zapisywane i podświetlane po naciśnięciu klawisza uaktualnienia.
 Zauważ, że gdy ocena jest zmieniona w dzienniku ocen, flaga \'Nadpisane ręcznie\' jest ustawiana, co oznacza, że ocena nie może być już zmieniana z poziomu aktywności.';
$string['showrange'] = 'Pokaż zakresy';
$string['showrange_help'] = 'Czy wyświetlić kolumnę zakresów?';
$string['showranges'] = 'Pokaż zakresy';
$string['showranges_help'] = 'Jeśli opcja jest włączona, raport nauczyciela będzie zawierać dodatkowy wiersz pokazujący zakres dla każdej kategorii i pozycji.';
$string['showrank'] = 'Pokaż pozycję';
$string['showrank_help'] = 'Pokaż miejsce w kolejności, jakie daje dana ocena wśród wszystkich ocen za ten element.';
$string['showuserimage'] = 'Pokaż zdjęcia użytkowników';
$string['showuserimage_help'] = 'Czy pokazywać obrazek/fotografię użytkownika obok jego nazwiska w raporcie ocen.';
$string['showverbose'] = 'Pokaż  {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Pokaż wagi';
$string['showweight_help'] = 'Pokazywać kolumnę wag?';
$string['simpleview'] = 'Widok prosty';
$string['sitewide'] = 'W skali całej platformy';
$string['sort'] = 'Sortuj';
$string['sortasc'] = 'Sortuj rosnąco';
$string['sortbyfirstname'] = 'Sortuj wg imienia';
$string['sortbylastname'] = 'Sortuj wg nazwiska';
$string['sortdesc'] = 'Sortuj malejąco';
$string['standarddeviation'] = 'Odchylenie standardowe';
$string['stats'] = 'Statystyka';
$string['statslink'] = 'Statys';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Studentów na stronę';
$string['studentsperpage_help'] = 'Ilość studentów wyświetlanych na jednej stronie w raporcie dziennika.';
$string['studentsperpagereduced'] = 'Obniżono max. ilość studentów na stronie z {$a->originalstudentsperpage} na {$a->studentsperpage}. Należy rozważyć zwiększenie ustawienia max_input_vars z {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategoria';
$string['submissions'] = 'Oddane prace';
$string['submittedon'] = 'Oddano: {$a}';
$string['switchtofullview'] = 'Przełącz do pełnego widoku';
$string['switchtosimpleview'] = 'Przełącz do widoku prostego';
$string['tabs'] = 'Karty';
$string['topcategory'] = 'Kategoria nadrzędna';
$string['total'] = 'Ogólnie';
$string['totalweight100'] = 'Suma wag jest równa 100';
$string['totalweightnot100'] = 'Suma wag nie jest równa 100';
$string['turnfeedbackoff'] = 'Wyłącz informację zwrotną';
$string['turnfeedbackon'] = 'Włącz informację zwrotną';
$string['typenone'] = 'żaden';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'To ustawienie określa użytą skalę ocen. Skali elementu związanego z aktywnością zdefiniowana jest na stronie ustawień tej aktywności.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Wartość';
$string['uncategorised'] = 'Bez kategorii';
$string['unchangedgrade'] = 'Ocena niezmieniona';
$string['unenrolledusersinimport'] = 'Import obejmował następujące oceny  użytkowników, którzy nie są obecnie zapisani w tym kursie: {$a}';
$string['unlimitedgrades'] = 'Oceny bez ograniczenia';
$string['unlimitedgrades_help'] = 'Normalnie ocena ograniczona jest do określonego zakresu (maksimum, minimum). Włączenie tej opcji znosi to ograniczenie tak, można bezpośrednio w dzienniku ocen wprowadzić ocenę np. ponad 100%. Zaleca się, by ta opcja była włączona w czasie poza szczytem obciążenia, ponieważ powoduje przeliczanie wszystkich ocen, co może wiązać się z wysokim obciążeniem serwera.';
$string['unlock'] = 'Odblokuj';
$string['unlockverbose'] = 'Odblokuj {$a->category} {$a->itemmodule}  {$a->itemname}';
$string['unused'] = 'Nieużywane';
$string['updatedgradesonly'] = 'Eksportuj tylko nowe lub zaktualizowane oceny';
$string['uploadgrades'] = 'Prześlij oceny';
$string['useadvanced'] = 'Użyj zaawansowanych cech';
$string['usedcourses'] = 'Używane kursy';
$string['usedgradeitem'] = 'Używane pozycje oceny';
$string['usenooutcome'] = 'Nie używaj efektów kształcenia';
$string['usenoscale'] = 'Nie używaj skali';
$string['usepercent'] = 'Użyj procentów';
$string['user'] = 'Użytkownik';
$string['userenrolmentsuspended'] = 'Zapisy użytkowników zostały zawieszone';
$string['usergrade'] = 'Użytkownik {$a->fullname} ({$a->useridnumber}) w {$a->gradeidnumber}';
$string['userid'] = 'ID użytkownika';
$string['usermappingerror'] = 'Błąd mapowania użytkownika: Nie można znaleźć użytkownika {$a->field} z "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Użytkownik nie jest członkiem bieżącej grupy.';
$string['usermappingerrorusernotfound'] = 'Błąd mapowania użytkownika: Nie można znaleźć użytkownika.';
$string['userpreferences'] = 'Preferencje użytkownika';
$string['useweighted'] = 'Użyj wag';
$string['verbosescales'] = 'słowna skale ocen';
$string['viewbygroup'] = 'Grupa';
$string['viewgrades'] = 'Podgląd ocen';
$string['warningexcludedsum'] = 'Ostrzeżenie: wykluczanie ocen nie jest zgodne z agregacją typu suma.';
$string['weight'] = 'wagi';
$string['weightcourse'] = 'Użyj w kursie ocen ważonych';
$string['weightedascending'] = 'Sortuj wg ważonych procentów rosnąco';
$string['weighteddescending'] = 'Sortuj wg ważonych procentów malejąco';
$string['weightedpct'] = 'ważone %';
$string['weightedpctcontribution'] = 'udział % wag';
$string['weightorextracredit'] = 'Waga lub extra kredyt';
$string['weights'] = 'Wagi';
$string['weightsedit'] = 'Edytuj wagę lub extra kredyt';
$string['weightuc'] = 'Waga';
$string['writinggradebookinfo'] = 'Zapisz ustawienia dziennika ocen';
$string['xml'] = 'XML';
$string['yes'] = 'Tak';
$string['yourgrade'] = 'Twoja ocena';
