<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Controlo de acessos';
$string['actionaftercorrectanswer'] = 'Ação após resposta correta';
$string['actionaftercorrectanswer_help'] = 'Após responder corretamente a uma pergunta, existem 3 opções quanto à sequência da lição:

* Normal - conforme sequência da lição
* Mostrar página não vista - As páginas são exibidas de forma aleatória sem que a mesma página seja exibida duas vezes
* Mostrar página não respondida - As páginas são exibidas de forma aleatória, sendo as perguntas não respondidas exibidas novamente';
$string['actions'] = 'Ações';
$string['activitylink'] = 'Hiperligação para a próxima atividade';
$string['activitylink_help'] = 'Mostra um link no final duma lição para outra atividade da disciplina. Selecione a atividade na caixa de seleção..';
$string['activitylinkname'] = 'Ir para: {$a}';
$string['activityoverview'] = 'Atenção às suas Lições! Clique aqui para mais informações.';
$string['addabranchtable'] = 'Inserir página de conteúdo';
$string['addanendofbranch'] = 'Inserir fim de sequência';
$string['addanewpage'] = 'Inserir nova página';
$string['addaquestionpage'] = 'Inserir página de pergunta';
$string['addaquestionpagehere'] = 'Inserir página de pergunta aqui';
$string['addbranchtable'] = 'Inserir página de conteúdo';
$string['addcluster'] = 'Inserir início de grupo';
$string['addedabranchtable'] = 'Página conteúdo inserida';
$string['addedanendofbranch'] = 'Fim de sequência inserido';
$string['addedaquestionpage'] = 'Página de pergunta inserida';
$string['addedcluster'] = 'Início de grupo inserido';
$string['addedendofcluster'] = 'Fim de grupo inserido';
$string['addendofcluster'] = 'Inserir fim de grupo';
$string['addpage'] = 'Inserir página';
$string['anchortitle'] = 'Início do conteúdo principal';
$string['and'] = 'E';
$string['answer'] = 'Resposta';
$string['answeredcorrectly'] = 'respondida(s) corretamente.';
$string['answersfornumerical'] = 'As respostas a perguntas numéricas devem coincidir com pares de valores máximos e mínimos';
$string['arrangebuttonshorizontally'] = 'Alinhar os botões horizontalmente?';
$string['attempt'] = 'Tentativa: {$a}';
$string['attempts'] = 'Tentativas';
$string['attemptsdeleted'] = 'Tentativas apagadas';
$string['attemptsremaining'] = 'Ainda pode realizar {$a} tentativa(s)';
$string['available'] = 'Disponível a partir de';
$string['averagescore'] = 'Pontuação média';
$string['averagetime'] = 'Tempo médio';
$string['branch'] = 'Botão';
$string['branchtable'] = 'Página de conteúdo';
$string['cancel'] = 'Cancelar';
$string['cannotfindanswer'] = 'Erro: não foi possível encontrar a resposta';
$string['cannotfindattempt'] = 'Erro: não foi possível encontrar a tentativa';
$string['cannotfindessay'] = 'Erro: não foi possível encontrar o desenvolvimento';
$string['cannotfindfirstgrade'] = 'Erro: não foi possível encontrar as notas';
$string['cannotfindfirstpage'] = 'Não foi possível encontrar a primeira página';
$string['cannotfindgrade'] = 'Erro: não foi possível encontrar as notas';
$string['cannotfindnewestgrade'] = 'Erro: não foi possível encontrar a nota mais recente';
$string['cannotfindnextpage'] = 'Cópia de segurança da lição: Não foi encontrada a página seguinte!';
$string['cannotfindpagerecord'] = 'Inserir fim de sequência: a página não foi encontrada';
$string['cannotfindpages'] = 'Não foi possível encontrar as páginas da lição';
$string['cannotfindpagetitle'] = 'Confirmar eliminação: o título da página não foi encontrado';
$string['cannotfindpreattempt'] = 'Não foi encontrado o registo da tentativa anterior!';
$string['cannotfindrecords'] = 'Erro: não foi possível encontrar registos da lição';
$string['cannotfindtimer'] = 'Erro: não foi possível encontrar tempos de realização da lição';
$string['cannotfinduser'] = 'Erro: não foi possível encontrar utilizadores';
$string['canretake'] = '{$a} pode repetir';
$string['casesensitive'] = 'Usar regular expressions';
$string['casesensitive_help'] = 'Se ativar esta opção pode definir as respostas possíveis usando regular expressions para maior flexibilidade na análise das respostas dos alunos';
$string['checkbranchtable'] = 'Assinalar página de conteúdo';
$string['checkedthisone'] = 'Assinalou este.';
$string['checknavigation'] = 'Assinalar navegação';
$string['checkquestion'] = 'Assinalar pergunta';
$string['classstats'] = 'Estatísticas da turma';
$string['clicktodownload'] = 'Clique no link seguinte para descarregar o ficheiro.';
$string['clicktopost'] = 'Clique aqui para incluir a sua nota na lista das melhores pontuações.';
$string['cluster'] = 'Grupo';
$string['clusterjump'] = 'Pergunta não vista dentro do grupo';
$string['clustertitle'] = 'Grupo';
$string['collapsed'] = 'Contraído';
$string['comments'] = 'Os seus comentários';
$string['completed'] = 'Completou';
$string['completederror'] = 'Completar a lição';
$string['completethefollowingconditions'] = 'Tem de completar as seguintes condições na lição <b>{$a}</b> antes de poder continuar.';
$string['conditionsfordependency'] = 'Condições de dependência';
$string['configactionaftercorrectanswer'] = 'Ação após uma resposta correta, por predefinição';
$string['configmaxanswers'] = 'Número máximo de respostas por página, por predefinição';
$string['configmaxhighscores'] = 'Número de melhores notas exibidas';
$string['configmediaclose'] = 'Exibe um botão de fechar na janela de pop-up do conteúdo de suporte';
$string['configmediaheight'] = 'Define a altura da janela de pop-up do conteúdo de suporte';
$string['configmediawidth'] = 'Define a largura da janela de pop-up do conteúdo de suporte';
$string['configslideshowbgcolor'] = 'Cor de fundo para a apresentação de slides, se ativa';
$string['configslideshowheight'] = 'Define a altura da apresentação de slides, se ativa';
$string['configslideshowwidth'] = 'Define a largura da apresentação de slides, se ativa';
$string['confirmdelete'] = 'Apagar página';
$string['confirmdeletionofthispage'] = 'Deseja apagar esta página?';
$string['congratulations'] = 'Parabéns - chegou ao fim da lição';
$string['continue'] = 'Continuar';
$string['continuetoanswer'] = 'Continuar para alterar respostas.';
$string['continuetonextpage'] = 'Continuar para a página seguinte';
$string['correctanswerjump'] = 'Seguir para, se resposta correta';
$string['correctanswerscore'] = 'Pontuação da resposta correta';
$string['correctresponse'] = 'Feedback da resposta correta';
$string['createaquestionpage'] = 'Criar uma página de pergunta';
$string['credit'] = 'Crédito';
$string['customscoring'] = 'Pontuação ajustável';
$string['customscoring_help'] = 'Se ativar esta opção, pode atribuir a cada resposta uma pontuação numérica (positivo ou negativo).';
$string['deadline'] = 'Até';
$string['defaultessayresponse'] = 'A sua resposta à pergunta de desenvolvimento será avaliada pelo professor.';
$string['deleteallattempts'] = 'Apagar todas as tentativas de realização da lição';
$string['deletedefaults'] = 'Foram apagados {$a} x valores por predefinição da lição';
$string['deletedpage'] = 'A página foi apagada';
$string['deleting'] = 'A apagar';
$string['deletingpage'] = 'A apagar página: {$a}';
$string['dependencyon'] = 'Dependente de';
$string['dependencyon_help'] = 'Esta opção permite que o acesso a esta lição dependa do desempenho do aluno noutra lição da mesma disciplina. Como critério pode ser usada qualquer combinação entre o tempo despendido, se completou a lição ou "nota melhor que".';
$string['description'] = 'Descrição';
$string['detailedstats'] = 'Estatísticas detalhadas';
$string['didnotanswerquestion'] = 'Não respondeu a esta pergunta';
$string['didnotreceivecredit'] = 'Não obteve qualquer pontuação';
$string['displaydefaultfeedback'] = 'Usar feedback predefinido';
$string['displaydefaultfeedback_help'] = 'Se ativar esta opção, quando um feedback não é definido numa pergunta em particular, é exibido o feedback predefinido "A resposta está correta" ou a "A resposta está errada".';
$string['displayhighscores'] = 'Exibir melhores notas';
$string['displayinleftmenu'] = 'Exibir no menu à esquerda?';
$string['displayleftif'] = 'Exibir menu apenas se a nota for superior a';
$string['displayleftif_help'] = 'Esta opção determina se um aluno deve obter uma determinada nota para poder visualizar o menu à esquerda. Isso obriga o aluno a percorrer toda a lição na primeira tentativa e depois de obter a nota exigida, pode usar o menu à esquerdo para rever a lição.';
$string['displayleftmenu'] = 'Exibir menu à esquerda';
$string['displayleftmenu_help'] = 'Se ativar está opção, será exibida uma lista das páginas da lição';
$string['displayofgrade'] = 'Exibição da nota (apenas para alunos)';
$string['displayreview'] = 'Mostrar botão para voltar a responder';
$string['displayreview_help'] = 'Se ativar esta opção, quando uma pergunta é respondida de forma incorreta, é dado a escolher ao aluno se quer responder de novo sem obter a pontuação ou continuar a lição';
$string['displayscorewithessays'] = 'Obteve {$a->score} num máximo de {$a->tempmaxgrade}.<br />As suas respostas à(s) pergunta(s) de desenvolvimento {$a->essayquestions resposta(s)} serão avaliadas posteriormente,<br />sendo a pontuação correspondente adicionada à pontuação final.<br /><br />A sua classificação atual, sem as perguntas que faltam avaliar, é de  {$a->score} num máximo de {$a->grade}.';
$string['displayscorewithoutessays'] = 'Obteve uma pontuação de {$a->score} (em {$a->grade}). Clique em Ver notas para ver a sua nota final na pauta';
$string['edit'] = 'Editar';
$string['editingquestionpage'] = 'A editar página de pergunta {$a}';
$string['editlessonsettings'] = 'Editar configurações da lição';
$string['editpage'] = 'Editar';
$string['editpagecontent'] = 'Editar';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Enviar por e-mail TODAS as perguntas de desenvolvimento avaliadas';
$string['emailgradedessays'] = 'Enviar por e-mail as perguntas de desenvolvimento avaliadas';
$string['emailsuccess'] = 'E-mails enviados com sucesso';
$string['emptypassword'] = 'A palava-chave não pode estar em branco';
$string['endofbranch'] = 'Fim da sequência';
$string['endofcluster'] = 'Fim do grupo';
$string['endofclustertitle'] = 'Fim do grupo';
$string['endoflesson'] = 'Fim da lição';
$string['enteredthis'] = 'introduziu isto.';
$string['entername'] = 'Introduza um nickname para a lista de melhores notas';
$string['enterpassword'] = 'Introduza a senha:';
$string['eolstudentoutoftime'] = 'Atenção: Terminou o tempo disponível para realizar esta lição. A sua última resposta poderá não ter sido considerada caso tenha sido dada depois do fim do tempo.';
$string['eolstudentoutoftimenoanswers'] = 'Não respondeu a nenhuma pergunta. Obteve uma classificação de 0 para esta lição.';
$string['essay'] = 'Desenvolvimento';
$string['essayemailmessage'] = '<p>Pergunta de desenvolvimento:<blockquote>{$a->question}</blockquote></p>
<p>A sua resposta:<blockquote><em>{$a->response}</em></blockquote></p>
<p>{$a->teacher}->Comentário do professor:<blockquote><em>{$a->comment}</em></blockquote></p>
<p>Obteve {$a->earned} (num máximo de{$a->outof}) nesta pergunta de desenvolvimento.</p><p>
A sua nota da lição foi atualizada para {$a->newgrade}&#37;.</p>';
$string['essayemailmessage2'] = '<p>Pergunta de desenvolvimento:<blockquote>{$a->question}</blockquote></p><p>A sua resposta:<blockquote><em>{$a->response}</em></blockquote></p><p>Comentários da avaliação:<blockquote><em>{$a->comment}</em></blockquote></p><p>Obteve {$a->earned} num máximo de {$a->outof} nesta pergunta de desenvolvimento.</p><p>A sua nota da lição foi atualizada para {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'A sua nota da pergunta {$a}';
$string['essays'] = 'Perguntas de desenvolvimento';
$string['essayscore'] = 'Nota da pergunta de desenvolvimento';
$string['fileformat'] = 'Formato de ficheiro';
$string['finish'] = 'Terminar';
$string['firstanswershould'] = 'A primeira resposta deverá seguir para a página "correta".';
$string['firstwrong'] = 'Infelizmente não obteve pontuação nesta pergunta, pois a sua resposta não está correta. Gostaria de tentar responder novamente, apenas para efeitos de aprendizagem, pois esta tentativa não contará para avaliação?';
$string['flowcontrol'] = 'Opções de controlo';
$string['full'] = 'Expandido';
$string['general'] = 'Geral';
$string['gotoendoflesson'] = 'Ir para o fim da lição';
$string['grade'] = 'Nota';
$string['gradebetterthan'] = 'Nota maior que (&#37;)';
$string['gradebetterthanerror'] = 'Obtenha uma nota melhor que {$a} %';
$string['gradeessay'] = 'Avaliar perguntas de desenvolvimento ({$a->notgradedcount} por avaliar e {$a->notsentcount} por enviar)';
$string['gradeis'] = 'A nota é {$a}';
$string['gradeoptions'] = 'Opções de avaliação';
$string['handlingofretakes'] = 'Tratamento das Repetições';
$string['handlingofretakes_help'] = 'Se permitir repetições, esta opção define se a nota da lição é a média ou máxima de todas as notas obtidas nas várias repetições da lição.';
$string['havenotgradedyet'] = 'Ainda não avaliou.';
$string['here'] = 'aqui';
$string['highscore'] = 'Melhor nota';
$string['highscores'] = 'Melhores notas';
$string['hightime'] = 'Tempo máximo';
$string['importcount'] = 'A importar {$a} perguntas';
$string['importquestions'] = 'Importar questões';
$string['importquestions_help'] = 'Esta opção permite importar perguntas de vários formatos a partir de um ficheiro de texto.';
$string['insertedpage'] = 'Página inserida';
$string['invalidfile'] = 'Ficheiro inválido';
$string['invalidid'] = 'Não foi especificado nenhum ID do módulo ou da lição';
$string['invalidlessonid'] = 'ID da lição incorreto';
$string['invalidpageid'] = 'ID da página inválido';
$string['jump'] = 'Seguir para';
$string['jumps'] = 'Segue para';
$string['jumps_help'] = 'Cada resposta (para as perguntas) ou descrição (para as páginas de conteúdo) seguem para uma página específica. A página seguinte pode ser definida de forma relativa, como \'Esta página\' ou \'Página seguinte\', ou absoluta, especificando uma das páginas da lição.';
$string['jumpsto'] = 'Segue para <em>{$a}</em>';
$string['leftduringtimed'] = 'Interrompeu uma lição com tempo limite.<br />Clique em Continuar para reiniciar à lição.';
$string['leftduringtimednoretake'] = 'Interrompeu uma lição com tempo limite<br />e não é permitido repetir ou continuar a lição.';
$string['leftduringtimedsession'] = 'Saiu durante uma lição com tempo limite';
$string['lesson:addinstance'] = 'Adicionar nova lição';
$string['lessonattempted'] = 'Lição frequentada';
$string['lessonclosed'] = 'Esta lição fechou em {$a}';
$string['lessoncloses'] = 'A lição fecha';
$string['lessoncloseson'] = 'A lição fecha em {$a}';
$string['lesson:edit'] = 'Editar uma lição';
$string['lessonformating'] = 'Formatação da lição';
$string['lesson:manage'] = 'Gerir uma lição';
$string['lessonmenu'] = 'Menu da lição';
$string['lessonnotready'] = 'Esta lição não está pronta para ser realizada. Contacte o seu {$a}.';
$string['lessonnotready2'] = 'A lição ainda não está disponível.';
$string['lessonopen'] = 'Esta lição ficará disponível em {$a}.';
$string['lessonopens'] = 'A lição abre';
$string['lessonpagelinkingbroken'] = 'Não foi encontrada a primeira página. As ligações entre páginas da lição poderão estar erradas. Contacte um administrador.';
$string['lessonstats'] = 'Estatísticas da lição';
$string['linkedmedia'] = 'Conteúdo de suporte';
$string['loginfail'] = 'A autenticação falhou. Tente de novo...';
$string['lowscore'] = 'Nota mais baixa';
$string['lowtime'] = 'Tempo mínimo';
$string['manualgrading'] = 'Avaliar perguntas de desenvolvimento';
$string['matchesanswer'] = 'Corresponde a';
$string['matching'] = 'Correspondência';
$string['matchingpair'] = 'Par de correspondência {$a}';
$string['maxgrade'] = 'Nota máxima';
$string['maxgrade_help'] = 'Esta opção define a nota máxima para a lição. Se o valor for 0, a lição não aparece no relatório de avaliação.';
$string['maxhighscores'] = 'Número de melhores notas exibidas';
$string['maximumnumberofanswersbranches'] = 'Número máximo de opções de resposta';
$string['maximumnumberofanswersbranches_help'] = 'Esta opção define o número máximo de opções de resposta que podem ser definidas nas perguntas da Lição. Se forem usadas apenas perguntas do tipo Verdadeiro/Falso, o número máximo de opções de resposta pode ser configurado para 2. Pode alterar esta opção a qualquer momento uma vez que afeta apenas o que o professor vê, e não a informação já guardada.';
$string['maximumnumberofattempts'] = 'Número máximo de tentativas';
$string['maximumnumberofattempts_help'] = 'Esta opção define o número máximo de tentativas permitidas para responder a uma pergunta. Se responder repetidamente de forma incorreta, quando o máximo de tentativas é atingido a lição passa automaticamente para a página seguinte.';
$string['maximumnumberofattemptsreached'] = 'Atingiu o número máximo de tentativas permitido - A lição vai avançar para a página seguinte';
$string['maxtime'] = 'Tempo limite (em minutos)';
$string['maxtimewarning'] = 'Tem {$a} minuto(s) para terminar a lição.';
$string['mediaclose'] = 'Mostrar botão de fechar:';
$string['mediafile'] = 'Ficheiro de pop-up';
$string['mediafile_help'] = 'Para incluir uma janela de pop-up no início da lição, escolha o ficheiro a exibir. Todas as páginas da lição incluirão um link para reabrir o pop-up, se necessário.';
$string['mediafilepopup'] = 'Clique aqui para ver';
$string['mediaheight'] = 'Altura da janela:';
$string['mediawidth'] = 'Largura da janela:';
$string['messageprovider:graded_essay'] = 'Notificações sobre avaliação de perguntas de desenvolvimento';
$string['minimumnumberofquestions'] = 'Número mínimo de perguntas';
$string['minimumnumberofquestions_help'] = 'Esta opção define o número mínimo de perguntas que será usado para calcular a nota da atividade. Se a lição contém uma ou mais páginas de conteúdo, o número mínimo de perguntas deve ser definido como zero.

Se, por exemplo, selecionar 20, será aconselhável inserir o seguinte texto na página inicial da lição: "Nesta lição deverá responder a pelo menos 20 perguntas. Poderá tentar responder a mais se desejar, no entanto se responder a menos de 20 a sua nota será calculada como se tivesse respondido a 20."';
$string['missingname'] = 'Introduza um nickname';
$string['modattempts'] = 'Permitir revisão';
$string['modattempts_help'] = 'Se ativar esta opção, os alunos podem navegar novamente pela lição desde o início.';
$string['modattemptsnoteacher'] = 'A possibilidade de revisão só funciona para os alunos.';
$string['modulename'] = 'Lição';
$string['modulename_help'] = 'A atividade Lição permite aos professores criarem uma experiência de aprendizagem interessante e adaptável.

A Lição é constituída por uma série de páginas com conteúdo em que cada página pode terminar com uma pergunta. Os tipos de pergunta podem ser de escolha múltipla, correspondência ou resposta curta. Dependendo da escolha correta ou não do aluno, este avança para a página seguinte ou retrocede para a anterior.

Uma lição pode ser avaliada ou ser apenas de treino, sem pontuação.

As Lições podem ser utilizadas:

* Para a aprendizagem de um conteúdo específico;
* Para simulações e exercícios de tomada de decisão;
* Como um meio para proporcionar conteúdos para diferentes estilos de aprendizagem. Por exemplo, os alunos podem optar, de acordo com a sua preferência, por uma página de vídeo, podcast ou texto;
* Para revisão de conhecimentos adaptados ao nível de conhecimento de cada aluno, com diferentes conjuntos de perguntas que são exibidas em função das respostas dadas às perguntas iniciais.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lições';
$string['move'] = 'Mover página';
$string['movedpage'] = 'Página movida';
$string['movepagehere'] = 'Mover página para aqui';
$string['moving'] = 'A mover página: {$a}';
$string['multianswer'] = 'Respostas múltiplas';
$string['multianswer_help'] = 'Ative esta opção se a resposta correta for uma combinação de várias opções de resposta.';
$string['multichoice'] = 'Escolha múltipla';
$string['multipleanswer'] = 'Resposta múltipla';
$string['nameapproved'] = 'O nome foi aprovado';
$string['namereject'] = 'O seu nome foi rejeitado pelo filtro.<br />Tente outro nome.';
$string['new'] = 'novo';
$string['nextpage'] = 'Página seguinte';
$string['noanswer'] = 'Uma ou mais perguntas estão ainda por responder. Por favor, volte atrás e submeta uma resposta.';
$string['noattemptrecordsfound'] = 'Não foram encontrados registos de tentativas: não foi atribuída nota';
$string['nobranchtablefound'] = 'Não foi encontrada nenhuma página de conteúdo';
$string['nocommentyet'] = 'Sem comentário.';
$string['nocoursemods'] = 'Não foram encontradas quaisquer atividades';
$string['nocredit'] = 'Sem crédito';
$string['nodeadline'] = 'Sem prazo limite';
$string['noessayquestionsfound'] = 'Não foram encontradas perguntas de desenvolvimento nesta lição.';
$string['nohighscores'] = 'Não há melhores notas';
$string['nolessonattempts'] = 'Não houve tentativas de realização desta lição.';
$string['nooneansweredcorrectly'] = 'Ninguém respondeu corretamente.';
$string['nooneansweredthisquestion'] = 'Ninguém respondeu a esta pergunta.';
$string['noonecheckedthis'] = 'Ninguém assinalou esta opção.';
$string['nooneenteredthis'] = 'Ninguém introduziu isto.';
$string['noonehasanswered'] = 'Ninguém respondeu a uma pergunta de desenvolvimento.';
$string['noretake'] = 'Não pode repetir esta lição.';
$string['normal'] = 'Normal - conforme sequência da lição';
$string['notcompleted'] = 'Incompleta';
$string['notdefined'] = 'Indefinido(a)';
$string['nothighscore'] = 'Não conseguiu fazer parte da lista das {$a} melhores notas.';
$string['notitle'] = 'Sem título';
$string['numberofcorrectanswers'] = 'Número de respostas corretas: {$a}';
$string['numberofcorrectmatches'] = 'Número de correspondências corretas: {$a}';
$string['numberofpagestoshow'] = 'Número de páginas a mostrar';
$string['numberofpagestoshow_help'] = 'Esta opção define o número de páginas exibidas numa lição. Apenas é aplicável em lições em que as páginas são exibidas aleatoriamente (quando a opção "Ação após resposta correta" está configurada como "Mostrar página não vista" ou "Mostrar página não respondida"). Se selecionar o valor 0 todas as páginas serão exibidas.';
$string['numberofpagesviewed'] = 'Perguntas respondidas: {$a}';
$string['numberofpagesviewednotice'] = 'Perguntas respondidas: {$a->nquestions}; (Deve responder pelo menos a: {$a->minquestions})';
$string['numerical'] = 'Numérica';
$string['ongoing'] = 'Exibir avaliação no decorrer da lição';
$string['ongoingcustom'] = 'Tem {$a->score} ponto(s) num máximo de {$a->currenthigh}.';
$string['ongoing_help'] = 'Se ativar esta opção, cada página da lição exibirá a pontuação obtida pelo aluno e a máxima possível de obter na lição.';
$string['ongoingnormal'] = 'Respondeu corretamente a {$a->correct} de {$a->viewed} perguntas.';
$string['onpostperpage'] = 'Apenas um registo por nota';
$string['options'] = 'Opções';
$string['or'] = 'OU';
$string['ordered'] = 'Por ordem';
$string['other'] = 'Outras Opções';
$string['outof'] = 'Em {$a}';
$string['overview'] = 'Perspetiva global';
$string['overview_help'] = 'Uma lição é uma atividade constituída por um conjunto de páginas. Cada página contém um determinado conteúdo e geralmente termina com uma pergunta. Associada a cada resposta está uma página para onde a lição segue. A página a seguir pode ser definida de forma relativa, para a mesma página ou para a seguinte, ou absoluta, seguindo para qualquer outra página na lição. A página de conteúdo é que contém um conjunto de botões para navegar para outras páginas na lição, que serve por exemplo de menu/índice da lição.';
$string['page'] = 'Página: {$a}';
$string['pagecontents'] = 'Conteúdo';
$string['page-mod-lesson-edit'] = 'Editar página da lição';
$string['page-mod-lesson-view'] = 'Ver ou pré-visualizar página';
$string['page-mod-lesson-x'] = 'Qualquer página da lição';
$string['pages'] = 'Páginas';
$string['pagetitle'] = 'Título da página';
$string['password'] = 'Senha';
$string['passwordprotectedlesson'] = '{$a} é uma lição protegida por senha.';
$string['pleasecheckoneanswer'] = 'Assinale uma resposta';
$string['pleasecheckoneormoreanswers'] = 'Assinale pelo menos uma resposta';
$string['pleaseenteryouranswerinthebox'] = 'Introduza a resposta na caixa';
$string['pleasematchtheabovepairs'] = 'Estabeleça a correspondência entre os pares';
$string['pluginadministration'] = 'Administração da lição';
$string['pluginname'] = 'Lição';
$string['pointsearned'] = 'Pontos obtidos';
$string['postprocesserror'] = 'Ocorreu um erro durante o pós-processamento!';
$string['postsuccess'] = 'Mensagem enviada com sucesso';
$string['practice'] = 'Lição de treino';
$string['practice_help'] = 'Uma lição de treino é apenas para aprender e a sua avaliação não aparece no relatório de avaliação nem  influencia a nota final do aluno.';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['prerequisitelesson'] = 'Pré-requisitos da lição';
$string['preview'] = 'Pré-visualizar';
$string['previewlesson'] = 'Pré-visualizar {$a}';
$string['previouspage'] = 'Página anterior';
$string['processerror'] = 'Ocorreu um erro durante o processo!';
$string['progressbar'] = 'Barra de progresso';
$string['progressbar_help'] = 'Se ativar esta opção, é exibida uma barra de progresso no fim da página da lição mostrando a percentagem aproximada de conclusão.';
$string['progressbarteacherwarning'] = 'A barra de progresso não é exibida para {$a}';
$string['progressbarteacherwarning2'] = 'Não vê a barra de progresso porque pode editar esta lição';
$string['progresscompleted'] = 'Completou {$a}% da lição';
$string['qtype'] = 'Tipo de Página';
$string['question'] = 'Inserir página de pergunta';
$string['questionoption'] = 'Opção de pergunta';
$string['questiontype'] = 'Tipo de pergunta';
$string['randombranch'] = 'Página de conteúdo aleatória';
$string['randompageinbranch'] = 'Pergunta aleatória da sequência';
$string['rank'] = 'Posição';
$string['rawgrade'] = 'Nota bruta';
$string['receivedcredit'] = 'Crédito obtido';
$string['redisplaypage'] = 'Voltar a exibir a página';
$string['report'] = 'Relatório';
$string['reports'] = 'Relatórios';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Permitir repetição';
$string['retakesallowed_help'] = 'Se ativar esta opção, os alunos podem fazer a lição mais que uma vez.';
$string['returnto'] = 'Voltar a {$a}';
$string['returntocourse'] = 'Voltar à disciplina';
$string['review'] = 'Revisão';
$string['reviewlesson'] = 'Rever lição';
$string['reviewquestionback'] = 'Sim, quero tentar novamente';
$string['reviewquestioncontinue'] = 'Não, quero avançar para a pergunta seguinte';
$string['sanitycheckfailed'] = 'Falha na verificação: esta tentativa foi apagada';
$string['savechanges'] = 'Gravar alterações';
$string['savechangesandeol'] = 'Gravar todas as alterações e ir para o fim da lição.';
$string['savepage'] = 'Guardar página';
$string['score'] = 'Nota';
$string['score_help'] = 'A pontuação só é usada quando a pontuação personalizada está ativada. A cada resposta poderá ser dada uma pontuação numérica (positiva ou negativa).';
$string['scores'] = 'Notas';
$string['secondpluswrong'] = 'Resposta incorreta. Quer voltar a tentar?';
$string['selectaqtype'] = 'Selecione tipo de pergunta';
$string['shortanswer'] = 'Resposta curta';
$string['showanunansweredpage'] = 'Mostrar página não respondida';
$string['showanunseenpage'] = 'Mostrar página não vista';
$string['singleanswer'] = 'Resposta única';
$string['skip'] = 'Ignorar navegação';
$string['slideshow'] = 'Apresentação de slides';
$string['slideshowbgcolor'] = 'Cor de fundo da apresentação de slides';
$string['slideshowheight'] = 'Altura da apresentação de slides';
$string['slideshow_help'] = 'Se ativar esta opção, a lição é exibida como uma apresentação de slides com um ecrã com uma largura e altura predefinidas.';
$string['slideshowwidth'] = 'Largura da apresentação de slides';
$string['startlesson'] = 'Iniciar lição';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} tentativa número {$a->attempt}';
$string['studentname'] = '{$a} Nome';
$string['studentoneminwarning'] = 'Aviso: Tem um minuto ou menos para terminar a lição.';
$string['studentresponse'] = 'Resposta de {$a}';
$string['submit'] = 'Submeter';
$string['submitname'] = 'Submeter nome';
$string['teacherjumpwarning'] = 'Nesta lição, há páginas que seguem para {$a->cluster}  ou {$a->unseen}. Esta sequência será ignorada e a lição seguirá para a página seguinte. Para testar a sequência das páginas entre como aluno.';
$string['teacherongoingwarning'] = 'A exibição da pontuação no decorrer da lição só é visível para os alunos. Para ver a pontuação no decorrer da lição entre como aluno.';
$string['teachertimerwarning'] = 'O cronómetro só é visível para os alunos. Para testar esta funcionalidade, entre como aluno.';
$string['thatsthecorrectanswer'] = 'A sua resposta está correta.';
$string['thatsthewronganswer'] = 'A sua resposta <b>não<b> está correta.';
$string['thefollowingpagesjumptothispage'] = 'As páginas seguintes seguem para esta';
$string['thispage'] = 'Esta página';
$string['timeisup'] = 'Terminou o tempo';
$string['timeremaining'] = 'Tempo restante';
$string['timespenterror'] = 'Gastou pelo menos {$a} minutos nesta lição.';
$string['timespentminutes'] = 'Tempo despendido (minutos)';
$string['timetaken'] = 'Tempo usado';
$string['topscorestitle'] = '{$a} melhores notas';
$string['truefalse'] = 'Verdadeiro/falso';
$string['unabledtosavefile'] = 'O ficheiro que carregou não pode ser guardado';
$string['unknownqtypesnotimported'] = '{$a} perguntas com tipos de perguntas não suportados não foram importadas';
$string['unseenpageinbranch'] = 'Pergunta não vista da sequência';
$string['unsupportedqtype'] = 'Tipo de pergunta não suportado ({$a})!';
$string['updatedpage'] = 'A página foi atualizada';
$string['updatefailed'] = 'A atualização falhou';
$string['usemaximum'] = 'Usar máximo';
$string['usemean'] = 'Usar média';
$string['usepassword'] = 'Lição protegida por senha';
$string['usepassword_help'] = 'Se ativar esta opção, é necessário introduzir uma senha para aceder à lição.';
$string['viewgrades'] = 'Ver notas';
$string['viewhighscores'] = 'Ver lista de melhores notas';
$string['viewreports'] = 'Ver {$a->attempts} tentativas completas de {$a->student}';
$string['viewreports2'] = 'Ver {$a} tentativas completas';
$string['welldone'] = 'Muito bem!';
$string['whatdofirst'] = 'O que deseja fazer para começar?';
$string['wronganswerjump'] = 'Seguir para, se resposta errada';
$string['wronganswerscore'] = 'Pontuação';
$string['wrongresponse'] = 'Feedback para resposta errada';
$string['xattempts'] = '{$a} tentativas';
$string['youhaveseen'] = 'Já viu mais do que uma página desta lição.<br />Quer continuar a partir da última página que viu?';
$string['youmadehighscore'] = 'Conseguiu um lugar na lista das {$a} melhores notas.';
$string['youranswer'] = 'A sua resposta';
$string['yourcurrentgradeis'] = 'A sua nota atual é {$a}';
$string['yourcurrentgradeisoutof'] = 'A sua nota atual é {$a->grade} em {$a->total}';
$string['youshouldview'] = 'Deve responder a pelo menos: {$a}';
