<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Eerste mededeling';
$string['alert2'] = 'Tweede mededeling';
$string['alert3'] = 'Derde mededeling';
$string['alert_general'] = 'Aankondiging';
$string['alert_info'] = 'Informatie';
$string['alertsdesc'] = 'Dit toont een gekleurde mededelingenbox (of meerdere, desgewenst in verschillende stijlen) op je Moodle voorpagina. Denk er s.v.p. aan ze uit te schakelen als je ze niet meer nodig hebt.';
$string['alertsheading'] = 'Mededelingen voor gebruikers';
$string['alertsheadingsub'] = 'Toont belangrijke mededelingen aan je gebruikers op de voorpagina';
$string['alerttext'] = 'Tekst van de mededeling';
$string['alerttextdesc'] = 'Wat is de boodschap die je wilt tonen';
$string['alerttitle'] = 'Titel';
$string['alerttitledesc'] = 'Titel van je mededeling';
$string['alerttype'] = 'Soort';
$string['alerttypedesc'] = 'Stel het gepaste type mededeling in';
$string['alert_warning'] = 'Waarschuwing';
$string['allclasses'] = 'Alle klassen';
$string['allcourses'] = 'Alle cursussen';
$string['allmodules'] = 'Alle modules';
$string['allunits'] = 'Alle eenheden';
$string['alternativecolors'] = 'Alternatieve kleurschema {$a}';
$string['alternativethemecolor'] = 'Alternatieve themakleur {$a}';
$string['alternativethemecolordesc'] = 'Welke kleur moet het thema in alternatief kleurschema {$a} zijn?';
$string['alternativethemecolorname'] = 'Naam van alternatief kleurschema {$a}';
$string['alternativethemecolornamedesc'] = 'Geef een herkenbare naam op voor dit alternatieve kleurschema.';
$string['alternativethemecolors'] = 'Alternatieve themakleur {$a}';
$string['alternativethemecolorsdesc'] = 'Definieer de alternatieve kleurschema\'s.';
$string['alternativethemehovercolor'] = 'Alternative Theme Hover Colour {$a}';
$string['alternativethemehovercolordesc'] = 'Welke kleur moet er gebruikt worden voor hovers in alternatief kleurschema {$a}?';
$string['alternativethemename'] = 'Naam voor kleurschema {$a}';
$string['alternativethemenamedesc'] = 'Voer hier de naam van alternatief kleurschema {$a} in.';
$string['alwaysdisplay'] = 'Toon altijd';
$string['analyticsdesc'] = 'Hier kunt je Google Analytics inschakelen voor je Moodle website. Je dient je aan te melden voor een gratis account op de Google Analytics website ( <a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a> )';
$string['analyticsheadingsub'] = 'Krachtige statistieken van Google';
$string['android'] = 'Android (Google Play)';
$string['backtotop'] = 'Naar boven';
$string['bootstrapcdn'] = 'FontAwesome van CDN';
$string['bootstrapcdndesc'] = 'Bij inschakelen zal FontAwesome geladen worden vanuit de online Bootstrap CDN bron. Schakel in wanneer je problemen ervaart met het tonen van de FontAwesome iconen op je site.';
$string['categoryicondesc'] = 'Indien ingeschakeld kun je hier iconen voor iedere categorie instellen.';
$string['categoryiconheading'] = 'Categorie Iconen';
$string['categoryiconheadingsub'] = '';
$string['categoryiconinfo'] = 'Aangepaste categorie iconen';
$string['categoryiconinfodesc'] = 'Stel hier per categorie een icoon in. De mogelijke opties vind je <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>, voer het gedeelte na "fa-" in.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Over Essential</h3>
<p>Essential is een aangepast Moodle bootstrap thema dat stijlen overerft van zijn <em>parent</em>-thema.</p>
<h3>Parents - ouders</h3>
<p>Dit thema is gebaseerd op het Bootstrap thema, dat werd gemaakt voor Moodle 2.5, met de hulp van:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Theme Credits</h3>
<p>Auteur: Julian Ridden<br>
Contact: julian@moodleman.net<br>
Website: <a href="http://www.moodleman.net">www.moodleman.net</a>
</p>
</div></div>';
$string['colordesc'] = 'Hier kun je diverse instellingen vinden om de kleuren van je thema aan te passen.';
$string['colorheading'] = 'Kleurinstellingen';
$string['colorheadingsub'] = 'Stel de kleuren in die in het thema gebruikt worden';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Contactinformatie';
$string['contactinfodesc'] = 'Voer hier je contactinfo in';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'De naam van je organisatie.';
$string['customcss'] = 'Aangepaste CSS';
$string['customcssdesc'] = 'Iedere CSS die je toevoegt in dit tekstgebied, zal worden toegepast op iedere pagina. Eenvoudig het thema aanpassen dus!';
$string['defaultcategoryicon'] = 'Standaard categorie icoon';
$string['defaultcategoryicondesc'] = 'Stel hier een standaard categorie icoon in.';
$string['defaultcolors'] = 'Standaardkleuren';
$string['displayafterlogin'] = 'Toon alleen ná inloggen';
$string['displaybeforelogin'] = 'Toon alleen vóór inloggen';
$string['displaymycourses'] = 'Toon cursussen waaraan deelgenomen wordt';
$string['displaymycoursesdesc'] = 'Toon cursussen waaraan deelgenomen wordt door de gebruiker in het aangepaste menu';
$string['dontdisplay'] = 'Toon nooit';
$string['enablealert'] = 'Schakel waarschuwen in';
$string['enablealertdesc'] = 'Schakel waarschuwingen in of uit';
$string['enablealternativethemecolors'] = 'Schakel alternatief kleurschema {$a} in';
$string['enablealternativethemecolorsdesc'] = 'Indien ingeschakeld krijgen gebruikers de keuze om alternatief kleurschema {$a}te kiezen.';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Voer de URL van je Facebook pagina in. (Bijv. http://www.facebook.com/mijnschool)';
$string['fixedwidthnarrow'] = 'Vaste breedte - Smal';
$string['fixedwidthwide'] = 'Vaste breedte - Breed';
$string['flickr'] = 'Flickr URL';
$string['flickrdesc'] = 'Voer de URL van Flickr pagina in. (Bijv. http://www.flickr.com/mijnschool)';
$string['fontselect'] = 'Kies typografie';
$string['fontselectdesc'] = 'Kies uit de lijst van beschikbare lettertype combinaties. Je kunt hier desgewenst ook kiezen om Google lettertypen uit te schakelen.';
$string['footercolor'] = 'Achtergrondkleur footer';
$string['footercolordesc'] = 'Stel hier de gewenste achtergrondkleur van de footer in.';
$string['footercolors'] = 'Kleuren in de foter';
$string['footercolorsdesc'] = 'Pas de kleuren van de pagina footer aan';
$string['footerheadingcolor'] = 'Header kleur van de footer';
$string['footerheadingcolordesc'] = 'Stel de kleur van de koppen van de blokken in de footer in.';
$string['footerhovercolor'] = 'Link hover kleur footer';
$string['footerhovercolordesc'] = 'Stel de kleur van links in de footer in bij het hoveren met de muis of cursor.';
$string['footersepcolor'] = 'Footer separator kleur';
$string['footersepcolordesc'] = 'Een separator is een lijn die inhoud (bijv. kolommen) scheidt. Stel de gewenste kleur hier in.';
$string['footertextcolor'] = 'Tekstkleur footer';
$string['footertextcolordesc'] = 'Stel de gewenste tekstkleur van de footer in.';
$string['footerurlcolor'] = 'Footer link kleur';
$string['footerurlcolordesc'] = 'Stel de gewenste kleur van links in de footer in.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Tekst welke in dit veld wordt ingevoegd zal op iedere pagina in de voetnoot worden weergegeven.';
$string['frontcontentarea'] = 'Voorpagina content';
$string['frontcontentareadesc'] = 'De inhoud van dit blik wordt over de gehele breedte van de pagina tussen de slidehsow en marketing blokken weergegeven.';
$string['frontcontentdesc'] = 'Dit voegt een speciaal blok in tussen de slideshow en de marketing blokken waar je eigen content kan plaatsen.';
$string['frontcontentheading'] = 'Voorpagina instellingen';
$string['frontpageblocks'] = 'Uitlijning van voorpagina blokken';
$string['frontpageblocksdesc'] = 'Hier kun je de uitlijning van de blokken op de voorpagina kiezen.';
$string['frontpagemiddleblocks'] = 'Voorpagina midden blokken inschakelen';
$string['frontpagemiddleblocksdesc'] = 'Indien ingeschakeld worden er drie blokken weergegeven onder de marketing blokken.';
$string['genericsettings'] = 'Algemene Instellingen';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Link naar je Google+ profiel. (bvb. https://plus.google.com/+mijnorganisatie)';
$string['hideonphone'] = 'Verberg slideshow op telefoons';
$string['hideonphonedesc'] = 'Kies hier of je de slideshow wil uitschakelen op telefoons.';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Link naar je Instagram feed. (bvb. http://instagram.com/mijnorganisatie)';
$string['ios'] = 'iPhone/iPad (Apple App Store)';
$string['iosdesc'] = '';
$string['iosicon'] = 'iOS thuisscherm iconen';
$string['iosicondesc'] = 'In dit thema zijn iconen in te stellen die getoond worden op het iOS thuisscherm als je een bladwijzer maakt voor de Moodle omgeving.';
$string['ipadicon'] = 'iPad icoon (Zonder Retina)';
$string['ipadicondesc'] = 'Dit icoon moet een 72px x 72px PNG icoon zijn.';
$string['ipadretinaicon'] = 'iPad icoon (Retina)';
$string['ipadretinaicondesc'] = 'Dit icoon moet een 144px x 144px PNG icoon zijn.';
$string['iphoneicon'] = 'iPhone/iPod Touch icoon (Zonder Retina)';
$string['iphoneicondesc'] = 'Dit icoon moet een 57px x 57px PNG zijn.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch icoon (Retina)';
$string['iphoneretinaicondesc'] = 'Dit icoon moet een 114px x 114px PNG zijn.';
$string['layout'] = 'Gebruik standaard cursus layout';
$string['layoutdesc'] = '';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn URL';
$string['linkedindesc'] = 'Link naar je LinkedIn profiel. (bvb. https://www.linkedin.com/company/mijnorganisatie)';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload hier je eigen logo. Indien je een logo upload vervangt dit automatisch het standaard logo en het gekozen icoon.';
$string['marketing1'] = 'Marketing blok 1';
$string['marketing2'] = 'Marketing blok 2';
$string['marketing3'] = 'Marketing blok 3';
$string['marketingbuttontext'] = 'Link tekst';
$string['marketingbuttontextdesc'] = 'Tekst om te tonen op de link button.';
$string['marketingbuttonurl'] = 'Link URL';
$string['marketingbuttonurldesc'] = 'URL the button will point to.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Stel hier de inhoud van het marketing blok in. Maak het kort maar krachtig.';
$string['marketingdesc'] = 'Dit thema bevat de optie om drie marketing blokken te tonen onder de slideshow. Dit geeft je de mogelijkheid om direct informatie te tonen aan gebruikers, ook zonder dat deze ingelogd zijn. Dit is handig voor als je specifieke cursussen wil uitlichten.';
$string['marketingheading'] = 'Marketing blokken';
$string['marketingheadingsub'] = 'De marketing blokken zijn drie blokken op de voorpagina waarin informatie en links getoond worden.';
$string['marketingheight'] = 'Hoogte van de marketing afbeeldingen';
$string['marketingheightdesc'] = 'Als je afbeeldingen wil tonen in de marketing blokken kun je hier de hoogte instellen.';
$string['marketingicon'] = 'Icoon';
$string['marketingicondesc'] = 'Naam van het iccon dat je wil gebruiken. Kies uit de lijst <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voor de naam in achter "fa-", bijvoorbeeld "star".';
$string['marketingimage'] = 'Afbeelding';
$string['marketingimagedesc'] = 'Stel hier een afbeelding in om boven de tekst in dit marketing blok te tonen.';
$string['marketinginfodesc'] = 'Configureer hier de marketing blokken.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Marketing blok titel.';
$string['marketingurltarget'] = 'Link doel';
$string['marketingurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['marketingurltargetnew'] = 'Open in nieuwe pagina';
$string['marketingurltargetparent'] = 'Open in hoofdframe';
$string['marketingurltargetself'] = 'Open in huidige pagina';
$string['mobileappsdesc'] = 'Heb je een app in de App Store of Play Store? Voer hier de links in zodat je apps eenvoudig gevonden kunenn worden.';
$string['mobileappsheading'] = 'Mobiele applicaties';
$string['mobileappsheadingsub'] = 'Link naar je apps om te stimuleren dat gebruikers mobiele apparaten gebruiken.';
$string['myclasses'] = 'Mijn klassen';
$string['mycourses'] = 'Mijn cursussen';
$string['mycoursesinfo'] = 'Automatische cursus lijst';
$string['mycoursesinfodesc'] = 'Toont een lijst met alle cursussen waar een gebruiker in ingeschreven is.';
$string['mycoursetitle'] = 'Naamgeving';
$string['mycoursetitledesc'] = 'Verander de naamgeving voor het "Mijn cursussen" menu hieronder.';
$string['mymodules'] = 'Mijn modules';
$string['myunits'] = 'Mijn lessen';
$string['nextsection'] = 'Volgende sectie';
$string['noenrolments'] = 'Geen cursusinschrijving bekend';
$string['oldnavbar'] = 'Gebruik oude navigatie balk positie';
$string['oldnavbardesc'] = 'Indien ingeschakeld wordt de navigatie balk op de oude positie getoond.';
$string['pagebackground'] = 'Pagina achtergrondafbeelding';
$string['pagebackgrounddesc'] = 'Upload hier je achtergrond afbeelding. Deze achtergrond afbeelding zal op alle pagina\'s getoond worden. Als je geen afbeelding upload wordt hier een vaste kleur voor gebruikt.';
$string['pagewidth'] = 'Kies pagina breedte';
$string['pagewidthdesc'] = 'Kies uit de lijst met beschikbare breedtes om de site breedte in te stellen.';
$string['perfinfo'] = 'Performance informatie';
$string['perfinfodesc'] = '';
$string['perf_max'] = 'Gedetailleerd';
$string['perf_min'] = 'Minimaal';
$string['pinterest'] = 'Pinterest URL';
$string['pinterestdesc'] = 'Link naar je Pinterest prikbord. (bvb. http://www.pinterest.com/mijnorganisatie/mijnprikbord)';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Vorige sectie';
$string['profilebarcustomtitle'] = 'Aangepaste profielbalk titel';
$string['profilebarcustomtitledesc'] = 'Voer hier indien gewenst een aangepaste title in voor de profielbalk.';
$string['readmore'] = 'Lees verder';
$string['region-footer-left'] = 'Voetnoot (links)';
$string['region-footer-middle'] = 'Voetnoot (midden)';
$string['region-footer-right'] = 'Voetnoot (rechts)';
$string['region-hidden-dock'] = 'Verborgen';
$string['region-home-left'] = 'Home (links)';
$string['region-home-middle'] = 'Home (midden)';
$string['region-home-right'] = 'Home (rechts)';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['right'] = 'Rechts';
$string['siteicon'] = 'Site afbeelding';
$string['siteicondesc'] = 'Als je geen logo hebt kun je hier een icoon invullen om op de plaats van het logo te tonen. De volledige lijst staat op <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer het gedeelte achter "fa-" hier in.';
$string['skype'] = 'Skype Account';
$string['skypedesc'] = 'Skype gebruikersnaam van je organisatie. (bvb. mijn.organisatie)';
$string['slidebuttoncolor'] = 'Slide buttonkleur';
$string['slidebuttoncolordesc'] = 'Kies hier de kleur voor de navigatie knoppen.';
$string['slidecaption'] = 'Slide tekst';
$string['slidecaptiondesc'] = 'Voer hier de tekst in die op de slide getoond zal worden.';
$string['slidecolor'] = 'Slide tekstkleur';
$string['slidecolordesc'] = 'Kies hier de kleur van de hoofdtekst op de slide.';
$string['slideimage'] = 'Slide afbeelding';
$string['slideimagedesc'] = 'Gebruik hier een transparante png (formaat is 256px x 256px voor de kleine afbeelding, en 300px x 1200px voor de achtergrond afbeelding)';
$string['slideshowdesc'] = 'Indien ingeschakeld wordt er een dynamische slideshow met maximaal 4 slides getoond om belangrijke informatie aantrekkelijk weer te geven.';
$string['slideshowheading'] = 'Voorpagina slideshow';
$string['slideshowheadingsub'] = 'Een dynamische slideshow voor de voorpagina';
$string['slidetitle'] = 'Slide titel';
$string['slidetitledesc'] = 'Voer een titel in voor je slide.';
$string['slideurl'] = 'Slide link';
$string['slideurldesc'] = 'Voer hier in waar de link achter "Verder lezen" naar moet verwijzen.';
$string['slideurltarget'] = 'Link doel';
$string['slideurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['slideurltargetnew'] = 'Open in nieuwe pagina';
$string['slideurltargetparent'] = 'Open in hoofdframe';
$string['slideurltargetself'] = 'Open in huidige pagina';
$string['socialdesc'] = 'Geef hier directe links naar de locaties op sociale netwerken waar jouw merk of organisatie voorkomt. Deze links worden overal in de koptekst van de pagina getoond.';
$string['socialheading'] = 'Sociale netwerk sites';
$string['socialheadingsub'] = 'Bind je gebruikers door gebruik te maken van sociale netwerken.';
$string['socialnetworks'] = 'Sociale netwerk sites';
$string['themecolor'] = 'Thema kleuren';
$string['themecolordesc'] = 'Welke kleur wil je het thema hebben? Dit heeft invloed op meerdere componenten binnen Moodle en bepaalt de basis kleur voor je thema.';
$string['themecolors'] = 'Themakleuren';
$string['themehovercolor'] = 'Thema hover kleuren';
$string['themehovercolordesc'] = 'Welke kleuren moeten de hovers in het thema hebben? Dit wordt bijvoorbeeld gebruikt voor links.';
$string['togglemarketing'] = 'Marketing blokken inschakelen';
$string['togglemarketingdesc'] = 'Kies hier of je de marketing blokken wil tonen.';
$string['toggleslideshow'] = 'Slideshow inschakelen';
$string['toggleslideshowdesc'] = 'Kies hier of je de slideshow in wil schakelen.';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = 'Link naar je Twitter feed. (bvb. https://twitter.com/mijnorganisatie)';
$string['usecategoryicon'] = 'Enable Category Icons';
$string['usecategoryicondesc'] = 'Use custom icons for categories';
$string['variablewidth'] = 'Volledige breedte';
$string['visibleadminonly'] = 'Blokken in deze regio worden alleen aan beheerders getoond';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Link naar je VKontakte profiel. (bvb. http://vk.com/mijnorganisatie)';
$string['website'] = 'Website URL';
$string['websitedesc'] = 'Link naar je website. (bvb. http://www.uplearning.nl)';
$string['youtube'] = 'YouTube URL';
$string['youtubedesc'] = 'Link naar je YouTube kanaal. (bvb. https://www.youtube.com/user/mijnorganisatie)';
