<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_installaddon', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   tool_installaddon
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acknowledgement'] = 'Erkjennelse';
$string['acknowledgementmust'] = 'Du må erkjenne dette';
$string['acknowledgementtext'] = 'Jeg forstår at det er mitt ansvar å ha full backup av denne siden før innstallasjon av tillegg. Jeg aksepterer og forstår at tillegg (spesielt, men ikke bare de som kommer fra uoffisielle kilder) kan inneholde sikkerhetshill, kan gjøre sider utilgjengelige, eller fører til lekkasjer eller tap av privat informasjon.';
$string['featuredisabled'] = 'Tilleggsinstallatøren er ikke tilgjengelig på denne siden';
$string['installaddon'] = 'Installer modul!';
$string['installaddons'] = 'Installer moduler';
$string['installexception'] = 'Oops.... Det har skjedd en feil under installasjonen av modulen. Aktiver debug-modus for å vise detaljene i feilen som oppstod.';
$string['installfromrepo'] = 'Installer tillegg fra Moodle plugins katalogen';
$string['installfromrepo_help'] = 'Do vil bli videresendt til Moodle plugins katalogen for å søke etter og innstallere tillegg. Merk deg at sidens fulle navn, URL og Moodle versjon også vil bli sendt, for å gjøre innstallasjonsprosessen enklere for deg';
$string['installfromzip'] = 'Installer moduler fra en ZIP-fil';
$string['installfromzipfile'] = 'ZIP-pakke';
$string['installfromzipfile_help'] = 'ZIP-pakken med modulen må kun inneholde EN mappe med et navn som samsvarer med modulnavnet. ZIP-fila vil bli pakket ut i tilhørende område for modultypen. Hvis pakken er lastet ned fra Moodles modulkatalog vil den ha denne strukturen.';
$string['installfromzip_help'] = 'Et alternativ til å installere tilleggsmoduler rett fra Moodles modulkatalog er å laste opp en ZIP-pakke med ønsket modul. ZIP-pakken må ha samme struktur som en pakke lastet ned fra Moodles modulkatalog.';
$string['installfromziprootdir'] = 'Gi nytt navn til rotkatalogen';
$string['installfromziprootdir_help'] = 'Noen ZIP-pakker, slik som de som er generert fra Github, kan få feil navn på rotmappen. Hvis det er tilfelle kan du korrigere dette manuelt her.';
$string['installfromzipsubmit'] = 'Installer modul fra ZIP-filen';
$string['installfromziptype'] = 'Modultype';
$string['installfromziptype_help'] = 'Velg modultypen du ønsker å installere. Advarsel: Installasjonsprosessen kan feile fatalt om du angir feil modultype.';
$string['permcheck'] = 'Vær sikker på at filområdet for modulen er skrivbart av webserver-prosessen.';
$string['permcheckerror'] = 'Det ser ikke ut til at Moodle har skriverettighet.';
$string['permcheckprogress'] = 'Sjekker for skrivetillatelser';
$string['permcheckresultno'] = 'Filområdet for  <em>{$a->path}</em> er ikke skrivbart.';
$string['permcheckresultyes'] = 'Filområdet for  <em>{$a->path}</em> er skrivbart.';
$string['pluginname'] = 'Modul-installerer';
$string['remoterequestalreadyinstalled'] = 'Dette er en forespørsel om å installere tilleggsmodulen {$a->name} ({$a->component}) versjon {$a->version} fra Moodles modulkatalog på denne portalen. Denne modulen er <strong>allerede installert</strong> på portalen.';
$string['remoterequestconfirm'] = 'Dette er en forespørsel om å installere <strong>{$a->name}</strong> ({$a->component}) versjon {$a->version} fra Moodle modulkatalog på denne portalen. Hvis du fortsetter vil tilleggsmodulens ZIP-pakke bli lastet ned for validering. Ingenting installeres på dette steget.';
$string['remoterequestinvalid'] = 'Det er en forespørsel om å innstallere et tillegg fra Moodle plugins katalogen på denne siden. Dessverre er forespørselen ugyldig og tillegget vil ikke bli innstallert';
$string['remoterequestpermcheck'] = 'Dette er en forespørsel om å installere tilleggsmodulen {$a->name} ({$a->component}) versjon {$a->version} fra Moodles modulkatalog på denne portalen. Det viser seg at filområdet  <strong>{$a->typepath}</strong> for denne modulen ikke er <strong>skrivbart</strong>. Du må angi skriverettigheter for webserveren til dette filområdet. Klikk på "Fortsett"-knappen for å gjenta sjekken.';
$string['remoterequestpluginfoexception'] = 'Oooops.... Det oppstod en feil da vi forsøkte å lese informasjonen om tilleggsmodulen {$a->name} ({$a->component}) versjon {$a->version}. Tilleggsmodulen kan ikke installeres. Slå på debugging for å se detaljene for denne feilen.';
$string['validation'] = 'Pakkevaliderer for moduler';
$string['validationmsg_componentmatch'] = 'Fullt navn på komponenten';
$string['validationmsg_componentmismatchname'] = 'Tilleggsmodulens navn stemmer ikke';
$string['validationmsg_componentmismatchname_help'] = 'Noen ZIP-pakker, som de som genereres av Github, kan inneholde feil navn på rotmappen. Du må derfor endre navnet på rotmappen slik at den samsvarer med modulens navn.';
$string['validationmsg_componentmismatchname_info'] = 'Tilleggsmodulen deklarerer eget modulnavn til \'{$a}\', men dette samsvarer ikke med navnet på rotmappen til modulen.';
$string['validationmsg_componentmismatchtype'] = 'Ikke samsvar med modultypen';
$string['validationmsg_componentmismatchtype_info'] = 'Du har valgt modultypen  \'{$a->expected}\', men modulen deklarerer at modultypen er \'{$a->found}\'.';
$string['validationmsg_filenotexists'] = 'Utpakket fil ble ikke funnet';
$string['validationmsg_filesnumber'] = 'Fant ikke nok filer i pakken';
$string['validationmsg_filestatus'] = 'Ikke mulig å pakke ut alle filene';
$string['validationmsg_filestatus_info'] = 'Forsøket på å pakke ut filen {$a->file} resulterte i feilen \'{$a->status}\'.';
$string['validationmsg_foundlangfile'] = 'Fant språkfil';
$string['validationmsglevel_debug'] = 'Debug';
$string['validationmsglevel_error'] = 'Feil';
$string['validationmsglevel_info'] = 'OK';
$string['validationmsglevel_warning'] = 'Advarsel';
$string['validationmsg_maturity'] = 'Deklarert modenhetsnivå';
$string['validationmsg_maturity_help'] = 'Modulen kan deklarere sitt modenhetsnivå. Dersom utvikleren bedømmer modulen som stabil, vil deklarert modenhetsnivå være MATURITY_STABLE. Alle andre modenhetsnivåer (som alfa og beta) bør bedømmes som ustabile og en advarsel gis.';
$string['validationmsg_missingexpectedlangenfile'] = 'Ikke samsvar med den engelske språkfilen';
$string['validationmsg_missingexpectedlangenfile_info'] = 'Modultypen mangler en forventet engelsk språkfil: {$a}';
$string['validationmsg_missinglangenfile'] = 'Fant ingen engelsk språkfil';
$string['validationmsg_missinglangenfolder'] = 'Mangler mappe for engelsk språkfil';
$string['validationmsg_missingversion'] = 'Tilleggsmodulen oppgir ikke hvilken versjon den har.';
$string['validationmsg_missingversionphp'] = 'Filen version.php finnes ikke';
$string['validationmsg_multiplelangenfiles'] = 'Fant duplikate engelske språkfiler';
$string['validationmsg_onedir'] = 'Ugyldig struktur på ZIP-pakken.';
$string['validationmsg_onedir_help'] = 'ZIP-pakken må inneholde en rotkatalog som inneholder modulens kode. Navnet på denne rotkatalogen må samsvare med modulens navn.';
$string['validationmsg_pathwritable'] = 'Sjekk av skrivetilgang';
$string['validationmsg_pluginversion'] = 'Tilleggsmodulens versjon';
$string['validationmsg_release'] = 'Tilleggsmodulens versjonsdato';
$string['validationmsg_requiresmoodle'] = 'Krav til Moodle-versjon';
$string['validationmsg_rootdir'] = 'Navnet på tilleggsmodulen som skal installeres';
$string['validationmsg_rootdir_help'] = 'Navnet på rotkatalogen i ZIP-pakken blir navnet på modulen som installeres. Dersom navnet ikke er korrekt, kan det være at du vil døpe om rotkatalogen i ZIP-pakken før du installerer.';
$string['validationmsg_rootdirinvalid'] = 'Ugyldig navn på tilleggsmodulen';
$string['validationmsg_rootdirinvalid_help'] = 'Navningen på rotkatalogen i ZIP-pakken har ugyldig syntaks. Noen ZIP-pakker, slik som generert fra Github, kan inneholde ugyldige navn på rotkatalogen. Du må fikse dette slik at mappenavnet samsvarer med navnet på tilleggsmodulen.';
$string['validationmsg_targetexists'] = 'Målmappen eksisterer allerede';
$string['validationmsg_targetexists_help'] = 'Mappen hvor tilleggsmodulen skal installeres kan ikke eksistere fra før.';
$string['validationmsg_unknowntype'] = 'Ukjent modultype';
$string['validationresult0'] = 'Valideringen mislykkes!';
$string['validationresult0_help'] = 'Det er oppdaget alvorlige problemer med tilleggsmodulen. Det er ikke trygt å installere denne modulen. Se nærmere på valideringsrapporten for flere detaljer.';
$string['validationresult1'] = 'Valideringen fullført og godkjent!';
$string['validationresult1_help'] = 'Tilleggsmodulen er validert og det er ikke oppdaget noen alvorlige problemer.';
$string['validationresultinfo'] = 'Informasjon';
$string['validationresultmsg'] = 'Melding';
$string['validationresultstatus'] = 'Status';
