<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktiviteter';
$string['addcategory'] = 'Legg til kategori';
$string['addcategoryerror'] = 'Kunne ikke legge til kategorien.';
$string['addexceptionerror'] = 'Det oppstod en feil under når unntak skulle legges til for userid:gradeitem';
$string['addfeedback'] = 'Legg til tilbakemelding';
$string['addgradeletter'] = 'Legg til karakterbokstav';
$string['addidnumbers'] = 'Legg til idnummer';
$string['additem'] = 'Legg til karakterelement';
$string['addoutcome'] = 'Legg til et læringsmål';
$string['addoutcomeitem'] = 'Legg til læringsmålelement';
$string['addscale'] = 'Legg til en skala';
$string['aggregateextracreditmean'] = 'Middelverdi for karakterer (med ekstra poeng)';
$string['aggregatemax'] = 'Høyeste karakter';
$string['aggregatemean'] = 'Middelverdi for karakterer';
$string['aggregatemedian'] = 'Median for karakterer';
$string['aggregatemin'] = 'Laveste karakter';
$string['aggregatemode'] = 'Mest gitte karakterer';
$string['aggregateonlygraded'] = 'Kalkulér bare karakterer som ikke er tomme';
$string['aggregateonlygraded_help'] = '<p>Tomme karakterfelter blir behandlet entens om laveste karakter eller utelatt fra sammenstillingen.</p>';
$string['aggregateoutcomes'] = 'Inkluder læringsmål i beregningen';
$string['aggregateoutcomes_help'] = '<p>Å ta med læringsmål i karakteroversikten leder ikke nødvendigvis til ønsket samlet karakter, så du har muligheten til å ta med læringsmål eller utelate dem.</p>';
$string['aggregatesonly'] = 'Bare karakterberegninger';
$string['aggregatesubcats'] = 'Karakterberegning hvor underkataloger er tatt med';
$string['aggregatesubcats_help'] = '<p>Oversikt over karakterer blir vanligvis gjort med resultatene i samme kategori, men det er også mulig å ta med karakterer i alle underkategorier og utelate andre sammenstilte karakterer.</p>';
$string['aggregatesum'] = 'Sum av karakterer';
$string['aggregateweightedmean'] = 'Vektet middelverdi av karakterer';
$string['aggregateweightedmean2'] = 'Enkel vektet middelverdi av karakterer';
$string['aggregation'] = 'Karakterberegning';
$string['aggregationcoef'] = 'Beregningskoeffisent';
$string['aggregationcoefextra'] = 'Ekstra poeng';
$string['aggregationcoefextra_help'] = '<h2>For beregning av oppsummert karakter</h2>
<p>Når en bruker "Karaktersum" som beregningsstrategi, kan ett karakterelement tjene som ekstrapoeng for kategorien. Dette betyr at karakterelementet legges til kategoriens beregnede karakter, ikke maksverdien det karakterelementet kan ha. Følgende eksempel vil kanskje illustrere:</p>

<ul>
    <li>Element 1 har skalaen 0-100</li>
    <li>Element 2 har skalaen 0-75</li>
    <li>Element 1 har avmerket "Bruk som ekstrapoeng", men ikke Element 2.</li>
    <li>Begge elementene hører til Kategori 1, som har "Karaktersum" som beregningsmetode.</li>
    <li>Kategori 1 har skalaen 0-75</li>
    <li>En student får karakteren 20 på Element 1 og 70 på Element 2</li>
    <li>Studentens totalkarakter for Kategori 1 vil bli 75/75 (20+70 = 90, men siden Element 1 bare tjener som ekstrapoeng vil totalsummen bli maksimum, dvs her 75.)</li>
</ul>
<h2>For vektet middelverdi av karakterer (ekstrapoeng)</h2>
<p>En verdi større enn 0 blir behandlet som dette karakterelementets ekstrapoeng når karakteren skal beregnes. Tallet er den faktoren karakteren blir ganget med før den legges til summen av alle karakterer, men elementet i seg selv blir ikke med når middelverdien beregnes. Et eksempel:</p>

<ul>
    <li>Element 1 har skalaen 0-100 og dets verdi for "ekstrapoeng" er satt til 2</li>
    <li>ELement 2 har skalaen 0-100 g dets verdi for "ekstrapoeng" er satt til 0.0000</li>
    <li>Element 3 har skalaen 0-100 g dets verdi for "ekstrapoeng" er satt til 0.0000</li>
    <li>Alle 3 elementene hører til Kategori 1, som har "Middelverdi av karakterer (med ekstrapoeng) som beregningsmetode.</li>
    <li>En student får karakteren 20 på Element 1, 40 på Element2 og 70 på Element 3.</li>
    <li>Studentens totale karakter for Kategori 1 vil bli 95/100 siden 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefextrasum'] = 'Ekstra poeng';
$string['aggregationcoefextrasum_help'] = '<p>Dersom beregningsmetoden "Sum av karakterer" benyttes, kan ett karakterelement brukes som ekstrapoeng for kategorien. Dette betyr at karakterelementets maksimumskarakter ikke vil bli lagt til kategoriens maksimumskarakter, men elementets karakter vil tas med. For eksempel:</p>

<ul>
    <li>Element 1 har skalaen 0-100</li>
    <li>Element 2 har skalaen 0-75</li>
    <li>Element 1 har "Bruk som ekstrapoeng" avmerket, ELement 2 har det ikke.</li>
    <li>Begge elementene hører til Kategori 1, som har "Sum av karakterer" som beregningsmetode.</li>
    <li>Kategori 1 har skalaen 0-75</li>
    <li>En student får karakteren 20 på Element 1 og 70 på Element 2</li>
    <li>Students karakter for Kategori 1 vil da bli 75/75 (20+70 = 90, siden Element 1 bare brukes som ekstrapoeng vil totalen gi maksimumskarakter)</li>
</ul>';
$string['aggregationcoefextraweight'] = 'Vekting av ekstrapoeng';
$string['aggregationcoefextraweight_help'] = '<p>Dersom en verdi større enn 0 blir lagt til, vil dette karaktereelementet få beregnet ekstrapoeng. Verdien er en faktor som karakteren blir ganget med før den legges til summen av alle karakterer. Elementet med ekstrapoeng vil ikke tas med når middelverdien på resterende karakterer beregnes. For eksempel:</p>

<ul>
    <li>Element 1 har skalaen 0-100 og ekstrapoeng er satt til 2</li>
    <li>Element 2 har skalaen 0-100 og ekstrapoeng er satt til 0.0000</li>
    <li>Element 3 har skalaen 0-100 og ekstrapoeng er satt til 0.0000</li>
    <li>Alle 3 elementene hører til Kategori 1, som har "Middelverdi av karakterer (med ekstrapoeng)" som beregningsmetode.</li>
    <li>En student får karakteren 20 på Element 1, 40 på Element 2 og 70 på Element 3.</li>
    <li>Studentens samlede karakter for Kategor1 1 vil da bli 95/100 siden  20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefweight'] = 'Enhetsvekting';
$string['aggregationcoefweight_help'] = '<p>Vekting som tillegges alle vurderinger i denne karaktergivingen når karakteren beregnes.</p>';
$string['aggregation_help'] = '<p>Denne menyen lar deg velge hvilken beregningsmetode som skal brukes for å regne ut hver brukers samlede karakter for denne kategorien. De forskjellige valgene er beskrevet under.</p>

<p>Karakterene blir først konvertert til en prosentverdi (intervall fra 0-1, dette kalles normalisering), deretter beregnet ved å benytte en av funksjonene under og til slutt konvertert til den skalaen du har valgt for kategorielementet (mellom valgt <em>Minimumsverdi</em> og <em>Maksimumsverdi</em>.</p>

<p><strong>VIKTIG!</strong>: En tom karakter er ganske enkelt en manglende karakter og kan bety forskjellige ting. F.eks. kan det bety at brukeren ikke har levert inn noe, at innleveringen ikke er vurdert av en lærer ennå, eller at karakteren er blitt slettet manuelt av en karakterbok-administrator. Du bør derfor ha spesiell oppmerksomhet mot disse "tomme" karakterene.</p>

<dl id="grade-aggregation-help">
    <dt>Middelverdi av karakterer</dt>
    <dd>Summen av alle karakterene blir delt på antall karakterelementer.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                     <code>(0.7 + 0.25 + 1.0)/3 = 0.65 --> 65/100</code></dd>

    <dt>Vektet middelverdi</dt>
        <dd>Hver karakter kan vektes, og deretter brukes i en aritmetisk beregning av middelverdien til å påvirke viktigheten av hvert element i den samlede middelverdien.</dd>
        <dd class="example">A1 70/100 vekt 10, A2 20/80 vekt 5, A3
                         10/10 vekt 3, kategoriens max 100:<br /><code>(0.7*10 + 0.25*5 + 1.0*3)/18 = 0.625 --> 62.5/100</code></dd>

    <dt>Forenklet vektet middelverdi</dt>
        <dd>Forskjellen fra <em>Vektet middelverdi</em> er at vektingen er beregnet som <em>Maksimal karakter</em> - <em>Minimumskarakter</em> for hvert element. En 100-poengs innlevering får vekten 100, en 10-poengs innlevering får vekten 10.
</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>(0.7*100 + 0.25*80 + 1.0*10)/190 = 0.526 --> 52.6/100</code></dd>

    <dt>Middelverdi av karakterer (med ekstrapoeng)</dt>
        <dd>Aritmetisk middel med en vri. En gammel og nå utgått beregningsmetode som er tatt med bare for å gi kompatibilitet med gamle aktiviteter som har denne beregningsmetoden.</dd>

    <dt>Median av karakterer</dt>
        <dd>Karakteren midt på skalaen (eller gjennomsnittet av de to midterste) når karakterene ordnes etter verdi. Fordelen med dette framfor rent gjennomsnitt er at en utelater de høyeste og laveste fra beregningen (karakterer som vanligvis er langt fra middelverdien).</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>median(0.7 ; 0.25 ; 1.0) = 0.7 --> 70/100</code></dd>

    <dt>Laveste karakter</dt>
        <dd>Resultatet blir laveste karakter etter en normalisering. Det brukes vanligvis i kombinasjon med <em>Beregn bare ikke-tomme karakterer</em>.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>min(0.7 ; 0.25 ; 1.0) = 0.25 --> 25/100</code></dd>

    <dt>Høyeste karakter</dt>
        <dd>Resultatet blir høyeste karakter etter en normalisering.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>max(0.7 ; 0.25 ; 1.0) = 1.0 --> 100/100</code></dd>

    <dt>Mest gitte karakter</dt>
        <dd>Mest gitte karakter er den karakteren som forekommer oftest. Dette er mest brukt for ikke-numeriske karakterer. Fordelen fremfor gjennomsnitt er at den ikke påvirkes av høyeste og laveste gitte karakterer (karakterer som er uvanlig langt fra gjennomsnittet). Beregningsmetoden vil likevel bli meningsløs dersom  mer enn en har meget høye eller lave karakterer (bare en beholdes), eller hvis alle karakterene er forskjellige fra hverandre.</dd>
        <dd class="example">A1 70/100, A2 35/50, A3 20/80, A4 10/10, A5 7/10 kategoriens max 100:<br />
                         <code>mode(0.7 ; 0.7 ; 0.25 ; 1.0 ; 0.7) = 0.7 --> 70/100</code></dd>

    <dt>Karaktersum</dt>
        <dd>Summen av alle karakterer. Karakterskalaer blir ignorert. Dette er den eneste beregningsmetoden hvor det ikke konverteres internt til prosentverdier (normalisering). <em>Maksimal karakter</em> for et kategorielement blir beregnet automatisk som en sum av maksverdiene fra alle beregnede elementer.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10:<br />
                         <code>70 + 20 + 10 = 100/190</code></dd>
</dl>';
$string['aggregationposition'] = 'Beregningsposisjon';
$string['aggregationposition_help'] = '<p>Angir hvor på siden beregningskolonnen for totalkarakter skal vises.</p>';
$string['aggregationsvisible'] = 'Tilgjengelige karakterberegningstyper';
$string['aggregationsvisiblehelp'] = 'Velg hvilke beregningsstyper som skal være tilgjengelige. Hold nede Ctrl-tasten for å velge mer enn ett element.';
$string['allgrades'] = 'Alle karakterer på kategori';
$string['allstudents'] = 'Alle studentene';
$string['allusers'] = 'Alle brukere';
$string['autosort'] = 'Autosorter';
$string['availableidnumbers'] = 'TIlgjengelige idnummer';
$string['average'] = 'Gjennomsnitt';
$string['averagesdecimalpoints'] = 'Desimaler i kolonnegjennomsnitt';
$string['averagesdecimalpoints_help'] = '<p>Angi antall desimaler som skal vises i hver kolonnes middelverdi. Dersom arv er valgt vil visningstypen for hver kolonne bli benyttet.</p>';
$string['averagesdisplaytype'] = 'Visningstype for kolonnegjennomsnitt';
$string['averagesdisplaytype_help'] = '<p>Angir hvordan middelverdien skal vises for hver kolonne. Dersom "arv" er valgt vil visningen som er angitt for hver kolonne bli benyttet.</p>';
$string['backupwithoutgradebook'] = 'Sikkerhetskopien inneholder ikke Karakterbok-konfigurasjon';
$string['badgrade'] = 'Angitte karakter er ugyldig';
$string['badlyformattedscale'] = 'Vennligst bruk en komma-separert liste av verdier. Det må være minst to verdier i listen.';
$string['baduser'] = 'Angitt bruker er ugyldig';
$string['bonuspoints'] = 'Bonuspoeng';
$string['bulkcheckboxes'] = 'Massebehandle avkrysningsbokser';
$string['calculatedgrade'] = 'Beregnet karakter';
$string['calculation'] = 'Beregning';
$string['calculationadd'] = 'Legg til beregning';
$string['calculationedit'] = 'Rediger beregning';
$string['calculation_help'] = 'En karakterberegning er en formel som brukes til å bestemme karakterer. Formelen må starte med et likhetstegn (=) og kan inneiholde vanlige matematiske tegn, slik som max, min og sum. Om ønskelig kan også andre karakterelementer tas med i beregningen ved å skrive inn ID-nummeret i doble hakeparenteser.';
$string['calculationsaved'] = 'Beregningen er lagret';
$string['calculationview'] = 'Se beregning';
$string['cannotaccessgroup'] = 'Desverre ingen tilgang til karakterer for valgte gruppe.';
$string['categories'] = 'Kategorier';
$string['categoriesanditems'] = 'Kategorier og enheter';
$string['categoriesedit'] = 'Rediger kategorier og enheter';
$string['category'] = 'Kategori';
$string['categoryedit'] = 'Rediger kategori';
$string['categoryname'] = 'Kategorinavn';
$string['categorytotal'] = 'Kategoritotal';
$string['categorytotalfull'] = '{$a->category} totalt';
$string['categorytotalname'] = 'Navn på kategoritotal';
$string['changedefaults'] = 'Endre standarder';
$string['changereportdefaults'] = 'Rediger rapportstandarder';
$string['chooseaction'] = 'Velg en handling...';
$string['choosecategory'] = 'Velg kategori';
$string['combo'] = 'Flik- og listeboks meny';
$string['compact'] = 'Kompakt';
$string['componentcontrolsvisibility'] = 'Hvorvidt dette karakterelementet er skjult, styres av aktivitetsinnstillingene.';
$string['contract'] = 'Kontraktkategori';
$string['controls'] = 'Kontrollere';
$string['courseavg'] = 'Kursgjennomsnitt';
$string['coursegradecategory'] = 'Kurstegn kategori';
$string['coursegradedisplaytype'] = 'Visningstype for kurskarakter';
$string['coursegradedisplayupdated'] = 'Visningstype for kurskarakter er endret';
$string['coursegradesettings'] = 'Innstillinger for kurskarakterer';
$string['coursename'] = 'Kursnavn';
$string['coursescales'] = 'Kurs-skalaer';
$string['coursesettings'] = 'Kursinnstillinger';
$string['coursesettingsexplanation'] = 'Innstillingen bestemmer om karakterboken skal vises for alle deltakere i dette kurset.';
$string['coursetotal'] = 'Kurstotal';
$string['createcategory'] = 'Lag kategori';
$string['createcategoryerror'] = 'Kunne ikke lage ny kategori';
$string['creatinggradebooksettings'] = 'Opprett innstillinger for karakterbok';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Gjeldende overordnet posisjon';
$string['curveto'] = 'Curve To';
$string['decimalpoints'] = 'Gjennomgående antall desimaler';
$string['decimalpoints_help'] = '<p>Angi antall desimaler som skal vises for hver karakter. Denne innstillingen har ingen effekt på karakterberegninger - de gjøres med fem desimaler uansett. Det er kun visningen av antall desimaler du setter her.</p>';
$string['default'] = 'Standard';
$string['defaultprev'] = 'Standard ({$a})';
$string['deletecategory'] = 'Slett kategori';
$string['disablegradehistory'] = 'Slå av karakterhistorie';
$string['disablegradehistory_help'] = 'Slå av historiesporing i endringer i karakter-relaterte tabeller. Dette kan øke serverens ytelse noe og spare plass i databasen.';
$string['displaylettergrade'] = 'Vis bokstavkarakterer';
$string['displaypercent'] = 'Vis prosent';
$string['displaypoints'] = 'Vis poeng';
$string['displayweighted'] = 'Vis vektede karakterer';
$string['dropdown'] = 'Listeboks-meny';
$string['droplow'] = 'Dropp den laveste';
$string['droplowestvalue'] = 'Sett dropp den laveste karakterverdien';
$string['droplow_help'] = '<p>Dersom angitt, vil dette valget utelate X av de laveste karakterene. X er den verdien du valgte for "Utelat laveste".</p>';
$string['dropped'] = 'Utelatt';
$string['dropxlowest'] = 'Utelat X laveste';
$string['dropxlowestwarning'] = 'Merk: Dersom du utelater x laveste vil karaktermodulen anta at alle elementene i kategorien har samme poengverdi. Dersom poengsettingen varierer vil resultatene bli uforutsigbare.';
$string['duplicatescale'] = 'Dupliker skala';
$string['edit'] = 'Rediger';
$string['editcalculation'] = 'Rediger beregning';
$string['editcalculationverbose'] = 'Rediger beregning for {$a->category}$a->itemmodule {$a->itemname}';
$string['editfeedback'] = 'Rediger feedback';
$string['editgrade'] = 'Rediger karakter';
$string['editgradeletters'] = 'Rediger bokstavkarakterer';
$string['editoutcome'] = 'Rediger læringsmål';
$string['editoutcomes'] = 'Rediger læringsutbytte';
$string['editscale'] = 'Rediger skala';
$string['edittree'] = 'Kategorier og enheter';
$string['editverbose'] = 'Rediger {$a->category}$a->itemmodule {$a->itemname}';
$string['enableajax'] = 'Slå på AJAX';
$string['enableajax_help'] = 'Legger til et lag med AJAX-funksjonalitet i karakter-rapporten, forenkler og øker hastigheten på vanlige operasjoner. Betinger at Javascript er slått på i nettleseren.';
$string['enableoutcomes'] = 'Slå på læringsutbytte';
$string['enableoutcomes_help'] = 'Support for Læringsmål (også kjent som kompetanse, mål, standarder og kriterier) betyr at vi kan gi karakter til hendelser ved å bruke en eller flere skalaer som er knyttet til oppnådde læringsmål. Ved å slå på Læringsmål gjør du slik karaktergiving mulig på hele nettstedet.';
$string['encoding'] = 'Koding';
$string['errorcalculationbroken'] = 'Sannsynligvis sirkelreferanse eller ødelagt kalkulasjonsformel';
$string['errorcalculationnoequal'] = 'Formelen må starte med erlik-tegn (=1+2)';
$string['errorcalculationunknown'] = 'Feil formel';
$string['errorgradevaluenonnumeric'] = 'Mottatt ikke-numerisk lavest eller høyest karakter for';
$string['errornocalculationallowed'] = 'Beregninger er ikke tillatt for denne enheten';
$string['errornocategorisedid'] = 'Kunne ikke få en ukategorisert id!';
$string['errornocourse'] = 'Kunne ikke hente kursinformasjonen';
$string['errorreprintheadersnonnumeric'] = 'Received non-numeric value for reprint-headers';
$string['errorsavegrade'] = 'Beklager - kunne ikke lagre karakteren.';
$string['errorsettinggrade'] = 'Feil ved lagring av "{$a->itemname}" karakter for brukerID {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Feil ved oppdatering av "Ta bare med ikke-tomme karakterer" innstillingen for karakterkategori ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Feil ved oppdatering av "Ta med læringsutbytte i beregningen" innstillingen for karakterkategori ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Feil ved oppdatering av "Ta også med underkategorier" innstillingen for karakterkategori ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Feil ved oppdatering av aggregeringstype for karakterkategori ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Feil ved oppdatering av aggregeringskoeffisient (vekting eller tilleggspoeng) for karakterelement ID {$a->id}';
$string['excluded'] = 'Excluded';
$string['excluded_help'] = '<p>Dersom -utelatt- er aktivisert vil denne karakteren bli utelatt fra alle beregninger som foretas av overordnet karakterelement eller kategori.</p>';
$string['expand'] = 'Utvid kategori';
$string['export'] = 'Eksporter';
$string['exportalloutcomes'] = 'Eksporter alt utbytte';
$string['exportfeedback'] = 'Inkluder feedback i eksporten';
$string['exportonlyactive'] = 'Ekskludér utestengte brukere';
$string['exportonlyactive_help'] = 'Ta kun med studenter med aktiv påmelding og som ikke er utestengte i eksporten.';
$string['exportplugins'] = 'Eksporter plugins';
$string['exportsettings'] = 'Eksporter innstillinger';
$string['exportto'] = 'Eksporter til';
$string['extracreditvalue'] = 'Ekstra poengverdi for {$a}';
$string['extracreditwarning'] = 'Note: Setting all items for a category to extra credit will effectively remove them from the grade calculation. Since there will be no point total';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackadd'] = 'Legg til tilbakemelding';
$string['feedbackedit'] = 'Rediger tilbakemelding';
$string['feedbackforgradeitems'] = 'Tilbakemelding for {$a}';
$string['feedback_help'] = '<p>Kommentarer som læreren har lagt til karakteren. Dette kan være differensierte og personlige tilbakemeldinger, eller enkle koder som viser til et internt tilbakemeldingssystem.</p>';
$string['feedbacks'] = 'Tilbakemeldinger';
$string['feedbacksaved'] = 'Tilbakemelding lagret';
$string['feedbackview'] = 'Se tilbakemelding';
$string['finalgrade'] = 'Endelig karakter';
$string['finalgrade_help'] = '<p>Sluttkarakteren etter at alle beregninger er gjennomført.</p>';
$string['fixedstudents'] = 'Lås studentnavn-kolonnen';
$string['fixedstudents_help'] = 'Frys kolonnen med studentnavn slik at en kan scrolle horisontalt i karaktene.';
$string['forceoff'] = 'Tving: Av';
$string['forceon'] = 'Tving: På';
$string['forelementtypes'] = 'for de valgte {$a}';
$string['forstudents'] = 'For studenter';
$string['full'] = 'Full';
$string['fullmode'] = 'Full visning';
$string['fullview'] = 'Full visning';
$string['generalsettings'] = 'Generelt';
$string['grade'] = 'Karakter';
$string['gradeadministration'] = 'Karakterbok administrasjon';
$string['gradeanalysis'] = 'Karakteranalyse';
$string['gradebook'] = 'Karakterbok';
$string['gradebookhiddenerror'] = 'Karakterboken er for tiden satt til å skjule alt fra studenten';
$string['gradebookhistories'] = 'Karakterhistorie';
$string['gradeboundary'] = 'Grenser for bokstavkarakterer';
$string['gradeboundary_help'] = '<p>En prosentgrense over hvilke karakterer som vil bli tildelt en karakterbokstav (dersom vis bokstavkarakterer brukes).</p>';
$string['gradecategories'] = 'Karakterkategorier';
$string['gradecategory'] = 'Karakterkategori';
$string['gradecategoryonmodform'] = 'Karakterkategori';
$string['gradecategoryonmodform_help'] = 'Denne innstillingen styrer kategorien som inneholder aktivitetens karakterer i karakterboken.';
$string['gradecategorysettings'] = 'Karakterkategorier';
$string['gradedisplay'] = 'Karaktervisning';
$string['gradedisplaytype'] = 'Type karaktervisning';
$string['gradedisplaytype_help'] = '<p>Angi hvordan karakterer skal vises i karakter- og brukerrapporter. Karakterer kan vises som reelle karakterer, i prosent (i henhold til minimums- og maksimumskarakterer) eller som bokstaver.</p>';
$string['gradedon'] = 'Satt karakter: {$a}';
$string['gradeexport'] = 'Karaktereksport';
$string['gradeexportcustomprofilefields'] = 'Tilpassede profilfelt for karaktereksport';
$string['gradeexportcustomprofilefields_desc'] = 'Inkluder disse tilpassede profilfeltene i karaktereksporten, separert med komma.';
$string['gradeexportdecimalpoints'] = 'Antall desimaler for karaktereksport';
$string['gradeexportdecimalpoints_desc'] = 'Antall desimaler som skal vises for eksport. Dette kan overstyres i eksporten.';
$string['gradeexportdisplaytype'] = 'Karaktereksport visningstype';
$string['gradeexportdisplaytype_desc'] = 'Karakterer kan vises som virkelige karakter, som prosent(i forhold til minimum og maksimumskarakterer som bokstaver(A,B,C osv) gjennom eksport. Dette kan overstyres i eksporten.';
$string['gradeexportuserprofilefields'] = 'Brukeres profilfelt for karaktereksport';
$string['gradeexportuserprofilefields_desc'] = 'Inkluder disse brukerprofilfeltene i karaktereksporten, separert med komma.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Hjelp for karakterer';
$string['gradehistorylifetime'] = 'Levetid for karakterhistorie';
$string['gradehistorylifetime_help'] = 'Dette angir hvor lenge du vil oppbevare endringshistorie i karakterrelaterte tabeller. Det er anbefalt å oppbevare dem så lenge som mulig. Hvis du opplever ytelsesproblemer eller har begrenset databaseplass, prøv å sett en lavere verdi.';
$string['gradeimport'] = 'Karakterimport';
$string['gradeimportfailed'] = 'Karakterimporten mislykkes. Detaljer:';
$string['gradeitem'] = 'Karakterenhet';
$string['gradeitemaddusers'] = 'Ekskluder fra karaktersetting';
$string['gradeitemadvanced'] = 'Avanserte karakterenhetsinnstillinger';
$string['gradeitemadvanced_help'] = 'Velg alle elementer som skal vises';
$string['gradeitemislocked'] = 'Denne aktiviteten er låst i karakterboka. Endringer som er gjort til karakteren i denne aktiviteten vil ikke kopieres til karakterboka før den er låst opp.';
$string['gradeitemlocked'] = 'Karakterlåsing';
$string['gradeitemmembersselected'] = 'Eksludert fra karaktersetting';
$string['gradeitemnonmembers'] = 'Inkludert i karaktersetting';
$string['gradeitemremovemembers'] = 'Inkluder i karaktersetting';
$string['gradeitems'] = 'Sett karakter';
$string['gradeitemsettings'] = 'Karaktersetting';
$string['gradeitemsinc'] = 'Karakterenheter som skal inkluderes';
$string['gradeletter'] = 'Bokstavkarakter';
$string['gradeletter_help'] = '<p>En bokstav eller et annet symbol brukt til å representere en skala av karakterer.</p>';
$string['gradeletternote'] = 'To delete a grade letter just empty any of the<br /> three text areas for that letter and click submit.';
$string['gradeletters'] = 'Bokstavkarakterer';
$string['gradelocked'] = 'Karakteren er låst';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maksimal karakter';
$string['grademax_help'] = '<p>Når en benytter karaktertypen "verdi", kan det angis en maksimumskarakter. Maksimumskarakteren for en aktivitetsbasert karakter angis ved å redigere innstillinger for aktiviteten.</p>';
$string['grademin'] = 'Minimum karakter';
$string['grademin_help'] = '<p>Når en bruker karaktertypen "verdi" kan det angis en minimumskarakter.</p>';
$string['gradeoutcomeitem'] = 'Gi karakter for læringsutbytteenhet';
$string['gradeoutcomes'] = 'Læringsutbytte';
$string['gradeoutcomescourses'] = 'Kursresultater';
$string['gradepass'] = 'Ståkarakter';
$string['gradepass_help'] = '<p>Dersom et element har et karakterkrav som brukeren må oppnå for å bestå, kan du angi det her.</p>';
$string['gradepreferences'] = 'Karakterinnstillinger';
$string['gradepreferenceshelp'] = 'Hjelp for karakterinnstillinger';
$string['gradepublishing'] = 'Tillat publisering';
$string['gradepublishing_help'] = 'Slå på publisering i eksporter/importer: Eksporterte karakter kan nås ved å gå på en URL, uten å logge på Moodlesiten. Karakterer kan importeres ved å gå på en slik URL (noe som betyr at Moodlesiten kan importere karakterer som er publisert av en annen portal). Som standard er det bare administratorer som kan bruke denne egenskapen, pass på at bruker får opplæring før denne egenskapen blir lagt til for andre roller (fare for bokmerkedeling og nedlastingsaccelators, IP-restriksjoner osv.)';
$string['gradereport'] = 'Karakterrapport';
$string['graderreport'] = 'Karaktersetting';
$string['grades'] = 'Karakterer';
$string['gradesforuser'] = 'Karakterer for {$a->user}';
$string['gradesonly'] = 'Bare karakterer';
$string['gradessettings'] = 'Karakterinnstillinger';
$string['gradetype'] = 'Karaktertype';
$string['gradetype_help'] = '<p>Angi hvilken karaktertype som skal brukes: "ingen" (det gis ikke karakter), "verdi" (slår på innstillinger for minimums- og maksimumskarakter), "skala" (slår på innstillinger for skalaer) eller "tekst" (bare tilbakemeldinger). Bare karaktertypene "verdi" og "skala" kan beregnes i formler. Karakterypen for et aktivitetsbasert element bestemmes under innstillingene for den enkelte aktivitet.</p>';
$string['gradeview'] = 'Se karakter';
$string['gradewasmodifiedduringediting'] = 'Karakteren for {$a->itemname} av {$a->username} ble ignorert fordi den nylig har blitt oppdatert av noen andre.';
$string['gradeweighthelp'] = 'Hjelp for karaktervekting';
$string['groupavg'] = 'Gruppegjennomsnitt';
$string['hidden'] = 'Skjult';
$string['hiddenasdate'] = 'Vis innsendt dato for skjulte karakterer';
$string['hiddenasdate_help'] = 'Hvis brukeren ikke kan se skjulte karakter vis innsendingsdatoen i stedet for \'-\'.';
$string['hidden_help'] = 'Dersom avmerket, blir karakterer skjult for studentene. Du kan om ønskelig angi en "Skjult til"-dato for å frigi karakterene når  karaktersettingen er ferdig,';
$string['hiddenuntil'] = 'Skjult til';
$string['hiddenuntildate'] = 'Skjult til: {$a}';
$string['hideadvanced'] = 'Skjul avanserte egenskaper';
$string['hideaverages'] = 'Skjul gjennomsnitt';
$string['hidecalculations'] = 'Skjul beregninger';
$string['hidecategory'] = 'Skjult';
$string['hideeyecons'] = 'Skjul vis/skjul ikoner';
$string['hidefeedback'] = 'Skjul tilbakemelding';
$string['hideforcedsettings'] = 'Skjul tvungne innstillinger';
$string['hideforcedsettings_help'] = 'Ikke vis tvungne innstillinger i brukergrensesnittet for karakterboka.';
$string['hidegroups'] = 'Skjul grupper';
$string['hidelocks'] = 'Skjul låser';
$string['hidenooutcomes'] = 'Vis læringsutbytte';
$string['hidequickfeedback'] = 'Skjul hurtigtilbakemelding';
$string['hideranges'] = 'Skjul skalaer';
$string['hidetotalifhiddenitems'] = 'Skjule totaler dersom de inneholder skjulte elementer?';
$string['hidetotalifhiddenitems_help'] = '<p>Denne innstillingen angir hvorvidt totaler som inneholder skjulte karakterelementer skal vises for studentene eller erstattes med en bindestrek (-). Dersom skjulte elementer skal vises kan totalkarakter fortsatt beregnes med eller uten de skjulte elementene.</p>
<p>Dersom skjulte elementer ikke vises, vil totalkarakteren bli forskjellig fra den læreren ser, siden læreren alltid ser totalkarakterene basert på alle elementene, enten de er skjult eller ikke.</p>
<p>Dersom skjulte elementer tas med, kan studentene beregne de skjulte elementene.</p>';
$string['hidetotalshowexhiddenitems'] = 'Vis totaler hvor skjulte elementer er utelatt';
$string['hidetotalshowinchiddenitems'] = 'Vis totaler hvor skjulte elementer er regnet med';
$string['hideverbose'] = 'Skjul {$a->category}{$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sorter med høy karakter stigende';
$string['highgradedescending'] = 'Sorter med høy karakter synkende';
$string['highgradeletter'] = 'Høy';
$string['identifier'] = 'Identifiser bruker ved';
$string['idnumbers'] = 'Id nummer';
$string['ignore'] = 'Ignorer';
$string['import'] = 'Importer';
$string['importcsv'] = 'Importer CSV';
$string['importcustom'] = 'Importer som egendefinerte læringsmål (bare for dette kurset)';
$string['importerror'] = 'En feil oppstod, skriptet ble ikke oppkalt med riktige parametre.';
$string['importfailed'] = 'Importen feilet';
$string['importfeedback'] = 'Tilbakemelding fra import';
$string['importfile'] = 'Importfil';
$string['importfilemissing'] = 'Ingen fil ble lastet opp, gå tilbake til skjemaet og pass på at du laster opp en gyldig fil.';
$string['importfrom'] = 'Importer fra';
$string['importoutcomenofile'] = 'Opplastet fil er tom eller ødelagt. Vær vennlig og pass på at det er en gyldig fil . Problemet ble oppdaget i linje {$a}; dette utløses ved at datalinjen ikke har så mange kolonner som første linje (overskriftslinjen) eller at den importerte filen mangler forventede overskrifter. Se på den eksporterte filen for et eksempel på en fil med gyldige overskrifter.';
$string['importoutcomes'] = 'Importer læringsutbytte';
$string['importoutcomes_help'] = 'Læringsutbytte kan importeres via CSV på samme måte som de kan eksporteres som CSV.';
$string['importoutcomesuccess'] = 'Importert læringsmål "{$a->name}" med ID #{$a->id}';
$string['importplugins'] = 'Importer plugin-er';
$string['importpreview'] = 'Importer forhåndsvisning';
$string['importsettings'] = 'Importer innstillinger';
$string['importskippednomanagescale'] = 'Du har ikke tillatelse til å legge til nye skalaer, så læringsutbytte "{$a}" ble hoppet over ettersom det krever at en ny skala blir opprettet.';
$string['importskippedoutcome'] = 'Et læringsutbytte med kortnavn "{$a}" eksisterer allerede i denne sammenhengen, den i den importerte filen ble hoppet over.';
$string['importstandard'] = 'Importer som standard læringsutbytte';
$string['importsuccess'] = 'Karakterimport suksessfull';
$string['importxml'] = 'Importer XML';
$string['includescalesinaggregation'] = 'Inkluder skalaer i summering';
$string['includescalesinaggregation_help'] = 'Du kan velge om skalaer skal inkluderes som tall i alle oppsamlede karakterer i alle karakterbøker i alle kurs. ADVARSEL: hvis du forandre denne innstillinger vil alle summerte karakterer bli omberegnet.';
$string['incorrectcourseid'] = 'Kurs ID var feil';
$string['incorrectcustomscale'] = '(Ugyldig egendefinert skala, vennligst endre den.)';
$string['incorrectminmax'] = 'Minimum må være mindre en maksimum';
$string['inherit'] = 'Arv';
$string['intersectioninfo'] = 'Student/Karakter info';
$string['item'] = 'Item';
$string['iteminfo'] = 'Enhetsinfo';
$string['iteminfo_help'] = '<p>Plass for å skrive inn informasjon om elementet. Teksten du skriver inn vil ikke synes noe annet sted.</p>';
$string['itemname'] = 'Enhetsnavn';
$string['itemnamehelp'] = 'Navnet på denne enheten, gitt av modulen';
$string['items'] = 'Enheter';
$string['itemsedit'] = 'Rediger karakterenhet';
$string['keephigh'] = 'Behold den høyeste';
$string['keephigh_help'] = 'Hvis satt, vil dette valget bare beholde de X høyeste karakterene, X er den valgte verdien for dette valget.';
$string['keymanager'] = 'Nøkkelbehandler';
$string['lessthanmin'] = 'Karakteren for {$a->itemname} til {$a->username} er mindre en minimumm tillatt';
$string['letter'] = 'Bokstav';
$string['lettergrade'] = 'Bokstavkarakter';
$string['lettergradenonnumber'] = 'Low and/or High grade were non-numeric for';
$string['letterpercentage'] = 'Bokstav (prosent)';
$string['letterreal'] = 'Bokstav (virkelig)';
$string['letters'] = 'Bokstaver';
$string['linkedactivity'] = 'Linket aktivitet';
$string['linkedactivity_help'] = '<p>Angir en aktivitet som dette læringsresultatet er lenket til. Dette brukes tl å måle studentresultater mot kriterier som ikke er tilgjengelig via aktivitetens karakter alene.</p>';
$string['linktoactivity'] = 'Lenke til {$a->name} aktivitet';
$string['lock'] = 'Lås';
$string['locked'] = 'Låst';
$string['locked_help'] = 'Dersom avmerket vil ikke karakterer lenger automatisk oppdateres av den relaterte aktiviteten.';
$string['locktime'] = 'Lås etter';
$string['locktimedate'] = 'Låst etter: {$a}';
$string['lockverbose'] = 'Lås {$a->category}{$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Lowest';
$string['lowgradeletter'] = 'Low';
$string['manualitem'] = 'Manuell enhet';
$string['mapfrom'] = 'Kartlegg fra';
$string['mappings'] = 'Oversikt over karakterenhet';
$string['mapto'] = 'Kartlegg til';
$string['max'] = 'Høyeste';
$string['maxgrade'] = 'Maks karakter';
$string['meanall'] = 'Alle karakterer';
$string['meangraded'] = 'Ikke-tomme karakterer';
$string['meanselection'] = 'Karakterer valgt for kolonnegjennomsnitt';
$string['meanselection_help'] = 'Om felt uten karakter skal inkluderes når en regner ut middleverdien for hver kolonne.';
$string['median'] = 'Median';
$string['min'] = 'Laveste';
$string['missingscale'] = 'Skala må velges';
$string['mode'] = 'Modus';
$string['morethanmax'] = 'Karakteren lagt inn for {$a->itemname} til {$a->username} er høyere enn maksimum tillatt';
$string['moveselectedto'] = 'Flytt valgte elementer til';
$string['movingelement'] = 'Flytter {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = '<p>Faktoren som alle karakterer for dette karakterelementet vil bli ganget med - med en maksimums- og minimumskarakter.</p>';
$string['multfactorvalue'] = 'Multiplikatorverdi for {$a}';
$string['mypreferences'] = 'Mine innstillinger';
$string['myreportpreferences'] = 'Mine rapportinnstillinger';
$string['navmethod'] = 'Navigasjonsinnstillinger';
$string['neverdeletehistory'] = 'Aldri slett historien';
$string['newcategory'] = 'Ny kategori';
$string['newitem'] = 'Nytt element for karaktersetting';
$string['newoutcomeitem'] = 'Nytt element for læringsmål';
$string['no'] = 'Nei';
$string['nocategories'] = 'Karakterkategori kunne ikke bli lagt til eller funnet for dette kurset';
$string['nocategoryname'] = 'Ikke noe kategorinavn ble gitt';
$string['nocategoryview'] = 'No category to view by';
$string['nocourses'] = 'Det er ingen kurs ennå';
$string['noforce'] = 'Ikke tving';
$string['nogradeletters'] = 'No grade letters set';
$string['nogradesreturned'] = 'No grades returned';
$string['noidnumber'] = 'Ikke noe idnummer';
$string['nolettergrade'] = 'Ingen bokstav karakter for';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Received non-numeric value for';
$string['nonunlockableverbose'] = 'Karakteren kan ikke låses opp før {$a->itemname} er låst opp.';
$string['nonweightedpct'] = 'ikke-vekted %';
$string['nooutcome'] = 'Ikke noe resultat';
$string['nooutcomes'] = 'Elementets læringsutbytte må lenkes til kursets læringsmål, men det er ingen læringsmål for dette kurset. Vil du legge til et læringsmål nå?';
$string['nopublish'] = 'Ikke publiser';
$string['norolesdefined'] = 'Ingen roller definert i Administrasjon > Karakterbok > Generelle innstillinger > Roller for karaktersetting';
$string['noscales'] = 'Læringsmål må lenkes til en vurderingsskala globalt eller i kurset, men det finnes ingen her. Vil du legge til en skala nå?';
$string['noselectedcategories'] = 'ingen kategorier ble valgt';
$string['noselecteditems'] = 'ingen enheter ble valgt';
$string['notteachererror'] = 'Du må være lærer for å bruke denne aktiviteten.';
$string['nousersloaded'] = 'Ingen brukere lastet';
$string['numberofgrades'] = 'Antall karakterer';
$string['onascaleof'] = 'på en skala fra {$a->grademin} til {$a->grademax}';
$string['operations'] = 'Handlinger';
$string['options'] = 'Valg';
$string['others'] = 'Andre';
$string['outcome'] = 'Læringsutbytte';
$string['outcomeassigntocourse'] = 'Legg til et ekstra læringsmål til dette kurset.';
$string['outcomecategory'] = 'Lag læringsutbytte i kategori';
$string['outcomecategorynew'] = 'Ny kategori';
$string['outcomeconfirmdelete'] = 'Er du sikker på at du vil slette læringsutbytte "{$a}"?';
$string['outcomecreate'] = 'Legg til nytt læringsutbytte';
$string['outcomedelete'] = 'Slett læringsutbytte';
$string['outcomefullname'] = 'Fullt navn';
$string['outcome_help'] = 'Angi Læringsutbytte som denne karaktereren representerer i karakterboka. Bare utbytte som er gitt i dette kurset og nettstedsutbytte er tilgjengelige.';
$string['outcomeitem'] = 'Læringsutbytteenhet';
$string['outcomeitemsedit'] = 'Rediger læringsutbytteenhet';
$string['outcomereport'] = 'Læringsutbytterapport';
$string['outcomes'] = 'Læringsutbytte';
$string['outcomescourse'] = 'Læringsutbytte inkludert i kurset';
$string['outcomescoursecustom'] = 'Egendefinert brukt (ikke ta bort)';
$string['outcomescoursenotused'] = 'Standard ikke brukt';
$string['outcomescourseused'] = 'Standard brukt (ikke fjern)';
$string['outcomescustom'] = 'Egendefinert læringsutbytte';
$string['outcomeshortname'] = 'Kort navn';
$string['outcomesstandard'] = 'Standard læringsutbytte';
$string['outcomesstandardavailable'] = 'Tilgjengelig standard læringsutbytte';
$string['outcomestandard'] = 'Standard læringsutbytte';
$string['outcomestandard_help'] = '<p>Et standard læringsresultat er (globalt) tilgjengelig for alle kurs.</p>';
$string['overallaverage'] = 'Totalgjennomsnitt';
$string['overridden'] = 'Overstyrt';
$string['overridden_help'] = '<p>Dersom på, vil overstyringsflagget hindre alle senere automatiske endringer å justere verdien av karakteren. Dette flagget settes ofte internt i karakterboka, men kan også slås på og av manuelt via dette skjemaet.</p>';
$string['overriddennotice'] = 'Den endelige karakteren fra denne aktiviteten ble redigert manuelt.';
$string['overridesitedefaultgradedisplaytype'] = 'Overstyr nettstedsinnstillinger';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Merk av her for å aktivere overstyring av de standarder som er satt for standard visning av karakterer i karakterboka. Dette aktiverer skjemaelementer som lar deg definere bokstavkarakterer og grenseverdier du måtte trenge.</p>';
$string['parentcategory'] = 'Overordnet kategori';
$string['pctoftotalgrade'] = '% av total karakter';
$string['percent'] = 'Prosent';
$string['percentage'] = 'Prosentandel';
$string['percentageletter'] = 'Prosent (Bokstav)';
$string['percentagereal'] = 'Prosent (Virkelig)';
$string['percentascending'] = 'Sorter etter prosent stigende';
$string['percentdescending'] = 'Sorter etter prosent synkende';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pluss-faktor';
$string['plusfactor_help'] = '<p>Et tall som blir lagt til alle karakterer for dette karakterelementet, ETTER at gangefaktoren er medregnet.</p>';
$string['plusfactorvalue'] = 'Oppveid verdi for {$a}';
$string['points'] = 'points';
$string['pointsascending'] = 'Sort by points ascending';
$string['pointsdescending'] = 'Sorter synkende etter poeng';
$string['positionfirst'] = 'Første';
$string['positionlast'] = 'Siste';
$string['preferences'] = 'Innstillinger';
$string['prefgeneral'] = 'Generell';
$string['prefletters'] = 'Karakterbokstaver og grenseverdier';
$string['prefrows'] = 'Spesielle rader';
$string['prefshow'] = 'Vis/skjul endringer';
$string['previewrows'] = 'Forhåndsvis rader';
$string['profilereport'] = 'Brukerprofilrapport';
$string['profilereport_help'] = 'Karakter-rapport brukt på brukerens profilside.';
$string['publishing'] = 'Publiserer';
$string['quickfeedback'] = 'Hurtig tilbakemelding';
$string['quickgrading'] = 'Hurtig karaktersetting';
$string['quickgrading_help'] = '<p>Rask karaktersetting legger til et tekstfelt i hver karakter i karakteroversikten som lar deg redigere mange karakterer i en operasjon. Du kan deretter klikke på "Oppdater"-knappen for å utføre alle endringene på en gang, i stedet for en om gangen.</p>';
$string['range'] = 'Skala';
$string['rangedecimals'] = 'Antall desimaler for utvalget';
$string['rangedecimals_help'] = 'Antall desimaler som skal vises for utvalget';
$string['rangesdecimalpoints'] = 'Desimaler vist i skalaer';
$string['rangesdecimalpoints_help'] = '<p>Angir antall desimaler som skal vises for hver skala. Denne innstillinge kan bli overstyrt  pr. karakterelement.</p>';
$string['rangesdisplaytype'] = 'Skala visningstype';
$string['rangesdisplaytype_help'] = '<p>Angir hvordan skalaer skal vises. Dersom arv er valgt, vil visningstypen for hver kolonne bli brukt.</p>';
$string['rank'] = 'Rank';
$string['rawpct'] = 'Rå %';
$string['real'] = 'Virkelig';
$string['realletter'] = 'Virkelig (Bokstav)';
$string['realpercentage'] = 'Virkelig (Prosent)';
$string['recovergradesdefault'] = 'Gjenoppretter karakterer som standard';
$string['recovergradesdefault_help'] = 'Gjenoppretter gamle karakterer som standard når en bruker blir meldt inn på nytt i et kurs.';
$string['regradeanyway'] = 'Gi nye karakterer likevel';
$string['removeallcoursegrades'] = 'Slett alle karakterer';
$string['removeallcourseitems'] = 'Slett alle enheter og kategorier';
$string['report'] = 'Rapport';
$string['reportdefault'] = 'Rapport standard ({$a})';
$string['reportplugins'] = 'Rapportpluginer';
$string['reportsettings'] = 'Rapportinnstillinger';
$string['reprintheaders'] = 'Gjenta kolonneoverskrifter';
$string['respectingcurrentdata'] = 'lar nåværende konfigurasjon stå uendret';
$string['rowpreviewnum'] = 'Forhåndsvis rader';
$string['savechanges'] = 'Lagre endringer';
$string['savepreferences'] = 'Lagre innstillinger';
$string['scaleconfirmdelete'] = 'Er du sikker på at du vil slette denne skalaen: {$a}?';
$string['scaledpct'] = 'Skalert %';
$string['seeallcoursegrades'] = 'Se alle kurskarakterer';
$string['select'] = 'Velg {$a}';
$string['selectalloroneuser'] = 'Vel alle eller en bruker';
$string['selectauser'] = 'Velg en bruker';
$string['selectdestination'] = 'Velg mål for {$a}';
$string['separator'] = 'Delingstegn';
$string['sepcolon'] = 'Kolon';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Sett kategorier';
$string['setcategorieserror'] = 'You must first set the categories for your course before you can give weights to them.';
$string['setgradeletters'] = 'Sett bokstavkarakterer';
$string['setpreferences'] = 'Sett innstillinger';
$string['setting'] = 'Innstilling';
$string['settings'] = 'Innstillinger';
$string['setweights'] = 'Sett vektinger';
$string['showactivityicons'] = 'Vis aktivitetsikoner';
$string['showactivityicons_help'] = '<p>Hvorvidt aktivitetsikoner skal vises ved siden av aktivitetsnavn.</p>';
$string['showallhidden'] = 'Vis skjulte';
$string['showallstudents'] = 'Vis alle studenter';
$string['showanalysisicon'] = 'Vis karakteranalyseikonet';
$string['showanalysisicon_desc'] = 'Skal karakteranalyseikonet vises som standard? Hvis aktivitetsmodulen støtter det, vil karakteranalyseikonet lenke til en side med en mer detaljert utredning om karakteren og hvordan den ble oppnådd.';
$string['showanalysisicon_help'] = 'Hvis aktivitetsmodulen støtter det, vil karakteranalyseikonet lenke til en side med en mer detaljert begrunnelse for karakteren og hvordan den ble oppnådd.';
$string['showaverage'] = 'Vis gjennomsnitt';
$string['showaverage_help'] = 'Vise gjennomsnittkolonnen? Studenter kan bli i stand til å finne ut av medstudenters karakterer dersom gjennomsnittet blir beregnet på få studenter og karakter. Av ytelseshensyn er gjennomsnitt omtrentlig dersom den baserer seg på skjulte elementer.';
$string['showaverages'] = 'Vis kolonnegjennomsnitt';
$string['showaverages_help'] = 'Om en skal vise middelverdien for hver kolonne.';
$string['showcalculations'] = 'Vis beregninger';
$string['showcalculations_help'] = 'Om en skal vise beregningsikon nær hver karakterenhet og kategori, verktøytips over beregnede verdier og en visuell markering som viser at kolonnen er beregnet.';
$string['showeyecons'] = 'Vis vis/skjul ikoner';
$string['showeyecons_help'] = 'Om en skal vise/skjule ikon i nærheten av hver karakter (kontrollerer synbarheten for bruker).';
$string['showfeedback'] = 'Vis tilbakemelding';
$string['showfeedback_help'] = 'Vise tilbakemeldingskolonnen?';
$string['showgrade'] = 'Vis karakterer';
$string['showgrade_help'] = 'Vise karakterkolonnen?';
$string['showgroups'] = 'Vis grupper';
$string['showhiddenitems'] = 'Vis skjulte elementer';
$string['showhiddenitems_help'] = 'Angir hvordan skjulte karakterenheter vises.

Hvis Skjul er valgt, er fullstendig skjult. Hvis Vis er valgt, vil den skjulte karakteren vises i grått med karakteren skjult fullstendig. Hvis "Bare skjult til" er valgt, vil karakteren skjules til datoen som vises i grått med karakteren skjult fullstendig til angitt dato, hvor hele karakterenheten vises.';
$string['showhiddenuntilonly'] = 'Skjult til:';
$string['showlettergrade'] = 'Vis bokstavkarakterer';
$string['showlettergrade_help'] = 'Vise bokstavkarakter kolonnen?';
$string['showlocks'] = 'Vis låser';
$string['showlocks_help'] = 'Om en skal vise et lås/lås-opp ikon nær karakteren';
$string['shownohidden'] = 'Ikke vis';
$string['shownooutcomes'] = 'Skjul læringsutbytte';
$string['shownumberofgrades'] = 'Vis antall karakterer i gjennomsnitt';
$string['shownumberofgrades_help'] = 'Om en skal vise antall karakter som brukes for å regne ut middelverdien i parantes etter hvert gjennomsnitt, for eksempel 45 (34).';
$string['showonlyactiveenrol'] = 'Vis kun aktive påmeldinger';
$string['showonlyactiveenrol_help'] = 'Denne innstillingen bestemmer om bare aktive påmeldte brukere skal være synlige i karakterboka. Hvis aktivert, blir ikke utestengte brukere vises i karakterboken.';
$string['showpercentage'] = 'Vis prosent';
$string['showpercentage_help'] = 'Skal det vises en ‰-verdi av hvert karakterelement?';
$string['showquickfeedback'] = 'Vis hurtigtilbakemelding';
$string['showquickfeedback_help'] = 'Hurtig tilbakemelding legger til et tekstelement i hver karaktercelle i karakter-rapporten, og gjør at du kan redigere tilbakemelding for mange karakterer på en gang. Du kan så klikke på Oppdaterknappen for å gjennomføre alle disse endringene med en gang, istedet for en om gangen.';
$string['showrange'] = 'Vis spekter';
$string['showrange_help'] = 'Vise spekterkolonnen?';
$string['showranges'] = 'Vis områder';
$string['showranges_help'] = 'Om en skal vise utvalget av karakterer for hver kolonne i en ekstra rekke';
$string['showrank'] = 'Vis rangering';
$string['showrank_help'] = 'Skal en vise brukerens rangering i forhold til resten av klassen, for hver karakterenhet?';
$string['showuserimage'] = 'Vis brukers profilbilde';
$string['showuserimage_help'] = 'Om en skal vise brukerens profilbilde ved siden av navnet i karakter-rapporten.';
$string['showverbose'] = 'Vis {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Vis vektinger';
$string['showweight_help'] = 'Vise kolonnen for karaktervektingr?';
$string['simpleview'] = 'Forenklet visning';
$string['sitewide'] = 'Nettstedsgjeldende';
$string['sort'] = 'sorter';
$string['sortasc'] = 'Sorter i stigende rekkefølge';
$string['sortbyfirstname'] = 'Sorter etter fornavn';
$string['sortbylastname'] = 'Sorter etter etternavn';
$string['sortdesc'] = 'Sorter i synkende orden';
$string['standarddeviation'] = 'Standardavvik';
$string['stats'] = 'Statistikk';
$string['statslink'] = 'Stats';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Studenter per side';
$string['studentsperpage_help'] = 'Antall studenter å vise per side i karakter-rapporten.';
$string['studentsperpagereduced'] = 'Redusert maks antall studenter per side fra {$a->originalstudentsperpage} til {$a->studentsperpage}. Vurder å øke PHP-innstillingen max_input_vars fra {$a->maxinputvars}.';
$string['subcategory'] = 'Normal kategori';
$string['submissions'] = 'Innsendelser';
$string['submittedon'] = 'Innsendt: {$a}';
$string['switchtofullview'] = 'Bytt til full visning';
$string['switchtosimpleview'] = 'Bytt til forenklet visning';
$string['tabs'] = 'Fliker';
$string['topcategory'] = 'Superkategori';
$string['total'] = 'Total';
$string['totalweight100'] = 'Total vekting er lik 100';
$string['totalweightnot100'] = 'Total vekting er ikke lik 100';
$string['turnfeedbackoff'] = 'Slå av tilbakemelding';
$string['turnfeedbackon'] = 'Slå på tilbakemelding';
$string['typenone'] = 'Ingen';
$string['typescale'] = 'Skala';
$string['typescale_help'] = '<p>Når du bruker karaktertypen "Skala", kan en skala velges. Skalaen for en aktivitetsbasert karakter blir satt ved ved å oppdatere innstillingene for aktiviteten det gjelder.</p>';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Verdi';
$string['uncategorised'] = 'Ukategorisert';
$string['unchangedgrade'] = 'Karakter uendret';
$string['unenrolledusersinimport'] = 'Importen inkluderte følgende karakterer for brukere som for tiden ikke er med i kurset: {$a}';
$string['unlimitedgrades'] = 'Ingen karakterbegrensning';
$string['unlimitedgrades_help'] = 'Som standard avgrenses karakterer av en minimums- og maksimumsverdi for den karakteren. Ved aktivering overstyrer du denne grensen og tillater at karakterer over 100% kan skrives inn manuelt. Vi anbefaler at denne innstillingen gjøres på en rolig tid på døgnet, da den medfører omberegning av karakterer og høy serverbelastning.';
$string['unlock'] = 'Lås opp';
$string['unlockverbose'] = 'Lås opp {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Ubrukt';
$string['updatedgradesonly'] = 'Eksporter bare nye eller oppdaterte karakter';
$string['uploadgrades'] = 'Last opp karakterer';
$string['useadvanced'] = 'Bruk avanserte egenskaper';
$string['usedcourses'] = 'Brukte kurs';
$string['usedgradeitem'] = 'Brukt karakterenhet';
$string['usenooutcome'] = 'Ikke bruk læringsutbytte';
$string['usenoscale'] = 'Ikke bruk skala';
$string['usepercent'] = 'Bruk prosent';
$string['user'] = 'Bruker';
$string['userenrolmentsuspended'] = 'Brukerpåmelding avbrutt';
$string['usergrade'] = 'Bruker {$a->fullname} ({$a->useridnumber}) om emnet {$a->gradeidnumber}';
$string['userid'] = 'Bruker ID';
$string['usermappingerror'] = 'Feil i brukermappingen: Fant ikke bruker med {$a->field} av "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Bruker er ikke medlem av gjeldende gruppe.';
$string['usermappingerrorusernotfound'] = 'Feil i brukermappingen. Fant ikke brukeren.';
$string['userpreferences'] = 'Brukerinnstillinger';
$string['useweighted'] = 'Bruk vektet';
$string['verbosescales'] = 'Utvidede skalaer';
$string['viewbygroup'] = 'Gruppe';
$string['viewgrades'] = 'Se karakterer';
$string['warningexcludedsum'] = 'Advarsel: Utelukking av karakterer er ikke kompatibelt med beregning av totalsum.';
$string['weight'] = 'vekting';
$string['weightcourse'] = 'Bruk vektede karakterer for dette kurset';
$string['weightedascending'] = 'Sorter etter vektet prosent stigende';
$string['weighteddescending'] = 'Sorter etter vektet prosent synkende';
$string['weightedpct'] = 'vektet %';
$string['weightedpctcontribution'] = 'vektet % bidrag';
$string['weightorextracredit'] = 'Vekting eller tilleggspoeng';
$string['weights'] = 'Vekting';
$string['weightsedit'] = 'Rediger vekting og tilleggspoeng';
$string['weightuc'] = 'Vekt';
$string['writinggradebookinfo'] = 'Skriver karakterbokinnstillinger';
$string['xml'] = 'XML';
$string['yes'] = 'Ja';
$string['yourgrade'] = 'Din karakter';
