<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Det er nye foruminnlegg';
$string['addanewdiscussion'] = 'Skriv i dette forumet';
$string['addanewquestion'] = 'Legg til et nytt spørsmål';
$string['addanewtopic'] = 'Skriv i dette forumet';
$string['advancedsearch'] = 'Avansert søk';
$string['allforums'] = 'Alle forum';
$string['allowdiscussions'] = 'Kan en {$a} skrive i dette forumet?';
$string['allowsallsubscribe'] = 'Dette forumet tillater at alle kan velge å abonnere eller ikke';
$string['allowsdiscussions'] = 'Dette forumet tillater alle å starte nye diskusjoner.';
$string['allsubscribe'] = 'Abonnerer på alle fora';
$string['allunsubscribe'] = 'Avslutt alle abonnement';
$string['alreadyfirstpost'] = 'Det finnes allerede en første post i diskusjonen';
$string['anyfile'] = 'Hvilken som helst fil';
$string['areaattachment'] = 'Vedlegg';
$string['areapost'] = 'Meldinger';
$string['attachment'] = 'Vedlegg';
$string['attachment_help'] = 'Du kan velge å legge til en eller flere filer til en forumpost. Hvis du legger ved et bilde, vil det bli vist etter meldingen.';
$string['attachmentnopost'] = 'Du kan ikke eksportere vedlegge uten en post-id';
$string['attachments'] = 'Vedlegg';
$string['attachmentswordcount'] = 'Vedlegg og ordtelling';
$string['blockafter'] = 'Legg inn grense for blokkering';
$string['blockafter_help'] = 'Denne innstillingen angir et maks. antall poster en bruker kan poste innenfor angitt tidsperiode. Brukere med egenskapen mod/forum: postwithoutthrottling er unntak fra postbegrensing';
$string['blockperiod'] = 'Tidsperiode for blokkering';
$string['blockperioddisabled'] = 'Ikke blokker';
$string['blockperiod_help'] = 'Studenter kan stenges ute fra å poste flere enn et visst antall poster i løpet av en angitt periode. Brukere med egenskapen mod/forum: postwithoutthrottling er unntak fra postbegrensing
';
$string['blogforum'] = 'Standardforum vist i blogglignende format';
$string['bynameondate'] = 'av {$a->name} - {$a->date}';
$string['cannotadd'] = 'Kan ikke legge til diskusjon i dette forumet';
$string['cannotadddiscussion'] = 'Du må være medlem av en gruppe for å legge til ny diskusjon i dette forumet.';
$string['cannotadddiscussionall'] = 'Du har ikke tillatelse til å legge til et nytt diskusjonsemne for alle deltakerne.';
$string['cannotaddsubscriber'] = 'Kan ikke legge til abonnent med brukerid {$a} til dette forumet.';
$string['cannotaddteacherforumto'] = 'Ikke mulig å legge til konvertert lærerforum-instans  i seksjon 0 i kurset.';
$string['cannotcreatediscussion'] = 'Kan ikke lage ny diskusjon';
$string['cannotcreateinstanceforteacher'] = 'Kunne ikke opprette ny instans av kursmodulen lærerforum.';
$string['cannotdeletepost'] = 'Du kan ikke slette dette innlegget!';
$string['cannoteditposts'] = 'Du kan ikke redigere andre folks innlegg';
$string['cannotfinddiscussion'] = 'Kan ikke finne diskusjonen i dette forumet';
$string['cannotfindfirstpost'] = 'Kan ikke finne første innlegg i dette forumet';
$string['cannotfindorcreateforum'] = 'Kunne ikke finne eller opprette et nyhetsforum for hovedsiden';
$string['cannotfindparentpost'] = 'Kunne ikke finne overordnet nivå for innlegg {$a}';
$string['cannotmovefromsingleforum'] = 'Kan ikke flytte en diskusjon fra forumtypen "Enkelt diskusjonsforum".';
$string['cannotmovenotvisible'] = 'Forum ikke synlig';
$string['cannotmovetonotexist'] = 'Du kan ikke flytte til det forumet - det eksisterer ikke!';
$string['cannotmovetonotfound'] = 'Fant ikke målforumet i dette kurset.';
$string['cannotmovetosingleforum'] = 'Kan ikke flytte diskusjoner til forumtypen "Diskusjonsforum for ett enkelt tema".';
$string['cannotpurgecachedrss'] = 'Kunne ikke tømme mellomlagrede RSS-agenter for kilden og/eller målforumene - sjekk filtillatelsene.';
$string['cannotremovesubscriber'] = 'Kunne ikke fjerne abbonnenten med id {$a} fra dette forumet!';
$string['cannotreply'] = 'Du kan ikke svare på dette innlegget';
$string['cannotsplit'] = 'Diskusjoner fra dette forumet kan ikke splittes';
$string['cannotsubscribe'] = 'Beklager, men du må være gruppemedlem for å abbonere.';
$string['cannottrack'] = 'Kunne ikke slå av sporing for det forumet';
$string['cannotunsubscribe'] = 'Kunne ikke stoppe abbonnementet ditt på det forumet';
$string['cannotupdatepost'] = 'Du kan ikke oppdatere dette innlegget';
$string['cannotviewpostyet'] = 'Du kan ikke lese andre studenters spørsmål i denne diskusjonen ennå fordi du ikke har lagt inn noe selv';
$string['cannotviewusersposts'] = 'Denne brukeren har ikke postet noen innlegg som du har tilgang til å se.';
$string['cleanreadtime'] = 'Tidspunkt for merking av gamle innlegg som lest';
$string['completiondiscussions'] = 'Studenter må lage diskusjoner:';
$string['completiondiscussionsgroup'] = 'Krever diskusjoner';
$string['completiondiscussionshelp'] = 'krever at diskusjonene skal fullføres';
$string['completionposts'] = 'Studenten må poste diskusjoner eller svar:';
$string['completionpostsgroup'] = 'Trenger innlegg';
$string['completionpostshelp'] = 'krever  at diskusjoner eller svar skal fullføres';
$string['completionreplies'] = 'Studenter må svare på innlegg:';
$string['completionrepliesgroup'] = 'Behøver svar';
$string['completionreplieshelp'] = 'trenger svar for å fullføre';
$string['configcleanreadtime'] = 'Tidspunkt for sletting av gamle, leste innlegg.';
$string['configdigestmailtime'] = 'Brukere som velger å få epost tilsendt i en samlesending vil få den en gang daglig. Denne settingen kontrollerer når på dagen samlesendingen vil bli sendt ut (neste gang cron kjører etter dette tidspunktet vil sende den ut).';
$string['configdisplaymode'] = 'Standard visningsmåte for diskusjoner dersom dette ikke er valgt.';
$string['configenablerssfeeds'] = 'Denne bryteren vil gjøre det mulig å få RSS matinger for alle fora. Du må allikevel manuelt slå på nating manuelt i innstillingene for hvert forum.';
$string['configenabletimedposts'] = 'Settes til "JA" dersom du vil tillate innstilling av når nye foruminnlegg skal bli synlige. (Under utvikling og ikke ferdig testet)';
$string['configlongpost'] = 'Alle innlegg over denne lengden (ikke inkludert HTML) blir regnet som lange.';
$string['configmanydiscussions'] = 'Maksimum antall diskusjoner vist i et forum per side';
$string['configmaxattachments'] = 'Standardverdi for maks antall tillatte vedlegg pr. innlegg';
$string['configmaxbytes'] = 'Standard maksimum størrelse for alle forumvedleggene på nettstedet (overordnet klassenes grenser og andre lokale innstillinger)';
$string['configoldpostdays'] = 'Hvor mange dager gamle et innlegg må være for at det skal betraktes som lest.';
$string['configreplytouser'] = 'Når et innlegg i et forum er sendt ut, skal det inneholde brukerens epostadresse slik at mottakere kan svare personlig istedenfor via forumet?';
$string['configshortpost'] = 'Alle innlegg under denne lengden (ikke inkludert HTML) blir regnet som korte.';
$string['configtrackingtype'] = 'Standard innstilling for lesesporing';
$string['configtrackreadposts'] = 'Sett til \'ja\' hvis du ønsker å spore lest/ulest for hver bruker.';
$string['configusermarksread'] = 'Hvis \'ja\', må brukeren manuelt merke et innlegg som lest. Hvis \'nei\', blir innlegget merket som lest når det blir sett.';
$string['confirmsubscribe'] = 'Ønsker du virkelig å abbonnere på forumet {$a}?';
$string['confirmunsubscribe'] = 'Ønsker du virkelig å avslutte abbonnementet på forumet {$a}?';
$string['couldnotadd'] = 'Kunne ikke legge ut innlegget ditt pga. en ukjent feil';
$string['couldnotdeletereplies'] = 'Beklager, innlegget kan ikke slettes siden noen allerede har svart på det';
$string['couldnotupdate'] = 'Kunne ikke oppdatere innlegget pga. en ukjent feil';
$string['delete'] = 'Slett';
$string['deleteddiscussion'] = 'Innlegget er slettet';
$string['deletedpost'] = 'Innlegget er slettet';
$string['deletedposts'] = 'Disse innleggene er slettet';
$string['deletesure'] = 'Er du sikker på at du vil slette dette innlegget?';
$string['deletesureplural'] = 'Er du sikker på at du vil slette dette innlegget og alle svarene({$a} innlegg)';
$string['digestmailheader'] = 'Her kommer din daglige samlepost fra forumene på {$a->sitename}. Gå til {$a->userprefs} hvis du vil endre innstillingene for epostutsendelse.';
$string['digestmailpost'] = 'Endre innstillinger for samleutsending av forummeldinger';
$string['digestmailprefs'] = 'Din brukerprofil';
$string['digestmailsubject'] = 'Samlepost fra forumet {$a}';
$string['digestmailtime'] = 'Samlesending av epost sendes ut kl:';
$string['digestsentusers'] = 'Sendte samlepost til {$a} brukere.';
$string['disallowsubscribe'] = 'Abonnementer er ikke tillatt';
$string['disallowsubscribeteacher'] = 'Abonnementer er ikke tillatt (med unntak av lærere)';
$string['discussion'] = 'Diskusjon';
$string['discussionmoved'] = 'Denne diskusjonen er flyttet til \'{$a}\'.';
$string['discussionmovedpost'] = 'Denne diskusjonen er blitt flyttet <a href="{$a->discusshref}">hit</a> i forumet <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Navn på diskusjon';
$string['discussions'] = 'Diskusjoner';
$string['discussionsstartedby'] = 'Diskusjoner startet av {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusjoner nylig startet av {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusjoner startet av {$a->fullname} i {$a->coursename}';
$string['discussthistopic'] = 'Diskuter dette emnet';
$string['displayend'] = 'Vis slutten';
$string['displayend_help'] = 'Denne innstillingen angir hvorvidt et foruminnlegg skal skjules etter en gitt dato. Merk at administratorer alltid kan se foruminnlegg.';
$string['displaymode'] = 'Visningsmodus';
$string['displayperiod'] = 'Vis perioden';
$string['displaystart'] = 'Vis starten';
$string['displaystart_help'] = '<p>Du kan velge om dine foruminnlegg skal vises fra en bestemt dato, skjules fra en bestemt dato eller bare vises en angitt periode.</p>

<p>Fjern hakene fra Deaktiver-boksene for å vise start og/eller sluttdato.</p>

<p>Merk at brukere med admnistratorrettigheter vil se meldinger før og etter datobegrensninger som er satt.</p>';
$string['displaywordcount'] = 'Vis ordtelling';
$string['displaywordcount_help'] = 'Denne innstillingen bestemmer hvorvidt ordtellingen for hver post skal vises eller ikke.';
$string['eachuserforum'] = 'Hver bruker starter en diskusjon';
$string['edit'] = 'Rediger';
$string['editedby'] = 'Redigert av {$a->name} - orginalinnlegg {$a->date}';
$string['editedpostupdated'] = '{$a}s poster ble oppdatert';
$string['editing'] = 'Redigerer';
$string['emaildigest_0'] = 'Du vil motta en e-post for hvert foruminnlegg.';
$string['emaildigest_1'] = 'Du vil motta en e-post hver dag som inneholder alle nye foruminnlegg.';
$string['emaildigest_2'] = 'Du vil motta en e-post hver dag som inneholder emnet for hvert foruminnlegg.';
$string['emaildigestcompleteshort'] = 'Hele innlegg';
$string['emaildigestdefault'] = 'Standard ({$a})';
$string['emaildigestoffshort'] = 'Ingen oppsummering';
$string['emaildigestsubjectsshort'] = 'Kun emnefelt';
$string['emaildigesttype'] = 'Valg for oppsummeringseposter';
$string['emaildigesttype_help'] = 'Hva slags varslinger du skal motta for hvert forum.

* Standard - følger samleinnstillingene gitt i din brukerprofil. Når du oppdaterer brukerprofilen din vil endringene være gjeldende her også.
* Ingen oppsamling: Du vil da få en epost pr. foruminnlegg.
* Samlesending med komplette bidrag: Du vil få en daglig epost med fullt innhold fra alle nye bidrag i forumene.
* Samlesending med opplisting av bidrag: Du vil få en daglig epost som inneholder titlene på alle bidrag denne dagen.';
$string['emaildigestupdated'] = 'Innstillingene for samlesending av foruminnlegg er endret til \'{$a->maildigesttitle}\' for forumet \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Din standard profilinnstilling for \'{$a->maildigesttitle}\' er benyttet for forumet \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Noe var galt med innlegget ditt. Kanskje det var blankt, eller vedlegget var for stort. Endringene dine ble ikke lagret. ';
$string['erroremptymessage'] = 'Innleggsmeldingen kan ikke være tom';
$string['erroremptysubject'] = 'Innleggstittel kan ikke være tom.';
$string['errorenrolmentrequired'] = 'Du må være påmeldt dette kurset for å få tilgang til dette innholdet';
$string['errorwhiledelete'] = 'Det oppsto en feil under slettingen av posten.';
$string['event_assessable_uploaded'] = 'Noe innhold er blitt postet.';
$string['everyonecanchoose'] = 'Alle kan velge om de vil abonnere';
$string['everyonecannowchoose'] = 'Abonnere er nå valgfritt for alle';
$string['everyoneisnowsubscribed'] = 'Alle er nå abonnenter på dette forumet';
$string['everyoneissubscribed'] = 'Alle abonnerer på dette forumet';
$string['existingsubscribers'] = 'Esksisterende abonnenter';
$string['exportdiscussion'] = 'Eksporter hele diskusjonen';
$string['forcedreadtracking'] = 'Tillatt tvungen sporing av uleste innlegg';
$string['forcedreadtracking_desc'] = 'Tillater forum til å bli satt opp med tvungen sporing av uleste innlegg. Dette kan medføre dårligere ytelse for noen brukere, spesielt i kurs som har mange forum og foruminnlegg. Hvis deaktivert - vil alle forum som tidligere har vært angitt som tvunget bli behandlet som frivillig sporing.';
$string['forcessubscribe'] = 'Dette forumet tvinger alle til å abonnere';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Legg til et nytt forum';
$string['forum:addnews'] = 'Legg til nyhet';
$string['forum:addquestion'] = 'Legg til spørsmål';
$string['forum:allowforcesubscribe'] = 'Tillat å tvinge abonnement';
$string['forumauthorhidden'] = 'Forfatter (skjult)';
$string['forumblockingalmosttoomanyposts'] = 'Du er i ferd med å nå grensen for innlegg. Du har sendt inn {$a->numposts} ganger på den siste {$a->blockperiod} og grensen er {$a->blockafter} innlegg.';
$string['forumbodyhidden'] = 'Dette innlegget kan du ikke se, sannsynligvis fordi du ikke har postet noe innlegg i diskusjonen ennå, fordi ventetiden før publisering ikke er utløpt ennå (vanligvis 30 minutter), fordi diskusjonen ikke har startet ennå eller fordi diskusjonen er utgått.';
$string['forum:createattachment'] = 'Sett inn vedlegg';
$string['forum:deleteanypost'] = 'Slett ethvert innlegg (når som helst)';
$string['forum:deleteownpost'] = 'Slett egne innlegg (innen fristen)';
$string['forum:editanypost'] = 'Redigert ethvert innlegg';
$string['forum:exportdiscussion'] = 'Eksporter hele diskusjonen';
$string['forum:exportownpost'] = 'Eksporter ditt eget innlegg';
$string['forum:exportpost'] = 'Eksporter innlegg';
$string['forumintro'] = 'Forumbeskrivelse';
$string['forum:managesubscriptions'] = 'Administrere abonnenter';
$string['forum:movediscussions'] = 'Flytte diskusjoner';
$string['forumname'] = 'Forumnavn';
$string['forumposts'] = 'Foruminnlegg';
$string['forum:postwithoutthrottling'] = 'Unntak fra innleggskø';
$string['forum:rate'] = 'Vurder innlegg';
$string['forum:replynews'] = 'Svar på nyheter';
$string['forum:replypost'] = 'Svare på innlegg';
$string['forums'] = 'Forum';
$string['forum:splitdiscussions'] = 'Dele opp diskusjoner';
$string['forum:startdiscussion'] = 'Starte nye diskusjoner';
$string['forumsubjecthidden'] = 'Tema (skjult)';
$string['forumtracked'] = 'Uleste innlegg skal spores';
$string['forumtrackednot'] = 'Uleste innlegg skal ikke spores';
$string['forumtype'] = 'Forumtype';
$string['forumtype_help'] = 'Det finnes fem forskjellige forumtyper:

* En enkel diskusjon - kun ett diskusjonstema, alt på en side. Passer bra for korte, fokuserte diskusjoner.

* Vanlig forum - er et åpent forum der alle (dersom dette ikke begrenses i andre innstillinger) kan starte nye diskusjoner. Dette egner seg for de fleste formål.

* Hver bruker starter en diskusjon - alle brukerne kan starte en ny diskusjon. Alle (dersom dette ikke begrenses i andre innstillinger) kan likevel svare på hvert enkelt diskusjonsinnlegg. Dette passer bra når du vil at hver enkelt deltaker i klassen skal skrive ett diskusjonsinnlegg f.eks. om deres refleksjoner om ukens emne, og alle andre skal evt. kunne gi respons til disse.

Spørsmål og svar forum - Denne forumtypen krever at brukerne poster sitt svar før de får se hva andre har svart på samme spørsmålet. Når de har bidratt, åpnes forumet for visning av andres innlegg og de kan poste innlegg på andre bidrag på vanlig måte. Denne forumtypen åpner derfor for like vilkår for alle brukerne og oppmuntrer til utforming av originale og uavhengige bidrag fra hver enkelt.';
$string['forum:viewallratings'] = 'Vis alle vurderinger  gitt av brukere';
$string['forum:viewanyrating'] = 'Se alle vurderinger';
$string['forum:viewdiscussion'] = 'Se diskusjoner';
$string['forum:viewhiddentimedposts'] = 'Se innlegg før redigeringsfristen er ute';
$string['forum:viewqandawithoutposting'] = 'Alltid vise Q og A innlegg';
$string['forum:viewrating'] = 'Se dine vurderinger';
$string['forum:viewsubscribers'] = 'Se abonnentene';
$string['generalforum'] = 'Vanlig forum (Passer i de fleste sammenhenger)';
$string['generalforums'] = 'Generelle forum';
$string['hiddenforumpost'] = 'Skjulte foruminnlegg';
$string['inforum'] = 'i {$a}';
$string['introblog'] = 'Innleggene i dette forumet blir automatisk kopiert hit fra brukerbloggene koblet til dette kurset siden blogginnleggene ikke lenger er tilgjengelige.';
$string['intronews'] = 'Her vil det komme nyheter og kunngjøringer.';
$string['introsocial'] = 'Et åpent forum der du kan skrive om hva du vil';
$string['introteacher'] = 'Et forum kun for lærere';
$string['invalidaccess'] = 'TIlgangen din til denne siden er feil';
$string['invaliddigestsetting'] = 'En ugyldig innstilling for samlesendinger ble angitt.';
$string['invaliddiscussionid'] = 'Diskusjons ID var feil eller eksisterer ikke lenger';
$string['invalidforcesubscribe'] = 'Feil tvangsinnmeldingsmodus';
$string['invalidforumid'] = 'Forum ID var feil';
$string['invalidparentpostid'] = 'Overordnet innleggs ID var feil';
$string['invalidpostid'] = 'Ugyldig post ID - {$a}';
$string['lastpost'] = 'Siste innlegg';
$string['learningforums'] = 'Læringsforum';
$string['longpost'] = 'Lang post';
$string['mailnow'] = 'Send nå';
$string['manydiscussions'] = 'Diskusjoner pr.side';
$string['markalldread'] = 'Marker alle innlegg i denne diskusjonen som lest';
$string['markallread'] = 'Marker alle innleggene i dette forumet som lest';
$string['markread'] = 'Marker som lest';
$string['markreadbutton'] = 'Marker <br /> som lest';
$string['markunread'] = 'Marker som ulest';
$string['markunreadbutton'] = 'Marker <br /> som ulest';
$string['maxattachments'] = 'Maks antall vedlegg';
$string['maxattachments_help'] = 'Denne innstillingen angir maks antall filer som kan legges ved et foruminnlegg.';
$string['maxattachmentsize'] = 'Maksimum størrelse på vedlegg';
$string['maxattachmentsize_help'] = '<p>
Den person som har laget forumet kan (snart) sette begrensninger for hvor store
vedlegg kan være.&nbsp;
</p>
<p>
Noen ganger er det mulig å laste opp større filer enn dette, men de blir ikke
lagret, og du kan få en feilmelding.
</p>';
$string['maxtimehaspassed'] = 'Beklager, men makstiden ({$a}) for å kunne redigere dette innlegget har gått ut.';
$string['message'] = 'Melding';
$string['messageprovider:digests'] = 'Abbonnerer på samlet utsending av foruminnlegg';
$string['messageprovider:posts'] = 'Foruminnlegg du abonnerer på';
$string['missingsearchterms'] = 'Følgende søkeord finnes bare i HTML-koden i denne meldingen:';
$string['modeflatnewestfirst'] = 'Vis svar flatt, nyeste innlegg først.';
$string['modeflatoldestfirst'] = 'Vis svar flatt, eldste innlegg først.';
$string['modenested'] = 'Vis svar nøstet (Overskrift og innhold)';
$string['modethreaded'] = 'Vis svar som tråd (Kun overskrifter)';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Aktivitetsmodulen Forum gjør det mulig for deltakere å ha asynkrone diskusjoner, dvs. diskusjoner som finner sted i løpet av en lengre tidsperiode.

Du kan velge mellom flere forumtyper, for eksempel standard forum der hvem som helst, når som helst kan starte en ny diskusjon; forum der hver student kan starte bare en diskusjon hver; eller et spørsmål og svar-forum der studentene må poste et svar før de kan se de andre studentenes poster. Lærere kan tillate filopplasting i foruminnlegg. Bilder som lastes opp vises i innlegget.

Deltakere kan abonnere på forum for å få e-postkopier av nye forumposter. Lærere kan sette abonneringinnstillingene til valgfritt, tvunget eller auto, eller slå av abonnering helt. Hvis nødvendig, kan elevene hindres fra å legge til mer enn et bestemt antall poster i en bestemt tidsperiode; dette kan hindre enkeltstudenter fra å dominere diskusjoner.

Forumposter kan vurderes av lærere eller studenter. Vurderingene kan legges sammen til en sammenlagt karakter som registreres i karakterboken.

Forum har mange bruksområder, for eksempel:

* Et sosialt møtested der studenter kan bli kjent med hverandre
* Til kursrelaterte kunngjøringer (ved bruk av nyhetsforum med tvunget abonnement)
* Til diskusjon av kursinnhold eller litteratur
* Til å fortsette en diskusjon om et spørsmål som ble startet i klasserommet
* Til diskusjoner mellom lærere (ved bruk av skjult forum)
* Et hjelpesenter der lærere og studenter kan gi hverandre råd
* Som et støtteområde for privat kommunikasjon mellom student og lærer (ved bruk av forum med separate grupper og kun en student i hver gruppe)
* Til utvidede oppgaver/aktiviteter, for eksempel \'brain teasere\' som studenter kan tenke på og foreslå løsninger til';
$string['modulenameplural'] = 'Forum';
$string['more'] = 'mer';
$string['movedmarker'] = '(Flyttet)';
$string['movethisdiscussionto'] = 'Flytt diskusjonen til et annet forum';
$string['mustprovidediscussionorpost'] = 'Du må angi  enten en diskusjons ID eller innleggs ID for å kunne eksportere';
$string['namenews'] = 'Oppslagstavle';
$string['namenews_help'] = '<p>Oppslagstavla er et forum som automatisk opprettes i alle nye kurs og på hovedsiden. Det er ment for generell informasjon og du kan bare ha en oppslagstavle pr. kurs.</p>

<p>Blokken "Siste nyheter" vil vise de nyeste innleggene fra Oppslagstavla (selv om du gir den et annet navn). Av denne årsaken blir alltid Oppslagstavla automatisk gjenopprettet hvis du legger til blokken "Siste nyheter".</p>';
$string['namesocial'] = 'Sosialt forum';
$string['nameteacher'] = 'Lærerforum';
$string['newforumposts'] = 'Nye foruminnlegg';
$string['noattachments'] = 'Det er ingen vedlegg til dette innlegget';
$string['nodiscussions'] = 'Ingen har skrevet i dette forumet enda';
$string['nodiscussionsstartedby'] = '{$a} har ikke startet noen diskusjoner';
$string['nodiscussionsstartedbyyou'] = 'Du har ikke startet noen diskusjoner ennå';
$string['noguestpost'] = 'Beklager, gjester kan ikke skrive innlegg';
$string['noguesttracking'] = 'Beklager, gjester kan ikke sette sporingsinnstillinger.';
$string['nomorepostscontaining'] = 'Fant ingen flere innlegg som inneholder \'{$a}\'';
$string['nonews'] = 'Ingen beskjeder er skrevet ennå';
$string['noonecansubscribenow'] = 'Abonnering er nå slått av';
$string['nopermissiontosubscribe'] = 'Du har ikke tillatelse til å se forumabonnenter';
$string['nopermissiontoview'] = 'Du har ikke tilgang til å se dette innlegget';
$string['nopostforum'] = 'Beklager, du kan ikke poste innlegg i dette forumet';
$string['noposts'] = 'Ingen innlegg';
$string['nopostsmadebyuser'] = '{$a} har ikke postet noen innlegg';
$string['nopostsmadebyyou'] = 'Du har ikke postet noen innlegg';
$string['noquestions'] = 'Det er ennå ingen spørsmål i dette forumet.';
$string['nosubscribers'] = 'Det er forløpig ingen som ønsker å motta e-postkopier fra dette forumet';
$string['notexists'] = 'Diskusjonen eksisterer ikke lenger';
$string['nothingnew'] = 'Ingenting nytt for {$a}';
$string['notingroup'] = 'Beklager, men du må være medlem i en gruppe for å se dette forumet.';
$string['notinstalled'] = 'Forummodulen er ikke installert';
$string['notpartofdiscussion'] = 'Dette innlegget er ikke en del av en diskusjon.';
$string['notrackforum'] = 'Ikke hold orden på uleste innlegg';
$string['noviewdiscussionspermission'] = 'Du har ikke høye nok rettigheter til å se diskusjonene i dette forumet';
$string['nowallsubscribed'] = 'Alle fora i {$a} er abonnert på.';
$string['nowallunsubscribed'] = 'Ingen fora i {$a} er abonnert på.';
$string['nownotsubscribed'] = '{$a->name} vil IKKE motta e-postkopier fra \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} sporer ikke lenger \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} vil motta e-postkopier fra \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} sporer nå \'{$a->forum}\'.';
$string['numposts'] = '{$a} innlegg';
$string['olderdiscussions'] = 'Eldre diskusjoner';
$string['oldertopics'] = 'Eldre tema';
$string['oldpostdays'] = 'Les etter dager';
$string['openmode0'] = 'Hverken skrive eller svare i dette forumet';
$string['openmode1'] = 'Ikke skrive egne emner, men svare på lærernes';
$string['openmode2'] = 'Både skrive egne innlegg og svare på andres';
$string['overviewnumpostssince'] = '{$a} innlegg siden siste innlogging';
$string['overviewnumunread'] = '{$a} ulest i alt';
$string['page-mod-forum-discuss'] = 'Side for diskusjontråd i forummodulen';
$string['page-mod-forum-view'] = 'Hovedsiden i forummodulen';
$string['page-mod-forum-x'] = 'Alle sider i forummodulen';
$string['parent'] = 'Les forrige innlegg';
$string['parentofthispost'] = 'Første innlegg i denne diskusjonen';
$string['pluginadministration'] = 'Forumadministrasjon';
$string['pluginname'] = 'Forum';
$string['postadded'] = 'Innlegget ditt ble sendt.<p>Du har {$a} til å redigere det hvis du vil gjøre endringer.';
$string['postaddedsuccess'] = 'Posting av innlegget ditt var vellykket.';
$string['postaddedtimeleft'] = 'Du har {$a} til å endre det dersom du vil gjøre forandringer.';
$string['postbyuser'] = '{$a->post} av {$a->user}';
$string['postincontext'] = 'Se dette innlegget på nettsiden';
$string['postmailinfo'] = 'Dette er en <b>kopi</b> av en beskjed skrevet på {$a} Bruk denne lenken under for å skrive et svar <b>på nettstedet</b>.';
$string['postmailnow'] = '<p>Dette innlegget vil bli sendt ut umiddelbart til alle abonnenter på dette forum.</p>';
$string['postrating1'] = 'Mest individuell (rasjonell) læring';
$string['postrating2'] = 'Individuell (rasjonell) og sosial (empatisk)';
$string['postrating3'] = 'Mest sosial (empatisk) læring';
$string['posts'] = 'Innlegg';
$string['postsmadebyuser'] = 'Poster lagt til av {$a}';
$string['postsmadebyuserincourse'] = 'Poster lagt til av {$a->fullname} i {$a->coursename}';
$string['posttoforum'] = 'Legg inn i forumet';
$string['postupdated'] = 'Innlegget ditt ble oppdatert';
$string['potentialsubscribers'] = 'Mulige abonnenter';
$string['processingdigest'] = 'Prosesserer samleepost for bruker {$a}';
$string['processingpost'] = 'Behandler innlegg {$a}';
$string['prune'] = 'Splitt';
$string['prunedpost'] = 'Startet ny diskusjon med innlegget';
$string['pruneheading'] = 'Splitt diskusjonen og flytt dette innlegget til en ny diskusjon.';
$string['qandaforum'] = 'Spørsmål og svar forum';
$string['qandanotify'] = 'Dette er et spørsmål og svar forum. For å kunne se andres svar på disse spørsmålene, må du først poste ditt eget svar.';
$string['re'] = 'Svar:';
$string['readtherest'] = 'Les resten av dette emnet';
$string['replies'] = 'Svar';
$string['repliesmany'] = '{$a} svar til nå';
$string['repliesone'] = '{$a} svar til nå';
$string['reply'] = 'Svar';
$string['replyforum'] = 'Svar i forumet';
$string['replytouser'] = 'Bruk e-postadresse i svar';
$string['resetdigests'] = 'Slett alle brukernes preferanser for sammendrag av foruminnlegg';
$string['resetforums'] = 'Slett innlegg fra';
$string['resetforumsall'] = 'Slett alle poster';
$string['resetsubscriptions'] = 'Slett alle forumabonnement';
$string['resettrackprefs'] = 'Slett alle sporingspreferanser i forum';
$string['rssarticles'] = 'Antall nylige RSS-artiker';
$string['rssarticles_help'] = '<p>Dette valget lar deg velge hvor mange innlegg som skal tas med i RSS-sendingen.</p>
<p>Et antall mellom 5 og 20 kan være passende for de fleste forum. Øk antallet dersom forumet er mye brukt.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS-mating av diskusjoner';
$string['rsssubscriberssposts'] = 'RSS-mating av innlegg';
$string['rsstype'] = 'RSS-mating av denne aktiviteten';
$string['rsstype_help'] = '<p>Dette valget lar deg aktivere RSS-utsending fra dette forumet.</p>

<p>Du kan velge mellom to typer forum:</p>

<ul>
<li><b>Diskusjoner:</b> Ved å bruke denne vil RSS-utsendingene ta med nye diskusjoner i forumet, inkludert innledende innlegg.</li>

<li><b>Innlegg:</b> Ved å bruke denne vil RSS-utsendingen ta med alle nye innlegg i forumet.</li>
</ul>';
$string['search'] = 'Søk';
$string['searchdatefrom'] = 'Innlegg må være nyere enn dette';
$string['searchdateto'] = 'Innlegg må være eldre enn dette';
$string['searchforumintro'] = 'Vær vennlig å skrive inn søketermer i en eller flere av de påfølgende felt';
$string['searchforums'] = 'Søk i fora';
$string['searchfullwords'] = 'Disse ord skal vises som hele ord';
$string['searchnotwords'] = 'Disse ord skal IKKE inkluderes';
$string['searcholderposts'] = 'Søk i eldre innlegg';
$string['searchphrase'] = 'Nøyaktig denne frase må finnes i innlegget';
$string['searchresults'] = 'Søkeresultater';
$string['searchsubject'] = 'Disse ordene skal finnes i tittel';
$string['searchuser'] = 'Dette navnet skal være likt forfatter';
$string['searchuserid'] = 'Moodle ID til forfatter';
$string['searchwhichforums'] = 'Velg hvilket forum du vil søke i';
$string['searchwords'] = 'Disse ordene kan forekomme hvor som helst i innlegget';
$string['seeallposts'] = 'Se alle innlegg skrevet av denne brukeren';
$string['shortpost'] = 'Kort innlegg';
$string['showsubscribers'] = 'Vis abonnenter til dette forumet';
$string['singleforum'] = 'En enkel diskusjon';
$string['smallmessage'] = '{$a->user} postet i {$a->forumname}';
$string['startedby'] = 'Startet av';
$string['subject'] = 'Overskrift';
$string['subscribe'] = 'Abonner på dette forumet';
$string['subscribeall'] = 'Meld alle på som abonnenter til dette forumet';
$string['subscribed'] = 'Abonnerer';
$string['subscribeenrolledonly'] = 'Beklager, men bare påmeldte brukere kan abonnere og få foruminnlegg tilsendt via e-post.';
$string['subscribenone'] = 'Slett alle abonnement på dette forumet';
$string['subscribers'] = 'Abonnenter';
$string['subscribersto'] = 'Abonnenter på \'{$a}\'';
$string['subscribestart'] = 'Jeg vil gjerne ha e-postkopier av innleggene i dette forumet';
$string['subscribestop'] = 'Jeg ønsker ikke  e-postkopier av innleggene i dette forumet';
$string['subscription'] = 'Abonnement';
$string['subscriptionandtracking'] = 'Abbonnement og sporing';
$string['subscriptionauto'] = 'Autoabonner';
$string['subscriptiondisabled'] = 'Abonnering avslått';
$string['subscriptionforced'] = 'Tvunget abonement';
$string['subscription_help'] = '<P>Når du abonnerer på et forum,
vil du motta kopier av innlegg skrevet i det på e-post. (Innleggene blir
vanligvis sendt ut på e-post 30 minutter etter at de er skrevet og lagt ut på
nett.)
<p>Brukerne (lærere, studenter, elever, deltakere e.l.) kan som oftest velge
selv om de vil motta e-postkopier fra hvert forum eller ikke. </p>
<p>Lærere kan imidlertid lage et forum slik at alle tvinges til å motta
e-postkopier.&nbsp; </p>
<p>Dette er spesielt nyttig i Oppslagstavlen og i andre fora (spesielt i starten
innen alle har lært at de kan selv velge om de vil abonnere.)</p>';
$string['subscriptionmode'] = 'Abonnementsmodus';
$string['subscriptionmode_help'] = 'Når en en bruker er abbonnent på et forum betyr dette at de får en e-post med kopi av alle innlegg som blir postet i dette forumet.

Brukerne kan vanligvis få velge selv i hvert forum om de ønsker å motta kopier av innlegg via e-post.

Dersom du tvinger abbonnement på et bestemt forum vil alle brukere automatisk bli abbonnenter, til og med de som blir innmeldt i kurset på et senere tidspunkt.

Dette er spesielt nyttig i Oppslagstavla og i forum ellers i den første perioden etter kursstart. (Før brukerene har skjønt at de kan styre dette selv.)

Dersom du bruker valget "Ja, til og begynne med" vil alle gjeldende og fremtidige brukere bli påmeldt, men kan slå av abbonnementet når de selv ønsker det. Velger du "Ja, for alltid" vil de IKKE kunne slå av abbonnementet for dette forumet.

Legg spesielt merke til hvordan valget "Ja, til og begynne med" fungerer når du oppdaterer et forum i drift. Hvis du endrer "Ja, til og begynne med" til "Nei" vil ikke brukerne bli avmeldt forumet - endringen vil bare gjelde kommende brukere. Tilsvarende vil en endring fra "Nei"  til "Ja, til og begynne med" ikke berøre eksisterende brukere men bare gjelde for de som kommer til senere.';
$string['subscriptionoptional'] = 'Valgritt abonnement';
$string['subscriptions'] = 'Abonnement';
$string['thisforumisthrottled'] = 'Dette forum har en begrensning på antall innlegg du kan skrive i en gitt tidsperiode - dette er nå satt til {$a->blockafter} innlegg på {$a->blockperiod}';
$string['timedposts'] = 'Tidsstyrte innlegg';
$string['timestartenderror'] = 'Sluttdato for visning kan ikke være tidligere enn startdato';
$string['trackforum'] = 'Spor uleste meldinger';
$string['tracking'] = 'Spor';
$string['trackingoff'] = 'Av';
$string['trackingon'] = 'Tvungent';
$string['trackingoptional'] = 'Valgfritt';
$string['trackingtype'] = 'Les sporing for dette forum?';
$string['trackingtype_help'] = 'Dersom "Aktiver sporing" er på, kan brukere spore leste og uleste meldinger i forum og diskusjoner. Læreren kan tvinge sporing i forumets innstillinger.


Det finnes tre valg for sporing:
* Valgfritt (standard): Brukerne kan slå sporing av og på selv.
* På: Sporing er alltid på.
* Av: Sporing er alltid avslått.';
$string['unread'] = 'Ulest';
$string['unreadposts'] = 'Uleste innlegg';
$string['unreadpostsnumber'] = '{$a} uleste innlegg';
$string['unreadpostsone'] = '1 ulest innlegg';
$string['unsubscribe'] = 'Si opp abonnementet på dette forumet';
$string['unsubscribeall'] = 'Si opp abonnementet på alle forum';
$string['unsubscribeallconfirm'] = 'Du er abonnent på {$a} forum. Ønsker du virkelig å si opp abonnementet på alle forum og koble fra automatisk abonnement?';
$string['unsubscribealldone'] = 'Alle valgfrie forumabonnementer er nå sagt opp. Du kommer fortsatt til å motta meldinger fra forum med tvungne abonnement. For å administrere forummeldinger, gå til Meldinger i Min profil-innstillingene.';
$string['unsubscribeallempty'] = 'Du er ikke abonnent på noen forum. Dersom du ikke ønsker å motta noe e-post fra denne serveren, ber vi deg gå til Meldinger i Min profil-innstillingene.';
$string['unsubscribed'] = 'Ikke abonnent';
$string['unsubscribeshort'] = 'Si opp abonnement';
$string['usermarksread'] = 'Manuell merking av "Lest"';
$string['viewalldiscussions'] = 'Se alle diskusjoner';
$string['warnafter'] = 'Innleggsgrense for å få advarsel';
$string['warnafter_help'] = '<p>Konseptet for administrasjon av foruminnlegg er meget enkelt. Brukere vil bli hindret i å poste flere innlegg etter et gitt antall innlegg i en angitt periode. Straks de nærmer seg dette antallet vil de bli varslet om at de er i ferd med å nå sperregrensen for flere innlegg i den angitte perioden./p>

<p>Dersom du setter varslingsgrensen til 0 vil advarsler kobles ut. Med en blokkeringsgrense på 0 vil muligheten for blokkering av nye innlegg slås av. Hvis blokkering er deaktivert vil også advarsler automatisk bli slått av.</p>

<p>Ingen av disse innstillingene har betydning for lærerens posting av innlegg.</p>';
$string['warnformorepost'] = 'Advarsel: Det er mer enn en diskusjon i dette forumet. Bruk den nyeste av dem.';
$string['yournewquestion'] = 'Ditt nye spørsmål';
$string['yournewtopic'] = 'Ditt nye diskusjonsemne';
$string['yourreply'] = 'Ditt svar';
