<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   feedback
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Legg til spørsmål i aktiviteten';
$string['add_pagebreak'] = 'Sett inn sideskift';
$string['adjustment'] = 'Justering';
$string['after_submit'] = 'Etter innsending';
$string['allowfullanonymous'] = 'Tillat full anonymitet';
$string['analysis'] = 'Analyse';
$string['anonymous'] = 'Anonym';
$string['anonymous_edit'] = 'Ta med brukers navn';
$string['anonymous_entries'] = 'Anonyme svar';
$string['anonymous_user'] = 'Anonym bruker';
$string['append_new_items'] = 'Legg til nye elementer';
$string['autonumbering'] = 'Automatisk nummerering av av spørsmål';
$string['autonumbering_help'] = 'Aktiverer eller deaktiverer automatisk nummerering av hvert spørsmål';
$string['average'] = 'Gjennomsnitt';
$string['bold'] = 'Fet';
$string['cancel_moving'] = 'Avbryt flytting';
$string['cannotmapfeedback'] = 'Databaseproblem, ikke i stand til å mappe feedback til kurs';
$string['cannotsavetempl'] = 'lagring av maler er ike tillatt';
$string['cannotunmap'] = 'Databaseproblem, ikke i stand til å oppheve mapping';
$string['captcha'] = 'CaptCHA';
$string['captchanotset'] = 'CAPTCHA er ikke satt.';
$string['check'] = 'Flersvar';
$string['checkbox'] = 'Flersvar - flere avkrysninger tillatt';
$string['check_values'] = 'Mulige svar';
$string['choosefile'] = 'Velg en fil';
$string['chosen_feedback_response'] = 'valgt tilbakemelding på undersøkelsen';
$string['completed'] = 'fullført';
$string['completed_feedbacks'] = 'Innsendte svar';
$string['complete_the_form'] = 'Svar på spørsmålene...';
$string['completionsubmit'] = 'Vis som fullført hvis feedback er innsendt.';
$string['configallowfullanonymous'] = 'Dersom dette valget settes til "Ja" kan feedback fullførres uten å logge inn. Dette har bare betydning for feedback-undersøkelser på  hovedsiden.';
$string['confirmdeleteentry'] = 'Er du sikker på at du vil slette denne oppføringen?';
$string['confirmdeleteitem'] = 'Er du sikker på at du vil slette dette elementet?';
$string['confirmdeletetemplate'] = 'Er du sikker på at du vil slette denne malen?';
$string['confirmusetemplate'] = 'Er du sikker på at du vil bruke denne malen?';
$string['continue_the_form'] = 'Fortsett med skjemaet';
$string['count_of_nums'] = 'Antall siffer';
$string['courseid'] = 'kursID';
$string['creating_templates'] = 'Lagre disse spørsmålene som en ny mal';
$string['delete_entry'] = 'Slett oppføring';
$string['delete_item'] = 'Slett spørsmål';
$string['delete_old_items'] = 'Slett gamle elementer';
$string['delete_template'] = 'Slett mal';
$string['delete_templates'] = 'Slett maler...';
$string['depending'] = 'Avhengigheter';
$string['depending_help'] = 'Det er mulig å vise elementer avhengig av verdier fra andre elementer.<br />
<strong>Her har du et eksempel:</strong><br />
<ul>
<li>Lag først det elementet som et annet element skal være avhengig av</li>
<li>Legg til et sideskift</li>
<li>Legg så til elementene som skal være avhengig av det forrige som du la til. Velg elementet fra listen over mulige avhengige elementer og legg til en verdi i feltet "Avhengig verdi"</li>
</ul>
<strong>Strukturen skal se ut som dette:</strong>
<ol>
<li>Element Q: Har du bil? A: ja/nei</li>
<li>Sideskift</li>
<li>Element Q: Hvilken farge er det på bilen din?<br />
(dette elementet avhenger av at element 1 har verdien = ja)</li>
<li>Element Q: Hvorfor har du ikke bil?<br />
(dette elementet avhenger av at element 1 har verdien = nei)</li>
<li>.... andre elementer</li>
</ol>';
$string['dependitem'] = 'Avhengig element';
$string['dependvalue'] = 'Avhengig verdi';
$string['description'] = 'Beskrivelse';
$string['do_not_analyse_empty_submits'] = 'Ikke ta med tomme innsendinger i analysen';
$string['dropdown'] = 'Flersvar - bare ett alternativ tillatt (Listeboks med alternativer)';
$string['dropdownlist'] = 'Flersvar - ett svar fra listeboks med alternativer';
$string['dropdownrated'] = 'Listemeny (vektet)';
$string['dropdown_values'] = 'Svar';
$string['drop_feedback'] = 'Fjern fra dette kurset';
$string['edit_item'] = 'Endre spørsmålet';
$string['edit_items'] = 'Endre spørsmål';
$string['email_notification'] = 'Send e-postvarsel ved innsendinger';
$string['email_notification_help'] = 'Dersom aktivert vil administratorer varsles via e-post ved hver innsending.';
$string['emailteachermail'] = '{$a->username} har fullført spørreskjemaet: \'{$a->feedback}\'
Du kan se responsen her:
{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} har fullført spørreskjemaet: <i>\'{$a->feedback}\'</i></p><p>
Du kan se responsen <a href="{$a->url}">her</a>.</p>';
$string['entries_saved'] = 'Svarene dine er nå lagret. Tusen takk!';
$string['eventcoursemoduleviewed'] = 'Kursmodul vist';
$string['eventinstanceslistviewed'] = 'Liste over forekomster vist';
$string['eventresponsedeleted'] = 'Respons slettet';
$string['eventresponsesubmitted'] = 'Respons sent';
$string['export_questions'] = 'Eksporter spørsmål';
$string['export_to_excel'] = 'Eksporter til Excel';
$string['feedback:addinstance'] = 'Legg til ny tilbakemelding';
$string['feedbackclose'] = 'Steng undersøkelsen';
$string['feedback:complete'] = 'Fullfør undersøkelsen';
$string['feedback:createprivatetemplate'] = 'Opprett en privat mal';
$string['feedback:createpublictemplate'] = 'Opprett en felles mal';
$string['feedback:deletesubmissions'] = 'Slett fullførte innsendinger';
$string['feedback:deletetemplate'] = 'Slett mal';
$string['feedback:edititems'] = 'Endre elementer';
$string['feedback_is_not_for_anonymous'] = 'feedback er ikke for anonyme besvarelser';
$string['feedback_is_not_open'] = 'Undersøkelsen er ikke åpen';
$string['feedback:mapcourse'] = 'Koble kurs til globale undersøkelser';
$string['feedbackopen'] = 'Åpne undersøkelsen';
$string['feedback:receivemail'] = 'Motta e-postvarsel';
$string['feedback:view'] = 'Vis en tilbakemelding';
$string['feedback:viewanalysepage'] = 'Vis analysesiden etter innsending';
$string['feedback:viewreports'] = 'Vis rapporter';
$string['file'] = 'Fil';
$string['filter_by_course'] = 'Filtrer pr. kurs';
$string['handling_error'] = 'Det oppstod en feil i Feedback-modulen';
$string['hide_no_select_option'] = 'Skjul "Ikke valgt"-opsjonen';
$string['horizontal'] = 'horisontal';
$string['importfromthisfile'] = 'Importer fra denne filen';
$string['import_questions'] = 'Importer spørsmål';
$string['import_successfully'] = 'Importen var vellykket';
$string['info'] = 'Informasjon';
$string['infotype'] = 'Informasjonstype';
$string['insufficient_responses'] = 'utilstrekkelige responser';
$string['insufficient_responses_for_this_group'] = 'Det er utilstrekkelig antall responser for denne gruppen';
$string['insufficient_responses_help'] = 'Det er for lite responser fra denne gruppen.

For at feedback skal være reelt anonym må det være minst to responser.';
$string['item_label'] = 'Overskrift';
$string['item_name'] = 'Spørsmål';
$string['label'] = 'Informasjonsfelt';
$string['line_values'] = 'Vekting';
$string['mapcourse'] = 'Koble feedback til kurs';
$string['mapcourse_help'] = 'Som standard vil feedback-skjemaeropprettetpå hovedsiden være tilgjengelig for alle kurs på portalen og vil vises i kurs som har aktivert feedback-blokken. Du kan tvinge spørreskjemaet til å vises ved å gjøre blokken obligatorisk. Du kan også begrensehvilke kurs som skal ha tilgang til spørreskjemaet ved å koble det mot bestemte kurs.';
$string['mapcourseinfo'] = 'Dette er en undersøkelse som er tilgjengelig for alle kurs som har slått på blokken for Feedback. Du kan likevel begrense undersøkelsen';
$string['mapcoursenone'] = 'Ingen kurs tilkoblet. Feedback er tilgjengelig for alle kurs.';
$string['mapcourses'] = 'Koble Feedback til kurs';
$string['mapcourses_help'] = 'Straks du har valgt relevant(e) kurs fra søket ditt, kan du assossiere dem med denne feedback-undersøkelsen via koble til kurs. Du kan velge flere kurs ved å holde nede Command/CTRL-tasten mens du klkker på kursnavnene. Et kurs kan fjernes fra listen når som helst.';
$string['mappedcourses'] = 'Tilkoblede kurs';
$string['max_args_exceeded'] = 'Max 6 valg kan håndteres, det er for mange valg for';
$string['maximal'] = 'maksimalt';
$string['messageprovider:message'] = 'Påminnelse om tilbakemelding';
$string['messageprovider:submission'] = 'Feedback meldinger';
$string['mode'] = 'Modus';
$string['modulename'] = 'Feedback';
$string['modulename_help'] = 'Feedbackmodulen gjør det mulig for læreren å lage egendefinerte spørreundersøkelser for å samle inn tilbakemeldinger fra deltakere. Det finnes flere spørsmålstyper å velge fra, bl. a. flervalg, ja/nei eller tekstsvar.

Responsen kan være anonym hvis det er ønskelig, og resultatene kan vises til alle deltakerene eller kun til lærerne. Feedbackaktiviteter på portalens forside kan også utføres av brukere som ikke er pålogget.

Feedbackaktiviteter kan brukes

* Til kursevalueringer, for å hjelpe læreren å identifisere mulige forbedringer til senere kurs
* For å la deltakere melde seg på kursmoduler, hendelser, osv.
* Til gjestespørreundersøkelser angående valg av kurs, skolens retningslinjer osv.
* Til anti-mobbingkampanjer, der studenter kan rapportere tilfeller av mobbing';
$string['modulenameplural'] = 'Feedback';
$string['movedown_item'] = 'Flytt dette spørsmålet nedover';
$string['move_here'] = 'Flytt hit';
$string['move_item'] = 'Flytt dette spørsmålet';
$string['moveup_item'] = 'Flytt dette spørsmålet oppover';
$string['multichoice'] = 'Flervalg';
$string['multichoicerated'] = 'Flervalg (vektet)';
$string['multichoicetype'] = 'Flervalgstype';
$string['multichoice_values'] = 'Flervalg svar';
$string['multiplesubmit'] = 'Tillat mer enn en innsending';
$string['multiplesubmit_help'] = ' Ved anonyme besvarelser tillates ubegrenset antall innsendinger fra hver bruker.';
$string['name'] = 'Navn';
$string['name_required'] = 'Navn er obligatorisk';
$string['next_page'] = 'Neste side';
$string['no_handler'] = 'Det er ikke definert noen handling for';
$string['no_itemlabel'] = 'Ingen overskrift';
$string['no_itemname'] = 'Manger elementnavn';
$string['no_items_available_yet'] = 'Det er ikke blitt lagt til spørsmål';
$string['non_anonymous'] = 'Brukerens navn vil bli lagret og vist sammen med svaret.';
$string['non_anonymous_entries'] = 'Ingen anonyme svar';
$string['non_respondents_students'] = 'studenter som ikke har svart';
$string['notavailable'] = 'denne feedbackundersøkelsen er ikke tilgjengelig';
$string['not_completed_yet'] = 'Ikke fullført ennå';
$string['no_templates_available_yet'] = 'Ingen maler tilgjengelig ennå';
$string['not_selected'] = 'Ikke valgt';
$string['not_started'] = 'ikke startet';
$string['numeric'] = 'Numerisk svar';
$string['numeric_range_from'] = 'Serie fra';
$string['numeric_range_to'] = 'Serie til';
$string['of'] = 'av';
$string['oldvaluespreserved'] = 'Alle gamle spørsmål med tildelte verdier blir lagret';
$string['oldvalueswillbedeleted'] = 'Gjeldende spørsmål med responser du har fått vil bli slettet';
$string['only_one_captcha_allowed'] = 'Det kan bare være EN captcha i en feedback';
$string['overview'] = 'Oversikt';
$string['page'] = 'Side';
$string['page_after_submit'] = 'Visningsside etter fullført';
$string['pagebreak'] = 'Sideskift';
$string['page-mod-feedback-x'] = 'Alle sider i Feedbackmodulen';
$string['parameters_missing'] = 'Det mangler parametre fra';
$string['picture'] = 'Bilde';
$string['picture_file_list'] = 'Liste med bilder';
$string['picture_values'] = 'velg en eller flere <br />bildefiler fra listen:';
$string['pluginadministration'] = 'Feedback administrasjon';
$string['pluginname'] = 'Feedback';
$string['position'] = 'Posisjon';
$string['preview'] = 'Forhåndsvisning';
$string['preview_help'] = 'I forhåndsvisningsmodus an du også endre rekkefølgen på spørsmålene';
$string['previous_page'] = 'Forrige side';
$string['public'] = 'Offentlig';
$string['question'] = 'Spørsmål';
$string['questionandsubmission'] = 'Spørsmåls- og innleveringsinnstillinger';
$string['questions'] = 'Spørsmål';
$string['radio'] = 'Flervalg - ett riktig svar';
$string['radiobutton'] = 'Flersvar - ett svar er tillatt (radioknapper)';
$string['radiobutton_rated'] = 'Radioknapp (vektet)';
$string['radiorated'] = 'Radioknapp (vektet)';
$string['radio_values'] = 'Svaralternativer';
$string['ready_feedbacks'] = 'Ferdige tilbakemeldinger';
$string['relateditemsdeleted'] = 'Alle dine brukerresponser for dette spørsmålet vil også bli slettet';
$string['required'] = 'Obligatorisk';
$string['resetting_data'] = 'Tilbakestill Feedback-svarene';
$string['resetting_feedbacks'] = 'Tilbakestiller Feedback';
$string['response_nr'] = 'Respons nr:';
$string['responses'] = 'Responser';
$string['responsetime'] = 'Responstid';
$string['save_as_new_item'] = 'Lagre som nytt spørsmål';
$string['save_as_new_template'] = 'Lagre som ny mal';
$string['save_entries'] = 'Send inn dine svar';
$string['save_item'] = 'Lagre spørsmålet';
$string['saving_failed'] = 'Lagringen mislykkes';
$string['saving_failed_because_missing_or_false_values'] = 'Lagringen mislykkes pga manglende eller ugyldige verdier';
$string['search_course'] = 'Søk i kurset';
$string['searchcourses'] = 'Søk kurs';
$string['searchcourses_help'] = 'Søk etter koden eller kursnavnet som  vil koble til denne undersøkelsen.';
$string['selected_dump'] = 'Valgte indekser av  $SESSION variabelen vises under:';
$string['send'] = 'send';
$string['send_message'] = 'send melding';
$string['separator_decimal'] = '.';
$string['separator_thousand'] = ',';
$string['show_all'] = 'Vis alt';
$string['show_analysepage_after_submit'] = 'Vis analysesiden etter innsending';
$string['show_entries'] = 'Vis responser';
$string['show_entry'] = 'Vis respons';
$string['show_nonrespondents'] = 'Vis brukere som ikke har svart';
$string['site_after_submit'] = 'webadresse etter innsending';
$string['sort_by_course'] = 'Sorter etter kurs';
$string['start'] = 'Start';
$string['started'] = 'startet';
$string['stop'] = 'Slutt';
$string['subject'] = 'Emne';
$string['switch_group'] = 'Bytt gruppe';
$string['switch_item_to_not_required'] = 'bytt til: svar er valgfritt';
$string['switch_item_to_required'] = 'bytt til: svar er obligatorisk';
$string['template'] = 'Mal';
$string['templates'] = 'Maler';
$string['template_saved'] = 'Malen er lagret';
$string['textarea'] = 'Lang tekstsvar';
$string['textarea_height'] = 'Antall linjer';
$string['textarea_width'] = 'Bredde';
$string['textfield'] = 'Korttekst svar';
$string['textfield_maxlength'] = 'Maksimum antall bokstaver som godtas';
$string['textfield_size'] = 'Bredde på tekstfeltet';
$string['there_are_no_settings_for_recaptcha'] = 'Det finnes ingen innstillinger for captcha';
$string['this_feedback_is_already_submitted'] = 'Du har allerede fullført denne aktiviteten.';
$string['typemissing'] = 'mangler verdien "type"';
$string['update_item'] = 'Lagre endringene på dette spørsmålet';
$string['url_for_continue'] = 'URL for fortsett-knappen';
$string['url_for_continue_help'] = 'Som standard vil brukeren havne på kurssiden etter innsending av en feedback. Du kan angi en URL her hvis fortsett-knappen skal lede til et annet sted.';
$string['use_one_line_for_each_value'] = '<br />Bruk en linje for hvert svaralternativ!';
$string['use_this_template'] = 'Bruk denne malen';
$string['using_templates'] = 'Bruk en mal';
$string['vertical'] = 'vertikal';
$string['viewcompleted'] = 'fullførte feedback-undersøkelser';
$string['viewcompleted_help'] = 'Du kan vise fullførte feedback-skjemaer, søkbare pr. kurs og/eller pr. spørsmål.
Feedback-responser kan eksporteres til Excel.';
