<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'ལཱ་འགན་གསརཔ་བཙུགས་དོ།';
$string['addrole'] = 'ལས་འགན་གསརཔ་ཁ་སྐོང་རྐྱབས།';
$string['advancedoverride'] = 'ཁྱད་དུ་འཕགས་པའི་ལཱ་འགན་མེདཔ་གཏང་།';
$string['allow'] = 'ཆོག';
$string['allowassign'] = 'ལས་འགན་སྤྲོད་ཆོག';
$string['allowed'] = 'ཆོག་ཅི།';
$string['allowoverride'] = 'ལས་འགན་དབང་ཐ་ཆོད་བཅུག';
$string['allowroletoassign'] = 'ལས་འགན་ཡོད་པའི་ལག་ལེན་པ་{$a->fromrole} ག་ར་ལུ་། {$a->targetrole} ལས་འགན་སྤྲོད།';
$string['allowroletooverride'] = 'ལས་འགན་ཡོད་པའི་ལག་ལེན་པ་{$a->fromrole} ག་ར་ལུ་ {$a->targetrole} ལས་འགན་དབང་ཐ་ཆོད་བཅུག';
$string['allowroletoswitch'] = 'ལས་འགན་ཡོད་པའི་ལག་ལེན་པ་{$a->fromrole} ག་ར་ལུ་ {$a->targetrole} ལས་འགན་ཚུ་ལས་ ལཱ་འགན་གཅིག་སྤྲོད།';
$string['allowswitch'] = 'ལཱ་འགན་སོར་བཅུག';
$string['allsiteusers'] = 'ས་ཁོངས་ལག་ལེན་པ་ཆ་མཉམ།';
$string['archetype'] = 'ལས་འགན་དཔེ་ཡང་དག';
$string['archetypecoursecreator'] = 'ARCHETYPE:སློབ་ཚན་བཟོ་མི།';
$string['archetypeeditingteacher'] = 'ARCHETYPE:སློབ་དཔོན(ཞུད་དག་རྐྱབ་ཆོག་མི)';
$string['archetypefrontpage'] = 'ARCHETYPE:གདོང་ཤོང་ནང་ བདེན་བཤད་འབད་ཡོད་པའི་ལག་ལེན་པ';
$string['archetypeguest'] = 'ARCHETYPE:མགྱོནམ།';
$string['archetype_help'] = 'ལས་འགན་འདི་ སྔོན་སྒྲིག་སྦེ་གཞི་སྒྲིག་འབད་བའི་སྐབས་སུ་ ལས་འགན་archetype དེ་ཧ་གོཝ་ཨིན། འདི་གིས་གཞན་ཡང་ ་ས་ཁོང་་འདི་ཡར་ཐོན་འབད་བའི་སྐབས་ཚུ་ ་ལས་འགན་གྱི་གནང་བ་གཞན་ཚུ་ཧ་གོ།';
$string['archetypemanager'] = 'ARCHETYPE:འཛིན་སྐྱོང་པ།';
$string['archetypestudent'] = 'ARCHETYPE: སློབ་ཕྲུག་';
$string['archetypeteacher'] = 'ARCHETYPE: སློབ་དཔོན (ཞུན་དག་འབད་མ་ཆོག་མི)';
$string['archetypeuser'] = 'ARCHETYPE: བདེན་བཤད་འབད་ཡོད་པའི་ལག་ལེན་པ།';
$string['assignanotherrole'] = 'ལས་འགན་གཞན་མི་སྤྲོད།';
$string['assignedroles'] = 'ལས་འགན་ཚུ་སྤྲོད་ཡོདཔ།';
$string['assignerror'] = '{$a->user} ལག་ལེན་པ་ལུ་ ལས་འགན་{$a->role} སྤྲོད་པའི་སྐབས་འཛོལ་བ།';
$string['assignglobalroles'] = 'རིམ་ལུགས་ལས་འགན་སྤྲོད';
$string['assignmentcontext'] = 'ལས་འགུལ་སྐབས་དོན།';
$string['assignmentoptions'] = 'ལས་འགུལ་གདམ་ཁ།';
$string['assignrole'] = 'ལས་འགན་སྤྲོད།';
$string['assignrolenameincontext'] = '{$a->context} འདི་ནང་ \'{$a->role}\' ལས་འགན་སྤྲོད།';
$string['assignroles'] = 'ལས་འགན་སྤྲོད།';
$string['assignrolesin'] = 'འདི་ནང་ {$a} ལས་འགན་སྤྲོད།';
$string['assignrolesrelativetothisuser'] = 'ལག་ལེན་པ་ལུ་ ལལས་འགན་ཚུ་དང་འབྲེལ་བའི་ལཱ་ཚུ་སྤྲོད།';
$string['backtoallroles'] = 'ལས་འགན་ཚུ་གི་ཐོ་ལུ་ལོག';
$string['backup:anonymise'] = 'མིང་གསང༌ལག་ལེན་པའི་དྲན་མཛོད་རྒྱབ་སྣོན།';
$string['backup:backupactivity'] = 'རྒྱབ་སྣོན་གྱི་སྦྱོང་ལཱ།';
$string['backup:backupcourse'] = 'རྒྱབ་སྣོན་གྱི་སློབ་ཚན།';
$string['backup:backupsection'] = 'རྒྱབ་སྣོན་གྱི་སྡེ་ཚན།';
$string['backup:backuptargethub'] = 'ལྟེ་བ་གི་རྒྱབ་སྣོན།';
$string['backup:backuptargetimport'] = 'ནང་འདྲེན་གྱི་རྒྱབ་སྣོན།';
$string['backup:configure'] = 'རིམ་སྒྲིག་རྒྱབ་སྣོན་གཡི་གདམ་ཁ།';
$string['backup:downloadfile'] = 'རྒྱབ་སྣོན་གྱི་ས་ཁོངས་ལས་ཡིག་སྣོད་ཚུ་ཕབ་ལེན་འབད།';
$string['backup:userinfo'] = 'ལག་ལེན་པའི་གནས་སྡུད་ཉེན་སྲུང་འབད';
$string['badges:awardbadge'] = 'ལག་ལེན་པ་ལུ་ངོ་རྒྱན་སྤྲོད།';
$string['badges:configurecriteria'] = 'ངོ་རྒྱན་ཐོབ་ནི་གི་ཚད་གཞི་བཟོ།';
$string['badges:configuredetails'] = 'ངོ་རྒྱན་གྱི་རྒྱས་བཤད་བཟོ།';
$string['badges:configuremessages'] = 'ངོ་རྒྱན་གྱི་བརྡ་འཕྲིན་བཟོ།';
$string['badges:createbadge'] = 'ངོ་རྒྱན་གྱི་རྫུན་མ་བཟོ།';
$string['badges:deletebadge'] = 'ངོ་རྒྱན་བཏོན་གཏང་།';
$string['badges:earnbadge'] = 'ངོ་རྒྱན་ཐོབ་སྦེ་འབད།';
$string['badges:manageglobalsettings'] = 'ངོ་རྒྱན་གྱི་འཛམ་གླིང་ཡོངས་འབྲེལ་གཞི་སྒྲིག་བཟོ།';
$string['badges:manageownbadges'] = 'རང་གི་ཐོབ་མི་ངོ་རྒྱན་ཚུ་བལྟ་ནི་དང་འཛིན་སྐྱོང་འབད།';
$string['badges:viewawarded'] = 'ངོ་རྒྱན་སྤྲོད་མ་ཚུགས་པའི་ཐོག་ ངོ་རྒྱན་ཐོབ་མི་ཚུ་བལྟ།';
$string['badges:viewbadges'] = 'མ་ཐོབ་པར་སྦེ་ ཡོད་མི་ངོ་རྒྱན་ཚུ་བལྟ།';
$string['badges:viewotherbadges'] = 'གཞན་ལག་ལེན་པ་གི་ངོ་ཐོ་ནང་ མི་མང་ངོ་རྒྱན་ཚུ་བལྟ།';
$string['block:edit'] = 'སྡེབ་ཚན་གཅིག་གི་གཞི་སྒྲིག་ཚུ་ཞིན་དག་འབད།';
$string['block:view'] = 'སྡེབ་ཚན་སྟོན';
$string['blog:associatecourse'] = 'འོས་བབ་དེ་སྐྱོན་བརྗོད་དེ་ཡོདཔ་ལས་ ག་ནི་ཡང་འབད་མི་ཚུགས་པས།';
$string['blog:associatemodule'] = 'འོས་བབ་དེ་སྐྱོན་བརྗོད་དེ་ཡོདཔ་ལས་ ག་ནི་ཡང་འབད་མི་ཚུགས་པས།';
$string['blog:create'] = 'སྡེབ་ཚན་གྱི་ཐོ་བཀོད་གསརཔ་གསར་བསྐྲུན་འབད';
$string['blog:manageentries'] = 'ཐོ་བཀོད་ཚུ་ཞུན་དག་འབད་དེ་འཛིན་སྐྱོང་འཐབ།';
$string['blog:manageexternal'] = 'ཕྱི་ཁ་གི་ཝེབ་དྲན་དེབ་ཚུ་ཞུད་དག་བརྐྱབ་སྟེ་འཛིན་སྐྱོང་འབད།';
$string['blog:manageofficialtags'] = 'གཞུང་དོན་ངོ་རྟགས་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['blog:managepersonaltags'] = 'སྒེར་དོན་ངོ་རྟགས་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['blog:search'] = 'སྡེབ་ཚན་གྱི་ཐོ་བཀོད་ཚུ་འཚོལ་ཞིབ་འབད།';
$string['blog:view'] = 'སྡེབ་ཚན་ཐོ་བཀོད་ཚུ་སྟོན།';
$string['blog:viewdrafts'] = 'སྡེབ་ཚན་ཐོ་བཀོད་ཀྱི་ཟིན་བྲིས་ལྟ།';
$string['calendar:manageentries'] = 'ཟླ་ཐོའི་ཐོ་བཀོད་གང་རུང་འཛིན་སྐྱོང་འཐབ།';
$string['calendar:managegroupentries'] = 'སྡེ་ཚན་ཟླ་ཐོའི་ཐོ་བཀོད་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['calendar:manageownentries'] = 'རང་གི་ཟླ་ཐོའི་ཐོ་བཀོད་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['capabilities'] = 'ལྕོགས་གྲུབ།';
$string['capability'] = 'ལྕོགས་གྲུབ།';
$string['category:create'] = 'དབྱེ་རིམ་ཚུ་གསར་བསྐྲུན་འབད';
$string['category:delete'] = 'དབྱེ་རིམ་བཏོན་གཏང་།';
$string['category:manage'] = 'དབྱེ་རིམ་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['category:update'] = 'དབྱེ་རིམ་ཚུ་དུས་མཐུན་བཟོ།';
$string['category:viewhiddencategories'] = 'སྦ་བཞག་ཡོད་མི་ དབྱེ་རིམ་ཚུ་བལྟ།';
$string['category:visibility'] = 'སྦ་བཞག་ཡོད་མི་ དབྱེ་རིམ་ཚུ་བལྟ།';
$string['checkglobalpermissions'] = 'རིམ་ལུགས་ཀྱི་གནང་བ་བརྟག་ཞིབ་འབད།';
$string['checkpermissions'] = 'གནང་བ་བརྟག་ཞིབ་འབད།';
$string['checkpermissionsin'] = '{$a} ནང་ལུ་གནང་བ་བརྟག་ཞིབ་འབད།';
$string['checksystempermissionsfor'] = '{$a->fullname}ལུ་ རིམ་ལུགས་ཀྱི་གནང་བ་བརྟག་ཞིབ་འབད།';
$string['checkuserspermissionshere'] = '{$a->contextlevel} འདི་ནང་{$a->fullname} ལུ་གནང་བ་བརྟག་ཞིབ་འབད།';
$string['chooseroletoassign'] = 'ལས་འགན་ཧྤྲོད་ནི་གཅིག་ཁདམ་ཁ་རྐྱབས།';
$string['cohort:assign'] = 'སྡེ་མཉམ་གྱི་འཐུས་མི་ཚུ་ བཏོན་བཙུགས་འབད།';
$string['cohort:manage'] = 'སྡེ་མཉམ་ཚུ་ བཟོ། བཏན་གཏང་། སྤོ་བཤུས་འབད།';
$string['cohort:view'] = 'ལྟ site-wide སྡེ་མཉམ་ཚུ།';
$string['comment:delete'] = 'ཡིག་ཆ་བཏོན་་གཏང་།';
$string['comment:post'] = 'བསམ་བཀོད་བརྡ་འཕྲིན་འབད།';
$string['comment:view'] = 'བསམ་བཀོད་ལྷག';
$string['community:add'] = 'མི་སྡེ་གི་སྡེབ་ཚན་ལག་ལེན་འཐབ་སྟེ་ལྟེ་བ་ཚུ་འཚོལ་ཞིབ་འབད་དེ་སློབ་ཚན་ཚུ་འཚོལ།';
$string['community:download'] = 'མི་སྡེ་གི་སྡེབ་ཚན་ནང་ལས་ སློབ་ཚན་གཅིག་ཕབ་ལེན་འབད།';
$string['confirmaddadmin'] = 'ཁྱོད་ཐད་རི་པ་རི་ ལག་ལེན་པ་སྦེ་ཁ་སྐོང་བརྐྱབ་སྟེ་<strong>{$a}</strong> འདི་་ཁོངས་ཀྱི་བགད་སྐྱོང་པ་བཀོད་ནི་ཨིན་ན?';
$string['confirmdeladmin'] = 'ཁྱོད་ཐད་རི་པ་རི་  ལག་ལེན་པ<strong>{$a}</strong>་འདི་ ས་ཁོངས་བདག་སྐྱོང་པའི་ཐོ་ནང་ལས་བཏོན་གཏང་ནི་ཨིན་ན?';
$string['confirmroleprevent'] = 'ཁྱོད་ཐད་རི་པ་རི་  ལག་ལེན་པ<strong>{$a}</strong>་འདི་ ས་ཁོངས་བདག་སྐྱོང་པའི་ཐོ་ནང་ལས་བཏོན་གཏང་ནི་ཨིན་ན?';
$string['confirmroleunprohibit'] = 'ཁྱོད་ཐད་རི་པ་རི་  ལག་ལེན་པ<strong>{$a}</strong>་འདི་ ས་ཁོངས་བདག་སྐྱོང་པའི་ཐོ་ནང་ལས་བཏོན་གཏང་ནི་ཨིན་ན?';
$string['confirmunassign'] = 'ཁྱོད་ཐད་རི་པ་རི་ ལས་འགན་འདི་ ལག་ལེན་པ་འདི་་ལས་ སྤ་བཤུས་འབད་ནི་་ཨིན་ན?';
$string['confirmunassignno'] = 'ཆ་མེད་གཏང་།';
$string['confirmunassigntitle'] = 'ལས་འགན་བརྗ་སོར་གཏན་འཁེལ་བཟོ།';
$string['confirmunassignyes'] = 'སྤོ་བཤུས་འབད།';
$string['context'] = 'གནས་སྟངས།';
$string['course:activityvisibility'] = 'ལཱ་ཚུ་ སྦ་བཞག/སྟོན';
$string['course:bulkmessaging'] = 'མི་ལེ་ཤ་ལུ་ འཕྲིན་དོན་གཏང་།';
$string['course:changecategory'] = 'སློབ་ཚན་དབྱེ་རིམ་བསྒྱུར་བཅོས་འབད།';
$string['course:changefullname'] = 'སློབ་ཚན་གྱི་མིང་ཆ་ཚང་བསྒྱུར་བཅོས་འབད།';
$string['course:changeidnumber'] = 'སློབ་ཚན་གྱི་ ID ཨང་ བསྒྱུར་བཅོས་འབད།';
$string['course:changeshortname'] = 'སློབ་ཚན་གྱི་མིང་ཐུང་ཀུ་བསྒྱུར་བཅོས་འབད།';
$string['course:changesummary'] = 'སློབ་ཚན་གྱི་བཅུད་དོན་བསྒྱུར་བཅོས་འབད།';
$string['course:create'] = 'སློབ་ཚན་གསར་བསྐྲུན་འབད།';
$string['course:delete'] = 'སློབ་ཚན་བཏོན་གཏང་།';
$string['course:enrolconfig'] = 'སློབ་ཚན་ནང་ རིམ་སྒྲིག་གནས་སྟངས་ཐོ་བཀོད།';
$string['course:enrolreview'] = 'སློབ་ཚན་ཐོ་བཀོད་ཚུ་བསྐྱར་ཞིབ་འབད།';
$string['course:ignorefilesizelimits'] = 'ཡིག་སྣོད་ཚད་ ག་ལས་ཡང་སྦོམ་ཡོད་མི་གི་བཀག་འཛིན།';
$string['course:isincompletionreports'] = 'སྙན་ཞུ་རྫོགཔ་ད་ལུ་སྟོན་འོང་།';
$string['course:manageactivities'] = 'ལཱ་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['course:managefiles'] = 'ཡིག་སྣོ་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['course:managegrades'] = 'སྡེ་རིམ་ཚུ་འཛིནསྐྱོང་འཐབ།';
$string['course:managegroups'] = 'སྡེ་ཚན་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['course:managescales'] = 'ཆ་ཚད་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['course:markcomplete'] = 'སློ་ཚན་རྫོགས་མི་ནང་ལུ་ ལག་ལེན་པ་ཚུ་ རྫོགཔ་སྦེ་སྟོན།';
$string['course:movesections'] = 'སྡེ་ཚན་ཚུ་སྤོ་བཤུས་འབད།';
$string['course:publish'] = 'ལྟེ་བ་ནང་ལུ་ སློབ་ཚན་གཅིག་དཔེ་སྐྲུན་འབད།';
$string['course:request'] = 'སློབ་ཚན་གསརཔ་ཞུ་བ་འབད།';
$string['course:reset'] = 'སློབ་ཚན་ སླར་སྒྲིག་འབད།';
$string['course:sectionvisibility'] = 'དབྱེ་ཚན་གྱི་མཐོང་གསལ་ ཚད་འཛིན་འབད།';
$string['course:setcurrentsection'] = '་ལྟོའི་དབྱེ་ཚན་གཞི་སྒྲིག་འབད།';
$string['course:update'] = 'སློབ་ཚན་སྒྲིག་སྟངས་དུས་མཐུན་བཟོ།';
$string['course:useremail'] = 'གློག་འཕྲིན་ཁ་བྱང་ཚུ་ ལྕོགས་ཅན/ལྕོགས་མིན་བཟོ།';
$string['course:view'] = 'སློབ་ཚན་ཚུ་ལྟ།';
$string['course:viewcoursegrades'] = 'སློབ་ཚན་གྱི་སྐུགས་ཚུ་ལྟ།';
$string['course:viewhiddenactivities'] = 'སྦ་བཞག་ཡོད་མི་ལཱ་ཚུ་ལྟ།';
$string['course:viewhiddencourses'] = 'སྦ་བཞག་ཡོད་མི་སློབ་ཚན་ཚུ་ལྟ།';
$string['course:viewhiddensections'] = 'སྦ་བཞག་ཡོད་མི་དབྱེ་ཚན་ཚུ་ལྟ།';
$string['course:viewhiddenuserfields'] = 'སྦ་བཞག་ཡོད་མི་དབྱེ་ཚན་ཚུ་ལྟ།';
$string['course:viewparticipants'] = 'སྦ་བཞག་ཡོད་མི་དབྱེ་ཚན་ཚུ་ལྟ།';
$string['course:viewscales'] = 'ཆ་ཚད་ཚུ་ལྟ།';
$string['course:viewsuspendedusers'] = 'ལག་ལེན་པ་ཕར་བཏོན་གཏང་མི་ཚུ་བལྟ།';
$string['course:visibility'] = 'སློབ་ཚན་ཚུ་ སྦ/སྟོན།';
$string['createrolebycopying'] = 'ལས་འགན་གསརཔ་གཅིག་{$a} ལས་འདྲ་བཤུས་ཕབ་སྟེ་བཟོ་';
$string['createthisrole'] = 'ལས་འགན་འདི་བཟོ།';
$string['currentcontext'] = 'ད་ལྟོའི་སྐབས་དོན་།';
$string['currentrole'] = 'ད་ལྟོའི་ལས་འགན།';
$string['customroledescription'] = 'སྲོལ་སྒྲིག་འགྲེལ་བཤད།';
$string['customrolename'] = 'མིང་ག་ར་སྲོལ་སྒྲིག་འབད།';
$string['defaultrole'] = 'སྔོན་སྒྲིག་ ལས་འགན།';
$string['defaultx'] = ': {$a} གི་སྔོན་སྒྲིག';
$string['defineroles'] = 'ལས་འགན་ཚུ་ངེས་འཛིན་འབད།';
$string['deletecourseoverrides'] = 'སློབ་ཚན་ནང་དབང་ཐ་ཆོད་ནི་ཆ་མཉམ་བཏོན་གཏང་།';
$string['deletelocalroles'] = 'ཉེ་གནས་ལས་འགན་ འགན་ལས་ཚུ་བཏོན་གཏང་།';
$string['deleterolesure'] = 'ལས་འགན་"$a->name ($a->shortname)" བཏོན་གཏང་ནི་ངེས་བདེན་ཨིན་ན?</p><p>ད་ལྟོ་ འགན་ལས་འདི་$a->countལག་ལེན་པ་ཚུ་ལུ་འགན་སྤྲོད་འབད་དེ་ཡོད།';
$string['deletexrole'] = '{$a} ལས་འགན་འདི་བཏོན་གཏང་།';
$string['duplicaterole'] = 'ལས་འགན་རྫུན་མ།';
$string['duplicaterolesure'] = 'ལས་འགན་"$a->name ($a->shortname)" རྫུན་མ་བཟོ་ནི་ངེས་བདེན་ཨིན་ན?</p>';
$string['editingrolex'] = 'ལས་འགན་ཞུན་དག་པ།  \'{$a}';
$string['editrole'] = 'ལས་འགན་ཞུན་དག་འབད།';
$string['editxrole'] = '{$a} ལས་འགན་ཞུན་དག་འབད།';
$string['errorbadrolename'] = 'བདེན་མེད་ལས་འགན་གྱི་མིང་།';
$string['errorbadroleshortname'] = 'བདེན་མེད་ལས་འགན་གྱི་མིང་།';
$string['errorexistsrolename'] = 'ལས་འགན་གྱི་མིང་ཧེ་མ་ལས་རང་འདུག';
$string['errorexistsroleshortname'] = 'ལས་འགན་གྱི་མིང་ཧེ་མ་ལས་རང་འདུག';
$string['eventroleallowassignupdated'] = 'ལས་འགན་སྤྲོད་ཆོགཔ་བཟོ།';
$string['eventroleallowoverrideupdated'] = 'ལས་འགནཐེབ་སྤྲོད་ཆོགཔ་བཟོ།';
$string['eventroleallowswitchupdated'] = 'ལས་འགན་སོར་བཏུབ་བཟོ།';
$string['eventroleassigned'] = 'ལས་འགན་སྤྲོད་ཡོདཔ།';
$string['eventrolecapabilitiesupdated'] = 'ལས་འགན་ཚུགས་པ་དུས་མཐུན་བཟོ་ཡོདཔ།';
$string['eventroledeleted'] = 'ལས་འགན་བཏོན་གཏང་ཡོདཔ།';
$string['eventroleunassigned'] = 'ལས་འགན་མ་སྤྲོད་པར་ཡོདཔ';
$string['existingadmins'] = 'ད་ལྟོ་ བདག་སྐྱོང་ཚུའི་ས་ཁོངས།';
$string['existingusers'] = 'ཡོད་མིའི་ལག་ལེན་པ་ཚུ {$a}';
$string['explanation'] = 'བཤད་པ།';
$string['export'] = 'ཕྱིར་སྐྱོད།';
$string['extusers'] = 'ད་ལྟོ་ ཡོདཔའི་ལག་ལེན་པ་ཚུ།';
$string['extusersmatching'] = '\'{$a}\'ད་ལྟོ་ ཡོདཔའི་ལག་ལེན་པའི་\'{$a}\' མཐུན་སྒྲིག';
$string['filter:manage'] = 'ཉེ་གནས་ ཚགས་ཙ་་འཛིན་སྐྱོང་གཞི་སྒྲིག་ཚུ།';
$string['frontpageuser'] = 'གདོང་ཤོག་གུར་ བདེན་བཤད་བཀོད་ཡོད་པའི་ལག་ལེན་པ།';
$string['frontpageuserdescription'] = 'གདོང་ཤོག་གི་སློབ་ཚན་ནང་ལུ་ ནང་བསྐྱོད་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་ག་ར།';
$string['globalrole'] = 'རིམ་ལུགས་ལས་འགན';
$string['globalroleswarning'] = 'ཉེན་བརྡ!ཤོག་ལེབ་འདི་ནང་ལས་ཁྱོད་ཀྱིས་ལས་འགན་སྤྲོད་མི་འདི་གིས་ གདོང་ཤོག་དང་སློབ་ཚན་ཆ་མཉམ་ཚུད་པའི་ རིམ་ལུགས་ཧྲིལ་བུ་ནང་གི་ལག་ལེན་པ་ག་ར་ལུ་ འཇུག་སྤྱོད་འབད་འོང་།';
$string['gotoassignroles'] = 'ཨ་ནི་{$a->contextlevel} འདི་ནང་ལུ་ ལས་འགན་སྤྲོད་པར་སོང་།';
$string['gotoassignsystemroles'] = 'རིམ་ལུགས་ལས་འགན་ནང་ལུ་སོང་།';
$string['grade:edit'] = 'སྡེ་རིམ་ཞུན་དག་འབད།';
$string['grade:export'] = 'སྡེ་རིམ་ཕྱི་འདྲེན་འབད།';
$string['grade:hide'] = 'སྡེ་རིམ་ཡང་ན་རྣམ་གྲངས་ཚུ་ སྦ/སྟོན།';
$string['grade:import'] = 'སྡེ་རིམ་ཚུ་ནང་འདྲེན་འབད།';
$string['grade:lock'] = 'སྡེ་རིམ་ ཡང་ན་ རྣམ་གྲངས་ཚུ་བསྡམ་བཞག';
$string['grade:manage'] = 'སྡེ་རིམ་རྣམ་གྲངས་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['grade:managegradingforms'] = 'ཁྱད་དུ་འཕགས་པའི་ སྡེ་རིམ་ཐབས་ལམ་ཚུ་ འཛིན་སྐྱོང་།';
$string['grade:manageletters'] = 'ཡི་གུའི་སྡེ་རིམ་འཛིན་སྐྱོང་འཐབ།';
$string['grade:manageoutcomes'] = 'སྡེ་རིམ་གྲུབ་འབྲས་འཛིན་སྐྱོང་འཐབ།';
$string['grade:managesharedforms'] = 'ཁྱད་དུ་འཕགས་པའི་ སྡེ་རིམ་དཔེ་གཞི་འབྲི་ཤོག་ཚུ་ འཛིན་སྐྱོང་།';
$string['grade:override'] = 'སྡེ་རིམ་ཚུ་དབང་ཐ་ཆོད།';
$string['grade:sharegradingforms'] = 'ཁྱད་དུ་འཕགས་པའི་ སྡེ་རིམ་དཔེ་གཞི་འབྲི་ཤོག་ཚུ་ བགོ་བཤའ་རྐྱབས།';
$string['grade:unlock'] = 'སྡེ་རིམ་ཡང་ན་རྣམ་གྲངས་ཚུ་སྟོན།';
$string['grade:view'] = 'རང་གི་སྡེ་རིམ་ཚུ་ལྟ།';
$string['grade:viewall'] = 'ལག་ལེན་གཞན་ཚུ་གི་སྡེ་རིམ་ལྟ།';
$string['grade:viewhidden'] = 'རང་གི་དོན་ལུ་སྦ་བཞག་ཡོད་མི་སྡེ་རིམ་ཚུ་ལྟ།';
$string['hidden'] = 'སྦ།';
$string['highlightedcellsshowdefault'] = 'འོག་ཐིག་ནང་ལུ་གདམ་འཐུ་འབད་ཡོད་མི་འདི་ཚུ་ སྔོན་སྒྲིག་གི་ལས་འགན་archetype ལྟག་ལུ་གདམ་འཐུ་འབད་ཡོད་མི།';
$string['highlightedcellsshowinherit'] = 'འོག་ཐིག་ནང་གཙོ་རྟགས་བཀལ་ཡོད་པའི་ཐིག་ཁྲམ་ཚུ་གིས་བརྒྱུད་དེ་ཐོབ་པའི་གནང་བ་སྟོནམ་མས་(ག་འབད་རུང)། ལྕོགས་གྲུབ་མ་ཡིན་པའི་ ག་གི་གནང་བ་ཁྱོད་བསྒྱུར་བཅོས་འབད་ནི་སྨོ། ཁྱོད་ཀྱིས་ག་ར་བརྒྱུད་དེ་ཐོབ་པའིགཞི་སྒྲིག་འབད་དགོ';
$string['inactiveformorethan'] = '{$a->timeperiod ལས་ ལྷག་སྟེ་ ཤུགས་མེད།';
$string['ingroup'] = '"{$a->group}" སྡེ་ཚན་ནང་།';
$string['inherit'] = 'འཐོབ་ནི།';
$string['invalidpresetfile'] = 'མ་བཏུབ་པའི་་ལས་འགན་གྱི་ཡིག་སྣོད།';
$string['legacy:admin'] = 'LEGACY ROLE: བདག་སྐྱོང་པ།';
$string['legacy:coursecreator'] = 'LEGACY ROLE: སློབ་ཚན་གསར་བསྐྲུན་འབད་མི།';
$string['legacy:editingteacher'] = 'LEGACY ROLE: སློབ་དཔོན་(ཞུན་དག་འབད་མི་)';
$string['legacy:guest'] = 'LEGACY ROLE: མགྱོནམ།';
$string['legacy:student'] = 'LEGACY ROLE: སློབ་ཕྲུག';
$string['legacy:teacher'] = 'LEGACY ROLE: སློབ་དཔོན(ཞུན་དག་མ་འབད་མི།)';
$string['legacytype'] = 'སྔོན་བཤུལ་ལས་འགན་དབྱེ་བ།';
$string['legacy:user'] = 'LEGACY ROLE: བདེན་བཤད་འབད་ཡོད་མི་ལག་ལེན་པ།';
$string['listallroles'] = 'ལས་འགན་ཆ་མཉམ་ཐོ་བཀོད་འབད';
$string['localroles'] = 'ཉེ་གནས་ལུ་འགན་སྤྲོད་འབད་ཡོད་མི་ལས་འགན་ཚུ།';
$string['mainadmin'] = 'བདག་སྐྱོང་པ་གཙོ་འཛིན།';
$string['mainadminset'] = 'བདག་སྐྱོང་གཙོ་འཛིན་གཞི་སྒྲིག་འབད།';
$string['manageadmins'] = 'ས་ཁོངས་བདག་སྐྱོང་པ་ཚུ་འཛིན་སྐྱོང་འབད།';
$string['manager'] = 'འཛིན་སྐྱོང་པ།';
$string['managerdescription'] = 'འཛིན་སྐྱོང་པ་ཚུ་གིས་སློབ་ཚན་ནང་འཛུལ་སྤྱོད་འབད་དེ་བཅོ་ཁ་བརྐྱབ་ཚུགས་། སྤྱིར་བཏང་ ཁོང་ཚུ་སློབ་ཚན་ནང་བཅའ་མར་མི་གཏོགས།';
$string['manageroles'] = 'ལས་འགན་ཚུ་ འཛིན་སྐྱོང་འཐབ།';
$string['maybeassignedin'] = 'སྐབས་ཐོབ་ཅིག་ལས་འགན་འདི་སྤྲོད་ཡི།';
$string['morethan'] = '{$a} ལས་མངམ།';
$string['multipleroles'] = 'སྣ་མང་ལས་འགན།';
$string['my:configsyspages'] = 'ངེ་གི་ངིའི་གདོང་ཤོག་ལུ་ ཤོག་ལེབ་གི་དཔེ་གཞི་རིམ་ལུགས་ རིམ་སྒྲིག་འབད།';
$string['my:manageblocks'] = 'ངིའི་གདོང་ཤོག་གི་སྡེབ་ཚན་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['neededroles'] = 'ལས་འགན་ཚུ་གནང་བ་དང་སྦྲག';
$string['nocapabilitiesincontext'] = 'སྐབས་དོན་འདི་ནང་ལུ་ ལྕོགས་གྲུབ་མིན་འདུག';
$string['noneinthisx'] = '{$a} ནཱ་ལུ་ག་ཅི་ཡང་མིན་འདུག';
$string['noneinthisxmatching'] = 'ཨ་ནི་ {$a->contexttype} ནང་ལུ་ ལག་ལེན་པ་ཚུ་མཐུན་སྒྲིག་མི་འབད་བས \'{$a->search}\' ནང་ལུ་འཚོལ།';
$string['norole'] = 'ལས་འགན་མེདཔ།';
$string['noroleassignments'] = 'ཨ་ནི་ལག་ལེན་པ་འདི་ལུ་ ས་ཁོངས་འདི་ནཱ་ལུ་ ལས་འགན་ག་ནི་ཡང་སྤྲོད་དེ་མིན་འདུག';
$string['noroles'] = 'ལས་འགན་ཚུ་མིན་འདུག';
$string['notabletoassignroleshere'] = 'ཁྱོད་ལུ་ནཱ་ ལས་འགན་ ག་ནི་ཡང་སྤརོད་མི་ཚུགས་པས།';
$string['notabletooverrideroleshere'] = 'ཁྱོད་ནཱ་ལུ་ ལས་འགན་ཚུ་ནང་ ཆ་མེད་གཏང་ནིའི་གནང་བ་མིན་འདུག';
$string['notes:manage'] = 'དྲན་འཛིན་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['notes:view'] = 'དྲན་འཛིན་ཚུ་བལྟ།';
$string['notset'] = 'གཞི་སྒྲིག་མ་འབད་བས།';
$string['overrideanotherrole'] = 'ལས་འགན་གཞན་མི་གཅིག་ཆ་མེད་གཏང་།';
$string['overridecontext'] = 'སྐབས་དོན་འདི་ཆ་མེད་གཏང་།';
$string['overridepermissions'] = 'གནང་བ་ཚུ་དབང་ཐ་ཆོད།';
$string['overridepermissionsforrole'] = 'ལས་འགན་\'{$a->role}\' འདི་ {$a->context} ནང་ཆ་མེད་གཏང་།';
$string['overridepermissionsin'] = '{$a} ནང་ལུ་གནང་མ་མེདཔ་བཟོ།';
$string['overrideroles'] = 'ལས་འགན་ཚུ་དབང་ཐ་ཆོད';
$string['overriderolesin'] = '{$a} ནང་ལུ་ལས་འགན་ཆ་མེད་གཏང་།';
$string['overrides'] = 'དབང་ཐ་ཆོད་ནི།';
$string['overridesbycontext'] = 'ཆ་མེད་གཏང་ (by context)';
$string['permission'] = 'གནང་བ།';
$string['permissions'] = 'གནང་བ་ཚུ།';
$string['permissionsforuser'] = 'ལག་ལེན་པ་ཚུ་ལུ་{$a}གནང་བ།';
$string['permissionsincontext'] = 'ནང་ལུ་གནང་བ་{$a} ཚུ';
$string['portfolio:export'] = 'གསལ་སྡུད་ནང་ལུ་ ཕྱིར་བསྐྱོད་འབད།';
$string['potentialusers'] = 'འོས་འབབ་ཡོད་མི་ལག་ལེན་པ་ཚུ།{$a}';
$string['potusers'] = 'འོས་འབབ་ཡོད་མི་ལག་ལེན་པ་ཚུ།';
$string['potusersmatching'] = 'འོས་འབབ་ཡོད་མི་ལག་ལེན་པ་ཚུ་ \'{$a}\' ནང་མཐུན་སྒྲིག';
$string['prevent'] = 'སྔོན་བཀག';
$string['prohibit'] = 'བཀག་དམ།';
$string['prohibitedroles'] = 'བཀག་དམ་འབད་ཡོདཔ།';
$string['question:add'] = 'དྲི་བ་གསརཔ་ཚུ་ཁ་སྐོང་རྐྱབས།';
$string['question:config'] = 'དྲི་བའི་དབྱེ་བ་ཚུ་རིམ་སྒྲིག་འབད།';
$string['question:editall'] = 'དྲི་བ་ཆ་མཉམ་ཞུན་དག་འབད།';
$string['question:editmine'] = 'ཁྱོད་རའི་དྲི་བ་ཚུ་ཞུན་དག་འབད།';
$string['question:flag'] = 'དྲི་བ་འདི་ཚུ་ལུ་ལན་བརྐྱབ་ད་ ཟུར་རྟགས་བཀལ།';
$string['question:managecategory'] = 'དྲི་བའི་དབྱེ་རིམ་ཚུ་ཞུན་དག་འབད།';
$string['question:moveall'] = 'དྲི་བ་ཆ་མཉམ་སྤོ་བཤུད་འབད།';
$string['question:movemine'] = 'ཁྱོད་རའི་དྲི་བ་ཚུ་སྤོ་བཤུད་འབད།';
$string['question:useall'] = 'དྲི་བ་ཆ་མཉམ་ལག་ལེན་འཐབ།';
$string['question:usemine'] = 'ཁྱོད་རའི་དྲི་བ་ཚུ་ལག་ལེན་འཐབ།';
$string['question:viewall'] = 'དྲི་བ་ག་ར་ལྟ།';
$string['question:viewmine'] = 'ཁྱོད་རའི་དྲི་བ་ཚུ་ལྟ།';
$string['rating:rate'] = 'རྣམས་གྲངས་ཚུ་ལུ་གནས་ཚད་ཁ་སྐོང་བརྐྱབ།';
$string['rating:view'] = 'ཁྱོད་ལུ་ཐོབ་ཡོད་པའི་གནས་ཚད་ཀྱི་བསྡོམས་ལྟ།';
$string['rating:viewall'] = 'མི་ངོམ་རེ་རེ་བཞིན་དུ་གིས་བྱིན་ཡོདཔའི་ མ་བཟོ་བའི་གནས་ཚད་ག་ར་ལྟ།';
$string['rating:viewany'] = 'ག་འབད་རུང་གཅིག་གིས་ཐོབ་ཡོད་པའི་གནས་ཚད་ཀྱི་བསྡོམས།';
$string['resetrole'] = 'སྔོན་སྒྲིག་ཚུ་ལུ་སླར་སྒྲིག་འབད།';
$string['resettingrole'] = '\'{$a}\'ལས་འགན་ལོག་བཟོ་བའི་བསྒང་།';
$string['restore:configure'] = 'གདམ་ཁ་ སོར་ཆུད་རིམ་སྒྲིག་འབད།';
$string['restore:createuser'] = 'ལག་ལེན་པ་ཚ་ སོར་ཆུད་ནང་བཟོ།';
$string['restore:restoreactivity'] = 'སྦྱོང་ལཱ་ཚུ་ སོར་ཆུད་འབད།';
$string['restore:restorecourse'] = 'སློབ་ཚན་ཚུ་ སོར་ཆུད་འབད།';
$string['restore:restoresection'] = 'སྡེ་ཚན་ཚུ་སོར་ཆུད་འབད།';
$string['restore:restoretargethub'] = 'ཡིག་སྣོད་ལྟེ་བ་ལུ་དམིགས་གཏད་བསྐྱེད་ཡོད་མི་ཚུ་སོར་ཆུད་འབད།';
$string['restore:restoretargetimport'] = 'ཡིག་སྣོད་ཕྱིར་བསྐྱོད་ལུ་་དམིགས་གཏད་བསྐྱེད་ཡོད་མི་ཚུ་སོར་ཆུད་འབད།';
$string['restore:rolldates'] = '་གི་རིམ་སྒྲིག་ཚེ་གྲངས་ཚུ་སོར་ཆུད་འབདཝ་ད་སྒྲིལ་བཅུག་ནུག';
$string['restore:uploadfile'] = 'རྒྱབ་སྣོན་གྱི་ས་སྒོ་ཚུ་ནང་ ཡིག་སྣོད་ཚུ་སྐྱེལ་བཙུགས་འབད།';
$string['restore:userinfo'] = 'ལག་ལེན་པའི་གནས་སྡུད་སོར་ཆུད་འབད།';
$string['restore:viewautomatedfilearea'] = 'རང་བཞིན་སྔ་སྒྲིག་ནང་ལས་ སློབ་ཚན་ཚུ་སྐྱར་གསོ་འབད།';
$string['risks'] = 'ཉེན་ཁ།';
$string['roleallowheader'] = 'ལས་འགན་ འབད་བཅུག';
$string['roleallowinfo'] = '{$a->context}, capability {$a->cap}:གི་དོན་ལས་ ཐོ་བཀོད་ཡོད་པའི་ལས་འགན་ཚུ་ལས་ ལས་འགན་གདམ་ཁ་འབད།';
$string['role:assign'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ལས་འགན་སྤྲོད།';
$string['roleassignments'] = 'ལས་འགན་ འགན་སྤྲོད།';
$string['roledefinitions'] = 'ལས་འགན་ངེས་ཏིག';
$string['rolefullname'] = 'ལས་འགན་གྱི་མིང་།';
$string['roleincontext'] = '{$a->context}་ནང་གི{$a->role}';
$string['role:manage'] = 'ལས་འགན་ཚུ་གསར་བསྐྲུན་འབད་དེ་འཛིན་སྐྱོང་འཐབ།';
$string['role:override'] = 'ལག་ལེན་པ་གཞན་ཚུ་གི་དོན་ལུ་ གནང་བ་ཚུ་དབང་ཐ་ཆོད';
$string['roleprohibitheader'] = 'འབད་མ་ཆོག་པའི་ལས་འགན།';
$string['roleprohibitinfo'] = 'མ་རུང་པའི་ལས་འགན་ནང་ལུ་ ཁ་སྐོང་འབད་ནི་གི་ལས་འགན་ཅིག་གདམ་ཁ་འབད་{$a->context}, capability {$a->cap}:';
$string['rolerepreset'] = 'ལས་འགན་སྔ་སྒྲིག་དེ་ལག་ལེན་ཐབ།';
$string['roleresetdefaults'] = 'སྔ་སྒྲིག།';
$string['roleresetrole'] = 'དཔེ་ཡང་དག དེ་ལག་ལེན་འཐབ།';
$string['role:review'] = 'གཞན་གྱི་གནང་བ་ཚུ་བསྐྱར་ཞིབ་འབད།';
$string['rolerisks'] = 'ལས་འགན་གི་ཉེན་ཁག';
$string['roles'] = 'ལས་འགན་ཚུ།';
$string['role:safeoverride'] = 'གཞན་ཚུ་གི་དོན་ལུ་ཉེན་མེད་གནང་བ་ཚུ་དབང་ཐ་ཆོད།';
$string['roleselect'] = 'གདམ་འཐུ་ ལས་འགན་ཚུ།';
$string['rolesforuser'] = '{$a} ལག་ལེན་པ་གི་ལས་འགན་ཚུ།';
$string['roleshortname'] = 'མིང་ཐུང་།';
$string['role:switchroles'] = 'ལས་འགན་གཞན་ལུ་སོར་བསྒྱུར་འབད།';
$string['roletoassign'] = 'འགན་སྤྲོད་འབད་ནིའི་ལས་འགན';
$string['roletooverride'] = 'དབང་ཐ་ཆོད་ནིའི་ལས་འགན';
$string['safeoverridenotice'] = 'དྲན་འཛིན:ཉེན་ཁ་སྦོམ་ཡོད་མི་ལྕོགས་གྲུབ་ཚུ་བསྡམ་བཞག་སྟེ་ཡོད་ ག་ཅི་སྦེ་ཟེར་བ་ཅིན་ཁྱོད་ལུ་ ཉེན་མེད་ལྕོགས་གྲུབ་ཚུ་རྐྱངམ་གཅིག་དབང་ནིའི་གནང་བ་ཡོད';
$string['selectanotheruser'] = 'ལག་ལེན་པ་གཞན་མི་གཅིག་གདམ་འཐུ་འབད།';
$string['selectauser'] = 'ལག་ལེན་པ་གདམ་འཐུ་འབད།';
$string['selectrole'] = 'ལས་འགན་སེལ་འཐུ་འབད།';
$string['showallroles'] = 'ལས་འགན་ཆ་མཉམ་སྟོན།';
$string['showthisuserspermissions'] = 'ལག་ལེན་པ་འདི་གི་གནང་བ་སྟོན།';
$string['site:accessallgroups'] = 'སྡེ་ཚན་ག་ར་ནང་འཛུལ་སྤྱོད་འབད།';
$string['siteadministrators'] = 'ས་ཁོངས་ནང་གི་ བདག་སྐྱོང་པ་ཚུ།';
$string['site:approvecourse'] = 'སློབ་ཚན་གསར་བསྐྲུན་འབད་ནི་ངོས་ལན་འབད།';
$string['site:backup'] = 'ཉེན་སྲུང་སློབ་ཚན་ཚུ།';
$string['site:config'] = 'ས་ཁོངས་རིམ་སྒྲིགས་ བསྒྱུར་བཅོས་འབད།';
$string['site:doanything'] = 'ག་ཅིག་ཡང་འབད་ཆོག';
$string['site:doclinks'] = 'ཨོཕ་སའིཊ་ ཌོཀས་ལུ་ འབྲེལ་ལམ་ཚུ་སྟོན།';
$string['site:import'] = 'སློབ་ཚན་གཞན་ཚུ་སློབ་ཚན་ནང་ ནང་འདྲེན་འབད།';
$string['site:manageblocks'] = 'ས་ཁོངས་-གནས་རིམ་སྡེབ་ཚན་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['site:mnetloginfromremote'] = 'ཐག་རིང་མུ་ཌེལ་ལས་ ནང་བསྐྱོད་འབད།';
$string['site:mnetlogintoremote'] = 'ཐག་རིང་མུ་ཌེལ་ནང་འགྱོ།';
$string['site:readallmessages'] = 'ས་ཁོངས་ནང་གི་འཕྲིན་དོན་ཆ་མཉམ་ལྷག';
$string['site:restore'] = 'སློབ་ཚན་ཚུ་སོར་ཆུད་འབད།';
$string['site:sendmessage'] = 'ལག་ལེན་པ་གང་རུང་ལུ་ འཕྲིན་དོན་ཚུ་གཏང་།';
$string['site:trustcontent'] = 'སྤོད་ཡོད་མི་ནང་དོན་ལུ་བློ་གཏད།';
$string['site:uploadusers'] = 'ཡིག་སྣོད་ནང་ལས་ལག་ལེན་པ་གསརཔ་ཚུ་ སྐྱེས་བཙུགས་འབད།';
$string['site:viewfullnames'] = 'ཨ་རྟ་རང་ ལག་ལེན་པའི་མིང་ཆ་ཚང་བལྟ།';
$string['site:viewparticipants'] = 'བཅའ་མར་གཏོགས་མི་ཚུ་བལྟ།';
$string['site:viewreports'] = 'སྙན་ཞུ་ཚུ་བལྟ།';
$string['site:viewuseridentity'] = 'ལག་ལེན་པ་ཚུ་ག་ར་གི་ངོ་རྟགས་ལྟ།';
$string['tag:create'] = 'ངོ་རྟགས་གསརཔ་ཚུ་གསར་བསྐྲུན་འབད།';
$string['tag:edit'] = 'ད་ལྟོ་ཡོད་མི་ངོ་རྟགས་ཚུ་ཞུན་དག་འབད།';
$string['tag:editblocks'] = 'ངོ་རྟགས་ཤོག་ལེབ་ནང་སྡེབ་ཚན་ཚུ་ཞུན་དག་འབད།';
$string['tag:flag'] = 'ངོ་རྟགས་འདི་ཚུ་ མིནམ་སྦེ་ ཟུར་རྟགས་བཀལ།';
$string['tag:manage'] = 'ངོ་རྟགས་ག་ར་ འཛིན་སྐྱོང་འཐབ།';
$string['thisnewrole'] = 'ཨ་ནི་ལས་འགན་གསརཔ།';
$string['thisusersroles'] = 'ལག་ལེན་པ་འདི་གི་ལས་འགན་གྱི་ལཱ་ཚུ།';
$string['unassignarole'] = '{$a} ལས་འགན་མ་སྤྲོདཔ།';
$string['unassignconfirm'] = '"{$a->user}" ཁྱོད་ལག་ལེན་པའི་འགན་ཁ་"{$a->role}" འདི་ནང་ལས་ ཐད་རི་པ་རི་ཕྱི་ཤོལ་འབད་་ནི་ཨིན་ན?';
$string['unassignerror'] = 'ལག་ལེན་པ་{$a->user}.ལུ་{$a->role}  ལས་འགན་ཕྱི་ཤོལ་འབད་བའི་སྐབས་མ་བཏུབ།';
$string['user:changeownpassword'] = 'རང་གི་ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད།';
$string['user:create'] = 'ལག་ལེན་པ་ཚུ་གསར་བསྐྲུན་འབད།';
$string['user:delete'] = 'ལག་ལེན་པ་ཚུ་བཏོན་གཏང་།';
$string['user:editmessageprofile'] = 'ལག་ལེན་པ་ཚུ་གི་ གློག་འཕྲིན་གསལ་སྡུད་ ཞུན་དག་འབད།';
$string['user:editownmessageprofile'] = 'ལག་ལེན་པ་ཚ་རང་གི་གློག་འཕྲིན་གསལ་སྡུད་ཞུན་དག་འབད།';
$string['user:editownprofile'] = 'རང་གི་ལག་ལེན་པའི་གསལ་སྡུད་ཞུན་དག་འབད།';
$string['user:editprofile'] = 'ལག་ལེན་པའི་གསལ་སྡུད་ཞུན་དག་འབད།';
$string['user:ignoreuserquota'] = 'ལག་ལེན་པའི་ཐོབ་ལམ་གྱི་ཚད་སྣང་མེད་སྦེ་བཞག';
$string['user:loginas'] = 'ལག་ལེན་པ་གཞན་མི་གཅིག་སྦེ་ ནང་བསྐྱོད་འབད';
$string['user:manageblocks'] = 'ལག་ལེན་པ་གཞན་མི་ཚུ་གི་གསལ་སྡུད་ལུ';
$string['user:manageownblocks'] = 'མི་དམང་ལག་ལེན་པའི་གསལ་སྡུད་ནང་ལུ་ རང་གི་བཀན་འཛིན་འཛིན་སྐྱོང་འབད།';
$string['user:manageownfiles'] = 'རང་དབང་སྒེར་གྱི་ཡིག་སྣོད་ས་ཁོངས་ནང་ལུ་ ཡིག་སྣོད་འཛིན་སྐྱོང་འབད།';
$string['user:managesyspages'] = 'མི་དམང་ལག་ལེན་པའི་གསལ་སྡུད་ནང་ལུ་ སྔོན་སྒྲིག་གི་ཤོག་ལེབ་བཀོད་རིས་ རིམ་སྒྲིག་འབད།';
$string['user:readuserblogs'] = 'ལག་ལེན་པའི་སྡེབ་ཚན་ཆ་མཉམ་བལྟ།';
$string['user:readuserposts'] = 'ལག་ལེན་པའི་བརྡ་འཕྲིན་ཆ་མཉམ་བལྟ།';
$string['usersfrom'] = '{$a} ལས་ལག་ལེན་པ།';
$string['usersfrommatching'] = '{$a->contextname} འདི་ལས་ལག་ལེན་པ་ཚུ་ \'{$a->search}\' མཐུན་སྒྲིག་འབད་དོ།';
$string['usersinthisx'] = '{$a}་ལག་ལེན་པ་འདི་ཚུ།';
$string['usersinthisxmatching'] = '{$a->contexttype} འདི་ལས་ལག་ལེན་པ་ཚུ་ \'{$a->search}\' མཐུན་སྒྲིག་འབད་དོ།';
$string['userswithrole'] = 'ལས་འགན་ཡོད་མི་ལག་ལེན་པ་ཆ་མཉམ།';
$string['userswiththisrole'] = 'ལག་ལེན་པ་ལས་འགན་དང་སྦྲག་སྟེ།';
$string['user:update'] = 'ལག་ལེན་པའི་གསལ་སྡུད་ཚུ་དུས་མཐུན་བཟོ།';
$string['user:viewalldetails'] = 'ལག་ལེན་པའིགནས་ཚུལ་ག་ར་ལྟ།';
$string['user:viewdetails'] = 'ལག་ལེན་པའི་གསལ་སྡུད་སྟོན';
$string['user:viewhiddendetails'] = 'ལག་ལེན་པའི་རྒྱས་བཤད་སྦ་བཞག་ཡོད་མི་ཚུ་སྟོན';
$string['user:viewuseractivitiesreport'] = 'ལག་ལེན་པའི་ལཱ་གི་སྙན་ཞུ་ཚུ་བལྟ།';
$string['user:viewusergrades'] = 'ལག་ལེན་པའི་སྡེ་རིམ་ཚུ་སྟོན';
$string['useshowadvancedtochange'] = 'ལག་ལེན་འཐབ་ \'Show advanced\' སོར་ནིའི་དོན་ལས།';
$string['viewingdefinitionofrolex'] = 'ཨ་ནི་\'{$a}\' ལས་འགན་གྱི་འགརེལ་བཤད་ལྟ་བའི་བསགང་ཨིན།';
$string['viewrole'] = 'ལས་འགན་རྒྱས་བཤད་སྟོན';
$string['webservice:createmobiletoken'] = 'འགྲུལ་འཕྲིན་ནང་འཛུལ་སྤྱོད་འབད་ནིའི་དོན་ལུ་ ཝེབ་ཞབས་ཏོག་བརྡ་མཚོན་བཟོ།';
$string['webservice:createtoken'] = 'ཝེབ་ཞབས་ཏོག་བརྡ་མཚོན་བཟོ།';
$string['whydoesuserhavecap'] = '{$a->fullname} འདི་ག་ཅི་སྦེ་ལྕོགས་གྲུབ་{$a->capability} སྐབས་ཐོབ་ {$a->context}ནང་ན་ཡོད་ག?';
$string['whydoesusernothavecap'] = '{$a->fullname} འདི་ག་ཅི་སྦེ་ལྕོགས་གྲུབ་{$a->capability} སྐབས་ཐོབ་ {$a->context}ནང་ན་ཡོད་ག?';
$string['xroleassignments'] = '{$a}\'s ལས་འགན་སྤྲོད་ནི་ཚུ།';
$string['xuserswiththerole'] = '"{$a->role}"ལས་འགན་ཡོད་མི་ ལག་ལེན་པ།';
