<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'དང་ལེན';
$string['accept_grades'] = 'ལག་ཆས་ལས་གནས་ཚད ་ཚུ་དང་ལེན་འབད';
$string['accept_grades_admin'] = 'ལག་ཆས་ལས་གནས་ཚད ་ཚུ་དང་ལེན་འབད';
$string['accept_grades_admin_help'] = 'Specify whether the tool provider can add, update, read, and delete གནས་ཚད ་ཚུ་ associated with instances of this tool དབྱེ་བ།.

Some tool providers support reporting གནས་ཚད ་ཚུ་ back to Moodle based on actions taken within the tool, creating a more integrated
experience.';
$string['accept_grades_help'] = 'Specify whether the tool provider can add, update, read, and delete གནས་ཚད ་ཚུ་ associated only with this ཕྱིའི tool instance.

Some tool providers support reporting གནས་ཚད ་ཚུ་ back to Moodle based on actions taken within the tool, creating a more integrated
experience.

Note that this setting may be overriden in the tool རིམ་སྒྲིག.';
$string['action'] = 'བྱ་བ།';
$string['active'] = 'ཤུགས་ལྡན།';
$string['activity'] = 'སྦྱོང་ལཱ';
$string['addnewapp'] = 'ཕྱིའི་གློག་རིམ་ལྕོགས་ཅན་བཟོ།';
$string['addserver'] = 'trusted server་གསརཔ་ཁ་སྐོང་རྐྱབས།';
$string['addtype'] = 'ཁ་སྐོང་རྐྱབས་ཕྱིའི་ལག་ཆས་རིམ་སྒྲིག';
$string['allow'] = 'བཅུག';
$string['allowinstructorcustom'] = 'སློབ་དཔོན་ཚུ་ལུ་སྲོལ་སྒྲིག་ཚད་བཟུང་ཚུ་ཁ་སྐོང་རྐྱབས་བཅུག';
$string['allowsetting'] = 'ལག་ཆས་ལས་གནས་ཚད ་ཚུ་དང་ལེན་འབད';
$string['always'] = 'ཨ་རྟག་རང་།';
$string['automatic'] = 'རང་བཞིན, based on URLགསར་བཙུགས་འབད';
$string['baseurl'] = 'གཞི་རྟེན། URL';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI སྦྱོང་ལཱ་ཚུ';
$string['basiclti_base_string'] = 'LTI OAuth གཞི་རྟེན་ཡིག་རྒྱུན།';
$string['basiclti_endpoint'] = 'LTI གསར་བཙུགས་འབད་ མཐའ་རྩེ།';
$string['basicltifieldset'] = 'སྲོལ་སྒྲིག  དཔེར་བརྗོད  fieldset';
$string['basiclti_in_new_window'] = 'ཁྱོད་ཀྱི་སྦྱོང་ལཱ་དེ་windowགསརཔ་ ནང་ཕྱེ་ནུག།';
$string['basicltiintro'] = 'སྦྱོང་ལཱ་ འགྲེལ་བཤད།';
$string['basicltiname'] = 'སྦྱོང་ལཱ་མིང';
$string['basiclti_parameters'] = 'LTI གསར་བཙུགས་འབད ཚད་བཟུང་ཚུ';
$string['basicltisettings'] = 'གཞི་རིམ་ སྦྱང་ནི ལག་ཆས Interoperability གཞི་སྒྲིག་ཚུ';
$string['cannot_delete'] = 'ཁྱོད་tool རིམ་སྒྲིག་བཏོན་མ་གཏང་།';
$string['cannot_edit'] = 'ཁྱོད་tool རིམ་སྒྲིག་ཞུན་དག་མ་འབད།';
$string['comment'] = 'བསམ་བཀོད།';
$string['configpassword'] = 'སྔོན་སྒྲིག་ ཐག་རིང་ ལག་ཆས ཆོག་ཡུག';
$string['configpreferheight'] = 'སྔོན་སྒྲིག དགའ་གདམ་ཅན མཐོ་ཚད།';
$string['configpreferwidget'] = 'widget་སྔོན་སྒྲིག་སྦེ་གཞི་སྒྲིག་འབད';
$string['configpreferwidth'] = 'སྔོན་སྒྲིག དགའ་གདམ་ཅན་ རྒྱ་ཚད།';
$string['configresourceurl'] = 'སྔོན་སྒྲིག ཐོན་ཁུངས། URL';
$string['configtoolurl'] = 'སྔོན་སྒྲིག་ ཐག་རིང་ ལག་ཆས URL';
$string['configtypes'] = 'LTI གློག་རིམ་ལྕོགས་ཅན་བཟོ།';
$string['courseid'] = 'སློབ་ཚན id number';
$string['coursemisconf'] = 'སློབ་ཚན་ རིམ་སྒྲིག་ཕྱི་འགྱུར་འབད་ནུག';
$string['course_tool_types'] = 'སློབ་ཚན tool དབྱེ་བ།s';
$string['createdon'] = 'ལུ་གསར་བསྐྲུན་འབད་ཡོདཔ།';
$string['curllibrarymissing'] = 'LTIལག་ལེན་འཐབ་ནི་དོན་ལུ་PHP Curl library་གཞི་བཙུགས་འབད་དགོ།';
$string['custom'] = 'སྲོལ་སྒྲིག་ཚད་བཟུང་ཚུ';
$string['custom_config'] = 'སྲོལ་སྒྲིག་ལག་ཆས་རིམ་སྒྲིག་ལག་ལེན་འཐབ་དོ';
$string['custom_help'] = 'སྲོལ་སྒྲིག། ཚད་བཟུང་།s are settings used by the tool provider. For example, a custom ཚད་བཟུང་། may be used to display
a specific resource from the provider.

It is safe to leave this field unchanged unless directed by the tool provider.';
$string['custominstr'] = 'སྲོལ་སྒྲིག་ཚད་བཟུང་ཚུ';
$string['debuglaunch'] = 'རྐྱེན་སེལ གདམ་ཁ།';
$string['debuglaunchoff'] = 'སྤྱིར་བཏང་གསར་བཙུགས་འབད';
$string['debuglaunchon'] = 'རྐྱེན་སེལ་ གསར་བཙུགས་འབད';
$string['default'] = 'སྔོན་སྒྲིག';
$string['default_launch_container'] = 'སྔོན་སྒྲིག གསར་བཙུགས་འབད་ འཛིན་སྣོད།';
$string['default_launch_container_help'] = 'The launch container affects the display of the tool when launched from the course. Some launch containers provide more screen
real estate to the tool, and others provide a more integrated feel with the Moodle environemnt.

* **སྔོན་སྒྲིག** - Use the launch container specified by the tool རིམ་སྒྲིག.
* **Embed** - The tool is displayed within the existing Moodle window, in a manner similar to most other སྦྱོང་ལཱ དབྱེ་བ།s.
* **Embed, without blocks** - The tool is displayed within the existing Moodle window, with just the neavigation controls
        at the top of the page.
* **New window** - The tool opens in a new window, occupying all the available space.
        Depending on the browser, it will open in a new tab or a popup window.
        It is possible that browsers will prevent the new window from opening.';
$string['delegate'] = 'སློབ་དཔོན་ལུ་བགོ་སྤེལ་འབད།';
$string['delete'] = 'བཏོན་གཏང་།';
$string['delete_confirmation'] = 'ཕྱིའི་ལག་ཆས་རིམ་སྒྲིག་བཏོན་གཏང་ངེས་གཏན་ཨིན་ན?';
$string['deletetype'] = 'ཕྱིའི་ལག་ཆས་རིམ་སྒྲིག་བཏོན་གཏང་།';
$string['display_description'] = 'སྦྱོང་ལཱ་ འགྲེལ་བཤད་གསར་བཙུགས་འབད་ད་བཀྲམ་སྟོན།';
$string['display_description_help'] = 'If selected, the activity description (specified above) will display above the tool provider\'s content.

The description may be used to provide additional instructions for launchers of the tool, but it is not required.

The description is never displayed when the tool\'s launch container is in a new window.';
$string['display_name'] = 'སྦྱོང་ལཱ་མིང་གསར་བཙུགས་འབད་ད་བཀྲམ་སྟོན།';
$string['display_name_help'] = 'If selected, the activity name (specified above) will display above the tool provider\'s content.

It is possible that the tool provider may also display the title. This option can prevent the activity title from
being displayed twice.

The title is never displayed when the tool\'s launch container is in a new window.';
$string['domain_mismatch'] = 'URL\'s domainགསར་བཙུགས་འབད  match རིམ་སྒྲིག་ལག་ཆས་གཅིག་ཁར་མ་མཐུན།';
$string['donot'] = 'མ་གཏང་།';
$string['donotaccept'] = 'དང་ལེན་མ་འབད།';
$string['donotallow'] = 'མ་བཅུག།';
$string['edittype'] = 'ཕྱིའི་ལག་ཆས་རིམ་སྒྲིག་ཞུན་དག་འབད།';
$string['embed'] = 'གནས་འདྲེན།';
$string['embed_no_blocks'] = 'གནས་འདྲེན་སྡེབ་ཚན་མེད་པར།';
$string['enableemailnotification'] = 'བརྡ་བསྐུལ་གློག་འཕྲིན་གཏང་།';
$string['errormisconfig'] = 'རིམ་སྒྲིག་ཕྱི་འགྱུར་ཡོདཔ་མི་ལག་ཆས། བཅོ་ནི་དོན་ལུ་ཁྱོད་ཀྱི་ Moodle རིམ་ལུགས་བདག་སྐྱོང་པ་ལུ་འབྲེལ་བ་འཐབ།';
$string['extensions'] = 'LTI དར་ཁྱབ་ཞབས་ཏོག་ཚུ།';
$string['external_tool_type'] = 'ཕྱིའི་ལག་ཆས་དབྱེ་བ།';
$string['external_tool_type_help'] = 'The main purpose of a tool རིམ་སྒྲིག is to set up a secure communication channel between Moodle and the tool provider.
It also provides an opportunity for རིམ་སྒྲིག defaults and setting up additional services provided by the tool.

* **Automatic, based on གསར་བཙུགས་འབད URL** - This setting should be used in almost all cases. Moodle will select the most appropriate tool རིམ་སྒྲིག
       based on the གསར་བཙུགས་འབད URL. ལག་ཆསs configured by both an administrator or within this course will be used.
       When the གསར་བཙུགས་འབད URL is specified, Moodle will provide feedback on whether it recognizes it or not. If Moodle does not recognize the གསར་བཙུགས་འབད URL,
       you may need to enter the tool རིམ་སྒྲིག details manually.
* **A specific tool དབྱེ་བ།** - By selecting a specific tool དབྱེ་བ།, you can force Moodle to use that tool རིམ་སྒྲིག when communicating with the
       ཕྱིའི tool provider. If the གསར་བཙུགས་འབད URL does not appear to belong to the tool provider, a warning will appear. In some cases, it is not necessary
       to enter a གསར་བཙུགས་འབད URL when providing a specific tool དབྱེ་བ། (if not launching to a particular resource within the tool provider).
* **སྲོལ་སྒྲིག། རིམ་སྒྲིག** - To setup custom tool རིམ་སྒྲིག on just this instance, show Advanced options, and enter the consumer key and
       shared secret yourself. If you do not have a consumer key and shared secret, you may be able to request them from the tool provider.
       Not all tools require a consumer key and shared secret, in which case the fields may be left blank.

### ལག་ཆས དབྱེ་བ། editing

Three icons are available after the ཕྱིའི། tool དབྱེ་བ། dropdown list:

* **ཁ་སྐོང་རྐྱབས།** - Create a course level tool རིམ་སྒྲིག. All ཕྱིའི། ལག་ཆས instances in this course may use the tool རིམ་སྒྲིག.
* **Edit** - Select a course level tool དབྱེ་བ། from the dropdown, then click this icon. The details of the tool རིམ་སྒྲིག may be edited.
* **Delete** - Remove the selected course level tool དབྱེ་བ།.';
$string['external_tool_types'] = 'ཕྱིའི་ ལག་ཆས དབྱེ་བ་ཚུ';
$string['failedtoconnect'] = 'Moodleའདི་"{$a}"གཅིག་ཁར་བརྡ་དོན་སྤྲོད་མི་ཚུགས་འབད།';
$string['filter_basiclti_configlink'] = 'ཁྱོད་དགའ་གདམ་ཅན་ས་ཁོངས་དང་ཆོག་ཡིག་ཚུ་རིམ་སྒྲིག་འབད།';
$string['filter_basiclti_password'] = 'ཆོག་ཡིག་ངེས་པར་དུ་་དགོ།';
$string['filterconfig'] = 'LTI  བདག་སྐྱོང༌།';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'nstanceརིམ་སྒྲིག་ཕྱི་འགྱུར་སྦེ་ཡོདཔ་མི་ལུ་ད་ལྟོ་ཡོད་མི་རིམ་སྒྲིག་དེ་ལག་ལེད་འཐབ།';
$string['fixnew'] = 'རིམ་སྒྲིག་གསརཔ།';
$string['fixnewconf'] = 'instanceརིམ་སྒྲིག་ཕྱི་འགྱུར་སྦེ་ཡོདཔ་མི་ལུ་རིམ་སྒྲིག་གསརཔ་ངེས་འཛིན་འབད';
$string['fixold'] = 'ད་ལྟོ་ཡོད་མི་ལག་ལེད་འཐབ།';
$string['forced_help'] = 'This setting has been forced in a course or site level tool རིམ་སྒྲིག. You may not change it from this interface.';
$string['force_ssl'] = 'Force་་SSL';
$string['force_ssl_help'] = 'Selecting this option forces all launches to this tool provider to use SSL.

In addition, all web service requests from the tool provider will use SSL.

If using this option, confirm that this Moodle site and the tool provider support SSL.';
$string['global_tool_types'] = 'Global ལག་ཆས་དབྱེ་བ་ཚུ';
$string['grading'] = 'གནས་ཚད Routing';
$string['icon_url'] = 'URL པར་རྟགས།';
$string['icon_url_help'] = 'The icon URL allows the icon that shows up in the course listing for this activity to be modified. Instead of using the default
LTI icon, an icon which conveys the དབྱེ་བ། of activity may be specified.';
$string['id'] = 'ངོ་རྟགས';
$string['invalidid'] = 'LTI ID་བདེན་མེད།';
$string['launch_in_moodle'] = 'moodle ནང་ན་ལག་ཆས་གསར་བཙུགས་འབད';
$string['launchinpopup'] = 'གསར་བཙུགས་འབད་ནི་གྱི་འཛིན་སྣོད།';
$string['launch_in_popup'] = 'pop-up ནང་ན་ལག་ཆས་གསར་བཙུགས་འབད';
$string['launchinpopup_help'] = 'The launch container affects the display of the tool when launched from the course. Some launch containers provide more screen
real estate to the tool, and others provide a more integrated feel with the Moodle environemnt.

* **སྔོན་སྒྲིག** - Use the launch container specified by the tool རིམ་སྒྲིག.
* **Embed** - The tool is displayed within the existing Moodle window, in a manner similar to most other སྦྱོང་ལཱ དབྱེ་བ།s.
* **Embed, without blocks** - The tool is displayed within the existing Moodle window, with just the neavigation controls
        at the top of the page.
* **New window** - The tool opens in a new window, occupying all the available space.
        Depending on the browser, it will open in a new tab or a popup window.
        It is possible that browsers will prevent the new window from opening.';
$string['launchoptions'] = 'གསར་བཙུགས་འབད་ནི་གདམ་ཁ་ཚུ';
$string['launch_url'] = 'གསར་བཙུགས་འབད URL';
$string['launch_url_help'] = 'The གསར་བཙུགས་འབད URL indicates the web address of the ཕྱིའི། ལག་ཆས, and may contain additional information, such as the resource to show.
If you are unsure what to enter for the གསར་བཙུགས་འབད URL, please check with the tool provider for more information.

If you have selected a specific tool དབྱེ་བ།, you may not need to enter a གསར་བཙུགས་འབད URL. If the tool link is used to just launch
into the tool provider\'s system, and not go to a specific resource, this will likely be the case.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'LTI སྦྱོང་ལཱ་གནས་ཚད།';
$string['lti:addinstance'] = 'LTI  སྦྱོང་ལཱ་གསརཔ་ཁ་སྐོང་རྐྱབས།';
$string['lti_administration'] = 'LTI བདག་སྐྱོང༌།';
$string['lti_errormsg'] = 'ལག་ཆས་འོག་གི་འཛོལ་བའི་འཕྲིན་དོན: "{$a}"་ལོག་གཏང་ནུག།';
$string['lti:grade'] = 'LTI སྦྱོང་ལཱ་གནས་ཚད།';
$string['lti_launch_error'] = 'ཕྱིའི་ལག་ཆས་གསར་བཙུགས་འབདཝ་ད་འཛོལ་བ་བྱུང་ནུག།ཕྱིའི་ལག་ཆས:';
$string['lti_launch_error_tool_request'] = '<p>
བདག་སྐྱོང་པའི་ལག་ཆས་རིམ་སྒྲིག་མཇུག་བསྡུ་ནི་དོན་ལས་  ་,  <a href="{$a->admin_request_url}" target="_top">ནཱ་ལུ་</a>ཨེབ་གཏང་འབད་ཞུ་བ་ཕུལ་
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>
        This error may be a result of a missing consumer key and shared secret for the tool provider.
    </p>
    <p>
        If you have a consumer key and shared secret, you may enter it when editing the ཕྱིའི tool instance (make sure advanced options are visible).<br />
        Alternatively, you may create a course level tool provider རིམ་སྒྲིག <a href="{$a->course_tool_editor}">here</a>.
    </p>';
$string['lti:manage'] = 'LTI སྦྱོང་ལཱ་ཞུན་དག་འབད།';
$string['lti:requesttooladd'] = 'ལག་ཆས་རིམ་སྒྲིག་དེ་ རིམ་ལུགས་བདག་སྐྱོང་པ་ཚུ་ལུ་ཕུལ།';
$string['lti_tool_request_added'] = 'ལག་ཆས་རིམ་སྒྲིག་ཞུ་བ་ཕུལ་ཡི།  བདག་སྐྱོང་པའི་ལག་ཆས་རིམ་སྒྲིག་མཇུག་བསྡུ་ནི་དོན་ལས་ ཁྱོད་བདག་སྐྱོང་པ་གཅིག་ཁར་འབྲེལ་བ་འཐབ།';
$string['lti_tool_request_existing'] = 'ལག་ཆས domain་དོན་ལུ་ལག་ཆས་རིམ་སྒྲིག་ཕུལ་ཡི།';
$string['ltiunknownserviceapicall'] = 'མ་ཤེས་པའི་LTIཞབས་ཏོག་API call.';
$string['lti:view'] = 'LTI སྦྱོང་ལཱ་ཞུན་སྟོན།';
$string['main_admin'] = 'ཡོངས་ཁྱབ་གྲོགས་རམ།';
$string['main_admin_help'] = 'ཕྱིའི། tools allow Moodle users to seamlessly interact with learning resources hosted remotely. Through a special
launch protocol, the remote tool will have access to some general information about the launching user. For example,
the institution name, course id, user id, and other information such as the user\'s name or e-mail address.

ལག་ཆས དབྱེ་བ།s listed on this page are separated into three categories:

* **Active** - These tool providers have been approved and configured by an administrator. They can be used from within any
        course on this Moodle instance. If a consumer key and shared secret are entered, a trust relationship is established
        between this Moodle instance and the remote tool, providing a secure communication channel.
* **Pending** - These tool providers came in through a package import, but have not been configured by an administrator.
        Teachers may still use tools from these providers if they have a consumer key and shared secret, or if none is required.
* **Rejected** - These tools providers are flagged as ones which an administrator has no intention of making available to the entire
        Moodle instance. Teachers may still use tools from these providers if they have a consumer key and shared secret, or if none is required.';
$string['miscellaneous'] = 'སྣ་ཚོགས།';
$string['misconfiguredtools'] = 'ལག་ཆས་instancesརིམ་སྒྲིག་ཕྱི་འགྱུར་སྐྱོན་འཛིན་ཡི།';
$string['missingparameterserror'] = 'འདི་ཤོག་ལེབ: "{$a}" རིམ་སྒྲིག་ཕྱི་འགྱུར་འབད་ནུག།';
$string['module_class_type'] = 'Moodle module དབྱེ་བ།';
$string['modulename'] = 'ཕྱིའི་ལག་ཆས';
$string['modulename_help'] = 'The ཕྱིའི tool activity module enables students to interact with learning resources and activities on other web sites. For example, an ཕྱིའི tool could provide access to a new activity དབྱེ་བ། or learning materials from a publisher.

To create an ཕྱིའི tool activity, a tool provider which supports LTI (Learning ལག་ཆསs Interoperability) is required. A teacher can create an ཕྱིའི tool activity or make use of a tool configured by the site administrator.

ཕྱིའི། tool activities differ from URL resources in a few ways:

* ཕྱིའི། tools are context aware i.e. they have access to information about the user who launched the tool, such as institution, course and name
* ཕྱིའི། tools support reading, updating, and deleting གནས་ཚད ་ཚུ་ associated with the activity instance
* ཕྱིའི། tool རིམ་སྒྲིགs create a trust relationship between your site and the tool provider, allowing secure communication between them';
$string['modulenameplural'] = 'basicltis';
$string['modulenamepluralformatted'] = 'LTI ལས།';
$string['never'] = 'ནམ་ཡང་།';
$string['new_window'] = 'window གསརཔ';
$string['noattempts'] = 'ལག་ཆས་instanceལུ་དཔའ་མ་བཅམ་ནུག';
$string['no_lti_configured'] = 'ཤུགས་ལྡན་མེད་པའི་ཕྱིའི་ལག་ཆས་ཚུ་རིམ་སྒྲིག་འབད་ནུག';
$string['no_lti_pending'] = 'ཕྱིའི་ལག་ཆས་ཚུ་བསྣར་མེད།';
$string['no_lti_rejected'] = 'ཕྱིའི་ལག་ཆས་ཚུ་དང་ལེན་སྤངས་པ་མེད།';
$string['noltis'] = 'lti instancesམིན་འདུག';
$string['noservers'] = 'serversམིན་འདུག';
$string['notypes'] = 'ད་ལྟོ་Moodle་ནང་ན་LTI ལག་ཆས་གཞི་སྒྲིག་མ་འབད་ནུག།';
$string['noviewusers'] = 'ལག་ལེན་པ་ཚུ་འདི་ལག་ཆས་ལག་ལེན་འཐབ་དོན་ལས་གནང་བ་མིན་འདུག།';
$string['optionalsettings'] = 'གདམ་ཁ་ཅན་གཞི་སྒྲིག་ཚུ།';
$string['organization'] = 'ཚོགས་སྡེ་རྒྱས་བཤད་ཚུ།';
$string['organizationdescr'] = 'ཚོགས་སྡེ་འགྲེལ་བཤད།';
$string['organizationid'] = 'ཚོགས་སྡེ ID';
$string['organizationid_help'] = 'A unique identifier for this Moodle instance. Typically, the DNS name of the organization is used.

If this field is left blank, the host name of this Moodle site will be used as the default value.';
$string['organizationurl'] = 'ཚོགས་སྡེ། URL';
$string['organizationurl_help'] = 'The base URL of this Moodle instance.

If this field is left blank, a default value will be used based on the site རིམ་སྒྲིག.';
$string['pagesize'] = 'ཤོག་ལེབ་རེ་རེ་ལུ་ཞུ་འབུལ།';
$string['password'] = 'རུབ་སྤྱོད་ གསང་བ།';
$string['password_admin'] = 'རུབ་སྤྱོད་ གསང་བ།';
$string['password_admin_help'] = 'The shared secret can be thought of as a password used to authenticate access to the tool. It should be provided
along with the consumer key from the tool provider.

ལག་ཆསs which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a shared secret.';
$string['password_help'] = 'For pre-configured tools, it is not necessary to enter a shared secret here, as the shared secret will be
provided as part of the རིམ་སྒྲིག process.

This field should be entered if creating a link to a tool provider which is not already configured.
If the tool provider is to be used more than once in this course, adding a course tool རིམ་སྒྲིག is a good idea.

The shared secret can be thought of as a password used to authenticate access to the tool. It should be provided
along with the consumer key from the tool provider.

ལག་ཆསs which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a shared secret.';
$string['pending'] = 'བསྣར';
$string['pluginadministration'] = 'LTI བདག་སྐྱོང༌།';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'དགའ་གདམ་ཅན་ མཐོ་ཚད།';
$string['preferwidget'] = 'དགའ་བའི་ Widget གསར་བཙུགས་འབད';
$string['preferwidth'] = 'དགའ་གདམ་ཅན རྒྱ་ཚད།';
$string['press_to_submit'] = 'སྦྱོང་ལཱ་གསར་བཙུགས་འབད་ནི་དོན་ལུ་མནན།';
$string['privacy'] = 'སྒེར་གཙང་།';
$string['quickgrade'] = 'གནས་ཚད་འཕྲལ་མགྱོགས་འབད་བཅུག';
$string['quickgrade_help'] = 'If enabled, multiple tools can be graded on one page. ཁ་སྐོང་རྐྱབས། གནས་ཚད ་ཚུ་ and comments then click the "Save all my feedback" button to save all changes for that page.';
$string['redirect'] = 'ཁྱོད་སྐར་ཆ་དག་པ་ཅིག་ལས་སླར་་ལོག་གཏང་འོང།  ག་དེམ་ཅིག་འབད་མ་གཏང་པ་ཅིན་ཨེབ་རྟ་འདི་མནན།';
$string['reject'] = 'དང་ལེན་སྤངས།';
$string['rejected'] = 'དང་ལེན་སྤངས་པ།།';
$string['resource'] = 'ཐོན་ཁུངས།';
$string['resourcekey'] = 'ལག་སྤྱོད་འབད་མི་གི་ལྡེ།';
$string['resourcekey_admin'] = 'ལག་སྤྱོད་འབད་མི་གི་ལྡེ།';
$string['resourcekey_admin_help'] = 'The consumer key can be thought of as a username used to authenticate access to the tool.
It can be used by the tool provider to uniquely identify the Moodle site from which users launch into the tool.

The consumer key must be provided by the tool provider. The method of obtaining a consumer key varies between
tool providers. It may be an automated process, or it may require a dialogue with the tool provider.

ལག་ཆསs which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a resource key.';
$string['resourcekey_help'] = 'For pre-configured tools, it is not necessary to enter a resource key here, as the consumer key will be
provided as part of the རིམ་སྒྲིག process.

This field should be entered if creating a link to a tool provider which is not already configured.
If the tool provider is to be used more than once in this course, adding a course tool རིམ་སྒྲིག is a good idea.

The consumer key can be thought of as a username used to authenticate access to the tool.
It can be used by the tool provider to uniquely identify the Moodle site from which users launch into the tool.

The consumer key must be provided by the tool provider. The method of obtaining a consumer key varies between
tool providers. It may be an automated process, or it may require a dialogue with the tool provider.

ལག་ཆསs which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a resource key.';
$string['resourceurl'] = 'ཐོན་ཁུངས། URL';
$string['return_to_course'] = 'སླར་ལོག་འགྱོ་ནི་དོན་ལས་<a href="{$a->link}" target="_top">ནཱ་ལུ</a> ཨེབ་གཏང་།';
$string['saveallfeedback'] = 'ངེའི་བསམ་ལན་ཆ་མཉམ་སྲུངས།';
$string['secure_icon_url'] = 'Icon URL མཐའ་བཙན་བཟོ།';
$string['secure_icon_url_help'] = 'Similar to the icon URL, but used if the user accessing Moodle securely through SSL. The main purpose for this field is to prevent
the browser from warning the user if the underlying page was accessed over SSL, but requesting to show an unsecure image.';
$string['secure_launch_url'] = 'གསར་བཙུགས་འབད URL མཐའ་བཙན་བཟོ།';
$string['secure_launch_url_help'] = 'Similar to གསར་བཙུགས་འབད URL, but used instead of the launch url if high security is required. Moodle will use the
secure launch URL instead of the launch URL if the Moodle site is accessed through SSL, or if the tool རིམ་སྒྲིག
is set to always launch through SSL.

The གསར་བཙུགས་འབད URL may also be set to an https address to force launching through SSL, and this field may be left blank.';
$string['send'] = 'གཏང་།';
$string['setupoptions'] = 'གཞི་སྒྲིག་གདམ་ཁ་ཚུ';
$string['share_email'] = 'གསར་བཙུགས་འབད་མི་གློག་འཕྲིན་གཅིག་ཁར་ལག་ཆས་རུབ་སྤྱོད།';
$string['share_email_admin'] = 'གསར་བཙུགས་འབད་མི་གློག་འཕྲིན་གཅིག་ཁར་ལག་ཆས་རུབ་སྤྱོད།';
$string['share_email_admin_help'] = 'Specify whether the e-mail address of the user launching the tool will be shared with the tool provider.
The tool provider may need launcher\'s e-mail addresses to distinguish users with the same name in the UI, or send e-mails
to users based on actions within the tool.';
$string['share_email_help'] = 'Specify whether the e-mail address of the user launching the tool will be shared with the tool provider.
The tool provider may need launcher\'s e-mail addresses to distinguish users with the same name, or send e-mails
to users based on actions within the tool.

Note that this setting may be overriden in the tool རིམ་སྒྲིག.';
$string['share_name'] = 'གསར་བཙུགས་འབད་མི་མིང་གཅིག་ཁར་ལག་ཆས་རུབ་སྤྱོད།';
$string['share_name_admin'] = 'གསར་བཙུགས་འབད་མི་མིང་གཅིག་ཁར་ལག་ཆས་རུབ་སྤྱོད།';
$string['share_name_admin_help'] = 'Specify whether the full name of the user launching the tool should be shared with the tool provider.
The tool provider may need launchers\' names to show meaningful information within the tool.';
$string['share_name_help'] = 'Specify whether the full name of the user launching the tool should be shared with the tool provider.
The tool provider may need launchers\' names to show meaningful information within the tool.

Note that this setting may be overriden in the tool རིམ་སྒྲིག.';
$string['share_roster'] = 'ལག་ཆས་ཀྱི་སློབ་ཚན་གི་ལས་རིམ་མེའུ་མིག་འཛུལ་སྤྱོད་འབད་བཅུག།';
$string['share_roster_admin'] = 'ལག་ཆས་ཀྱི་སློབ་ཚན་གི་ལས་རིམ་མེའུ་མིག་འཛུལ་སྤྱོད་འབད་ནི་བཟུམ་ཡོད།';
$string['share_roster_admin_help'] = 'Specify whether the tool can access the list of users enrolled in courses from which this tool དབྱེ་བ། is launched.';
$string['share_roster_help'] = 'Specify whether the tool can access the list of users enrolled in this course.

Note that this setting may be overriden in the tool རིམ་སྒྲིག.';
$string['show_in_course'] = 'tool instances་གསར་བསྐྲུན་འབད་ད་ལག་ཆས་དབྱེ་བ་སྟོན།';
$string['show_in_course_help'] = 'If selected, this tool རིམ་སྒྲིག will appear in the "ཕྱིའི། tool དབྱེ་བ།" dropdown when teachers
configure ཕྱིའི tools within courses.

In most cases, this option does not need to be selected. Teachers can use this tool རིམ་སྒྲིག
based on the གསར་བཙུགས་འབད URL matching the ལག་ཆས base URL, which is the དགའ་གདམ་ཅན method.

The only case in which this option should be selected is if the tool རིམ་སྒྲིག is just intended for single sign on.
For example, if all launches to the tool provider just take the user to a landing page instead of to a specific resource.';
$string['size'] = 'ཚད་ ཚད་བཟུང་ཚུ།';
$string['submission'] = 'ཞུ་འབུལ།';
$string['submissions'] = 'སྤྲོད་ནི།';
$string['submissionsfor'] = '{$a} གི་སྤྲོད་མི་ཚུ།';
$string['toggle_debug_data'] = 'རྐྱེན་སེལ་གནས་་སྡུད་ སོར་སྟོན་འབད།';
$string['tool_config_not_found'] = 'འདི་URLགི་ལག་ཆས་རིམ་སྒྲིག་མ་མཐོང་།';
$string['tool_settings'] = 'ལག་ཆས་གཞི་སྒྲིག་ཚུ།';
$string['toolsetup'] = 'ཕྱིའི་ལག་ཆས་རིམ་སྒྲིག';
$string['toolurl'] = 'ལག་ཆས གཞི་རྟེན། URL';
$string['toolurl_help'] = 'The tool base URL is used to match tool launch URLs to the correct tool རིམ་སྒྲིག. Prefxing the URL with http(s) is optional.

ཁ་སྐོང་རྐྱབས།itionally, the base URL is used as the launch URL if a launch URL is not specified in the ཕྱིའི tool instance.

<table>
    <thead>
        <tr>
            <td>
                <b>གཞི་རྟེན། URL</b>
            </td>
            <td>
                <b>Matches</b>
            </td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>
                tool.com
            </td>
            <td>
                tool.com, tool.com/quizzes, tool.com/quizzes/quiz.php?id=10, www.tool.com/quizzes
            </td>
        </tr>
        <tr>
            <td>
                www.tool.com/quizzes
            </td>
            <td>
                tool.com/quizzes, tool.com/quizzes/take.php?id=10, www.tool.com/quizzes
            </td>
        </tr>
        <tr>
            <td>
                quiz.tool.com
            </td>
            <td>
                quiz.tool.com, quiz.tool.com/take.php?id=10
            </td>
        </tr>
    </tbody>
</table>

If two different tool རིམ་སྒྲིགs are for the same domain, the most specific match will be used.';
$string['typename'] = 'ལག་ཆས་མིང་';
$string['typename_help'] = 'The tool name is used to identify the tool provider within Moodle. The name entered will be visible
to teachers when adding ཕྱིའི tools within courses.';
$string['types'] = 'དབྱེ་བ་ཚུ';
$string['update'] = 'དུས་མཐུན་བཟོ།';
$string['using_tool_configuration'] = 'ལག་ཆས་རིམ་སྒྲིག་ལག་ལེད་འཐབ་དོ';
$string['validurl'] = 'ནུས་ཅན URL http(s)://  འགོ་བཙུགས་དགོ།';
$string['viewsubmissions'] = 'ཞུ་འབུལ་དང་གནས་ཚདའི་གསལ་གཞི།';
