<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'གསལ་བཀོད་འབད་ཡོད་པའི་ བདག་སྐྱོང་སྣོད་ཐོ་འདི་ བདེན་མེད་ཨིན་མས།';
$string['admindirname'] = 'བདག་སྐྱོང་ སྣོད་ཐོ་';
$string['admindirsetting'] = 'Web Host ལག་ལེན་ཉུང་བ་ ཡང་ན་ ཁྱོད་ཀྱི་ ཚད་འཛིན་པེ་ནཱལ་ ལ་སོགས་པ་ཚུ་ནང་འཛུལ་སྤྱོད་ འབད་ནིའི་དོན་ལུ་ དམིགས་བསལ་ URL དེ་འབདཝ་ད་ལུ་ འདི་ Moodle བདག་སྐྱོང་ཤོག་ལེབ་ཚུ་གི་དོན་ལུ་ ཚད་ལྡན་གནས་ཚད་དང་གཅིག་ཁར་ མི་མཐུན་པས། འ་ནི་དཀའ་ངལ་འདི་ ཁྱོད་ཀྱི་གཞི་བཙུགས་ནང་ བདག་སྐྱོང་སྣོད་ཐོ་བསྐྱར་མིང་བཏགས་ཞིནམ་ལས་ མིང་གསརཔ་དེ་ ནཱ་ལུ་བཙུག་ཐོག་ལས་ སེལ་ཚུགས།དཔེར་ན་ <br /> <br /><b>moodleadmin</b><br /> <br /> །འདི་གིས་ Moodle་ནང་ བདག་སྐྱོང་ འབྲེལ་མཐུད་ཚུ་ གཏན་བཟོས་འབད་ཚུགས།';
$string['admindirsettinghead'] = 'བདག་སྐྱོང་ སྣོད་ཐོ་ གཞི་སྒྲིག་འབད་དོ།';
$string['admindirsettingsub'] = 'Web host ཉུང་སུ་གཅིག་གི་རྐྱངམ་ཅིག་གིས་ ཁྱོད་ཀྱི་ ཚད་འཛིན་པེ་ནཱལ་ ལ་སོགས་པ་ཚུ་ནང་འཛུལ་སྤྱོད་ འབད་ནིའི་དོན་ལུ་ /admin འདི་ དམིགས་བསལ་ URL སྦེ་ ལག་ལེན་འཐབ་ཨིན་མས། དེ་འབདཝ་ད་ལུ་ འདི་ Moodle བདག་སྐྱོང་ཤོག་ལེབ་ཚུ་གི་དོན་ལུ་ ཚད་ལྡན་གནས་ཚད་དང་གཅིག་ཁར་ མི་མཐུན་པས། འ་ནི་དཀའ་ངལ་འདི་ ཁྱོད་ཀྱི་གཞི་བཙུགས་ནང་ བདག་སྐྱོང་སྣོད་ཐོ་བསྐྱར་མིང་བཏགས་ཞིནམ་ལས་ མིང་གསརཔ་དེ་ ནཱ་ལུ་བཙུག་ཐོག་ལས་ སེལ་ཚུགས།དཔེར་ན་ <br /> <br /><b>moodleadmin</b><br /> <br /> །འདི་གིས་ Moodle་ནང་ བདག་སྐྱོང་ འབྲེལ་མཐུད་ཚུ་ གཏན་བཟོས་འབད་ཚུགས།';
$string['availablelangs'] = 'ཐོབ་ཡོད་པའི་སྐད་ཡིག་ཚུ་གྱི་ཐོ་བཀོད།';
$string['caution'] = 'དྲན་བཏོན།';
$string['chooselanguage'] = 'སྐད་ཡིག་ སེལ་འཐུ་འབད།';
$string['chooselanguagehead'] = 'སྐད་ཡིག་ སེལ་འཐུ་འབད།';
$string['chooselanguagesub'] = 'གཞི་བཙུགས་ཀྱི་དོན་ལུ་རྐྱངམ་ཅིག་ སྐད་ཡིག་གཅིག་སེལ་འཐུ་འབད། ཁྱོད་ཀྱིས་ ས་ཁོངས་དང་ ལག་ལེན་པའི་སྐད་ཡིག་ཚུ་ ཤུལ་མམ་གྱི་ གསལ་གཞི་ནང་ སེལ་འཐུ་འབད་ཚུགས།';
$string['cliadminpassword'] = 'བདག་སྐྱོང་གསརཔ་གྱི་ལག་ལེན་པ་དང་ཆོག་ཡིག།';
$string['cliadminusername'] = 'བདག་སྐྱོང་གྱི་རྩིས་ཐོ་ལག་ལེན་པ་མིང་།';
$string['clialreadyconfigured'] = 'ཡིག་སྣོད་config.php་འདི་ཧེ་མ་ལས་འདུག།ཁྱོད་ཨ་ནཱི་ས་ཁོངས་གཞི་བཙུགས་འབད་བ་ཅིན་admin/cli/install_database.php་དེ་ལག་ལོན་འཐབ་གནང།';
$string['clialreadyinstalled'] = 'ཡིག་སྣོད་config.php་འདི་ཧེ་མ་ལས་འདུག།ཁྱོད་ཨ་ནཱི་ས་ཁོངས་ཡར་བསྐྱེད་འབད་བ་ཅིན་admin/cli/upgrade.php་དེ་ལག་ལོན་འཐབ་གནང།';
$string['cliinstallfinished'] = 'Installation completed successfully.';
$string['cliinstallheader'] = 'བཀོད་རྒྱ་མཚམས་ཐིག་སྒྲིག་འཇུག་གི་བྱ་རིམ།';
$string['climustagreelicense'] = 'ཕན་ཚུན་བར་འབྲེལ་མེད་པའི་གནས་སྟངས་ལུ་ ཆོག་ཐམ་གྱི་ཆོག་ཐམ་ལུ་ངེས་ལེན་ཡིག་ཆ་ལུ་ངེས་ལེན་འབད་དགོ';
$string['clitablesexist'] = 'གཞི་གྲངས་མཛོད་ཀྱི་ཐིག་སྒྲོམ་དེ་ཧེ་མ་ལས་ཡོདཔ་ལས་ སྒྲིག་འཇུག་དེ་འཕྲོ་མཐུད་འབད་མི་བཏུབ་པས།';
$string['compatibilitysettings'] = 'ཁྱོད་རའི་PHPགཞི་སྒྲིགཚུ་ ཞིབ་དཔྱད་འབད་དོ།';
$string['compatibilitysettingshead'] = 'ཁྱོད་རའི་PHPགཞི་སྒྲིགཚུ་ ཞིབ་དཔྱད་འབད་དོ།';
$string['compatibilitysettingssub'] = 'Moodle ཚུལ་བཞིན་སྦེ་ལག་ལེན་འཐབ་བཏུབ་བཟོ་ནིའི་དོན་ལུ་ ཁྱོད་ཀྱི་སར་བར་ འདི་ཚུ་ག་ར་ མཐའ་འཁྱོལ་དགོ།';
$string['configfilenotwritten'] = 'Moodleསྣོད་ཐོ་དེ་ འབྲི་བཏུབ་མི་གཅིག་མེན་ནི་འདི་གིས་ གཞི་བཙུགས་པ་འདི་གིས་ ཁྱོད་ཀྱིས་གདམ་ཁ་ བརྐྱབས་ཡོད་པའི་སྒྲིག་སྟངས་ཚུ་ཡོད་པའི་ རིམ་སྒྲིག་ པི་ཨེཆ་པི་གཅིག་ རང་བཞིན་གྱིས་ གཞི་སྒྲིག་འབད་མ་ཚུགས། Moodle་གྱི་ སྣོད་ཐོ་རྩ་བའི་ནང་འཁོད་ནང་ལུ་ config.php ཟེར་མིང་བཏགས་ཡོད་མི་ ཡིག་སྣོད་གཅིག་ནང་ལུ་ ཁྱོད་ཀྱིས་ འོག་གི་ཨང་རྟགས་ཚུ་ འདྲ་བཤུས་བརྐྱབ་ཚུགས།';
$string['configfilewritten'] = 'རིམ་སྒྲིག་ པི་ཨེཆ་པི་ མཐའ་འཁྱོལ་ཅན་སྦེ་ གསར་བསྐྲུན་འབད་ཡོདཔ།';
$string['configurationcomplete'] = 'རིམ་སྒྲིག་ མཇུག་བསྡུ་ཡོདཔ།';
$string['configurationcompletehead'] = 'རིམ་སྒྲིག་ མཇུག་བསྡུ་ཡོདཔ།';
$string['configurationcompletesub'] = 'Moodle གྱིས་ཁྱོད་ཀྱི་རིམ་སྒྲིག་འདི་ ཁྱོད་རའི་ མུ་ཌེལ་གཞི་བཙུགས་རྩ་བའི་ནང་གི་ཡིག་སྣོད་གཅིག་ནང་ སྲུངས་ནིའི་དཔའ་བཅམས་ཡི།';
$string['database'] = 'གནས་སྡུད་གཞི་རྟེན།';
$string['databasehead'] = 'གནས་སྡུད་གཞི་རྟེན་གཞི་སྒྲིག་ཚུ།';
$string['databasehost'] = 'གནས་སྡུད་གཞི་རྟེན་host';
$string['databasename'] = 'གནས་སྡུད་གཞི་རྟེན་ མིང་།';
$string['databasepass'] = 'གནས་སྡུད་གཞི་རྟེན་ཆོག་ཡིག།';
$string['databaseport'] = 'གནས་སྡུད་གཞི་རྟེན་གྱི་མཐུད་སྣེ།';
$string['databasesocket'] = 'Unix སྒྲོག་མཐུད།';
$string['databasetypehead'] = 'གནས་སྡུད་གཞི་རྟེན་ཀྱི་སྒུལ་འདེབྱ་རིམ།';
$string['databasetypesub'] = 'Moodle གྱི་གནས་སྡུད་གཞི་རྟེན་དབྱེ་བ་དག་པ་ཅིག་རྒྱབ་སྐྱོར་འདུག། ཧ་མ་གོ་བ་ཅིན་serverགཅིག་ཁར་བདག་སྐྱོང་པ་འབྲེལ་བ་འཐབ་གནང་།';
$string['databaseuser'] = 'གནས་སྡུད་གཞི་རྟེན་ ལད་ལོན་པ།';
$string['dataroot'] = 'གནས་སྡུད་ སྣོད་ཐོ་';
$string['datarooterror'] = 'ཁྱོད་ཀྱི་གསལ་བཀོད་འབད་ཡོད་མི་ \'གནས་སྡུད་ སྣོད་ཐོ་\'དེ་ ཐོབ་མ་ཚུགས་ ཡང་ན་ གསར་བསྐྲུན་འབད་མ་ཚུགས། འགྲུལལམ་ནོར་བཅོས་འབད་ ཡང་ན་ སྣོད་ཐོ་ ལག་ཐོག་ལས་ གསར་བསྐྲུན་འབད།';
$string['datarootpermission'] = 'གཞི་གྲངས་མ་གཞི་་གནང་བ།';
$string['datarootpublicerror'] = 'ཁྱོད་ཀྱི་གསལ་བཀོད་འབད་ཡོད་མི་ \'གནས་སྡུད་ སྣོད་ཐོ་\'དེ་ web་བརྒྱུད་དེ་ ཐད་ཀར་དུ་ འཛུལ་སྤྱོད་འབད་བཏུབ་པས། སྣོད་ཐོ་སོ་སོ་ ལག་ལེན་འཐབ་དགོ་པས།';
$string['dbconnectionerror'] = 'ཁྱོད་ཀྱི་གསལ་བཀོད་འབད་ཡོད་མི་ གནས་སྡུད་གཞི་རྟེན་ལུ་ འབྲེལ་མཐུད་འབད་མི་ཚུགས་པས། ཁྱོད་རའི་ གནས་སྡུད་གཞི་རྟེན་སྒྲིག་སྟངས་ཚུ་ ཞིབ་དཔྱད་འབད་གནང་།';
$string['dbcreationerror'] = 'གནས་སྡུད་གཞི་རྟེན་ གསར་བསྐྲུན་འབད་ནི་ལུ་ འཛོལ་བ། བྱིན་ཏེ་ཡོད་མི་ སྒྲིག་སྟངས་ཚུ་གིས་ གནས་སྡུད་གཞི་རྟེན་གྱི་མིང་གསར་བསྐྲུན་འབད་མ་ཚུགས།';
$string['dbhost'] = 'ཞབས་ཞུ་འཚོ་བརྟེན་ས་ངོ་མ།';
$string['dbpass'] = 'ཆོག་ཡིག།';
$string['dbport'] = 'མཐུད་སྣེ།';
$string['dbprefix'] = 'ཐིག་སྒྲོམ་སྔོན་འཇུག';
$string['dbtype'] = 'དབྱེ་བ།';
$string['directorysettings'] = '<p>Moodleགཞི་བཙུགས་འདི་གི་ གནས་ཁོངས་ཚུ་ ངེས་དཔྱད་འབད་གནང་།</p> <p><b>web ཁ་བྱང་ཚུ་:</b> Moodleའདི་ག་ཏེ་ལུ་ འཛུལ་སྤྱོད་འབད་ནི་ཨིན་ན webཁ་བྱང་ ཆ་ཚང་གསལ་བཀོད་འབད་གནང་། ཁྱོད་ཀྱི་ web་ས་ཁོངས་འདི་ སྣ་མང་ URLབརྒྱུད་དེ་ འཛུལ་སྤྱོད་འབད་བཏུབ་པ་ཅིན་ ཁྱོད་རའི་སློབ་ཕྲུགཚུ་གིས་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ བཅོས་མིན་དེ་རང་བཞག་གནང་། རྒྱབ་ལུས་ གཡོ་ཤད་ བཙུགས་མ་གནང་།</p> <p><b>Moodle སྣོད་ཐོ:</b> གཞི་བཙུགས་འདི་ལུ་ སྣོད་ཐོའི་འགྲུལ་ལམ་ ཆ་ཚང་ གསལ་བཀོད་འབད་གནང་། ཚུགས་ཡིག་/མགྱོགས་ཡིག་ཚུ་ ངེས་བེདན་སྦེ་ བཙུགས་གནང་།</p> <p><b>གནས་སྡུད་ སྣོད་ཐོ་:</b> Moodle་གྱིས་ སྐྱེལ་བཙུགས་་འབད་ཡོད་མི་ ཡིག་སྣོད་ཚུ་སྲུང་བཞག་འབད་ནིའི་དོན་ལུ་ ས་སྒོ་གཅིག་དགོ་པས། འ་ནི་ སྣོད་ཐོ་འདི་ webསར་བར་ ལག་ལེན་པ་ (usually \'nobody\' or \'apache\')གིས་ ལྷག་བཏུབ་དང་འབྲི་ཚུགསཔ་སྦེ་འོང་དགོ། དེ་འབདཝ་ད་ལུ་ ཕྲང་ཕྲང་རང་ webབརྒྱུད་དེ་ འཛུལ་སྤྱོད་འབད་མ་བཏུབ་སྦེ་དགོ།</p>';
$string['directorysettingshead'] = 'Moodle གཞི་བཙུགས་འདི་གི་ གནས་ཁོངས་ཚུ་ ངེས་དཔྱད་འབད་གནང་།';
$string['directorysettingssub'] = '<p><b>web་ ཁ་བྱང་ཚུ་:</b> Moodle་འདི་ག་ཏེ་ལུ་ འཛུལ་སྤྱོད་འབད་ནི་ཨིན་ན web་ཁ་བྱང་ ཆ་ཚང་གསལ་བཀོད་འབད་གནང་། ཁྱོད་ཀྱི་ web་ས་ཁོངས་འདི་ སྣ་མང་ ཡུ་ཨར་ཨེལ་བརྒྱུད་དེ་ འཛུལ་སྤྱོད་འབད་བཏུབ་པ་ཅིན་ ཁྱོད་རའི་སློབ་ཕྲུགཚུ་གིས་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ བཅོས་མིན་དེ་རང་བཞག་གནང་། རྒྱབ་ལུས་ གཡོ་ཤད་ བཙུགས་མ་གནང་། <br /> <br /> <b>Moodle་ སྣོད་ཐོ:</b> གཞི་བཙུགས་འདི་ལུ་ སྣོད་ཐོའི་འགྲུལ་ལམ་ ཆ་ཚང་ གསལ་བཀོད་འབད་གནང་། ཚུགས་ཡིག་/མགྱོགས་ཡིག་ཚུ་ ངེས་བེདན་སྦེ་ བཙུགས་གནང་།</p> <br /> <br /> <p><b>གནས་སྡུད་ སྣོད་ཐོ་:</b> Moodle་གྱིས་ སྐྱེལ་བཙུགས་་འབད་ཡོད་མི་ ཡིག་སྣོད་ཚུ་སྲུང་བཞག་འབད་ནིའི་དོན་ལུ་ ས་སྒོ་གཅིག་དགོ་པས། འ་ནི་ སྣོད་ཐོ་འདི་ web་སར་བར་ ལག་ལེན་པ་ (usually \'nobody\' or \'apache\')གིས་ ལྷག་བཏུབ་དང་འབྲི་ཚུགསཔ་སྦེ་འོང་དགོ། དེ་འབདཝ་ད་ལུ་ ཕྲང་ཕྲང་རང་ web་བརྒྱུད་དེ་ འཛུལ་སྤྱོད་འབད་མ་བཏུབ་སྦེ་དགོ།';
$string['dirroot'] = 'Moodle སྣོད་ཐོ།';
$string['dirrooterror'] = '\'Moodleསྣོད་ཐོ་\' སྒྲིག་སྟངས་འདི་ མེནམ་ཨིནམ་བཟུམ་ཅིག་འདུག། ང་བཅས་ཀྱིས་འདི་ནང་ལུ་ མུ་ཌལ་གཞི་བཙུགས་གཅིག་མཐོངམ་མས། འོག་ལུ་ཡོད་མི་ བེ་ལུ་དེ་ སླར་སྒྲིག་འབད་ནུག།';
$string['download'] = 'ཕབ་ལེན།';
$string['downloadlanguagebutton'] = '&quot;{$a}&quot; language pack ཕབ་ལེན་འབད།';
$string['downloadlanguagehead'] = 'language pack ཕབ་ལེན་འབད།';
$string['downloadlanguagenotneeded'] = 'སྔོན་སྒྲིག་ སྐད་ཡིག་གི་སྦུང་ཚན་ "$a" ལག་ལེན་འཐབ་སྟེ་ གཞི་བཙུགས་དེ་ འཕྲོ་མཐུད་དེ་འབད།';
$string['downloadlanguagesub'] = 'ད་ཁྱོད་ལུ་ འ་ནི་སྐད་ཡིག་ནང་ལུ་ language pack ཕབ་ལེན་འབད་ནི་དང་ གཞི་བཙུགས་འཕྲོ་མཐུད་འབད་ནིའི་གདམ་ཁ་ཡོད། <br /><br /> ག་དེམ་ཅིག་སྦེ་ language pack ཕབ་ལེན་འབད་མ་ཚུགས་པ་ཅིན་ ལས་སྦྱོར་འདི་ ཨིན་སྐད་ནང་ འཕྲོ་མཐུད་འབད་འོང་།(གཞི་བཙུགས་ལས་སྦྱོར་དེ་ མཇུག་བསྡུ་ཞིནམ་ལས་ ཁྱོད་ལུ་ language packs ཁ་སྐོང་ཚུ་ ཕབ་ལེན་འབད་ནི་དང་གཞི་བཙུགས་འབད་ནིའི་གོ་སྐབས་ཡོད།)';
$string['doyouagree'] = 'བློ་མཐུན་ཡོད་ག';
$string['environmenthead'] = 'ཁྱོད་རའི་ མཐའ་འཁོར་ཞིབ་དཔྱད་འབད་དོ་་་';
$string['environmentsub'] = 'ང་བཅས་ཀྱིས་ ཁྱོད་ཀྱི་ རིམ་ལུགས་ཀྱི་ཆ་ཤས་འདྲ་མིན་སྣ་ཚོགས་ཚུ་གིས་ རིམ་ལུགས་ཀྱི་དངོསམཁོ་ཚུ་དང་ མཐུན་མི་མཐུན་ ཞིབ་དཔྱད་འབད་དོ།';
$string['environmentsub2'] = 'Moodleའཛིན་གྲོལ་རེ་རེ་གྱི་PHP་འཛིན་གྲོལ་དག་པ་ཅིག་དང་PHP extensionsངེས་མཁོ་དགོཔ་ཨིན།གཞི་བཙུགས་དང་ཡར་བསྐྱེད་་མ་བཟོ་བའི་ཧེ་མFull environmentཞིབ་དཔྱད་འབད་འོང་།';
$string['errorsinenvironment'] = 'མཐའ་འཁོར་དབྱེ་དཔྱད་མཐར་མ་ཕྱིན།';
$string['fail'] = 'འཐུས་ཤོར།';
$string['fileuploads'] = 'ཡིག་སྣོད་ སྐྱེལ་བཙུགས།';
$string['fileuploadserror'] = 'ཨ་ནི་འདི་ ་བཟོ་བཏུབ་སྦེ་འོང་དགོ།';
$string['fileuploadshelp'] = '<p>ཁྱོད་ཀྱི་སར་བར་གུ་ ཡིག་སྣོད་སྐྱེལ་བཙུགས་འབད་ནི་འདི་ ལྕོགས་མིན་བཟོ་དེ་ཡོདཔ་བཟུམ་ཅིག་འདུག།</p> <p>Moodle་འདི་ད་ལྟོ་ཡང་ གཞི་བཙུགས་འབད་ཚུགས་ དེ་འབདཝ་ད་ ལྕོགས་གྲུབ་འདི་མེད་པ་ཅིན་ སློབཚན་ཡིག་སྣོད་ ཡང་ན་ ལག་ལེན་པའི་གསལ་སྡུད་གསརཔ་ཚུ་ སྐྱེལ་བཙུགས་འབད་མི་ཚུགས།</p> <p>ཡིག་སྣོད་ སྐྱེལ་བཙུགས་ ལྕོགས་ཅན་བཟོ་ནིའི་དོན་ལུ་ ཁྱོད་(ཡན་ན་ ཁྱོད་རའི་རིམ་ལུགས་བདག་སྐྱོང་)གིས་ ཁྱོད་རའི་རིམ་ལུགས་གུ་ php.ini གི་ ཡིག་སྣོད་ངོ་མ་དེ་ ཞུན་དག་འབད་ཞིནམ་ལས་ <b>file_uploads</b> to \'1\'.</p> གི་དོན་ལུ་ སྒྲིག་སྟངས་ཚུ་ བསྒྱུར་བཅོས་འབད་དགོ།';
$string['inputdatadirectory'] = 'གནས་་སྡུད་ སྣོད་ཐོ:';
$string['inputwebadress'] = 'Web ཁ་བྱང:';
$string['inputwebdirectory'] = 'Moodle སྣོད་ཐོ:';
$string['installation'] = 'གཞི་བཙུགས།';
$string['langdownloaderror'] = 'སྐད་ཡིག་ "{$a}"འདི་ གཞི་བཙུགས་འབད་དེ་མིན་ནུག། གཞི་བཙུགས་འདི་ ཨིན་སྐད་ནང་ འཕྲོ་མཐུད་དེ་འབད་ནི་ཨིན།';
$string['langdownloadok'] = 'སྐད་ཡིག་ "{$a}"འདི་ མཐའ་འཁྱོལ་ཅན་སྦེ་ གཞི་བཙུགས་འབད་ཡི། གཞི་བཙུགས་འདི་ སྐད་ཡིག་འདི་ནང་རང་ འཕྲོ་མཐུད་དེ་འབད་ནི་ཨིན།';
$string['magicquotesruntime'] = 'སྒྱུ་མའི་དཔེ་བཀོད་ཀྱི་དུས་ཡུན་ཚང་བ།';
$string['magicquotesruntimeerror'] = 'ཨ་ནི་འདི་ ་བཟོ་མ་བཏུབ་སྦེ་འོང་དགོ།';
$string['magicquotesruntimehelp'] = '<p>མུ་ཌལ་ ལཱ་ ཚུལ་མཐུནམ་སྦེ་འབད་ནིའི་དོན་ལུ་ Magic quotes དེ་ ་བཟོ་མ་བཏུབ་སྦེ་ བཞག་དགོ།</p> <p> སྤྱིར་བཏང་ལུ་ སྔོན་སྒྲིག་གིས་ ཨོཕ་འོང་་་་་་་་་་་་་ <b>magic_quotes_runtime</b> in your php.ini file.</p> གཟིགས་གནང་། <p><p> ཁྱོད་རའི་ php.ini ནང་འཛུལ་སྤྱོད་འབད་མ་ཚུགས་པ་ཅིན་ ཁྱོད་རའི་མུ་ཌལ་སྣོད་ཐོ་གི་ནང་འཁོད་ནང་ལུ་ .htaccess ཟེར་མི་ཡིག་སྣོད་ནང་ལུ་ འོག་གི་ གྲལ་ཐིག་འདི་བཙུག་ཚུགསཔ་འོང་།:</p> <blockquote><div>php_value magic_quotes_runtime Off</div></blockquote>';
$string['memorylimit'] = 'དྲན་ཚད་';
$string['memorylimiterror'] = 'PHP དྲན་ཚད་འདི་ ཉུང་སུ་སྦེ་ གཞི་སྒྲིག་འབད་དེ་འདུག་་་་ ཤུལ་ལས་ཁྱོད་ལུ་དཀའ་ངལ་འབྱུང་འོང་།';
$string['memorylimithelp'] = '<p>ད་ལྟོ་ཁྱོད་ཀྱི་སར་བར་གྱི་དོན་ལུ་ PHP དྲན་ཚད་དེ་ $a ལུ་གཞི་སྒྲིག་འབད་དེ་འདུག།</p> <p> འདི་གིས་ཤུལ་ལས་ མུ་ཌལ་ལུ་ དྲན་ཚད་ཀྱི་དཀའ་ངལ་ཚུ་འབྱུང་བཅུག་འོང་ཝ། འདི་གི་ནང་ལས་ཡང་ ཁྱོད་ཀྱི་མུ་ཌལ་དང་ལག་ལེན་པ་ལོ་ཤ་ལྕོགས་ཅན་བཟོ་ཡོད་པ་ཅིན་ དཀའ་ངལ་འབྱུང་འོང་།</p> <p> ཁྱོད་ཀྱིས་ 40M བཟུམ་གྱི་ PHP དྲན་ཚད་ མང་སུ་ཡོད་མི་ རིམ་སྒྲིག་འབད་བ་ཅིན་ ལེགས་ཤོམ་འོང་། འདི་འབད་ནི་གི་དོན་ལུ་ ཐབས་ཤེས་ ལེ་ཤ་ཡོད་:</p> <ol> <li> ཁྱོད་ཀྱིས་ <i>--enable-memory-limit</i> དང་གཅིག་ཁར་ PHP ལོག་ཕྱོགས་སྒྲིག་འབད་ཚུགས་པ་ཅིན་ འདི་གི་ས་ མུ་ཌལ་གི་དྲན་ཚད་ཁོ་ར་གིས་སྦེ་ གཞི་སྒྲིག་འབད་ཚུགས།</li> <li>ཁྱོད་རའི་ php.ini ཡིག་སྣོད་ནང་འཛུལ་སྤྱོད་འབད་ཚུགས་པ་ཅིན་ ཁྱོད་ཀྱི་ <b>memory_limit</b>སྒྲིག་སྟངས་འདི་ 40M བཟུམ་གཅིག་ལུ་ བསྒྱུར་བཅོས་འབད་ཚུགས། ག་དེམ་ཅིག་སྦེ་འཛུལ་སྤྱོད་འབད་མ་ཚུགས་པ་ཅིན་ ཁྱོད་རའི་བདག་སྐྱོང་པ་ལུ་ འབད་བཅུག། <li> PHP སར་བར་ ལ་ལོ་གཅིག་ནང་ འོག་གི་གྲལ་ཐིག་ཚུ་ཡོད་མི་ མུ་ཌལ་སྣོད་ཐོ་ནང་ཁྱོད་ཀྱིས་ .htaccess ཡིག་སྣོད་གསར་བསྐྲུན་འབད་ཚུགས། <blockquote><div>php_value memory_limit 40M</div></blockquote> <p> དེ་འབདཝ་ད་ལུ་ སར་བར་ལ་ལོ་གཅིག་ནང་ འདི་གིས་ <b>all</b> PHP ཤོག་ལེབ་ཚུ་ གཡོག་བཀོལ་ནི་ལུ་སྔོན་བཀག་འབདཝ་ཨིན། (ཤོག་ལེབ་ཚུ་ནང་བལྟ་བའི་སྐབས་ འཛོལ་བ་ཚུ་མཐོང་འོང་) དེ་འབདཝ་ལས་ .htaccess ཡིག་སྣོད་་རྩ་བསྐྲད་གཏང་དགོ།</p></li> </ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP འདི་ SQL*Server དང་གཅིག་ཁར་ འབྲེལ་བ་འཐབ་ཚུགས་ནིའི་དོན་ལུ་ MSSQL རྒྱ་བསྐྱེད་དང་གཅིག་ཁར་ ཚུལ་མཐུན་སྦེ་ རིམ་སྒྲིག་མ་འབད་བས།php.ini ཡིག་སྣོད་ ཞིབ་དཔྱད་འབད་གནང་ ཡང་ན་ PHP ལོག་ཕྱོགས་སྒྲིག་འབད་གནང་།';
$string['mysqliextensionisnotpresentinphp'] = 'PHP འདི་ SQL*Server དང་གཅིག་ཁར་ འབྲེལ་བ་འཐབ་ཚུགས་ནིའི་དོན་ལུ་ MSSQL རྒྱ་བསྐྱེད་དང་གཅིག་ཁར་ ཚུལ་མཐུན་སྦེ་ རིམ་སྒྲིག་མ་འབད་བས།ཁྱོད་རའི་php.ini ཡིག་སྣོད་ ཞིབ་དཔྱད་འབད་གནང་ ཡང་ན་ PHP ལོག་ཕྱོགས་སྒྲིག་འབད་གནང་། PHP 4 གི་དོན་ལུ་ MySQLi ཐོབ་མིཚུགས་པས།';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Moodleགནས་་སྡུད་བཞག་སར་འདི་ ད་ལྟོ་ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ འདི་རིམ་སྒྲིག་འབད་དགོ། འདི་་གནས་སྡུད་གཞི་རྟེན་ཧེ་མ་ལས་གསར་བསྐྲུན་འབད་དི་ ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་གི་འཛུལ་སྤྱོད་འབད་ཡོད།Table prefix is mandatory.';
$string['nativemysqli'] = 'MySQL (native/mysqli) ཡར་རྒྱས་འགྱོ་ཡོདཔ།';
$string['nativemysqlihelp'] = 'Moodleགནས་་སྡུད་བཞག་སར་འདི་ ད་ལྟོ་ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ འདི་རིམ་སྒྲིག་འབད་དགོ། གནས་སྡུད་གཞི་རྟེན་ལག་ལེན་པ་དགོ་པའི་གནང་བ་དང་ལག་ལེན་པ་མིང་དང་ཆོག་ཡིག་དེ་ཚུ་ཧེ་མ་ལས་ཡོད་པ་ཅིན་་གནས་སྡུད་གཞི་རྟེན་གཅིག་འབདན་གསར་བསྐྲུན་འབད་དི་་འོང་།Table prefix is optional.


འི་མིང་དང་ཆོག་ཡིག
འདི་་གནས་སྡུད་གཞི་རྟེན་ཧེ་མ་ལས་གསར་བསྐྲུན་འབད་དི་ ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་གི་འཛུལ་སྤྱོད་འབད་ཡོད།Table prefix is mandatory.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Moodleགནས་་སྡུད་བཞག་སར་འདི་ ད་ལྟོ་ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ འདི་རིམ་སྒྲིག་འབད་དགོ། འདི་་གནས་སྡུད་གཞི་རྟེན་ཧེ་མ་ལས་གསར་བསྐྲུན་འབད་དི་ ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་གི་འཛུལ་སྤྱོད་འབད་ཡོད།Table prefix is mandatory.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Moodleགནས་་སྡུད་བཞག་སར་འདི་ ད་ལྟོ་ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ འདི་རིམ་སྒྲིག་འབད་དགོ། འདི་་གནས་སྡུད་གཞི་རྟེན་ཧེ་མ་ལས་གསར་བསྐྲུན་འབད་དི་ ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་གི་འཛུལ་སྤྱོད་འབད་ཡོད།Table prefix is mandatory.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Moodleགནས་་སྡུད་བཞག་སར་འདི་ ད་ལྟོ་ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ འདི་རིམ་སྒྲིག་འབད་དགོ། འདི་་གནས་སྡུད་གཞི་རྟེན་ཧེ་མ་ལས་གསར་བསྐྲུན་འབད་དི་ ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་གི་འཛུལ་སྤྱོད་འབད་ཡོད།Table prefix is mandatory.';
$string['nativesqlsrvnodriver'] = 'Microsoft གི་སྒུལ་འདེད་བྱ་རིམ SQL གིཞབས་ཞུ་PHP དེ་གཞི་བཙུགས་མ་འབདཝ་ཡང་ན་ལེགས་ཤོམ་སྦེ་མ་བཅོས་བས།';
$string['nativesqlsrvnonwindows'] = 'Microsoft གི་སྒུལ་འདེད་བྱ་རིམ SQL གིཞབས་ཞུ་PHP དེ Windows OS.གི་དོན་ལས་རྐྱངམ་ཅིག་འདུག';
$string['ociextensionisnotpresentinphp'] = 'PHP འདི་ ཨོ་རེ་ཀཱལ་དང་གཅིག་ཁར་འབྲེལ་བ་འཐབ་ཚུགས་ནིའི་དོན་ལུ་ MSSQL རྒྱ་བསྐྱེད་དང་གཅིག་ཁར་ ཚུལ་མཐུན་སྦེ་ རིམ་སྒྲིག་མ་འབད་བས། ཁྱོད་རའི་ php.ini ཡིག་སྣོད་ ཞིབ་དཔྱད་འབད་གནང་ ཡང་ན་ PHP ལོག་ཕྱོགས་སྒྲིག་འབད་གནང་།';
$string['pass'] = 'མཐར་འཁྱོལ།';
$string['paths'] = 'ལམ།';
$string['pathserrcreatedataroot'] = '({$a->dataroot})གནས་་སྡུད་ སྣོད་ཐོ་དེ་གཞི་བཅུགས་འབད་མི་གིས་ བཟོ་མི་ཚུགས་པས།';
$string['pathshead'] = 'ལམ་གཏན་འཁེལ་བཟོ།';
$string['pathsrodataroot'] = 'གཞི་གྲངས་ངོ་མ་དེ་ བྲི་མི་བཏུབ་པས།';
$string['pathsroparentdataroot'] = 'གཞི་གྲངས་དཀར་ཆ་མ་ ({$a->parent})དེ་བྲི་མི་བཏུབ་པས། གཞི་གྲངས་དཀར་ཆ({$a->dataroot}) དེ་་གཞི་བཙུགས་འབད་མི་གིས་བཟོ་མི་བཏུབ་པས།';
$string['pathssubadmindir'] = 'webhostsདག་པ་ཅིག་ /admin ལག་ལེན་འཐབ་འབད་དམིགས་བསལ་ URL འདི་control panel or somethingའཛུལ་སྤྱོད་འབདཝ་ཨིན། ཁ་རྗེ་མེད་པར་ Moodleབདག་སྐྱོང་ཤོག་ལེབ་ཚུ་གྱི་ཚད་ལྡན་གནས་ཁོངས་གཅིག་ཁར་མི་མཐུན་ཨིན། ཁྱོད་ཀྱི་དཀའ་ངལ་དེ་ བདག་སྐྱོང་ཀྱི་སྣོད་ཐོ་ གཞི་བཙུགས་འབད་བའི་གང་བསྐྱར་མིང་བཏགས་སྦེ་སེལ་ཚུགས། དཔེར་ན: <em>moodleadmin</em>. འདི་གྱི་Moodle ནང་ན་བདག་སྐྱོང་འབྲེལ་ལམ་ཚུ་གྱི་དཀའ་ངལ་་སེལ་ཚུགས་ཨིན།';
$string['pathssubdataroot'] = 'སྐྱེལ་བཙུགས་ཚར་མི་ཡིག་སྣོད་ཚུ་Moodleགྱི་སྲུངས་བཞག་ནི་གྱི་དོན་ལུ་ས་གནས་དགོ།ཨ་ནི་སྣོད་ཐོ(ས་གནས་)དི་web serverལག་ལེན་པ་(usually \'nobody\' or \'apache\')གྱི་readable AND WRITEABLE དགོ  འདི་འབདཝ་ད་ web ལས་འཛུལ་སྤྱོད་ཐད་ཀར་འབད་ནི་མེད་འོང་།་The installer will try to create it if doesn\'t exist.';
$string['pathssubdirroot'] = 'Moodle installation ལུ་སྣོད་ཐོ་གི་འགྲུལ་ལམ་ག་ར་བྱིན་།';
$string['pathssubwwwroot'] = 'Moodleའཛུལ་སྤྱོད་འབད་ནི་དོན་ལུ་Web གྱི་ཁ་བྱང་ག་ར་བྱིན་དགོ། སྣ་མང་ཁ་བྱང་ཚུ་གྱི་Moodleའཛུལ་སྤྱོད་འབད་མི་ཚུགས། ག་དེམ་ཅིག་འབད་ཁྱོད་ཀྱི་སྣ་མང་མི་མང་གི་ཁ་བྱང་ཚུ་ཡོད་པ་ཅིན་ འདི་མ་གཏོགས་གཞན་ག་ར་གུ་རྟག་བརྟན་སླར་ལོག་གཏང་ནི་དོན་ལུ་གཞི་སྒྲིག་འབད་དགོ། Intranet and Internet་གཉིས་ལས་ཁྱོད་ཀྱི་ས་ཁོངས་དེ་འཛུལ་སྤྱོད་འབད་བ་ཅིན་ མི་མང་གི་ཁ་བྱང་ལག་ལེན་འཐབ་དི་འབདཝ་ལས་Intranetལག་ལེན་པ་ཚུ་གྱི་ཡང་མི་མང་གི་ཁ་བྱང་ལག་ལེན་འཐབ་ཚུགས།
ག་དེམ་ཅིག་འབད་ཁྱོད་ཀྱི་ཁ་བྱང་ངེས་བདེན་མེན་བ་ཅིན་ཁྱོད་ཀྱི་browserནང་ན་URL་དེ་བསྒྱུར་བཅོས་འབད་སྦེ་ ལོག་installation with a different value.འགོ་བཙུགས།';
$string['pathsunsecuredataroot'] = 'གཞི་གྲངས་ངོ་་མ་གི་གནས་དེ་ ཉེན་སྲུང་མིན་འདུག';
$string['pathswrongadmindir'] = 'བདག་སྐྱོང་དཀཅ་ཆ་དེ་མིན་འདུག';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP འདི་ PostgreSQL དང་གཅིག་ཁར་འབྲེལ་བ་འཐབ་ཚུགས་ནིའི་དོན་ལུ་ PGSQL རྒྱ་བསྐྱེད་དང་གཅིག་ཁར་ ཚུལ་མཐུན་སྦེ་ རིམ་སྒྲིག་མ་འབད་བས། ཁྱོད་རའི་ php.ini ཡིག་སྣོད་ ཞིབ་དཔྱད་འབད་གནང་ ཡང་ན་ PHP ལོག་ཕྱོགས་སྒྲིག་འབད་གནང་།';
$string['phpextension'] = '{$a} PHPརྒྱ་སྐྱེད།';
$string['phpversion'] = 'PHP ཐོན་རིམ།';
$string['phpversionhelp'] = '<p>Moodle་ལུ་ ཐོན་རིམ་འདི་ ཉུང་མཐའ་ལུ་ 4.3.0 ཡང་ན་ 5.1.0 དགོ། (5.0.x ལུ་ ཤེས་ཚུགས་པའི་དཀའ་ངལ་ ལེ་ཤ་འདུག་)</p> <p>ཁྱོད་ད་ལྟོ་ཐོན་རིམ་$a གཡོག་བཀོལ་དོ་</p> <p>PHP ཡར་བསྐྱེད་འབད་དགོ་ ཡང་ན་ PHP ཐོན་རིམ་གསརཔ་ཡོད་མི་ ཧོསིཊ་གཅིག་དང་གཅིག་ཁར་ སྤོ་བཤུད་འབད།!<br /> (5.0.x ནང་ལུ་ ཁྱོད་ཀྱིས་ ཐོན་རིམ་ 4.4.x ལུ་ མར་ཕབ་འབད་ཚུགས།)</p>';
$string['releasenoteslink'] = 'Moodleཐོན་རིམ་གྱི་བརྡ་དོན་ལས་ {$a}་གསར་བཏོན་དྲན་འཛིན་དེ་བཟིགས།';
$string['safemode'] = 'ཉེན་སྲུང་གི་གནས།';
$string['safemodeerror'] = 'ཉེན་མེད་ཐབས་ལམ་ ཨཱོན་སྦེ་ཡོད་པའི་སྐབས་ མུ་ཌེལ་ལུ་ དཀའ་ངལ་འོང་།';
$string['safemodehelp'] = '<p>ཉེན་མེད་ཐབས་ལམ་ ཨཱོན་སྦེ་ཡོད་པའི་སྐབས་ Moodleལུ་ དཀའ་ངལ་འོང་། དེ་མ་ཚད་ ཡིག་སྣོད་གསརཔ་ཚུ་ཡང་ གསར་བསྐྲུན་འབད་མི་ཚུགས་</p> <p>ཉེན་མེད་ཐབས་ལམ་འདི་ paranoid མི་མང་ web host རྐྱངམ་ཅིག་གིས་ ལྕོགས་ཅན་བཟོ་དེ་འོང་། དེ་འབདཝ་ལས་ ཁྱོད་རའི་Moodleས་ཁོངས་ཀྱི་དོན་ལུ་ web host ཚོང་སྡེ་གསརཔ་ འཚོལ་དགོཔ་འོང་།</p> <p>ཁྱོད་ར་ འབད་དགོ་མནོ་བ་ཅིན་ གཞི་བཙུགས་འཕྲོ་མཐུད་འབད་ དེ་འབདཝ་ད་ ཤུལ་ལས་ དཀའ་ངལ་ ཨ་མི་རེ་ འཐོན་འོང་།</p>';
$string['sessionautostart'] = 'ལཱ་ཡུན་ རང་བཞིན་འགོ་བཙུགས།';
$string['sessionautostarterror'] = 'འདི ་ཡོདཔ་མ་བཟོ།';
$string['sessionautostarthelp'] = '<p>Moodle་ལུ་ ལཱཡུན་རྒྱབ་སྐྱོར་དགོཔ་དང་ འདི་མེད་པ་ཅིན་ ལཱ་འབད་མི་བཏུབ།</p> <p>ལཱ་ཡུན་ཚུ་ php.ini ཡིག་སྣོད་ནང་ ལྕོགས་ཅན་བཟོ་བཏུབ་་་་session.auto_start parameter འཚོལ།</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP has not been properly configured with the SQLite extension. Please check your php.ini file or recompile PHP.';
$string['upgradingqtypeplugin'] = 'plugin དེ་དུས་མཐུན།';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'ཁྱོད་རའི་ གློག་རིག་ནང་ <strong>{$a->packname} {$a->packversion}</strong> package འདི་ མཐའ་འཁྱོལཅན་སྦེ་ གཞི་བཙུགས་དང་ གསར་བཙུགས་འབད་ཡོདཔ་ལས་བརྟེན་ ཁྱོད་ཀྱིས་འ་ནི་ ཤོག་ལེབ་འདི་བལྟ་ཚུགསཔ་ཨིན། བཀྲིས་བདེ་ལེགས་!';
$string['welcomep30'] = '<strong>{$a->installername}</strong> གསར་བཏོན་འབད་མི་ནང་ <strong>Moodle</strong> བཀོལ་སྤྱོད་འབད་བཏུབ་མི་ མཐའ་འཁོར་གསར་བསྐྲུན་འབད་མི་གློག་རིམ་ཚུ་ཡང་ཚུདཔ་ཨིན།';
$string['welcomep40'] = 'ཐུམ་སྒྲིལ་འདི་ནང་ལུ་ <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong> ཡང་ ཚུདཔ་ཨིན།';
$string['welcomep50'] = 'ཐུམ་སྒྲིལ་འདི་ནང་ལུ་ གློག་རིམ་ཆ་མཉམ་གྱི་ལག་ལེན་ཚུ་ ཁོང་རའི་ ཆོག་ཐམ་ལུ་ དབང་ཚད་ཡོདཔ་ཨིན། <strong>{$a->installername}</strong> ཐུམ་སྒྲིལ་ཆ་ཚང་འདི་ <a href="http://www.opensource.org/docs/definition_plain.html">open source</a> ཨིནམ་དང་ <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> ཆོག་ཐམ་དང་འཁྲིལ་ཏེ་ བགོ་བཀྲམ་འབད་འབདཝ་ཨིན།';
$string['welcomep60'] = 'འོག་གི་ཤོག་ལེབ་ཚུ་གིས་ ཁྱོད་རའི་གློག་རིག་ནང<strong>Moodle</strong> རིམ་སྒྲིག་འབད་ནིའི་ ཐབས་ལམ་ འཇམ་ཏོང་ཏོ་ཚུ་སྟོན་འོང་། སྔོན་སྒྲིག་ སྒྲིག་སྟངས་ཚུ་ དང་ལེན་འབད་ ཡང་ན་ ཁྱོད་རའི་དགོས་མཁོ་དང་བསྟུན་ཏེ་ འདི་ཚུ་ བསྒྱུར་བཅོས་འབད།';
$string['welcomep70'] = '<strong>Moodle</strong> གཞི་སྒྲིག་ འཕྲོ་མཐུད་དེ་འབད་ནིའི་དོན་ལུ་ "Next" ཨེབ་རྟ་གུ་ ཨེབ་གཏང་འབད།';
$string['wwwroot'] = 'Web ཁ་བྱང་ཚུ་';
$string['wwwrooterror'] = '\'Web་བྱང་\' འདི་་ནུས་ཅན་མེན་མས་ - འ་ནི་མུ་ཌེལ་ གཞི་བཙུགས་དེ་ འདི་ནང་མེདཔ་བཟུམ་ཅིག་འདུག། འོག་ལུ་ ཡོད་མི་ བེ་ལུ་དེ་ སླར་སྒྲིག་འབད་དེ་འདུག།';
