<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'བྱེད་ལས།';
$string['activate'] = 'སྤྱོད་སྒོ་ལྕོགས་ཅན་བཟོ།';
$string['activatesuccess'] = 'ངོ་རྒྱན་ནང་འཛུལ་ཞུགས་འབད་ནི་འི་ ལྕོགས་ཅན་བཟོ་ནི་འདི་ མཐར་འཁྱོལ་ཅན་ཅིག་འགྱོ་ཡི།';
$string['addbadgecriteria'] = 'ངོ་རྒྱན་གྱི་ཚད་གཞི་ཁ་སྐོང་རྐྱབས།';
$string['addcourse'] = 'སློབ་ཚན་ཁ་སྐོང་བཀོད།';
$string['addcourse_help'] = 'ངོ་རྒྱན་དེ་ནང་བཀོད་དགོ་པའི་སློབ་ཚན་ཚུ་གདམ་ཁ་རྐྱབས། མང་རབས་གདམ་ནིའི་དོན་ལུ་ CTRLལྡ་ཡིག་དེ་ཨེབ།';
$string['addcriteria'] = 'ཚད་གཞི་ཁ་སྐོང་རྐྱབས།';
$string['addcriteriatext'] = 'ཚད་གཞི་ཁ་སྐོང་རྐྱབས་ནིའི་དོན་ལུ་ མར་འབབ་གློག་རིམ་དཀར་ཆག་ནང་ལས་ གཅིག་གདམ་ཁ་རྐྱབས་གནང་།';
$string['addtobackpack'] = 'backpack ནང་ལུ་ཁ་སྐོང་འབད།';
$string['adminonly'] = 'ཨ་ནི་ངོ་ཤོག་དེ་ བདག་སྐྱོང་པ་གི་དོན་ལུ་རྐྱངམ་ཅིག་ཨིན།';
$string['after'] = 'སྤྲོད་པའི་ཟླ་ཚེས་ཀྱི་ཤུལ་ལས།';
$string['aggregationmethod'] = 'སྤྱིར་བསྡོམས་ཀྱི་ཐབས་ལམ།';
$string['all'] = 'ཆ་མཉམ།';
$string['allmethod'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ གནས་ཚིག་ཆ་མཉམ་སྒྲུབ་ཅི།';
$string['allmethodactivity'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ ལས་བྱེད་ཆ་མཉམ་རྫོགས་ཡི།';
$string['allmethodcourseset'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ སློབ་ཚན་ཆམཉམ་རྫོགས་ཡི།';
$string['allmethodmanual'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ ལས་འགན་ཆ་མཉམ་གྱི་ ངོ་རྒྱན་བྱིནམ་ཨིནའ';
$string['allmethodprofile'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ གསལ་བསྡུས་ཀྱི་ ཡུལ་ཆ་མཉམ་རྫོགས་སོང་ཡི།';
$string['allowcoursebadges'] = 'སློབ་ཚན་ངོ་རྒྱན་ཚུ་ ལྕོགས་ཅན་བཟོ།';
$string['allowcoursebadges_desc'] = 'སློབ་ཚན་སྐབས་ཐོབ་ནང་ལུ་ ངོ་རྒྱན་བཟོ་སྟེ་གནང་ཆ་ སྒྲིག་བཅུག།';
$string['allowexternalbackpack'] = 'ཕྱིའི་རྒྱབ་སྣོན་དང་འབྲེལ་མཐུད་འབད་ནིའི་ ལྕོགས་ཅན་བཟོ།';
$string['allowexternalbackpack_desc'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ཁོང་རའི་ཕྱིའི་རྒྱབ་སྣོན་སྦྱིན་མི་ལས་ འབྲེལ་མཐུད་འབད་ནིའི་གནང་སྦྱིན་སྤྲོད་ད། ཡོངས་འབྲེལ་དེ་ སྤྱོད་བཏུབ་མེད་པ་ཅིན་ གདམ་ཁ་འདི་ ལྕོགས་མིན་བཟོ་བཞག་ཟེར་ རྒྱབ་སྣོན་ངོ་སྦྱོར་འབདཝ་ཨིན། དཔེར་ན་  (because of the firewall)';
$string['any'] = 'གང་རུང༌།';
$string['anymethod'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ གནས་ཚིག་གང་རུང༌ཅིག་སྒྲུབ་ཡོདཔ།';
$string['anymethodactivity'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ བྱེད་ལས་གང་རུང༌ཅིག་རྫོགས་ཡོདཔ།';
$string['anymethodcourseset'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ སློབ་ཚན་གང་རུང༌ཅིག་རྫོགས་ཡོདཔ།';
$string['anymethodmanual'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ ལས་འགན་གང་རུང༌ཅིག་གིས་ངོ་རྒྱན་སྦྱིནམ་ཨིན།';
$string['anymethodprofile'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ གསལ་བསྡུས་ཀྱི་ཡུལ་་དེ་རྫོགས་སོང་ཡི།';
$string['attachment'] = 'ཡིག་འཕྲིན་དང་ཆ་ངོ་རྒྱན་སྦྲགས།';
$string['attachment_help'] = 'དབྱེ་ཞིབ་འབད་དེ་ཡོད་པ་ཅིན་ ངོ་རྒྱན་སྤྲོད་ཡོད་པའི་ཡིག་སྣོད་ཅིག་ ཕབ་ལེན་གྱི་དོན་ལུ་ ཐོབ་མི་གི་གློག་འཕྲིན་ནང་སྦྲགས་གཏང་ཡོད། གློག་འཕྲིན་དང་སྦྲགས་ཡོད་མི་དེ་ གདམ་ཁ་འདི་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ གནས་ཁོངས་ནང་ལུ་ལྕོགས་ཅན་བཟོ་དགོ';
$string['award'] = 'ངོ་རྒྱན་སྤྲོད།';
$string['awardedtoyou'] = 'ང་ལུ་འབྱིན།';
$string['awardoncron'] = 'ངོ་རྒྱན་ནང་འཛུལ་སྤྱོད་འབད་ནི་འདི་ མཐར་འཁྱོལ་ཅན་ཅིག་བྱུང་ཡི། ལག་ལེན་པ་མང་ཤོས་ཀྱིས་རང་ ངོ་རྒྱན་དེ་ཐོབ་ཚུགས། གནས་ཁོངས་ལག་ལེན་དཔྱད་ནི་གི་དོན་ལུ་ ཨ་ནི་བྱེད་ལས་དེ་བཟོ་འདོན་གྱི་དོན་ལུ་ དུས་ཡུན་དག་པ་ཅིག་གོར་འོང་།';
$string['awards'] = 'ཐོབ་མི་ཚུ།';
$string['backpackavailability'] = 'ཕྱིའི་ངོ་རྒྱན་གྱི་ བདེན་དཔྱད།';
$string['backpackavailability_help'] = 'ངོ་རྒྱན་ཐོབ་མི་ཚུ་ ཁྱོད་ལས་ཐོབ་ཅི་ཟེར་ བདེན་ཁུངས་བསྐྱལ་ནིའི་དོན་ལུ་ backpack ཞབས་ཏོག་ཅིག་འབད་སྤྱོད་།བད་ཚུགས་དགོ། དེ་གིས་ངོ་རྒྱན་དེ་ ཁྱོད་ཀྱི་གནས་ཁོངས་ལས་ཐོབ་ཅི་ཟེར་ བདེན་ཁུངས་བསྐྱལ་ཚུགས་དགོ་ ད་ལྟོ་ཁྱོད་ཀྱི་གནས་ཁོངས་འཛུལ་སྤྱོད་འབད་བཏུབ་མེདཔ་ལས་ ངོ་རྒྱ་སྤྲོད་ཚར་མི་དང་སྤྲོད་ནི་ཨིན་མི་ཚུ་དོན་ཁུངས་སྐྱེལ་མི་ཚུགས། ཨ་ནི་ཡིག་འཕྲིན་འདི་ག་ཅི་སྦེ་བལྟཝ་སྨོ  ཨ་ནི་འདི་ཡང་ན་ ཁྱོད་ཀྱི་firewall གིས་འཛུལ་སྤྱོད་འབད་མི་བཅུག་དོ་འོང་། ཡང་ན་གནས་ཁོངས་འདི་ ཆོག་ཡིག་གིས་བསྡམ་བཞག་བཞགཔ་འོང་། ཡང་ན་ཁྱོད་ཀྱི་གློག་རིག་ལག་ལེན་ཐབས་ཚུལ་འདི་  ཡོངས་འབྲེལ་ནང་ལས་ཐོབ་མ་ཚུགས་མི་ཅི་ཨིནམ་འོང་ དཔེར་ན་ (such as a local development machine) དཀའ་རྙོག་དེ་འདི་ཨིན་མས་ག ཁྱོད་ཀྱིས་དཀའ་རྙོག་འདི་ གནས་ཁོངས་ག་སྟེ་ལས་ངོ་རྒྱན་སྤྲོད་ནི་ཨིན་ན་གི་ནང་ལས་སེལ་དགོ་ དེ་མེན་པ་ཅིན་ ངོ་རྒྱན་ཐོབ་མི་ཚུ་གིས་ ངོ་རྒྱན་འདི་ཁྱོད་ལས་ཐོབ་ཅི་ཟེར་ཁུངས་བཀལ་མི་ཚུགས། ཁྱོད་ཀྱི་གནས་ཁོངས་འདི་ དངོས་མཐོང་མེན་པ་ཅིན་ ཁྱོད་ཀྱིས་མོ་བཏབ་ཀྱི་དོན་ལས་ ངོ་རྒྱན་ཚུ་ དངོས་མཐོང་མ་གྱུར་བའི་ཧེ་མ་བཟོ་ཚུགས། ང་གིས་གནས་ཁོང་འདི་ མི་དམངས་ལུ་འཛུལ་སྤྱོད་བཟོ་མ་ཚུགས་པ་ཅིན་ག་དེ་སྦེ་འབད་ནི་   དེའི་སྐབས་དགོ་པའིURLའདི་ ་[your-site-url]/badges/assertion.php་ཨིན། ག་དེམ་ཅིག་སྦེ་ ཁྱོད་ཀྱིས་firewall འདི་བཅོས་ཏེ་ ཡིག་སྣོད་དེ་ལུ་ཕྱིའི་འཛུལ་ཚུགས་པ་ཅིན་ ངོ་རྒྱན་བདེན་ཁུངས་དེ་བཀལ་ཚུགས།';
$string['backpackbadges'] = 'ཁྱོད་ལུ་ You have {$a->totalbadges} badge(s) displayed from {$a->totalcollections} collection(s). <a href="mybackpack.php">Change backpack settings</a>. ཚུ་ཡོད།';
$string['backpackconnection'] = 'རྒྱབ་སྣོན་འབྲེལ་མཐུད།';
$string['backpackconnection_help'] = 'ངོ་ཤོག་འདི་གིས་ ཁྱོད་ཕྲིའི་རྒྱབ་སྣོན་བྱིན་མི་དང་འབྲེལ་བ་འབད་ཚུགས། backpack དང་འབྲེལ་མཐུད་ཡོད་པ་ཅིན་ ཕྱིའི་ངོ་རྒྱན་ཚུ་ གནས་ཁོངས་འདི་ཁ་ལས་ དངོས་སྟོན་འབད་ཚུགས་ནི་དང་ ངོ་རྒྱན་ཚུ་ཁྱོད་རའི་backpackནང་འཕུལ་ཚུགས། ད་ལྟོ་འབད་བ་ཅིན <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a>རྐྱངམ་ཅིག་ རྒྱབ་སྐྱོར་འབད་དེ་ཡོད། backpack འབྲེལ་འཐུད་ངོ་ཤོག་གཞི་སྒྲིག་མ་འབད་བའི་ཧེ་མ་ backpack ཞབས་ཏོག་ནང་ལུ་ དངོས་ཞུགས་འབད་དགོ';
$string['backpackdetails'] = 'རྒྱབ་སྣོན་གཞི་སྒྲིག';
$string['backpackemail'] = 'གློག་འཕྲིན་ཨང་།';
$string['backpackemail_help'] = 'ཁྱོད་རའི་ backpack དང་འབྲེལ་བ་ཡོད་པའི་གློག་འཕྲིན་ཚུ། ཁྱོད་རང་འབྲེལ་མཐུད་ཡོད་པའི་སྐབས་ ངོ་རྒྱན་གང་རུང་ཅིག་ཐོབ་མི་དེ་ གློག་འཕྲིན་འདི་དང་འབྲེལ་བ་ཡོདཔ་ཨིན།';
$string['backpackimport'] = 'ངོ་རྒྱན་ནང་སྐྱོད་གཞི་སྒྲིག';
$string['backpackimport_help'] = 'backpack མཐུད་སྦྲེལ་དེ་མཐར་འཁྱོལ་ཅན་སྦེ་གཞི་བཙུགས་ཞིནམ་ལས་ ཁྱོད་ཀྱི་backpack ནང་ལས་ངོ་རྒྱན་ཚུ་ "My Badges" ཟེར་བའི་ངོ་ཤོག་དང་གསལ་སྡུས་ནང་ གསལ་སྟོན་ཚུགས། ཨ་ནི་ནང་ལུ་ ཁྱོད་རའི་་backpack ནང་ལས་ ཁྱོད་རའི་གསལ་སྡུས་ནང་གསལ་སྟོན་འབད་ནི་ཨིན་མི་ཚུ་ གདམ་ཁ་རྐྱབ་ཚུགས།';
$string['badgedetails'] = 'ངོ་རྒྱན་རྒྱས་བཤད།';
$string['badgeimage'] = 'པར།';
$string['badgeimage_help'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་བྱིནམ་ད་ལུ་ པར་ཨ་ནི་འདི་ལག་ལེན་འཐབ་འོང་། པར་གསརཔ་ཁ་སྐོང་འབད་ནིའི་དོན་ལུ་ འཚོལ་ཞིནམ་ལས་ "Save changes" ཟེར་མི་ལུ་ཨེབ་ད། པར་དེ་ངོ་རྒྱན་གི་དགོས་པ་འཁྲིལ་ མཐའམ་བཏོག་སྟེ་གྲུ་བཞི་བཟོ་ དེ་ལས་སླར་ཚད་བཟོ་ཞིནམ་འོང་།';
$string['badgeprivacysetting'] = 'ངོ་རྒྱན་སྒེར་དབང་གཞི་སྒྲིག';
$string['badgeprivacysetting_help'] = 'ཁྱོད་ཐོབ་སྟེ་ཡོད་མི་ ངོ་རྒྱན་ཚུ་ ཁྱོད་རའི་རྩིས་ཐོ་ངོ་ཤོག་ ནང་གསལ་སྟོན་འབད་ཚུགས། ཨ་ནི་གཞི་སྒྲིག་འདི་གིས་ ཁྱོད་རའི་ངོ་རྒྱན་གསརཔ་ཐོབ་མི་ཚུ་ རང་བཞིན་གྱིས་གསལ་མཐོང་བཟོ་ཚུགས། ཁྱོད་ཀྱིས་ "My badges" ངོ་ཤོག་ནང་འགྱོ་ཞིནམ་ལས་ ངོ་རྒྱན་རང་སོའི་ སྒེར་དབང་གཞི་སྒྲིག་འབད་ཚུགས།';
$string['badgeprivacysetting_str'] = 'ང་རའི་གདོང་ཤོག་ནང་ལུ་ ངོ་རྒྱན་ཐོབ་མི་ཚུ་རང་བཞིན་གྱིས་ གསལ་སྟོན་འབད་ཚུགས།';
$string['badgesalt'] = 'Salt for hashing ཐོབ་མིའི་གློག་འཕྲིན་ཁ་བྱང་';
$string['badgesalt_desc'] = 'hash་ལག་ལེན་འཐབ་པ་ཅིན་ backpack ལུ་ངོ་རྒྱན་ཐོབ་མི་ཚུ་ལུ་ ཁོང་གི་གློག་འཕྲིན་ཕྱི་ཁར་མ་བཏོན་པར་ གཏན་འབེབས་འབད་ཚུགསཔ་བཟོཝ་ཨིན། ཨ་ནི་གཞི་སྒྲིག་འདི་གིས་ ཡིག་འབྲུ་དབྱངས་གསལ་དང་ཨང་རྟགས་རྐྱངམ་ཅིག་ལག་ལེན་འཐབ་ཆོག་ ཐོབ་མི་གཏེན་འབེབས་ཀྱི་དོན་ལུ་ ངོ་རྒྱན་བྱིན་ནི་འགོ་བཙུགས་ཞིནམ་ལས་ཚུར་ གཞི་སྒྲིག་ཚུ་སོར་བཅོས་འབད་མ་གནང་།';
$string['badgesdisabled'] = 'གནས་ཁོངས་འདི་ན་ལུ་ ངོ་རྒྱན་ཚུ་ལྕོགས་ཅན་བཟོ་སྟེ་མེད།';
$string['badgesearned'] = 'ཐོབ་ཡོད་པའི་ངོ་རྒྱན་གྱི་གྱངས་ཁ། {$a}';
$string['badgesettings'] = 'ངོ་རྒྱན་གཞི་སྒྲིག';
$string['badgestatus_0'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ཐོབ་པ་མེད།';
$string['badgestatus_1'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ཐོབ་པ་ཡོད།';
$string['badgestatus_2'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ཐོབ་པ་མེད།';
$string['badgestatus_3'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ཐོབ་པ་ཡོད།';
$string['badgestatus_4'] = 'མཛོད་ནང་བསྡམ་ཡོདཔ།';
$string['badgestoearn'] = 'ཡོད་པའི་ངོ་རྒྱན་གྱི་གྱངས་ཁ། {$a}';
$string['badgesview'] = 'སློབ་ཚན་གྱི་ངོ་རྒྱན།';
$string['badgeurl'] = 'ངོ་རྒྱན་སྤྲོད་ཡོད་པའི་ འབྲེལ་འཐུད།';
$string['bawards'] = 'ཐོབ་མི་ཚུ། ({$a})';
$string['bcriteria'] = 'ཚད་གཞི';
$string['bdetails'] = 'རྒྱས་བཤད་ཞུན་དག་འབད།';
$string['bmessage'] = 'ཕྲིན་ཡིག';
$string['boverview'] = 'སྤྱིར་བཏང་མཐོང་སྣང༌།';
$string['bydate'] = 'རྫོགས་མི།';
$string['clearsettings'] = 'གཞི་སྒྲིག་སེལ་ནི།';
$string['completioninfo'] = 'ཨ་ནི་ངོ་རྒྱན་འདི་ ག་ཅི་རྫོགས་ནི་འདི་གིས་བྱིན་བྱིནམ་ཨིན་ན།';
$string['completionnotenabled'] = 'སློབ་ཚན་རྫོགས་ཡོདཔ་འདི་ སློབ་མཚན་འདི་ནང་ ལྕོགས་ཅན་བཟོ་སྟེ་མེདཔ་ལས་ ངོ་རྒྱན་ཚད་གཞི་ནང་ཙུད་སྟེ་མེད། སློབ་ཚན་མཇུག་བསྡུ་འདི་ སློབ་ཚན་གཞི་སྒྲིག་ནང་ ལྕོགས་ཅན་བཟོ་འོང་།';
$string['configenablebadges'] = 'ལྕོགས་ཅན་འབད་བའི་སྐབས་ ཨ་ནི་ཁྱད་གནད་དེ་གིས་ གནས་ཁོངས་ལག་ལེན་པ་ཚུ་ལུ་ ངོ་རྒྱན་བཟོ་སྟེ་སྤྲོད་ནི་ལུ་རྒྱབ་སྐྱོར་འབདཝ་ཨིན།';
$string['configuremessage'] = 'ངོ་རྒྱན་ཡིག་འཕྲིན།';
$string['connect'] = 'མཐུད།';
$string['connected'] = 'མཐུདཔ་ཡོདཔ།';
$string['connecting'] = 'མཐུད་བའི་བསྒང་།';
$string['contact'] = 'འབྲེལ་བ།';
$string['contact_help'] = 'ངོ་རྒྱན་སྤྲོད་མི་དང་འབྲེལ་བ་ཡོད་པའི་ གློག་འཕྲིན་ཁ་བྱང་།';
$string['copyof'] = '{$a} གི་འདྲ།';
$string['coursebadges'] = 'ངོ་རྒྱན་ཚུ།';
$string['coursebadgesdisabled'] = 'སློབ་ཚན་ངོ་རྒན་ཚུ་ གནས་ཁོངས་འདི་ནང་ལྕོགས་ཅན་བཟོ་སྟེ་མེད།';
$string['coursecompletion'] = 'ལག་ལེན་པ་ཚུ་ ཨ་ནི་སློབ་ཚན་འདི་ མཇུག་བསྡུ་དགོ';
$string['create'] = 'ངོ་རྒྱན་གསརཔ།';
$string['createbutton'] = 'ངོ་རྒྱན་བཟོ།';
$string['creatorbody'] = '<p>{$a->user} གིས་ངོ་རྒྱན་ལུ་མཁོ་བའི་ཁྱད་ཆོས་ཚང་ཚུགསཔ་ལས་ ངོ་རྒྱན་སྤྲོད་དེ་ཡོད། {$a->link} </p> ནང་ལུ་ངོ་རྒྱན་སྤྲོད་མི་འདི་བལྟ་གནང་།';
$string['creatorsubject'] = '\'{$a}\' བྱིན་ཏེ་ཡོད།';
$string['criteria_0'] = 'ཨ་ནི་ངོ་རྒྱན་འདི་ནམ་སྤྲོད་སྤྲོདཔ་ཨིན་ན།';
$string['criteria_1'] = 'བྱེད་ལས་རྫོགས་ཡོདཔ།';
$string['criteria_1_help'] = 'ལས་རྒྱན་དང་སློབ་ཚན་རྫོགས་མི་ཚུ་ལུ་ ལག་ལེན་པ་གིས་ངོ་རྒྱན་བྱིན་ནི་གི་དབང་ཆ་སྤྲོད་ཡོད།';
$string['criteria_2'] = 'ལས་འགན་རང་ཤུགས་ཀྱིས་སྤྲོད་པ།';
$string['criteria_2_help'] = 'གནས་ཁོངས་དང་སློབ་ཚན་ནང་ལུ་ ལས་འགན་ཅིག་ཡོད་མི་ལུ་ ལག་ལེན་པ་གིས་རང་ཤུགས་ཐོག་ལས་ ངོ་རྒྱན་བྱིན་ནི་ལུ་དབང་ཆ་བྱིནམ་ཨིན།';
$string['criteria_3'] = 'མི་སྡེ་གྲལ་གཏོགས།';
$string['criteria_3_help'] = 'མི་སྡེ།';
$string['criteria_4'] = 'སློབ་ཚན་འཇུག་བསྡུ།';
$string['criteria_4_help'] = 'སློབ་ཚན་མཇུག་བསྡུ་མི་ལག་ལེན་པ་ཚུ་ལུ་ ངོ་རྒྱན་སྤྲོད་ནི་གི་བདག་དབང་སྤྲོདཔ་ཨིན། ཨ་ནི་ཚད་གཞི་འདི་ནང་ལུ་ ཚད་གཞི་གཞན་ སྐུགས་ཉུང་མཐའ་ དང་སློབ་ཚན་མཇུག་བསྡུ་བའི་ཟླ་ཚེས་ཚུ་ཡོད།';
$string['criteria_5'] = 'སློབ་ཚན་ཆ་ཚང་མཇུག་བསྡུ་བའི་བསྒང་།';
$string['criteria_5_help'] = 'སློབ་ཚན་ཆ་ཚང་མཇུག་བསྡུ་མི་ཚུ་ལུ་ ངོ་རྒྱན་སྤྲོད་བཅུགཔ་ཨིན། སློབ་ཚན་རེ་རེ་ལུ་ ཚད་གཞི་ཁ་སྐོང་ སྐུགས་ཚད་ཉུང་མཐའ་དང་སློབ་ཚན་མཇུག་བསྡུ་བ་ལ་སོགས་པ་ཡོདཔ་ཨིན།';
$string['criteria_6'] = 'གསལ་བསྡུ་མཇུག་བསྡུ།';
$string['criteria_6_help'] = 'ལག་ལེན་པ་ཚུ་ ཁོང་གི་གསལ་བསྡུ་ནང་ལུ་ཡུལ་ལ་ལུ་ཅིག་ཚང་མི་ཚུ་ལུ་ ངོ་རྒྱན་བྱིན་བཅུགཔ་ཨིན། ཁྱོད་ཀྱིས་ ལག་ལེན་པ་ཚུ་ལུ་ སྤྱོད་དབང་ཡོད་མི སྔ་སྒྲིག་འབད་ཡོད་མི་ལས་ གབམ་ཁ་འབད་ཚུགས།';
$string['criteriacreated'] = 'ངོ་རྒྱན་གྱི་ཚད་གཞི་ མཐར་འཁྱོལ་ཅན་སྦེ་ བཟོ་ཡོདཔ།';
$string['criteriadeleted'] = 'ངོ་རྒྱན་གྱི་ཚད་གཞི་ མཐར་འཁྱོལ་ཅན་སྦེ་ ཕྱིར་བཏོན་གཏང་ཡོདཔ།';
$string['criteria_descr'] = 'ལག་ལེན་པ་ཚུ་གིས་ འོག་ལུ་ཡོད་མི་མཁོ་ཆེ་བའི་ཁྱད་ཆོས་ཚུ་ཚངམ་ད་ ཁོང་ལག་ལེན་པ་ཚུ་ལུ་ངོ་རྒྱན་འདི་བྱིནམ་ཨིན།';
$string['criteria_descr_0'] = 'ངོ་རྒྱན་དེ་ ལག་ལེན་པ་ཚུ་ལུ་ མཁོ་ཆེ་བའི་ཁྱད་ཆོས་ལེ་ཤ་ཡོད་ས་ལས་ <strong>{$a}</strong> ཚུ་ཚངམ་ད་ ངོ་རྒྱན་དེ་སྤྲོདཔ་ཨིན།';
$string['criteria_descr_1'] = 'འོག་ལུ་བཀོད་ཡོད་པའི་བྱེད་ལས་ཚུ་ལས་ <strong>{$a}</strong> ཚུ་རྫོགས་ཡོད།';
$string['criteria_descr_2'] = 'འོག་ལུ་ཡོད་པའི་ལས་འགན་ཚུ་ལས་ ལག་ལེན་པ་ཚུ་གིས་ ངོ་རྒྱན་དེ་<strong>{$a}</strong>དང་སྦྲགས་བྱིན་དགོ';
$string['criteria_descr_4'] = 'ལག་ལེན་པ་ཚུ་སློབ་ཚན་མཇུག་བསྡུ་དགོ';
$string['criteria_descr_5'] = 'སློབ་ཚན་འོག་ལུ་བཀོད་དོ་བཟུམ་ཡོད་ས་ལས་ <strong>{$a}</strong>ཚ་མཇུག་བསྡུ་ཡི།';
$string['criteria_descr_6'] = 'ལག་ལེན་པའི་ གསལ་བསྡུ་ཀྱི་ཡུལ་ འོག་ལུ་བཀོད་དོ་བཟུམ་ཡོད་ས་ལས <strong>{$a}</strong> མཇུག་བསྡུ་ཡི།';
$string['criteria_descr_bydate'] = '<em>{$a}</em> གིས';
$string['criteria_descr_grade'] = 'ཉུང་མཐའ་སྐུགས་ <em>{$a}</em>';
$string['criteria_descr_short0'] = '<strong>{$a}</strong> གི་མཇུག་བསྡུ་།';
$string['criteria_descr_short1'] = '<strong>{$a}</strong>གི་མཇུག་བསྡུ་།';
$string['criteria_descr_short2'] = '<strong>{$a}</strong> གི་བྱིན་ཡོདཔ།';
$string['criteria_descr_short4'] = 'སློབ་ཚན་མཇུག་བསྡུ།';
$string['criteria_descr_short5'] = '<strong>{$a}</strong> གི་མཇུག་བསྡུ་།';
$string['criteria_descr_short6'] = '<strong>{$a}</strong>  གི་མཇུག་བསྡུ།';
$string['criteria_descr_single_1'] = 'འོག་ལུ་ཡོད་པའི་བྱེད་ལས་འདི་ མཇུག་བསྡུ་ཡོདཔ།';
$string['criteria_descr_single_2'] = 'ངོ་རྒྱན་འདི་ ལག་ལེན་པ་འདི་གིས་ འོག་ལུ་ཡོད་པའི་ལས་འགན་སྦྲགས་སྤྲོད་དགོ';
$string['criteria_descr_single_4'] = 'ལག་ལེན་པ་ཚུ་སློབ་ཚན་མཇུག་བསྡུ་དགོ';
$string['criteria_descr_single_5'] = 'འོག་ལུ་ཡོད་པའི་སློབ་ཚན་འདི་ མཇུག་བསྡུ་ཡོད།';
$string['criteria_descr_single_6'] = 'འོག་ལུ་བཀོད་ཡོད་མི་ ་ལག་ལེན་པའི་ གསལ་བསྡུའི་ཡུལ་དེ་ མཇུག་བསྡུ་ཡི།';
$string['criteria_descr_single_short1'] = 'མཇུག་བསྡུ།';
$string['criteria_descr_single_short2'] = 'གིས་སྤྲོད་ཡོད།';
$string['criteria_descr_single_short4'] = 'སློབ་ཚན་མཇུག་བསྡུ།';
$string['criteria_descr_single_short5'] = 'མཇུག་བསྡུ།';
$string['criteria_descr_single_short6'] = 'མཇུག་བསྡུ།';
$string['criteriasummary'] = 'ཚད་གཞི་བཅུད་བསྡུས།';
$string['criteriaupdated'] = 'ངོ་རྒྱན་གྱི་ཚད་གཞི་ མཐར་འཁྱོལ་ཅན་སྦེ་ ཡར་བཙུགས་ཡོདཔ།';
$string['criterror'] = 'ད་ལྟོ་བྱིན་ཡོད་པའི་ ཚད་གཞི།';
$string['criterror_help'] = 'ཡུལ་ཚན་དེ་གིས་ ངོ་རྒྱན་གྱི་དོན་ལུ་ དགོཔ་མཁོ་ཆེ་བའི་ ཁྱད་ཆོས་ཧེ་མ་ལས་བཙུགས་ཡོད་རུང་ ད་ལྟོ་གསལ་མཐོང་མེད་མི་ཚུ་སྟོནམ་ཨིན། ལག་ལེན་པ་ཚུ་གིས་ མ་འོངས་པ་ལུ་ ངོ་རྒྱན་དེ་ཐོབ་ཚུགས་ནི་གི་དོན་ལུ་ ཁྱད་ཆོས་དེ་ཚུ་དྲན་ཐོ་མེདཔ་བཟོ་དགོཔ་ཨིན།';
$string['currentimage'] = 'ད་ལྟོའི་པར།';
$string['currentstatus'] = 'ད་ལྟོའི་གནས་རིམ།';
$string['dateawarded'] = 'སྤྲོད་པའི་ཟླ་ཚེས།';
$string['dateearned'] = 'ཟླ་ཚེས། {$a}';
$string['day'] = 'ཉིན་གྲངས།';
$string['deactivate'] = 'འཛུལ་སྤྱོད་ལྕོགས་མིན་བཟོ།';
$string['deactivatesuccess'] = 'ངོ་རྒྱན་ནང་ལུ་ འཛུལ་སྤྱོད་འབད་ནི་འདི མཐར་ཕྱིནམ་སྦེ་ ལྕོགས་མིན་བཟོ་ཡི།';
$string['defaultissuercontact'] = 'སྔ་སྒྲིག་ངོ་རྒྱན་སྤྲོད་མི་གི་ འབྲེལ་བྱང་རྒྱས་པ།';
$string['defaultissuercontact_desc'] = 'ངོ་རྒྱན་སྤྲོད་མི་དང་འབྲེལ་བ་ཡོད་པའི་ གློག་འཕྲིན་ཁ་བྱང་།';
$string['defaultissuername'] = 'སྔ་སྒྲིག་ངོ་རྒྱན་སྤྲོད་མིའི་མིང་།';
$string['defaultissuername_desc'] = 'སྤྲོད་མི་ངོ་ཚབ་ཡང་ན་བདང་འཛིན།';
$string['delbadge'] = 'ངོ་རྒྱན་ཕྱིར་བཏོན་འབད།';
$string['delconfirm'] = 'ངོ་རྒྱན་ཕྱིར་བཏོན་གཏང་ནི་ཨིནམ་ངེས་གཏན་ཨིན་ན། \'{$a}\'?';
$string['delcritconfirm'] = 'ཁྱད་ཆོས་དེ་ རྩ་མེད་བཏོན་གེཏང་ནི་ཨིནམ་ གཏན་གཏན་ཨིན་ན།';
$string['delparamconfirm'] = 'ཚད་གཞི་འདི་ཕྱིར་བཏོན་གཏང་ནི་ཨིནམ་ངེས་གཏན་ཨིན་ན';
$string['description'] = 'འགྲེལ་བཤད།';
$string['disconnect'] = 'འབྲེལ་འཐུད་མེདཔ་བཟོ།';
$string['donotaward'] = 'སྐབས་ཅིག་ ངོ་རྒྱན་དེ་ སྤྱོད་བཏུབ་མེདཔ་ལས་ ལག་ལེན་པ་ཚུ་ལུ་ སྦྱིན་མི་བཏུབ་པས། ངོ་རྒྱན་དེ་འབྱིན་འདོད་ཡོད་པ་ཅིན་ གནས་རིམ་དེ་སྤྱོད་བཏུབ་པའི་ནང་བཟོ་གནང་།';
$string['editsettings'] = 'གཞི་སྒྲིག་ཞུན་དག་འབད།';
$string['enablebadges'] = 'ངོ་རྒྱན་ལྕོགས་ཅན་བཟོ།';
$string['error:backpackdatainvalid'] = 'backpack ནང་ལས་འོང་མི་ གནས་སྡུད་འདི་ ཆ་འཇོག་མེདཔ་ཨིན་མས།';
$string['error:backpackemailnotfound'] = 'གློག་ཕྲིན་ཁ་བྱང \'{$a}\' དེ་ backpack དང་འབྲེལ་བ་མིན་འདུག ཨ་ནི་རྩི་ཐོ་གི་དོན་ལུ་ ཡང་ན་<a href="http://backpack.openbadges.org">create a backpack</a> དགོ་པས་ ཡང་ན་གློག་ཕྲིན་ཁ་བྱང་གཞན་ཅིག་ལས་ འཛུལ་ཞུགས་འབད་དགོ';
$string['error:backpackloginfailed'] = 'རྒྱ་མཚན་ {$a} ལུ་རྟེན་ ཁྱོད་ ཕྱིའི་backpack དང་འབྲེལ་འཐུབ་མིན་འདུག';
$string['error:backpacknotavailable'] = 'ཁྱོད་ཀྱི་གནས་ཁོངས་འདི་ ཡོངས་འབྲེལ་ལས་ འཛུལ་ཞུགས་འབད་བཏུབ་མེདཔ་ལས་ ངོ་རྒྱན་བྱིན་མི་ཚུ་ ཕྱིའི་backpackཞབས་ཏོག་གིས་བདེན་དཔྱད་འབད་མི་བཏུབ་པས།';
$string['error:backpackproblem'] = 'ཁྱོད་ཀྱི་ backpack ཞབས་ཏོག་བྱིན་མི་དང་ཅིག་ཁར་ འབྲེལ་འཐུད་ནི་ལུ་ བཀའ་ངལ་ཡོདཔ་ལས་ ལོག་ཨ་ཙི་ཁ་ལས་འབད་གནང་།';
$string['error:badjson'] = 'འབྲེལ་འཐུད་འབད་ནི་འབད་བའི་ སྦྱོར་རྩོམ་འདི་གིས་ ཆ་འཇོག་མེད་པའི་གནས་སྡུད་བྱིན་ཡོད།';
$string['error:cannotact'] = 'ངོ་རྒྱན་དེ་ལག་ལེན་འཐབ་བཏུབ་བཟོ་མི་བཏུབ་པས།';
$string['error:cannotawardbadge'] = 'ངོ་རྒྱན་དེ་ལག་ལེན་པ་ཚུ་ལུ་སྤྲོད་མི་ཚུགས་པས།';
$string['error:clone'] = 'ངོ་རྒྱན་དེ་ མཚུངས་གཟུགས་བཟོ་མི་ཚུགས་པས།';
$string['error:connectionunknownreason'] = 'འབྲེལ་འཐུད་དེ་མཐར་འཁྱོལ་ཅན་ཅིག་འགྱོ་མ་ཚུགས་ ཨིན་རུང་ག་ཅི་སྦེ་ཨིན་ན་གནད་དོན་མ་བཀོད་པས།';
$string['error:duplicatename'] = 'མིང་དེ་དང་ཆ་ངོ་རྒྱན་ཡོད་མི་ ཧེ་མ་ལས་ གློག་རིག་རིམ་ལུགས་ནང་འདུག';
$string['error:externalbadgedoesntexist'] = 'ངོ་རྒྱན་ཐོབ་མ་ཚུགས།';
$string['error:invalidbadgeurl'] = 'ངོ་རྒྱ་སྤྲོད་མི་གི་ ཆ་འཇོག་མེད་པའི་  URL སྒྲིག་བཀོད།';
$string['error:invalidcriteriatype'] = 'ཆ་འཇོག་མེད་པའི་ ཚད་གཞི་འི་དབྱེ་ཁག';
$string['error:invalidexpiredate'] = 'ཆ་འཇོག་ཡུན་གནས་དེ་ ཟླ་ཚེས་འདི་ མ་འོངས་པ་ལུ་འོང་དགོ';
$string['error:invalidexpireperiod'] = 'ཆ་འཇོག་ཡུན་གནས་ 0 དང་དེ་བ་དམའཝ་སྦེ་མི་བཏུབ།';
$string['error:noactivities'] = 'ཨ་ནི་སློབ་ཚན་ནང་ལུ་ བྱེད་ལས་་དང་ཆ་ཁྱད་ཆོས་';
$string['error:noassertion'] = 'གློག་རིག་སྤྱོད་པ་དེ་ལས་ ངེས་གཏམ་མིན་འདུག འཛུལ་ཞུགས་ཀྱི་བྱ་རིམ་མ་འབད་བའི་ཧེ་མ་ ཀྱོད་ཀྱིས་ གདམ་ཐོ་ཡིག་སྒྲོམ་དེ་ བསྡམ་བཞག་ཡོད་དོ་ཡོདཔ་མས།';
$string['error:nocourses'] = 'ཨ ནི་གནས་ཁོངས་ནང་ལུ་ སློབ་ཚན་ག་ལུ་ཡང་ སློབ་ཚན་འཇུག་བསྡུ་དེ་ལྕོགས་ཅན་བཟོ་སྟེ་མེདཔ་ལས་ དེ་ཚུ་དངོས་སྟོན་འབད་མི་བཏུབ་པས། སློབ་ཚན་མཇུག་བསྡུ་ཚུ་ སླབོབ་ཚན་གཞི་སྒྲིག་ནང་ལས་ལྕོགས་ཅན་བཟོ་བཏུབ།';
$string['error:nogroups'] = 'ཁྱོད་ཀྱི་backpackནང་ལུ་ མི་དམངས་བསྡུ་གསོག་གི་ངོ་རྒྱན་ <p>ཚུ་མིན་འདུག་ མི་དམངས་ཀྱི་བསྡུ་གསོག་</p> <p>རྐྱངམ་ཅིག་སྟོན་ནུག་ མི་དམངས་བསྡུ་གསོག་<p>ཚུ་བཟོ་ནིའི་དོན་ལས་ <a href="http://backpack.openbadges.org">visit your backpack</a> འབྲེལ་བ་འབད།';
$string['error:nopermissiontoview'] = 'ངོ་རྒྱན་ཐོབ་མི་ཚུ་བལྟ་ནིའི་གནང་བ་ཁྱོད་ལུ་མེདཔ་ཨིན།';
$string['error:nosuchbadge'] = 'ངོ་རྒྱན་ངོ་རྟགས་ཨང་{$a}འཆང་མི་འདི་མིན་འདུག';
$string['error:nosuchcourse'] = 'ཉེན་བརྡ : ཨ་ནི་སློབ་ཚན་འདི་ད་ལས་ཕར་ ་ཐོབ་མི་ཚུགས་པས།';
$string['error:nosuchfield'] = 'ཉེན་བརྡ : ཨ་ནི་ལག་ལེན་པའི་ གསལ་ཡུལ་དེ་ ད་ལས་ཕར་ཐོབ་མི་ཚུགས་པས།';
$string['error:nosuchmod'] = 'ཉེན་བརྡ :ཨ་ནི་བྱེད་ལས་དེ་ ད་ལས་ཕར་ཐོབ་མི་ཚུགས་པས།';
$string['error:nosuchrole'] = 'ཉེན་བརྡ :ཨ་ནི་ལས་འགན་དེ་ ད་ལས་ཕར་ཐོབ་མི་ཚུགས་པས།';
$string['error:nosuchuser'] = 'སྐབས་ཐོག་གི་backpackབྱིན་མི་ལས་ གློག་རིག་ཁབྱང་དེ་ལག་ལེན་འཐབ་མི་ ལག་ལེན་པ་ལུ་ རྩིས་ཐོ་མིན་འདུག';
$string['error:notifycoursedate'] = 'ཉེན་བརྡ : ངོ་རྒྱན་དེ་དང་བྲེལ་བ་ཡོད་པའི་  སློབ་ཚན་འཇུག་བསྡུ་གི་བྱེད་ལས་དེ་ སློབ་ཚན་འགོ་མ་བཙུགས་ཚུན་ བདག་དབང་མི་སྤྲོད།';
$string['error:parameter'] = 'ཉེན་བརྡ : ངོ་རྒྱན་བདག་དབང་སྤྲོད་ནི་འདི་གཏན་འབེབས་བཟོ་ནིའི་དོན་ལུ་ ཚད་གཞི་ཅིག་འདི་ག་དེ་སྦེ་རུང་གདམ་འཐུ་འབད་དགོ།';
$string['error:personaneedsjs'] = 'སྐབས་ཐོག་ backpack དང་འབྲེལ་འཐུད་འབད་ནིའི་དོན་ལུ་ Javascriptའདི་ངེས་བདེན་དགོཔ་ཨིན། འབད་ཚུགས་པ་ཅིན་ ངོ་ཤོག་དེ་སླར་ལོག་ཡར་འདྲེན་བཀལ་ནིའི་དོན་ལུ་';
$string['error:requesterror'] = 'འབྲེལ་འཐུད་ཀྱི་གསོལ་འདེབས་དེ་ མཐར་ཕྱིན་མ་ཚུགས། (error code {$a}).Javascriptའདི་ལྕོགས་ཅན་བཟོ།';
$string['error:requesttimeout'] = 'ལཱ་མཇུག་མ་བསྡུཝ་ལས་ འབྲེལ་འཐུད་འབད་དགོ་པའི་གསོལ་འདེབས་འབད་མི་དེ་ དུས་ཡུན་རྫོགས་སོང་ཡི།';
$string['error:save'] = 'ངོ་རྒྱན་དེ་ བཀག་སྲུང་འབད་མི་ཚུགས་པས།';
$string['evidence'] = 'སྒྲུབ་བྱེད';
$string['existingrecipients'] = 'ངོ་རྒྱན་ཐོབ་མི་ཚུའི་ཐོ།';
$string['expired'] = 'དུས་ཡུན་རྫོགས་ཡོད།';
$string['expiredate'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ ཟླ་ཚེས་{$a} རྫོགསཔ་ཨིན།';
$string['expireddate'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ ཟླ་ཚེས་{$a} རྫོགས་ཡོད།';
$string['expireperiod'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ སྤྲོད་ཞིནམ་ལས་ ཉིན་གྲངས་ {$a} གི་ཤུལ་ལས་རྫོགསཔ་ཨིན།';
$string['expireperiodh'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ སྤྲོད་ཞིནམ་ལས་ ཆུ་ཚོད་ {$a} གི་ཤུལ་ལས་རྫོགསཔ་ཨིན།';
$string['expireperiodm'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ སྤྲོད་ཞིནམ་ལས་ སྐར་མ {$a} གི་ཤུལ་ལས་རྫོགསཔ་ཨིན།';
$string['expireperiods'] = 'ངོ་རྒྱ་དེ་ཆ་འཇོག་ཡུན་གནས་དེ་ སྤྲོད་ཞིནམ་ལས་ སྐར་ཆ་ {$a} གི་ཤུལ་ལས་རྫོགསཔ་ཨིན།';
$string['expirydate'] = 'ཆ་འཇོག་ཡུན་གནས་རཛོགས་པའི་ཟླ་ཚེས།';
$string['expirydate_help'] = 'ངོ་རྒྱ་དེ་ འཁོད་ཡོད་པའི་དུས་ཚོད་ཁར་ ཆ་འཇོག་ཡུན་གནས་རྫོགས་ནི་དང་ ཡང་ན་ ངོ་རྒྱན་ཚུའི་ཆ་འཇོག་ཡུན་གནས་རཛོགས་པའི་ཟླ་ཚེས་འདི་ ངོ་རྒྱན་ནམ་སྤྲོད་སྤྲོདཔ་ཨིན་ན་ལུ་བལྟ་སྟེ་བཟོ་བཏུབ་ཨིན།';
$string['externalbadges'] = 'ཡོངས་འབྲེལ་གཞན་ཁ་ལས་ཐོབ་པའི་ ངེའི་ངོ་རྒྱན་ཚུ།';
$string['externalbadges_help'] = 'ཨ་ནི་གནས་ཡུལ་དེ་གིས་ ཁྱོད་ཀྱི་ཕྱའི་backpackནང་གི་ངོ་རྒྱན་ཚུ་སྟོནམ་ཨིན།';
$string['externalbadgesp'] = 'ཡོངས་འབྲེལ་གཞན་ཁ་ལས་ཐོབ་པའི་ ངོ་རྒྱན་ཚུ།';
$string['externalconnectto'] = 'ཁྱོད་དགོ་པའི་ ཕྱིའི་ངོ་རྒྱན་ཚུ་དངོས་སུ་སྟོན་ནིའི་དོན་ལུ་ <a href="{$a}">connect to a backpack</a> འབྲེལ་འཐུད་འབད།';
$string['fixed'] = 'ཟླ་ཚེས་གཏན་འབེབས།';
$string['hidden'] = 'གཡིབ་ཡོདཔ།';
$string['hiddenbadge'] = 'སྟབས་ཉེསཔ་ལས་བརྟེན་ཏེ་ ངོ་རྒྱན་འཆང་མི་དེ་གིས་ ཨ་ནི་གནས་ཚུལ་དེ་ ཐོབ་ཚུགསཔ་མ་བཟོ་བས།';
$string['issuancedetails'] = 'ངོ་རྒྱ་ཆ་འཇོག་རྫོགས་དུས་ཚོད།';
$string['issuedbadge'] = 'ངོ་རྒྱན་སྤྲོད་ཡོད་པའི་ བརྡ་དོན་གནས་ཚུལ།';
$string['issuerdetails'] = 'སྤྲོད་མི་གི་གནས་ཚུལ་རྒྱས་བཤད།';
$string['issuername'] = 'སྤྲོད་མི་གི་མིང་།';
$string['issuername_help'] = 'སྤྲོད་མི་གི་ངོ་ཚབ་དང་དབང་འཛིན།';
$string['issuerurl'] = 'སྤྲོད་མི་གི་URL';
$string['localbadges'] = '{$a} ཡོངས་འབྲེལ་ལས་ངེ་གི་ངོ་རྒྱན།';
$string['localbadgesh'] = 'ཡོངས་འབྲེལ་འདི་ལས་ངེ་གི་ངོ་རྒྱན།';
$string['localbadgesh_help'] = 'ཨ་ནི་གློག་རིག་གནས་ཁོངས་ནང་གི་ངོ་རྒྱན་ཐོབ་མི་ཚུ་ཆ་མཉམ་ སློ་ཚན་མཇུག་བསྡུ་དེ་ལས་ སློབ་ཚན་གྱི་བྱེད་ལས་ཚུ་མཇུག་བསྡུ་ནི་ དེ་ལས་གཞན་མཁོ་ཆས་ཚུ་མཇུག་བསྡུ་མི་ཚུ་ཨིན། ཁྱོད་ཀྱི་ངོ་རྒྱན་དེ་ སྒེར་མཐོང་དང་ དམངས་མཐོང་གང་རུང་ཅིག་ ཁྱོད་རའི་བློ་འདོད་བསྟར་འཛིན་སྐྱོང་འབད་ཚུགས། ཁྱོད་ཀྱ་ངོ་རྒྱན་ཚུ་ ག་ར་སྟབས་གཅིག་གུ་ཡང་ན་རེ་རེ་བཞིན་དུ་ཕབ་ལེན་འབད་ཞིནམ་ལས་ ཁྱོད་རའི་སྒེར་གི་ གློག་རིག་རྩིས་ཁོར་ནང་བསྲུང་བཞག་ཚུགས། ཕབ་ལེན་འབད་མི་ཚུ་ ཁྱོད་རའི་ཕྱིའི་backpackཞབས་ཏོག་ནང་ བཀོད་བཞག་བཏུབ།';
$string['localbadgesp'] = '{$a}:ལས་ངོ་རྒྱན།';
$string['localconnectto'] = 'ཨནི་ངོ་རྒྱན་ཚུ་ གནས་ཁོངས་འདི་གི་ཕྱི་ཁར་མཉམ་སྤྱོད་འབད་ནིའི་དོན་ལུ་ <a href="{$a}">དེ་ backpack</a>.དང་འཐུད་དགོ';
$string['makeprivate'] = 'སྒེར་དབང་བཟོ།';
$string['makepublic'] = 'མི་མང་གི་བཟོ།';
$string['managebadges'] = 'ངོ་རྒྱན་འཛིན་སྐྱོང་འབད།';
$string['message'] = 'འཕྲིན་ཡིག་ གཟུགས་ངོ།';
$string['messagebody'] = '<p>ཁྱོད་ལུ་ ངོ་རྒྱན་"%badgename%"!</p> <p>སྤྲོད་ཡོད། ངོ་རྒྱན་དེ་གི་གནས་ཚུལ་རྒྱས་བཤད་དེ་ %badgelink%.</p> <p>ནང་མཐོང་ཚུགས། {$a}.</p>དེ་ཁ་ལས་ངོ་རྒྱན་དེ་ཕབ་ལེན་འབད་ཚུགས།';
$string['messagesubject'] = 'ཁྱོད་ཀྱིས་ངོ་རྒྱན་དེ་ཐོབ་ཡོད། བཀྲ་ཤིས་བདེ་ལེགས།';
$string['method'] = 'ཚད་གཞི་འདི་ནམ་མཇུག་བསདུ་ཡི་ག';
$string['mingrade'] = 'སྐུགས་ཚད་ཉུང་མཐའ་དགོཔ།';
$string['month'] = 'ཟླཝ།';
$string['mybackpack'] = 'ངེ་གི་backpackགཞི་སྒྲིག';
$string['mybadges'] = 'ངེ་གི་ངོ་རྒྱན';
$string['never'] = 'རྩ་ལས་མེདཔ།';
$string['newbadge'] = 'ངོ་རྒྱན་གསརཔ་ཅིག་ཁ་སྐོང་བཀོད།';
$string['newimage'] = 'པར་གསརཔ།';
$string['noawards'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་ ད་ལྟོ་ཚུན་ཐོབ་དེ་མེད།';
$string['nobackpack'] = '<br/>གི་རྩིས་ཐོ་དང་འབྲེལ་འཐུད་འབད་ནིའི་དོན་ལུ་ backpackཞབས་ཏོག་དེ་ མིན་འདུག';
$string['nobackpackbadges'] = 'ཁྱོད་ཀྱིས་གདམ་ཁ་འབད་མི་ མཛོད་<a href="mybackpack.php">Add more collections</a>.འདི་ནང་ ངོ་རྒྱན་དེ་ཚུ་མིན་འདུག';
$string['nobackpackcollections'] = 'ངོ་རྒྱན་གྱི་མཛོང་ག་ནི་ཡང་གདམ་ཁ་མ་འབད་བས།<a href="mybackpack.php">Add collections</a>.';
$string['nobadges'] = 'ངོ་རྒྱན་ཚུ་ མིན་འདུག';
$string['nocriteria'] = 'ཨ་ནི་ངོ་རྒྱན་གྱི་དོན་ལས་ ད་ཚུན་ ཚད་གཞི་མ་བཟོ་བས།';
$string['noexpiry'] = 'ཨ་ནི་ངོ་རྒྱན་གྱི་དོན་ལས་ ཆ་འཇོག་རྫོགས་ནིའི་དུས་ཡུན་མིན་འདུག';
$string['noparamstoadd'] = 'ཨ་ནི་ངོ་རྒྱན་གྱི་དོན་ལུ་ ཚད་གཞི་ཁ་སྐོང་འབད་དགོཔ་ག་ནི་ཡང་མིན་འདུག';
$string['notacceptedrole'] = 'ཁྱོད་ཀྱི་སྐབས་ཐོག་གི་ལས་འགན་འདི་ ངོ་རྒྱན་རང་ཤུགས་ཀྱི་སྤྲོད་མིའི་གྲངས་སུ་མིན་འདུག <br/>ལག་ལེན་པ་ངོ་རྒྱན་ཐོབ་མི་ཚུ་བལྟ་དགོ་པ་ཅིན་ {$a}གི་ངོ་ཤོག་ནང་བལྟ་གནང་།';
$string['notconnected'] = 'མ་འཐུད་པས།';
$string['nothingtoadd'] = 'ཁ་སྐོང་འབད་ནིའི་དོན་ ཚད་གཞི་ག་ནི་ཡང་མིན་འདུག';
$string['notification'] = 'ངོ་རྒྱན་བཟོ་མིའི་དོན་ལས་ བརྡ་འཕྲིན་བྱིན།';
$string['notification_help'] = 'ཨ་ནིོ་གཞི་སྒྲི་དེ་གིས་ ངོ་རྒྱན་བཟོ་མི་དེ་ལུ་ ངོ་རྒྱན་དེ་སྤྲོད་ཡོད་ཟེར་ བརྡ་འཕྲིན་སྐྱེལ་ནི་ལུ་འཛིན་སྐྱོང་འབདཝ་ཨིན། དེ་ནང་ལུ་གདམ་ཁ་ཅན་  * **NEVER** ཟེར་བརྡ་འཕྲིན་སྐྱེལ་མ་དགོཔ།  * **EVERY TIME** ཟེར་ནམ་ངོ་རྒྱན་སྤྲོདཔ་ཅི་བརྡ་འཕྲིན་སྐྱེལ་ནི་ * **DAILY**ཟེར་ཉིན་བསྟར་བཞིན་དུ་ཚར་རེ་སྐྱེལ་ནི་  * **WEEKLY** ཟེར་བདུན་ཕྲག་རེ་ལུ་ཚར་ར་ེ་སྐྱེལ་ནི་ དེ་ལས་ * **MONTHLY**ཟེར་ཟླ་རིམ་བཞིན་དུ་ཚར་རེ་སྐྱེལ་ནི་ཚུ་ཡོད།';
$string['notifydaily'] = 'ཨ་རྟག་ར།';
$string['notifyevery'] = 'དུས་ནམ་རང་།';
$string['notifymonthly'] = 'ཟླ་རིམ་བཞིན་དུ།';
$string['notifyweekly'] = 'བདུན་ཕྲག་བཞིན་དུ།';
$string['numawards'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་ ལག་ལེན་པ་<a href="{$a->link}">{$a->count}</a> user(s)ལུ་སྤྲོད་ཡོད།';
$string['numawardstat'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་ ལག་ལེན་པ་ {$a} ལུ་སྤྲོད་ཡོད།';
$string['overallcrit'] = 'གདམ་ཁ་འབད་ཡོད་མི་ ཚད་གཞི་ཚུ་ལས་ འདི་མཇུགབསྡུ་ཡི།';
$string['personaconnection'] = 'ཁྱོད་རའི་གློག་འཕྲིན་ཁ་བྱང་ལས་ འཛུལ་ཞུགས་འབད།';
$string['personaconnection_help'] = 'Persona ཟེར་མི་འདི་ ཁྱོད་རའི་གློག་ཕྲིན་ཁ་བྱང་དེ་ལག་ལེན་ཐོག་ ཡོངས་འབྲེལ་གེ་རང་ནང་ ཁྱོད་རང་ངོས་འཛིན་ཚུགས་པའི་ རྒྱུད་ཁོངས་ཅིག་ཨིན། Persona རྩི་ཐོ་དང་འབྲེལ་འཐུད་བཞག་ནིའི་དོན་ལུ་ Open Badges backpackགིས་ ནང་འཛུལ་གི་དོན་ལུ་Persona འདི་ལག་ལེན་འཐབ་ཨིན། གནས་ཚུལ་རྒྱས་བཤད་ཀྱི་དོན་ལུ་  <a href="https://login.persona.org/about">https://login.persona.org/about</a>.བལྟ་གནང་།';
$string['potentialrecipients'] = 'ངོ་རྒྱན་ཐོབ་ནིའི་འོས་བབ་ཡོད་མི།';
$string['recipientdetails'] = 'ངོ་རྒྱན་ཐོབ་མིའི་ ངོ་སྤྲོད་རྒྱས་པ།';
$string['recipientidentificationproblem'] = 'ད་ལྟོའི་་ལག་ལེན་ཚུ་ལས་ ཨ་ནི་ངོ་རྒྱན་ཐོབ་མི་མིན་འདུག';
$string['recipients'] = 'ངོ་རྒྱན་ཐོབ་མི་ཚུ།';
$string['recipientvalidationproblem'] = 'ད་ལྟོའི་ ལག་ལེན་འཐབ་མི་འདི་ ངོ་རྒྱན་ཐོབ་མི་ཨིན་ཟེར་ གཏན་འབེབས་སྦེ་བདེན་དཔྱད་མི་འབད་བས།';
$string['relative'] = 'ལྟོས་ཁྱད་ཀྱི་ཟླ་ཚེས།';
$string['requiredcourse'] = 'སློབ་ཚན་གྱི་ཚད་གཞི་ནང་ལུ་ སློབ་ཚན་ཅིག་དེ་མ་པ་ལས་བཀོད་དགོ';
$string['reviewbadge'] = 'ངོ་རྒྱན་འཛུལ་ཞུགས་ཀྱི་གྱུར་བ།';
$string['reviewconfirm'] = '<p>དེ་གིས་ ཀྱོད་ཀྱི་ངོ་རྒྱན་དེ་མཐོང་ཚགས་བཟོ་ཞིནམ་ལས་ གཞན་མི་ཚུ་ཡང་ ཐོབ་ཚུགསཔ་བཟོཝ་ཨིན། མི་ལ་ལུ་ཅིག་ ཚད་གཞི་འདི་ཚང་ཡོདཔ་འོང་ནི་ཨིནམ་ལས་ ཁྱོད་ཀྱིས་ཨ་ནི་འདི་ལྕོགས་ཅན་བཟོཝ་ཅི་ དེ་་འཕྲོ་ལས་རང་ངོ་རྒྱན་འདི་སྤྲོད་ཚུགས། </p> <p>ངོ་རྒྱན་དེ་ཚརཅིག་སྤྲོད་ཞིནམ་ལས་ <strong>locked</strong>ཁོ་བསྡམ་བཞག་འོང་། དེ་ནང་ལུ་ གཞི་སྒྲིག་ ཆ་འཇོག་མེད་པའི་དུས་ཚོད་ལ་སོགས་པ་ཚུ་སོར་མི་བཏུབ། </p> <p>ཁྱོད་ཨ་ནི་འདི་ངོ་རྒྱན་\'{$a}\'?</p>ལུ་ལྕོགས་ཅན་བཟོ་ནི་གཏན་གཏན་ཨིན་ན།';
$string['save'] = 'བསྲུང་།';
$string['searchname'] = 'མིང་གིས་སྦེ་འཚོལ།';
$string['selectaward'] = 'ངོ་རྒྱན་སྤྲོདཔ་ད་ ལས་འགན་ག་ཅི་འབག་ནི་ཨིན་ན་ གདམ་ཁ་འབད།';
$string['selectgroup_end'] = 'མི་མང་ཀྱི་ཕྱོགས་བསྡུ་རྐྱངམ་ཅིག་སྟོན་ཡོད། མི་མང་ཕྱོགས་བསྡུ་མེམ་བཟོ་ནིའི་དོན་ལུ་ <a href="http://backpack.openbadges.org">visit your backpack</a>';
$string['selectgroup_start'] = 'ཁྱོད་ཀྱིbackpack་ནང་ལས་ཕྱོགས་བསྡུས་ གནས་ཁོངས་ནང་ དངོས་སྟོན་འབད་དགོ་མནོ་མི་ གདམ་ཁ་རྐྱབ།';
$string['selecting'] = 'ངོ་རྒྱན་གདམ་ཁའབད་ཡོད་མི་དང་ཆ།';
$string['setup'] = 'གཞི་སྒྲིག་བཟོ།';
$string['signinwithyouremail'] = 'ཁྲོད་རའི་གློག་འཕྲིན་ཁ་བྱང་དང་ཆ་ འཛུལ་ཞུགས་འབད།';
$string['sitebadges'] = 'གནས་ཁོངས་ངོ་རྒྱན་ཚུ།';
$string['sitebadges_help'] = 'གནས་ཁོངས་ངོ་རྒྱན་དེ་ གནས་ཁོངས་དང་འབྲེལ་བ་ཡོད་པའི་ བྱེད་ལས་ལུ་རྐྱངམ་ཅིག་སྤྲོདཔ་ཨིན། སློབ་ཚན་ཚུ་མཇུག་བསྡུ་ནི་དང་ ལག་ལེན་པའི་ངོ་སྤྲོད་མདོར་དསྡུས་ཚུ་ཡང་དེ་ནང་ཚུདཔ་ཨིན། གནས་ཁོངས་ངོ་རྒྱན་ཚུ་གཞན་ལུ་་རང་ཤུགས་ཐོག་ཡང་སྤྲོད་བཏུབ། སློབ་ཚན་དང་འབྲེལ་ཡོད་ཀྱི་ངོ་རྒྱན་ཚུ་ སློབ་ཚན་གྱི་གནས་རིམ་ཁར་བཟོ་དགོ་ སློབ་ཚན་ངོ་རྒྱན་ཚུ་ སློབ་ཚན་བདག་སྐྱོང་ངོ་རྒྱན་འོག་ཐོབ་ཚུགས།';
$string['status'] = 'ངོ་རྒྱན་གྱི་གནས་རིམ།';
$string['status_help'] = 'ངོ་རྒྱན་གྱི་གནས་རིམ་དེ་གིས་ རིམ་ལུགས་ནང་གི་ཁོ་གི་བྱ་སྤྱོད་དང་སྤྱོད་ལུགས་དེ་ གཏན་འབེབས་འབདའབད་འོང་།  * **AVAILABLE**ཟེར་མི་འདི་ ངོ་རྒྱན་དེ་ལག་ལེན་པ་ཚུ་གིས་ཐོབ་ཚུགས་ནི། ཐོབ་ཚུགསཔ་ཨིན་རུང་ ཚད་གཞི་ཚུ་གྱུར་བཅོས་འབད་མི་བཏུབ། **NOT AVAILABLE** ཟེར་བ་ཅིན་ ལག་ལེན་པ་ཚུ་གིས་ཐོབ་མི་ཚུགས་ནི་དང་ རང་ཤུགས་ཐོག་ཡང་སྤྲོད་མི་བཏུབ་ནི་ཨིན། ཨ་ནི་བཟུམ་མའི་ངོ་རྒྱན་དེ་ཧེ་མ་སྤྲོད་ེ་མེད་པ་ཅིན་ ཚད་གཞི་ཚུ་གྱུར་བཅོས་འབད་བཏུབ། ཚར་ཅིག་ལག་ལེན་པ་ཅིག་ལུ་རང་བྱིན་ཏེ་འབད་རུང་ ངོ་རྒྱན་དེ་ཆོགལྡེ་འོག་ཚུདཔ་ཨིན། ཆོག་ལྡེ་འོག་ཡོད་མི་ངོ་རྒྱན་དེ་ ལག་ལེན་པ་ཚུ་གིས་ཐོབ་ཚུགས་རུང་ ཚད་གཞི་ཚུ་གྱུར་བཅོས་འབད་མི་བཏུབ་ནི་ཨིན། ངོ་རྒྱན་ཚུ་ག་ཅི་སྦེ་ཆོག་ལྡེ་འོག་བཙུགསཔ་སྨོ། ལག་ལེན་པ་ཆ་མཉམ་རང་ མཁོ་བའི་ཁྱད་ཆོས་ ཚང་དགོཔ་བཟོ་ནི། སྐབས་ཐོག་ངོ་རྒྱན་ཚུ་ཆ་མེད་གཏང་མི་ཚུགས་ནི་དང་། དགོ་པའི་མཁོ་ཆོས་ཆ་མཉམ་གྱུར་བཅོས་འབད་བཅུག་པ་ཅིན་ ལག་ལེན་པ་ཁྱད་ཆོས་དང་ཚང་དགོཔ་མ་འདྲཝ་ཡོད་མི་དེ་ཚུ་ལུ་ལུ་ ངོ་རྒྱན་གཅིག་སྤྲོད་ནི་གི་ཉེན་ཁ་ཡོདཔ་ཨིན།';
$string['statusmessage_0'] = 'ཨ་ནི་ངོ་རྒྱ་དེ་ སྐབས་ཐོག་ ལག་ལེན་པ་ལུ་ཐོབ་དབང་མེད། ལག་ལེན་པ་ཚུ་ངོ་རྒྱན་ཐོབ་བཅུག་ནིའི་རེ་འདོད་ཡོད་པ་ཅིན་ ལྟ་སྤྱོད་དེ་ ལྕོགས་ཅན་བཟོ།';
$string['statusmessage_1'] = 'ཨ་ནི་ངོ་རྒྱ་དེ་ སྐབས་ཐོག་ ལག་ལེན་པ་ལུ་ཐོབ་དབང་ཡོད། སོར་དགོཔ་ཡོད་པ་ཅིན་ ལྕོགས་མིན་བཟོ་ད།';
$string['statusmessage_2'] = 'ཨ་ནི་ངོ་རྒྱ་དེ་ སྐབས་ཐོག་ ལག་ལེན་པ་ལུ་ཐོབ་དབང་མེད། དེ་ལས་ཚད་གཞི་ཚུ་ཆོག་ཡིག་གིས་བསྡམ་ཡོད། ལག་ལེན་པ་ཚུ་ངོ་རྒྱན་ཐོབ་བཅུག་ནིའི་རེ་འདོད་ཡོད་པ་ཅིན་ ལྟ་སྤྱོད་དེ་ ལྕོགས་ཅན་བཟོ།';
$string['statusmessage_3'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་ལག་ལེན་པ་ཚུ་ལུ་ཐོབ་ཆོགཔ་ཡོད་ ཨིན་རུང་ཚད་གཞི་ཚུ་ཆོག་ཡིག་གིས་བསྡམ་ཡོད།';
$string['statusmessage_4'] = 'ངོ་རྒྱན་དེ་ སྐབས་ཅིག་ མཛོད་ནང་བསྡམ་ཡོད།';
$string['subject'] = 'ཡིག་འཕྲིན་གྱི་རྩ་དོན།';
$string['variablesubstitution'] = 'ཡིག་འཕྲིན་ནང་ལུ་ འགྱུར་ལྡོག་ཅན་གྱི་ཚབ་མ།';
$string['variablesubstitution_help'] = 'ངོ་རྒྱན་གྱི་འཕྲིན་ཡིག་ནང་ལུ་ འགྱུར་ལྡོག་ཅན་ལ་ལུ་ཅིག་བཙུགས་བཏུབ་ དེ་ཡང་ཡིག་འཕྲིག་གི་ དོན་ངོ་མ་དང་ རྩ་དོན་སོགས་ག་ཅི་ནང་ཡང་བཏུབ་ཨིནམ་དང་ ཡིག་འཕྲིན་དེ་སྐྱེལཝ་ད་ དོན་ངོ་མ་དང་ རྗེ་སོར་འབད་ནིའི་དོན་ལས་ཨིན། འགྱུར་ལྡོག་ཅན་ཚུ་འོག་ལུ་འཁོད་ཡོད་དོ་བཟུམ་བཙུགས་དགོ་ འོག་ལུ་ཡོད་མི་འགྱུར་ལྡོག་ཅན་ལག་ལེན་འཐབ་ཚགས། ཨ་ནི་འདི་ ངོ་རྒྱན་གྱི་མིང་ %username% :གི་ཚབ་བཙུགས་བཏུབ། དེ་ཡང་་ཐོབ་མི་གི་མིང་%badgelink% :གི་ཚབ་བཙུགས་བཏུབ། ཨ་ནི་འདི་ མི་མང་ གི་URLགནས་ཚུལ་དང་སྦྲགས་ཏེ་ཚབ་བཙུགས་བཏུབ།';
$string['viewbadge'] = 'བྱིན་མི་ངོ་རྒྱན་ཚུ་བལྟ།';
$string['visible'] = 'དངོས་མཐོང་ཅན།';
$string['warnexpired'] = 'ཨ་ནི་ངོ་རྒྱན་དེ་ ཆ་འཇོག་དུས་ཡུན་ཚང་ནུག';
$string['year'] = 'ལོ་གྲངས།';
