<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   backup
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['autoactivedescription'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་ཚུ་འབན་ནི་ཨིན་ན་མེན་གདམ་ཁ་བརྐྱབ། ལག་ཐོག་འདི་སེལ་འཐུ་འབད་བ་ཅིན་རྒྱབ་སྣོན་ཚུ་འབད་ནི་དེ་རང་བཞིན་གྱི་རྒྱབ་སྣོན་ CLI script་གིས་ཐོག་ལས་འབད་ཚུགས། འདི་ལག་ཐོག་བཀོད་ལམ་ཡང་ན་cron་གིས་ཐོག་ལས་སྤྱོད་བཚུགས།';
$string['autoactivedisabled'] = 'ལྕོགས་མིན་བཟོ་ཡོདཔ།';
$string['autoactiveenabled'] = 'ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
$string['autoactivemanual'] = 'ལག་ཐོག';
$string['automatedbackupschedule'] = 'འཆར་རིམ།';
$string['automatedbackupschedulehelp'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་ཚུ་བདུན་ཕྲག་གི་ཉིམ་ནམ་འབད་ནི་ཨིན་ན་གདམ་ཁ་བརྐྱབ།';
$string['automatedbackupsinactive'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་ཚུ་ས་ཁོགས་བདག་སྐྱོང་གི་ལྕོགས་ཅན་མ་བཟོ་བས།';
$string['automatedbackupstatus'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་གནས་ཚད།';
$string['automatedsettings'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་འབད་གཞི་སྒྲིག་ཚུ།';
$string['automatedsetup'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་འབད་གཞི་སྒྲིག';
$string['automatedstorage'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་འབད་བསག་མཛོད།';
$string['automatedstoragehelp'] = 'རྒྱབ་སྣོན་ཚུ་རང་བཞིན་གྱིས་གསར་བསྐྲུན་འབད་བའི་བསྐབ་གནས་ཁོངས་ག་ཏེ་བསྲུང་བཞག་ནི་ཨིན་ན་གདམ་ཁ་བརྐྱབ།';
$string['backupactivity'] = 'སྦྱོང་ལཱ: {$a}་རྒྱབ་སྣོན་འབད།';
$string['backupcourse'] = 'སློབ་ཚན: {$a}་རྒྱབ་སྣོན་འབད།';
$string['backupcoursedetails'] = 'སློབ་ཚན་གྱི་རྒྱས་བཤད་ཚུ།';
$string['backupcoursesection'] = 'དབྱེ་ཚན: {$a}';
$string['backupcoursesections'] = 'སློབ་ཚན་གྱི་དབྱེ་ཚན་ཚུ།';
$string['backupdate'] = 'ཚེས་གྲངས་གདམ་ཁ་བརྐྱབ་ཡོདཔ།';
$string['backupdetails'] = 'རྒྱབ་སྣོན་རྒྱས་བཤད་ཚུ།';
$string['backupdetailsnonstandardinfo'] = 'སེལ་འཐུ་གྲུབ་པའི་ཡིག་སྣོད་འདི་ ཚད་ལྡན་Moodle་གིས་རྒྱབ་སྣོན་ཡིག་སྣོད་ མེན་པས། སོར་ཆུད་ལས་སྦྱོར་གྱི་རྒྱབ་སྣོན་ཡིག་སྣོད་དེ་ཚད་ལྡན་རྩ་སྒྲིག་ལུ་འབད་ཞིནམ་ལས་སོར་ཆུད་འབད་འོང་།';
$string['backupformat'] = 'རྩ་སྒྲིག';
$string['backupformatimscc1'] = 'MS མཐུན་མོང Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS མཐུན་མོང་ Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'རྩ་སྒྲིག་ མ་ཤེསཔ།';
$string['backuplog'] = 'འཕྲུལ་རིག་གི་བརྡ་དོན་དང་ཉེན་བརྡ།';
$string['backupmode'] = 'གནས་ཐངས།';
$string['backupmode10'] = 'ཡོངས་ཁྱབ།';
$string['backupmode20'] = 'ནང་འདྲེན་འབད།';
$string['backupmode30'] = 'ལྟེ་བ།';
$string['backupmode40'] = 'ས་ཁོངས་ཅོག་འཐདཔ།';
$string['backupmode50'] = 'རང་བཞིན་གྱི་འབད་ཡོདཔ།';
$string['backupmode60'] = 'གཞི་བསྒྱུར་འབད་ཡོདཔ།';
$string['backupsection'] = 'སློབ་ཚན་གྱི་དབྱེ་ཚན་{$a}གིས་རྒྱབ་སྣོན་འབད།';
$string['backupsettings'] = 'གཞི་སྒྲིག་རྒྱབ་སྣོན་འབད།';
$string['backupsitedetails'] = 'ས་ཁོགས་རྒྱས་བཤད་ཚུ།';
$string['backupstage16action'] = 'འཕྲོ་མཐུད།';
$string['backupstage1action'] = 'ཤུལ་མམ།';
$string['backupstage2action'] = 'ཤུལ་མམ།';
$string['backupstage4action'] = 'རྒྱབ་སྣོན་འབད།';
$string['backupstage8action'] = 'འཕྲོ་མཐུད།';
$string['backuptype'] = 'དབྱེ་བ།';
$string['backuptypeactivity'] = 'སྦྱོང་ལཱ།';
$string['backuptypecourse'] = 'སློབ་ཚན།';
$string['backuptypesection'] = 'དབྱེ་ཚན།';
$string['backupversion'] = 'རྒྱབ་སྣོན་ཐོན་རིམ།';
$string['cannotfindassignablerole'] = 'རྒྱབ་སྣོན་ཡིག་སྣོད་ནང་{$a}་ལས་འགན་འདི་ལས་འགན་ཅིག་སྤྲོད་ཡོད་མི་དང་འཁྲིལ་ཏི་ས་ཁྲ་བཟོ་མ་ཚུགས།';
$string['choosefilefromactivitybackup'] = 'སྦྱོང་ལཱ་གི་རྒྱབ་སྣོན་ས་གོ།';
$string['choosefilefromactivitybackup_help'] = 'རྒྱབ་སྣོན་སྦྱོང་ལཱ་ཚུ་གིས་སྔོན་མའི་གཞི་སྒྲིག་དེ་ལག་ལེན་འཐབ་ད་ རྒྱབ་སྣོན་ཡིག་སྣོད་ཚུ་ནཱ་ལུ་བསྲུང་བཞག་འོང་།';
$string['choosefilefromautomatedbackup'] = 'རང་བཞིན་གྱི་འབད་ཡོད་པའི་རྒྱབ་སྣོན་ཚུ།';
$string['choosefilefromautomatedbackup_help'] = 'རང་བཞིན་གྱིས་བཟོ་བཏོན་འབད་ཡོད་པའི་ རྒྱབ་སྣོན་ཚུ་ཡོདཔ་ཨིན།';
$string['choosefilefromcoursebackup'] = 'སློབ་ཚན་གི་རྒྱབ་སྣོན་ས་གོ།';
$string['choosefilefromcoursebackup_help'] = 'རྒྱབ་སྣོན་སློབ་ཚན་ཚུ་གིས་སྔོན་མའི་གཞི་སྒྲིག་དེ་ལག་ལེན་འཐབ་ད་ རྒྱབ་སྣོན་ཡིག་སྣོད་ཚུ་ནཱ་ལུ་བསྲུང་བཞག་འོང་།';
$string['choosefilefromuserbackup'] = 'ལག་ལེན་པའི་སྒེར་དོན་རྒྱབ་སྣོན་ས་གོ།';
$string['choosefilefromuserbackup_help'] = 'རྒྱབ་སྣོན་སློབ་ཚན་ཚུ་ནང་"མིང་མེད་ལག་ལན་པའི་བརྡ་དོན་" གིས་གདམ་ཁ་བདེན་རྟགས་བཀོད་ཡོད་པ་ཅིན་ རྒྱབ་སྣོན་ཡིག་སྣོད་ཚུ་ནཱ་ལུ་བསྲུང་བཞག་འོང་།';
$string['configgeneralactivities'] = 'སྦྱོང་ལཱ་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneralanonymize'] = 'འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པ་ཚུ་ལོ་རྒྱུས་གེ་ར་ སྔོན་སྒྲིག་གིས་མིང་མེདཔ་བཟོ་འོང་།';
$string['configgeneralbadges'] = 'རྒྱབ་སྣོན་གྱི་ནང་ན་ ངོ་རྒྱན་ཁོངས་རྟོགས་ཚུགས་བཟོ་ནིའི་དོན་ལུ་ སྔ་སྒྲིག་གི་ གཞི་སྒྲིག་བཙུགསཔ་ཨིན།';
$string['configgeneralblocks'] = 'སྡེབ་ཚན་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneralcomments'] = 'བསམ་བཀོད་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneralfilters'] = 'ཚགས་མ་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneralhistories'] = 'ལག་ལེན་པ་གིས་འདས་པའི་ལོ་རྒྱུས་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgenerallogs'] = 'འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ དྲན་དེབ་ཚུ་རྒྱབ་སྣོན་གྱི་གྲངས་སུ་བཙུགས་ནི་དོན་ལུ་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneralquestionbank'] = 'ལྕོགས་ཅན་བཟོ་སྟེ་ཡོད་པ་ཅིན་ དྲི་བའི་མཛོད་དེ་ རང་བཞིན་གྱིས་རྒྱབ་སྣོན་གྱི་གྲལ་ཁར་་གཏོགསཔ་ཨིན། གཞི་སྒྲིགདེ་ལྕོགས་མིན་བཟོ་ད་པ་ཅིན་ རྒྱབ་སྣོན་དང་དེའི་བྱེདལས་ དྲི་བའི་མཛོད་ལག་ལེན་འབད་སྤྱོད་གཏང་མི་གེ་ར་ ལྕོགས་མིན་ལུ་གྱུར་ཏེ་ རིག་བསྡུར་གྱི་དྲི་བ་དྲིས་ལན་སོགས་ཡང་ལྕོགས་མིན་འགྱོཝ་ཨིན།';
$string['configgeneralroleassignments'] = 'སྔོན་སྒྲིག་ལས་འགན་ཚུ་གིས་འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལས་འགུལ་ཚུ་རྒྱབ་སྣོན་འབད་འོང།';
$string['configgeneralusers'] = 'ལག་ལེན་པ་ཚུ་རྒྱབ་སྣོན་གྱི་ནང་བཙུགས་ན་མི་བཙུགས་ སྔོན་སྒྲིག་གིས་གཞི་སྒྲིག་འབད་འོང།';
$string['configgeneraluserscompletion'] = 'འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པའི་བརྡ་དོན་ཆ་ཚང་སྦེ་རྒྱབ་སྣོན་ཚུ་སྒྲིག་གིས་བཙུགས་འོང།';
$string['configloglifetime'] = 'འདི་གིས་རྒྱབ་སྣོན་གྱི་བརྡ་དོན་དྲན་དེབ་ཚུ་ཆུ་ཚོད་དུས་ཡུན་ག་དེམ་ཅིག་བདག་འཛིན་སྦེ་བཞག་ནི་ཨིན་ན་གསལ་བཀོད་འབད་འོང་། ལོ་ཚད་འདི་གི་ཧེ་མའི་དྲན་དེབ་ཚུ་རང་བཞིན་གྱིས་བཏོན་གཏངམ་ཨིན། འདི་གིས་གནས་གོང་དེ་ཆུང་ཀུ་སྦེ་བཞག་དགོ་ ག་ཅི་སྦེ་ཟེར་བ་ཅིན་རྒྱབ་སྣོན་འབད་ཚར་བའི་དྲན་དེབ་བརྡ་དོན་སྦོམ་ཐལ་འོང་།';
$string['confirmcancel'] = 'རྒྱབ་སྣོན་འབད་ནི་ཆ་མེད་གཏང་།';
$string['confirmcancelno'] = 'སྡོད།';
$string['confirmcancelquestion'] = 'ཆ་མེད་གཏང་ནི་རེ་སྨོན་ཡོད་ག? ཁྱོད་ཀྱི་བཙུགས་མི་བརྡ་དོན་ག་ཅི་ཨིན་རུང༌བརླག་སྟོར་ཞུགས་འོང་།';
$string['confirmcancelyes'] = 'ཆ་མེད་གཏང་།';
$string['confirmnewcoursecontinue'] = 'སློབ་ཚན་གསརཕ་གིས་ཉེན་བརྡ།';
$string['confirmnewcoursecontinuequestion'] = 'སློབ་ཚན་སོར་ཆུད་འབད་ནིའི་ལས་སྦྱོར་གྱི་ གནས་སྐབས་ཀྱི་(སྦ་བཞག་པའི་)སློབ་ཚན་གསར་བསྐྲུན་འབད་འོང་། སོར་ཆུད་འབད་ནི བར་བཤོལ་བཞངག་ནི་ལུ་ ཆ་མེད་གཏང་ནི་ཨེབ་གཏང་། སོར་ཆུད་འབད་བའི་བསྐབ་ Browserདེ་ཁ་མ་བསྡམས།';
$string['coursecategory'] = 'དབྱེ་རིམ་དེ་ནང་ལུ་སློབ་ཚན་འདི་སོར་ཆུད་འབད།';
$string['courseid'] = 'ID་ངོ་མ།';
$string['coursesettings'] = 'སློབ་ཚན་གཞི་སྒྲིག་ཚུ།';
$string['coursetitle'] = 'མགོ་མིང་།';
$string['currentstage1'] = 'འགོ་ཐོག་གཞི་སྒྲིག་ཚུ།';
$string['currentstage16'] = 'ཆ་ཚང་།';
$string['currentstage2'] = 'ལས་འཆར་གཞི་སྒྲིག་ཚུ།';
$string['currentstage4'] = 'ངེས་དཔྱད་དང་བསྐྱར་ཞིབ།';
$string['currentstage8'] = 'རྒྱབ་སྣོན་འབད།';
$string['enterasearch'] = 'འཚོལ་ཞིབ་འབད་ནི་ཅིག་བཙུགས།';
$string['error_block_for_module_not_found'] = 'སློབ་ཚན་ཚད་གཞི་(id: {$a->mid})་གིས་ Orphan་སྡེབ་ཚན་མཚོན་དཔེ: (id: {$a->bid})་ཐོབ་ཡོད། སྡེབ་ཚན་གྱི་རྒྱབ་སྣོན་བཟོ་མི་བཏུབ།';
$string['error_course_module_not_found'] = 'Orphan སློབ་ཚན་ཚད་གཞི་(id: {$a})་ཐོབ་ཡོད།
ཚད་གཞི་གྱི་རྒྱབ་སྣོན་བཟོ་མི་བཏུབ།';
$string['errorfilenamemustbezip'] = 'ཁྱོད་ཀྱི་ཡིག་སྣོད་ཀྱི་མིང་བཙུགས་མི་འདི་ ZIP་ཡིག་སྣོད་དང་.mbz་རྒྱ་བསྐྱེད་ཡོད་མི་དགོ།';
$string['errorfilenamerequired'] = 'ཁྱོད་ཀྱི་རྒྱབ་སྣོན་འདི་ལུ་ནུས་ཅན་ཡིག་སྣོད་ཀྱི་མིང་བཙུགས་དགོ།';
$string['errorinvalidformat'] = 'མ་ཤེས་པའི་རྒྱབ་སྣོན་རྩ་སྒྲིག།';
$string['errorinvalidformatinfo'] = 'སེལ་འཐུ་གྲུབ་པའི་ཡིག་སྣོད་འདི་ ནུས་ཅན་Moodle་རྒྱབ་སྣོན་ཡིག་སྣོད་མེན་ལས་སོར་ཆུད་འབད་མི་བཏུབ།';
$string['errorminbackup20version'] = 'རྒྱབ་སྣོན་འདི་ Moodle ་རྒྱབ་སྣོན་ཡར་འཕར་ཐོན་རིམ་({$a->backup})་གིས་གསར་བསྐྲུན་འབད་ཡོད། ཉུང་མཐའ་{$a->min}་དགོཔ་ཨིན། སོར་ཆུད་འབད་མི་བཏུབ།';
$string['errorrestorefrontpage'] = 'གདོང་ཤོག་གི་ས་ཁར་ སོར་ཆུད་འབད་ནི་མི་ཆོག།';
$string['errortgznozlib'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ ཡིག་སྣོད་ཚུ་ རྒྱབ་སྣོན་གསར་པའི་གཞི་སྒྲིག་ནང་་ཡོདཔ་ལས་ བསྐྱར་གསོ་འབད་མི་བཏུབ་ དེ་སྦེ་མ་བཏུབ་མི་དེ་ཡང་ རིམ་ལུགས་དེ་ནང་ལུ་ zlib PHP extension་མེདཔ་ལས་ཨིན།';
$string['executionsuccess'] = 'རྒྱབ་སྣོན་གྱི་ཡིག་སྣོད་དེ་མཐར་འཁྱོལ་སྦེ་གསར་བསྐྲུན་འབད་ཡོད།';
$string['filealiasesrestorefailures'] = 'མིང་རྫུན་མ་སོར་ཆུད་འཐུས་ཤོར་ཚུ།';
$string['filealiasesrestorefailures_help'] = 'Aliasesཟེར་མི་ཚུ་ ཡིག་གནས་ གཞན་མི་ཚུ་དང་འབྲེལ་མཐུན་གྱི་དོན་ལས་ མཐུན་འབྲེལ་འབད་མི་';
$string['filealiasesrestorefailuresinfo'] = 'རྒྱབ་སྣོན་ཡིག་སྣོད་ཀྱི་གྲངས་སུ་བཙུགས་མི་མིང་རྫུན་མ་ལ་ལོ་ཚུ་སོར་ཆུད་འབད་མ་བཏུབ། ས་ཁོངས་ངོ་མ་ནང་ཡོད་པའི་ གནས་ཁོངས་དང་འབྱུང་ཁུངས་ཡིག་སྣོད འབྲེལ་གཏུགས་འབད་མི་འདི་ འོག་གི་ཐོ་ཡིག་ནང་ཡོད།';
$string['filename'] = 'ཡིག་སྣོད་མིང་།';
$string['filereferencesincluded'] = 'ཕྱིའི་ནང་དོན་ལུ་གཞི་བསྟུན་འབད་ཡོད་མི་ཡིག་སྣོད་དེ་རྒྱབ་སྣོན་ཐུམ་སྒྲིལ་གྲངས་སུ་ཚུད་ཡོདཔ་ལས་ དེ་ས་ཁོངས་གཞན་ན་ལཱ་འབད་མི་བཏུབ།';
$string['filereferencesnotsamesite'] = 'རྒྱབ་སྣོན་འདི་ས་ཁོངས་གཞན་ལས་ཨིན་ཡིག་སྣོད་གཞི་བསྟུན་ཚུ་སོར་ཆུད་འབད་མི་བཏུབ།';
$string['filereferencessamesite'] = 'རྒྱབ་སྣོན་འདི་ས་ཁོངས་གཞན་ལས་ཨིན་ཡིག་སྣོད་གཞི་བསྟུན་ཚུ་སོར་ཆུད་འབད་བཏུབ།';
$string['generalactivities'] = 'སྦྱོང་ལཱ་ཚུ་གྲངས་སུ་བཙུགས།';
$string['generalanonymize'] = 'མིང་མེད་པའི་ལོ་རྒྱུས།';
$string['generalbackdefaults'] = 'ཡོངས་ཁྱབ་རྒྱབ་སྣོན་སྔོན་སྒྲིག་ཚུ།';
$string['generalbadges'] = 'ངོ་རྒྱན་ཚུ་ གྲལ་ཁར་བཙུགས།';
$string['generalblocks'] = 'སྡེབ་ཚན་ཚུ་གྲངས་སུ་བཙུག།';
$string['generalcomments'] = 'བསམ་བཀོད་ཚུ་གྲངས་སུ་བཙུག།';
$string['generalfilters'] = 'བཙག་མ་ཚ་གྲངས་སུ་བཙུག།';
$string['generalgradehistories'] = 'ལོ་རྒྱུས་ཚུ་གྲངས་སུ་བཙུག།';
$string['generalhistories'] = 'ལོ་རྒྱུས་ཚུ་གྲངས་སུ་བཙུག།';
$string['generallogs'] = 'དྲན་དེབ་ཚུ་གྲངས་སུ་བཙུག།';
$string['generalquestionbank'] = 'དྲི་བའི་མཛོད་ཚུ་གྲལ་ཁར་བཙུགས།';
$string['generalroleassignments'] = 'ལས་འགན་སྐལ་ནི་ཚུ་གྲངས་སུ་བཙུག།';
$string['generalsettings'] = 'ཡོངས་ཁྱབ་རྒྱབ་སྣོན་གཞི་སྒྲིག་ཚུ།';
$string['generalusers'] = 'ལག་ལེན་པ་ཚུ་གྲངས་སུ་བཙུག།';
$string['generaluserscompletion'] = 'ལག་ལེན་པ་ཡོངས་སྒྲུབ་པའི་བརྡ་དོན་གྲངས་སུ་བཙུག།';
$string['hidetypes'] = 'དབྱེ་སྡེ་ཚུ་གཡིབ།';
$string['importbackupstage16action'] = 'འཕྲོ་མཐུད།';
$string['importbackupstage1action'] = 'ཤུལ་མམ།';
$string['importbackupstage2action'] = 'ཤུལ་མམ།';
$string['importbackupstage4action'] = 'ནང་འདྲེན་འབད།';
$string['importbackupstage8action'] = 'འཕྲོ་མཐུད།';
$string['importcurrentstage0'] = 'སློབ་ཚན་སེལ་འཐུ་འམད།';
$string['importcurrentstage1'] = 'འགོ་ཐོག་གཞི་སྒྲིག་ཚུ།';
$string['importcurrentstage16'] = 'མཇུག་བསྡུ།';
$string['importcurrentstage2'] = 'ལས་འཆར་གཞི་སྒྲིག་ཚུ།';
$string['importcurrentstage4'] = 'ངེས་དཔྱད་དང་བསྐྱར་ཞིབ།';
$string['importcurrentstage8'] = 'ནང་འདྲེན་འབད།';
$string['importfile'] = 'རྒྱབ་སྣོན་ཡིག་སྣོད་གཅིག་ནང་འདྲེན་འབད།';
$string['importgeneralmaxresults'] = 'ནང་སྐྱོད་འབད་དགོ་པའི་ སློབ་ཚན་གྱི་གྱངས་ཁ་མཐོ་ཤོས།';
$string['importgeneralmaxresults_desc'] = 'ཨ་ནི་དེ་གིས་  སློབ་ཚན་ནང་སྐྱོད་འབད་ནི་འབད་བའི་བྱ་རིམ་གྱི་གོ་རིམ་དང་པའི་སྐབས་ཐོ་བཀོད་འབད་མི་གི་གྱངས་ཁ་ཚུ་དམ་འཛིན་འབདཝ་ཨིན།';
$string['importgeneralsettings'] = 'སྤྱིར་གྱི་ནང་སྐྱོད་འབད་ནི་ཨིན་པའི་སྔ་སྒྲིག';
$string['importsuccess'] = 'ང་འདྲེན་འབད་ཚར་ཡི།';
$string['includeactivities'] = 'གྲངས་སུ་བཙུག:';
$string['includeditems'] = 'དོན་ཚན་ཚུ་གྲངས་སུ་བཙུག་ཡོདཔ་:';
$string['includefilereferences'] = 'ཕྱིའི་ནང་དོན་ལུ་གཞི་བསྟུན་འབད་ཡོད་མི་ཡིག་སྣོད།';
$string['includesection'] = 'དབྱེ་ཚན་{$a}';
$string['includeuserinfo'] = 'ལག་ལེན་པའི་གནས་སྡུད།';
$string['locked'] = 'བསྡམ་བཞག་ཡོད།';
$string['lockedbyconfig'] = '་སྔོན་སྒྲིག་རྒྱབ་སྣོན་གྱི་གཞི་སྒྲིག་ཚུ་ གཞི་སྒྲིགའདི་གིས་བསྡམ་བཞག་ཡོད།';
$string['lockedbyhierarchy'] = 'རྟེན་འབྲེལ་ཚུ་གིས་བསྡམ་བཞག་ཡོད།';
$string['lockedbypermission'] = 'གཞི་སྒྲིག་འདི་བསྒྱུར་བཅོས་འབད་ནི་ཁྱོད་ལུ་གནང་བ་མེད།';
$string['loglifetime'] = 'དོན་ལུ་དྲན་དེབ་ཕཞག།';
$string['managefiles'] = 'རྒྱབ་སྣོན་ཡིག་སྣོད་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['missingfilesinpool'] = 'ཡིག་སྣོད་ལ་ལོ་ཅིག་རྒྱབ་སྣོན་འབད་བའི་བསྐབ་སྲུངས་མ་པཚུགས་ འདི་ཚུ་སོར་ཆུད་འབད་མི་ཚུགས།';
$string['module'] = 'སྦྱོང་ཚན།';
$string['moodleversion'] = 'Moodle ཐོན་རིམ།';
$string['moreresults'] = 'གྲུབ་འབྲས་ལེ་ཤ་འདུག་ དམིགས་བསལ་འཚོལ་ཞིབ་མངམ་བཙུག།';
$string['nomatchingcourses'] = 'བཀྲམ་སྟོན་འབད་ནི་དོན་ལུ་སློབ་ཚན་ཚུ་མེད།';
$string['norestoreoptions'] = 'དབྱེ་རིམ་ཚུ་ཡང་ན་ ད་ལྟོ་ཡོད་པའི་སློབ་ཚན་ཚུ་ ལུ་སོར་ཆུད་འབད་ཚུགསཔ་མེད།';
$string['originalwwwroot'] = 'རྒྱབ་སྣོན་གྱི་URL';
$string['preparingdata'] = 'གནས་སྡུད་བཟོ་བའི་བསྒང་།';
$string['previousstage'] = 'ཧེ་མ།';
$string['qcategory2coursefallback'] = 'དྲི་བ་ཚུ་གིས་དབྱེ་རིམ་"{$a->name}" ཧེ་མ་ལས་རང་རྒྱབ་སྣོན་ཡིག་སྣོད་གྱི་རིམ་ལུགས/སློབ་ཚན་དབྱེ་རིམ་སྐབས་དོན་ནང་ ཡོད་མི་འདི་ སོར་ཆུད་འབད་བའི་སྐབས་ སློབ་ཚན་སྐབས་དོན་ནང་གསར་བསྐྲུན་འབད་འོང་།';
$string['qcategorycannotberestored'] = 'དྲི་བ་ཚུ་གིས་དབྱེ་རིམ་"{$a->name}" ་དེ་སོར་ཆུད་ཀྱི་གསར་བསྐྲུན་འབད་མ་ཚུགས།';
$string['question2coursefallback'] = 'དྲི་བ་ཚུ་གིས་དབྱེ་རིམ་"{$a->name}" ཧེ་མ་ལས་རང་རྒྱབ་སྣོན་ཡིག་སྣོད་གྱི་རིམ་ལུགས/སློབ་ཚན་དབྱེ་རིམ་སྐབས་དོན་ནང་ ཡོད་མི་འདི་ སོར་ཆུད་འབད་བའི་སྐབས་ སློབ་ཚན་སྐབས་དོན་ནང་གསར་བསྐྲུན་འབད་འོང་།';
$string['questionegorycannotberestored'] = 'དྲི་བ་ཚུ་"{$a->name}" ་སོར་ཆུད་འབད་བའི་སྐབས་ སློབ་ཚན་སྐབས་དོན་ནང་གསར་བསྐྲུན་འབད་མ་ཚུགས།';
$string['restoreactivity'] = 'སྦྱོང་ལཱ་ སོར་ཆུད་འབད།';
$string['restorecourse'] = 'སློབ་ཚན་ སོར་ཆུད་འབད།';
$string['restorecoursesettings'] = 'སློབ་ཚན་ གཞི་སྒྲིག་ཚུ།';
$string['restoreexecutionsuccess'] = 'སློབ་ཚན་དེ་མཐར་འཁྱོལ་སྦེ་སོར་ཆུད་འབད་ཡི། འཕྲོ་མཐུད་ཨེབ་རྟ་འདི་ལུ་ཨེབ་གཏང་པ་ཅིན་ སོར་ཆུད་འབད་ཚར་བའི་སློབ་ཚན་དེ་མཐོང་ཚུགས།';
$string['restorefileweremissing'] = 'ཡིག་སྣོད་ལ་ལོ་ཅིག་རྒྱབ་སྣོན་དང་མ་ཚངམ་ལས་ སོར་ཆུད་འབད་མ་ཚུགས།';
$string['restorenewcoursefullname'] = 'སློབ་ཚན་གྱི་མིང་གསརཔ།';
$string['restorenewcourseshortname'] = 'སློབ་ཚན་གྱི་མིང་གསརཔ།';
$string['restorenewcoursestartdate'] = 'འགོ་བཙུགས་ ཚེས་གྲངས་ གསརཔ།';
$string['restorerolemappings'] = 'ལས་འགན་ས་ཁྲ་བཟོ་ཡོད་མི་སོར་ཆུད་འབད།';
$string['restorerootsettings'] = 'གཞི་སྒྲིག་ཚུ་སོར་ཆུད་འབད།';
$string['restoresection'] = 'དབྱེ་ཚན་ སོར་ཆུད་འབད།';
$string['restorestage1'] = 'ངེས་དཔྱད།';
$string['restorestage16'] = 'བསྐྱར་ཞིབ།';
$string['restorestage16action'] = 'སོར་ཆུད་འབད།';
$string['restorestage1action'] = 'ཤུལ་མམ།';
$string['restorestage2'] = 'འགྲོ་ཡུལ།';
$string['restorestage2action'] = 'ཤུལ་མམ།';
$string['restorestage32'] = 'ལས་སྦྱོར།';
$string['restorestage32action'] = 'འཕྲོ་མཐུད།';
$string['restorestage4'] = 'གཞི་སྒྲིག་ཚུ།';
$string['restorestage4action'] = 'ཤུལ་མམ།';
$string['restorestage64'] = 'མཇུག་བསྡུ།';
$string['restorestage64action'] = 'འཕྲོ་མཐུད།';
$string['restorestage8'] = 'ལས་འཆར།';
$string['restorestage8action'] = 'ཤུལ་མམ།';
$string['restoretarget'] = 'དམིགས་གཏད་ སོར་ཆུད་འབད།';
$string['restoretocourse'] = 'སློབ་ཚན་ལུ་སོར་ཆུད་འབད།';
$string['restoretocurrentcourse'] = 'སློབ་ཚན་འདི་གི་ནང་ལུ་སོར་ཆུད་འབད།';
$string['restoretocurrentcourseadding'] = 'སློབ་ཚན་གྱི་རྒྱབ་སྣོན་དེ་  སློབ་ཚན་འདི་དང་མཉམ་བསྡོམས་གཏང།';
$string['restoretocurrentcoursedeleting'] = 'སློབ་ཚན་གྱི་ནང་དོན་ཚུ་བཏོན་གཏང་བཞིནམ་ལས་སོར་ཆུད་འབད།';
$string['restoretoexistingcourse'] = 'ད་ལྟོ་ཡོད་པའི་སློབ་ཚན་འདི་གི་ནང་ལུ་སོར་ཆུད་འབད།';
$string['restoretoexistingcourseadding'] = 'སློབ་ཚན་གྱི་རྒྱབ་སྣོན་དེ་  ད་ལྟོ་ཡོད་པའི་སློབ་ཚན་འདི་དང་མཉམ་བསྡོམས་གཏང།';
$string['restoretoexistingcoursedeleting'] = 'ད་ལྟོ་ཡོད་པའི་སློབ་ཚན་གྱི་ནང་དོན་ཚུ་བཏོན་གཏང་བཞིནམ་ལས་སོར་ཆུད་འབད།';
$string['restoretonewcourse'] = 'སློབ་ཚན་གསརཔ་སྦེ་སོར་ཆུད་འབད།';
$string['restoringcourse'] = 'སློབ་ཚན་སོར་ཆུད་འབད་བའི་བསྒང་ཡོད།';
$string['restoringcourseshortname'] = 'སོར་ཆུད་འབད་དོ།';
$string['rootenrolmanual'] = 'ལག་ཐོག་མིང་བཀོད་ སྦེ་སོར་ཆུད་འབད།';
$string['rootsettingactivities'] = 'སྦྱོང་ལཱ་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettinganonymize'] = 'མིང་མེད་པའི་ལག་ལེན་པའི་ལོ་རྒྱུས།';
$string['rootsettingbadges'] = 'ངོ་་རྒྱན་ཚུ་གྲལ་ཁར་བཙུགས།';
$string['rootsettingblocks'] = 'སྡེབ་ཚན་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettingcalendarevents'] = 'ཟླ་ཐོ་བྱ་སྒོ་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettingcomments'] = 'བསམ་བཀོད་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettingfilters'] = 'བཙག་མ་ཚ་གྲངས་སུ་བཙུག།';
$string['rootsettinggradehistories'] = 'གནས་ཚད་ཀྱི་ལོ་རྒྱུས་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettingimscc1'] = 'IMS མཐུན་མོང་ Cartridge 1.0 ་ལུ་གཞི་བསྒྱུར་འབད།';
$string['rootsettingimscc11'] = 'IMS མཐུན་མོང་ Cartridge 1.1་ལུ་གཞི་བསྒྱུར་འབད།';
$string['rootsettinglogs'] = 'སློབ་ཚན་ དྲན་དེབ་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettingquestionbank'] = 'དྲི་བའི་མཛོད་ཚུ་གྲལ་ཁ་བཙུགས།';
$string['rootsettingroleassignments'] = 'ལས་འགན་སྐལ་ནི་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettings'] = 'རྒྱབ་སྣོན་གཞི་སྒྲིག་ཚུ།';
$string['rootsettingusers'] = 'མིང་ཐོ་བཀོད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་གྲངས་སུ་བཙུག།';
$string['rootsettinguserscompletion'] = 'ལག་ལེན་པའི་ཡོངས་སྒྲུབ་རྒྱས་བཤད་ཚུ་གྲངས་སུ་བཙུགས།';
$string['sectionactivities'] = 'སྦྱོང་ལཱ་ཚུ།';
$string['sectioninc'] = 'རྒྱབ་སྣོན་ནང་ཚུད་ཡོད་(ལག་ལེན་པའི་ལོ་རྒྱུས་མེད)';
$string['sectionincanduser'] = 'ལག་ལེན་པའི་བརྡ་དོན་ཅིག་ཁར་རྒྱབ་སྣོན་ནང་བཙུགས་ཡོད།';
$string['selectacategory'] = 'དབྱེ་རིམ་གཅིག་སེལ་འཐུ་འབད།';
$string['selectacourse'] = 'སློབ་ཚན་གཅིག་སེལ་འཐུ་འབད།';
$string['setting_course_fullname'] = 'སློབ་ཚན་གྱི་མིང་།';
$string['setting_course_shortname'] = 'སློབ་ཚན་མིང་ཐུང་།';
$string['setting_course_startdate'] = 'སློབ་ཚན་འགོ་བཙུགས་པའི་ཚེས་གྲངས།';
$string['setting_keep_groups_and_groupings'] = 'ད་ལྟོའི་ སྡེ་ཚན་ཚུ་དང་སྡེ་བཟོ་ཚུ་བཞག།';
$string['setting_keep_roles_and_enrolments'] = 'ད་ལྟོའི་ ལས་འགན་ཚུ་དང་མིང་བཀོད་ཚུ་བཞག།';
$string['setting_overwriteconf'] = 'སློབ་ཚན་རིམ་སྒྲིག་ ཚབ་སྲུང་འབད།';
$string['showtypes'] = 'དབྱེ་སྡེ་གདམ་ཁ་ཚུ་སྟོན།';
$string['skiphidden'] = 'སྦ་བཞག་ཡོད་པའི་སློབ་ཚན་ཚུ་གོམ་འགྱོ།';
$string['skiphiddenhelp'] = 'སྦ་བཞག་ཡོད་པའི་སློབ་ཚན་ཚུ་གོམ་འགྱོ་ནི་ཨིན་ན་མེན་གདམ།';
$string['skipmodifdays'] = 'ན་ལས་ཚུར་ སློབ་ཚན་ཚུ་ལེགས་བཅོས་མ་གྲུབ་མི་གོམ་འགྱོ།';
$string['skipmodifdayshelp'] = 'སློབ་ཚན་ཚུ་ཉིམ་བདག་པ་ཅིག་ལས་ཚུར་ལེགས་བཅོས་མ་གྲུབ་མི་གོམ་འགྱོ་ནི་སྦེ་གདམ།';
$string['skipmodifprev'] = 'སློབ་ཚན་ཚུ་ཧེ་མ་རྒྱབ་སྣོན་ལས་ཚུར་་ལེགས་བཅོས་མ་གྲུབ་མི་གོམ་འགྱོ་ནི།';
$string['skipmodifprevhelp'] = 'སློབ་ཚན་ཚུ་ རྒྱབ་སྣོན་ཧེ་མམ་ལས་ཚུར་ལེགས་བཅོས་མ་གྲུབ་མི་གོམ་འགྱོ་ནི་ཨིན་ན་མེན་གདམ།';
$string['storagecourseandexternal'] = 'སློབ་ཚན་གྱི་རྒྱབ་སྣོན་ཡིག་སྣོད་ས་གོ་དང་གསལ་བཀོད་འབད་ཡོད་པའི་སྣོད་ཐོ།';
$string['storagecourseonly'] = 'སློབ་ཚན་གྱི་རྒྱབ་སྣོན་ཡིག་སྣོད་ས་གོ།';
$string['storageexternalonly'] = 'རང་བཞིན་གྱི་རྒྱབ་སྣོན་ཚུ་འབད་ནིའི་དོན་ལུ་གསལ་བཀོད་འབད་ཡོད་པའི་སྣོད་ཐོ།';
$string['title'] = 'མིང་གནས།';
$string['totalcategorysearchresults'] = 'དབྱེ་རིམ་ཡོངས་བསྡོམས:{$a}';
$string['totalcoursesearchresults'] = 'སློབ་ཚན་ཡོངས་བསྡོམས:{$a}';
$string['unnamedsection'] = 'མིང་མེད་པའི་སྡེ་ཚན།';
$string['userinfo'] = 'ལག་ལེན་པའི་ གནས་ཚུལ།';
