<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_ldap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'སྣོད་ཐོ་ཤུགས་ལྡན་ནང་རྩིས་ཐོ་གསརཔ་གསར་བསྐྲུན་འབད་མི་ཚུགས། འདི་ལཱ་འབད་བཏུབ་ནིའི་དོན་ལུ་ ཁྱོད་ལུ་ (LDAPS connection, bind user with adequate rights, etc.)བཟུམ་གྱི་དགོས་མཁོ་ཚུ་ག་ར་ཚངམ་སྦེ་ཡོདཔ་ངེས་བདེན་བཟོ།';
$string['auth_ldap_attrcreators'] = 'ཁྱད་ཆོས་གསར་བསྐྲུན་འབད་ཆོག་པའི་འཐུས་མི་ཚུ་གི་སྡེ་ཚན་ཡང་ན་སྐབས་དོན་ཚུ་གི་ཐོ་ཡིག་ སྣ་མང་སྡེ་ཚན་ཚུ་ \';\' གིས་སོ་སོ་འཕྱལ།\'cn=teachers,ou=staff,o=myorg\'བཟུམ་སྦེ།';
$string['auth_ldap_attrcreators_key'] = 'གསར་བསྐྲུན་པ་ཚུ་ཆེད་བརྗོད་འབད';
$string['auth_ldap_auth_user_create_key'] = 'ལག་ལེན་པ་ཚུ་ཕྱི་ཁ་ལས་སྦེ་གསར་བསྐྲུན་འབད';
$string['auth_ldap_bind_dn'] = 'བའིནཌི-ལག་ལེན་པ་ལུ་ལག་ལེན་ཚུ་འཚོལ་ཞིབ་འདབ་བཅུག་ནི་ལག་ལེན་འཐབ་ནི་ཨིན་པ་ཅིན་ འདི་ནཱ་ལུ་གསལ་བཀོད་འབད། \'cn=ldapuser,ou=public,o=org\' བཟུམ།';
$string['auth_ldap_bind_dn_key'] = 'དབྱེ་སེལ་འབད་ཡོད་པའི་མིང་།';
$string['auth_ldap_bind_pw'] = 'བའིནཌི་-ལག་ལེན་པའི་ཆོག་ཡིག';
$string['auth_ldap_bind_pw_key'] = 'ཆོག་ཡིག';
$string['auth_ldap_bind_settings'] = 'Bindསྒྲིག་སྟངས།';
$string['auth_ldap_changepasswordurl_key'] = 'ཆོག་ཡིག་-བསྒྱུར་བཅོས་ URL';
$string['auth_ldap_contexts'] = 'ལག་ལེན་པ་ཚུ་གནས་ཡོད་སའི་སྐབས་དོན་ཚུ་གི་ཐོ་བཀོད། སྐབས་དོན་མ་འདྲཝ་ཚུ་ \';\' གིས་སོ་སོ་འཕྱལ། དཔེར་ན་ \'ou=users,o=org; ou=others,o=org';
$string['auth_ldap_contexts_key'] = 'སྐབས་དོན་ཚུ།';
$string['auth_ldap_create_context'] = 'ལག་ལེན་པའི་གསར་བསྐྲུན་གློག་འཕྲིན་ངེས་དཔྱད་ཀྱིས་སྦེ་ལྕོགས་ཅན་བཟོཝ་ཨིན་པ་ཅིན་ ལག་ལེན་པ་ཚུ་གསར་བསྐྲུན་འབད་ཡོད་སའི་སྐབས་དོན་གསར་བཀོད་འབད། སྲུང་སྐྱོབ་ཀྱི་གནད་དོན་ཚུ་སྔོན་བཀག་འབད་ནིའི་དོན་ལུ་ སྐབས་དོན་འདི་ལག་ལེན་པ་གཞན་ཚུ་ལས་སོ་སོ་འོང་དགོ། ཁྱོད་ཀྱིས་སྐབས་དོན་འདི་ ldap_སྐབས་དོན-འགྱུར་ཅན་ལུ་ ཁ་སྐོང་བརྐྱབ་མི་དགོ་ མུ་ཌེལ་གྱིས་སྐབས་དོན་ནང་ལས་རང་བཞིན་གྱིས་ལག་ལེན་པ་ཚུ་འཚོལ་ཞིབ་འབད་འོང་། <br /><b>དྲན་དགོཔ!</b> ཁྱོད་ཀྱིས་ ཡིག་སྣོད་ auth/ldap/auth.php ནང་ ལག་ལེན་པའི་གསར་བསྐྲུན་ལཱ་བཟོ་ནིའི་དོན་ལུ་ལག་ལེན་པ་-གསར་བསྐྲུན་ () ཐབས་ལམ་ འདི་ལེགས་བཅོས་འབད་དགོ';
$string['auth_ldap_create_context_key'] = 'ལག་ལེན་པ་གསརཔ་ཚུ་གི་དོན་ལུ་སྐབས་དོན་';
$string['auth_ldap_create_error'] = 'LDAP ནང་ལུ་ ལག་ལེན་པ་གསར་བསྐྲུན་འབད་ནི་ལུ་འཛོལ་བ།';
$string['auth_ldap_creators'] = 'སློབ་ཚན་གསརཔ་གསར་བསྐྲུན་འབད་ཆོག་པའི་འཐུས་མི་ཚུ་གི་སྡེ་ཚན་ཡང་ན་སྐབས་དོན་གྱི་ཐོ་བཀོད་ སྣ་མང་སྡེ་ཚན་ཚུ་ \';\' གིས་ སོ་སོ་འཕྱལ། དཔེར་ན་ \'cn=teachers,ou=staff,o=myorg\' བཟུམ།';
$string['auth_ldap_creators_key'] = 'གསར་བསྐྲུན་པ།';
$string['auth_ldapdescription'] = 'བདེན་བཤད་འབད་ནི་ ཐབས་ལམ་གི་དོན་ལུ་ཕྱིའི་LDAP སར་བར་ བྱིན་ཏེ་ཡོད། ལག་ལེན་པའི་མིང་ དང་་ཆོག་ཡིག་ནུས་ཅན་ཨིན་པ་ཅིན་ Moodleགྱིས་ལག་ལེན་པ་གསརཔ་གསར་བསྐྲུན་གནས་སྡུད་གཞི་རྟེན་ནང་ན་འབད་ནི་ཨིན། ཨ་ནཱི་ཚད་གཞི་གི་ LDAP་ལས་ལག་ལེན་པའི་ཁྱད་ཆོས་ཚུ་ལྷག་ཏི་དགོཔ་པའི་ས་སྒོ་ཚུ་Moodle གི་ནང་ན་ སྔོན་བཀང་འབད་ཨིན། ནང་བསྐྱོད་དོན་ལས་ལག་ལེན་པའི་མིང་དང་ཆོག་ཡིག་ཞིབ་དཔྱད་འབད་ཨིན།';
$string['auth_ldap_expiration_desc'] = 'ཆོག་ཡིག་དུས་ཡོལ་ཐལ་ཞིབ་དཔྱད ཡང་ན་ ཆོག་ཡིག་དུས་ཡོལ་ཐལ་LDAPལས་ཐད་ཀར་དུ་LDAP་གྱི་ལྷག་འབད་ ལྕོགས་མིན་བཟོ་ནི་ དོན་ལུ་ མེན་ སེལ་འཐུ་འབད།';
$string['auth_ldap_expiration_key'] = 'དུས་ཡོལ།';
$string['auth_ldap_expiration_warning_desc'] = 'ཆོག་ཡིག་དུས་ཡོལ་གྱི་ཉེན་བརྡ་མ་བྱིན་པའི་ཧེ་མའི་ཉིན་གྲངས།';
$string['auth_ldap_expiration_warning_key'] = 'དུས་ཡོལ་ཉེན་བརྡ་';
$string['auth_ldap_expireattr_desc'] = 'གདམ་ཁ་ཅན: ཆོག་ཡིག་དུས་ཡོལ་གྱི་དུས་ཡུན་གསོག་འཇོག་འབད་མི་ldap-ཁྱད་ཆོས་མེདཔ་གཏངམ་ཨིན';
$string['auth_ldap_expireattr_key'] = 'དུས་ཡོལ་ཁྱད་ཆོས།';
$string['auth_ldapextrafields'] = 'ས་སྒོ་གདམ་ཁ་ཅན་ ཁྱོད་ཀྱི་<b>LDAP ས་སྒོ</b>གསལ་བཀོད་ལས་  Moodle ལག་ལེན་པ་ལ་ལོ་ཅིག་ས་སྒོ་ཚུ་གཅིག་ཁར་བརྡ་དོན་ གདམ་ཁ་བརྐྱབ་འབད་སྔོན་བཀང་འབད་ཚུགས། ས་སྒོ་ཚུ་སྟོངམ་འབད་བཞག་བ་ཅིན་་LDAP་ལས་ག་ཅིག་ཡང་གནས་སོར་མེད་འབད་ ཚབ་ལུMoodle སྔོན་སྒྲིག་ཚུ་ལག་ལེན་འཐབ་འོང་';
$string['auth_ldap_graceattr_desc'] = 'གདམ་ཁ་ཅན: gracelogin ཁྱད་ཆོས་མེདཔ་གཏངམ་ཨིན';
$string['auth_ldap_gracelogin_key'] = 'Grace་ནང་བསྐྱོད་ ཁྱད་ཆོས།';
$string['auth_ldap_gracelogins_desc'] = 'LDAP gracelogin རྒྱབ་བསྐྱོར་ལྕོགས་ཅན་བཟོ། ཆོག་ཡིག་དུས་ཡོལ་བའི་ཤུལ་ལས་ gracelogin གྱངས་ཁ་ ༠ ཚུན་ ལག་ལེན་པ་གིས་ནང་བསྐྱོད་འབད་ཚུགས། སྒྲིག་སྟངས་འདི་ལྕོགས་ཅན་བཟོ་མི་འདི་གིས་ཆོག་ཡིག་དུས་ཡོལ་དེ་ཡོད་པ་ཅིན་ གིརེསི་ནང་བསྐྱོད་འཕྲིན་དོན་བཀྲམ་སྟོན་འབདཝ་ཨིན';
$string['auth_ldap_gracelogins_key'] = 'Grace་ནང་བསྐྱོད་ཚུ';
$string['auth_ldap_groupecreators'] = 'སྡེ་ཚན་གསར་བསྐྲུན་འབད་ཆོག་པའི་འཐུས་མི་ཚུ་གི་སྡེ་ཚན་ཡང་ན་སྐབས་དོན་གྱི་ཐོ་བཀོད། སྣ་མང་སྡེ་ཚན་ཚུ་ \';\' གིས་སྦེ་ སོ་སོ་འཕྱལ། དཔེར་ན་ \'cn=teachers,ou=staff,o=myorg\' བཟུམ།';
$string['auth_ldap_groupecreators_key'] = 'སྡེ་ཚན་གསར་བསྐྲུན་པ།';
$string['auth_ldap_host_url'] = '\'ldap://ldap.myorg.com/\'ཡང་ན་ \'ldaps://ldap.myorg.com/\' བཟུམ་གྱི་ URL རྣམ་པ་ནང་ LDAP host གསལ་བཀོད་འབད';
$string['auth_ldap_host_url_key'] = 'གནད་མཛོད་ཀྱི་ URL';
$string['auth_ldap_ldap_encoding'] = 'LDAP སར་བར་གྱི་ལག་ལེན་འཐབ་ཡོད་མི་ ཨིན་ཀོ་ཌིང་གསལ་བཀོད་འབད་ utf-8, MS AD v2 གིས་མང་ཤོས་རང་ cp1252, cp1250, etc བཟུམ་གྱི་ སྔོན་སྒྲིག་ཨིན་ཀོ་ཌིང་ལག་ལེན་འཐབ་ཨིན';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP ཨིན་ཀོ་ཌིང་།';
$string['auth_ldap_login_settings'] = 'ནང་བསྐྱོད་ གཞི་སྒྲིག་ཚུ་';
$string['auth_ldap_memberattribute'] = 'གདམ་ཁ་ཅན: ལག་ལེན་པ་སྡེ་ཚན་ནང་གི་ཨིན་པ་ཅིན་འཐུས་མི་ལག་ལེན་པའི་ཁྱད་ཆོས་མེདཔ་གཏངམ་ཨིན་ ཨ་རྟག་ཧ་ལུགས་ཀྱི་ \'འཐུས་མི།';
$string['auth_ldap_memberattribute_isdn'] = 'གདམ་ཁ་ཅན: འཐུས་མི་ཚུ་གི་ཁྱད་ཆོས་བེ་ལུ་ ༠ ཡང་ན་ ༡ ལེགས་སྐྱོང་འཐབ་ནི་མེདཔ་གཏངམ་ཨིན';
$string['auth_ldap_memberattribute_isdn_key'] = 'འཐུས་མི་ཁྱད་ཆོས་ཀྱིས་ ༡ ཡང་ན་ ༢ ལག་ལེན་འཐབ་ཨིན';
$string['auth_ldap_memberattribute_key'] = 'འཐུས་མི་ཁྱད་ཆོས།';
$string['auth_ldap_noconnect'] = 'LDAP-ཚད་གཞི་གི་ སར་བར་ལུ་འབྲེལ་མཐུད་འབད་མི་ཚུགས: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-ཚད་གཞི་གི་ སར་བར་གཅིག་ལུ་ཡང་འབྲེལ་མཐུད་འབད་མི་ཚུགས: {$a}';
$string['auth_ldap_noextension'] = '<em>ཉེན་བརྡ: PHP LDAP ཚད་གཞི་མེདཔ་བཟུམ་ཅིག་འདུག་ འདི་གཞི་བཙུགས་འབད་དེ་ལྕོགས་ཅན་བཟོ་ཡོདཔ་བརྟན་བརྟན་བཟོ་གནང་།</em>';
$string['auth_ldap_no_mbstring'] = 'སྣོད་ཐོ་ཤུགས་ལྡན་ནང་ལག་ལེན་པ་ཚུ་གསར་བསྐྲུན་འབད་ནིའི་དོན་ལུ་ ཁྱོད་ལུ་ mbstring རྒྱ་བསྐྱེད་དགོ།';
$string['auth_ldapnotinstalled'] = 'LDAP བདེན་བཤད་བདེན་བཤད་འབད་ནི་ལུ་ལག་ལེན་འཐབ་མིད་ཚུབས། PHP LDAP ཚད་གཞི འདི་གཞི་བཙུགས་མ་འབད་ནུག།';
$string['auth_ldap_objectclass'] = 'གདམ་ཁ་ཅན: ldap_ལག་ལེན་པ་_དབྱེ་བ་གུ་ ལག་ལེན་པ་ཚུ་ མིང་བཏགས་ནི/འཚོལ་ཞིབ་འབད་ནིའི་དོན་ལུ་ལག་ལེན་འཐབ་ཡོད་མི་objectClass མེདཔ་གཏངམ་ཨིན་ འདི་བསྒྱུར་བཅོས་འབད་མི་དགོ།';
$string['auth_ldap_objectclass_key'] = 'Object class';
$string['auth_ldap_opt_deref'] = 'འཚོལ་ཞིབ་འབད་བའི་སྐབས་མིང་རྫུན་མ་ཚུ་ག་དེ་སྦེ་བདག་འཛིན་འཐབ་ནི་ཨིན་ན་ གཏན་འབེབས་བཟོཝ་ཨིན། འོག་གི་བེ་ལུསི་ལས་གཅིག་སེར་འཐུ་འབད: "No" (LDAP_DEREF_NEVER) ཡང་ན་ "Yes" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'མི་མཐུན་པའི་མིང་རྫུན་མ།';
$string['auth_ldap_passtype'] = 'LDAP སར་བར་ནང་གི་ཆོག་ཡིག་གསརཔ་ཡང་ན་བསྒྱུར་བཅོས་འབད་ཡོད་མི་ཚུ་གི་རྩ་སྒྲིག་གསལ་བཀོད་འབད';
$string['auth_ldap_passtype_key'] = 'ཆོག་ཡིག་ རྩ་སྒྲིག';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP ཆོག་ཡིག་དུས་ཡོལ་གཞི་སྒྲིག།';
$string['auth_ldap_preventpassindb'] = 'ཆོག་ཡིག་Moodle\'s གྱི་ DB ནང་གསོག་འཇོག་འབད་ནི་ལས་བཀད་དམ་འབད་ནིའི་དོན་ལུ་ ཨིན་ སེལ་འཐུ་འབད';
$string['auth_ldap_preventpassindb_key'] = 'ཆོག་ཡིག་ སྦ་བཞག';
$string['auth_ldap_search_sub'] = 'ཡན་ལག་སྐབས་དོན་ཚུ་ནང་ལས་ ལག་ལེན་པ་ཚུ་འཚོལ་ཞིབ་འབད';
$string['auth_ldap_search_sub_key'] = 'ཡན་ལག་སྐབས་དོན་ཚུ་འཚོལ་ཞིབ་འབད';
$string['auth_ldap_server_settings'] = 'LDAP སར་བར་གྱི་ གཞི་སྒྲིག་ཚུ་';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() སེལ་འཐུ་འབད་ཡོད་མི་ལག་ལེན་པའི་དབྱེ་བ: {$a}རྒྱབ་བསྐྱོར་མི་འབད་བས།';
$string['auth_ldap_update_userinfo'] = 'LDAP ལས་ Moodleལུ་ལག་ལེན་པའི་བརྡ་དོན་དུས་མཐུན་བཟོ་ (མགོ་མིང་ མཇུག་མིང་ ཁ་བྱང་་་་)ཁྱོད་ར་དགོས་དོན་དང་འཁྲིལ་ཏེ་ "Data mapping" གསལ་བཀོད་འབད';
$string['auth_ldap_user_attribute'] = 'གདམ་ཁ་ཅན: ལག་ལེན་པ་ཚུ་མིང་བཏགས་ནི་/འཚོལ་ཞིབ་འབད་ནིའི་དོན་ལུ་ལག་ལེན་འཐབ་ཡོད་མི་ཁྱད་ཆོས་མེདཔ་གཏངམ་ཨིན། ཨ་རྟག་ཧ་ལུགས་ \'cn';
$string['auth_ldap_user_attribute_key'] = 'ལག་ལེན་པའི་ཁྱད་ཆོས།';
$string['auth_ldap_user_exists'] = 'LDAP ལག་ལེན་པའི་མིང་ཧེ་མ་ལས་རང་འདུག';
$string['auth_ldap_user_settings'] = 'ལག་ལེན་པ་འཚོལ་ཞིབ་གཞི་སྒྲིག།';
$string['auth_ldap_user_type'] = 'ལག་ལེན་པ་ཚུ་  LDAP ནང་ག་དེ་སྦེ་ གསོག་འཇོག་འབད་དེ་ཡོདཔ་ཨིན་ན་ སེལ་འཐུ་འབད་ སྒྲིག་སྟངས་འདི་གིས་ ནང་བསྐྱོད་དུས་ཡོལ་དང་ གིརེསི་ནང་བསྐྱོད་ དེ་ལས་ ལག་ལེན་གསར་བསྐྲུན་ག་དེ་སྦེ་ལཱ་འབདཝ་ཨིན་གསལ་བཀོད་འབདཝ་ཨིན';
$string['auth_ldap_user_type_key'] = 'ལག་ལེན་པའི་དབྱེ་བ།';
$string['auth_ldap_usertypeundefined'] = 'རིམ་སྒྲིག། ལག་ལེན་པའི-དབྱེ་བ་ངེས་འཛིན་འབད་དེ་མེདཔ་ ཡང་ན་ ལས་འགན་ ldap_expirationtime2unix འདི་གིས་སེལ་འཐུ་འབད་ཡོད་མི་དབྱེ་བ་རྒྱབ་སྐྱོར་མི་འབད་བས་';
$string['auth_ldap_usertypeundefined2'] = 'རིམ་སྒྲིག། ལག་ལེན་པའི-དབྱེ་བ་ངེས་འཛིན་འབད་དེ་མེདཔ་ ཡང་ན་ ལས་འགན་ ldap_unixi2expirationtime འདི་གིས་སེལ་འཐུ་འབད་ཡོད་མི་དབྱེ་བ་རྒྱབ་སྐྱོར་མི་འབད་བས་!';
$string['auth_ldap_version'] = 'ཁྱོད་ཀྱི་སར་བར་གྱི་ལག་ལེན་འཐབ་མི་ LDAP གནད་སྤེལ་ལམ་ལུགས་ཀྱི་ཐོན་རིམ།';
$string['auth_ldap_version_key'] = 'ཐོན་རིམ།';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'ནང་བསྐྱོད་རྐྱང་པ་དཔའ་བཅམ་ནིའི་དོན་ལུ་ NTLM domain ཨིན་ལུ་གཞི་སྒྲིག་འབད།<strong>དྲན་དགོཔ་:</strong> འདི་ལཱ་འབད་བཏུབ་བཟོ་ནིའི་དོན་ལུ་ ཝེབ་སར་བར་གུ་གཞི་སྒྲིག་ཧེང་སྐལ་དགོ་ <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a> བལྟ་གནང་།';
$string['auth_ntlmsso_enabled_key'] = 'ལྕོགས་ཅན་བཟོ།';
$string['auth_ntlmsso_ie_fastpath'] = 'NTLM SSO fast path ལྕོགས་ཅན་བཟོ་ནིའི་དོན་ལུ་ ཨིན་ ལུ་གཞི་སྒྲིག་འབད(རིམ་པ་ལ་ལོ་གཅིག་གོམ་སྟེ་འགྱོཝ་ཨིནམ་དང་ ཞབས་ཏོག་སྤྱོད་མི་གི་བརའུ་ཟར་འདི་ MS Internet Explorer ཨིན་པ་ཅིན་རྐྱངམ་གཅིག་ལཱ་འབད་བཏུབ་ཨིན)';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE འགྲུལ་ལམ་མགྱོགས་དྲགས?';
$string['auth_ntlmsso_maybeinvalidformat'] = 'REMOTE_USER headerལས་ ལག་ལེན་པ་མིང་ཕྱིར་འདོན་འབད་མི་ཚུགས་པས། རྩ་སྒྲིག་རིམ་སྒྲིག་འབད་མི་འདི་བདེན་པ་ཨིན་ན?';
$string['auth_ntlmsso_missing_username'] = 'ཁྱོད་ཀྱི་ཉུང་མཐའ་%username%འདི་ ཐག་རིང་ལག་ལེན་པ་མིང་རྩ་སྒྲིག་ ནང་ན་ གསལ་བཀོད་འབད་དགོཔ།';
$string['auth_ntlmsso_remoteuserformat'] = '\'བདེན་བཤད་འབད་ནི་་དབྱེ་བ\' ནང་ན་\' NTLM\' འདི་ གདམ་ཁ་བརྐྱབས་པ་ཅིན་ ཁྱོད་ཀྱི་ཐག་རིང་ལག་ལེན་པ་མིང་རྩ་སྒྲིག་ འདི་གསལ་བཀོད་འབད་དགོཔ། སྟོངམ་འབད་བཞག་པ་ཅིན་ སྔོན་སྒྲིགDOMAINལག་ལེན་པ་མིང་རྩ་སྒྲིག་ལག་ལེན་འཐབ་འོང།ཁྱོད་ཀྱི་<b>%domain%</b>གདམ་ཁ་ཅན  placeholder ལུ་ domain nameའབྱུང་ནི་འབད་གསལ་བཀོད་འབད, ངེས་མཁོ།<b>%username%</b> placeholder ལུ་ ལག་ལེན་པ་མིང་ འབྱུང་ནི་འབད་གསལ་བཀོད་འབད།<br /><br />ལ་ལོ་ཅིག་ རྒྱ་སྦོམ་སྦེ་ལག་ལེན་འཐབ་རྩ་སྒྲིག་ཚུ་ཚར་མི་དེ་ <tt>%domain%%username%</tt> (MS Windows default), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> and just <tt>%username%</tt> ( domain part མེད་པ་ཅིན).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'ཐག་རིང་ལག་ལེན་པ་མིང་རྩ་སྒྲིག།';
$string['auth_ntlmsso_subnet'] = 'གཞི་སྒྲིག་འབད་བ་ཅིན་འདིགི་ SSO དེ་་ཞབས་ཏོག་སྤྱོད་མི་གཅིག་ཁར་subnetནང་ན་དཔའ་བཅམ་འབད་འོང། Format: xxx.xxx.xxx.xxx/bitmask. Separate multiple subnets with \',\' (comma).';
$string['auth_ntlmsso_subnet_key'] = 'Subnet';
$string['auth_ntlmsso_type'] = 'ཝེབ་སར་བར་ནང་ན་ བདེན་བཤད་འབད་ནི་ཐབས་ལམ རིམ་སྒྲིག་འབད་ཡོད་མི་འདི་ ལག་ལེན་པ་ཚུ་བདེན་བཤད་འབདཝ་ཨིན།(ཐེ་ཚོམ་བཟའ་བ་ཅིནNTLMགདམ་ཁ་བརྐྱབ)';
$string['auth_ntlmsso_type_key'] = 'Authentication་དབྱེ་བ།';
$string['connectingldap'] = 'LDAP སར་བར་ལུ་ མཐུད་འབད་དོ་་་';
$string['creatingtemptable'] = 'གནས་སྐབས་ཀྱི་ཐིག་ཁྲམ་{$a}གསར་བསྐྲུན་འབད་དོ';
$string['didntfindexpiretime'] = 'password_expire()་རྫོགས་ནི་གི་དུས་ཚོད་འཐོབ་མ་ཚུགས།';
$string['didntgetusersfromldap'] = 'LDAP ་ལས་ལག་ལེན་པ་ཚུ་འཐོབ་མ་ཚུགས-- error? -- exiting';
$string['gotcountrecordsfromldap'] = 'LDAP ་ལས་དྲན་ཐོ་ཚུ་འཐོབ་ཚུགས་ཡི།';
$string['morethanoneuser'] = 'རྣམ་རྟོག་ལང་སི་སི!ldapནང་ན་ ལག་ལེན་པ་དྲན་ཐོ་གཅིག་ལས་ལྷག་འདུག། དང་པ་དེ་ལག་ལེན་འཐབ།';
$string['needbcmath'] = 'grace་ནང་བསྐྱོད་ཚུ་Active Directory མཉམ་གཅིག་ལག་ལོན་བཐབ་ནི་དོན་ལས་  BCMathརྒྱ་བསྐྱེད་དགོ།';
$string['needmbstring'] = 'Active Directory ནང་ན་ཆོག་ཡིག་བསྒྱུར་བཅོས་བཐབ་ནི་དོན་ལས་ mbstring རྒྱ་བསྐྱེད་དགོ།';
$string['nodnforusername'] = 'user_update_password()་ནང་ན་འཛོལ་བ་ཡོད། No DN for: {$a->username}';
$string['noemail'] = 'ཁྱིད་ལུ་གློག་འཕྲིན་བསྐྱེད་ནི་འབད་ཡི་ འདི་འབདཝ་ད་འཐུས་ཤོར་བྱུང་ཡོདཔ།';
$string['notcalledfromserver'] = 'ཝེབ་སར་བར་ ལས་བོད་ནི་མི་འོང་།!';
$string['noupdatestobedone'] = 'དུས་མཐུན་ཚུ་བཟོ་མ་ཚུགས།';
$string['nouserentriestoremove'] = 'ལག་ལེན་པ་ཐོ་བཀོད་ཚུ་རྩ་བསྐྲད་མ་ཚུགས།';
$string['nouserentriestorevive'] = 'ལག་ལེན་པ་ཐོ་བཀོད་ཚུ་ལོག་སྟེ་བཟོ་མ་ཚུགས།';
$string['nouserstobeadded'] = 'ལག་ལེན་པ་ཚུ་ཁ་སྐོང་རྐྱབས་མ་ཚུགས།';
$string['ntlmsso_attempting'] = 'NTLM ་བརྒྱུད་དེ་ རང་རྐྱང་མིང་རྟགས་བཀོད་ནི་ དཔའ་བཅམ་དོ་...';
$string['ntlmsso_failed'] = 'རང་བཞིན་གྱི་ནང་བསྐྱོད་འབད་ནི་འཐུས་ཤོར་བྱུང་ཡོད་ སྤྱིར་བཏང་ནང་བསྐྱོད་ཤོག་ལེབ་དེ་འབད་རྩོལ་བསྐྱེད་...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO ་འིད་ལྕོགས་མིན་ཐལ་ཡོད།';
$string['ntlmsso_unknowntype'] = 'མ་ཤེསཔ་ ntlmsso ་དབྱེ་བ!';
$string['pagedresultsnotsupp'] = 'LDAP་ཤོག་ལེབ་གྲུབ་འབྲས་དེ་རྒྱབ་སྐྱོར་མིན་འདུག།་(PHP ཐོན་རིམ་རྒྱབ་སྐྱོར་མེད་ཨིན་ན་ ཡང་ན་ ་Moodle་དེ་LDAP protocol་ཐོན་རིམ་༢་ལག་ལེན་བཐབ་ནི་རིམ་སྒྲིག་འབད་ནུག)';
$string['pagesize'] = 'གནས་གོང་དེ་ཁྱོད་རའི་LDAP ཝེབ་སར་གྲུབ་འབྲས་ལས་ཆུང་ཀུ་ ཐད་རི་བ་རི་བཟོ། ཆ་ཚན་ཚད( འདྲི་དཔྱད་གཅིག་གི་ནང་ ཐོ་བཀོད་མང་མཐའ་སླར་ལོག་འབད་ཚུགསཔ་)';
$string['pagesize_key'] = 'ཤོག་ལེབ་ཚད།';
$string['pluginname'] = 'LDAP ཝེབ་སར་';
$string['pluginnotenabled'] = 'Plugin ལྕོགས་ཅན་མ་བཟོ་ཡོདཔ!';
$string['renamingnotallowed'] = 'LDAP ནང་ན་ལགལེན་པ་ བསྐྱར་མིང་བཏགས་ནི་མེད་ཆོགཔ།';
$string['rootdseerror'] = 'ཤུགས་ལྡན་སྣོད་ཐོ་དོན་ལུ་ འཛོལ་བ་ འདྲི་དཔྱད་འབད་ནི་ rootDSE';
$string['start_tls'] = 'དུས་རྒྱུན་གྱི་ TLS གསང་བཟོ་ཡོད་པའི་ LDAP ཞབས་ཏོག་ (འདྲེན་ལམ་ 389) ་ལག་ལེན་འཐབ།';
$string['start_tls_key'] = 'TLS ་ལག་ལེན་འཐབ་';
$string['updatepasserror'] = 'user_update_password() ་ནང་འཛོལ་བ། འཛོལ་བའི་ ཨང་རྟགས་: {$a->errno}; འཛོལ་བའི་ ཡིག་རྒྱུན་: {$a->errstring}';
$string['updatepasserrorexpire'] = 'ཆོག་ཡིག་དུས་ཡོལ་ དུས་ཡུན་ལྷག་པའི་སྐབས་ user_update_password() ་ནང་འཛོལ་བ། འཛོལ་བའི་ ཨང་རྟགས་: {$a->errno}; འཛོལ་བའི་ ཡིག་རྒྱུན་: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'དུས་ཡོལ་ དུས་ཡུན་དང་/ ཡང་ན་ gracelogins ་ལེགས་བཅོས་འབད་བའི་སྐབས་ user_update_password() ་ནང་འཛོལ་བ། འཛོལ་བའི་ ཨང་རྟགས་: {$a->errno}; འཛོལ་བའི་ ཡིག་རྒྱུན་: {$a->errstring}';
$string['updateremfail'] = 'LDAP དྲན་ཐོ་ ་ དུས་མཐུན་བཟོཝ་ད་འཛོལ་བ། འཛོལ་བའི་ ཨང་རྟགས: {$a->errno}; འཛོལ་བའི་ ཡིག་རྒྱུན་: {$a->errstring}<br/>ལྡེ་ཡིག
 ({$a->key}) - moodle རྙིངམ་གྱི་ གནས་གོང་: \'{$a->ouvalue}\' གསརཔ་ གནས་གོང་: \'{$a->nuvalue}';
$string['updateremfailamb'] = 'བརྡ་དོན་ངེས་མེད་ས་སྒོ་{$a->key} ཡོད་པའི་ LDAP དུས་མཐུན་བཟོ་ཚུགས།; moodle རྙིངམ་གྱི་ གནས་གོང་: \'{$a->ouvalue}\' གསརཔ་ གནས་གོང་: \'{$a->nuvalue}';
$string['updateusernotfound'] = 'ཕྱི་ལས་དུས་མཐུན་བཟོ་བའི་བསྒང་ ལག་ལེན་པ་ཐོབ་མ་ཚུགས། རྟིང་བདའ་ནི་རྒྱས་བཤད་ཚུ་: འཚོལ་ཞིབ་ཀྱི་ གཞི་རྟེན་: \'{$a->userdn}\'; འཚོལ་ཞིབ་ཀྱི་ སེལ་ཚགས་: \'(objectClass=*)\'; འཚོལ་ཞིབ་ཀྱི་ ཁྱད་ཆོས་ཚུ་: {$a->attribs}';
$string['useracctctrlerror'] = '{$a} ་གི་དོན་ལུ་ userAccountControl ལེནམ་ད་འཛོལ་བ།';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() གི་ སེལ་འཐུ་གྲུབ་པའི་ ལག་ལེན་པའི་དབྱེ་བ་: {$a} ལུ་རྒྱབ་རྟེན་མེད།';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() གི་ སེལ་འཐུ་གྲུབ་པའི་ ལག་ལེན་པའི་དབྱེ་བ་: {$a} ལུ་རྒྱབ་རྟེན་མེད།';
$string['userentriestoadd'] = 'ལག་ལེན་པའི་ཐོ་བཀོད་ཚུ་ {$a} ་ཁ་སྐོང་རྐྱབས་ནི།';
$string['userentriestoremove'] = 'ལག་ལེན་པའི་ཐོ་བཀོད་ཚུ་ {$a} རྩ་བསྐྲད་གཏང་ནི།';
$string['userentriestorevive'] = 'ལག་ལེན་པའི་ཐོ་བཀོད་ཚུ་ {$a} ལོག་སྟེ་བཟོ་ནི།';
$string['userentriestoupdate'] = 'ལག་ལེན་པའི་ཐོ་བཀོད་ཚུ་ {$a} ་དུས་མཐུན་བཟོ་ནི།';
$string['usernotfound'] = 'LDAP ནང་ན་ལག་ལེན་པ་འཚོལ་མ་བཐོབ།';
