<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'བདེན་བཤད་འབད་ནི་ཡོད་མི་ plugins';
$string['alternatelogin'] = 'ནཱ་ལུ་ ཡུ་ཨར་ཨེལ་ བཙུག་པ་་ཅིན་ ས་ཁོངས་དེའི་ ནང་བསྐྱོད་ཤོག་ལེབ་སྦེ་ལག་ལེན་འཐབ་འོང་།
ཤོག་ལེབ་འདི་ནང་ལུ་ བྱ་བའི་རྒྱུ་དངོས་<strong>\'{$a}\'</strong> དང་ སླར་ལོག་ས་ཁོངས་<strong>ལག་ལེན་པའི་མིང་</strong> དང་<strong>ཆོག་ཡིག་</strong>. ལུ་ གཞི་སྒྲིག་འབད་བཞག་པའི་ འབྲི་ཤོག་དགོ།<br /> བདེན་མེད་ URL བཙུག་པ་ཅིན་ ཁྱོད་ར་ས་ཁོངས་འདི་ནང་འཛུལ་སྤྱོད་འབད་མ་ཚུགསཔ་བཟོ་ནིའི་ཉེན་ཁ་ཡོདཔ་ལས་ དྲན་པ་བཏོན།<br /> སྔོན་སྒྲིག་ནང་བསྐྱོད་ཤོག་ལེབ་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ སྒྲིག་སྟངས་འདི་སྟོངམ་སྦེ་བཞག';
$string['alternateloginurl'] = 'ནང་བསྐྱོད་ URL་གཞན';
$string['auth_changepasswordhelp'] = 'ཆོག་ཡིག་གྲོགས་རམ་ བསྒྱུར་བཅོས་འབད';
$string['auth_changepasswordhelp_expl'] = 'ཆོག་ཡིག་བརླག་སྟོར་ཞུགས་ཡོད་མི་ལག་ལེན་པ་{$a}་ལུ་ ཆོག་ཡིག་བརླག་སྟོར་གྲོགས་རམ་བཀྲམ་སྟོན་འབད། <strong>ཆོག་ཡིག་བསྒྱུར་བཅོས་ URL</strong> ཡང་ན་ ནང་འཁོད་མུ་ཌེལ་ཆོག་ཡིག་བསྒྱུར་བཅོས་ཀྱི་ཚབ་ལུ་ འདི་བཀྲམ་སྟོན་འབད་དེ་འོང་།';
$string['auth_changepasswordurl'] = 'ཆོག་ཡིག་ བསྒྱུར་བཅོས་འབད་ནིའི་URL';
$string['auth_changepasswordurl_expl'] = '{$a} ཆོག་ཡིག་བརླག་སྟོར་ཞུགས་ཡོད་མི་ལག་ལེན་པ་ཚུ་ལུ་གཏང་ནིའི་དོན་ལུ་ ཡུ་ཨར་ཨེལ་ གསལ་བཀོད་འབད། <strong>ཚད་ལྡན་བསྒྱུར་བཅོས་ཆོག་ཡིག་ཤོག་ལེབ་ལག་ལེན་འཐབ་</strong>འདི་ <strong>མིན་</strong> ལུ་ གཞི་སྒྲིག་འབད།';
$string['auth_changingemailaddress'] = 'ཁྱོད་ཀྱིས་ གློག་འཕྲིན་ཁ་བྱང་ {$a->oldemail} ལས་ {$a->newemail} ལུ་བསྒྱུར་བཅོས་འབད་ནིའི་ཞུ་བ་འབད་ཡི། སྲུང་སྐྱོབ་གནད་དོན་གྱི་དོན་ལུ་ང་བཅས་ཀྱིས་ཁ་བྱང་གསརཔ་འདི་ཁྱོད་ཀྱི་ཨིནམ་ངེས་དཔྱད་འབད་ནིའི་དོན་ལུ་འཕྲིན་དོན་གློག་འཕྲིན་གཏང་དོ། འཕྲིན་དོན་དེ་ནང་གི་ URL་འདི་ཁ་ཕྱེཝ་ཅིག་ ཁྱོད་ཀྱི་གློག་འཕྲིན་ཁ་བྱང་འདི་དུས་མཐུན་བཟོ་དེ་འོང་།';
$string['auth_common_settings'] = 'མཐུན་མོང་ གཞི་སྒྲིག།';
$string['auth_data_mapping'] = 'གནས་སྡུད་ ས་ཁྲ་བཟོ་ནི།';
$string['authenticationoptions'] = 'བདེན་བཤད་ གདམ་ཁ་ཚུ';
$string['auth_fieldlock'] = 'ཨང་རྩིས་ བསྡམ་བཞག།';
$string['auth_fieldlock_expl'] = '<p><b>ཨང་རྩིས་ བསྡམ་བཞག:</b> ལྕོགས་ཅན་བཟོ་དེ་ཡོད་པ་ཅིན་ མུ་ཌེལ་ ལག་ལེན་པ་དང་བདག་སྐྱོང་པ་གིས་ ས་སྒོ་ཐད་ཀར་དུ་ཞུན་དག་འབད་ནི་ལས་སྔོན་བཀག་འབད་འོང་། ཁྱོད་ཀྱིས་གནས་སྡུད་འདི་ཕྱིའི་ auth རིམ་ལུགས་ནང་རྒྱུན་སྐྱོང་འཐབ་ཨིན་པ་ཅིན་ གདམ་ཁ་འདི་ལག་ལེན་འཐབ། </p>';
$string['auth_fieldlocks'] = 'ལག་ལེན་པའི་ས་སྒོ་ཚུ་ བསྡམ་བཞག།';
$string['auth_fieldlocks_help'] = '<p>ཁྱོད་ཀྱིས་ལག་ལེན་པའི་གནས་སྡུད་ས་སྒོ་ཚུ་བསྡམ་བཞག་ཚུགས།
འ་ནི་འདི་ ལག་ལེན་པའི་གནས་སྡུད་འདི་བདག་སྐྱོང་པ་ཚུ་གིས་ ལག་ལེན་པའི་དྲན་ཐོ་ཚུ་ཞུན་འབད་དེ་ལག་ཐོག་ལས་རྒྱུན་སྐྱོང་འཐབ་ནི་ ཡང་ན་ \'ལག་ལེན་ཚུ་ སྐྱེལ་བཙུགས\' མཐུན་རྐྱེན་ལག་ལེན་འཐབ་ཐོག་ལས་སྐྱེལ་བཙུགས་འབད་ཡོད་ས་ལུ་ ཕན་ཐོགས་ཅན་གཅིག་ཨིན།
ཁྱོད་ཀྱིས་མུ་ཌེལ་ལུ་དགོས་མཁོ་ཡོད་མི་ས་སྒོ་ཚུ་བསྡམ་བཞག་པ་ཅིན་ ལག་ལེན་པའི་རྩིས་ཐོ་ཚུ་གསར་བསྐྲུན་འབད་བའི་སྐབས་གནས་སྡུད་འབྱིན་དགོ་ དེ་མེན་པ་ཅིན་ རྩིས་ཐོ་ཚུ་ལཱ་འབད་མི་བཏུབ།</p><p> དཀའ་ངལ་མི་ཐོན་ནིའི་དོན་ལུ་ བསྡམ་ནི་ཐབས་ལམ་འདི་ \'སྟོངམ་ཨིན་པ་ཅིན་ ལྡེ་མིག་ཕྱེ་ཡོད་\' ལུ་གཞི་སྒྲིག་འབད་ནི་ཆ་འཇོག་འབད</p>';
$string['authinstructions'] = 'སྔོན་སྒྲིག་ནང་བསྐྱོད་བསླབ་སྟོན་ཚུ་ ནང་བསྐྱོད་ཤོག་ལེབ་ནང་སྟོན༌ནིའི༌དོན༌ལུ༌ འདི་སྟོངམ་བཞག། སྲོལ་སྒྲིག་ནང་བསྐྱོད་བསླབ་སྟོན་ཚུ་བྱིན་ནི་ཨིན་པ་ཅིན་ འདི་ནང་བཙུག།';
$string['auth_invalidnewemailkey'] = 'འཛོལ་བ: ཁྱོད་གློག་འཕྲིན་ཁ་བྱང་བསྒྱུར་བཅོས་ངེས་དཔྱད་འབདཝ་ཨིན་པ་ཅིན་ གློག་འཕྲིན་ཐོག་ལས་ཁྱོད་ལུ་གཏང་ཡོད་མི་URL་འཕྱི་འགྱུར་འབད་འདྲ་བཤུས་བརྐྱབ་བརྐྱབས་འོང་། ཁ་བྱང་འདི་ལོག་འདྲ་བཤུས་བརྐྱབ་ཞིནམ་ལས་ ལོག་འབད་རྩོལ་བསྐྱེད་གནང་།';
$string['auth_multiplehosts'] = 'སྣ་མང་ཧོསིཊི་ ཡང་ན་ ཁ་བྱང་ཚུ་གསལ་བཀོད་འབད་ཚུགས་(དཔེར་ན་host1.com;host2.com;host3.com) or (དཔེར་ན་xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'ཁྱོད་རའི་གློག་འཕྲིན་ཁ་བྱང་དུས་མཐུན་བཟོ་ནིའི་དོན་ལུ་ དཔའ་བཅམ་རྫོགས་སོ་ནུག། ཁྱོད་ཀྱི་དུས་མཐུན་ཞུ་བ་དེ་ཆ་མེད་གཏང་ཡོདཔ།';
$string['auth_passwordisexpired'] = 'ཁྱོད་ཀྱི་ཆོག་ཡིག་འདི་དུས་ཡོལ་ཐལ་ནུག།
ཆོག་ཡིག་འདི་སོར་ནི་ཨིན་ན?';
$string['auth_passwordwillexpire'] = 'ཁྱོད་ཀྱི་ཆོག་ཡིག་འདི་ཉིམ་{$a}་དུས་ཡོལ་ཐལ་ནི་མས།
ཆོག་ཡིག་འདི་ད་ལྟོ་སོར་ནི་ཨིན་ན?';
$string['auth_remove_delete'] = 'ནང་འཁོད་ ཆ་ཚང་སྦེ་བཏོན་གཏང་།';
$string['auth_remove_keep'] = 'ནང་འཁོད་བཞག';
$string['auth_remove_suspend'] = 'ནང་འཁོད་འཕྲ་བཀག་བཞག';
$string['auth_remove_user'] = 'ཕྱིའི་འབྱུང་ཁུངས་ནང་ལས་ལག་ལེན་པ་རྩ་བསྐྲད་གཏང་ད་མཉམ་འབྱུང་རྒྱ་ཆེ་བ་སྦེ་འབད་བའི་སྐབས་ ནང་འཁོད་ལག་ལེན་པའི་རྩིས་ཐོ་ཚུ་ག་ཅི་འབད་ནི་ཨིན་ན་ གསལ་བཀོད་འབད།
འདི་ཚུ་ ext འབྱུང་ཁུངས་ནང་ལོག་ཐོན་པ་ཅིན་ འཕྲ་བཀག་འབད་ཡོད་མི་ལག་ལེན་པ་ཚུ་རྐྱངམ་གཅིག་རང་བཞིན་གྱིས་བསྐྱར་གསོན་འབདཝ་ཨིན';
$string['auth_remove_user_key'] = 'ext ལག་ལེན་པ་ རྩ་བསྐྲད་གཏང་ཡོདཔ།';
$string['auth_sync_script'] = 'Cron མཉམ་འབྱུང་ ཡིག་ཚུགས།';
$string['auth_updatelocal'] = 'ཉེ་གནས་དུས་མཐུན་བཟོ།';
$string['auth_updatelocal_expl'] = '<p><b>ཉེ་གནས་དུས་མཐུན་བཟོ:</b> ལྕོགས་ཅན་བཟོ་དེ་ཡོད་པ་ཅིན་ ནམ་རང་འབད་རུང་ལག་ལེན་པ་ནང་བསྐྱོད་འབད་བའི་སྐབས་དང་ ལག་ལེན་པ་མཉམ་འབྱུང་འབད་བའི་སྐབས་ (ཕྱིའི་ auth ལས་) ས་སྒོ་འདི་དུས་མཐུན་བཟོ་དེ་འོང་། ཉེ་གནས་སྦེ་དུས་མཐུན་བཟོ་ནི་ལུ་གཞི་སྒྲིག་འབད་ཡོད་མི་ས་སྒོ་ཚུ་བསྡམ་བཞག་དགོ།</p>';
$string['auth_updateremote'] = 'ཕྱིའི་དུས་མཐུན་བཟོ།';
$string['auth_updateremote_expl'] = '<p><b>ཕྱིའི་དུས་མཐུན་བཟོ:</b> ལྕོགས་ཅན་བཟོ་དེ་ཡོད་པ་ཅིན་ ལག་ལེན་པའི་དྲན་ཐོ་དུས་མཐུན་བཟོ་དེ་ཡོད་པའི་སྐབས་ ཕྱིའི་ auth དུས་མཐུན་བཟོ་དེ་འོང་། ཞུན་དག་འབད་བཅུག་ནིའི་དོན་ལུ་ ས་སྒོ་ཚུ་བསྡམ་བཞག་དགོ།</p>';
$string['auth_updateremote_ldap'] = '<p><b>དྲན་འཛིན:</b> ཕྱིའི་LDAP གནས་སྡུད་དུས་མཐུན་བཟོ་ནིའི་དོན་ལུ་ ལག་ལེན་པའི་དྲན་ཐོ་ཆ་མཉམ་ལུ་ཞུན་དག་འབད་ནིའི་ཁེ་དབང་ཡོད་མི་ བཱིནཌི་-ལག་ལེན་པ་ལུ་ binddn དང་ bindpw གཞི་སྒྲིག་དགོ། ད་ལྟོ་འདི་གིས་ སྣ་མང་-བེ་ལུཌི་ ཁྱད་ཆོས་ཚུ་ཉམས་སྲུང་མི་འབདཝ་ཨིནམ་དང་ དུས་མཐུན་བཟོ་བའི་སྐབས་ བེ་ལུ་ཐེབས་ཚུ་རྩ་བསྐྲད་གཏང་འོང་།';
$string['auth_user_create'] = 'ལག་ལེན་གསར་བསྐྲུན་འབད་ནི་དུས་མཐུན་བཟོ།';
$string['auth_user_creation'] = 'ལག་ལེན་པ་གསརཔ་(མིང་མེད་མི་)ཚུ་གིས་ ཕྱིའི་བདེན་བཤད་འབྱུང་ཁུངས་གུ་ལག་ལེན་པའི་རྩིས་ཐོ་གསར་བསྐྲུན་འབད་དེ་གློག་འཕྲིན་ཐོག་ལས་ངེས་དཔྱད་འབད་ཚུགས། ཁྱོད་ཀྱིས་འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པ་གསར་བསྐྲུན་གྱི་དོན་ལུ་ མོ་ཌུལ་-དམིགས་བསལ་གདམ་ཁ་ཚུ་རིམ་སྒྲིག་འབད་ནི་སེམས་ཁར་བཞག།';
$string['auth_usernameexists'] = 'སེལ་འཐུ་འབད་ཡོད་མི་ལག་ལེན་པའི་མིང་ཧེ་མ་ལས་རང་འདུག། གསརཔ་གཅིག་གདམ་ཁ་བརྐྱབ་གནང་།';
$string['auto_add_remote_users'] = 'ཐག་རིང་ལག་ལེན་པ་ཚུ་རང་བཞིན་གྱིས་ཁ་སྐོང་རྐྱབས།';
$string['changepassword'] = 'ཆོག་ཡིག་བསྒྱུར་བཅོས་ URL';
$string['changepasswordhelp'] = 'ནཱ་ལུ་ལག་ལེན་པ་ཚུ་གིས་ལག་ལེན་པའི་མིང་/ཆོག་ཡིག་ ག་དེམ་ཅིག་སྦེ་བརྗེད་པ་ཅིན་སླར་གསོ་འབད་ནི་ ཡང་ན་ བསྒྱུར་བཅོས་འབད་ནིའི་དོན་ལུ་གནས་ཁོངས་གསལ་བཀོད་འབད་ཆོག། འདི་ ལག་ལེན་པ་ཚུ་ལུ་ནང་བསྐྱོད་ཤོག་ལེབ་དང་ལག་ལེན་པའི་ཤོག་ལེབ་གུ་ཨེབ་རྟ་སྦེ་བྱིན་ཏེ་འོང་། ག་དེམ་ཅིག་སྦེ་འདི་སྟོངམ་སྦེ་བཞག་པ་ཅིན་ ཨེབ་རྟ་འདི་མི་འོང་།';
$string['chooseauthmethod'] = 'བདེན་བཤད་ཐབས་ལམ་གདམ་ཁ་རྐྱབས།';
$string['chooseauthmethod_help'] = 'ལག་ལེན་པ་ནང་བསྐྱོད་འབད་བའི་བསྒང་་གཞི་སྒྲིག་དི་གིས་བདེན་བཤད་ཐབས་ལམ་ལག་ལེན་ག་ཅི་འཐབ་ཅིག་ག་ཏན་ཏན་བཟོ་ཨིན།
ལྕོགས་ཅན་བཟོ་ཡོད་པའི་བདེན་བཤད་པ་ལག་ཨིན་ཚུ་
གདམ་ཁ་བརྐྱབས་དགོ་ དེ་མེན་ལག་ལེན་པ་གིས་ནང་བསྐྱོད་ཙ་ལས་འབད་མི་ཚུགས། ལག་ལེན་པ་ནང་བསྐྱོད་འབད་ནི་བཀག་ནིའི་དོན་ལུ་"ནང་སྐྱོད་ མེད"་ལག་ལན་འཐབ།';
$string['createpassword'] = 'ཆོག་ཡིག་བཟོ་ཞིནམ་ལས་ ལག་ལེན་པ་ལུ་ བརྡ་ཕྲིན་སྤྲོད།';
$string['createpasswordifneeded'] = 'དགོས་མཁོ་ཡོད་པ་ཅིན་ ཆོག་ཡིག་གསར་བསྐྲུན་འབད';
$string['emailchangecancel'] = 'གློག་འཕྲིན་བསྒྱུར་བཅོས་ཆ་མེད་གཏང་།';
$string['emailchangepending'] = 'བསྒྱུར་བཅོས་ཐག་མ་ཆོད།
{$a->preference_newemail} ་ལུ་གཏང་ཡོད་པའི་འབྲེལ་ལམ་ཁ་ཕྱེ།';
$string['emailnowexists'] = 'ཁྱོད་རའི་གསལ་སྡུད་ནང་གློག་འཕྲིན་ཁ་བྱང་ལཱ་སྐལ་ནི་དཔའ་བཅམ་འདི་མི་ཅིག་ཁྱོད་ཀྱིས་ཧེན་མ་ལས་ལཱ་སྐལ་ཡོད། གློག་འཕྲིན་ཁ་བྱང་བསྒྱུར་བཅོས་ཞུ་བ་འབད་མི་ད་ལས་ཆ་མེད་གཏང་ཡོད་ དེ་སྦེཝ་ད་སོ་སོ་ཁ་བྱང་ལཱ་སྐལ་གནང་།';
$string['emailupdate'] = 'གློག་འཕྲིན་ཁ་བྱང་དུས་མཐུན་བཟོ';
$string['emailupdatemessage'] = 'བརྩེ་བའི་{$a->fullname}་ཁྱོད་ ཀྱིས་ {$a->site}་ནང་ལག་ལེན་པའི་རྩིས་ཐོ་གིས་གློག་འཕྲིན་ཁ་བྱང་བསྒྱུར་བཅོས་ཞུ་བ་འབད་ནུག།
ངེས་དཔྱད་འབད་ནི་དོན་ལུ་འོག་གི་ URL་དེ་བརའུ་ཟར་ནང་ཁ་ཕྱེ་གནང་།
{$a->url}';
$string['emailupdatesuccess'] = 'ལག་ལེན་པ་<em>{$a->fullname}</em>གིས་གློག་འཕྲིན་ཁ་བྱང་དེ་<em>{$a->email}</em>་ལུ་མཐར་འཁྱོལ་སྦེ་དུས་མཐུན་བཟོ་ཡོད།';
$string['emailupdatetitle'] = 'གློག་འཕྲིན་ཁ་བྱང་་དུས་མཐུན་གཏན་འཁེལ་ན་ལས་{$a->site}་བཟོ།';
$string['enterthenumbersyouhear'] = 'ཁྱོད་ཀྱིས་གོ་མི་ཨང་ཚུ་བཙུགས།';
$string['enterthewordsabove'] = 'ལྟག་གི་མིང་ཚིག་ཚུ་བཙུགས།';
$string['errormaxconsecutiveidentchars'] = 'ཆོག་ཡིག་ནང་རིམ་མཐུད༌ཡིག་འབྲུ༌ཅོག་གཅིག་པ༌མང་ཤོས༌{$a}་དགོ།';
$string['errorminpassworddigits'] = 'ཆོག་ཡིག་ནང་ཨང་ཡིག་(ཚུ་)་ཉུང་མཐའ་{$a} དགོ།';
$string['errorminpasswordlength'] = 'ཆོག་ཡིག་ནང་ཡིག་འབྲུ༌རིངམ་ཉུང་མཐའ་ {$a}༌དགོ།';
$string['errorminpasswordlower'] = 'ཆོག་ཡིག་ནང་མགྱོགས་ཡིག(ཚུ) ཉུང་མཐའ་ {$a}  དགོ།';
$string['errorminpasswordnonalphanum'] = 'ཆོག་ཡིག་ནང་དབྱངས་གསལ་ཨང་གྲངས་མིན་པའི་ཡིག་འབྲུ་ {$a} དགོ།';
$string['errorminpasswordupper'] = 'ཆོག་ཡིག་ནང་ཚུགས་ཡིག(ཚུ)་ ཉུང་མཐའ་ $a དགོ།';
$string['errorpasswordupdate'] = 'ཆོག་ཡིག་དུས་མཐུན་བཟོ་བའི་བསྐབ་འཛོལ་བ་འབྱུང་ཡི་
 ཆོག་ཡིག་བསྒྱུར་བཅོས་མ་འབད།';
$string['event_user_loggedin'] = 'ལག་ལེན་པ་ནང་ན་འཛུལ་ཡོདཔ།';
$string['eventuserloggedinas'] = 'ལག་ལེན་པ་ ལག་ལེན་པ་སོ་སོ་སྦེ་ ནང་འཛུལ་འབད་ཡོདཔ།';
$string['forcechangepassword'] = 'ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་བཅུག།';
$string['forcechangepasswordfirst_help'] = 'ལག་ལེན་པ་ཚུ་ལུ་ མུ་ཌེལ་ནང་འགོ་དང་པ་ནང་བསྐྱོད་འབད་བའི་སྐབས་ ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་བཅུག།';
$string['forcechangepassword_help'] = 'ལག་ལེན་པ་ཚུ་ལུ་ མུ་ཌེལ་ནང་འདི་གི་ཤུལ་ལས་ནང་བསྐྱོད་འབད་བའི་སྐབས་ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་བཅུག།';
$string['forgottenpassword'] = 'ནཱ་ལུ་ URL་བཙུག་པ་ཅིན་ འདི་ས་ཁོངས་འདི་གི་དོན་ལུ་བརླག་སྟོར་ཞུགས་ཡོད་མི་ཆོག་ཡིག་སླར་གསོ་ཤོག་ལེབ་སྦེ་ལག་ལེན་འཐབ་སྟེ་འོང་། འདི་ མུ་ཌེལ་གྱི་ཕྱི་ཁ་ལུ་ཆོག་ཡིག་ཚུ་ཧྲིལ་བུ་སྦེ་ ལེགས་སྐྱོང་འཐབ་ཡོད་པའི་ས་ཁོངས་ཚུ་གི་དོན་ལུ་ཨིན། སྔོན་སྒྲིག་ཆོག་ཡིག་སླར་གསོ་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ འདི་སྟོངམ་སྦེ་བཞག།';
$string['forgottenpasswordurl'] = 'བརྗེད་དེ་ཡོད་མི་ཆོག་ཡིག་ ཡུ་ཨར་ཨེལ།';
$string['getanaudiocaptcha'] = 'རྣར་ཉན་ CAPTCHA ལེན།';
$string['getanimagecaptcha'] = 'གཟུགས་བརྙན་ CAPTCHA ལེན།';
$string['getanothercaptcha'] = 'CAPTCHA གཞན་གཅིག་ལེན།';
$string['guestloginbutton'] = 'མགྱོནམ་ནང་བསྐྱོད་ཨེབ་རྟ།';
$string['incorrectpleasetryagain'] = 'བདེན་མེད། ལོག་རྩོལ་བསྐྱེད་གནང་།';
$string['infilefield'] = 'ཡིག་སྣོད་ནང་དགོ་པའི་ས་སྒོ།';
$string['informminpassworddigits'] = 'ཨང་ཡིག༌ཉུང་མཐའ་ {$a}';
$string['informminpasswordlength'] = 'ཡིག༌འབྲུ༌ཉུང་མཐའ་ {$a}';
$string['informminpasswordlower'] = 'མགྱོགས་ཡིག(ཚུ)༌ཉུང་མཐའ་ {$a}';
$string['informminpasswordnonalphanum'] = 'དབྱངས་གསལ་ཨང་གྲངས་མ་ཡིན་པའི་ཡིག་འབྲུ་ཉུང་མཐའ་ {$a}';
$string['informminpasswordupper'] = 'ཚུགས་ཡིག༌ཉུང་མཐའ་ {$a}';
$string['informpasswordpolicy'] = 'ཆོག་ཡིག་ནང་{$a}་དགོ';
$string['instructions'] = 'བསླབ་སྟོན་ཚུ་';
$string['internal'] = 'ནང་འཁོད';
$string['locked'] = 'བསྡམ་བཞག་ཡོདཔ།';
$string['md5'] = 'MD5 hash';
$string['nopasswordchange'] = 'ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་མི་བཏུབ།';
$string['nopasswordchangeforced'] = 'ཁྱོད་རའི་ཆོག་ཡིག་བསྒྱུར་བཅོས་མ་འབད་བ་ འཕྲོ་མཐུད་དེ་འབད་མི་ཚུགས་ འདི་འབདཝ་ད་ འདི་བསྒྱུར་བཅོས་འབད་ནིའི་དོན་ལུ་ ཤོག་ལེབ་མིན་འདུག། ཁྱོད་རའི་ Moodle་བདག་སྐྱོང་པ་ལུ་འབྲེལ་བ་འཐབ།';
$string['noprofileedit'] = 'གསལ་སྡུད་འདི་ཞུན་དག་འབད་མ་ཚུགས';
$string['ntlmsso_attempting'] = 'NTLM བརྒྱུད་དེ་ ནང་བསྐྱོད་རྐྱང་པ་དཔའ་བཅམ་དོ་་་་';
$string['ntlmsso_failed'] = 'རང་བཞིན་-ནང་བསྐྱོད་འཐུས་ཤོར་བྱུང་ཡོདཔ། སྤྱིར་གཏང་ནང་བསྐྱོད་ཤོག་ལེབ་འབད་བསྐྱེད་་་';
$string['ntlmsso_isdisabled'] = 'NTLM SSO ལྕོགས་མིན་བཟོ་ཡོདཔ།';
$string['passwordhandling'] = 'ཆོག་ཡིག་ས་སྒོ་ལེགས་སྐྱོང་འཐབ་པ།';
$string['plaintext'] = 'ཚིག་ཡིག་ཉག་རྐྱང་།';
$string['pluginnotenabled'] = 'བདེན་བཤད་ plugin \'{$a}\' ལྕོགས་ཅན་མ་བཟོ་བས།';
$string['pluginnotinstalled'] = 'བདེན་བཤད་ plugin \'{$a}\'གཞི་བཙུགས་མ་འབད་བས།';
$string['potentialidps'] = 'ཡོངས་ཀྱི་རྩིས་ཐོ་ལག་ལེན་འཐབ་སྟེ་ནང་བསྐྱོད་འབད:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA ་འདི་གིས་རང་བཞིན་ལས་རིམ་ཚུ་ལོག་སྤྱོད་བཀག་ནི་དོན་ལུ་ཨིན། འཇམ་སམ་སྦེ་མིང་ཚིག་ཚུ་གོ་རིམ་དང་བར་སྟོང་གི་སོ་སོ་འཕྱལ་ཏི་་སྒྲོམ་ནང་བཙུགས། མིང་ཚིག་ཚུ་ངེས་གཏན་སྦེ་མ་ཤེས་པ་ཅིན་CAPTCHA་གཞན་་ཡང་ན་རྣར་ཉན་ CAPTCHA་ཅིག་ལེན།';
$string['selfregistration'] = 'རང་གིས་ཐོ་བཀོད་འབད་ནི།';
$string['selfregistration_help'] = 'གློག་འཕྲིན་གཞི་བཞག་གི་ རང་གི་ཐོ་བཀོད་འབད་ནིའི་ དེན་བཤད་plugin་འཐུ་འབད་དེ་ཡོད་པ་ཅིན་འདི་གིས་འོས་འབབ་ཡོད་པའི་ལག་ལེན་པ་ཚུ་ལུ་ཁོང་ར་གིས་ཐོ་བཀོད་འབད་ནི་དང་རྩིས་ཐོ་གསར་བསྐྲུན་འབད་ནི་ལྕོགས་ཅན་བཟོཝ་ཨིན། འདི་གིས་ spam་གྱི་དོན་ལུ་ spammers ་གྲོས་གནས་བརྡ་འཕྲིན་དང་ དྲན་དེབ་ཐོ་བཀོད་ལ་སོགས་པ་ཚུ་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ རྩིས་ཐོ་གསར་བསྐྲུན་འབད་བཅུགཔ་ཨིན། ཉེན་ཁ་འདི་ལས་འཛེམ་ནིའི་དོན་ལུ་ རང་གིས་ཐོ་བཀོད་འབད་ནི་ལྕོགས་མིན་བཟོ་དགོཔ་དང་ ཡང་ན་ <em>
གློག་འཕྲིན་ཌོ་མེན་ཆོག་མི་ཚུ་</em> གཞི་སྒྲིག་ཚད་འཛིན་འབད་དགོ།';
$string['sha1'] = 'SHA-1 ཧེཤི།';
$string['showguestlogin'] = 'ནང་བསྐྱོད་ཤོག་ལེབ་གུ་ ཁྱོད་ཀྱིས་མགྱོནམ་གྱི་ནང་བསྐྱོད་ཨེབ་རྟ་ སྦ་ནི་དང་ ཡང་ན་ སྟོན་ནི་ཚུ་འབད་ཆོག།';
$string['stdchangepassword'] = 'ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་ནི་དོན་ལུ་ ཚད་ལྡནཤོག་ལེབ་ལག་ལེན་འཐབ།';
$string['stdchangepassword_expl'] = 'ཕྱིའི་བདེན་བཤད་རིམ་ལུགས་ཀྱིས་Moodle་བརྒྱུད་དེ་ ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་བཅུག་པ་ཅིན་ འདི་ ཨིན་ ལུ་སོར་བསྒྱུར་འབད། གཞི་སྒྲིག་འདི་གིས་ \'ཆོག་ཡིག་བསྒྱུར་བཅོས་ URL མེདཔ་གཏངམ་ཨིན།';
$string['stdchangepassword_explldap'] = 'དྲན་འཛིན: LDAP སར་བར་ཐག་རིང་ཨིན་པ་ཅིན་ ཁྱོད་ལུ་ LDAP over an SSL encrypted tunnel (ldaps://) འོས་བྱོར་འབད་ལག་ལེན་འཐབ།';
$string['suspended'] = 'འཕྲལ་བཀག༌བཞག༌པའི༌རྩིས་ཐོ།';
$string['suspended_help'] = 'འཕྲལ་བཀག༌བཞག༌པའི༌ལག༌ལེན༌པའི༌རྩིས་ཐོ༌ཚུ༌ལུ༌ནང་བསྐྱོད༌འབད༌མི༌ཡང༌ན༌
ཝེབ༌ཞབས་ཏོག༌ལག༌ལེན༌འཐབ༌མི༌བཚུགས༌
ནི༌དང༌ཕྱིར་བསྐྱོད་འཕྲིན་དོན༌ཚུ༌བཏོན་བཀོག༌བཞགཔ༌ཨིན།


འཕྲིན་དོན།';
$string['testsettings'] = 'བརྟག་དཔྱད་ གཞི་སྒྲིག';
$string['unlocked'] = 'ལྡེ་མིག་ཕྱེ་ཡོད།';
$string['unlockedifempty'] = 'སྟོངམ་ཨིན་པ་ཅིན་ལྡེ་མིག་ཕྱེ་ཡོད།';
$string['update_never'] = 'ནམ་ཡང་།';
$string['update_oncreate'] = 'གསར་བསྐྲུན་འབད་བའི་སྐབས་ལུ།';
$string['update_onlogin'] = 'ནང་བསྐྱོད་ཚར་རེ་འབད་བའི་སྐབས་ལུ།';
$string['update_onupdate'] = 'དུས་མཐུན་བཟོ་བའི་སྐབས་ལུ།';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() གིས༌སེལ་འཐུ་གྲུབ་པའི༌ལག༌ལེན༌པ༌དབྱེ་བ: {$a}༌ལུ༌རྒྱབ་སྐྱོར༌མེད།';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() གིས༌སེལ་འཐུ་གྲུབ་པའི༌ལག༌ལེན༌པ༌དབྱེ་བ༌ལུ༌རྒྱབ་སྐྱོར༌མེད(..དེ༌འབད༌རུང)';
