<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = '이 질문을 미리 볼 수는 있지만, 이게 실제 시험이라면 다음과 같은 이유 때문에 볼 수 없게 됩니다:';
$string['action'] = '활동';
$string['activityoverview'] = '제출예정인 퀴즈가 있습니다.';
$string['adaptive'] = '적응 모드';
$string['adaptive_help'] = '만일 이를 활성화하면, 한 질문에 대해 여러번 답을 할 수 있게 됩니다. 따라서 비록 학생의 답이 틀렸다고 하더라도, 즉시 몇 번이고 다시 질문을 시도할 수 있습니다. 하지만 "감점 적용" 설정에 따라 학생이 오답을 할 때에는 감점이 될 수도 있습니다.';
$string['addaquestion'] = '질문 추가 ...';
$string['addarandomquestion'] = '무작위 질문 추가 ...';
$string['addarandomquestion_help'] = '무작위 질문을 추가할 때에는 퀴즈 내 범주에서 무작위로 추출된  질문이 제시됩니다. 이는 학생 개개인이 서로 다른 질문을 받게 된다는 뜻이며, 학생들에게 여러번 시도가 주어질 때에는 그 때마다 다른 질문을 제시받게 된다는 것을 의미합니다.';
$string['adddescriptionlabel'] = '설명/표지 추가';
$string['addingquestion'] = '질문 추가';
$string['addingquestions'] = '이곳에서 질문에 관계된 데이터베이스를 관리할 수 있습니다. 질문은 손쉽게 관리할 수 있게끔 범주별로 저장되고, 또한 \'개방\'한다면 선택한 강좌 혹은 다른 강좌에서도 이를 사용할 수 있습니다.<br /><br />범주를 선택하거나 생성한 후 질문을 편집할 수 있습니다. 어떠한 질문이라도 다른 질문 은행의 범주에 추가될 수 있습니다.';
$string['addmoreoverallfeedbacks'] = '피드백 항목 추가';
$string['addnewgroupoverride'] = '모둠 추가 덮어쓰기';
$string['addnewpagesafterselected'] = '선택된 질문 뒤에 새 페이지 추가';
$string['addnewquestionsqbank'] = '범주 {$a->catname}: {$a->link} 에 질문 추가 >>';
$string['addnewuseroverride'] = '사용자 추가 덮어쓰기';
$string['addpagehere'] = '여기에 새 페이지 추가';
$string['addquestion'] = '질문 추가';
$string['addquestions'] = '질문 추가';
$string['addquestionstoquiz'] = '현재 퀴즈에 질문 추가하기';
$string['addrandom'] = '무작위 질문 {$a} 추가';
$string['addrandom1'] = '<< 추가';
$string['addrandom2'] = '무작위 질문';
$string['addrandomfromcategory'] = '범주에서 무작위 질문 추가';
$string['addrandomquestion'] = '무작위 질문 추가';
$string['addrandomquestiontoquiz'] = '퀴즈 {$a} 에 무작위 질문 추가';
$string['addselectedtoquiz'] = '선택한 것을 퀴즈에 추가';
$string['addtoquiz'] = '퀴즈에 추가';
$string['affectedstudents'] = '변경된 {$a}';
$string['aftereachquestion'] = '매 질문 추가 후';
$string['afternquestions'] = '{$a} 질문 추가 후';
$string['age'] = '연령';
$string['allattempts'] = '모든 시도들';
$string['allinone'] = '무제한';
$string['allowreview'] = '검토 허용';
$string['alreadysubmitted'] = '이 시도를 이미 제출한 듯 함';
$string['alternativeunits'] = '대체 단위';
$string['alwaysavailable'] = '항상 가능';
$string['analysisoptions'] = '분석 옵션';
$string['analysistitle'] = '항목 분석표';
$string['answer'] = '정답';
$string['answered'] = '응답했음';
$string['answerhowmany'] = '단답 혹은 복수의 답?';
$string['answers'] = '답안';
$string['answersingleno'] = '복수의 답 인정';
$string['answersingleyes'] = '단답만 가능';
$string['answertoolong'] = '{$a} 째 줄의 답이 너무 김';
$string['aon'] = 'AON 형식';
$string['areyousureremoveselected'] = '정말 선택한 모든 질문들을 삭제하겠습니까?';
$string['asshownoneditscreen'] = '편집 순서 대로';
$string['attempt'] = '{$a} 차 시도';
$string['attemptalreadyclosed'] = '이 시도는 이미 종료되었습니다.';
$string['attemptclosed'] = '아직 시도를 마치지 않았음';
$string['attemptduration'] = '소비 시간';
$string['attemptedon'] = '시도 중';
$string['attempterror'] = '이번에는 퀴즈 시도가 허용되지 않습니다. 이유 :';
$string['attemptfirst'] = '첫번째 시도';
$string['attemptincomplete'] = '시도({$a} 회까지)가 아직 종료되지 않았습니다.';
$string['attemptlast'] = '마지막 시도';
$string['attemptnumber'] = '시도';
$string['attemptquiznow'] = '퀴즈 풀기 시작';
$string['attempts'] = '시도';
$string['attemptsallowed'] = '허용된 시도';
$string['attemptsdeleted'] = '시도가 삭제됨';
$string['attemptselection'] = '분석할 시도 선택:';
$string['attemptsexist'] = '더 이상 질문을 추가하거나 삭제할 수 없습니다.';
$string['attemptsnum'] = '시도: {$a}';
$string['attemptsnumthisgroup'] = '시도: {$a->total} (이 모둠에서 {$a->group})';
$string['attemptsnumyourgroups'] = '시도: {$a->total} (당신의 모둠에서 {$a->group})';
$string['attemptsonly'] = '시도한 학습자만 보기';
$string['attemptstate'] = '상태';
$string['attemptstillinprogress'] = '시도가 아직 진행중입니다.';
$string['attemptsunlimited'] = '무한정 시도';
$string['autosaveperiod'] = '자동 저장 기간';
$string['back'] = '이전 질문으로 돌아가기';
$string['backtocourse'] = '강좌로 돌아가기';
$string['backtoquestionlist'] = '질문목록으로 돌아가기';
$string['backtoquiz'] = '질문 편집으로 이동';
$string['basicideasofquiz'] = '퀴즈 작성 요령';
$string['bestgrade'] = '최고 성적';
$string['bothattempts'] = '시도를 한 학생과 하지 않은 학생 보기';
$string['browsersecurity'] = '브라우저 보안';
$string['browsersecurity_help'] = '만일 "자바 보안 전체 화면 팝업" 이 선택되면

* 퀴즈는 학생이 자바스크립트가 활성화 되어 있는 웹브라우저를 사용할때만 시작됩니다.
* 퀴즈는 다른 모든 창을 덮고 찾아가기 컨트롤이 없는 전체화면 팝업 창에 나타납니다.
* 학생들은  복사 및 붙여넣기 같은 기능을 가능한 사용하지 못하게 됩니다.';
$string['calculated'] = '수식계산형';
$string['calculatedquestion'] = '{$a} 번째 줄에 지원되지 않는 계산형 질문. 이 질문은 무시됩니다.';
$string['cannotcreatepath'] = '({$a})경로를 생성할 수 없음';
$string['cannoteditafterattempts'] = '이 퀴즈는 이미 푼 학생이 있기 때문에 질문을 추가하거나 삭제할 수 없습니다. ({$a})';
$string['cannotfindprevattempt'] = '처리할 이전의 시도가 없습니다.';
$string['cannotfindquestionregard'] = '재 채점를 위한 질문 가져오기 실패';
$string['cannotinsert'] = '질문을 삽입할 수 없음';
$string['cannotinsertrandomquestion'] = '새로운 무작위 질문을 삽입할 수 없음';
$string['cannotloadquestion'] = '질문 옵션을 탑재할 수 없음';
$string['cannotloadtypeinfo'] = '질문 유형에 특정적인 정보를 탑재할 수 없음';
$string['cannotopen'] = '내보내기 파일({$a})을 열 수 없음';
$string['cannotrestore'] = '질문 세션을 복구할 수 없음';
$string['cannotreviewopen'] = '아직 열려있다고 하더라도, 이 시도를 재검토할 수는 없습니다.';
$string['cannotsavelayout'] = '서식을 저장할 수 없음';
$string['cannotsavenumberofquestion'] = '페이지 당 질문수를 저장할 수 없음';
$string['cannotsavequestion'] = '질문 목록을 저장할 수 없음';
$string['cannotsetgrade'] = '퀴즈의 최대 성적을 새로 설정할 수 없음';
$string['cannotsetsumgrades'] = '누계성적 산출 실패';
$string['cannotstartmissingquestion'] = '이 퀴즈에서 시도를 시작할 수 없습니다. 퀴즈가 존재하지 않는 질문을 포함하고 있습니다.';
$string['cannotwrite'] = '내보내기 파일({$a})에 쓸 수 없음';
$string['caseno'] = '아니오, 대소문자는 중요치 않음';
$string['casesensitive'] = '대소문자 구별';
$string['caseyes'] = '네, 대소문자는 정확히 일치해야 함';
$string['categories'] = '범주들';
$string['category'] = '범주';
$string['categoryadded'] = '범주 \'{$a}\' 추가됨';
$string['categorydeleted'] = '범주 \'{$a}\' 삭제됨';
$string['categorynoedit'] = '\'{$a}\'범주를 편집할 수 있는 권한이 없습니다.';
$string['categoryupdated'] = '범주 업데이트 성공';
$string['close'] = '창 닫기';
$string['closebeforeopen'] = '퀴즈를 업데이트 할 수 없음. 퀴즈 여는 날을 마감날짜보다 이르게 지정해야 합니다.';
$string['closed'] = '닫힘';
$string['closepreview'] = '미리보기 닫기';
$string['closereview'] = '다시보기 닫기';
$string['comment'] = '덧글';
$string['commentorgrade'] = '덧글 혹은 성적 덮어쓰기';
$string['comments'] = '덧글';
$string['completedon'] = '완료됨';
$string['configadaptive'] = '예를 선택하게 되면 학생들은 시도 중 한  질문에 대해 여러번 응답을 할 수 있게 된다.';
$string['configattemptsallowed'] = '퀴즈를 볼 수 있는 최대 시도 수';
$string['configdecimaldigits'] = '성적 표시할 때 보여줄 소숫점 자릿 수';
$string['configdecimalplaces'] = '퀴즈의 점수를 표시할 때의 소숫점 자리 수';
$string['configdecimalplacesquestion'] = '개별 질문 점수를 표시할 때의 소숫점 자리 수';
$string['configdelay1'] = '첫번째 시도 후 다음 시도까지의 대기 시간을 설정';
$string['configdelay1st2nd'] = '여기에 대기 시간을 설정해 놓으면, 학생들은 첫번째 시도 후 여기 적힌 시간이 경과하기 전에는 두번째 시도를 할 수 없게 된다.';
$string['configdelay2'] = '세번째 혹은 그 이후 시도까지 대기할 시간 설정';
$string['configdelaylater'] = '여기에 대기 시간을 설정해 놓으면, 학생들은 시도 후 여기 적힌 시간이 경과하기 전에는 세번째 혹은 네번째 등, 다음 시도를 할 수 없게 된다.';
$string['configeachattemptbuildsonthelast'] = '여러번 시도를 허용할 때 이전 시도 결과를 포함시킬지의 여부';
$string['configgrademethod'] = '여러번 시도를 허용할 때 최종 퀴즈 결과를 어떤 방법으로 산출할 것인지를 선택';
$string['configintro'] = '새 퀴즈를 만들 때 사용할 기본 양식 설정. 어떤 퀴즈 양식을 고급형으로 지정할 지를 설정할 수 있음';
$string['configmaximumgrade'] = '퀴즈 성적 산출을 위한 기본 등급 형태';
$string['confignewpageevery'] = ' 질문을 추가할 때 자동적으로 페이지 분할이 삽입될 수 있도록 설정 방법 선택';
$string['configpenaltyscheme'] = '적응 모드에서 오답에 대한 감점 설정';
$string['configpopup'] = '강제적으로 시도를 팝업창에서 열도록 하고 시험 중 복사 및 붙이기를 제한하기 위해 자바스크립트 사용';
$string['configrequirepassword'] = '시험을 보기위해 반드시 암호를 입력해야 함';
$string['configrequiresubnet'] = '학생들이 특정 컴퓨터로만 응시할 수 있게 함';
$string['configreviewoptions'] = '시험을 검토할 때 혹은 시험 보고서를 살펴볼 때 사용자들이 볼 수 있는 정보를 조정';
$string['configshowblocks'] = '퀴즈 푸는 중 블록 보임';
$string['configshowuserpicture'] = '시도 중 화면에 사용자 사진 보임';
$string['configshufflequestions'] = '이 기능을 켜면, 시험지의  질문 순서가 학생들이 시도할 때마다 매번 무작위로 바뀌게 될 것임';
$string['configshufflewithin'] = '이 기능을 활성화하고, 질문 설정에서 옵션이 활성화하면, 학생이 퀴즈에서 시도할 때마다 개개  질문을 구성하는 부분들이 매번 무작위로 섞이게 됩니다.';
$string['configtimelimit'] = '분 단위의 기본 응시 시간. 0은 무제한';
$string['configtimelimitsec'] = '초 단위의 기본 응시 시간. 0은 무제한';
$string['configurerandomquestion'] = '질문 구성';
$string['confirmclose'] = '당신은 이 시도를 끝내려고 합니다. 일단 시도를 종료하면 더 이상 답을 고칠 수 없습니다.';
$string['confirmserverdelete'] = '당신은 정말 서버 <b>{$a}</b>를 목록에서 삭제하겠습니까?';
$string['confirmstartattemptlimit'] = '허용된 시도 수: {$a}. 퀴즈에 들어가면 1회의 기회를 쓰게 됩니다. 계속 하겠습니까?';
$string['confirmstartattempttimelimit'] = '이 퀴즈는 시간 제한이 있으며 {$a} 회의 시도만 허용됩니다. 퀴즈에 들어가면 1회의 기회를 쓰게 됩니다. 계속 하시겠습니까?';
$string['confirmstarttimelimit'] = '이 퀴즈는 시간 제한이 있습니다. 정말 시작하시겠습니까?';
$string['containercategorycreated'] = '처음 만들어진 범주 안에 생성된 모든 것들은 그 범주가 사라지더라도 그 상위 범주에 모두 저장됩니다.';
$string['continueattemptquiz'] = '지난번 시도 계속';
$string['continuepreview'] = '미리보기 계속';
$string['copyingfrom'] = '\'{$a}\' 질문 복사하기';
$string['copyingquestion'] = '질문 복사하기';
$string['correct'] = '맞음';
$string['correctanswer'] = '정답';
$string['correctanswerformula'] = '정답 공식';
$string['correctansweris'] = '정답 : {$a}';
$string['correctanswerlength'] = '유효 숫자';
$string['correctanswers'] = '옳은 답들';
$string['correctanswershows'] = '정답제시형태';
$string['corrresp'] = '정답에 대한 반응';
$string['countdown'] = '초읽기시작.(10,9,8...,0)';
$string['countdownfinished'] = '이 퀴즈는 닫힙니다. 당신의 답을 지금 제출하여 주시기 바랍니다.';
$string['countdowntenminutes'] = '퀴즈는 10분 후 종료될 것입니다.';
$string['coursetestmanager'] = 'CTM 형식';
$string['createcategoryandaddrandomquestion'] = '범주를 만들고 무작위 질문 추가';
$string['createfirst'] = '우선 주관식 단답형 질문을 만들어야 합니다.';
$string['createmultiple'] = '퀴즈에 여러 무작위 질문 추가';
$string['createnewquestion'] = '새 질문 생성';
$string['createquestionandadd'] = '질문 작성 및 퀴즈에 추가';
$string['custom'] = '사용자 포멧';
$string['dataitemneed'] = '질문이 유효하려면 적어도 한 쌍 이상의 자료항목이 추가되어야 함';
$string['datasetdefinitions'] = '범주 {$a} 에 대한 재사용 가능한 숫자집합 정의';
$string['datasetnumber'] = '수';
$string['daysavailable'] = '가능한 날';
$string['decimaldigits'] = '소숫점 처리';
$string['decimalplaces'] = '성적의 소숫점 자리 수';
$string['decimalplaces_help'] = '이 설정들 통해서 학생들의 점수나 성적을 표시할 때 소수 몇째 자리까지 표시해야 할 것인지를 정할 수 있습니다. 이 설정은 점수를 표시할 때만 영향을 미치며, 데이터베이스에 저장된 성적이나 최대 정밀도로 수행되는 내부 계산에는 영향을 주지 않습니다.';
$string['decimalplacesquestion'] = '퀴즈 성적의 소숫점 자리 수';
$string['decimalplacesquestion_help'] = '이 설정은 개별 질문에 대한 성적을 표시할때 소숫점 몇 자리까지 표시할 것인가를 명시합니다.';
$string['decimalpoints'] = '소수점';
$string['default'] = '기본설정';
$string['defaultgrade'] = '기본 질문 성적';
$string['defaultinfo'] = '질문의 기본 범주';
$string['delay1'] = '1,2차 시도사이 시간 간격';
$string['delay1st2nd'] = '1,2차 시도사이 대기 시간을 둠';
$string['delay1st2nd_help'] = '<p>퀴즈를 풀 때 시간차를 설정해 놓으면, 학생들은 첫 시도와 두번째 시도 사이에 일정 시간 동안 기다려야만 한다.</p>';
$string['delay2'] = '이전 시도 후 시간 간격';
$string['delaylater'] = '차기 시도사이에 대기 시간을 둠';
$string['delaylater_help'] = '<p>여기에 시간차를 설정해 놓으면 학생들은 퀴즈를 풀 때 세번째 혹은 그 이후 시도 사이에 일정한 시간 동안 기다려야만 한다.
</p>';
$string['deleteattemptcheck'] = '정말 이 시도를 취소하겠습니까?';
$string['deleteselected'] = '선택내용 지우기';
$string['deletingquestionattempts'] = '퀴즈 시도 삭제';
$string['description'] = '설명';
$string['disabled'] = '불가';
$string['displayoptions'] = '선택사항 보이기';
$string['donotuseautosave'] = '자동 저장 사용하지 않음';
$string['download'] = '내보낸 항목파일을 다운로드하려면 클릭';
$string['downloadextra'] = '(파일은 강좌의 /backupdata/quiz에도 저장되었음)';
$string['duplicateresponse'] = '이전에도 같은 답을 했기 때문에 이 제출은 무시되었습니다.';
$string['eachattemptbuildsonthelast'] = '각 시도는 마지막 시도에 누적됩니다.';
$string['eachattemptbuildsonthelast_help'] = '<p>만일 여러번 시도를 허용하고 이 설정을 <b>예</b>로 해 놓으면, 새로운 시도과정에 이미 지난번 시도했던 결과를 포함하게 된다. 이것은 여러번에 걸쳐 퀴즈를 완수할 수 있도록 허용한다.</p>

<p>매 시도마다 새로운 퀴즈를 보이고 싶으면, 이 설정을 <b>아니오</b>로 두어라.</p>';
$string['editcategories'] = '범주 편집';
$string['editcategory'] = '범주 편집';
$string['editcatquestions'] = '범주의 질문 편집';
$string['editingquestion'] = '질문 편집';
$string['editingquiz'] = '퀴즈 편집';
$string['editingquiz_help'] = '퀴즈를 만들때 주된 개념은 다음과 같습니다:

* 퀴즈, 한 개 이상의 페이지에 질문을 가지고 있음
* 질문 은행, 범주별로 정리된 모든 질문의 사본을 가지고 있음
* 무작위 질문 - 퀴즈를 볼 때 마다 학생들은 다른 질문을 받게되고, 다른 학생들은 다른 질문을 받게 됩니다.';
$string['editingquizx'] = '퀴즈 편집: {$a}';
$string['editoverride'] = '편집 덮어쓰기';
$string['editqcats'] = '질문 범주 편집';
$string['editquestions'] = '질문 편집';
$string['editquiz'] = '퀴즈 편집';
$string['editquizquestions'] = '퀴즈 질문 편집';
$string['emailconfirmbody'] = '{$a->username} 님,

{$a->submissiontime} 에 \'{$a->coursename}\'의 퀴즈 \'{$a->quizname}\'에 대한 답안을 제출해 주셔서 감사합니다.

본 이메일은 답안이 정상적으로 접수되었음을 확인하는 것입니다.

본 퀴즈는 {$a->quizurl} 에서 접속할 수 있습니다.';
$string['emailconfirmsmall'] = '\'{$a->quizname}\'에 답을 제출해 주셔사 감사합니다.';
$string['emailconfirmsubject'] = '{$a->quizname} 의 답안 접수 확인';
$string['emailnotifybody'] = '{$a->username} 님,

{$a->studentname} 학생이  강좌 \'{$a->coursename}\' 에서 \'{$a->quizname}\' ({$a->quizurl}) 을 완결하였습니다.

이 시도는 {$a->quizreviewurl} 에서 검토 할 수 있습니다.';
$string['emailnotifysmall'] = '{$a->studentname}가  {$a->quizname}를 완료하였습니다.';
$string['emailnotifysubject'] = '{$a->studentname} 은  {$a->quizname} 퀴즈를 완결하였습니다.';
$string['emailoverduesubject'] = '시도기간 초과: {$a->quizname}';
$string['empty'] = '비었음';
$string['enabled'] = '가능';
$string['endtest'] = '시험 종료 ...';
$string['erroraccessingreport'] = '이 보고서에는 접근할 수 없음';
$string['errorinquestion'] = '질문 오류';
$string['errormissingquestion'] = '오류 : 아이디 {$a} 의 질문이 사라짐';
$string['errornotnumbers'] = '오류 - 답은 숫자라야 함';
$string['errorunexpectedevent'] = '시도{$a->attemptid} 중  {$a->questionid} 질문에서 예기치 않은 이벤트 코드 {$a->attemptid} 발견';
$string['essay'] = '에세이';
$string['essayquestions'] = '논제';
$string['eventquizattemptabandoned'] = '퀴즈 시도 버림';
$string['eventquizattemptstarted'] = '퀴즈 시도 시작됨';
$string['eventquizattemptsubmitted'] = '퀴즈 시도 제출됨';
$string['eventquizattempttimelimitexceeded'] = '퀴즈 시도 시간 제한 초과';
$string['everynquestions'] = '매 {$a} 질문당';
$string['everyquestion'] = '모든 질문';
$string['everythingon'] = '모두 켬';
$string['export'] = '내보내기';
$string['exportcategory'] = '범주 내보내기';
$string['exporterror'] = '내보내기 과정에서 오류 발생';
$string['exportingquestions'] = '질문을 파일로 내보내는 중';
$string['exportname'] = '파일명';
$string['exportquestions'] = '파일로 질문 내보내기';
$string['extraattemptrestrictions'] = '시도에 대한 특별 제한';
$string['false'] = '틀림';
$string['feedback'] = '피드백';
$string['feedbackerrorboundaryformat'] = '등급 경계값은 반드시 퍼센트이거나 숫자라야 합니다. 입력한 {$a} 은 인식되지 않습니다.';
$string['feedbackerrorboundaryoutofrange'] = '등급 경계값은 0~100% 사이의 값을 가져야만 합니다. 입력한 {$a} 은 그 범위에 들지 않습니다.';
$string['feedbackerrorjunkinboundary'] = '등급 경계값 칸은 빈틈없이 채워져야 합니다.';
$string['feedbackerrorjunkinfeedback'] = '빈칸을 남기지 말고 반응칸을 다 채워야만 합니다.';
$string['feedbackerrororder'] = '피드백 성적 경계값은 높은 값이 먼저 나오게 순서대로 써야 합니다. 입력한 경계값 {$a} 은 순서가 맞지 않습니다.';
$string['file'] = '파일';
$string['fileformat'] = '파일 형식';
$string['fillcorrect'] = '옳은 답을 채우시오';
$string['filloutnumericalanswer'] = '적어도 하나의 가능한 답과 유효숫자를 제공해야 합니다. 첫번째 일치하는 답은 점수를 매기고 피드백을 하는데 쓰입니다. 만일 끝까지 정답을 입력하지 않은 채로 피드백만 한다면, 결국은 학생은 오답처리가 될 것입니다.';
$string['filloutoneanswer'] = '적어도 하나의 답을 작성해야 합니다. 빈칸으로 남겨진 답안은 사용되지 않습니다. \'*\'표는 와이드카드 문자로 쓰일 수 있습니다. 첫번째로 일치하는 답은 점수를 매기고 피드백을 하는데 쓰일 것입니다.';
$string['filloutthreequestions'] = '적절한 답안과 함께 적어도 3개의 질문을 작성해야 합니다. 질문 없이 답만 제시함으로써 특정 오답을 제공할 수도 있습니다. 질문과 답안이 없이 공백인 곳은 무시됩니다.';
$string['fillouttwochoices'] = '적어도 2개의 답안을 작성해야 합니다. 빈칸으로 남겨진 답안은 사용되지 않습니다.';
$string['finishattemptdots'] = '시도 종료';
$string['finishreview'] = '검토 마침';
$string['forceregeneration'] = '다시 생성';
$string['formatnotfound'] = '{$a} 형식에 대한 가져오기/내보내기를 찾을 수 없음';
$string['formatnotimplemented'] = '이 형식은 정확하게 구현되지 않았습니다. 버그 보고서를 제출하기 바람';
$string['formulaerror'] = '수식 오류!';
$string['fractionsaddwrong'] = '당신이 선택한 점수 총계는 100% 가 아닙니다.<br /> 현재 합계가 {$a} % 입니다. <br />질문를 수정하기 위해 되돌아가겠습니까?';
$string['fractionsnomax'] = '정답은 100%가 되어야 합니다.<br /> 그래야 이 질문에 대한 등급 처리가 가능합니다.<br /> 이 문제를 수정하기 위해 되돌아 가겠습니까?';
$string['fromfile'] = '파일에서 :';
$string['functiondisabledbysecuremode'] = '지금 그 기능은 사용할 수 없음';
$string['generalfeedback'] = '일반적 피드백';
$string['generalfeedback_help'] = '일반 피드백은 질문이 시도된 후 보여지는 문장입니다. 응답에 따라 달라지는 특정 질문에 대한 피드백과는 달리 같은 일반적인 피드백이 항상 보여집니다.';
$string['graceperiod'] = '제출 유예 기간';
$string['graceperiodmin'] = '마지막 제출 유예 기간';
$string['graceperiodtoosmall'] = '유예기간은 {$a} 이상이어야 합니다.';
$string['grade'] = '성적';
$string['gradeall'] = '모두 채점';
$string['gradeaverage'] = '평균 점수';
$string['gradeboundary'] = '등급 경계';
$string['gradeessays'] = '에세이 채점';
$string['gradehighest'] = '최고 점수';
$string['grademethod'] = '채점 방법';
$string['grademethod_help'] = '학생들에게 여러번 시도를 허용하면, 학생들의 최종 성적을 계산하는데 다음 방법을 사용할 수 있습니다

* 모든 시도중에 최고 점수
* 모든 시도의 평균 점수
* 첫번째 점수 (다른 시도들은 무시됩니다)
* 마지막 점수 (다른 시도들은 무시됩니다)
';
$string['gradesdeleted'] = '퀴즈 성적이 삭제됨';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = '득점 : {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = '감점 적용 후 : <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = '이번 제출은 {$a} 의 감점이 있습니다.';
$string['gradingdetailszeropenalty'] = '이 제출에 대해 감점을 당하지 않습니다.';
$string['gradingmethod'] = '채점 방법: {$a}';
$string['groupoverrides'] = '모둠 덮어쓰기';
$string['groupsnone'] = '강좌에 모둠이 없음';
$string['guestsno'] = '죄송합니다, 손님 계정으로는 퀴즈를 보거나 풀 수 없습니다.';
$string['hidebreaks'] = '페이지 분할 감춤';
$string['hidereordertool'] = '재정렬 도구 감춤';
$string['history'] = '응답 이력:';
$string['howquestionsbehave_desc'] = '퀴즈에서 질문들이 동작할지에 대한 기본 설정';
$string['imagedisplay'] = '보일 그림';
$string['import'] = '가져오기';
$string['importcategory'] = '범주 가져오기';
$string['importerror'] = '가져오기 과정에서 오류 발생';
$string['importfilearea'] = '강좌에 있는 기존 파일에서 가져오기';
$string['importfileupload'] = '내려받은 파일에서 가져오기';
$string['importfromthisfile'] = '이 파일에서 가져오기';
$string['import_help'] = '이 기능은 외부 텍스트 파일에서 질문을 가져오는 것을 허용합니다.

만일 파일에 ascii 코드가 아닌 문자를 가지고 있으면  UTF-8 엔코딩을 사용해야 합니다. 마이크로소프트 오피스에 의해 만들어진 파일은 평상적으로 올바르게 처리되지 않는 특수 엔코딩을 사용할 수 있으므로 특히 주의를 기울여야 합니다.

내보내기 및 가져오기 포맷은 끼워 넣을 수 있는 자원입니다. 선택할 수 있는 포맷이 모듈 및 플러그인 데이터베이스에 있을 수도 있습니다.';
$string['importingquestions'] = '파일에서 {$a} 질문 가져오기';
$string['importmax10error'] = '질문 오류. 열 개 이상의 답안을 쓸 수 없음';
$string['importmaxerror'] = '질문에 오류가 있습니다.  너무 많은 답이 있음';
$string['importquestions'] = '파일에서 질문 가져오기';
$string['inactiveoverridehelp'] = '* 학생은 퀴즈를 풀 수 있는 자격이 안 되거나 제대로된 모둠에 속해있지 않습니다.';
$string['incorrect'] = '부정확';
$string['indivresp'] = '각 항목에 대한 개인들의 응답';
$string['info'] = '정보';
$string['infoshort'] = 'i';
$string['inprogress'] = '진행 중';
$string['introduction'] = '소개';
$string['invalidattemptid'] = '그런 시도 ID가 존재하지 않음';
$string['invalidcategory'] = '범주 ID가 올바르지 않음';
$string['invalidnumericanswer'] = '입력한 답 가운데 하나는 적절한 숫자가 아닙니다.';
$string['invalidnumerictolerance'] = '입력한 허용오차 중 하나는 알맞는 숫자가 아닙니다.';
$string['invalidoverrideid'] = '잘못된 덮어쓰기 id';
$string['invalidquestionid'] = '맞지 않는 질문 ID';
$string['invalidquizid'] = '맞지 않는 퀴즈 ID';
$string['invalidsource'] = '그 정보는 합당하지 않습니다.';
$string['invalidsourcetype'] = '맞지 않는 원안 형식';
$string['invalidstateid'] = '맞지 않는 상태 ID';
$string['lastanswer'] = '당신의 마지막 답은';
$string['layout'] = '시험지 서식';
$string['layoutasshown'] = '서식 미리 보기';
$string['layoutasshownwithpages'] = '보여진 것과 같은 페이지 레이아웃 <small>({$a} 질문마다 자동으로 새 페이지)</small>';
$string['layoutshuffledandpaged'] = '한 페이지 당 {$a}개의 질문으로 뒤섞어 놓은 질문들';
$string['layoutshuffledsinglepage'] = '한 페이지내에 질문 뒤섞음';
$string['link'] = '링크';
$string['listitems'] = '퀴즈에서 항목 목록';
$string['literal'] = '문자';
$string['loadingquestionsfailed'] = '질문 탑재 실패 : {$a}';
$string['makecopy'] = '새 질문 저장';
$string['managetypes'] = '질문 유형과 서버를 관리';
$string['manualgrading'] = '채점';
$string['mark'] = '제출';
$string['markall'] = '페이지 제출';
$string['marks'] = '점수';
$string['marks_help'] = '각 질문에 대한 수치적 점수 및 전체적인 시도 점수';
$string['match'] = '짝찾기';
$string['matchanswer'] = '해당하는 답';
$string['matchanswerno'] = '{$a} 번 답 연결';
$string['max'] = '최대';
$string['messageprovider:attempt_overdue'] = '퀴즈 시도가  기한이 지나면 경고';
$string['messageprovider:confirmation'] = '퀴즈 제출 확인';
$string['messageprovider:submission'] = '퀴즈 제출 통지';
$string['min'] = '최소';
$string['minutes'] = '시간(분)';
$string['missingcorrectanswer'] = '반드시 정답이 지정되야 함';
$string['missingitemtypename'] = '빠짐 : 명칭';
$string['missingquestion'] = '질문이 더 이상 존재하지 않는 것 같습니다.';
$string['modulename'] = '퀴즈';
$string['modulename_help'] = '퀴즈 모듈은 선생님들로 하여금 선다형, 참/거짓형, 짝찾기형 및 여타 유형의 질문을을 가지고 퀴즈를 만들수 있게 해 줍니다. 매 시도는 자동으로 채점되고 선생님들은 피드백이나 정답 등을 보여줄지 여부를 선택할 수 있습니다.';
$string['modulenameplural'] = '퀴즈';
$string['moveselectedonpage'] = '선택한 질문을 {$a} 페이지로 옮김';
$string['multichoice'] = '선다형';
$string['multipleanswers'] = '최소 한 개의 답을 선택하시오.';
$string['multiplier'] = '배수';
$string['mustbesubmittedby'] = '이 시도는  {$a}가 제출해야 합니다.';
$string['name'] = '명칭';
$string['navmethod'] = '찾아가기 방법';
$string['navmethod_free'] = '자유로운';
$string['navmethod_seq'] = '연속적인';
$string['navnojswarning'] = '경고: 이 링크들은 답안을 저장하지 않습니다. 페이지 하단의 다음 버튼을 사용하십시요.';
$string['neverallononepage'] = '한꺼번에 배치하지 않음';
$string['newattemptfail'] = '오류 : 새로운 시도를 할 수 없음';
$string['newpage'] = '새 페이지';
$string['newpageevery'] = '새 페이지 자동 시작';
$string['newpage_help'] = '<p>다소 긴 퀴즈의 경우 한 페이지에 보이는 질문수를 제한함으로서 퀴즈를 여러 페이지로 분할해 나타나게 할 수 있습니다. 여기에서 지정한 수에 근거해서 질문이 추가될 때 자동적으로 페이지 나눔 표시가 삽입됩니다. 하지만 후에 편집 페이지에서 페이지 나눔은 수동으로 이동시킬 수도 있습니다.
</p>';
$string['noanswers'] = '아무 답도 고르지 않았음!';
$string['noattempts'] = '한번도 퀴즈를 시도하지 않았음';
$string['noattemptsfound'] = '시도하지 않았습니다.';
$string['noattemptstoshow'] = '보려는 시도가 없었음';
$string['nocategory'] = '옳지 않거나 없는 범주가 지정됨';
$string['noclose'] = '무제한';
$string['nocommentsyet'] = '아직 의견이 없음';
$string['noconnection'] = '현재 이 질문을 계속 진행 할 수 있는 웹 서비스에 접속되지 않았습니다. 관리자에게 연락하십시오.';
$string['nodataset'] = '와일드카드가 아님';
$string['nodatasubmitted'] = '아무런 자료도 제출하지 않았음';
$string['noessayquestionsfound'] = '수동으로 채점할 질문이 없음';
$string['nogradewarning'] = '이 퀴즈는 채점되지 않음. 따라서 성적에 따른 피드백을 설정할 수 없음';
$string['nomoreattempts'] = '더 이상 할 수 없음';
$string['none'] = '없음';
$string['noopen'] = '개시일 없음';
$string['nooverridedata'] = '적어도 하나 이상의 퀴즈 설정을덮어쓰기해야 함';
$string['nopossibledatasets'] = '가능하지 않는 숫자집합';
$string['noquestionintext'] = '질문 문장에 내장형 질문이 포함되어 있지 않음';
$string['noquestions'] = '아직 퀴즈가 추가되지 않음';
$string['noquestionsfound'] = '질문을 찾을 수 없음';
$string['noquestionsinquiz'] = '퀴즈에 질문이 없읍니다.';
$string['noquestionsnotinuse'] = '범주가 비어있으므로 이 무작위 질문은 사용할 수 없습니다.';
$string['noquestionsonpage'] = '빈 페이지';
$string['noresponse'] = '반응 없음';
$string['noreview'] = '이 퀴즈를 볼 권한이 없음';
$string['noreviewattempt'] = '이 시도를 검토하도록 허용되지 않았습니다.';
$string['noreviewshort'] = '허가되지 않음';
$string['noreviewuntil'] = '{$a}까지 이 퀴즈를 볼 권한이 없음';
$string['noreviewuntilshort'] = '{$a} 사용가능';
$string['noscript'] = '계속하려면 자바스크립트가 지원되야 합니다!';
$string['notavailabletostudents'] = '경고 : 이 퀴즈는 현재 학생들에게 적용할 수 없음';
$string['notenoughrandomquestions'] = '범주 {$a->category}에 질문 {$a->name} ({$a->id})을 만드는데 충분한 질문이 없습니다.';
$string['notenoughsubquestions'] = '하위 질문이 제대로 정의되지 않았습니다. 되돌아 가서 이 질문을 고치겠습니까?';
$string['notimedependentitems'] = '시간 제한을 받는 질문들은 현재 퀴즈 모듈에 의해 지원이 되지 않습니다. 해결방법으로  전체의 퀴즈에 대한 시간 제한을 설정해 놓으십시오. 다른 항목을 고르시겠습니까?(아니면 현재의 항목을 그대로 이용하시겠습니까)?';
$string['notyetgraded'] = '아직 채점되지 않음';
$string['notyetviewed'] = '아직 보지 않음';
$string['notyourattempt'] = '당신이 한 시도가 아닙니다!';
$string['noview'] = '로그인 사용자는 이 퀴즈를 볼 수 없음';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} 가 {$a->attemptnum} 번의 시도를 하였음';
$string['numattemptsmade'] = '이 퀴즈에 대해 {$a} 시도가 있었음';
$string['numberabbr'] = '#';
$string['numerical'] = '수치형';
$string['numquestionsx'] = '질문: {$a}';
$string['oneminute'] = '1분';
$string['onlyteachersexport'] = '선생님만이 질문을 내보내기 할 수 있음';
$string['onlyteachersimport'] = '편집 권한이 있는 사람만 질문 가져오기를 할 수 있음';
$string['onthispage'] = '이 페이지에서';
$string['open'] = '응답하지 않음';
$string['openclosedatesupdated'] = '퀴즈 시작 및 종료일이 변경되었음';
$string['optional'] = '선택사항';
$string['orderandpaging'] = '정렬 및 페이지 나누기';
$string['orderandpaging_help'] = '각 질문의 반대편에 있는 10,20,30... 과 같은 숫자는 질문의 순서를 표시합니다. 이 숫자들은 추가 질문이 삽입될 수 있도록 10단위로 증가합니다. 질문을 다시 정렬하시 위해서는 숫자를 변경하고 "질문 재정렬" 버튼을 클릭하십시요.

특정 질문 다음에 페이지 나눔을 추가하려면 질문 다음에 있는 체크박스에 표시하고, "선택된 질문 다음에 새 페이지 추가" 버튼을 클릭하십시요.

여러 페이지에 걸쳐 질문을 정렬하려면 다시 페이지 나눔 버튼을 클릭하고 페이지당 질문의 수를 선택하세요.';
$string['orderingquiz'] = '퀴즈 정렬 및 페이지 나누기';
$string['orderingquizx'] = '정렬 및 페이지 나누기 {$a}';
$string['outcomesadvanced'] = '학습성과는 고급 설정입니다';
$string['outof'] = '최대 {$a->maxgrade} 중 {$a->grade}';
$string['outofpercent'] = '최대 {$a->maxgrade} 중 {$a->grade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = '전반적인 피드백';
$string['overallfeedback_help'] = '전반적인 회신의견은 학생들이 퀴즈를 다 끝마쳤을 때 학생들에게 보여지는 문장입니다. 추가적으로 성적 경계를  (백분율 혹은 수로서) 명시하면 보여지는 문장은 학생들이 얻은 점수에 의해서 달라집니다.
';
$string['overdue'] = '기한초과';
$string['overduehandling'] = '종료시';
$string['overduehandlingautoabandon'] = '시도는 시간이 만료되기전에 제출되어야 합니다. 그렇지 않으면 계산되지 않습니다.';
$string['overduehandlingautosubmit'] = '열린 시도는 자동으로 제출됩니다.';
$string['override'] = '덮어쓰기';
$string['overridedeletegroupsure'] = '모둠 {$a}에 대해 덮어쓰기를 삭제하기를 원하십니까?';
$string['overridedeleteusersure'] = '사용자 {$a}에 대해 덮어쓰기를 삭제하기를 원하십니까?';
$string['overridegroup'] = '모둠 덮어쓰기';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = '덮어쓰기';
$string['overrideuser'] = '사용자 덮어쓰기';
$string['overrideusereventname'] = '{$a->quiz} - 덮어 쓰기';
$string['page-mod-quiz-attempt'] = '퀴즈 시도 페이지';
$string['page-mod-quiz-edit'] = '퀴즈 페이지 편집';
$string['page-mod-quiz-report'] = '모든 퀴즈 보고서 페이지';
$string['page-mod-quiz-review'] = '퀴즈 시도 페이지 검토';
$string['page-mod-quiz-summary'] = '퀴즈 시도 요약 페이지';
$string['page-mod-quiz-view'] = '퀴즈 정보 페이지';
$string['page-mod-quiz-x'] = '모든 퀴즈 모듈 페이지';
$string['pagesize'] = '한페이지당 보여질 시도들:';
$string['parent'] = '상위';
$string['parentcategory'] = '상위 범주';
$string['parsingquestions'] = '가져온 파일에서 질문 파싱';
$string['partiallycorrect'] = '부분 맞음';
$string['penalty'] = '감점';
$string['penaltyscheme'] = '감점 적용';
$string['penaltyscheme_help'] = '만일 활성화되면 틀린 답에 대해 감점 처리됩니다. 감점하는 양은 질문설정에서 명시 할 수 있습니다.

이 설정은 적응모드가 활성화 되었을 경우 적용됩니다.';
$string['percentcorrect'] = '퍼센트 맞음';
$string['pleaseclose'] = '요청이 처리되었습니다. 이제 이 창을 닫을 수 있습니다.';
$string['pluginadministration'] = '시험지 관리';
$string['pluginname'] = '퀴즈';
$string['popup'] = '보안창에 퀴즈 보이기';
$string['popupblockerwarning'] = '테스트의 이 부분은 보안모드로 되어 있습니다. 이는 보안된 창에서 퀴즈를 풀어야 함을 의미합니다. 팝업 차단기를 해제해 주시기 바랍니다. 감사합니다.';
$string['popupnotice'] = '이 퀴즈는 보안창에서 보일 것임';
$string['preprocesserror'] = '전처리 과정에서 오류 발생!';
$string['preview'] = '미리보기';
$string['previewquestion'] = '질문 미리보기';
$string['previewquiz'] = '{$a} 퀴즈 미리보기';
$string['previewquiznow'] = '지금 퀴즈 미리보기';
$string['previous'] = '이전의 상태';
$string['publish'] = '개방';
$string['publishedit'] = '이 범주의 질문을 수정하거나 추가하기 위해서는 강좌에서 출판할 수 있는 권한이 있어야 함';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = '퀴즈명';
$string['qti'] = 'IMS QTI 형식';
$string['qtypename'] = '형식, 퀴즈명';
$string['question'] = '질문';
$string['questionbankcontents'] = '질문은행 내용';
$string['questionbankmanagement'] = '질문은행 관리';
$string['questionbehaviour'] = '질문 진행방식';
$string['questioncats'] = '질문 범주';
$string['questiondeleted'] = '이 질문은 삭제되었습니다. 선생님에게 연락하십시오.';
$string['questioninuse'] = '\'{$a->questionname}\' 질문은 현재 {$a->quiznames} 에서 사용되고 있습니다.<br />이 질문은 이 퀴즈나 항목에서 삭제되지 않을 것입니다.';
$string['questionmissing'] = '현 세션에 대한 질문이 누락되었습니다.';
$string['questionname'] = '질문명';
$string['questionnonav'] = '<span class="accesshide">질문</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">정보</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '데이터베이스로부터 질문 {$a}을 가져오지 못했습니다.';
$string['questionorder'] = '질문 순서';
$string['questionposition'] = '질문 {$a}에 대한 정렬된 새로운 위지';
$string['questions'] = '질문들';
$string['questionsinclhidden'] = '질문들(숨겨진 질문 포함)';
$string['questionsinthisquiz'] = '퀴즈에 속한 질문들';
$string['questionsperpage'] = '한 페이지당 질문';
$string['questionsperpageselected'] = '한 페이지당 질문수가 정해져 있습니다. 따라서 페이지 재배치 기능은 작동하지 않습니다. {$a} 에서 이를 변경할 수 있습니다.';
$string['questionsperpagex'] = '페이지당 질문 수: {$a}';
$string['questiontext'] = '질문 내용';
$string['questiontextisempty'] = '[빈 질문 문장]';
$string['questiontype'] = '{$a} 유형의 질문';
$string['questiontypesetupoptions'] = '질문 유형을 위한 옵션 설정:';
$string['quiz:addinstance'] = '새 퀴즈 추가';
$string['quiz:attempt'] = '퀴즈 시도';
$string['quizavailable'] = '{$a}까지 퀴즈를 이용할 수 있음';
$string['quizclose'] = '퀴즈 종료';
$string['quizclosed'] = '{$a} 에 퀴즈 끝남';
$string['quizcloses'] = '퀴즈그만하기';
$string['quizcloseson'] = '{$a} 에 퀴즈가 종료될 예정임';
$string['quiz:deleteattempts'] = '퀴즈 시도 삭제';
$string['quiz:emailconfirmsubmission'] = '제출할 때 이메일 확인받음';
$string['quiz:emailnotifysubmission'] = '제출에 대한 안내를 이메일로 받음';
$string['quiz:emailwarnoverdue'] = '시도가 시간이 지나서 제출되어야 할 필요가 있을때 알림 메세지 받기';
$string['quiz:grade'] = '퀴즈 수동 채점';
$string['quiz:ignoretimelimits'] = '퀴즈에서 시간 제한 무시';
$string['quizisclosed'] = '이 퀴즈는 닫힘';
$string['quizisclosedwillopen'] = '퀴즈가 종료됨 (열림 {$a})';
$string['quizisopen'] = '이 퀴즈는 열려 있음';
$string['quizisopenwillclose'] = '퀴즈시작({$a} 에 종료)';
$string['quiz:manage'] = '퀴즈 관리';
$string['quiz:manageoverrides'] = '퀴즈 덮어쓰기 관리';
$string['quiznavigation'] = '퀴즈 찾아가기';
$string['quizopen'] = '퀴즈시작';
$string['quizopenclose'] = '시작 및 종료 일자';
$string['quizopenclose_help'] = '학습자들은 퀴즈 시작시간 이후 시도를 할 수 있으며 종료시간이전에 시도를 마쳐야 합니다.';
$string['quizopened'] = '본 퀴즈는 시작됬음.';
$string['quizopenedon'] = '이 퀴즈는 {$a} 에 개봉됨';
$string['quizopens'] = '퀴즈열기';
$string['quizopenwillclose'] = '퀴즈가 시작되었으며, {$a} 에 종료될 것임';
$string['quizordernotrandom'] = '퀴즈의 순서는 뒤섞이지 않음';
$string['quizorderrandom'] = '* 퀴즈의 순서가 뒤섞임';
$string['quiz:preview'] = '퀴즈 미리보기';
$string['quiz:regrade'] = '시도한 퀴즈 재채점';
$string['quiz:reviewmyattempts'] = '시도 검토';
$string['quizsettings'] = '퀴즈 설정';
$string['quiztimer'] = '퀴즈 타이머';
$string['quiz:view'] = '퀴즈 정보 보기';
$string['quiz:viewreports'] = '퀴즈 보고서 보기';
$string['quizwillopen'] = '퀴즈는 {$a} 에 시작될 것임';
$string['random'] = '무작위 질문';
$string['randomcreate'] = '무작위 질문 만들기';
$string['randomfromcategory'] = '범주에서 무작위 질문 :';
$string['randomfromexistingcategory'] = '존재하는 범주에서 무작위 질문';
$string['randomnosubcat'] = '하위범주를 배제한 본 범주내 질문들';
$string['randomquestionusinganewcategory'] = '새로운 범주를 사용한 무작위 질문';
$string['randomwithsubcat'] = '하위범주를 포함한 본 범주내 질문들';
$string['readytosend'] = '퀴즈의 답을 보내려고 합니다. 계속하시겠습니까?';
$string['reattemptquiz'] = '퀴즈에 재도전';
$string['recentlyaddedquestion'] = '최근 추가된 질문';
$string['recurse'] = '하위 목록의 질문들도 포함함';
$string['regrade'] = '모든 시도 재채점하기';
$string['regradecomplete'] = '모든 시도가 재채점되었음';
$string['regradecount'] = '{$a->attempt} 중 {$a->changed} 점수가 변경되었음';
$string['regradedisplayexplanation'] = '더좋은 성적을 얻기 위해 재채점을 하는 과정은 다시보기 하이퍼링크를 누르면 다른 윈도우 창으로 볼수 있습니다.';
$string['regradenotallowed'] = '이 퀴즈를 다시 채점할 권한을 가지고 있지 않습니다.';
$string['regradingquestion'] = '"{$a}" 재채점 중';
$string['regradingquiz'] = '퀴즈 "{$a}" 재채점';
$string['remove'] = '삭제';
$string['removeallquizattempts'] = '모든 퀴즈시도 제거';
$string['removeemptypage'] = '빈 페이지 삭제';
$string['removeselected'] = '선택항목 삭제';
$string['rename'] = '새이름';
$string['renderingserverconnectfailed'] = '{$a} 서버는 RQP 요청을 처리하는데 실패하였습니다. URL이 정확한지 확인하십시오';
$string['reorderquestions'] = '질문 재정렬';
$string['reordertool'] = '재정렬 도구 보여주기';
$string['repaginate'] = '페이지당 {$a} 질문으로 페이지 다시 나눔';
$string['repaginatecommand'] = '페이지 재설정';
$string['repaginatenow'] = '즉시 페이지 재설정';
$string['replace'] = '대체';
$string['replacementoptions'] = '대체 옵션';
$string['report'] = '보고서';
$string['reportanalysis'] = '항목 분석';
$string['reportattemptsfrom'] = '시도 시작일';
$string['reportattemptsthatare'] = '시도들:';
$string['reportdisplayoptions'] = '표시 옵션';
$string['reportfullstat'] = '자세한 통계';
$string['reportmulti_percent'] = '멀티 퍼센트';
$string['reportmulti_q_x_student'] = '복수 학습자 선택';
$string['reportmulti_resp'] = '개별 응답';
$string['reportmustselectstate'] = '최소한 한 상태를 선택해야 합니다.';
$string['reportnotfound'] = '알 수 없는 보고({$a})';
$string['reportoverview'] = '개요';
$string['reportregrade'] = '재채점';
$string['reportresponses'] = '상세 반응';
$string['reports'] = '보고들';
$string['reportshowonly'] = '시도들만 표시';
$string['reportsimplestat'] = '간단한 통계';
$string['reportusersall'] = '퀴즈를 시도한 모든 사용자';
$string['reportuserswith'] = '퀴즈를 시도한 등록된 사용자';
$string['reportuserswithorwithout'] = '퀴즈를 시도한 혹은 시도하지 않은 등록된 사용자';
$string['reportuserswithout'] = '퀴즈를 시도하지 않은 등록된 사용자';
$string['reportwhattoinclude'] = '보고서에 포함할 것';
$string['requirepassword'] = '비밀번호 입력';
$string['requirepassword_help'] = '<p>이 항목은 선택사항이다.</p>

<p>만일 여기에 비밀번호를 입력해 놓으면 참여자들은 반드시 동일한 비밀번호를 입력해야만 퀴즈를 풀 수 있는 자격을 갖게 된다.</p>';
$string['requiresubnet'] = '허용 네트워크 주소 제한';
$string['requiresubnet_help'] = '<p>이 항목은 선택사항이다.</p>

<p>특정 랜 혹은 인터넷의 서브넷을 전체 혹은 부분의 IP주소를 쉼표로 분리하여 지정함으로서 퀴즈에 접속할 수 있는 곳을 한정할 수 있다.</p>

<p>이는 개방되지 않은 퀴즈에 대해 특정 위치에 있는 사람들에게만 퀴즈에 접속할 수 있게 하고 싶을 때 사용하면 특히 쓸모가 있다.</p>

<p>예:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>이에는 세가지 유형의 방식이 있다.(example.com과 같은 문자 기반의 이름은 쓸 수 없다)
<ol>
<li><b>192.168.10.1</b>와 같은 완전한 IP 주소, 이는 단 하나의 컴퓨터(혹은 프록시)만 쓸 수 있다.</li>
<li><b>192.168</b>과 같은 부분적 IP 주소, 이는 이 번호대로 시작하는 모든 주소를 가진 컴퓨터에서는 접근할 수 있다.</li>
<li><b>231.54.211.0/20</b>와 같은 CIDR 표현식, 이는 하위 주소를 좀 더 명확하게 지정해 준다.</li>
</ol>
</p>

<p>공백은 무시된다.</p>';
$string['response'] = '응답';
$string['responses'] = '응답들';
$string['results'] = '결과';
$string['returnattempt'] = '시도로 돌아가기';
$string['reuseifpossible'] = '최근 삭제된 것을 재사용하기';
$string['reverttodefaults'] = '기본 설정으로 되돌리기';
$string['review'] = '재검토하기';
$string['reviewafter'] = '퀴즈 마감 후에 재검토 허용';
$string['reviewalways'] = '아무 때나 재검토를 허용';
$string['reviewattempt'] = '시도를 검토';
$string['reviewbefore'] = '퀴즈를 푸는 동안 재검토 허용';
$string['reviewclosed'] = '퀴즈 마감 이후';
$string['reviewduring'] = '시도 중에';
$string['reviewimmediately'] = '퀴즈 제출 직후';
$string['reviewnever'] = '재검토를 허용하지 않음';
$string['reviewofattempt'] = '{$a} 차 시도 검토';
$string['reviewofpreview'] = '미리보기 검토';
$string['reviewopen'] = '나중에, 퀴즈 마감 이전';
$string['reviewoptions'] = '재검토 허용여부';
$string['reviewoptionsheading'] = '검토 옵션';
$string['reviewoptionsheading_help'] = '이 옵션들은 퀴즈를 재 검토하거나 퀴즈 보고서를 볼 때, 사용자에게 어떤 정보를 보게할 것인지를 조정하는 것입니다.

\'퀴즈 제출 직후\'란 학생들이 시도를 종료한 이후 2분 이내를 의미합니다. \'나중에, 퀴즈 마감 이전\'에란 말그대로 퀴즈의 마감날 이전 어느 때던지 볼 수 있다는 뜻입니다.

\'퀴즈 마감 이후란 퀴즈의 마감일 이후를 뜻합니다. 만일 퀴즈에 마감일이 설정되어 있지 않다면, 이러한 상태는 절대로 도달되지 않습니다.

';
$string['reviewoverallfeedback'] = '전반적 의견';
$string['reviewoverallfeedback_help'] = '학생의 총점에 따라 시도의 끝에 주어지는 피드백';
$string['reviewresponse'] = '응답 검토';
$string['reviewresponsetoq'] = '응답 검토(질문 {$a})';
$string['reviewthisattempt'] = '본 시도에 대한 응답 재검토';
$string['rqp'] = '원격 질문';
$string['rqps'] = '원격 질문들';
$string['sameasoverall'] = '총점과 동일';
$string['save'] = '저장';
$string['saveandedit'] = '질문 수정 및 저장';
$string['saveattemptfailed'] = '현재의 시험 결과 저장 실패';
$string['savedfromdeletedcourse'] = '삭제된 "{$a}" 강좌에서 가져다 저장하기';
$string['savegrades'] = '내 점수 저장하기';
$string['savemyanswers'] = '내 답안 저장하기';
$string['savenosubmit'] = '제출은 하지말고 저장';
$string['saveoverrideandstay'] = '저장하고 또 다른 덮어쓰기를 입력하세요.';
$string['savequiz'] = '전부 저장';
$string['saving'] = '저장';
$string['savingnewgradeforquestion'] = '질문 아이디 {$a}에 대한 새로운 성적 저장';
$string['savingnewmaximumgrade'] = '새 최대 성적 저장';
$string['score'] = '원점수';
$string['scores'] = '점수';
$string['select'] = '선택하기';
$string['selectall'] = '전체 선택';
$string['selectcategory'] = '범주 선택';
$string['selectedattempts'] = '선택된 시도들';
$string['selectnone'] = '모두 선택 해제';
$string['selectquestiontype'] = '-- 질문 유형 선정 --';
$string['serveradded'] = '서버가 추가됨';
$string['serveridentifier'] = '식별자';
$string['serverinfo'] = '서버 정보';
$string['servers'] = '서버';
$string['serverurl'] = '서버 URL';
$string['settingsoverrides'] = '설정 덮어쓰기';
$string['shortanswer'] = '단답';
$string['show'] = '보기';
$string['showall'] = '한 페이지에 모든 질문 보기';
$string['showblocks'] = '시험시 블록 보이기';
$string['showblocks_help'] = '예로 설정하면, 시험을 보는 동안 블록이 보일 것임';
$string['showbreaks'] = '페이지 중단 표시 보기';
$string['showcategorycontents'] = '범주 목록 {$a->arrow} 보기';
$string['showcorrectanswer'] = '피드백에서 정답을 보여줄까요?';
$string['showdetailedmarks'] = '점수 세부사항 보이기';
$string['showeachpage'] = '한 페이지를 한꺼번에 보이기';
$string['showfeedback'] = '답변 후에 피드백을 볼건가요?';
$string['showinsecurepopup'] = '시도에 \'보안창\' 사용';
$string['showlargeimage'] = '큰 이미지';
$string['shownoattempts'] = '시도하지 않은 학생들 보기';
$string['shownoattemptsonly'] = '시도하지 않은 학생들만 보기';
$string['shownoimage'] = '이미지 없음';
$string['showreport'] = '보고서 보여주기';
$string['showsmallimage'] = '작은 이미지';
$string['showteacherattempts'] = '선생님 시도 보기';
$string['showuserpicture'] = '사용자 사진 제시';
$string['showuserpicture_help'] = '이 옵션을 켜면, 학생 이름 및 사진이 시도 중 화면에 나타나게 되고, 검토 화면에도 표시됩니다.
일례로 시험을 감독해야 할 경우, 응시자가 제대로 응시했는지를 손쉽게 점검하려 할 때 이를 적용할 수 있습니다.';
$string['shuffle'] = '섞기';
$string['shuffleanswers'] = '답안 섞기';
$string['shuffledrandomly'] = '무작위로 섞임';
$string['shufflequestions'] = '질문 섞기';
$string['shufflequestionsselected'] = '질문 뒤섞음이 설정되어 있습니다. 페이지와 관련된 어떤 동작이 사용가능하지 않습니다. 뒤섞임 옵션 변경 {$a}';
$string['shufflewithin'] = '답안 뒤섞기';
$string['shufflewithin_help'] = '활성화되고 질문 설정에서 옵션이 활성화되면, 학생들이 퀴즈를 시도할 때마다 질문을 구성하는 부분들이 무작위로 뒤섞이게 됩니다. 이 설정은 선다형 질문이나 짝찾기형 질문과 같이 여러 부분으로 되어 있는 경우에만 적용됩니다.


';
$string['singleanswer'] = '한개의 답을 선택하시오';
$string['sortage'] = '만든 순으로 정렬';
$string['sortalpha'] = '가나다 순으로 정렬';
$string['sortquestionsbyx'] = '질문 정렬 순서 : {$a}';
$string['sortsubmit'] = '질문 정렬';
$string['sorttypealpha'] = '유형, 제목으로 정렬';
$string['specificapathnotonquestion'] = '지정 질문에 대한 파일 경로가  없음';
$string['specificquestionnotonquiz'] = '지정한 질문이 퀴즈에 없음';
$string['startagain'] = '다시 시작';
$string['startattempt'] = '시도 시작';
$string['startedon'] = '시작';
$string['startnewpreview'] = '새 미리보기 시작';
$string['stateabandoned'] = '제출되지 않았습니다.';
$string['statefinished'] = '종료됨';
$string['statefinisheddetails'] = '{$a}를 제출함';
$string['stateinprogress'] = '진행중';
$string['statenotloaded'] = '데이터베이스로부터 질문 {$a} 상태를 로딩하지 못하였습니다.';
$string['stateoverdue'] = '기한 만료';
$string['stateoverduedetails'] = '{$a}가 제출해야 합니다.';
$string['status'] = '현황';
$string['stoponerror'] = '오류시 중단함';
$string['submitallandfinish'] = '모두 제출하고 끝냄';
$string['subneterror'] = '미안합니다. 이 퀴즈는 잠겨있으므로 특정한 위치에서만 이용가능합니다. 현재 당신의 컴퓨터는 이 퀴즈를 이용할 수 없습니다.';
$string['subnetnotice'] = '이 퀴즈는 특정한 지역에서만 접근 가능하도록 하기위해서 잠겨져 있습니다. 당신의 컴퓨터는 허용된 지역이 아닙니다. 어쨋든 선생님이라면 미리보기가 허용됩니다.';
$string['subplugintype_quiz'] = '보고서';
$string['subplugintype_quizaccess'] = '접근 규칙';
$string['subplugintype_quizaccess_plural'] = '접근 규칙';
$string['subplugintype_quiz_plural'] = '보고서';
$string['substitutedby'] = '다음으로 대체';
$string['summaryofattempt'] = '시도 개요';
$string['summaryofattempts'] = '이전 시도들에 대한 요약';
$string['temporaryblocked'] = '현재 당신은 일시적으로 퀴즈를 재시도 하도록 허용되지 않았습니다.<br /> 재시도는 다음 날자에 할 수 있습니다:';
$string['theattempt'] = '시도';
$string['theattempt_help'] = '학생들이 시도를 검토할 수 있는지 여부';
$string['time'] = '시간';
$string['timecompleted'] = '종료';
$string['timedelay'] = '재시도 경과시간이 지나지 않았기 때문에 퀴즈를 하도록 허용되지 않습니다.';
$string['timeleft'] = '남은 시간';
$string['timelimit'] = '시간제한';
$string['timelimitexeeded'] = '미안합니다!  시간이 초과됐습니다.';
$string['timelimit_help'] = '<p>기본적으로는 퀴즈를 푸는데 시간 제한이 없어서 학생들이 퀴즈를 완전히 풀 수 있도록 필요한 만큼 시간을 쓸 수 있다.</p>

<p>만약 시간 제한을 둘 경우, 시간 내에 퀴즈를 풀어낼 수 있도록 여러가지를 점검하고 확인해야 한다.</p>

<ul>
  <li>브라우저에서 Javascript가 구동될 수 있도록 확인 - 이는 타이머가 제대로 작동할 수 있도록 한다.</li>
  <li>시간 흐름을 알 수 있게 타이머 창이 뜨게한다.</li>
  <li>시간이 다 경과되면 자동으로 퀴즈가 닫히며 그간 답해 놓은 것들을 갈무리하게 한다.</li>
  <li>만일 학생들이 제한 시간을 다 쓰고도 60초 이내에 정리하지 않으면 퀴즈를 종료하고 자동으로 0점 처리하게 한다.</li>
</ul>';
$string['timelimitmin'] = '제한시간(분)';
$string['timelimitsec'] = '제한시간(초)';
$string['timestr'] = '%y/%m/%d %H:%M:%S';
$string['timesup'] = '시간이 다 되었습니다!';
$string['timetaken'] = '걸린 시간';
$string['timing'] = '타이밍';
$string['tofile'] = '파일로';
$string['tolerance'] = '허용오차';
$string['toomanyrandom'] = '범주에 저장되어 있는 질문보다 요구한 질문 수가 더 많습니다!';
$string['top'] = '위';
$string['totalmarksx'] = '총점: {$a}';
$string['totalquestionsinrandomqcategory'] = '범주 내 {$a} 질문의 총계';
$string['true'] = '진실';
$string['truefalse'] = '참/거짓';
$string['type'] = '유형';
$string['unfinished'] = '열기';
$string['ungraded'] = '채점 안됨';
$string['unit'] = '단위';
$string['unknowntype'] = '{$a} 줄에 지원되지 않는 질문 유형. 질문 무시됨.';
$string['unusedcategorydeleted'] = '강좌가 삭제된 이후, 쓰였던  질문들이 더 이상 사용되지 않았기 때문에, 이 범주는 삭제되었습니다.';
$string['updatesettings'] = '퀴즈 설정 업데이트';
$string['updatingatttemptgrades'] = '시도 성적 업데이트';
$string['updatingfinalgrades'] = '최종 성적 업데이트';
$string['updatingthegradebook'] = '성적부 업데이트';
$string['upgradesure'] = '<div>특히,  퀴즈 모듈은 퀴즈 테이블를 상당히 변경하게 될 것입니다.  이 업그레이드는 아직 충분히 검증되지 않았습니다. 계속하기전에 데이터베이스 테이블을 백업하기를 권장합니다.</div>';
$string['upgradingquizattempts'] = '퀴즈 시도를 업그레이드 중: 퀴즈 {$a->done}/{$a->outof} (퀴즈 아이디 {$a->info})';
$string['upgradingveryoldquizattempts'] = '매우 오래된 퀴즈 시도를 업그레이드 중: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = '이 범주의 질문들은 원래 있던 강좌 범주가 삭제되어서 사이트 내의 다른 범주로 이동되었습니다.';
$string['useroverrides'] = '사용자 덮어쓰기';
$string['usersnone'] = '본 시험에 아무도 접속하지 않음';
$string['validate'] = '유효한지 확인';
$string['viewallanswers'] = '{$a} 퀴즈 답안 보기';
$string['viewallreports'] = '{$a}시도에 대한 결과 보기';
$string['viewed'] = '봄';
$string['warningmissingtype'] = '<b>이 문형은 아직 시스템에 설치되지 않은 형식입니다.<br /> 무들 관리자에게 지적하여 주십시요.</b>';
$string['wheregrade'] = '내 성적이 어디 있습니까?';
$string['wildcard'] = '와일드카드';
$string['windowclosing'] = '조금 뒤 창이 닫힐 것입니다.';
$string['withsummary'] = '요약된 통계와 함께';
$string['wronguse'] = '이 페이지를 사용할 수 없음';
$string['xhtml'] = 'XHTML 형식';
$string['youneedtoenrol'] = '강좌에 등록을 마쳐야 이 퀴즈에 도전할 수 있음';
$string['yourfinalgradeis'] = '이번 퀴즈의 최종 점수는 {$a} 입니다.';
