<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = '설치 예정';
$string['action'] = '동작';
$string['actionchoice'] = '\'{$a}\' 파일을 어떻게 하시겠습니까?';
$string['actions'] = '동작들';
$string['active'] = '활성';
$string['activeusers'] = '활동중인 사용자들';
$string['activities'] = '학습활동';
$string['activities_help'] = '포럼, 퀴즈 및 위키 등 상호 작용이 가능한 활동을 강좌에 추가할 수 있음';
$string['activity'] = '활동';
$string['activityclipboard'] = '이 활동을 옮기기: <b>{$a}</b>';
$string['activityiscurrentlyhidden'] = '아직 공개되지 않은 활동임';
$string['activitymodule'] = '활동 모듈';
$string['activitymodules'] = '활동 모듈';
$string['activityreport'] = '활동 보고';
$string['activityreports'] = '활동 보고서';
$string['activityselect'] = '다른 곳으로 옮기려면 선택';
$string['activitysince'] = '{$a} 이후 활동';
$string['activityweighted'] = '개인별 활동';
$string['add'] = '추가';
$string['addactivity'] = '학습활동 추가';
$string['addactivitytosection'] = '섹션 \'{$a}\'에 활동 추가';
$string['addadmin'] = '관리자 추가';
$string['addblock'] = '블록 추가';
$string['addcomment'] = '덧글 추가 ...';
$string['addcountertousername'] = '아이디에 번호를 추가하여 계정 생성';
$string['addcreator'] = '강좌 생성자 추가';
$string['adddots'] = '추가...';
$string['added'] = '{$a} 추가됨';
$string['addedrecip'] = '{$a} 가 새 수령인으로 추가됨';
$string['addedrecips'] = '{$a} 들이 새 수령인으로 추가됨';
$string['addedtogroup'] = '{$a} 모둠에 추가됨';
$string['addedtogroupnot'] = '{$a} 모둠에 추가되지 않음';
$string['addedtogroupnotenrolled'] = '강좌 등록생이 아니므로, {$a} 모둠에 추가되지 못함';
$string['addfilehere'] = '여기에 파일 추가';
$string['addinganew'] = '새 {$a} 추가하기';
$string['addinganewto'] = '새 {$a->what} 를 {$a->to} 에 추가하기';
$string['addingdatatoexisting'] = '기존의 데이터에 추가하기';
$string['additionalnames'] = '추가 이름';
$string['addlinkhere'] = '여기에 링크 추가';
$string['addnewcategory'] = '범주 추가';
$string['addnewcourse'] = '강좌 추가';
$string['addnewuser'] = '사용자 추가';
$string['addnousersrecip'] = '{$a} 에 접속하지 않았던 사용자를 수령자명부에 추가';
$string['addpagehere'] = '여기에 텍스트 추가';
$string['addresource'] = '학습자원 추가';
$string['addresourceoractivity'] = '활동 혹은 자료 추가';
$string['addresourcetosection'] = '섹션 \'{$a}\'에 자원 추가';
$string['address'] = '주소';
$string['addstudent'] = '학생 추가';
$string['addsubcategory'] = '하위 범주 추가';
$string['addteacher'] = '선생님 추가';
$string['admin'] = '관리자';
$string['adminhelpaddnewuser'] = '사용자 계정 수동으로 생성';
$string['adminhelpassignadmins'] = '관리자는 사이트의 어디에서나 활동할 수 있음';
$string['adminhelpassigncreators'] = '강좌 생성자는 새 강좌를 만들 수 있음';
$string['adminhelpassignsiteroles'] = '특정 사용자에게 사이트의 역할을 적용함';
$string['adminhelpassignstudents'] = '강좌로 가서 학생들을 추가하기';
$string['adminhelpauthentication'] = '외부 데이터베이스나 내부 사용자 계정을 사용할 수 있음';
$string['adminhelpbackup'] = '자동 백업 일정 설정';
$string['adminhelpconfiguration'] = '사이트의 꾸미기와 기능 설정';
$string['adminhelpconfigvariables'] = '사이트의 일반적 작동에 영향을 미치는 변수 설정';
$string['adminhelpcourses'] = '강좌와 범주를 설정하고 사람들을 배치하며 유보된 과정을 개설';
$string['adminhelpeditorsettings'] = 'HTML 편집기의 기본설정 정의';
$string['adminhelpedituser'] = '사용자 계정 목록을 살펴보고 편집';
$string['adminhelpenvironment'] = '서버가 추후 운영 환경에 적합한지 점검';
$string['adminhelpfailurelogs'] = '로그인 실패 기록 검색';
$string['adminhelplanguage'] = '현재의 언어 팩을 점검하고 편집';
$string['adminhelplogs'] = '사이트의 모든 활동기록 검색';
$string['adminhelpmanageblocks'] = '설치된 블록과 이들의 설정 관리';
$string['adminhelpmanagedatabase'] = '데이터베이스에 직접 접속하기(조심!)';
$string['adminhelpmanagefilters'] = '문서 필터와 관련 설정 선택';
$string['adminhelpmanagemodules'] = '설치된 모듈과 설정 관리';
$string['adminhelpmanageroles'] = '사용자에게 적용될 역할을 규정하고 생성함';
$string['adminhelpmymoodle'] = '내 공부방 사용자를 위한 블록 설정';
$string['adminhelpreports'] = '강좌 현황 보고';
$string['adminhelpsitefiles'] = '서버 파일 관리';
$string['adminhelpsitesettings'] = '사이트의 시작 페이지가 어떻게 보일지 정의하십시요';
$string['adminhelpstickyblocks'] = '고정 블록의 환경 설정';
$string['adminhelpthemes'] = '사이트 꾸미기(색, 글꼴 등) 선택';
$string['adminhelpuploadusers'] = '텍스트 파일을 불러들여 새 사용자 계정 추가';
$string['adminhelpusers'] = '사용자 및 인증 설정';
$string['adminhelpxmldbeditor'] = 'XMLDB 파일을 편집할 수 있는 도구. 개발자용';
$string['administration'] = '관리';
$string['administrationsite'] = '사이트 관리';
$string['administrator'] = '관리자';
$string['administratordescription'] = '관리자들은 사이트의 모든 강좌에서 어떤 작업이라도 할 수 있습니다.';
$string['administrators'] = '관리자들';
$string['administratorsall'] = '모든 관리자';
$string['administratorsandteachers'] = '관리자와 선생님';
$string['advanced'] = '고급';
$string['advancedfilter'] = '고급검색';
$string['advancedsettings'] = '고급설정';
$string['afterresource'] = '자원 "{$a}" 이후';
$string['aftersection'] = '섹션 "{$a}" 이후';
$string['again'] = '다시';
$string['aimid'] = 'AIM 아이디';
$string['ajaxuse'] = 'AJAX 및 자바';
$string['all'] = '모두';
$string['allactions'] = '모든 조치';
$string['allactivities'] = '모든 활동';
$string['allcategories'] = '모든 범주';
$string['allchanges'] = '모든 변경';
$string['alldays'] = '모든 날';
$string['allfieldsrequired'] = '모든 필드가 필수';
$string['allfiles'] = '모든 파일';
$string['allgroups'] = '모든 모둠';
$string['alllogs'] = '전체 기록';
$string['allmods'] = '모든 {$a}';
$string['allow'] = '허용';
$string['allowinternal'] = '내부적 방법도 허용';
$string['allownone'] = '아무도 허용하지 않음';
$string['allownot'] = '허용하지 않음';
$string['allparticipants'] = '모든 참가자';
$string['allteachers'] = '모든 선생님';
$string['alphanumerical'] = '하이폰이나 마침표를 포함한 알파벳이나 숫자만 쓸 수 있음';
$string['alreadyconfirmed'] = '이미 등록이 완료되었습니다.';
$string['alternatename'] = '대체 이름';
$string['always'] = '항상';
$string['and'] = '{$a->one} 및 {$a->two}';
$string['answer'] = '대답';
$string['any'] = '어떤';
$string['appearance'] = '모습';
$string['approve'] = '승인';
$string['areyousure'] = '계속하시겠습니까?';
$string['areyousuretorestorethis'] = '계속할까요?';
$string['areyousuretorestorethisinfo'] = '이 과정의 말미에 이 백업자료를 기존의 강좌에 추가할 것인지, 아니면 완전히 새 강좌로 생성할 것인지를 선택하여야 합니다.';
$string['asc'] = '오름차순';
$string['assessment'] = '평가';
$string['assignadmins'] = '관리자 권한부여';
$string['assigncreators'] = '생성자 권한부여';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = '사이트 전체를 관장할 역할 부여';
$string['authenticateduser'] = '인증된 사용자';
$string['authenticateduserdescription'] = '인증을 거친 사용자들';
$string['authentication'] = '인증';
$string['authenticationplugins'] = '인증 플러그인';
$string['autosubscribe'] = '포럼 자동 구독';
$string['autosubscribeno'] = '아니오: 포럼을 자동 구독하지 않겠습니다.';
$string['autosubscribeyes'] = '예: 내가 글을 올린 포럼은 구독하겠습니다.';
$string['availability'] = '이용가능 상태';
$string['availablecourses'] = '이용할 수 있는 강좌';
$string['back'] = '뒤로';
$string['backto'] = '{$a} 로 돌아가기';
$string['backtocourselisting'] = '강좌 목록으로 돌아가기';
$string['backtopageyouwereon'] = '예전 페이지으로 돌아감';
$string['backtoparticipants'] = '참여자 목록으로 돌아가기';
$string['backup'] = '백업';
$string['backupactivehelp'] = '자동 백업을 할 것인지의 여부를 선택합니다.';
$string['backupcancelled'] = '백업 취소';
$string['backupcoursefileshelp'] = '이 항목을 "예"로 해 놓으면, 강좌 파일이 자동 백업에 포함됨';
$string['backupdate'] = '백업 날짜';
$string['backupdatenew'] = '&nbsp; {$a->TAG} 는 현재 {$a->year} {$a->month} {$a->mday} , {$a->weekday} 임<br />';
$string['backupdateold'] = '{$a->TAG} 는 {$a->year} {$a->month} {$a->mday} , {$a->weekday} 이었음';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = '백업 자세히 보기';
$string['backupexecuteathelp'] = '자동백업 시작시각 선택';
$string['backupfailed'] = '강좌 중 일부가 저장되지 않았습니다!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = '성공적으로 백업 완료';
$string['backupfromthissite'] = '이 사이트에 대해 백업을 했습니까?';
$string['backupgradebookhistoryhelp'] = '이를 활성화하면 성적 이력이 자동 백업에 포함될 것입니다. 단, 이 기능을 원할하게 작동시키기 위해서는 시스템 설정에서 성적 이력을 비활성(disablegradehistory)시키지 말아야 합니다.';
$string['backupincludemoduleshelp'] = '자동 백업에 강좌 모듈, 사용자 데이터 등을 포함시킬지 여부 선택';
$string['backupincludemoduleuserdatahelp'] = '자동 백업에 모듈의 사용자 데이터를 포함시킬지 여부 선택';
$string['backupkeephelp'] = '백업할 때 예전 백업파일을 몇 개까지 서버에 보관할까요? (더 오래된 것은 자동으로 삭제됨)';
$string['backuplogdetailed'] = '자세한 실행기록';
$string['backuploglaststatus'] = '최근 실행기록';
$string['backupmissinguserinfoperms'] = '주: 이 백업은 사용자 데이터를 포함하지 않습니다. 연습 및 상호평가 활동들은 본 백업에 포함되지 않을 것이기 때문에 본 유형의 백업으로는 이러한 모듈들을 백업하는 데 적절하지 않습니다.';
$string['backupnext'] = '다음 백업';
$string['backupnonisowarning'] = '경고: 이 백업은 Unicode 이전버전(1.6 이전)자료를 포함하고 있습니다. Unicode 버전으로 복구할때 ASCII 문자 이외의 문자를 가지고 있으면 문제가 있을 수 있습니다. 이 백업을 올바르게 복구하기 위한 정보를 보기위해서는 <a href="http://docs.moodle.org/en/Backup_FAQ">백업 FAQ</a> 를 참고하십시요.';
$string['backupnotyetrun'] = '자동 백업 대기 중';
$string['backuporiginalname'] = '백업 이름';
$string['backuproleassignments'] = '각 역할의 부여 현황 백업';
$string['backupsavetohelp'] = '백업 파일을 저장할 경로 입력<br />(기존 강좌 경로에 저장하려면 비워 둘 것)';
$string['backupsitefileshelp'] = '강좌에서 사용된 파일을 함께 백업하려면 "예"를 선택';
$string['backuptakealook'] = '{$a} 에서 백업 기록을 확인 하세요.';
$string['backupuserfileshelp'] = '사용자의 파일(사진 등)을 자동 백업에 포함시킬지 여부 선택';
$string['backupversion'] = '백업 버전';
$string['badges'] = '뱃지';
$string['block'] = '블록';
$string['blockconfiga'] = '{$a} 블록 설정';
$string['blockconfigbad'] = '정보가 정확하지 않아 설정창을 열 수 없습니다.';
$string['blocks'] = '블록';
$string['blocksaddedit'] = '블록 추가/편집';
$string['blockseditoff'] = '블록 편집 끔';
$string['blocksediton'] = '블록 편집 켬';
$string['blocksetup'] = '블록 테이블 설정';
$string['blocksuccess'] = '{$a} 테이블 설치 완료';
$string['brief'] = '간략한';
$string['bulkactions'] = '대량 작업';
$string['bulkactionselect'] = '{$a} 대량 작업 선택';
$string['bulkmovecoursessuccess'] = '{$a->courses} 강좌를 {$a->category} 범주로 성공적으로 이동함';
$string['bycourseorder'] = '강좌 순서로';
$string['byname'] = '{$a} 순서로';
$string['bypassed'] = '건너뜀';
$string['cachecontrols'] = '캐시 제어';
$string['cancel'] = '취소';
$string['cancelled'] = '취소됨';
$string['categories'] = '강좌 범주';
$string['categoriesandcoures'] = '강좌 범주와 강좌';
$string['category'] = '범주';
$string['categoryadded'] = '범주 \'{$a}\' 가 추가됨';
$string['categorybulkaction'] = '선택한 범주에 대한 대량 작업';
$string['categorycontents'] = '강좌 및 범주목록';
$string['categorycurrentcontents'] = '{$a} 의 내용';
$string['categorydeleted'] = '범주 \'{$a}\' 가 삭제됨';
$string['categoryduplicate'] = '이미 범주명 \'{$a}\' 존재함!';
$string['categorymodifiedcancel'] = '범주가 변경되었음! 취소하고 다시 시도하시기 바랍니다.';
$string['categoryname'] = '범주명';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}의 하위 범주';
$string['categoryupdated'] = '범주 \'{$a}\'가 업데이트되었음';
$string['changedpassword'] = '변경된 비밀번호';
$string['changepassword'] = '비밀번호 변경';
$string['changesmadereallygoaway'] = '변경사항이 있습니다. 이동하시면 변경내용을 잃게 됩니다. 정말 이동하겠습니까?';
$string['changessaved'] = '수정됨';
$string['check'] = '점검';
$string['checkall'] = '모두 점검';
$string['checkingbackup'] = '백업 점검';
$string['checkingcourse'] = '강좌 점검';
$string['checkingforbbexport'] = 'BlackBoard 내보내기 점검';
$string['checkinginstances'] = '작동 점검';
$string['checkingsections'] = '영역 점검';
$string['checklanguage'] = '언어 점검';
$string['checknone'] = '점검하지 않음';
$string['childcoursenotfound'] = '하위 과정을 찾을 수 없음!';
$string['childcourses'] = '하위 과정';
$string['choose'] = '선택';
$string['choosecourse'] = '강좌 선택하기';
$string['choosedots'] = '선택...';
$string['chooselivelogs'] = '또는 현재 활동 보기';
$string['chooselogs'] = '보고 싶은 기록 선택';
$string['choosereportfilter'] = '보고서를 위한 필터 선택';
$string['choosetheme'] = '테마 선택';
$string['chooseuser'] = '사용자 선택';
$string['city'] = '도시';
$string['clambroken'] = '관리자가 업로드파일에 대해 바이러스 체크를 활성화시킨 상태입니다만 제어설정에 문제가 있습니다.<br />파일 올리기는 실패했습니다. 관리자에게 그 사항을 알리고 고칠 수 있도록 메일을 보낸 상태입니다.<br />다음에 업로드해 보십시오';
$string['clamdeletedfile'] = '파일이 삭제 되었습니다';
$string['clamdeletedfilefailed'] = '파일을 삭제할 수 없습니다';
$string['clamemailsubject'] = '{$a} :: Clam AV 알림';
$string['clamfailed'] = 'Clam AV의 실행이 되지 않았습니다. 오류 메세지는 {$a} 였습니다. 다음은 Clam가 보낸 내용입니다 :';
$string['clamlost'] = '무들은 업로드한 파일에 대해 Clam을 실행하도록 설정되었습니다만, Clam AV, {$a} 에게 배정된 경로가 부정확합니다.';
$string['clamlostandactinglikevirus'] = '추가로, clam 작동을 실패할 경우, 무들은 파일을 바이러스로 취급하도록 설정되었습니다. 이는 clam이 제대로 작동하기 전까지는 어느 누구도 제대로 파일을 올릴 수 없다는 것을 뜻합니다.';
$string['clammovedfile'] = '이 파일은 지정된 격리 장소로 옮겨졌습니다. 새로운 장소는 {$a} 입니다.';
$string['clammovedfilebasic'] = '이 파일은 격리된 디렉토리로 옮겨졌습니다.';
$string['clamquarantinedirfailed'] = '지정된 격리 디렉토리 {$a} 로 파일을 옮길 수 없습니다.
당신은 감염된 파일을 발견시 삭제하라는 조항으로 고쳐야 합니다.';
$string['clamunknownerror'] = 'Clam에 확인되지 않은 오류가 있었습니다.';
$string['cleaningtempdata'] = '임시 데이터 삭제하기';
$string['clear'] = '정리';
$string['clickhelpiconformoreinfo'] = '...계속...다 읽고 싶으면 도움말 아이콘을 클릭';
$string['clickhere'] = '여기를 클릭...';
$string['clicktochangeinbrackets'] = '변경하려면 다음을 클릭 {$a}';
$string['clicktohideshow'] = '펴거나 접으려면 클릭';
$string['closebuttontitle'] = '닫기';
$string['closewindow'] = '창 닫기';
$string['collapse'] = '축소';
$string['collapseall'] = '모두 접기';
$string['collapsecategory'] = '{$a} 축소';
$string['commentincontext'] = '문맥에서 덧글 찾기';
$string['comments'] = '덧글';
$string['commentsnotenabled'] = '덧글 기능 사용 불가';
$string['commentsrequirelogin'] = '코멘트를 보려면 로그인 해야 합니다.';
$string['comparelanguage'] = '현재 언어를 비교, 수정하기';
$string['complete'] = '완료';
$string['completereport'] = '보고 완성';
$string['configuration'] = '환경설정';
$string['confirm'] = '확인';
$string['confirmcheckfull'] = '정말 {$a} 를 승인해 주려고 합니까?';
$string['confirmcoursemove'] = '이 강좌 ({$a->course})를  이 범주({$a->category})로 옮기시겠습니까?';
$string['confirmed'] = '등록 완료';
$string['confirmednot'] = '등록 미확정!';
$string['content'] = '내용';
$string['continue'] = '계속';
$string['continuetocourse'] = '강좌에 들어가려면 이곳을 누르시오.';
$string['convertingwikitomarkdown'] = 'Wiki를 Markdown으로 변환';
$string['cookiesenabled'] = '브라우저의 쿠키 기능이 작동되야 합니다.';
$string['cookiesenabled_help'] = '<p>이 사이트에서는 두 개의 쿠키를 사용합니다.</p>

<p>가장 중요한 것은 <b>무들세션</b>이라 부르는 세션 쿠키입니다. 브라우저에서 이 쿠키를 허용해야만 무들에 로그인하고 이곳 저곳을 돌아다니며 활동을 계속할 수 있습니다. 여러분이 브라우저를 닫거나 로그아웃을 하면 이 쿠키는 (브라우저와 서버에서) 삭제됩니다.</p>

<p>또 하나의 쿠키는 순전히 편의를 위한 것인데, 보통은 <b>MOODLEID</b>로 불립니다. 이는 브라우저 내에서 여러분의 사용자명을 기억하는데 사용됩니다. 즉 여러분이 다른 곳을 탐색하다가 무들의 로그인 페이지로 돌아왔을 때 사용자명 입력부분에 이미 사용자명이 쓰여져 있는 것을 알 수 있습니다. 하지만 이 쿠키는 거부하는 편이 안전한데, 이 때는 매번 로그인 할 때 마다 사용자명을 써 넣어야 합니다.</p>';
$string['cookiesnotenabled'] = '현재, 브라우저의 쿠키가 작동하지 않습니다.';
$string['copy'] = '복사';
$string['copyasnoun'] = '복사';
$string['copyingcoursefiles'] = '강좌 파일 복사';
$string['copyingsitefiles'] = '강좌에서 사용된 사이트 파일 복사';
$string['copyinguserfiles'] = '사용자 파일 복사';
$string['copyingzipfile'] = '압축 파일 복사';
$string['copyrightnotice'] = '저작권 알림';
$string['coresystem'] = '핵심 시스템';
$string['cost'] = '수업료';
$string['costdefault'] = '기본 수업료';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = '국가';
$string['course'] = '강좌';
$string['courseadministration'] = '강좌 관리';
$string['courseapprovedemail'] = '요청한 {$a->name} 강좌는 개설할 수 있도록 승인되었으며 {$a->teacher} 가 되었습니다. 강좌로 접속하려면 {$a->url} 로 가십시오.';
$string['courseapprovedemail2'] = '요청한 {$a->name} 강좌가 승인되었습니다. 강좌에 접속하려면 {$a->url} 로 가십시오.';
$string['courseapprovedfailed'] = '승인사항 저장에 실패하였습니다!';
$string['courseapprovedsubject'] = '강좌가 승인되었습니다!';
$string['courseavailable'] = '학생 이용 가능';
$string['courseavailablenot'] = '학생 이용 불가능';
$string['coursebackup'] = '강좌 백업';
$string['coursebulkaction'] = '선택한 강좌에 대한 대량 작업';
$string['coursecategories'] = '강좌 목록';
$string['coursecategory'] = '강좌 범주';
$string['coursecategorydeleted'] = '삭제된 강좌 범주 {$a}';
$string['coursecategory_help'] = '이 설정은 강좌가 강좌목록에 나타날 범주를 결정합니다.';
$string['coursecatmanagement'] = '강좌 및 범주 관리';
$string['coursecompletion'] = '강좌이수완료';
$string['coursecompletions'] = '강좌이수완료';
$string['coursecreators'] = '강좌 생성자';
$string['coursecreatorsdescription'] = '강좌 생성자는 새로운 과정을 개설할 수 있습니다.';
$string['coursedeleted'] = '강좌 {$a} 삭제됨';
$string['coursedisplay'] = '강좌 개요';
$string['coursedisplay_help'] = '이 설정은 전체 과정을 한 화면 또는 여러 화면에 나타나게 할 것인가를 정하는 것입니다. 하지만 SCORM형식과 같은 특정 과정 형식에는 영향을 미치지 못합니다.';
$string['coursedisplay_multi'] = '한 화면에 한 영역씩 보임';
$string['coursedisplay_single'] = '힌 화면에 모든 영역 보임';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = '예전 강좌 파일';
$string['coursefilesedit'] = '예전 강좌 파일 편집';
$string['coursefileswarning'] = '강좌파일은 사용을 권장하지 않습니다.';
$string['coursefileswarning_help'] = '강좌파일은 무들 2.0이후로 권장되지 않습니다. 가능한 외부 저장소를 사용하십시요.';
$string['courseformatdata'] = '강좌 유형 자료';
$string['courseformatoptions'] = '{$a}에 대한 강좌 형식 옵션';
$string['courseformats'] = '강좌 유형';
$string['courseformatudpate'] = '업데이트 포맷';
$string['coursegrades'] = '강좌 성적';
$string['coursehelpcategory'] = '학생들이 강좌를 쉽게 찾을 수 있도록 제시할 기본 범주';
$string['coursehelpforce'] = '강좌 내 모든 활동을 강제 모둠으로 지정';
$string['coursehelpformat'] = '강좌의 주 페이지가 이 형식으로 표식될 것입니다.';
$string['coursehelphiddensections'] = '학생들에게 강좌내 비공개 영역을 어떻게 제시할 것인가를 설정';
$string['coursehelpmaximumupload'] = '사이트 설정값 한도내에서 강좌에서 업로드할 수 있는 파일의 최대 크기를 정의하십시요';
$string['coursehelpnewsitemsnumber'] = '강좌 누리집의 오른쪽 새소식난에 게시될 새소식 항목 수<br/>(0 은 새소식난이 나타나지 않음)';
$string['coursehelpnumberweeks'] = '강좌의 주 페이지에 표시될 주차/토픽의 갯수';
$string['coursehelpshowgrades'] = '성적부 표시 활성화. 개별 활동 영역에서 성적이 표시되는 것을 막지는 않습니다';
$string['coursehidden'] = '아직 학생들이 강좌를 이용할 수 없음';
$string['courseinfo'] = '강좌 정보';
$string['courselegacyfiles'] = '예전 강좌 파일들';
$string['courselegacyfiles_help'] = '강좌 파일 영역은 무들 1.9 이전 버전에 대해 호환성을 제공합니다. 이 영역에 있는 모든 파일들은 강좌의 모든 참여자에게 접근가능(링크를 걸던 알 걸던) 하고 무들에서 이 파일들이 어디에서 사용하는지 알 수 없습니다.

강좌파일을 저장하기 위해 이 영역을 사용하면 개인정보와 보안 문제들이 발생할 수 있으며 백업, 강좌 가져오기,  강좌가 공유되고 재사용될때  파일이 누락될 수도 있습니다. 당신이 무엇을 하고 있는지 잘 알지 않는한 이 영역을 사용하지 않는 것을 권장합니다.

아래의 링크는 이것들에 대한 자세한 정보를 제공하며 무들 2에서 파일들을 관리하는 좋은 방법을 보여줄 것입니다.
';
$string['courselegacyfilesofcourse'] = '이전 강좌 파일들: {$a}';
$string['coursemessage'] = '강좌 사용자에게 메세지 보내기';
$string['coursenotaccessible'] = '공개적 접속을 허용하지 않음';
$string['courseoverview'] = '강좌 개요';
$string['courseoverviewfiles'] = '강좌 요약 파일';
$string['courseoverviewfilesext'] = '강좌 요약 파일 확장자들';
$string['courseoverviewfiles_help'] = '이미지 등의 강좌 요약 파일이 강좌 요약과 함께 강좌 목록에 표시됩니다.';
$string['courseoverviewfileslimit'] = '강좌 요약 파일 한계';
$string['courseoverviewgraph'] = '강좌 개요표';
$string['courseprofiles'] = '강좌 소개';
$string['coursereasonforrejecting'] = '요청이 기각된 이유';
$string['coursereasonforrejectingemail'] = '요청자에게 이메일로 발송될 것임';
$string['coursereject'] = '개설 요청 거부';
$string['courserejected'] = '강좌개설이 거부되었고 신청자에게 통보되었습니다.';
$string['courserejectemail'] = '죄송합니다만 당신의 강좌개설 요청이 거부되었습니다. 다음은 거부 이유입니다:
{$a}';
$string['courserejectreason'] = '강좌 개설이 거절된 이유<br />(이것은 신청자에게 이메일로 통보될 것입니다)';
$string['courserejectsubject'] = '강좌 개설 신청이 거부됨';
$string['coursereport'] = '강좌 보고서';
$string['coursereports'] = '강좌 보고서';
$string['courserequest'] = '개설 관리';
$string['courserequestdetails'] = '요청한 강좌의 내역';
$string['courserequestfailed'] = '웬일인지, 강좌 개설 요청을 저장할 수 없습니다.';
$string['courserequestintro'] = '이 양식을 사용해 원하는 교육과정의 개설을 요청하십시오.<br /> 운영자가 왜 당신이 이 교육과정을 개설하려고 하는지 충분히 알 수 있도록 많은 정보를 써주세요.';
$string['courserequestreason'] = '강좌 개설을 원하는 이유';
$string['courserequestsuccess'] = '개설 신청 저장 성공. 며칠안에 그 결과가 이메일로 통지될 것입니다.';
$string['courserequestsupport'] = '관리자가 검토할 때 도움이 될 정보';
$string['courserestore'] = '강좌 복원';
$string['courses'] = '강좌';
$string['coursesectionsummaries'] = '강좌의 영역 개요';
$string['coursesettings'] = '표준강좌 설정';
$string['coursesmovedout'] = '{$a} 에서 강좌 옮겨짐';
$string['coursespending'] = '유보되었던 강좌 승인';
$string['coursestart'] = '개강';
$string['coursesummary'] = '강좌 요약';
$string['coursesummary_help'] = '강좌 요약은 강좌 목록에 표시됩니다. 강좌 검색은 강좌명과 더불어 강좌 요약 문서를검색합니다.';
$string['courseupdates'] = '강좌 업데이트';
$string['create'] = '새로 만들기';
$string['createaccount'] = '새 계정 만들기';
$string['createcategory'] = '범주 생성';
$string['createfolder'] = '{$a} 에 새 폴더 만들기';
$string['createnew'] = '새로 만들기';
$string['createnewcategory'] = '새 범주 만들기';
$string['createnewcourse'] = '새 강좌 만들기';
$string['createnewsubcategory'] = '새 하위범주 만들기';
$string['createsubcategoryof'] = '{$a}의 하위범주 만들기';
$string['createuser'] = '사용자 생성';
$string['createuserandpass'] = '아이디와 비밀번호 생성';
$string['createziparchive'] = '압축 파일 만들기';
$string['creatingblocks'] = '블록 만들기';
$string['creatingblocksroles'] = '블록 수준의 역할 부여 및 덮어쓰기 생성';
$string['creatingblogsinfo'] = '블로그 소개 만들기';
$string['creatingcategoriesandquestions'] = '범주와 질문 만들기';
$string['creatingcoursemodules'] = '강좌 모듈 만들기';
$string['creatingcourseroles'] = '강좌 수준의 역할 부여 및 덮어쓰기 생성';
$string['creatingevents'] = '일정 만들기';
$string['creatinggradebook'] = '성적부 만들기';
$string['creatinggroupings'] = '모둠무리 만들기';
$string['creatinggroupingsgroups'] = '모둠무리에 모둠 추가';
$string['creatinggroups'] = '모듬 만들기';
$string['creatinglogentries'] = '로그 목록 만들기';
$string['creatingmessagesinfo'] = '메시지 정보 만들기';
$string['creatingmodroles'] = '모듈 수준의 역할 부여 및 덮어쓰기 생성';
$string['creatingnewcourse'] = '새로운 강좌 생성';
$string['creatingrolesdefinitions'] = '역할 정의 생성';
$string['creatingscales'] = '척도 만들기';
$string['creatingsections'] = '섹션 만들기';
$string['creatingtemporarystructures'] = '임시 구조 만들기';
$string['creatinguserroles'] = '사용자 수준의 역할 부여 및 덮어쓰기 생성';
$string['creatingusers'] = '사용자 계정 만들기';
$string['creatingxmlfile'] = 'XML파일 만들기';
$string['currency'] = '화폐단위';
$string['currentcourse'] = '현재 강좌';
$string['currentcourseadding'] = '현재의 강좌, 데이터 추가하기';
$string['currentcoursedeleting'] = '현재의 강좌, 먼저 삭제하기';
$string['currentlanguage'] = '현재의 언어';
$string['currentlocaltime'] = '현재의 지역시';
$string['currentlyselectedusers'] = '현재 선택된 사용자들';
$string['currentpicture'] = '현재 사진';
$string['currentrelease'] = '현재의 배포 정보';
$string['currentversion'] = '현재의 버전';
$string['databasechecking'] = '무들 데이터베이스를 {$a->oldversion} 에서 {$a->newversion} 으로 업그레이드 중입니다.';
$string['databaseperformance'] = '데이터베이스 성능';
$string['databasesetup'] = '데이터베이스 설정';
$string['databasesuccess'] = '데이터베이스가 성공적으로 업그레이드됨';
$string['databaseupgradebackups'] = '현재 백업 버전은 {$a} 입니다.';
$string['databaseupgradeblocks'] = '현재 블록 버전은 {$a} 입니다.';
$string['databaseupgradegroups'] = '현재 모둠 버전은 {$a} 입니다.';
$string['databaseupgradelocal'] = '로컬 데이타베이스의 최신 버전은 {$a} 입니다.';
$string['databaseupgrades'] = '데이터베이스 업그레이드하기';
$string['date'] = '날짜';
$string['datechanged'] = '변경된 날짜';
$string['datemostrecentfirst'] = '날짜-최근부터';
$string['datemostrecentlast'] = '날짜-오래된 것부터';
$string['day'] = '일';
$string['days'] = '일';
$string['decodinginternallinks'] = '내부 링크 해독하기';
$string['default'] = '기본값';
$string['defaultcoursestudent'] = '학생';
$string['defaultcoursestudentdescription'] = '일반적으로 강좌 안에서 학생들의 활동은 제약을 받습니다.';
$string['defaultcoursestudents'] = '학생들';
$string['defaultcoursesummary'] = '이 강좌를 간단하게 소개하는 내용을 써 주세요.
무엇을 배우는 곳인지, 어느 정도의 수준인지....';
$string['defaultcourseteacher'] = '선생님';
$string['defaultcourseteacherdescription'] = '강좌 안에서 선생님은 학생의 등급을 매기거나 활동을 바꾸는 등, 거의 모든 일을 할 수 있습니다.';
$string['defaultcourseteachers'] = '선생님';
$string['defaulteditor'] = '기본 편집기';
$string['delete'] = '삭제';
$string['deleteablock'] = '블록 삭제';
$string['deleteall'] = '전부 삭제';
$string['deleteallcannotundo'] = '완전 삭제 - 되돌릴 수 없음';
$string['deleteallcomments'] = '모든 코멘트를 삭제';
$string['deleteallratings'] = '모든 등급을 삭제';
$string['deletecategory'] = '{$a} 범주 삭제';
$string['deletecategorycheck'] = '<b>\'{$a}\'<b/> 범주를 완전히 삭제하시겠습니까? 상위 범주로 모든 코스가 이동하거나 다른 장소로 이동됩니다.';
$string['deletecategorycheck2'] = '이 범주를 삭제하려면, 그 속에 있는 강좌와 범주를 어떻게 할 것인가를 선택해야 합니다.';
$string['deletecategoryempty'] = '범주가 비었습니다.';
$string['deletecheck'] = '{$a} 를 지울까요?';
$string['deletecheckfiles'] = '이 파일을 지우는 것이 확실합니까?';
$string['deletecheckfull'] = '{$a} 파일을 지우는 것이 확실합니까?';
$string['deletechecktype'] = '정말 {$a->type} 를 지우고자 합니까?';
$string['deletechecktypename'] = '정말 {$a->type} 의 "{$a->name}" 를 지우고자 합니까?';
$string['deletecheckwarning'] = '당신은 지금 이 파일을 지우려고 합니다.';
$string['deletecomment'] = '이 덧글 삭제';
$string['deletecompletely'] = '완전히 삭제';
$string['deletecourse'] = '강좌 삭제';
$string['deletecoursecheck'] = '강좌와 모든 자료를 완전히 지우시겠습니까?';
$string['deleted'] = '지워짐';
$string['deletedactivity'] = '{$a} 지워짐';
$string['deletedcourse'] = '{$a} 이 완전히 삭제됨';
$string['deletednot'] = '{$a} 를 지울 수 없습니다!';
$string['deletelogs'] = '로그 삭제';
$string['deleteselected'] = '선택 사항 삭제';
$string['deleteselectedkey'] = '선택된 키 삭제';
$string['deletingcourse'] = '강좌 {$a} 를 지우기';
$string['deletingexistingcoursedata'] = '강좌에 있는 데이터 지우기';
$string['deletingolddata'] = '오래된 데이터 지우기';
$string['department'] = '부서';
$string['desc'] = '내림차순';
$string['description'] = '설명';
$string['deselectall'] = '모두 선택해제';
$string['detailedless'] = '간단히';
$string['detailedmore'] = '자세히';
$string['directory'] = '디렉토리';
$string['disable'] = '관리모드 해제';
$string['disabledcomments'] = '덧글 비활성화';
$string['displayingfirst'] = '오직 첫째 {$a->count} {$a->things} 이 보여집니다.';
$string['displayingrecords'] = '{$a} 레코드 보기';
$string['displayingusers'] = '{$a->start} 에서 {$a->end} 까지 사용자 보기';
$string['displayonpage'] = '페이지에 표시';
$string['dndcourse'] = '정렬을 바꾸거나 다른 범주로 옮기기 위해 이 강좌를 끌어다 놓을 수 있습니다.';
$string['dndenabled_inbox'] = '파일을 끌어다 놓아 추가할 수 있음';
$string['dndnotsupported'] = '드래그 드롭 업로드가 지원되지 않습니다.';
$string['dndnotsupported_help'] = '사용 중인 브라우저가 끌어다 놓기 업로드를 지원하지 않습니다<br />이 기능은 Internet Explorer 버전 10 이상을 비롯하여 Chrome, Firefox, Safari 최신 버전에서 사용할 수 있습니다.';
$string['dndnotsupported_insentence'] = '드래그 드롭이 지원되지 않습니다.';
$string['dnduploadwithoutcontent'] = '올린 것에 아무런 내용이 없음';
$string['dndworkingfile'] = '파일을 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkingfilelink'] = '파일이나 링크를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkingfiletext'] = '파일이나 문서를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkingfiletextlink'] = '파일이나 문서 혹은 링크를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkinglink'] = '링크를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkingtext'] = '문서를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['dndworkingtextlink'] = '문서나 링크를 올리려면 강좌 영역에 끌어다 놓을 것';
$string['documentation'] = '무들 문서';
$string['dontsortcategories'] = '범주를 정렬하지 마십시요';
$string['dontsortcourses'] = '강좌를 정렬하지 마십시요';
$string['down'] = '아래';
$string['download'] = '내려받기';
$string['downloadall'] = '모두 내려받기';
$string['downloadexcel'] = '엑셀 양식으로 내려받기';
$string['downloadfile'] = '파일 내려받기';
$string['downloadods'] = 'ODS 양식으로 내려받기';
$string['downloadtext'] = '텍스트 양식으로 내려받기';
$string['doyouagree'] = '이러한 조건을 읽고 이해하였습니까?';
$string['droptoupload'] = '여기에 파일을 놓아 업로드';
$string['duplicate'] = '복제';
$string['duplicateconfirm'] = '정말 {$a->modtype} \'{$a->modname}\'를 복사하겠습니까?';
$string['duplicatecontcourse'] = '강좌로 복귀';
$string['duplicatecontedit'] = '복사본 편집';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\'를 성공적으로 복사하였습니다.';
$string['duplicatinga'] = '{$a} 를 복제중';
$string['edhelpaspellpath'] = '맞춤법검사 기능을 이용하기 위해서는 <strong>aspell 0.50</strong>이 설치되어있거나 서버에 설치한 후, aspell 프로그램에 접근하는 정확한 경로를 명시해야 합니다. Linix/Unix 시스템에서 이 경로는 대체로 <strong>/usr/bin/aspell</strong>이나, 그렇지  않을 때도 있습니다';
$string['edhelpbgcolor'] = '편집창의 배경색을 결정합니다.<br />유효한 값은 #ffffff 또는 white 등 입니다.';
$string['edhelpcleanword'] = '이 설정은 특정-워드 형태의 필터링을 가능하게 하거나, 불가능하게 합니다.';
$string['edhelpenablespelling'] = '맞춤법 검사 기능을 설정합니다. 맞춤법 검사를 활성화할 경우, <strong>aspell</strong>이 서버에 설치되어 있어야만 합니다.';
$string['edhelpfontfamily'] = '폰트-패밀리 속성은 폰트 패밀리 명칭이나, 일반적 문자의 패밀리 명칭을 모아 놓은 목록입니다. 패밀리 명칭은 쉼표로 구분되어야 합니다.';
$string['edhelpfontlist'] = '편집기의 펼침 메뉴에 사용될 문자를 정의합니다.';
$string['edhelpfontsize'] = '기본글꼴 크기는 문자의 크기를 결정합니다.<br />유효한 값은 medium, large, smaller, larger, 10pt,11px 등입니다.';
$string['edit'] = '고치기';
$string['edita'] = '{$a} 고치기';
$string['editcategorysettings'] = '범주 설정 편집';
$string['editcategorythis'] = '이 범주 편집';
$string['editcoursesettings'] = '강좌 설정 고치기';
$string['editfiles'] = '파일 고치기';
$string['editgroupprofile'] = '모둠 정보 고치기';
$string['editinga'] = '{$a} 고치는 중';
$string['editingteachershort'] = '편집자';
$string['editlock'] = '이 값은 고칠 수 없습니다!';
$string['editmyprofile'] = '개인정보 수정';
$string['editorbgcolor'] = '배경 색상';
$string['editorcleanonpaste'] = '덧붙여진 HTML 태그 삭제';
$string['editorcommonsettings'] = '일반 설정';
$string['editordefaultfont'] = '기본 글꼴';
$string['editorenablespelling'] = '맞춤법검사 가능';
$string['editorfontlist'] = '글꼴목록';
$string['editorfontsize'] = '기본글꼴 크기';
$string['editorresettodefaults'] = '기본값으로 재설정';
$string['editorsettings'] = '편집기 설정';
$string['editorshortcutkeys'] = '편집 단축키';
$string['editsettings'] = '설정';
$string['editsummary'] = '요약 고치기';
$string['editthisactivity'] = '이 활동 고치기';
$string['editthiscategory'] = '이 범주 고치기';
$string['edittitle'] = '제목 수정';
$string['edittitleinstructions'] = '취소하려면 Esc키를 누르고, 끝내려면 엔터';
$string['edituser'] = '사용자 계정 편집';
$string['email'] = '이메일 주소';
$string['emailactive'] = '이메일 활성화';
$string['emailagain'] = '이메일 (다시)';
$string['emailalreadysent'] = '암호 재설정 이메일이 이미 보내어졌습니다. 이메일을 확인하십시요.';
$string['emailcharset'] = '이메일 문자셋';
$string['emailconfirm'] = '계정 확인';
$string['emailconfirmation'] = '안녕하세요 {$a->firstname},

\'{$a->sitename}\'의 이메일 주소를 통해서 새로운 계정이 요청되었습니다.
새로운 계정을 사용하시려면 아래의 웹 주소로 가세요.

{$a->link}

대부분의 메일 프로그램에서 파란색 링크로 보일 것입니다. 클릭하면 됩니다. 만일 이를 지원하지 않으면 위에 있는 주소를 복사하여 웹 브라우저의 주소창에 복사해 넣으셔도 가능합니다.

만약 도움이 필요하시면, 아래 관리자에게 연락주세요.
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: 계정 승인';
$string['emailconfirmsent'] = '<p>당신의 이메일 주소인 <b>{$a}</b>로 메일이 갔습니다.</p>
<p>등록을 마치기 위한 간단한 안내문이 포함되어 있습니다.</p>';
$string['emaildigest'] = '이메일 요약 형식';
$string['emaildigestcomplete'] = '전부다(모든 게시 내용에 대해 매일)';
$string['emaildigest_help'] = '아래는 포럼에서 기본 값으로 사용할 일별 다이제스트 설정입니다.

* 다이제스트 없음 - 포럼 게시글마다 하나의 이메일을 받습니다.
* 다이제스트 - 모든 게시글 - 매일 각 포럼 게시글의 내용을 전부 담은 다이제스트 이메일을 한 통 받습니다.
* 다이제스트 - 제목만 - 매일 각 포럼 게시글의 제목만 담은 다이제스트 이메일을 한 통 받습니다.';
$string['emaildigestoff'] = '요약하지 않음(포럼 게시물이 게시될 때만)';
$string['emaildigestsubjects'] = '제목만(매일)';
$string['emaildisable'] = '이메일 전송 금지';
$string['emaildisableclick'] = '여기를 눌러 모든 이메일이 이 주소로 보내지는 것을 불가능하게 함';
$string['emaildisplay'] = '이메일 공개';
$string['emaildisplaycourse'] = '강좌 참여자에게만 공개';
$string['emaildisplayhidden'] = '이메일 숨김';
$string['emaildisplayno'] = '모든 사람에게 비공개';
$string['emaildisplayyes'] = '모든 사람에게 공개';
$string['emailenable'] = '이메일 전송 허용';
$string['emailenableclick'] = '모든 이메일이 이 주소로 보내질수 있도록 재설정하려면 여기를 누름';
$string['emailexists'] = '이 이메일 주소는 이미 등록된 것임';
$string['emailformat'] = '이메일 양식';
$string['emailmustbereal'] = '경고: 이메일 주소는 실제 사용할 수 있는 것이어야 함';
$string['emailnotallowed'] = '이 도메인의 이메일 주소는 허가되지않는 ({$a})임';
$string['emailnotfound'] = '이 이메일 주소는 데이터베이스에 없는 이메일 주소임';
$string['emailonlyallowed'] = '이 이메일은 허가된 ({$a})중의 하나가 아님';
$string['emailpasswordchangeinfo'] = '안녕하세요 {$a->firstname},

누군가(아마 당신) 당신의 계정 \'{$a->sitename}\' 으로 새로운 비밀번호를 요청했습니다.

비밀 번호를 변경하려면 아래의 주소를 클릭해주세요.

{$a->link}

대부분의 메일 프로그램에서 파란색 링크로 보일 텐데 그냥 클릭하면 됩니다. 만일 이를 지원하지 않으면 위에 있는 주소를 복사하여 웹 브라우저의 주소창에 복사해 넣으셔도 가능합니다.

만약 도움이 필요하시면 아래의 관리자에게 연락주세요.
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = '안녕하세요 {$a->firstname},

누군가(아마 당신) 당신의 계정 \'{$a->sitename}\' 으로 새로운 비밀번호를 요청했습니다.

유감스럽게도 본 사이트에서 당신의 계정을 사용할 수 없게 되었으며 초기화시킬 수도 없습니다. 사이트 관리자 {$a->admin} 에게 연락해 주십시오.';
$string['emailpasswordchangeinfofail'] = '안녕하세요 {$a->firstname},

누군가(아마 당신) 당신의 계정 \'{$a->sitename}\' 으로 새로운 비밀번호를 요청했습니다.

유감스럽게도 본 사이트에서는 비밀번호를 초기화시킬 수 없으므로 사이트 관리자인 {$a->admin} 에게 연락해 주십시오.';
$string['emailpasswordchangeinfosubject'] = '{$a}: 비밀번호 변경 안내';
$string['emailpasswordconfirmation'] = '안녕하세요 {$a->firstname},

누군가(아마 당신) 당신의 계정 \'{$a->sitename}\' 으로 새로운 비밀번호를 요청했습니다.

만약 확실하다면 아래의 주소를 클릭해주세요.

{$a->link}

대부분의 메일 프로그램에서 파란색 링크로 보일 것입니다. 클릭하면 됩니다. 만일 이를 지원하지 않으면 위에 있는 주소를 복사하여 웹 브라우저의 주소창에 복사해 넣으셔도 가능합니다.

만약 도움이 필요하시면 아래의 관리자에게 연락주세요.
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: 비밀번호 변경 확인';
$string['emailpasswordconfirmmaybesent'] = '<p>만약 사용자 ID나 이메일 주소가 정확하면 이메일이 발송될 것입니다.</p>
 <p>거기에는 암호변경을 완료하고 확인하기 위한 간단한 안내문이 포함되어 있습니다. 만일 지속적으로 어려움을 격는다면, 사이트 관리자에게 연락하기 바랍니다.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>지정한 사용자 계정에 기록된 이메일 주소가 없습니다.</p>
   <p>사이트 관리자에게 문의하시기 바랍니다.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>제공하신 사용자 세부 정보와 일치하는 사용자 계정을 찾을 수 없습니다.</p>
   <p>입력한 정보를 확인하고 다시 시도하십시오.
문제가 계속되면 사이트 관리자에게 문의하시기 바랍니다.</p>';
$string['emailpasswordconfirmsent'] = '<b>{$a}</b>로 이메일이 보내지게 됩니다
<br />비밀번호 변경 확인을 위한 내용이 포함됩니다.
만일 지속적으로 어려움을 격는다면, 사이트 관리자에게 연락하기 바랍니다.';
$string['emailpasswordsent'] = '비밀번호 변경에 대한 확인을 해 주셔서 감사합니다.
<br />새로운 비밀번호가 포함된 이메일이 <b>{$a->email}</b> 로 보내졌습니다.
<br />새 비밀번호는 자동으로 생성되었습니다.
<a href="{$a->link}">비밀번호 변경하기</a> 로 가서 기억하기 쉬운 비밀번호로 바꾸세요.';
$string['emailresetconfirmation'] = '안녕하세요 {$a->firstname}님,

{$a->sitename} 사이트의 \'{$a->username}\' 계정에 대해 암호 재설정이 요청되었습니다.

이 요청을 확인하고 계정에 새로운 암호를 설정하려면 다음 웹 주소를 방문하십시오:

{$a->link}
(이 링크는 재설정이 요청된 시점으로부터 {$a->resetminutes}분 동안 유효합니다)

만약 여러분이 재설정을 요청하지 않았다면 별도의 작업이 필요하지 않습니다.

도움이 필요한 경우에는 사이트 관리자 {$a->admin}에게 문의하시기 바랍니다.';
$string['emailresetconfirmationsubject'] = '{$a}: 암호 재설정 요청';
$string['emailresetconfirmsent'] = '<b>{$a}</b>에 있는 주소로 이메일을 보냈습니다.
<br />거기에는 이 암호 변경을 확인하고 마치기 위한 간단한 지시 사항이 포함되어 있습니다. 문제가 계속되면 사이트 관리자에게 문의하십시오.';
$string['emptydragdropregion'] = '빈 영역';
$string['enable'] = '관리모드 활성';
$string['encryptedcode'] = '암호화된 코드';
$string['english'] = '영어';
$string['enrolmentmethods'] = '등록 방법';
$string['entercourse'] = '이 강좌에 들어가려면 클릭';
$string['enteremail'] = '이메일 주소 입력';
$string['enteremailaddress'] = '이메일 주소로 새로운 비밀번호가 전송됩니다.';
$string['enterusername'] = '사용자아이디 입력';
$string['entries'] = '입력 내용';
$string['error'] = '오류';
$string['errorcreatingactivity'] = '\'{$a}\' 활동의 기능을 생성할 수 없음';
$string['errorfiletoobig'] = '파일 크기 한계인 {$a} 바이트를 초과함';
$string['errornouploadrepo'] = '이 사이트에는 올릴만한 저장소가 없음';
$string['errorwhenconfirming'] = '오류가 발생되어 아직 승인되지 않았습니다.
이메일에서 링크를 클릭했는지 확인해 주세요. 링크의 주소를 브라우저 창에 복사하셔도 가능합니다.';
$string['eventcontentviewed'] = '콘텐츠 봄';
$string['eventcoursecategorydeleted'] = '범주 삭제됨';
$string['eventcoursecontentdeleted'] = '강좌 콘텐츠가 삭제되었습니다.';
$string['eventcoursecreated'] = '강좌가 생성되었습니다.';
$string['eventcoursedeleted'] = '강좌가 삭제되었습니다.';
$string['eventcoursemodulecreated'] = '강좌 모듈이 생성되었습니다.';
$string['eventcoursemoduledeleted'] = '강좌 모듈이 삭제되었습니다.';
$string['eventcoursemoduleupdated'] = '강좌 모듈이 업데이트 되었습니다.';
$string['eventcourseresetended'] = '강좌 초기화가 끝났습니다.';
$string['eventcourseresetstarted'] = '강좌 초기화가 시작되었습니다.';
$string['eventcourserestored'] = '강좌가 복원되었습니다.';
$string['eventcoursesectionupdated'] = '강좌 섹션이 업데이트 되었습니다.';
$string['eventcourseupdated'] = '강좌가 업데이트 되었습니다.';
$string['eventusercreated'] = '사용자가 생성되었습니다.';
$string['eventuserdeleted'] = '사용자가 삭제되었습니다.';
$string['eventuserlistviewed'] = '사용자 목록 봄';
$string['eventuserloggedout'] = '사용자가 로그아웃 했습니다.';
$string['eventuserprofileviewed'] = '사용자 프로파일 봄';
$string['eventuserupdated'] = '사용자가 업데이트 되었습니다.';
$string['everybody'] = '모두';
$string['executeat'] = '작동시각';
$string['existing'] = '존재함';
$string['existingadmins'] = '기존 관리자';
$string['existingcourse'] = '이미 있는 강좌';
$string['existingcourseadding'] = '이미 있는 강좌, 여기에 자료 추가하기';
$string['existingcoursedeleting'] = '존재하는 강좌, 먼저 삭제하기';
$string['existingcreators'] = '기존의 강좌 만든이';
$string['existingstudents'] = '소속된 학생들';
$string['existingteachers'] = '존재하는 선생님들';
$string['expand'] = '확대';
$string['expandall'] = '모두 펼치기';
$string['expandcategory'] = '{$a} 확대';
$string['explanation'] = '설명';
$string['extendenrol'] = '등록 연장(개인)';
$string['extendperiod'] = '기간 연장';
$string['failedloginattempts'] = '마지막 로그인 후 {$a->attempts} 회 로그인 실패';
$string['failedloginattemptsall'] = '{$a->accounts} 로 {$a->attempts} 회 로그인 실패';
$string['feedback'] = '피드백';
$string['file'] = '파일';
$string['fileexists'] = '이미 {$a} 파일이 있음';
$string['filemissing'] = '{$a} 이 빠짐.';
$string['files'] = '파일';
$string['filesanduploads'] = '파일 및 업로드';
$string['filesfolders'] = '파일/폴더';
$string['filetoolarge'] = '올리기엔 너무 큼';
$string['fileuploadwithcontent'] = '파일 업로드시 콘텐츠 매개변수는 포함할 수 없음';
$string['filloutallfields'] = '이 서식의 모든 항목을 채워주세요.';
$string['filter'] = '필터';
$string['findmorecourses'] = '더 많은 강좌 보기...';
$string['first'] = '처음';
$string['firstaccess'] = '처음 접속';
$string['firstname'] = '성';
$string['firstnamephonetic'] = '이름-음성학적';
$string['firstsiteaccess'] = '사이트 최초 액세스';
$string['firsttime'] = '이곳에 처음 오셨나요?';
$string['folder'] = '폴더';
$string['folderclosed'] = '닫힌 경로';
$string['folderopened'] = '열린 경로';
$string['followingoptional'] = '아래 항목은 선택사항입니다.';
$string['followingrequired'] = '아래 항목은 필수사항입니다.';
$string['for'] = '위해서';
$string['force'] = '강제지정';
$string['forcelanguage'] = '지정 언어';
$string['forceno'] = '지정하지 않음';
$string['forcepasswordchange'] = '강제로 암호 변경';
$string['forcepasswordchangecheckfull'] = '정말, 비밀번호를 {$a} 로 바꾸시겠습니까?';
$string['forcepasswordchange_help'] = '다음번 로그인 할 때, 사용자에게 비밀번호를 바꿀 것을 요구';
$string['forcepasswordchangenot'] = '비밀번호를 {$a} 로 바꿀 수 없음';
$string['forcepasswordchangenotice'] = '계속하려면 비밀번호를 바꿔야만 함';
$string['forcetheme'] = '지정된 테마';
$string['forgotaccount'] = '비밀번호를 잊으셨습니까?';
$string['forgotten'] = '사용자 아이디나 비밀번호를 잊으셨습니까?';
$string['forgottenduplicate'] = '이메일 주소가 여러 계정에 중복되어 있으므로 사용자 아이디를 대신 입력해 주십시오.';
$string['forgotteninvalidurl'] = '비밀번호 불일치';
$string['format'] = '형식';
$string['format_help'] = '강좌 유형은 강좌 페이지의 레이아웃을 결정합니다.

* SCORM 형식 -  강좌 페이지 첫 섹션에 SCORM 패키지가 표시됩니다. (SCORM/AICC 활동 모듈을 사용하는 대안으로서)
* 사회적 형식 -  포럼이 강좌 페이지에 표시됩니다.
* 토픽 형식 -  강좌 페이지가 토픽 섹션들로 구성됩니다.
* 주간 형식 -  강좌 페이지가 주간 섹션들로 구성되며 첫 주의 시작일은 강좌의 시작일과 같습니다.
';
$string['formathtml'] = 'HTML 형식';
$string['formatmarkdown'] = 'Markdown 형식';
$string['formatplain'] = '텍스트 형식';
$string['formattext'] = '무들 자동 형식';
$string['formattexttype'] = '포멧팅';
$string['framesetinfo'] = '이 프레임셋 문서는 다음을 포함 :';
$string['from'] = '부터';
$string['frontpagecategorycombo'] = '합쳐진 범주';
$string['frontpagecategorynames'] = '범주 보기';
$string['frontpagecourselist'] = '강좌 목록';
$string['frontpagecoursesearch'] = '강좌 검색 상자';
$string['frontpagedescription'] = '시작 페이지 설명';
$string['frontpagedescriptionhelp'] = '시작 페이지에 사이트에 대한 설명이 표시될 것 입니다.';
$string['frontpageenrolledcourselist'] = '등록된 강좌';
$string['frontpageformat'] = '시작 페이지 형식';
$string['frontpageformatloggedin'] = '로그인 했을 때 시작 페이지';
$string['frontpagenews'] = '새소식 보기';
$string['frontpagesettings'] = '시작 페이지 설정';
$string['fulllistofcourses'] = '강좌목록';
$string['fullname'] = '전체 이름';
$string['fullnamecourse'] = '강좌 전체 이름';
$string['fullnamecourse_help'] = '강좌의 전체 이름은 강좌 목록 및 강좌의 모든 페이지의 윗 쪽에 표시됩니다.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = '사용자 성명';
$string['fullprofile'] = '전체 개인정보';
$string['fullsitename'] = '사이트 정식 명칭';
$string['functiondisabled'] = '그 기능은 현재 사용할 수 없음';
$string['general'] = '기본';
$string['geolocation'] = '경도 - 위도';
$string['gettheselogs'] = '기록 보기';
$string['go'] = '다음';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)< /br>< /br>
이 프로그램은 프리웨어입니다. 당신은 자유소프트웨어 재단이 선언한 GNU 일반 공중 사용 허가서에 근거하여 재배포할 수도 있고, 수정하여 사용할 수도 있습니다. 이에는 GPL 버전 2 또는 그 이후의 버전이 적용됩니다.< /br>< /br>
이 프로그램은 유용할 것이라는 희망으로 배포되었습니만, 어떠한 종류의 상업적 이익이나 특별한 의도를 지지하는 등에 대해 보장하지 않습니다.< /br>< /br>
무들 저작권에 대해 상세한 정보가 필요하시면 아래의 사이트(영문)를 참고하시기 바랍니다.< /br> http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)< /br>< /br>
이 프로그램은 프리웨어입니다. 당신은 자유소프트웨어 재단이 선언한 GNU 일반 공중 사용 허가서에 근거하여 재배포할 수도 있고, 수정하여 사용할 수도 있습니다. 이에는 GPL 버전 3 또는 그 이후의 버전이 적용됩니다.< /br>< /br>
이 프로그램은 유용할 것이라는 희망으로 배포되었습니만, 어떠한 종류의 상업적 이익이나 특별한 의도를 지지하는 등에 대해 보장하지 않습니다.< /br>< /br>
무들 저작권에 대해 상세한 정보가 필요하시면 아래의 사이트(영문)를 참고하시기 바랍니다.< /br> http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL 사용허가';
$string['grade'] = '성적';
$string['grades'] = '성적';
$string['gravatarenabled'] = '본 사이트는 이미 <a href="http://www.gravatar.com/">Gravatar</a>가 활성화되어 있습니다. 만일 프로필 사진을 올리지 않았다면, 무들은 Gravatar에서 프로필 사진을 탑재하려 할 것입니다.';
$string['group'] = '모둠';
$string['groupadd'] = '새 모둠을 추가';
$string['groupaddusers'] = '선택된 모둠에 사용자 추가';
$string['groupextendenrol'] = '등록 연장(공통)';
$string['groupfor'] = '모둠을 위한';
$string['groupinfo'] = '선택된 모둠의 정보';
$string['groupinfoedit'] = '모둠 설정 편집';
$string['groupinfomembers'] = '선택된 구성원의 정보';
$string['groupinfopeople'] = '선택된 사람의 정보';
$string['groupmembers'] = '모둠 구성원';
$string['groupmemberssee'] = '모둠 구성원 보기';
$string['groupmembersselected'] = '선택된 모둠의 구성원';
$string['groupmode'] = '모둠 모드';
$string['groupmodeforce'] = '강제 모둠 모드';
$string['groupmy'] = '내 모둠';
$string['groupnonmembers'] = '모둠에 속하지 않은 사람';
$string['groupnotamember'] = '죄송합니다, 당신은 모둠의 구성원이 아닙니다.';
$string['grouprandomassign'] = '모든 사람을 무작위로 모둠에 배정';
$string['groupremove'] = '선택된 모둠 삭제하기';
$string['groupremovemembers'] = '선택한 구성원 삭제하기';
$string['groups'] = '모둠';
$string['groupsnone'] = '모둠 없음';
$string['groupsseparate'] = '분리된 모둠';
$string['groupsvisible'] = '열린 모둠';
$string['guest'] = '손님계정';
$string['guestdescription'] = '어디에서건 손님 계정으로는 내용을 입력하지 못하는 등, 최소의 권한을 가집니다.';
$string['guestskey'] = '키를 갖고 있는 손님 허용하기';
$string['guestsno'] = '손님 계정 허용하지 않기';
$string['guestsnotallowed'] = '미안합니다, \'{$a}\' 에 손님 계정으로 입장할 수 없습니다.';
$string['guestsyes'] = '키 없는 손님 계정 허용하기';
$string['guestuser'] = '손님 사용자';
$string['guestuserinfo'] = '대개의 강좌에서 읽기만 할 수 있는 계정입니다.';
$string['help'] = '도움';
$string['helpprefix2'] = '{$a} 를 포함하는 도움말';
$string['helpwiththis'] = '이것에 대한 도움말';
$string['hiddenassign'] = '비공개 과제';
$string['hiddenfromstudents'] = '학생에게 비공개';
$string['hiddensections'] = '비공개 영역';
$string['hiddensectionscollapsed'] = '비공개 영역은 제목만 보여짐';
$string['hiddensections_help'] = '이 설정은 감춰진 섹션(주차별 형식인 강좌에서 공휴일을 나타내기 위해서 사용될 수 있음)이 축소된 형태로 학생들에게 표시될지 아주 감추어질지를 결정합니다.';
$string['hiddensectionsinvisible'] = '비공개 영역은 완전히 볼수 없음';
$string['hide'] = '감추기';
$string['hideadvancedsettings'] = '고급 설정 숨기기';
$string['hidepicture'] = '그림 감추기';
$string['hidesection'] = '섹션 {$a} 숨기기';
$string['hidesettings'] = '설정 숨기기';
$string['hideshowblocks'] = '블록 보이기/숨기기';
$string['hits'] = '접속수';
$string['hitsoncourse'] = '{$a->username} 의 {$a->coursename} 접속수';
$string['hitsoncoursetoday'] = '오늘 {$a->username} 가 {$a->coursename} 에 접속한 횟수';
$string['home'] = '홈';
$string['hour'] = '시';
$string['hours'] = '시간';
$string['howtomakethemes'] = '새로운 테마를 만드는 법';
$string['htmleditor'] = 'HTML 편집기 사용';
$string['htmleditoravailable'] = 'HTML 편집기 사용 가능';
$string['htmleditordisabled'] = '개인정보에서 HTML편집기를 사용 불가로 설정하셨습니다.';
$string['htmleditordisabledadmin'] = '관리자가 HTML편집기를 사용할 수 없도록 설정하였습니다.';
$string['htmleditordisabledbrowser'] = '편집기가 웹 브라우져와 호환되지 않아 사용할 수 없습니다.';
$string['htmlfilesonly'] = 'HTML 파일만';
$string['htmlformat'] = 'HTML 포멧';
$string['icon'] = '아이콘';
$string['icqnumber'] = 'icq 번호';
$string['idnumber'] = 'id 번호';
$string['idnumbercourse'] = '강좌 식별 번호';
$string['idnumbercoursecategory'] = '범주 식별 번호';
$string['idnumbercoursecategory_help'] = '강좌 범주의 식별번호는 단지 외부 시스템의 범주와 비교할 때 외에는 쓰이지 않고, 사이트의 그 어디에서도 드러나지 않습니다. 만일 범주가 공식적인 코드명을 가지고 있다면 입력할 필요가 있지만, 그 외에는 비어두어도 됩니다.';
$string['idnumbercourse_help'] = '강좌의 ID 번호는 강좌를 외부 시스템과 매칭시킬 때만 사용되며 무들 사이트에서는 표시되지 않습니다. 만일 강좌가 공식적인 코드명을 갖고 있다면  이것이 입력 될수 있습니다. 그렇지 않다면, 이를 공백으로 둘 수 있습니다.';
$string['idnumbergroup'] = '모둠 식별 번호';
$string['idnumbergroup_help'] = '모둠모음의 식별번호는 단지 외부 시스템의 모둠모음과 비교할 때 외에는 쓰이지 않고, 사이트의 그 어디에서도 드러나지 않습니다. 만일 모둠모음이 공식적인 코드명을 가지고 있다면 입력할 필요가 있지만, 그 외에는 비어두어도 됩니다.';
$string['idnumbergrouping'] = '모둠그룹핑 식별번호';
$string['idnumbergrouping_help'] = '모둠모음의 식별번호는 단지 외부 시스템의 모둠모음과 비교할 때 외에는 쓰이지 않고, 사이트의 그 어디에서도 드러나지 않습니다. 만일 모둠모음이 공식적인 코드명을 가지고 있다면 입력할 필요가 있지만, 그 외에는 비어두어도 됩니다.';
$string['idnumbermod'] = '식별 번호';
$string['idnumbermod_help'] = 'ID 번호를 설정하는 것은 점수 계산을 할 때 각각의 활동을 구별하기 위한 한 방안입니다. 만일 활동이 어떤 점수 계산에도 포함되지 않는다면 식별 번호 필드를 공백으로 두어도 무방합니다.
ID 번호는 활동 설정 페이지에서 편집할 수 있지만, 또한 성적부에서도 설정될 수 있다.';
$string['idnumbertaken'] = '이 ID는 이미 쓰고 있습니다.';
$string['imagealt'] = '그림 설명';
$string['import'] = '가져오기';
$string['importdata'] = '가져올 강좌 정보';
$string['importdataexported'] = '강좌로부터 내보낸 정보를 성공적으로 불러들였습니다.<br />가져오기를 계속합니다.';
$string['importdatafinished'] = '가져오기 완료!  계속 진행하세요.';
$string['importdatafrom'] = '데이터를 가져올 강좌 찾기:';
$string['inactive'] = '비활동';
$string['include'] = '포함';
$string['includeallusers'] = '모든 사용자 포함';
$string['includecoursefiles'] = '강좌 파일 포함';
$string['includecourseusers'] = '강좌 사용자 포함';
$string['included'] = '포함됨';
$string['includelogentries'] = '로그 목록 포함';
$string['includemodules'] = '모듈 포함';
$string['includemoduleuserdata'] = '모듈의 사용자 데이터 포함';
$string['includeneededusers'] = '필수 사용자 포함';
$string['includenoneusers'] = '사용자 없음 포함';
$string['includeroleassignments'] = '역할 부여 포함';
$string['includesitefiles'] = '이 강좌에서 사용된 사이트 파일 포함';
$string['includeuserfiles'] = '사용자 파일 포함';
$string['increasesections'] = '영역 번호 증가';
$string['info'] = '정보';
$string['institution'] = '기관';
$string['instudentview'] = '학생 관점에서';
$string['interests'] = '관심분야';
$string['interestslist'] = '관심사 목록';
$string['interestslist_help'] = '자신의 관심 항목을 쉼표로 분리하여 입력하십시요. 당신의 관심사는 개인정보 페이지에 태그로 표시될 것입니다.';
$string['invalidemail'] = '쓸 수 없는 이메일 주소';
$string['invalidlogin'] = '다시 로그인해 주세요.';
$string['invalidusername'] = '이이디에는 영어소문자, 숫자, 밑줄, 하이폰, 쉼표, 마침표 또는 @ 기호만을 쓸 수 있습니다.';
$string['invalidusernameupload'] = '쓸 수 없는 ID';
$string['ip_address'] = 'ip 주소';
$string['jump'] = '가기';
$string['jumpto'] = '..로 바로 가기';
$string['keep'] = '유지';
$string['keepsearching'] = '계속 찾기';
$string['langltr'] = '왼쪽에서 오른쪽으로 쓰는 언어';
$string['langrtl'] = '오른쪽에서 왼쪽으로 쓰는 언어';
$string['language'] = '언어';
$string['languagegood'] = '언어팩이 업데이트되었습니다.';
$string['last'] = '마지막';
$string['lastaccess'] = '최근의 접속';
$string['lastcourseaccess'] = '강좌 최종 액세스';
$string['lastedited'] = '마지막 수정됨';
$string['lastlogin'] = '마지막 로그인';
$string['lastmodified'] = '마지막 수정됨';
$string['lastname'] = '이름';
$string['lastnamephonetic'] = '성-음성학적';
$string['lastsiteaccess'] = '사이트 최종 액세스';
$string['lastyear'] = '지난 해';
$string['latestlanguagepack'] = 'moodle.org에서 최신의 언어 팩 확인하기';
$string['layouttable'] = '배치표';
$string['leavetokeep'] = '현재의 패스워드를 유지하려면 비워두세요.';
$string['legacythemeinuse'] = '브라우저가 너무 오래되어 사이트가 호환모드에서 보여지고 있습니다.';
$string['license'] = '사용허가';
$string['licenses'] = '사용허가';
$string['liketologin'] = '완전한 사용자 계정으로 로그인 하시겠습니까?';
$string['list'] = '목록';
$string['listfiles'] = '{$a} 의 파일 목록';
$string['listofallpeople'] = '모든 사람 목록';
$string['listofcourses'] = '강좌 목록';
$string['loadinghelp'] = '로딩 중 ...';
$string['local'] = '로컬';
$string['localplugins'] = '로컬 플러그인';
$string['localpluginsmanage'] = '로컬 플러그인 관리';
$string['location'] = '위치';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = '{$a} 계정으로 접속';
$string['loggedinasguest'] = '손님 계정으로 접속';
$string['loggedinnot'] = '접속되지 않았습니다.';
$string['login'] = '로그인';
$string['loginalready'] = '이미 로그인 되있습니다';
$string['loginas'] = '..로 로그인';
$string['loginaspasswordexplain'] = '<p>본 기능을 이용하려면 지정한 "loginas password"를 입력해야 합니다.<br />잘 모르겠으면 서버 관리자에게 문의하기 바랍니다.</p>';
$string['login_failure_logs'] = '로그인 실패 기록';
$string['loginguest'] = '손님으로 로그인';
$string['loginsite'] = '사이트에 로그인';
$string['loginsteps'] = '안녕하세요! 이 웹사이트를 제대로 이용하려면 새로운 계정을 만들어야 합니다. 어떤 강좌는 등록키가 필요할 수도 있습니다.
   <ol>
   <li> <a href="{$a}">새로운 계정 만들기</a>를 클릭하여 양식을 채워넣습니다.</li>
   <li> 입력한 이메일 주소로 확인 메일이 즉시 전송됩니다.</li>
   <li>이메일을 읽고, 포함된 웹링크를 클릭합니다.</li>
   <li>당신의 계정이 등록 확인되면 로그인 할 수 있습니다.</li>
   <li>이제 참여하고 싶은 강좌를 선택합니다.</li>
   <li>등록키를 입력하는 칸이 있다면, 선생님이 알려준 암호를 넣으면 됩니다.</li>
   <li>등록이 완료되면 강좌를 충분히 이용할 수 있습니다. 앞으로는 신청한 강좌를 수강하기 위해 개인 ID와 비밀번호만 필요할 것입니다.</li>
   </ol>';
$string['loginstepsnone'] = '<p>안녕하세요!</p>
<br /> 강좌를 제대로 이용하기 위해서는 계정을 생성하여야 합니다.
<br /> 사용자 아이디와 비밀번호를 입력해야 합니다.
<br /> 만약 입력한 아이디가 중복된다면 다른 아이디를 사용해야 합니다.';
$string['loginto'] = '{$a} 에 로그인하기';
$string['logout'] = '로그아웃';
$string['logoutconfirm'] = '로그아웃 하겠습니까?';
$string['logs'] = '로그';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">다음</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">다음</a> ]';
$string['lookback'] = '돌이켜 보기';
$string['mailadmins'] = '관리자에게 알림';
$string['mailstudents'] = '학생들에게 알림';
$string['mailteachers'] = '선생님께 알려드림';
$string['maincoursepage'] = '주 강좌 페이지';
$string['makeafolder'] = '폴더 만들기';
$string['makeeditable'] = '만약 웹서버에서 \'{$a}\'를 수정가능하도록 하면 웹상에서 바로 수정할 수 있습니다.';
$string['makethismyhome'] = '내 기본 누리집으로 만듬';
$string['manageblocks'] = '블록들';
$string['managecategorythis'] = '이 범주 관리';
$string['managecourses'] = '강좌 관리';
$string['managedatabase'] = '데이터베이스';
$string['manageeditorfiles'] = '편집기 관리';
$string['managefilters'] = '필터';
$string['managemodules'] = '모듈';
$string['manageroles'] = '역할과 권한';
$string['markedthistopic'] = '이 주제는 현재의 주제로서 강조됩니다.';
$string['markthistopic'] = '이 주제를 현재의 주제로 강조하기';
$string['matchingsearchandrole'] = '\'{$a->search}\' {$a->role} 찾은 내용';
$string['maxareabytesreached'] = '파일 크기(또는 여러 파일의 전체 크기)가 이 영역의 여유 공간보다 큽니다.';
$string['maxbytesforfile'] = '파일 {$a}가 허용되는 최대 크기보다 큽니다.';
$string['maxfilesize'] = '새 파일 최대크기: {$a}';
$string['maxfilesreached'] = '최대 {$a} 개의 파일을 첨부 가능';
$string['maximumchars'] = '{$a} 문자의 최대치';
$string['maximumgrade'] = '최대 성적';
$string['maximumgradex'] = '최대 성적: {$a}';
$string['maximumshort'] = '최대';
$string['maximumupload'] = '업로드 제한 용량';
$string['maximumupload_help'] = '<p>이 설정은 사이트 관리자에 의해 설정된 크기 이내에서 학생들이 올릴 수 있는 파일의 최대 크기를 지정하는 것입니다.</p>

<p>이것은 추후에 각 활동 모듈내에서 상황에 따라 더 제한할 수 있는 여지가 있게 됩니다.</p>';
$string['maxnumberweeks'] = '주/주제의 최대 수';
$string['maxnumberweeks_desc'] = '강좌에 표시될 몇 주 혹은 주제의 최대수를 조정';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} 강좌</a>를 보여줌';
$string['maxsize'] = '제한 용량: {$a}';
$string['maxsizeandareasize'] = '새 파일의 최대 크기 : {$a->size}, 전체 한도 : {$a->areasize}';
$string['maxsizeandattachments'] = '파일의 최대 크기: {$a->size}, 최대 첨부 파일 갯수: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = '새 파일의 최대 크기: {$a->size}, 최대 첨부 개수: {$a->attachments}, 전체 한도: {$a->areasize}';
$string['memberincourse'] = '강좌 동료';
$string['messagebody'] = '메세지 내용';
$string['messagedselectedusers'] = '선택한 사용자에게 메세지를 발송하고 수신인 목록을 초기화 합니다.';
$string['messagedselectedusersfailed'] = '선택한 사용자에게 메세지를 보내는 중 오류 발생. 누군가는 이미 메일을 받았을 것임.';
$string['messageprovider:availableupdate'] = '올리기 유의사항 표시';
$string['messageprovider:backup'] = '백업 통지';
$string['messageprovider:badgecreatornotice'] = '';
$string['messageprovider:badgerecipientnotice'] = '';
$string['messageprovider:courserequestapproved'] = '강좌 생성 요청 승인 통지';
$string['messageprovider:courserequested'] = '강좌 생성 요청 통지';
$string['messageprovider:courserequestrejected'] = '강좌 생성 요청 거절 통지';
$string['messageprovider:errors'] = '사이트관련 주요 오류';
$string['messageprovider:errors_help'] = '관리자가 꼭 알아야 할 심각한 오류가 있습니다.';
$string['messageprovider:instantmessage'] = '사용자간 개인적 메세지';
$string['messageprovider:instantmessage_help'] = '여기에서는 타 사용자가 여러분에게 직접 보내는 메시지를 어떻게 처리할 지를 설정합니다.';
$string['messageprovider:notices'] = '사소한 문제에 대한 유의점';
$string['messageprovider:notices_help'] = '관리자가 주목해야 할  유의사항이 있습니다.';
$string['messageselect'] = '이 사용자를 메일 수신자로 선택';
$string['messageselectadd'] = '메세지 보내기';
$string['middlename'] = '모듈 이름';
$string['migratinggrades'] = '성적 이관';
$string['min'] = '분';
$string['mins'] = '분';
$string['minute'] = '분';
$string['minutes'] = '분간';
$string['miscellaneous'] = '기타';
$string['missingcategory'] = '목록을 선택하세요';
$string['missingcity'] = '빠짐: 도시';
$string['missingcountry'] = '빠짐: 국가';
$string['missingdescription'] = '빠짐: 설명';
$string['missingemail'] = '빠짐: 이메일 주소';
$string['missingfirstname'] = '빠짐: 성';
$string['missingfromdisk'] = '디스크에 없음';
$string['missingfullname'] = '빠짐: 성명';
$string['missinglastname'] = '빠짐: 이름';
$string['missingname'] = '빠짐: 이름';
$string['missingnewpassword'] = '빠짐: 새로운 비밀번호';
$string['missingpassword'] = '빠짐: 비밀번호';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA 응답 누락';
$string['missingreqreason'] = '빠짐: 이유';
$string['missingshortname'] = '빠짐: 단축명';
$string['missingshortsitename'] = '빠짐: 단축 사이트명';
$string['missingsitedescription'] = '빠짐: 사이트 설명';
$string['missingsitename'] = '빠짐: 사이트 이름';
$string['missingstrings'] = '번역안된 문자열 확인';
$string['missingstudent'] = '누군가를 선택해야 함';
$string['missingsummary'] = '빠짐: 요약';
$string['missingteacher'] = '누군가를 선택해야 함';
$string['missingurl'] = '빠짐: 웹주소(URL)';
$string['missingusername'] = '빠짐: 사용자 아이디';
$string['modchooserdisable'] = '활동 선택 끔';
$string['modchooserenable'] = '활동 선택 켬';
$string['moddoesnotsupporttype'] = '{$a->modname} 모듈은 {a->type} 유형의 업로드를 지원하지 않음';
$string['modified'] = '수정됨';
$string['moduleintro'] = '모듈 소개';
$string['modulesetup'] = '설정하기 : 모듈 테이블';
$string['modulesuccess'] = '{$a} 테이블이 바르게 설정되었습니다.';
$string['modulesused'] = '사용된 모듈';
$string['month'] = '개월';
$string['months'] = '개월';
$string['moodledocs'] = '문서 창고';
$string['moodledocslink'] = '이 페이지를 위한 무들 문서';
$string['moodlerelease'] = '무들 판 공개';
$string['moodleversion'] = '무들 버전';
$string['more'] = '좀 더';
$string['morehelp'] = '도움글 더';
$string['moreinformation'] = '이 오류에 대한 추가 정보';
$string['moreprofileinfoneeded'] = '추가 신상 명세';
$string['mostrecently'] = '가장 최근';
$string['move'] = '옮기기';
$string['movecategoriessuccess'] = '{$a->count}개의 범주를 \'{$a->to}\' 범주로 성공적으로 옮김';
$string['movecategoriestotopsuccess'] = '{$a->count}개의 범주를 최상위 수준으로 성공적으로 옮김';
$string['movecategorycontentto'] = '옮겨감';
$string['movecategorysuccess'] = '\'{$a->moved}\' 범주를 \'{$a->to}\' 범주로 성공적으로 옮김';
$string['movecategoryto'] = '범주를 다음으로 옮김 :';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' 범주를 최상위 수준으로 성공적으로 옮김';
$string['movecontent'] = '{$a} 이동';
$string['movecontentstoanothercategory'] = '다른 범주로 내용 옮기기';
$string['movecoursemodule'] = '자원 이동';
$string['movecoursesection'] = '섹션 이동';
$string['movecourseto'] = '강좌를 다음으로 옮김 :';
$string['movedown'] = '아래로 옮김';
$string['movefilestohere'] = '파일을 여기로 옮김';
$string['movefull'] = '{$a} 를 여기로 옮김';
$string['movehere'] = '여기로 옮김';
$string['moveleft'] = '왼쪽으로 옮김';
$string['moveright'] = '오른쪽으로 옮김';
$string['movesection'] = '섹션 {$a} 이동';
$string['moveselectedcategoriesto'] = '선택한 범주를 다음으로 옮기기';
$string['moveselectedcoursesto'] = '선택된 강좌를 옮김';
$string['movetoanotherfolder'] = '다른 폴더로 옮기기';
$string['moveup'] = '위로 옮김';
$string['msnid'] = 'MSN 아이디';
$string['mustchangepassword'] = '새 비밀번호는 쓰던 것과는 달라야 합니다.';
$string['mustconfirm'] = '로그인 계정을 확인하세요.';
$string['mycourses'] = '내 강좌';
$string['myfiles'] = '개인 파일';
$string['myfilesmanage'] = '개인 파일 관리';
$string['myhome'] = '내 누리집';
$string['mymoodledashboard'] = '내 공부방 상황판';
$string['myprofile'] = '내 개인정보';
$string['name'] = '이름';
$string['nameforlink'] = '이 연결고리 이름은?';
$string['nameforpage'] = '이름';
$string['navigation'] = '찾아가기';
$string['needed'] = '필요함';
$string['never'] = '접속안함';
$string['neverdeletelogs'] = '로그를 삭제하지 않기';
$string['new'] = '새로운';
$string['newaccount'] = '새 계정';
$string['newcourse'] = '새 강좌';
$string['newpassword'] = '새 비밀번호';
$string['newpasswordfromlost'] = '<strong>주의:</strong> 잃어버린 암호 복구 과정으로 보내어지는 두 통의 이메일 중 <strong>두번째 </strong>이메일에 <<strong>현재 비밀번호</strong>가 전송될 것입니다. 진행하기 전에 교체된 비밀번호가 도착했는 지 확인하기 바랍니다.';
$string['newpassword_help'] = '현재 비밀번호를 그대로 유지하려면 빈 칸으로 둠';
$string['newpasswordtext'] = '{$a->firstname} 님 안녕하세요?

\'{$a->sitename}\'에서의 계정이 변경되었습니다.
   사용자아이디: {$a->username}
   임시비밀번호: {$a->newpassword}

다음의 주소로 접속하여 비밀번호를 변경하시기 바랍니다.
   {$a->link}

대개의 메일프로그램은 바로 링크할 수 있도록 되어 있지만 만일 바로 링크할 수 없으면 위의 주소를 복사하여 주소창에 붙여 놓고 진행할 수 있습니다.

\'{$a->sitename}\' 의 관리자가 환영인사 드립니다.
{$a->signoff}';
$string['newpicture'] = '새 사진';
$string['newpicture_help'] = '새 사진을 추가하기 위해서는 (JPG나 PNG 포맷)으로 되어 있는 이미지를 선택하고, "개인정보 새로고침"을 클릭하십시요. 이미지는 정사각형으로 잘려져서 100x100픽셀로 크기가 조절될 것입니다.';
$string['newsitem'] = '새 항목';
$string['newsitems'] = '새 소식';
$string['newsitemsnumber'] = '볼 새소식';
$string['newsitemsnumber_help'] = '이 설정은 강좌 페이지의 최근 뉴스 블록에 얼마나 많은 최근 게시물이 표시되어야 하는지를 결정합니다. 만일 여기에 "0 뉴스 항목" 으로 설정하게 되면, 최신 뉴스 블록이 표시되지 않습니다.';
$string['newuser'] = '새로운 사용자';
$string['newusernewpasswordsubj'] = '새 사용자 계정';
$string['newusernewpasswordtext'] = '\'{$a->sitename}\'에 새 계정이 생성되었고 임시암호가 발급되었습니다.

당신의 로그인 정보는 다음과 같습니다:
사용자 ID: {$a->username}
암호: {$a->newpassword}
(처음 로그인 할때 암호를 바꾸어야 합니다)

\'{$a->sitename}\'를 사용하기 위해서는 {$a->link}
에서 로그인 하십시요.

대부분의 메일 프로그램에서는 클릭할 수 있는 파란색 링크로 표시됩니다. 만일 그렇지 않은 경우에는 주소를 웹브라우저 윈도우의 주소창에 복사하여 사용하십시요.

\'{$a->sitename}\' 의 관리자가 환영인사 드립니다.
{$a->signoff}';
$string['newusers'] = '새로운 사용자';
$string['newwindow'] = '새 창';
$string['next'] = '다음';
$string['nextsection'] = '다음 분야';
$string['no'] = '아니오';
$string['noblockstoaddhere'] = '이 페이지에 추가할 수 있는 블록이 없음';
$string['nobody'] = '아무도 없음';
$string['nochange'] = '변경사항 없음';
$string['nocomments'] = '덧글 없음';
$string['nocourses'] = '강좌 없음';
$string['nocoursesfound'] = '\'{$a}\' 로 검색된 결과가 없습니다.';
$string['nocoursesyet'] = '검색된 결과가 없습니다.';
$string['nodstpresets'] = '관리자가 일광절약제 설정을 할 수 없습니다.';
$string['nofilesselected'] = '복구하기 위한 파일이 선택되지 않았습니다.';
$string['nofilesyet'] = '아직 업로드할 파일이 없습니다.';
$string['nograde'] = '성적 없음';
$string['nohelpforactivityorresource'] = '현재 이 자료 혹은 활동과 관련된 도움말이 없습니다.';
$string['noimagesyet'] = '등록된 이미지 없음';
$string['nologsfound'] = '기록이 발견되지 않았습니다.';
$string['nomatchingusers'] = '\'{$a}\' 와 일치하는 사용자 없음';
$string['nomorecourses'] = '검색된 결과가 없습니다.';
$string['nomoreidnumber'] = '충돌을 피하기 위해 id 번호를 사용하지 마십시오.';
$string['none'] = '없음';
$string['noneditingteacher'] = '편집권한이 없는 선생님';
$string['noneditingteacherdescription'] = '편집권한을 가지지 못한 선생님은 강좌에서 평가를 하거나 가르칠 수는 있지만 활동을 고치지는 못합니다.';
$string['nonstandard'] = '비 표준';
$string['nopendingcourses'] = '승인 대기중인 강좌가 없습니다.';
$string['nopotentialadmins'] = '잠재적 관리자 없음';
$string['nopotentialcreators'] = '잠재적 강좌 생성자 없음';
$string['nopotentialstudents'] = '잠재적 학생 없음';
$string['nopotentialteachers'] = '잠재적 선생님 없음';
$string['norecentactivity'] = '최근 활동 없음';
$string['noreplybouncemessage'] = '실제 존재하지 않는 이메일 주소로 답장을 보냈습니다. 포럼에 내용을 게시하고 싶었다면 답장 대신 {$a} 포럼에 직접 게시 하십시오. 다음은 당신이 쓴 이메일의 원문입니다.';
$string['noreplybouncesubject'] = '{$a}  - 되돌아온 이메일';
$string['noreplyname'] = '이 이메일로 답장을 보내지 마십시오.';
$string['noresetrecord'] = '해당 재설정 요청에 대한 기록이 없습니다. 암호 재설정 요청을 새로 시작하시기 바랍니다.';
$string['noresults'] = '결과 없음';
$string['normal'] = '일반';
$string['normalfilter'] = '일반 검색';
$string['nosite'] = '사이트 내에서는 강좌를 찾을 수 없음';
$string['nostudentsfound'] = '{$a} 발견되지 않음';
$string['nostudentsingroup'] = '이 모둠에는 아직 학생들이 없습니다.';
$string['nostudentsyet'] = '아직 이 강좌에 등록한 학생이 없습니다.';
$string['nosuchemail'] = '그런 이메일 주소 없음';
$string['notavailable'] = '사용 가능하지 않음';
$string['noteachersyet'] = '이 강좌에는 아직 선생님이 없음';
$string['notenrolled'] = '{$a} 는 이 강좌에 등록되지 않았음';
$string['notenrolledprofile'] = '이 사용자는 강좌의 구성원이 아니므로 개인정보를 볼 수 없습니다.';
$string['noteusercannotrolldatesoncontext'] = '<strong>주의</strong> 요구되는 권한에 미치지 못하므로, 백업을 복구하는 동안 날짜 조정에 실패하였습니다.';
$string['noteuserschangednonetocourse'] = '<strong>주의</strong> 사용자 자료(활동, 파일, 메시지 등)를 복구할 때는 강좌의 사용자가  복구되어야 합니다. 이 설정이 변경되었습니다.';
$string['nothingnew'] = '새로 바뀐 내용이 없음';
$string['nothingtodisplay'] = '게시할 내용 없음';
$string['notice'] = '알림';
$string['noticenewerbackup'] = '이 백업파일은 무들 {$a->backuprelease} ({$a->backupversion} )판에 의해 만들어진 것이고 현재 구동되고 있는 무들 {$a->serverrelease} ({$a->serverversion} )보다 새 것입니다. 이 경우 약간의 불일치를 촉발할 수 있으며, 구판으로 복구할 때 작동을 보증할 수 없습니다.';
$string['notifications'] = '시스템공지';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, 사용자: {$a->info}';
$string['notifyloginfailuresmessageend'] = '이들의 로그를 {$a}/course/log.php?id=1&chooselog=1&modid=site_errors 에서 볼 수 있음';
$string['notifyloginfailuresmessagestart'] = '마지막 통보 이후, {$a} 에 로그인하다 실패한 목록';
$string['notifyloginfailuressubject'] = '{$a} :: 실패한 로그인 공지사항들';
$string['notincluded'] = '포함되지 않음';
$string['notingroup'] = '죄송합니다만, 이곳을 보려면 모둠의 구성원이 되어야 합니다.';
$string['notpublic'] = '공개되지 않았음!';
$string['nousersfound'] = '사용자 없음';
$string['nousersmatching'] = '\'{$a}\'와 일치하는 사용자가 없음';
$string['nousersyet'] = '사용자 아직 없음';
$string['novalidcourses'] = '볼 수 있는 강좌가 없음';
$string['now'] = '지금';
$string['numattempts'] = '{$a} 실패한 로그인 시도(들)';
$string['numberofcourses'] = '강좌의 수';
$string['numberweeks'] = '주/토픽의 수';
$string['numdays'] = '{$a} 일';
$string['numhours'] = '{$a} 시';
$string['numletters'] = '{$a} 개의 편지';
$string['numminutes'] = '{$a} 분';
$string['nummonths'] = '{$a} 달';
$string['numseconds'] = '{$a} 초';
$string['numviews'] = '{$a} 봄';
$string['numweeks'] = '{$a} 주';
$string['numwords'] = '{$a} 단어';
$string['numyears'] = '{$a} 년';
$string['ok'] = 'OK';
$string['oldpassword'] = '현재 암호';
$string['olduserdirectory'] = '오래된 사용자 디렉토리이며 더 이상 필요하지 않습니다. 안전하게 삭제할 수 있습니다. 포함되어 있던 파일들은 새 사용자 디렉토리로 복사되었습니다.';
$string['opentoguests'] = '손님 접근';
$string['optional'] = '선택';
$string['options'] = '옵션';
$string['order'] = '정렬';
$string['originalpath'] = '원래 경로';
$string['orphanedactivitiesinsectionno'] = '분리된 활동 ({$a} 섹션)';
$string['other'] = '기타';
$string['outline'] = '요약';
$string['outlinereport'] = '요약 보고';
$string['page'] = '페이지';
$string['pagea'] = '페이지 {$a}';
$string['pageheaderconfigablock'] = '블록을 %fullname% 으로 배열중';
$string['pagepath'] = '페이지 경로';
$string['pageshouldredirect'] = '본 페이지는 자동적으로 재조정됨. 아무 변화가 없으면 하단의 계속 링크를 이용하시기 바랍니다.';
$string['parentcategory'] = '상위 범주';
$string['parentcoursenotfound'] = '상위 과정이 개설되지 않았습니다.';
$string['parentfolder'] = '상위 폴더';
$string['participants'] = '참여자';
$string['participantslist'] = '참여자 목록';
$string['participationratio'] = '참여자 비율';
$string['participationreport'] = '참여 보고서';
$string['password'] = '비밀번호';
$string['passwordchanged'] = '비밀번호가 변경되었습니다.';
$string['passwordconfirmchange'] = '비밀번호 변경 확인';
$string['passwordextlink'] = '다음의 이 링크는 당신의 잊어버린 비밀번호를 알려줄 것입니다. 이것은 당신을 무들 밖으로 안내할것입니다.';
$string['passwordforgotten'] = '비밀번호 잊어버림';
$string['passwordforgotteninstructions'] = '우선 반드시 당신의 개인정보를 사용자 데이터 베이스에서 찾을 수 있어야 합니다. 무들 사용자 ID나 등록된 이메일 주소를 기입란에 입력해주기 바랍니다. 두개 다 입력할 필요는 없습니다.';
$string['passwordforgotteninstructions2'] = '비밀번호를 재설정하기 위해서는 아래에 사용자 아이디나 이메일 주소를 입력하세요. 데이터베이스에서 확인이 되면 추후 과정을 안내할 이메일을 확인된 이메일 주소로 발송할 것입니다.';
$string['passwordnohelp'] = '잊어버린 비밀번호를 찾는데 이용가능한 도움문서가 없습니다. 무들 관리자에게 연락하시기 바랍니다.';
$string['passwordrecovery'] = '예, 로그인을 도와주세요.';
$string['passwordsdiffer'] = '비밀번호가 일치하지 않습니다.';
$string['passwordsent'] = '비밀번호가 보내졌습니다.';
$string['passwordsenttext'] = '<p>이메일이 {$a->email} 로 보내졌습니다.</p>
   <p><b>새 비밀번호를 위한 이메일을 확인해 주세요.</b></p>
   <p>새 비밀번호는 자동으로 생성되었습니다. 기억하기 쉬운 번호로 <a href="{$a->link}">비밀번호를 변경하려면 여기를 클릭하세요.</a></p>';
$string['passwordset'] = '암호가 재설정 되었습니다.';
$string['path'] = '경로';
$string['pathnotexists'] = '경로가 서버에 존재하지 않음!';
$string['pathslasherror'] = '경로는 슬래쉬로 끝날 수 없음!!';
$string['paymentinstant'] = '신속하게 등록금 지불 및 등록을 마치려면 아래의 버튼을 사용하시오!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> 미결제</small>)';
$string['paymentrequired'] = '이 강좌는 수강하기 위해 등록금이 필요합니다.';
$string['payments'] = '지불';
$string['paymentsorry'] = '납입해 주셔서 감사합니다! 하지만 안타깝게도 아직 수납과정이 완료되지 않았으며 강좌에 "{$a->fullname}" 로 완전히 등록되지 않았습니다. 몇 초 후에 계속 강좌 진입을 시도해 보시길 바랍니다. 만일 지속적으로 문제가 있다면 사이트 관리자나 {$a->teacher} 에게 연락하시기 바랍니다.';
$string['paymentthanks'] = '납입해 주셔서 감사합니다!<br />강좌 {$a} 에 정상적으로 등록되었습니다.';
$string['pendingrequests'] = '승인대기 강좌';
$string['periodending'] = '기간 종료 ({$a})';
$string['perpage'] = '페이지당';
$string['perpagea'] = '페이지당 : {$a}';
$string['personal'] = '개인적인';
$string['personalprofile'] = '개인정보';
$string['phone'] = '전화';
$string['phone2'] = '휴대 전화';
$string['phpinfo'] = 'PHP 정보';
$string['pictureof'] = '{$a} 사진';
$string['pictureofuser'] = '사용자 사진';
$string['pleaseclose'] = '이제 이 창을 닫기 바랍니다.';
$string['pleasesearchmore'] = '좀 더 검색하기 바랍니다';
$string['pleaseusesearch'] = '검색 기능을 사용하세요';
$string['plugin'] = '플러그인';
$string['plugincheck'] = '플러그인 점검';
$string['plugindeletefiles'] = '\'{$a->name}\' 플러그인과 관련된 모든 자료들은 데이터베이스에서 삭제되었습니다. 플러그인이 재설치되는 것을 막기 위해서는 서버의  {$a->directory} 경로를 수동으로 삭제해야만 합니다.';
$string['pluginsetup'] = '플러그인 테이블 설정';
$string['policyaccept'] = '약관을 이해하였으며 이에 동의합니다.';
$string['policyagree'] = '이 사이트를 계속 이용하시려면 약관에 동의하셔야 합니다. 동의하십니까?';
$string['policyagreement'] = '사이트 정책 동의';
$string['policyagreementclick'] = '사이트 정책 동의로의 링크';
$string['popup'] = '팝업';
$string['popupwindow'] = '새창으로 열기';
$string['popupwindowname'] = '팝업 창';
$string['post'] = '게시';
$string['posts'] = '게시물';
$string['potentialadmins'] = '잠재적 관리자';
$string['potentialcreators'] = '잠재적 강좌 생성자';
$string['potentialstudents'] = '잠재적 학생';
$string['potentialteachers'] = '잠재적 선생님';
$string['preferences'] = '사용자 선택사항';
$string['preferredlanguage'] = '선호하는 언어';
$string['preferredtheme'] = '선호하는 테마';
$string['preprocessingbackupfile'] = '백업파일 전처리';
$string['prev'] = '이전';
$string['preview'] = '미리보기';
$string['previewhtml'] = 'HTML 형식 미리보기';
$string['previeworchoose'] = '테마 선택/미리보기';
$string['previous'] = '이전으로';
$string['previouslyselectedusers'] = '\'{$a}\' 와 일치하지 않는 기선택 사용자';
$string['previoussection'] = '이전 섹션';
$string['primaryadminsetup'] = '관리자 계정 설정';
$string['profile'] = '개인정보';
$string['profilenotshown'] = '이 개인정보 사항은 적어도 이 사람이 어느 한 강좌에 등록할 때까지 제시되지 않을 것입니다.';
$string['publicprofile'] = '개인정보 공개';
$string['publicsitefileswarning'] = '경고: 이곳의 파일은 누구나 접근할 수 있습니다.';
$string['publicsitefileswarning2'] = '주: 여기에 있는 파일들은 주소를 알고 있는 어느 누구라도 접속할 수 있음. 보안상, 복구 후에는 여타 백업 파일들은 즉각 삭제할 것을 추천.';
$string['publicsitefileswarning3'] = '주: 여기에 있는 파일들은 주소를 알고 있는 어느 누구라도 접속할 수 있음. <br />보안상, 백업 파일들은 안전한 백업경로에만 저장되어야 할 것임.';
$string['publish'] = '공개';
$string['question'] = '질문';
$string['questionsinthequestionbank'] = '질문은행의 질문들';
$string['readinginfofrombackup'] = '백업된 정보 읽기';
$string['readme'] = 'README';
$string['recentactivity'] = '최근 활동';
$string['recentactivityreport'] = '최근활동 상세보고';
$string['recipientslist'] = '수신자 목록';
$string['recreatedcategory'] = '재생성된 범주 {$a}';
$string['redirect'] = '리다이랙트';
$string['reducesections'] = '영역수 줄임';
$string['refresh'] = '새로고침';
$string['refreshingevents'] = '일정 새로고침';
$string['registration'] = '무들 등록하기';
$string['registrationcontact'] = '공개적으로 연결';
$string['registrationcontactno'] = '아니오, 나는 사이트 목록에 등재되길 원하지 않습니다';
$string['registrationcontactyes'] = '예, 예지 무들 사용자가 나에게 연락할 양식을 제공해 주십시요.';
$string['registrationemail'] = '이메일 통지';
$string['registrationinfo'] = '<p> 이 페이지는 무들 사이트를  moodle.org에 등록하도록 해 줍니다. 등록은 무료입니다. 등록의 잇점은 혹시 있을지도 모르는 보안문제나 무들의 새판 공지 등의 주요 사항을 바로 받아 볼 수 있다는 것입니다.</p>
<p>기본적으로 개인정보는 보장됩니다. 이 자료를 요구하는 것은 순전히 여러분을 지원하기 위한 것이며, 무들 커뮤니티의 전체적 통계를 살펴보기 위한 것입니다.</p>
<p>만약 선택한다면, 사이트 이름, 국가, 웹주소가 무들 사이트에 등록될 것입니다.</p>
<p> 모든 등록은 수동으로 이루어집니다.
일단 등록하면 등록된 내용은 쉽게 수정할 수 있습니다.</p>';
$string['registrationinfotitle'] = '등록 정보';
$string['registrationno'] = '아니오, 이메일을 받지 않겠습니다.';
$string['registrationsend'] = 'moodle.org에 등록 정보 보내기';
$string['registrationyes'] = '예, 중요한 사항을 나에게 알려주세요.';
$string['reject'] = '거절';
$string['rejectdots'] = '기각...';
$string['reload'] = '다시 로딩';
$string['remoteappuser'] = '원격 {$a} 사용자';
$string['remove'] = '삭제';
$string['removeadmin'] = '관리자 삭제';
$string['removecreator'] = '강좌 생성자 삭제';
$string['removestudent'] = '학생계정 삭제';
$string['removeteacher'] = '선생님 삭제';
$string['rename'] = '새이름으로';
$string['renamefileto'] = '<b>{$a}</b>를 새이름으로 고침';
$string['report'] = '보고서';
$string['reports'] = '보고서';
$string['repositories'] = '저장소';
$string['requestcourse'] = '개설 요청';
$string['requestedby'] = '요청자:';
$string['requestedcourses'] = '요청된 강좌';
$string['requestreason'] = '개설 요청 이유';
$string['required'] = '필수사항';
$string['requirespayment'] = '이 강좌는 수강하기위해 등록금이 필요함';
$string['reset'] = '초기화';
$string['resetcomponent'] = '구성요소';
$string['resetcourse'] = '강좌 초기화';
$string['resetinfo'] = '이 페이지에서는 강좌의 활동과 다른 설정은 그대로 둔 채, 사용자 데이터를 삭제할 수 있도록 해 줍니다. 아래 항목을 선택하고 이페이지를 제출하면, 당신의 데이터가 선택한 강좌에서 영구히 삭제됨을 유의하시기 바랍니다!';
$string['resetnotimplemented'] = '초기화가 구현되지 않았음';
$string['resetrecordexpired'] = '사용한 암호 재설정 링크가 {$a}분이 지나 만료되었습니다. 암호 재설정을 새로 시작하십시오.';
$string['resetstartdate'] = '시작날짜 초기화';
$string['resetstatus'] = '상태';
$string['resettask'] = '할일';
$string['resettodefaults'] = '기본값으로 초기화';
$string['resortbyfullname'] = '강좌 전체이름으로';
$string['resortbyidnumber'] = '강좌 id번호로';
$string['resortbyshortname'] = '강좌 짧은 이름으로';
$string['resortcourses'] = '강좌 정렬';
$string['resortsubcategoriesbyidnumber'] = 'id 번호로 하위범주 정렬';
$string['resortsubcategoriesbyname'] = '이름으로 하위범주 정렬';
$string['resource'] = '자료';
$string['resourcedisplayauto'] = '자동';
$string['resourcedisplaydownload'] = '자동 내려받기';
$string['resourcedisplayembed'] = '임베디드';
$string['resourcedisplayframe'] = '프레임에서';
$string['resourcedisplaynew'] = '새 창';
$string['resourcedisplayopen'] = '열기';
$string['resourcedisplaypopup'] = '팝업창으로';
$string['resources'] = '참고자료';
$string['resources_help'] = '학습자원 유형은  거의 모든 종류의 웹 콘텐츠가 강좌에 삽입되는 것을 가능하게 합니다.';
$string['restore'] = '복구';
$string['restorecancelled'] = '복구 취소됨';
$string['restorecannotassignroles'] = '복구하려면 특정 권한이 필요한데, 아직 그럴 권한이 부여되어 있지 않음';
$string['restorecannotcreateorassignroles'] = '복구하려면 생성 혹은 부여할 수 있는 권한이 필요한데, 아직 그런 권한이 부여되어 있지 않음';
$string['restorecannotcreateuser'] = '복구하려면 백업파일에서 사용자 \'{$a}\'를 생성할 수 있는 권한이 필요한데, 아직 그럴 권한이 부여되어 있지 않음';
$string['restorecannotoverrideperms'] = '복구하려면 권한을 덮어쓰기 권한이 필요한데 아직 그럴 권한이 부여되어 있지 않음';
$string['restorecoursenow'] = '강좌를 지금 복구하기!';
$string['restoredaccount'] = '복구된 계정';
$string['restoredaccountinfo'] = '이 계정은 타 서버에서 가져온 것이고 비밀번호는 없습니다. 이메일을 통해 비밀번호를 설정하려면 "계속" 을 누르시기 바랍니다.';
$string['restorefinished'] = '성공적으로 복구완료';
$string['restoreto'] = '복구하기';
$string['restoretositeadding'] = '경고: 사이트 시작 페이지에 자료를 추가하고, 사이트 시작 페이지로 복구하려고 하고 있습니다!';
$string['restoretositedeleting'] = '경고: 사이트 시작 페이지의 자료를 삭제하고, 사이트 시작 페이지로 복구하려고 하고 있습니다!';
$string['restoreuserconflict'] = '백업 파일에서 사용자 \'{$a}\' 를 복구하려는 시도는 문제를 일으킬 것임';
$string['restoreuserinfofailed'] = '사용자 데이터 복구 권한이 없어 복구 과정이 정지됨';
$string['restoreusersprecheck'] = '사용자 데이터 점검';
$string['restoreusersprecheckerror'] = '사용자 데이터를 점검하는 중, 문제점을 발견';
$string['restricted'] = '제한됨';
$string['returningtosite'] = '이 웹사이트로 들어 갈까요?';
$string['returntooriginaluser'] = '{$a} 로 복귀';
$string['revert'] = '복구';
$string['role'] = '역할';
$string['roleassignments'] = '역할 부여';
$string['rolemappings'] = '역할 배치';
$string['rolerenaming'] = '역할명 고침';
$string['rolerenaming_help'] = '이 옵션은 자신의 강좌에서 사용되는 역할 명을 바꿀 수 있게 합니다. 이것은 표시되는 명칭만 바꾸는 것이며 실제 그 역할이 지니는 권한은 변하지 않습니다.
여기에 적힌 새로운 역할명은 강좌 참여자 페이지뿐만 아니라 기타 강좌의 이곳 저곳에 쓰이게 됩니다. 예를 들어 관리자가 어떤 강좌의 운영자로 선택이 될 경우, 관리자는 그 강좌의 일원으로서 새로운 역할명으로 강좌목록에 표시될 수 있습니다.
';
$string['roles'] = '역할';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS로 배포할 최근 문서의 수';
$string['rsserror'] = 'RSS 데이터 읽기 에러';
$string['rsserrorauth'] = 'RSS 링크가 유효한 인증 토큰을 가지고 있지 않음';
$string['rsserrorguest'] = '이 피드는 데이터에 접근하는데 손님 접근을 이용하는데 손님은 그 데이터를 읽을 권한이 없습니다. 이 피드를 보내오는 원래의 장소(URL)를 유효한 사용자로 접속하여 새로운 RSS 링크를 받으십시요.';
$string['rsskeyshelp'] = '보안 및 사생활보호를 위해 RSS피드 URL에는 새용자 개개인만의 고유한 토큰을 포함됩니다. 이는 다른 사용자들이 RSS피드를 통하여 함부로 침범하면 안되는 영역에 접근하는 것을 막습니다.</p><p>이 토큰은 여러분이 처음 무들의 RSS피드를 이용하는 구역에 접속할 때 자동으로 생성됩니다. 만일 어떤 연유에서건 RSS피드 URL이 누출되었다고 생각되면 "초기화" 링크를 눌러 새 토큰을 받을 수 있습니다. 이 때 전에 받은 토큰은 실효됨을 명심하십시오.';
$string['rsstype'] = '이 활동을 RSS로 내보냄';
$string['saveandnext'] = '저장 후 다음 보기';
$string['savechanges'] = '변경사항 저장';
$string['savechangesanddisplay'] = '변경사항 저장 및 표시';
$string['savechangesandreturntocourse'] = '저장 후 강좌로 복귀';
$string['savecomment'] = '덧글 저장';
$string['savedat'] = '다음에 저장됐음 :';
$string['savepreferences'] = '개인설정 저장';
$string['saveto'] = '저장 경로';
$string['scale'] = '척도';
$string['scale_help'] = '척도는 활동에서 능력을 평가하는 수단을 제공합니다. 척도는 부정적인것에서 긍정적인 범위의 순서있는 값들을 콤마로 분리한 목록으로 정의됩니다. 예:"매우 실망스러운, 썩 좋지 않은, 보통, 좋은, 매우 좋은, 뛰어난"';
$string['scales'] = '척도';
$string['scalescustom'] = '맞춤 척도';
$string['scalescustomcreate'] = '새로운 척도 추가';
$string['scalescustomno'] = '맞춤 척도가 만들어지지 않았습니다.';
$string['scalesstandard'] = '표준 척도';
$string['scalestandard'] = '표준 척도';
$string['scalestandard_help'] = '<p>표준 척도는 사이트 전역에 걸쳐 어떤 강좌에서도 활용 가능한 척도이다.</p>';
$string['scalestip'] = '맞춤 척도를 만들려면 강좌 관리자 메뉴에 있는 \'척도\'링크를 사용하세요.';
$string['scalestip2'] = '맞춤 척도를 만들려면 강좌 관리자 메뉴에 있는 성적 링크를 클릭한 후, 척도 편집기능을 이용하십시요.';
$string['schedule'] = '일정';
$string['screenshot'] = '스크린샷';
$string['search'] = '검색';
$string['searchagain'] = '다시 찾기';
$string['searchbyemail'] = '이메일주소로 찾기';
$string['searchbyusername'] = '사용자 아이디로 찾기';
$string['searchcourses'] = '강좌 찾기';
$string['searchhelp'] = '여러 개의 단어로 검색할 수 있습니다.<br />
word : 텍스트안에 이 단어와 관련된 어떤 것이라도 검색<br />
+word : 정확히 일치하는 것만 검색<br />
-word : 이 단어를 포함하지 않는 것만 보여주기';
$string['search_help'] = '문서의 어느 곳에서든지 하나 이상의 단어를 검색하고자 할 때에는 이들 단어를 쉼표로 분리해서 입력하면 된다. 모든 단어는 한 음절 이상이면 된다.
좀 더 자세하게 검색하고자 할 때에는 검색란에 아무 것도 쓰지 않은 채, 상세검색을 누르면 자세한 검색 양식이 나타난다.';
$string['searchoptions'] = '검색 조건';
$string['searchresults'] = '검색 결과';
$string['sec'] = '초';
$string['seconds'] = '초';
$string['secondstotime172800'] = '2 일';
$string['secondstotime259200'] = '3 일';
$string['secondstotime345600'] = '4 일';
$string['secondstotime432000'] = '5 일';
$string['secondstotime518400'] = '6 일';
$string['secondstotime604800'] = '1 주일';
$string['secondstotime86400'] = '하루';
$string['secretalreadyused'] = '이미 비밀번호 변경 확인이 되었고, 그 후 비밀번호는 변경되지 않았습니다.';
$string['secs'] = '초';
$string['section'] = '영역';
$string['sectionname'] = '영역명';
$string['sections'] = '영역';
$string['sectionusedefaultname'] = '기본 영역명 사용';
$string['seealsostats'] = '통계 보기';
$string['selctauser'] = '이용자 선택';
$string['select'] = '선택';
$string['selectacategory'] = '범주를 선택하세요.';
$string['selectacountry'] = '국가 선택';
$string['selectacourse'] = '강좌 선택';
$string['selectacoursesite'] = '강좌 혹은 사이트 선택';
$string['selectagroup'] = '모둠 선택';
$string['selectall'] = '모두 선택';
$string['selectamodule'] = '활동 모듈을 선택하십시요.';
$string['selectanaction'] = '활동 선택';
$string['selectanoptions'] = '옵션 선택';
$string['selectaregion'] = '지역 선택';
$string['selectcategorysort'] = '정렬하려는 범주가 어떤 것입니까?';
$string['selectcategorysortby'] = '범주 정렬 방식 선택';
$string['selectcoursesortby'] = '강좌 정렬 방식 선택';
$string['selectdefault'] = '기본 선택';
$string['selectedcategories'] = '선택된 범주들';
$string['selectedfile'] = '선택된 파일';
$string['selectednowmove'] = '이동할 파일 {$a}이 선택되었습니다. 목적 폴더에 가서 \'이곳으로 파일 옮기기\'를 클릭하세요';
$string['selectfiles'] = '파일 선택';
$string['selectmoduletoviewhelp'] = '도움말 보기위한 모듈 선택';
$string['selectnos'] = '모두 \'아니오\'를 선택하십시요';
$string['selectperiod'] = '기간 선택';
$string['senddetails'] = '이메일로 나의 상세정보 보내기';
$string['separate'] = '분리';
$string['separateandconnected'] = '학습자의 분리와 연대 유형';
$string['separateandconnectedinfo'] = '척도는 독립된 배움과 연결된 배움 이론에 기반하고 있습니다. 이 이론은 우리가 보고 듣는 것들에 대해 우리들이 평가하고 학습하는 두 가지 다른 방법을 설명합니다.
<ul><li><strong>독립된 학습자</strong>는 느낌이나 감정없이 가능한 객관적이려고 합니다. 다른 사람과의 대화에서 그들은 자신의 생각을 방어하며 논리를 사용하여 상대방의 생각에서 허점을 찾아냅니다. </li></ul>
<ul><li><strong>연결된 학습자</strong> 는 다른 사람에 더 민감합니다. 그들은 감정이입하는데 능력이 있고, 듣는 편이며, 그들이 연결되어 있으며 \'그들의 관점에서 이해\'한다고 느낄 때까지 질문합니다. 그들은 다른 사람들에게서 그들이 발견한 지식에 이르는 경험을 공유하려고 함에 의해서 배웁니다.</li></ul>';
$string['servererror'] = '서버와 교신 중 오류 발생';
$string['serverlocaltime'] = '서버의 지역시간';
$string['setcategorytheme'] = '범주 테마 설정';
$string['setpassword'] = '암호 설정';
$string['setpasswordinstructions'] = '아래에 있는 암호 및 암호 확인을 입력하고 "암호 설정"을 클릭하십시오. <br />새 암호가 저장된 후에 로그인 상태로 됩니다.';
$string['settings'] = '설정';
$string['shortname'] = '짧은 이름';
$string['shortnamecollisionwarning'] = '[*]=이 짧은 이름은 이미 다른 교육과정에 사용되고 있습니다. 승인이 될 수 있는 다른 이름으로 바꿔주십시오';
$string['shortnamecourse'] = '강좌 단축명';
$string['shortnamecourse_help'] = '강좌의 간단한 이름이 찾아가기에 표시되며 강좌의 이메일 메세지의 제목줄에 사용됩니다.';
$string['shortnametaken'] = '짧은 이름이 다른 곳( {$a} )에서 사용되고 있습니다.';
$string['shortnameuser'] = '사용자 간단 이름';
$string['shortsitename'] = '사이트의 단축명(예:한 단어)';
$string['show'] = '보기';
$string['showactions'] = '활동 보기';
$string['showadvancedsettings'] = '상세 설정 보기';
$string['showall'] = '{$a} 전체보기';
$string['showallcourses'] = '전체보기: 강좌';
$string['showallusers'] = '전체보기: 사용자';
$string['showblockcourse'] = '블록이 있는 강좌 목록보기';
$string['showcategory'] = '{$a} 보기';
$string['showcomments'] = '덧글 보기/감추기';
$string['showcommentsnonjs'] = '덧글 보기';
$string['showdescription'] = '강좌 화면에 설명 표시';
$string['showdescription_help'] = '이를 활성화시키면, 위의 안내/소개가 활동/자료 링크 바로 하단 강좌 화면에 표시될 것입니다.';
$string['showgrades'] = '성적 표시';
$string['showgrades_help'] = '많은 활동들이 성적 설정을 허용하고 있습니다. 이 설정은 강좌 관리 블록의 성적 링크를 통하여 강좌의 모든 성적 목록을 볼 수 있을지를 결정합니다.

';
$string['showingacourses'] = '모든  {$a} 강좌 보기';
$string['showingxofycourses'] = '전체 {$a->total}개의 강좌 중 {$a->start}부터 {$a->end}까지 표시 중';
$string['showlistofcourses'] = '강좌 목록보기';
$string['showmodulecourse'] = '활동이 있는 강좌 목록보기';
$string['showonly'] = '보기만';
$string['showperpage'] = '페이지당 {$a} 개씩 보기';
$string['showrecent'] = '최근 활동 보기';
$string['showreports'] = '활동 보고서 보기';
$string['showreports_help'] = '모든 참여자들은 강좌에서 자신들의 활동에 대한 활동 보고서를 볼 수 있습니다. 활동 보고서는 포럼 게시글이나 과제 제출등의 기여 목록 뿐만아니라 접근 기록도 포함하고 있습니다. 이 설정은 학생들이 자신들의 개인 정보 페이지를 통하여 활동 보고서를 볼 수 있을지를 결정합니다.';
$string['showsettings'] = '설정 보기';
$string['showtheselogs'] = '로그 보기';
$string['showthishelpinlanguage'] = '{$a} 언어로 도움말 보기';
$string['since'] = '이래로';
$string['sincelast'] = '마지막 로그인 이후로';
$string['site'] = '사이트';
$string['sitedefault'] = '사이트 기본값';
$string['siteerrors'] = '사이트 오류';
$string['sitefiles'] = '파일 창고';
$string['sitefilesused'] = '이 강좌에서 사용된 사이트 파일';
$string['sitehome'] = '사이트 누리집';
$string['sitelegacyfiles'] = '예전 사이트 파일';
$string['sitelogs'] = '사이트 로그';
$string['sitemessage'] = '사용자들에게 메세지 보내기';
$string['sitenews'] = '사이트 뉴스';
$string['sitepages'] = '사이트';
$string['sitepartlist'] = '참여자 목록을 볼 수 있는 권한이 없습니다.';
$string['sitepartlist0'] = '사이트 참여자 목록을 보기 위해서는 사이트 선생님의 자격이 있어야만 합니다.';
$string['sitepartlist1'] = '사이트 참여자 목록을 보기 위해서는 선생님의 자격이 있어야만 합니다.';
$string['sites'] = '사이트';
$string['sitesection'] = '주제부분을 포함';
$string['sitesettings'] = '사이트 설정';
$string['siteteachers'] = '사이트 선생님';
$string['size'] = '크기';
$string['sizeb'] = '바이트';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = '생략';
$string['skiptocategorylisting'] = '범주목록으로 건너뛰기';
$string['skiptocoursedetails'] = '자세한 강좌 정보로 건너뛰기';
$string['skiptocourselisting'] = '강좌 목록으로 건너뛰기';
$string['skypeid'] = 'Skype 아이디';
$string['socialheadline'] = '사회적 포럼-최근의 글들';
$string['someallowguest'] = '어떤 강좌는 손님의 접속을 허용할 수 있습니다.';
$string['someerrorswerefound'] = '정보가 없거나 부정확합니다. 자세한 내용은 다음을 보세요.';
$string['sort'] = '정렬';
$string['sortby'] = '정렬';
$string['sortbyx'] = '{$a} 올림차순으로 정렬';
$string['sortbyxreverse'] = '{$a} 내림차순으로 정렬';
$string['sortcategoriesbyidnumber'] = 'ID 번호로 범주 정렬';
$string['sortcategoriesbyname'] = '이름으로 범주 정렬';
$string['sortcoursesbyfullname'] = '전체이름으로  강좌 정렬';
$string['sortcoursesbyidnumber'] = 'ID 번호로  강좌 정렬';
$string['sortcoursesbyshortname'] = '짧은 이름으로 강좌 정렬';
$string['sorting'] = '정렬';
$string['sourcerole'] = '원래 역할';
$string['specifyname'] = '이름은 반드시 기입해야 합니다.';
$string['standard'] = '표준';
$string['starpending'] = '([*] = 승인 대기중인 교육과정.)';
$string['startdate'] = '강좌 시작일';
$string['startdate_help'] = '주별로 제공되는 강좌의 경우, 강좌가 시작되는 요일을 여기에 적으면 됩니다. 이 설정이 영향을 주는 곳은 로그기록으로서 이 설정에 있는 날짜를 기준으로 표시가 가능합니다.';
$string['startingfrom'] = '개시일';
$string['startsignup'] = '새 계정 만들기';
$string['state'] = '시/도';
$string['statistics'] = '통계';
$string['statisticsgraph'] = '통계 그래프';
$string['stats'] = '통계';
$string['statslogins'] = '접속';
$string['statsmodedetailed'] = '자세히 보기';
$string['statsmodegeneral'] = '일반 보기';
$string['statsnodata'] = '강좌 과 기간 조합에 맞는 데이터가 없습니다';
$string['statsnodatauser'] = '강좌, 사용자 및 기간을 조합한 것에 해당하는 대한 데이터가 없습니다';
$string['statsoff'] = '통계가 활성화되어 있지 않음';
$string['statsreads'] = '열람수';
$string['statsreport1'] = '접속';
$string['statsreport10'] = '사용자 활동';
$string['statsreport11'] = '가장 활동적인 강좌';
$string['statsreport12'] = '가장 활동적인 강좌 (가중치)';
$string['statsreport13'] = '등록자수가 가장 많은 강좌';
$string['statsreport14'] = '보기 및 글쓰기가 가장 활발한 강좌';
$string['statsreport2'] = '열람수 (선생님과 학생)';
$string['statsreport3'] = '게시물 (선생님과 학생)';
$string['statsreport4'] = '모든 활동 (선생님과 학생)';
$string['statsreport5'] = '모든 학생 활동 (열람 및 게시)';
$string['statsreport7'] = '사용자 활동 (열람 및 게시)';
$string['statsreport8'] = '모든 사용자 활동';
$string['statsreport9'] = '접속수 (사이트의 교육과정)';
$string['statsreportactivity'] = '모든 활동 (선생님과 학생)';
$string['statsreportactivitybyrole'] = '모든 활동(열람 및 게시)';
$string['statsreportforuser'] = '개인당';
$string['statsreportlogins'] = '접속';
$string['statsreportreads'] = '열람수 (선생님과 학생)';
$string['statsreporttype'] = '보고서 형식';
$string['statsreportwrites'] = '게시물 (선생님과 학생)';
$string['statsstudentactivity'] = '학생 활동';
$string['statsstudentreads'] = '학생 열람수';
$string['statsstudentwrites'] = '학생 게시물';
$string['statsteacheractivity'] = '선생님 활동';
$string['statsteacherreads'] = '선생님 보기';
$string['statsteacherwrites'] = '선생님 게시물';
$string['statstimeperiod'] = '기간 - 마지막';
$string['statsuniquelogins'] = '유일한 접속들';
$string['statsuseractivity'] = '모든 활동들';
$string['statsuserlogins'] = '접속';
$string['statsuserreads'] = '조회수';
$string['statsuserwrites'] = '게시글수';
$string['statswrites'] = '게시글수';
$string['status'] = '상태';
$string['stringsnotset'] = '다음의 문자열은 {$a} 에 정의되지 않았습니다.';
$string['studentnotallowed'] = '\'{$a}\' 계정으로 이 강좌에 접속할 수 없습니다.';
$string['students'] = '학생들';
$string['studentsandteachers'] = '학생들과 선생님들';
$string['subcategories'] = '하위 범주';
$string['subcategory'] = '하위 범주';
$string['subcategoryof'] = '{$a}의 하위범주';
$string['submit'] = '제출';
$string['success'] = '성공';
$string['summary'] = '요약';
$string['summary_help'] = '요약은 학생들이  주제(혹은 주간)안의 활동을 준비할 수 있도록 하는  간단한 문장입니다. 문장은 강좌 페이지의 섹션 이름 아래에 보여집니다.

';
$string['summaryof'] = '{$a} 의 요약';
$string['supplyinfo'] = '추가 정보';
$string['suspended'] = '유보된';
$string['suspendedusers'] = '유보된 사용자';
$string['switchdevicedefault'] = '표준 테마로 전환';
$string['switchdevicerecommended'] = '자신의 환경에 맞는 테마로 전환';
$string['switchrolereturn'] = '평소의 역활로 돌아감';
$string['switchroleto'] = '다음으로 역할 바꾸기';
$string['tag'] = '태그';
$string['tagalready'] = '이 범주는 이미 존재합니다.';
$string['tagmanagement'] = '범주 추가/삭제';
$string['tags'] = '태그';
$string['targetrole'] = '변경될 역할';
$string['teacheronly'] = '오직 {$a} 를 위한';
$string['teacherroles'] = '{$a} 역할';
$string['teachers'] = '선생님';
$string['textediting'] = '내용을 수정할 때';
$string['texteditor'] = '표준 웹 양식 사용하기';
$string['textformat'] = '텍스트 포멧';
$string['thanks'] = '감사합니다.';
$string['theme'] = '테마';
$string['themes'] = '테마';
$string['themesaved'] = '새로 저장된 테마';
$string['therearecourses'] = '{$a}  강좌가 있습니다.';
$string['thereareno'] = '이 강좌에는 {$a}가 없습니다.';
$string['thiscategory'] = '이 범주';
$string['thiscategorycontains'] = '본 범주에 포함된 내용들';
$string['time'] = '시';
$string['timezone'] = '시간대';
$string['to'] = '까지';
$string['tocontent'] = '" {$a}" 아이템에';
$string['tocreatenewaccount'] = '새 계정 생성 생략';
$string['today'] = '오늘';
$string['todaylogs'] = '오늘의 로그';
$string['toeveryone'] = '모든 이에게';
$string['toomanybounces'] = '그 메일 주소는 너무 많이 반송되었습니다. 계속하려면 이메일을 <b>바꿔야만</b> 합니다.';
$string['toomanytoshow'] = '보여줄 사용자가 너무 많습니다.';
$string['toomanyusersmatchsearch'] = '너무 많은 사용자 ({$a->count}) 가  \'{$a->search}\' 와 일치함';
$string['toomanyuserstoshow'] = '보여줄 사용자 ({$a}) 가 너무 많음';
$string['toonly'] = '오직 {$a} 에 넣기';
$string['top'] = '맨 위';
$string['topic'] = '토픽';
$string['topichide'] = '{$a} 에서 이 토픽을 감추기';
$string['topicoutline'] = '토픽 개요';
$string['topicshow'] = '{$a} 에 이 토픽을 보이기';
$string['toplevelcategory'] = '최상위 범주';
$string['total'] = '전체';
$string['totopofsection'] = '섹션 "{$a}"의 맨위에';
$string['trackforums'] = '포럼 추적';
$string['trackforumsno'] = '아니오: 내가 본 글들의 경로를 추적하지 마시오.';
$string['trackforumsyes'] = '예: 새 글들은 강조해 주시오.';
$string['trysearching'] = '대신 검색을 시도하라';
$string['turneditingoff'] = '편집모드 끄기';
$string['turneditingon'] = '편집모드 켜기';
$string['undecided'] = '결정 않됨';
$string['unfinished'] = '미완성';
$string['unknowncategory'] = '등록되지 않은 범주';
$string['unknownerror'] = '알 수 없는 오류';
$string['unlimited'] = '제한없음';
$string['unpacking'] = '압축풀기 {$a}';
$string['unsafepassword'] = '안전하지 않은 비밀번호- 다른 것으로 입력하세요.';
$string['untilcomplete'] = '완료될 때까지';
$string['unusedaccounts'] = '{$a} 일 이상 사용하지 않으면 자동적으로 제명 처리됩니다.';
$string['unzip'] = '압축풀기';
$string['unzippingbackup'] = '백업 압축풀기';
$string['up'] = '위';
$string['update'] = '업데이트';
$string['updated'] = '업데이트됨 {$a}';
$string['updatemymoodleoff'] = '이 페이지를 사용자 맞춤하는 것을 중단';
$string['updatemymoodleon'] = '이 페이지를 사용자 맞춤';
$string['updatemyprofile'] = '개인정보 수정';
$string['updatesevery'] = '매 {$a} 초마다 업데이트';
$string['updatethis'] = '{$a} 업데이트';
$string['updatethiscourse'] = '강좌 업데이트';
$string['updatinga'] = '{$a} 업데이트 중';
$string['updatingain'] = '{$a->in} 에 있는 {$a->what} 을 업데이트';
$string['upload'] = '올리기';
$string['uploadafile'] = '파일 올리기';
$string['uploadcantwrite'] = '디스크에 파일 쓰기 실패';
$string['uploadedfile'] = '파일 올리기 성공';
$string['uploadedfileto'] = '{$a->file} 이 {$a->directory} 로 업로드됨';
$string['uploadedfiletoobig'] = '죄송합니다 파일이 너무큽니다({$a} 바이트 이상 불가)';
$string['uploadextension'] = 'PHP 확장기능에 의해 파일 올리기 중지됨';
$string['uploadfailednotrecovering'] = '당신의 파일 업로드가 실패했음 왜냐하면 한개의 파일 {$a->name} 에 문제가 있었음.<br /> 여기 문제의 기록이 있음:<br />{$a->problem}<br />복원할 수 없음.';
$string['uploadfilelog'] = '{$a} 파일의 업로드 기록';
$string['uploadformlimit'] = '올려진 파일 {$a} 이 지정된 최대 크기를 초과함';
$string['uploadlabel'] = '제목:';
$string['uploadlimitwithsize'] = '{$a->contextname} 업로드 한계 ({$a->displaysize})';
$string['uploadnewfile'] = '새파일 올리기';
$string['uploadnofilefound'] = '파일이 없습니다. 올릴 파일을 제대로 선택하셨습니까?';
$string['uploadnotallowed'] = '업로드 할 수 없습니다.';
$string['uploadnotempdir'] = '임시 폴더 누락';
$string['uploadoldfilesdeleted'] = '당신이 올린 경로에서 오래된 파일(들)이 지워졌음';
$string['uploadpartialfile'] = '파일의 일부만 업로드 되었습니다.';
$string['uploadproblem'] = '\'{$a}\' 파일을 올리는 중에 오류가 발생하였습니다.( 파일 크가가 너무 큰가요?)';
$string['uploadrenamedchars'] = '적절한 문자가 아니므로 파일 이름을 {$a->oldname} 에서 {$a->newname} 로 고침.';
$string['uploadrenamedcollision'] = '파일명이 중첩되어 {$a->oldname} 에서 {$a->newname} 으로 파일명을 고침.';
$string['uploadserverlimit'] = '올린 파일이 서버가 제한하는 최대크기를 넘어섬.';
$string['uploadthisfile'] = '이 파일 업로드하기';
$string['url'] = 'URL';
$string['used'] = '사용됨';
$string['usedinnplaces'] = '{$a} 가 사용된 장소';
$string['usemessageform'] = '아니면 선택된 학생들에게 이 형식을 이용하여 메세지를 보냅니다.';
$string['user'] = '사용자';
$string['userconfirmed'] = '{$a} 이 확인 되었습니다.';
$string['usercurrentsettings'] = '내 개인정보 설정';
$string['userdata'] = '사용자 데이터';
$string['userdeleted'] = '이 사용자 계정은 삭제되었습니다.';
$string['userdescription'] = '설명';
$string['userdescription_help'] = '이 곳에는 다른 사람들이 여러분의 개인정보를 살펴볼 때 참조할 수 있도록 자신에 대해 기록을 남길 수 있는 곳입니다.';
$string['userdetails'] = '사용자 세부사항';
$string['userfiles'] = '사용자 파일';
$string['userlist'] = '사용자 목록';
$string['username'] = '사용자 아이디';
$string['usernameemailmatch'] = '사용자 아이디와 이메일 주소는 다른 사용자와 같아서는 않됩니다.';
$string['usernameexists'] = '이 아이디는 이미 사용중입니다. 다른 아이디를 사용하세요.';
$string['usernamelowercase'] = '소문자만 허용됨';
$string['usernamenotfound'] = '사용자 아이디가 데이터베이스에 없습니다.';
$string['usernameoremail'] = '사용자 아이디나 이메일 주소를 입력';
$string['usernotconfirmed'] = '{$a} 를 확인 할 수 없습니다.';
$string['userpic'] = '사용자 사진';
$string['users'] = '사용자';
$string['userselectorautoselectunique'] = '사용자가 검색되면 자동으로 선택';
$string['userselectorpreserveselected'] = '검색에서 더 이상 일치하지 않더라도 선택된 사용자 유지';
$string['userselectorsearchanywhere'] = '사용자명 검색 내용 일치';
$string['usersnew'] = '새로운 사용자';
$string['usersnoaccesssince'] = '비활동인 사용자 보기';
$string['userswithfiles'] = '사용자파일 포함';
$string['useruploadtype'] = '올리는 형식: {$a}';
$string['userviewingsettings'] = '{$a} 개인정보 설정';
$string['userzones'] = '사용자 영역';
$string['usetheme'] = '테마 사용';
$string['usingexistingcourse'] = '개설된 강좌 사용하기';
$string['valuealreadyused'] = '이미 이용된 값';
$string['version'] = '버전';
$string['view'] = '보기';
$string['viewallcourses'] = '모든 강좌 보기';
$string['viewallcoursescategories'] = '모든 강좌 및 범주 보기';
$string['viewallsubcategories'] = '모든 하위 범주 보기';
$string['viewfileinpopup'] = '팝업창으로 보기';
$string['viewing'] = '보기:';
$string['viewmore'] = '더 보기';
$string['viewprofile'] = '개인정보 보기';
$string['views'] = '보기';
$string['viewsolution'] = '해답 보기';
$string['virusfound'] = '관리자 경고! 클램AV가 {$a->user} 가 {$a->course} 에 올린 자료파일에 바이러스가 있음을 발견함.
여기 클램스캔의 사용결과가 있음:';
$string['virusfoundlater'] = '당신이 {$a->date} 에 {$a->course} 로 올린 {$a->filename} 파일이 바이러스를 포함하고 있음이 밝혀짐. 여기 그 파일에 무슨 일이 일어났는지 요약이 있음:

{$a->action}

만약 이것이 제출된 과제라면, 선생님이 볼수 있도록 다시 제출해야함.';
$string['virusfoundlateradmin'] = '관리자 경고! 사용자 {$a->user} 가 {$a->date} 에 {$a->course} 로 올린 {$a->filename} 파일이 바이러스를 포함하고 있음이 밝혀짐. 여기 그 파일에 어떤 문제가 있는지에 대한 개요가 있음:

{$a->action}

그 사용자에게도 통보되었음.';
$string['virusfoundlateradminnolog'] = '관리자 경고! 파일이름 {$a->filename} 으로 올려진 자료가 바이러스를 포함하고 있음이 밝혀짐. 무들이 처음 자료를 올린 사람에 대한 조처를 취하지 못함.
여기 이 파일에 어떤 문제가 있는지에 대한 개요가 있음:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: 바이러스 발견!';
$string['virusfounduser'] = '당신이 올린 파일, {$a->filename} 이 바이러스 검색기에의해 검사되었고 감염이 확인 되었음!
당신의 파일 업로드는 성공적이지 못함.';
$string['virusplaceholder'] = '올려진 자료가 바이러스를 포함하고 있음이 발견되어 옮겨졌거나 지워졌고 사용자에게 통보되었습니다.';
$string['visible'] = '볼 수 있음';
$string['visible_help'] = '이 설정은 강좌목록에 강좌가 나타나도록 할 것인지를 결정합니다. 선생님과 관리자를 제외하고, 일반 사용자는 강좌에 입장할 수 없습니다.';
$string['visibletostudents'] = '{$a} 가 볼 수 있음';
$string['warning'] = '경고';
$string['warningdeleteresource'] = '주의: {$a} 은 다른 자료에서 참조되고 있습니다. 그래도 자료를 업데이트하겠습니까?';
$string['webpage'] = '웹 페이지';
$string['week'] = '주';
$string['weekhide'] = '{$a} 에서 이 주를 감추기';
$string['weeklyoutline'] = '주별 개요';
$string['weeks'] = '주';
$string['weekshow'] = '{$a} 에 이번 주 보이기';
$string['welcometocourse'] = '{$a} 에 오신 것을 환영합니다.';
$string['welcometocoursetext'] = '{$a->coursename} 에 오신 것을 환영합니다!

이미 개인정보를 입력 하지 않았다면, 우리가 당신에 대해 더 잘 알 수 있도록 개인정보를 입력해 주십시요.

{$a->profileurl}';
$string['whatforlink'] = '링크로 무엇을 하고 싶습니까?';
$string['whatforpage'] = '텍스트로 무엇을 하고 싶습니까?';
$string['whattocallzip'] = 'zip 파일 이름은?';
$string['whattodo'] = '실행목록';
$string['windowclosing'] = '이 창은 자동으로 닫혀야 합니다만 아직 닫히지 않았으면 지금 닫아주기 바랍니다.';
$string['withchosenfiles'] = '선택된 파일(들)을..';
$string['withdisablednote'] = '{$a} (비 활성화됨)';
$string['withoutuserdata'] = '사용자 데이터 제외';
$string['withselectedusers'] = '선택된 사용자를';
$string['withselectedusers_help'] = '* 메세지 보내기 - 한 사람 혹은 여러 참여자에게 메세지 보내기
* 새 학습관찰 추가 - 선택된 참여자에게 학습관찰 추가
* 공통 학습관찰 추가 - 한사람 이상 참여자에게 같은 학습관찰 추가';
$string['withuserdata'] = '사용자 데이터 포함';
$string['wordforstudent'] = '학습자에 대한 호칭';
$string['wordforstudenteg'] = '예: 학생, 참여자 등';
$string['wordforstudents'] = '학습자들에 대한 호칭';
$string['wordforstudentseg'] = '예: 학생들, 참여자들 등';
$string['wordforteacher'] = '선생님에 대한 호칭';
$string['wordforteachereg'] = '예: 선생님, 튜터, 촉진자 등';
$string['wordforteachers'] = '선생님들에 대한 호칭';
$string['wordforteacherseg'] = '예: 선생님들, 튜터, 촉진자들 등';
$string['writingblogsinfo'] = '블로그 정보 쓰기';
$string['writingcategoriesandquestions'] = '범주를 정하고 질문 쓰기';
$string['writingcoursedata'] = '강좌 데이터 쓰기';
$string['writingeventsinfo'] = '일정 정보 쓰기';
$string['writinggeneralinfo'] = '일반적 정보 쓰기';
$string['writinggradebookinfo'] = '성적부 정보 쓰기';
$string['writinggroupingsgroupsinfo'] = '모둠무리-모둠 정보 쓰기';
$string['writinggroupingsinfo'] = '모둠무리 정보 쓰기';
$string['writinggroupsinfo'] = '모둠 정보 쓰기';
$string['writingheader'] = '머릿말 쓰기';
$string['writingloginfo'] = '기록 정보 쓰기';
$string['writingmessagesinfo'] = '메시지 정보 쓰기';
$string['writingmoduleinfo'] = '모듈 정보 쓰기';
$string['writingscalesinfo'] = '척도 정보 쓰기';
$string['writinguserinfo'] = '사용자 정보 쓰기';
$string['wrongpassword'] = '계정 비밀번호가 일치하지 않음';
$string['yahooid'] = '야후 아이디';
$string['year'] = '년';
$string['years'] = '년';
$string['yes'] = '예';
$string['youareabouttocreatezip'] = 'zip 파일을 생성하려고 합니다.';
$string['youaregoingtorestorefrom'] = '다음의 복구 과정을 시작하려고 합니다.';
$string['youneedtoenrol'] = '그 활동을 하려면 이 강좌에 등록해야 합니다.';
$string['yourlastlogin'] = '마지막 로그인';
$string['yourself'] = '당신자신';
$string['yourteacher'] = '당신의 {$a}';
$string['yourwordforx'] = '\'{$a}\'에 대한 호칭';
$string['zippingbackup'] = '백업 압축하기';
