<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = '접근 제한';
$string['actionaftercorrectanswer'] = '답 맞힌 후 할 일';
$string['actionaftercorrectanswer_help'] = '질문에 정답을 입력하면 다음 페이지에 대해 3 옵션이 있습니다.

* 보통 - 완전학습 경로 따라가기
* 보지 않은 페이지 보기 - 페이지들이 무작위로 한번만 보여집니다.
* 답하지 않은 페이지 보기 - 답하지 않은 질문이 있는 페이지들이 무작위로 보여집니다.';
$string['actions'] = '활동';
$string['activitylink'] = '다음 활동으로의 링크';
$string['activitylink_help'] = '완전학습의 마지막에 강좌의 다른 활동으로으 링크를 제공하려면 내림목록에서 활동을 선택하십시요.';
$string['activitylinkname'] = '{$a} 로 가기';
$string['activityoverview'] = '제출 마감인 완전학습이 있습니다.';
$string['addabranchtable'] = '콘텐츠 페이지 추가';
$string['addanendofbranch'] = '분기 끝 추가';
$string['addanewpage'] = '페이지 추가';
$string['addaquestionpage'] = '질문페이지 추가';
$string['addaquestionpagehere'] = '여기에 질문페이지 추가';
$string['addbranchtable'] = '콘텐츠 페이지 추가';
$string['addcluster'] = '질문묶음 추가';
$string['addedabranchtable'] = '콘텐츠 페이지 추가됨';
$string['addedanendofbranch'] = '분기 끝 추가됨';
$string['addedaquestionpage'] = '질문페이지 추가됨';
$string['addedcluster'] = '질문묶음 추가됨';
$string['addedendofcluster'] = '질문묶음끝 추가됨';
$string['addendofcluster'] = '질문묶음끝 추가';
$string['addpage'] = '페이지 추가';
$string['anchortitle'] = '핵심 콘텐츠의 시작';
$string['and'] = '그리고';
$string['answer'] = '답안';
$string['answeredcorrectly'] = '정답을 맞췄음';
$string['answersfornumerical'] = '수치형 질문에 대한 답은 최소 값과 최대 값 쌍으로 이루어져야 합니다.';
$string['arrangebuttonshorizontally'] = '콘텐츠 버튼을 수평으로 배열할까요?';
$string['attempt'] = '{$a} 번째 시도';
$string['attempts'] = '시도';
$string['attemptsdeleted'] = '삭제된 시도';
$string['attemptsremaining'] = '{$a} 번의 시도 남음';
$string['available'] = '학습 시작';
$string['averagescore'] = '평균 점수';
$string['averagetime'] = '평균 시간';
$string['branch'] = '콘텐츠';
$string['branchtable'] = '콘텐츠';
$string['cancel'] = '취소';
$string['cannotfindanswer'] = '답안을 찾을 수 없음';
$string['cannotfindattempt'] = '오류: 시도를 찾을 수 없음';
$string['cannotfindessay'] = '오류: 에세이를 찾을 수 없음';
$string['cannotfindfirstgrade'] = '오류: 성적을 찾을 수 없음';
$string['cannotfindfirstpage'] = '첫 페이지를 찾을 수 없음';
$string['cannotfindgrade'] = '오류: 성적을 찾을 수 없음';
$string['cannotfindnewestgrade'] = '오류: 최근 성적을 찾을 수 없음';
$string['cannotfindnextpage'] = '강좌 백업: 다음 페이지를 찾을 수 없음!';
$string['cannotfindpagerecord'] = '분기 끝 추가: 페이지 기록을 찾을 수 없음';
$string['cannotfindpages'] = '완전학습 페이지를 찾을 수 없음';
$string['cannotfindpagetitle'] = '인증 삭제:페이지 제목을 찾을 수 없음';
$string['cannotfindpreattempt'] = '이전의 시도 기록을 찾을 수 없음!';
$string['cannotfindrecords'] = '오류: 학습 기록을 찾을 수 없음';
$string['cannotfindtimer'] = '오류: 학습 시간 기록을 찾을 수 없음';
$string['cannotfinduser'] = '오류: 사용자를 찾을 수 없음';
$string['canretake'] = '{$a} 는 재이수 가능';
$string['casesensitive'] = '정규 표현 사용';
$string['casesensitive_help'] = '응답을 분석하기 위해 정규적 표현을 사용하기 위해서는 체크박스에 표시하십시요.';
$string['checkbranchtable'] = '콘텐츠 페이지 점검';
$string['checkedthisone'] = '이것을 점검하였음';
$string['checknavigation'] = '찾아가기 점검';
$string['checkquestion'] = '질문 점검';
$string['classstats'] = '학급 통계';
$string['clicktodownload'] = '파일을 내려받으려면 다음의 링크를 클릭하시오.';
$string['clicktopost'] = '고득점 목록에 당신의 성적을 게시하려면 여기를 클릭하시오.';
$string['cluster'] = '질문묶음';
$string['clusterjump'] = '질문묶음에서 보지 않은 질문';
$string['clustertitle'] = '질문묶음';
$string['collapsed'] = '제목 펼침';
$string['comments'] = '당신의 평';
$string['completed'] = '이수';
$string['completederror'] = '학습 완료';
$string['completethefollowingconditions'] = '계속하기 위해서는 <b>{$a}</b> 학습에서 다음 내용을 먼저 완료해야만 합니다.';
$string['conditionsfordependency'] = '선수 학습';
$string['configactionaftercorrectanswer'] = '정답일 때의 기본 활동';
$string['configmaxanswers'] = '페이지 당 기본 최대 답 수';
$string['configmaxhighscores'] = '표시할 최고점의 갯수';
$string['configmediaclose'] = '미디어 파일에 의해 생성된 팝업창의 종료버튼 표시';
$string['configmediaheight'] = '미디어 파일에 의해 생성된 팝업창의 높이 조정';
$string['configmediawidth'] = '미디어 파일에 의해 생성된 팝업창의 너비 조정';
$string['configslideshowbgcolor'] = '슬라이드쇼의 배경색';
$string['configslideshowheight'] = '슬라이드쇼 창의 높이 설정';
$string['configslideshowwidth'] = '슬라이드쇼 창의 너비 설정';
$string['confirmdelete'] = '페이지 삭제';
$string['confirmdeletionofthispage'] = '페이지 삭제 확인';
$string['congratulations'] = '학습의 끝입니다 - 축하합니다';
$string['continue'] = '계속';
$string['continuetoanswer'] = '답 수정 계속하기';
$string['continuetonextpage'] = '다음 페이지로 가기';
$string['correctanswerjump'] = '정답인 경우 이동할 곳';
$string['correctanswerscore'] = '정답에 대한 점수';
$string['correctresponse'] = '정답에 대한 반응';
$string['createaquestionpage'] = '질문 페이지 만들기';
$string['credit'] = '학점';
$string['customscoring'] = '성적매기기';
$string['customscoring_help'] = '<p>각 답안에 숫자로 된 배점을 적도록 한다. 답안 배점은 음수 혹은 양수를 쓸 수 있다. 외부에서 가져온 문제의 경우에는 자동적으로 정답에는 1점, 오답에는 0점이 주어지지만 이를 바꿀 수도 있다.</p>';
$string['deadline'] = '마감시간';
$string['defaultessayresponse'] = '선생님이 당신의 에세이를 평가할 것입니다.';
$string['deleteallattempts'] = '모든 완전학습 시도를 삭제';
$string['deletedefaults'] = '{$a} x 기본 학습이 삭제됨';
$string['deletedpage'] = '페이지 삭제';
$string['deleting'] = '삭제하기';
$string['deletingpage'] = '{$a} 페이지 삭제';
$string['dependencyon'] = '선수학습 유무';
$string['dependencyon_help'] = '이 설정은 이 완전학습에 대한 접근이 같은 강좌내의 다른 완전학습에서의 학습자의 능력에 의존하도록 합니다. 소요된 시간, 완료됨 혹은 "성적"이 사용될 수 있습니다.';
$string['description'] = '서술';
$string['detailedstats'] = '자세한 통계';
$string['didnotanswerquestion'] = '이 질문에 답하지 않았음';
$string['didnotreceivecredit'] = '점수를 못 받음';
$string['displaydefaultfeedback'] = '기본 피드백 사용';
$string['displaydefaultfeedback_help'] = '활성화되면 특정 질문에 대해 응답이 발견되지 않으면 "정답입니다" 혹은 "틀린 답입니다"라는 기본 응답이 보여질 것입니다.';
$string['displayhighscores'] = '고득점 표시';
$string['displayinleftmenu'] = '왼쪽 메뉴를 보일까요?';
$string['displayleftif'] = '다음 성적 이상일 때 왼쪽 메뉴 표시 :';
$string['displayleftif_help'] = '이 설정은 학생이 왼쪽 메뉴를 보기 전, 몇 점을 얻어야 하는지를 결정하는 것이다. 이는 학생으로 하여금 첫 시도에 전체 학습을 하게 하고, 요구된 점수를 얻게 되면 복습을 위해 왼쪽 메뉴를 사용할 수 있게 한다.';
$string['displayleftmenu'] = '왼쪽 메뉴 표시';
$string['displayleftmenu_help'] = '활성화되면  페이지의 목록이 표시됩니다.';
$string['displayofgrade'] = '성적 표시 (학생만)';
$string['displayreview'] = '질문 다시풀기 옵션을 제공';
$string['displayreview_help'] = '활성화되어 있는 경우, 질문에 정답을 맞추지 못했을때, 학생은 점수 반영없이 다시 그 문제를 풀어보거나 계속할 수 있는 옵션이 주어집니다.
';
$string['displayscorewithessays'] = '자동으로 채점되는 질문에 대해 {$a->tempmaxgrade} 점 중 {$a->score} 점을 얻었습니다.<br>  당신의{$a->essayquestions}  에세이 질문(들)은 추후에 채점될 것이며 최종 점수에 추가될 것입니다.<br/> 에세이 질문(들)을 제외한 점수는 현재 {$a->grade} 점 중에서 {$a->score} 점을 받았습니다.';
$string['displayscorewithoutessays'] = '당신의 점수는 {$a->score} 점 입니다.({$a->grade} 점 만점)';
$string['edit'] = '편집';
$string['editingquestionpage'] = '{$a} 질문 페이지 편집';
$string['editlessonsettings'] = '완전학습 설정';
$string['editpage'] = '내용 편집';
$string['editpagecontent'] = '페이지 내용 편집';
$string['email'] = '이메일';
$string['emailallgradedessays'] = '모두에게  채점된 에세이 이메일 보내기';
$string['emailgradedessays'] = '채점된 에세이 이메일 보내기';
$string['emailsuccess'] = '이메일이 성공적으로 보내어졌습니다';
$string['emptypassword'] = '암호는 공백일 수 없습니다.';
$string['endofbranch'] = '분기 끝';
$string['endofcluster'] = '질문묶음 끝';
$string['endofclustertitle'] = '질문묶음 끝';
$string['endoflesson'] = '학습 종료';
$string['enteredthis'] = '입장했습니다.';
$string['entername'] = '고득점 목록에 쓸 별명을 입력하세요';
$string['enterpassword'] = '비밀번호를 입력하세요 :';
$string['eolstudentoutoftime'] = '주의: 학습시간이 종료되었습니다.
마지막 답변이 종료 후에 입력되었다면, 그것은 평가되지 않을 것입니다.';
$string['eolstudentoutoftimenoanswers'] = '당신은 답변을 전혀 하지 않았습니다.
이번 학습에서 0점을 얻게 되었습니다.';
$string['essay'] = '에세이';
$string['essayemailmessage'] = '<p>에세이 질문:<blockquote>{$a->question}</blockquote></p>
<p>여러분의 답:<blockquote><em>{$a->response}</em></blockquote></p>
<p>{$a->teacher} 의 평:<blockquote><em>{$a->comment}</em></blockquote></p>
<p>이 에세이 질문에서 {$a->outof} 중 {$a->earned} 을 얻었습니다.</p>
<p>학습에 대한 성적은 {$a->newgrade}% 로 변경되었습니다.</p>';
$string['essayemailmessage2'] = '<p>에세이 질문:<blockquote>{$a->question}</blockquote></p> <p>여러분의 답:<blockquote><em>{$a->response}</em></blockquote></p> <p>채점자의 평:<blockquote><em>{$a->comment}</em></blockquote></p> <p>이에세이 질문에서 {$a->outof} 중 {$a->earned} 을 얻었습니다.</p> <p>학습에 대한 성적은 {$a->newgrade}% 로 변경되었습니다.</p>';
$string['essayemailsubject'] = '{$a} 질문에 대한 성적';
$string['essays'] = '에세이';
$string['essayscore'] = '에세이 점수';
$string['fileformat'] = '파일 형식';
$string['finish'] = '종료';
$string['firstanswershould'] = '첫 대답은 "맞음"페이지으로 이동해야 합니다.';
$string['firstwrong'] = '답이 틀렸기 때문에 점수를 얻을 수 없습니다. 그냥 재미로 계속 해보겠습니까?(맞아도 점수 추가는 없습니다.)';
$string['flowcontrol'] = '흐름 조절';
$string['full'] = '내용 전체 펼침';
$string['general'] = '일반적';
$string['gotoendoflesson'] = '완전학습의 끝으로 가기';
$string['grade'] = '성적';
$string['gradebetterthan'] = '점(%) 이상 획득';
$string['gradebetterthanerror'] = '{$a} 퍼센트 보다 좋은 성적 얻기';
$string['gradeessay'] = '에세이 질문 채점 ({$a->notgradedcount}이 아직 채점되지 않았고  {$a->notsentcount} 제출하지 않았습니다)';
$string['gradeis'] = '성적은 {$a} 입니다';
$string['gradeoptions'] = '성적 옵션';
$string['handlingofretakes'] = '재이수 처리방법';
$string['handlingofretakes_help'] = '재이수가 허용되면 이 설정은 완전학습에 대한 성적이 모든 시도의 평균인지 최대인지를 명시합니다.';
$string['havenotgradedyet'] = '아직 채점되지 않았습니다.';
$string['here'] = '이 곳';
$string['highscore'] = '고득점';
$string['highscores'] = '높은 점수들';
$string['hightime'] = '최장 시간';
$string['importcount'] = '{$a} 질문 가져오기';
$string['importquestions'] = '질문 가져오기';
$string['importquestions_help'] = '이 기능은 텍스트 파일을 통하여 다양한 형식의 질문을 가져오기 할 수 있게 합니다.';
$string['insertedpage'] = '페이지 삽입';
$string['invalidfile'] = '잘못된 파일';
$string['invalidid'] = '어떤 강좌 모듈/학습 ID도 통과하지 못함';
$string['invalidlessonid'] = '학습 ID 부정확';
$string['invalidpageid'] = '잘못된 페이지 ID';
$string['jump'] = '건너뛰기';
$string['jumps'] = '건너 뜀';
$string['jumps_help'] = '(질문에 대한)각 답안 혹은 (콘텐츠 페이지에 대한)설명은  바로가기를 가지고 있습니다. 바로가기는 이 페이지 혹은 다음 페이지 등의 상대적 경로 일 수 있고 완전학습의 한 페이지를 나타내는 절대적 경로 일 수 있습니다.';
$string['jumpsto'] = '{$a} 로 건너 뜀';
$string['leftduringtimed'] = '당신은 규정된 학습시간에 자리를 비웠습니다.<br />
학습을 다시 시작하려면 계속 버튼을 눌러주세요.';
$string['leftduringtimednoretake'] = '당신은 규정된 학습시간에 자리를 비웠기 때문에<br />재학습을 하거나 계속할 수 없습니다.';
$string['leftduringtimedsession'] = '시간이 정해진 세션에서 나갔습니다.';
$string['lesson:addinstance'] = '새 완전학습 추가';
$string['lessonattempted'] = '완전학습 시도됨';
$string['lessonclosed'] = '이 완전학습은 {$a} 에 종료되었습니다.';
$string['lessoncloses'] = '완전학습 종료';
$string['lessoncloseson'] = '완전학습은 {$a} 에 종료됨';
$string['lesson:edit'] = '완전학습 편집';
$string['lessonformating'] = '완전 학습 포맷중';
$string['lesson:manage'] = '완전학습 관리';
$string['lessonmenu'] = '완전 학습 메뉴';
$string['lessonnotready'] = '이 학습은 진행할 수 없습니다. {$a} 에게 연락하기 바랍니다.';
$string['lessonnotready2'] = '이 학습은 진행할 수 없습니다.';
$string['lessonopen'] = '이 학습과정은 {$a} 에 열릴 것입니다.';
$string['lessonopens'] = '완전 학습 시작';
$string['lessonpagelinkingbroken'] = '학습의 시작 페이지가 발견되지 않습니다. 학습의 연결 고리가 끊어졌을 수 있습니다. 관리자에게 연락하십시요.';
$string['lessonstats'] = '완전학습 통계';
$string['linkedmedia'] = '연결된 매체';
$string['loginfail'] = '로그인에 실패했습니다, 다시 시도하세요.';
$string['lowscore'] = '낮은 점수';
$string['lowtime'] = '최단 시간';
$string['manualgrading'] = '에세이 채점';
$string['matchesanswer'] = '맞는 답을 찾음';
$string['matching'] = '짝찾기형';
$string['matchingpair'] = '일치하는 짝 {$a}';
$string['maxgrade'] = '최대 성적';
$string['maxgrade_help'] = '이 설정은 완전학습에 대한 최대 성적을 명시합니다. 만일 0으로 설정되면 완전학습은 성적 페이지에 나타나지 않습니다.';
$string['maxhighscores'] = '표시할 고득점 수';
$string['maximumnumberofanswersbranches'] = '답의 최대 수';
$string['maximumnumberofanswersbranches_help'] = '이 설정은 완전학습에 사용될 수 있는 최대 답 수를 지정합니다. 만일 참/거짓 질문만 사용된다면 2로 설정될 수 있습니다. 이 설정은 선생님이 보는 것만 영향을 주고 데이터에는 영향을 주지 않기 때문에 언제든지 변경될 수 있습니다.';
$string['maximumnumberofattempts'] = '최대 시도 수';
$string['maximumnumberofattempts_help'] = '이 설정은 각 질문에 대해 허용된 최대 시도 횟수를 명시합니다. 반복적으로 틀리게 답하고, 최대 시도 회수에 도달하면 완전학습의 다음 페이지가 표시됩니다.';
$string['maximumnumberofattemptsreached'] = '최대 허용 시도횟수에 도달하였습니다. 다음 페이지로 갑니다.';
$string['maxtime'] = '제한 시간(분)';
$string['maxtimewarning'] = '완전 학습을 마치기까지 {$a} 분 남았습니다.';
$string['mediaclose'] = '종료 버튼 보이기';
$string['mediafile'] = '미디어파일 창';
$string['mediafile_help'] = '완전 학습의 처음에 팝업 창을 포함시키기 위해서 표시할 적절한 페이지를 선택하십시요. 모든 완전 학습 페이지는 필요한 경우 팝업을 다시 열 수 있는 링크를 포함하게 될 것입니다.';
$string['mediafilepopup'] = '이곳을 누르면 수업 동영상 파일을 볼 수 있습니다.';
$string['mediaheight'] = '팝업 창 높이 :';
$string['mediawidth'] = '팝업 창 너비 :';
$string['messageprovider:graded_essay'] = '에세이 채점 통지';
$string['minimumnumberofquestions'] = '질문의 최소 갯수';
$string['minimumnumberofquestions_help'] = '이 설정은 활동에 대한 성적을 계산하는데 사용하는 질문의 최소 갯수를 명시합니다. 만일 완전학습이 한개 이상의 콘텐츠 페이지를 가지고 있다면 최소 질문의 수는 0으로 설정되어야 합니다.

만일 예를 들어 20으로 설정되는 경우 완전학습의 시작페이지에 다음 문장을 추가하면 좋습니다. " 이 완전학습에서는 적어도 20개의 질문을 시도해야 합니다. 원한다면 더 할 수도 있습니다. 만일 20개 질문 이하를 시도한다면 성적은 20개를 시도한것으로 간주하여 계산될 것입니다.';
$string['missingname'] = '별명을 입력하시오';
$string['modattempts'] = '검토 허용';
$string['modattempts_help'] = '<p>이것은 학생이 앞쪽으로 다시 가서 자신의 답을 고칠 수 있는 기회를 제공한다.</p>';
$string['modattemptsnoteacher'] = '검토과정은 학생에게만 해당됨';
$string['modulename'] = '완전학습';
$string['modulename_help'] = '완전학습 모듈은 선생님이 질문 포함 페이지들로 구성된 적응 학습 경험을 제공할 수 있도록 합니다. ';
$string['modulenameplural'] = '완전학습';
$string['move'] = '페이지 옮김';
$string['movedpage'] = '페이지 옮겨짐';
$string['movepagehere'] = '이곳으로 페이지 옮김';
$string['moving'] = '{$a} 페이지 옮김';
$string['multianswer'] = '다답';
$string['multianswer_help'] = '한 개 이상의 응답이 정답인 경우에는 체크박스에 표시하십시요.';
$string['multichoice'] = '선다형';
$string['multipleanswer'] = '복수 답';
$string['nameapproved'] = '이름 승인됨';
$string['namereject'] = '죄송합니다. 당신의 이름은 필터에 의해 거부되었습니다. <br />다른 이름을 입력하세요.';
$string['new'] = '새';
$string['nextpage'] = '다음 페이지';
$string['noanswer'] = '답을 하지 않았습니다. 되돌아 가서 답을 입력하세요.';
$string['noattemptrecordsfound'] = '한 번도 시도한 기록이 없습니다. 성적이 주어지지 않았습니다.';
$string['nobranchtablefound'] = '콘텐츠 페이지를 찾을 수 없습니다.';
$string['nocommentyet'] = '아직 코멘트 없음';
$string['nocoursemods'] = '아무런 활동도 하지 않음';
$string['nocredit'] = '학점 없음';
$string['nodeadline'] = '무한정';
$string['noessayquestionsfound'] = '이 완전학습에는 에세이 질문이 없음.';
$string['nohighscores'] = '높은 점수 없음';
$string['nolessonattempts'] = '이 학습에 대해 아무런 시도도 없었음.';
$string['nooneansweredcorrectly'] = '아무도 정답을 맞추지 못했음.';
$string['nooneansweredthisquestion'] = '아무도 이 질문에 답하지 않았음.';
$string['noonecheckedthis'] = '아무도 이것을 확인하지 않았음.';
$string['nooneenteredthis'] = '아무도 여기에 들어오지 않았음.';
$string['noonehasanswered'] = '아직 아무도 에세이 질문에 답하지 않았음.';
$string['noretake'] = '당신은 이 학습을 다시 하도록 허가받지 못했습니다.';
$string['normal'] = '정상 - 학습 과정 따라가기';
$string['notcompleted'] = '완료하지 않았음';
$string['notdefined'] = '정의되지 않았음';
$string['nothighscore'] = '고득점 {$a} 목록에 등재되지 않았음';
$string['notitle'] = '제목없음';
$string['numberofcorrectanswers'] = '정답 수: {$a}';
$string['numberofcorrectmatches'] = '바른 연결을 한 갯수: {$a}';
$string['numberofpagestoshow'] = '보여줄 페이지 수';
$string['numberofpagestoshow_help'] = '<p>이 값은 플래시 카드 유형의 수업에만 적용되는 변수이다. 기본값은 0으로 이것은 수업내 모든 쪽 혹은 카드가 다 보여지는 것을 의미한다. 0이 아닌 값을 설정하면, 그 숫자만큼의 쪽이 보여진다. 그 수만큼의 쪽/카드가 보여진 후에는 학습의 끝에 도달하며 그 때 학생들은 자신의 성적을 볼 수 있다.</p>

<p>만일 이 값이 학습에 포함되어 있는 쪽의 수보다 많게되면, 모든 쪽을 보여준 후에는 수업의 끝에 도달하게 된다.</p>';
$string['numberofpagesviewed'] = '응답한 질문의 수: {$a}';
$string['numberofpagesviewednotice'] = '응답한 질문수 : {$a->nquestions} (최소한  {$a->minquestions} 개 답해야 합니다.)';
$string['numerical'] = '숫자';
$string['ongoing'] = '현재 점수 보기';
$string['ongoingcustom'] = '당신은 {$a->currenthigh} (최고)점 중 {$a->score} 점입니다.';
$string['ongoing_help'] = '<p>이 기능을 켜놓으면, 각 페이지마다 학생이 현재까지 얻은 점수가 표시된다. 예를들어 어떤 학생이 5점짜리 문제 네개를 답했는데 그 중 하나만 틀렸다고 하면, 현재 점수는 15/20 점으로 표시된다.</p>';
$string['ongoingnormal'] = '당신은 {$a->viewed} 개의 질문 중  {$a->correct} 질문에 정확한 답을 했습니다.';
$string['onpostperpage'] = '성적 당 하나의 게시물만';
$string['options'] = '옵션';
$string['or'] = '또는';
$string['ordered'] = '정렬';
$string['other'] = '기타';
$string['outof'] = '{$a} 중';
$string['overview'] = '개요';
$string['overview_help'] = '완전학습은 페이지들과 선택적으로 콘텐츠 페이지로 구성되어 있습니다. 페이지에는 콘텐츠를 포함하고 있으며 보통 질문으로 끝납니다. 각 질문들은 바로가기와 연관되어 있습니다. 바로가기는 이 페이지, 다음 페이지 등 상대적일 수 있으며, 완전학습의 어느 한 페이지를 명시하는 절대적인 경로일 수 있습니다. 분기 표는 목차와 같이 완전학습의 다른 페이지로의 링크를 포함하는 페이지입니다.';
$string['page'] = '페이지: {$a}';
$string['pagecontents'] = '페이지의 내용';
$string['page-mod-lesson-edit'] = '완전학습 페이지 편집';
$string['page-mod-lesson-view'] = '완전학습 페이지를 보기 혹은 미리보기';
$string['page-mod-lesson-x'] = '모든 완전학습 페이지';
$string['pages'] = '페이지들';
$string['pagetitle'] = '페이지 제목';
$string['password'] = '비밀번호';
$string['passwordprotectedlesson'] = '{$a} 는 비밀번호가 있는 학습입니다.';
$string['pleasecheckoneanswer'] = '한 개의 답을 고르십시오';
$string['pleasecheckoneormoreanswers'] = '하나 혹은 그 이상의 답을 고르십시오.';
$string['pleaseenteryouranswerinthebox'] = '상자 안에 답을 입력하십시오.';
$string['pleasematchtheabovepairs'] = '짝을 지어 맞추십시오.';
$string['pluginadministration'] = '완전학습 관리';
$string['pluginname'] = '완전학습';
$string['pointsearned'] = '얻은 점수';
$string['postprocesserror'] = '후처리 과정에서 오류 발생!';
$string['postsuccess'] = '게시 성공';
$string['practice'] = '모의 학습';
$string['practice_help'] = '연습으로 한 완전학습은 성적부에 나타나지 않습니다.';
$string['preprocesserror'] = '선처리 과정에서 오류 발생!';
$string['prerequisitelesson'] = '선수 완전학습';
$string['preview'] = '미리보기';
$string['previewlesson'] = '{$a} 미리보기';
$string['previouspage'] = '앞 페이지';
$string['processerror'] = '처리 과정에서 오류 발생!';
$string['progressbar'] = '진도 막대';
$string['progressbar_help'] = '활성화되면 완전학습 페이지의 아래에 근사적인 완료 백분율을 보여주는 막대가 표시됩니다.';
$string['progressbarteacherwarning'] = '{$a} 에 대해서는 진척상황막대가 표시되지 않음';
$string['progressbarteacherwarning2'] = '본 학습을 편집할 수 있으므로 진척상황막대는 볼 수 없음';
$string['progresscompleted'] = '완전 학습의 {$a}를 완료하였습니다.';
$string['qtype'] = '페이지 유형';
$string['question'] = '질문';
$string['questionoption'] = '질문 옵션';
$string['questiontype'] = '질문 형태';
$string['randombranch'] = '무작위 콘텐츠 페이지';
$string['randompageinbranch'] = '콘텐츠 페이지 내 무작위 질문';
$string['rank'] = '등위';
$string['rawgrade'] = '원 성적';
$string['receivedcredit'] = '이수함';
$string['redisplaypage'] = '페이지 다시 보기';
$string['report'] = '보고';
$string['reports'] = '보고서';
$string['response'] = '반응';
$string['retakesallowed'] = '재시도 허용됨';
$string['retakesallowed_help'] = '활성화되면 학생들은 완전학습을 한번이상 시도할 수 있습니다.';
$string['returnto'] = '{$a}로 돌아가기';
$string['returntocourse'] = '강좌로 돌아가기';
$string['review'] = '검토';
$string['reviewlesson'] = '학습 검토하기';
$string['reviewquestionback'] = '예, 다시하겠습니다.';
$string['reviewquestioncontinue'] = '아니오, 다음 질문으로 넘어가겠습니다.';
$string['sanitycheckfailed'] = '정상감시를 실패하였습니다: 이번 시도는 무효처리 됩니다.';
$string['savechanges'] = '변경사항 저장';
$string['savechangesandeol'] = '모두 저장하고 학습 종료로 가기';
$string['savepage'] = '페이지 저장';
$string['score'] = '점수';
$string['scores'] = '점수들';
$string['secondpluswrong'] = '정확하지 않습니다. 다시 하시겠습니까?';
$string['selectaqtype'] = '질문 유형 선택';
$string['shortanswer'] = '단답';
$string['showanunansweredpage'] = '답하지 않은 페이지 보기';
$string['showanunseenpage'] = '보지 않은 페이지 보기';
$string['singleanswer'] = '단답';
$string['skip'] = '찾아가기 건너뛰기';
$string['slideshow'] = '슬라이드쇼';
$string['slideshowbgcolor'] = '슬라이드쇼 배경색';
$string['slideshowheight'] = '슬라이드쇼 높이';
$string['slideshow_help'] = '활성화되면 완전 학습은 고정된 폭과 높이의 슬라이드쇼로 표시됩니다.';
$string['slideshowwidth'] = '슬라이드쇼 너비';
$string['startlesson'] = '학습 시작하기';
$string['studentattemptlesson'] = '{$a->firstname} {$a->lastname} 의 시도 수 : {$a->attempt}';
$string['studentname'] = '이름 : {$a}';
$string['studentoneminwarning'] = '경고: 학습 종료 시간이 1분 정도 남았습니다.';
$string['studentresponse'] = '{$a} 의 반응';
$string['submit'] = '제출';
$string['submitname'] = '이름 입력';
$string['teacherjumpwarning'] = '이 완전학습에서 {$a->cluster}나 {$a->unseen} 으로의 이동 과정이 사용되고 있습니다. 다음 페이지 이동이 대신 사용될 수 있습니다. 이들 이동을 점검하기 위해서는 학생으로 로그인하십시요.';
$string['teacherongoingwarning'] = '현재 점수는 학생들에게만 보여집니다. 현재 점수를 확인하기 위해서는 학생으로 로그인하십시오.';
$string['teachertimerwarning'] = '타이머는 학생들을 위해서만 작동됩니다. 학생으로 로그인 하여 타이머를 점검하세요.';
$string['thatsthecorrectanswer'] = '올바른 답 입니다.';
$string['thatsthewronganswer'] = '잘못된 답 입니다.';
$string['thefollowingpagesjumptothispage'] = '다음의 페이지에서 이 페이지로 되돌아 오게 됩니다.';
$string['thispage'] = '제자리';
$string['timeremaining'] = '남은 시간';
$string['timespenterror'] = '적어도 {$a} 분간은 학습에 임해야 합니다.';
$string['timespentminutes'] = '소비 시간(분)';
$string['timetaken'] = '시간이 걸렸음';
$string['topscorestitle'] = '상위 {$a} 고득점';
$string['truefalse'] = '참/거짓';
$string['unabledtosavefile'] = '올린 파일을 저장할 수 없음';
$string['unknownqtypesnotimported'] = '지원되지 않는 질문 유형의  {$a} 질문을 가져오지 못 했음';
$string['unseenpageinbranch'] = '콘텐츠 페이지 내 보지 않은 질문';
$string['unsupportedqtype'] = '지원되지 않는 질문 형식 ({$a})!';
$string['updatedpage'] = '업데이트된 페이지';
$string['updatefailed'] = '업데이트 실패';
$string['usemaximum'] = '최대값 사용';
$string['usemean'] = '평균값 사용';
$string['usepassword'] = '암호로 보호된 학습';
$string['usepassword_help'] = '<p>이는 학생들이 지정한 암호를 입력하지 않으면 학습에 접속할 수 없게 하는 것이다.</p>';
$string['viewgrades'] = '성적 보기';
$string['viewhighscores'] = '고득점 목록 보기';
$string['viewreports'] = '{$a->attempts} 회 마친 {$a->student} 의 결과 보기';
$string['viewreports2'] = '완료된 {$a} 시도 보기';
$string['welldone'] = '잘했어요!';
$string['whatdofirst'] = '처음에 무엇을 하길 원합니까?';
$string['wronganswerjump'] = '오답의 경우 이동할 곳';
$string['wronganswerscore'] = '오답에 대한 점수';
$string['wrongresponse'] = '오답에 대한 반응';
$string['xattempts'] = '{$a} 번째 시도';
$string['youhaveseen'] = '당신은 이미 이 학습을 시도한 적이 있습니다.<br /> 도중에 끝마쳤던 부분부터 시작하길 원합니까?';
$string['youmadehighscore'] = '당신은 {$a} 를 고득점 목록에 올렸습니다.';
$string['youranswer'] = '당신의 대답';
$string['yourcurrentgradeis'] = '현재 성적은  {$a} 입니다';
$string['yourcurrentgradeisoutof'] = '현재 성적은 {$a->total} 중 {$a->grade} 입니다.';
$string['youshouldview'] = '당신은 적어도 {$a} 에 답해야만 합니다.';
