<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = '스크린샷 추가';
$string['advertise'] = '이 강좌를 광고해서 사람들이 참여할 수 있도록 하세요';
$string['advertised'] = '광고됨';
$string['advertiseon'] = '{$a} 에 이 강좌 광고';
$string['advertiseonhub'] = '허브에 이 강좌 광고';
$string['advertiseonmoodleorg'] = 'moodle.org에 이 강좌 광고';
$string['advertisepublication_help'] = '커뮤니티 허브 서버에 강좌를 광고해서 사람들이 이 강좌를 찾아서 등록할 수 있도록 하세요.';
$string['all'] = '모두';
$string['allowglobalsearch'] = '이 허브를 공개해서 모든 강좌들을 전세계사람들이 검색할 수 있도록 하세요.';
$string['allowpublicsearch'] = '이 허브를 공개해서 사람들이 참여할 수 있도록 하세요.';
$string['audience'] = '수강자';
$string['audienceadmins'] = '무들 관리자';
$string['audienceeducators'] = '교육자';
$string['audience_help'] = '이 강좌에 참여하고자 하는 수강자를 선택하세요.';
$string['audiencestudents'] = '학생';
$string['badgesnumber'] = '뱃지 수 ({$a})';
$string['badurlformat'] = '잘못된 URL 형식';
$string['cannotsearchcommunity'] = '죄송합니다. 이 페이지를 볼 권한이 없습니다.';
$string['community'] = '커뮤니티';
$string['communityremoved'] = '이 강좌 링크는 목록에서 제거되었습니다.';
$string['confirmregistration'] = '등록 확인';
$string['contactable'] = '일반인들로 부터 연락';
$string['contactable_help'] = '예로 설정하면 허브는 당신의 이메일 주소를 표시할 것입니다.';
$string['contactemail'] = '연락처 이메일';
$string['contactname'] = '담당자 이름';
$string['contactphone'] = '전화';
$string['contactphone_help'] = '전화번호는 허브 관리자에게만 표시되며 공개적으로는 보여지지 않습니다.';
$string['continue'] = '계속';
$string['contributornames'] = '기타 기여자';
$string['contributornames_help'] = '이 항목에  강좌에 기여한 사람들의 이름을 나열할 수 있습니다.';
$string['coursemap'] = '강좌 맵';
$string['coursename'] = '이름';
$string['courseprivate'] = '비공개';
$string['coursepublic'] = '공개';
$string['coursepublished'] = '이 강좌가 \'{$a}\'에 성공적으로 공개되었습니다. ';
$string['courseshortname'] = '짧은 이름';
$string['courseshortname_help'] = '당신 강좌의 짧은 이름을 입력하세요. 유일할 필요는 없습니다.';
$string['coursesnumber'] = '강좌 수 ({$a})';
$string['courseunpublished'] = '강좌 {$a->courseshortname}가 더 이상 {$a->hubname}에 공개되지 않았습니다.';
$string['courseurl'] = '강좌 URL';
$string['courseurl_help'] = '이것은 당신 강좌의 URL입니다. 이 URL은 검색결과에 링크로 표시됩니다.';
$string['creatorname'] = '작성자';
$string['creatorname_help'] = '작성자는 강좌를 만든사람입니다.';
$string['creatornotes'] = '작성자 노트';
$string['creatornotes_help'] = '작성자 노트는 강좌를 사용하는 방법에 대한 선생님들을 위한 가이드입니다.';
$string['deletescreenshots'] = '이 스크린샷을 삭제';
$string['deletescreenshots_help'] = '현재 업로드된 스크린 샷을 모두 삭제';
$string['demourl'] = '데모 URL';
$string['demourl_help'] = '당신 강좌의 데모 URL을 입력하세요. 기본으로 이것은 당신 강좌의 URL입니다. 데모 URL은 검색 결과에서 링크로 표시됩니다.';
$string['description'] = '설명';
$string['description_help'] = '이 설명문이 허브의 강좌 목록에 보여질 것입니다.';
$string['detectednotexistingpublication'] = '{$a->hubname} 는 더 이상 준재하지 않은 강좌를 나열하고 있습니다. 허브 관리자에게 공개 번호 {$a->id}가 더 이상 존재하지 않는다고 알려주십시요.';
$string['downloadable'] = '다운로드 가능';
$string['educationallevel'] = '교육 수준';
$string['educationallevel_help'] = '이 강좌에 맞는 가장 적합한 교육 수준을 선택하세요.';
$string['edulevelassociation'] = '협회';
$string['edulevelcorporate'] = '기업';
$string['edulevelgovernment'] = '정부';
$string['edulevelother'] = '기타';
$string['edulevelprimary'] = '초등';
$string['edulevelsecondary'] = '중등';
$string['eduleveltertiary'] = '고등';
$string['emailalert'] = '이메일통지';
$string['emailalert_help'] = '활성화 되면 허브 관리자는 보안 이슈와 기타 중요한 이슈들에 대해 이메일을 보낼것입니다.';
$string['enrollable'] = '등록가능';
$string['errorbadimageheightwidth'] = '이미지의 최대 크기는 {$a->width} X {$a->height} 입니다.';
$string['errorcourseinfo'] = '허브 ({$a})로부터 강좌 메타데이터를 가져오는데 오류가 발생하였습니다. 추후에 이 페이지를 다시 로드하여 허브에서 강좌 메타데이터를 다시 가져와 보십시요. 그렇지 않으면 다음의 기본 메타데이터를 사용하여 등록과정을 진행할지 결정할 수 있습니다.';
$string['errorcoursepublish'] = '강좌 공개화 ({$a})중에 오류가 발생하였습니다. 다시 시도해 보십시요.';
$string['errorcoursewronglypublished'] = '공개화 오류를 허브가 보내왔습니다. 다시 시도해 보십시요.';
$string['errorcron'] = '"{$a->hubname}" 허브 에서 등록 업데이트 하는 중에 오류가 발생하였습니다. ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = '등록을 업데이트 하기 위해서는 XML-RPC가 활성화 되어야 합니다.';
$string['errorhublisting'] = 'Moodle.org에서 허브 목록을 가져오는데 오류가 발생하였습니다. 다음에 다시 해 보십시요 ({$a})';
$string['errorlangnotrecognized'] = '제공한 언어 코드는 무들이 인식하지 못합니다. {$a}에게 연락하십시요.';
$string['errorregistration'] = '등록 중에 오류가 발생하였습니다. 다음에 다시 시작하십시요. ({$a})';
$string['errorunpublishcourses'] = '예상하지 못한 오류로 인해서 강좌가 허브에서 삭제될 수 없었습니다. 다음에 다시 시도해 보거나(추천) 관리자에게 연락하십시요. ';
$string['existingscreenshotnumber'] = '{$a} 존재하는 스크린 샷. 허브 관리자가 당신 강좌를 활성화 하면 이 페이지에서 이들 스크린 샷을 볼 수 있습니다.';
$string['existingscreenshots'] = '존재하는 스크린샷';
$string['forceunregister'] = '예, 등록 자료를 지웁니다.';
$string['forceunregisterconfirmation'] = '당신의 사이트는 {$a}에 접근할 수 없습니다. 허브가 일시적으로 다운되었을 수 있습니다. 로컬 등록을 제거하고자 하는 것이 아니면 취소하시고 다음에 시도하십시요.';
$string['geolocation'] = '지리적 위치';
$string['geolocation_help'] = '장래에는 지역 기반 검색을 제공할 수도 있습니다. 강좌에 대해 지역을 명시하고자 하면 여기에 위도/경도 값을 입력하십시요. (예 -31.947884,115.871285). 이 값을 찾으려면 구글 맵을 사용하면 됩니다.';
$string['hub'] = '허브';
$string['imageurl'] = '이미지 URL';
$string['imageurl_help'] = '이 이미지는 허브에 게시될 것입니다. 이 이미지는 항상 허브로부터 얻을 수 있어야 합니다. 이미지는 최대 크기 {$a->width} X {$a->height}를 가질 수 있습니다.';
$string['information'] = '정보';
$string['issuedbadgesnumber'] = '발행한 뱃지 수 ({$a})';
$string['language'] = '언어';
$string['language_help'] = '이 강좌의 주언어';
$string['lasttimechecked'] = '체크한 마지막 시간';
$string['licence'] = '저작권';
$string['licence_help'] = '강좌를 배포하고자 하는 저작권을 선택하세요.';
$string['logourl'] = '로고 URL';
$string['modulenumberaverage'] = '평균 강좌 모듈 수 ({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['mustselectsubject'] = '주제를 선택해야 합니다.';
$string['name'] = '이름';
$string['name_help'] = '이 이름이 강좌 목록에 보여질 것입니다.';
$string['neverchecked'] = '체크한 적 없음';
$string['next'] = '다음';
$string['no'] = '없음';
$string['nocheckstatusfromunreghub'] = '사이트가 허브에 등록되지 않아서 상태를 확인할 수 없습니다.';
$string['nohubselected'] = '아무 허브도 선택되지 않았습니다.';
$string['none'] = '없음';
$string['nosearch'] = '허브 혹은 강좌를 공개하지 않습니다.';
$string['notregisteredonhub'] = '강좌를 공개하기 전에 관리자가 사이트를 적어도 한개의 허브에 등록하는 것이 필요합니다. 관리자에게 문의하십시요.';
$string['notregisteredonmoodleorg'] = '관리자가 이 사이트를 moodle.org 에 등록하는 것이 필요합니다.';
$string['operation'] = '행동';
$string['orenterprivatehub'] = '혹은 비공개 허브 URL을 입력하세요';
$string['participantnumberaverage'] = '평균참여자 수 ({$a})';
$string['postaladdress'] = '우편번호';
$string['postaladdress_help'] = '이 사이트의 우편번호 혹은 이 사이트를 운영하는 조직의 우편번호';
$string['postsnumber'] = '게시물 수 ({$a})';
$string['previousregistrationdeleted'] = '이전 등록이 {$a}에서 삭제되었습니다. 등록 프로세스를 다시 시작할 수 있습니다. 감사합니다.';
$string['prioritise'] = '우선순위 정함';
$string['privacy'] = '개인정보보호';
$string['privacy_help'] = '허브는 등록된 사이트 목록을 표시하기를 원할 수도 있습니다. 만일 그렇다면 당신이 그 목록에 나타나기를 원하는지 아닌지 선택할 수 있습니다.';
$string['private'] = '비공개';
$string['privatehuburl'] = '비공개 허브 URL';
$string['publicationinfo'] = '강좌 공개 정보';
$string['publichub'] = '공개 허브';
$string['publishcourse'] = '{$a} 공개';
$string['publishcourseon'] = '{$a} 에 공개';
$string['publishedon'] = '공개일';
$string['publisheremail'] = '공개자 이메일';
$string['publisheremail_help'] = '공개자의 이메일 주소는 허브 관리자가 공개된 강좌에 대한 상태의 변화에 대해 공개자에게 알려주는 것을 가능하게 합니다.';
$string['publishername'] = '공개자';
$string['publishername_help'] = '공개자는 개인이거나 강좌의 공식적 공개자인 조직입니다. 다른 사람을 위해 강좌를 공개하는 것이 아니면 공개자는 당신이 될 것입니다.';
$string['publishon'] = '공개일';
$string['publishonspecifichub'] = '다른 허브에 공개';
$string['questionsnumber'] = '질문 수 ({$a})';
$string['readvertiseon'] = ' {$a}에 홍보 정도를 업데이트';
$string['registeredcourses'] = '등록된 강좌들';
$string['registeredmoodleorg'] = '	
Moodle.org ({$a})';
$string['registeredon'] = '다음에 등록';
$string['registeredsites'] = '등록된 사이트들';
$string['registermoochtips'] = 'Moodle.net에 등록하기 위해서는 Moodle.org  에 등록되어 있어야 합니다.';
$string['registersite'] = '{$a}에 등록';
$string['registerwith'] = '허브에 등록';
$string['registrationconfirmed'] = '사이트 등록이 확인 되었습니다.';
$string['registrationconfirmedon'] = '이제 허브 {$a}에 등록되었습니다. 강좌 관리메뉴의 "공개" 링크를 사용하여 강좌들을 이 허브에 공개할 수 있습니다.';
$string['registrationinfo'] = '등록 정보';
$string['registrationupdated'] = '등록이 업데이트 되었습니다.';
$string['registrationupdatedfailed'] = '등록 업데이트를 실패했습니다.';
$string['removefromhub'] = '허브에서 제거';
$string['renewregistration'] = '등록 갱신';
$string['resourcesnumber'] = '자원의 수 ({$a})';
$string['restartregistration'] = '등록 다시 시작';
$string['roleassignmentsnumber'] = '역할 부여 수 ({$a})';
$string['screenshots'] = '스크린 샷';
$string['screenshots_help'] = '강좌의 스크린 샷이 검색 결과에 표시될 것입니다.';
$string['search'] = '검색';
$string['selecthub'] = '허브 검색';
$string['selecthubforadvertise'] = '홍보할 허브를 선택하세요';
$string['selecthubforsharing'] = '업로드할 허브를 선택하세요';
$string['selecthubinfo'] = '커뮤니티 허브는 강좌들을 나열하는 서버입니다. 이 무들 사이트가 등록된 허브에만 강좌를 공개할 수 있습니다. 원하는 허브가 아래 목록에 없다면 관리자에게 연락하십시요.';
$string['sendfollowinginfo'] = '추가 정보';
$string['sendfollowinginfo_help'] = '다음 정보는 전체 통계를 위해 보내어질 것입니다. 어떤 사이트 목록에서도 공개되지 않습니다.';
$string['sendingcourse'] = '강좌 보내기';
$string['sendingsize'] = '강좌파일이 ({$a->total}Mb)을 올리는 동안 기다려주십시요.';
$string['sent'] = '...완료됨';
$string['settings'] = '설정';
$string['settingsupdated'] = '설정이 업데이트 되었습니다.';
$string['share'] = '사람들이 다운로드 할 수 있도록 강좌를 공유하세요.';
$string['shared'] = '공유됨';
$string['shareon'] = '{$a} 에 강좌를 업로드';
$string['shareonhub'] = '허브에 이 강좌를 업로드';
$string['sharepublication_help'] = '커뮤니티 허브에 이 강좌를 업로드하면 사람들이 다운로드해서 자신들의 무들 사이트에 강좌를 설치할 수 있게 합니다.';
$string['siteadmin'] = '관리자';
$string['siteadmin_help'] = '사이트 관리자의 성명';
$string['sitecountry'] = '국가';
$string['sitecountry_help'] = '당신의 조직이 속해 있는 국가';
$string['sitecreated'] = '사이트가 만들어짐';
$string['sitedesc'] = '설명';
$string['sitedesc_help'] = '당신 사이트의 설명이 사이트 목록에 보여질 수도 있습니다. 평문만을 사용하십시요.';
$string['siteemail'] = '이메일 주소';
$string['siteemail_help'] = '필요하면 허브 관리자가 연락할 수 있도록 이메일 주소를 제공하여야 합니다. 이메일 주소는 다른 목적으로 이용되지 않을 것입니다. 개인적인 이메일 대신 직위와 관련된 이메일 주소(예:sitemanager@example.com)를 입력하는 것을 추천합니다.';
$string['sitegeolocation'] = '지리적 주소';
$string['sitegeolocation_help'] = '장래에는 허브에서 지역 기반 검색을 제공할 수도 있습니다. 사이트에 대해 지역을 명시하고자 하면 여기에 위도/경도 값을 입력하십시요. (예 -31.947884,115.871285). 이 값을 찾으려면 구글 맵을 사용하면 됩니다.';
$string['sitelang'] = '언어';
$string['sitelang_help'] = '당신의 사이트 언어가 사이트 목록에 표시될 것입니다.';
$string['sitename'] = '이름';
$string['sitename_help'] = '허브가 허용한다면 사이트의 이름이 사이트 목록에 보여질 것입니다.';
$string['sitephone'] = '전화';
$string['sitephone_help'] = '당신의 전화번호는 허브관리자에게만 보여집니다.';
$string['siteprivacy'] = '개인정보보호';
$string['siteprivacylinked'] = '사이트 이름을 링크로 공개';
$string['siteprivacynotpublished'] = '이 사이트를 공개하지 마십시요';
$string['siteprivacypublished'] = '사이트 이름만 공개';
$string['siteregconfcomment'] = '당신의 사이트는 {$a}에서 마지막 확인이 필요합니다. ({$a}에 스팸을 피하기 위해)';
$string['siteregistrationcontact'] = '문의 양식';
$string['siteregistrationcontact_help'] = '만일 허용하면 다른 사람들이 허브에 있는 연락 양식을 통해 당신에게 연락할 수 도 있을 것입니다. 그들은 당신의 이메일 주소를 절대로 볼 수 없습니다.';
$string['siteregistrationemail'] = '이메일 통지';
$string['siteregistrationemail_help'] = '이것을 활성화하면 허브 관리자가 보안 이슈와 같은 중요 뉴스에 대해 당신에게 이메일 보낼 수도 있습니다.';
$string['siteregistrationupdated'] = '사이트 등록이 업데이트 되었습니다.';
$string['siterelease'] = '무들 배포판';
$string['siterelease_help'] = '이 사이트의 무들 배포판 번호';
$string['siteupdatedcron'] = '"{$a}"에 사이트 등록이 업데이트 되었습니다.';
$string['siteupdatesend'] = '허브에 등록 업데이트 마침.';
$string['siteupdatesstart'] = '허브에 등록 업데이트 시작 ...';
$string['siteurl'] = '사이트 URL';
$string['siteurl_help'] = 'URL은 이 사이트의 주소입니다. 만일 개인보호정책 설정이 사람들이 사이트 주소를 볼 수 있도록 허용하였다면 이 주소가 사용되는 URL이 될 것입니다.';
$string['siteversion'] = '무들 버전';
$string['siteversion_help'] = '이 사이트의 무들 버전';
$string['specifichubregistrationdetail'] = '당신의 사이트를 다른 커뮤니티 허브에 등록할 수 있습니다.';
$string['statistics'] = '통계 정보보호';
$string['status'] = '허브 목록';
$string['statuspublished'] = '나열됨';
$string['statusunpublished'] = '나열되지 않음';
$string['subject'] = '주제';
$string['subject_help'] = '강좌가 카버하는 주요 주제 영역을 선택하세요.';
$string['tags'] = '태그';
$string['tags_help'] = '태그는 강좌를 추가적으로 분류하고 찾는데 도움이 됩니다. 간단하고 의미있는 단어를 사용하고 단어들을 콤마로 분리하세요. 예: math, algebra, geometry';
$string['trustme'] = '신뢰';
$string['type'] = '광고/공유된';
$string['unknownstatus'] = '알 수 없음';
$string['unlistedurl'] = '목록에 없는 허브 URL';
$string['unprioritise'] = '우선순위 없앰';
$string['unpublish'] = '공개 취소';
$string['unpublishalladvertisedcourses'] = '허브에 광고되고 있는 모든 강좌 삭제';
$string['unpublishalluploadedcourses'] = '허브에 업로드 된 강좌를 모두 삭제';
$string['unpublishconfirmation'] = '"{$a->hubname}" 허브에서 "{$a->courseshortname}" 강좌를 제거하기를 원하십니까?';
$string['unpublishcourse'] = '{$a}를 공개 취소';
$string['unregister'] = '등록취소';
$string['unregisterconfirmation'] = '허브 {$a}에서 사이트를 등록 취소하려고 합니다. 일단 연결이 끊어지면 거기에 남아 있는 강좌를 관리할 수 없습니다. 등록 취소하기를 원하십니까?';
$string['unregisterfrom'] = '{$a} 에서 등록을 취소';
$string['unregistrationerror'] = '사이트가 허브 {$a}에서 등록 취소를 할때 오류가 발생하였습니다.';
$string['untrustme'] = '신뢰되지 않음';
$string['update'] = '업데이트';
$string['updatesite'] = '{$a}에 등록을 업데이트';
$string['updatestatus'] = '지금 확인하세요';
$string['uploaded'] = '업로드됨';
$string['url'] = 'hub URL';
$string['urlalreadyregistered'] = '당신의 사이트는 이미 이 허브에 등록된 것처럼 보이는데 이는 무언가 잘 못되었다는 것을 의미합니다. 허브 관리자에게 문의하여 등록을 리셋시켜서 다시 시도할 수 있도록 하십시요.';
$string['usersnumber'] = '사용자 수 ({$a})';
$string['warning'] = '경고';
$string['wrongtoken'] = '등록이 알 수 없는 이유(네트워크?)로 실패하였습니다. 다시 시작하십시요.';
$string['wrongurlformat'] = '잘못된 URL 포맷';
$string['xmlrpcdisabledcommunity'] = 'XML - RPC 익스텐션이 서버에서 활성화 되지 않았습니다. 강좌를 검색하여 다운받을 수 없습니다.';
$string['xmlrpcdisabledpublish'] = 'XML - RPC 익스텐션이 서버에서 활성화 되지 않았습니다. 강좌를 공개하가니 공개된 강좌를 관리할 수 없습니다.';
$string['xmlrpcdisabledregistration'] = 'XML - RPC 익스텐션이 서버에서 활성화 되지 않았습니다. 활성화 하기 전에는 등록을 취소하거나 업데이트 할 수 없습니다.';
