<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = '접속 거부됨';
$string['accounts'] = '계정';
$string['addcategory'] = '범주 추가';
$string['additionalhtml'] = '추가적인 HTML';
$string['additionalhtml_desc'] = '이 설정은 모든 페이지에 추가하고자 하는 HTML을 명시할 수 있도록 합니다. 페이지의 HEAD 태그안에, BODY 태그가 열린 바로 다음에, 혹은 BODY 태그가 닫히기 직전에 추가될 HTML을 설정할 수 있습니다. <br/> 이렇게 함으로써 모든 페이지에 사용자 맞춤 헤더와 푸터를 추가하거나 Google Analytics 와 같은 서비스에 대한 지원을 매우 쉽게 선택한 테마에 상관없이 추가할 수 있습니다.';
$string['additionalhtmlfooter'] = 'Body 가 닫히기 전에';
$string['additionalhtmlfooter_desc'] = '여기에 있는 콘텐츠는 모든 페이지에서 body 태그가 닫히기 직전에  추가될 것입니다.';
$string['additionalhtmlhead'] = '헤드안에';
$string['additionalhtmlhead_desc'] = '여기에 있는 콘텐츠는 모든 페이지에서 HEAD태그의 아래에  추가될 것입니다.';
$string['additionalhtml_heading'] = '모든 페이지에 추가될 추가 HTML';
$string['additionalhtmltopofbody'] = 'BODY 가 열릴때';
$string['additionalhtmltopofbody_desc'] = '여기에 있는 콘텐츠는 모든 페이지에서 시작 body 태그 다음에  추가될 것입니다.';
$string['admincategory'] = '범주: {$a}';
$string['adminseesall'] = '관리자는 모든 것을 봄';
$string['adminseesallevents'] = '관리자에게 일정 공개';
$string['adminseesownevents'] = '관리자는 일반 사용자와 유사합니다.';
$string['advancedfeatures'] = '추가기능 설정';
$string['allcountrycodes'] = '모든 국가 코드';
$string['allowbeforeblock'] = '허용 IP 우선 처리';
$string['allowbeforeblockdesc'] = '일반적으로 차단 IP 목록이 우선 적용되지만, 이 기능을 켜 놓으면 허용된 IP 목록을 먼저 처리합니다.';
$string['allowblockstodock'] = '블록이 도킹영역을 사용하는 것을 허용';
$string['allowcategorythemes'] = '범주별 테마 허용';
$string['allowcoursethemes'] = '강좌별 테마 허용';
$string['allowediplist'] = '허용된 IP 목록';
$string['allowemailaddresses'] = '허용된 이메일 도메인';
$string['allowframembedding'] = '프레임 임베딩 허용';
$string['allowframembedding_help'] = '이 사이트를 외부 사이트 프레임 안으로 탑재 가능하게 허용. 이 기능을 활성화시키는 것은 보안상 권장하지 않습니다.';
$string['allowguestmymoodle'] = '내 공부방에 손님 접근 허용';
$string['allowobjectembed'] = 'Embed 와 Object 태그 허용';
$string['allowthemechangeonurl'] = '주소지에 있는 테마로 변경 허용';
$string['allowuserblockhiding'] = '블록 감추기 허용';
$string['allowuserswitchrolestheycantassign'] = '역할 부여 능력이 없는 사용자에게 역할을 바꿀수 있도록 허용';
$string['allowuserthemes'] = '개인별 테마 허용';
$string['antivirus'] = '바이러스 방역';
$string['appearance'] = '꾸미기';
$string['aspellpath'] = 'aspell 경로';
$string['authentication'] = '인증';
$string['authpreventaccountcreation'] = '인증시 사용자 계정 생성 방지';
$string['authpreventaccountcreation_help'] = '사용자 인증 시, 아직 계정이 없는 경우에는 자동으로 생성됨. 만일 인증에 LDAP과 같은 외부 데이터베이스가 사용된 경우 기존 계정이 있는 사용자만 사이트에 접속되도록 제한하고 싶은 경우, 이 옵션을 활성화 시킬 것. 이 경우 새 계정을 생성하려면 사용자의 특성을 업로드하거나 수동으로 생성해야 함. 단 엠넷 인증에는 적용되지 않음을 유의할 것.';
$string['authsettings'] = '인증 관리';
$string['autolang'] = '언어 자동 인식';
$string['autologinguests'] = '자동 로그인 손님';
$string['availablelicenses'] = '가능 사용허가 수준';
$string['availableto'] = '사용 대상';
$string['backgroundcolour'] = '투명 색상';
$string['backups'] = '백업';
$string['backup_shortname'] = '백업 파일이름으로 강좌이름 사용';
$string['backup_shortnamehelp'] = '백업 파일명의 일부로서 강좌 식벌번호 대신 강좌명을 사용';
$string['badwordsconfig'] = '금칙어(욕설 등)를 콤마로 구분해 입력하시오';
$string['badwordsdefault'] = '따로 지정한 목록이 없다면, 언어팩에 들어있는 기본 목록을 사용';
$string['badwordslist'] = '금칙어 목록';
$string['blockediplist'] = '차단된 IP 목록';
$string['blockeditingmenu'] = '블록 편집 메뉴';
$string['blockinstances'] = '보기';
$string['blockmultiple'] = '다중';
$string['blockprotect'] = '인스턴스 보호';
$string['blocksettings'] = '블록 관리';
$string['blockunprotect'] = '보호해제';
$string['bloglevel'] = '블로그 가시성';
$string['bookmarkadded'] = '갈무리주소 추가됨';
$string['bookmarkalreadyexists'] = '이 페이지는 이미 갈무리되어 있습니다.';
$string['bookmarkdeleted'] = '갈무리주소 삭제됨';
$string['bookmarkthispage'] = '이 페이지를 갈무리함';
$string['cacheapplication'] = '어플리케이션 캐시';
$string['cacheapplicationhelp'] = '캐시 된 항목은 모든 사용자를 사이에 공유되며 정해진 TTL에 의해 만료됩니다.';
$string['cachejs'] = '자바스크립트 캐쉬';
$string['cachejs_help'] = '자바스크립트 캐쉬 및 압축은 페이지 적재 효율을 향상시킵니다. 상용 사이트에서는 꼭 사용하기 바랍니다. 프로그램 개발자들은 이 기능을 비활성화 하기를 원할 수도 있습니다.';
$string['cacherequest'] = '요청 캐시';
$string['cacherequesthelp'] = '요청이 완료되면 만료되는 사용자 특정 캐시. 정적 스토어를 사용하는 영역을 대치하기 설계되었습니다.';
$string['cachesession'] = '세션 캐시';
$string['cachesessionhelp'] = '사용자 세션이 종료되면 만료되는 사용자 특정 캐시. 세션 블로트/스트레인을 줄이기 위해 설계되었습니다.';
$string['cachesettings'] = '캐시 설정';
$string['cachetext'] = '문서 캐쉬 한계';
$string['caching'] = '캐싱';
$string['calendarexportsalt'] = '일정표 내보내기 암호';
$string['calendarsettings'] = '일정표';
$string['calendartype'] = '달력 유형';
$string['calendar_weekend'] = '주말';
$string['cannotdeletemodfilter'] = '\'{$a->filter}\' 는 \'{$a->module}\' 모듈의 일부분이므로 제거할 수 없습니다.';
$string['cannotuninstall'] = '{$a}는 제거 할 수 없습니다.';
$string['cfgwwwrootslashwarning'] = 'config.php의 $CFG->wwwroot 를 잘못 지정하였습니다. 마지막에\'/\' 문자가 들어있습니다. 이 문자를 제거하지 않으면 <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a> 과 같은 버그가 발생할 것입니다.';
$string['cfgwwwrootwarning'] = 'config.php의 $CFG->wwwroot 를 잘못 지정하였습니다. URL 주소가 맞지 않습니다. 수정하지 않으면 <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a> 과 같은 버그가 발생할 것입니다.';
$string['change'] = '변경';
$string['checkboxno'] = '아니오';
$string['checkboxyes'] = '예';
$string['choosefiletoedit'] = '편집할 파일 선택';
$string['clamfailureonupload'] = '바이러스 검역 실패';
$string['cleanup'] = '정리';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = '오류: "{$a->option}" 에 대한 "{$a->value}" 값이 바르지 않음';
$string['cliincorrectvalueretry'] = '잘못된 값, 재 시도 바람';
$string['clistatusdisabled'] = '상태: 비활성';
$string['clistatusenabled'] = '상태: 활성';
$string['clistatusenabledlater'] = '상태: CLI 유지 보수 모드가 {$a}에서 활성화됩니다';
$string['clitypevalue'] = '유형 값';
$string['clitypevaluedefault'] = '유형에 기본값({$a})을 쓰려면 엔터키를 누르세요';
$string['cliunknowoption'] = '알 수 없는 옵션: {$a}  --help를 사용하기 바람';
$string['cliupgradefinished'] = '명령어 줄 판올림이 성공적으로 완료되었습니다.';
$string['cliupgradenoneed'] = '설치 버전 {$a} 에 대해  업그레이드가 필요하지 않습니다. 감사합니다!';
$string['cliyesnoprompt'] = 'y(예를 의미) 혹은 n(아니오를 의미)을 입력';
$string['commentsperpage'] = '페이지마다 표시될 덧글';
$string['commonfiltersettings'] = '공용 필터 설정';
$string['commonsettings'] = '일반 설정';
$string['componentinstalled'] = '구성요소가 설치되었음';
$string['computedfromlogs'] = '{$a} 이후 기록에서 계산됨';
$string['condifmodeditdefaults'] = '새 활동 생성 시, 기본으로 삼을 값들을 여기에 지정.  또한 고급 기능을 이용해 설정할 활동을 지정할 수 있음.';
$string['confeditorhidebuttons'] = 'HTML 편집기에서 감추고자 하는 버튼을 선택하세요.';
$string['configallcountrycodes'] = '사용자 개인정보 등에서 선택할 수 있는 국가 목록입니다. 빈칸(기본값)으로 두면, 기본 영어 팩에 있는 countries.php에 있는 목록이 사용됩니다. 이는 ISO 3166-1의 목록과 동일하다. 만일 뭔가 쓰려면, \'KR,FR,ES\' 처럼 컴마로 구분해 적으면 됩니다. 만일 새로운 비 표준 코드를 추가하려면, \'en\' 안에 있는 countries.php에 이들을 추가하고 자신의 언어팩에도 이들를 추가해야 할 것입니다.';
$string['configallowassign'] = '왼쪽의 역할이 기표된 각 칼럼의 역할을 부여할 수 있게 허용';
$string['configallowblockstodock'] = '만일 이것이 활성화되어 있고 선택된 테마에 의해 지원이 된다면, 사용자는 특별한 도킹영역으로 블록을 이동시킬 수 있습니다.';
$string['configallowcategorythemes'] = '이것을 활성화하면, 범주 수준에서 테마를 설정할 수 있게 된다. 각각의 하위 범주 혹은 강좌 나름대로 테마를 지정하지 않는 한, 범주 수준에서 설정한 테마가 그 하위에도 적용된다. 경고: 범주 테마 활성화는 성능에 영향을 미칠 수도 있다.';
$string['configallowcoursethemes'] = '이것을 활성화하면, 각 강좌 나름대로 독특한 테마로 설정될 수 있습니다. 강좌 테마는 다른 모든 테마(사이트, 사용자, 또는 세션 테마) 를 덮어쓰게 됩니다.';
$string['configallowemailaddresses'] = '만약 특정 도메인의 이메일 주소만 허용하고자 한다면, 그 주소를 한 칸씩 띄어 적어 놓아라. 그 외 모든 다른 도메인은 거부된다. ( 예: <strong>sun.ac.kr moodle.org</strong> )';
$string['configallowguestmymoodle'] = '활성화되면 손님들은 내 공부방에 접근할 수 있습니다. 그렇지 않은 경우 사이트의 시작페이지로 가게 됩니다.';
$string['configallowobjectembed'] = '기본 보안 조치에 따라, 일반 사용자들은 멀티미디어 파일 (예:플래시,동영상,mp3)을 EMBED, OBJECT 등의 명령어나 태그를 사용해서 올릴 수 없습니다. (비록 안전한 미디어 파일일지라도) 관리자가 허락 옵션을 켜야만 파일을 올릴 수 있습니다.';
$string['configallowoverride'] = '왼쪽 난의 역할을 가진 사람에게 기표된 칼럼의 역할을 덮어쓰기할 수 있도록 허용';
$string['configallowoverride2'] = '왼쪽 열에 있는 역할에 의해 덮어쓰기 될 수 있는 역할들을 선택하십시요.<br />이 설정은 moodle/role:override의 능력을 갖거나 moodle/role:safeoverride의 능력을 갖는 사용자에게만 적용됨을 주목하십시요.';
$string['configallowswitch'] = '이미 지니고 있는 어떤 역활을 교환하려는지 선택하시오. 표에 있는 항목의 경우, 사용자가 역할 교환을 위한 moodle/role:switchroles 능력이 있어야만 합니다.<br />
moodle/course:view 능력만 지닌 역할을 교환할 수 있고, moodle/site:doanything 능력으로는 교환할 수 없기 때문에 표의 일부 영역은 비활성 됨을 주목하기 바랍니다.';
$string['configallowthemechangeonurl'] = '활성화되면, 무들의 주소가 어디라도  theme={themename} 를 이용해서 테마를 바꿀 수 있다.';
$string['configallowuserblockhiding'] = '사용자들이 사이트의 블록을 숨기거나 볼 수 있도록 허용하겠습니까? 이 기능은 접을 수 있는 블록의 상태을 기억하기 위해 자바 스크립트와 쿠키를 사용하며, 사용자 보기에만 영향을 미칩니다.';
$string['configallowuserswitchrolestheycantassign'] = '기본적으로 moodle/role:assign은 사용자들의 역활 교환에 필요하다. 이 설정을 활성화함으로서 이를 충족시키며 또한 결과적으로 "역할 부여 허용"표에서 펼침메뉴로 설정된 "교환할 역할"만을 이용할 수 있게 된다. "역할 부여 허용"표에서는 기존 역할을 능가하는 역활로 빠꾸는 것을 허용하지 않으므로 역할부여 허용 설정을 권장하는 것이다.';
$string['configallowuserthemes'] = '이것을 활성화하면, 사용자는 자신만의 테마를 사용할 수 있게 됩니다. 개인별 테마는 기존의 (강좌 테마가 아닌)사이트 테마를 덮어쓰기 합니다.';
$string['configallusersaresitestudents'] = '이 사이트 시작 페이지 활동에 대하여 모든 사용자가 학생으로 간주되도록 할 것입니까? 만약 "예"라고 설정한다면 승인된 사용자 누구라도 다른 과정에 손쉽게 학생으로 참여할 수 있게 됩니다. 만약 "아니오"를 선택한다면 사용자는 시작 페이지의 특정 과정에만 참여하도록 제한될 것입니다. 이 때는 관리자와 지정된 선생님만이 시작 페이지의 선생님으로서 활동할 수 있습니다.';
$string['configauthenticationplugins'] = '사용하고자 하는 인증 플러그인을 선택하여 우선 순위로 나열하라.';
$string['configautolang'] = '브라우저 설정에서 기본 언어를 검출. 비활성화된 경우 사이트 기본설정이 사용됨';
$string['configautologinguests'] = '어떤 강좌에 방문객이 접속했을 때, 자동적으로 손님자격으로 로그인이 되게 할 것인가?';
$string['configbloglevel'] = '본 설정은 이 사이트에 있는 사용자 블로그를 어느 수준까지 보게 할 것인가를 지정하는 것입니다. 블로그에 게제된 유형 혹은 내용을 지정하는 것이 아니라 Viewer의 최대 영역을 지정한다는 점에 유의하기 바란다. 여러분이 블로그 사용을 꺼려하면 이를 비활성화 시킬 수 있습니다.';
$string['configcachetext'] = '큰 사이트나 문서 필터를 사용하는 사이트라면 이 설정값을 적절히 줌으로서 처리 속도를 빠르게 할 수 있다. 문서는 여기에 지정된 시간 동안 메모리에 저장된다. 실제로 이 값을 너무 작게 설정하면 다소 처리 속도가 늦게 되며, 또 너무 큰 값을 설정해도 입력된 내용(예를 들어, 새로운 링크)을 새로고침하는데 시간이 오래 걸릴 것이다.';
$string['configcalendarcustomexport'] = '달력 날짜 범위 맞춤 내보내기 활성화';
$string['configcalendarexportsalt'] = '이 무작위 문장은 달력을 내보내기 하는데 사용되는 인증토큰의 보안을 증가시키기 위해 사용됩니다. 만일 이 해시 솔트를 변경하면 모든 현재의 토큰이 무효화 됨을 주목하십시요..';
$string['configclamactlikevirus'] = '바이러스 파일로 처리';
$string['configclamdonothing'] = '정상적인 파일로 처리';
$string['configclamfailureonupload'] = '만약 업로드 된 파일을 검사하도록 clam을 구성했는데, 잘 못 설정되거나 알려지지 않은 이유 때문에 오류가 발생한다면, 어떻게 될까? 이 때 만약 \'바이러스 파일로 처리하기\'를 선택한다면 그들은 격리 구역으로 가거나 삭제될 것입니다. 만약 \'정상적인 파일로 처리\'를 선택하면 그 파일은 일반적인 저장고로 이동할 것입니다. 어쨌든 관리자는 이에 대한 경고를 받게 됩니다. 만약 당신이 \'바이러스 파일로 처리\'를 선택했는데, 어떤 이유에서건 실행 오류를 만나게 된다면(대개는 불가능한 경로를 설정했기 때문에 생긴다)업로드 된 모든 파일은 격리된 구역으로 옮겨지거나 삭제 됩니다. 이 설정을 할 때는 매우 조심하십시요.';
$string['configconvertformat'] = '만일 <i>latex</i>, <i>dvips</i> 및 <i>convert</i>를 이용할 수 있다면 이미지들은 지정된 형식을 사용하여 만들어질 것이다. 그렇지 않다면 mimeTeX를 이용하여 GIF로 만들어진다.';
$string['configcookiehttponly'] = 'PHP 5.2.0기능 활성화 - 브라우저가 실제 http의 요청에만 쿠키를 제공해야 하며 스크립트에 의해서는 쿠키를 접속할 수 없어야 한다. 이것은 모든 브라우저를 지원하는 것은 아니며 모든 코드에 완벽히 호환되지는 않을 것이다. 몇 종류의 XSS 공격을 막는데 도움이 된다.';
$string['configcookiesecure'] = '만일 서버가 https 접속만 허용한다면 보안 쿠키 제공 활성화를 권장한다. 만일 이를 활성화 해 놓았다면 웹서버는 http://나 https:// 주소로 우회시킨 설정에 대해서는 접속을 허용하지 않을 것이다. <em>wwwroot</em> 가 https:// 로 시작하지 않는  주소에 대해서는 이 설정은 자동적으로 꺼진다.';
$string['configcountry'] = '만약 여기에 국가를 지정한다면, 지정된 국가는 새로운 사용자계정의 기본값으로 설정된다. 사용자 스스로 국가(언어)를 선택하게 하고 싶으면, 지정하지 말고 그냥 놓아 두십시요.';
$string['configcourseoverviewfilesext'] = '콤마로 분리된 강좌 요약 파일 확장자 목록';
$string['configcourseoverviewfileslimit'] = '강좌 요약에 첨부할 수 있는 최대 파일 수';
$string['configcourserequestnotify'] = '강좌개설 요청이 있을 경우 이를 처리해야 할 관리자 아이디 지정';
$string['configcourserequestnotify2'] = '강좌개설 요청이 있을 경우 이를 처리해야 할 사용자. 강좌 개설을 허용할 수 있는 사용자만 여기에 나열됨.';
$string['configcoursesperpage'] = '강좌 목록에서 페이지당 표시될 강좌의 수를 입력하세요.';
$string['configcronclionly'] = '이것이 설정되면 크론 스크립트는 웹 대신 명령어 줄에서만 실행될 수 있다. 이것은 아래의 크론 암호설정을 덮어쓰기 합니다.';
$string['configcronremotepassword'] = '이것은 cron.php가 아래와 같이 URL에서 제공하는 양식을 이용하여 암호가 제공되지 않으면 웹에서 구동될 수 없다는 것을 의미한다.<pre> http://site.example.com/admin/cron.php?password=opensesame
 </pre> 여기를 비워놓으면 암호를 요구하지 않는다.';
$string['configcurlcache'] = 'cURL 잔존 시간, 초단위';
$string['configcustommenuitems'] = '여기에서 테마에 의해 보여질 사용자 메뉴를 구성할 수 있습니다.
각 줄은 파이프 문자로 구분된 메뉴 문장과 링크 URL(선택사항) 그리고 도구팁(선택사항)으로 구성됩니다. 하이픈을 사용하여 구조를 명시할 수 있습니다.
예::
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org
-Moodle News|http://moodle.org/news
Moodle company
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support
</pre>';
$string['configdbsessions'] = '이를 켜 놓으면, 현재 세션 정보를 저장하기 위해서 데이테베이스를 이용할 것입니다. 이는 특히 큰 사이트나 많은 서버로 구성된 사이트에서 유용하게 쓰일 수 있습니다. 대부분 사이트에서는 이를 막아 놓고 서버 디스크에 세션 정보를 기록하도록 합니다. 만일 지금 이 옵션을 바꾸게 되면, 당신을 포함한 현재 접속된 모든 사용자의 접속이 끊어져 로그아웃될 것입니다. 그리고 MySQL을 사용한다면 my.cnf에 있는 \'max_allowed_packet\'을 최소 4M이상인지를 확인하십시요.';
$string['configdebug'] = '이것을 "예"로 두면 지속적인 경고를 위해서 PHP 오류 보고가 증가할 것이다. 개발자에게나 유용한 기능이다.';
$string['configdebugdisplay'] = '이것을 켜두면 오류보고가 HTML문서로 보여진다. 대체로 실용적이기는 하지만 XHTML, JS, 쿠키 및 HTTP 헤더를 깨지게 한다. 이를 꺼 두면 오류보고는 추후에 디버그 할 수 있도록 서버에 기록으로 남는다. PHP의 error_log로 기록위치를 설정할 수 있다.';
$string['configdebugpageinfo'] = '페이지 하단에 페이지 정보가 표시되게 하려면 활성화 하십시요.';
$string['configdebugsmtp'] = '이메일 발송시의 자세한 오류 내용을 SMTP 서버에게 보내게 함';
$string['configdebugvalidators'] = '페이지의 각주에 외부 검사기 서버에 대한 링크를 원한다면 활성화 하세요, 사용자 이름이 <em>w3cvalidator</em> 인 사용자를 만들고 손님 접속을 활성화하는 것이 필요할 수 있습니다. 이 변경은 서버에 대해 승인 받지 않은 접속을 허용하게 되므로 실제 운영중인 사이트에서는 활성화 하지 마십시요.';
$string['configdefaulthomepage'] = '로그인 사용자를 위한 기본 누리집을 결정합니다. ';
$string['configdefaultrequestcategory'] = '사용자가 요청한 강좌는 자동적으로 이 범주에 속하게 됩니다.';
$string['configdefaultrequestedcategory'] = '승인된 강좌가 수용될 기본 범주';
$string['configdefaultuserroleid'] = '이곳에서 지정한 역할로 모든 사용자에게 사이트 수준의 역할이 부여됩니다. 또한 다른 역할도 부여할 수 있습니다. 기본 역할은 인증된 사용자(구판에서는 손님)입니다. 자신들이 소유한 다른 역할과 상충되지 않게 하고, 모든 사용자가 강좌 수준의 권한(포럼의 게시 및 일정 관리 등)을 넘어서는 권한을 갖지 않게 주의하십시요.';
$string['configdeleteincompleteusers'] = '제시된 날 이후까지 계정 설정을 완료하지 않은 사용자는 자동 삭제됨';
$string['configdeleteunconfirmed'] = '만약 이메일 인증제를 사용한다면, 여기에 설정된 기간내에 사용자들이 확인 응답을 해야합니다. 이 기간이 경과한 후에는 확인 응답을 하지 않은 계정은 삭제됩니다.';
$string['configdenyemailaddresses'] = '같은 방법으로 여기에 있는 특정 도메인 목록의 이메일 주소를 허용하지 않는다. 그 외 모든 다른 도메인들은 허용된다. 예: <strong>hanmail.net yahoo.co.uk<strong/>';
$string['configdisableuserimages'] = '사용자가 개인정보 사진을 임의로 바꾸지 못하게 함';
$string['configdisplayloginfailures'] = '이것은 이전에 로그인에 실패했던 사용자의 정보를 표시할 것이다.';
$string['configdocroot'] = '무들 문서 창고의 경로를 정의합니다. 만일 나름대로의 사용자 온라인 문서를 갖고자 할 경우에는 이를 바꿀 수 있습니다. 그러나 문서 경로가 http://docs.moodle.org 과 같은 형식을 사용하도록 하십시요.';
$string['configdoctonewwindow'] = '만일 이 기능을 활성화 하면, 무들 문서로의 링크가 새 창에서 보여집니다.';
$string['configeditordictionary'] = '이것은 만약 aspell에 사용자가 쓰는 언어의 사전이 없을 때 사용할 값입니다.';
$string['configeditorfontlist'] = '편집기의 펼침 목록에 나타날 글꼴 선택';
$string['configemailchangeconfirmation'] = '사용자가 개인 정보에서 메일 주소를 변경하면 이메일 주소 확인 절차를 요구';
$string['configenableajax'] = '만일 AJAX 기능을 활성화하면 사용자는 자신들의 개인정보에서 이를 비활성화 할 수 있으나, 여기에서 비활성화하면 모든 사람이 AJAX 기능을 쓸 수 없게 됩니다.';
$string['configenableblogs'] = '이 스위치는 모든 사이트 사용자에게 자신만의 블로그를 제공합니다.';
$string['configenablecalendarexport'] = '일정표로 내보냄/작성 활성화';
$string['configenablecomments'] = '덧글 활성화';
$string['configenablecourserequests'] = '이 기능을 켜 놓으면 어느 누구던 강좌를 요청하여 만들 수 있다.';
$string['configenabledevicedetection'] = '테마 및 다른 기능 적용을 위한 모바일, 스마트폰, 타블릿 혹은 기본 기기(데스크탑 pc, 랩탑등) 감지 활성화';
$string['configenablegroupmembersonly'] = '활성화되면 활동에 대한 접근은 모둠 구성원만으로 제한됩니다. 이것은 서버 부하를 증가시킬 수 있습니다, 추가적으로 활동이 모듬 구성원이 아닌 사람들에게는 숨겨지는 방향으로 성적부 범주가 설정되어야 합니다.';
$string['configenablemobilewebservice'] = '공식 무들 앱 혹은 같은 서비스를 사용하는 다른 앱을 사용하려면 모바일 서비스를 활성화 하십시요. 자세한 것은 {$a}를 읽어 보십시요.';
$string['configenablerssfeeds'] = '이 스위치는 무들에서 자료를 RSS 방식으로 내보낼 수 있게 한다. 각 모듈에서 RSS로 내보내려 한다면, 현재 어떤 상황인지를 살펴보고 안되면 관리자 환경설정 아래에 있는 모듈 설정에서 조정하라.';
$string['configenablerssfeedsdisabled'] = '만일 사이트 전체 RSS 피드기능을 막아놓았다면, 이 기능은 이용할 수 없다. 이를 가능하게 하려면 우선 관리자 환경설정 아래에 있는 변수 설정으로 가서 사이트 전체의 설정을 바꾸어야 한다.';
$string['configenablerssfeedsdisabled2'] = 'RSS 피드가 서버 수준에서 비활성화 되어 있습니다. 우선 서버/RSS에서 활성화 할 필요가 있습니다.';
$string['configenablesafebrowserintegration'] = '이것은 퀴즈 설정 양식에서 브라우저 보안 항목에 \'안전 시험 브라우저 필요\' 라는 선택을 추가합니다. 자세한 것은 http://www.safeexambrowser.org/  를 참고하세요.';
$string['configenablestats'] = '여기를 체크해 놓으면 무들의 일정관리 기능은 여러 기록과 통계를 수합할 것이다. 사이트의 부하에 따라 다소 시간이 걸릴 수도 있다. 이 기능을 활성화할 경우, 여러분의 강좌는 물론 사이트 전체에 관련된 여러 그래프와 통계를 볼 수 있다.';
$string['configenabletrusttext'] = '무들은 기본적으로 사용자가 올리는 문서를 철저하게 검색하여 혹시 있을지 모르는 보안에 위해가 되는 악성코드 혹은 동영상 등을 제거합니다. 내용 검증 체계는 신임하는 사용자들이 올리는 내용에 대해서는 간섭하지 않고 향상된 기능을 포함시킬 수 있는 권한을 부여하는 형태로 이루어집니다. 이러한 체계를 가능하게 하려면, 우선 이 설정을 켜고, 내용신임 인증에 대한 특별한 무들 역할을 부여해야 합니다. 이러한 사용자들에 의해 올려지거나 생성되는 문서는 따로 인증표식이 붙어 표시되기 전에 특정 코드가 삭제되지 않을 것입니다.';
$string['configenablewebservices'] = '웹서비스는 다른 시스템이 무들에 로그인해서 특정 작업을 하는 것을 가능하게 합니다. 이 기능을 사용하지 않으면 향상된 보안을 위해 이 기능은 비활성화 되어야 합니다.';
$string['configenablewsdocumentation'] = '웹 서비스 문서 자동 생성 활성화. 사용자는 보안키 페이지 {$a}에서 자신만의 문서에 접근할 수 있습니다. 활성화된 프로토콜에 대한 문서를 보여줍니다.';
$string['configerrorlevel'] = '당신이 알고싶은 PHP경고 수준을 선택하라. 대부분 보통(Normal)이 가장 좋은 선택이다.';
$string['configexportlookahead'] = '내보내기에 포함될 향후 일 수';
$string['configexportlookback'] = '내보내기에 포함될 이전 일 수';
$string['configextendedusernamechars'] = '이 설정을 활성화시켜 놓으면 학생들은 사용자 아이디에 어떤 문자도 쓸 수 있습니다.(학생들의 실제 이름에는 영향을 주지 않습니다) 기본적으로는 비활성화되어 있어 사용자 ID에 영문자소문자와 숫자, 밑줄, 하이픈, 점, 골뱅이를 조합한 것만 허용됩니다.';
$string['configextramemorylimit'] = '검색, 백업/복구 혹은 크론과 같은 일부 스크립트는 좀 더 많은 메모리를 요구합니다. 대형 사이트에서는 좀 더 큰 값을 지정하십시오.';
$string['configfilterall'] = '머릿말, 제목, 찾아가기 막대 등에 포함된 모든 문자열을 필터합니다. 다국어 필터를 사용할 때 유용하지만, 그렇지 않으면 적은 이득을 얻는 대신 사이트에 추가적인 부담만 주게 됩니다.';
$string['configfiltermatchoneperpage'] = '이 자동 링크 필터는 전체 페이지에서 최초 일치하는 내용에만 단 한번 링크를 걸고 나머지는 무시한다.';
$string['configfiltermatchonepertext'] = '이 자동 링크 필터는 페이지의 각 문서 항목(예: 자원 블록 등)에서 첫번째 일치하는 항목에 자동 링크를 시키고 나머지 것들은 모두 무시합니다. 이 설정은 페이지별 필터 설정이 <i>예</i>이면 무시됩니다.';
$string['configfilteruploadedfiles'] = '이 기능을 켜 놓으면 업로드된 모든 웹문서를 화면에 표시하기 전에 검색하나 그 외의 파일은 필터하지 않습니다.';
$string['configforcelogin'] = '일반적으로 사이트의 시작 페이지와 강좌 목록은 로그인 하지 않고도 볼 수 있습니다. 하지만 로그인 하지 않고는 아무 것도 할 수 없게 하려면 이 설정을 켜 놓아야만 합니다.';
$string['configforceloginforprofiles'] = '이 설정은 손님계정이 아닌 실제 계정으로 로그인 해야만 다른 사람의 개인정보를 볼 수 있게 합니다. 이 설정을 비 활성화 한 경우, 사용자가 개인정보에 광고를 게시하거나 부적절한 콘텐츠를 게시해서 전세계사람들이 보게 할 수도 있습니다.';
$string['configfrontpage'] = '위에서 선택된 항목은 사이트 시작 페이지에 표시될 것입니다.';
$string['configfrontpagecourselimit'] = '최대 강좌 수';
$string['configfrontpagecourselimithelp'] = '사이트 시작 화면의 강좌목록에서 보여질 최대 강좌 수';
$string['configfrontpageloggedin'] = '위에서 선택된 항목은 사용자가 로그인한 후 사이트 시작 페이지에 표시될 것입니다.';
$string['configfullnamedisplay'] = '이것은 전체 이름을 표시하는 방법을 정의하는 것이다. 대부분의 한 언어만 쓰는 사이트에서는 기본값인 "성+이름"으로도 충분하지만, 다양한 언어팩을 쓰는 경우 특히 성이나 이름이 매우 긴 경우에는 이름을 보이지 않게 하거나 성을 보이지 않게 설정할 수도 있다.';
$string['configgeoipfile'] = 'GeoIP City의 이진 데이터가 있는 위치. 이 파일은 무들 배포본에 포함된 것이 아니며 <a href="http://www.maxmind.com/">MaxMind</a>에서 개별적으로 얻어야만 하는 것입니다. 상용 정식판을 구매할 수도 있고 공개판을 이용할 수도 있습니다.  <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a>을 내려받아 서버의 "{$a}" 경로에 풀어 넣으면 됩니다.';
$string['configgetremoteaddrconf'] = '리버스 프록시 뒤에 서버가 있으면, 어떤 HTTP 헤더가 원격 IP 주소를 신임해야 할 것인지 지정하기 위해 이 설정을 사용할 수 있다. 헤더는 순서대로 읽혀지며, 우선적으로 사용 가능한 것을 이용한다.';
$string['configgradebookroles'] = '이 설정은 성적부에 표시될 사람을 조정할 수 있게 합니다. 사용자는 최소한 이들 중 하나의 역할이 되어야만 그 강좌의 성적부에 등재될 수 있습니다.';
$string['configgradeexport'] = '성적을 내보낼 때 우선적으로 사용할 성적부 형식을 선택하십시요. 선택된 플러그인이 설정된 후에는 추후 모든 성적의 "최근 내보냄" 항목으로 이용될 것입니다. 예를 들면 내보내기 한 레코드들은 "새로운" 혹은 "새로고침"된 것으로 간주될 것이다. 확신이 들지 않으면 모든 것을 비워 두십시요.';
$string['confighiddenuserfields'] = '선생님과 관리자 이외의 사람들에게는 공개하지 않을 사용자 정보를 선택하십시요. 이렇게 하면 학생들의 프라이버시를 증진시킬 수 있습니다. 여러 항목을 선택할 때는 CTRL키를 누른채 항목들을 선택하면 됩니다.';
$string['configidnumber'] = '이 옵션은 다음의 셋 중에 하나를 선택해야 합니다. (1)사용자 ID번호를 전혀 요구하지 않습니다. (2)사용자 ID번호는 요구하나 빈칸을 허용합니다. (3)사용자 ID번호를 요구하고 빈 칸을 허용하지 않습니다. 만일 사용자 ID번호가 입력되면, 개인정보에 표시됩니다.';
$string['configintro'] = '이 관리 페이지를 통하여 무들 서버가 원할히 작동할 수 있도록 많은 설정 변수들을 지정할 수 있습니다. 너무 염려하지 마십시요 - 대개 기본값으로 제시되어 있는 설정만으로도 잘 작동하며, 설령 지금 당장 설정하지 못한다 하더라도 추후에 이 관리 페이지에서 설정을 바꿀 수도 있습니다.';
$string['configintroadmin'] = '이 페이지를 통해 이 사이트 전반을 완벽하게 통제할 수 있는 주관리자 계정을 설정하여야 합니다. 실제 사용할 수 있는 이메일 주소와 함께 안전한 사용자 ID와 암호를 조심스레 입력하십시요. 나중에 또 다른 관리자 계정을 추가할 수도 있습니다.';
$string['configintrosite'] = '이 페이지에서는 이 사이트의 명칭과 시작 페이지에 대한 설정을 할 수 있습니다. 여러분은 언제라도 다시 홈 페이지의 관리 > 환경설정 > 사이트 설정 항목을 통해 이 곳으로 돌아와 설정을 바꿀 수 있습니다.';
$string['configiplookup'] = '여러 기록에서 (34.12.222.93 같은) IP주소를 클릭하여 IP가 어디에 있는지를 살펴볼 수 있다. 선택할 수 있는 다양한 플러그인이 있는데, 나름대로 일장 일단을 갖고 있다.';
$string['configkeeptagnamecase'] = '태그를 만든 사람이 사용자로 입장할 때, 태그 명칭이 원래 형태대로 유지되도록 하려면 여기를 체크해 놓으십시요.';
$string['configlang'] = '사이트 전체를 위한 기본 언어를 선택하십시요.사용자들은 언어메뉴나 개인정보의 설정을 통해 이 설정을 덮어쓸 수도 있습니다.';
$string['configlanglist'] = '무들에 설치된 언어팩이면 어떤 언어든지 사용자 스스로 선택할 수 있도록 가급적 이 곳을 빈칸으로 놓아 두십시요. 하지만, 사용자들이 선택하는 언어 목록을 제한하고 싶으면 해당하는 언어코드를 쉼표로 분리하여 작성하여 넣으면 됩니다. 예시: ko,en,fr,it';
$string['configlangmenu'] = '누리집과 로그인페이지 등에서 일반적인 목적으로 언어 메뉴를 보이게 할 것인지 말 것인지를 설정하십시요. 이 설정은 사용자들이 개인정보에서 선호하는 언어를 설정하는 능력에는 영향을 미치지 않습니다.';
$string['configlangstringcache'] = '데이터 경로에 컴파일된 파일 형태로 모든 언어의 문자열을 저장. 만일 무들을 번역하는 중이거나 소스 코드의 문자열을 변경시키고자 할 때에는, 이 기능을 꺼 놓을 수 있음. 그렇지 않다면 그냥 두는 편이 성능 상 이득을 볼 수 있음.';
$string['configlatinexcelexport'] = '엑셀로 내보내기 위한 인코딩 선택';
$string['configlocale'] = '사이트 전체의 로케일을 선택해라. 이것은 모든 언어팩의  포맷이나 날짜 언어를 덮어쓰기 할것입니다 .(그럼에도 불구하고 일정표의 요일은 영향받지 않습니다) 여기에 지정한 로케일은 서버에서 지원하도록 해야 합니다.(예: Linux에서 한글 로케일은 ko_KR.UTF-8) 대부분의 경우 이 부분은 공백으로 두는 편이 낫습니다.';
$string['configloginhttps'] = '이 기능을 켜면 https연결을 사용해 암호화된 기법으로 무들의 로그인페이지에 접속할 수 있게 한다. 그리고 로그인 후에는 평소의 웹 접속 방식인 http URL로 되돌아간다.
주의: 이 설정은 웹서버에서 보안모드인 https가 작동할 수 있어야만 한다 - 그렇지 않으면 여러분은 꼼짝달싹할 수 없게 사이트에 갇히게 된다.';
$string['configloglifetime'] = '이것은 용자의 활동 기록을 얼마나 오래 보유할 것인가를 정하는 것입니다. 여기에 표시된 시간보다 오래된 기록은 자동으로 삭제됩니다. 필요하다면 가능한한 오래 유지하는 것이 좋습니다. 하지만 서버의 부하가 많고, 시스템 성능이 낮다면, 기록 보유 기간을 짧게 하는 편이 더 나을지도 모릅니다. 30보다 낮은 값은 통계가 제대로 동작하지 않을 수 있으므로 추천하지 않습니다.';
$string['configlookahead'] = '앞을 내다보고자 하는 날들';
$string['configmaxbytes'] = '이것은 사이트전체에 걸쳐 올릴 수 있는 파일의 최대 크기를 규정합니다. 이 설정은 PHP의 설정변수인  post_max_size와 upload_max_filesize, Apache의 설정변수인  LimitRequestBody에 의해 제한 받습니다.  이 값은 무들 내 각 강좌나 모듈에서 선택할 수 있는 범위를 제한하게 됩니다. 만일 \'서버 한계\'를 선택한다면 서버에 의해 허용된 최대 값이 사용될 것입니다.';
$string['configmaxconsecutiveidentchars'] = '최대 연속된 동일 문자 점검. 점검하지 않으려면 0을 사용';
$string['configmaxeditingtime'] = '이것은 사용자들이 게시한 여러 내용들을 수정할 수 있는 시간을 명시합니다.
일반적으로 30분이 적당합니다.';
$string['configmaxevents'] = '보일 최대 행사';
$string['configmaxusersperpage'] = '강좌, 모둠, 수업집단, 웹서비스등의 사용자 선택기에 표시될 최대 사용자 수';
$string['configmessaging'] = '사이트 사용자 간에 내부 메세지 시스템을 이용할 수 있게 할까요?';
$string['configmessagingallowemailoverride'] = '사용자가 자신의 프로필의 이메일 주소가 아닌 다른 이메일 주소로 이메일  메시지 통지를 받을 수 있도록 허용.';
$string['configmessagingdeletereadnotificationsdelay'] = '읽은 통지는 공간을 절약하기 위해 삭제될 수 있습니다. 통지를 읽은 후 얼마나 지나야 삭제될 수 있습니까?';
$string['configmessaginghidereadnotifications'] = '메세지 이력을 볼 때 포럼 게시글과 같은 읽은 이벤트 통지 감추기';
$string['configminpassworddigits'] = '비밀번호에 최소 여기에 제시된 수만큼의 숫자가 들어 있어야 합니다.';
$string['configminpasswordlength'] = '비밀번호의 길이는 여기에 제시된 글자수 이상이어야 합니다.';
$string['configminpasswordlower'] = '비밀번호에 최소 여기에 제시된 수만큼의 소문자가 들어 있어야 합니다.';
$string['configminpasswordnonalphanum'] = '비밀번호에 최소 여기에 제시된 수만큼의 특수문자가 들어 있어야 합니다.';
$string['configminpasswordupper'] = '비밀번호에 최소 여기에 제시된 수만큼의 대문자가 들어 있어야 합니다.';
$string['configmobilecssurl'] = '모바일 앱 인터페이스를 맞춤화 하기 위한 CSS 파일';
$string['configmodchooserdefault'] = '활동 선택기는 기본적으로 사용자에게 제시되어야 할까요?';
$string['configmycoursesperpage'] = '개인 강좌 목록에 표시할 최대 강좌 수';
$string['configmymoodleredirect'] = '이 설정은 관리자가 아닌 사람이 로그인 할 때 강제적으로 /my 경로로 가게하고 최고 수준 사이트 찾아가기를 /my로 대체합니다.';
$string['configmypagelocked'] = '이 설정은 관리자가 아닌 사람이 기본  페이지를 편집할 수 없게 합니다.';
$string['confignavcourselimit'] = '로그인을 하지 않거나, 등록 강좌가 없는 사용자들에게 제시되는 강좌의 수를 제한';
$string['confignavshowallcourses'] = '이것을 설정하면 사이트에 있는 모든 강좌들이 항상 찾아가기에 나타나도록 합니다.';
$string['confignavshowcategories'] = '찾아가기 막대와 찾아가기 블록에 강좌 범주 표시. 사용자가 등록한 강좌에는 나타나지 않지만 내 강좌들에는 범주없이 나열됩니다.';
$string['confignotifyloginfailures'] = '로그인 실패 기록은 이메일을 통해 통보될 것이다. 누가 이런 통지를 받아야 하는가?';
$string['confignotifyloginthreshold'] = '로그인 실패에 대한 경고를 받는다면, 한 사람 또는 한 IP주소에 의한 로그인 실패 횟수가 얼마나 되야 통지할 필요가 있겠는가?';
$string['confignotloggedinroleid'] = '미등록 사용자들은 사이트의 관점에서 이 역할을 부여받았다고 가정하는 것이다. 손님계정은 언제나 당연히 인정하는 것이지만 그외에도 그 역할을 좀더 확대하거나 축소하길 원할 수도 있다. 게시물을 올린다던가 하는 일들은 여전히 정식으로 사용자가 등록을 해야만 가능하게 해 두어야 할 것이다.';
$string['configopentogoogle'] = '이 설정을 체크해 놓으면 구글은 이 사이트에 손님계정으로 들어올 수 있게 된다. 또한, 구글서치를 통해서 들어오는 사람들도 자동적으로 손님 계정으로 로그인 될 것이다. 이미 손님계정의 방문을 허락한 곳이라면 구글은 아무 제한없이 투명하게 접속시킨다는 점을 유의하라.';
$string['configoverride'] = 'config.php에 정의됨';
$string['configpasswordpolicy'] = '이 기능을 켜 놓으면 암호부여 정책에 따라 사용자의 비밀번호가 유효한지 점검합니다. 암호부여 정책을 규정하기 위해 아래 내용을 설정하시오.(\'아니오\'를 선택하면 무시됩니다)';
$string['configpathtoclam'] = 'clam AV의 경로. 대체로 리눅스 계열에서는 /usr/bin/clamscan 나 /usr/bin/clamdscan 가 될 것이다. clam AV를 실행하기 위해 경로를 정확히 지정해야 한다.';
$string['configpathtodu'] = 'du의 경로. 대개 /usr/bin/du 가 됩니다. 만약 이를 설정해 놓는다면, 이 경로에 있는 내용들이 다른 많은 파일들이 들어있는 경로보다 빠르게 출력될 것입니다.';
$string['configperfdebug'] = '이 기능을 활성화시키면, 표준테마의 경우 맨 아랫단에 성능에 대한 정보가 나타날 것이다.';
$string['configprofileroles'] = '개인정보 및 참여자  페이지에 제공될 역활 목록';
$string['configprofilesforenrolledusersonly'] = '악의적인 사람들의 오용을 막기위해 강좌에 등록하지 않은 사람에게는 개인정보를 비공개합니다. 새 사용자는 개인정보를 작성하기 전에 적어도 하나 이상의 강좌에 등록해야만 합니다.';
$string['configprotectusernames'] = '기본적으로 forget_password.php는 사용자 ID나 이메일 주소를 추측할 수 없게 아무런 단서도 표시하지 않는다.';
$string['configproxybypass'] = '프록시를 우회해야 할 IP나 호스트명을 쉼표로 분리하여 적는다(예:192.168., .mydomain.com)';
$string['configproxyhost'] = '이 <b>서버</b>가 인터넷에 접속하기위해 프록시 컴퓨터를 사용해야한다면, 프록시 호스트명을 이곳에 입력하세요. 아니면 비워 두십시요.';
$string['configproxypassword'] = '어떤 경우에는 프록시를 통해 인터넷에 접속하는데 암호가 필요합니다. 요구하지 않은 경우 공백(PHP cURL 익스텐션이 필요)';
$string['configproxyport'] = '프록시 서버가 필요하다면, 여기에 프록시 포트를 적어 넣어라.';
$string['configproxytype'] = '웹 프록시의 종류(SOCKS5지원을 위해서는 PHP5와 cURL 익스텐션이 필요)';
$string['configproxyuser'] = '어떤 경우 프록시를 통해 인터넷에 접속할 때 사용자 ID가 필요합니다. 필요없을 경우에는 비워 두십시오(PHP cURL 익스텐션이 필요)';
$string['configquarantinedir'] = '만약 clam AV가 감염된 파일을 격리된 디렉토리로 이동시키길 원한다면, 그 경로를 여기에 입력하세요. 그 경로는 반드시 웹서버가 "쓸 수"있어야 합니다.
만약에 이 곳을 비워두거나 기록할 수 없거나 존재하지 않는 디렉토리를 입력한다면, 감염된 파일은 삭제될 것입니다. 경로명을 쓸 때 마지막 슬래쉬는 포함시키면 안됩니다.';
$string['configrecaptchaprivatekey'] = '무들 서버와 recaptcha.net 서버 사이에 통신용으로 쓰이는 문자열. http://recaptcha.net에 접속하여 이 사이트에 쓸 문자열을 얻어 오라.';
$string['configrecaptchapublickey'] = '등록 양식에 reCAPTCHA 요소를 표시하기 위해 쓸 문자열. http://recaptcha.net에서 생성';
$string['configrequestcategoryselection'] = '강좌를 요청할 때 범주를 선택할 수 있습니다.';
$string['configrequestedstudentname'] = '강좌에서 학생을 지칭하는 용어';
$string['configrequestedstudentsname'] = '강좌에서 학생들을 지칭하는 용어';
$string['configrequestedteachername'] = '강좌에서 선생님을 지칭하는 용어';
$string['configrequestedteachersname'] = '강좌에서 선생님들을 지칭하는 용어';
$string['configrequiremodintro'] = '매 활동에 입장할 때 활동 소개를 강제로 보게하고 싶지 않은 경우, 이 선택을 비활성할 것';
$string['configrunclamavonupload'] = '이를 켜 놓으면, clam AV는 업로드되는 모든 파일을 검색할 것이다.';
$string['configrunclamonupload'] = '업로드된 파일에 대해 clam AV로 바이러스 검색을 하겠는가? 이를 위해서는 clam 프로그램의 정확한 경로가 필요할 것이다.
(clam AV는 http://www.clamav.net/로부터 공짜로 제공되는 바이러스 스캐너이다.)';
$string['configsectioninterface'] = '인터페이스';
$string['configsectionmail'] = '메일';
$string['configsectionmaintenance'] = '유지보수';
$string['configsectionmisc'] = '기타';
$string['configsectionoperatingsystem'] = '운영체제';
$string['configsectionpermissions'] = '사용권한';
$string['configsectionrequestedcourse'] = '강좌 개설 요청';
$string['configsectionsecurity'] = '보안';
$string['configsectionstats'] = '통계';
$string['configsectionuser'] = '사용자';
$string['configsecureforms'] = '무들은 웹 폼에서 데이터를 받을 때 추가적인 보안 레벨을 사용할 수 있습니다. 만약 이것을 활성화하면, 브라우저의 HTTP_REFERER 변수는 현재의 form adress와 교차로 확인된다. 매우 드믄 경우이지만, 만약 사용자가 웹 트래픽으로부터 벗어나기 위해 HTTP_REFERER를 제거하도록 설정한 방화벽을 사용할 경우 문제를 야기할 수 있습니다. 그 증상은 폼에 갇혀 버리는 것이다. 예를들어 만약 사용자들이 로그인하는데 문제를 가지고 있다면, 사이트를 brute-force password 공격에 더 노출 시킬지라도, 이 설정을 꺼 둘 수 있습니다. 자신이 없으면, \'예\'로 놓으십시요.';
$string['configsessioncookie'] = '이 설정은 무들세션을 위해 사용하는 쿠기의 이름을 지정하는 것이다. 이것은 선택적이고, 같은 웹사이트에서 하나 이상의 무들 프로그램이 구동되어 쿠키의 혼동이 생길 우려가 있을 때만 유용하다.';
$string['configsessioncookiedomain'] = '이는 무들 쿠키를 활용할 수 있는 도메인을 변경할 수 있게 한다. 이것은 여타 서브도메인의 웹 응용프로그램과 무들 세션의 정보를 공유해야 할 무들의 최적화(예를들어 인증 혹은 등록 플러그인)에 유용하게 활용될 수 있다.
<strong>경고: 기본설정(비어있음)으로 놓아둘 것을 강력히 권고한다 - 잘못된 설정은 사이트 접속을 차단하는 결과를 낳는다.</strong>';
$string['configsessioncookiepath'] = '브라우저가 무들 쿠키를 전송하는 위치를 변경하려면 이 곳에 특정 디렉토리를 설정하면 된다. 그냥 두면 기본값인 \'/\'로 설정된다.';
$string['configsessiontimeout'] = '사이트에 로그인한 사람이 오랫동안 아무 일도 안하고 시간을 허비한다면, 일정 시간 후에 자동적으로 로그아웃 된다(세션 종료). 이 변수는 이 시간의 길이를 규정한다.';
$string['configshowcommentscount'] = '덧글 수를 보여 줌. 덧글의 링크를 보여줄 때마다 하나 이상의 쿼리가 발생';
$string['configshowicalsource'] = 'iCal의 이벤트에 대한 소스 정보를 표시합니다';
$string['configshowsiteparticipantslist'] = '사이트 참여자 목록에는 사이트의 모든 학생과 선생님 명단이 표시됩니다. 이 사이트 참여자의 목록을 볼 수 있도록 허용될 사람은 누구입니까?';
$string['configsitedefaultlicense'] = '사이트 기본 사용허가';
$string['configsitedefaultlicensehelp'] = '이 사이트에 있는 콘텐츠 공개를 위한 기본 사용허가
';
$string['configsitemaxcategorydepth'] = '최대 범주의 깊이';
$string['configsitemaxcategorydepthhelp'] = '이것은 범주나 콤보 목록을 표시할때 확장되는 하위 범주의 최대 깊이를 지정합니다. 더 깊은 수준의 범주는 링크로 표시되며 AJAX요청으로 확장할 수 있습니다.';
$string['configslasharguments'] = '파일들은 \'슬래쉬 아규먼트\'를 사용하는 스크립트를 통해서 제공됩니다. 이 방법은 파일들이 웹 브라우저나 프록시 서버등에서 훨씬 쉽게 저장되도록 합니다. 불행하게도 어떤 PHP서버들은 이 방법을 허용하지 않습니다. 만약 업로드된 파일이나 이미지를 보는데 문제가 있다면, 이 설정을 비활성화 하십시요.';
$string['configsmartpix'] = '이를 켜 놓으면, 아이콘은 PHP 스크립트를 통해 현재의 테마, 상위 테마, 그리고 무들의 /pix 경로에서 검색되어 제공된다. 이는 테마 안에 중복된 이미지가 있을 때 좋지만 다소 성능에 무리를 준다.';
$string['configstartwday'] = '한 주의 첫 요일';
$string['configstatsfirstrun'] = '여기에서 cron이 통계를 처리한 후 얼마나 오랫동안 기록을 보유하고 있어야 할지를 지정한다. 만일 매우 접속이 많거나 서버를 임대해 쓰는 경우는, 통계처리에 걸리는 시간도 길고 부하도 많이 걸리기 때문에 기록을 오래 유지시키는 일은 바람직하지 않다.(여기에서는 1 month = 28 days로 설정했고, 그래프와 보고에서는 1 month = 1 calendar month로 했음에 유의하라)';
$string['configstatsmaxruntime'] = '통계 처리과정은 부하가 매우 많이 걸리기 때문에 언제 시작하고 얼마나 유지할지를 이 항목과 다음 항목에서 지정해 주어야 한다.';
$string['configstatsmaxruntime2'] = '통계 처리는 매우 집중적일 수 있기 때문에, 하루의 통계를 처리하는데 있어 허용할 수 있는 최대 시간을 지정합니다. 한번의 cron 실행으로 처리할 수 있는 최대 날 수는 31일입니다.';
$string['configstatsmaxruntime3'] = '통계처리시 서버에 상당한 부하가 걸린다는 점을 염두에 두고, 통계 처리에 허용할 최대 시간을 지정한다. cron을 통해 처리할 최대 날 수는 아래에서 지정할 수 있다.';
$string['configstatsruntimedays'] = '매 통계 처리 수행시 수행할 최대 날 수를 지정합니다. 통계가 최신일 때는 하루만  처리될 것입니다. 크론의 실행 시간을 단축시키고 싶다면, 서버의 부하를 감안하여 이 값을 조절하십시요.';
$string['configstatsruntimestart'] = '언제 통계 처리를 하는 cronjob을 <b>시작</b>시켜야 하는가? 같은 서버에 여러개의 무들이 설치된 경우 다른 시간을 명시하십시요.';
$string['configstatsuserthreshold'] = '이 설정은 강좌가 통계 계산에 포함되기 위한 등록된 사용자의 최소 수를 명시합니다.';
$string['configstrictformsrequired'] = '활성화되면 사용자가 양식의 필수 항목에 공백이나 줄바꿈 만을 입력하는 것을 방지할 수 있습니다.';
$string['configstripalltitletags'] = '활동이나 자원 이름에 HTML 태그를 사용하는 것을 허용하려면 체크표시를 해제하십시오.';
$string['configsupportemail'] = '이 이메일 주소는 새 계정을 신청한 사용자가 일반적인 도움말이 필요할 경우 반송 주소로 공개될 것입니다. 이 이메일 주소를 입력하지 않은 경우에는 사용할 수 있는 이메일 주소는 제공되지 않습니다.';
$string['configsupportname'] = '이는 보조 이메일이나 웹주소를 통해 일반적인 도움말을 제공할 때 쓰여지는 이름입니다.';
$string['configsupportpage'] = '이 웹 주소는 새 계정을 신청한 사용자가 일반적인 도움말이 필요할 경우 접속 주소로 공개될 것입니다. 이 웹 주소를 입력하지 않은 경우에는 접속할 수 있는 링크가 제공되지 않습니다.';
$string['configthemedesignermode'] = '보통 모든 테마의 이미지와 스타일시트는 성능향상을 위해 브라우저와 서버에 오랫동안 캐시됩니다. 만일 테마를 디자인하거나 코드를 개발하는 경우 캐시된 버전을 제공받지 않도록 하기 위해 이 모드를 동작시키기를 원할 수도 있습니다. 경고: 이렇게 하면 모든 사용자들에게 사이트가 느려집니다. 다른 방법으로 테마 선택 페이지에서 테마 캐시를 수동으로 리셋시킬 수 있습니다.';
$string['configthemelist'] = '다양한 테마를 사용하게 하려면 이 부분을 빈칸을 남겨두십시요. 만약 테마 메뉴를 짧게하길 원한다면, 여기에 콤마로 분리된 목록 이름을 명시할 수 있습니다. (공백을 사용하지 마십시요) 예: standard,orangewhite';
$string['configtimezone'] = '여기에서 표준시간대를 선택합니다. 이것은 단지 기본값으로 쓸 표준시간대이며, 각 사용자는 개인정보 난에서 그들 자신에 맞는 설정을 따로 할 수가 있습니다. 이곳의 "서버 지역시간대"는 서버 전반에 적용되는 기준 시간으로 무들의 기본값인데, 사용자 개인정보에 있는 시간대와는 별도입니다. Cronjob은 이 시간을 기준으로 작동합니다.';
$string['configuseblogassociations'] = '사용자들이 강좌 및 강좌 모듈의 항목을 연합해서 자신들의 블로그를 쓸 수 있게 할까요? ';
$string['configuseexternalyui'] = '로컬 파일을 사용하는 대신 Yahoo 서버에서 온라인으로 제공하는 파일을 사용하세요. 주의: 인터넷 연결이 필요합니다. 그렇지 않으면 AJAX가 동작하지 않을 것입니다.';
$string['configuserquota'] = '사용자가 자신의 영역에 저장할 수 있는 파일의 최대 용량. {$a->bytes} bytes == {$a->displaysize}';
$string['configusetags'] = '사이트 전반에 걸쳐 태그 기능을 활성화할 필요가 있을까요?';
$string['configvariables'] = '변수';
$string['configverifychangedemail'] = '허용 혹은 거부된 도메인을 이용하여 바뀐 이메일 주소를 검증. 이 설정이 비활성화되어 있을 경우 새 사용자에게만 도메인 검증이 이루어짐';
$string['configvisiblecourses'] = '숨겨진 범주의 강좌 표시';
$string['configwarning'] = '설정값을 조심해서 변경하시오 - 잘못된 값이 문제를 일으킬 수 있습니다.';
$string['configyuicomboloading'] = '이 옵션은 YUI 라이브러리에 대해 결합된 파일 로딩 최적화를 활성화시킵니다. 성능상의 이유로 이 설정은 실제 운영하는 사이트에서 활성화되어야 합니다.';
$string['confirmation'] = '확정';
$string['confirmdeletecomments'] = '정말, 덧글을 삭제하시겠습니까? ';
$string['confirmed'] = '확인됨';
$string['convertformat'] = '출력 형식 <i>변환</i>';
$string['cookiehttponly'] = 'http 쿠키만';
$string['cookiesecure'] = '보안 쿠키만';
$string['country'] = '기본 국가';
$string['coursecontact'] = '강좌 관리자';
$string['coursecontact_desc'] = '여기에서는 강좌 소개에 표시하고 싶은 사람을 설정할 수 있게 한다. 기표된 역할이 주어진 사용자는 강좌 설명에 이름이 제시됩니다.';
$string['courselistshortnames'] = '확장된 강좌 이름 표시';
$string['coursemgmt'] = '추가/편집';
$string['courseoverview'] = '강좌 개요';
$string['courserequestnotify'] = '개설 요청 알림';
$string['courserequestnotifyemail'] = '{$a->link} 에서 {$a->user} 가 새 강좌 개설 요청';
$string['courserequests'] = '강좌 요청';
$string['courserequestspending'] = '강좌 개설 보류중';
$string['courses'] = '강좌';
$string['coursesperpage'] = '한 페이지당 강좌 수';
$string['courseswithsummarieslimit'] = '요약 제한이 있는 강좌';
$string['creatornewroleid'] = '새 강좌 생성자의 역할';
$string['creatornewroleid_help'] = '사용자가 새 강좌를 관리할 권한을 가지지 않았다면 사용자는 이 역활을 사용하여 자동으로 등록될 수 있습니다.';
$string['cron'] = '크론';
$string['cronclionly'] = '명령어 줄에서만 크론 실행';
$string['cronerrorclionly'] = '죄송합니다. 이  페이지는 관리자에 의하여 인터넷 접속을 금하도록 설정되었습니다.';
$string['cronerrorpassword'] = '죄송합니다. 이  페이지에 접속하려면 적절한 암호가 있어야 합니다.';
$string['cron_help'] = 'cron.php 유지 스크립트는 새롭게 작성된 포럼 게시글을 이메일로 보내는 것처럼 무들 모듈이 정해진 시간마다 작업을 수행하는 것을 도와줍니다. 스크립트를 예를 들어 5분마다 실행시키는 메카니즘이 필요합니다.';
$string['cronremotepassword'] = '크론 비밀번호';
$string['cronwarning'] = '<a href="cron.php">cron.php 관리 스크립트</a>가 최소 24시간 동안 작동되지 않았습니다.';
$string['ctyperecommended'] = '사이트가 비 라틴계열의 언어를 사용한다면 사이트의 성능 향상을 위해 추가적인 ctype PHP 확장자 설치를 강력히 권고합니다.';
$string['ctyperequired'] = '다국어 호환 기능 및 사이트의 성능 향상을 위해 이제부터 무들은 ctype의 PHP 확장자를 요구합니다.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = '무들 네트웍 기능을 활성화하기 위해서는 추가적인 cURL 라이브러리를 설치할 것을 강력히 권고한다.';
$string['curlrequired'] = '무들 저장소와 교신하기 위해서는 cURL PHP 익스텐션이 필요합니다.';
$string['curltimeoutkbitrate'] = 'cURL 타임아웃을 계산하는데 사용할 비트레이트  (Kbps)';
$string['curltimeoutkbitrate_help'] = '이 설정은 많은 cURL 요청시 적절한 타임아웃 시간을 계산하기 위해 사용됩니다. 이 계산에서 콘텐츠의 크기를 알기 위해 HTTP DEAD 요청이 이루어집니다. 이 값을 0으로 하면 이 요청이 되어지는 것을 비활성화 시킵니다.';
$string['currenttheme'] = '현재 테마';
$string['customcheck'] = '다른 점검들';
$string['custommenu'] = '맞춤 목록';
$string['custommenuitems'] = '맞춤 목록 항목';
$string['datarootsecurityerror'] = '<p><strong>보안 경고!</strong></p><p>자료 경로가 잘못되어 웹에 누출되었습니다. 이는 이곳의 모든 파일을 전세계 어느 누구라도 사용할 수 있으며, 어떤 것들은 크래커에 의해 사이트에 불법으로 접속할 수 있는 단서를 제공할 수 있습니다!</p>
<p>따라서  <em>반드시</em> 자료 경로 ({$a})를 공개적인 웹으로는 접속할 수 없는 새 장소로 옮겨야 할 뿐만 아니라, config.php안의 <code>$CFG->dataroot</code> 설정을 고쳐야 합니다.</p>';
$string['datarootsecuritywarning'] = '사이트가 안전해 보이지 않습니다. 데이터경로 ({$a})를 직접 웹으로 접속할 수 없도록 조치하기 바랍니다.';
$string['dbmigrate'] = '무들 데이터베이스 이전';
$string['dbmigrateconnecerror'] = '지정한 데이터 베이스에 연결할 수 없습니다.';
$string['dbmigrateencodingerror'] = '데이터베이스 인코드를 {$a} 보다는 UNICODE/UTF8으로 쓰기 바랍니다.<br />다시 지정하기기 바랍니다.';
$string['dbmigratepostgres'] = '데이터베이스 서버로 PostgreSQL를 사용하는 것 같습니다. 이전을 원활히 하기위해서는 수동으로 "UNICODE"(PostgreSQL 7) 혹은 "UTF8" (PostgreSQL 8) 코드로 맞추어 새로운 데이터베이스를 만들어 저장해야 합니다. 계속하려면 아래에 있는 새로운 데이터베이스 연결 설정을 입력하시기 바랍니다.';
$string['dbmigratewarning'] = '이 과정을 시작하기 전에 무들 데이터베이스를 백업하여 두었는지 확인하기 바랍니다. 어떻게 해야할지 잘 모르겠으면 시스템관리자에게 문의하십시오. 마이그레이션이 시작되면 여러분의 무들 사이트는 관리모드로 전환되어 버릴 것입니다.';
$string['dbmigratewarning2'] = '<b>경고 : 데이터베이스 이전과정을 시작하려 합니다. 다시 한번 무들의 데이터베이스를 백업해 두었는지 확인하기 바랍니다.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">본 데이터베이스는 새로운 UTF8 코드로 변경되었습니다. config.php를 편집한 후, 새 데이터베이스를 사용하여 무들을 사용하기 바랍니다.</font>';
$string['dbmigrationdupfailed'] = '오류: <font color="#ff0000"><pre>{$a}</pre></font> 때문에 데이터베이스 복제 실패.';
$string['dbsessions'] = '데이터베이스 사용';
$string['debug'] = '디버그 메세지';
$string['debugall'] = '모두: 모든 합리적 PHP 디버그 메세지를 보여줌';
$string['debugdeveloper'] = '개발자: 개발자를 위한 추가적인 디버그 메세지';
$string['debugdisplay'] = '디버그 메시지 표시';
$string['debugging'] = '오류 보고';
$string['debugminimal'] = '최소: 치명적인 오류만 보여주기';
$string['debugnone'] = '없음: 어떤 오류 내용도 보여주지 않음';
$string['debugnormal'] = '보통: 오류와 경고 및 알림을 보여주기';
$string['debugpageinfo'] = '웹페이지 정보 표시';
$string['debugsmtp'] = '이메일 발송 디버그';
$string['debugstringids'] = '기본 문자열 표시';
$string['debugvalidators'] = '유효한 연결고리 표시';
$string['defaultcity'] = '기본 도시';
$string['defaultcity_help'] = '여기에 입력되는 도시는 새로운 사용자 계정을 만들때 기본으로 사용됩니다.';
$string['defaulthomepage'] = '사용자 기본 누리집';
$string['defaultrequestcategory'] = '개설할 강좌의 기본 범주';
$string['defaultsettinginfo'] = '기본: {$a}';
$string['defaultuserroleid'] = '모든 사용자에 대한 기본 역할';
$string['deleteincompleteusers'] = '미설정 사용자 삭제 기한';
$string['deleteunconfirmed'] = '인증 유예 기간';
$string['deleteuser'] = '사용자 삭제';
$string['density'] = '밀도';
$string['denyemailaddresses'] = '거부할 이메일 도메인';
$string['development'] = '개발';
$string['devicedetectregex'] = '기기 검출 정규 표현식';
$string['devicedetectregex_desc'] = '기본적으로 무들은 디바이스를 구분할 수 있습니다. 기본적으로는 데스크탑 컴퓨터, 노트북 등으로 인식하지만 모바일기기(휴대전화, 기타 모바일기기), 태블릿(아이패드, 안드로이드 태블릿), 지금은 잘 사용하고 있지 않은 (IE6를 지원하는)기기도 구분이 됩니다. 이 테마선택기능은 이러한 기기들에 특성에 맞춰 각각 적용될 수 있습니다. 특정 이름을 사용해서 특정 기기만을 위해 테마가 적용될 수도 있는데 이럴 경우 기본적으로 인식되는 기기보다 우선권을 갖습니다. 예를 들어 \'/(MIDP-1.0|Maemo|Windows CE)/\' 이런 표현을 사용하게 되면 흔히 사용되는 피쳐폰이라고 인식하고 \'featurephone\'이라고 결과값을 보내줍니다. 이렇게 해서\' featurephone\'이라는 테마가 추가되어 이들 기기에는 이 테마가 적용되는 되도록 할 수 있습니다. 다른 폰은 이것과 관계없이 특정 모바일 디바이스로 인식되어 테마가 별도 적용됩니다.';
$string['devicedetectregexexpression'] = '정규 표현';
$string['devicedetectregexvalue'] = '반환 값';
$string['devicetype'] = '기기 유형';
$string['disableuserimages'] = '사용자 개인 사진 비활성화';
$string['displayerrorswarning'] = '상용 사이트에서는 오류 메세지를 통하여 서버의 민감한 정보가 누출될 우려가 있기 때문에 PHP의 <em>display_errors</em> 설정을 추천하지 않습니다.';
$string['displayloginfailures'] = '로그인 실패 보여주기';
$string['dndallowtextandlinks'] = '택스트와 링크들을 드래그 드롭으로 업로드';
$string['docroot'] = '무들 문서창고 경로';
$string['doctonewwindow'] = '새 창에서 열기';
$string['download'] = '내려받기';
$string['edithelpdocs'] = '도움 문서 편집';
$string['editingnoncorelangfile'] = '추가된 모듈/플러그인의 번역내용을 변경하려고 하고 있습니다. 표준 모듈이 아닌 것은 맞춤문자열(_local) 경로에만 저장할 수 있습니다. 모듈의 lang 경로에 번역내용을 넣고 싶으면, 그 모듈을 만든 원 저작자에게 보내시면 됩니다.';
$string['editlang'] = '<b>언어팩 편집</b>';
$string['editorbackgroundcolor'] = '배경색';
$string['editordictionary'] = '편집기 사전';
$string['editorfontfamily'] = '폰트 패밀리';
$string['editorfontlist'] = '글꼴 목록';
$string['editorfontsize'] = '글꼴 크기';
$string['editorhidebuttons'] = '숨길 편집 버튼';
$string['editorkillword'] = '워드 형식 필터';
$string['editorspelling'] = '편집기 철자법';
$string['editorspellinghelp'] = '철자 검사의 활성/비활성. 이를 활성화해 놓으려면 반드시 서버에 <strong>aspell</strong>이 탑재되어 있어야 합니다.';
$string['editstrings'] = '문자열 편집';
$string['emailchangeconfirmation'] = '이메일 주소 검증';
$string['emoticonalt'] = '대체 텍스트';
$string['emoticoncomponent'] = '이미지 구성요소';
$string['emoticonimagename'] = '이미지 이름';
$string['emoticons'] = '이모티콘';
$string['emoticons_desc'] = '이 양식은 사이트에 사용하는 이모티콘을 정의합니다. 테이블에서 행을 제거하고자 하면 필요한 필드에 빈 값으로 양식을 저장하십시요. 새 이모티콘을 등록하려면 마지막 행에 필드를 채우십시요. 모든 필드를 기본 값으로 리셋시키려면 위의 링크를 따라 가십시요.

* 텍스트(필수) - 이 문장이 이모티콘 이미지로 대치 됩니다. 최소 2글자 이상이어야 합니다.
* 이미지 이름(필수) - 확장자 없는 이모티콘 이미지 파일 이름. 구성요소 pix 폴더에 상대적 경로
* 이미지 구성요소(필수) - 아이콘을 제공하는 구성요소
* 대체문장(선택) - 문자열 식별자와 이모티콘에 대한 대체문장의 구성요소';
$string['emoticonsreset'] = '이모티콘 설정을 기본 값으로 리셋';
$string['emoticontext'] = '텍스트';
$string['emptysettingvalue'] = '비어있음';
$string['enableajax'] = 'AJAX 활성화';
$string['enableblogs'] = '블로그 활성화';
$string['enablecalendarexport'] = '일정표로 내보내기 활성화';
$string['enablecomments'] = '덧글 활성화';
$string['enablecourserequests'] = '강좌 개설 가능';
$string['enablecssoptimiser'] = 'CSS 최적기 활성화';
$string['enabled'] = '활성화 됨';
$string['enabledevicedetection'] = '기기 감지 활성화';
$string['enablegravatar'] = '그라바타 활성화';
$string['enablegroupmembersonly'] = '모둠구성원에게 개방';
$string['enablemobilewebservice'] = '모바일 웹서비스 활성화';
$string['enablerecordcache'] = '레코드 캐시 활성화';
$string['enablerssfeeds'] = 'RSS 피드 활성화';
$string['enablesafebrowserintegration'] = '안전 시험 브라우저 통합 활성화';
$string['enablestats'] = '통계 활성화';
$string['enabletrusttext'] = '신뢰된 내용 활성화';
$string['enablewebservices'] = '웹서비스 활성화';
$string['enablewsdocumentation'] = '웹서비스 문서';
$string['enrolinstancedefaults'] = '등록 인스턴스 기본 설정';
$string['enrolinstancedefaults_desc'] = '새 강좌에 대한 기본 등록 설정';
$string['enrolmultipleusers'] = '사용자 등록';
$string['environment'] = '환경';
$string['environmenterrortodo'] = '이 무들버전을 설치하기 전에 앞에서 발견된 모든 환경설정 문제(오류)를 해결해야 합니다!';
$string['environmenterrorupgrade'] = '경고: 이 무들판의 업그레이드를 계속하기 전에 위에 제시된 모든 환경 문제(오류)를 해결해야만 합니다. 이러한 요구사항을 수정하지 않은 채로 판올림을 하게되면 자료를 잃게 되는 등의 문제에 봉착하게 됩니다. 그래도 판올림을 계속 하겠습니까?';
$string['environmentmustfixsetting'] = 'PHP 설정을 바꾸어야만 함';
$string['environmentok'] = '서버 환경이 모든 최소한의 요구사항을 충족시킴';
$string['environmentrecommendcustomcheck'] = '만일 이 검사에 실패한다면 잠재적인 문제를 지니고 있는 것임';
$string['environmentrecommendinstall'] = '설치하거나 활성화할 것을 권고함';
$string['environmentrecommendversion'] = '{$a->needed} 버전을 권장하고 있는 데 현재 {$a->current} 을 사용하고 있음';
$string['environmentrequirecustomcheck'] = '반드시 통과해야 함';
$string['environmentrequireinstall'] = '설치하거나 활성화해야만 함';
$string['environmentrequireversion'] = '{$a->needed} 버전이 요구되는 데, 현재 {$a->current} 이 구동되고 있음';
$string['environmentsettingok'] = '필수설정 점검통과';
$string['environmentshouldfixsetting'] = 'PHP 설정이 변경되어야만 함';
$string['environmentxmlerror'] = '환경 설정 데이터 불러들이기 오류 ({$a->error_code})';
$string['errordeletingconfig'] = '플러그인 \'{$a}\' 설정기록 삭제 중 오류 발생';
$string['errorsetting'] = '설정을 저장할 수 없음:';
$string['errorwithsettings'] = '오류때문에 설정을 바꿀 수 없음.';
$string['everyonewhocan'] = '\'{$a}\' 권한을 지닌 모든 사람';
$string['exceptions'] = '예외';
$string['execpathnotallowed'] = 'config.php 에서  실행 경로 설정 비활성화';
$string['experimental'] = '시험적임';
$string['experimentalsettings'] = '시험적 설정';
$string['extendedusernamechars'] = '아이디에 확장 문자 허용';
$string['extramemorylimit'] = '별도 PHP 메모리 한계';
$string['fatalmagicquotesruntime'] = '<p>심각한 설정오류가 발견되었으므로 서버 관리자에게 알려주시기 바랍니다.<p/><p>무들을 원활하게 작동시키기 위해 현재의 PHP 설정을 바꿔야만 합니다.<p/><p> <code>magic_quotes_runtime</code>은 반드시 <code>off</code>으로 설정되어 있어야만 합니다.<p/><p>이러한 설정은 <code>php.ini</code>를 수정하여 바꿀 수도 있고, Apache/IIS 의 설정 혹은  <code>.htaccess</code> 파일을 수정해도 바꿀 수 있습니다.</p>';
$string['fatalsessionautostart'] = '<p>심각한 설정오류가 발견되었으므로 서버 관리자에게 알려주시기 바랍니다.<p/><p>무들을 원활하게 작동시키기 위해 현재의 PHP 설정을 바꿔야만 합니다.<p/><p> <code>session.auto_start</code>는 반드시 <code>off</code>으로 설정되어 있어야만 합니다.<p/><p>이러한 설정은 <code>php.ini</code>를 수정하여 바꿀 수도 있고, Apache/IIS 의 설정 혹은  <code>.htaccess</code> 파일을 수정해도 바꿀 수 있습니다.</p>';
$string['filecreated'] = '새 파일 생성됨';
$string['filestoredin'] = '다음 경로에 저장 :';
$string['filestoredinhelp'] = '파일이 저장될 곳';
$string['filterall'] = '모든 문자열을 필터링';
$string['filtermatchoneperpage'] = '한  페이지에 한 번만 필터 적용';
$string['filtermatchonepertext'] = '한 텍스트에 한 번만 필터 적용';
$string['filters'] = '필터';
$string['filtersettings'] = '필터 설정';
$string['filtersettingsgeneral'] = '일반적인 필터 설정';
$string['filteruploadedfiles'] = '업로드된 파일 필터링';
$string['forcelogin'] = '강제로 로그인하게 함';
$string['forceloginforprofileimage'] = '사용자 사진을 보기 위해서는 로그인하도록 함.';
$string['forceloginforprofiles'] = '개인정보 열람시 로그인';
$string['forcetimezone'] = '특정 표준시 강요';
$string['frontpage'] = '시작 페이지';
$string['frontpagebackup'] = '시작 페이지 백업';
$string['frontpagedefaultrole'] = '기본 시작 페이지 역할';
$string['frontpagefilters'] = '시작 페이지 필터';
$string['frontpageloggedin'] = '로그인 후 시작 페이지 항목';
$string['frontpageoverrides'] = '시작 페이지 사용권한 덮어쓰기';
$string['frontpagequestions'] = '시작 페이지 퀴즈';
$string['frontpagerestore'] = '시작 페이지 복원';
$string['frontpageroles'] = '시작 페이지 역할';
$string['frontpagesettings'] = '시작 페이지 설정';
$string['fullnamedisplay'] = '전체 이름 형식';
$string['gdrecommended'] = 'GD 확장은 이미지의 변환에 이용되므로 만일 이를 누락하게 되면 개인정보의 사진을 표시하는 등의 기능을 사용하지 못하게 될 것입니다.';
$string['gdrequired'] = 'GD 익스텐션은 무들에서 이미지 변환에 필요합니다.';
$string['generalsettings'] = '일반 설정';
$string['geoipfile'] = 'GeoIP City 자료 파일';
$string['getremoteaddrconf'] = '기록된 IP 주소 원본';
$string['globalswarning'] = '<p><strong>보안 경고</strong></p><p>무들이 바르게 작동하기 위해서는, 현재의 일부 PHP설정을 바꿔야 합니다.<p/><p><em>반드시</em>  <code>register_globals=off</code>로 설정해야 합니다.</p><p> 이는 <code>php.ini</code>나 Apache/IIS의  <code>.htaccess</code> 파일의 변수를 조정하면 됩니다.</p>';
$string['googlemapkey3'] = '구글맵 API V3 키';
$string['gotofirst'] = '빠진 첫번째 문자열로 가기';
$string['gradebook'] = '성적부';
$string['gradebookroles'] = '채점되는 역할';
$string['gradeexport'] = '1차 성적 전송 방법';
$string['gravatardefaulturl'] = '그라바타 기본 이미지 URL';
$string['groupenrolmentkeypolicy'] = '모둠 등록키 정책';
$string['groupenrolmentkeypolicy_desc'] = '이 기능을 켜 놓으면, 무들은 유효한 비밀번호 작성 정책에 비추어 모둠의 등록키가 작성되었는지를 점검하게 된다.';
$string['guestroleid'] = '손님계정 역할';
$string['guestroleid_help'] = '이 역할은 자동적으로 손님 사용자에게 부여됩니다. 또한 손님 등록 플러그인을 통해 강좌에 입장한 비등록 사용자에게도 일시적으로 부여됩니다.';
$string['helpadminseesall'] = '관리자가 모든 일정을 볼 수 있거나 그 이벤트들 스스로 적용됩니까?';
$string['helpforcetimezone'] = '모든 사용자에게 각자 자신의 표준시간대를 선택할 수 있게 하거나, 지정한 시간대를 쓰도록 강요할 수 있습니다.';
$string['helpsitemaintenance'] = '판올림 및 기타 작업';
$string['helpstartofweek'] = '달력에서 한 주는 무슨 요일에 시작됩니까?';
$string['helpupcominglookahead'] = '일정표에서 다가오는 행사를 며칠 전부터 보여지게 할까요?';
$string['helpupcomingmaxevents'] = '얼마나 많은(최대) 행사를 보여지게 할까요?';
$string['helpweekenddays'] = '주중 어느 날이 "주말"로 취급되어져 다른 색깔로 표시되어집니까?';
$string['hiddenuserfields'] = '사용자 항목 감춤';
$string['hidefromall'] = '모두에게 감춤';
$string['hidefromnone'] = '아무에게도 감추지  않음';
$string['hidefromstudents'] = '학생에게 감춤';
$string['htmleditor'] = '웹 편집기';
$string['htmleditorsettings'] = 'HTML 편집기 설정';
$string['htmlsettings'] = 'HTML 설정';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP 보안';
$string['hubs'] = '허브';
$string['iconvrecommended'] = '당신의 사이트가 라틴언어계열이 아닌 언어를 지원하는 경우, 사이트의 성능을 향상시키기 위해서는 ICONV라이브러리를 설치할 것을 권장합니다.';
$string['iconvrequired'] = 'ICONV라이브러리 설치 필수';
$string['ignore'] = '무시';
$string['includemoduleuserdata'] = '모듈 사용자 데이터 포함';
$string['incompatibleblocks'] = '호환되지 않는 블록';
$string['installhijacked'] = '설치과정은 원래의 IP 주소에서 마칠 수 있어야만 합니다.';
$string['installsessionerror'] = 'PHP 세션을 시작할 수 없습니다. 브라우저가 쿠키를 허용하는지 확인하기 바랍니다.';
$string['intlrecommended'] = 'Intl 익스텐션은 지역화에 따른 정렬등 국제화 지원을 향상시키는데 사용합니다.';
$string['invalidsection'] = '잘못된 영역';
$string['invaliduserchangeme'] = '"changeme"는 예약된 사용자 아이디입니다. 이 이름으로는 계정을 만들 수 없습니다.';
$string['ipblocked'] = '현재 이 사이트는 사용할 수 없습니다.';
$string['ipblocker'] = 'IP 제한';
$string['ipblockersyntax'] = '한 줄에 한 항목만 입력하세요. 유효한 입력은 단일 호스트에  대응하는 전체 IP주소 (<b>192.168.10.1</b>와 같이) 이거나 일부분만 일치하는 부분적인 주소 ( <b>192.168.</b>와 같이) 혹은 CIDR 표기방법 (<b>231.54.211.0/20</b>와 같이); 혹은 주소의 마지막 부분에 범위가 있는 IP 주소 범위 (such as <b>231.3.56.10-20</b>와 같이) 입니다.  문장형식으로 된 도메인 이름 (\'example.com\' 와 같이)는 지원되지 않습니다. 빈 줄은 무시됩니다.';
$string['iplookup'] = 'IP 주소 열람';
$string['iplookupinfo'] = '기본적으로 무들은 IP 주소의 위치를 찾기위해 무료 NetGeo (The Internet Geographic Database) 서버를 이용하지만, 안타깝게도 더이상 정상적으로 유지되지 않고 <em>대제적으로 부정확한</em> 자료를 회신합니다. 따라서 MaxMind의 공개 GeoLite City 데이터베이스 사본을 설치할 것을 권합니다.<br />IP 주소의 위치는 단순한 지도나 구글맵을 이용하여 표시될 수 있습니다. 이를 이용하기 위해서는 구글 계정과 구글맵에 제대로 표시하기 위한 공개 구글맵 API 암호를 적용해 주어야 합니다.';
$string['iplookupmaxmindnote'] = '이 제품은 MaxMind(<a href="http://www.maxmind.com/">http://www.maxmind.com/</a>)의 의해 제작된 GeoLite의 자료를 포함하고 있습니다.';
$string['keeptagnamecase'] = '태그 명칭 유지';
$string['lang'] = '초기 설정 언어';
$string['langcache'] = '언어 메뉴 캐쉬';
$string['langcache_desc'] = '언어메뉴 캐시. 활성화되면 사용가능한 번역 목록이 캐시됩니다. 캐시는 내장된 언어 팩 관리 도구를 통하여 언어팩을 설치하거나 삭제할때 자동으로 새로고침됩니다. 만일 수동으로 언어팩을 설치하는 경우 캐시된 목록을 새로고침하기 위해 모든 캐시 기능을 청소해야 합니다.';
$string['langlist'] = '선택목록의 언어';
$string['langmenu'] = '언어 선택 메뉴';
$string['langpackwillbeupdated'] = '노트: 판올림 중에 무들은 선택된 언어팩을 판올림할 것입니다.';
$string['langstringcache'] = '모든 언어 문자열 캐쉬';
$string['languagesettings'] = '언어 설정';
$string['latexpreamble'] = 'LaTeX 전문';
$string['latexsettings'] = 'LaTeX 표현 설정';
$string['latinexcelexport'] = '엑셀 인코딩';
$string['legacyfilesinnewcourses'] = '새 강좌에서 예전 강좌 파일들';
$string['legacyfilesinnewcourses_help'] = '기본적으로 예전 파일 영역은 업그레이드된 강좌에만 있습니다. 단일 활동 백업 및 복구 같은 기능은 이 설정과 부합되지 않습니다.';
$string['licensesettings'] = '사용허가 설정';
$string['linkadmincategories'] = '관리자 범주 링크';
$string['loading'] = '탑재 중';
$string['localetext'] = '전역 로케일';
$string['localstringcustomization'] = '맞춤 문자열';
$string['location'] = '지역';
$string['locationsettings'] = '표준시 설정';
$string['locked'] = '잠김';
$string['lockoutduration'] = '계정 잠금 기간';
$string['lockoutduration_desc'] = '잠겨진 계정은 자동으로 이 기간 이후에 잠금 해제됩니다.';
$string['lockoutemailsubject'] = '{$a}에 있는 계정이 잠겨져 있습니다.';
$string['lockouterrorunlock'] = '잘못된 계정 잠금해제 정보가 제공되었습니다.';
$string['lockoutthreshold'] = '계정 잠금 임계 값';
$string['lockoutwindow'] = '계정 잠금 관찰 윈도우';
$string['log'] = '접속 기록';
$string['logguests'] = '손님 접속을 기록하기';
$string['logguests_help'] = '이 설정은 손님 계정이나 로그인 하지 않은 사용자에 의한 활동에 대한 기록을 활성화 합니다. 높은 프로필의 사이트는 성능 이유로 기록을 비활성화하기를 원할 수도 있습니다. 실제 운영중인 사이트는 이 설정을 활성화하는 것을 추천합니다.';
$string['loginhttps'] = 'HTTPS 로그인 사용';
$string['loginpageautofocus'] = '로그인 페이지 양식 자동 초점';
$string['loginpageautofocus_help'] = '이 옵션을 활성화하면 로그인 페이지의 사용성을 증가시키지만 자동으로 항목에 촛점이 가도록 하는 것은 접근성 문제로 생각될 수 있습니다.';
$string['loginpasswordautocomplete'] = '로그인 양식에서 암호 자동완성 차단';
$string['loglifetime'] = '기록 보유 시간';
$string['longtimewarning'] = '<b>이 과정은 꽤 시간이 소요됨을 염두에 두시기 바랍니다.</b>';
$string['maintenancemode'] = '유지관리 모드';
$string['maintenancemodeisscheduled'] = '사이트가 {$a}분 후에 유지모드로 변경됩니다.';
$string['maintfileopenerror'] = '유지 관리 파일 열기 오류';
$string['maintinprogress'] = '유지 관리 진행 중...';
$string['manageformats'] = '강좌 포맷 관리';
$string['manageformatsgotosettings'] = '{$a}에서 기본 포맷이 변경될 수 있습니다.';
$string['managelang'] = '언어팩 관리';
$string['managelicenses'] = '사용허가 관리';
$string['manageqbehaviours'] = '질문 진행방식 관리';
$string['manageqtypes'] = '질문 유형 관리';
$string['maturity100'] = '베타';
$string['maturity150'] = '배포 후보';
$string['maturity200'] = '안정 버전';
$string['maturity50'] = '알파';
$string['maturityallowunstable'] = '힌트: 이 스크립트를 --allow-unstable 옵션을 사용하여 실행할 수도 있습니다.';
$string['maturitycoreinfo'] = '사이트가 현재 불안정한 "{$a}" 개발 코드를 사용하고 있습니다.';
$string['maturitycorewarning'] = '설치하거나 업그레이드 하고자 하는 무들 버전은 대부분의 정식 사이트에서 사용하는데 적절하지 못한 불안정한 "{$a}" 개발 코드들을 포함하고 있습니다. 이것이 원하는 것이 아니라면 무들코드의 안정한 브랜치로부터 업데이트 하도록 하십시요. 자세한 사항은 무들 문서를 참고하십시요.';
$string['maxbytes'] = '올릴 파일의 최대 크기';
$string['maxconsecutiveidentchars'] = '최대 연속 동일문자';
$string['maxeditingtime'] = '게시물 수정 최대 시한';
$string['maxusersperpage'] = '페이지당 최대 사용자';
$string['mbstringrecommended'] = '당신의 사이트가 라틴언어계열이 아닌 언어를 지원하는 경우, 사이트의 성능을 향상시키기 위해서 MBSTRING 라이브러리 설치를 권장합니다.';
$string['mediapluginavi'] = 'avi 필터 사용';
$string['mediapluginflv'] = 'flv 필터 사용';
$string['mediapluginimg'] = '이미지 자동 탑재';
$string['mediapluginmov'] = 'mov 필터 사용';
$string['mediapluginmp3'] = 'mp3 필터 사용';
$string['mediapluginmpg'] = 'mpg 필터 사용';
$string['mediapluginogg'] = '.ogg 필터활성화';
$string['mediapluginogv'] = '.ogv 필터활성화';
$string['mediapluginram'] = 'ram 필터 사용';
$string['mediapluginrm'] = 'rm 필터 사용';
$string['mediapluginrpm'] = 'rpm 필터 사용';
$string['mediapluginswf'] = 'swf 필터 사용';
$string['mediapluginswfnote'] = '보안 문제 때문에 일반 사용자의 swf플래시 파일 전송은 허용되지 않습니다.';
$string['mediapluginwmv'] = 'wmv 필터 사용';
$string['mediapluginyoutube'] = '유튜브 연결 활성화';
$string['messaging'] = '내부 메시지 발송 가능';
$string['messagingallowemailoverride'] = '통지 이메일 덮어쓰기';
$string['messagingdeletereadnotificationsdelay'] = '읽은 통지 삭제';
$string['messaginghidereadnotifications'] = '읽은 통지 감추기';
$string['minpassworddigits'] = '숫자';
$string['minpasswordlength'] = '암호의 최소 길이';
$string['minpasswordlower'] = '소문자';
$string['minpasswordnonalphanum'] = '특수문자';
$string['minpasswordupper'] = '대문자';
$string['misc'] = '기타';
$string['mnetrestore_extusers'] = '<strong>참고:</strong>이 백업파일에는 진행과정 중 복원될 수 있는 무들네트웍의 원격 사용자 계정 정보가 포함되어 있습니다.';
$string['mnetrestore_extusers_admin'] = '<strong>주의:</strong> 본 백업 파일은 다른 곳의 무들에서 작성되었으며, 원격 무들네트웍 사용자 계정이 포함되어 있습니다. 복원과정에서 생성되어 있는 사용자에 대한 무들네트웍을 점검할 것입니다. 이상이 있는 사용자에 대해서는 (무들네트웍 대신) 자동적으로 내부 인증을 거치도록 할 것입니다. 이에 대한 사항은 복원 기록에 남길 것입니다.';
$string['mnetrestore_extusers_mismatch'] = '<strong>참고:</strong> 이 백업파일은 현재와는 다른 무들 설정을 기반으로 작성되었고 복구에 실패할 지도 모르는 무들네트웍의 원격 사용자 계정 정보가 들어 있습니다. 만일 이것이 현재의 무들 설정을 기반으로 작성되었다고 확신하거나, 필요한 무들네트웍 설정이 완벽하다고 믿는다면, 복구를 시도할 수도 있을 것입니다.';
$string['mnetrestore_extusers_noadmin'] = '<strong>주의:</strong> 본 백업 파일은 다른 곳의 무들에서 작성되었으며, 원격 무들네트웍 사용자 계정이 포함되어 있습니다. 당신은 이러한 유형의 복원 처리를 할 권한이 없습니다. 사이트 관려자에게 문의하거나, 사용자 정보 (모듈, 파일 등)을 제외하고 강좌를 복원하십시오.';
$string['mnetrestore_extusers_switchuserauth'] = '원격( {$a->mnethosturl} )무들네트웍의 사용자 {$a->username} 를 본 사이트의 인증된 사용자 {$a->auth} 로 전환';
$string['mobile'] = '모바일';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = '활동 선택기 기본';
$string['modeditdefaults'] = '활동 설정의 기본 값';
$string['modeditingmenu'] = '활동 편집 메뉴';
$string['modsettings'] = '활동 관리';
$string['modulesecurity'] = '모듈 보안';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = '강제로 예전의 다중언어 문법 사용: &lt;span&gt; without the class="multilang" and &lt;lang&gt;';
$string['mustenablestats'] = '아직 통계수집을 하도록 설정하지 않았습니다.';
$string['mycoursesperpage'] = '강좌의 수';
$string['mydashboard'] = '시스템 기본 상황페이지';
$string['mymoodle'] = '내 공부방';
$string['mymoodleredirect'] = '내 공부방 강제 개설';
$string['mypage'] = '내 공부방 페이지';
$string['mypagelocked'] = '기본 페이지 잠김';
$string['myprofile'] = '기본 개인정보 페이지';
$string['mysql416bypassed'] = '사이트가 iso-8859-1 (라틴) 언어만을 사용하는 경우 현재 설치된 MySQL 4.1.12(혹은 그 이상 버전)를 사용할 수 있습니다.';
$string['mysql416required'] = '모든 데이터가 향후 UTF-8로 변환될 수 있도록 하기위해서는 MySQL 4.1.16 이상 버전이 무들 1.6버전에 필요합니다.';
$string['navadduserpostslinks'] = '사용자의 게시글을 보기 위한 링크 추가';
$string['navcourselimit'] = '강좌 한계';
$string['navigationupgrade'] = '이 업그레이드는 기존의 관리, 강좌, 활동 및 참여자를 위한 블록을 대치할  두 개의 새로운 찾아가기 블록을 도입합니다. 이들 블록에 대한 특정 권한을 설정했을 경우, 다시 한 번 모든 기능들이 제대로 작동하는지 점검해야 합니다.';
$string['navshowallcourses'] = '모든 강좌 공개';
$string['navshowcategories'] = '강좌 범주 공개';
$string['navshowfrontpagemods'] = '찾아가기에 초기 페이지 활동 보여주기';
$string['navshowfrontpagemods_help'] = '활성화되면 시작페이지 활동들이 사이트 페이지들 아래에 있는 찾아가기에 표시됩니다.';
$string['navshowfullcoursenames'] = '강좌 전체 이름 보여주기';
$string['navshowfullcoursenames_help'] = '활성화되면 찾아가기에 있는 강좌들이 단축이름 대신 전체이름으로 표시됩니다.';
$string['navshowmycoursecategories'] = '내 강좌 범주 보여주기';
$string['navsortmycoursessort'] = '내 강좌 정렬';
$string['neverdeleteruns'] = '실행을 삭제하지 마십시요.';
$string['nobookmarksforuser'] = '갈무리된 주소가 없음';
$string['nodatabase'] = '데이터베이스 없음';
$string['nohttpsformobilewarning'] = '유효한 인증서와 HTTPS를 활성화하는 것을 추천합니다. 무들 어플리케이션은 항상 보안 접속을 우선 사용하도록 시도할 것 입니다.';
$string['nomissingstrings'] = '빠진 문자열 없음';
$string['nonewsettings'] = '이번 판올림과정에서 새로운 설정이 추가되지 않았습니다.';
$string['nonexistentbookmark'] = '요청한 곳을 찾을 수 없습니다.';
$string['noresults'] = '검색 결과 없음.';
$string['noroles'] = '역할 없음';
$string['notifications'] = '통지';
$string['notifyloginfailures'] = '로그인실패를 통지받을 사람';
$string['notifyloginthreshold'] = '이메일 알림을 위한 문턱값';
$string['notloggedinroleid'] = '방문자 역할';
$string['numberofmissingstrings'] = '{$a} 개의 문자열 번역안됨';
$string['numberofstrings'] = '전체 문자열 수: {$a->strings}<br />빠진 문자열: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = '추가적인 OpenSSL 라이브러리를 설치할 것을 강력히 권고함 -- 무들 네트웍 기능을 이용할 수 있게 됨';
$string['opentogoogle'] = 'Google에 개방';
$string['optionalmaintenancemessage'] = '선택적인 유지 보수 메세지';
$string['order1'] = '첫번째';
$string['order2'] = '두번째';
$string['order3'] = '세번째';
$string['order4'] = '네번째';
$string['passwordpolicy'] = '암호부여 정책';
$string['pathconvert'] = '<i>convert</i> 실행파일 경로';
$string['pathdvips'] = '<i>dvips</i> 실행파일 경로';
$string['pathlatex'] = 'LaTeX 실행파일 경로';
$string['pathtoclam'] = 'clam AV 경로';
$string['pathtodot'] = 'dot 경로';
$string['pathtodot_help'] = 'dot 경로. 아마도 /usr/bin/dot. DOT 파일로부터 그래픽을 만들 수 있으려면, dot 실행파일을 설치하고 여기서 그것을 지시해야 합니다. 지금은 무들에 내장된 프로파일링 기능(개발->프로파일링)에 의해서만 사용됨을 주목하십시요.';
$string['pathtodu'] = 'du 경로';
$string['pathtopgdump'] = 'pg_dump  경로';
$string['pathtopgdumpdesc'] = '시스템에 한개 이상의 pg_dump가 있을 경우(예를 들어 postgresql 버전을 여러 개 설치한 경우)에만 필요함';
$string['pathtopgdumpinvalid'] = 'pg_dump의 잘못된 경로- 경로가 잘못되었거나 실행파일이 아님';
$string['pathtopsql'] = 'psql  경로';
$string['pathtopsqldesc'] = '시스템에 한개 이상의 psql이 있을 경우에(예를 들어 postgresql 버전이 여러개 설치된 경우)만 필요합니다.';
$string['pathtopsqlinvalid'] = 'psql의 잘못된 경로- 경로가 잘못되었거나 실행파일이 아님';
$string['perfdebug'] = '성능 정보';
$string['performance'] = '성능';
$string['pgcluster'] = 'PostgreSQL 클러스터';
$string['pgclusterdescription'] = '명령어 라인 실행을 위한 PostgreSQL 버전/클러스터 파라메터. 만일 한개의 postgresql만이 설치되어 있다거나 잘 모를 경우에는 공백으로 남겨놓으십시요.';
$string['php50restricted'] = 'PHP 5.0.x 는 약간의 버그가 보고되었습니다. 5.1.x로 판올림 하던가, 아니면 4.3.x 혹은 4.4.x로 바꿔주기 바랍니다.';
$string['php533warning'] = 'PHP 5.3.3  이상의 버전을 권장합니다.';
$string['phpfloatproblem'] = '예상밖의 PHP 부동소숫점 처리 문제 검출 - {$a}';
$string['pleaserefreshregistration'] = '이 사이트는 moodle.org에 등록되어 있습니다. {$a} 에 업데이트 이후 상당한 변화가 있었다면 등록 업데이트를 고려해 보기 바랍니다.';
$string['pleaseregister'] = '이 버튼을 제거하고 싶으면 당신의 사이트를 등록해 주세요.';
$string['plugin'] = '플러그인';
$string['plugins'] = '플러그인';
$string['pluginscheck'] = '플러그인 의존성 체크';
$string['pluginscheckfailed'] = '{$a->pluginslist}에 대해 의존성 점검이 실패하였습니다.';
$string['pluginsoverview'] = '플러그인 개요';
$string['profilecategory'] = '개인정보 목록';
$string['profilecategoryname'] = '개인정보 목록명(유일해야 함)';
$string['profilecategorynamenotunique'] = '이 목록명은 이미 사용 중임';
$string['profilecommonsettings'] = '일반 설정';
$string['profileconfirmcategorydeletion'] = '상위 범주(혹은 최상위 범주의 아래)로 이동하게 될 {$a} 개의 항목이 범주 안에 있습니다.<br />그래도 이 범주를 삭제하겠습니까?';
$string['profileconfirmfielddeletion'] = '삭제 될 {$a} 개의 사용자 기록이 이 항목에 있습니다.<br />그래도 이 항목을 삭제하겠습니까?';
$string['profilecreatecategory'] = '개인정보 범주 생성';
$string['profilecreatefield'] = '개인정보 항목 생성:';
$string['profilecreatenewcategory'] = '개인정보 범주 만들기';
$string['profilecreatenewfield'] = '새로운 "{$a}" 개인정보 항목 만들기';
$string['profiledefaultcategory'] = '기타 항목';
$string['profiledefaultchecked'] = '기본사항 점검 완료';
$string['profiledefaultdata'] = '기본값';
$string['profiledeletecategory'] = '범주 삭제';
$string['profiledeletefield'] = '항목 삭제';
$string['profiledescription'] = '항목의 설명';
$string['profiledscript'] = '이 스크립트는 프로파일되었습니다.';
$string['profiledscriptview'] = '이 스크립트에 대한 프로파일 정보를 보기';
$string['profileeditcategory'] = '{$a} 범주 편집';
$string['profileeditfield'] = '{$a} 개인정보 항목 편집';
$string['profilefield'] = '개인정보 항목';
$string['profilefieldcolumns'] = '열';
$string['profilefieldispassword'] = '암호 필드 입니까?';
$string['profilefieldlink'] = '연결';
$string['profilefieldlink_help'] = '문서를 연결고리로 전환하려면, $$를 포함하여 주소를 입력하라. 즉 트위터의 아이디를 연결고리로 전환하려면  http://twitter.com/$$ 처럼 입력하면 된다.';
$string['profilefieldlinktarget'] = '목적지';
$string['profilefieldmaxlength'] = '최대 길이';
$string['profilefieldrows'] = '행';
$string['profilefields'] = '추가 개인정보 항목 설정';
$string['profilefieldsize'] = '표시 크기';
$string['profileforceunique'] = '자료가 중복되지 않아야 합니까?';
$string['profileinvaliddata'] = '옳지 않은 값';
$string['profilelocked'] = '항목이 잠겼습니까?';
$string['profilemenudefaultnotinoptions'] = '기본값은 필수항목 임';
$string['profilemenunooptions'] = '메뉴 없음';
$string['profilemenuoptions'] = '메뉴 선택사항(한 줄에 하나씩)';
$string['profilemenutoofewoptions'] = '최소 2개의 선택사항을 제공해야 함';
$string['profilename'] = '이름';
$string['profilenofieldsdefined'] = '아무 항목도 정의되지 않았슴';
$string['profilerequired'] = '이 항목이 필요합니까?';
$string['profileroles'] = '개인정보 공개할 역활';
$string['profilesforenrolledusersonly'] = '등록 사용자만의 개인정보';
$string['profileshortname'] = '짧은 이름(중복되지 않아야 함)';
$string['profileshortnamenotunique'] = '이미 사용된 이름입니다.';
$string['profilesignup'] = '로그인 페이지를 표시할까요?';
$string['profilespecificsettings'] = '세부 설정';
$string['profilevisible'] = '누구에게 이 항목을 공개 할까요?';
$string['profilevisibleall'] = '모든 이에게 공개';
$string['profilevisible_help'] = '<p>개개의 항목은 감춤, 모두 공개, 사용자 공개 중 하나를 선택할 수 있습니다. 감춤 설정은 관리자가 사용자의 사적인 자료를 보호하고 싶을 때 주로 사용합니다. \'사용자 공개\'는 \'모두 공개\'가 정보의 어떤 유형이든 공개하여 활용할 수 있는 데 비해 대체로 민감한 정보를 감추고 싶을 경우에 선택합니다.</p>';
$string['profilevisiblenone'] = '비공개';
$string['profilevisibleprivate'] = '사용자에게 공개';
$string['profiling'] = '프로파일링';
$string['profilingallowall'] = '연속 프로파일링';
$string['profilingallowall_help'] = '이 설정을 활성화하면 어느순간에도 무들 세션 수명 기간동안 모든 실행된 스크립트에 대해 프로파일링을 활성화하기 위해 PROFILEALL파라메터(PGC)를 어느곳에서든지 사용할 수 있습니다. 유사하게 프로파일링을 정지시키기 위해 PROFILEALLSTOP을 사용할 수 있습니다.';
$string['profilingallowme'] = '선택적 프로파일링';
$string['profilingallowme_help'] = '이 설정을 활성화하면 선택적으로 PROFILEME 파라메터(PGC)를 사용하여 그 스크립트에 대한 프로파일링이 일어나도록 할 수 있습니다. 유사하게 프로파일링이 일어나지 않도록 DONTPROFILEMEfmf 사용할 수 있습니다.';
$string['profilingautofrec'] = '자동 프로파일링';
$string['profilingautofrec_help'] = '이 설정을 구성하게되면 (명시된 빈도 - 1/XXX에 근거하여 무작위로) 어떤 요청이 선택되어 자동적으로 프로파일되고 추가 분석을 위해 결과를 저장합니다. 이런 방식의 프로파일링은 설정 포함/제외 설정을 준수합니다. 자동프로파일링을 비활성화하려면 그것을 0으로 설정하십시요.';
$string['profilingenabled'] = '프로파일링 활성화';
$string['profilingenabled_help'] = '이 설정을 활성화하면 이 사이트에서 프로파일링이 가능하게되고 다음 옵션을 구성해서 프로파일링 동작을 정의할 수 있습니다.';
$string['profilingexcluded'] = '프로파일링 제외';
$string['profilingexcluded_help'] = '\'이것들을 프로파일\' 설정에 의해 정의된 것들로부터 프로파일링 제외될 (콤마로 분리,  wwwroot를 제외한 절대경로, 호출가능한) URL 목록';
$string['profilingincluded'] = '이것들을 프로파일링';
$string['profilingincluded_help'] = '자동으로 프로파일될  (콤마로 분리,  wwwroot를 제외한 절대경로, 호출가능한) URL 목록. 예: /index.php, /course/view.php. 또한 어떤 위치에 있는 * 와일드카드 허용. 예: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = '프로파일링 실행을 지속';
$string['profilinglifetime_help'] = '예전의 프로파일링 실행에 대한 정보를 보관하기 위한 시간을 명시하십시요. 더 이상된 것들은 정리될 것입니다. \'참고 실행\'으로 표시된 프로파일 실행은 정리에서 제외됨을 주목하십시요,';
$string['protectusernames'] = '사용자이름 보호';
$string['proxybypass'] = '프록시 우회 호스트';
$string['proxyhost'] = '프록시 호스트';
$string['proxypassword'] = '프록시 암호';
$string['proxyport'] = '프록시 포트';
$string['proxytype'] = '프록시 타입';
$string['proxyuser'] = '프록시 사용자 이름';
$string['purgecaches'] = '모든 캐시 삭제';
$string['purgecachesconfirm'] = '무들은 테마, 자바스크립트, 언어 문자열, 필터된 문장, rss 피드 및 여러 계산된 자료 조각들을 캐시에 저장할 수 있습니다. 캐시를 청소하면 서버에서 데이터들이 지워져서 브라우저가 데이터를 다시 가져오도록 하며, 현재 코드에 의해 만들어진 최신의 값들을 볼 수 있습니다. 캐시를 청소하는 것은 아무런 위험이 없지만 서버와 클라이언트가 새로운 정보를 계산하고 저장할 때까지 사이트가 잠시동안 느려질 수 있습니다.';
$string['purgecachesfinished'] = '모든 캐시가 삭제됨';
$string['qtyperqpwillberemoved'] = '업그레이드 과정에서 RQP 문제 유형은 제거될 것입니다. 만일 이 유형의 문제를 사용하지 않았다면, 추후에는 어떤 문제도 발생하지 않을 것입니다.';
$string['qtyperqpwillberemovedanyway'] = '업그레이드 과정에서 RQP 질문 유형은 제거될 것입니다. 데이터베이스에 RQP 질문이 탑재되어 있다면, 업그레이드를 계속하기 전에 http://moodle.org/mod/data/view.php?d=13&rid=797  에서 코드를 다시 설치하지 않는한 작업이 중단될 것입니다.';
$string['quarantinedir'] = '검역 디렉토리';
$string['question'] = '질문';
$string['questionbehaviours'] = '질문 진행방식';
$string['questioncwqpfscheck'] = '퀴즈에  \'무작위\' 질문이 비공개 혹은 공개 질문 은행 중에서 선택하도록 설정되어 있습니다. 좀 더 자세한 보고서는 <a href="{$a->reporturl}">이 곳</a> 과 무들 문서 창고의 <a href="{$a->docsurl}">이 곳</a>을 참고하기 바랍니다.';
$string['questioncwqpfsok'] = '통과. 여러분의 퀴즈에는 처리되어야 할 \'무작위\' 질문이 없습니다.';
$string['questiontype'] = '질문 유형';
$string['questiontypes'] = '질문 유형';
$string['recaptchaprivatekey'] = 'ReCAPTCHA 비밀키';
$string['recaptchapublickey'] = 'ReCAPTCHA 공개키';
$string['register'] = '사이트 등록';
$string['registermoodleorg'] = '{$a}로 사이트를 등록할 때';
$string['registerwithmoodleorg'] = 'Moodle.org 에 등록';
$string['registration'] = '사이트등록';
$string['registrationwarning'] = '사이트가 등록되지 않았습니다.';
$string['releasenoteslink'] = '무들 버전에 대한 정보를 얻기 위해서는 온라인 <a target="_blank" href="{$a}">릴리즈 노트</a> 를 보십시요.';
$string['rememberusername'] = '사용자이름 기억';
$string['reportsmanage'] = '보고서 관리';
$string['requestcategoryselection'] = '범주 선택 활성화';
$string['requiredentrieschanged'] = '<strong>중요 - 필히 읽어볼 것<br/>(본 경고 메세지는 판올림 과정에서만 보이게 될 것입니다.)</strong><br/>버그 수정 때문에, \'필수 항목\' 및 \'설정을 보기전 필수 항목\'설정을 이용하는 데이터베이스 활동에 대한 동작이 변경될 것입니다. 좀 더 자세한 변경 내용은 <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">데이터베이스 모듈 포럼</a>을 참고하면 됩니다. 이러한 설정이 어떻게 작동할 것인가는 <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">무들 문서 창고</a>에서 역시 찾아볼 수 있습니다.
<br/><br/>본 변경은 여러분의 시스템의 다음과 같은 데이터베이스에 영향을 줄 것입니다.(지금 즉시 이 목록을 저장하여 두고, 판올림 이후에 활동들이 선생님들의 의도한 대로 온전히 구동되는지를 점검해 보기 바랍니다.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = '활동 개요 필요';
$string['requires'] = '필수';
$string['restorernewroleid'] = '강좌에서 복구자의 역할';
$string['reverseproxy'] = '리버스 프록시';
$string['riskconfig'] = '사용자가 사이트의 설정과 작동을 변경할 수 있음';
$string['riskconfigshort'] = '위험한 설정';
$string['riskdataloss'] = '사용자가 다량의 정보나 내용을 파괴할 수 있음';
$string['riskdatalossshort'] = '자료 소실 위험';
$string['riskmanagetrust'] = '사용자가 다른 사용자의 신뢰 설정을 변경할 수 있음';
$string['riskmanagetrustshort'] = '인증 관리';
$string['riskpersonal'] = '사용자가 다른 사용자의 개인 정보에 접근할 수 있음';
$string['riskpersonalshort'] = '개인신상 노출 위험';
$string['riskspam'] = '사용자가 타인에게 스팸메일을 보낼 수 있음';
$string['riskspamshort'] = '스팸에 노출 위험';
$string['riskxss'] = '사용자가 XSS를 허용하는 문서나 파일을 첨가할 수 있음';
$string['riskxssshort'] = 'XSS 실행 노출 위험';
$string['roleswithexceptions'] = '{$a->roles}, 및 {$a->exceptions}';
$string['rssglobaldisabled'] = '서버 수준에서 비활성화';
$string['runclamavonupload'] = '파일검역에 clam AV 사용';
$string['save'] = '저장';
$string['savechanges'] = '변경사항 저장';
$string['search'] = '검색';
$string['searchinsettings'] = '설정 검색';
$string['searchresults'] = '검색 결과';
$string['sectionerror'] = '섹션 오류!';
$string['secureforms'] = '추가적인 보안 형식 사용';
$string['security'] = '보안';
$string['selectdevice'] = '기기 선택';
$string['selecttheme'] = '{$a} 기기 에 대한 테마 선책';
$string['server'] = '서버';
$string['serverchecks'] = '서버 점검';
$string['serverlimit'] = '서버 한계';
$string['sessionautostartwarning'] = '<p>심각한 구성 오류가 발견되었습니다. 서버 관리자에게 알리십시요.</p><p> 무들이 잘 동작하려면 관리자가 PHP 설정을 변경해야 합니다. </p><p><code>session.auto_start</code> 는<code>off</code>로 설정되어야 합니다.</p><p>이 설정은 <code>php.ini</code>, Apache/IIS <br />구성 혹은 서버의 <code>.htaccess</code> 파일을 편집해서 변경할 수 있습니다.</p>';
$string['sessioncookie'] = '쿠키 접두어';
$string['sessioncookiedomain'] = '쿠키 도메인';
$string['sessioncookiepath'] = '쿠키 경로';
$string['sessionhandling'] = '세션 처리';
$string['sessiontimeout'] = '시간 종료';
$string['settingfileuploads'] = '통상적인 작동을 위해서는 파일 올리기 기능이 필요합니다. PHP 설정에서 이를 활성화하기 바랍니다.';
$string['settingmemorylimit'] = '메모리 부족 발견, PHP 설정에서 메모리 양을 좀 더 크게 설정하기 바랍니다.';
$string['settingsafemode'] = '무들은 안전모드에 대해 완벽한 호환성을 갖지 못합니다. 관리자에게 이 기능을 꺼달라고 요청하기 바랍니다. 안전모드에서의 무들 구동은 지원되지 않기 때문에, 안전모드로 구동할 경우 여러 문제가 야기될 수 있음을 유의하십시오.';
$string['showcommentscount'] = '덧글 수 보임';
$string['showdetails'] = '자세히 보기';
$string['showuseridentity'] = '사용자 아이덴티티 표시';
$string['simplexmlrequired'] = '이제부터 무들에서 SimpleXML PHP 확장자가 필요';
$string['sitemaintenance'] = '이 사이트는 점검 중이며 현재 사용할 수 없습니다.';
$string['sitemaintenancemode'] = '유지 보수';
$string['sitemaintenanceoff'] = '점검이 끝나고, 다시 일반적인 작동 상태가 되었습니다.';
$string['sitemaintenanceon'] = '이 사이트는 현재 점검중입니다(관리자만 이 사이트를 사용하거나 로그인 할 수 있습니다).';
$string['sitemaintenanceoncli'] = '사이트가 현재 CLI 유지 모드에 있어서 웹 접근이 허용되지 않습니다.';
$string['sitemaintenancewarning'] = '현재 유지 점검 상태에 있습니다(관리자만 로그인 할 수 있습니다.) 일반 작업으로 되돌리시려면 <a href="maintenance.php">정상 작동</a>모드를 사용하십사오.';
$string['sitemaintenancewarning2'] = '현재 점검모드(관리자만 로그인 됨)임. 정상적으로 작동하게 하려면 <a href="{$a}">점검모드 끔</a>을 선택';
$string['sitepolicies'] = '사이트 정책';
$string['sitepolicy'] = '사이트 정책 URL';
$string['sitepolicyguest'] = '손님들에 대한 사이트 정책 URL';
$string['sitepolicyguest_help'] = '만일 이 사이트를 사용하기 전에 모든 등록된 사용자들이 보아야 하고 동의해야 하는 사이트 정책이 있다면 여기에 그 URL을 명시하십시요. 그렇지 않은 경우 빈칸으로 남겨 주십시요. 이 설정은 어떤 공개된 URL도 포함할 수 있습니다. 노트: 로그인되지 않은 사용자에 대한 접근은 강제 로그인 설정으로 방지될 수 있습니다.';
$string['sitepolicy_help'] = '만일 이 사이트를 사용하기 전에 모든 등록된 사용자들이 보아야 하고 동의해야 하는 사이트 정책이 있다면 여기에 그 URL을 명시하십시요. 그렇지 않은 경우 빈칸으로 남겨 주십시요. 이 설정은 어떤 공개된 URL도 포함할 수 있습니다.';
$string['sitesectionhelp'] = '선택되면, 토픽 영역이 사이트 시작 페이지에 보일 것입니다.';
$string['slasharguments'] = '슬래쉬 인수 사용';
$string['smartpix'] = '자동 아이콘 검색';
$string['soaprecommended'] = '웹서비스나 몇개의 기여 모듈을 위해 선택적인 soap 익스텐션을 설치하는 것이 유용합니다.';
$string['sort_fullname'] = '강좌 전체 이름';
$string['sort_idnumber'] = '강좌 ID 번호';
$string['sort_shortname'] = '강좌 짧은 이름';
$string['sort_sortorder'] = '정렬 순서';
$string['spellengine'] = '철자검색 엔진';
$string['spelllanguagelist'] = 'Spell 언어 목록';
$string['splrequired'] = 'SPL PHP 왁장자가 필수임';
$string['stats'] = '통계';
$string['statsfirstrun'] = '최대 보유 시한';
$string['statsmaxruntime'] = '최대 동작 시간';
$string['statsmoodleorg'] = '통계';
$string['statsruntimedays'] = '처리할 날 수';
$string['statsruntimestart'] = '실행 시각';
$string['statsuserthreshold'] = '한계 인원';
$string['stickyblocks'] = '고정 블록';
$string['stickyblockscourseview'] = '강좌 페이지';
$string['stickyblocksduplicatenotice'] = '만일 추가한 블록이 이미 특정 페이지에 존재하고 있다면, 두 개가 겹쳐질 것입니다.<br />이때 원래의 고정 블록은 편집하지 못하게 되나 복사된 블록은 여전히 편집할 수 있습니다.';
$string['stickyblocksmymoodle'] = '내 공부방';
$string['stickyblockspagetype'] = '설정할 페이지 형식';
$string['strictformsrequired'] = '필수항목 엄격 확인';
$string['stripalltitletags'] = '모든 활동 이름에서 HTML 태그 제거';
$string['supportcontact'] = '지원 연락처';
$string['supportemail'] = '보조 이메일';
$string['supportname'] = '보조 이름';
$string['supportpage'] = '보조 페이지';
$string['suspenduser'] = '보류된 사용자 계정';
$string['switchlang'] = '언어 경로 바꿈';
$string['systempaths'] = '시스템 경로';
$string['tablenosave'] = '상단 표의 변경내용은 자동으로 저장됩니다.';
$string['tablesnosave'] = '상단 표의 변경내용은 자동으로 저장됩니다.';
$string['tabselectedtofront'] = '탭이 있는 테이블에서 현재 선택된 탭이 있는 줄은 제일 앞에 위치해야만 합니다.';
$string['tabselectedtofronttext'] = '선택된 탭 행을 앞으로 가져오기';
$string['themedesignermode'] = '테마 디자이너 모드';
$string['themelist'] = '테마 목록';
$string['themenoselected'] = '테마가 선택되지 않았습니다.';
$string['themeresetcaches'] = '테마 캐시 지움';
$string['themeselect'] = '테마 선택';
$string['themeselector'] = '테마 선택';
$string['themesettings'] = '테마 설정';
$string['therewereerrors'] = '데이터 오류';
$string['thirdpartylibs'] = '써드파티 라이브러리';
$string['timezone'] = '기본 표준시';
$string['timezoneforced'] = '사이트 관리자에 의해 지정';
$string['timezoneisforcedto'] = '모든 사용자가 강제로 사용';
$string['timezonenotforced'] = '개인별 표준시 선택 허용';
$string['tokenizerrecommended'] = '추가적인 PHP Tokenizer 확장 설치가 요구됩니다. -- 이는 무들 네트웍의 기능을 향상시킵니다.';
$string['tools'] = '관리도구';
$string['toolsmanage'] = '관리도구 관리';
$string['unattendedoperation'] = '부재 작동';
$string['unbookmarkthispage'] = '갈무리 해제';
$string['unicoderecommended'] = '모든 자료를 유니코드(UTF-8)로 저장해야 합니다. 새로운 설치 과정에서는 기본 문자코드가 유니코드로 저장되어 있다고 가정하고 작동이 됩니다. 만일 업그레이드 중이라면 반드시 UTF-8 변환과정을 수행하여야만 합니다.(관리 페이지 참조)';
$string['unicoderequired'] = '모든 자료가 유니코드(UTF-8)로 저장되야 합니다. 새로운 설치 과정에서는 기본 문자코드가 유니코드로 저장되어 있다고 가정하고 작동이 됩니다. 만일 업그레이드 중이라면 반드시 UTF-8 변환과정을 수행하여야만 합니다.(관리 페이지 참조)';
$string['uninstallplugin'] = '플러그인 제거';
$string['unlockaccount'] = '계정 잠금 해제';
$string['unsettheme'] = 'Unset 테마';
$string['unsupported'] = '지원되지 않음';
$string['unsuspenduser'] = '사용자 계정 활성화';
$string['updateaccounts'] = '기존 계정 업데이트';
$string['updateautocheck'] = '사용가능한 업데이트가 있는지 자동으로 확인';
$string['updateautodeploy'] = '업데이트 배포 활성화';
$string['updateavailable'] = '새로운 무들 버전이 있습니다.';
$string['updateavailabledetailslink'] = '자세한 정보는  {$a->url}를 참고하세요.';
$string['updateavailableforplugin'] = '사용가능한 플러그인에 대해 새로운 버전이 있습니다.';
$string['updateavailableinstall'] = '이 업데이트 설치';
$string['updateavailable_moreinfo'] = '추가정보 ...';
$string['updateavailablenot'] = '무들 코드는 최신입니다.';
$string['updateavailable_release'] = '무들 {$a}';
$string['updateavailable_version'] = '버전{$a}';
$string['updatecomponent'] = '구성요소 업데이트';
$string['updateminmaturity'] = '필요한 코드 성숙도';
$string['updatenotifications'] = '업데이트 통지';
$string['updatenotificationsubject'] = '이 사이트에 대한 사용가능한 업데이트들이 있습니다,';
$string['updatenotifybuilds'] = '새로운 빌드에 대해 통지';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 는 사용자 자료를 보호하기 위해 사용자 암호와 백업에 대한 여러가지 보안 수정을 포함하고 있습니다. 결과적으로 몇 가지 설정과 백업과 관련된 설정이 변경되었을 수 있습니다. <br />
자세한 것은 <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 릴리즈 노트</a>f를 참조하십시요</p>';
$string['upgrade197noticesubject'] = '무들 1.9.7 판올림 보안 소식';
$string['upgrade197salt'] = '비밀번호 누출의 위험성을 줄이기 위해, password salt를 설정해 놓을 것을 강력히 권합니다.<br />좀 더 자세한 내용은 <a href="{$a}" target="_blank">password salting documentation</a> 을 참조하세요.';
$string['upgradeerror'] = '{$a->plugin} 를 {$a->version} 판으로 업데이트하던 중, 알 수 없는 오류로 인해 중지되었습니다.';
$string['upgradeforumread'] = '포럼의 게시물을 찾기 위해 Moodle 1.5에 "읽음/안읽은 게시물" 기능이 추가 되었습니다. <br />이 기능을 사용하려면 <a href="{$a}">이 곳을 클릭하여</a> 테이블을 업데이트하세요.';
$string['upgradeforumreadinfo'] = '읽거나 읽지 않은 포럼의 게시물을 찾기 위해 Moodle 1.5에 새로운 기능이 추가되었습니다. 이 기능을 사용하기 위해 추적 정보를 이용하기 위해서는 현존하고 있는 게시물에 있는 목록을 업데이트할 필요가 있습니다.  사이트에 따라 시간이 길어질 수 있으며(수 시간) 데이터베이스의 규모에 따라 좀 더 시간이 걸릴 수도 있습니다. 일단 이것을 진행시키면 꼭 끝을 보아야 합니다.(윈도우 브라우저 창을 유지시키는 것 만으로 할 수 있습니다.) 걱정마십시오 - 당신의 사이트는 로그를 업그레이드 하는 동안 다른사람이 이용하는데 불편없이 잘 운영이 될 것입니다.
<br /><br />판올림 과정을 시작할까요?';
$string['upgradelogs'] = '원활한 작동을 위해서 오래된 로그(경과기록)는 업그레이드할 필요가 있습니다. <a href="{$a}">추가 정보</a>';
$string['upgradelogsinfo'] = '최근에 바뀐 로그 기록이 저장되었습니다. 이전의 활동 기록을 보려면, 오래된 기록들은 업그레이드 되어야 합니다. 사이트에 따라 시간이 길어질 수 있으며(수 시간) 데이터베이스의 규모에 따라 좀 더 시간이 걸릴 수도 있습니다. 일단 이것을 진행시키면 꼭 끝을 보아야 합니다.(윈도우 브라우저 창을 유지시키는 것 만으로 할 수 있습니다.) 걱정마십시오 - 당신의 사이트는 로그를 업그레이드 하는 동안 다른사람이 이용하는데 불편없이 잘 운영이 될 것입니다.<br /><br />이제부터 경과기록(로그)를 업그레이드 할까요?';
$string['upgradepluginsfirst'] = '사용가능한 모든 업데이트를 먼저 설치하는 것을 권장합니다.';
$string['upgradepluginsinfo'] = '플러그인 업데이트';
$string['upgradesettings'] = '새로운 설정';
$string['upgradesettingsintro'] = '앞서의 판올림과정 동안 아래의 설정이 추가되었습니다. 기본 설정에서 필요한 내용을 바꾼 다음, 페이지  하단에 있는 "변경사항 저장"을 클릭하십시요.';
$string['upgradestalefiles'] = '혼합된 무들 버전이 발견되었습니다. 업그레이드를 계속할 수 없습니다.';
$string['upgradestart'] = '판올림';
$string['upgradesure'] = '무들 파일들이 변경완료되었고  서버를<br /><br />
 <strong>{$a}</strong> <br /><br />
버전으로 자동 판올림할 준비가 되었습니다. 일단 이 과정을 시작하면 되돌이킬 수 없습니다.<br /><br />확실히 이 서버를 새 버전으로 판올림 하시겠습니까?';
$string['upgradetimedout'] = '판올림 제한 시간이 초과되었습니다. 다시 시작해 보기 바랍니다.';
$string['upgradingdata'] = '데이터 업그레이드';
$string['upgradinglogs'] = '경과기록(로그) 업그레이드';
$string['upgradingversion'] = '새 판으로 판올림 중';
$string['upwards'] = '위로';
$string['useblogassociations'] = '연합 활성화';
$string['useexternalyui'] = '야후 UI 라이브러리 사용';
$string['user'] = '사용자';
$string['userbulk'] = '일괄 사용자 처리';
$string['userlist'] = '사용자 목록 살펴보기';
$string['userpolicies'] = '사용자 정책';
$string['userpreference'] = '개인 맞춤설정';
$string['userquota'] = '사용자 쿼터';
$string['users'] = '사용자';
$string['usesitenameforsitepages'] = '사이트 페이지에 사이트 이름 사용';
$string['usetags'] = '태그 기능 활성화';
$string['validateerror'] = '이 값은 유효하지 않음:';
$string['verifychangedemail'] = '이메일 변경시 도메인 점검';
$string['warningcurrentsetting'] = '잘못된 값: {$a}';
$string['webproxy'] = '웹 프록시';
$string['webproxyinfo'] = '무들서버가 인터넷을 직접 접속할 수 없는 경우 다음 옵션을 입력하세요. 환경변수, 언어팩, RSS 피드, 표준시 등을 내려받기 위해서는 인터넷 접속이 이루어져야 합니다. <br/><em> PHP cURL 확장자를 설치할 것을 권고합니다. </em>';
$string['xmlrpcrecommended'] = 'xmlrpc 익스텐션은 허브 통신에 필요하며 웹서비스와 무들 네트워킹에 유용합니다,';
$string['yuicomboloading'] = 'YUI 콤보 로딩';
$string['ziprequired'] = '더 이상  info-ZIP 이나 PclZip 라이브러리가 사용되지 않으므로 Zip PHP확장자가 필요합니다.';
