<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_formal_white', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_formal_white
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['blockcolumnwidth'] = 'Lled colofn blociau';
$string['blockcontentbgc'] = 'Lliw cefndir cynnwys blociau';
$string['blockcontentbgcdesc'] = 'Mae hwn yn pennu lliw cefndir cynnwys blociau ar gyfer y thema.';
$string['choosereadme'] = '<div class="clearfix">
    <div class="theme_screenshot">
        <h2>Formal White</h2>
        <img src="formal_white/pix/screenshot.gif" />

        <h3>Theme Discussion Forum:</h3>
        <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

        <h3>Theme Credits</h3>
        <p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

        <h3>Theme Documentation:</h3>
        <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

        <h3>Report a bug:</h3>
        <p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
    </div>
    <div class="theme_description">
        <h2>About</h2>
        <p>Formal White is a fluid-width, three-column theme ported over to 2.0 from Moodle 1.X.</p>
        <h2>Tweaks</h2>
        <p>This theme is built upon both Base and Canvas, two parent themes included in the Moodle core. If you want to modify this theme, we recommend that you first duplicate it, then rename it before making your changes. This will prevent your customized theme from being overwritten by future Moodle upgrades, and you\'ll still have the original files if you make a mess. More information on modifying themes can be found in the <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a>.</p>
    <h2>Credits</h2>
    <p>This theme was coded and is maintained by MediaTouch 2000. </p>
        <h2>License</h2>
        <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
    </div>
</div>';
$string['configtitle'] = 'Thema wen ffurfiol';
$string['customcss'] = 'CSS Personol';
$string['fontsizereference'] = 'Maint ffont cyffredinol';
$string['fontsizereferencedesc'] = 'Mae hwn yn gadael i chi bennu\'r maint ffont diofyn ar gyfer y thema hon. Dydyn ni ddim yn argymell eich bod yn gosod maint mwy na 13px oherwydd mae hynny\'n gallu achos problemau gyda rhai blociau.';
$string['footnote'] = 'Troedyn';
$string['footnotedesc'] = 'Bydd y cynnwys yn yr ardal destun hon yn ymddangos ar droedyn pob tudalen.';
$string['headerbgc'] = 'Lliw cefndir y pennyn';
$string['headerbgcdesc'] = 'Mae hwn yn pennu lliw cefndir pennyn y blociau ar gyfer y thema hon.';
$string['lblockcolumnbgc'] = 'Lliw cefndir y golofn chwith';
$string['lblockcolumnbgcdesc'] = 'Mae hwn yn pennu lliw cefndir y golofn chwith ar gyfer y thema hon.';
$string['noframe'] = 'Golwg gwyn ffurfiol 1.9';
$string['noframedesc'] = 'Dewiswch hwn i sicrhau bod eich tudalen Moodle yn edrych fel Moodle 1.* amgen, heb y ffrâm o\'i hamgylch.';
$string['pluginname'] = 'Gwyn ffurfiol';
$string['rblockcolumnbgc'] = 'Lliw cefndir y golofn dde';
$string['region-side-post'] = 'Dde';
$string['region-side-pre'] = 'Chwith';
