<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Gallwch gael rhagolwg o\'r cwis hwn, ond petai hwn yn gynnig go iawn, byddech chi\'n cael eich rhwystro oherwydd:';
$string['action'] = 'Gweithred';
$string['adaptive'] = 'Modd addasu';
$string['adaptive_help'] = 'Os yw hwn wedi\'i alluogi, bydd hawl rhoi mwy nag un ymateb i gwestiwn o fewn yr un cynnig ar y cwis. Felly, er enghraifft, os yw\'r ateb yn anghywir, bydd y myfyriwr yn cael rhoi cynnig arall arni yn y syth. Fodd bynnag, yn dibynnu ar y gosodiad "Gosod cosbau", bydd pwyntiau cosb yn cael eu tynnu am bob cynnig anghywir.';
$string['addaquestion'] = 'Ychwanegu cwestiwn...';
$string['addarandomquestion'] = 'Ychwanegu cwestiwn ar hap ...';
$string['addarandomquestion_help'] = 'Pan fydd cwestiwn ar hap yn cael ei ychwanegu, bydd cwestiwn a ddewiswyd ar hap o\'r categori yn cael ei roi yn y cwis. Mae hyn yn golygu bod myfyrwyr gwahanol yn debygol o gael cyfres wahanol o gwestiynau. Pan fydd cwis yn caniatáu mwy nag un cynnig, yna bydd pob cynnig yn debygol o gynnwys cyfres newydd o gwestiynau.';
$string['adddescriptionlabel'] = 'Ychwanegu disgrifiad/label';
$string['addingquestion'] = 'Wrthi\'n ychwanegu cwestiwn';
$string['addingquestions'] = 'Ar yr ochr hon o\'r dudalen rydych chi\'n rheoli eich cronfa ddata o gwestiynau. Caiff cwestiynau eu storio mewn categorïau i\'ch helpu i\'w cadw mewn trefn, a gallant gael eu defnyddio gan unrhyw gwis yn eich cwrs neu hyd yn oed gyrsiau eraill petaech yn dewis eu \'cyhoeddi\'. <br /><br />Ar ôl i chi ddewis neu greu categori cwestiwn byddwch yn gallu creu neu olygu cwestiynau. Gallwch ddewis ychwanegu unrhyw rai o\'r cwestiynau hyn at eich cwestiynau ar ochr arall y dudalen hon.';
$string['addmoreoverallfeedbacks'] = 'Ychwanegu {nif} maes adborth arall';
$string['addnewgroupoverride'] = 'Ychwanegu gosodiad diystyru grŵp';
$string['addnewpagesafterselected'] = 'Ychwanegu tudalennau newydd ar ôl y cwestiynau a ddewiswyd';
$string['addnewquestionsqbank'] = 'Ychwanegu cwestiynau at y categori {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Ychwanegu gosodiad diystyru defnyddiwr';
$string['addpagehere'] = 'Ychwanegu tudalen yma';
$string['addquestion'] = 'Ychwanegu cwestiwn';
$string['addquestions'] = 'Ychwanegu cwestiynau';
$string['addquestionstoquiz'] = 'Ychwanegu cwestiynau at y cwis presennol';
$string['addrandom'] = 'Ychwanegu {$a} cwestiwn ar hap';
$string['addrandom1'] = '<< Ychwanegu';
$string['addrandom2'] = 'cwestiynau ar hap';
$string['addrandomfromcategory'] = 'Ychwanegu cwestiynau ar hap o\'r categori:';
$string['addrandomquestion'] = 'Ychwanegu cwestiwn ar hap';
$string['addrandomquestiontoquiz'] = 'Ychwanegu cwestiwn ar hap at y cwis {$a}';
$string['addselectedtoquiz'] = 'Ychwanegu\'r rhai a ddewiswyd at y cwis';
$string['addtoquiz'] = 'Ychwanegu at y cwis';
$string['affectedstudents'] = '{$a} wedi\'u heffeithio';
$string['aftereachquestion'] = 'Ar ôl ychwanegu pob cwestiwn';
$string['afternquestions'] = 'Ar ôl ychwanegu {$a} cwestiwn';
$string['age'] = 'oed';
$string['allattempts'] = 'Pob cynnig';
$string['allinone'] = 'Diderfyn';
$string['allowreview'] = 'Caniatáu adolygu';
$string['alreadysubmitted'] = 'Mae\'n debygol eich bod eisoes wedi cyflwyno\'r cynnig hwn';
$string['alternativeunits'] = 'Unedau Eraill';
$string['alwaysavailable'] = 'Ar gael drwy\'r amser';
$string['analysisoptions'] = 'Dewisiadau dadansoddi';
$string['analysistitle'] = 'Tabl Dadansoddi Eitemau';
$string['answer'] = 'Ateb';
$string['answered'] = 'Wedi ateb';
$string['answerhowmany'] = 'Un neu fwy o atebion?';
$string['answers'] = 'Atebion';
$string['answersingleno'] = 'Caniateir mwy nag un ateb';
$string['answersingleyes'] = 'Un ateb yn unig';
$string['answertoolong'] = 'Ateb yn rhy hir ar ôl llinell {$a} (dim mwy na 255 llythyren)';
$string['aon'] = 'fformat AON';
$string['areyousureremoveselected'] = 'Ydych chi\'n siŵr eich bod am dynnu pob un o\'r cwestiynau a ddewiswyd?';
$string['asshownoneditscreen'] = 'Fel y mae\'n ymddangos ar y sgrin olygu';
$string['attempt'] = 'Cynnig {$a}';
$string['attemptalreadyclosed'] = 'Mae\'r cynnig hwn wedi\'i orffen yn barod.';
$string['attemptclosed'] = 'Dydy\'r cynnig hwn heb gau eto';
$string['attemptduration'] = 'Amser a gymerwyd';
$string['attemptedon'] = 'Rhoddwyd cynnig ar';
$string['attempterror'] = 'Does gennych chi ddim hawl i roi cynnig ar y cwis hwn ar hyn o bryd oherwydd: {$a}';
$string['attemptfirst'] = 'Cynnig cyntaf';
$string['attemptincomplete'] = 'Nid yw\'r cynnig (gan {$a}) wedi ei gwblhau eto.';
$string['attemptlast'] = 'Cynnig olaf';
$string['attemptnumber'] = 'Cynnig';
$string['attemptquiznow'] = 'Rhowch gynnig ar y cwis nawr';
$string['attempts'] = 'Cynigion';
$string['attemptsallowed'] = 'Cynigion a ganiateir';
$string['attemptsdeleted'] = 'Wedi dileu cynigion ar y cwis';
$string['attemptselection'] = 'Dewiswch pa gynigion i\'w dadansoddi fesul defnyddiwr:';
$string['attemptsexist'] = 'Ni allwch ychwanegu na dileu cwestiynau mwyach.';
$string['attemptsnum'] = 'Cynigion: {$a}';
$string['attemptsnumthisgroup'] = 'Sawl cynnig: {$a->total} ({$a->group} o\'r grŵp hwn)';
$string['attemptsnumyourgroups'] = 'Sawl cynnig: {$a->total} ({$a->group} o\'ch grwpiau)';
$string['attemptsonly'] = 'Dim ond dangos myfyrwyr gyda chynigion';
$string['attemptstillinprogress'] = 'Mae\'r cynnig hwn yn dal ar agor';
$string['attemptsunlimited'] = 'Nifer ddiderfyn o gynigion';
$string['back'] = 'Yn ôl i ragolwg y cwestiwn';
$string['backtocourse'] = 'Yn ôl i\'r cwrs';
$string['backtoquestionlist'] = 'Yn ôl i\'r Rhestr Cwestiynau';
$string['backtoquiz'] = 'Yn ôl i olygu cwis';
$string['basicideasofquiz'] = 'Y syniadau sylfaenol ynghylch llunio cwis';
$string['bestgrade'] = 'Y radd orau';
$string['bothattempts'] = 'Dangos myfyrwyr sydd wedi rhoi cynnig arni a\'r rheini sydd heb';
$string['browsersecurity'] = 'Diogelwch y porwr';
$string['browsersecurity_help'] = 'Os dewisir "Ffenestr naid sgrin gyfan gyda rhywfaint o ddiogelwch JavaScript",

* Ni fydd y cwis yn cychwyn oni bai fod gan y myfyriwr borwr gwe gyda JavaScript wedi\'i alluogi
* Bydd y cwis yn ymddangos mewn ffenestr naid sgrin lawn sy\'n mynd dros y ffenestri eraill i gyd ac sydd heb reolyddion llywio
* Bydd y myfyrwyr yn cael eu hatal, cyn belled ag y bo modd, rhag defnyddio pethau fel copïo a gludo';
$string['calculated'] = 'Wedi Cyfrifo';
$string['calculatedquestion'] = 'Ni gefnogwyd y Cwestiwn a Gyfrifwyd yn llinell {$a}. Bydd y cwestiwn yn cael ei anwybyddu.';
$string['cannotcreatepath'] = 'Does dim modd creu\'r llwybr ({$a})';
$string['cannoteditafterattempts'] = 'Allwch chi ddim ychwanegu na thynnu cwestiynau gan fod rhywun eisoes wedi rhoi cynnig ar y cwis hwn. ({$a})';
$string['cannotfindprevattempt'] = 'Heb ganfod y cynnig diwethaf i adeiladu arno.';
$string['cannotfindquestionregard'] = 'Heb lwyddo i nôl cwestiynau ar gyfer graddio eto!';
$string['cannotinsert'] = 'Does dim modd mewnosod cwestiwn';
$string['cannotinsertrandomquestion'] = 'Does dim modd mewnosod cwestiwn ar hap newydd!';
$string['cannotloadquestion'] = 'Does dim modd llwytho dewisiadau cwestiwn';
$string['cannotloadtypeinfo'] = 'Heb lwyddo i lwytho gwybodaeth cwestiwn penodol ar gyfer y math o gwestiwn';
$string['cannotopen'] = 'Does dim modd agor y ffeil allgludo ({$a})';
$string['cannotrestore'] = 'Doedd dim modd adfer sesiynau\'r cwestiwn';
$string['cannotreviewopen'] = 'Allwch chi ddim adolygu\'r cynnig hwn. Mae ar agor o hyd.';
$string['cannotsavelayout'] = 'Doedd dim modd cadw\'r cynllun';
$string['cannotsavenumberofquestion'] = 'Doedd dim modd cadw nifer y cwestiynau ar bob tudalen';
$string['cannotsavequestion'] = 'Does dim modd cadw\'r rhestr cwestiynau';
$string['cannotsetgrade'] = 'Doedd dim modd pennu uchafswm gradd newydd ar gyfer y cwis';
$string['cannotsetsumgrades'] = 'Heb lwyddo i bennu swm graddau';
$string['cannotstartgradesmismatch'] = 'Does dim modd cychwyn cynnig ar y cwis hwn. Mae\'r cwis i fod i gael ei raddio, ond does dim cwestiynau yn y cwis sy\'n werth unrhyw farciau.';
$string['cannotstartmissingquestion'] = 'Does dim modd cychwyn cynnig ar y cwis hwn. Mae diffiniad y cwis yn cynnwys cwestiwn sydd ddim yn bodoli.';
$string['cannotstartnoquestions'] = 'Does dim modd cychwyn cynnig ar y cwis hwn. Dydy\'r cwestiwn ddim wedi cael ei sefydlu eto. Does dim cwestiynau wedi cael eu hychwanegu.';
$string['cannotwrite'] = 'Does dim modd ysgrifennu i\'r ffeil allgludo ({$a})';
$string['caseno'] = 'Na, nid yw\'n gwahaniaethu rhwng llythrennau bach/mawr';
$string['casesensitive'] = 'Sensitif i lythrennau bach/mawr';
$string['caseyes'] = 'Oes, rhaid i\'r llythrennau bach/mawr gyfateb';
$string['categories'] = 'Categorïau';
$string['category'] = 'Categori';
$string['categoryadded'] = 'Wedi ychwanegu\'r categori \'{$a}\'';
$string['categorydeleted'] = 'Wedi dileu\'r categori \'{$a}\'';
$string['categorynoedit'] = 'Nid oes gennych chi hawliau golygu yn y categori \'{$a}\'.';
$string['categoryupdated'] = 'Wedi diweddaru\'r categori\'n llwyddiannus';
$string['close'] = 'Cau\'r ffenestr';
$string['closebeforeopen'] = 'Doedd dim modd diweddaru\'r cwis. Rydych chi wedi rhoi dyddiad cau sydd cyn y dyddiad agor.';
$string['closed'] = 'Wedi cau';
$string['closepreview'] = 'Cau\'r rhagolwg';
$string['closereview'] = 'Cau\'r adolygiad';
$string['comment'] = 'Sylw';
$string['commentorgrade'] = 'Gwneud sylw neu ddiystyrru\'r radd';
$string['comments'] = 'Sylwadau';
$string['completedon'] = 'Wedi cwblhau ar';
$string['configadaptive'] = 'Os ydych chi\'n dewis Iawn ar gyfer y dewis hwn yna bydd y myfyriwr yn cael gwneud sawl ymateb i gwestiwn hyd yn oed o fewn yr un cynnig ar y cwis.';
$string['configattemptsallowed'] = 'Cyfyngiad ar sawl ymgais sydd gan fyfyrwyr ar gwis.';
$string['configdecimaldigits'] = 'Nifer y digidau ddylai gael eu dangos ar ôl y pwynt degol wrth ddangos graddau.';
$string['configdecimalplaces'] = 'Nifer y digidau ddylai gael eu dangos ar ôl y pwynt degol wrth ddangos graddau ar gyfer y cwis.';
$string['configdecimalplacesquestion'] = 'Nifer y digidau ddylai gael eu dangos ar ôl y pwynt degol wrth ddangos y radd ar gyfer cwestiynau unigol.';
$string['configdelay1'] = 'Os ydych chi\'n pennu cyfnod o oedi, yna bydd myfyriwr yn gorfod aros cymaint â hynny cyn rhoi cynnig ar gwis ar ôl y cynnig cyntaf.';
$string['configdelay1st2nd'] = 'Os ydych chi\'n pennu cyfnod o oedi yma, fydd y myfyriwr ddim yn gallu dechrau ei ail gynnig nes bod yr amser hwnnw wedi mynd heibio ar ôl diwedd ei gynnig cyntaf.';
$string['configdelay2'] = 'Os ydych chi\'n pennu cyfnod o oedi yma, yna bydd myfyriwr yn gorfod aros cymaint â hynny o amser cyn ei drydydd cynnig neu unrhyw gynnig arall.';
$string['configdelaylater'] = 'Os ydych chi\'n pennu cyfnod o oedi yma, ni fydd y myfyriwr yn gallu dechrau ei drydydd, pedwerydd, ... cynnig nes bod cymaint â hyn o amser wedi mynd heibio ers ei gynnig blaenorol.';
$string['configeachattemptbuildsonthelast'] = 'Os oes hawl gwneud mwy nag un cynnig, yna bydd pob cynnig newydd yn cynnwys canlyniadau\'r cynnig blaenorol.';
$string['configgrademethod'] = 'Os oes hawl gwneud mwy nag un cynnig, pa ddull a ddylid ei ddefnyddio i gyfrifo gradd derfynol y myfyriwr ar gyfer y cwis.';
$string['configintro'] = 'Bydd y gwerthoedd a bennwch yma\'n diffinio\'r gwerthoedd diofyn sy\'n cael eu defnyddio yn y ffurflen gosodiadau pan fyddwch chi\'n creu cwis newydd. Gallwch hefyd ffurfweddu pa osodiadau cwis sy\'n cael eu hystyried fel gosodiadau uwch.';
$string['configmaximumgrade'] = 'Y radd ddiofyn er mwyn cyfrifo graddfa gradd y cwis.';
$string['confignewpageevery'] = 'Wrth ychwanegu cwestiwn at y cwis, bydd toriadau tudalen yn cael eu rhoi i mewn yn awtomatig i\'r gosodiad a ddewiswch yma.';
$string['configpenaltyscheme'] = 'Pwyntiau cosb a dynnwyd am bob ateb anghywir yn y modd addasu.';
$string['configpopup'] = 'Gorfodi agor y cynnig mewn ffenestr naid, a defnyddio triciau JavaScript i geisio atal copïo a gludo ac ati yn ystod cynigion ar gwis.';
$string['configrequirepassword'] = 'Rhaid i fyfyrwyr roi\'r cyfrinair hwn cyn rhoi cynnig ar gwis.';
$string['configrequiresubnet'] = 'Dim ond o\'r cyfrifiaduron hyn y gall myfyrwyr roi cynnig ar y cwis.';
$string['configreviewoptions'] = 'Mae\'r dewisiadau hyn yn rheoli pa wybodaeth mae defnyddwyr yn ei gweld wrth adolygu cynnig ar gwis neu edrych ar adroddiadau cwis.';
$string['configshowblocks'] = 'Dangos blociau yn ystod cynigion ar gwis.';
$string['configshowuserpicture'] = 'Dangos llun y defnyddiwr ar y sgrin yn ystod ei gynnig.';
$string['configshufflequestions'] = 'Os ydych chi\'n galluogi\'r dewis hwn, yna bydd trefn y cwestiynau yn y cwis yn cael eu cymysgu ar hap bob tro y bydd myfyriwr yn rhoi cynnig ar gwis.';
$string['configshufflewithin'] = 'Os ydych chi\'n galluogi\'r dewis hwn, yna bydd y rhannau\'n sy\'n creu cwestiynau unigol yn cael eu cymysgu ar hap bob tro y bydd myfyriwr yn dechrau cynnig ar y cwis hwn, ar yr amod bod y dewis hefyd wedi\'i alluogi yng ngosodiadau\'r cwestiwn.';
$string['configtimelimit'] = 'Terfyn amser diofyn ar gyfer cwisiau mewn munudau. 0 yn golygu dim terfyn amser.';
$string['configtimelimitsec'] = 'Terfyn amser diofyn ar gyfer cwisiau mewn eiliadau. 0 yn golygu dim terfyn amser.';
$string['configurerandomquestion'] = 'Ffurfweddu cwestiwn';
$string['confirmclose'] = 'Rydych chi ar fin dod â\'r cynnig hwn i ben. Ar ôl i chi ei gau, ni fyddwch yn gallu newid eich atebion.';
$string['confirmserverdelete'] = 'Ydych chi\'n siŵr eich bod am dynnu\'r gweinydd <b>{$a}</b> oddi ar y rhestr?';
$string['confirmstartattemptlimit'] = 'Mae\'r cwrs yn gyfyngedig i {$a} cynnig. Rydych chi ar fin dechrau cynnig o\'r newydd. Ydych chi am fwrw ymlaen?';
$string['confirmstartattempttimelimit'] = 'Mae cyfyngiad amser ar y cwis a chewch roi {$a} cynnig arno yn unig.
Rydych chi ar fin dechrau cynnig o\'r newydd. Ydych chi am fwrw ymlaen?';
$string['confirmstarttimelimit'] = 'Mae cyfyngiad amser ar y Cwis. Ydych chi\'n siŵr eich bod am ddechrau?';
$string['containercategorycreated'] = 'Mae\'r categori wedi cael ei greu i storio\'r holl gategorïau gwreiddiol a symudwyd i\'r lefel safle am y rhesymau isod.';
$string['continueattemptquiz'] = 'Bwrw ymlaen â\'r cynnig diwethaf';
$string['continuepreview'] = 'Bwrw ymlaen â\'r rhagolwg diwethaf';
$string['copyingfrom'] = 'Wrthi\'n creu copi o\'r cwestiwn \'{$a}\'';
$string['copyingquestion'] = 'Wrthi\'n copïo cwestiwn';
$string['correct'] = 'Cywir';
$string['correctanswer'] = 'Ateb cywir';
$string['correctanswerformula'] = 'Fformiwla Ateb Cywir';
$string['correctansweris'] = 'Ateb cywir: {$a}';
$string['correctanswerlength'] = 'Ffigurau Arwyddocaol';
$string['correctanswers'] = 'Atebion cywir';
$string['correctanswershows'] = 'Ateb cywir yn dangos';
$string['corrresp'] = 'Ymateb Cywir';
$string['countdown'] = 'Cyfrif i lawr';
$string['countdownfinished'] = 'Mae\'r cwis hwn yn dod i ben, dylech gyflwyno eich atebion nawr.';
$string['countdowntenminutes'] = 'Bydd y cwis yn dod i ben mewn deng munud.';
$string['coursetestmanager'] = 'Fformat Rheolwr Profion y Cwrs';
$string['createcategoryandaddrandomquestion'] = 'Creu categori ac ychwanegu cwestiwn ar hap';
$string['createfirst'] = 'Rhaid i chi greu ambell gwestiwn ag atebion byr yn gyntaf.';
$string['createmultiple'] = 'Ychwanegu amryw o gwestiynau ar hap at y cwis';
$string['createnewquestion'] = 'Creu cwestiwn newydd';
$string['createquestionandadd'] = 'Creu cwestiwn newydd a\'i ychwanegu at y cwis.';
$string['custom'] = 'Fformat personol';
$string['dataitemneed'] = 'Mae angen i chi ychwanegu o leiaf un set o eitemau data i gael cwestiwn dilys';
$string['datasetdefinitions'] = 'Diffiniadau set ddata y gellir eu hailddefnyddio ar gyfer categori {$a}';
$string['datasetnumber'] = 'Rhif';
$string['daysavailable'] = 'Dyddiau ar gael';
$string['decimaldigits'] = 'Digidiau degol yn y graddau';
$string['decimalplaces'] = 'Pwyntiau degol mewn graddau';
$string['decimalplacesquestion'] = 'Lleoedd degol mewn graddau cwestiwn';
$string['decimalplacesquestion_help'] = 'Mae\'r gosodiad hwn yn pennu nifer y digidau ar ôl y pwynt degol wrth ddangos y graddau ar gyfer cwestiynau unigol.';
$string['decimalpoints'] = 'Pwyntiau degol';
$string['default'] = 'Diofyn';
$string['defaultgrade'] = 'Gradd cwestiwn diofyn';
$string['defaultinfo'] = 'Y categori diofyn ar gyfer cwestiynau.';
$string['delay1'] = 'Bwlch amser rhwng y cynnig cyntaf a\'r ail gynnig';
$string['delay1st2nd'] = 'Gorfodi cyfnod amser rhwng y cynnig 1af a\'r 2il gynnig';
$string['delay1st2nd_help'] = 'Os yw hwn wedi\'i alluogi, bydd yn rhaid i fyfyrwyr aros i\'r amser penodol fynd heibio cyn y gall roi cynnig ar y cwis yr eilwaith.';
$string['delay2'] = 'Bwlch amser rhwng y cynigion wedyn';
$string['delaylater'] = 'Gorfodi cyfnod amser rhwng cynigion dilynol';
$string['delaylater_help'] = 'Os yw hwn wedi\'i alluogi, bydd rhaid i fyfyrwyr ddisgwyl i\'r amser penodol fynd heibio cyn rhoi cynnig ar y cwis y trydydd tro ac unrhyw droeon eraill.';
$string['deleteattemptcheck'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu\'r cynigion hyn yn llwyr?';
$string['deleteselected'] = 'Dileu\'r dewis';
$string['deletingquestionattempts'] = 'Wrthi\'n dileu cynigion ar gwestiwn';
$string['description'] = 'Disgrifiad';
$string['disabled'] = 'Wedi\'i analluogi';
$string['displayoptions'] = 'Dangos dewisiadau';
$string['download'] = 'Cliciwch i lwytho i lawr y ffeil categori a allgludwyd';
$string['downloadextra'] = '(cedwir y ffeil hefyd yn ffeiliau\'r cyrsiau yn y ffolder data wrth gefn/cwis)';
$string['duplicateresponse'] = 'Mae\'r hyn a gyflwynwyd gennych wedi cael ei anwybyddu oherwydd eich bod wedi rhoi ateb cyfwerth ynghynt.';
$string['eachattemptbuildsonthelast'] = 'Mae pob cynnig yn adeiladu ar yr un diwethaf.';
$string['eachattemptbuildsonthelast_help'] = 'Os oes hawl gwneud mwy nag un cynnig a bod y gosodiad hwn wedi\'i alluogi, bydd pob cynnig newydd ar gwis yn cynnwys canlyniadau\'r cynnig blaenorol. Bydd hyn yn ei gwneud yn bosib cwblhau\'r cwis dros sawl cynnig.';
$string['editcategories'] = 'Golygu categorïau';
$string['editcategory'] = 'Golygu categori';
$string['editcatquestions'] = 'Golygu cwestiynau categori';
$string['editingquestion'] = 'Wrthi\'n Golygu Cwestiwn';
$string['editingquiz'] = 'Wrthi\'n Golygu Cwis';
$string['editingquiz_help'] = 'Wrth greu cwis, dyma\'r prif gysyniadau:
* Y cwis, yn cynnwys cwestiynau dros un neu fwy o dudalennau
* Y banc cwestiynau, sy\'n storio copïau o\'r holl gwestiynau wedi\'u trefnu mewn categorïau
* Cwestiynau ar hap - mae myfyrwyr yn cael cwestiynau gwahanol bob tro y byddant yn rhoi cynnig ar y cwis a gall myfyrwyr gwahanol gael cwestiynau gwahanol';
$string['editoverride'] = 'Golygu diystyru';
$string['editqcats'] = 'Golygu categoriau cwestiynau';
$string['editquestions'] = 'Golygu cwestiynau';
$string['editquiz'] = 'Golygu Cwis';
$string['editquizquestions'] = 'Golygu Cwestiynau Cwis';
$string['emailconfirmbody'] = 'Annwyl {$a->username},

Diolch am gyflwyno eich atebion i
\'{$a->quizname}\'
yn y cwrs \'{$a->coursename}\'
am {$a->submissiontime}.

Mae\'r neges hon yn cadarnhau bod eich atebion wedi cyrraedd yn ddiogel.

Gallwch gael mynediad at y cwis hwn yn {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Diolch am gyflwyno eich atebion i \'{$a->quizname}\'';
$string['empty'] = 'Gwag';
$string['enabled'] = 'Wedi galluogi';
$string['endtest'] = 'Gorffen y cynnig ...';
$string['erroraccessingreport'] = 'Allwch chi ddim gweld yr adroddiad hwn';
$string['errorinquestion'] = 'Gwall yn y cwestiwn';
$string['errormissingquestion'] = 'Gwall: Nid oes gan y system gwestiwn gydag id {$a}';
$string['errornotnumbers'] = 'Gwall - rhaid i\'r atebion fod yn rhif';
$string['errorunexpectedevent'] = 'Wedi canfod cod digwyddiad annisgwyl {$a->event} yn y cwestiwn {$a->questionid} yn y cynnig {$a->attemptid}.';
$string['essay'] = 'Traethawd';
$string['essayquestions'] = 'Cwestiynau';
$string['everynquestions'] = 'Bob {$a} cwestiwn';
$string['everyquestion'] = 'Pob cwestiwn';
$string['everythingon'] = 'Popeth ar';
$string['export'] = 'Allgludo';
$string['exportcategory'] = 'allgludo\'r categori';
$string['exporterror'] = 'Mae gwall wedi digwydd yn ystod y broses allgludo';
$string['exportingquestions'] = 'Mae\'r cwestiynau\'n cael eu hallgludo i\'r ffeil';
$string['exportname'] = 'Enw\'r ffeil';
$string['exportquestions'] = 'Allgludo cwestiynau i ffeil';
$string['extraattemptrestrictions'] = 'Cyfyngiadau ychwanegol ar gynigion';
$string['false'] = 'Gau';
$string['feedback'] = 'Adborth';
$string['feedbackerrorboundaryformat'] = 'Rhaid i ffiniau graddio\'r adborth fod mewn canrannau neu rifau. Ni lwyddwyd i adnabod y gwerth a roesoch {$a}.';
$string['feedbackerrorboundaryoutofrange'] = 'Dylai ffinau graddio\'r adborth fod rhwng 0% a 100%. Mae\'r gwerth a roesoch yn ffin {$a} y tu allan i\'r ystod.';
$string['feedbackerrorjunkinboundary'] = 'Rhaid i chi lenwi blychau ffiniau graddio\'r adborth heb adael unrhyw fylchau.';
$string['feedbackerrorjunkinfeedback'] = 'Rhaid i chi lenwi\'r blychau adborth heb adael unrhyw fylchau.';
$string['feedbackerrororder'] = 'Rhaid i ffiniau graddio\'r adborth fod mewn trefn, o\'r uchaf i\'r isaf. Nid yw\'r gwerth a roesoch yn ffin {$a} mewn trefn.';
$string['file'] = 'Ffeil';
$string['fileformat'] = 'Fformat Ffeil';
$string['fillcorrect'] = 'Llenwch gyda\'r un cywir';
$string['filloutnumericalanswer'] = 'Dylech ddarparu o leiaf un ateb posibl a goddefiad. Defnyddir yr ateb cyntaf sy\'n cyfateb i benderfynu ar sgôr ac adborth. Os rhowch chi adborth heb ateb ar y diwedd, bydd myfyrwyr yn gweld hyn os nad yw eu hateb yn cyd-fynd ag unrhyw atebion eraill.';
$string['filloutoneanswer'] = 'Dylech ddarparu o leiaf un ateb  posibl. Ni ddefnyddir atebion sy\'n cael eu gadael yn wag. Gellir defnyddio \'*\' fel \'nod chwilio\' i gyfateb ag unrhyw lythrennau neu rifau. Bydd yr ateb cyntaf sy\'n cyfateb yn cael ei ddefnyddio i benderfynu ar sgôr ac adborth.';
$string['filloutthreequestions'] = 'Dylech ddarparu o leiaf tri chwestiwn  gydag atebion yn cyfateb. Gallwch ddarparu rhagor o atebion anghywir drwy roi ateb gyda chwestiwn gwag. Os yw\'r cwestiwn a\'r ateb yn wag, cânt eu hanwybyddu.';
$string['fillouttwochoices'] = 'Rhaid i chi lenwi o leiaf dau ddewis.  Ni ddefnyddir dewisiadau a adawyd yn wag.';
$string['finishattemptdots'] = 'Gorffen y cynnig...';
$string['finishreview'] = 'Gorffen adolygu';
$string['forceregeneration'] = 'gorfodi adfywiad';
$string['formatnotfound'] = 'Heb lwyddo i ddod o hyd i fformat mewngludo/allgludo {$a}';
$string['formatnotimplemented'] = 'Nid yw\'r fformat hwn wedi cael ei roi ar waith yn gywir. Postiwch adroddiad i gofnodi bygiau';
$string['formulaerror'] = 'Gwallau fformiwla!';
$string['fractionsaddwrong'] = 'Nid yw\'r graddau positif a ddewsioch yn gwneud cyfanswm o 100%<br />Yn hytrach, maent yn gwneud cyfanswm o {$a}%<br />Ydych chi am fynd yn ôl i gywiro\'r cwestiwn hwn?';
$string['fractionsnomax'] = 'Dylai un o\'r atebion fod yn 100% fel ei fod yn <br/> bosibl cael gradd lawn ar gyfer y cwestiwn hwn. Ydych chi am fynd yn ôl i gywiro\'r cwestiwn hwn?';
$string['fromfile'] = 'o ffeil:';
$string['functiondisabledbysecuremode'] = 'Does dim modd defnyddio\'r weithred honno ar hyn o bryd';
$string['generalfeedback'] = 'Adborth cyffredinol';
$string['generalfeedback_help'] = 'Adborth cyffredinol yw testun sy\'n ymddangos ar ôl rhoi cynnig ar gwestiwn. Yn wahanol i adborth ar gwestiwn penodol sy\'n dibynnu ar yr ateb a roddwyd, bydd yr un adborth cyffredinol yn ymddangos bob tro.';
$string['grade'] = 'Gradd';
$string['gradeall'] = 'Graddio\'r Cwbl';
$string['gradeaverage'] = 'Gradd gyfartalog';
$string['gradeboundary'] = 'Ffiniau\'r Graddau';
$string['gradeessays'] = 'Graddio Traethodau';
$string['gradehighest'] = 'Gradd uchaf';
$string['grademethod'] = 'Dull graddio';
$string['grademethod_help'] = 'Pan fydd hawl rhoi mwy nag un cynnig, bydd y dulliau canlynol ar gael ar gyfer cyfrifo gradd derfynol y cwis: * Y radd uchaf o\'r holl gynigion * Gradd gyfartalog (cymedr) pob cynnig * Cynnig cyntaf (bydd pob cynnig arall yn cael ei anwybyddu) * Cynnig olaf (bydd pob cynnig arall yn cael ei anwybyddu)';
$string['gradesdeleted'] = 'Wedi dileu graddau cwis';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Marciau ar gyfer y gwaith hwn: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Ar ôl cyfrifo\'r cosbau blaenorol, mae hyn yn rhoi cyfanswm o <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Cafodd y gwaith hwn ei gosbi: {$a}.';
$string['gradingdetailszeropenalty'] = 'Ni chawsoch eich cosbi am y gwaith hwn.';
$string['gradingmethod'] = 'Dull graddio: {$a}';
$string['groupoverrides'] = 'Diystyru grŵp';
$string['groupsnone'] = 'Does dim grwpiau yn y cwrs hwn';
$string['guestsno'] = 'Mae\'n flin gennyf, ni chaiff gwesteion weld na rhoi cynnig ar gwis';
$string['hidebreaks'] = 'Cuddio toriadau tudalen';
$string['hidereordertool'] = 'Cuddio\'r offeryn aildrefnu';
$string['history'] = 'Hanes yr Ymatebion:';
$string['howquestionsbehave_desc'] = 'Y gosodiad diofyn ar gyfer ymddygiad cwestiynau mewn cwis.';
$string['imagedisplay'] = 'Delwedd i\'w harddangos';
$string['import'] = 'Mewngludo';
$string['importcategory'] = 'mewngludo categori';
$string['importerror'] = 'Digwyddodd gwall yn ystod y broses mewngludo';
$string['importfilearea'] = 'Mewngludo o ffeil sydd eisoes yn ffeiliau\'r cwrs...';
$string['importfileupload'] = 'Mewngludo o ffeil a lwythwyd i fyny...';
$string['importfromthisfile'] = 'Mewngludo o\'r ffeil hon';
$string['import_help'] = 'Mae\'r weithred hon yn eich galluogi chi i fewngludo cwestiynau o ffeiliau testun allanol. Os yw eich ffeil yn cynnwys nodau non-ascii, yna rhaid defnyddio amgodio UTF-8. Byddwch yn ofalus iawn â ffeiliau sy\'n cael eu cynhyrchu gan raglenni Microsoft Office, oherwydd mae\'r rhain fel arfer yn defnyddio amgodio arbennig sy\'n anodd delio â nhw. Ategion yw fformatau Mewngludo ac Allgludo. Efallai fod fformatau dewisol eraill ar gael yn y gronfa ddata Modiwlau ac Ategion.';
$string['importingquestions'] = 'Mewngludo {$a} cwestiwn o\'r ffeil';
$string['importmax10error'] = 'Mae gwall yn y cwestiwn. Efallai nad oes gennych mwy na deg ateb';
$string['importmaxerror'] = 'Mae gwall yn y cwestiwn. Mae gormod o atebion.';
$string['importquestions'] = 'Mewngludo cwestiynau o\'r ffeil';
$string['inactiveoverridehelp'] = '* Nid oes gan y myfyriwr y swyddogaeth na\'r grŵp cywir i roi cynnig ar y cwis';
$string['incorrect'] = 'Anghywir';
$string['indivresp'] = 'Atebion Unigolion i Bob Eitem';
$string['info'] = 'Gwybodaeth';
$string['infoshort'] = 'gwyb';
$string['inprogress'] = 'Ar y gweill';
$string['introduction'] = 'Cyflwyniad';
$string['invalidattemptid'] = 'Does dim ID cynnig o\'r fath yn bodoli';
$string['invalidcategory'] = 'ID y Categori yn annilys';
$string['invalidnumericanswer'] = 'Nid oedd un o\'r atebion a roesoch yn rhif dilys.';
$string['invalidnumerictolerance'] = 'Nid oedd un o\'r goddefiadau a roesoch yn rhif dilys.';
$string['invalidoverrideid'] = 'ID diystyru annilys';
$string['invalidquestionid'] = 'ID cwestiwn annilys';
$string['invalidquizid'] = 'ID cwis annilys';
$string['invalidsource'] = 'Nid yw\'r ffynhonnell yn cael ei derbyn fel un dilys';
$string['invalidsourcetype'] = 'Math annilys o ffynhonnell';
$string['invalidstateid'] = 'ID cyflwr annilys';
$string['lastanswer'] = 'Eich ateb diwethaf oedd';
$string['layout'] = 'Cynllun';
$string['layoutasshown'] = 'Cynllun y dudalen fel a ddangosir';
$string['layoutasshownwithpages'] = 'Cynllun y dudalen fel a ddangosir. <small>(Tudalen newydd yn awtomatig bob {$a} cwestiwn.)</small>';
$string['layoutshuffledandpaged'] = 'Cwestiynau\'n cael eu cymysgu ar hap gyda {$a} cwestiwn ar bob tudalen';
$string['layoutshuffledsinglepage'] = 'Cwestiynau\'n cael eu cymysgu ar hap, bob un ar yr un tudalen';
$string['link'] = 'Dolen';
$string['listitems'] = 'Rhestr o Eitemau mewn Cwis';
$string['literal'] = 'Llythrennol';
$string['loadingquestionsfailed'] = 'Llwytho\'r cwestiynau wedi methu: {$a}';
$string['makecopy'] = 'Cadw fel cwestiwn newydd';
$string['managetypes'] = 'Rheoli mathau o gwestiynnau a gweinyddion';
$string['manualgrading'] = 'Graddio';
$string['mark'] = 'Cyflwyno';
$string['markall'] = 'Cyflwyno\'r dudalen';
$string['marks'] = 'Marciau';
$string['match'] = 'Cyfateb';
$string['matchanswer'] = 'Ateb sy\'n cyfateb';
$string['matchanswerno'] = 'Ateb sy\'n cyfateb {$a}';
$string['max'] = 'Uchafswm';
$string['messageprovider:confirmation'] = 'Cadarnhad o\'r cwisiau a gyflwynoch';
$string['messageprovider:submission'] = 'Hysbysiad o gwisiau a gyflwynwyd';
$string['min'] = 'Lleiafswm';
$string['minutes'] = 'Munudau';
$string['missingcorrectanswer'] = 'Mae\'n rhaid rhoi ateb cywir';
$string['missingitemtypename'] = 'Enw coll';
$string['missingquestion'] = 'Mae\'n ymddangos nad ydy\'r cwestiwn hwn yn bodoli mwyach';
$string['modulename'] = 'Cwis';
$string['modulenameplural'] = 'Cwisiau';
$string['moveselectedonpage'] = 'Symud y cwestiynau a ddewiswyd i dudalen: {$a}';
$string['multichoice'] = 'Aml-ddewis';
$string['multipleanswers'] = 'Dewiswch o leiaf un ateb.';
$string['multiplier'] = 'Lluoswr';
$string['name'] = 'Enw';
$string['navnojswarning'] = 'Rhybudd: fydd y dolenni hyn ddim yn cadw eich atebion. Defnyddiwch y botwm Nesaf ar waelod y dudalen.';
$string['neverallononepage'] = 'Byth, pob cwestiwn ar un dudalen';
$string['newattemptfail'] = 'Gwall: Doedd dim modd dechrau cynnig newydd ar gwis';
$string['newpage'] = 'Tudalen newydd';
$string['newpageevery'] = 'Cychwyn tudalen newydd yn awtomatig';
$string['newpage_help'] = 'Ar gyfer cwisiau hirach, mae\'n gwneud synnwyr i ymestyn y cwis dros sawl tudalen drwy gyfyngu ar nifer y cwestiynau ar bob tudalen. Wrth ychwanegu cwestiwn at y cwis, bydd toriadau tudalen yn cael eu mewnosod yn awtomatig yn unol â\'r gosodiad. Fodd bynnag, gallwch dynnu toriadau tudalen yn nes ymlaen ar y dudalen olygu.';
$string['noanswers'] = 'Ni ddewiswyd atebion!';
$string['noattempts'] = 'Nid oes neb wedi rhoi cynnig ar y cwis hwn';
$string['noattemptsfound'] = 'Heb ganfod dim un cynnig.';
$string['noattemptstoshow'] = 'Dim cynigion i\'w dangos';
$string['nocategory'] = 'Anghywir neu heb ddewis categori penodol';
$string['noclose'] = 'Dim dyddiad cau';
$string['nocommentsyet'] = 'Dim sylwadau hyd yn hyn.';
$string['noconnection'] = 'Nid oes cysylltiad gyda gwasanaeth gwefan a all broseu\'r cwestiwn yma. Cysylltwch â\'ch gweinyddwr os gwelwch yn dda.';
$string['nodataset'] = 'dim - nid yw\'n nod chwilio';
$string['nodatasubmitted'] = 'Does dim data wedi\'i gyflwyno.';
$string['noessayquestionsfound'] = 'Heb lwyddo i ddod o hyd i gwestiynau i\'w graddio â llaw';
$string['nogradewarning'] = 'Dydy\'r cwis ddim wedi cael ei raddio, felly allwch chi ddim pennu adborth cyffredinol sy\'n amrywio yn ôl y radd.';
$string['nomoreattempts'] = 'Ni chewch roi cynnig arall arni';
$string['none'] = 'Dim un';
$string['noopen'] = 'Dim dyddiad agor';
$string['nooverridedata'] = 'Rhaid i chi ddiystyru o leiaf un o osodiadau\'r cwis.';
$string['nopossibledatasets'] = 'Dim setiau data posibl';
$string['noquestionintext'] = 'Nid yw testun y cwestiwn yn cynnwys unrhyw gwestiynau a fewnosodwyd';
$string['noquestions'] = 'Nid oes cwestiynau wedi\'u hychwanegu eto';
$string['noquestionsfound'] = 'Heb ddod o hyd i gwestiynau';
$string['noquestionsinquiz'] = 'Does dim cwestiynau yn y cwis hwn.';
$string['noquestionsnotinuse'] = 'Dydy\'r cwestiwn ar hap hwn ddim yn bodoli, gan fod ei gategori yn wag.';
$string['noquestionsonpage'] = 'Tudalen wag';
$string['noresponse'] = 'Dim Ymateb';
$string['noreview'] = 'Ni chewch adolygu\'r cwis hwn';
$string['noreviewattempt'] = 'Chewch chi ddim adolygu\'r cynnig hwn.';
$string['noreviewshort'] = 'Dim hawl';
$string['noreviewuntil'] = 'Ni chewch adolygu\'r cwis hwn tan {$a}';
$string['noreviewuntilshort'] = 'Ar gael {$a}';
$string['noscript'] = 'Rhaid galluogi JavaScript er mwyn bwrw ymlaen!';
$string['notavailabletostudents'] = 'Cofiwch: Nid yw\'r cwis hwn ar gael i\'ch myfyrwyr ar hyn o bryd';
$string['notenoughrandomquestions'] = 'Does dim digon o gwestiynau yn y categori {$a->category} i greu\'r cwestiwn {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nid oes digon o is-gwestiynau wedi cael eu diffinio!<br />Ydych chi am fynd yn ôl i gywiro\'r cwestiwn hwn?';
$string['notimedependentitems'] = 'Nid yw modiwl y cwis yn gallu cefnogi eitemau sy\'n dibynnu ar amser. I ddatrys hyn, rhowch gyfyngiad amser ar gyfer cwblhau\'r cwis cyfan. Ydych chi am ddewis eitem wahanol(neu defnyddio\'r eitem hon beth bynnag)?';
$string['notyetgraded'] = 'Heb ei raddio eto';
$string['notyetviewed'] = 'Heb edrych arno eto';
$string['notyourattempt'] = 'Nid eich cynnig chi yw hwn!';
$string['noview'] = 'Dydy\'r defnyddiwr sydd wedi mewngofnodi ddim yn cael gweld y cwis hwn';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} wedi gwneud {$a->attemptnum} cynnig';
$string['numattemptsmade'] = '{$a} cynnig wedi\'u gwneud ar y cwis hwn';
$string['numberabbr'] = '#';
$string['numerical'] = 'Rhifol';
$string['numquestionsx'] = 'Cwestiynau: {$a}';
$string['onlyteachersexport'] = 'Dim ond athrawon all allgludo cwestiynau';
$string['onlyteachersimport'] = 'Dim ond athrawon gyda hawliau golygu sy\'n gallu mewngludo cwestiynau';
$string['onthispage'] = 'Y dudalen hon';
$string['open'] = 'Heb ateb';
$string['openclosedatesupdated'] = 'Wedi diweddaru dyddiadau agor a chau\'r cwis';
$string['optional'] = 'dewisol';
$string['orderandpaging'] = 'Trefn a rhannu tudalennau';
$string['orderandpaging_help'] = 'Mae\'r rhifau 10, 20, 30, ... gyferbyn â phob cwestiwn yn nodi trefn y cwestiynau. Mae\'r rhifau\'n cynyddu mewn camau o 10 er mwyn gadael lle i roi cwestiynau ychwanegol i mewn. I aildrefnu\'r cwestiynau, newidiwch y rhifau yna cliciwch y botwm "Aildrefnu\'r cwestiynau". I ychwanegu toriadau tudalen ar ôl cwestiynau penodol, ticiwch y blychau nesaf at y cwestiynau yna clicio\'r botwm "Ychwanegu tudalennau newydd ar ôl y cwestiynau a ddewiswyd". I drefnu\'r cwestiynau dros sawl tudalen, cliciwch y botwm \'Ail-osod tudalennau\' a dewis nifer y cwestiynau ar bob tudalen.';
$string['orderingquiz'] = 'Trefn a rhannu tudalennau';
$string['outof'] = '{$a->grade} allan o uchafswm o {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} o uchafswm o {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Adborth cyffredinol';
$string['overallfeedback_help'] = 'Adborth cyffredinol yw\'r testun sy\'n ymddangos ar ôl rhoi cynnig ar gwis. Drwy bennu ffiniau\'r graddau ychwanegol (fel canran neu rif), bydd y testun sy\'n ymddangos yn dibynnu ar y radd a gafwyd.';
$string['overdue'] = 'Hwyr';
$string['override'] = 'Diystyru';
$string['overridedeletegroupsure'] = 'Ydych chi\'n siŵr eich bod am ddileu\'r gosodiad diystyru ar gyfer y grŵp {$a}?';
$string['overridedeleteusersure'] = 'Ydych chi\'n siŵr eich bod am ddileu\'r gosodiad diystyru ar gyfer y defnyddiwr {$a}?';
$string['overridegroup'] = 'Diystyru grŵp';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Diystyru';
$string['overrideuser'] = 'Diystyru defnyddiwr';
$string['overrideusereventname'] = '{$a->quiz} - Diystyru';
$string['page-mod-quiz-edit'] = 'Golygu tudalen gwis';
$string['page-mod-quiz-x'] = 'Unrhyw dudalen modiwl cwis';
$string['pagesize'] = 'Nifer y cynigion a ddangosir ar bob tudalen';
$string['parent'] = 'Rhiant';
$string['parentcategory'] = 'Categori rhiant';
$string['parsingquestions'] = 'Dosrannu cwestiynau o\'r ffeil mewngludo.';
$string['partiallycorrect'] = 'Rhannol gywir';
$string['penalty'] = 'Cosb';
$string['penaltyscheme'] = 'Rhoi Cosbau';
$string['penaltyscheme_help'] = 'Os yw hwn wedi\'i alluogi, bydd pwyntiau cosb yn cael eu tynnu o\'r marc terfynol am roi ateb anghywir i gwestiwn. Bydd maint y gosb wedi\'i bennu yng ngosodiadau\'r cwestiwn. Dim ond os yw\'r modd addasu wedi\'i alluogi y bydd y gosodiad hwn ar waith.';
$string['percentcorrect'] = 'Canran Cywir';
$string['pleaseclose'] = 'Mae eich cais wedi cael ei brosesu. Gallwch gau\'r ffenestr hon yn awr.';
$string['pluginadministration'] = 'Gweinyddu\'r Modiwl Cwis';
$string['pluginname'] = 'Cwis';
$string['popup'] = 'Dangos y cwis mewn ffenestr &quot;ddiogel&quot;';
$string['popupblockerwarning'] = 'Mae\'r adran hon o\'r prawf yn y modd diogel. Golyga hyn fod angen i chi ateb y cwis mewn ffenestr ddiogel. Diffoddwch eich Rhwystrwr Ffenestri Powld. Diolch.';
$string['popupnotice'] = 'Bydd myfyrwyr yn gweld y cwis hwn mewn ffenestr ddiogel';
$string['preprocesserror'] = 'Digwyddodd gwall cyn prosesu!';
$string['preview'] = 'Rhagolwg';
$string['previewquestion'] = 'Rhagolwg o\'r cwestiwn';
$string['previewquiz'] = 'Rhagolwg o {$a}';
$string['previewquiznow'] = 'Rhagolwg o\'r cwis nawr';
$string['previous'] = 'Cyflwr cynharach';
$string['publish'] = 'Cyhoeddi';
$string['publishedit'] = 'Mae\'n rhaid bod gennych ganiatâd yn y cwrs cyhoeddi i ychwanegu neu olygu cwestiynau yn y categori hwn';
$string['qbrief'] = 'C. {$a}';
$string['qname'] = 'enw';
$string['qti'] = 'Fformat IMS QTI';
$string['qtypename'] = 'math, enw';
$string['question'] = 'Cwestiwn';
$string['questionbankcontents'] = 'Cynnwys y banc cwestiynau';
$string['questionbankmanagement'] = 'Rheoli\'r banc cwestiynau';
$string['questionbehaviour'] = 'Ymddygiad y cwestiwn';
$string['questioncats'] = 'Categorïau Cwestiwn';
$string['questiondeleted'] = 'Mae\'r cwestiwn hwn wedi ei ddileu. Holwch eich athro.';
$string['questioninuse'] = 'Mae\'r cwestiwn \'{$a->questionname}\' yn cael ei ddefnyddio ar hyn o bryd yn: <br />{$a->quiznames}<br />Ni chaiff y  cwestiwn ei ddileu o\'r cwisiau, dim ond o\'r rhestr categori.';
$string['questionmissing'] = 'Mae\'r cwestiwn ar gyfer y sesiwn hon ar goll';
$string['questionname'] = 'Enw\'r cwestiwn';
$string['questionnonav'] = '<span class="accesshide">Cwestiwn </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Gwybodaeth </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Dydy\'r cwestiwn {$a} ddim wedi cael ei lwytho o\'r gronfa ddata';
$string['questionorder'] = 'Trefn cwestiynau';
$string['questions'] = 'Cwestiynau';
$string['questionsinclhidden'] = 'Cwestiynau (yn cynnwys rhai cudd)';
$string['questionsinthisquiz'] = 'Cwestiynau yn y cwis hwn';
$string['questionsperpage'] = 'Cwestiynau ar bob tudalen';
$string['questionsperpageselected'] = 'Mae nifer y cwestiynau ar bob tudalen wedi\'i phennu. O ganlyniad, mae\'r gosodiadau rhannu tudalennau wedi\'u hanalluogi. Gallwch newid hyn yn {$a}.';
$string['questionsperpagex'] = 'Cwestiynau ar bob tudalen: {$a}';
$string['questiontext'] = 'Testun y cwestiwn';
$string['questiontextisempty'] = '[Testun cwestiwn yn wag]';
$string['questiontype'] = 'Math o gwestiwn {$a}';
$string['questiontypesetupoptions'] = 'Dewisiadau ar gyfer mathau o gwestiynau:';
$string['quiz:attempt'] = 'Rhoi cynnig ar gwis';
$string['quizavailable'] = 'Mae\'r cwis ar gael tan: {$a}';
$string['quizclose'] = 'Cau\'r cwis';
$string['quizclosed'] = 'Mae\'r cwis hwn wedi dod i ben ar {$a}';
$string['quizcloses'] = 'Cwis yn cau';
$string['quizcloseson'] = 'Bydd y cwis hwn yn dod i ben am {$a}';
$string['quiz:deleteattempts'] = 'Dileu cynigion ar gwis';
$string['quiz:emailconfirmsubmission'] = 'Cael neges gadarnhau ar ôl cyflwyno gwaith';
$string['quiz:emailnotifysubmission'] = 'Cael neges hysbysu pan fydd cynnig yn cael ei gyflwyno';
$string['quiz:grade'] = 'Graddio cwisiau â llaw';
$string['quiz:ignoretimelimits'] = 'Anwybyddu\'r cyfyngiadau amser ar gwisiau';
$string['quizisclosed'] = 'Mae\'r cwrs hwn wedi dod i ben';
$string['quizisclosedwillopen'] = 'Cwis ar gau (bydd ar agor {$a})';
$string['quizisopen'] = 'Mae\'r cwrs hwn ar agor';
$string['quizisopenwillclose'] = 'Cwis ar agor (bydd yn cau {$a})';
$string['quiz:manage'] = 'Rheoli cwisiau';
$string['quiz:manageoverrides'] = 'Rheoli gosodiadau diystyru cwis';
$string['quiznavigation'] = 'Blwch Llywio\'r Cwis';
$string['quizopen'] = 'Agor y cwis';
$string['quizopenclose'] = 'Dyddiadau agor a chau';
$string['quizopenclose_help'] = 'Dim ond ar ôl yr amser agor y bydd myfyrwyr yn gallu dechrau rhoi cynnig arni. Rhaid iddynt gwblhau pob cynnig cyn yr amser cau.';
$string['quizopened'] = 'Mae\'r cwis hwn ar agor.';
$string['quizopenedon'] = 'Agorwyd y cwis ar {$a}';
$string['quizopens'] = 'Cwis yn agor';
$string['quizopenwillclose'] = 'Mae\'r cwis hwn ar agor. Bydd yn cau ar {$a} am';
$string['quizordernotrandom'] = 'Dydy trefn y cwis ddim wedi\'i gymysgu';
$string['quizorderrandom'] = '* Mae trefn y cwis wedi\'i gymysgu';
$string['quiz:preview'] = 'Rhagolwg o\'r cwisiau';
$string['quiz:regrade'] = 'Graddio pob cynnig ar gwis eto';
$string['quiz:reviewmyattempts'] = 'Adolygu eich cynigion eich hun';
$string['quizsettings'] = 'Gosodiadau\'r Cwis';
$string['quiztimer'] = 'Amserydd y Cwis';
$string['quiz:view'] = 'Gweld gwybodaeth am y cwis';
$string['quiz:viewreports'] = 'Gweld adroddiadau am y cwis';
$string['quizwillopen'] = 'Bydd y cwis hwn yn agor {$a}';
$string['random'] = 'Cwestiwn ar Hap';
$string['randomcreate'] = 'Creu Cwestiynnau Ar Hap';
$string['randomfromcategory'] = 'Cwestiwn ar hap o\'r categori:';
$string['randomfromexistingcategory'] = 'Cwestiwn ar hap o gategori sydd eisoes yn bodoli';
$string['randomnosubcat'] = 'Cwestiynau o\'r categori hwn yn unig, ac nid o\'i is-gategorïau.';
$string['randomquestionusinganewcategory'] = 'Cwestiwn ar hap gan ddefnyddio categori newydd';
$string['randomwithsubcat'] = 'Cwestiynau o\'r categori hwn a\'i is-gategorïau.';
$string['readytosend'] = 'Rydych chi ar fin anfon eich cwis i gael ei raddio. Ydych chi\'n siŵr eich bod am fwrw ymlaen?';
$string['reattemptquiz'] = 'Rhoi cynnig arall ar y cwis';
$string['recentlyaddedquestion'] = 'Cwestiwn a ychwanegwyd yn diweddar!';
$string['recurse'] = 'Dangos cwestiynau o is-gategoriau hefyd';
$string['regrade'] = 'Ailraddio pob cynnig';
$string['regradecomplete'] = 'Mae pob cynnig wedi cael eu graddio';
$string['regradecount'] = 'Mae {$a->changed} allan o {$a->attempt} gradd wedi\'u newid';
$string['regradedisplayexplanation'] = 'Caiff cynigion sy\'n newid ar ôl cael eu hailraddio eu dangos fel hyperddolen i ffenestr adolygu\'r cwestiwn';
$string['regradenotallowed'] = 'Nid oes gennych hawl i ailraddio\'r cwis hwn';
$string['regradingquestion'] = 'Ailraddio "{$a}".';
$string['regradingquiz'] = 'Ailraddio Cwis "{$a}"';
$string['remove'] = 'Tynnu';
$string['removeallquizattempts'] = 'Dileu pob cynnig ar gwis';
$string['removeemptypage'] = 'Tynnu\'r dudalen wag';
$string['removeselected'] = 'Tynnu\'r hyn a ddewiswyd';
$string['rename'] = 'Ailenwi';
$string['renderingserverconnectfailed'] = 'Nid yw\'r gweinydd {$a} wedi llwyddo i brosesu cais RQP. Gwnewch yn siŵr fod yr URL yn gywir.';
$string['reorderquestions'] = 'Ail-drefnu\'r cwestiynau';
$string['reordertool'] = 'Dangos y teclyn ail-drefnu';
$string['repaginate'] = 'Ail-osod y dudalen gyda {$a} cwestiwn ar bob tudalen';
$string['repaginatecommand'] = 'Ail-osod tudalennau';
$string['repaginatenow'] = 'Ail-osod tudalennau nawr';
$string['replace'] = 'Cyfnewid';
$string['replacementoptions'] = 'Dewisiadau Cyfnewid';
$string['report'] = 'Adroddiadau';
$string['reportanalysis'] = 'Dadansoddi Eitem';
$string['reportfullstat'] = 'Ystadegau manwl';
$string['reportmulti_percent'] = 'Aml-Ganran';
$string['reportmulti_q_x_student'] = 'Dewisiadau Aml-fyfyriwr';
$string['reportmulti_resp'] = 'Atebion Unigol';
$string['reportnotfound'] = 'Adroddiad dieithr ({$a})';
$string['reportoverview'] = 'Trosolwg';
$string['reportregrade'] = 'Ailraddio cynigion';
$string['reportresponses'] = 'Ymatebion manwl';
$string['reports'] = 'Adroddiadau';
$string['reportsimplestat'] = 'Ystadegau syml';
$string['requirepassword'] = 'Angen cyfrinair';
$string['requirepassword_help'] = 'Os ydych yn gofyn am gyfrinair, rhaid i fyfyriwr ei roi er mwyn rhoi cynnig ar y cwis.';
$string['requiresubnet'] = 'Angen cyfeiriad rhwydwaith';
$string['requiresubnet_help'] = 'Gallai mynediad at gwis gael ei gyfyngu i isrwydi penodol ar y LAN neu ar y Rhyngrwyd drwy nodi rhestr o rifau cyfeiriad IP llawn neu rannol gyda choma rhyngddynt. Gall hyn fod yn ddefnyddiol ar gyfer cwis wedi\'i oruchwylio, er mwyn sicrhau mai dim ond pobl mewn lleoliad penodol sy\'n gallu cael mynediad at y cwis.';
$string['response'] = 'Ymateb';
$string['responses'] = 'Ymatebion';
$string['results'] = 'Canlyniadau';
$string['reuseifpossible'] = 'Ailddefnyddio\'r hyn a dynwyd yn flaenorol';
$string['reverttodefaults'] = 'Mynd yn ôl i osodiadau diofyn y cwis';
$string['review'] = 'Adolygu';
$string['reviewafter'] = 'Caniatáu adolygu ar ôl i\'r cwis ddod i ben';
$string['reviewalways'] = 'Caniatáu adolygu ar unrhyw adeg';
$string['reviewattempt'] = 'Adolygu\'r cynnig';
$string['reviewbefore'] = 'Caniatáu adolygu pan fo\'r cwis ar agor';
$string['reviewclosed'] = 'Ar ôl i\'r cwis ddod i ben';
$string['reviewduring'] = 'Yn ystod y cynnig';
$string['reviewimmediately'] = 'Yn syth ar ôl rhoi cynnig arno';
$string['reviewnever'] = 'Peidio byth â chaniatáu adolygu';
$string['reviewofattempt'] = 'Adolgiad o\'r Cynnig {$a}';
$string['reviewofpreview'] = 'Adolygu\'r rhagolwg';
$string['reviewopen'] = 'Yn nes ymlaen, pan fo\'r cwis yn dal ar agor';
$string['reviewoptions'] = 'Caiff myfyrwyr adolygu';
$string['reviewoptionsheading'] = 'Opsiynau adolygu';
$string['reviewresponse'] = 'Adolygu ymateb';
$string['reviewresponsetoq'] = 'Adolygu\'r ymateb (cwestiwn {$a})';
$string['reviewthisattempt'] = 'Adolygu eich ymatebion yn y cynnig hwn';
$string['rqp'] = 'Cwestiwn o Bell';
$string['rqps'] = 'Cwestiynau o Bell';
$string['sameasoverall'] = 'Yr un peth â graddau cyffredinol';
$string['save'] = 'Cadw';
$string['saveandedit'] = 'Cadw\'r newidiadau a golygu\'r cwestiynau';
$string['saveattemptfailed'] = 'Heb lwyddo i gadw\'r cynnig presennol ar y cwis.';
$string['savedfromdeletedcourse'] = 'Cadwyd o\'r cwrs a ddilewyd: "{$a}"';
$string['savegrades'] = 'Cadw graddau';
$string['savemyanswers'] = 'Cadw fy atebion';
$string['savenosubmit'] = 'Cadw heb ei gyflwyno';
$string['saveoverrideandstay'] = 'Cadw a chyflwyno gosodiad diystyru arall';
$string['savequiz'] = 'Cadw\'r cwis cyfan';
$string['saving'] = 'Wrthi\'n cadw';
$string['savingnewgradeforquestion'] = 'Wrthi\'n cadw gradd newydd ar gyfer ID cwestiwn {$a}.';
$string['savingnewmaximumgrade'] = 'Wrthi\'n cadw\'r radd uchaf bosib newydd.';
$string['score'] = 'Sgôr crai';
$string['scores'] = 'Sgoriau';
$string['select'] = 'Dewis';
$string['selectall'] = 'Dewis y cyfan';
$string['selectcategory'] = 'Dewis categori';
$string['selectedattempts'] = 'Cynigion a ddewisiwyd...';
$string['selectnone'] = 'Dad-dicio pob un';
$string['selectquestiontype'] = '-- Dewiswch fath o gwestiwn --';
$string['serveradded'] = 'Wedi ychwanegu gweinydd';
$string['serveridentifier'] = 'Dynodwr';
$string['serverinfo'] = 'Gwybodaeth am y gweinydd';
$string['servers'] = 'Gweinyddion';
$string['serverurl'] = 'Gweinydd URL';
$string['settingsoverrides'] = 'Diystyru gosodiadau';
$string['shortanswer'] = 'Ateb Byr';
$string['show'] = 'Dangos';
$string['showall'] = 'Dangos yr holl gwestiynau ar un dudalen';
$string['showblocks'] = 'Dangos y blociau yn ystod cynigion ar gwis';
$string['showblocks_help'] = 'Os yw hwn wedi\'i alluogi, yna bydd blociau normal yn ymddangos yn ystod cynigion ar gwis';
$string['showbreaks'] = 'Dangos toriadau tudalen';
$string['showcategorycontents'] = 'Dangos cynnwys categori {$a->arrow}';
$string['showcorrectanswer'] = 'Dangos yr atebion cywir yn yr adborth?';
$string['showdetailedmarks'] = 'Dangos manylion am y marc';
$string['showeachpage'] = 'Dangos un dudalen ar y tro';
$string['showfeedback'] = 'Dangos adborth ar ôl ateb?';
$string['showinsecurepopup'] = 'Defnyddio ffenestr naid \'ddiogel\' ar gyfer cynigion';
$string['shownoattempts'] = 'Dangos y myfyrwyr sydd heb roi cynnig arni';
$string['shownoattemptsonly'] = 'Dim ond dangos myfyrwyr sydd heb roi cynnig arni';
$string['showteacherattempts'] = 'Dangos cynigion athro';
$string['showuserpicture'] = 'Dangos llun y defnyddiwr';
$string['showuserpicture_help'] = 'Os yw hwn wedi\'i alluogi, bydd enw a llun y myfyriwr yn ymddangos ar y sgrin yn ystod y cynnig, ac ar y sgrin adolygu. Bydd hyn yn ei gwneud yn haws sicrhau bod y myfyriwr wedi mewngofnodi fel ef ei hun mewn arholiad wedi\'i oruchwylio.';
$string['shuffle'] = 'Cymysgu';
$string['shuffleanswers'] = 'Cymysgu atebion';
$string['shuffledrandomly'] = 'Wedi\'u cymysgu ar hap';
$string['shufflequestions'] = 'Cymysgu cwestiynau';
$string['shufflequestionsselected'] = 'Mae cymysgu ar hap wedi\'i alluogi, felly bydd rhaid gweithredoedd tudalen ddim ar gael. I newid y dewis cymysgu, {$a}.';
$string['shufflewithin'] = 'Cymysgu oddi fewn i gwestiynau';
$string['shufflewithin_help'] = 'Os yw hwn wedi\'i alluogi, bydd y rhannau sy\'n cyfrannu at bob cwestiwn yn cael eu cymysgu ar hap bob tro y bydd myfyriwr yn rhoi cynnig ar gwis, ar yr amod bod y dewis hwn hefyd wedi\'i alluogi yng ngosodiadau\'r cwestiwn. Mae\'r cwestiwn hwn ddim ond yn berthnasol i gwestiynau gyda mwy nag un rhan, megis cwestiynau aml-ddewis neu gwestiynau sy\'n cyfateb.';
$string['singleanswer'] = 'Dewiswch un ateb.';
$string['sortage'] = 'Trefnu yn ôl oedran';
$string['sortalpha'] = 'Trefnu yn ôl enw';
$string['sortquestionsbyx'] = 'Trefnu cwestiynau yn ôl: {$a}';
$string['sortsubmit'] = 'Trenfu\'r cwestiynau';
$string['sorttypealpha'] = 'Trefnu yn ôl math, enw';
$string['specificapathnotonquestion'] = 'Dydy\'r llwybr ffeil a nodwyd ddim ar y cwestiwn a nodwyd';
$string['specificquestionnotonquiz'] = 'Dydy\'r cwestiwn a nodwyd ddim ar y cwis a nodwyd';
$string['startagain'] = 'Cychwyn eto';
$string['startattempt'] = 'Rhoi cynnig arni';
$string['startedon'] = 'Wedi cychwyn ar';
$string['startnewpreview'] = 'Dechrau rhagolwg newydd';
$string['statenotloaded'] = 'Dydy cyflwr y cwestiwn {$a} ddim wedi\'i lwytho o\'r gronfa ddata';
$string['status'] = 'Statws';
$string['stoponerror'] = 'Stopio ar ôl cyrraedd gwall';
$string['submitallandfinish'] = 'Cyflwyno\'r cwbl a gorffen';
$string['subneterror'] = 'Mae\'n flin gennyf, mae\'r cwis hwn wedi\'i gloi sy\'n golygu mai o rai lleoliadau\'n unig y gellir ei agor. Nid yw\'ch cyfrifiadur chi\'n un o\'r rheini sy\'n cael defnyddio\'r cwis ar hyn o bryd.';
$string['subnetnotice'] = 'Mae\'n flin gennyf, mae\'r cwis hwn wedi\'i gloi sy\'n golygu mai o rai lleoliadau\'n unig y gellir ei agor. Nid yw\'ch cyfrifiadur chi ar isrwyd derbyniol. Fel athro, cewch weld y rhagolwg.';
$string['subplugintype_quiz'] = 'Adroddiad';
$string['subplugintype_quiz_plural'] = 'Adroddiadau';
$string['substitutedby'] = 'yn cael ei ddisodli gan';
$string['summaryofattempt'] = 'Crynodeb o\'r cynnig';
$string['summaryofattempts'] = 'Crynodeb o\'ch cynigion blaenorol';
$string['temporaryblocked'] = 'Ni chewch roi cynnig arall ar y cwis ar hyn o bryd.<br /> Cewch gyfle arall i roi cynnig arno ar:';
$string['theattempt'] = 'Y cynnig';
$string['time'] = 'Amser';
$string['timecompleted'] = 'Amser Gorffen';
$string['timedelay'] = 'Ni chewch roi cynnig ar y cwis gan nad yw\'r cyfnod amser wedi dirwyn i ben cyn y cewch roi cynnig ar gwis arall.';
$string['timeleft'] = 'Amser sydd ar ôl';
$string['timelimit'] = 'Cyfyngiad amser';
$string['timelimitexeeded'] = 'Mae\'n flin gennyf! Mae amser y cwis wedi dod i ben!';
$string['timelimitmin'] = 'Terfyn amser (munudau)';
$string['timelimitsec'] = 'Terfyn amser (eiliadau)';
$string['timestr'] = '%H:%M:%S ar %d/%m/%y';
$string['timesup'] = 'Mae\'r amser wedi dod i ben!';
$string['timetaken'] = 'Amser a gymerwyd';
$string['tofile'] = 'i\'r ffeil';
$string['tolerance'] = 'Goddefiad';
$string['toomanyrandom'] = 'Mae nifer y cwestiynau ar hap yn fwy nag sydd ar gael yn y categori!';
$string['top'] = 'Top';
$string['totalquestionsinrandomqcategory'] = 'Cyfanswm o {$a} cwestiwn yn y categori.';
$string['true'] = 'Gwir';
$string['truefalse'] = 'Gwir/Gau';
$string['type'] = 'Math';
$string['unfinished'] = 'agor';
$string['ungraded'] = 'Heb ei raddio';
$string['unit'] = 'Uned';
$string['unknowntype'] = 'Nid yw\'r llinell {$a} yn cefnogi\'r math hwn o gwestiwn. Caiff y cwestiwn ei anwybyddu';
$string['unusedcategorydeleted'] = 'Mae\'r categori hwn wedi\'i ddileu oherwydd, ar ôl dileu\'r cwrs, ni chaiff y cwestiynau eu defnyddio mwyach.';
$string['updatesettings'] = 'Diweddaru gosodiadau\'r cwis';
$string['updatingatttemptgrades'] = 'Diweddaru graddau cynigion.';
$string['updatingfinalgrades'] = 'Diweddaru\'r graddau terfynol.';
$string['updatingthegradebook'] = 'Diweddaru\'r llyfr graddau.';
$string['upgradesure'] = '<div style="color: red;">Yn benodol, bydd modiwl y cwis yn gwneud newid sylweddol i\'r tablau cwis ac nid yw\'r diweddariad hwn wedi cael ei brofi\'n ddigonol. Rydym yn argymell yn gryf y dylech greu copi wrth gefn o\'ch  tablau cronfa ddata cyn bwrw ymlaen.';
$string['upgradingquizattempts'] = 'Uwchraddio cynigion ar gwis: cwis {$a->done}/{$a->outof} (ID y cwis {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Uwchraddio cynigion hen iawn ar gwis: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Mae\'r categori hwn wedi ei gadw a\'i symud i lefel y safle oherwydd ei fod yn gategori a gyhoeddwyd ac sy\'n cael ei ddefnyddio o hyd gan gyrsiau eraill.';
$string['useroverrides'] = 'Dewisiadau diystyru\'r defnyddiwr';
$string['usersnone'] = 'Does gan ddim un myfyriwr fynediad at y cwis hwn';
$string['validate'] = 'Dilysu';
$string['viewallanswers'] = 'Gweld {$a} cynnig ar y cwis';
$string['viewallreports'] = 'Gweld adroddiadau ar gyfer {$a} cynnig';
$string['viewed'] = 'Wedi gweld';
$string['warningmissingtype'] = '<b>Nid yw\'r math hwn o gwis wedi\'i osod ar Moodle eto. <br />Rhowch wybod i\'ch gweinydd Moodle.</b>';
$string['wheregrade'] = 'Ble mae fy ngradd?';
$string['wildcard'] = 'Nod chwilio';
$string['windowclosing'] = 'Bydd y ffenestr hon yn cau cyn bo hir.';
$string['withsummary'] = 'Gyda Chrynodeb o\'r Ystadegau';
$string['wronguse'] = 'Ni chewch ddefnyddio\'r dudalen fel hyn';
$string['xhtml'] = 'Fformat XHTML';
$string['youneedtoenrol'] = 'Rhaid i chi gofrestru ar y cwrs hwn cyn y gallwch roi cynnig ar y cwis hwn.';
$string['yourfinalgradeis'] = 'Dyma\'ch gradd derfynol am y cwis hwn: {$a}';
