<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Gweithred';
$string['addanotherhint'] = 'Ychwanegu awgrym arall';
$string['addcategory'] = 'Ychwanegu categori';
$string['addmorechoiceblanks'] = 'Gwag ar gyfer {nif} Dewis Arall';
$string['adminreport'] = 'Adrodd ar broblemau posibl yn eich cronfa ddata o gwestiynau.';
$string['answer'] = 'Ateb';
$string['answers'] = 'Atebion';
$string['answersaved'] = 'Wedi cadw\'r ateb';
$string['attemptfinished'] = 'Wedi gorffen y cynnig';
$string['attemptfinishedsubmitting'] = 'Wedi gorffen cyflwyno\'r cynnig:';
$string['attemptoptions'] = 'Dewisiadau ymgais';
$string['availableq'] = 'Ar gael?';
$string['badbase'] = 'Sylfaen wael cyn **: {$a}**';
$string['behaviour'] = 'Ymddygiad';
$string['behaviourbeingused'] = 'Ymddygiad sy\'n cael ei ddefnyddio: {$a}';
$string['broken'] = 'Mae hon yn "ddolen wedi torri", sy\'n cyfeirio at ffeil nad yw\'n bodoli.';
$string['byandon'] = 'gan <em>{$a->user}</em> am <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Doedd dim modd creu copi o\'r ffeil wrth gefn';
$string['cannotcreate'] = 'Doedd dim modd creu cofnod newydd yn y tabl question_attempts';
$string['cannotcreatepath'] = 'Does dim modd creu llwybr: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Does dim modd i chi ddileu\'r ymddygiad \'{$a}\'. Mae\'n cael ei ddefnyddio gan gynigion ar gwestiynau.';
$string['cannotdeletecate'] = 'Does dim modd dileu\'r categori hwnnw gan mai dyma\'r categori diofyn ar gyfer y cyd-destun hwn.';
$string['cannotdeleteneededbehaviour'] = 'Does dim modd dileu ymddygiad cwestiwn \'{$a}\'. Mae ymddygiadau eraill wedi\'u gosod sy\'n dibynnu arno.';
$string['cannotdeleteqtypeinuse'] = 'Does dim modd dileu\'r math o gwestiwn \'{$a}\'. Mae cwestiynau o\'r math yma yn y banc cwestiynau.';
$string['cannotdeleteqtypeneeded'] = 'Does dim modd dileu\'r math o gwestiwn \'{$a}\'. Mae mathau o gwestiynau eraill wedi\'u gosod sy\'n dibynnu arno.';
$string['cannotenable'] = 'Does dim modd creu\'r math o gwestiwn {$a} yn uniongyrchol.';
$string['cannotenablebehaviour'] = 'Does dim modd defnyddio\'r ymddygiad cwestiwn {$a} yn uniongyrchol. I\'w ddefnyddio\'n fewnol yn unig.';
$string['cannotfindcate'] = 'Doedd dim modd dod o hyd i gofnod y categori';
$string['cannotfindquestionfile'] = 'Doedd dim modd dod o hyd i ffeil ddata\'r cwestiwn yn zip';
$string['cannotgetdsfordependent'] = 'Does dim modd cael y set ddata benodol ar gyfer cwestiwn sy\'n ddibynnol ar set ddata! (cwestiwn: {$a->id}, datasetitem: {$a->item})';
$string['cannotgetdsforquestion'] = 'Does dim modd cael y set ddata benodol ar gyfer cwestiwn sydd angen ei gyfrifo! (cwestiwn: {$a})';
$string['cannothidequestion'] = 'Doedd dim modd cuddio\'r cwestiwn';
$string['cannotimportformat'] = 'Yn anffodus, nid yw proses mewngludo\'r fformat wedi\'i rhoi ar waith eto!';
$string['cannotinsertquestion'] = 'Doedd dim modd mewnosod cwestiwn newydd!';
$string['cannotinsertquestioncatecontext'] = 'Doedd dim modd mewnosod y categori cwestiwn newydd {$a->cat} contextid anghyfreithlon {$a->ctx}';
$string['cannotloadquestion'] = 'Doedd dim modd llwytho\'r cwestiwn';
$string['cannotmovequestion'] = 'Does dim modd i chi ddefnyddio\'r sgript hon i symud cwestiynau sydd â ffeiliau\'n gysylltiedig â nhw o wahanol fannau.';
$string['cannotopenforwriting'] = 'Does dim modd agor i ysgrifennu: {$a}';
$string['cannotpreview'] = 'Does dim modd cael rhagolwg o\'r cwestiynau hyn!';
$string['cannotread'] = 'Does dim modd darllen y ffeil mewngludo (neu mae\'r ffeil yn wag)';
$string['cannotretrieveqcat'] = 'Doedd dim modd adfer categori\'r cwestiwn';
$string['cannotunhidequestion'] = 'Wedi methu datguddio\'r cwestiwn.';
$string['cannotunzip'] = 'Doedd dim modd echdynnu\'r ffeil.';
$string['cannotwriteto'] = 'Does dim modd ysgrifennu cwestiynau a allgludwyd i {$a}';
$string['category'] = 'Categori';
$string['categorycurrent'] = 'Categori presennol';
$string['categorycurrentuse'] = 'Defnyddio\'r categori hwn';
$string['categorydoesnotexist'] = 'Nid yw\'r categori hwn yn bodoli';
$string['categoryinfo'] = 'Gwybodaeth am y categori';
$string['categorymove'] = 'Mae\'r categori \'{$a->name}\' yn cynnwys {$a->count} cwestiwn (gall rhai fod yn hen ac yn gudd ac sy\'n dal i gael eu defnyddio mewn rhai cwisiau cyfredol). <br />Dewiswch eu symud i gategori arall.';
$string['categorymoveto'] = 'Cadw yn y categori';
$string['categorynamecantbeblank'] = 'Ni chaiff enw\'r categori fod yn wag.';
$string['changeoptions'] = 'Newid opsiynau';
$string['changepublishstatuscat'] = 'Bydd statws rhannu\'r <a href="{$a->caturl}">Categori "{$a->name}"</a> yn y cwrs "{$a->coursename}" yn newid o  <strong>{$a->changefrom} i {$a->changeto}</strong>.';
$string['check'] = 'Gwirio';
$string['chooseqtypetoadd'] = 'Dewis math o gwestiwn i\'w ychwanegu';
$string['clearwrongparts'] = 'Clirio ymatebion anghywir';
$string['clickflag'] = 'Fflagio cwestiwn';
$string['clicktoflag'] = 'Fflagio\'r cwestiwn hwn er mwyn gallu cyfeirio ato\'n y dyfodol';
$string['clicktounflag'] = 'Dileu\'r fflag';
$string['clickunflag'] = 'Dileu\'r fflag';
$string['closepreview'] = 'Cau\'r rhagolwg';
$string['combinedfeedback'] = 'Adborth cyfunol';
$string['comment'] = 'Sylw';
$string['commented'] = 'Sylwadau: {$a}';
$string['commentormark'] = 'Rhoi sylw neu anwybyddu\'r nod';
$string['comments'] = 'Sylwadau';
$string['commentx'] = 'Sylw: {$a}';
$string['complete'] = 'Cwblhau';
$string['contexterror'] = 'Ddylech chi ddim fod wedi cyrraedd yma os nad ydych chi\'n symud categori i gyd-destun arall.';
$string['copy'] = 'Creu copi o {$a} a newid dolenni.';
$string['correct'] = 'Cywir';
$string['correctfeedback'] = 'Ar gyfer unrhyw ymateb cywir';
$string['correctfeedbackdefault'] = 'Mae eich ateb yn gywir.';
$string['created'] = 'Crëwyd';
$string['createdby'] = 'Crëwyd gan';
$string['createdmodifiedheader'] = 'Crëwyd / cadwyd ddiwethaf';
$string['createnewquestion'] = 'Creu cwestiwn newydd ...';
$string['cwrqpfs'] = 'Cwestiynau ar hap gan ddewis cwestiynau o isgategorïau.';
$string['cwrqpfsinfo'] = '<p>Wrth uwchraddio i Moodle 1.9 byddwn yn gwahanu categorïau cwestiynau yn gyd-destunau gwahanol. Bydd yn rhaid newid statws rhannu rhai cwestiynau a chategorïau cwestiynau ar eich safle. Mae angen gwneud hyn oherwydd gallai achos prin godi lle mae un neu fwy o gwestiynau \'ar hap\' mewn cwis yn cael eu gosod i ddewis o blith categorïau sydd wedi\'u rhannu a heb eu rhannu (fel sy\'n wir ar y safle hwn). Mae hyn yn digwydd pan fo cwestiwn \'ar hap\' yn cael ei osod i ddewis o isgategorïau, ac mae gan un neu fwy o\'r isgategorïau hynny statws rhannu gwahanol i\'r categori rhiant lle crëwyd y cwestiynau ar hap.</p>
<p>Wrth ddiweddaru i Moodle 1.9, bydd statws rhannu categorïau\'r cwestiynau canlynol, lle mae\'r cwestiynau \'ar hap\' yn y rhiant-gategori yn dewis y cwestiynau, yn newid i\'r un statws rhannu a\'r categori gyda\'r cwestiwn \'ar hap\'. Bydd statws rhannu\'r categorïau canlynol yn newid. Bydd cwestiynau y bydd hyn yn effeithio arnynt yn parhau i weithio ym mhob cwis nes eich bod yn eu tynnu o\'r cwisiau hyn.</p>';
$string['cwrqpfsnoprob'] = 'Ni chaiff categorïau cwestiwn ar eich safle eu heffeithio gan y mater \'Cwestiynau ar hap yn dewis cwestiynau o isgategorïau\'.';
$string['decimalplacesingrades'] = 'Llefydd degol yn y graddau';
$string['defaultfor'] = 'Dewis diofyn ar gyfer {$a}';
$string['defaultinfofor'] = 'Y categori diofyn ar gyfer cwestiynau sy\'n cael eu rhannu yng nghyd-destun \'{$a}\'.';
$string['defaultmark'] = 'Nod diofyn';
$string['defaultmarkmustbepositive'] = 'Mae\'n rhaid i\'r nod diofyn fod yn bositif.';
$string['deletecoursecategorywithquestions'] = 'Mae cwestiynau yn y banc cwestiynau sy\'n gysylltiedig â chategori\'r cwrs. Drwy fwrw ymlaen, byddant yn cael eu dileu. Efallai y byddwch am eu symud yn gyntaf, drwy ddefnyddio\'r rhyngwyneb banc cwestiynau.';
$string['deletequestioncheck'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu \'{$a}\'?';
$string['deletequestionscheck'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu\'r cwestiynau canlynol?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Wrthi\'n dileu ymddygiad cwestiwn \'{$a}\'';
$string['deletingqtype'] = 'Wrthi\'n dileu\'r math o gwestiwn \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Ddim yn cyfateb i unrhyw ateb]';
$string['disabled'] = 'Wedi\'i analluogi';
$string['displayoptions'] = 'Dangos y dewisiadau';
$string['disterror'] = 'Mae\'r dosbarthiad {$a} wedi achosi problemau';
$string['donothing'] = 'Peidiwch â chopïo na symud ffeiliau, na newid dolenni.';
$string['editcategories'] = 'Golygu categorïau';
$string['editcategories_help'] = 'Yn hytrach na chadw popeth ar un rhestr fawr, gellir trefnu cwestiynau\'n gategorïau ac yn isgategorïau.
Mae gan bob categori gyd-destun sy\'n pennu lle gellir defnyddio\'r cwestiynau yn y categori:
* Cyd-destun gweithgaredd - Cwestiynau sydd ond ar gael yn y modiwl gweithgaredd
* Cyd-destun cwrs - Cwestiynau sydd ar gael ym mhob modiwl gweithgaredd yn y cwrs
* Cyd-destun categori\'r cwrs - Cwestiynau sydd ar gael ym mhob modiwl gweithgaredd a chyrsiau yng nghategori\'r cwrs
* Cyd-destun system - Cwestiynau sydd ar gael ym mhob cwrs a gweithgaredd ar y safle.

Bydd categorïau’n cael eu defnyddio ar gyfer cwestiynau ar hap hefyd, gan fod cwestiynau\'n cael eu dewis o gategori penodol.';
$string['editcategory'] = 'Golygu categori';
$string['editingcategory'] = 'Golygu categori';
$string['editingquestion'] = 'Golygu cwestiwn';
$string['editquestion'] = 'Golygu cwestiwn';
$string['editquestions'] = 'Golygu cwestiynau';
$string['editthiscategory'] = 'Golygu\'r categori hwn';
$string['emptyxml'] = 'Gwall dieithr - imsmanifest.xml gwag';
$string['enabled'] = 'Wedi\'i alluogi';
$string['erroraccessingcontext'] = 'Does dim modd cael mynediad at y cyd-destun';
$string['errordeletingquestionsfromcategory'] = 'Gwall wrth ddileu\'r cwestiynau o\'r categori {$a}.';
$string['errorduringpost'] = 'Digwyddodd gwall ar ôl prosesu!';
$string['errorduringpre'] = 'Digwyddodd gwall cyn prosesu!';
$string['errorduringproc'] = 'Digwyddodd gwall wrth brosesu!';
$string['errorduringregrade'] = 'Doedd dim modd ailraddio\'r cwestiwn {$a->qid}, mynd i\'r statws {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Gwall: does dim modd creu copi o\'r ffeil {$a}.';
$string['errorfilecannotbemoved'] = 'Gwall: does dim modd symud y ffeil {$a}.';
$string['errorfileschanged'] = 'Gwall: mae\'r ffeiliau sydd wedi\'u cysylltu â\'r cwestiynau wedi newid ers i\'r ffurflen gael ei dangos.';
$string['errormanualgradeoutofrange'] = 'Nid yw\'r radd {$a->grade} rhwng 0 a {$a->maxgrade} ar gyfer y cwestiwn {$a->name}. Nid yw\'r sgôr na\'r sylw wedi cael eu cadw.';
$string['errormovingquestions'] = 'Gwall wrth symud cwestiynau gydag ids {$a}.';
$string['errorpostprocess'] = 'Digwyddodd gwall ar ôl prosesu!';
$string['errorpreprocess'] = 'Digwyddodd gwall cyn prosesu!';
$string['errorprocess'] = 'Digwyddodd gwall wrth brosesu!';
$string['errorprocessingresponses'] = 'Roedd gwall wrth brosesu eich ymatebion ({$a}). Cliciwch bwrw ymlaen i fynd yn ôl i\'r dudalen roeddech chi arni i roi cynnig arall arni.';
$string['errorsavingcomment'] = 'Gwall wrth gadw\'r sylw ar gyfer y cwestiwn {$a->name} yn y gronfa ddata.';
$string['errorsavingflags'] = 'Gwall wrth gadw\'r statws fflag.';
$string['errorupdatingattempt'] = 'Gwall wrth ddiweddaru\'r cynnig {$a->id} yn y gronfa ddata.';
$string['exportcategory'] = 'Allgludo categori';
$string['exportcategory_help'] = 'Mae\'r gosodiad hwn yn pennu o ba gategori y bydd y cwestiynau a allgludir yn cael eu cymryd.
Mae rhai fformatau mewngludo, megis GIFT a Moodle XML, yn caniatáu i ddata cyd-destun a chategorïau gael eu cynnwys yn y ffeil a allgludir, gan ei gwneud yn bosib (yn ddewisol) eu hail-greu wrth fewngludo. I wneud hyn, dylid rhoi tic yn y blychau priodol.';
$string['exporterror'] = 'Gwallau wrth allgludo!';
$string['exportfilename'] = 'cwis';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Allgludo cwestiynau i ffeil';
$string['exportquestions_help'] = 'Mae\'r weithred hon yn ei gwneud yn bosib i allgludo categori cyflawn (ac unrhyw isgategorïau) o gwestiynau i ffeil. Gan ddibynnu ar fformat y ffeil a ddewisir, efallai na fydd modd allgludo rhai mathau o gwestiynau a data cwestiynau.';
$string['feedback'] = 'Adborth';
$string['filecantmovefrom'] = 'Does dim modd symud ffeiliau’r cwestiynau gan nad oes gennych chi hawl i dynnu\'r ffeiliau o\'r man lle rydych chi\'n ceisio symud y cwestiynau.';
$string['filecantmoveto'] = 'Does dim modd symud na chopïo ffeiliau’r cwestiynau gan nad oes gennych chi hawl i ychwanegu ffeiliau i\'r man lle rydych chi\'n ceisio symud y cwestiynau.';
$string['fileformat'] = 'Fformat y ffeil';
$string['filesareacourse'] = 'ardal y ffeiliau cwrs';
$string['filesareasite'] = 'ardal y ffeiliau safle';
$string['filestomove'] = 'Symud / copïo ffeiliau i {$a}?';
$string['fillincorrect'] = 'Llenwi\'r ymatebion cywir';
$string['flagged'] = 'Wedi\'i fflagio';
$string['flagthisquestion'] = 'Rhoi fflag ar y cwestiwn hwn';
$string['formquestionnotinids'] = 'Roedd y ffurflen yn cynnwys cwestiwn nad yw yn questionids';
$string['fractionsnomax'] = 'Dylai un o\'r atebion gael sgôr o 100% fel bo modd cael marciau llawn am y cwestiwn hwn.';
$string['generalfeedback'] = 'Adborth cyffredinol';
$string['generalfeedback_help'] = 'Bydd adborth cyffredinol yn cael ei ddangos i\'r myfyriwr ar ôl iddo roi cynnig ar y cwestiwn. Yn wahanol i adborth, sy\'n dibynnu ar y math o gwestiwn ac ar ymateb y myfyriwr, bydd y testun adborth cyffredinol yn cael ei ddangos i bob myfyriwr. Gallwch ddefnyddio\'r adborth cyffredinol i roi ateb llawn i\'r myfyrwyr neu i ddarparu dolen at ragor o wybodaeth y gallant ei defnyddio os nad oeddent yn deall y cwestiynau.';
$string['getcategoryfromfile'] = 'Cael categori o ffeil';
$string['getcontextfromfile'] = 'Cael cyd-destun o ffeil';
$string['hidden'] = 'Wedi\'i guddio';
$string['hintn'] = 'Awgrym {no}';
$string['hintnoptions'] = 'Awgrym {no} dewisiadau';
$string['hinttext'] = 'Testun awgrymiadau';
$string['howquestionsbehave'] = 'Ymddygiad cwestiynau';
$string['howquestionsbehave_help'] = 'Gall y myfyrwyr ryngweithio â\'r cwestiynau yn y cwis mewn nifer o wahanol ffyrdd. Er enghraifft, efallai y byddwch am i\'r myfyrwyr roi ateb i bob cwestiwn ac yna cyflwyno\'r cwis i gyd cyn y bydd modd graddio unrhyw beth neu gael unrhyw adborth. Y modd \'Gohirio adborth\' fyddai hwnnw. Neu, efallai y byddwch am i\'r myfyrwyr gyflwyno pob cwestiwn wrth fynd er mwyn cael adborth yn syth, ac os nad ydynt yn cael y cwestiwn yn gywir yn syth, fod modd iddynt roi cynnig arall arni am lai o farciau. Y modd \'Rhyngweithiol gyda mwy nag un cynnig\' fyddai hwnnw. Mae’n debyg mai’r rheini yw’r ddau fodd mwyaf cyffredin o ymddygiad.';
$string['ignorebroken'] = 'Anwybyddu dolenni sydd wedi torri';
$string['importcategory'] = 'Mewngludo categori';
$string['importcategory_help'] = 'Mae\'r gosodiad hwn yn pennu i ba gategori y bydd y cwestiynau a fewngludir yn mynd.

Mae\'n bosib y bydd ambell fformat mewngludo, megis GIFT a Moodle XML, yn cynnwys data cyd-destun a chategori yn y ffeil mewngludo. I ddefnyddio\'r data, yn hytrach na\'r categori a ddewiswyd, dylid rhoi tic yn y blychau priodol. Os nad yw\'r categorïau yn y ffeil mewngludo yn bodoli, byddant yn cael eu creu.';
$string['importerror'] = 'Digwyddodd gwall yn ystod y broses mewngludo';
$string['importerrorquestion'] = 'Gwall wrth fewngludo cwestiwn';
$string['importfromcoursefiles'] = '...neu dewiswch ffeil cwrs i\'w mewngludo.';
$string['importfromupload'] = 'Dewiswch ffeil i\'w llwytho i fyny...';
$string['importingquestions'] = 'Wrthi\'n mewngludo {$a} cwestiwn o\'r ffeil';
$string['importparseerror'] = 'Wedi canfod gwall(au) wrth ddosbarthu\'r ffeil a fewngludwyd. Heb fewngludo cwestiynau. I fewngludo unrhyw gwestiynau da rhowch gynnig arall arni gan osod \'Stopio os oes gwall\' ar \'Na\'';
$string['importquestions'] = 'Mewngludo cwestiynau o ffeil';
$string['importquestions_help'] = 'Mae\'r weithred hon yn ei gwneud yn bosib mewngludo cwestiynau mewn amrywiaeth o fformatau drwy gyfrwng ffeil testun. Noder ei bod yn rhaid bod y ffeil yn defnyddio system amgodio UTF-8.';
$string['importwrongfiletype'] = 'Nid yw\'r math o ffeil rydych chi wedi\'i dewis ({$a->actualtype}) yn cyfateb i\'r math a ddisgwylir gan y fformat mewngludo hwn ({$a->expectedtype}).';
$string['impossiblechar'] = 'Wedi canfod nod amhosib {$a} fel nod parenthesis';
$string['includesubcategories'] = 'Dangos cwestiynau o isgategorïau hefyd';
$string['incorrect'] = 'Anghywir';
$string['incorrectfeedback'] = 'Ar gyfer unrhyw ymateb anghywir';
$string['incorrectfeedbackdefault'] = 'Mae eich ateb yn anghywir.';
$string['information'] = 'Gwybodaeth';
$string['invalidanswer'] = 'Ateb anghyflawn';
$string['invalidarg'] = 'Dim argiau dilys wedi\'u darparu neu ffurfweddiad gweinydd anghywir';
$string['invalidcategoryidforparent'] = 'Mae ID categori u rhiant yn annilys!';
$string['invalidcategoryidtomove'] = 'ID categori annilys i\'w symud!';
$string['invalidconfirm'] = 'Roedd y llinyn cadarnhau yn anghywir';
$string['invalidcontextinhasanyquestions'] = 'Cyd-destun annilys wedi\'i basio i question_context_has_any_questions.';
$string['invalidgrade'] = 'Dydy graddau ({$a}) ddim yn cyfateb â dewisiadau gradd - wedi anwybyddu\'r cwestiwn.';
$string['invalidpenalty'] = 'Cosb annilys';
$string['invalidwizardpage'] = 'Does dim tudalen dewin wedi\'i nodi neu mae\'r dudalen yn anghywir!';
$string['lastmodifiedby'] = 'Addaswyd ddiwethaf gan';
$string['linkedfiledoesntexist'] = 'Dydy\'r ffeil gyswllt {$a} ddim yn bodoli';
$string['makechildof'] = 'Creu isgategori o \'{$a}\'';
$string['makecopy'] = 'Creu copi';
$string['maketoplevelitem'] = 'Symud i\'r lefel uchaf';
$string['manualgradeoutofrange'] = 'Mae\'r radd hon oddi allan i\'r ystod ddilys.';
$string['manuallygraded'] = 'Graddiwyd yn bersonol {$a->mark} gyda\'r sylw: {$a->comment}';
$string['mark'] = 'Marc';
$string['markedoutof'] = 'Marc allan o';
$string['markedoutofmax'] = 'Marc allan o {$a}';
$string['markoutofmax'] = 'Marc {$a->mark} allan o {$a->max}';
$string['marks'] = 'Marciau';
$string['matchgrades'] = 'Cyfateb graddau';
$string['matchgradeserror'] = 'Gwall os nad yw\'r radd wedi\'i rhestru';
$string['matchgrades_help'] = 'Mae\'n rhaid i\'r graddau sydd wedi\'u mewngludo gyfateb i un o\'r graddau dilys ar y rhestr sefydlog - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (gwerthoedd negyddol hefyd). Os nad ydynt, ceir dau opsiwn:

*  Gwall os nad yw\'r radd wedi\'i rhestru - Os yw cwestiwn yn cynnwys unrhyw raddau nad ydynt ar y rhestr bydd gwall yn cael ei ddangos ac ni fydd y cwestiwn hwnnw\'n cael ei fewngludo
* Gradd agosaf os nad yw wedi\'i rhestru - Os canfyddir gradd nad yw\'n cyfateb i werth ar y rhestr, bydd y radd yn cael ei newid i\'r gwerth agosaf sy\'n cyfateb ar y rhestr';
$string['matchgradesnearest'] = 'Gradd agosaf os nad yw wedi\'i rhestru';
$string['missingcourseorcmid'] = 'Mae angen darparu ID cwrs neu ID cm i print_question.';
$string['missingcourseorcmidtolink'] = 'Mae angen darparu ID cwrs neu ID cm i  get_question_edit_link.';
$string['missingimportantcode'] = 'Mae cod pwysig ar goll ar gyfer y math hwn o gwestiwn: {$a}.';
$string['missingoption'] = 'Does dim opsiynau yn y cwestiwn llenwi bylchau {$a}';
$string['modified'] = 'Cadwyd ddiwethaf';
$string['move'] = 'Symud o {$a} a newid dolenni.';
$string['movecategory'] = 'Symud categori';
$string['movedquestionsandcategories'] = 'Wedi symud cwestiynau a chategorïau cwestiynau o {$a->oldplace} i {$a->newplace}.';
$string['movelinksonly'] = 'Newidiwch y mannau y mae\'r dolenni\'n arwain iddynt, peidiwch â symud na chopïo ffeiliau.';
$string['moveq'] = 'Symud cwestiwn/cwestiynau';
$string['moveqtoanothercontext'] = 'Symud cwestiwn i gyd-destun arall.';
$string['moveto'] = 'Symud i >>';
$string['movingcategory'] = 'Wrthi\'n symud y categori';
$string['movingcategoryandfiles'] = 'Ydych chi\'n siŵr eich bod am symud y categori {$a->name} a phob isgategori i\'r cyd-destun ar gyfer "{$a->contextto}"?<br /> Rydym wedi canfod {$a->urlcount} o ffeiliau wedi\'u cysylltu â chwestiynau yn {$a->fromareaname}, hoffech chi gopïo neu symud y rhain i {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Ydych chi\'n siŵr eich bod am symud y categori "{$a->name}" a phob isgategori i\'r cyd-destun ar gyfer "{$a->contextto}"?';
$string['movingquestions'] = 'Wrthi\'n symud y cwestiynau ac unrhyw ffeiliau';
$string['movingquestionsandfiles'] = 'Ydych chi\'n siŵr eich bod am symud y cwestiwn/cwestiynau {$a->questions} i gyd-destun ar gyfer <strong>"{$a->tocontext}"</strong>?<br /> Rydym wedi canfod <strong>{$a->urlcount} o ffeiliau</strong> sydd wedi\'u cysylltu â\'r cwestiwn/cwestiynau hyn yn {$a->fromareaname}, fyddech chi\'n hoffi copïo neu symud y rhain i {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Ydych chi\'n siŵr eich bod am symud y cwestiwn/cwestiynau {$a->questions} i gyd-destun ar gyfer <strong>"{$a->tocontext}"</strong>?<br /> Does <strong>dim ffeiliau</strong> wedi\'u cysylltu â\'r cwestiwn/cwestiynau yn {$a->fromareaname}.';
$string['needtochoosecat'] = 'Mae angen i chi ddewis categori i symud y cwestiwn hwn iddo, neu gwasgwch \'canslo\'.';
$string['nocate'] = 'Dim categori o\'r fath {$a}!';
$string['nopermissionadd'] = 'Does gennych ddim hawl i ychwanegu cwestiynau yma.';
$string['nopermissionmove'] = 'Does gennych ddim hawl i symud cwestiynau oddi yma. Mae\'n rhaid i chi gadw\'r cwestiwn yn y categori hwn neu ei gadw fel cwestiwn newydd.';
$string['noprobs'] = 'Heb ddod o hyd i broblemau yng nghronfa ddata eich cwestiynau.';
$string['noquestions'] = 'Heb ddod o hyd i unrhyw gwestiynau y mae modd eu hallgludo. Gwnewch yn siŵr eich bod wedi dewis categori i’w allgludo sy\'n cynnwys cwestiynau.';
$string['noquestionsinfile'] = 'Nid oes cwestiynau yn y ffeil mewngludo';
$string['noresponse'] = '[Dim ymateb]';
$string['notanswered'] = 'Heb ateb';
$string['notchanged'] = 'Heb newid ers y cynnig diwethaf';
$string['notenoughanswers'] = 'Mae angen o leiaf {$a} ateb ar y math hwn o gwestiwn';
$string['notenoughdatatoeditaquestion'] = 'Ni roddwyd ID cwestiwn, ID categori na math o gwestiwn.';
$string['notenoughdatatomovequestions'] = 'Mae angen i chi ddarparu ids cwestiwn y cwestiynau rydych chi am eu symud.';
$string['notflagged'] = 'Dim fflag';
$string['notgraded'] = 'Heb ei raddio';
$string['notshown'] = 'Ddim yn cael ei ddangos';
$string['notyetanswered'] = 'Heb ei ateb eto';
$string['notyourpreview'] = 'Nid yw\'r rhagolwg hwn yn eiddo i chi';
$string['novirtualquestiontype'] = 'Does dim math rhithiad o gwestiwn ar gyfer math o gwestiwn {$a}';
$string['numqas'] = 'Sawl cynnig';
$string['numquestions'] = 'Nifer y cwestiynau';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} wedi\'u cuddio)';
$string['options'] = 'Opsiynau';
$string['orphanedquestionscategory'] = 'Cwestiynau wedi\'u cadw o gategorïau sydd wedi\'u dileu';
$string['orphanedquestionscategoryinfo'] = 'Yn achlysurol, ac yn bennaf oherwydd chwilod o hen feddalwedd, gall cwestiynau aros yn y gronfa ddata er bod eu categori cwestiwn cyfatebol wedi\'i ddileu. Wrth gwrs, ni ddylai hyn ddigwydd, ond mae wedi digwydd ar y safle hwn yn y gorffennol. Mae\'r categori hwn wedi\'i greu yn awtomatig, a\'r cwestiynau amddifad wedi\'u symud yma fel y gallwch eu rheoli. Nodwch fod unrhyw ffeiliau cyfryngau neu ddelweddau oedd yn cael eu defnyddio gan y cwestiynau hyn yn debygol o fod wedi’u colli.';
$string['page-question-category'] = 'Tudalen categorïau cwestiynau';
$string['page-question-edit'] = 'Tudalen golygu cwestiynau';
$string['page-question-export'] = 'Tudalen allgludo cwestiynau';
$string['page-question-import'] = 'Tudalen mewngludo cwestiynau';
$string['page-question-x'] = 'Unrhyw dudalen cwestiynau';
$string['parent'] = 'Rhiant';
$string['parentcategory'] = 'Rhiant-gategori';
$string['parentcategory_help'] = 'Bydd y categori newydd yn cael ei roi yn y rhiant-gategori. Os yw categori ar y "brig", mae\'n golygu nad yw wedi\'i gynnwys mewn unrhyw gategori arall. Bydd cyd-destunau\'r categorïau mewn ffont trwm. Rhaid cael o leiaf un categori ym mhob cyd-destun.';
$string['parenthesisinproperclose'] = 'Parenthesis cyn ** ddim wedi cau\'n briodol yn {$a}**';
$string['parenthesisinproperstart'] = 'Parenthesis cyn ** ddim wedi cychwyn yn briodol yn {$a}**';
$string['parsingquestions'] = 'Dosbarthu cwestiynau o\'r ffeil a fewngludwyd.';
$string['partiallycorrect'] = 'Rhannol gywir';
$string['partiallycorrectfeedback'] = 'Ar gyfer unrhyw ymateb sy\'n rhannol gywir';
$string['partiallycorrectfeedbackdefault'] = 'Mae eich ateb yn rhannol gywir.';
$string['penaltyfactor'] = 'Ffactor cosb';
$string['penaltyfactor_help'] = 'Mae\'r gosodiad hwn yn pennu pa ffracsiwn o\'r sgôr a enillwyd sy\'n cael ei dynnu am bob ymateb anghywir. Dim ond os yw\'r cwis yn cael ei redeg yn y modd addasu y mae\'n berthnasol.

Dylai\'r ffactor cosb fod yn rhif rhwng 0 ac 1. Mae ffactor cosb o 1 yn golygu ei bod yn rhaid i\'r myfyriwr gael yr ateb yn gywir y tro cyntaf er mwyn cael unrhyw fath o glod amdano. Mae ffactor cosb o 0 yn golygu y gall myfyriwr roi cynnig ar y cwestiynau dro ar ôl tro a chael y marciau llawn wrth wneud hynny.';
$string['penaltyforeachincorrecttry'] = 'Cosb am bob ymgais aflwyddiannus';
$string['penaltyforeachincorrecttry_help'] = 'Pan fyddwch yn defnyddio\'r ymddygiad \'Rhyngweithiol gyda mwy nag un cynnig\' neu \'Modd addasu\', gan roi sawl cyfle i\'r myfyriwr gael yr ateb yn gywir, mae\'r opsiwn hwn yn rheoli faint mae\'r myfyriwr yn cael ei gosbi am bob cynnig aflwyddiannus.

Mae\'r gosb yn gyfran o radd y cwestiwn yn ei chyfanrwydd, felly os yw\'r cwestiwn werth tri phwynt, a\'r gosb yn 0.3333333, bydd y myfyriwr yn sgorio 3 os yw\'n cael y cwestiwn yn iawn y tro cyntaf, 2 os yw\'n cael y cwestiwn yn iawn yr eildro, a 1 os yw\'n cael y cwestiwn yn iawn y trydydd tro.';
$string['permissionedit'] = 'Golygu\'r cwestiwn hwn';
$string['permissionmove'] = 'Symud y cwestiwn hwn';
$string['permissionsaveasnew'] = 'Cadw fel cwestiwn newydd';
$string['permissionto'] = 'Mae gennych chi hawl i :';
$string['previewquestion'] = 'Cael rhagolwg o\'r cwestiwn: {$a}';
$string['published'] = 'wedi rhannu';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Mae\'r cwestiwn "{$a->name}" ({$a->qtype})</a> yng nghategori\'r cwestiwn hwn ond mae hefyd yn cael ei ddefnyddio yn <a href="{$a->qurl}">y cwis "{$a->quizname}"</a> mewn cwrs arall "{$a->coursename}".';
$string['questionbank'] = 'Banc cwestiynau';
$string['questionbehaviouradminsetting'] = 'Gosodiadau ymddygiad cwestiynau';
$string['questionbehavioursdisabled'] = 'Ymddygiadau cwestiynau i\'w hanalluogi';
$string['questionbehavioursdisabledexplained'] = 'Rhowch restr o ymddygiadau nad ydych am iddynt ymddangos yn y gwymplen, gan ddefnyddio coma i\'w gwahanu';
$string['questionbehavioursorder'] = 'Trefn ymddygiad cwestiynau';
$string['questionbehavioursorderexplained'] = 'Rhowch restr o ymddygiadau, wedi\'u gwahanu gan gomas, yn y drefn rydych am iddynt ymddangos yn y gwymplen';
$string['questioncategory'] = 'Categori cwestiynau';
$string['questioncatsfor'] = 'Categori cwestiynau ar gyfer \'{$a}\'';
$string['questiondoesnotexist'] = 'Nid yw\'r cwestiwn hwn yn bodoli';
$string['questionidmismatch'] = 'Anghysondeb o ran ids y cwestiwn';
$string['questionname'] = 'Enw\'r cwestiwn';
$string['questionno'] = 'Cwestiwn {$a}';
$string['questionpreviewdefaults_desc'] = 'Mae’r gosodiadau diofyn yma yn cael eu defnyddio pan fydd defnyddiwr yn edrych ar gwestiwn am y tro cyntaf yn y banc cwestiynau. Unwaith y bydd defnyddiwr wedi gweld cwestiwn, bydd ei ddewisiadau personol yn cael eu storio fel dewisiadau defnyddiwr.';
$string['questions'] = 'Cwestiynau';
$string['questionsaveerror'] = 'Gwallau\'n digwydd wrth gadw\'r cwestiwn - ({$a})';
$string['questionsinuse'] = '(* Mae cwestiynau sydd â seren wrth eu hymyl yn cael eu defnyddio\'n barod mewn ambell gwis. Ni fydd y cwestiynau hyn yn cael eu dileu o\'r cwisiau hyn, dim ond o\'r rhestr categorïau.)';
$string['questionsmovedto'] = 'Wedi symud y cwestiynau sy\'n dal i gael eu defnyddio i "{$a}" yn y categori cwrs rhiant.';
$string['questionsrescuedfrom'] = 'Cwestiynau wedi\'u cadw o\'r cyd-destun {$a}.';
$string['questionsrescuedfrominfo'] = 'Cafodd y cwestiynau hyn (rhai ohonynt wedi\'u cuddio o bosib) eu cadw pan gafodd y cyd-destun {$a} ei ddileu oherwydd eu bod yn dal i gael eu defnyddio gan ambell gwis neu weithgaredd arall.';
$string['questiontext'] = 'Testun y cwestiwn';
$string['questiontype'] = 'Math o gwestiwn';
$string['questionuse'] = 'Defnyddio\'r cwestiwn yn y gweithgaredd hwn';
$string['questionvariant'] = 'Amrywiad y cwestiwn';
$string['questionx'] = 'Cwestiwn {$a}';
$string['requiresgrading'] = 'Angen graddio';
$string['responsehistory'] = 'Hanes ymatebion';
$string['restart'] = 'Dechrau eto';
$string['restartwiththeseoptions'] = 'Dechrau eto gyda\'r opsiynau hyn';
$string['reviewresponse'] = 'Adolygu ymateb';
$string['rightanswer'] = 'Ateb cywir';
$string['rightanswer_help'] = 'crynodeb o’r ymateb cywir sydd wedi’i gynhyrchu’n awtomatig. Gall fod yn gyfyngedig, felly efallai y dylech ystyried esbonio’r ateb cywir yn adborth cyffredinol y cwestiwn, a diffodd y dewis hwn.';
$string['save'] = 'Cadw';
$string['saved'] = 'Wedi cadw: {$a}';
$string['saveflags'] = 'Cadw statws y fflagiau';
$string['selectacategory'] = 'Dewiswch gategori:';
$string['selectaqtypefordescription'] = 'Dewiswch fath o gwestiwn er mwyn cael disgrifiad ohono.';
$string['selectcategoryabove'] = 'Dewisiwch gategori uchod';
$string['selectquestionsforbulk'] = 'Dewis cwestiynau ar gyfer gweithredoedd torfol';
$string['settingsformultipletries'] = 'Mwy nag un ymgais';
$string['shareincontext'] = 'Rhannu mewn cyd-destun ar gyfer {$a}';
$string['showhidden'] = 'Dangos hen gwestiynau hefyd';
$string['showmarkandmax'] = 'Dangos y marc a\'r marc uchaf';
$string['showmaxmarkonly'] = 'Dangos y marc uchaf yn unig';
$string['shown'] = 'Dangoswyd';
$string['shownumpartscorrect'] = 'Dangos nifer yr ymatebion cywir';
$string['shownumpartscorrectwhenfinished'] = 'Dangos nifer yr ymatebion cywir';
$string['showquestiontext'] = 'Dangos testun y cwestiwn yn y rhestr cwestiynau';
$string['specificfeedback'] = 'Adborth penodol';
$string['specificfeedback_help'] = 'Adborth sy\'n dibynnu ar yr ymateb a roddwyd gan y myfyriwr';
$string['started'] = 'Wedi cychwyn';
$string['state'] = 'Statws';
$string['step'] = 'Cam';
$string['stoponerror'] = 'Stopio os oes gwall';
$string['stoponerror_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r broses mewngludo yn dod i ben pan ganfyddir gwall, gan arwain at beidio â mewngludo cwestiynau, ynteu a yw unrhyw gwestiynau sy\'n cynnwys gwallau\'n cael eu hanwybyddu, a bod unrhyw gwestiynau dilys yn cael eu mewngludo.';
$string['submissionoutofsequence'] = 'Nid yw\'r dilyniant yn gywir. Peidiwch â chlicio\'r botwm i fynd yn ôl pan rydych chi\'n gweithio ar gwestiynau cwis.';
$string['submissionoutofsequencefriendlymessage'] = 'Rydych chi wedi rhoi data nad yw\'n rhan o\'r dilyniant arferol. Gall hyn ddigwydd os byddwch yn defnyddio botymau Yn ôl ac Ymlaen eich porwr; peidiwch â defnyddio\'r rhain yn ystod y prawf. Gall hefyd ddigwydd os byddwch yn clicio ar rywbeth tra mae\'r dudalen yn llwytho. Cliciwch <strong>Bwrw ymlaen</strong> i barhau.';
$string['submit'] = 'Cyflwyno';
$string['submitandfinish'] = 'Cyflwyno a gorffen';
$string['submitted'] = 'Cyflwyno: {$a}';
$string['technicalinfo'] = 'Gwybodaeth dechnegol';
$string['technicalinfo_help'] = 'Mae’r wybodaeth dechnegol hon yn debygol o fod yn ddefnyddiol dim ond ar gyfer datblygwyr sy’n gweithio ar fathau newydd o gwestiynau. Gall hefyd fod yn ddefnyddiol wrth geisio datrys problemau gyda chwestiynau.';
$string['technicalinfominfraction'] = 'Ffracsiwn lleiaf: {$a}';
$string['technicalinfoquestionsummary'] = 'Crynodeb o\'r cwestiwn: {$a}';
$string['technicalinforightsummary'] = 'Crynodeb o\'r ateb cywir: {$a}';
$string['technicalinfostate'] = 'Cyflwr y cwestiwn: {$a}';
$string['tofilecategory'] = 'Ysgrifennu categori i ffeil';
$string['tofilecontext'] = 'Ysgrifennu cyd-destun i ffeil';
$string['uninstallbehaviour'] = 'Dadosod yr ymddygiad ar gyfer y cwestiwn hwn.';
$string['uninstallqtype'] = 'Dadosod y math o gwestiwn hwn.';
$string['unknown'] = 'Heb adnabod';
$string['unknownbehaviour'] = 'Heb adnabod yr ymddygiad: {$a}.';
$string['unknownorunhandledtype'] = 'Heb adnabod neu heb drin y math hwn o gwestiwn: {$a}';
$string['unknownquestion'] = 'Heb adnabod y cwestiwn: {$a}.';
$string['unknownquestioncatregory'] = 'Heb adnabod categori\'r cwestiwn: {$a}.';
$string['unknownquestiontype'] = 'Heb adnabod y math hwn o gwestiwn: {$a}.';
$string['unknowntolerance'] = 'Heb adnabod y math o oddefiad {$a}';
$string['unpublished'] = 'heb ei rannu';
$string['updatedisplayoptions'] = 'Dewisiadau dangos diweddariad';
$string['upgradeproblemcategoryloop'] = 'Wedi canfod problem wrth uwchraddio\'r categorïau cwestiynau. Mae dolen yn y goeden gategorïau. Yr ids categori dan sylw yw {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Doedd dim modd diweddaru\'r categori cwestiwn {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Wedi canfod problem wrth uwchraddio categorïau\'r cwestiynau. Mae\'r categori {$a->id} yn cyfeirio at y rhiant {$a->parent}, sydd ddim yn bodoli. Wedi newid y rhiant er mwyn datrys y broblem.';
$string['whethercorrect'] = 'P\'un a yw\'n gywir';
$string['whethercorrect_help'] = 'Mae hyn yn cynnwys y disgrifiad testunol ‘Cywir’, ‘Rhannol gywir’ neu ‘Anghywir’, ac unrhyw beth sydd wedi’i amlygu mewn lliw sy’n cyfleu yr un wybodaeth.';
$string['withselected'] = 'Gyda\'r dewis';
$string['wrongprefix'] = 'Rhagddodiad enw {$a} wedi\'i fformatio\'n anghywir';
$string['xoutofmax'] = '{$a->mark} allan o {$a->max}';
$string['yougotnright'] = 'Rydych chi wedi gwneud y dewis cywir yn dewis {$a->num}.';
$string['youmustselectaqtype'] = 'Mae\'n rhaid i chi ddewis math o gwestiwn.';
$string['yourfileshoulddownload'] = 'Dylai\'r ffeil rydych chi\'n ei mewngludo ddechrau llwytho i lawr yn fuan. Os na, gwasgwch <a href="{$a}">cliciwch yma</a>.';
