<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Mae cyfeiriadur y gweinyddwr a roddwyd yn anghywir';
$string['admindirname'] = 'Cyfeiriadur y gweinyddwr';
$string['admindirsetting'] = 'Nifer fach iawn o westeiwyr gwe sy\'n defnyddio /admin fel URL arbennig i chi gael mynd i mewn i\'r
    panel rheoli neu beth bynnag. Yn anffodus, mae hyn yn gwrthdaro â
    lleoliad safonol tudalennau gweinyddol Moodle. Gallwch drwsio hyn drwy
    ailenwi cyfeiriadur y gweinyddwr wrth osod y rhaglen, a rhoi\'r
    enw newydd yma.  Er enghraifft: <br /> <br /><b>gweinyddmoodle</b><br /> <br />
    Bydd hyn yn trwsio\'r dolenni gweinyddol yn Moodle.';
$string['admindirsettinghead'] = 'Gosod cyfeiriadur y gweinyddwr...';
$string['admindirsettingsub'] = 'Nifer fach iawn o westeiwyr gwe sy\'n defnyddio /admin fel URL arbennig i chi gael mynd i mewn i\'r
panel rheoli neu beth bynnag. Yn anffodus, mae hyn yn gwrthdaro â
lleoliad safonol tudalennau gweinyddol Moodle. Gallwch drwsio hyn drwy
ailenwi cyfeiriadur y gweinyddwr wrth osod y rhaglen, a rhoi\'r
enw newydd yma. Er enghraifft: <br /> <br /><b>gweinyddmoodle</b><br /> <br />
Bydd hyn yn trwsio dolenni gweinyddol yn Moodle.';
$string['availablelangs'] = 'Y pecynnau iaith sydd ar gael';
$string['caution'] = 'Gofal';
$string['chooselanguage'] = 'Dewiswch iaith';
$string['chooselanguagehead'] = 'Dewis iaith';
$string['chooselanguagesub'] = 'Dewiswch iaith ar gyfer y broses osod. Bydd yr iaith hon yn cael ei defnyddio fel yr iaith ddiofyn ar gyfer y safle, ond gellir ei newid yn nes ymlaen.';
$string['cliadminpassword'] = 'Cyfrinair gweinyddwr newydd';
$string['cliadminusername'] = 'Enw defnyddiwr gweinyddwr';
$string['clialreadyconfigured'] = 'Mae\'r ffeil config.php yn bodoli eisoes, defnyddiwch admin/cli/install_database.php os ydych chi am osod y safle hwn.';
$string['clialreadyinstalled'] = 'Mae\'r ffeil config.php yn bodoli eisoes, defnyddiwch admin/cli/upgrade.php os ydych chi am uwchraddio eich safle.';
$string['cliinstallfinished'] = 'Roedd y broses osod yn llwyddiannus.';
$string['cliinstallheader'] = 'Rhaglen gosod llinell gorchymyn Moodle {$a}';
$string['climustagreelicense'] = 'Yn y modd nad yw\'n rhyngweithiol mae\'n rhaid i chi gytuno â\'r drwydded drwy nodi\'r opsiwn --agree-license';
$string['clitablesexist'] = 'Mae\'r tablau cronfa ddata eisoes yn bresennol, doedd dim modd i\'r gosodiad cli fynd rhagddo.';
$string['compatibilitysettings'] = 'Wrthi\'n profi eich gosodiadau PHP ...';
$string['compatibilitysettingshead'] = 'Wrthi\'n profi eich gosodiadau PHP ...';
$string['compatibilitysettingssub'] = 'Dylai\'ch gweinydd basio\'r holl brofion hyn fel bod Moodle yn rhedeg yn llwyddiannus';
$string['configfilenotwritten'] = 'Nid oedd y sgript gosod wedi llwyddo i greu ffeil config.php yn awtomatig a oedd yn cynnwys eich gosodiadau personol, fwy na thebyg oherwydd na ellir ysgrifennu dros y cyfeiriadur Moodle. Gallwch gopïo\'r cod canlynol eich hun i ffeil o\'r enw config.php yng nghyfeiriadur gwraidd Moodle.';
$string['configfilewritten'] = 'Wedi llwyddo i greu\'r ffeil config.php yn llwyddiannus';
$string['configurationcomplete'] = 'Wedi gorffen ffurfweddu';
$string['configurationcompletehead'] = 'Wedi gorffen ffurfweddu';
$string['configurationcompletesub'] = 'Ceisiodd Moodle gadw eich ffurfwedd mewn ffeil yng ngwraidd eich rhaglen Moodle.';
$string['database'] = 'Cronfa ddata';
$string['databasehead'] = 'Gosodiadau\'r gronfa ddata';
$string['databasehost'] = 'Gwesteiwr y gronfa ddata';
$string['databasename'] = 'Enw\'r gronfa ddata';
$string['databasepass'] = 'Cyfrinair y gronfa ddata';
$string['databaseport'] = 'Porth y gronfa ddata';
$string['databasesocket'] = 'Soced Unix';
$string['databasetypehead'] = 'Dewis gyrrwr ar gyfer y gronfa ddata';
$string['databasetypesub'] = 'Mae Moodle yn gallu delio â gwahanol fathau o weinyddwyr cronfeydd data. Cysylltwch â gweinyddwr y gweinydd os nad ydych chi\'n gwybod pa fath i\'w ddefnyddio.';
$string['databaseuser'] = 'Defnyddiwr cronfa ddata';
$string['dataroot'] = 'Cyfeiriadur data';
$string['datarooterror'] = 'Heb lwyddo i ddod o hyd i\'r \'Cyfeiriadur Data\' a nodoch neu ni lwyddwyd i\'w greu. Gallwch naill ai gywiro\'r llwybr neu greu\'r cyfeiriadur hwn eich hun.';
$string['datarootpermission'] = 'Hawliau ar gyfer cyfeiriaduron data';
$string['datarootpublicerror'] = 'Mae modd gweld y \'cyfeiriadur data\' a nodoch yn uniongyrchol ar y we. Mae\'n rhaid i chi ddefnyddio cyfeiriadur gwahanol.';
$string['dbconnectionerror'] = 'Heb lwyddo i gysylltu â\'r gronfa ddata a nodoch. Tarwch olwg dros osodiadau eich cronfa ddata.';
$string['dbcreationerror'] = 'Gwall wrth greu cronfa ddata. Heb lwyddo i greu\'r gronfa ddata a enwyd â\'r gosodiadau a roddwyd.';
$string['dbhost'] = 'Gweinydd y gwesteiwr';
$string['dbpass'] = 'Cyfrinair';
$string['dbport'] = 'Porth';
$string['dbprefix'] = 'Llythrennau Blaen Tablau';
$string['dbtype'] = 'Math';
$string['directorysettings'] = '<p>A wnewch chi gadarnhau lleoliadau\'r rhaglen Moodle hon.</p>

<p><b>Cyfeiriad ar y We:</b>
Rhowch y cyfeiriad ar y we llawn lle byddwch yn mynd i mewn i Moodle.
Os gellir defnyddio sawl URL i fynd i mewn i\'ch gwefan yna dewiswch
yr un fyddai\'ch myfyrwyr yn fwyaf tebygol o\'i ddefnyddio. Peidiwch â chynnwys
slaes ar y diwedd.</p>

<p><b>Cyfeiriadur Moodle:</b>
Rhowch y llwybr cyfeiriadur llawn i\'r rhaglen a osodwyd.
Gwnewch yn siŵr eich bod yn defnyddio\'r llythrennau bach/mawr cywir.</p>

<p><b>Cyfeiriadur Data:</b>
Mae Moodle angen lle ar gyfer cadw ffeiliau sy\'n cael eu llwytho i fyny.  Dylai
defnyddiwr gweinydd y we (fel arfer \'neb\' neu \'apache\') allu darllen ac YSGRIFENNU ar y cyfeiriadur hwn,  ond ni ddylid gallu mynd i mewn iddo\'n
uniongyrchol drwy\'r we.</p>';
$string['directorysettingshead'] = 'Cadarnhewch leoliadau\'r rhaglen Moodle hon';
$string['directorysettingssub'] = '<b>Cyfeiriad ar y We:</b>
Rhowch y cyfeiriad ar y we llawn lle byddwch yn mynd i mewn i Moodle.
Os gellir defnyddio sawl URL i fynd i mewn i\'ch gwefan yna dewiswch
yr un fyddai\'ch myfyrwyr yn fwyaf tebygol o\'i ddefnyddio. Peidiwch â chynnwys slaes ar y diwedd.
<br />
<br />
<b>Cyfeiriadur Moodle:</b>
Rhowch y llwybr cyfeiriadur llawn i\'r rhaglen a osodwyd
Gwnewch yn siŵr eich bod yn defnyddio\'r llythrennau bach/mawr cywir.
<br />
<br />
<b>Cyfeiriadur Data:</b>
Mae Moodle angen lle ar gyfer cadw ffeiliau sy\'n cael eu llwytho i fyny. Dylai
defnyddiwr gweinydd y we (fel arfer \'neb\' neu \'apache\') allu darllen ac YSGRIFENNU ar y cyfeiriadur hwn,  ond ni ddylid gallu mynd i mewn iddo\'n
uniongyrchol drwy\'r we.';
$string['dirroot'] = 'Cyfeiriadur Moodle';
$string['dirrooterror'] = 'Yn ôl pob tebyg, mae gosodiadau \'Cyfeiriadur Moodle\' yn anghywir - nid ydym wedi gallu dod o hyd i raglen Moodle yn y fan honno. Mae\'r gwerth isod wedi cael ei ailosod.';
$string['download'] = 'Llwytho i lawr';
$string['downloadlanguagebutton'] = 'Llwytho\'r pecyn iaith &quot;{$a}&quot;';
$string['downloadlanguagehead'] = 'Llwytho\'r pecyn iaith i lawr';
$string['downloadlanguagenotneeded'] = 'Gallwch barhau â\'r broses osod gan ddefnyddio\'r pecyn iaith diofyn, "{$a}".';
$string['downloadlanguagesub'] = 'Nawr, gallwch ddewis llwytho pecyn iaith i lawr a bwrw ymlaen â\'r broses osod yn yr iaith honno.<br /><br />Os nad ydych chi\'n gallu llwytho\'r pecyn iaith i lawr, bydd y broses osod yn cario ymlaen yn Saesneg. (Ar ôl i\'r broses osod ddod i ben, bydd gennych gyfle i lwytho a gosod pecynnau iaith ychwanegol.)';
$string['doyouagree'] = 'Ydych chi\'n cytuno ? (ydw/nac ydw):';
$string['environmenthead'] = 'Wrthi\'n profi eich amgylchedd ...';
$string['environmentsub'] = 'Rydym yn gwneud yn siŵr fod gwahanol gydrannu eich system yn bodloni gofynion y system';
$string['environmentsub2'] = 'Mae gan bob fersiwn Moodle ofyniad fersiwn PHP sylfaenol ac amryw o estyniadau PHP gorfodol.
Bydd yr amgylchedd yn cael ei brofi\'n llawn cyn pob proses osod a diweddaru. Cysylltwch â gweinyddwr y gweinydd os nad ydych chi\'n gwybod sut mae gosod fersiwn newydd neu alluogi estyniadau PHP.';
$string['errorsinenvironment'] = 'Wedi methu profi\'r amgylchedd!';
$string['fail'] = 'Methu';
$string['fileuploads'] = 'Llwytho ffeiliau i fyny';
$string['fileuploadserror'] = 'Dylai hwn fod ymlaen';
$string['fileuploadshelp'] = '<p>Yn ôl pob golwg, nid yw eich gweinydd wedi galluogi llwytho ffeiliau i fyny.</p>

<p>Byddwch dal yn gallu gosod Moodle, ond os nad ydych yn gallu gwneud hyn, ni fyddwch yn gallu
   llwytho ffeiliau cyrsiau na delweddau proffil defnyddwyr i fyny.</p>

<p>I alluogi llwytho ffeiliau i fyny, bydd angen i chi (neu weinyddwr eich system)
   olygu\'r brif ffeil php.ini ar eich system a newid y gosodiad ar gyfer
   <b>file_uploads</b> to \'1\'.</p>';
$string['inputdatadirectory'] = 'Cyfeiriadur data:';
$string['inputwebadress'] = 'Cyfeiriad gwe :';
$string['inputwebdirectory'] = 'Cyfeiriadur Moodle:';
$string['installation'] = 'Gosod';
$string['langdownloaderror'] = 'Yn anffodus, ni osodwyd yr iaith ganlynol: "{$a}". Bydd y broses osod yn cario ymlaen yn Saesneg.';
$string['langdownloadok'] = 'Wedi gosod "{$a}" yn llwyddiannus. Bydd y broses osod yn cario ymlaen yn yr iaith hon.';
$string['magicquotesruntime'] = 'Amser Rhedeg Dyfynodau Hud';
$string['magicquotesruntimeerror'] = 'Dylai hwn fod wedi\'i ddiffodd';
$string['magicquotesruntimehelp'] = '<p>Dylid diffodd Amser Rhedeg Dyfynodau Hud fel bo Moodle yn gweithio\'n iawn.</p>

<p>Fel arfer, mae wedi\'i ddiffodd yn ddiofyn ... tarwch olwg ar y gosodiad <b>magic_quotes_runtime</b> yn eich ffeil php.ini.</p>

<p><p>Os nad ydych yn gallu mynd i mewn i\'ch php.ini, efallai gallwch roi\'r llinell ganlynol mewn ffeil .htaccess yn eich cyfeiriadur Moodle:
   <blockquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Maint y Cof';
$string['memorylimiterror'] = 'Mae maint y cof PHP wedi\'i osod yn eitaf isel ...efallai y cewch broblemau yn nes ymlaen.';
$string['memorylimithelp'] = '<p>Mae maint y cof PHP yn eich gweinydd ar hyn o bryd yn {$a}.</p>

<p>Gall hyn arwain at broblemau â\'r cof yn nes ymlaen, yn enwedig
   os ydych wedi galluogi llawer o fodiwlau a/neu lawer o ddefnyddwyr.</p>

<p>Rydym yn argymell eich bod yn ffurfweddu PHP gyda mwy o gof os yn bosib, megis 40M.
   Mae sawl ffordd o wneud hyn:</p>
<ol>
<li>Os ydych yn gallu, ceisiwch ail-grynhoi PHP gyda <i>--enable-memory-limit</i>.
    Bydd hyn yn gadael i Moodle osod maint y cof ei hun.</li>
<li>Os ydych yn gallu mynd i mewn i\'ch ffeil php.ini, gallwch newid y gosodiad <b>memory_limit</b>
    yn y fan honno i tua 40M. Os nad ydych chi\'n gallu gwneud hyn eich hun, efallai
    y gallech ofyn i\'ch gweinyddwr wneud hyn i chi.</li>
<li>Ar rai gweinyddion PHP, gallwch greu ffeil .htaccess yng nghyfeiriadur Moodle
    sy\'n cynnwys y llinell hon:
    <p><blockquote>php_value memory_limit 40M</blockquote></p>
    <p>Fodd bynnag, ar rai gweinyddion bydd hyn yn atal <b>pob</b> tudalen PHP rhag gweithio
    (bydd gwallau\'n ymddangos pan fyddwch yn edrych ar dudalennau) felly bydd rhaid i chi dynnu\'r ffeil .htaccess file.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'Nid yw\'r PHP wedi cael ei ffurfweddu\'n iawn gyda\'r estyniad MSSQL er mwyn iddo allu cyfathrebu â SQL*Server.  Tarwch olwg dros eich ffeil php.ini neu ail-grynhoi PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'Dydy\'r PHP ddim wedi cael ei ffurfweddu\'n iawn gyda\'r estyniad MySQLi er mwyn iddo allu cyfathrebu â MySQL. Tarwch olwg dros eich ffeil php.ini neu ail-grynhoi PHP. Nid yw estyniad MySQLi ar gael ar gyfer PHP 4.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Mae angen i chi\'n awr ffurfweddu\'r gronfa ddata lle bydd y rhan fwyaf o ddata Moodle yn cael eu storio.
Mae\'n rhaid bod y gronfa ddata hon eisoes wedi cael ei chreu a bod enw defnyddiwr a chyfrinair wedi\'u creu i\'w defnyddio. Rhaid defnyddio llythrennau blaen ar gyfer tablau.';
$string['nativemysqli'] = 'MySQL gwell (native/mysqli)';
$string['nativemysqlihelp'] = 'Mae angen i chi\'n awr ffurfweddu\'r gronfa ddata lle bydd y rhan fwyaf o ddata Moodle yn cael eu storio.
Gellir creu cronfa ddata os oes gan ddefnyddiwr y gronfa ddata\'r caniatâd angenrheidiol, a rhaid bod enw defnyddiwr a chyfrinair eisoes yn bodoli. Mae defnyddio llythrennau blaen ar gyfer tablau yn ddewisol.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Mae angen i chi\'n awr ffurfweddu\'r gronfa ddata lle bydd y rhan fwyaf o ddata Moodle yn cael eu storio. Mae\'n rhaid bod y gronfa ddata hon eisoes wedi cael ei chreu a bod enw defnyddiwr a chyfrinair wedi\'u creu i\'w defnyddio. Rhaid defnyddio llythrennau blaen ar gyfer tablau.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Mae angen i chi\'n awr ffurfweddu\'r gronfa ddata lle bydd y rhan fwyaf o ddata Moodle yn cael eu storio. Mae\'n rhaid bod y gronfa ddata hon eisoes wedi cael ei chreu a bod enw defnyddiwr a chyfrinair wedi\'u creu i\'w defnyddio. Rhaid defnyddio llythrennau blaen ar gyfer tablau.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Mae angen i chi\'n awr ffurfweddu\'r gronfa ddata lle bydd y rhan fwyaf o ddata Moodle yn cael eu storio. Mae\'n rhaid bod y gronfa ddata hon eisoes wedi cael ei chreu a bod enw defnyddiwr a chyfrinair wedi\'u creu i\'w defnyddio. Rhaid defnyddio llythrennau blaen ar gyfer tablau.';
$string['ociextensionisnotpresentinphp'] = 'Nid yw\'r PHP wedi cael ei ffurfweddu\'n iawn gyda\'r estyniad OCI8 er mwyn iddo allu cyfathrebu ag Oracle. Tarwch olwg dros eich ffeil php.ini neu ail-grynhoi PHP.';
$string['pass'] = 'Pasio';
$string['paths'] = 'Llwybrau';
$string['pathserrcreatedataroot'] = 'Dydy\'r rhaglen osod ddim yn gallu creu\'r cyfeiriadur data ({$a->dataroot}).';
$string['pathshead'] = 'Cadarnhau llwybrau';
$string['pathsrodataroot'] = 'Does dim modd ysgrifennu ar y cyfeiriadur gwraidd data.';
$string['pathsroparentdataroot'] = 'Does dim modd ysgrifennu ar y cyfeiriadur rhiant ({$a->parent}). Dydy\'r rhaglen osod ddim yn gallu creu\'r cyfeiriadur data ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Nifer fach iawn o westeiwyr gwe sy\'n defnyddio /admin fel URL arbennig i chi gael mynd i mewn i\'r panel rheoli neu beth bynnag. Yn anffodus, mae hyn yn gwrthdaro â lleoliad safonol tudalennau gweinyddol Moodle. Gallwch drwsio hyn drwy ailenwi cyfeiriadur y gweinyddwr wrth osod y rhaglen, a rhoi\'r enw newydd yma. Er enghraifft: <em>gweinyddmoodle</em>.  Bydd hyn yn trwsio\'r dolenni gweinyddol yn Moodle';
$string['pathssubdataroot'] = 'Mae Moodle angen lle ar gyfer cadw ffeiliau sy\'n cael eu llwytho i fyny. Dylai defnyddiwr gweinydd y we (fel arfer \'neb\' neu \'apache\') allu darllen ac YSGRIFENNU ar y cyfeiriadur hwn, ond ni ddylid gallu mynd i mewn iddo\'n uniongyrchol drwy\'r we. Bydd y rhaglen osod yn ceisio ei greu os nad yw\'n bodoli.';
$string['pathssubdirroot'] = 'Llwybr cyfeiriadur llawn i raglen Moodle.';
$string['pathssubwwwroot'] = 'Y cyfeiriad gwe llawn a ddefnyddir i fynd i mewn i Moodle.
Nid yw\'n bosibl mynd i mewn i Moodle wrth ddefnyddio amryw o gyfeiriadau.
Os oes gan eich safle amryw o gyfeiriadau cyhoeddus, bydd rhaid i chi sefydlu llwybrau ailgyfeirio parhaol ar gyfer pob un ohonynt ar wahân i hwn.
Os gellir mynd i mewn i\'ch safle o\'r Rhyngrwyd a\'r Fewnrwyd, defnyddiwch y cyfeiriad cyhoeddus yma a sefydlu DNS er mwyn i ddefnyddwyr y Fewnrwyd allu defnyddio\'r cyfeiriad cyhoeddus hefyd.
Os nad yw\'r cyfeiriad yn gywir, newidiwch yr URL yn eich porwr i ailddechrau\'r rhaglen osod gyda gwerth gwahanol.';
$string['pathsunsecuredataroot'] = 'Dydy lleoliad y data gwraidd ddim yn ddiogel';
$string['pathswrongadmindir'] = 'Cyfeiriadur y gweinyddwr';
$string['pgsqlextensionisnotpresentinphp'] = 'Nid yw\'r PHP wedi cael ei ffurfweddu\'n iawn gyda\'r estyniad PGSQL er mwyn iddo allu cyfathrebu â PostgreSQL. Tarwch olwg dros eich ffeil php.ini neu ail-grynhoi PHP.';
$string['phpextension'] = 'Estyniad PHP {$a}';
$string['phpversion'] = 'Fersiwn PHP';
$string['phpversionhelp'] = '<p>Mae angen o leiaf fersiwn PHP 4.3.0 neu 5.1.0 ar Moodle (mae llawer o broblemau gyda 5.0.x).</p>
<p>Ar hyn o bryd, rydych yn rhedeg fersiwn {$a}</p>
<p>Rhaid i chi uwchraddio PHP neu newid i westeiwr â fersiwn diweddarach o PHP!<br/>
(Os oes gennych 5.0.x gallwch hefyd is-raddio i fersiwn 4.4.x)</p>';
$string['releasenoteslink'] = 'Os hoffech gael gwybodaeth am y fersiwn hon o Moodle, darllenwch y nodiadau ar gyfer y fersiwn yn {$a}';
$string['safemode'] = 'Modd Diogel';
$string['safemodeerror'] = 'Mae\'n bosibl y bydd Moodle yn profi problemau os yw\'r modd diogel ymlaen';
$string['safemodehelp'] = '<p>Mae\'n bosibl y bydd Moodle yn profi llawer o broblemau os yw\'r modd diogel ymlaen. Un broblem y gallech ddod ar ei thraws yw
   na fyddwch o bosib yn gallu creu ffeiliau newydd.</p>

<p>Fel arfer, dim ond gwesteiwyr gwe cyhoeddus paranoid sy\'n troi\'r modd diogel ymlaen, felly efallai y
   bydd rhaid i chi gael cwmni gwesteiwr gwe newydd ar gyfer eich safle Moodle.</p>

<p>Gallwch roi cynnig ar fwrw ymlaen i osod, ond mae\'n siŵr y byddwch yn dod ar draws rhai problemau yn nes ymlaen.</p>';
$string['sessionautostart'] = 'Awto Gychwyn y Sesiwn';
$string['sessionautostarterror'] = 'Dylai hwn fod wedi\'i ddiffodd';
$string['sessionautostarthelp'] = '<p>Mae angen cefnogaeth sesiwn ar Moodle ac ni fydd yn gweithio hebddo.</p>

<p>Gallwch alluogi sesiynau yn y ffeil php.ini file ... chwiliwch am y paramedr session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'Dydy\'r PHP ddim wedi cael ei ffurfweddu\'n iawn gyda\'r estyniad SQLite. Tarwch olwg dros eich ffeil php.ini neu ail-grynhoi PHP.';
$string['upgradingqtypeplugin'] = 'Wrthi\'n uwchraddio ategyn math/cwestiwn';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Rydych chi\'n gweld y dudalen hon gan eich bod wedi gosod a
    lansio\'r pecyn <strong>{$a->packname} {$a->packversion}</strong> yn llwyddiannus ar eich cyfrifiadur. Llongyfarchiadau!';
$string['welcomep30'] = 'Mae\'r fersiwn <strong>{$a->installername}</strong> yn cynnwys rhaglenni
    i greu amgylchedd y gall  <strong>Moodle</strong> weithio ynddo, sef:';
$string['welcomep40'] = 'Mae\'r pecyn hefyd yn cynnwys <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Y trwyddedau perthnasol sy\'n llywodraethu dros yr holl raglenni yn y pecyn hwn. Y pecyn cyflawn yw <strong>{$a->installername}</strong>
    <a href="http://www.opensource.org/docs/definition_plain.html">open source</a> a chaiff ei ddosbarthu dan y drwydded <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Bydd y tudalennau canlynol yn eich arwain drwy\'r camau syml i
    ffurfweddu a gosod <strong>Moodle</strong> ar eich cyfrifiadur. Gallwch ddewis derbyn y gosodiadau
    diofyn, neu gallwch eu newid eich hun ar gyfer eich dibenion chi.';
$string['welcomep70'] = 'Cliciwch y botwm "Nesaf" i fwrw ymlaen i osod <strong>Moodle</strong>.';
$string['wwwroot'] = 'Cyfeiriad ar y we';
$string['wwwrooterror'] = 'Nid yw\'r \'Cyfeiriad ar y We\' yn ddilys - yn ôl pob tebyg, nid yw\'r rhaglen Moodle yn y cyfeiriad hwn. Mae\'r gwerth isod wedi cael ei ailosod.';
