<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_shibboleth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_method'] = 'Enw\'r dull dilysu';
$string['auth_shib_auth_method_description'] = 'Rhowch enw sy\'n gyfarwydd i\'ch defnyddwyr ar gyfer y dull dilysu Shibboleth. Gallai hyn fod yn enw eich ffederasiwn Shibboleth, e.e. <tt>Mewngofnodi SWITCHaai</tt> neu <tt>Mewngofnodi InCommon</tt> neu rywbeth tebyg.';
$string['auth_shibbolethdescription'] = 'Drwy ddefnyddio\'r dull hwn, caiff defnyddwyr eu creu a\'u dilysu gan ddefnyddio <a href="http://shibboleth.internet2.edu/">Siboleth</a>.<br/>Sicrhewch eich bod yn darllen y ffeil <a href="../auth/shibboleth/README.txt">README</a> ar gyfer Siboleth ar sut i gydosod eich Moodle gyda Siboleth';
$string['auth_shibboleth_errormsg'] = 'Dewiswch y sefydliad rydych chi\'n aelod ohono!';
$string['auth_shibboleth_login'] = 'Mewngofnodi i Shibboleth';
$string['auth_shibboleth_login_long'] = 'Mewngofnodi i Moodle drwy Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Mewngofnodi eich hun';
$string['auth_shibboleth_select_member'] = 'Rydw i\'n aelod o ...';
$string['auth_shibboleth_select_organization'] = 'Er mwyn dilysu drwy Shibboleth, dewiswch eich sefydliad o\'r rhestr:';
$string['auth_shib_changepasswordurl'] = 'URL newid cyfrinair';
$string['auth_shib_convert_data'] = 'API addasu data';
$string['auth_shib_convert_data_description'] = 'Gallwch ddefnyddio\'r API hwn i addasu ymhellach y data a ddarperir gan Siboleth. Darllenwch y ffeil <a href="../auth/shibboleth/README.txt">README</a> am gyfarwyddiadau pellach.';
$string['auth_shib_convert_data_warning'] = 'Nid yw\'r ffeil hon yn bodoli neu ni all proses y gweinydd gwe ei darllen!';
$string['auth_shib_idp_list'] = 'Darparwyr manylion adnabod';
$string['auth_shib_idp_list_description'] = 'Rhowch restr o entityIDs Darparwyr Manylion Adnabod y gall defnyddwyr eu dewis ar y dudalen mewngofnodi.<br />Rhaid cael coma rhwng pob elfen yn y rhestr o entityID yr IdP (gweler y ffeil meta ddata Shibboleth) ac Enw\'r IdP fel y bydd yn ymddangos yn y gwymplen.<br />Gallwch hefyd ddewis trydydd paramedr, sef ychwanegu lleoliad dechreuwr sesiwn Shibboleth a gaiff ei ddefnyddio rhag ofn bod eich rhaglen Moodle yn rhan o osodiad aml-ffederasiwn.';
$string['auth_shib_instructions'] = 'Defnyddiwch y <a href="{$a}">ffurflen mewngofnodi Siboleth</a> i gael mynediad drwy Siboleth, os gall eich sefydliad ddelio ag ef.<br />Fel arall, defnyddiwch y ffurflen mewngofnodi normal a ddangosir yma.';
$string['auth_shib_instructions_help'] = 'Yma, dylech roi cyfarwyddiadau personol i\'ch defnyddwyr i egluro Siboleth. Caiff ei ddangos ar y dudalen mewngofnodi yn yr adran cyfarwyddiadau. Rhaid i\'r cyfarwyddiadau gynnwys dolen at "<b>{$a}</b>" y bydd defnyddwyr yn ei glicio pan fyddant am fewngofnodi.';
$string['auth_shib_integrated_wayf'] = 'Gwasanaeth WAYF Moodle';
$string['auth_shib_integrated_wayf_description'] = 'Os ydych chi\'n ticio hwn, bydd Moodle yn defnyddio ei wasanaeth WAYF ei hun yn hytrach na\'r un a ffurfweddwyd ar gyfer Shibboleth. Bydd cwymplen yn ymddangos ar y dudalen fewngofnodi arall hon lle bydd rhaid i\'r defnyddiwr ddewis ei Ddarparwr Manylion Adnabod.';
$string['auth_shib_logout_return_url'] = 'URL arall ar gyfer dychwelyd ar ôl allgofnodi';
$string['auth_shib_logout_return_url_description'] = 'Rhowch yr URL y bydd defnyddwyr Shibboleth yn cael eu cyfeirio ato ar ôl allgofnodi.<br />Os ydych chi\'n ei adael yn wag, bydd defnyddwyr yn cael eu hailgyfeirio at y lleoliad mae Moodle yn cyfeirio defnyddwyr';
$string['auth_shib_logout_url'] = 'URL ar ôl allgofnodi o Ddarparwr Gwasanaeth Shibboleth';
$string['auth_shib_logout_url_description'] = 'Rhowch URL i ddelio â defnyddwyr ar ôl allgofnodi o Ddarparwr Gwasanaeth Shibboleth. Fel arfer, <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Os ydych chi am ddefnyddio\'r gwasanaeth WAYF integredig, rhaid i chi ddarparu rhestr o entityIDs Darparwyr Manylion Adnabod, gyda chomas rhyngddynt, eu henwau a dechreuwr sesiwn (os ydych yn dymuno).';
$string['auth_shib_only'] = 'Siboleth yn unig';
$string['auth_shib_only_description'] = 'Ticiwch y dewis hwn os bydd rhaid gorfodi dilysiad Siboleth';
$string['auth_shib_username_description'] = 'Enw\'r newidyn amgylchedd Siboleth gweinydd gwe a ddefnyddir fel enw defnyddiwr Moodle';
$string['pluginname'] = 'Siboleth';
$string['shib_no_attributes_error'] = 'Ymddengys eich bod wedi eich dilysu gyda Siboleth ond nid yw Moodle wedi derbyn unrhyw briodoleddau defnyddiwr. Sicrhewch fod eich Darparwr Hunaniaeth yn rhyddhau\'r priodoleddau angenrheidiol ({$a}) i\'r Darparwr Gwasanaeth y mae Moodle yn rhedeg arno, neu rhowch wybod i wefeistr y gweinydd hwn.';
$string['shib_not_all_attributes_error'] = 'Mae angen rhai priodoleddau Siboleth penodol ar Moodle, ac nid ydynt yn bresennol yn eich achos chi. Dyma\'r priodoleddau: {$a}<br />Cysylltwch â gwefeistr y gweinydd hwn neu eich Darparwr Hunaniaeth.';
$string['shib_not_set_up_error'] = 'Ymddengys nad yw dilysu Siboleth wedi\'i ffurfweddu\'n gywir, oherwydd does dim newidynnau amgylchedd Siboleth yn bresennol ar y dudalen hon. Darllenwch y ffeil <a href="README.txt">README</a> am gyfarwyddiadau pellach am sut i ffurfweddu dilysu Siboleth neu cysylltwch â gwefeistr y gosodiad Moodle hwn.';
