<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Wedi gwrthod mynediad';
$string['accounts'] = 'Cyfrifon';
$string['addcategory'] = 'Ychwanegu categori';
$string['additionalhtml'] = 'HTML ychwanegol';
$string['additionalhtml_desc'] = 'Mae\'r gosodiadau hyn yn gadael i chi bennu\'r HTML rydych chi am ei ychwanegu at bob tudalen. Gallwch bennu HTML a gaiff ei ychwanegu o fewn y tag HEAD ar gyfer y dudalen, naill ai\'n syth ar ôl agor y tag BODY neu\'n syth cyn cau\'r tag..<br /> Bydd gwneud hyn yn eich galluogi chi i ychwanegu penynnau neu droedynnau personol ar bob tudalen neu ychwanegu cymorth ar gyfer gwasanaethau megis Google Analytics yn rhwydd iawn ac yn annibynnol ar eich thema ddewisol.';
$string['additionalhtmlfooter'] = 'Cyn cau\'r tag BODY';
$string['additionalhtmlfooter_desc'] = 'Bydd y cynnwys hwn yn cael ei ychwanegu at bob tudalen cyn cau\'r tag corff.';
$string['additionalhtmlhead'] = 'O fewn y PENNYN';
$string['additionalhtmlhead_desc'] = 'Bydd y cynnwys hwn yn cael ei ychwanegu at waelod y tag HEAD ar bob tudalen.';
$string['additionalhtml_heading'] = 'HTML ychwanegol yn cael ei ychwanegu at bob tudalen.';
$string['additionalhtmltopofbody'] = 'Pan fydd y tag BODY yn agor';
$string['additionalhtmltopofbody_desc'] = 'Bydd y cynnwys hwn yn cael ei ychwanegu at bob tudalen yn syth ar ôl agor y tag BODY.';
$string['admincategory'] = 'Categori: {$a}';
$string['adminseesall'] = 'Gweinyddwyr yn gweld popeth';
$string['adminseesallevents'] = 'Gweinyddwyr yn gweld yr holl ddigwyddiadau';
$string['adminseesownevents'] = 'Gweinyddwyr yn union fel defnyddwyr eraill';
$string['advancedfeatures'] = 'Nodweddion uwch';
$string['allcountrycodes'] = 'Codau pob gwlad';
$string['allowbeforeblock'] = 'Bydd y rhestr a ganiateir yn cael ei phrosesu\'n gyntaf';
$string['allowbeforeblockdesc'] = 'Yn ddiofyn, bydd cofnodion yn y rhestr IP a rwystrir yn cael eu cyfateb yn gyntaf. Os yw\'r dewis hwn wedi\'i alluogi, bydd cofnodion yn y rhestr IP a ganiateir yn cael eu prosesu cyn y rheini yn y rhestr a rwystrir.';
$string['allowblockstodock'] = 'Gadael i flociau ddefnyddio\'r doc';
$string['allowcategorythemes'] = 'Caniatáu themâu categori';
$string['allowcoursethemes'] = 'Caniatáu themâu cwrs';
$string['allowediplist'] = 'Rhestr IP a ganiateir';
$string['allowemailaddresses'] = 'Parthau e-bost a ganiateir';
$string['allowframembedding'] = 'Caniatáu plannu fframiau';
$string['allowframembedding_help'] = 'Caniatáu plannu\'r safle hwn mewn fframiau ar safleoedd allanol. Ni argymhellir galluogi\'r nodwedd hon am resymau diogelwch.';
$string['allowguestmymoodle'] = 'Caniatáu mynediad i Fy hafan';
$string['allowobjectembed'] = 'Caniatáu tagiau EMBED ac OBJECT';
$string['allowthemechangeonurl'] = 'Caniatáu newid thema yn yr URL';
$string['allowuserblockhiding'] = 'Caniatáu i ddefnyddwyr guddio blociau';
$string['allowuserswitchrolestheycantassign'] = 'Gadael defnyddwyr heb swyddogaethau neilltuo i gyfnewid swyddogaethau';
$string['allowuserthemes'] = 'Caniatáu themâu defnyddiwr';
$string['antivirus'] = 'Gwrth-firws';
$string['appearance'] = 'Ymddangosiad';
$string['aspellpath'] = 'Llwybr i aspell';
$string['authentication'] = 'Dilysu';
$string['authpreventaccountcreation'] = 'Atal creu cyfrif wrth ddilysu';
$string['authpreventaccountcreation_help'] = 'Pan fydd defnyddiwr yn dilysu, bydd cyfrif yn cael ei greu\'n awtomatig ar y safle os nad oes un yn bodoli\'n barod. Os mai cronfa ddata allanol, megis LDAP, sy\'n dilysu, ond eich bod am gyfyngu mynediad i\'r safle ar gyfer defnyddwyr sydd eisoes â chyfrif yn unig, yna dylech alluogi\'r dewis hwn. Bydd angen creu cyfrifon â llaw neu drwy nodwedd llwytho defnyddwyr i fyny. Cofiwch nad yw\'r gosodiad hwn yn berthnasol i broses ddilysu MNet.';
$string['authsettings'] = 'Rheoli\'r broses ddilysu';
$string['autolang'] = 'Awtoganfod iaith';
$string['autologinguests'] = 'Mewngofnodi gwesteion yn awtomatig';
$string['availablelicenses'] = 'Y trwyddedau sydd ar gael';
$string['availableto'] = 'Ar gael i';
$string['backgroundcolour'] = 'Lliw tryloyw';
$string['backups'] = 'Ffeiliau wrth gefn';
$string['backup_shortname'] = 'Defnyddio enw\'r cwrs yn enw\'r ffeil wrth gefn';
$string['backup_shortnamehelp'] = 'Defnyddio enw\'r cwrs fel rhan o enw\'r ffeil wrth gefn.';
$string['badwordsconfig'] = 'Cofnodwch eich rhestr o eiriau drwg, gyda choma yn eu gwahanu.';
$string['badwordsdefault'] = 'Os yw\'r rhestr bersonol yn wag, defnyddir rhestr ddiofyn o\'r pecyn iaith.';
$string['badwordslist'] = 'Rhestr bersonol o eiriau drwg';
$string['blockediplist'] = 'Rhestr IP wedi\'u rhwystro';
$string['blockeditingmenu'] = 'Dewislenni golygu bloc';
$string['blockeditingmenu_desc'] = 'Os byddant yn cael eu galluogi, bydd y nifer o eiconau golygu bloc a ddangosir pan fydd golygu ymlaen yn cael eu harddangos mewn cwymplen. Mae hwn yn lleihau\'r cynnwys ar y sgrin drwy guddio\'r eiconau nes bydd eu hangen.';
$string['blockinstances'] = 'Digwyddiadau';
$string['blockmultiple'] = 'Mwy nag un';
$string['blockprotect'] = 'Gwarchod enghreifftiau';
$string['blockprotect_help'] = 'Os ydych yn cloi math arbennig o floc, bydd dim modd i unrhyw un ychwanegu neu ddileu enghreifftiau. (Gallwch, wrth gwrs, ddatgloi eto os ydych angen golygu enghreifftiau.)
Mae hyn yn cael ei wneud er mwyn gwarchod blociau fel gosodiadau a llywio sy’n anodd iawn eu hadfer os ydynt yn cael eu dileu\'n ddamweiniol.';
$string['blocksettings'] = 'Rheoli blociau';
$string['blockunprotect'] = 'Dad-ddiogelu';
$string['bloglevel'] = 'Gweld blogiau';
$string['bookmarkadded'] = 'Wedi ychwanegu nod tudalen.';
$string['bookmarkalreadyexists'] = 'Rydych eisoes wedi rhoi nod tudalen ar y dudalen hon.';
$string['bookmarkdeleted'] = 'Wedi dileu nod tudalen.';
$string['bookmarkthispage'] = 'Rhoi nod tudalen yma';
$string['cacheapplication'] = 'Storfa rhaglen';
$string['cacheapplicationhelp'] = 'Mae eitemau wedi\'u storio yn cael eu rhannu ymysg pob defnyddiwr ac yn dod i ben trwy ttl sydd wedi\'i bennu.';
$string['cachejs'] = 'Sgript';
$string['cachejs_help'] = 'Mae storio a chywasgu Javascript yn gwella perfformiad llwytho tudalennau\'n sylweddol. Rydym yn argymell hyn yn gryf ar safleoedd cynhyrchu. Mae\'n debyg y bydd datblygwyr am ddiffodd y nodwedd hon.';
$string['cacherequest'] = 'Storfa ceisiadau';
$string['cacherequesthelp'] = 'Storfa benodol y defnyddiwr sy’n dod ben i pan fydd y cais wedi’i gwblhau. Wedi’i greu i ddisodli adrannau lle rydym yn defnyddio storfeydd statig.';
$string['cachesession'] = 'Storfa sesiynau';
$string['cachesessionhelp'] = 'Storfa benodol y defnyddiwr sy’n dod ben i pan fydd sesiwn y defnyddiwr yn gorffen. Wedi’i greu i liniaru chwyddo/straen sesiwn.';
$string['cachesettings'] = 'Gosodiadau\'r storfa';
$string['cachetext'] = 'Stôr testun am oes';
$string['caching'] = 'Storio';
$string['calendarexportsalt'] = 'Testun ar hap ar gyfer allgludo calendr';
$string['calendarsettings'] = 'Calendr';
$string['calendartype'] = 'Math o galendr';
$string['calendartype_desc'] = 'Dewis math diofyn o galendr ar gyfer y safle cyfan. Gall y gosodiad hwn gael ei ddiystyru yn ngosodiad y cwrs neu gan ddefnyddwyr yn eu proffil personol.';
$string['calendar_weekend'] = 'Dyddiau\'r penwythnos';
$string['cannotdeletemodfilter'] = 'Allwch chi ddim dadosod \'{$a->filter}\' oherwydd mae\'n rhan o\'r modiwl \'{$a->module}\'';
$string['cannotuninstall'] = 'Does dim modd dadosod {$a}.';
$string['cfgwwwrootslashwarning'] = 'Rydych chi wedi diffinio $CFG->wwwroot yn anghywir yn eich ffeil config.php. Rydych chi wedi cynnwys \'/\' ar y diwedd. Dylech ddileu\'r nod hwn neu fe fyddwch yn dod ar draws chwilod rhyfedd fel <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Rydych chi wedi diffinio $CFG->wwwroot yn anghywir yn eich ffeil config.php. Nid yw\'n cyfateb â\'r URL rydych chi\'n ei ddefnyddio i gael mynediad at y dudalen hon. Dylech gywiro hyn neu fe fyddwch yn dod ar draws bygiau rhyfedd fel <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'newid';
$string['checkboxno'] = 'Na';
$string['checkboxyes'] = 'Iawn';
$string['choosefiletoedit'] = 'Dewiswch ffeil i\'w golygu o\'r blwch uchod';
$string['clamfailureonupload'] = 'Methiant AV ar glam';
$string['cleanup'] = 'Glanhau';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'i';
$string['cliincorrectvalueerror'] = 'Gwall, gwerth anghywir "{$a->value}" ar gyfer "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Gwerth anghywir, rhowch gynnig arall arni';
$string['clistatusdisabled'] = 'Statws: wedi\'i analluogi';
$string['clistatusenabled'] = 'Statws: wedi\'i alluogi';
$string['clistatusenabledlater'] = 'statws: bydd modd cynnal a chadw CLI yn cael ei alluogi ar {$a}';
$string['clitypevalue'] = 'math o werth';
$string['clitypevaluedefault'] = 'math o werth, pwyswch Enter i ddefnyddio\'r gwerth diofyn ({$a})';
$string['cliunknowoption'] = 'Dewisiadau dieithr:
  {$a}
Defnyddiwch y dewis --help.';
$string['cliupgradefinished'] = 'Wedi uwchraddio\'r llinell orchymyn yn llwyddiannus';
$string['cliupgradenoneed'] = 'Does dim angen uwchraddio\'r fersiwn sydd wedi\'i osod {$a}. Diolch am ddod beth bynnag!';
$string['cliyesnoprompt'] = 'mae teipio i (yn golygu iawn) neu n (yn golygu na)';
$string['commentsperpage'] = 'Nifer y sylwadau sy\'n ymddangos ar bob tudalen';
$string['commonfiltersettings'] = 'Gosodiadau hidlo cyffredin';
$string['commonsettings'] = 'Gosodiadau cyffredin';
$string['componentinstalled'] = 'Wedi gosod cydran';
$string['computedfromlogs'] = 'Wedi\'u cyfrifo o logiau ers {$a}.';
$string['condifmodeditdefaults'] = 'Mae\'r gwerthoedd a bennwch yma yn diffinio\'r gwerthoedd diofyn sy\'n cael eu defnyddio yn ffurflen gosodiadau\'r gweithgaredd pan fyddwch yn creu gweithgaredd newydd. Gallwch hefyd ffurfweddu pa osodiadau gweithgaredd sy\'n cael eu hystyried fel gosodiadau uwch.';
$string['confeditorhidebuttons'] = 'Dewiswch y botymau a ddylai gael eu cuddio yn y golygydd HTML.';
$string['configallcountrycodes'] = 'Dyma\'r rhestr o wledydd y gellir eu dewis mewn gwahanol lefydd, er enghraifft, ym mhroffil y defnyddiwr. Os yw\'n wag (y dewis diofyn), defnyddir y rhestr yn countries.php y pecyn iaith Saesneg safonol. Hon yw\'r rhestr yn ISO 3166-1. Fel arall, gallwch bennu rhestr o godau gyda chomas rhyngddynt, er enghraifft \'GB,FR,ES\'. Os ydych yn ychwanegu codau newydd yma, nad ydynt yn rhai safonol, bydd angen i chi eu hychwanegu at countries.php yn \'en\' ac yn eich pecyn iaith.';
$string['configallowassign'] = 'Caniatáu i\'r swyddogaethau ar yr ochr chwith neilltuo\'r swyddogaethau ym mhob colofn';
$string['configallowblockstodock'] = 'Os yw\'r dewis hwn ar gael yn y thema a ddewiswyd a\'i fod wedi\'i alluogi, gall defnyddwyr ddewis symud blociau i ddoc arbennig.';
$string['configallowcategorythemes'] = 'Os ydych chi\'n galluogi hwn, yna mae\'n bosib gosod themau ar lefel categori. Bydd hyn yn effeithio ar bob cwrs a chategori plentyn oni bai eu bod wedi gosod eu thema eu hunain. RHYBUDD: Mae galluogi themau categori yn gallu effeithio ar berfformiad.';
$string['configallowcoursethemes'] = 'Os ydych yn galluogi hyn, bydd y cyrsiau\'n cael dewis eu themâu eu hunain. Bydd themâu cwrs yn diystyru pob dewis thema arall (themâu safle, defnyddiwr neu sesiwn)';
$string['configallowemailaddresses'] = 'Os hoffech gyfyngu pob cyfeiriad e-bost newydd i barthau penodol, rhestrwch hwy yma gyda bylchau rhyngddynt. Caiff pob parth arall ei wrthod. ee <strong>eincoleg.edu.au.gov.au</strong>';
$string['configallowguestmymoodle'] = 'Os yw gwesteion sydd wedi\'u galluogi yn gallu cael mynediad i Fy hafan, fel arall bydd gwesteion yn cael eu harallgyfeirio i dudalen flaen y safle.';
$string['configallowobjectembed'] = 'Fel mesur diogelwch diofyn, ni chaiff defnyddwyr normal fewnosod deunydd amlgyfrwng (fel Flash) o fewn testunau drwy ddefnyddio tagiau EMBED ac OBJECT penodol yn eu HTML (er y gellir dal i wneud hyn yn ddiogel drwy ddefnyddio\'r hidlydd mediaplugins). Os hoffech ganiatáu\'r tagiau hyn, rhowch y dewis hwn ar waith.';
$string['configallowoverride'] = 'Gadael i\'r swyddogaethau ar yr ochr chwith ddiystyru\'r swyddogaethau ym mhob colofn';
$string['configallowoverride2'] = 'Dewiswch ba swyddogaeth(au) sy\'n gallu cael eu diystyrru gan bob swyddogaeth yn y golofn chwith. <br />Cofiwch fod y gosodiadau hyn ddim ond yn berthnasol i ddefnyddwyr sydd naill ai â\'r gallu moodle/role:override neu\'r gallu moodle/role:safeoverride.';
$string['configallowswitch'] = 'Dewiswch ba swyddogaethau y gall defnyddiwr newid iddynt, yn seiliedig ar ba swyddogaethau sydd ganddynt eisoes. Yn ogystal â chofnod yn y tabl hwn, rhaid bod defnyddiwr hefyd yn gallu moodle/role:switchroles er mwyn newid. <br /> Cofiwch mai\'r unig swyddogaethau y gellir newid iddynt yw\'r rheini â moodle/course:view a\'r rheini heb moodle/site:doanything, felly mae rhai colofnau yn y tabl wedi\'u hanalluogi.';
$string['configallowthemechangeonurl'] = 'Os yw wedi\'i alluogi, mae\'n bosib newid y thema drwy ychwanegu theme={themename} at unrhyw URL Moodle.';
$string['configallowuserblockhiding'] = 'Ydych chi am ganiatáu i ddefnyddwyr guddio/dangos blociau ochr ym mhob man yn y safle hwn? Mae\'r nodwedd hon yn defnyddio Javascript a briwsion i gofio cyflwr pob bloc y gellir ei grebachu, a bydd dim ond yn effeithio ar yr hyn bydd y defnyddiwr ei hun yn ei weld.';
$string['configallowuserswitchrolestheycantassign'] = 'Yn ddiofyn, mae\'n rhaid cael moodle/role:assign i ddefnyddwyr allu newid swyddogaethau. Mae galluogi\'r gosodiad hwn yn dileu\'r gofyniad hwn, felly\'r tabl "Caniatáu neilltuo swyddogaethau" yn unig sy\'n pennu\'r gosodiadau ar gyfer y swyddogaethau sydd ar gael yn y ddewislen "Newid swyddogaeth i". Rydym yn argymell nad yw\'r gosodiadau ar gyfer "Caniatáu neilltuo swyddogaethau" yn galluogi defnyddwyr i newid i swyddogaeth gyda mwy o alluoedd na\'u swyddogaeth bresennol.';
$string['configallowuserthemes'] = 'Os ydych chi\'n galluogi hyn, gall defnyddwyr osod eu themâu eu hunain. Bydd themâu defnyddwyr yn diystyru themâu safle (ond nid themâu cwrs)';
$string['configallusersaresitestudents'] = 'Ar gyfer y gweithgareddau ar dudalen flaen y safle, a ddylid ystyried POB defnyddiwr fel myfyriwr?  Os ydych yn ateb "Iawn", caiff unrhyw gyfrif defnyddiwr sydd wedi\'i gadarnhau gymryd rhan fel myfyriwr yn y gweithgareddau hyn. Os ydych yn ateb "Na", dim ond defnyddwyr sydd eisoes yn cymryd rhan mewn o leiaf un cwrs fydd yn gallu cymryd rhan yn y gweithgareddau hyn ar y dudalen flaen. Dim ond gweinyddwyr ac athrawon a ddewiswyd yn arbennig gaiff weithredu fel athrawon ar gyfer y gweithgareddau hyn ar y dudalen flaen.';
$string['configauthenticationplugins'] = 'Dewiswch yr ategion dilysu yr hoffech eu defnyddio a\'u gosod yn y drefn methu. Bydd yr ategyn a ddewisir yn y golofn \'Cofrestru\' yn ymdrin â hunangofrestru (\'e-bost\' fel arfer).';
$string['configautolang'] = 'Canfod yr iaith ddiofyn o osodiadau\'r porwr. Os yw hwn wedi\'i analluogi, defnyddir y dewis diofyn ar gyfer y safle.';
$string['configautologinguests'] = 'A ddylid mewngofnodi ymwelwyr fel gwesteion yn awtomatig wrth fynd i mewn i gyrsiau â mynediad gwestai?';
$string['configbloglevel'] = 'Mae\'r gosodiad hwn yn gadael i chi gyfyngu faint o flogiau defnyddwyr gaiff eu gweld ar y safle hwn. Cofiwch mai uchafswm y GWYLIWR a bennir, nid y postiwr na\'r mathau o negeseuon a bostiwyd ar flog. Gellir analluogi blogiau\'n llwyr hefyd os nad ydych am eu cael o gwbl.';
$string['configcachetext'] = 'Ar gyfer safleoedd mwy neu safleoedd sy\'n defnyddio hidlyddion testun, gall y gosodiad hwn gyflymu pethau\'n sylweddol. Cedwir copïau o destunau ar ffurf wedi\'u prosesu am y cyfnod a bennir yma. Gallai gosod hwn yn rhy fach arafu pethau ychydig, ond gall ei osod yn rhy fawr olygu bod testunau\'n cymryd yn rhy hir i adnewyddu (gyda dolenni newydd, er enghraifft).';
$string['configcalendarcustomexport'] = 'Galluogi allfudo amrediad dyddiad personol o’r calendr';
$string['configcalendarexportsalt'] = 'Mae\'r testun ar hap hwn yn cael ei ddefnyddio er mwyn gwella diogelwch y tocynau dilysu wrth allgludo calendrau. Cofiwch y bydd yr holl docynau presennol yn annilys os ydych yn newid yr hash ar hap.';
$string['configclamactlikevirus'] = 'Trin ffeiliau fel firysau';
$string['configclamdonothing'] = 'Trin ffeiliau fel rhai glân';
$string['configclamfailureonupload'] = 'Os ydych chi wedi ffurfweddu clam i sganio ffeiliau a lwythir i fyny, ond ei fod wedi\'i ffurfweddu\'n anghywir neu\'n methu â rhedeg am ba bynnag reswm, sut ddylai ymddwyn?  Os dewiswch \'Trin ffeiliau fel firysau\', cânt eu symud i\'r ardal cwarantin, neu eu dileu. Os dewiswch \'Trin ffeiliau fel rhai glân\', caiff y ffeiliau fel arfer eu symud i\'r cyfeiriadur cyrchfan. Y naill ffordd neu\'r llall, caiff gweinyddwyr eu hysbysu bod clam wedi methu. Os ydych chi\'n dewis \'Trin ffeiliau fel firysau\' a bod clam yn methu â rhedeg am ryw reswm (fel arfer am eich bod wedi rhoi pathtoclam annilys), caiff POB ffeil a lwythir i fyny ei symud i\'r ardal cwarantin dynodedig, neu ei dileu. Byddwch yn ofalus gyda\'r gosodiad hwn.';
$string['configconvertformat'] = 'Os yw <i>latex</i>, <i>dvips</i> a <i>convert</i> ar gael, bydd y delweddau\'n cael eu creu gan ddefnyddio\'r fformat a bennwyd. Os na, defnyddir mimeTeX a fydd yn creu delwedd GIF.';
$string['configcookiehttponly'] = 'Mae hwn yn galluogi\'r nodwedd PHP 5.2.0 newydd - rhoddir cyfarwyddyd i borwyr anfon cwcis gyda cheisiadau http go-iawn yn unig. Ni ddylai cwcis fod ar gael drwy ieithoedd sgriptio. Dydy hyn ddim yn gweithio ym mhob porwr ac efallai na fydd yn hollol gydnaws â\'r cod presenol. Mae\'n helpu i atal rhai mathau o ymosodiadau XSS.';
$string['configcookiesecure'] = 'Os mai dim ond cysylltiadau https y mae\'r gweinydd yn eu derbyn, rydym yn argymell galluogi anfon cwcis diogel. Os yw hwn wedi\'i alluogi, gwnewch yn siŵr nad yw\'r gweinydd gwe yn derbyn http:// neu sefydlwch drefn i ailgyfeirio\'n barhaol i gyfeiriad https://. Os nad yw\'r cyfeiriad <em>wwwroot</em> yn dechrau gyda https://, bydd y gosodiad hwn yn diffodd yn awtomatig.';
$string['configcountry'] = 'Os ydych chi\'n pennu gwlad yma, dewisir y wlad hon yn ddiofyn ar gyfrifon defnyddwyr newydd.  I orfodi defnyddwyr i ddewis gwlad, gadewch hwn yn wag.';
$string['configcourseoverviewfilesext'] = 'Rhestr wedi\'i gwahanu gan gomas o estyniadau i ffeiliau crynodeb cwrs sydd wedi\'u caniatáu.';
$string['configcourseoverviewfileslimit'] = 'Uchafswm y nifer o ffeiliau y mae modd eu hatodi i grynodeb cwrs.';
$string['configcourserequestnotify'] = 'Teipiwch enw defnyddiwr y defnyddiwr sy\'n cael ei hysbysu pan ddaw cais am gwrs newydd.';
$string['configcourserequestnotify2'] = 'Y defnyddwyr fydd yn cael eu hysbysu pan fydd cais am gwrs. Dim ond defnyddwyr sy\'n gallu cymeradwyo ceisiadau am gwrs sy\'n cael eu rhestru yma.';
$string['configcoursesperpage'] = 'Rhowch nifer y cyrsiau i\'w harddangos ar bob tudalen mewn rhestr o gyrsiau.';
$string['configcourseswithsummarieslimit'] = 'Y nifer mwyaf o gyrsiau i\'w dangos mewn rhestr o gyrsiau gan gynnwys crynodebau cyn dychwelyd i restr fwy syml.';
$string['configcronclionly'] = 'Os caiff hwn ei osod, dim ond o\'r llinell gorchymyn y gellir rhedeg y sgript cron, yn hytrach na thrwy ddefnyddio\'r we. Bydd hyn yn diystyru\'r gosodiad cyfrinair cron isod.';
$string['configcronremotepassword'] = 'Mae hyn yn golygu nad oes modd rhedeg y sgript cron.php o borwr gwe heb roi\'r cyfrinair drwy ddefnyddio\'r ffurf URL ganlynol:<pre>
    http://enghraifft. safle.com/gwein/cron.php?cyfrinair=opensesame
</pre>Os gadewir hwn yn wag, ni fydd angen cyfrinair.';
$string['configcurlcache'] = 'Amser nes bydd y stôr cURL yn dod yn fyw, mewn eiliadau.';
$string['configcustommenuitems'] = 'Gallwch ffurfweddu dewislen bersonol yma i\'w dangos gan themâu. Mae pob llinell yn cynnwys rhywfaint o destun dewislen, dolen URL (dewisol) a theitl blwch diffinio (dewisol), gyda nodau pibell yn eu gwahanu. Gallwch bennu strwythur gan ddefnyddio cysylltnodau. Er enghraifft: <pre> Moodle community|http://moodle.org -Moodle free support|http://moodle.org/support -Moodle development|http://moodle.org/development --Moodle Tracker|http://tracker.moodle.org --Moodle Docs|http://docs.moodle.org -Moodle News|http://moodle.org/news Moodle company -Moodle commercial hosting|http://moodle.com/hosting -Moodle commercial support|http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Os caiff y gosodiad hwn ei alluogi, bydd yn defnyddio\'r gronfa ddata i storio gwybodaeth am sesiynau cyfredol. Mae hyn yn arbennig o ddefnyddiol i safleoedd mawr/prysur neu i safleoedd a adeiladwyd ar glwstwr o weinyddion. Mae\'n debyg y dylid gadael hwn wedi\'i analluogi ar gyfer y rhan fwyaf o safleoedd, fel y defnyddir y ddisg gweinydd yn lle.  Cofiwch y bydd newid y gosodiad hwn yn awr yn allgofnodi pob defnyddiwr cyfredol (gan gynnwys chi eich hun). Os ydych chi\'n defnyddio MySQL, sicrhewch fod \'max_allowed_packet\' yn my.cnf (neu my.ini) yn o leiaf 4M.';
$string['configdebug'] = 'Os ydych yn troi hwn ymlaen, yna gwneir mwy o adrodd_gwallau PHP, a fydd yn argraffu mwy o rybuddion. Dim ond i ddatblygwyr y mae hyn yn ddefnyddiol.';
$string['configdebugdisplay'] = 'Pan fydd wedi\'i droi ymlaen, bydd y broses adrodd gwallau\'n mynd i\'r dudalen HTML. Mae hyn yn ymarferol, ond bydd yn torri XHTML, JS, briwsion a phennynnau HTTP yn gyffredinol. Wedi\'i ddiffodd, bydd yn anfon yr allbwn i\'ch cofnodion gweinydd, gan alluogi gwell dadfygio. Y gosodiad PHP error_log sy\'n rheoli i ba gofnod yr aiff hwn.';
$string['configdebugpageinfo'] = 'Galluogwch y dewis hwn os ydych am argraffu gwybodaeth y dudalen yn nhroedyn y dudalen.';
$string['configdebugsmtp'] = 'Galluogi gwybodaeth dadfygio amleiriog wrth anfon negeseuon e-bost i weinydd SMTP.';
$string['configdebugvalidators'] = 'Galluogwch y dewis hwn os ydych am gael dolenni at weinyddwyr dilysu allanol yn nhroedyn y dudalen. Efallai y bydd angen i chi greu defnyddiwr newydd gyda\'r enw defnyddiwr <em>w3cvalidator</em>, a chaniatáu mynediad i westeion. Mae\'r newidiadau hyn yn gallu rhoi mynediad heb awdurdod i weinydd, felly peidiwch â\'u galluogi ar safleoedd cynhyrchu!';
$string['configdefaulthomepage'] = 'Mae hyn yn pennu\'r hafan ar gyfer defnyddwyr sydd wedi mewngofnodi';
$string['configdefaultrequestcategory'] = 'Caiff cyrsiau y bydd defnyddwyr yn gwneud cais amdanynt eu rhoi yn y categori hwn yn awtomatig.';
$string['configdefaultrequestedcategory'] = 'Categori diofyn ar gyfer cyrsiau y gwnaed cais amdanynt, os ydynt wedi\'u hawdurdodi.';
$string['configdefaultuserroleid'] = 'Bydd pob defnyddiwr sydd wedi mewngofnodi\'n cael galluoedd y swyddogaeth a bennir yma, ar lefel y safle, yn OGYSTAL ag unrhyw swyddogaethau eraill a all fod wedi\'u rhoi iddynt. Y swyddogaeth ddiofyn yw\'r swyddogaeth Defnyddiwr wedi\'i ddilysu. Noder na fydd hyn yn gwrthdaro â swyddogaethau eraill sydd ganddynt oni bai eich bod yn gwahardd galluoedd, dim ond yn sicrhau bod gan bob defnyddiwr alluoedd nad oes modd eu neilltuo ar lefel y cwrs (e.e. postio negeseuon blog, rheoli eu calendr eu hunain, ac ati).';
$string['configdeleteincompleteusers'] = 'Ar ôl y cyfnod hwn, bydd hen gyfrifon sydd heb eu gosod yn llawn yn cael eu dileu.';
$string['configdeleteunconfirmed'] = 'Os ydych chi\'n defnyddio dull dilysu e-bost, caiff ymateb ei dderbyn gan ddefnyddwyr yn y cyfnod hwn. Ar ôl y cyfnod hwn, caiff hen gyfrifon heb eu cadarnhau eu dileu.';
$string['configdenyemailaddresses'] = 'I wrthod cyfeiriadau e-bost o barthau penodol, rhestrwch hwy yma yn yr un ffordd. Derbynnir pob parth arall e.e. <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Dewis peidio galluogi defnyddwyr i newid delweddau proffil defnyddwyr.';
$string['configdisplayloginfailures'] = 'Bydd hyn yn dangos gwybodaeth i ddefnyddwyr dethol am fethiannau mewngofnodi blaenorol.';
$string['configdndallowtextandlinks'] = 'Galluogi neu analluogi llusgo a gollwng testun a dolenni i dudalen cwrs, ynghyd a llusgo a gollwng ffeiliau. Nodwch fod llusgo testun i Firefox neu rhwng gwahanol borwyr yn annibynadwy a gall achosi i ddata fethu a llwytho i fyny neu i destun llygredig gael ei lwytho i y fyny.';
$string['configdocroot'] = 'Mae hwn yn diffinio\'r llwybr at y Dogfennau Moodle ar gyfer darparu dogfennaeth sy’n ymdrin yn benodol â’r cyd-destun trwy ddolenni ‘Dogfennau Moodle ar gyfer y dudalen hon’ yn nhroedyn pob tudalen. Os yw\'r maes yn wag, bydd dolenni ddim yn cael eu dangos.';
$string['configdoctonewwindow'] = 'Os ydych chi\'n galluogi hyn, dangosir dolenni at Ddogfennau Moodle mewn ffenestr newydd.';
$string['configeditordictionary'] = 'Defnyddir y gwerth hwn os nad oes gan aspell eiriadur ar gyfer iaith y defnyddiwr.';
$string['configeditorfontlist'] = 'Dewiswch y ffontiau a ddylai ymddangos yng nghwymprestr y golygydd.';
$string['configemailchangeconfirmation'] = 'Gofyn am gam ychwanegol i gadarnhad e-bost pan fydd defnyddwyr yn newid eu cyfeiriad e-bost yn eu proffil.';
$string['configenableajax'] = 'Mae\'r gosodiad hwn yn rheoli\'r defnydd o AJAX ar draws y safle. Mae AJAX yn ofynnol ar gyfer rhai swyddogaethau fel llusgo a gollwng.';
$string['configenableblogs'] = 'Mae\'r switsh yn darparu holl ddefnyddwyr y safle gyda\'u blog eu hunain.';
$string['configenablecalendarexport'] = 'Galluogi allgludo calendrau neu danysgrifio iddynt.';
$string['configenablecomments'] = 'Galluogi sylwadau';
$string['configenablecourserequests'] = 'Bydd hyn yn gadael i unrhyw ddefnyddiwr wneud cais am greu cwrs.';
$string['configenabledevicedetection'] = 'Mae\'n galluogi canfod ffonau symudol, ffonau clyfar, cyfrifiaduron tabled neu ddyfeisiau diofyn (cyfrifiaduron pen desg, gliniaduron, ac ati) er mwyn defnyddio themâu a nodweddion eraill.';
$string['configenablegroupmembersonly'] = 'Os yw wedi\'i alluogi, dim ond aelodau\'r grŵp fydd yn cael mynediad at weithgareddau. Gallai hyn arwain at gynnydd yn llwyth y gweinydd. At hynny, rhaid sefydlu categorïau llyfr graddau mewn ffordd benodol i sicrhau bod y gweithgareddau\'n cael eu cuddio rhag y rheini nad ydynt yn aelodau o\'r grŵp.';
$string['configenablemobilewebservice'] = 'Galluogi gwasanaeth symudol ar gyfer y rhaglen app Moodle swyddogol neu\'r rhaglen app arall sy\'n gwneud cais amdano. I gael rhagor o wybodaeth, darllenwch y {$a}';
$string['configenablerssfeeds'] = 'Os yw wedi’i alluogi, bydd porthiannau RSS yn cael eu cynhyrchu gan nifer o wahanol nodweddion o bob rhan o’r safle, fel blogs, fforymau, gweithgareddau cronfeydd data a rhestrau termau. Nodwch hefyd bod angen i borthiannau RSS fod wedi’u galluogi ar gyfer y modiwlau gweithgaredd arbennig.';
$string['configenablerssfeedsdisabled'] = 'Nid yw ar gael gan fod porthiannau RSS wedi\'u hanalluogi yn yr holl Safle. I\'w galluogi, ewch i\'r gosodiadau Newidynnau dan Ffurfweddu Gweinyddol.';
$string['configenablerssfeedsdisabled2'] = 'Mae crynodebau RSS wedi\'u hanalluogi ar lefel y gweinydd. Rhaid i chi eu galluogi yn gyntaf yn y Gweinydd/RSS.';
$string['configenablesafebrowserintegration'] = 'Mae hwn yn ychwanegu\'r dewis \'Rhaid Cael Porwr Arholiadau Diogel\' at y maes \'Diogelwch porwr\' ar ffurflen gosodiadau\'r cwis. Ewch i http://www.safeexambrowser.org/ am ragor o wybodaeth.';
$string['configenablestats'] = 'Os dewiswch \'iawn\' yma, bydd cronjob Moodle yn prosesu\'r cofnodion ac yn casglu rhai ystadegau. Gan ddibynnu faint o draffig sydd ar eich safle, gall hyn gymryd cryn amser. Os ydych yn galluogi hyn, gallwch weld rhai graffiau ac ystadegau diddorol am bob un o\'ch cyrsiau, neu am y safle\'n gyffredinol.';
$string['configenabletrusttext'] = 'Yn ddiofyn, bydd Moodle yn glanhau testun a ddaw gan ddefnyddwyr yn drwyadl er mwyn tynnu unrhyw sgriptiau neu ddeunydd amlgyfrwng drwg ayb. a allai fod yn risg diogelwch. Mae\'r system Cynnwys Cymeradwy yn ffordd o roi\'r gallu i ddefnyddwyr penodol yr ydych yn ymddiried ynddynt gynnwys y nodweddion datblygedig hyn yn eu cynnwys heb ymyrryd. I alluogi\'r system hon, yn gyntaf bydd angen i chi alluogi\'r gosodiad hwn, yna rhoi\'r caniatâd Cynnwys Cymeradwy i swyddogaeth Moodle benodol. Caiff testunau a grëir neu a lwythir i fyny gan ddefnyddwyr o\'r fath eu marcio\'n gymeradwy, ac ni chânt eu glanhau cyn eu harddangos.';
$string['configenablewebservices'] = 'Mae gwasanaethau gwe yn galluogi systemau eraill i fewngofnodi i\'r Moodle hwn ac i wneud pethau. Oni bai eich bod wir yn ei ddefnyddio, dylech analluogi\'r gosodiad hwn er mwyn bod yn fwy diogel.';
$string['configenablewsdocumentation'] = 'Mae\'n galluogi cynhyrchu dogfennau gwasanaethau gwe yn awtomatig. Gall defnyddiwr fynd i\'w ddogfennau ei hun ar ei dudalen allweddi diogelwch {$a}. Mae\'n dangos y dogfennau ar gyfer y protocolau a alluogwyd yn unig.';
$string['configerrorlevel'] = 'Dewiswch faint o rybuddion PHP yr hoffech eu gweld. Fel arfer, normal fydd y dewis gorau.';
$string['configexportlookahead'] = 'Diwrnodau i edrych ymlaen yn ystod allfudo';
$string['configexportlookback'] = 'Diwrnodau i edrych yn ôl yn ystod allfudo';
$string['configextendedusernamechars'] = 'Galluogwch y gosodiad hwn i ganiatáu i fyfyrwyr ddefnyddio unrhyw nodau yn eu henwau defnyddiwr (cofiwch nad yw hyn yn effeithio ar eu henwau gwirioneddol). Y dewis diofyn yw "gau" sy\'n cyfyngu enwau defnyddwyr i lythrennau bach a nodau alffaniwmerig, tanlinell (_), cysylltnod (-), atalnod llawn (.) neu symbol at (@).';
$string['configextramemorylimit'] = 'Mae angen rhagor o gof ar rai sgriptiau fel chwilio, gwneud copi wrth gefn/adfer neu cron. Dylech osod gwerthoedd uwch ar gyfer safleoedd mawr.';
$string['configfilterall'] = 'Hidlo pob llinyn, gan gynnwys penawdau, teitlau, bar llywio ac yn y blaen. Bydd hyn fwyaf defnyddiol wrth ddefnyddio\'r hidlydd aml iaith; fel arall bydd yn creu llwyth ychwanegol ar eich safle heb iddo elwa lawer.';
$string['configfiltermatchoneperpage'] = 'Bydd hidlyddion i greu dolenni\'n awtomatig yn creu un ddolen yn unig at y testun cyfatebol cyntaf a ganfyddir ar y dudalen lawn. Caiff pob un arall ei anwybyddu.';
$string['configfiltermatchonepertext'] = 'Bydd hidlyddion i greu dolenni\'n awtomatig yn creu un ddolen yn unig i\'r testun cyfatebol cyntaf a ganfyddir ym mhob eitem testun (e.e. adnodd, bloc) ar y dudalen. Caiff pob un arall ei anwybyddu. Caiff y gosodiad hwn ei anwybyddu os dewiswyd y gosodiad <i>un i bob tudalen<i>.';
$string['configfilteruploadedfiles'] = 'Prosesu pob ffeil HTML a phob ffeil testun a lwythwyd i fyny gyda\'r hidlyddion cyn eu dangos, y ffeiliau HTML a lwythir i fyny\'n unig, neu ddim ffeiliau o gwbl.';
$string['configforcelogin'] = 'Fel arfer, gall pobl ddarllen tudalen flaen y safle a\'r rhestri cyrsiau (ond nid y cyrsiau eu hunain) heb fewngofnodi ar y safle. Os ydych am orfodi pobl i fewngofnodi cyn gwneud UNRHYW BETH ar y safle, dylech alluogi\'r gosodiad hwn.';
$string['configforceloginforprofiles'] = 'Mae\'r gosodiad hwn yn gorfodi pobl i fewngofnodi fel cyfrif real (nid gwestai) cyn cael gweld proffil unrhyw ddefnyddiwr.  Os ydych wedi analluogi\'r gosodiad hwn, efallai y gwelwch rai defnyddwyr yn postio hysbysebion (sbam) neu gynnwys amhriodol arall yn eu proffiliau, a bod y proffiliau hyn yn weladwy i\'r byd i gyd.';
$string['configfrontpage'] = 'Bydd yr eitemau a ddewisir uchod i\'w gweld ar dudalen flaen y safle.';
$string['configfrontpagecourselimit'] = 'Uchafswm y nifer o gyrsiau';
$string['configfrontpagecourselimithelp'] = 'Uchafswm y nifer o gyrsiau i’w dangos ar dudalen flaen y safle yn y rhestr cyrsiau.';
$string['configfrontpageloggedin'] = 'Bydd yr eitemau a ddewisir uchod i\'w gweld ar dudalen flaen y safle pan fydd defnyddiwr wedi mewngofnodi.';
$string['configfullnamedisplay'] = 'Mae hyn yn diffinio sut bydd enwau\'n edrych pan gânt eu dangos yn llawn. Ar gyfer y rhan fwyaf o safleoedd uniaith, y gosodiad mwyaf effeithlon yw "Enwau + Cyfenw", sef y gosodiad diofyn, ond efallai y dewiswch guddio cyfenwau\'n gyfan gwbl, neu adael i\'r pecyn iaith cyfredol benderfynu (mae gwahanol gonfensiynau gan rai ieithoedd).';
$string['configgeoipfile'] = 'Lleoliad y ffeil ddata beuaidd GeoIP City. Dydy\'r ffeil hon ddim yn rhan o ddosbarthiad Moodle a rhaid ei gael ar wahân o <a href="http://www.maxmind.com/">MaxMind</a>. Gallwch naill ai brynu fersiwn masnachol neu ddefnyddio\'r fersiwn rhad ac am ddim.<br />Mae\'n syml - llwythwch y ffeil <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> a\'i hechdynnu i gyfeiriadur "{$a}" eich gweinydd.';
$string['configgetremoteaddrconf'] = 'Os yw eich gweinydd y tu ôl i ddirprwy weinydd gwrthdro, gallwch ddefnyddio\'r gosodiad hwn i bennu pa benynnau HTTP y gallwch ymddiried ynddynt i gynnwys y cyfeiriad IP o bell.';
$string['configgradebookroles'] = 'Mae\'r gosodiad hwn yn eich galluogi i reoli pwy sy\'n ymddangos ar y llyfr graddau. Rhaid i ddefnyddwyr gael o leiaf un o\'r swyddogaethau hyn mewn cwrs cyn eu bod yn ymddangos yn llyfr graddau\'r cwrs hwnnw.';
$string['configgradeexport'] = 'Dewiswch ba fformatau allgludo llyfr graddau yw eich prif ddulliau o allgludo graddau. Yna, bydd ategion penodol yn gosod ac yn defnyddio maes "allgludwyd diwethaf" ar gyfer pob gradd. Er enghraifft, gallai hyn arwain at nodi cofnodion sydd wedi\'u hallgludo fel rhai "newydd" neu "wedi diweddaru". Os nad ydych chi\'n siŵr am hyn, yna peidiwch â thicio dim.';
$string['confighiddenuserfields'] = 'Er mwyn gwella preifatrwydd myfyrwyr, cewch ddewis pa feysydd gwybodaeth defnyddiwr yr ydych am eu cuddio rhag defnyddwyr eraill, heblaw athrawon y cwrs a gweinyddwyr. Daliwch y fysell CTRL i ddewis mwy nag un maes.';
$string['configidnumber'] = 'Mae\'r dewis hwn yn pennu\'r canlynol: (a) Ni ofynnir i ddefnyddwyr am rif ID o gwbl, (b) Gofynnir i ddefnyddwyr am rif ID ond gallant ei adael yn wag neu (c) Gofynnir i ddefnyddwyr am rif ID ac ni allant ei adael yn wag. Os bydd y defnyddiwr yn rhoi rhif ID, caiff ei ddangos yn ei Broffil.';
$string['configintro'] = 'Ar y dudalen hon, gallwch bennu nifer o newidynnau ffurfweddu i helpu Moodle i weithio\'n iawn ar eich gweinydd.  Peidiwch â phoeni gormod am hyn - fel arfer bydd y rhagosodiadau\'n gweithio\'n iawn, a gallwch ddod yn ôl i\'r dudalen hon i newid y gosodiadau unrhyw bryd.';
$string['configintroadmin'] = 'Ar y dudalen hon, dylech ffurfweddu eich prif gyfrif gweinyddwr a fydd â rheolaeth lwyr dros y safle. Sicrhewch eich bod yn rhoi enw defnyddiwr a chyfrinair diogel iddo, yn ogystal â chyfeiriad e-bost dilys.  Gallwch greu mwy o gyfrifon gweinyddwyr rywbryd eto.';
$string['configintrosite'] = 'Ar y dudalen hon, gallwch ffurfweddu tudalen flaen ac enw\'r safle newydd hwn. Gallwch ddo yn ôl rywbryd eto i newid y gosodiadau hyn unrhyw bryd drwy ddefnyddio\'r dewislenni Gweinyddu.';
$string['configiplookup'] = 'Pan gliciwch ar gyfeiriad IP (megis 34.12.222.93), fel yn y cofnodion, dangosir map i chi sy\'n dyfalu lle mae\'r IP hwnnw wedi\'i leoli. Mae gwahanol ategion ar gyfer hyn y gallwch ddewis o\'u mysg, ac mae gan bob un ei fanteision a\'i anfanteision.';
$string['configkeeptagnamecase'] = 'Ticiwch hwn os ydych am i enwau tag gadw eu casin gwreiddiol a roddwyd gan y defnyddwyr wnaeth eu creu';
$string['configlang'] = 'Dewis iaith ddiofyn ar gyfer yr holl safle. Gall defnyddwyr ddiystyru\'r gosodiad hwn trwy ddefnyddio\'r ddewislen iaith neu\'r gosodiadau yn eu proffil personol.';
$string['configlanglist'] = 'Gadewch hwn yn wag i adael defnyddwyr i ddewis unrhyw un o\'r ieithoedd sydd gennych yn y gosodiad Moodle hwn.  Fodd bynnag, gallwch gwtogi\'r ddewislen iaith drwy roi rhestr o\'r codau iaith yr hoffech gyda chomas rhyngddynt.  Er enghraifft:  en,es_es,fr,it';
$string['configlangmenu'] = 'Dewis a hoffech ddangos y ddewislen iaith gyffredinol yn yr hafan, y dudalen mewngofnodi, ayb.  Ni fydd hyn yn effeithio ar allu defnyddwyr i ddewis eu hoff iaith yn eu proffil eu hunain.';
$string['configlangstringcache'] = 'Mae hyn yn storio\'r holl linynnau iaith i ffeiliau wedi\'u crynhoi yn y cyfeiriadur data. Os ydych chi\'n cyfieithu Moodle neu\'n newid llinynnau yng nghod ffynhonnell Moodle, efallai byddwch yn dewis diffodd hwn. Fel arall, gallwch ei adael ymlaen i weld y manteision o ran perfformiad.';
$string['configlatinexcelexport'] = 'Dewis yr amgodio ar gyfer eitemau a allgludir o Excel.';
$string['configlocale'] = 'Dewiswch locale cyffredinol i\'r safle - bydd hwn yn diystyru fformat a iaith dyddiadau ar gyfer pob pecyn iaith (ond ni fydd yn effeithio ar enwau dyddiau yn y calendr). Mae angen gosod y data locale ar eich system gweithredu (e.e. ar gyfer linux en_US.UTF-8 neu es_ES.UTF-8). Yn y rhan fwyaf o achosion, dylid gadael y maes hwn yn wag.';
$string['configloginhttps'] = 'Drwy droi hwn ymlaen, bydd Moodle yn defnyddio cysylltiad diogel https ar gyfer y dudalen mewngofnodi\'n unig (er mwyn mewngofnodi\'n ddiogel), ac yna\'n dychwelyd i\'r URL http normal ar gyfer cyflymder cyffredinol.  RHYBUDD: mae ANGEN galluogi https yn benodol ar y gweinydd gwe cyn defnyddio\'r gosodiad hwn - os na wnewch, GALLECH GLOI EICH HUN ALLAN O\'CH SAFLE.';
$string['configloglifetime'] = 'Mae hyn yn pennu am faint o amser yr hoffech gadw logiau am weithgaredd defnyddwyr. Caiff logiau sy\'n hŷn na hyn eu dileu\'n awtomatig. Rydym yn argymell eich bod yn cadw logiau am gyn hired â phosibl, rhag ofn y bydd eu hangen arnoch, ond os oes gennych chi weinydd prysur iawn a\'ch bod yn cael problemau perfformiad, yna efallai yr hoffech leihau oes y log. Dydyn ni ddim yn argymell gwerthoedd is na 30 oherwydd efallai na fydd yr ystadegau\'n gweithio\'n iawn.';
$string['configlookahead'] = 'Dyddiau i Edrych Ymlaen';
$string['configmaxbytes'] = 'Mae hyn yn pennu\'r uchafswm maint ar gyfer ffeiliau a lwythir i fyny drwy\'r safle i gyd. Cyfyngir ar y gosodiad hwn gan y gosodiadau PHP post_max_size ac upload_max_filesize, yn ogystal â\'r gosodiad Apache LimitRequestBody. Yn ei dro, mae maxbytes yn cyfyngu ar y gwahanol feintiau y gellir eu dewis ar lefel y cwrs neu ar lefel y modiwlau.';
$string['configmaxconsecutiveidentchars'] = 'Ddylai cyfrineiriau ddim gael mwy na\'r rhif hwn o nodau union yr un peth yn dilyn ei gilydd. Defnyddiwch 0 i analluogi\'r archwiliad hwn.';
$string['configmaxeditingtime'] = 'Mae hwn yn pennu faint o amser sydd gan bobl i olygu negeseuon a bostiwyd ar y fforwm, sylwadau am eirfa ayb. Fel arfer, bydd 30 munud yn werth da.';
$string['configmaxevents'] = 'Digwyddiadau i Edrych Ymlaen';
$string['configmaxusersperpage'] = 'Y nifer mwyaf o ddefnyddwyr i\'w dangos mewn dewisydd defnyddiwr yn cwrs, grŵp, cohort, gwasanaeth gwe ayb.';
$string['configmessaging'] = 'A ddylai\'r system anfon negeseuon rhwng safleoedd fod wedi\'i galluogi?';
$string['configmessagingallowemailoverride'] = 'Caniatáu i hysbysiadau negeseuon e-bost gael eu hanfon i gyfeiriad e-bost gwahanol i\'r cyfeiriad e-bost sydd ym mhroffil y defnyddiwr';
$string['configmessagingdeletereadnotificationsdelay'] = 'Gallwch ddileu hysbysiadau sydd wedi\'u darllen er mwyn arbed lle. Faint o amser sy\'n rhaid disgwyl ar ôl darllen hysbysiad cyn y gellir ei ddileu?';
$string['configmessaginghidereadnotifications'] = 'Cuddio hysbysiadau sydd wedi\'u darllen am ddigwyddiadau megis postio negeseuon ar fforwm wrth edrych ar hanes negeseuon';
$string['configminpassworddigits'] = 'Rhaid i gyfrineiriau gael o leiaf cymaint â hyn o rifau.';
$string['configminpasswordlength'] = 'Rhaid i gyfrineiriau gael o leiaf cymaint â hyn o nodau.';
$string['configminpasswordlower'] = 'Rhaid i gyfrineiriau gael o leiaf cymaint â hyn o lythrennau bach.';
$string['configminpasswordnonalphanum'] = 'Rhaid i gyfrineiriau gael o leiaf cymaint â hyn o nodau nad ydynt yn llythrennau nac yn rhifau.';
$string['configminpasswordupper'] = 'Rhaid i gyfrineiriau gael o leiaf cymaint â hyn o briflythrennau.';
$string['configmobilecssurl'] = 'Ffeil CSS i bersonoli rhyngwyneb eich app symudol';
$string['configmodchooserdefault'] = 'Dylai\'r dewiswr gweithgareddau gael ei gyflwyno i\'r defnyddiwr yn ddiofyn?';
$string['configmycoursesperpage'] = 'Nifer fwyaf y cyrsiau sy\'n ymddangos mewn unrhyw restr o gyrsiau\'r defnyddiwr ei hun.';
$string['configmymoodleredirect'] = 'Mae\'r gosodiad hwn yn gorfodi ailgyfeiriadau i /my wrth i bobl nad ydynt yn weinyddwyr fewngofnodi, ac yn disodli briwsionyn lefel uchaf y safle gyda /my';
$string['configmypagelocked'] = 'Mae\'r gosodiad hwn yn atal y dudalen ddiofyn rhag cael ei golygu gan bobl nad ydynt yn weinyddwyr.';
$string['confignavcourselimit'] = 'Mae hyn yn cyfyngu nifer y cyrsiau sy\'n cael eu dangos i\'r defnyddiwr pan nad yw wedi mewngofnodi neu os nad yw wedi cofrestru ar unrhyw gwrs.';
$string['confignavshowallcourses'] = 'Mae’r gosodiad hwn yn pennu os bydd defnyddwyr sydd wedi cofrestru ar gyfer cwrs yn gallu gweld Cyrsiau (sy’n rhestru pob cwrs) yn yr adran llywio, yn ogystal â Fy Nghyrsiau (sy\'n rhestru\'r cyrsiau y maent wedi cofrestru ar eu cyfer).';
$string['confignavshowcategories'] = 'Dangos categorïau cwrs yn y bar llywio ac yn y blociau llywio. Dydy hyn ddim yn digwydd mewn cyrsiau mae\'r defnyddiwr wedi cofrestru arnynt yn barod, ond byddant yn cael eu rhestru dan fy nghyrsiau heb gategorïau.';
$string['confignotifyloginfailures'] = 'Os cofnodwyd methiannau mewngofnodi, gellir anfon hysbysiadau e-bost allan. Pwy ddylai weld yr hysbysiadau hyn?';
$string['confignotifyloginthreshold'] = 'Os yw hysbysiadau am fethiannau mewngofnodi\'n weithredol, sawl methiant mewngofnodi gan un defnyddiwr neu un cyfeiriad IP y mae\'n werth hysbysu amdanynt?';
$string['confignotloggedinroleid'] = 'Caiff defnyddwyr sydd heb fewngofnodi i\'r safle eu trin fel bod y swyddogaeth hon wedi\'i rhoi iddynt yng nghyd-destun y safle. Gwestai fydd ei eisiau arnoch yma bron bob tro, ond efallai yr hoffech greu swyddogaethau sy\'n fwy neu\'n llai cyfyngol. Bydd angen i\'r defnyddiwr fewngofnodi\'n iawn i greu postiadau, ac ati.';
$string['configopentogoogle'] = 'Os ydych yn galluogi\'r gosodiad hwn, caiff Google fynediad i\'ch safle fel Gwestai. Hefyd, caiff pobl sy\'n dod i\'ch safle ar ôl chwilio ar Google eu mewngofnodi fel Gwestai\'n awtomatig.  Cofiwch mai dim ond mynediad tryloyw y bydd hyn yn ei ddarparu i gyrsiau sydd eisoes yn caniatáu mynediad i westeion.';
$string['configoverride'] = 'Wedi\'i ddiffinio yn config.php';
$string['configpasswordpolicy'] = 'Bydd dewis defnyddio hwn yn dweud wrth Moodle i wirio cyfrineiriau defnyddiwr yn erbyn polisi cyfrinair dilys. Defnyddiwch y gosodiadau isod i bennu eich polisi (byddant yn cael eu hanwybyddu os ydych yn dewis \'Na\').';
$string['configpasswordresettime'] = 'Bydd hwn yn pennu faint o amser sydd gan bobl i ddilysu cais ailosod cyfrinair cyn ei fod yn dod i ben. Fel arfer mae 30 munud yn werth da.';
$string['configpathtoclam'] = 'Llwybr at clam AV. Mae\'n debyg y bydd yn rhywbeth fel /usr/bin/clamscan neu /usr/bin/clamdscan. Mae angen hwn arnoch er mwyn i clam AV redeg.';
$string['configpathtodu'] = 'Llwybr at du. Mae\'n debyg y bydd yn rhywbeth fel /usr/bin/du. Os teipiwch hwn, bydd tudalennau sy\'n dangos cynnwys cyfeiriaduron yn rhedeg yn llawer cyflymach ar gyfer cyfeiriaduron â llawer o ffeiliau ynddynt.';
$string['configperfdebug'] = 'Os ydych chi\'n galluogi hyn, caiff gwybodaeth am berfformiad ei argraffu yn nhroedyn y thema safonol';
$string['configprofileroles'] = 'Rhestr o\'r swyddogaethau sydd i\'w gweld ar y dudalen cyfranogi a phroffiliau defnyddwyr.';
$string['configprofilesforenrolledusersonly'] = 'Er mwyn atal sbamwyr, caiff disgrifiadau proffil defnyddwyr sydd heb gofrestru ar unrhyw gwrs eu cuddio. Rhaid i ddefnyddwyr newydd gofrestru ar o leiaf un cwrs cyn y gallant ychwanegu disgrifiad proffil.';
$string['configprotectusernames'] = 'Yn ddiofyn, ni fydd forget_password.php yn dangos unrhyw awgrymiadau a allai arwain at rywun yn dyfalu enwau defnyddwyr neu gyfeiriadau e-bost.';
$string['configproxybypass'] = 'Rhestr gyda chomas rhyngddynt o gyfeiriadau IP neu enwau gwesteiwyr (rhannol) ddylai osgoi\'r dirprwy (e.e. 192.168., .fymharth.com';
$string['configproxyhost'] = 'Os oes angen i\'r <b>gweinydd</b> hwn ddefnyddio cyfrifiadur dirprwyol (e.e. mur cadarn) i ddefnyddio\'r Rhyngrwyd, rhowch enw gwesteiwr a phorth y dirprwy yma.  Fel arall, gadewch yn wag.';
$string['configproxypassword'] = 'Mae angen cyfrinair i gael mynediad at y rhyngrwyd drwy ddirprwy yn ôl y gofyn. Bydd yn wag os yw\'n ddim (angen estyniad PHP cURL).';
$string['configproxyport'] = 'Os oes angen cyfrifiadur dirprwyol ar y gweinydd hwn, rhowch y porth dirprwyol yma.';
$string['configproxytype'] = 'Math o ddirprwy gwe (angen estyniad PHP5 a cURL ar gyfer cymorth SOCKS5).';
$string['configproxyuser'] = 'Mae angen enw defnyddiwr i gael mynediad at y rhyngrwyd drwy ddirprwy yn ôl y gofyn. Bydd yn wag os yw\'n ddim (angen estyniad PHP cURL).';
$string['configquarantinedir'] = 'Os hoffech i clam AV symud ffeiliau heintiedig i gyfeiriadur cwarantin, enwch ef yma. Rhaid i\'r gweinydd gwe allu ysgrifennu ynddo. Os ydych yn ei adael yn wag, os enwch gyfeiriadur nad yw\'n bodoli, neu nad oes modd ysgrifennu ynddo, caiff ffeiliau heintiedig eu dileu. Peidiwch â chynnwys slaes ar y diwedd.';
$string['configrecaptchaprivatekey'] = 'Llinyn o nodau a ddefnyddir i gyfathrebu rhwng eich gweinydd Moodle a\'r gweinydd recaptcha. Gallwch gael un ar gyfer y safle hwn drwy fynd i http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Llinyn o nodau a ddefnyddir i ddangos yr elfen reCAPTCHA yn y ffurflen creu cyfrif. Caiff ei gynhyrchu gan http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Caniatáu dewis categori wrth wneud cais am gwrs.';
$string['configrequestedstudentname'] = 'Y gair am fyfyriwr a ddefnyddir yn y cyrsiau y gofynnwyd amdanynt';
$string['configrequestedstudentsname'] = 'Y gair am fyfyrwyr a ddefnyddir yn y cyrsiau y gofynnwyd amdanynt';
$string['configrequestedteachername'] = 'Y gair am athro a ddefnyddir yn y cyrsiau y gofynnwyd amdanynt';
$string['configrequestedteachersname'] = 'Y gair am athrawon a ddefnyddir yn y cyrsiau y gofynnwyd amdanynt';
$string['configrequiremodintro'] = 'Dylech analluogi\'r dewis hwn os nad ydych chi am orfodi defnyddwyr i roi disgrifiad o bob gweithgaredd.';
$string['configrunclamavonupload'] = 'Wedi\'i alluogi, defnyddir clam AV i sganio pob ffeil a lwythir i fyny.';
$string['configrunclamonupload'] = 'Rhedeg clam AV wrth lwytho ffeil i fyny? Bydd arnoch angen llwybr cywir yn pathtoclam er mwyn i hyn weithio.  (Mae Clam AV yn sganiwr firysau y gallwch ei gael am ddim o http://www.clamav.net/)';
$string['configsectioninterface'] = 'Rhyngwyneb';
$string['configsectionmail'] = 'Post';
$string['configsectionmaintenance'] = 'Cynnal a chadw';
$string['configsectionmisc'] = 'Amrywiol';
$string['configsectionoperatingsystem'] = 'System gweithredu';
$string['configsectionpermissions'] = 'Caniatâd';
$string['configsectionrequestedcourse'] = 'Ceisiadau cwrs';
$string['configsectionsecurity'] = 'Diogelwch';
$string['configsectionstats'] = 'Ystadegau';
$string['configsectionuser'] = 'Defnyddiwr';
$string['configsecureforms'] = 'Gall Moodle ddefnyddio lefel diogelwch ychwanegol wrth dderbyn data o ffurflenni gwe. Os caiff hyn ei alluogi, caiff newidyn HTTP_REFERER y porwr ei wirio yn erbyn cyfeiriad y ffurflen gyfredol. Mewn rhai achosion prin, gall hyn achosi problemau os yw\'r defnyddiwr yn defnyddio mur cadarn (e.e. Zonealarm) wedi\'i ffurfweddu i stripio HTTP_REFERER o\'u traffig gwe. Y symptomau yw mynd yn \'sownd\' ar ffurflen. Os yw eich defnyddwyr yn cael problemau gyda\'r dudalen mewngofnodi (er enghraifft) efallai yr hoffech analluogi\'r gosodiad hwn, er y gallai hynny adael eich safle\'n fwy agored i ymosodiadau ar gyfrinair drwy rym. Os oes gennych amheuaeth, gadewch hwn wedi\'i osod yn \'Iawn\'.';
$string['configsessioncookie'] = 'Mae\'r gosodiad hwn yn personoli enw\'r briwsionyn a ddefnyddir ar gyfer sesiynau Moodle. Mae hwn yn ddewisol, a\'r unig ffordd y mae\'n ddefnyddiol yw i osgoi drysu briwsion pan fydd mwy nag un copi o Moodle yn rhedeg o fewn yr un wefan.';
$string['configsessioncookiedomain'] = 'Mae hyn yn eich galluogi i newid y parth lle mae cwcis Moodle ar gael. Mae hyn yn ddefnyddiol ar gyfer addasu Moodle (e.e. ategion dilysu neu greu cyfrif) os oes angen rhannu gwybodaeth am sesiwn Moodle gyda rhaglen ar y we neu is-barth arall. <strong>RHYBUDD: rydym yn argymell yn gryf eich bod yn gadael y gosodiad hwn ar y dewis diofyn (gwag) - bydd gwerth anghywir yn atal pob ymgais i fewngofnodi i\'r safle.</strong>';
$string['configsessioncookiepath'] = 'Os bydd arnoch angen newid lle bydd porwyr yn anfon briwsion Moodle, gallwch newid y gosodiad hwn i bennu un o is-gyfeiriaduron eich gwefan.  Fel arall, dylai\'r dewis diofyn \'/\' fod yn iawn.';
$string['configsessiontimeout'] = 'Os bydd pobl sydd wedi mewngofnodi i\'r safle hwn yn segur am amser hir (heb lwytho tudalennau) cânt eu hallgofnodi\'n awtomatig (caiff eu sesiwn ei ddiweddu). Mae\'r newidyn hwn yn pennu pa mor hir y dylai\'r amser hwn fod.';
$string['configshowcommentscount'] = 'Dangos y blwch cyfri sylwadau, bydd yn costio un ymholiad yn fwy wrth ddangos y ddolen sylwadau';
$string['configshowicalsource'] = 'Dangos gwybodaeth am ffynhonnell ar gyfer digwyddiadau iCal';
$string['configshowsiteparticipantslist'] = 'Caiff y myfyrwyr safle a\'r athrawon safle hyn i gyd eu rhestru ar restr cyfranogwyr y safle. Pwy gaiff weld rhestr cyfranogwyr y safle?';
$string['configsitedefaultlicense'] = 'Trwydded ddiofyn y safle';
$string['configsitedefaultlicensehelp'] = 'Y drwydded ddiofyn ar gyfer cyhoeddi cynnwys ar y safle hwn';
$string['configsitemaxcategorydepth'] = 'Dyfnder mwyaf y categori';
$string['configsitemaxcategorydepthhelp'] = 'Mae hyn yn pennu dyfnder mwyaf yr is-gategorïau a ehangwyd wrth ddangos categorïau neu restr gyfun. Bydd categorïau o lefelau dyfnach yn dangos fel dolenni a gall defnyddwyr eu ehangu gyda cais AJAX.';
$string['configslasharguments'] = 'Darperir ffeiliau (delweddau, eitemau a lwythir i fyny, ayb) drwy sgript sy\'n defnyddio \'argiau slaes\' (yr ail ddewis yma). Mae\'r dull hwn yn caniatáu storio ffeiliau\'n haws mewn porwyr gwe, gweinyddion dirprwyol ayb. Yn anffodus, nid yw rhai gweinyddion PHP yn caniatáu\'r dull hwn, felly os cewch anhawster wrth geisio gweld ffeiliau neu ddelweddau a lwythwyd i fyny (e.e. lluniau defnyddwyr), dylech chi analluogi\'r gosodiad hwn.';
$string['configsmartpix'] = 'Pan fydd hwn ymlaen, caiff eiconau eu cyflwyno drwy sgript PHP sy\'n chwilio drwy\'r thema gyfredol, yna drwy bob thema rhiant, ac yna drwy ffolder /pix Moodle. Bydd hyn yn lleihau\'r angen i ddyblygu ffeiliau delwedd o fewn themâu, ond bydd y perfformiad yn dioddef ychydig.';
$string['configstartwday'] = 'Dechrau wythnos';
$string['configstatsfirstrun'] = 'Mae hwn yn pennu pa mor bell yn ôl y dylid prosesu\'r cofnodion <b>y tro cyntaf</b> y bydd y cronjob am brosesu ystadegau. Os oes gennych chi lawer o draffig a\'ch bod ar system rhannu gwesteiwr, mae\'n debyg na fydd yn syniad da mynd yn rhy bell yn ôl, gan y gallai gymryd amser maith i redeg gan ddefnyddio llawer o adnoddau. (Cofiwch, ar gyfer y gosodiad hwn, 1 mis = 28 diwrnod. Yn y graffiau a\'r adroddiadau a gynhyrchir, 1 mis = 1 mis calendr.)';
$string['configstatsmaxruntime'] = 'Gall prosesu ystadegau fod yn waith eithaf dwys, felly defnyddiwch gyfuniad o\'r maes hwn a\'r maes nesaf i nodi pryd y bydd yn rhedeg, ac am ba mor hir.';
$string['configstatsmaxruntime2'] = 'Gall prosesu ystadegau fod yn waith caled. Pennwch yr amser hiraf a ganiateir ar gyfer casglu un diwrnod o ystadegau. Nifer fwyaf y diwrnodau sy\'n gallu cael eu prosesu mewn un weithred cron yw 31.';
$string['configstatsmaxruntime3'] = 'Pennwch yr amser hiraf a ganiateir i gyfrifo\'r ystadegau ar gyfer un diwrnod, gan gofio bod prosesu ystadegau yn rhoi cryn dipyn o faich ar y gweinydd. Gallwch bennu\'r nifer fwyaf o ddiwrnodau sy\'n cael eu prosesu mewn un cron isod.';
$string['configstatsruntimedays'] = 'Pennwch nifer fwyaf y diwrnodau sy\'n cael eu prosesu ym mhob gweithred ystadegau. Pan fydd yr ystadegau wedi\'u diweddaru, dim ond un diwrnod fydd yn cael ei brosesu, felly newidiwch y gwerth hwn yn dibynnu ar lwyth eich gweinydd. Gallwch ei ostwng os oes angen gweithredoedd cron byrrach.';
$string['configstatsruntimestart'] = 'Faint o\'r gloch ddylai\'r cronjob sy\'n prosesu\'r ystadegau gychwyn? Caiff ei argymell eich bod yn pennu gwahanol amseroedd os oes mwy nag un safle Moodle ar un gweinydd.';
$string['configstatsuserthreshold'] = 'Mae\'r gosodiad hwn yn pennu nifer leiaf y defnyddwyr cofrestredig er mwyn cynnwys cwrs mewn cyfrifiadau ystadegau.';
$string['configstrictformsrequired'] = 'Os yw hwn wedi\'i alluogi, fydd defnyddwyr ddim yn gallu rhoi bwlch neu doriad llinell yn unig mewn meysydd gofynnol ar ffurflenni.';
$string['configstripalltitletags'] = 'Dad-diciwch y gosodiad hwn i ganiatáu rhoi tagiau HTML mewn enwau adnoddau a gweithgareddau.';
$string['configsupportemail'] = 'Caiff y cyfeiriad e-bost hwn ei gyhoeddi i ddefnyddwyr y safle hwn fel yr un i gysylltu ag ef os oes angen help cyffredinol arnynt (er enghraifft, pan fydd defnyddwyr newydd yn creu eu cyfrifon eu hunain). Os yw hwn yn wag, yna ni fydd cyfeiriad e-bost ar gael i gynnig help defnyddiol i ddefnyddwyr.';
$string['configsupportname'] = 'Dyma enw\'r unigolyn neu\'r endid sy\'n cynnig help cyffredinol drwy e-bost neu gyfeiriad gwe.';
$string['configsupportpage'] = 'Caiff y cyfeiriad gwe hwn ei gyhoeddi i ddefnyddwyr y safle hwn fel yr un i gysylltu ag ef os oes angen help cyffredinol arnynt (er enghraifft, pan fydd defnyddwyr newydd yn creu eu cyfrifon eu hunain). Os yw hwn yn wag, yna ni fydd cyfeiriad gwe ar gael i gynnig help defnyddiol i ddefnyddwyr.';
$string['configthemedesignermode'] = 'Fel arfer, bydd pob delwedd thema a thaflenni arddull yn cael eu storio am gyfnod hir iawn mewn porwyr ac ar y gweinydd, am resymau perfformiad. Os ydych chi\'n dylunio themâu neu\'n datblygu cod yna efallai y byddwch yn dewis defnyddio hwn fel nad ydych chi\'n cael fersiynau wedi\'u storio. Rhybudd: bydd gwneud hyn yn arafu eich safle i bob defnyddiwr! Fel arall, gallwch hefyd ailosod y themâu wedi\'u storio eich hun o\'r dudalen Dewis Thema.';
$string['configthemelist'] = 'Gadewch hwn yn wag er mwyn caniatáu defnyddio unrhyw thema ddilys. Os hoffech leihau\'r ddewislen themâu, gallwch roi rhestr o enwau yma gyda chomas rhyngddynt (Peidiwch â defnyddio bylchau!).
Er enghraifft:  standard,orangewhite.';
$string['configtimezone'] = 'Gallwch osod y gylchfa amser ddiofyn yma. Dim ond y gylchfa amser DDIOFYN ar gyfer dangos dyddiadau fydd hon - gall pob defnyddiwr ddiystyru hyn drwy osod un eu hunain yn eu proffil. Bydd "Amser y gweinydd" yma yn gosod dewis diofyn Moodle yr un fath â gosodiad system gweithredu\'r gweinydd, ond bydd "Amser y gweinydd" yn y proffil defnyddiwr yn achosi i\'r defnyddiwr ddefnyddio\'r gosodiad cylchfa amser hwn yn ddiofyn. Bydd cronjobs sy\'n dibynnu ar amser o\'r dydd i redeg yn defnyddio\'r gylchfa amser hon.';
$string['configuseblogassociations'] = 'A ddylai defnyddwyr allu trefnu eu blog drwy gysylltu cofnodion gyda chyrsiau a modiwlau cyrsiau?';
$string['configuseexternalyui'] = 'Yn lle defnyddio ffeiliau lleol, defnyddiwch y ffeiliau ar-lein sydd ar gael ar weinyddion Yahoo. RHYBUDD: Rhaid cael cysylltiad â\'r we i wneud hyn, neu ni fydd AJAX yn gweithio ar eich safle.';
$string['configuserquota'] = 'Nifer fwyaf y beitiau y gall defnyddiwr eu storio yn ei ardal ar gyfer ffeiliau preifat. {$a->bytes} beit == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Os yw wedi\'i alluogi bydd enw byr y safle\'n cael ei ddefnyddio ar gyfer cwgn tudalennau\'r safle yn y llywio yn hytrach na\'r llinyn \'Tudalennau safle\'';
$string['configusetags'] = 'A ddylid galluogi gweithredoedd tagiau ar draws yr holl safle?';
$string['configvariables'] = 'Newidynnau';
$string['configverifychangedemail'] = 'Mae hyn yn galluogi dilysu cyfeiriadau e-bost a newidiwyd drwy ddefnyddio gosodiadau parthau e-bost sy\'n cael eu caniatáu a\'u gwrthod. Os nad yw\'r gosodiad hwn ar waith, dim ond wrth greu defnyddwyr newydd bydd parthau\'n cael eu gwirio.';
$string['configvisiblecourses'] = 'Dangos cyrsiau mewn categorïau cudd fel arfer';
$string['configwarning'] = 'Byddwch yn ofalus wrth newid y gosodiadau hyn - gallai gwerthoedd rhyfedd achosi problemau.';
$string['configyuicomboloading'] = 'Mae\'r dewis hwn yn rhoi ar waith y ffordd orau o lwytho ffeiliau cyfun ar gyfer llyfrgelloedd YUI. Dylech ddewis defnyddio\'r gosodiad hwn ar safleoedd cynhyrchu am resymau perfformiad.';
$string['confirmation'] = 'Cadarnhad';
$string['confirmdeletecomments'] = 'Rydych chi ar fin dileu sylwadau, ydych chi\'n siŵr?';
$string['confirmed'] = 'Wedi cadarnhau';
$string['convertformat'] = '<i>trosi</i> fformat allbwn';
$string['cookiehttponly'] = 'Dim ond cwcis http';
$string['cookiesecure'] = 'Cwcis diogel yn unig';
$string['country'] = 'Gwlad ddiofyn';
$string['coursecontact'] = 'Rheolwyr cwrs';
$string['coursecontact_desc'] = 'Mae\'r gosodiad hwn yn gadael i chi reoli pwy sy\'n ymddangos ar y disgrifiad cwrs. Bydd angen i ddefnyddwyr gael o leiaf un o\'r swyddogaethau hyn mewn cwrs i gael eu dangos ar ddisgrifiad cwrs y cwrs hwnnw.';
$string['courselistshortnames'] = 'Dangos enwau cyrsiau estynedig';
$string['courselistshortnames_desc'] = 'Wrth ddangos rhestrau o gyrsiau, neu wrth gyfeirio at gyrsiau ar sgriniau gweinyddu, dangos enw byr y cwrs yn ogystal a\'r enw llawn. Yn wir, pan rydych yn rhoi\'r gosodiad hwn ar waith, mae\'r dangosydd yn defnyddio\'r llinyn iaith \'courseextendednamedisplay\', fel eich bod yn gallu newid beth sy\'n cael ei ddangos trwy ddefnyddio Addasu iaith.';
$string['coursemgmt'] = 'Ychwanegu/golygu cyrsiau';
$string['courseoverview'] = 'Trosolwg cwrs';
$string['courserequestnotify'] = 'Hysbysiad cais am gwrs';
$string['courserequestnotifyemail'] = 'Mae\'r defnyddiwr {$a->user} wedi gwneud cais am gwrs newydd yn {$a->link}';
$string['courserequests'] = 'Ceisiadau cwrs';
$string['courserequestspending'] = 'Ceisiadau cwrs sydd yn yr arfaeth';
$string['courses'] = 'Cyrsiau';
$string['coursesperpage'] = 'Cyrsiau i bob tudalen';
$string['courseswithsummarieslimit'] = 'Cyrsiau gyda chyfyngiadau crynodebau';
$string['creatornewroleid'] = 'Swyddogaeth crewyr mewn cyrsiau newydd';
$string['creatornewroleid_help'] = 'Os nad oes gan y defnyddiwr eisoes hawl i reoli\'r cwrs newydd, caiff y defnyddiwr ei gofrestru\'n awtomatig gan ddefnyddio\'r swyddogaeth hon.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Gweithredu cron drwy\'r llinell gorchymyn yn unig';
$string['cronerrorclionly'] = 'Yn anffodus, mae\'r gweinyddwr wedi rhwystro mynediad gwe i\'r dudalen hon.';
$string['cronerrorpassword'] = 'Yn anffodus, nid ydych wedi rhoi cyfrinair dilys i gael mynediad i\'r dudalen hon';
$string['cron_help'] = 'Mae\'r sgript cynnal cron.php yn helpu rhai o fodiwlau Moodle i gyflawni tasgau yn ôl amserlen, megis anfon copïau o negeseuon newydd sy\'n cael eu postio ar fforwm. Rhaid cael mecanwaith i redeg y sgript yn rheolaidd e.e. bob 5 munud.';
$string['cronremotepassword'] = 'Cyfrinair cron ar gyfer mynediad o bell';
$string['cronwarning'] = 'Nid yw <a href="cron.php">sgript cynnal a chadw cron.php</a> wedi cael ei redeg ers o leiaf 24 awr.';
$string['ctyperecommended'] = 'Rydym yn argymell yn gryf eich bod yn gosod yr estyniad PHP ctype dewisol er mwyn gwella perfformiad y safle, yn enwedig os yw eich safle\'n delio ag ieithoedd nad ydynt yn rhai Lladin.';
$string['ctyperequired'] = 'Bellach, rhaid i Moodle gael yr estyniad PHP ctype er mwyn gwella perfformiad y safle ac i sicrhau cydnawsedd â mwy nag un iaith.';
$string['curlcache'] = 'Storfa cURL TTL';
$string['curlrecommended'] = 'Argymhellir yn gryf eich bod yn gosod y llyfrgell Curl ddewisol fel bo Rhwydweithio Moodle yn gallu gweithio.';
$string['curlrequired'] = 'Bellach, rhaid i Moodle gael yr estyniad cURL PHP er mwyn cyfathrebu â chronfeydd Moodle.';
$string['curltimeoutkbitrate'] = 'Y gyfradd didau i\'w defnyddio wrth gyfrifo amser dod i ben cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Caiff y gosodiad hwn ei ddefnyddio i gyfrifo amser dod i ben priodol mewn ceisiadau cURL mawr. Fel rhan o\'r cyfrifiad hwn, gwneir cais HTTP HEAD i bennu maint y cynnwys. Bydd gosod hwn ar 0 yn golygu na fydd y cais hwn yn cael ei wneud.';
$string['currenttheme'] = 'Thema gyfredol';
$string['customcheck'] = 'Archwiliadau eraill';
$string['custommenu'] = 'Dewislen bersonol';
$string['custommenuitems'] = 'Eitemau dewislen bersonol';
$string['datarootsecurityerror'] = '<p><strong>RHYBUDD DIOGELWCH!</strong></p><p>Mae eich cyfeiriadur gwraidd data yn y lle anghywir ac mae\'n agored i\'r we. Mae hyn yn golygu bod eich ffeiliau preifat yn agored i unrhyw un yn y byd, a gallai cracwyr ddefnyddio rhai ohonynt i gael mynediad gweinyddwr i\'ch safle heb awdurdod!</p>
<p><em>Rhaid</em> i chi symud y cyfeiriadur gwraidd data ({$a}) i leoliad newydd nad yw yn eich cyfeiriadur gwe cyhoeddus a diweddaru\'r gosodiad <code>$CFG->dataroot</code> yn eich config.php.</p>';
$string['datarootsecuritywarning'] = 'Efallai nad yw ffurfweddiad eich safle\'n ddiogel. Sicrhewch nad oes modd mynd i\'ch cyfeiriadur dataroot ({$a}) yn uniongyrchol oddi ar y we.';
$string['dbmigrate'] = 'Mudo cronfa ddata Moodle';
$string['dbmigrateconnecerror'] = 'Doedd dim modd cysylltu â\'r gronfa ddata a bennwyd.';
$string['dbmigrateencodingerror'] = 'Mae\'r gronfa ddata a bennwyd yn defnyddio\'r amgodio {$a} yn hytrach na\'r amgodio gofynnol UNICODE/UTF8.<br />Dewiswch un arall.';
$string['dbmigratepostgres'] = 'Ymddengys eich bod yn defnyddio PostgreSQL fel gweinydd y gronfa ddata. I fwrw ymlaen â\'r broses mudo, bydd angen i chi greu cronfa ddata newydd eich hun gydag amgodio "UNICODE"(PostgreSQL 7) neu "UTF8" (PostgreSQL 8) i storio\'r data a fudwyd. Rhowch eich gosodiadau cysylltu cronfa ddata newydd isod i fwrw ymlaen:';
$string['dbmigratewarning'] = 'Sicrhewch eich bod wedi creu copi wrth gefn o\'ch cronfa ddata Moodle cyn cychwyn y weithdrefn hon. Os nad ydych yn siŵr sut i wneud hynny, cysylltwch â gweinyddwr eich system. Caiff eich safle Moodle ei roi mewn modd cynnal a chadw wedi i chi gychwyn y broses mudo';
$string['dbmigratewarning2'] = '<b>Rhybudd: Rydych chi ar fin cychwyn y broses mudo cronfa ddata. Sicrhewch fod gennych gopi wrth gefn o\'ch holl gronfa ddata Moodle.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Mae\'r gronfa ddata hon wedi mudo i gronfa ddata UTF8 newydd, ond cafodd ei hanghymeradwyo. Golygwch eich config.php a defnyddio\'r gronfa ddata newydd ar gyfer y Moodle hwn.</font>';
$string['dbmigrationdupfailed'] = 'Mae proses dyblygu\'r gronfa ddata wedi methu gyda\'r gwall posibl:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Defnyddio\'r gronfa ddata ar gyfer gwybodaeth sesiwn';
$string['debug'] = 'Dadfygio negeseuon';
$string['debugall'] = 'POB UN: Dangos pob neges dadfygio PHP resymol';
$string['debugdeveloper'] = 'DATBLYGWR: mwy o negeseuon dadfygio Moodle i ddatblygwyr';
$string['debugdisplay'] = 'Dangos negeseuon dadfygio';
$string['debugging'] = 'Dadfygio';
$string['debugminimal'] = 'LLEIAF: dangos camgymeriadau di-droi\'n-ôl yn unig';
$string['debugnone'] = 'DIM: Peidio â dangos dim gwallau na rhybuddion';
$string['debugnormal'] = 'NORMAL: Dangos gwallau, rhybuddion a hysbysiadau';
$string['debugpageinfo'] = 'Dangos gwybodaeth am y dudalen';
$string['debugsmtp'] = 'Dadfygio anfon e-bost';
$string['debugstringids'] = 'Dangos tarddiad y llinynnau iaith';
$string['debugstringids_desc'] = 'Mae’r opsiwn hwn wedi’i greu i helpu cyfieithwyr. Pan fydd yr opsiwn hwn wedi’i alluogi, ychwanegwch y llinynnau paramedr=1 at gais URL a bydd yn dangos y ffeil iaith ac id y llinyn wrth ymyl pob llinyn sy\'n cael ei allbynnu.';
$string['debugvalidators'] = 'Dangos dolenni dilysydd';
$string['defaultcity'] = 'Dinas ddiofyn';
$string['defaultcity_help'] = 'Y ddinas hon fydd y ddinas ddiofyn wrth greu cyfrifon defnyddwyr newydd.';
$string['defaultformatnotset'] = 'Doedd dim modd pennu fformat cwrs diofyn. Edrychwch ar osodiadau\'r safle.';
$string['defaulthomepage'] = 'Hafan ddiofyn ar gyfer defnyddwyr';
$string['defaultrequestcategory'] = 'Categori diofyn ar gyfer ceisiadau cyrsiau';
$string['defaultsettinginfo'] = 'Diofyn: {$a}';
$string['defaultuserroleid'] = 'Swyddogaeth ddiofyn pob defnyddiwr';
$string['deleteincompleteusers'] = 'Dileu defnyddwyr anghyflawn ar ôl';
$string['deleteunconfirmed'] = 'Dileu defnyddwyr sydd heb eu cadarnhau ar ôl';
$string['deleteuser'] = 'Dileu defnyddiwr';
$string['density'] = 'Dwysedd';
$string['denyemailaddresses'] = 'Parthau e-bost a wrthodir';
$string['development'] = 'Datblygu';
$string['devicedetectregex'] = 'Mynegiannau rheolaidd i ganfod dyfeisiau';
$string['devicedetectregex_desc'] = '<p>Yn ddiofyn, gall Moodle ganfod dyfeisiau diofyn (cyfrifiaduron bwrdd gwaith, gliniaduron, ayb), symudol (ffonau a dyfeisiau llaw), tabled (iPads, tabled Android) a hen rai (defnyddwyr Internet Explorer 6). Gellir defnyddio\'r dewisydd themâu i osod themâu ar wahân i bob un o\'r rhain. Mae\'r gosodiad hwn yn caniatáu mynegiant rheolaidd sy\'n galluogi canfod mathau ychwanegol o ddyfeisiau (sy\'n cael blaenoriaeth dros y mathau diofyn).</p> <p>Er enghraifft, gallech ddefnyddio\'r mynegiant rheolaidd \'/(MIDP-1.0|Maemo|Windows CE)/\' i ganfod rhai ffonau cyffredin drwy roi\'r gwerth \'ffonaucyffredin\'. Mae hyn yn ychwanegu \'ffonaucyffredin\' at y dewisydd themâu a fyddai\'n eich galluogi i ychwanegu themau i\'w defnyddio ar y dyfeisiau hyn. Byddai ffonau eraill yn dal i ddefnyddio\'r thema a ddewiswyd ar gyfer y ddyfais symudol honno.<p>';
$string['devicedetectregexexpression'] = 'Mynegiant rheolaidd';
$string['devicedetectregexvalue'] = 'Gwerth a ddychwelir';
$string['devicetype'] = 'Math o ddyfais';
$string['disableuserimages'] = 'Analluogi lluniau proffil defnyddwyr';
$string['displayerrorswarning'] = 'Nid ydym yn argymell galluogi\'r gosodiad PHP <em>display_errors</em> ar safleoedd cynhyrchu oherwydd gallai rhai negeseuon gwall ddatgelu gwybodaeth sensitif am eich gweinydd.';
$string['displayloginfailures'] = 'Dangos methiannau mewngofnodi i';
$string['dndallowtextandlinks'] = 'Lanlwythiad llusgo a gollwng testun/dolenni';
$string['docroot'] = 'Gwreiddyn dogfen Dogfennau Moodle';
$string['doctonewwindow'] = 'Agor mewn ffenestr newydd';
$string['download'] = 'Llwytho i lawr';
$string['edithelpdocs'] = 'Golygu dogfennau help';
$string['editingnoncorelangfile'] = 'Rydych chi\'n ceisio addasu cyfieithiad o ategyn/modiwl ychwanegyn. Gallwch gadw cyfieithiad o fodiwlau 3ydd parti yn eich ffolder _leol yn unig. Efallai y dylech symud y ffeil gyda\'r cyfieithiad i\'r cyfeiriadau iaith modiwl a/neu ei hanfon i\'r sawl sy\'n cynnal y modiwl ychwanegyn.';
$string['editlang'] = '<b>Golygu</b>';
$string['editorbackgroundcolor'] = 'Lliw cefndir';
$string['editordictionary'] = 'Geiriadur y golygydd';
$string['editorfontfamily'] = 'Teulu ffont';
$string['editorfontlist'] = 'Rhestr ffont';
$string['editorfontsize'] = 'Maint ffont';
$string['editorhidebuttons'] = 'Botymau cudd';
$string['editorkillword'] = 'Hidlydd fformat Word';
$string['editorspelling'] = 'Offeryn sillafu y golygydd';
$string['editorspellinghelp'] = 'Galluogi neu analluogi gwirio sillafu. Pan fydd wedi\'i alluogi, rhaid gosod <strong>aspell</strong> ar y gweinydd.';
$string['editstrings'] = 'Golygu geiriau neu frawddegau';
$string['emailchangeconfirmation'] = 'Cadarnhau newid e-bost';
$string['emoticonalt'] = 'Testun arall';
$string['emoticoncomponent'] = 'Cydran y ddelwedd';
$string['emoticonimagename'] = 'Enw\'r ddelwedd';
$string['emoticons'] = 'Eiconau Emosiwn';
$string['emoticons_desc'] = 'Mae\'r ffurflen hon yn diffinio\'r eiconau emosiwn (neu wynebau hapus) sy\'n cael eu defnyddio ar eich safle. I dynnu rhes o\'r tabl, cadwch y ffurflen gyda gwerth gwag yn unrhyw un o\'r meysydd gofynnol. I gofrestru eicon emosiwn newydd, llenwch y meysydd yn y rhes wag olaf. I ailosod yr holl feysydd i\'r gwerthoedd diofyn, dilynwch y ddolen uchod.

* Testun (gofynnol) - Bydd delwedd eicon emosiwn yn ymddangos yn lle\'r testun. Rhaid iddo fod yn o leiaf dau nod.
* Enw\'r ddelwedd (gofynnol) - Enw ffeil y ddelwedd eicon emosiwn heb yr estyniad, yn perthyn i\'r ffolder pix cydrannol.
* Cydran y ddelwedd (gofynnol) - Y gydran sy\'n darparu\'r eicon.
* Testun arall (dewisol) - Dynodydd llinyn a chydran testun arall yr eicon emosiwn.';
$string['emoticonsreset'] = 'Ailosod y gosodiad eicon emosiynau i\'r gwerthoedd diofyn';
$string['emoticontext'] = 'Testun';
$string['emptysettingvalue'] = 'Gwag';
$string['enableajax'] = 'Galluogi AJAX';
$string['enableblogs'] = 'Galluogi blogiau';
$string['enablecalendarexport'] = 'Galluogi allgludo calendr';
$string['enablecomments'] = 'Galluogi sylwadau';
$string['enablecourserequests'] = 'Galluogi ceisiadau cyrsiau';
$string['enablecssoptimiser'] = 'Galluogi optimeiddiwr CSS';
$string['enablecssoptimiser_desc'] = 'Pan fydd CSS sydd wedi’i alluogi yn cael ei redeg trwy broses optimeiddio cyn cael ei storio. Mae’r optimeiddiwr yn prosesu’r CSS gan gael gwared o reolau ac arddulliau dyblyg, yn ogystal â chael gwared o fylchau gwyn ac ailfformatio. Nodwch nad ydy galluogi’r broses hon yr un pryd â modd dylunio thema yn dda i berfformiad ond bydd yn helpu dylunwyr thema i greu CSS wedi\'i optimeiddio.';
$string['enabled'] = 'Wedi\'i alluogi';
$string['enabledevicedetection'] = 'Galluogi canfod dyfais';
$string['enablegravatar'] = 'Galluogi Gravatar';
$string['enablegravatar_help'] = 'Pan fydd wedi’i alluogi bydd Moodle yn ceisio nôl llun proffil defnyddiwr o Gravatar os nad ydy’r defnyddiwr wedi llwytho delwedd i fyny.';
$string['enablegroupmembersonly'] = 'Galluogi aelodau grŵp yn unig';
$string['enablemobilewebservice'] = 'Galluogi\'r gwasanaeth gwe symudol';
$string['enablerecordcache'] = 'Galluogi Stôr Cofnodion';
$string['enablerssfeeds'] = 'Galluogi porthiannau RSS';
$string['enablesafebrowserintegration'] = 'Galluogi integreiddio\'r Porwr Arholiad Diogel';
$string['enablestats'] = 'Galluogi ystadegau';
$string['enabletgzbackups'] = 'Galluogi fformat copi wrth gefn newydd';
$string['enabletgzbackups_desc'] = 'Os galluogir, bydd copïau wrth gefn yn cael eu creu mewn fformat cywasgu newydd ar gyfer ffeiliau .mbz (wedi\'u storio\'n fewnol fel ffeil .tar.gz). Bydd hyn yn tynnu cyfyngiad maint y copi wrth gefn 4GB ac fe allai wella\'r perfformiad. Mae adfer yn cefnogi\'r ddau fformat a dylai\'r gwahaniaeth fod yn dryloyw i ddefnyddwyr.';
$string['enabletgzbackups_nozlib'] = 'Nid yw\'r estyniad PHP ‘zlib’ ar gael. Mae\'r fformat copi wrth gefn newydd yn dibynnu ar yr estyniad hwn a bydd wedi ei analluogi nes y bydd zlib wedi\'i osod a\'i alluogi.';
$string['enabletrusttext'] = 'Galluogi Cynnwys Cymeradwy';
$string['enablewebservices'] = 'Galluogi gwasanaethau gwe';
$string['enablewsdocumentation'] = 'Dogfennaeth gwasanaethau gwe';
$string['enrolinstancedefaults'] = 'Gosodiadau diofyn yr enghreifftiau cofrestru';
$string['enrolinstancedefaults_desc'] = 'Gosodiadau cofrestru diofyn mewn cyrsiau newydd.';
$string['enrolmultipleusers'] = 'Cofrestru\'r defnyddwyr';
$string['environment'] = 'Amgylchedd';
$string['environmenterrortodo'] = 'Rhaid datrys yr holl broblemau amgylcheddol (gwallau) uchod cyn parhau i osod y fersiwn hwn o Moodle!';
$string['environmenterrorupgrade'] = 'Rhybudd: dylech ddatrys yr holl broblemau amgylcheddol (gwallau) uchod cyn parhau i osod y fersiwn hwn o Moodle! Gallai uwchraddio heb drwsio\'r gofynion hyn achosi problemau megis colli data. A ydych chi\'n siŵr eich bod am fwrw ymlaen â\'r uwchraddio?';
$string['environmentmustfixsetting'] = 'Rhaid newid y gosodiad PHP.';
$string['environmentok'] = 'Mae amgylchedd eich gweinydd yn bodloni\'r holl ofynion sylfaenol.';
$string['environmentrecommendcustomcheck'] = 'os yw\'r prawf hwn yn methu, mae\'n dangos problem bosibl';
$string['environmentrecommendinstall'] = 'wedi\'i argymell i\'w osod/ei alluogi';
$string['environmentrecommendversion'] = 'argymhellir fersiwn {$a->needed} ac rydych yn defnyddio {$a->current}';
$string['environmentrequirecustomcheck'] = 'rhaid i\'r prawf hwn basio';
$string['environmentrequireinstall'] = 'angen ei osod/ei alluogi.';
$string['environmentrequireversion'] = 'Mae angen fersiwn {$a->needed} ac rydych yn defnyddio {$a->current}';
$string['environmentsettingok'] = 'wedi canfod y gosodiad a argymhellir';
$string['environmentshouldfixsetting'] = 'Dylid newid y gosodiad PHP.';
$string['environmentxmlerror'] = 'Gwall wrth ddarllen data amgylchedd ({$a->error_code})';
$string['errordeletingconfig'] = 'Roedd gwall wrth ddileu\'r cofnodion ffurfweddu ar gyfer ategyn \'{$a}\'.';
$string['errorsetting'] = 'Wedi methu cadw\'r gosodiad:';
$string['errorwithsettings'] = 'Heb newid rhai gosodiadau oherwydd gwall:';
$string['everyonewhocan'] = 'Pawb sy\'n gallu \'{$a}\'';
$string['exceptions'] = 'eithriadau';
$string['execpathnotallowed'] = 'Mae gosod llwybrau gweithredadwy wedi\'i analluogi yn config.php';
$string['experimental'] = 'Arbrofol';
$string['experimentalsettings'] = 'Gosodiadau arbrofol';
$string['extendedusernamechars'] = 'Caniatáu nodau estynedig mewn enwau defnyddwyr';
$string['extramemorylimit'] = 'Terfyn cof PHP ychwanegol';
$string['fatalmagicquotesruntime'] = '<p>Wedi canfod gwall ffurfweddu difrifol, rhowch wybod i weinyddwr y gweinydd.</p><p> Mae\'n rhaid i\'r gweinyddwr newid y gosodiadau PHP i Moodle allu gweithio\'n iawn. Mae\'n rhaid gosod </p><p><code>magic_quotes_runtime</code> i <code>off</code>.</p><p>Rheolir y gosodiad hwn drwy olygu\'r <code>php.ini</code>, y ffurfweddiad Apache/IIS <br />neu\'r ffeil <code>.htaccess</code> ar y gweinydd.</p>';
$string['fatalsessionautostart'] = '<p>Wedi canfod gwall ffurfweddu difrifol, rhowch wybod i weinyddwr y gweinydd.</p><p> Mae\'n rhaid i\'r gweinyddwr newid y gosodiadau PHP i Moodle allu gweithio\'n iawn. Mae\'n rhaid gosod </p><p><code>session.auto_start</code> i <code>off</code>.</p><p>Rheolir y gosodiad hwn drwy olygu\'r <code>php.ini</code>, y ffurfweddiad Apache/IIS <br />neu\'r ffeil <code>.htaccess</code> ar y gweinydd.</p>';
$string['filecreated'] = 'Wedi creu ffeil newydd';
$string['filestoredin'] = 'Cadw ffeil yn y ffolder :';
$string['filestoredinhelp'] = 'Ble cedwir y ffeil';
$string['filterall'] = 'Hidlo pob llinyn';
$string['filtermatchoneperpage'] = 'Hidlo\'r hyn sy\'n cyfateb unwaith ar bob tudalen';
$string['filtermatchonepertext'] = 'Hidlo\'r hyn sy\'n cyfateb unwaith ym mhob bloc testun';
$string['filters'] = 'Hidlyddion';
$string['filtersettings'] = 'Gosodiadau hidlo';
$string['filtersettingsgeneral'] = 'Gosodiadau hidlo cyffredinol';
$string['filteruploadedfiles'] = 'Hidlo ffeiliau sydd wedi\'u llwytho i fyny';
$string['forcelogin'] = 'Gorfodi defnyddwyr i fewngofnodi';
$string['forceloginforprofileimage'] = 'Gorfodi defnyddwyr i fewngofnodi i weld lluniau defnyddwyr';
$string['forceloginforprofileimage_help'] = 'Os yw hwn wedi\'i alluogi, rhaid i ddefnyddwyr fewngofnodi er mwyn gweld lluniau proffil defnyddwyr a bydd llun diofyn y defnyddiwr yn cael ei ddefnyddio ym mhob e-bost hysbysu.';
$string['forceloginforprofiles'] = 'Gorfodi defnyddwyr i fewngofnodi ar gyfer proffiliau';
$string['forcetimezone'] = 'Gorfodi\'r gylchfa amser ddiofyn';
$string['formatuninstallwithcourses'] = 'Mae {$a->count} cwrs yn defnyddio {$a->format}. Bydd eu fformat yn cael ei newid i {$a->defaultformat} (fformat diofyn y safle hwn). Gall ychydig o ddata fformat penodol gael ei golli. Ydych chi\'n siŵr eich bod am fwrw ymlaen?';
$string['frontpage'] = 'Tudalen flaen';
$string['frontpagebackup'] = 'Copi wrth gefn o\'r dudalen flaen';
$string['frontpagedefaultrole'] = 'Swyddogaeth tudalen flaen ddiofyn';
$string['frontpagefilters'] = 'Hidlyddion tudalen flaen';
$string['frontpageloggedin'] = 'Eitemau\'r dudalen flaen (ar ôl mewngofnodi)';
$string['frontpageoverrides'] = 'Diystyru caniatâd tudalen flaen';
$string['frontpagequestions'] = 'Cwestiynau tudalen flaen';
$string['frontpagerestore'] = 'Adfer tudalen flaen';
$string['frontpageroles'] = 'Swyddogaethau tudalen flaen';
$string['frontpagesettings'] = 'Gosodiadau tudalen flaen';
$string['fullnamedisplay'] = 'Fformat enw llawn';
$string['fullnamedisplayprivate'] = 'Fformat enw llawn - preifat';
$string['gdrecommended'] = 'Defnyddir yr estyniad GD i drosi delweddau. Ni fydd rhai nodweddion, megis delweddau proffil defnyddwyr, ar gael os yw ar goll.';
$string['gdrequired'] = 'Mae Moodle nawr yn gofyn i chi gael estyniad GD ar gyfer trosi delweddau.';
$string['generalsettings'] = 'Gosodiadau cyffredinol';
$string['geoipfile'] = 'Ffeil ddata GeoIP city ';
$string['getremoteaddrconf'] = 'Ffynhonnell cyfeiriad IP y sawl sydd wedi mewngofnodi';
$string['globalswarning'] = '<p><strong>RHYBUDD DIOGELWCH!</strong></p><p> I weithredu\'n iawn, mae ar Moodle angen <br />i chi wneud newidiadau penodol i\'ch gosodiadau PHP cyfredol.</p><p>Mae\'n <em>rhaid</em> gosod <code>register_globals=off</code>.</p><p>Rheolir y gosodiad hwn drwy olygu eich <code>php.ini</code>, eich ffurfweddiad Apache/IIS <br /> neu eich ffeil <code>.htaccess</code>.</p>';
$string['googlemapkey3'] = 'Bysell API V3 Google Maps';
$string['googlemapkey3_help'] = 'Mae angen i chi roi bysell arbennig i ddefnyddio Google Maps ar gyfer patrwm chwilio am gyfeiriad IP. Mae modd i chi gael y fysell am ddim o <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Mynd i\'r llinyn coll cyntaf';
$string['gradebook'] = 'Llyfr graddau';
$string['gradebookroles'] = 'Graddau\'r swyddogaethau';
$string['gradeexport'] = 'Y prif ffyrdd o allgludo';
$string['gravatardefaulturl'] = 'URL delwedd ddiofyn Gravatar';
$string['gravatardefaulturl_help'] = 'Mae angen i Gravatar gael delwedd ddiofyn i’w ddangos os nad yw’n gallu dod o hyd i lun ar gyfer defnyddiwr penodol. Darparwch URL llawn ar gyfer delwedd. Os yw\'r gosodiad hwn yn wag, bydd Moodle yn ceisio defnyddio y ddelwedd diofyn mwyaf addas ar gyfer y dudalen rydych yn edrych arni. Nodwch hefyd fod gan Gravatar nifer o godau y gellir eu defnyddio i <a href="https://en.gravatar.com/site/implement/images/#default-image">gynhyrchu delweddau diofyn</a>.';
$string['groupenrolmentkeypolicy'] = 'Polisi allwedd cofrestru grŵp';
$string['groupenrolmentkeypolicy_desc'] = 'Mae hyn yn gwneud i Moodle wirio allweddi cofrestru grŵp yn erbyn polisi cyfrinair dilys.';
$string['guestroleid'] = 'Swyddogaeth gwestai';
$string['guestroleid_help'] = 'Mae\'r swyddogaeth hon yn cael ei neilltuo\'n awtomatig i\'r gwestai. Mae hefyd yn cael ei neilltuo dros dro i ddefnyddwyr sydd heb gofrestru sy\'n mynd i mewn i\'r cwrs gydag ategyn cofrestru gwestai.';
$string['helpadminseesall'] = 'A yw gweinyddwyr yn gweld yr holl ddigwyddiadau yn y calendr neu ddim ond y rhai sy\'n berthnasol iddynt?';
$string['helpcalendarcustomexport'] = 'Galluogi’r dewis allgludo ystod dyddiau personol yn allgludo calendr. Mae’n rhaid i  Allgludo calendr fod wedi\'i alluogi ymlaen llaw er mwyn i hyn fod yn effeithiol.';
$string['helpexportlookahead'] = 'Faint o ddiwrnodau yn y dyfodol mae’r calendr yn edrych am ddigwyddiadau yn ystod allgludo y dewis allgludo personol?';
$string['helpexportlookback'] = 'Faint o ddiwrnodau yn y dyfodol mae’r calendr yn edrych am ddigwyddiadau yn ystod allgludo y dewis allgludo personol?';
$string['helpforcetimezone'] = 'Gallwch ganiatáu i ddefnyddwyr ddewis eu cylchfa amser eu hunain, neu orfodi cylchfa amser ar gyfer pawb.';
$string['helpshowicalsource'] = 'Os yw wedi’i alluogi, bydd enw’r tanysgrifiad a’r ddolen yn dangos ar gyfer digwyddiadau sydd wedi’u mewngludo gan iCal.';
$string['helpsitemaintenance'] = 'Ar gyfer uwchraddio a gwaith arall';
$string['helpstartofweek'] = 'Pa ddydd sy\'n dechrau\'r wythnos yn y calendr?';
$string['helpupcominglookahead'] = 'Sawl diwrnod i\'r dyfodol fydd y calendr yn chwilio\'n ddiofyn am ddigwyddiadau sydd ar y gweill?';
$string['helpupcomingmaxevents'] = 'Faint o weithgareddau sydd ar y gweill (nifer fwyaf) gaiff eu dangos i ddefnyddwyr yn ddiofyn?';
$string['helpweekenddays'] = 'Pa ddyddiau\'r wythnos sy\'n cael eu trin fel "penwythnos" ac sy\'n cael eu dangos gyda lliw gwahanol?';
$string['hiddenuserfields'] = 'Cuddio meysydd defnyddiwr';
$string['hidefromall'] = 'Cuddio oddi wrth pob defnyddiwr';
$string['hidefromnone'] = 'Cuddio oddi wrth neb';
$string['hidefromstudents'] = 'Cuddio oddi wrth fyfyrwyr';
$string['htmleditor'] = 'Golygydd HTML';
$string['htmleditorsettings'] = 'Gosodiadau\'r golygydd HTML';
$string['htmlsettings'] = 'Gosodiadau HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Diogelwch HTTP';
$string['hubs'] = 'Bothau';
$string['iconvrecommended'] = 'Argymhellir yn gryf eich bod yn gosod y llyfrgell ICONV ddewisol er mwyn gwella perfformiad y safle, yn enwedig os gall eich safle ddelio ag ieithoedd heblaw rhai Lladin.';
$string['iconvrequired'] = 'Mae angen gosod yr estyniad ICONV.';
$string['ignore'] = 'Anwybyddu';
$string['includemoduleuserdata'] = 'Cynnwys data defnyddiwr modiwl';
$string['incompatibleblocks'] = 'Blociau anghydnaws';
$string['installhijacked'] = 'Mae\'n rhaid i\'r gosodiad gael ei orffen o\'r cyfeiriad IP gwreiddiol, mae\'n ddrwg gen i.';
$string['installsessionerror'] = 'Heb lwyddo i ymgychwyn sesiwn PHP, cadarnhewch fod eich porwr yn derbyn cwcis.';
$string['intlrecommended'] = 'Mae\'r estyniad Intl yn cael ei ddefnyddio i wella cymorth rhyngwladoli, megis trefnu ymwybyddiaeth locale.';
$string['invalidsection'] = 'Adran annilys.';
$string['invaliduserchangeme'] = 'Mae\'r enw defnyddiwr "changeme" wedi\'i gadw -- chewch chi ddim ei ddefnyddio i greu cyfrif.';
$string['ipblocked'] = 'Nid yw\'r safle hwn ar gael ar hyn o bryd.';
$string['ipblocker'] = 'Rhwystrwr IP';
$string['ipblockersyntax'] = 'Rhowch bob cofnod ar un llinell. Mae cofnodion dilys naill ai\'n gyfeiriadau IP llawn (megis <b>192.168.10.1</b>) sy\'n cyfateb i un gwesteiwr; neu\'n gyfeiriad rhannol (megis <b>192.168.</b>) sy\'n cyfateb i unrhyw gyfeiriad sy\'n cychwyn gyda\'r rhifau hynny; neu\'n nodiannau CIDR (megis <b>231.54.211.0/20</b>); neu\'n amrediad o gyfeiriadau IP (megis <b>231.3.56.10-20</b>) lle mae\'r amrediad yn berthnasol i ran olaf y cyfeiriad. Nid oes modd delio ag enwau parth testun (megis \'enghraifft.com\'). Anwybyddir llinellau gwag.';
$string['iplookup'] = 'Edrych am gyfeiriad IP';
$string['iplookupgeoplugin'] = 'Mae gwasanaeth <a href="http://www.geoplugin.com">geoPlugin</a> yn cael ei ddefnyddio ar hyn o bryd i chwilio am wybodaeth ddaearyddol. I gael canlyniadau mwy cywir rydym yn argymell eich bod yn gosod copi lleol o gronfa ddata MaxMind GeoLite.';
$string['iplookupinfo'] = 'Yn ddiofyn, mae Moodle yn defnyddio gweinydd NetGeo (Cronfa Ddata Ddaearyddol y Rhyngrwyd), sef gweinydd ar-lein di-dâl, i edrych am leoliadau cyfeiriadau IP. Yn anffodus, nid yw\'r gronfa ddata hon yn cael ei chynnal erbyn hyn, ac mae\'n bosibl y bydd yn dychwelyd data <em>hollol anghywir</em>. Argymhellir eich bod yn gosod copi lleol o\'r gronfa ddata GeoLite City ddi-dâl gan MaxMind.<br />
Mae lleoliad y cyfeiriad IP yn cael ei ddangos ar fap syml neu gan ddefnyddio Google Maps. Cofiwch fod angen i chi gael cyfrif Google a gwneud cais am allwedd API Google Maps er mwyn galluogi mapiau rhyngweithiol.';
$string['iplookupmaxmindnote'] = 'Mae\'r cynnyrch hwn yn cynnwys data GeoLite a grëwyd gan MaxMind, sydd ar gael yn <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Gwahaniaethu rhwng llythrennau mawr a bach yn y tag';
$string['lang'] = 'Iaith ddiofyn';
$string['langcache'] = 'Dewislen Storio iaith';
$string['langcache_desc'] = 'Storio\'r ddewislen iaith. Os yw wedi\'i alluogi, caiff y rhestr o gyfieithiadau sydd ar gael ei storio. Bydd y stôr yn cael ei adnewyddu\'n awtomatig pan fyddwch yn gosod neu\'n dileu pecyn iaith drwy ddefnyddio\'r offeryn rheoli pecynnau iaith parod. Os ydych chi\'n gosod pecyn iaith newydd eich hun, mae\'n rhaid i chi ddefnyddio\'r nodwedd Clirio pob stôr er mwyn adnewyddu\'r rhestr a storiwyd.';
$string['langlist'] = 'Ieithoedd ar y ddewislen iaith';
$string['langmenu'] = 'Dangos dewislen iaith';
$string['langpackwillbeupdated'] = 'NODYN: Bydd Moodle yn ceisio llwytho diweddariadau i lawr ar gyfer eich pecynnau iaith yn ystod y broses uwchraddio.';
$string['langstringcache'] = 'Storio\'r holl linynnau iaith';
$string['languagesettings'] = 'Gosodiadau iaith';
$string['latexpreamble'] = 'Rhagymadrodd LaTeX';
$string['latexsettings'] = 'Gosodiadau Rendrydd LaTeX';
$string['latinexcelexport'] = 'Amgodio Excel';
$string['legacyfilesaddallowed'] = 'Caniatáu ychwanegu at hen ffeiliau';
$string['legacyfilesaddallowed_help'] = 'Os oes gan gwrs hen ffeiliau cwrs, caniatewch i ffeiliau a ffolderi gael eu hychwanegu atynt.';
$string['legacyfilesinnewcourses'] = 'Hen ffeiliau cwrs mewn cyrsiau newydd';
$string['legacyfilesinnewcourses_help'] = 'Yn ddiofyn, dim ond mewn cyrsiau sydd wedi\'u huwchraddio y mae hen ffeiliau cwrs ar gael. Dylech nodi nad yw rhai nodweddion, megis creu copi wrth gefn/adfer fel gweithgaredd unigol, yn gydnaws â\'r gosodiad hwn.';
$string['licensesettings'] = 'Gosodiadau\'r drwydded';
$string['linkadmincategories'] = 'Cysylltu categorïau gweinyddol';
$string['linkadmincategories_help'] = 'Os bydd wedi’i alluogi bydd categorïau gosod gweinyddol yn dangos fel dolenni yn y bar llywio ac yn arwain at dudalen categori gweinyddol.';
$string['loading'] = 'Wrthi\'n llwytho';
$string['localetext'] = 'Locale y safle cyfan';
$string['localstringcustomization'] = 'Addasu llinynnau lleol';
$string['location'] = 'Lleoliad';
$string['locationsettings'] = 'Gosodiadau lleoliad';
$string['locked'] = 'wedi cloi';
$string['lockoutduration'] = 'Hyd cloi’r cyfrif';
$string['lockoutduration_desc'] = 'Bydd cyfrif sydd wedi\'i gloi yn cael ei ddatgloi\'n awtomatig yn dilyn y cyfnod hwn o amser.';
$string['lockoutemailbody'] = 'Cafodd eich cyfrif gyda’r enw defnyddiwr {$a->username} ar weinydd \'{$a->sitename}\' ei gloi yn dilyn sawl ymgais aflwyddiannus i fewngofnodi. I ddatgloi’r cyfrif ar unwaith ewch i’r cyfeiriad dilynol {$a->link} Yn y rhan fwyaf o raglenni post, dylai hwn ddangos fel dolen las y mae modd ei glicio. Os nad yw hynny’n gweithio, yna copïwch a gludwch y cyfeiriad i’r llinell cyfeiriad ar dop ffenestr eich porwr gwe. Os ydych angen help, holwch weinyddwr y safle, {$a->admin}';
$string['lockoutemailsubject'] = 'Cafodd eich cyfrif ar {$a} ei gloi';
$string['lockouterrorunlock'] = 'Gwybodaeth datgloi cyfrif anghywir wedi\'i roi.';
$string['lockoutthreshold'] = 'Trothwy cloi\'r cyfrif';
$string['lockoutthreshold_desc'] = 'Dewiswch y nifer o gynigion mewngofnodi aflwyddiannus sy’n achosi i\'r cyfrif gael ei gloi. Mae modd i’r nodwedd hon gael ei chamddefnyddio er mwyn atal ymosodiadau ar y gwasanaeth.';
$string['lockoutwindow'] = 'Ffenestr arsylwi cloi cyfrif';
$string['lockoutwindow_desc'] = 'Yr amser arsylwi ar gyfer trothwy cloi’r cyfrif, os nad oes unrhyw gynigion aflwyddiannus bydd y rhifydd trothwy yn cael ei ailosod ar ôl yr amser hwn.';
$string['log'] = 'Logiau';
$string['logguests'] = 'Log mynediad gwestai';
$string['logguests_help'] = 'Mae\'r gosodiad hwn yn galluogi cofnodi\'r camau a gymerwyd gan westai ac nid defnyddwyr sydd wedi mewngofnodi. Efallai bydd safleoedd proffil uchel am analluogi\'r log hwn am resymau perfformiad. Rydym yn argymell gadael y gosodiad hwn ymlaen ar safleoedd cynhyrchu.';
$string['loginhttps'] = 'Defnyddio HTTPS ar gyfer mewngofnodi';
$string['loginpageautofocus'] = 'Ffocysu ffurf y dudalen mewngofnodi yn awtomatig';
$string['loginpageautofocus_help'] = 'Bydd galluogi\'r dewis hwn yn gwneud y dudalen fewngofnodi\'n haws ei defnyddio. Ond gallai ffocysu meysydd yn awtomatig effeithio ar fynediad hwylus.';
$string['loginpasswordautocomplete'] = 'Atal awtogwblhau\'r cyfrinair ar y ffurflen mewngofnodi';
$string['loginpasswordautocomplete_help'] = 'Bydd diffodd hwn yn galluogi defnyddwyr i gadw cyfrinair eu cyfrif yn eu porwr. Bydd galluogi\'r gosodiad hwn yn golygu na fydd eich safle\'n dilyn rheolau dilysu XHTML llym.';
$string['loglifetime'] = 'Cadw logiau am';
$string['longtimewarning'] = '<b>Cofiwch, gall y broses hon gymryd amser maith.</b>';
$string['maintenancemode'] = 'Yn y modd cynnal a chadw';
$string['maintenancemodeisscheduled'] = 'Mae\'r safle yn newid i\'r modd cynnal a chadw mewn {$a} munud';
$string['maintfileopenerror'] = 'Gwall wrth agor ffeiliau cynnal a chadw!';
$string['maintinprogress'] = 'Wrthi\'n cynnal a chadw ...';
$string['manageformats'] = 'Rheoli fformatau cwrs';
$string['manageformatsgotosettings'] = 'Mae modd newid y fformat diofyn mewn {$a}';
$string['managelang'] = 'Rheoli';
$string['managelicenses'] = 'Rheoli trwyddedau';
$string['manageqbehaviours'] = 'Rheoli ymddygiad cwestiynau';
$string['manageqtypes'] = 'Rheoli mathau o gwestiwn';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Rhyddhau\'r ymgeisydd';
$string['maturity200'] = 'Fersiwn sefydlog';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Awgrym: Efallai y dylech redeg y sgript hon gyda\'r dewis --caniatáu—ansefydlog';
$string['maturitycoreinfo'] = 'Ar hyn o bryd mae eich safle\'n rhedeg cod datblygu "{$a}" ansefydlog';
$string['maturitycorewarning'] = 'Mae\'r fersiwn o Moodle rydych chi ar fin ei osod neu ei uwchraddio yn cynnwys cod datblygu "{$a}" ansefydlog sydd ddim yn addas i\'w ddefnyddio ar y rhan fwyaf o safleoedd cynhyrchu. Os nad oeddech yn bwriadu hyn, yna dylech wneud yn siŵr eich bod yn diweddaru o gangen SEFYDLOG o god Moodle. Darllenwch Ddogfennau Moodle i gael rhagor o fanylion.';
$string['maxbytes'] = 'Maint mwyaf ffeil llwytho i fyny';
$string['maxconsecutiveidentchars'] = 'Nodau dilynol union yr un peth';
$string['maxeditingtime'] = 'Amser hiraf i olygu negeseuon a bostiwyd';
$string['maxusersperpage'] = 'Nifer mwyaf o ddefnyddwyr y dudalen';
$string['mbstringrecommended'] = 'Argymhellir yn gryf eich bod yn gosod y llyfrgell MBSTRING ddewisol er mwyn gwella perfformiad y safle, yn enwedig os gall eich safle ddelio ag ieithoedd heblaw rhai Lladin.';
$string['mediapluginavi'] = 'Galluogi hidlydd .avi';
$string['mediapluginflv'] = 'Galluogi hidlydd .flv';
$string['mediapluginimg'] = 'Galluogi awto-blannu delweddau sydd wedi\'u cysylltu';
$string['mediapluginmov'] = 'Galluogi hidlydd .mov';
$string['mediapluginmp3'] = 'Galluogi hidlydd .mp3';
$string['mediapluginmpg'] = 'Galluogi hidlydd .mpg';
$string['mediapluginogg'] = 'Galluogi hidlydd .ogg';
$string['mediapluginogv'] = 'Galluogi hidlydd .ogv';
$string['mediapluginram'] = 'Galluogi hidlydd .ram';
$string['mediapluginrm'] = 'Galluogi hidlydd .rm';
$string['mediapluginrpm'] = 'Galluogi hidlydd .rpm';
$string['mediapluginswf'] = 'Galluogi hidlydd .swf';
$string['mediapluginswfnote'] = 'Fel mesur diogelwch diofyn, ni ddylid gadael i ddefnyddwyr normal fewnosod ffeiliau fflash swf.';
$string['mediapluginwmv'] = 'Galluogi hidlydd .wmv';
$string['mediapluginyoutube'] = 'Galluogi hidlydd dolenni YouTube';
$string['messaging'] = 'Galluogi system anfon negeseuon';
$string['messagingallowemailoverride'] = 'Diystyru e-byst hysbysu';
$string['messagingdeletereadnotificationsdelay'] = 'Dileu hysbysiadau sydd wedi\'u darllen';
$string['messaginghidereadnotifications'] = 'Cuddio hysbysiadau sydd wedi\'u darllen';
$string['minpassworddigits'] = 'Digidau';
$string['minpasswordlength'] = 'Hyd y cyfrinair';
$string['minpasswordlower'] = 'Llythrennau bach';
$string['minpasswordnonalphanum'] = 'Nodau nad ydynt yn llythrennau nac yn rhifau';
$string['minpasswordupper'] = 'Priflythrennau';
$string['misc'] = 'Amrywiol';
$string['mnetrestore_extusers'] = '<strong>Cofiwch:</strong> Mae\'r ffeil wrth gefn hon yn cynnwys cyfrifon defnyddwyr Rhwydwaith Moodle pell a gaiff eu hadfer fel rhan o\'r broses.';
$string['mnetrestore_extusers_admin'] = '<strong>Nodyn:</strong> Mae\'n ymddangos bod y ffeil wrth gefn hon yn perthyn i osodiad Moodle arall ac mae\'n cynnwys cyfrifon defnyddwyr Rhwydwaith Moodle o bell. Bydd y broses adfer yn ceisio cyfateb  gwesteiwyr y Rhwydwaith Moodle ar gyfer yr holl ddefnyddwyr sydd wedi\'u creu. Bydd y rheini sydd ddim yn cyfateb yn cael eu symud yn awtomatig i\'r broses dilysu mewnol (yn hytrach na mnet). Bydd y log adfer yn eich hysbysu o hynny.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Cofiwch:</strong> Mae\'n debyg bod y ffeil wrth gefn hon wedi tarddu o osodiad Moodle gwahanol, a\'i bod yn cynnwys cyfrifon defnyddwyr Rhwydwaith Moodle pell a allai fethu ag adfer. Does dim modd delio â\'r weithred hon. Os ydych chi\'n siŵr y cafodd ei chreu ar y gosodiad Moodle hwn, neu os gallwch sicrhau bod yr holl Westeiwyr Rhwydwaith Moodle angenrheidiol wedi\'u ffurfweddu, gallwch ddal i geisio adfer.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nodyn:</strong> Mae\'n ymddangos bod y ffeil wrth gefn hon yn perthyn i osodiad Moodle arall ac mae\'n cynnwys cyfrifon defnyddwyr Rhwydwaith Moodle o bell. Does gennych chi ddim hawl cyflawni\'r broses adfer hon. Cysylltwch â gweinyddwr y safle, neu fel arall, gallwch adfer y cwrs heb unrhyw wybodaeth am ddefnyddwyr (modiwlau, ffeiliau...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Mae\'r defnyddiwr Rhwydwaith Moodle o Bell {$a->username} (yn deillio o {$a->mnethosturl}) wedi newid i ddefnyddiwr dilysu lleol {$a->auth}.';
$string['mobile'] = 'Symudol';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Dewiswr gweithgaredd diofyn';
$string['modeditdefaults'] = 'Y gwerthoedd diofyn ar gyfer gosodiadau gweithgaredd';
$string['modeditingmenu'] = 'Dewislenni golygu gweithgareddau';
$string['modeditingmenu_desc'] = 'Os galluogir, bydd nifer o\'r eiconau golygu gweithgareddau yn cael eu harddangos mewn cwymplen wrth edrych ar gwrs gyda golygu ymlaen. Bydd hyn yn lleihau\'r cynnwys ar y sgrin wrth olygu cwrs drwy guddio\'r eiconau nes bydd eu hangen.';
$string['modsettings'] = 'Rheoli gweithgareddau';
$string['modulesecurity'] = 'Diogelwch modiwl';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Gorfodi\'r hen gystrawen multilang: &lt;span&gt; heb y dosbarth="multilang" a &lt;lang&gt;';
$string['mustenablestats'] = 'Dydy ystadegau ddim wedi eu galluogi ar y safle hwn eto.';
$string['mycoursesperpage'] = 'Nifer y cyrsiau';
$string['mydashboard'] = 'Hysbysfwrdd diofyn y system';
$string['mymoodle'] = 'Fy Moodle';
$string['mymoodleredirect'] = 'Gorfodi defnyddwyr i ddefnyddio Fy Moodle';
$string['mypage'] = 'Gwneud Fy hafan yn ddiofyn';
$string['mypagelocked'] = 'Cloi\'r dudalen ddiofyn';
$string['myprofile'] = 'Tudalen proffil ddiofyn';
$string['mysql416bypassed'] = 'Fodd bynnag, os yw eich safle\'n defnyddio ieithoedd iso-8859-1 (Lladin) YN UNIG, gallwch barhau i ddefnyddio\'r MySQL 4.1.12 (neu uwch) sydd wedi\'i osod gennych ar hyn o bryd.';
$string['mysql416required'] = 'MySQL 4.1.16 yw\'r fersiwn sylfaenol sy\'n ofynnol ar gyfer Moodle 1.6 er mwyn sicrhau y gellir trosi\'r holl ddata i UTF-8 yn y dyfodol.';
$string['navadduserpostslinks'] = 'Ychwanegu dolenni i weld postiadau\'r defnyddiwr';
$string['navadduserpostslinks_help'] = 'Os yw wedi’i alluogi bydd dwy ddolen yn cael eu hychwanegu at bob defnyddiwr yn y bar llywio er mwyn cael gweld trafodaethau mae\'r defnyddiwr wedi\'u cychwyn a phostiadau mae\'r defnyddiwr wedi\'u gwneud mewn fforymau drwy\'r safle ac mewn cyrsiau penodol.';
$string['navcourselimit'] = 'Cyfyngiad y cwrs';
$string['navigationupgrade'] = 'Mae\'r uwchraddiad hwn yn cyflwyno dau floc llywio newydd a fydd yn disodli\'r blociau hyn: Gweinyddu, Cyrsiau, Gweithgareddau a\'r Cyfranogwyr. Os oeddech chi wedi gosod unrhyw hawliau arbennig ar y blociau hynny, dylech wneud yn siŵr bod popeth yn ymddwyn fel y dylent.';
$string['navshowallcourses'] = 'Dangos pob cwrs';
$string['navshowcategories'] = 'Dangos categorïau cwrs';
$string['navshowfrontpagemods'] = 'Dangos gweithgareddau\'r dudalen flaen yn y bar llywio';
$string['navshowfrontpagemods_help'] = 'Os yw wedi\'i alluogi, bydd gweithgareddau\'r dudalen flaen yn cael eu dangos yn y bar llywio o dan tudalennau\'r safle.';
$string['navshowfullcoursenames'] = 'Dangos enw llawn y cyrsiau';
$string['navshowfullcoursenames_help'] = 'Os yw wedi\'i alluogi bydd y cyrsiau sy\'n y bar llywio yn cael eu dangos gyda\'u henwau llawn yn hytrach na\'u henwau byr.';
$string['navshowmycoursecategories'] = 'Dangos categorïau fy nghwrs';
$string['navshowmycoursecategories_help'] = 'Os yw wedi\'i alluogi bydd y cyrsiau yng nghangen fy nghyrsiau y defnyddiwr yn cael eu dangos yn categorïau.';
$string['navsortmycoursessort'] = 'Trefnu fy nghyrsiau';
$string['navsortmycoursessort_help'] = 'Mae hwn yn pennu os yw cyrsiau’n cael eu rhestru o dan Fy nghyrsiau yn ôl y drefn ddidoli (h.y. y drefn sydd wedi’i gosod yn Gosodiadau > Gweinyddu Safle > Cyrsiau >Ychwanegu/golygu cyrsiau) neu yn nhrefn yr wyddor yn ôl gosodiadau’r cwrs';
$string['neverdeleteruns'] = 'Peidio byth â dileu rhediadau';
$string['nobookmarksforuser'] = 'Nid oes gennych unrhyw nodau tudalen.';
$string['nodatabase'] = 'Dim cronfa ddata';
$string['nohttpsformobilewarning'] = 'Rydym yn argymell eich bod yn galluogi HTTPS gyda thystysgrif ddilys. Bydd yr app Moodle bob amser yn ceisio defnyddio cyswllt wedi\'i ddiogelu\'n gyntaf.';
$string['nomissingstrings'] = 'Dim llinynnau coll';
$string['nonewsettings'] = 'Ni ychwanegwyd gosodiadau newydd yn ystod yr uwchraddiad hwn.';
$string['nonexistentbookmark'] = 'Nid yw\'r nod tudalen yn eich cais yn bodoli.';
$string['noresults'] = 'Heb ddod o hyd i ganlyniadau.';
$string['noroles'] = 'Dim swyddogaethau';
$string['notifications'] = 'Hysbysiadau';
$string['notifyloginfailures'] = 'E-bostio methiannau mewngofnodi i';
$string['notifyloginthreshold'] = 'Trothwy ar gyfer hysbysiadau e-bost';
$string['notloggedinroleid'] = 'Swyddogaeth ar gyfer ymwelwyr';
$string['numberofmissingstrings'] = 'Nifer y llinynnau sydd ar goll: {$a}';
$string['numberofstrings'] = 'Cyfanswm nifer y llinynnau: {$a->strings}<br />Ar goll: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Bydd storio opcode PHP yn gwella perfformiad ac yn lleihau\'r gofynion cof. Mae estyniad OPcache yn cael ei argymell a\'i gefnogi\'n llwyr.';
$string['opensslrecommended'] = 'Argymhellir yn gryf eich bod yn gosod y llyfrgell OpenSSL ddewisol -- mae\'n galluogi Rhwydweithio Moodle.';
$string['opentogoogle'] = 'Agor i Google';
$string['optionalmaintenancemessage'] = 'Neges cynnal a chadw ddewisol';
$string['order1'] = 'Cyntaf';
$string['order2'] = 'Ail';
$string['order3'] = 'Trydydd';
$string['order4'] = 'Pedwerydd';
$string['passwordpolicy'] = 'Polisi cyfrinair';
$string['passwordresettime'] = 'Uchafswm amser ar gyfer dilysu cais ailosod cyfrinair';
$string['pathconvert'] = 'Llwybr <i>trosi</i> deuaidd';
$string['pathdvips'] = 'Llwybr <i>dvips</i> deuaidd';
$string['pathlatex'] = 'Llwybr <i>latex</i> deuaidd';
$string['pathtoclam'] = 'llwybr clam AV';
$string['pathtodot'] = 'Llwybr at ddot';
$string['pathtodot_help'] = 'Llwybr at ddot. Rhywbeth fel /usr/bin/dot. Er mwyn gallu cynhyrchu graffigau o ffeiliau DOT, rhaid eich bod wedi gosod y weithred dot ac yn pwyntio ati yn y fan hon. Cofiwch, am nawr, dim ond y nodweddion proffilio yn Moodle sy\'n ei ddefnyddio (Datblygu->Proffilio).';
$string['pathtodu'] = 'Llwybr at du';
$string['pathtopgdump'] = 'Llwybr at pg_dump';
$string['pathtopgdumpdesc'] = 'Dim ond os oes gennych fwy nag un pg_dump ar eich system y bydd angen rhoi hwn (er enghraifft, os oes gennych fwy nag un fersiwn o postgresql wedi\'i osod)';
$string['pathtopgdumpinvalid'] = 'Llwybr annilys at pg_dump - llwybr naill ai\'n anghywir neu ddim yn weithredadwy';
$string['pathtopsql'] = 'Llwybr at psql';
$string['pathtopsqldesc'] = 'Dim ond os oes gennych fwy nag un psql ar eich system y bydd angen rhoi hwn (er enghraifft, os oes gennych fwy nag un fersiwn o postgresql wedi\'i osod)';
$string['pathtopsqlinvalid'] = 'Llwybr annilys at psql - llwybr naill ai\'n anghywir neu ddim yn weithredadwy';
$string['pcreunicodewarning'] = 'Mae’n cael ei argymell yn gryf eich bod yn defnyddio estyniad PCRE PHP sy’n gydnaws â nodau Unicode.';
$string['perfdebug'] = 'Gwybodaeth perfformiad';
$string['performance'] = 'Perfformiad';
$string['pgcluster'] = 'Clwstwr PostgreSQL';
$string['pgclusterdescription'] = 'Paramedr fersiwn/clwstwr PostgreSQL ar gyfer gweithrediadau llinell gorchmynion. Os mai dim ond un postgresql sydd ar eich system, neu os nad ydych yn siŵr beth yw hyn, gadewch hwn yn wag.';
$string['php50restricted'] = 'Mae PHP 5.0.x yn frith o broblemau hysbys; uwchraddiwch i 5.1.x neu israddiwch i 4.3.x neu 4.4.x';
$string['php533warning'] = 'Rydym yn argymell PHP 5.3.3 neu uwch';
$string['phpfloatproblem'] = 'Wedi canfod problem annisgwyl wrth drin rhifau arnawf PHP - {$a}';
$string['pleaserefreshregistration'] = 'Mae\'ch safle wedi\'i gofrestru gyda moodle.org. Fyddech chi gystal ag uwchraddio\'r cofrestriad os oes newidiadau sylweddol wedi digwydd ers i chi uwchraddio ddiwethaf, ar {$a}';
$string['pleaseregister'] = 'Cofrestrwch eich safle i gael gwared â\'r botwm hwn';
$string['plugin'] = 'Ategyn';
$string['plugins'] = 'Ategion';
$string['pluginscheck'] = 'Gwirio dibyniaethau ategion';
$string['pluginscheckfailed'] = 'Gwirio dibyniaethau wedi methu ar gyfer {$a->pluginslist}';
$string['pluginschecktodo'] = 'Mae\'n rhaid i chi ddatrys holl ofynion yr ategyn cyn mynd ymlaen i osod y fersiwn hwn o Moodle!';
$string['pluginsoverview'] = 'Golwg gyffredinol ar yr ategion';
$string['pluginsoverviewsee'] = 'Ewch i dudalen <a href="{$a->url}">trosolwg o’r ategion</a> i gael gwybod mwy.';
$string['profilecategory'] = 'Categori';
$string['profilecategoryname'] = 'Enw categori (rhaid bod yn unigryw)';
$string['profilecategorynamenotunique'] = 'Mae\'r enw categori hwn eisoes yn cael ei ddefnyddio';
$string['profilecommonsettings'] = 'Gosodiadau cyffredin';
$string['profileconfirmcategorydeletion'] = 'Mae {$a} maes yn y categori hwn a symudir i\'r categori uwchlaw (neu islaw os mai hwn yw\'r categori uchaf).<br />Ydych chi am ddileu\'r categori hwn beth bynnag?';
$string['profileconfirmfielddeletion'] = 'Mae {$a} cofnod defnyddiwr ar gyfer y maes hwn a gaiff eu dileu.<br/>Ydych chi am ddileu\'r maes hwn beth bynnag?';
$string['profilecreatecategory'] = 'Creu categori proffil newydd';
$string['profilecreatefield'] = 'Creu maes proffil newydd:';
$string['profilecreatenewcategory'] = 'Creu categori newydd';
$string['profilecreatenewfield'] = 'Creu maes proffil newydd "{$a}"';
$string['profiledefaultcategory'] = 'Meysydd eraill';
$string['profiledefaultchecked'] = 'Wedi\'u gwirio\'n ddiofyn';
$string['profiledefaultdata'] = 'Gwerth diofyn';
$string['profiledeletecategory'] = 'Dileu categori';
$string['profiledeletefield'] = 'Dileu maes';
$string['profiledescription'] = 'Disgrifiad o\'r maes';
$string['profiledscript'] = 'Wedi proffilio\'r sgript';
$string['profiledscriptview'] = 'Gweld gwybodaeth proffilio\'r sgript hon';
$string['profileeditcategory'] = 'Golygu categori: {$a}';
$string['profileeditfield'] = 'Wrthi\'n golygu maes proffil: {$a}';
$string['profilefield'] = 'Maes Proffil';
$string['profilefieldcolumns'] = 'Colofnau';
$string['profilefieldispassword'] = 'A yw hwn yn faes cyfrinair?';
$string['profilefieldlink'] = 'Dolen';
$string['profilefieldlink_help'] = 'I newid y testun yn ddolen, rhowch URL yn cynnwys $$. Bydd yr $$ yn cael ei ddisodli gan y testun. Er enghraifft, i newid ID Twitter yn ddolen, teipiwch http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Dolen i\'r targed';
$string['profilefieldmaxlength'] = 'Hyd mwyaf';
$string['profilefieldrows'] = 'Rhesi';
$string['profilefields'] = 'Meysydd proffil defnyddiwr';
$string['profilefieldsize'] = 'Maint arddangos';
$string['profileforceunique'] = 'Ddylai\'r data fod yn unigryw?';
$string['profileinvaliddata'] = 'Gwerth annilys';
$string['profilelocked'] = 'A yw\'r maes hwn wedi\'i gloi?';
$string['profilemenudefaultnotinoptions'] = 'Nid yw\'r gwerth diofyn yn un o\'r dewisiadau';
$string['profilemenunooptions'] = 'Dim dewisiadau dewislen ar gael';
$string['profilemenuoptions'] = 'Dewisiadau dewislen (un i bob llinell)';
$string['profilemenutoofewoptions'] = 'Rhaid i chi roi o leiaf 2 ddewis';
$string['profilename'] = 'Enw';
$string['profilenofieldsdefined'] = 'Does dim meysydd wedi\'u diffinio';
$string['profilerequired'] = 'A oes angen y maes hwn?';
$string['profileroles'] = 'Proffilio\'r swyddogaethau y gellir eu gweld';
$string['profilesforenrolledusersonly'] = 'Proffiliau ar gyfer defnyddwyr sydd wedi cofrestru\'n unig';
$string['profileshortname'] = 'Enw byr (rhaid iddo fod yn unigryw)';
$string['profileshortnamenotunique'] = 'Mae\'r enw byr hwn yn cael ei ddefnyddio eisoes';
$string['profilesignup'] = 'Dangos ar y dudalen creu cyfri?';
$string['profilespecificsettings'] = 'Gosodiadau penodol';
$string['profilevisible'] = 'Pwy sy\'n gallu gweld y maes hwn?';
$string['profilevisibleall'] = 'Gweladwy i bawb';
$string['profilevisible_help'] = '* Cudd - Ar gyfer data preifat sy\'n cael ei weld gan weinyddwyr yn unig * Defnyddiwr yn gweld - Ar gyfer data preifat sy\'n cael ei weld gan y defnyddiwr a\'r gweinyddwyr yn unig * Pawb yn gweld';
$string['profilevisiblenone'] = 'Anweladwy';
$string['profilevisibleprivate'] = 'Gweladwy i\'r defnyddiwr';
$string['profiling'] = 'Wrthi\'n proffilio';
$string['profilingallowall'] = 'Proffilio parhaus';
$string['profilingallowall_help'] = 'Os ydych chi\'n galluogi\'r gosodiad hwn, yna gallwch ddefnyddio\'r paramedr PROFILEALL ar unrhyw adeg yn unrhyw le (PGC) er mwyn proffilio\'r holl sgriptiau ym mywyd y sesiwn Moodle. Yn yr un modd, gallwch ddefnyddio\'r paramedr PROFILEALLSTOP i\'w stopio.';
$string['profilingallowme'] = 'Proffilio dethol';
$string['profilingallowme_help'] = 'Os ydych chi\'n galluogi\'r gosodiad hwn, yna gallwch ddefnyddio\'r paramedr PROFILEME ar unrhyw adeg yn unrhyw le (PGC) a bydd y sgript honno\'n cael ei phroffilio. Yn yr un modd, gallwch ddefnyddio\'r paramedr DONTPROFILEME i atal y broses proffilio';
$string['profilingautofrec'] = 'Proffilio\'n awtomatig';
$string['profilingautofrec_help'] = 'Drwy ffurfweddu’r gosodiad hwn, bydd rhai ceisiadau (ar hap, yn seiliedig ar yr amlder a benodwyd – 1 o N) yn cael eu dewis a’u proffilio’n awtomatig, gan storio’r canlyniadau ar gyfer dadansoddiad pellach. Nodwch fod y ffordd hon o broffilio yn arsylwi gosodiadau cynnwys/eithrio. I analluogi proffilio awtomatig gosodwch ef i 0.';
$string['profilingenabled'] = 'Galluogi proffilio';
$string['profilingenabled_help'] = 'Os ydych chi\'n galluogi\'r gosodiad hwn, byddwch yn gallu proffilio ar y safle hwn ac yn gallu diffinio sut mae\'n ymddwyn drwy ffurfweddu\'r dewisiadau nesaf.';
$string['profilingexcluded'] = 'Eithrio proffilio';
$string['profilingexcluded_help'] = 'Rhestr o URL\'s (gyda chomas rhyngddynt, absolute skipping wwwroot, callable) fydd yn cael eu heithrio rhag cael eu proffilio o\'r rhai sydd wedi\'u diffinio gan y gosodiad \'Proffilio\'r rhain\'.';
$string['profilingimportprefix'] = 'Rhagosodiad proffilio mewngludo';
$string['profilingimportprefix_desc'] = 'I’w gwneud yn haws i’w canfod, bydd yr holl rediadau proffilio sydd wedi’u mewngludo yn cael eu rhagosod gyda\'r gwerth sydd wedi’i bennu yma.';
$string['profilingincluded'] = 'Proffilio\'r rhain';
$string['profilingincluded_help'] = 'Rhestr o URL\'s (gyda chomas rhyngddynt, absolute skipping wwwroot, callable) fydd yn cael eu proffilio\'n awtomatig. Enghreifftiau: /index.php, /course/view.php. Hefyd yn derbyn y nod chwilio * yn unrhyw le. Enghreifftiau: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Cadw rhediadau proffilio';
$string['profilinglifetime_help'] = 'Pennwch am faint o amser rydych chi am gadw gwybodaeth am hen rediadau proffilio. Bydd rhai hŷn yn cael eu tocio o bryd i\'w gilydd. Cofiwch fod hyn yn eithrio unrhyw rediad proffilio a nodwyd fel \'rhediad cyfeirnod\'';
$string['protectusernames'] = 'Diogelu enwau defnyddwyr';
$string['proxybypass'] = 'Gwesteiwyr hepgor y dirprwy';
$string['proxyhost'] = 'Gwesteiwr dirprwyol';
$string['proxypassword'] = 'Cyfrinair y dirprwy';
$string['proxyport'] = 'Porth dirprwyol';
$string['proxytype'] = 'Math o ddirprwy';
$string['proxyuser'] = 'Enw defnyddiwr y dirprwy';
$string['purgecaches'] = 'Puro\'r holl storfeydd';
$string['purgecachesconfirm'] = 'Gall Moodle storio themâu, javascript, llinynnau iaith, testun wedi\'i hidlo, crynodebau rss a llawer iawn o ddata arall wedi\'i gyfrifo. Bydd puro\'r storfeydd hyn yn dileu\'r data hwnnw o\'r gweinydd ac yn gorfodi porwyr i nôl y data eto, fel y gallwch fod yn dawel eich meddwl eich bod yn gweld y gwerthoedd diweddaraf a gynhyrchwyd gan y cod cyfredol. Does dim perygl mewn puro storfeydd, ond efallai bydd eich safle\'n arafu am dipyn hyd nes bod y gweinydd a\'r cleientiaid yn cyfrifo\'r wybodaeth newydd ac yn ei storio.';
$string['purgecachesfinished'] = 'Wedi puro pob storfa.';
$string['qtyperqpwillberemoved'] = 'Wrth uwchraddio, bydd cwestiynnau RQP yn cael eu tynnu. Doeddech chi ddim yn defnyddio\'r math hwn o gwestiwn beth bynnag, felly ddylech chi ddim profi unrhyw broblemau.';
$string['qtyperqpwillberemovedanyway'] = 'Wrth uwchraddio, bydd cwestiynau RQP yn cael eu tynnu. Mae gennych chi rai cwestiynau RQP yn eich cronfa ddata a bydd y rhain yn stopio gweithio oni bai eich bod yn ailosod y cod o http://moodle.org/mod/data/view.php?d=13&rid=797 cyn bwrw ymlaen i uwchraddio.';
$string['quarantinedir'] = 'Cyfeiriadur cwarantin';
$string['question'] = 'Cwestiwn';
$string['questionbehaviours'] = 'Sut mae cwestiynau\'n ymddwyn';
$string['questioncwqpfscheck'] = 'Caiff un neu fwy o gwestiynau \'ar hap\' mewn cwis eu trefnu i ddewis cwestiynau o blith cymysgedd o gategorïau cwestiynau a rennir a rhai na chânt eu rhannu. Ceir adroddiad manylach <a href="{$a->reporturl}">yma</a> a gweler tudalen Dogfennau Moodle <a href="{$a->docsurl}">yma</a>.';
$string['questioncwqpfsok'] = 'Da. Does dim cwestiynau \'ar hap\' yn eich cwisiau sydd wedi\'u trefnu i ddewis cwestiynau o blith cymysgedd o gategorïau cwestiynau a rennir a rhai na chânt eu rhannu.';
$string['questiontype'] = 'Math o gwestiwn';
$string['questiontypes'] = 'Mathau o gwestiwn';
$string['quizattemptsupgradedmessage'] = 'Yn Moodle 2.1 cafodd y cwestiynau eu huwchraddio\'n sylweddol. Roedd yn bosib oedi rhannau o\'r broses o uwchraddio\'r gronfa ddata ar gyfer eu rhedeg yn nes ymlaen. Cyn uwchraddio i Moodle 2.7, mae\'n rhaid i\'r broses uwchraddio hon gael ei chwblhau.';
$string['recaptchaprivatekey'] = 'Allwedd breifat ReCAPTCHA';
$string['recaptchapublickey'] = 'Allwedd gyhoeddus ReCAPTCHA';
$string['register'] = 'Cofrestrwch eich safle';
$string['registermoodleorg'] = 'Pan rydych yn cofrestru eich safle gyda {$a}';
$string['registermoodleorgli1'] = 'Rydych wedi’ch hychwanegu at restr bostio cyfaint-isel ar gyfer hysbysiadau pwysig fel rhybuddion diogelwch a rhaglenni newydd Moodle.';
$string['registermoodleorgli2'] = 'Bydd ystadegau am eich safle yn cael eu hychwanegu at {$a} y gymdeithas Moodle fyd-eang.';
$string['registermoodleorgli3'] = 'Mae eich safle hefyd wedi’i gofrestru gyda Moodle.net ({$a}), gan ganiatáu i ddefnyddwyr gyda’r gallu i gyhoeddi cyrsiau (dim ond rheolwyr sy’n ddiofyn) ddewis cyhoeddi cyrsiau yn Moodle.net.';
$string['registerwithmoodleorg'] = 'Cofrestrwch gyda Moodle.org';
$string['registration'] = 'Cofrestru';
$string['registration_help'] = 'Cofrestru eich safle gyda Moodle.org ydy’r dewis gorau er mwyn derbyn hysbysiadau am rybuddion diogelwch, i gyfrannu at <a href="http://moodle.org/stats">ystadegau defnyddio Moodle</a> ac i allu rhannu cyrsiau yn <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Dydy eich safle ddim wedi cael ei gofrestru eto.';
$string['releasenoteslink'] = 'I gael gwybodaeth am y fersiwn hwn o Moodle, gweler y <a target="_new" href="{$a}">Nodiadau Rhyddhau</a> ar-lein';
$string['rememberusername'] = 'Cofio\'r enw defnyddiwr';
$string['rememberusername_desc'] = 'Galluogi os ydych chi eisiau storio cwcis parhaol gydag enwau defnyddwyr yn ystod mewngofnodi defnyddiwr. Efallai bydd cwcis parhaol yn cael eu hystyried fel problem breifatrwydd os ydyn nhw’n cael eu ddefnyddio heb ganiatâd.';
$string['reportsmanage'] = 'Rheoli adroddiadau';
$string['requestcategoryselection'] = 'Galluogi dewis categori';
$string['requiredentrieschanged'] = '<strong>PWYSIG - DARLLENWCH<br/>(Bydd y neges rybudd hon yn ymddangos wrth uwchraddio\'n unig)</strong><br/>Er mwyn trwsio chwilen, bydd ymddygiad y gweithgareddau cronfeydd data sy\'n defnyddio\'r gosodiadau \'Cofnodion gofynnol\' a \'Cofnodion gofynnol cyn gweld gosodiadau\' yn newid. Gallwch ddarllen esboniad manylach yn <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">y fforwm modiwl cronfeydd data</a>. Gallwch ddarllen am ymddygiad disgwyliedig y gosodiadau hyn hefyd yn <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>Mae\'r newid hwn yn effeithio ar y cronfeydd data canlynol yn eich system: (Cadwch y rhestr hon nawr, ac ar ôl uwchraddio, gwnewch yn siŵr fod y gweithgareddau hyn yn dal yn gweithio yn ôl dymuniad yr athro.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Rhaid cael disgrifiad o weithgaredd';
$string['requires'] = 'Gofynnol';
$string['restorernewroleid'] = 'Rôl adferwyr yn y cyrsiau';
$string['restorernewroleid_help'] = 'Os nad oes gan y defnyddiwr hawl i reoli y cyrsiau sydd newydd eu hadfer yn barod, bydd y defnyddiwr yn derbyn y rôl yn awtomatig a\'i gofrestru os bydd angen. Dewiswch "Dim" os nad ydych chi eisiau i adferwyr allu rheoli bob cwrs sydd wedi’i adfer.';
$string['reverseproxy'] = 'Dirprwy weinydd gwrthdro';
$string['riskconfig'] = 'Gallai defnyddwyr newid ffurfweddiad ac ymddygiad y safle';
$string['riskconfigshort'] = 'Risg ffurfweddu';
$string['riskdataloss'] = 'Gallai defnyddwyr ddinistrio darnau mawr o gynnwys neu wybodaeth';
$string['riskdatalossshort'] = 'Perygl o golli data';
$string['riskmanagetrust'] = 'Gallai defnyddwyr newid gosodiadau ymddiried defnyddwyr eraill';
$string['riskmanagetrustshort'] = 'Rheoli gosodiadau ymddiried';
$string['riskpersonal'] = 'Gallai defnyddwyr gael mynediad at wybodaeth breifat defnyddwyr eraill';
$string['riskpersonalshort'] = 'Risg preifatrwydd';
$string['riskspam'] = 'Gallai defnyddwyr anfon post sothach at ddefnyddwyr y safle neu at eraill';
$string['riskspamshort'] = 'Risg post sothach';
$string['riskxss'] = 'Gallai defnyddwyr ychwanegu ffeiliau a thestun sy\'n caniatáu sgriptio ar draws y safle (XSS)';
$string['riskxssshort'] = 'Risg XSS';
$string['roleswithexceptions'] = '{$a->roles}, gyda {$a->exceptions}';
$string['rssglobaldisabled'] = 'Wedi\'i analluogi ar lefel gweinydd';
$string['runclamavonupload'] = 'Defnyddio clam AV ar ffeiliau a lwythir i fyny';
$string['save'] = 'Cadw';
$string['savechanges'] = 'Cadw\'r newidiadau';
$string['search'] = 'Chwilio';
$string['searchinsettings'] = 'Chwilio yn y gosodiadau';
$string['searchresults'] = 'Canlyniadau\'r chwilio';
$string['sectionerror'] = 'Gwall adran!';
$string['secureforms'] = 'Defnyddio diogelwch ychwanegol ar y ffurflen';
$string['security'] = 'Diogelwch';
$string['selectdevice'] = 'Dewis dyfais';
$string['selecttheme'] = 'Dewis thema ar gyfer dyfais {$a}';
$string['server'] = 'Gweinydd';
$string['serverchecks'] = 'Archwiliadau\'r gweinydd';
$string['serverlimit'] = 'Terfyn y gweinydd';
$string['sessionautostartwarning'] = '<p>Wedi canfod gwall ffurfweddu difrifol, rhowch wybod i weinyddwr y gweinydd.</p><p> Iddo weithio\'n iawn, mae Moodle yn mynnu bod y gweinyddwr yn newid y gosodiadau PHP.</p><p>Rhaid bod <code>session.auto_start</code><code>wedi\'i ddiffodd</code>.</p><p>Caiff y gosodiad hwn ei reoli drwy olygu <code>php.ini</code>, Apache/IIS <br />ffeil ffurfweddu neu <code>.htaccess</code> ar y gweinydd.</p>';
$string['sessioncookie'] = 'Rhagddodiad briwsionyn';
$string['sessioncookiedomain'] = 'Parth cwci';
$string['sessioncookiepath'] = 'Llwybr briwsionyn';
$string['sessionhandling'] = 'Trin y sesiwn';
$string['sessiontimeout'] = 'Amser wedi dod i ben';
$string['settingfileuploads'] = 'Rhaid gallu llwytho ffeiliau i fyny er mwyn gweithio, felly dylech ei alluogi yn y ffurfweddiad PHP.';
$string['settingmemorylimit'] = 'Dim digon o gof. Pennwch uchafwm maint mwy i\'r cof yn y gosodiadau PHP.';
$string['settingsafemode'] = 'Dydy Moodle ddim yn hollol gydnaws â\'r modd diogel, gofynnwch i weinyddwr y gweinydd ei ddiffodd. Dydy rhedeg Moodle yn y modd diogel ddim yn syniad da, felly gallwch ddisgwyl dod ar draws problemau os ydych yn gwneud hynny.';
$string['showcommentscount'] = 'Dangos bloc cyfri\'r sylwadau';
$string['showdetails'] = 'Dangos manylion';
$string['showuseridentity'] = 'Dangos manylion adnabod y defnyddiwr';
$string['showuseridentity_desc'] = 'Wrth ddewis neu chwilio am ddefnyddwyr, ac wrth ddangos rhestr o ddefnyddwyr, efallai bydd y meysydd hyn yn cael eu dangos yn ychwanegol i’w henwau llawn. Caiff y meysydd eu dangos i ddefnyddwyr gyda\'r gallu moodle/site:viewuseridentity yn unig; yn ddiofyn, athrawon a rheolwyr. (Dewiswch un neu ddau o feysydd sy’n orfodol yn eich sefydliad er mwyn i’r dewis hwn wneud mwy o synnwyr.)';
$string['simplexmlrequired'] = 'Bellach, mae ar Moodle angen yr estyniad SimpleXML PHP.';
$string['sitemaintenance'] = 'Mae gwaith cynnal a chadw\'n cael ei wneud ar y safle hwn ac nid yw ar gael ar hyn o bryd';
$string['sitemaintenancemode'] = 'Modd cynnal a chadw';
$string['sitemaintenanceoff'] = 'Mae\'r modd cynnal a chadw wedi\'i analluogi ac mae\'r safle\'n rhedeg yn normal unwaith eto';
$string['sitemaintenanceon'] = 'Mae eich safle yn y modd cynnal a chadw ar hyn o bryd (dim ond gweinyddwyr all fewngofnodi a defnyddio\'r safle).';
$string['sitemaintenanceoncli'] = 'Ar hyn o bryd mae\'ch safle yn y modd cynnal a chadw CLI, does dim mynediad i\'r we.';
$string['sitemaintenancewarning'] = 'Mae eich safle yn y modd cynnal a chadw ar hyn o bryd (dim ond gweinyddwyr all fewngofnodi).  I ddychwelyd y safle hwn i\'r modd normal, <a href="maintenance.php">analluogwch y modd cynnal a chadw</a>.';
$string['sitemaintenancewarning2'] = 'Ar hyn o bryd, mae eich safle yn y modd cynnal (dim ond gweinyddwyr sy\'n gallu mewngofnodi). I fynd â\'r safle\'n ôl i weithio\'n arferol, dylech <a href="{$a}">analluogi\'r modd cynnal</a>.';
$string['sitepolicies'] = 'Polisïau\'r safle';
$string['sitepolicy'] = 'URL polisi\'r safle';
$string['sitepolicyguest'] = 'URL polisi\'r safle ar gyfer gwesteiwyr';
$string['sitepolicyguest_help'] = 'Os oes gennych chi bolisi safle mae\'n rhaid i bob gwestai ei weld a chytuno iddo cyn defnyddio\'r safle hwn. Rhowch ei URL yma, neu fel arall, gadewch y maes hwn yn wag. Gall y gosodiad hwn gynnwys unrhyw URL cyhoeddus. Nodyn: gallwch atal defnyddwyr sydd heb fewngofnodi gyda\'r gosodiad gorfodi i fewngofnodi.';
$string['sitepolicy_help'] = 'Os oes gennych chi bolisi safle y mae\'n rhaid i bob defnyddiwr ei weld a chytuno ag ef cyn defnyddio\'r safle hwn, nodwch ei URL yma; fel arall, gadewch y maes hwn yn wag.  Gall yr URL gyfeirio at unrhyw le - un man cyfleus fyddai ffeil yn ffeiliau\'r safle, e.e. http://saflechi/ffeil.php/1/polisi.html';
$string['sitesectionhelp'] = 'Os caiff hyn ei ddewis, dangosir adran pynciau ar dudalen flaen y safle.';
$string['slasharguments'] = 'Defnyddio argiau slaes';
$string['smartpix'] = 'Chwilio smart pix';
$string['soaprecommended'] = 'Bydd gosod yr estyniad soap dewisol yn ddefnyddiol ar gyfer gwasanaethau gwe a rhai ychwanegion.';
$string['sort_fullname'] = 'Enw llawn y cwrs';
$string['sort_idnumber'] = 'Rhif ID y cwrs';
$string['sort_shortname'] = 'Enw byr y cwrs';
$string['sort_sortorder'] = 'Trefn ddidoli';
$string['spellengine'] = 'Peiriant sillafu';
$string['spelllanguagelist'] = 'Rhestr iaith sillafu';
$string['splrequired'] = 'Bellach, mae ar Moodle angen yr estyniad SPL PHP.';
$string['stats'] = 'Ystadegau';
$string['statsfirstrun'] = 'Y cyfnod prosesu mwyaf';
$string['statsmaxruntime'] = 'Amser rhedeg mwyaf';
$string['statsmoodleorg'] = 'ystadegau';
$string['statsruntimedays'] = 'Diwrnodau i brosesu';
$string['statsruntimestart'] = 'Rhedeg am';
$string['statsuserthreshold'] = 'Trothwy defnyddiwr';
$string['stickyblocks'] = 'Blociau gludiog';
$string['stickyblockscourseview'] = 'Tudalen cwrs';
$string['stickyblocksduplicatenotice'] = 'Os yw unrhyw floc a ychwanegwch yma eisoes yn bresennol ar dudalen benodol, bydd yn achosi bloc dyblyg.<br />Dim ond y bloc â phin na fydd yn bosib ei olygu, byddwch dal yn gallu golygu\'r bloc dyblyg.';
$string['stickyblocksmymoodle'] = 'Fy Moodle';
$string['stickyblockspagetype'] = 'Math o dudalen i\'w ffurfweddu';
$string['strictformsrequired'] = 'Dilysu\'r meysydd gofynnol yn llym';
$string['stripalltitletags'] = 'Tynnu tagiau HTML oddi ar enw pob gweithgaredd';
$string['supportcontact'] = 'Manylion cyswllt Cymorth';
$string['supportemail'] = 'E-bost Cymorth';
$string['supportname'] = 'Enw\'r Cymorth';
$string['supportpage'] = 'Tudalen Cymorth';
$string['suspenduser'] = 'Atal y cyfrif defnyddiwr';
$string['switchlang'] = 'Newid cyfeiriadur iaith';
$string['systempaths'] = 'Llwybrau system';
$string['tablenosave'] = 'Caiff newidiadau yn y tabl uchod eu cadw\'n awtomatig.';
$string['tablesnosave'] = 'Caiff newidiadau yn y tabl uchod eu cadw\'n awtomatig.';
$string['tabselectedtofront'] = 'Ar dablau gyda thabiau, a ddylid gosod y rhes gyda\'r tab sydd wedi\'i ddewis ar hyn o bryd ar y blaen';
$string['tabselectedtofronttext'] = 'Dwyn rhes y tab a ddewiswyd i\'r blaen';
$string['testsiteupgradewarning'] = 'Rydych ar hyn o bryd yn defnyddio safle prawf {$a}, i\'w uwchraddio\'n iawn defnyddiwch yr offeryn rhyngwyneb llinell gorchymyn';
$string['themedesignermode'] = 'Modd dylunio thema';
$string['themelist'] = 'Rhestr themâu';
$string['themenoselected'] = 'Dim thema wedi\'i dewis';
$string['themeresetcaches'] = 'Clirio\'r storfeydd thema';
$string['themeselect'] = 'Newid thema';
$string['themeselector'] = 'Dewisydd thema';
$string['themesettings'] = 'Gosodiadau thema';
$string['therewereerrors'] = 'Roedd gwallau yn eich data';
$string['thirdpartylibrary'] = 'Llyfrgell';
$string['thirdpartylibrarylocation'] = 'Lleoliad';
$string['thirdpartylibs'] = 'Llyfrgelloedd trydydd parti';
$string['timezone'] = 'Cylchfa amser ddiofyn';
$string['timezoneforced'] = 'Mae hyn wedi\'i orfodi gan weinyddwr y safle';
$string['timezoneisforcedto'] = 'Gorfodi pob defnyddiwr i ddefnyddio';
$string['timezonenotforced'] = 'Gall defnyddwyr ddewis eu cylchfa amser eu hunain';
$string['tokenizerrecommended'] = 'Argymhellir gosod yr estyniad Tocynnwr PHP dewisol -- mae\'n gwneud i Rwydweithio Moodle weithio\'n well.';
$string['tools'] = 'Offer gweinyddol';
$string['toolsmanage'] = 'Rheoli\'r offer gweinyddol';
$string['unattendedoperation'] = 'Gweithred heb oruchwyliaeth';
$string['unbookmarkthispage'] = 'Tynnu\'r nod tudalen o\'r dudalen hon';
$string['unicoderecommended'] = 'Argymhellir storio eich holl ddata yn Unicode (UTF-8). Dylid gosod fersiynau newydd mewn cronfeydd data sydd ag Unicode fel set nodau ddiofyn. Os ydych chi\'n uwchraddio, dylech gyflawni\'r broses mudo UTF-8 (gweler y dudalen Gweinyddwyr).';
$string['unicoderequired'] = 'Mae\'n ofynnol eich bod yn storio eich holl ddata ar fformat Unicode (UTF-8). Rhaid gosod fersiynau newydd mewn cronfeydd data sydd ag Unicode fel set nodau ddiofyn. Os ydych chi\'n uwchraddio, dylech gyflawni\'r broses mudo UTF-8 (gweler y dudalen Gweinyddwyr).';
$string['uninstallplugin'] = 'Dadosod';
$string['unlockaccount'] = 'Datgloi\'r cyfrif';
$string['unsettheme'] = 'Dadosod thema';
$string['unsupported'] = 'Anghymeradwy';
$string['unsuspenduser'] = 'Rhoi\'r cyfrif defnyddiwr ar waith';
$string['updateaccounts'] = 'Diweddaru cyfrifon presennol';
$string['updateautocheck'] = 'Chwilio\'n awtomatig am ddiweddariadau sydd ar gael';
$string['updateautocheck_desc'] = 'Os yw wedi’i alluogi, bydd eich safle’n chwilio’n awtomatig am ddiweddariadau sydd ar gael ar gyfer cod Moodle a phob ategyn ychwanegol. Os bydd diweddariad newydd ar gael, bydd hysbysiad yn cael ei anfon at weinyddwyr y safle.';
$string['updateautodeploy'] = 'Galluogi defnyddio diweddariadau';
$string['updateautodeploy_desc'] = 'Os yw wedi’i alluogi, bydd modd i chi osod a llwytho diweddariadau sydd ar gael i lawr yn uniongyrchol o dudalennau gweinyddu Moodle. Nodwch fod rhaid i broses eich gweinydd gwe gael hawl ysgrifennu i ffolderi gyda gosodiad Moodle er mwyn i hyn weithio. Mae modd gweld hyn fel risg diogelwch posibl.';
$string['updateavailable'] = 'Mae fersiwn diweddarach o Moodle ar gael!';
$string['updateavailabledetailslink'] = 'Ewch i {$a->url} i gael gwybod mwy';
$string['updateavailableforplugin'] = 'Mae fersiwn diweddarach o rai o\'ch ategion ar gael!';
$string['updateavailableinstall'] = 'Gosod y diweddaraid hwn';
$string['updateavailable_moreinfo'] = 'Mwy o wybodaeth...';
$string['updateavailablenot'] = 'Mae gennych y cod Moodle diweddaraf!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Fersiwn {$a}';
$string['updatecomponent'] = 'Diweddaru cydran';
$string['updateminmaturity'] = 'Aeddfedrwydd cod gofynnol';
$string['updateminmaturity_desc'] = 'Rhoi gwybod am ddiweddariadau sydd ar gael dim ond os oes gan y cod sydd ar gael y lefel ddewisol o aeddfedrwydd o leiaf. Mae diweddariadau ar gyfer ategion sydd ddim yn datgan lefel aeddfedrwydd eu cod yn cael eu cofnodi waeth beth yw’r gosodiad hwn.';
$string['updatenotificationfooter'] = 'Mae eich safle Moodle {$a->siteurl} wedi’i ffurfweddu i chwilio’n awtomatig am ddiweddariadau sydd ar gael. Rydych chi’n derbyn y neges hon fel gweinyddwr y safle. Mae modd i chi analluogi chwilio’n awtomatig am ddiweddariadau yn yr adran Gweinyddu safle yn y bloc Gosodiadau. Mae modd i chi addasu y dull o gyflwyno’r neges hon drwy eich gosodiad Negeseua personol yn yr adran Fy ngosodiadau proffil.';
$string['updatenotifications'] = 'Hysbysiadau diweddariadau';
$string['updatenotificationsubject'] = 'Mae diweddariadau Moodle ar gael ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Rhoi gwybod am luniadau newydd';
$string['updatenotifybuilds_desc'] = 'Os yw wedi’i alluogi, bydd y diweddariad sydd ar gael ar gyfer cod Moodle hefyd yn cael ei gofnodi pan fydd lluniad newydd ar gyfer y fersiwn gyfredol ar gael. Gwelliannau parhaus o unrhyw fersiwn o Moodle yw lluniadau. Yn gyffredinol, maent yn cael eu rhyddhau yn wythnosol. Os nad yw wedi\'i alluogi, bydd y diweddariad sydd ar gael yn cael ei gofnodi dim ond pan fydd fersiwn uwch o Moodle yn cael ei ryddhau. Dydy chwilio am ategion ddim yn cael ei effeithio gan y gosodiad hwn.';
$string['upgrade197notice'] = '<p>Mae Moodle 1.9.7 yn cynnwys nifer o atebion diogelwch ar gyfer cyfrineiriau defnyddwyr a chopïau wrth gefn er mwyn diogelu data defnyddwyr ar eich safle. O ganlyniad, efallai bydd rhai o\'ch gosodiadau a\'ch caniatâdau\'n ymwneud â chopïau wrth gefn wedi newid.<br />
Darllenwch <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">nodiadau fersiwn Moodle 1.9.7</a> i gael manylion llawn.</p>';
$string['upgrade197noticesubject'] = 'Hysbysiadau diogelwch uwchraddio Moodle 1.9.7';
$string['upgrade197salt'] = 'Er mwyn lleihau\'r perygl o ddwyn cyfrineiriau, rydym yn argymell yn gryf eich bod yn gosod cyfrinair ar hap.<br />Darllenwch y <a href="{$a}" target="_blank">dogfennau am gyfrineiriau ar hap</a> am fanylion.';
$string['upgradeerror'] = 'Gwall dieithr wrth uwchraddio {$a->plugin} i fersiwn {$a->version}. Does dim modd bwrw ymlaen.';
$string['upgradeforumread'] = 'Mae nodwedd newydd wedi\'i hychwanegu yn Moodle 1.5 i olrhain negeseuon a bostiwyd mewn fforymau sydd wedi/heb gael ei ddarllen.<br />I ddefnyddio\'r nodwedd hon, bydd angen i chi <a href="{$a}">ddiweddaru eich tablau</a>.';
$string['upgradeforumreadinfo'] = 'Mae nodwedd newydd wedi\'i hychwanegu yn Moodle 1.5 i olrhain negeseuon a bostiwyd mewn fforymau sydd wedi/heb gael ei ddarllen. I ddefnyddio\'r nodwedd hon, bydd angen i chi ddiweddaru eich tablau gyda\'r holl wybodaeth olrhain ar gyfer y negeseuon sy\'n bodoli eisoes. Gan ddibynnu ar faint eich safle, gall hyn gymryd cryn amser (oriau) a gall fod yn faich ar y gronfa ddata, felly mae\'n well gwneud hyn yn ystod cyfnod tawel. Fodd bynnag, bydd eich safle\'n dal i weithredu yn ystod yr uwchraddiad hwn, ac ni effeithir ar ddefnyddwyr. Ar ôl i chi gychwyn y broses hon, dylech adael iddi orffen (cadwch ffenestr eich porwr ar agor). Fodd bynnag, os stopiwch y broses drwy gau\'r ffenestr: peidiwch â phoeni, gallwch ailgychwyn.<br /><br />Ydych chi am gychwyn y broses uwchraddio nawr?';
$string['upgradelogs'] = 'Er mwyn i hyn weithio\'n llawn, mae angen uwchraddio eich hen gofnodion.  <a href="{$a}">Mwy o wybodaeth</a>';
$string['upgradelogsinfo'] = 'Gwnaed rhai newidiadau\'n ddiweddar i\'r ffordd y caiff cofnodion eu storio. I allu gweld eich hen gofnodion i gyd fesul-gweithgaredd, bydd angen uwchraddio eich hen gofnodion. Gan ddibynnu ar eich safle, gall hyn gymryd amser maith (e.e. nifer o oriau) a gall fod yn faich ar y gronfa ddata ar safleoedd mawr. Ar ôl i chi gychwyn y broses hon, dylech adael iddi orffen (drwy gadw ffenestr y porwr ar agor). Peidiwch â phoeni - bydd eich safle\'n gweithio\'n iawn i bobl eraill wrth i\'r cofnodion gael eu diweddaru.<br /><br />Ydych chi am ddiweddaru eich cofnodion nawr?';
$string['upgradepluginsfirst'] = 'Mae\'n rhaid i chi osod a lawrlwytho y diweddariadau sydd ar gael eich hun';
$string['upgradepluginsinfo'] = 'Diweddaru ategion';
$string['upgradepluginsinfo_help'] = 'Mae diweddariadau ar gael ar gyfer rhai o\'ch ategion. Dylech eu gosod i gyd cyn uwchraddio cronfa ddata Moodle. Os nad yw eich safle yn cefnogi defnyddio diweddariadau awtomatig, mae\'n rhaid i chi lawrlwytho a gosod fersiynau newydd o\'r ategion yn ei gweinydd eich hun.';
$string['upgradesettings'] = 'Gosodiadau newydd';
$string['upgradesettingsintro'] = 'Cafodd y gosodiadau a ddangosir isod eu hychwanegu y tro diwethaf i chi uwchraddio Moodle. Gwnewch unrhyw newidiadau angenrheidiol i\'r rhagosodiadau yna cliciwch "Cadw\'r gosodiadau" ar waelod y dudalen hon.';
$string['upgradestalefiles'] = 'Fersiynau cymysg o Moodle wedi\'u canfod, does dim modd bwrw ymlaen â\'r uwchraddio';
$string['upgradestalefilesinfo'] = 'Mae proses ddiweddaru Moodle wedi cael ei rhewi am fod sgriptiau PHP gan o leiaf dau brif fersiwn o Moodle wedi cael eu canfod yn nghyfeiriadur Moodle. Gall hyn achosi nifer o broblemau yn ddiweddarach, felly er mwyn bwrw ymlaen mae\'n rhaid i chi wneud yn siŵr mai dim ond ffeiliau ar gyfer fersiwn unigol o Moodle sydd wedi’u cynnwys yn y cyfeiriadur Moodle. Mae’r ffordd orau o lanhau eich cyfeiriadur Moodle fel a ganlyn: *ailenwch y cyfeiriadur Moodle presennol yn “moodle_old” * ewch ati i greu cyfeiriadur Moodle newydd yn cynnwys ffeiliau naill ai o lawrlwythiad pecyn Moodle safonol, neu o ystorfa Moodle Git yn unig * symudwch y ffeil config.php wreiddiol ac unrhyw ategion ansafonol o’r cyfeiriadur “moodle_old" i’r cyfeiriadur Moodle newydd. Pan fydd gennych gyfeiriadur Moodle glân, adnewyddwch y dudalen hon i ailgydio ym mhroses ddiweddaru Moodle. Mae’r rhybudd hwn yn cael ei achosi’n aml gan ddatgywasgu pecyn safonol Moodle dros fersiwn cynharach o Moodle. Tra bo hyn yn iawn ar gyfer uwchraddiadau bach, nid yw\'n cael ei argymell ar gyfer uwchraddiadau Moodle mawr. Gall y rhybudd hwn fod wedi\'i achosi hefyd gan dasg ddiweddaru neu benthyg anghyflawn o’r ystorfa Git, ac os felly efallai bydd rhaid i chi ddisgwyl i’r dasg gael ei chwblhau, neu redeg y gorchymyn glanhau priodol a rhoi cynnig arall ar y dasg. Mae mwy o wybodaeth yn y ddogfennaeth uwchraddio yn <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Uwchraddio cronfa ddata Moodle nawr';
$string['upgradesure'] = 'Mae\'ch ffeiliau Moodle wedi newid ac rydych ar fin uwchraddio eich gweinydd yn awtomatig i\'r fersiwn hwn: <br /><br />
<strong>{$a}</strong> <br /><br />
Ar ôl gwneud hyn, allwch chi ddim dychwelyd. <br /><br />
Cofiwch, gall y broses hon gymryd amser maith. <br /><br />
Ydych chi\'n siŵr eich bod am uwchraddio\'r gweinydd hwn i\'r fersiwn hwn?';
$string['upgradetimedout'] = 'Amser uwchraddio wedi dod i ben. Bydd angen i chi ailddechrau\'r broses uwchraddio.';
$string['upgradingdata'] = 'Uwchraddio data';
$string['upgradinglogs'] = 'Uwchraddio cofnodion';
$string['upgradingversion'] = 'Wrthi\'n uwchraddio i fersiwn newydd';
$string['upwards'] = 'i fyny';
$string['useblogassociations'] = 'Galluogi cysylltiadau';
$string['useexternalyui'] = 'Defnyddio llyfrgelloedd YUI ar-lein';
$string['user'] = 'Defnyddiwr';
$string['userbulk'] = 'Camau ar gyfer sawl defnyddiwr';
$string['userlist'] = 'Pori rhestr defnyddwyr';
$string['userpolicies'] = 'Polisïau defnyddiwr';
$string['userpreference'] = 'Hoff ddewisiadau defnyddiwr';
$string['userquota'] = 'Cwota defnyddiwr';
$string['users'] = 'Defnyddwyr';
$string['usesitenameforsitepages'] = 'Defnyddio enw\'r safle ar gyfer tudalennau\'r safle';
$string['usetags'] = 'Galluogi gweithredoedd tagiau';
$string['validateerror'] = 'Roedd y gwerth hwn yn annilys:';
$string['verifychangedemail'] = 'Cyfyngu ar y parthau wrth newid e-bost';
$string['warningcurrentsetting'] = 'Mae\'r gwerth presennol yn annilys: {$a}';
$string['warningiconvbuggy'] = 'Dydy eich fersiwn chi o\'r llyfrgell iconv ddim yn cefnogi\'r addasydd //IGNORE. Dylech osod yr estyniad mbstirng y mae modd ei ddefnyddio ar gyfer glanhau llinynnau sy\'n cynnwys nodau UTF-8 annilys.';
$string['webproxy'] = 'Dirprwy gwe';
$string['webproxyinfo'] = 'Llenwch y dewisiadau canlynol os nad yw eich gweinydd Moodle yn gallu mynd i\'r rhyngrwyd yn uniongyrchol. Rhaid cael mynediad i\'r rhyngrwyd er mwyn llwytho data amgylchedd, pecynnau iaith, crynodebau RSS, parthau amser, ayb. .<br /><em>Rydym yn argymell estyniad PHP cURL yn gryf.</em>';
$string['xmlrpcrecommended'] = 'Mae angen yr estyniad xmlrpc er mwyn cyfathrebu â\'r ganolfan, ac mae\'n ddefnyddiol ar gyfer gwasanaethau gwe a rhwydweithio Moodle';
$string['yuicomboloading'] = 'Wrthi\'n llwytho YUI cyfun';
$string['ziprequired'] = 'Mae angen yr estyniad Zip PHP ar Moodle nawr. Dydy\'r ffeiliau deuaidd info-ZIP na\'r llyfrgell PclZip ddim yn cael eu defnyddio mwyach.';
$string['zlibenabled'] = 'Wedi galluogi zlib';
