<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Première alerte';
$string['alert2'] = 'Deuxième alerte';
$string['alert3'] = 'Troisième alerte';
$string['alert_general'] = 'Annonce';
$string['alert_info'] = 'Information';
$string['alertsdesc'] = 'Ceci va afficher une alerte (ou plusieurs) dans trois différents styles à vos utilisateurs sur la page d\'accueil de Moodle. Pensez s\'il vous plaît à les désactiver lorsqu\'elles ne seront plus nécessaires.';
$string['alertsheading'] = 'Alertes utilisateur';
$string['alertsheadingsub'] = 'Affiche des messages importants à vos utilisateurs sur la page d\'accueil';
$string['alerttext'] = 'Texte de l\'alerte';
$string['alerttextdesc'] = 'Le texte que vous souhaitez afficher dans votre alerte';
$string['alerttitle'] = 'Titre';
$string['alerttitledesc'] = 'Titre/en-tête principal pour votre alerte';
$string['alerttype'] = 'Niveau';
$string['alerttypedesc'] = 'Définissez le juste niveau d\'alerte pour informer au mieux vos utilisateurs';
$string['alert_warning'] = 'Attention';
$string['allclasses'] = 'Toutes les classes';
$string['allcourses'] = 'Tous les cours';
$string['allmodules'] = 'Tous les modules';
$string['allunits'] = 'Toutes les unités';
$string['alternativecolors'] = 'Couleurs alternatives {$a}';
$string['alternativethemecolor'] = 'Couleur alternative de thème {$a}';
$string['alternativethemecolordesc'] = 'Quelle devraient-être les couleurs alternatives du thème {$a} ? Si activées et choisies par l\'utilisateur, elles remplaceront les couleurs par défaut du thème.';
$string['alternativethemecolorname'] = 'Nom de la variante du jeu de couleurs {$a}';
$string['alternativethemecolornamedesc'] = 'Fournissez un nom reconnaissable pour ce jeu alternatif de couleurs de thème';
$string['alternativethemecolors'] = 'Couleurs alternatives du thème';
$string['alternativethemecolorsdesc'] = 'Défini les couleurs alternatives du thème que l\'utilisateur pourrait choisir.';
$string['alternativethemehovercolor'] = 'Couleur alternative au survol du thème {$a}';
$string['alternativethemehovercolordesc'] = 'Quelle devrait-être la couleur alternative au survol du thème {$a} ? Si activée et choisie par l\'utilisateur, elle remplacera la couleur au survol par défaut du thème.';
$string['alternativethemename'] = 'Nom de la combinaison de couleurs';
$string['alternativethemenamedesc'] = 'Donnez un nom à vos couleurs alternatives de thème';
$string['alternativethemetextcolor'] = 'Couleur de texte alternatif {$a}';
$string['alternativethemetextcolordesc'] = 'Définissez la couleur de votre texte alternatif {$a}';
$string['alternativethemeurlcolor'] = 'Couleur de lien alternatif {$a}';
$string['alternativethemeurlcolordesc'] = 'Définissez la couleur de votre lien alternatif {$a}';
$string['alwaysdisplay'] = 'Toujours afficher';
$string['analytics'] = 'Analytics';
$string['analyticscleanurl'] = 'URLs simplifiées';
$string['analyticscleanurldesc'] = 'Générer une URL simplifiée au suivi avancé';
$string['analyticsdesc'] = 'Ici vous pouvez activer Google Analytics pour votre site Moodle. Vous aurez besoin de créer un compte gratuit sur le site Google Analytics ( <a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a> )';
$string['analyticsenabled'] = 'Activé';
$string['analyticsenableddesc'] = 'Activer analytics pour Moodle';
$string['analyticsguniversal'] = 'Google Universal analytics';
$string['analyticsheadingsub'] = 'Des outils analytiques puissants de Google';
$string['analyticsimagetrack'] = 'Suivi d\'images';
$string['analyticsimagetrackdesc'] = 'Activer le suivi d\'image pour les navigateurs avec JavaScript désactivé.';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'ID du site';
$string['analyticssiteiddesc'] = 'Entrez l\'ID de votre site';
$string['analyticssiteurl'] = 'URL d\'analytics';
$string['analyticssiteurldesc'] = 'Entrez l\'URL de votre "Piwik Analytics" sans http(s) ou une barre oblique. Par exemple "monsite.com/analytics".';
$string['analyticstrackadmin'] = 'Suivi des administrateurs';
$string['analyticstrackadmindesc'] = 'Activer le suivi des utilisateurs administrateurs (pas recommandé)';
$string['analyticstrackingid'] = 'ID su site';
$string['analyticstrackingiddesc'] = 'Entrez votre ID de suivi';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Indiquez l\'URL vers votre application pour mobiles sur le Google Play Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['backgroundstylefixed'] = 'Fixe';
$string['backgroundstylestretch'] = 'Étirée';
$string['backgroundstyletiled'] = 'Mosaïque';
$string['backtotop'] = 'Retour en haut de page';
$string['badgepreferences'] = 'Préférences de badge';
$string['blogpreferences'] = 'Préférences de blog';
$string['bootstrapcdn'] = 'Police Awesome de CDN';
$string['bootstrapcdndesc'] = 'Si activé, cela va charger la police Awesome à partir de la source CDN Bootstrap en ligne. Activez cette option si vous rencontrez des problèmes d\'affichage avec les icônes de la police Awesome sur votre site.';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'Style fil d\'Ariane';
$string['breadcrumbstyled'] = 'Fantaisie';
$string['breadcrumbstyledesc'] = 'Ici vous pouvez changer le style du fil d\'Ariane';
$string['breadcrumbstylednocollapse'] = 'Fantaisie pas réduite';
$string['breadcrumbthin'] = 'Fin';
$string['cachesused'] = 'Mise en cache utilisée';
$string['categoryiconcategory'] = 'L\'icône de la catégorie : {$a->category}.';
$string['categoryicondesc'] = 'Si activé, ceci vous permettra de définir des icônes pour chaque catégorie de cours.';
$string['categoryiconheading'] = 'Affichage d\'icône basé sur la catégorie';
$string['categoryiconheadingsub'] = 'Utilisez des icônes pour illustrer vos catégories';
$string['categoryiconinfo'] = 'Définissez des icônes de catégorie personnalisées';
$string['categoryiconinfodesc'] = 'Chaque icône est définie par son "category ID". Vous les obtenez en regardant l\'URL de chaque catégorie.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2> Essential </h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg" />
</p>
</div>
<div class="well">
<h3>À propos de Essential</h3>
<p>Essential est un thème Bootstrap modifié de Moodle qui hérite des styles et des moteurs de rendus de son thème parent.</p>
<h3>Parents</h3>
<p>Ce thème est basé sur le thème Bootstrap, qui a été créé pour Moodle 2.5, avec l\'aide de :<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans. </p>
<h3>Crédits du thème</h3>
<p>Auteurs : Julian Ridden <br>
Contact : julian@moodleman.net<br>
Site Web : <a href="http://www.moodleman.net">www.moodleman.net</a> </p>
</div></div>';
$string['colordesc'] = 'Ici vous pouvez trouver différents réglages pour changer de nombreuses couleurs présentes dans ce thème.';
$string['colorheading'] = 'Paramètres des couleurs';
$string['colorheadingsub'] = 'Définissez les couleurs utilisées dans votre thème';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Coordonnées';
$string['contactinfodesc'] = 'Entrez vos coordonnées';
$string['copyright'] = 'Droits d\'auteur';
$string['copyrightdesc'] = 'Le nom de votre organisation';
$string['coursegrades'] = 'Notes de cours';
$string['customcss'] = 'CSS personnalisées';
$string['customcssdesc'] = 'Toutes les règles CSS que vous ajoutez à cette zone de texte seront reflétées dans chaque page, ce qui rend plus facile la personnalisation de ce thème.';
$string['dbqueries'] = 'BD Lire/Ecrire';
$string['defaultcategoryicon'] = 'Icônes de catégorie par défaut';
$string['defaultcategoryicondesc'] = 'Définissez une icône de catégorie par défaut';
$string['defaultcolors'] = 'Couleurs par défaut';
$string['displayafterlogin'] = 'Afficher après authentification uniquement';
$string['displaybeforelogin'] = 'Afficher avant authentification uniquement';
$string['displaymycourses'] = 'Afficher les cours des utilisateurs';
$string['displaymycoursesdesc'] = 'Afficher les cours des utilisateurs dans le menu personnalisé';
$string['donate_desc'] = '{$a->url}  afin de permettre au développement d\'Essential de continuer, ou pour simplement exprimer votre gratitude.';
$string['donate_desc2'] = 'pour permettre au développement d\'Essential de continuer, ou simplement d\'exprimer votre gratitude.';
$string['donate_title'] = 'Dons pour Essential';
$string['dontdisplay'] = 'Ne jamais afficher';
$string['enablealert'] = 'Activer l\'alerte';
$string['enablealertdesc'] = 'Active ou désactive les alertes';
$string['enablealternativethemecolors'] = 'Activer les couleurs alternatives de thème {$a}';
$string['enablealternativethemecolorsdesc'] = 'Si activé, l\'utilisateur pourra choisir des couleurs alternatives pour le thème {$a}.';
$string['enablecategoryicon'] = 'Activer les icônes de catégorie';
$string['enablecategoryicondesc'] = 'Si activé, vous serez en mesure de choisir des icônes de catégorie après avoir cliqué sur « Enregistrer les modifications ».';
$string['enablecustomcategoryicon'] = 'Activer les icônes de catégorie';
$string['enablecustomcategoryicondesc'] = 'Si ce réglage est activé, vous verrez sous cette section chaque catégorie avec une option personnalisable. Pensez à enregistrer après activation ou désactivation de cette option.';
$string['extperfinfoheading'] = 'Information de performance étendue';
$string['facebook'] = 'URL Facebook';
$string['facebookdesc'] = 'Entrez l\'URL de votre page Facebook. (ex. http://www.facebook.com/mycollege)';
$string['few'] = 'Un peu';
$string['fitvids'] = 'Utiliser FitVids';
$string['fitvidsdesc'] = 'Activer FitVids (fitvidsjs.com) pour rendre votre vidéos adaptatives. Si FitVids est activé et que vous voulez exclure une vidéo, il faut ajouter "class =" fitvidsignore "» au tag «iframe \' dans le mode HTML de l\'éditeur. Par exemple: \'iframe class = largeur "de fitvidsignore" = "420" height = "315" src = "// www.youtube.com/embed/enmEmym85xc" frameborder = "0" allowfullscreen = ""> </iframe\'.';
$string['fixedwidthnarrow'] = 'Largeur fixe - Rapproché';
$string['fixedwidthnormal'] = 'Largeur fixe - Normal';
$string['fixedwidthwide'] = 'Largeur fixe - Large';
$string['flattr_click'] = 'donner via Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'URL Flickr';
$string['flickrdesc'] = 'Entrez l\'URL de votre page Flickr. (ex. http://www.flickr.com/mycollege)';
$string['fontcharacterset'] = 'Jeu de caractères Google additionnel';
$string['fontcharactersetcyrillic'] = 'Cyrillique';
$string['fontcharactersetcyrillicext'] = 'Cyrillique étendu';
$string['fontcharactersetdesc'] = 'Choisissez des jeux de caractères supplémentaires pour les différentes langues. L\'utilisation de nombreux jeux de caractères peuvent ralentir votre Moodle, il faut donc faire en sorte de sélectionner les jeux de caractères dont vous avez réellement besoin.';
$string['fontcharactersetgreek'] = 'Grec';
$string['fontcharactersetgreekext'] = 'Grec étendu';
$string['fontcharactersetlatinext'] = 'Latin étendu';
$string['fontcharactersetvietnamese'] = 'Vietnamien';
$string['fontfileeotbody'] = 'Fichier de police EOT Corps de texte';
$string['fontfileeotheading'] = 'Fichier de police EOT Titres';
$string['fontfileotfbody'] = 'Fichier de police OTF Corps de texte';
$string['fontfileotfheading'] = 'Fichier de police OTF Titres';
$string['fontfiles'] = 'Fichiers de police';
$string['fontfilesdesc'] = 'Déposez vos fichiers de police ici.';
$string['fontfilesvgbody'] = 'Fichier de police SVG Corps de texte';
$string['fontfilesvgheading'] = 'Fichier de police SVG Titres';
$string['fontfilettfbody'] = 'Fichier de police TTF Corps de texte';
$string['fontfilettfheading'] = 'Fichier de police TTF Titres';
$string['fontfilewoffbody'] = 'Fichier de police WOFF Corps de texte';
$string['fontfilewoffheading'] = 'Fichier de police WOFF';
$string['fontfilewofftwobody'] = 'Fichier de police WOFF Corps de texte';
$string['fontfilewofftwoheading'] = 'Fichier de police WOFF Titres';
$string['fontheadingdesc'] = 'Sélectionnez et entrez les polices que vous souhaitez utiliser dans votre environnement Moodle.';
$string['fontheadingsub'] = 'Réglages de la police';
$string['fontnamebody'] = 'Police du texte';
$string['fontnamebodydesc'] = 'Entrez le nom exact de la police à utiliser pour tous les autres textes.';
$string['fontnameheading'] = 'Police de titre';
$string['fontnameheadingdesc'] = 'Entrez le nom exact de la police à utiliser pour les titres.';
$string['fontselect'] = 'Sélecteur de police';
$string['fontselectdesc'] = 'Choisissez dans la liste des polices disponibles. Vous pouvez choisir ici de désactiver les polices Google si nécessaire.';
$string['fontsettings'] = 'Police';
$string['fonttypecustom'] = 'Police personnalisée';
$string['fonttypegoogle'] = 'Police web Google';
$string['fonttypestandard'] = 'Polices standard';
$string['footercolor'] = 'Couleur de fond du pied de page';
$string['footercolordesc'] = 'Régler la couleur de fond de la boîte du pied de page.';
$string['footercolors'] = 'Couleurs du pied-de-page';
$string['footercolorsdesc'] = 'Changer les couleurs du pied de page';
$string['footerheading'] = 'Pied de page';
$string['footerheadingcolor'] = 'Couleur des titres dans le pied de page';
$string['footerheadingcolordesc'] = 'Définissez la couleur des titres pour les blocs dans le pied de page.';
$string['footerhovercolor'] = 'Couleur au survol dans le pied de page';
$string['footerhovercolordesc'] = 'Définissez la couleur des hyperliens au survol de la souris.';
$string['footersepcolor'] = 'Couleur du séparateur dans le pied de page';
$string['footersepcolordesc'] = 'Les séparateurs sont des lignes utilisées pour séparer le contenu. Réglez leur couleur ici.';
$string['footertextcolor'] = 'Couleur du texte du pied de page';
$string['footertextcolordesc'] = 'Définissez la couleur de votre texte dans le pied de page';
$string['footerurlcolor'] = 'Couleur des liens dans le pied de page';
$string['footerurlcolordesc'] = 'Définissez la couleur de vos hyperliens dans le pied de page.';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Le texte ajouté dans cette zone de texte sera affiché dans le pied de page sur tout votre site Moodle.';
$string['frontcontent'] = 'Activer la zone de contenu de la page d\'accueil';
$string['frontcontentarea'] = 'Contenu de la page d\'accueil';
$string['frontcontentareadesc'] = 'Tout ce qui est écrit dans cette zone de texte sera affiché sur toute la largeur de la page entre le diaporama et les annonces marketing';
$string['frontcontentdesc'] = 'Ceci ajoute un contenu personnalisé entre le diaporama et les annonces marketing';
$string['frontcontentheading'] = 'Réglages de la page d\'accueil';
$string['frontpageblocks'] = 'Alignement des blocs de la page d\'accueil';
$string['frontpageblocksdesc'] = 'Choisir l\'alignement (à droite ou à gauche) des blocs de la page d\'accueil';
$string['frontpageblocksheading'] = 'Blocs de la page d\'accueil';
$string['frontpageheading'] = 'Page d\'accueil';
$string['frontpageheadingdesc'] = 'Configurez ici quels éléments additionnels vous voulez afficher sur la page d\'accueil.';
$string['frontpagemiddleblocks'] = 'Activer les blocs dans la zone centrale';
$string['frontpagemiddleblocksdesc'] = 'Si cette option est activée, vous pourrez utiliser 3 nouveaux emplacements de blocs juste sous les spots de marketing';
$string['fullname'] = 'Nom complet du site';
$string['fullnamesummary'] = 'Nom complet et résumé';
$string['generalheadingdesc'] = 'Configurez les paramètres globaux du thème sur cette page. Vous y trouverez aussi bien des options de mise en page que visuelles.';
$string['generalheadingsub'] = 'Paramètres généraux';
$string['genericsettings'] = 'Paramètres généraux';
$string['googleplus'] = 'URL Google+';
$string['googleplusdesc'] = 'Entrez l\'URL de votre profil Google+. (ex. http://plus.google.com/107817105228930159735)';
$string['headerheading'] = 'En-tête';
$string['headertitle'] = 'Titre de l\'en-tête';
$string['helplink'] = 'Lien d\'aide';
$string['helplinkdesc'] = 'Si vous avez choisi URL ci-dessus, renseignez l\'URL complète vers votre site d\'aide (doit inclure http:// ou https://). Si vous avez choisi adresse de courriel, renseignez la.';
$string['helplinktype'] = 'Activez le lien d\'aide dans le menu';
$string['helplinktypedesc'] = 'Choisissez si vous souhaitez activer une option d\'aide dans le menu de l\'utilisateur. Vous pouvez choisir de fournir une URL qui sera ouverte dans une nouvelle fenêtre ou une adresse e-mail.';
$string['hideonphone'] = 'Diaporama sur les mobiles';
$string['hideonphonedesc'] = 'Choisissez si vous souhaitez que le diaporama s\'affiche sur les mobiles ou non';
$string['hideontablet'] = 'Cacher le diaporama sur les tablettes';
$string['hideontabletdesc'] = 'Choisissez si vous souhaitez désactiver le diaporama sur les tablettes.';
$string['included'] = 'Fichiers inclus';
$string['instagram'] = 'URL Instagram';
$string['instagramdesc'] = 'Entrez l\'URL de votre page Instagram. (ex. http://instagram.com/mycollege)';
$string['ios'] = 'iPhone/iPad/iPod Touch (App Store)';
$string['iosdesc'] = 'Indiquez l\'URL vers votre application pour mobiles sur le App Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['iosicon'] = 'Icônes d\'écran d\'accueil iOS';
$string['iosicondesc'] = 'Le thème fournit une icône par défaut pour les écrans d\'accueil d\'iOS et Android. Vous pouvez déposer vos icônes personnalisées si vous le souhaitez.';
$string['ipadicon'] = 'Icône iPad (Non Retina)';
$string['ipadicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 72 px par 72 px';
$string['ipadretinaicon'] = 'Icône iPad (Retina)';
$string['ipadretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 144 px par 144 px';
$string['iphoneicon'] = 'Icône iPhone/iPod Touch (Non Retina)';
$string['iphoneicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 57 px par 57 px';
$string['iphoneretinaicon'] = 'Icône iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 114 px par 114 px';
$string['layout'] = 'Utilisez une disposition de cours standard';
$string['layoutdesc'] = 'Ce thème est conçu pour mettre les deux colonnes de blocs sur le côté. Si vous préférez la disposition standard des cours Moodle, vous pouvez cocher cette case et retourner à l\'ancienne et ennuyeuse disposition en trois colonnes.';
$string['left'] = 'Gauche';
$string['linkedin'] = 'URL LinkdIn';
$string['linkedindesc'] = 'Entrez l\'URL de votre profil LinkedIn. (ex. http://www.linkedin.com/company/mycollege)';
$string['loadtime'] = 'Temps de chargement';
$string['loggedinas'] = 'Connecté en tant que';
$string['loggedinfrom'] = 'Connecté depuis';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Déposez votre logo personnalisé ici si vous voulez l\'ajouter à l\'en-tête. <br> Si vous déposez un logo, il remplacera l\'icône standard et le nom qui a été affiché par défaut.';
$string['marketing1'] = 'Annonce marketing Une - Titre';
$string['marketing2'] = 'Annonce marketing Deux - Titre';
$string['marketing3'] = 'Annonce marketing Trois - Titre';
$string['marketingbuttontext'] = 'Texte du lien';
$string['marketingbuttontextdesc'] = 'Texte à afficher sur le bouton';
$string['marketingbuttonurl'] = 'Lien URL';
$string['marketingbuttonurldesc'] = 'URL vers laquelle le bouton va pointer';
$string['marketingcontent'] = 'Contenu';
$string['marketingcontentdesc'] = 'Contenu à afficher dans l\'annonce marketing. Gardez le court et concis.';
$string['marketingdesc'] = 'Ce thème offre la possibilité d\'activer trois annonces "marketing" ou "spots publicitaires" juste sous le diaporama. Elles vous permettent d\'afficher facilement les informations essentielles à vos utilisateurs et fournissent des liens directs.';
$string['marketingheading'] = 'Annonces marketing';
$string['marketingheadingsub'] = 'Trois emplacements sur la première page pour ajouter des informations et des liens';
$string['marketingheight'] = 'Hauteur des images marketing';
$string['marketingheightdesc'] = 'Si vous souhaitez afficher des images dans les annonces marketing, vous pouvez spécifier leur hauteur ici.';
$string['marketingicon'] = 'Icône';
$string['marketingicondesc'] = 'Nom de l\'icône que vous souhaitez utiliser. La liste est <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a>. Il suffit d\'entrer ce qui est après le "icon-".';
$string['marketingimage'] = 'Image';
$string['marketingimagedesc'] = 'Ceci donne la possibilité d\'afficher une image au-dessus du texte dans l\'annonce marketing';
$string['marketinginfodesc'] = 'Entrez les réglages de votre annonce marketing.';
$string['marketingtitle'] = 'Titre';
$string['marketingtitledesc'] = 'Titre à afficher dans cette annonce marketing';
$string['marketingurltarget'] = 'Cible du lien';
$string['marketingurltargetdesc'] = 'Choisissez comment le lien doit être ouvert';
$string['marketingurltargetnew'] = 'Nouvelle page';
$string['marketingurltargetparent'] = 'Cadre parent';
$string['marketingurltargetself'] = 'Page actuelle';
$string['memused'] = 'Mémoire utilisée';
$string['messagepreferences'] = 'Notification des messages';
$string['mobileappsdesc'] = 'Avez-vous une web app sur l\'App Store ou Google Play Store ? Fournissez un lien ici afin que vos utilisateurs puissent se procurer l\'application en ligne';
$string['mobileappsheading'] = 'Apps pour mobiles';
$string['mobileappsheadingsub'] = 'Lien vers votre application pour vos étudiants qui utilisent des mobiles';
$string['myclasses'] = 'Mes classes';
$string['mycourses'] = 'Mes cours';
$string['mycoursesinfo'] = 'Liste dynamique des cours des utilisateurs';
$string['mycoursesinfodesc'] = 'Affiche une liste dynamique des cours des utilisateurs.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Changer la terminologie pour le lien "Mes cours" dans le menu déroulant';
$string['mygrades'] = 'Mes notes';
$string['mymodules'] = 'Mes modules';
$string['myunits'] = 'Mes unités';
$string['navbartitle'] = 'Titre de la barre de navigation';
$string['navbartitledesc'] = 'Configurez ici le titre à afficher dans la barre de navigation';
$string['nextsection'] = 'Section suivante';
$string['nobreadcrumb'] = 'Cacher';
$string['noenrolments'] = 'Vous n\'avez pas de cours actuellement';
$string['nomessagesfound'] = 'Aucun message n\'a été trouvé';
$string['noslidetitle'] = 'Pas de titre pour la diapositive {$a->slide}';
$string['notitle'] = 'Pas de titre';
$string['numberofslides'] = 'Nombre de diapositives';
$string['numberofslides_desc'] = 'Nombre de diapositives dans le diaporama';
$string['oldnavbar'] = 'Utiliser l\'ancienne position de la barre de navigation';
$string['oldnavbardesc'] = 'Activez cette option pour utiliser l\'ancienne position de la barre de navigation';
$string['pagebackground'] = 'Image de fond de la page';
$string['pagebackgrounddesc'] = 'Déposez votre propre image de fond. Elle sera appliquée en arrière-plan sur toutes les pages. Si rien n\'est déposé, une image par défaut est utilisée.';
$string['pagebackgroundstyle'] = 'Style du fond de page';
$string['pagebackgroundstyledesc'] = 'Sélectionnez le style de l\'image téléchargée.';
$string['pagewidth'] = 'Largeur de page';
$string['pagewidthdesc'] = 'Choisissez parmi la liste de largeurs de page disponibles pour votre site';
$string['peakmem'] = 'Pic de mémoire';
$string['perfinfo'] = 'Mode d\'indications de performance';
$string['perfinfodesc'] = 'De nombreux sites n\'ont pas besoin d\'indications de performance entièrement détaillées. Surtout vu du côté utilisateurs. Lorsqu\'il est activé, il montre un formulaire simplifié avec des informations de base de chargement de la page.';
$string['perfinfoheading'] = 'Information de performance';
$string['perf_max'] = 'Détaillé';
$string['perf_min'] = 'Minimal';
$string['pinterest'] = 'URL Pinterest';
$string['pinterestdesc'] = 'Entrez l\'URL de votre page Pinterest. (ex. http://pinterest.com/mycollege)';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Section précédente';
$string['profilebarcustomtitle'] = 'Titre du bloc personnalisé de la barre de profil';
$string['profilebarcustomtitledesc'] = 'Titre du bloc personnalisé de la barre de profil';
$string['readme_click'] = 'Cliquez sur README.txt';
$string['readme_desc'] = '{$a->url} pour plus d\'informations sur le thème Essential.';
$string['readme_title'] = 'Lisez-moi Essential.';
$string['readmore'] = 'Lire la suite';
$string['region-footer-left'] = 'Pied de page (gauche)';
$string['region-footer-middle'] = 'Pied de page (centre)';
$string['region-footer-right'] = 'Pied de page (droite)';
$string['region-hidden-dock'] = 'Caché aux utilisateurs';
$string['region-home-left'] = 'Accueil (gauche)';
$string['region-home-middle'] = 'Accueil (centre)';
$string['region-home-right'] = 'Accueil (droite)';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Gauche';
$string['right'] = 'Droite';
$string['serverload'] = 'Charge du serveur';
$string['sessionsize'] = 'Taille de la session';
$string['shortname'] = 'Nom court du site';
$string['shortnamesummary'] = 'Nom court et résumé';
$string['siteicon'] = 'Icône du site';
$string['siteicondesc'] = 'Vous n\'avez pas de logo ? Entrez le nom de l\'icône que vous souhaitez utiliser. La liste est ici <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a>. Il suffit d\'entrer ce qui est après le "icon-".';
$string['skype'] = 'Compte Skype';
$string['skypedesc'] = 'Entrez le nom d\'utilisateur Skype du compte de votre organisation';
$string['slidebuttoncolor'] = 'Couleur du bouton du diaporama';
$string['slidebuttoncolordesc'] = 'Couleur du bouton de la diapo « En savoir plus »';
$string['slidebuttonhovercolor'] = 'Couleur du bouton de diapositive';
$string['slidebuttonhovercolordesc'] = 'La couleur que devrait avoir le bouton de navigation de diapositive au survol.';
$string['slidecaption'] = 'Légende de la diapositive';
$string['slidecaptionbelow'] = 'Légende de la diapositive sous l\'image';
$string['slidecaptionbelowdesc'] = 'Indique si la légende du diaporama doit être sous l\'image';
$string['slidecaptioncentred'] = 'Légende de la diapositive centrée';
$string['slidecaptioncentreddesc'] = 'Si la légende de la diapositive devrait être centrée';
$string['slidecaptiondesc'] = 'Entrez le texte de la légende à utiliser pour la première diapositive';
$string['slidecolor'] = 'Couleur du texte du diaporama';
$string['slidecolordesc'] = 'Quelle couleur devrait avoir le texte principal sur le côté.';
$string['slideimage'] = 'Image de la diapositive';
$string['slideimagedesc'] = 'L\'image s\'affiche mieux si elle est transparente. (Les dimensions de l\'image devraient être de 256 px par 256 px)';
$string['slideinterval'] = 'Intervalle entre les diapositives';
$string['slideintervaldesc'] = 'Intervalle de transition des diapositives en millisecondes.';
$string['slideno'] = 'Diapositive {$a->slide}';
$string['slidenodesc'] = 'Entrez les paramètres de la diapositive {$a->slide}.';
$string['slideshowdesc'] = 'Ceci crée un diaporama dynamique avec jusqu\'à seize diapositives pour vous permettre de promouvoir des éléments importants de votre site. Le diaporama est adaptatif par le fait que la hauteur d\'image se règle selon la taille de l\'écran. La hauteur recommandée est de 300px. La largeur est fixée à 100% et donc la hauteur réelle sera plus faible si la largeur est supérieure à la taille de l\'écran. Avec les petites tailles d\'écran la hauteur est réduite dynamiquement sans la nécessité de fournir des images séparées. Pour des largeurs d\'écran <= 767px 165px de hauteur, largeur entre 768px et 979px 225px = hauteur et la largeur> = 980px 300px de hauteur. Si aucune image n\'est sélectionnée pour une diapositive, alors l\'image par default dans le dossier pix est utilisée.';
$string['slideshowheading'] = 'Diaporama de la page d\'accueil';
$string['slideshowheadingsub'] = 'Diaporama dynamique pour la page d\'accueil';
$string['slidetitle'] = 'Titre de la diapositive';
$string['slidetitledesc'] = 'Entrez un titre descriptif pour votre diapositive';
$string['slideurl'] = 'Lien de la diapositive';
$string['slideurldesc'] = 'Entrez la cible du lien de l\'image de la première diapositive';
$string['slideurltarget'] = 'Cible du lien';
$string['slideurltargetdesc'] = 'Choisissez comment le lien doit être ouvert';
$string['slideurltargetnew'] = 'Nouvelle page';
$string['slideurltargetparent'] = 'Cadre parent';
$string['slideurltargetself'] = 'Page actuelle';
$string['socialdesc'] = 'Fournir des liens directs vers les réseaux sociaux essentiels qui font de la publicité pour votre site. Ceux-ci apparaissent dans l\'en-tête de chaque page.';
$string['socialheading'] = 'Réseautage social';
$string['socialheadingsub'] = 'Motivez vos utilisateurs avec les réseaux sociaux';
$string['socialnetworks'] = 'Réseaux sociaux';
$string['themecolor'] = 'Couleur du thème';
$string['themecolordesc'] = 'La couleur que votre thème devrait avoir. Ceci va changer de multiples composants pour produire la couleur que vous souhaitez sur le site Moodle';
$string['themecolors'] = 'Couleurs du thème';
$string['themehovercolor'] = 'Couleur de survol du thème';
$string['themehovercolordesc'] = 'La couleur que prennent les éléments survolés sur votre site. Ceci concerne les liens, les menus, etc.';
$string['themeiconcolor'] = 'Couleur d\'icône';
$string['themeiconcolordesc'] = 'Définir la couleur pour toutes les icônes';
$string['themenavcolor'] = 'Couleur de la navigation';
$string['themenavcolordesc'] = 'Définissez la couleur pour la navigation.  En l\'occurrence la barre de menus et le style fantaisie du fil d\'Ariane .';
$string['themetextcolor'] = 'Couleur du texte';
$string['themetextcolordesc'] = 'Définissez la couleur de votre texte.';
$string['themeurlcolor'] = 'Couleur du lien';
$string['themeurlcolordesc'] = 'Définissez la couleur de votre lien textuel';
$string['togglemarketing'] = 'Bascule de l\'affichage des annonces marketing';
$string['togglemarketingdesc'] = 'Choisissez si vous souhaitez afficher ou masquer les trois annonces marketing.';
$string['toggleslideshow'] = 'Bascule de l\'affichage du diaporama';
$string['toggleslideshowdesc'] = 'Choisissez si vous souhaitez afficher ou masquer le diaporama.';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Entrez l\'URL de votre flux Twitter. (ex. http://www.twitter.com/mycollege)';
$string['unreadnewnotification'] = 'Nouvelle notification';
$string['usecategoryicon'] = 'Activer les icônes de catégorie';
$string['usecategoryicondesc'] = 'Utiliser des icônes personnalisées pour les catégories';
$string['variablewidth'] = 'Largeur variable';
$string['visibleadminonly'] = 'Les blocs déplacés dans la zone ci-dessous ne seront visibles que par les administrateurs';
$string['vk'] = 'URL VKontakte';
$string['vkdesc'] = 'Entrez l\'URL de la page Vkontakte. (ex. http://www.vk.com/mycollege)';
$string['website'] = 'URL du site Web';
$string['websitedesc'] = 'Entrez l\'URL de votre propre site. (ex. http://www.pukunui.com)';
$string['windows'] = 'Bureau Windows';
$string['windowsdesc'] = 'Fournissez une URL vers votre application mobile sur Windows Store. Si vous n\'en disposez pas, vous pouvez peut-être envisager de faire un lien vers l\'application officielle Moodle Mobile. (Http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Fournissez une URL vers votre application mobile sur Windows Store. Si vous n\'en disposez pas, vous pouvez peut-être envisager de faire un lien vers l\'application officielle  (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['youtube'] = 'URL Youtube';
$string['youtubedesc'] = 'Entrez l\'URL de votre chaîne YouTube. (ex. http://www.youtube.com/mycollege)';
