<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   offlinequiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Ajouter';
$string['addaquestion'] = 'Ajouter une question...';
$string['addarandomquestion'] = 'Ajouter question aléatoire';
$string['addarandomquestion_help'] = 'Moodle ajoute une sélection aléatoire de questions à choix multiple (ou questions à choix multiple tout ou rien) au groupe de test hors-ligne courant. Le nombre de questions ajouté peut être choisi. Les questions sont choisies dans la catégorie courante (et ses sous catégories si cette option est sélectionnée).';
$string['addlist'] = 'Ajouter une liste';
$string['addnewpagesafterselected'] = 'Ajouter de nouvelles pages après les questions sélectionnées';
$string['addnewquestionsqbank'] = 'Ajouter des questions à la catégorie {$a->catname} : {$a->link}';
$string['addnewuseroverride'] = 'Ajouter une dérogation d\'utilisateur';
$string['addpagehere'] = 'Ajouter une page ici';
$string['addparts'] = 'Ajouter des participants';
$string['addrandom'] = 'Ajouter {$a} question(s) à choix multiples aléatoires';
$string['addrandomfromcategory'] = 'Ajouter des questions aléatoires depuis la catégorie';
$string['addtoofflinequiz'] = 'Ajouter au test hors-ligne';
$string['addtoqueue'] = 'Ajouter à la file d\'attente';
$string['allinone'] = 'Illimité';
$string['alllists'] = 'Toutes les listes';
$string['allresults'] = 'Afficher tous les résultats';
$string['allstudents'] = 'Afficher tous les étudiants';
$string['alwaysavailable'] = 'Toujours disponible';
$string['analysis'] = 'Analyse des éléments';
$string['answerform'] = 'Grille de réponses';
$string['answerformforgroup'] = 'Grille de réponses pour le groupe {$a}';
$string['answerpdfxy'] = 'Grille pour les réponses ({$a}->maxquestions questions / {$a}->maxanswers options)';
$string['areyousureremoveselected'] = 'Êtes-vous sûr de vouloir supprimer toutes les questions sélectionnées ?';
$string['attemptexists'] = 'Des tentatives existent';
$string['attemptsexist'] = 'Vous ne pouvez plus ajouter ou supprimer de question.';
$string['attemptsnum'] = 'Résultats : {$a}';
$string['attemptsonly'] = 'Afficher uniquement les étudiants ayant des résultats';
$string['attendances'] = 'Présences';
$string['basicideasofofflinequiz'] = 'Les concepts de base pour créer des tests hors-ligne';
$string['bulksavegrades'] = 'Enregistrer les notes';
$string['calibratescanner'] = 'Calibrer le scanner';
$string['cannoteditafterattempts'] = 'Vous ne pouvez plus ajouter ou supprimer de question car il y a déjà des résultats complets. ({$a})';
$string['category'] = 'Catégorie';
$string['changed'] = 'Le résultat a été modifié.';
$string['checkparts'] = 'Marquer les participants sélectionnés présents';
$string['checkuserid'] = 'Vérifier groupe/numéro d\'identification';
$string['chooseagroup'] = 'Choisissez un groupe...';
$string['closebeforeopen'] = 'Impossible de modifier le test hors-ligne : vous avez indiqué une date de fermeture antérieure à la date d\'ouverture du test.';
$string['closestudentview'] = 'Fermer la vue étudiante';
$string['closewindow'] = 'Fermer la fenêtre';
$string['cmmissing'] = 'Le module-cours pour le test hors-ligne avec l\'identifiant {$a} est manquant';
$string['configdecimalplaces'] = 'Le nombre de chiffres à afficher après la virgule lors de l\'affichage des notes du test.';
$string['configintro'] = 'Les valeurs indiquées ici définissent les valeurs utilisées par défaut lors de la création d\'un test hors-ligne.';
$string['configkeepfilesfordays'] = 'Conbien de jours les fichiers téléchargés sont conservés dans l\'espace temporaire de stockage. Durant ce temps les images scannées sont disponibles lors de la relecture du test hors-ligne.';
$string['configonlylocalcategories'] = 'Les questions partagées ne sont pas autorisées.';
$string['configpapergray'] = 'Niveau de blanc du papier';
$string['configshuffleanswers'] = 'Mélanger les réponses';
$string['configshufflequestions'] = 'Si cette option est activée, l\'ordre des questions des groupes de tests hors-ligne sera déterminé aléatoirement lors de chaque création de l\'aperçu dans l\'onglet \'Formulaires PDF\'.';
$string['configshufflewithin'] = 'Si vous activez cette option, alors les parties constituant une question seront mélangées aléatoirement lorsque la feuille de questions et les grilles de réponses sont créées.';
$string['configuseridentification'] = 'Une formule décrivant la manière d\'identifier les utilisateurs. Cette formule est utilisée pour attribuer les grilles de réponses aux utilisateurs dans le système.';
$string['copy'] = 'Copier';
$string['copyright'] = '<strong>Attention : Le contenu de cette page est uniquement destiné à votre information personnelle. Comme tout autre texte les questions sont soumises à des restrictions de copyright. Vous n\'êtes pas autorisé à les copier ou à les communiquer à d\'autres personnes!</strong>';
$string['copyselectedtogroup'] = 'Ajouter les questions sélectionnées au groupe : {$a}';
$string['copytogroup'] = 'Ajouter toutes les questions au groupe : {$a}';
$string['correct'] = 'correct';
$string['correcterror'] = 'corriger';
$string['correctforgroup'] = 'réponses correctes pour le groupe {$a}';
$string['correctionoptionsheading'] = 'Options de correction.';
$string['correctupdated'] = 'Formulaire de correction mis à jour pour le groupe {$a}.';
$string['couldnotgrab'] = 'Saisie de l\'image {$a} impossible';
$string['couldnotregister'] = 'Enregistrement de l\'utilisateur {$a} impossible';
$string['createlistfirst'] = 'Ajouter des participants';
$string['createofflinequiz'] = 'Créer les formulaires';
$string['createpartpdferror'] = 'Le formulaire PDF pour la liste des participants {$a} n\'a pas pu être créé. La liste est peut-être vide.';
$string['createpdf'] = 'Formulaire PDF';
$string['createpdferror'] = 'Le formulaire pour le groupe {$a} n\'a pas pu être créé. Il est possible qu\'il n\'y ait pas de question pour ce groupe.';
$string['createpdffirst'] = 'Créer la liste PDF d\'abord';
$string['createpdfforms'] = 'Créer les formulaires';
$string['createpdfs'] = 'Formulaires PDF';
$string['createpdfsparticipants'] = 'Formulaires PDF pour la liste des participants';
$string['createquestionandadd'] = 'Créer une nouvelle question et l\'ajouter au test.';
$string['createquiz'] = 'Créer les formulaires';
$string['csvfile'] = 'Fichier CSV';
$string['CSVformat'] = 'Format CSV';
$string['CSVplus1format'] = 'Format CSV (données brutes)';
$string['darkgray'] = 'Gris sombre';
$string['datanotsaved'] = 'Impossible d\'enregistrer les réglages';
$string['decimalplaces'] = 'Décimales dans les notes';
$string['decimalplaces_help'] = 'Ce réglage vous permet de choisir le nombre de décimales à afficher dans les scores ou dans les notes. Ces réglages n\'agissent que sur l\'affichage des notes, et n\'altèrent pas les notes stockées dans la base de données, ni les calculs internes qui sont effectués avec précision.';
$string['deletelistcheck'] = 'Voulez-vous vraiment supprimer la liste sélectionnée et tous ses participants ?';
$string['deletepagecheck'] = 'Voulez-vous vraiment supprimer les pages sélectionnées ?';
$string['deletepagesafterselected'] = 'Supprimer les sauts de page après les questions sélectionnées';
$string['deletepartcheck'] = 'Voulez-vous vraiment supprimer les participants sélectionnés ?';
$string['deleteparticipantslist'] = 'Supprimer la liste des participants';
$string['deletepdfs'] = 'Supprimer les documents';
$string['deleteresultcheck'] = 'Voulez-vous vraiment supprimer les résultats sélectionnés ?';
$string['deleteselectedpart'] = 'Supprimer les participants sélectionnés';
$string['deleteselectedresults'] = 'Supprimer les résultats sélectionnés';
$string['deletethislist'] = 'Supprimer cette liste';
$string['deleteupdatepdf'] = 'Supprimer et mettre à jour les formulaires PDF';
$string['difficultytitle'] = 'Difficulté';
$string['difficultytitlea'] = 'Difficulté A';
$string['difficultytitleb'] = 'Difficulté B';
$string['difficultytitlediff'] = 'Différence';
$string['displayoptions'] = 'Options d\'affichage';
$string['done'] = 'fait';
$string['downloadpartpdf'] = 'Télécharger le fichier PDF pour la liste \'{$a}';
$string['downloadpdfs'] = 'Télécharger les documents';
$string['downloadresultsas'] = 'Télécharger les résultats comme :';
$string['editgroupquestions'] = 'Modifier les questions des groupes';
$string['editgroups'] = 'Modifier les groupes hors-ligne';
$string['editingofflinequiz'] = 'Modification des questions des groupes';
$string['editingofflinequiz_help'] = 'Lors de la création d\'un test hors-ligne, les concepts principaux suivants sont à considérer :

* le test, qui contient des questions sur une ou plusieurs pages ;
* la banque de questions, qui contient des copies de toutes les questions, organisées en catégories.';
$string['editlist'] = 'Modifier la liste';
$string['editlists'] = 'Modifier les listes';
$string['editofflinequiz'] = 'Modifier le test hors-ligne';
$string['editofflinesettings'] = 'Éditer les réglages du test hors-ligne';
$string['editorder'] = 'Modifier l\'ordre';
$string['editparticipants'] = 'Modifier les participants';
$string['editquestions'] = 'Modifier les questions';
$string['editscannedform'] = 'Modifier la grille scannée';
$string['editthislist'] = 'Modifier cette liste';
$string['emptygroups'] = 'Certains groupes du test hors-ligne sont vides. SVP ajoutez des questions.';
$string['enroluser'] = 'Inscrire l\'utilisateur';
$string['erroraccessingreport'] = 'Vous n\'êtes pas autorisé à afficher ce rapport.';
$string['errorreport'] = 'Rapport des erreurs d\'importation';
$string['everythingon'] = 'activé';
$string['Excelformat'] = 'Format Excel';
$string['fileformat'] = 'Format des feuilles de questions';
$string['fileformat_help'] = 'Choisissez si vous voulez vos feuilles de questions au format PDF ou DOCX. Les grilles de réponses et les corrections sont toujours générées au format PDF.';
$string['filesizetolarge'] = 'Certains de vos fichiers images sont très volumineux. Les dimensions seront réduites durant l\'interprétation. SVP essayez de scanner vos grilles avec une résolution entre 200 et 300 dpi et en mode noir et blanc. Cela accélèrera l\'interprétation dans le futur';
$string['fontsize'] = 'Corps de police';
$string['forautoanalysis'] = 'Pour analyse automatique';
$string['formforcorrection'] = 'Feuille des corrections pour le groupe {$a}';
$string['formforgroup'] = 'Feuille des questions pour le groupe {$a}';
$string['formforgroupdocx'] = 'Feuille des questions pour le groupe {$a} (DOCX)';
$string['formsexist'] = 'Des questionnaires ont déjà été créés.';
$string['formsheetsettings'] = 'Réglage de formulaire';
$string['formspreview'] = 'Aperçu des formulaires';
$string['formwarning'] = 'Aucune grille de réponses n\'est définie. SVP, contactez votre administrateur.';
$string['functiondisabledbysecuremode'] = 'Cette fonctionnalité est actuellement désactivée';
$string['generalfeedback'] = 'Feedback général';
$string['generalfeedback_help'] = 'Le feedback général d\'une question est le texte présenté à l\'étudiant après une tentative de réponse. Contrairement au feedback pour une question spécifique, qui dépend du type de question et de la réponse donnée, le même feedback général est toujours affiché.';
$string['generatepdfform'] = 'Générer les formulaires PDF';
$string['grade'] = 'Note';
$string['gradedon'] = 'Noté le';
$string['gradedscannedform'] = 'Formulaire scanné avec les notes';
$string['gradeiszero'] = 'Note : Le nombre maximum de points pour ce test hors-ligne est 0 !';
$string['gradeswarning'] = 'Les notes de question doivent être numériques !';
$string['gradewarning'] = 'La note de la question doit être numérique !';
$string['gradingofflinequiz'] = 'Notes';
$string['gradingoptionsheading'] = 'Options de notation';
$string['greeniscross'] = 'compté comme une croix';
$string['group'] = 'Groupe';
$string['groupoutofrange'] = 'Le groupe était hors limite et a été remplacé par le groupe A.';
$string['groupquestions'] = 'Questions des groupes';
$string['hasresult'] = 'Un résultat existe';
$string['idnumber'] = 'Numéro d\'identification';
$string['imagefile'] = 'Fichier image';
$string['imagenotfound'] = 'Fichier image : {$a} non trouvé !';
$string['imagenotjpg'] = 'Image non jpg ou png : {$a}';
$string['imagickwarning'] = 'ImageMagick manquant : demandez à votre administrateur d\'installer la librairie ImageMagick et de vérifer le chemin d\'accès au fichier binaire convert dans les réglages du filtre tex. Vous ne pouvez pas importer de fichier TIF sans ImageMagick !';
$string['import'] = 'Importer';
$string['importedon'] = 'Importé le';
$string['importerror11'] = 'Un autre résultat existe';
$string['importerror12'] = 'Utilisateur non inscrit';
$string['importerror13'] = 'Pas de données de groupe';
$string['importerror14'] = 'Lecture impossible';
$string['importerror15'] = 'Lecture non fiable';
$string['importerror16'] = 'Erreur de page';
$string['importerror17'] = 'Pages incomplète';
$string['importerror21'] = 'Lecture impossible';
$string['importerror22'] = 'Lectures non fiables';
$string['importerror23'] = 'Utilisateur absent de la liste';
$string['importerror24'] = 'Liste non détectée';
$string['importforms'] = 'Importer des grilles de réponses';
$string['importfromto'] = 'Import de {$a->from} à {$a->to} sur {$a->total}.';
$string['import_help'] = '<p>
Vous pouvez importer un fichier image isolé ou plusieurs fichiers images dans une archive ZIP. Le module de test hors ligne traitera les fichiers images en tâche de fond.
Les noms de fichiers ne sont pas importants mais ne doivent pas contenir de caractères spéciaux ou accentués. Les images peuvent être de type GIF, PNG ou TIFs. Une résolution entre 200 et 300 dpi est recommandée.</p>';
$string['importisfinished'] = 'L\'import pour le test hors-ligne {$a} est terminé.';
$string['importlinkresults'] = 'Lien vers les résultats : {$a}';
$string['importlinkverify'] = 'Lien vers la vérification : {$a}';
$string['importmailsubject'] = 'Notification d\'import de quiz hors-ligne';
$string['importnumberexisting'] = 'Nombre de grilles en double : {$a}';
$string['importnumberpages'] = 'Nombre de pages importées avec succès : {$a}';
$string['importnumberresults'] = 'Nombre importé : {$a}';
$string['importnumberverify'] = 'Nombre de grilles qui nécessitent une vérification : {$a}';
$string['importtimefinish'] = 'Processus terminé : {$a}';
$string['importtimestart'] = 'Processus démarré : {$a}';
$string['inconsistentdata'] = 'Données inconsistantes : {$a}';
$string['info'] = 'Informations';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'Des lectures non fiables nécessitent des corrections manuelles';
$string['insecuremarkingsforquestion'] = 'Des lectures non fiables nécessitent une correction manuelle pour la question';
$string['insertnumber'] = 'SVP insérez le numéro didentification correct indiqué par le cadre bleu.';
$string['instruction1'] = 'Cette grille de réponses sera scannée automatiquement. SVP ne pas plier ou tâcher. Utilisez un stylo noir ou bleu pour remplir les champs :';
$string['instruction2'] = 'Seules les cases cochées clairement sont interprétées correctement ! Pour corriger une case cochée, remplissez complètement la case de couleur : elle sera interprétée comme non cochée :';
$string['instruction3'] = 'Les cases ainsi corrigées ne peuvent pas être marquées à nouveau. SVP n\'inscrivez rien en dehors des cases.';
$string['introduction'] = 'Introduction';
$string['invigilator'] = 'Surveillant(e)';
$string['ischecked'] = 'Présence cochée';
$string['isnotchecked'] = 'Présence non cochée';
$string['itemdata'] = 'données de l\'élément';
$string['keepfilesfordays'] = 'Conserver les fichiers (jours)';
$string['lightgray'] = 'Gris clair';
$string['linktoscannedform'] = 'Voir la grille de réponses scannée';
$string['listnotdetected'] = 'Détection du code barre pour la liste impossible!';
$string['logdeleted'] = 'Entrée de l\'historique {$a} supprimée.';
$string['logourl'] = 'URL du logo';
$string['lowertrigger'] = 'Seconde borne inférieure';
$string['lowertriggerzero'] = 'La seconde borne inférieure est nulle';
$string['lowerwarning'] = 'Première borne inférieure';
$string['lowerwarningzero'] = 'La première borne inférieure est nulle';
$string['marginwarning'] = 'SVP imprimez les fichiers PDF suivants sans marges additionnelles !<br /> Evitez d\'utiliser des photocopies. Dans le doute commandez des copies à l\'équipe de support.';
$string['marks'] = 'Points';
$string['matrikel'] = 'Numéro d\'identification';
$string['maxgradewarning'] = 'La note maximum doit être un nombre !';
$string['missingimagefile'] = 'Fichier image manquant';
$string['missingitemdata'] = 'Réponse(s) manquante(s) pour l\'utilisateur {$a}';
$string['missinglogdata'] = 'Historique manquant pour un résultat existant.';
$string['missingquestion'] = 'La question n\'existe plus.';
$string['missinguserid'] = 'Numéro d\'identification de l\'utilisateur manquant ! Lecture du code barre impossible !';
$string['modulename'] = 'Test hors-ligne';
$string['modulename_help'] = 'Le module d\'activité test hors-ligne permet à l\'enseignant de concevoir et gérer des tests hors-ligne comportant des questions à choix multiples.
Les questions sont stockées dans la banque de questions et peuvent être ré-utilisées dans le cours ou même dans d\'autres cours.
Les tests hors-lignes peuvent être téléchargés sous forme de fichiers PDF. Les étudiants marquent leurs réponses sur des grilles de réponses constituées de cases à cocher.
Ces grilles sont scannées et les réponses importées dans le système.
Pour plus d\'informations, consultez <a href="http://offline-tests.univie.ac.at">http://offline-tests.univie.ac.at</a>';
$string['modulenameplural'] = 'Tests hors-ligne';
$string['moodleprocessing'] = 'Laisser Moodle traiter les données';
$string['movecorners'] = 'Changez la position des marques de coins en premier. Utilisez le glisser-déplacer.';
$string['moveselectedonpage'] = 'Déplacer les questions sélectionnées sur la page : {$a}';
$string['multianswersforsingle'] = 'Plusieurs réponses pour une question à réponse unique';
$string['multichoice'] = 'Choix multiples';
$string['multipleanswers'] = 'Choisissez au moins une réponse.';
$string['neededcorrection'] = '<strong>Attention : Certaines de vos marques ont nécessité une correction manuelle. Examinez les carrés rouges sur l\'image suivante.
<br />Ce défaut a nécessité l\'intervention manuelle d\'un enseignant et retardé la publication des résultats du test ! Essayez d\'éviter cela la prochaine fois.</strong>';
$string['newgrade'] = 'Noté';
$string['newpage'] = 'Nouvelle page';
$string['noattemptexists'] = 'Aucun résultat';
$string['noattempts'] = 'Aucun résultat importé !';
$string['noattemptsonly'] = 'Afficher uniquement les étudiants sans résultat';
$string['nocourse'] = 'Le cours avec l\'identifiant {$a->course} auquel le test hors-ligne avec l\'identifiant {$a->offlinequiz} appartient est manquant.';
$string['nogradesseelater'] = 'Ce test hors-ligne n\'a pas encore été évalué pour {$a}. Les résultats seront publiés ici.';
$string['nogroupdata'] = 'Pas de donnée de groupe pour l\'utilisateur {$a}';
$string['nomcquestions'] = 'Il n\'y a aucune question à choix multiple dans le groupe {$a} !';
$string['noofflinequiz'] = 'Il n\'y a pas de test hors-ligne avec l\'identifiant {$a} !';
$string['nopages'] = 'Pas de page importée';
$string['noparticipantsfound'] = 'Pas de participant trouvé';
$string['nopdfscreated'] = 'Pas de document créé !';
$string['noquestions'] = 'Certains groupes de tests hors-ligne sont vides. SVP ajoutez des questions.';
$string['noquestionselected'] = 'Pas de question sélectionnée !';
$string['noquestionsfound'] = 'Il n\'y a pas de question pour le groupe {$a} !';
$string['noquestionsonpage'] = 'Page vide';
$string['noresults'] = 'Il n\'y a pas de résultat';
$string['noreview'] = 'Vous n\'êtes par autorisé à relire ce test hors-ligne';
$string['noscannedpage'] = 'Il n\'y a pas de page avec l\'identifiant {$a} !';
$string['notxtfile'] = 'Pas de fichier TXT';
$string['notyetgraded'] = 'Pas encore noté';
$string['nozipfile'] = 'Pas de fichier ZIP';
$string['numattempts'] = 'Nombre de résultats importés : {$a}';
$string['numattemptsqueue'] = '{$a} ajoutés à la file d\'attente. Vous recevrez un email lorsque le traitement sera terminé.';
$string['numattemptsverify'] = 'Grilles scannées en attente de correction : {$a}';
$string['numberformat'] = 'La valeur doit être un nombre avec {$a} chiffres !';
$string['numbergroups'] = 'Nombre de groupes';
$string['numpages'] = '{$a} pages importées';
$string['numquestionsx'] = 'Questions : {$a}';
$string['numusersadded'] = '{$a} participants ajoutés';
$string['ODSformat'] = 'Format ODS';
$string['offlineimplementationfor'] = 'Implémentation hors-ligne pour';
$string['offlinequiz:addinstance'] = 'Ajouter un test hors-ligne';
$string['offlinequiz:attempt'] = 'Attempt quizzes';
$string['offlinequizcloses'] = 'Ce test hors-ligne est fermé';
$string['offlinequizcloseson'] = 'La relecture pour ce test hors-ligne fermera le {$a}';
$string['offlinequiz:createofflinequiz'] = 'Créer les formulaires du test hors-ligne';
$string['offlinequiz:deleteattempts'] = 'Supprimer les résultats du test hors-ligne';
$string['offlinequiz:grade'] = 'Noter le test hors-ligne manuellement';
$string['offlinequizisclosed'] = 'Ce test hors-ligne est fermé';
$string['offlinequizisclosedwillopen'] = 'Test hors-ligne fermé (ouverture {$a})';
$string['offlinequizisopen'] = 'Ce test hors-ligne est ouvert';
$string['offlinequizisopenwillclose'] = 'Test hors-ligne ouvert (fermera le {$a})';
$string['offlinequiz:manage'] = 'Gérer les tests hors-ligne';
$string['offlinequizopenedon'] = 'Ce test est ouvert depuis {$a}';
$string['offlinequizopens'] = 'Le test est disponible';
$string['offlinequiz:preview'] = 'Aperçu des tests hors-ligne';
$string['offlinequizsettings'] = 'Réglages hors-ligne';
$string['offlinequiz:view'] = 'Afficher les informations du test hors-ligne';
$string['offlinequiz:viewreports'] = 'Afficher les rapports de test hors-ligne';
$string['offlinequizwillopen'] = 'Ce test hors-ligne sera ouvert le {$a}';
$string['oneclickenrol'] = 'Inscription en un clic';
$string['oneclickenroldesc'] = 'Si cette option est activée, les enseignants ont la possibilité d\' inscrire les utilisateurs en un clic pendant la correction des grilles de réponses (erreur "User not in course").';
$string['oneclickrole'] = 'Rôle pour les inscriptions en un clic.';
$string['oneclickroledesc'] = 'Choisir le rôle pour les inscriptions en un clic. Seuls les rôles avec l\'archétype "student" peuvent être sélectionnés.';
$string['onlylocalcategories'] = 'Uniquement des catégories de questions locales au cours';
$string['orderandpaging'] = 'Ordre et pagination';
$string['orderandpaging_help'] = 'Les nombres 10, 20, 30... en face de chaque question indiquent l\'ordre des questions. Les nombres augmentent par pas de 10 pour laisser de la place à l\'insertion éventuelle de questions supplémentaires. Pour réarranger les questions, modifiez les nombres, puis cliquez sur le bouton « Arranger les questions ».

Pour ajouter des sauts de page après certaines questions, cochez la case en face de ces questions, puis cliquez sur le bouton « Ajouter de nouvelles pages après les questions sélectionnées ».

Pour organiser les questions sur plusieurs pages, cliquez sur le bouton « Repagination » et indiquez le nombre de questions désirées par page.';
$string['orderingofflinequiz'] = 'Ordre et pagination';
$string['otherresultexists'] = 'Un résultat différent pour {$a} existe déjà, import ignoré ! Supprimez le résultat existant d\'abord.';
$string['outof'] = '{$a->grade} sur {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback global';
$string['overview'] = 'Notes';
$string['overviewdownload_help'] = '';
$string['pagecorrected'] = 'Feuille de la liste des participants corrigée importée';
$string['pageimported'] = 'Feuille de la liste des participants importée';
$string['page-mod-offlinequiz-edit'] = 'Éditer la page du test hors-ligne';
$string['page-mod-offlinequiz-x'] = 'Ajouter une page au test hors-ligne';
$string['pagenotdetected'] = 'Impossible de détecter le code barre pour la page !';
$string['pagenumberimported'] = 'Feuille {$a} de la liste des participants importée';
$string['pagesizeparts'] = 'Participants affichés par page :';
$string['papergray'] = 'Niveau de blanc du papier';
$string['papergray_help'] = 'Si les parties blanches de vos grilles de réponses sont très sombres, vous pouvez corriger cela en choisissant Gris sombre.';
$string['participants'] = 'Participants';
$string['participants_help'] = '<p>Les listes de participants sont destinées aux tests hors-ligne avec un nombre important de participants. Elles aident l\'enseignant à vérifier quels étudiants ont effectivement participé au test hors-ligne et si tous les résultats ont été importés correctement.
Vous pouvez ajouter des utilisateurs aux différentes listes. Chaque liste peut par exemple contenir les participants regroupés dans une salle. Les participants peuvent être membres d\'un groupe spécial. Un outil d\'inscription peut être utilisé pour créer ces groupes.
Des listes de participants peuvent être téléchargées sous forme de documents PDF, imprimées et cochées exactement comme les grilles de réponse des tests hors-ligne. Plus tard elles peuvent être importées et les étudiants marqués seront considérés comme présents au test hors-ligne.
SVP évitez toute marque ou tâche sur les codes barres car ils sont utilisés pour identifier chaque participant.</p>';
$string['participantsinlists'] = 'Participants dans les listes';
$string['participantslist'] = 'Liste des participants';
$string['participantslists'] = 'Participants';
$string['partimport'] = 'Import des listes de participants';
$string['partimport_help'] = '<p>
Dans cet onglet vous pouvez télécharger les listes de participants remplies. Vous pouvez importer un fichier image isolé ou plusieurs fichiers images dans une archive ZIP. Le module de test hors-ligne traitera les fichiers images en tâche de fond.
Les noms de fichiers ne sont pas importants mais ne doivent pas contenir de caractères spéciaux ou accentués. Les images peuvent être de type GIF, PNG ou TIFs. Une résolution entre 200 et 300 dpi est recommandée.</p>';
$string['pdfdeletedforgroup'] = 'Formulaire pour le groupe {$a} supprimé';
$string['pdfintro'] = 'Informations additionnelles';
$string['pdfintro_help'] = 'Ces informations seront imprimées sur la première page de la feuille de questions et doivent contenir des informations générales sur la manière de remplir la grille des réponses.';
$string['pdfintrotext'] = '<b>Comment cocher les cases ?</b><br />Cette grille de réponses sera scannée automatiquement. SVP ne pas plier ou tâcher. Utilisez un stylo noir ou bleu pour remplir les champs. Pour corriger une case cochée, remplissez complètement la case de couleur : elle sera interprétée comme non cochée.<br />';
$string['pdfintrotoolarge'] = 'L\'introduction est trop longue (max. 2000 caractères).';
$string['pdfscreated'] = 'Les formulaires PDF ont été créés';
$string['pdfsdeletedforgroup'] = 'Formulaires pour le groupe {$a} supprimés';
$string['pearlywhite'] = 'Blanc perle';
$string['pluginadministration'] = 'Administration test hors-ligne';
$string['pluginname'] = 'Test hors-ligne';
$string['point'] = 'point';
$string['present'] = 'présent';
$string['preview'] = 'Prévisualiser';
$string['previewforgroup'] = 'Prévisualisation pour le groupe {$a}';
$string['previewquestion'] = 'Prévisualiser la question';
$string['questionanalysis'] = 'Analyse de difficulté';
$string['questionanalysistitle'] = 'Tableau de l\'analyse de difficulté';
$string['questionbankcontents'] = 'Contenu de la banque de questions';
$string['questionname'] = 'Nom de question';
$string['questionsheet'] = 'Feuille de questions';
$string['questionsin'] = 'Questions dans';
$string['questionsingroup'] = 'Questions dans le groupe';
$string['questionsinthisofflinequiz'] = 'Questions dans ce test hors-ligne';
$string['questiontextisempty'] = '[Texte de question vide]';
$string['quizdate'] = 'Date du test hors-ligne';
$string['quizopenclose'] = 'Dates d\'ouverture et de fermeture';
$string['quizopenclose_help'] = 'Les étudiants ne peuvent voir leurs tentatives qu\'après l\'heure d\'ouverture et avant l\'heure de fermeture.';
$string['quizquestions'] = 'Questions du test';
$string['readjust'] = 'Ré-ajuster';
$string['realydeletepdfs'] = 'Voulez-vous vraiment supprimer les fichiers des formulaires ?';
$string['realydeleteupdatepdf'] = 'Voulez-vous vraiment supprimer et mettre à jour la liste des participants ?';
$string['recreatepdfs'] = 'Recréer les PDF';
$string['rediswrong'] = 'croix fausse ou manquante';
$string['refreshpreview'] = 'Rafraîchir l\'aperçu';
$string['regrade'] = 'Ré-évaluer';
$string['regradedisplayexplanation'] = '<b>Attention :</b> La ré-évaluation change aussi les notes qui ont été modifiées manuellement !';
$string['regradinginfo'] = 'Si vous modifiez la note d\'une question, Vous devez lancer une ré-évaluation du test hors-ligne pour mettre à jour les résultats des participants.';
$string['regradingquiz'] = 'Ré-évaluation';
$string['regradingresult'] = 'Ré-évaluation des résultats pour l\'utilisateur {$a}...';
$string['reloadpreview'] = 'Recharger l\'aperçu';
$string['reloadquestionlist'] = 'Recharger la liste des questions';
$string['remove'] = 'Supprimer';
$string['removeemptypage'] = 'Supprimer page vide';
$string['removeselected'] = 'Supprimer sélectionné';
$string['reordergroupquestions'] = 'Réordonner les questions du groupe';
$string['reorderquestions'] = 'Réordonner les questions';
$string['reordertool'] = 'Afficher l\'outil d\'organisation';
$string['repaginate'] = 'Repaginer avec {$a} questions par page';
$string['repaginatecommand'] = 'Repaginer';
$string['repaginatenow'] = 'Repaginer maintenant';
$string['reportstarts'] = 'relecture des résultats';
$string['resetofflinequizzes'] = 'Réinitialiser les données du test hors-ligne';
$string['resultexists'] = 'Un résultat identique pour {$a} existe déjà, import ignoré';
$string['resultimport'] = 'Importer les résultats';
$string['results'] = 'Résultats';
$string['review'] = 'Relecture';
$string['reviewbefore'] = 'Permettre la relecture pendant que le test hors-ligne est ouvert';
$string['reviewclosed'] = 'Après la fermeture du test hors-ligne';
$string['reviewcloses'] = 'Fin de relecture';
$string['reviewimmediately'] = 'Immédiatement après la tentative';
$string['reviewincludes'] = 'La relecture inclus';
$string['reviewofresult'] = 'Relecture du résultat';
$string['reviewopens'] = 'Début de relecture';
$string['reviewoptions'] = 'Les étudiants peuvent relire';
$string['reviewoptionsheading'] = 'Options de relecture';
$string['reviewoptions_help'] = 'Ces options permettent de décider les informations que les participants au test hors-ligne peuvent voir après l\'import des résultats.
Vous pouvez aussi définir les dates de début et de fin de la relecture. Les cases à cocher signifient
<table>
<tr><td style="vertical-align: top;"><b>La tentative</b></td><td>
Le texte des questions et les réponses seront affichés aux étudiants. Ils verront quelles réponses ils ont choisies, mais les réponses correctes ne seront pas indiquées.</td>
</td></tr>
<tr><td style="vertical-align: top;"><b>Si correcte</b></td><td>
Cette option ne peut être activée que si l\'option "La tentative" est aussi activée. Si activée, les étudiants verront quelles réponses étaient correctes (fond vert) ou incorrectes (fond rouge).
</td></tr>
<tr><td style="vertical-align: top;"><b>Points</b></td><td>
Les notes (points) pour les tests hors-ligne seront affichées. Cette option n\'est utile que si "Réponses juste" ou "La grille scannée" sont activés.
</td></tr>
<tr><td style="vertical-align: top;"><b>Réponse juste</b></td><td>
La réponse correcte à la question est affichée. Cette option n\'est disponible que si l\'option "La tentative" est activée.
</td></tr>
<tr><td style="vertical-align: top;"><b>La grille scannée</b></td><td>
La grille des réponses scannée est affichée. Les cases reconnues comme cochées sont marquées par un cadre vert.
</td></tr>
<tr><td style="vertical-align: top;"><b>La grille scannée avec les notes</b></td><td>
La grille des réponses scannée est affichée. Les cases reconnues comme cochées sont marquées par un cadre vert. Les croix inexactes ou manquantes sont indiquées par un carré rouge. De plus, une table les notes maximum et les notes atteintes pour chaque question.
</td></tr>
</table>';
$string['rimport'] = 'Importer/Corriger';
$string['rotate'] = 'Rotation';
$string['rotatingsheet'] = 'Rotation de la page...';
$string['save'] = 'Sauvegarder';
$string['saveandshow'] = 'Sauvegarder et montrer les changements à l\'étudiant';
$string['savescannersettings'] = 'Enregistrer les réglages du scanner';
$string['scannedform'] = 'Formulaire scanné';
$string['scannerformfortype'] = 'Formulaire pour le type {$a}';
$string['scanneroptions'] = 'Réglages du scanner';
$string['scannerpdfs'] = 'Formulaires vides';
$string['scannerpdfstext'] = 'Télécharger les formulaires vides suivants si vous voulez utiliser votre propre logiciel de scan.';
$string['scanningoptionsheading'] = 'Options du scanner';
$string['score'] = 'Score';
$string['select'] = 'Sélectionnez';
$string['selectagroup'] = 'Sélectionnez un groupe';
$string['selectall'] = 'Sélectionnez tout';
$string['selectcategory'] = 'Sélectionnez catégorie';
$string['selectdifferentgroup'] = 'Veuillez sélectionner un groupe différent !';
$string['selectedattempts'] = 'Sélectionner tentatives...';
$string['selectformat'] = 'Sélectionner format...';
$string['selectgroup'] = 'Basé sur le groupe';
$string['selectlist'] = 'Sélectionnez une liste ou tentez de ré-ajuster la feuille :';
$string['selectnone'] = 'Dé-sélectionner tout';
$string['selectpage'] = 'Choisissez un numéro de page ou tentez de ré-ajuster la feuille :';
$string['selectquestiontype'] = '-- Sélectionner le type de question --';
$string['showallparts'] = 'Afficher tous les {$a} participants';
$string['showcopyright'] = 'Afficher une mention de copyright';
$string['showcopyrightdesc'] = 'Si vous activez cette option, une mention de copyright sera affichée aux étudiants sur la page de relecture des résultats.';
$string['showgrades'] = 'Imprimer la note des questions';
$string['showgrades_help'] = 'Cette option détermine si la note maximale de chaque question du test hors-ligne doit être imprimée sur la feuille des questions.';
$string['showmissingattemptonly'] = 'Afficher tous les participants cochés et sans résultat';
$string['showmissingcheckonly'] = 'Afficher tous les participants non cochés et avec un résultat';
$string['shownumpartsperpage'] = 'Afficher {$a} participants par page';
$string['showstudentview'] = 'Afficher la vue étudiante.';
$string['showtutorial'] = 'Afficher un tutoriel sur les tests hors-ligne aux étudiants';
$string['showtutorialdescription'] = 'Vous pouvez ajouter un lien vers le tutoriel sur la page de cours en utilisant l\'URL :';
$string['showtutorial_help'] = 'Cette option détermine si les étudiants peuvent visualiser un tutoriel sur les bases des tests en ligne.
Ce tutoriel fournit des informations sur comment utiliser les différents documents constituant un test hors-ligne. Une partie interactive leur enseigne comment marquer correctement leur numéro d\'identification.<br />
<b>Veuillez noter :</b><br />
Si vous réglez cette option sur Oui, mais que le test en ligne est masqué, le lien ne sera pas visible. Dans ce cas, vous pouvez ajouter un lien vers le tutoriel sur la page de cours.';
$string['shuffleanswers'] = 'Mélanger les réponses';
$string['shufflequestions'] = 'Mélanger les questions';
$string['shufflequestionsanswers'] = 'Mélanger les questions et les réponses';
$string['shufflequestionsselected'] = 'Le mélange des questions a été activé. Certaines options relatives aux pages ne sont pas disponibles. Pour changer le réglage du mélange des questions, {$a}';
$string['shufflewithin'] = 'Mélanger les éléments des questions';
$string['shufflewithin_help'] = 'Si cette option est activée, les propositions de réponses aux questions seront mélangées aléatoirement à chaque nouvelle tentative du test, à condition que l\'option correspondant ait également été activée dans les paramètres de la question. Le réglage ne s\'applique qu\'aux questions qui comportent des propositions de réponses, telles que les questions à choix multiples ou les questions d\'appariement.';
$string['signature'] = 'Signature';
$string['standard'] = 'Standard';
$string['starttutorial'] = 'Démarrer le tutoriel sur l\'examen';
$string['statistics'] = 'Statistiques';
$string['statisticsplural'] = 'Statistiques';
$string['statsoverview'] = 'Vue d\'ensemble des statistiques';
$string['studycode'] = 'Code étudiant';
$string['theattempt'] = 'La tentative';
$string['timesup'] = 'Temps écoulé !';
$string['totalpointsx'] = 'Total des notes : {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total des {$a} questions de la catégorie.';
$string['trigger'] = 'bornes basse/haute';
$string['tutorial'] = 'Tutoriel sur les tests hors-ligne';
$string['type'] = 'Type';
$string['uncheckparts'] = 'Marquer les participants sélectionnés absents';
$string['updatedsumgrades'] = 'La somme des notes du groupe {$a->letter} a été re-calculée à {$a->grade}.';
$string['upgradingilogs'] = 'Mise à jour des pages scannées : page scannée {$a->done}/{$a->outof} <br/>(identifiant de test hors-ligne {$a->info})';
$string['upgradingofflinequizattempts'] = 'Mise à jour des tentatives du test hors-ligne : test hors-ligne {$a->done}/{$a->outof} <br/>(identifiant de test hors-ligne {$a->info})';
$string['upload'] = 'Importer/Corriger';
$string['uploadpart'] = 'Importer/Corriger des listes de participants';
$string['uppertrigger'] = 'Higher second boundary';
$string['uppertriggerzero'] = 'Higher second boundary is zero';
$string['upperwarning'] = 'Higher first boundary';
$string['upperwarningzero'] = 'Higher first boundary is zero';
$string['useradded'] = 'Utilisateur {$a} ajouté';
$string['userdoesnotexist'] = 'L\'utilisateur {$a} n\'existe pas dans le système';
$string['useridentification'] = 'Identification des utilisateurs';
$string['userimported'] = 'L\'utilisateur {$a} a été importé et noté';
$string['usernotincourse'] = 'Utilisateur {$a} pas dans le cours.';
$string['usernotinlist'] = 'Utilisateur non enregistré dans la liste !';
$string['usernotregistered'] = 'Utilisateur {$a} non inscrit dans le cours.';
$string['userpageimported'] = 'Page isolée importée pour l\'utilisateur {$a}';
$string['valuezero'] = 'La valeur ne doit pas être nulle';
$string['viewresults'] = 'Voir les résultats';
$string['white'] = 'Blanc';
$string['withselected'] = 'Avec la sélection';
$string['zerogradewarning'] = 'Attention : La note du test hors-ligne est 0.0 !';
$string['zipfile'] = 'Fichier ZIP';
$string['zipok'] = 'Fichier ZIP importé';
