<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sv', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan förhandsgranska det här testet, men om detta vore ett verkligt försök, skulle Du bli blockerad eftersom:';
$string['action'] = 'Åtgärd';
$string['activityoverview'] = 'Du har tester som passerat slutdatum';
$string['adaptive'] = 'Inställd för anpassning';
$string['adaptive_help'] = 'Om detta är aktiverat kommer flera svarsförsök på en fråga att tillåtas inom samma försök på testet. Så om till exempel ett svar är markerat som felaktigt ska studenten ha rätt att försöka igen direkt. Dock, om det är inställt på "Tillämpa avdrag", så kommer ett avdrag att göras för varje felaktigt försök.';
$string['addaquestion'] = 'Lägg till en fråga...';
$string['addarandomquestion'] = 'Lägg till en slumpmässig fråga...';
$string['addarandomquestion_help'] = 'När en slumpmässig fråga läggs till, resulterar det i att en slumpmässigt vald fråga från kategorin sätts in i testet. Detta innebär att olika studenter kan få olika urval av frågor, och när ett test tillåter flera försök, så innehåller sannolikt varje försök ett nytt urval av frågor.';
$string['adddescriptionlabel'] = 'Lägg till beskrivning/etikett';
$string['addingquestion'] = 'Lägger till en fråga';
$string['addingquestions'] = 'Det är här som Du kan hantera frågor till testen. Frågorna är ordnade i kategorier för att göra det enklare för Dig att organisera dem. Du kan använda en enskild fråga i samtliga test i kursen. Om frågan dessutom tillhör en kategori som är publicerad så kan den även användas i test på andra kurser.<br/><br/>
När Du har valt eller skapat en kategori så kan Du skapa och redigera frågor, samt välja ut frågor till testet.';
$string['addmoreoverallfeedbacks'] = 'Lägg till {no} fler fält för återkoppling';
$string['addnewgroupoverride'] = 'Lägg till överskridande av grupp';
$string['addnewpagesafterselected'] = 'Lägg till nya sidor efter de valda frågorna';
$string['addnewquestionsqbank'] = 'Lägg till frågor till kategorin {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Lägg till överskridande av användare';
$string['addpagehere'] = 'Lägg till sida här';
$string['addquestion'] = 'Lägg till fråga';
$string['addquestions'] = 'Lägg till frågor';
$string['addquestionstoquiz'] = 'Lägg till frågor till det aktuella testet';
$string['addrandom'] = 'Lägg till {$a} slumpmässiga frågor';
$string['addrandom1'] = 'Lägg till';
$string['addrandom2'] = 'slumpmässiga frågor';
$string['addrandomfromcategory'] = 'Lägg till slumpmässiga frågor från kategorin: ';
$string['addrandomquestion'] = 'Lägg till en slumpmässig fråga';
$string['addrandomquestiontoquiz'] = 'Lägg till en slumpmässig fråga till testet {$a}';
$string['addselectedtoquiz'] = 'Lägg det markerade till testet';
$string['addtoquiz'] = 'Lägg till till test';
$string['affectedstudents'] = 'Påverkade {$a}';
$string['aftereachquestion'] = 'Efter tillägget av varje fråga';
$string['afternquestions'] = 'Efter tillägget av [$a} frågor';
$string['age'] = 'ålder';
$string['allattempts'] = 'Alla försök';
$string['allinone'] = 'Obegränsat';
$string['allowreview'] = 'Tillåt granskning';
$string['alreadysubmitted'] = 'Det är troligt att Du redan har skickat in detta försök för bedömning.';
$string['alternativeunits'] = 'Alternativa enheter';
$string['alwaysavailable'] = 'Alltid tillgängligt';
$string['analysisoptions'] = 'Alternativ för analys';
$string['analysistitle'] = 'Tabell för komponenter att analysera';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvarad/e';
$string['answerhowmany'] = 'Ett eller flera svar?';
$string['answers'] = 'Svar';
$string['answersingleno'] = 'Flera svar tillåtna';
$string['answersingleyes'] = 'Endast ett svar';
$string['answertoolong'] = 'Svaret är för långt efter rad {$a} (max 255 tecken)';
$string['aon'] = 'AON-format';
$string['areyousureremoveselected'] = 'Är Du säker på att Du vill ta bort alla de valda frågorna?';
$string['asshownoneditscreen'] = 'Som visats på skärmen för redigering';
$string['attempt'] = 'Försök {$a}';
$string['attemptalreadyclosed'] = 'Det här försöket har redan avslutats.';
$string['attemptclosed'] = 'Försöket har inte avslutats ännu';
$string['attemptduration'] = 'Förbrukad tid';
$string['attemptedon'] = 'Försök genomfört den';
$string['attempterror'] = 'Du har inte tillstånd att göra försök på det här testet p g a: {$a}';
$string['attemptfirst'] = 'Första försök';
$string['attemptincomplete'] = 'Det här försöket (av {$a}) är ännu inte avslutat';
$string['attemptlast'] = 'Senaste försök';
$string['attemptnumber'] = 'Försök';
$string['attemptquiznow'] = 'Påbörja försök av testet nu';
$string['attempts'] = 'Försök';
$string['attemptsallowed'] = 'Antal tillåtna försök';
$string['attemptsdeleted'] = 'Försök att genomföra test har upptäckts';
$string['attemptselection'] = 'Markera vilka försök per användare som Du vill analysera:';
$string['attemptsexist'] = 'Det har testet har Du redan gjort ett försök på';
$string['attemptsnum'] = 'Försök: {$a}';
$string['attemptsnumthisgroup'] = 'Försök: {$a->total} ({$a->group} från den här gruppen)';
$string['attemptsnumyourgroups'] = 'Försök: {$a->total} ({$a->group} från dina grupper)';
$string['attemptsonly'] = 'Visa bara de studenter/elever/deltagare/lärande som har gjort försök';
$string['attemptstate'] = 'Tillstånd';
$string['attemptstillinprogress'] = 'Pågående försök';
$string['attemptsunlimited'] = 'Obegränsat antal försök';
$string['autosaveperiod'] = 'Period/intervall för autospara';
$string['autosaveperiod_desc'] = 'Studentens svar kan sparas automatiskt med några minuters mellanrum under pågående test. Detta innebär en avvägning: Att spara svaren kan öka belastningen på servern, men minskar risken för att eleverna förlorar sitt arbete.';
$string['back'] = 'Tillbaka till förhandsgranskning av fråga';
$string['backtocourse'] = 'Tillbaka till kursen';
$string['backtoquestionlist'] = 'Tillbaka till  listan med frågor';
$string['backtoquiz'] = 'Tillbaka till redigering av test';
$string['basicideasofquiz'] = 'De grundläggande idéerna bakom utveckling av test';
$string['bestgrade'] = 'Bästa betyget';
$string['bothattempts'] = 'Visa bara de studenter/elever/deltagare/lärande som har och inte har gjort försök';
$string['browsersecurity'] = 'Säkerhet för webbläsare';
$string['browsersecurity_help'] = 'Om "Fullskärms popup med JavaScript säkerhet" är valt,

* Testet kommer bara att starta om studenten har JavaScript aktiverat i sin Webläsare
* Testet visas i ett popup fönster som täcker alla andra fönster och saknar navigationskontroller
* Studenterna är hindrade, så långt som möjligt från att använda möjligheter som  klipp och klistra';
$string['calculated'] = 'Beräknad';
$string['calculatedquestion'] = 'Beräknad fråga stödjs inte på rad {$a}. Ingen hänsyn kommer att tas till frågan.';
$string['cannotcreatepath'] = 'Det går inte att skapa sökvägen';
$string['cannoteditafterattempts'] = 'Du kan inte ta bort eller lägga till frågor eftersom det har gjorts försök på det här testet. ({$a})';
$string['cannotfindprevattempt'] = 'Det går inte att hitta ett föregående försök att bygga vidare på';
$string['cannotfindquestionregard'] = 'Det gick inte att hämta frågorna för att göra om betygssättningen!';
$string['cannotinsert'] = 'Det går inte att infoga fråga';
$string['cannotinsertrandomquestion'] = 'Det gick inte att infoga en ny slumpmässig fråga!';
$string['cannotloadquestion'] = 'Det gick inte att ladda alternativen som hör till frågan';
$string['cannotloadtypeinfo'] = 'Det gick inte att ladda in frågetypen med specifik information kring frågan';
$string['cannotopen'] = 'Det går inte att öppna den exporterade filen ({$a})';
$string['cannotrestore'] = 'Det gick inte att återställa sessionerna rörande frågan';
$string['cannotreviewopen'] = 'Du kan inte utvärdera det här försöket eftersom det fortfarande pågår';
$string['cannotsavelayout'] = 'Det gick inte att spara layouten';
$string['cannotsavenumberofquestion'] = 'Det gick inte att spara antal frågor per sida';
$string['cannotsavequestion'] = 'Det går inte att spara frågelistan';
$string['cannotsetgrade'] = 'Det gick inte att ange ett nytt maximum för testet';
$string['cannotsetsumgrades'] = 'Det gick inte att ställa in sammanlagda betyg';
$string['cannotstartgradesmismatch'] = 'Kan inte starta ett försök för detta test. Testet är inställt för att betygssättas utifrån {$a->grade}, men ingen av frågorna i testet har ett betyg. Detta kan lösas på sidan \'Redigera test\'.';
$string['cannotstartmissingquestion'] = 'Kan inte starta försök för detta test. Testets definition innehåller en fråga som inte existerar.';
$string['cannotstartnoquestions'] = 'Kan inte starta försök för detta test. Testet har inte satts upp ännu. Inga frågor har lagts till.';
$string['cannotwrite'] = 'Det går inte att skriva till den exporterade filen ({$a})';
$string['caseno'] = 'Nej, stor eller liten bokstav spelar ingen roll';
$string['casesensitive'] = 'Stor eller liten bokstav gör  skillnad';
$string['caseyes'] = 'Ja, stor/liten bokstav måste matcha exakt';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorin \'{$a}\' lades till';
$string['categorydeleted'] = 'Kategorin \'{$a}\' togs bort';
$string['categorynoedit'] = 'Du har inte behörighet att redigera privilegier i kategorin \'{$a}\'.';
$string['categoryupdated'] = 'Kategorin uppdaterades framgångsrikt';
$string['close'] = 'Stäng fönster';
$string['closebeforeopen'] = 'Det gick inte att uppdatera testet. Du har angivit ett slutdatum som ligger för startdatumet.';
$string['closed'] = 'Stängd';
$string['closepreview'] = 'Stäng förhandsgranskning';
$string['closereview'] = 'Stäng förhandsgranskning';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Gör en kommentar eller ändra  omdöme/betyg';
$string['comments'] = 'Kommenarer';
$string['completedon'] = 'Fullgjord den';
$string['configadaptive'] = 'Om Du väljer "Ja" för det här alternativet då kommer studenten/eleven/deltagaren/den lärande att kunna avge flera olika svar på en fråga under samma försök på testet. ';
$string['configattemptsallowed'] = 'Begränsning av det antal försök som studenter/elever/deltagare/lärande tillåts göra på testet.';
$string['configdecimaldigits'] = 'Antal siffror som ska visas efter decimalkommat vid visning betyg.';
$string['configdecimalplaces'] = 'Det antal siffror som ska användas efter decimaltecknet när poäng för testet visas.';
$string['configdecimalplacesquestion'] = 'Det antal siffror som ska användas efter decimaltecknet när poäng för enskilda frågor visas.';
$string['configdelay1'] = 'Om du sätter tidsfördröjning måste studenten vänta den angivna tiden innan den kan utföra ett nytt försök sedan sitt första försök.';
$string['configdelay1st2nd'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt andra försök förrän så mycket tid har passerat sedan deras första försök.';
$string['configdelay2'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt försök förrän så mycket tid har passerat sedan deras tredje eller senare försök.';
$string['configdelaylater'] = 'Om du anger en tidsfördröjning här kan eleven inte starta sitt tredje, fjärde... osv. försök förrän så mycket tid förlöpt sedan slutet på deras föregående försök.';
$string['configeachattemptbuildsonthelast'] = 'Om flera försök tillåts innehåller varje nytt försök resultatet från det föregående försöket.';
$string['configgrademethod'] = 'Om flera försök tillåts, vilken metod skall användas för att beräkna studentens slutgiltiga betyg för testet.';
$string['configintro'] = 'Värdena du anger här definierar de förinställda värdena som används i inställningsformuläret när man skapar ett nytt test. Du kan även ange vilka inställningar för test som ska anses som avancerade.';
$string['configmaximumgrade'] = 'Förvalt betygsskala som testets betygssättning ska använda.';
$string['confignavmethod'] = 'I läget fri navigering kan frågor besvaras i valfri ordning med användning av navigationen. I sekventiell navigering måste frågorna besvaras i en bestämd ordning.';
$string['confignewpageevery'] = 'När du lägger till frågor till testet kommer sidbrytning att göras automatiskt enligt de inställningar du gör här.';
$string['configoutcomesadvanced'] = 'Om denna inställning är aktiverad kommer Resultat på sidan för inställningar för testet att betraktas som avancerade inställningar.';
$string['configpenaltyscheme'] = 'Avdrag gjorda för varje felaktigt svar i anpassande läge';
$string['configpopup'] = 'Tvinga försöket att öppnas i ett popupp-fönster och använd JavaScript för att försöka förhindra kopiera och klistra in under försöket.';
$string['configrequirepassword'] = 'Studenter/elever/deltagare/lärande måste ange det här lösenordet innan de kan göra försök på det här testet. ';
$string['configrequiresubnet'] = 'Studenter/elever/deltagare/lärande kan bara göra försök på det här testet via dessa datorer. ';
$string['configreviewoptions'] = 'Dessa inställningar avgör vilken information användare kan se när de granskar ett försök av ett test eller granskar testrapporter.';
$string['configshowblocks'] = 'Visa block under försök. ';
$string['configshowuserpicture'] = 'Visa användare bild på skärmen under försök. ';
$string['configshufflequestions'] = 'Om Du aktiverar detta alternativ, då kommer ordningen på frågorna i testet att ändras slumpmässigt varje gång någon gör ett försök på testet.';
$string['configshufflewithin'] = 'Om Du aktiverar detta alternativ, då kommer de delar som bygger upp de enskilda frågorna att ändras slumpmässigt varje gång en student påbörjar ett försök på det här testet, detta under förutsättning att alternativet också är aktiverat i den frågans inställningar.';
$string['configtimelimit'] = 'Förvald standardmässig tidsbegränsning i minuter för test. 0 betyder att det inte finns någon begränsning. ';
$string['configtimelimitsec'] = 'Förvald standardmässig tidsbegränsning i sekunder för test. 0 betyder att det inte finns någon begränsning. ';
$string['configurerandomquestion'] = 'Konfigurera fråga';
$string['confirmclose'] = 'Du håller på att avsluta det här försöket. När Du väl har avslutat försöket kommer Du inte längre att kunna ändra Dina svar.';
$string['confirmserverdelete'] = 'Är Du säker på att Du vill ta bort servern <b>{$a}</b> från listan?';
$string['confirmstartattemptlimit'] = 'Det här testet får Du bara göra {$a} gånger. Genom att Du öppnar testet så registreras det som ett försök. Vill Du fortsätta?';
$string['confirmstartattempttimelimit'] = 'Det här testet har en tidsbegränsning och Du får bara göra det {$a} gånger. Genom att Du öppnar testet så registreras det som ett försök. Vill Du fortsätta?';
$string['confirmstarttimelimit'] = 'Det här testet har en tidsbegränsning. Är Du säker på att Du vill påbörja det?';
$string['connectionerror'] = 'Nätverksanslutning förlorade (autospara misslyckades).

Anteckna alla svar som angavs på webbplatsen de sista minuterna på papper, försöka sedan att återansluta.

När anslutningen har återupprättats, bör dina svar sparas och detta meddelande kommer att försvinna.';
$string['connectionok'] = 'Nätverksanslutning återställd. Du kan fortsätta  på ett säkert sätt.';
$string['containercategorycreated'] = 'Den här kategorin har skapats för att lagra alla de ursprungliga kategorier som har flyttats till webbplatsnivån p.g.a. de orsaker som anges nedan.';
$string['continueattemptquiz'] = 'Fortsätt med det senaste försöket';
$string['continuepreview'] = 'Fortsätt med den senaste förhandsgranskningen';
$string['copyingfrom'] = 'Skapar en kopia av frågan \'{$a}\'';
$string['copyingquestion'] = 'Kopierar en fråga';
$string['correct'] = 'Rätt';
$string['correctanswer'] = 'Rätt svar';
$string['correctanswerformula'] = 'Formel för korrekta svar';
$string['correctansweris'] = 'Rätt svar: {$a}';
$string['correctanswerlength'] = 'Viktiga symboler';
$string['correctanswers'] = 'Rätt svar';
$string['correctanswershows'] = 'Rätt svar visar';
$string['corrresp'] = 'Rätt svarsreaktion';
$string['countdown'] = 'Tid kvar';
$string['countdownfinished'] = 'Tiden håller på att ta slut, Du bör spara Dina svar nu!';
$string['countdowntenminutes'] = 'Tio minuter kvar!';
$string['coursetestmanager'] = '\'Course Test  Manager\'-format';
$string['createcategoryandaddrandomquestion'] = 'Skapa en kategori och lägg till en slumpmässig fråga';
$string['createfirst'] = 'Du måste skapa några kortsvars-frågor först.';
$string['createmultiple'] = 'Skapa flera frågor';
$string['createnewquestion'] = 'Skapa ny fråga';
$string['createquestionandadd'] = 'Skapa en ny fråga och lägg till den till testet.';
$string['custom'] = 'Standardformat';
$string['dataitemneed'] = 'Du måste lägga till åtminstone en uppsättning datakomponenter för att få till en giltig fråga.';
$string['datasetdefinitions'] = 'Återanvändbara definitioner av dataset för kategorin {$a}';
$string['datasetnumber'] = 'Tal/Nummer';
$string['daysavailable'] = 'Dagar tillgängligt';
$string['decimaldigits'] = 'Decimalsiffror i betyg';
$string['decimalplaces'] = 'Antal decimaler i betyg';
$string['decimalplaces_help'] = 'Genom att använda den här inställningen kan Du ange antalet decimaler som ska visas i betyget/omdömet för varje försök.

Om du t.ex. väljer \'0\' så betyder det att de visade betygen kommer att avrundas till heltal.

Den här inställningen påverkar bara visningen av betyg. Detta har ingen inverkan på de interna beräkningarna och avrundning av betyg.';
$string['decimalplacesquestion'] = 'Antal decimaler i betyget för frågan';
$string['decimalplacesquestion_help'] = 'Denna inställning specificerar det antal siffror som visas efter decimalkommat vid visning av poäng vid varje fråga.';
$string['decimalpoints'] = 'Decimalpoäng';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Normalpoäng';
$string['defaultinfo'] = 'Standardkategori för frågor.';
$string['delay1'] = 'Tidsfördröjning mellan det första och andra försöket';
$string['delay1st2nd'] = 'Påtvingad fördröjning mellan 1:a och 2:a försöket';
$string['delay1st2nd_help'] = '<p>Om du ställer in en tidsfördröjning då kommer studenterna/eleverna/deltagarna/de lärande att vara tvungna att vänta så länge innan de kan göra ett andra försök att genomföra testet.</p>';
$string['delay2'] = 'Tidsfördröjning mellan senare försök';
$string['delaylater'] = 'Tvingad tidsfördröjning för senare försök.';
$string['delaylater_help'] = '<p>Om du anger en tidsfördröjning här då kommer studenterna/eleverna/deltagarna/de lärande att bli tvungna att vänta så länge innan de kan göra förnyade försök att genomföra testet.</p>';
$string['deleteattemptcheck'] = 'Är Du helt säker på att Du vill ta bort de här försöken för gott?';
$string['deleteselected'] = 'Ta bort de/t markerade';
$string['deletingquestionattempts'] = 'Tar bort försök på frågor';
$string['description'] = 'Beskrivning';
$string['disabled'] = 'Avaktiverad';
$string['displayoptions'] = 'Alternativ för visning';
$string['donotuseautosave'] = 'Använd inte autospara';
$string['download'] = 'Klicka för att ladda ner den exporterade filen för kategorier';
$string['downloadextra'] = '(filen är också lagrad in \'kursens filer\' i katalogen /test)';
$string['duplicateresponse'] = 'Den inskickade uppgiftslösningen räknas inte eftersom Du har lämnat ett liknande svar tidigare.';
$string['eachattemptbuildsonthelast'] = 'Varje försök bygger på det senaste';
$string['eachattemptbuildsonthelast_help'] = '<p>Om det &auml;r till&aring;tet att g&ouml;ra flera f&ouml;rs&ouml;k och den h&auml;r
inst&auml;llningen &auml;r satt till \'Ja\' s&aring; kommer varje f&ouml;rs&ouml;k att
inneh&aring;lla resultaten fr&aring;n det tidigare f&ouml;rs&ouml;ket.
Detta g&ouml;r det m&ouml;jligt att fullf&ouml;lja testet via ett antal f&ouml;rs&ouml;k.</p>
<p>F&ouml;r att visa ett nytt test f&ouml;r varje f&ouml;rs&ouml;k s&aring; v&auml;ljer Du
\'Nej\' f&ouml;r den h&auml;r inst&auml;llningen.</p>';
$string['editcategories'] = 'Redigera kategorier';
$string['editcategory'] = 'Redigera kategori';
$string['editcatquestions'] = 'Redigera frågor i kategorin';
$string['editingquestion'] = 'Redigera en fråga';
$string['editingquiz'] = 'Redigera övning';
$string['editingquiz_help'] = 'När du skapar ett test, så är de viktigaste begreppen följande:

* Testet, med frågor över en eller flera sidor
* Frågebanken, som lagrar kopior av alla frågor indelade i kategorier
* Slumpade frågor - En student får olika frågor varje gång han/hon gör försök på testet och olika studenter kan alltså få olika frågor.';
$string['editingquizx'] = 'Redigerar test: {$a}';
$string['editoverride'] = 'Redigera överskridande';
$string['editqcats'] = 'Redigera kategorier av frågor';
$string['editquestions'] = 'Redigera frågor';
$string['editquiz'] = 'Redigera test';
$string['editquizquestions'] = 'Redigera testfrågor';
$string['emailconfirmbody'] = 'Käre/a {$a->username},

Tack för att Du har skickat in Dina svar till
\'{$a->quizname}\'
i kursen \'{$a->coursename}\'
vid {$a->submissiontime}.

Detta meddelande bekräftar att vi har fått dina svar.

Du kan få tillgång till det här testet genom  {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Tack för att Du har fullföljt testet och bekräftat Dina svar på  \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bekräftelse av inskickning av test: {$a->quizname}';
$string['emailnotifybody'] = 'Käre/a {$a->username},

{$a->studentname} har fullföljt testet 
\'{$a->quizname}\' ({$a->quizurl})
i kursen \'{$a->coursename}\'
Du kan visa detta försök vid {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har fullgjort {$a->quizname}';
$string['emailnotifysubject'] = '{$a->studentname} har fullföljt testet {$a->quizname}';
$string['emailoverduebody'] = 'Bäste {$a->studentname},

Du påbörjade ett försök på \'{$a->quizname}\' i kursen \'{$a->coursename}\', men du skickade inte in det. Det borde ha skickats in senast {$a->attemptduedate}. Om du fortfarande vill skicka in detta försöket, gå till {$a->attemptsummaryurl} och klicka på knappen Skicka in. Du måste göra detta före {$a->attemptgraceend} annars kommer ditt försök inte att räknas.';
$string['emailoverduesmall'] = 'Du skickade inte in ditt försök på {$a->quizname}. Gå till {$a->attemptsummaryurl} före {$a->attemptgraceend} om du fortfarande vill skicka in försöket.';
$string['emailoverduesubject'] = 'Försöket är nu förfallet: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktiverad';
$string['endtest'] = 'Slut på test...';
$string['erroraccessingreport'] = 'Du får inte tillgång till den här rapporten';
$string['errorinquestion'] = 'Fel i fråga';
$string['errormissingquestion'] = 'Fel: Systemet saknar frågan med id:  {$a}';
$string['errornotnumbers'] = 'Fel - svar måste vara numeriska';
$string['errorunexpectedevent'] = 'Oväntad kod för händelse {$a->event} återfanns för frågan {$a->questionid} i försöket {$a->attemptid}.';
$string['essay'] = 'Essäfråga';
$string['essayquestions'] = 'Essäfrågor';
$string['eventquizattemptabandoned'] = 'Test försök övergiven';
$string['eventquizattemptstarted'] = 'Test försök påbörjad';
$string['eventquizattemptsubmitted'] = 'Test försök inlämnad';
$string['eventquizattempttimelimitexceeded'] = 'Test försök tidsbegränsning överskridit';
$string['everynquestions'] = 'Varje {$a} fråga';
$string['everyquestion'] = 'Varje fråga';
$string['everythingon'] = 'Allting på';
$string['export'] = 'Exportera';
$string['exportcategory'] = 'Exportera kategori';
$string['exporterror'] = 'Ett fel inträffade i samband med genomförande av exporten';
$string['exportingquestions'] = 'Frågorna exporteras till en fil';
$string['exportname'] = 'Namn på fil';
$string['exportquestions'] = 'Exportera frågorna till en fil';
$string['extraattemptrestrictions'] = 'Extra restriktioner för försök';
$string['false'] = 'Falskt';
$string['feedback'] = 'Återkoppling';
$string['feedbackerrorboundaryformat'] = 'Betygsgränserna för återkoppling måste vara angivna antingen i procent eller i form av ett tal. Det värde som Du har angivit inom spannet {$a} är inte giltigt.';
$string['feedbackerrorboundaryoutofrange'] = 'Betygsgränserna för återkoppling måste vara mellan 0% och 100%. Det värde som Du har matat in i spannet {$a} är utanför den begränsningen.';
$string['feedbackerrorjunkinboundary'] = 'Du måste fylla i boxarna för betygsgränserna för återkoppling utan att lämna några tomrum.';
$string['feedbackerrorjunkinfeedback'] = 'Du måste fylla i boxarna för återkoppling utan att lämna några tomrum.';
$string['feedbackerrororder'] = 'Betygsgränserna för återkoppling måste vara i ordning, med den högsta först. Det värde som Du har matat in i spannet {$a} följer inte den ordningen.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Fyll i med rätt';
$string['filloutnumericalanswer'] = 'Du tillhandahåller åtminstone ett möjligt svar och tolerans. Det första matchande svaret kommer att användas för att bestämma resultatet och återkopplingen. Om Du tillhandahåller viss återkoppling men inget svar på slutet som kommer detta att visas för de studenter/elever/deltagare/lärande vars responser inte matchas av något av de andra svaren.';
$string['filloutoneanswer'] = 'Du måste fylla i åtminstone ett svar. Svar som lämnas tomma räknas inte.';
$string['filloutthreequestions'] = 'Du måste fylla i minst tre frågor. Frågor som lämnas tomma räknas inte.';
$string['fillouttwochoices'] = 'Du måste fylla i åtminstone två val. Val som lämnas tomma räknas inte.';
$string['finishattemptdots'] = 'Avsluta försök';
$string['finishreview'] = 'Avsluta efterhandsgranskning';
$string['forceregeneration'] = 'tvinga återskapande';
$string['formatnotfound'] = 'Det gick inte att hitta formatet {$a} för import/export';
$string['formatnotimplemented'] = 'Det här formatet har inte införts i systemet på rätt sätt. Var snäll och formulera en \'bug\'-rapport.';
$string['formulaerror'] = 'Fel i formlerna!';
$string['fractionsaddwrong'] = 'De positiva betyg Du valt kan inte summeras till 100%.<br />Istället kommer de upp till {$a}%
<br />Vill Du gå tillbaka och ändra denna fråga?';
$string['fractionsnomax'] = 'Ett av svaren borde bli 100%, så att det är
<br />möjligt att få fullt betyg på denna fråga.
<br />Vill Du gå tillbaka och ändra denna fråga?';
$string['fromfile'] = 'från fil';
$string['functiondisabledbysecuremode'] = 'Den funktionaliteten är f n avaktiverad';
$string['generalfeedback'] = 'Allmän återkoppling';
$string['generalfeedback_help'] = 'Allmän återkoppling är text som visas efter att en fråga har besvarats. Till skillnad från återkoppling för en specifik fråga vilken beror på avgivet svar, så visas alltid samma allmänna återkoppling oavsett svar.';
$string['graceperiod'] = 'Tidsfrist för inskickning';
$string['graceperiod_desc'] = 'Om inställning för åtgärd vid förfallen tid är satt till "Tillåt en tidsfrist för inskickning men tillåt inte förändringar av svaren", är detta förvalt värde för extra tid, i sekunder.';
$string['graceperiod_help'] = 'Om inställning för åtgärd vid förfallen tid är satt till "Tillåt en tidsfrist för inskickning men tillåt inte förändringar av svaren", är detta den extra tid som är tillåten.';
$string['graceperiodmin'] = 'Senaste tidsfrist för inskickning';
$string['graceperiodmin_desc'] = 'Det finns ett potentiellt fel alldeles i slutet av testet. Å ena sidan vill vi låta eleven arbeta ända till sista testsekunden - med hjälp av timern som automatiskt skickar in testförsöket när tiden går ut.

Å andra sidan kan servern då bli överbelastad och behöva viss tid för att processa svaren. Därför kommer vi att acceptera svar för upp till detta antal sekunder efter att tiden gått ut så att eleverna inte bestraffas för att servern är långsam.

Dock kan eleven fuska och få så här många sekunder mer att besvara testet. Du måste göra en avvägning baserat på hur mycket du litar på prestandan på servern när tester skickas in.';
$string['graceperiodtoosmall'] = 'Tidsfristen måste vara mer än {$a}.';
$string['grade'] = 'Betyg/omdöme';
$string['gradeall'] = 'Bedöm/betygssätt alla';
$string['gradeaverage'] = 'Medelbetyg';
$string['gradeboundary'] = 'Betygsgräns';
$string['gradeessays'] = 'Bedöm/betygssätt essäfrågor';
$string['gradehighest'] = 'Högsta betyg';
$string['grademethod'] = 'Betygsättningsmetod';
$string['grademethod_help'] = '<p>N&auml;r det &auml;r till&aring;tet med upprepade f&ouml;rs&ouml;k s&aring; finns
det olika s&auml;tt som Du kan anv&auml;nda f&ouml;r att ber&auml;kna studentens/elevens/deltagarens/den l&auml;randes
slutbetyg/omd&ouml;me p&aring; testet.</p>
<p><b>H&ouml;gsta betyget/omd&ouml;met</b></p>
<ul>
<li>
Slutbetyget/omd&ouml;met &auml;r det h&ouml;gsta (b&auml;sta) av samtliga f&ouml;rs&ouml;k.
</li>
</ul>
<p><b>Genomsnittsligt (medel)betyg/omd&ouml;me</b></p>
<ul>
<li>
Slutbetyget/omd&ouml;met &auml;r medelbetyget ber&auml;knat p&aring; alla f&ouml;rs&ouml;k.
</li>
</ul>
<p><b>Det f&ouml;rsta betyget/omd&ouml;met</b></p>
<ul>
<li>Slutbetyget/omd&ouml;met &auml;r det som har uppn&aring;tts p&aring; det f&ouml;rsta
f&ouml;rs&ouml;ket (de &ouml;vriga r&auml;knas inte).</li>
</ul>
<p><b>Det sista betyget/omd&ouml;met</b></p>
<ul>
<li>Slutbetyget/omd&ouml;met &auml;r enbart det som har uppn&aring;tts p&aring; det senaste f&ouml;rs&ouml;ket.</li>
</ul>';
$string['gradesdeleted'] = 'Betyg på test har tagits bort';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Betyg/omdömen för det här inskickade testet: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Med tidigare avdrag ger detta <strong><strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Det här inskickade testet innefattar ett avdrag på {$a}.';
$string['gradingdetailszeropenalty'] = 'Du har inte fått något avdrag på det här inskickade testet.';
$string['gradingmethod'] = 'Metod för bedömning/betygssättning: {$a}';
$string['groupoverrides'] = 'Överskridanden av grupp';
$string['groupsnone'] = 'Det finns inga grupper i den här kursen';
$string['guestsno'] = 'Tyvärr, gäster kan inte se eller göra test';
$string['hidebreaks'] = 'Dölj sidbrytningar';
$string['hidereordertool'] = 'Dölj verktyget för revidering av ordningsföljden';
$string['history'] = 'Historik över responser:';
$string['howquestionsbehave_desc'] = 'Förvald inställning för hur frågor beter sig i ett test.';
$string['imagedisplay'] = 'Bild att visa';
$string['import'] = 'Importera';
$string['importcategory'] = 'importera kategori';
$string['importerror'] = 'Ett fel inträffade i samband med genomförande av importen';
$string['importfilearea'] = 'Importen från filen finns redan i kursfilerna...';
$string['importfileupload'] = 'Import från fil - laddas upp...';
$string['importfromthisfile'] = 'Importera från den här filen';
$string['import_help'] = 'Denna funktion gör att du kan importera frågor från externa textfiler.

Om filen innehåller icke ASCII-tecken måste du använda teckenkodning UTF-8. Var särskilt försiktig med filer som genereras av Microsofts Office program eftersom dessa ofta använder en speciell kodning som inte kommer att hanteras på rätt sätt.

Importformat och exportformat är en möjliga att lägga till och ta bort som insticksmoduler. Andra valfria format kan vara tillgängliga i databasen för moduler och insticksmoduler.';
$string['importingquestions'] = 'Importerar {$a} frågor från fil';
$string['importmax10error'] = 'Det finns ett fel i frågan. Du kan inte ha fler än 10 svar.';
$string['importmaxerror'] = 'Det finns ett fel i frågan. Det finns för många svar.';
$string['importquestions'] = 'Importera frågor från fil';
$string['inactiveoverridehelp'] = '* Studenten/eleven/deltagaren/den lärande tillhör inte rätt grupp alt har inte rätt roll för att göra försök på testet.';
$string['incorrect'] = 'Felaktigt';
$string['indivresp'] = 'Individers svarsreaktioner på varje komponent i testet';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Pågår';
$string['introduction'] = 'Introduktion';
$string['invalidattemptid'] = 'Det finns inget försök med detta ID';
$string['invalidcategory'] = 'ID för kategori är ogiltigt';
$string['invalidnumericanswer'] = 'Ett av de svar Du matade in var inte ett giltigt tal.';
$string['invalidnumerictolerance'] = 'En av de toleranser Du matade in var inte ett giltigt tal.';
$string['invalidoverrideid'] = 'Ogiltigt id för överskridande';
$string['invalidquestionid'] = 'Ogiltigt id för fråga';
$string['invalidquizid'] = 'Ogiltigt id för test';
$string['invalidsource'] = 'Den här källan är inte godkänd som giltig';
$string['invalidsourcetype'] = 'Ogiltig typ av källa';
$string['invalidstateid'] = 'Ogiltigt id för status';
$string['lastanswer'] = 'Ditt senaste svar var';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Sidans layout är som visas.';
$string['layoutasshownwithpages'] = 'Sidans layout är som visas. <small>(Automatiskt en ny sida för var {$a} fråga.)</small>';
$string['layoutshuffledandpaged'] = 'Frågor blandas slumpmässigt med {$a} frågor per sida.';
$string['layoutshuffledsinglepage'] = 'Frågor blandas slumpmässigt, alla på en sida.';
$string['link'] = 'Länk';
$string['listitems'] = 'Listar komponenter i test';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Laddning av frågor misslyckades: {$a}';
$string['makecopy'] = 'Spara som en ny fråga';
$string['managetypes'] = 'Administrera frågetyper och servrar';
$string['manualgrading'] = 'Bedömer/betygssätter';
$string['mark'] = 'Skicka in';
$string['markall'] = 'Skicka in sida';
$string['marks'] = 'Poäng';
$string['marks_help'] = 'Den numeriska poängen för varje fråga, och den övergripande poängen för försöket.';
$string['match'] = 'Para_ihop';
$string['matchanswer'] = 'Svara på para-ihop-fråga';
$string['matchanswerno'] = 'Matchar svar {$a}';
$string['max'] = 'Max';
$string['messageprovider:attempt_overdue'] = 'Varning när ditt testförsök faller utanför tilldelad tid.';
$string['messageprovider:confirmation'] = 'Bekräftelse av Dina egna fullföljanden av test';
$string['messageprovider:submission'] = 'Meddelande om fullföljanden av test';
$string['min'] = 'Min';
$string['minutes'] = 'Minuter';
$string['missingcorrectanswer'] = 'Du måste ange rätt svar';
$string['missingitemtypename'] = 'Det saknas ett namn';
$string['missingquestion'] = 'Denna fråga verkar inte längre existera';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Aktiviteten test medger för en lärare att skapa tester med frågor av olika typ, inklusive flervals frågor, matchning, kort svar och numeriska frågor.

Läraren kan tillåta att testet får försökas flera gånger, med frågorna blandade eller slumpvis valda från frågebanken. En tidsgräns kan sättas.

Varje försök rättas automatiskt, med undantag för essäfrågor, och betyget sparas i betygsboken.

Läraren kan välja om och när ledtrådar, återkoppling och rätta svar ska visas för eleven.

Tester kan användas

* Som kurstester
* Som minitester till läsuppgifter eller i slutet av ett ämnesområde
* Som förövning inför viktiga tester med hjälp av testfrågor från gamla test
* För att ge omedelbar återkoppling om genomförande
* För självuppskattning';
$string['modulenameplural'] = 'Test';
$string['moveselectedonpage'] = 'Flytta de valda frågorna till sidan: {$a}';
$string['multichoice'] = 'Flerval';
$string['multipleanswers'] = 'Välj minst ett svar';
$string['multiplier'] = 'Multiplikator';
$string['mustbesubmittedby'] = 'Detta försöket måste skickas in av {$a}.';
$string['name'] = 'Namn';
$string['navmethod'] = 'Navigationsmetod';
$string['navmethod_free'] = 'Fri';
$string['navmethod_help'] = 'När sekventiell navigering är aktiverat måste eleven gå igenom testet i angiven ordning och kan då inte gå tillbaka till tidigare sidor eller hoppa framåt.';
$string['navmethod_seq'] = 'Sekventiell';
$string['navnojswarning'] = 'OBS! de här länkarna kommer inte att spara Dina svar. Använd knappen "Fortsätt" längst ner på sidan. ';
$string['neverallononepage'] = 'Aldrig, alla frågor på en sida';
$string['newattemptfail'] = 'Fel: Det gick inte att påbörja ett nytt försök av testet';
$string['newpage'] = 'Ny sida';
$string['newpageevery'] = 'Starta en ny sida automatiskt';
$string['newpage_help'] = '<p>N&auml;r det g&auml;ller l&auml;ngre test s&aring; &auml;r det klokt om Du f&ouml;rdelar fr&aring;gorna &ouml;ver ett st&ouml;rre antal sidor. Det g&ouml;r Du genom att begr&auml;nsa det antal fr&aring;gor som ska visas p&aring; varje sida.</p><p>  N&auml;r Du l&auml;gger till fr&aring;gor kommer det automatiskt att l&auml;ggas in sidbrytningar i enlighet med den inst&auml;llning som Du v&auml;ljer h&auml;r. Du kommer dock &auml;ven att kunna inf&ouml;ra manuella sidbrytningar l&auml;ngre fram n&auml;r Du redigerar sidorna.
</p>';
$string['noanswers'] = 'Du valde inga svar!';
$string['noattempts'] = 'Inga försök har gjorts med detta test';
$string['noattemptsfound'] = 'Inga försök funna.';
$string['noattemptstoshow'] = 'Det finns inga försök att visa';
$string['nocategory'] = 'En felaktig kategori, eller ingen kategori har angivits';
$string['noclose'] = 'Inget datum för avslutning av test';
$string['nocommentsyet'] = 'Inga kommentarer ännu.';
$string['noconnection'] = 'Det finns f.n. ingen uppkoppling till en webbtjänst som kan bearbeta denna fråga. Var snäll och kontakta Din administratör.';
$string['nodataset'] = 'ingenting - detta är inte ett wild card';
$string['nodatasubmitted'] = 'Det skrevs inte in några data.';
$string['noessayquestionsfound'] = 'Det gick inte att hitta några manuellt bedömda/betygssatta frågor';
$string['nogradewarning'] = 'Detta test är inte betygssatt så du kan inte sätta övergripande återkoppling som skiljer sig genom betyget.';
$string['nomoreattempts'] = 'Inga fler försök tillåtna';
$string['none'] = 'Ingen';
$string['noopen'] = 'Inget datum för öppnande av test';
$string['nooverridedata'] = 'Du måste överskrida åtminstone en av inställningarna i testet.';
$string['nopossibledatasets'] = 'Inga möjliga uppsättningar av data';
$string['noquestionintext'] = 'Frågetexten innehåller inte några inbäddade frågor';
$string['noquestions'] = 'Inga frågor har ännu lagts till';
$string['noquestionsfound'] = 'Det gick inte att hitta några frågor';
$string['noquestionsinquiz'] = 'Det finns inga frågor i det här testet. ';
$string['noquestionsnotinuse'] = 'Denna slumpade fråga används inte efterssom dess kategori är tom.';
$string['noquestionsonpage'] = 'Tom sida';
$string['noresponse'] = 'Ingen svarsreaktion';
$string['noreview'] = 'Du får inte granska detta test';
$string['noreviewattempt'] = 'Du har inte rätt att granska det här försöket. ';
$string['noreviewshort'] = 'Inte tillåten';
$string['noreviewuntil'] = 'Du får inte granska detta test förrän {$a}';
$string['noreviewuntilshort'] = 'Tillgänglig {$a}';
$string['noscript'] = 'JavaScript måste vara aktiverat om Du vill fortsätta!';
$string['notavailabletostudents'] = 'OBS! Detta test är tyvärr inte tillgängligt för Dina studenter/elever/deltagare/lärande';
$string['notenoughrandomquestions'] = 'Det finns inte tillräckligt många frågor i kategorin {$a->category} för att skapa frågan {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Otillräckligt antal delfrågor!<br />
Vill Du gå tillbaka och rätta till den här frågan?';
$string['notimedependentitems'] = 'Tidsstyrda komponenter stödjs f.n. inte av modulen Test. Som ett sätt att klara detta ändå kan Du ange en tidsgräns för hela testet. Vill Du välja en annan komponent (eller använda den aktuella komponenten ändå)?';
$string['notyetgraded'] = 'Ännu inte betygssatta';
$string['notyetviewed'] = 'Ännu ej granskade';
$string['notyourattempt'] = 'Detta är inte Ditt försök!';
$string['noview'] = 'Användare som är inloggade får inte visa det här testet';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har gjort {$a->attemptnum} försök';
$string['numattemptsmade'] = '{$a} försök har genomförts på det här testet';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Frågor: {$a}';
$string['onlyteachersexport'] = 'Endast lärare kan exportera frågor';
$string['onlyteachersimport'] = 'Endast lärare med behörighet att redigera kan importera frågor';
$string['onthispage'] = 'Denna sida';
$string['open'] = 'Inte besvarad';
$string['openclosedatesupdated'] = 'Datum för att öppna och stänga testet har uppdaterats';
$string['optional'] = 'valfritt';
$string['orderandpaging'] = 'Ordningsföljd och sidindelning';
$string['orderandpaging_help'] = 'Siffrorna 10, 20, 30, ... motstående varje fråga indikerar ordningen på frågorna. Numreringen ökar med steg om 10 för att lämna utrymme för tillkommande frågor att kunna infogas. För att ändra ordningsföljden för frågorna, ändra på numreringen och klicka sedan på knappen "Gör om ordningsföljden på frågorna".';
$string['orderingquiz'] = 'Ordningsföljd och sidindelning';
$string['orderingquizx'] = 'Ordningsföljd och sidindelning: {$a}';
$string['outcomesadvanced'] = 'Resultat är avancerad inställning';
$string['outof'] = 'av ett maximum på';
$string['outofpercent'] = '{$a->grade} av ett maximum på {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Övergripande återkoppling';
$string['overallfeedback_help'] = 'Övergripande återkoppling är text som visas efter att ett test har försökts. Genom att ange specifika poänggränser (som procenttal eller som antal), kan texten bero på den poäng som uppnåtts.';
$string['overdue'] = 'förfallen';
$string['overduehandling'] = 'När tiden går ut';
$string['overduehandlingautoabandon'] = 'Försök måste skickas in innan tiden går ut, annars räknas de inte';
$string['overduehandlingautosubmit'] = 'Pågående försök skickas in automatiskt';
$string['overduehandling_desc'] = 'Vad ska hända som förvalt om en elev inte skickar in testet innan tiden går ut.';
$string['overduehandlinggraceperiod'] = 'Det finns en tidsfrist när pågående försök kan skickas in, men inga fler frågor besvaras';
$string['overduehandling_help'] = 'Denna inställning kontrollerar vad som händer om en elev misslyckas med att skicka in sitt försök på ett test innan tiden går ut. Om eleven aktivt arbetar med testet när tiden går ut kommer timern för nedräkning alltid att automatiskt skicka in försöket, men om eleven har loggat ut kommer denna inställning avgöra vad som händer.';
$string['overduemustbesubmittedby'] = 'Tiden för detta test har nu gått ut. Det borde redan ha skickats in. Om du vill att detta testförsök ska poängsättas/betygssättas måste du skicka in det senast {$a}. Om du inte skickar in det då, kommer inga poäng från detta försök att räknas.';
$string['override'] = 'Överskrid';
$string['overridedeletegroupsure'] = 'Är Du säker på att Du vill ta bort överskridandet för gruppen {$a}?';
$string['overridedeleteusersure'] = 'Är Du säker på att Du vill ta bort överskridandet för användaren {$a}?';
$string['overridegroup'] = 'Överskrid grupp';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Överskridanden';
$string['overrideuser'] = 'Överskrid användare';
$string['overrideusereventname'] = '{$a->quiz} - överskridande';
$string['page-mod-quiz-attempt'] = 'Försök dig på test';
$string['page-mod-quiz-edit'] = 'Redigera testsida';
$string['page-mod-quiz-report'] = '';
$string['page-mod-quiz-review'] = 'Granska test sida';
$string['page-mod-quiz-summary'] = 'Test försök sammanfattande sida';
$string['page-mod-quiz-view'] = 'Test informationssida';
$string['page-mod-quiz-x'] = 'Varje sida för testmodul';
$string['pagesize'] = 'Antal försök som ska visas per sida:';
$string['parent'] = 'Förälder';
$string['parentcategory'] = 'Föräldra-kategori';
$string['parsingquestions'] = '\'Parsar\' frågor från en importerad fil.';
$string['partiallycorrect'] = 'Delvis korrekt';
$string['penalty'] = 'Avdrag';
$string['penaltyscheme'] = 'Tillämpa avdrag';
$string['penaltyscheme_help'] = '<p>Om ett test k&ouml;rs i anpassningsbart l&auml;ge s&aring; kommer studenten/eleven/deltagaren/den l&auml;rande att kunna l&auml;mna ett nytt svar p&aring; fr&aring;gan om det f&ouml;rsta svaret &auml;r felaktigt. I det h&auml;r fallet kan det vara s&aring; att Du, f&ouml;r varje felaktigt svar, vill inf&ouml;ra ett avdrag som ska dras fr&aring;n slutbetyget p&aring; fr&aring;gan. Hur stort avdraget ska vara v&auml;ljer Du individuellt f&ouml;r varje fr&aring;ga n&auml;r Du skapar eller redigerar fr&aring;gan.</p>

<p>Den h&auml;r inst&auml;llningen har bara effekt om testet k&ouml;rs i anpassningsbart l&auml;ge.</p>';
$string['percentcorrect'] = 'Rätt procent';
$string['pleaseclose'] = 'Din förfrågan har bearbetats. Du kan stänga det här fönstret nu.';
$string['pluginadministration'] = 'Administration av test';
$string['pluginname'] = 'Test';
$string['popup'] = 'Visa testet i ett "säkert" fönster';
$string['popupblockerwarning'] = 'Den här sektionen av testet är i säkert läge. Det innebär att Du måste genomföra testet i ett säkert fönster. Var snäll och avaktivera Din popup-blockerare. Tack så mycket!';
$string['popupnotice'] = 'Studenter/elever/deltagare/lärande kommer att få se detta test i ett säkert fönster.';
$string['preprocesserror'] = 'Fel inträffade under förbehandling!';
$string['preview'] = 'Förhandsgranska';
$string['previewquestion'] = 'Förhandsgranska fråga';
$string['previewquiz'] = 'Förhandsgranska test';
$string['previewquiznow'] = 'Förhandsgranska testet nu';
$string['previous'] = 'Föregående status';
$string['publish'] = 'Publicera';
$string['publishedit'] = 'Du måste ha tillstånd i den publicerande kursen för att få lägga till eller redigera frågor i den här kategorin';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'namn';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'typ, namn';
$string['question'] = 'Fråga';
$string['questionbankcontents'] = 'Innehåll i frågebank';
$string['questionbankmanagement'] = 'Administration av frågebank';
$string['questionbehaviour'] = 'Frågans beteende';
$string['questioncats'] = 'Kategorier av frågor';
$string['questiondeleted'] = 'Den här frågan har tagits bort. Var snäll och kontakt Din lärare.';
$string['questioninuse'] = 'För närvarande används frågan \'{$a}\' :';
$string['questionmissing'] = 'Frågan för den här sessionen saknas';
$string['questionname'] = 'Frågans namn';
$string['questionnonav'] = '<span class="accesshide">Fråga </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Frågan {$a} har inte laddats från databasen';
$string['questionorder'] = 'Ordning på frågor';
$string['questionposition'] = 'Ny position i ordningen för fråga {$a}';
$string['questions'] = 'Frågor';
$string['questionsinclhidden'] = 'Frågor (inräknat de som saknas)';
$string['questionsinthisquiz'] = 'Frågor i det här testet';
$string['questionsperpage'] = 'Maximalt antal frågor per sida';
$string['questionsperpageselected'] = 'Antal frågor per sida har satts så att sidindelningen för närvarande är fast. Som resultat av detta har kontrollen för sidindelning avaktiverats. Du kan ändra detta på {$a}.';
$string['questionsperpagex'] = 'Frågor per sida: {$a}';
$string['questiontext'] = 'Frågetext';
$string['questiontextisempty'] = '[tom frågetext]';
$string['questiontype'] = 'Frågetyp {$a}';
$string['questiontypesetupoptions'] = 'Aternativa inställningar för frågetyper:';
$string['quiz:addinstance'] = 'Lägg till nytt test';
$string['quiz:attempt'] = 'Försök att genomföra test';
$string['quizavailable'] = 'Detta test är tillgängligt till: {$a}';
$string['quizclose'] = 'Stäng testet';
$string['quizclosed'] = 'Detta test stängdes {$a}';
$string['quizcloses'] = 'Testet stängs';
$string['quizcloseson'] = 'Testet kommer att avslutas {$a}';
$string['quiz:deleteattempts'] = 'Ta bort försök att genomföra test';
$string['quiz:emailconfirmsubmission'] = 'Hämta bekräftelse via e-post i samband med inskickning';
$string['quiz:emailnotifysubmission'] = 'Använd e-post för att hämta meddelande om  inskickningar';
$string['quiz:emailwarnoverdue'] = 'Få ett meddelande när tiden för ett försök går ut och måste skickas in.';
$string['quiz:grade'] = 'Betygssätt test manuellt';
$string['quiz:ignoretimelimits'] = 'Ta inte hänsyn till tidsbegränsningar på test';
$string['quizisclosed'] = 'Det här testet är stängt';
$string['quizisclosedwillopen'] = 'Testet stängt (öppnas {$a})';
$string['quizisopen'] = 'Det här testet är öppet';
$string['quizisopenwillclose'] = 'Testet är öppet (stängs {$a})';
$string['quiz:manage'] = 'Administrera test';
$string['quiz:manageoverrides'] = 'Administrera överskridanden av test';
$string['quiznavigation'] = 'Navigation i test';
$string['quizopen'] = 'Öppna testet';
$string['quizopenclose'] = 'Öppnings- och stängningsdatum';
$string['quizopenclose_help'] = 'Elever kan endast starta sina försök efter öppningstiden och de måste fullfölja in sina försök före stängningstiden.';
$string['quizopened'] = 'Det här testet är öppet';
$string['quizopenedon'] = 'Det här testet är öppnades {$a}';
$string['quizopens'] = 'Testet öppnas';
$string['quizopenwillclose'] = 'Det här testet är öppet, kommer att stängas {$a}';
$string['quizordernotrandom'] = 'Ordningsföljden i testet har inte kastats om ';
$string['quizorderrandom'] = 'Ordningsföljden i testet har kastats om ';
$string['quiz:preview'] = 'Förhandsgranska test';
$string['quiz:regrade'] = 'Gör om betygssättningen för försök på test';
$string['quiz:reviewmyattempts'] = 'Granska Dina försök';
$string['quizsettings'] = 'Inställningar för test';
$string['quiztimer'] = 'Testtimer';
$string['quiz:view'] = 'Visa information om test';
$string['quiz:viewreports'] = 'Visa rapporter om test';
$string['quizwillopen'] = 'Det här testet kommer att öppnas {$a}';
$string['random'] = 'Slumpfråga';
$string['randomcreate'] = 'Skapa slumpade frågor';
$string['randomfromcategory'] = 'Slumpad fråga från kategori:';
$string['randomfromexistingcategory'] = 'Slumpad fråga från en befintlig kategori:';
$string['randomnosubcat'] = 'Endast frågor från denna kategori, inte från dess underkategorier';
$string['randomquestionusinganewcategory'] = 'Slumpad fråga under användning av en ny kategori';
$string['randomwithsubcat'] = 'Frågor från denna kategori och dess underkategorier';
$string['readytosend'] = 'Du är på väg att skicka hela Ditt test för betygsättning.  Är Du säker på att Du vill fortsätta?';
$string['reattemptquiz'] = 'Gör om testet';
$string['recentlyaddedquestion'] = 'Denna fråga har lagts till nyligen!';
$string['recurse'] = 'Ta även med frågor från underkategorier';
$string['regrade'] = 'Förnya betyg/omdöme för varje försök';
$string['regradecomplete'] = 'Nya betyg/omdömen har givits för varje försök';
$string['regradecount'] = '{$a->changed} av {$a->attempt} betyg ändrades';
$string['regradedisplayexplanation'] = 'Försök som ändras i samband med förnyad betygssättning visas som länkar till fönstret för förnyad visning av fråga.';
$string['regradenotallowed'] = 'Du har inte tillstånd att göra om betygssättningen för det här testet';
$string['regradingquestion'] = 'Förnyad betygssättning av  "{$a}"';
$string['regradingquiz'] = 'Förnyad betygssättning av  test  "{$a}"';
$string['remove'] = 'Ta bort';
$string['removeallquizattempts'] = 'Ta bort alla försök på test';
$string['removeemptypage'] = 'Ta bort tom sida';
$string['removeselected'] = 'Ta bort markerade';
$string['rename'] = 'Ändra namn';
$string['renderingserverconnectfailed'] = 'Servern {$a} misslyckades med att bearbeta ett RQP anrop. Kontrollera att URLen är korrekt.';
$string['reorderquestions'] = 'Gör om ordningsföljden på frågorna';
$string['reordertool'] = 'Visa verktyget för att göra om ordningsföljden';
$string['repaginate'] = 'Paginera om med  {$a}  frågor per sida';
$string['repaginatecommand'] = 'Gör om sidindelningen';
$string['repaginatenow'] = 'Gör om sidindelningen nu';
$string['replace'] = 'Byt ut';
$string['replacementoptions'] = 'Alternativ för utbyten';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Analys av komponenter';
$string['reportattemptsfrom'] = 'Försök från';
$string['reportattemptsthatare'] = 'Försök som är';
$string['reportdisplayoptions'] = 'Visa alternativ';
$string['reportfullstat'] = 'Detaljerad statistik';
$string['reportmulti_percent'] = 'Flerfaldiga procent';
$string['reportmulti_q_x_student'] = 'Flerfaldiga val av studenter/elever/deltagare/lärande';
$string['reportmulti_resp'] = 'Individuella svarsreaktioner';
$string['reportmustselectstate'] = 'Du måste välja åtminstone ett tillstånd.';
$string['reportnotfound'] = 'Rapporten är okänd ({$a})';
$string['reportoverview'] = 'Översikt';
$string['reportregrade'] = 'Förnya  betyg/omdömen för försök';
$string['reportresponses'] = 'Detaljerad responser';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Visa endast försök';
$string['reportshowonlyfinished'] = 'Visa högst en genomförd försök per användare ({$a})';
$string['reportsimplestat'] = 'Enkel statistik';
$string['reportusersall'] = 'alla användare som har försökt testet';
$string['reportuserswith'] = 'registrerade användare som har försökt testet';
$string['reportuserswithorwithout'] = 'registrerade användare som har. eller inte har, försökt testet';
$string['reportuserswithout'] = 'registrerade användare som inte har försökt testet';
$string['reportwhattoinclude'] = 'Vad som inkluderas i rapporten';
$string['requirepassword'] = 'Kräv ett lösenord';
$string['requirepassword_help'] = '<p>Det h&auml;r f&auml;ltet &auml;r valfritt.</p>
<p>Om Du anger ett l&ouml;senord h&auml;r d&aring; m&aring;ste deltagare skriva in samma l&ouml;senord innan de f&aring;r lov att g&ouml;ra ett f&ouml;rs&ouml;k med testet.</p>';
$string['requiresubnet'] = 'Kräv en nätverksadress';
$string['requiresubnet_help'] = '<p>Det h&auml;r f&auml;ltet &auml;r valfritt.</p>
<p>Du kan begr&auml;nsa tillg&aring;ngen till ett test till specifika undern&auml;t
p&aring; ett LAN eller p&aring; Internet genom att ange en kommaseparerad lista med
delar av, eller hela numren f&ouml;r IP-adresser.</p>
<p>Det h&auml;r &auml;r speciellt anv&auml;ndbart n&auml;r det g&auml;ller test d&auml;r Du vill vara s&auml;ker p&aring; att
bara m&auml;nniskor i ett specifikt rum ska ha tillg&aring;ng till testet.</p>
<p>Till exempel:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>
<p>Det finns tre typer av nummer som Du kan anv&auml;nda (Du kan inte anv&auml;nda
textbaserade dom&auml;nnamnm som exempel.se):</p>
<ol>
<li>Kompletta IP-adresser, s&aring;som <b>192.168.10.1</b> som kommer att kopplas till en enskild dator
(eller proxy).</li>
<li>Delar av adresser, s&aring;som <b>192.168</b> som kommer att kopplas till allt som inleds med dessa siffror.</li>
<li>CIDR notation,  s&aring;som <b>231.54.211.0/20</b> som g&ouml;r det m&ouml;jligt att ange mer detaljerade undern&auml;t.</li>
</ol>
<p>Mellanslag g&ouml;r ingen skillnad.</p>';
$string['response'] = 'Respons';
$string['responses'] = 'Responser';
$string['results'] = 'Resultat';
$string['returnattempt'] = 'Återgå till försök';
$string['reuseifpossible'] = 'Återanvänd en tidigare borttagen';
$string['reverttodefaults'] = 'Återställ standardinställningar för test';
$string['review'] = 'Granska';
$string['reviewafter'] = 'Tillåt granskning efter det att testet är stängt';
$string['reviewalways'] = 'Tillåt granskning när som helst';
$string['reviewattempt'] = 'Granska försök';
$string['reviewbefore'] = 'Tillåt granskning medan testet är öppet';
$string['reviewclosed'] = 'Efter det att testet är avslutat';
$string['reviewduring'] = 'Under försöket';
$string['reviewimmediately'] = 'Direkt efter försöket';
$string['reviewnever'] = 'Tillåt aldrig granskning';
$string['reviewofattempt'] = 'Statistik över försök {$a}';
$string['reviewofpreview'] = 'Granskning av förhandsgranskning';
$string['reviewopen'] = 'Senare, medan testet fortfarande är öppet';
$string['reviewoptions'] = 'Studenter/elever/deltagare/lärande kan granska';
$string['reviewoptionsheading'] = 'Alternativ  för granskning';
$string['reviewoptionsheading_help'] = 'Dessa inställningar kontrollerar vilken information eleven kan se när de granskar sitt testförsök eller tittar på testrapporten.

**Under försöket** är inställningar som endast är relevant för visst beteende, som "interaktiv med multipla försök", som kan visa återkoppling under försöket.

**Omedelbart efter försöket** är inställningar som gäller för de första två minuterna efter att eleven klickat på knappen "Skicka in allt och avsluta".

**Senare, medan testet fortfarande är öppet** är inställningar som gäller efter att testets stängningsdatum har passerat. Om testet inte har stängningsdatum kan detta tillstånd inte nås.';
$string['reviewoverallfeedback'] = 'Övergripande återkoppling';
$string['reviewoverallfeedback_help'] = 'Återkopplingen som ges vid slutet av ett försök, beroende på elevens totala poäng.';
$string['reviewresponse'] = 'Respons på granskning';
$string['reviewresponsetoq'] = 'Granska svar (fråga {$a})';
$string['reviewthisattempt'] = 'Granska Dina svar i det här försöket';
$string['rqp'] = 'Fjärrfråga';
$string['rqps'] = 'Fjärrfrågor';
$string['sameasoverall'] = 'Detsamma för övergripande betyg/omdömen';
$string['save'] = 'Spara';
$string['saveandedit'] = 'Spara ändringar och redigera frågor';
$string['saveattemptfailed'] = 'Det gick inte att spara det aktuella försöket på testet';
$string['savedfromdeletedcourse'] = 'Sparad från den borttagna kursen "{$a}"';
$string['savegrades'] = 'Spara betyg/omdömen';
$string['savemyanswers'] = 'Spara mina svar';
$string['savenosubmit'] = 'Spara utan att skicka in test';
$string['saveoverrideandstay'] = 'Spara och mata in ytterligare ett överskridande';
$string['savequiz'] = 'Spara hela detta test';
$string['saving'] = 'Sparar';
$string['savingnewgradeforquestion'] = 'Sparar ny poäng för fråga med id {$a}.';
$string['savingnewmaximumgrade'] = 'Sparar ny maximal poäng.';
$string['score'] = 'Rena poäng';
$string['scores'] = 'Resultat/poäng';
$string['select'] = 'Välj';
$string['selectall'] = 'Välj alla';
$string['selectcategory'] = 'Välj kategori';
$string['selectedattempts'] = 'Valda försök...';
$string['selectnone'] = 'Avmarkera alla';
$string['selectquestiontype'] = '-- Välj frågetyp --';
$string['serveradded'] = 'En server har lagts till';
$string['serveridentifier'] = 'Identifierare';
$string['serverinfo'] = 'Information om server';
$string['servers'] = 'Servrar';
$string['serverurl'] = 'URL till server';
$string['settingsoverrides'] = 'Inställningar för överskridanden';
$string['shortanswer'] = 'Kort svar';
$string['show'] = 'Visa';
$string['showall'] = 'Visa alla frågor på en sida';
$string['showblocks'] = 'Visa block under försök på test';
$string['showblocks_help'] = 'Om satt till ja kommer normala block att visas under försök av test';
$string['showbreaks'] = 'Visa sidbrytningar';
$string['showcategorycontents'] = 'Visa innehåll i kategori {$a->arrow}';
$string['showcorrectanswer'] = 'Vill Du visa de rätta svaren i återkopplingen?';
$string['showdetailedmarks'] = 'Visa detaljerad betygsinformation';
$string['showeachpage'] = 'Visa en sida i taget';
$string['showfeedback'] = 'Vill Du visa återkoppling efter det att frågorna är besvarade?';
$string['showinsecurepopup'] = 'Använd ett "säkert" popup-fönster för försök på test';
$string['showlargeimage'] = 'Stor bild';
$string['shownoattempts'] = 'Visa de studenter/elever/deltagare/lärande som inte har gjort några försök';
$string['shownoattemptsonly'] = 'Visa bara studenter/elever/deltagare/lärande som inte har gjort några försök';
$string['shownoimage'] = 'Ingen bild';
$string['showreport'] = 'Visa rapport';
$string['showsmallimage'] = 'Liten bild';
$string['showteacherattempts'] = 'Visa de försök som(distans)lärare har gjort';
$string['showuserpicture'] = 'Visa användarens bild';
$string['showuserpicture_help'] = 'Om aktiverat kommer elevens namn och bild visas på skärmen under försöket, och på översiktsvyn, vilket gör det enklare att kontrollera att eleven har loggat in som sig själv i ett övervakat test.';
$string['shuffle'] = 'Blanda om';
$string['shuffleanswers'] = 'Frågorna skall ges i slumpmässig ordning';
$string['shuffledrandomly'] = 'Slumpmässigt ändrad ordningsföljd';
$string['shufflequestions'] = 'Svarsalternativen skall ges i slumpmässig ordning';
$string['shufflequestionsselected'] = 'Blanda frågor har ställts in, så vissa åtgärder som rör sidor är inte tillgängliga. För att ändra blandningsinställningen, {$a}.';
$string['shufflewithin'] = 'Blanda om inom frågorna';
$string['shufflewithin_help'] = '<p>Om du aktiverar det här alternativet då kommer de delar som bygger upp
de enskilda frågorna att slumpmässigt blandas varje gång en student/elev/deltagare/lärande
påbörjar ett försök med det här testet, detta under förutsättning att alternativet även är aktiverat i inställningarna för frågan.  </p>

<p>Avsikten är bara att göra det lite svårare för folk att kopiera av varandra.</p>

<p>Det här gäller bara frågor som består av flera delar som t.ex. flervalsfrågor och para-ihop-frågor. Ordningen för flervalsfrågor blandas bara när det här alternativet är aktiverat.
Svaren till para-ihop-frågor blandas alltid, i det fallet styr den här inställningen bara huruvida även ordningsföljden på paren av frågor-svar ska blandas.</p>

<p>Det här alternativet har ingenting med användningen av slumpmässiga frågor att göra. </p>';
$string['singleanswer'] = 'Välj ett svar';
$string['sortage'] = 'Sortera enligt ålder';
$string['sortalpha'] = 'Sortera enligt alfabetet';
$string['sortquestionsbyx'] = 'Sortera frågor enligt: {$a}';
$string['sortsubmit'] = 'Sortera frågor';
$string['sorttypealpha'] = 'Sortera enligt typ, namn';
$string['specificapathnotonquestion'] = 'Den angivna sökvägen till filen finns inte med i den angivna frågan';
$string['specificquestionnotonquiz'] = 'Den angivna frågan finns inte med i det angivna testet';
$string['startagain'] = 'Starta om';
$string['startattempt'] = 'Starta försök';
$string['startedon'] = 'Startad (när)';
$string['startnewpreview'] = 'Starta ny förhandsgranskning';
$string['stateabandoned'] = 'Aldrig inskickad';
$string['statefinished'] = 'Slutfört';
$string['statefinisheddetails'] = 'Inskickat {$a}';
$string['stateinprogress'] = 'Pågående';
$string['statenotloaded'] = 'Status för frågan {$a} har inte laddats från databasen';
$string['stateoverdue'] = 'Tiden har gått ut';
$string['stateoverduedetails'] = 'Måste skickas in av {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Avbryt vid fel';
$string['submitallandfinish'] = 'Skicka in allt och avsluta';
$string['subneterror'] = 'Det här testet är tyvärr bara tillgängligt från speciella ställen. Den dator som Du använder tillhör inte de datorer som Du kan använda för att göra testet.';
$string['subnetnotice'] = 'Det här testet har låsts så att det bara är tillgängligt från vissa platser. Din dator tillhör inte ett undernät med behörighet. Som lärare kan Du ändå förhandsgranska testet.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quizaccess'] = 'Åtkomstregel';
$string['subplugintype_quizaccess_plural'] = 'Åtkomstregler';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['substitutedby'] = 'kommer att ersättas av';
$string['summaryofattempt'] = 'Sammanfattning av försök';
$string['summaryofattempts'] = 'Sammanfattning av dina tidigare försök';
$string['temporaryblocked'] = 'Du får för tillfället inte göra om försöket på testet. <br />Du kommer att få pröva igen på:';
$string['theattempt'] = 'Försöket';
$string['theattempt_help'] = 'Om eleven kan granska försöket överhuvud taget.';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Genomförd';
$string['timedelay'] = 'Du får inte göra testet eftersom det återstår tid i den tidsfördröjning som gäller innan Du får fortsätta med ett annat test.';
$string['timeleft'] = 'Återstående tid';
$string['timelimit'] = 'Tidsbegränsning';
$string['timelimitexeeded'] = 'Tyvärr! Du har överskridit tiden för testet!';
$string['timelimit_help'] = '<p align="center"><strong>Tidsbegr&auml;nsning</strong></p>
<p>Som f&ouml;rinst&auml;lld standard s&aring; har test inte n&aring;gon tidsbegr&auml;nsning.
Studenter/elever/deltagare/l&auml;rande kan allts&aring; anv&auml;nda hur mycket tid de vill f&ouml;r
att g&ouml;ra f&auml;rdigt ett test. </p>
<p>Om Du anger en specifik tidsbegr&auml;nsning s&aring; h&auml;nder ett antal saker som syftar till att
testet ska fullf&ouml;ljas inom den tiden:</p>
<ul>
  <li>St&ouml;d f&ouml;r Javascript i webbl&auml;saren blir obligatoriskt - detta g&ouml;r det m&ouml;jligt f&ouml;r tidtagaren att fungera p&aring; ett korrekt s&auml;tt</li>
  <li>Ett flytande f&ouml;nster med tidtagaren och med nedr&auml;kning visas</li>
  <li>N&auml;r tidtagaren visar att tiden &auml;r ute s&aring; skickas de s&aring; l&aring;ngt genomf&ouml;rda testet in
  i befintligt skick</li>
  <li>Om en student/elev/deltagare/l&auml;rande lyckas fuska och anv&auml;nder mer &auml;n 60 sekunder ut&ouml;ver den till&aring;tna tiden
  s&aring; ges testet automatiskt betyget/omd&ouml;met 0.</li>
</ul>';
$string['timelimitmin'] = 'Tidsbegränsning (minuter)';
$string['timelimitsec'] = 'Tidsbegränsning (sekunder)';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Tiden är slut!';
$string['timetaken'] = 'Tid för genomförande';
$string['timing'] = 'Tidtagning';
$string['tofile'] = 'Ingen fil';
$string['tolerance'] = 'Tolerans';
$string['toomanyrandom'] = 'Antalet frågor som skall slumpas fram är fler än antalet tillgängliga frågor i kategorin! ({$a})';
$string['top'] = 'Topp';
$string['totalmarksx'] = 'Sammanfattning av betyg/omdömen: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totalt {$a} frågor i kategori.';
$string['true'] = 'Sant';
$string['truefalse'] = 'Sant/Falskt';
$string['type'] = 'Typ';
$string['unfinished'] = 'öppen';
$string['ungraded'] = 'Inte bedömd/betygssatt';
$string['unit'] = 'Enhet';
$string['unknowntype'] = 'Frågetypen stödjs inte på rad {$a}. Hänsyn kommer inte att tas till frågan.';
$string['unusedcategorydeleted'] = 'Den här kategorin har tagits bort eftersom frågorna inte användes på servern längre efter det att kursen tagits bort.';
$string['updatesettings'] = 'Uppdatera inställningarna för test';
$string['updatingatttemptgrades'] = 'Uppdaterar betyg för försök.';
$string['updatingfinalgrades'] = 'Uppdaterar slutliga betyg.';
$string['updatingthegradebook'] = 'Uppdaterar betygsbok.';
$string['upgradesure'] = '<div style="color: red;">Modulen Test kommer att genomföra en omfattande förändring av testtabellerna och den här uppgraderingen har inte testats tillräckligt. Vi rekommenderar starkt att Du säkerhetskopierar Din databas innan Du fortsätter.</div>';
$string['upgradingquizattempts'] = 'Uppgraderar försök på test: test {$a->done}/{$a->outof} (Test id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Uppgraderar väldigt gamla testförsök: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Den här kategorin har flyttats till webbplatsnivån efterom dess frågor användes av andra test på servern efter det att kursen tagits bort.';
$string['useroverrides'] = 'Överskridanden för användare';
$string['usersnone'] = 'Inga studenter/elever/deltagare/lärande har tillgång till detta test. ';
$string['validate'] = 'Validera';
$string['viewallanswers'] = 'Visa {$a} genomförda test';
$string['viewallreports'] = 'Visa rapporter för {$a} försök';
$string['viewed'] = 'Granskad';
$string['warningmissingtype'] = '<b>Den här frågan är av en typ som inte har installerats på Din Moodle-instans ännu.<br />Var snäll och gör Din Moodle administratör uppmärksam på detta.</b>';
$string['wheregrade'] = 'Var är mitt omdöme/betyg?';
$string['wildcard'] = 'Wild card';
$string['windowclosing'] = 'Det här fönstret kommer strax att stängas.';
$string['withsummary'] = 'med sammanfattande statistik';
$string['wronguse'] = 'Det går inte att använda sidan så';
$string['xhtml'] = 'XHTML-format';
$string['youneedtoenrol'] = 'Du måste registrera dig på den här kursen innan du får göra ett försök på testet.';
$string['yourfinalgradeis'] = 'Ditt slutgiltiga betyg för detta test är {$a}.';
