<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sv', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'på väg att installeras';
$string['action'] = 'Åtgärd';
$string['actionchoice'] = 'Vad vill du göra med filen \'{$a}\'?';
$string['actions'] = 'Åtgärder';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktiva användare';
$string['activities'] = 'Aktiviteter';
$string['activities_help'] = 'Aktiviteter, såsom forum, frågesporter och wikis, aktiverar interaktivt innehåll som kan läggas till kursen.';
$string['activity'] = 'Aktivitet';
$string['activityclipboard'] = 'Flyttar denna aktivitet: <b>{$a}</b>';
$string['activityiscurrentlyhidden'] = 'Tyvärr, den här aktiviteten är för tillfället dold.';
$string['activitymodule'] = 'Aktivitetsmodul';
$string['activitymodules'] = 'Aktivitetsmoduler';
$string['activityreport'] = 'Aktivitetsrapport';
$string['activityreports'] = 'Aktivitetsrapporter';
$string['activityselect'] = 'Välj den här aktiviteten och flytta den någon annanstans.';
$string['activitysince'] = 'Aktiviteter sedan {$a}';
$string['activityweighted'] = 'Aktivitet per användare';
$string['add'] = 'Lägg till';
$string['addactivity'] = 'Lägg till en aktivitet...';
$string['addactivitytosection'] = 'Lägg en aktivitet i sektion \'{$a}\'';
$string['addadmin'] = 'Lägg till administratör';
$string['addblock'] = 'Lägg till ett block';
$string['addcomment'] = 'Lägg till en kommentar...';
$string['addcountertousername'] = 'Skapa en användare genom att lägga till ett tal till användarnamnet';
$string['addcreator'] = 'Lägg till kursutvecklare';
$string['adddots'] = 'Lägg till...';
$string['added'] = 'Lade till {$a}';
$string['addedrecip'] = 'Lade till {$a} ny mottagare';
$string['addedrecips'] = 'Lade till {$a} nya mottagare';
$string['addedtogroup'] = 'Lade till till grupp "{$a}"';
$string['addedtogroupnot'] = 'Inte tillagd till grupp "{$a}"';
$string['addedtogroupnotenrolled'] = 'Inte tillagd till grupp "{$a}" eftersom användar/en/na inte är registrerad/e på kursen.';
$string['addfilehere'] = 'Lägg till fil (er) här';
$string['addinganew'] = 'Lägger till en ny {$a}';
$string['addinganewto'] = 'Lägger till en ny {$a->what} till {$a->to}';
$string['addingdatatoexisting'] = 'Lägger till nya data';
$string['additionalnames'] = 'Ytterligare namn';
$string['addlinkhere'] = 'Lägg till länk här';
$string['addnewcategory'] = 'Lägg till en ny kategori';
$string['addnewcourse'] = 'Lägg till en ny kurs';
$string['addnewuser'] = 'Lägg till en ny användare';
$string['addnousersrecip'] = 'Lägg till användare som inte har har besökt den här {$a} till listan över mottagare.';
$string['addpagehere'] = 'Lägg till text här';
$string['addresource'] = 'Lägg till en resurs...';
$string['addresourceoractivity'] = 'Lägg till en aktivitet eller resurs';
$string['addresourcetosection'] = 'Lägg till en resurs i avsnitt \'{$a}\'';
$string['address'] = 'Adress';
$string['addstudent'] = 'Lägg till en ny student/elev/deltagare/lärande';
$string['addsubcategory'] = 'Lägg till en underkategori';
$string['addteacher'] = 'Lägg till distanslärare/handledare/coach';
$string['admin'] = 'Administration';
$string['adminhelpaddnewuser'] = 'För att skapa ett nytt användarkonto manuellt';
$string['adminhelpassignadmins'] = 'Administratörer kan göra vad som helst och har tillgång till hela applikationen';
$string['adminhelpassigncreators'] = 'Kursutvecklare kan skapa nya kurser och undervisa i dem.';
$string['adminhelpassignsiteroles'] = 'Tillämpa de roller som har definierats på webbplatsnivå för specifika användare.';
$string['adminhelpassignstudents'] = 'Gå in i en kurs och lägg till studenter/elever/deltagare/lärande från menyn för administration.';
$string['adminhelpauthentication'] = 'Du kan använda interna användarkonton eller externa databaser.';
$string['adminhelpbackup'] = 'Konfigurera hur säkerhetskopiering/ar  fungerar';
$string['adminhelpconfiguration'] = 'Konfigurera webbplatsens utseende och funktion.';
$string['adminhelpconfigvariables'] = 'Konfigurera de variabler som påverkar webbplatsen på ett övergripande sätt.';
$string['adminhelpcourses'] = 'Definiera kurser/kategorier. Ge användare tillgång, behörigheter och rättigheter till dem.';
$string['adminhelpeditorsettings'] = 'Definiera de grundläggande inställningarna för HTML-redigeraren.';
$string['adminhelpedituser'] = 'Gå igenom förteckningen över konton och
redigera valfritt konto.';
$string['adminhelpenvironment'] = 'Kontrollera hur Din server fungerar i förhållande till aktuella och framtida krav för installation.';
$string['adminhelpfailurelogs'] = 'Blädda igenom loggarna för att hitta misslyckade försök att logga in.';
$string['adminhelplanguage'] = 'För att kontrollera och redigera det aktuella språkpaketet.';
$string['adminhelplogs'] = 'Gå igenom dokumentationen (loggarna) för alla aktiviteter på webbplatsen.';
$string['adminhelpmanageblocks'] = 'Hantera installerade block och deras inställningar.';
$string['adminhelpmanagedatabase'] = 'Direkt åtkomst till databasen. Var försiktig!';
$string['adminhelpmanagefilters'] = 'Välj textfilter och därmed sammanhängande inställningar.';
$string['adminhelpmanagemodules'] = 'Administrera de installerade modulerna och deras inställningar.';
$string['adminhelpmanageroles'] = 'Skapa och definiera roller som ska kunna tillämpas för användare.';
$string['adminhelpmymoodle'] = 'Konfigurera MittMoodle-block för användare.';
$string['adminhelpreports'] = 'Rangordning av kurser enligt olika kriterier.';
$string['adminhelpsitefiles'] = 'För att publicera allmänna filer eller ladda upp externa säkerhetskopior.';
$string['adminhelpsitesettings'] = 'Definiera hur ingångssidan (första/hem) på webbplatsen ska se ut.';
$string['adminhelpstickyblocks'] = 'Konfigurera sådana permanenta block som gäller för hela Moodle.';
$string['adminhelpthemes'] = 'Välj hur webbplatsen ska se ut (färger, typsnitt osv.';
$string['adminhelpuploadusers'] = 'Importera nya användarkonton från en textfil.';
$string['adminhelpusers'] = 'Definiera Dina användare och sätt upp autenticering.';
$string['adminhelpxmldbeditor'] = 'Gränssnitt för att redigera XMLDB-filerna. Endast för utvecklare.';
$string['administration'] = 'Administration  av kurs';
$string['administrationsite'] = 'Administration av webbplats';
$string['administrator'] = 'Administratör';
$string['administratordescription'] = 'Administratörer kan normalt sett göra allt på webbplatsen, i alla kurser.';
$string['administrators'] = 'Administratörer';
$string['administratorsall'] = 'Alla administratörer';
$string['administratorsandteachers'] = 'Administratörer och (distans)lärare';
$string['advanced'] = 'Avancerad';
$string['advancedfilter'] = 'Avancerade filter';
$string['advancedsettings'] = 'Avancerade inställningar';
$string['afterresource'] = 'Efter resurs "{$a}"';
$string['aftersection'] = 'Efter sektion "{$a}"';
$string['again'] = 'Igen';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX och Javascript';
$string['all'] = 'Alla';
$string['allactions'] = 'Alla åtgärder';
$string['allactivities'] = 'Alla aktiviteter';
$string['allcategories'] = 'Alla kategorier';
$string['allchanges'] = 'Alla ändringar';
$string['alldays'] = 'Alla dagar';
$string['allfieldsrequired'] = 'Alla fält krävs';
$string['allfiles'] = 'Alla filer';
$string['allgroups'] = 'Alla grupper';
$string['alllogs'] = 'Alla loggar';
$string['allmods'] = 'Alla {$a}';
$string['allow'] = 'Tillåt';
$string['allowinternal'] = 'Tillåt även interna metoder.';
$string['allownone'] = 'Tillåt en';
$string['allownot'] = 'Tillåt inte';
$string['allparticipants'] = 'Alla deltagare';
$string['allteachers'] = 'Alla lärare';
$string['alphanumerical'] = 'Kan endast innehålla alfanumeriska tecken, bindestreck (-) eller punkt (.)';
$string['alreadyconfirmed'] = 'Registreringen har redan bekräftats.';
$string['alternatename'] = 'Alternativt namn';
$string['always'] = 'Alltid';
$string['and'] = '{$a->one} och  {$a->two}';
$string['answer'] = 'Svar';
$string['any'] = 'Vilken/a som helst';
$string['appearance'] = 'Utseende';
$string['approve'] = 'Godkänn';
$string['areyousuretorestorethis'] = 'Vill Du fortsätta?';
$string['areyousuretorestorethisinfo'] = 'Senare i den här processen kommer Du att kunna välja om Du vill lägga till den här säkerhetskopieringen till en befintlig kurs eller om Du vill skapa en helt ny kurs.';
$string['asc'] = 'Stigande';
$string['assessment'] = 'Rättning/bedömning/(ut)värdering/betygssättning/examination';
$string['assignadmins'] = 'Registrera administratörer';
$string['assigncreators'] = 'Registrera kursutvecklare';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tilldela roller som är giltiga på webbplatsnivå.';
$string['authenticateduser'] = 'Autenticerad användare';
$string['authenticateduserdescription'] = 'Alla inloggade användare';
$string['authentication'] = 'Autenticering';
$string['authenticationplugins'] = 'Plugin-program för autenticering';
$string['autosubscribe'] = 'Automatisk prenumeration på forum';
$string['autosubscribeno'] = 'Nej, jag vill inte bli automatiskt registrerad som prenumerant på forum.';
$string['autosubscribeyes'] = 'Ja, registrera mig som prenumerant när jag gör ett inlägg i ett visst forum.';
$string['availability'] = 'Tillgänglighet';
$string['availablecourses'] = 'Tillgängliga kurser';
$string['back'] = 'Tillbaka';
$string['backto'] = 'Tillbaka till {$a}';
$string['backtocourselisting'] = 'Tillbaka till listan över kurser';
$string['backtopageyouwereon'] = 'Tillbaka till föregående sida';
$string['backtoparticipants'] = 'Tillbaka till deltagarförteckningen';
$string['backup'] = 'Säkerhetskopiering';
$string['backupactivehelp'] = 'Välj huruvida Du vill ställa in automatisk säkerhetskopiering eller inte.';
$string['backupcancelled'] = 'Säkerhetskopieringen är avbruten.';
$string['backupcoursefileshelp'] = 'Om den här inställningen är aktiverad så kommer kursfilerna automatiskt att tas med i säkerhetskopieringarna.';
$string['backupdate'] = 'Datum för säkerhetskopiering.';
$string['backupdatenew'] = '{$a->TAG} är nu {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} var {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaljerad info om säkerhetskopiering';
$string['backupexecuteathelp'] = 'Välj vid vilken tid automatiska säkerhetskopieringar ska genomföras.';
$string['backupfailed'] = 'Några av Dina kurser sparades inte!';
$string['backupfilename'] = 'säkerhetskopiering';
$string['backupfinished'] = 'Säkerhetskopieringen framgångsrikt avslutad.';
$string['backupfromthissite'] = 'Har den den här webbplatsen säkerhetskopierats?';
$string['backupgradebookhistoryhelp'] = 'Om detta är aktiverat då kommer historiken för betygskatalogen att ingå i automatiska säkerhetskopieringar. Observera att Du inte behöver avaktivera historiken för betygssättningen i inställningarna för servern (disablegradehistory) för att detta ska fungera.';
$string['backupincludemoduleshelp'] = 'För att välja om Du vill ta med kursmoduler med eller utan användardata i säkerhetskopieringen.';
$string['backupincludemoduleuserdatahelp'] = 'Välj huruvida Du vill ta med användardata för modul i automatiska säkerhetskopieringar.';
$string['backupkeephelp'] = 'Hur många säkerhetskopierade filer för varje kurs vill Du ha kvar på hårddisken? (de äldsta tas automatiskt bort).';
$string['backuplogdetailed'] = 'Detaljerad logg över genomförandet.';
$string['backuploglaststatus'] = 'Den senaste loggen över genomförande.';
$string['backupmissinguserinfoperms'] = 'Obs: Denna säkerhetskopia innehåller inga användardata. Övnings och Workshop aktiviteterna kommer inte att ingå i säkerhetskopian, eftersom dessa moduler inte är kompatibla med den här typen av säkerhetskopiering.';
$string['backupnext'] = 'Nästa säkerhetskopiering';
$string['backupnonisowarning'] = 'Varning: Den här säkerhetskopian kommer från en icke-Unicode version av Moodle (före 1.6) Om den här säkerhetskopian innehåller texter i icke-ISO-8859-1 då kan de bli FÖRVRÄNGDA om Du försöker återställa dem till den här Unicode versionen av Moodle. Se <a href="http://docs.moodle.org/en/Backup_FAQ">FAQ angående säkerhetskopior</a> om Du vill ha utförligare information om hur man kan återställa den här säkerhetskopian på ett korrekt sätt.';
$string['backupnotyetrun'] = 'Avvaktar automatisk backup';
$string['backuporiginalname'] = 'Namn på säkerhetskopian';
$string['backuproleassignments'] = 'Säkerhetskopiera rolltilldelningarna för dessa roller';
$string['backupsavetohelp'] = 'Hela sökvägen till katalogen där Du vill spara de säkerhetskopierade filerna <br /> Om Du vill spara dem i standardkatalogen så behöver Du inte fylla i något här.';
$string['backupsitefileshelp'] = 'Om detta är aktiverat så kommer de filer på webbplatsen som används i kurser att  tas med vid automatisk säkerhetskopiering.';
$string['backuptakealook'] = 'Var snäll och kontrollera Din loggar för säkerhetskopiering i: {$a}';
$string['backupuserfileshelp'] = 'Välj om Du vill ta med användarfiler (avatarer eller bilder ur profilen) i den automatiska säkerhetskopieringen.';
$string['backupversion'] = 'Säkerhetskopians version';
$string['badges'] = 'Badges';
$string['block'] = 'Block';
$string['blockconfiga'] = 'Konfigurerar ett {$a} block';
$string['blockconfigbad'] = 'Det här blocket har inte implementerats på ett korrekt sätt och kan därför inte erbjuda något gränssnitt för konfiguration.';
$string['blocks'] = 'Block';
$string['blocksaddedit'] = 'Lägg till/Redigera block';
$string['blockseditoff'] = 'Redigering av block är avaktiverat';
$string['blocksediton'] = 'Redigering av block är aktiverat';
$string['blocksetup'] = 'Sätter upp tabeller för block';
$string['blocksuccess'] = '{$a} tabeller har satts upp korrekt';
$string['brief'] = 'Kortfattat';
$string['bulkactions'] = 'Massåtgärder';
$string['bulkactionselect'] = '{$a} bulk åtgärdsval';
$string['bulkmovecoursessuccess'] = 'Framgångsrikt flyttat {$a->courses} kurser till {$a->category}';
$string['bycourseorder'] = 'Ordna enligt kurser';
$string['byname'] = 'av {$a}';
$string['bypassed'] = 'Förbikopplad';
$string['cachecontrols'] = 'Kontroller av cache';
$string['cancel'] = 'Återställ';
$string['cancelled'] = 'Avbruten';
$string['categories'] = 'Kurskategorier';
$string['categoriesandcoures'] = 'Kurskategorier och kurser';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorin \'{$a}\' lades till';
$string['categorybulkaction'] = 'Bulk åtgärdsval för valda kategorier';
$string['categorycontents'] = 'Underkategorier och kurser';
$string['categorycurrentcontents'] = 'Innehåll i {$a}';
$string['categorydeleted'] = 'Kategorin \'{$a}\' togs bort';
$string['categoryduplicate'] = 'Kategorin \'{$a}\' finns redan!';
$string['categorymodifiedcancel'] = 'Kategorin har modifierats! Var snäll och avbryt och prova igen.';
$string['categoryname'] = 'Namn på kategori';
$string['categorysubcategoryof'] = '{$a->category} - underkategori av {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorin \'{$a}\' uppdaterades';
$string['changedpassword'] = 'Ändrat lösenord';
$string['changepassword'] = 'Ändra lösenord';
$string['changesmadereallygoaway'] = 'Du har utfört förändringar. Är du säker på att du vill navigera bort och bli av med de?';
$string['changessaved'] = 'Ändringar sparade';
$string['check'] = 'Kontrollera';
$string['checkall'] = 'Kontrollera alla';
$string['checkingbackup'] = 'Kontrollerar säkerhetskopia';
$string['checkingcourse'] = 'Kontrollerar kurs';
$string['checkingforbbexport'] = 'Kontrollerar om det finns något som har exporteras från Blackboard.';
$string['checkinginstances'] = 'Kontrollerar instanser';
$string['checkingsections'] = 'Kontrollerar sektioner';
$string['checklanguage'] = 'Kontrollera språk';
$string['checknone'] = 'Kontrollera inte någon';
$string['childcoursenotfound'] = '"Barn"-kurs hittades inte';
$string['childcourses'] = '"Barn"-kurser';
$string['choose'] = 'Välj';
$string['choosecourse'] = 'Välj en kurs';
$string['choosedots'] = 'Välj...';
$string['chooselivelogs'] = 'Eller se på nuvarande aktivitet';
$string['chooselogs'] = 'Välj vilka loggar Du vill se';
$string['choosereportfilter'] = 'Välj ett filter för rapporten';
$string['choosetheme'] = 'Välj layouttema';
$string['chooseuser'] = 'Välj en användare';
$string['city'] = 'Stad/ort';
$string['clambroken'] = 'Din systemadministratör har aktiverat viruskontroll av uppladdade filer men<br> något är felaktigt inställt. Din fil laddades INTE upp på rätt sätt.<br />Din systemadministratör har fått ett e-postmeddelande om detta så det ska gå att rätta till det.<br />Försök att ladda upp Din fil igen senare.';
$string['clamdeletedfile'] = 'Den här filen har tagits bort.';
$string['clamdeletedfilefailed'] = 'Det gick inte att ta bort den här filen.';
$string['clamemailsubject'] = '{$a} :: Clam AV meddelande';
$string['clamfailed'] = 'Det gick inte att köra Clam AV. Felmeddelandet var {$a}. Här är felbeskrivningen:';
$string['clamlost'] = 'Moodle är inställt så att clam ska köras när någon laddar upp filer men den sökväg som är angiven för Clam AV, {$a}, är inte giltig.';
$string['clamlostandactinglikevirus'] = 'Dessutom så är Moodle inställt så att om det inte går att köra Clam så behandlas alla filer som virus. Det innebär i klartext att Du måste ordna till det här för att det ska vara möjligt att ladda upp filer till systemet.';
$string['clammovedfile'] = 'Filen har flyttats till den katalog för misstänkta filer som Du har angivit, den nya platsen är {$a}';
$string['clammovedfilebasic'] = 'Filen har flyttats till katalogen för misstänkta filer.';
$string['clamquarantinedirfailed'] = 'Det gick inte att flytta filen till den katalog för misstänkta filer som Du har angivit, {$a}. Du behöver ta tag i detta eftersom filerna kommer att tas bort om det visar sig att de innehåller virus.';
$string['clamunknownerror'] = 'Det uppstod ett okänt fel med Clam.';
$string['cleaningtempdata'] = 'Tömmer tillfälliga data';
$string['clear'] = 'Rensa';
$string['clickhelpiconformoreinfo'] = '... fortsätter ... Klicka på ikonen för hjälp för att läsa hela artikeln';
$string['clickhere'] = 'Klicka här...';
$string['clicktochangeinbrackets'] = '{$a} (Klicka för att förstora)';
$string['clicktohideshow'] = 'Klicka för att expandera eller fälla ihop';
$string['closewindow'] = 'Stäng detta fönster';
$string['collapse'] = 'Fäll ihop';
$string['collapseall'] = 'Fäll ihop all/t/a';
$string['collapsecategory'] = 'Komprimera {$a}';
$string['commentincontext'] = 'Hitta den här kommentaren i sitt sammanhang';
$string['comments'] = 'Kommentarer';
$string['commentsnotenabled'] = 'Kommentar funktionaliteten är inte aktiverad.';
$string['commentsrequirelogin'] = 'Du måste logga in för att visa kommentarerna';
$string['comparelanguage'] = 'Jämför och redigera det aktuella språket.';
$string['complete'] = 'Komplett';
$string['completereport'] = 'Komplett rapport';
$string['configuration'] = 'Konfiguration';
$string['confirm'] = 'Bekräfta';
$string['confirmcheckfull'] = 'Är Du helt säker på att Du vill bekräfta {$a} ?';
$string['confirmcoursemove'] = 'Är du säker på att du vill flytta den här kursen ({$a->course}) in i den här kategorin ({$a->category})?';
$string['confirmed'] = 'Din registrering har blivit bekräftad.';
$string['confirmednot'] = 'Din registrering har ännu inte blivit bekräftad.';
$string['content'] = 'Innehåll';
$string['continue'] = 'Nästa';
$string['continuetocourse'] = 'Klicka här för få tillträde till Din kurs.';
$string['convertingwikitomarkdown'] = 'Konverterar Wiki till Markdown';
$string['cookiesenabled'] = 'Du måste aktivera \'Cookies\' i inställningarna till din webbläsare.';
$string['cookiesenabled_help'] = '<p>Den h&auml;r webbplatsen anv&auml;nder tv&aring; \'cookies\'.\'Cookies\' &auml;r sm&aring; filer som kan
inneh&aring;lla en kort text. Servern kan lagra s&aring;dana filer p&aring; Din h&aring;rddisk.
N&auml;r Du &aring;terv&auml;nder till samma server s&aring; kan den komma ih&aring;g Dig.
</p><p>Endast den server som har lagt in \'cookien\' kan l&auml;sa den. \'Cookies\' &auml;r inte en
ink&ouml;rsport f&ouml;r datavirus. Du kan sj&auml;lv, via Din webbl&auml;sares inst&auml;llningar,
 best&auml;mma om Du vill till&aring;ta \'cookies\' eller ej.</p>
 <p>Den viktigaste &auml;r \'cookien\' f&ouml;r sessioner, vanligtvis kallad <b>MoodleSession</b>.
Du m&aring;ste till&aring;ta denna \'cookie\' i Din webbl&auml;sare
f&ouml;r att bibeh&aring;lla Din login-information fr&aring;n sida till sida i v&aring;r l&auml;romilj&ouml;.</p>
<p>N&auml;r Du loggar ut eller st&auml;nger av webbl&auml;saren tas \'cookien\' automatiskt bort,
b&aring;de fr&aring;n Din webbl&auml;sare och fr&aring;n servern.</p>
<p>Den andra \'cookien\'  &auml;r bara till f&ouml;r ren bekv&auml;mlighet.
Den kallas oftast f&ouml;r n&aring;got i stil med <b>MOODLEID</b>.
Den kommer bara ih&aring;g Ditt anv&auml;ndarnamn i webbl&auml;saren.
Detta inneb&auml;r att n&auml;r Du bes&ouml;ker l&auml;romilj&ouml;n n&auml;sta g&aring;ngs&aring; kommer anv&auml;ndarnamnet redan att vara ifyllt.</p>
<p>Du kan om Du vill avaktivera denna funktion. Det inneb&auml;r is&aring;fall bara
att Du m&aring;ste skriva in Ditt anv&auml;ndarnamn
varje g&aring;ng Du loggar in.</p>';
$string['cookiesnotenabled'] = 'Cookies är f.n. tyvärr inte aktiverade i inställningarna till Din webbläsare.';
$string['copy'] = 'Kopiera';
$string['copyasnoun'] = 'kopiera';
$string['copyingcoursefiles'] = 'Kopiera kursfiler...';
$string['copyingsitefiles'] = 'Kopierar filer på webbplatsen som används i kurs';
$string['copyinguserfiles'] = 'Kopierar användarfiler...';
$string['copyingzipfile'] = 'Kopierar zip.fil...';
$string['copyrightnotice'] = 'Meddelande om upphovsrätt';
$string['coresystem'] = 'Kärnsystem';
$string['cost'] = 'Kostnad';
$string['costdefault'] = 'Standardkostnad';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administration av kurs';
$string['courseapprovedemail'] = 'Den kurs som Du har beställt {$a->name} har blivit godkänd och Du har blivit registrerad som {$a->teacher}. För att få tillgång till Din kurs, gå till {$a->url}';
$string['courseapprovedemail2'] = 'Den kurs som Du har efterfrågat, {$a->name}, har beviljats. Här hittar Du Din nya kurs {$a->url}';
$string['courseapprovedfailed'] = 'Det gick inte att spara kursen som godkänd!';
$string['courseapprovedsubject'] = 'Din kurs har blivit godkänd!';
$string['courseavailable'] = 'Den här kursen är öppen för studenter/elever/deltagare/lärande.';
$string['courseavailablenot'] = 'Den här kursen är inte öppen för studenter/elever/deltagare/lärande.';
$string['coursebackup'] = 'Säkerhetskopiering  av kurs';
$string['coursebulkaction'] = 'Bulk åtgärdsval för valda kurser';
$string['coursecategories'] = 'Kategori av kurs';
$string['coursecategory'] = 'Kategorier av kurser';
$string['coursecategorydeleted'] = 'Tog bort kurskategorin {$a}';
$string['coursecategory_help'] = '<p>Din administratör av Moodle kan ha satt upp
ett flertal kategorier av kurser.</p>
<p>Till exempel, \'Naturvetenskap\', \'Humaniora\', \'Folkhälsa\' etc.</p>
<p>Välj det som passar in bäst på Din kurs.
Detta val kommer att påverka var i kurslistan Din kurs visas.
Detta gör det lättare för de lärande att hitta Din kurs.
</p>';
$string['coursecatmanagement'] = 'Kurs- och kategoriadministration';
$string['coursecompletion'] = 'Fullföljande av kurs';
$string['coursecompletions'] = 'Fullföljande av kurser';
$string['coursecreators'] = 'Kursutvecklare';
$string['coursecreatorsdescription'] = 'Kursutvecklare kan skapa nya kurser och undervisa i dem.';
$string['coursedeleted'] = 'Tog bort kursen {$a}';
$string['coursedisplay'] = 'Kurslayout';
$string['coursedisplay_help'] = 'Den här inställningen avgör huruvida kursen visas på en stor sida eller fördelad över över ett antal sidor. Inställningen har ingen effekt på visa kursformat såsom SCORM formatet.';
$string['coursedisplay_multi'] = 'Visa en sektion per sida';
$string['coursedisplay_single'] = 'Visa alla sektioner på en stor sida.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Ärvda kursfiler';
$string['coursefilesedit'] = 'Redigera ärvda kursfiler';
$string['coursefileswarning'] = 'Kursfilerna är föråldrade (deprecated)';
$string['coursefileswarning_help'] = 'Kursfiler används inte sedan Moodle 2,0, använd externa arkiv istället så mycket som möjligt.';
$string['courseformatdata'] = 'Data för kursformat';
$string['courseformatoptions'] = 'Formateringsalternativ för {$a}';
$string['courseformats'] = 'Kursformat';
$string['courseformatudpate'] = 'Uppdatera format';
$string['coursegrades'] = 'Kursbetyg';
$string['coursehelpcategory'] = 'Positionera kursen i kurslistan och gör det lättare för kursdeltagare att hitta den.';
$string['coursehelpforce'] = 'Tvinga kursens gruppläge till varje aktivitet i kursen.';
$string['coursehelpformat'] = 'Kursens ingångssida kommer att visas i detta format.';
$string['coursehelphiddensections'] = 'Hur de dolda sektionerna i kursen ska visas för studenter/elever/deltagare/lärande.';
$string['coursehelpmaximumupload'] = 'Ange en maximal storlek för de filer som kan laddas upp till den här kursen. Detta anger en begränsning som gäller för hela webbplatsen.';
$string['coursehelpnewsitemsnumber'] = 'Antal senaste nyheter från nyhetsforumet som visas i blocket för senaste nyheter på kurssidan. Om satt till noll så visas inte blocket.';
$string['coursehelpnumberweeks'] = 'Antal sektioner i kursen (enbart applicerbart på vissa kursformat).';
$string['coursehelpshowgrades'] = 'Aktivera visning av betygskatalogen. Det förhindrar inte att betyg/omdöme visas inom ramen för de individuella aktiviteterna.';
$string['coursehidden'] = 'Den här kursen är f.n. inte tillgänglig för studenter/elever/deltagare/lärande.';
$string['courseinfo'] = 'Kursinformation';
$string['courselegacyfiles'] = 'Ärvda kursfiler';
$string['courselegacyfiles_help'] = 'Området för kursfiler ger viss bakåtkompatibilitet med Moodle 1.9 och tidigare. Alla filer i detta område är alltid tillgängliga för alla deltagare i kursen (om du länkar till dem eller inte) och det finns inget sätt att veta om något av dessa filer används i Moodle.

Om du använder det här området för att lagra kursens filer kan du utsätta dig säkerhetsrelaterade problem. Du kan råka ut för saknade filer i säkerhetskopior, saknade filer i importerade kurser och saknade filer  vid ateranvändning av resurser och ativiteter.

Det rekommenderas därför att du inte använder kursfiler om du inte verkligen vet vad du gör. Länken nedan ger mer information om allt detta och kommer att visa dig några bättre sätt att hantera filer i Moodle 2.';
$string['courselegacyfilesofcourse'] = 'Äldre kursfiler: {$a}';
$string['coursemessage'] = 'Skicka meddelande användare av kursen.';
$string['coursenotaccessible'] = 'Den här kursen tillåter inte offentligt tillträde.';
$string['courseoverview'] = 'Översikt över kurser';
$string['courseoverviewfiles'] = 'Filer för kurssammanfattning';
$string['courseoverviewfilesext'] = 'Filändelser för kurssammanfattning';
$string['courseoverviewfiles_help'] = 'Filer för kurssammanfattning, exempelvis bilder, visas i listan på kurser tillsammans med sammanfattningen.';
$string['courseoverviewfileslimit'] = 'Maximalt antal filer för kurssammanfattning';
$string['courseoverviewgraph'] = 'Grafisk översikt över kurs';
$string['courseprofiles'] = 'Profiler för kurs';
$string['coursereasonforrejecting'] = 'Orsaker till att Du avslår denna förfrågan';
$string['coursereasonforrejectingemail'] = 'Detta kommer att skickas till med e-post till den som har gjort förfrågan.';
$string['coursereject'] = 'Avslå en ansökan om en kurs.';
$string['courserejected'] = 'Ansökan om kurs har avslagits och den som har ansökt kursen har fått meddelande om detta.';
$string['courserejectemail'] = 'Din ansökan om en kurs har avslagits av följande skäl: {$a}';
$string['courserejectreason'] = 'Gör ett utkast över Din motivering för att avslå den här kursen.';
$string['courserejectsubject'] = 'Din ansökan om kurs har avslagits';
$string['coursereport'] = 'Kursrapport';
$string['coursereports'] = 'Kursrapporter';
$string['courserequest'] = 'Ansökan om kurs';
$string['courserequestdetails'] = 'Detaljer angående den kurs Du efterfrågar';
$string['courserequestfailed'] = 'Av samma anledning gick det inte att spara Din ansökan om en kurs.';
$string['courserequestintro'] = 'Använd det här formuläret för att ansöka om att en kurs ska skapas för Dig.<br />Försök att fylla i så mycket information som möjligt för<br />att underlätta för administratörerna att förstå varför Du vill ha denna kurs.';
$string['courserequestreason'] = 'Skäl för att Du vill ha den här kursen.';
$string['courserequestsuccess'] = 'Din kursansökan har sparats. Du kommer få epost med information om ifall din ansökan godkändes.';
$string['courserequestsupport'] = 'Kompletterande information för att underlätta för administratören att utvärdera denna förfrågan.';
$string['courserestore'] = 'Återställ kurs';
$string['courses'] = 'Kurser';
$string['coursesectionsummaries'] = 'Sammanfattningar för sektioner i kurser';
$string['coursesettings'] = 'Förvalda standardinställningar för kurs';
$string['coursesmovedout'] = 'Kurser som har flyttats ut ur {$a}';
$string['coursespending'] = 'Kurser i kö för att bli godkända';
$string['coursestart'] = 'Startdatum för kurs';
$string['coursesummary'] = 'Sammanfattning av kurs';
$string['coursesummary_help'] = 'Kursen sammanfattning visas i listan över kurser. En kurs sökning söker text i kursen sammanfattning utöver kursnamnet.';
$string['courseupdates'] = 'Kursuppdatering';
$string['create'] = 'Skapa';
$string['createaccount'] = 'Skapa mitt nya konto';
$string['createcategory'] = 'Skapa kategori';
$string['createfolder'] = 'Skapa en mapp i {$a}';
$string['createnew'] = 'Skapa ny';
$string['createnewcategory'] = 'Skapa ny kategori';
$string['createnewcourse'] = 'Skapa ny kurs';
$string['createnewsubcategory'] = 'Skapa ny underkategori';
$string['createsubcategoryof'] = 'Skapa underkategori till {$a}';
$string['createuser'] = 'Skapa användare';
$string['createuserandpass'] = 'Skapa ett nytt användarnamn och lösenord för att logga in med.';
$string['createziparchive'] = 'Skapa ziparkiv';
$string['creatingblocks'] = 'Skapar block';
$string['creatingblocksroles'] = 'Skapar tilldelningar av, och överskridanden för, roller på blocknivå.';
$string['creatingblogsinfo'] = 'Skapar info om bloggar';
$string['creatingcategoriesandquestions'] = 'Skapar kategorier och frågor...';
$string['creatingcoursemodules'] = 'Skapar kursmoduler...';
$string['creatingcourseroles'] = 'Skapar tilldelningar av, och överskridanden för, roller på kursnivå.';
$string['creatingevents'] = 'Skapar händelser';
$string['creatinggradebook'] = 'Skapar betygs/omdömeskatalog';
$string['creatinggroupings'] = 'Skapar gruppindelningar';
$string['creatinggroupingsgroups'] = 'Lägger till grupper till grupperingar';
$string['creatinggroups'] = 'Skapar grupper';
$string['creatinglogentries'] = 'Skapar log \'entries\'...';
$string['creatingmessagesinfo'] = 'Skapar info om meddelanden';
$string['creatingmodroles'] = 'Skapar tilldelningar av, och överskridanden för, roller på modulnivå.';
$string['creatingnewcourse'] = 'Skapar en ny kurs...';
$string['creatingrolesdefinitions'] = 'Skapar definitioner av roller';
$string['creatingscales'] = 'Skapar skalor...';
$string['creatingsections'] = 'Skapar sektioner...';
$string['creatingtemporarystructures'] = 'Skapar tillfälliga strukturer...';
$string['creatinguserroles'] = 'Skapar tilldelningar av, och överskridanden för, roller på användarnivå.';
$string['creatingusers'] = 'Skapar användare...';
$string['creatingxmlfile'] = 'Skapar XML-fil...';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Aktuell kurs';
$string['currentcourseadding'] = 'Aktuell kurs, lägger till data...';
$string['currentcoursedeleting'] = 'Aktuell kurs, tar bort den först...';
$string['currentlanguage'] = 'Nuvarande språk';
$string['currentlocaltime'] = 'Din nuvarande lokala tid';
$string['currentlyselectedusers'] = 'F.n. valda användare';
$string['currentpicture'] = 'Aktuell bild';
$string['currentrelease'] = 'Aktuell information om \'release\'';
$string['currentversion'] = 'Aktuell version';
$string['databasechecking'] = 'Uppgraderar Moodles databas från version {$a->oldversion} till {$a->newversion}...';
$string['databaseperformance'] = 'Databasens prestanda';
$string['databasesetup'] = 'Sätter upp databas';
$string['databasesuccess'] = 'Databasen har uppgraderats';
$string['databaseupgradebackups'] = 'Säkerhetskopians versionen är nu {$a}';
$string['databaseupgradeblocks'] = 'Versionen av block är nu {$a}';
$string['databaseupgradegroups'] = 'Versionen av grupper är nu {$a}';
$string['databaseupgradelocal'] = 'Versionen av de lokala databasinställningarna är nu {$a}';
$string['databaseupgrades'] = 'Uppgraderar databas...';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum för ändring';
$string['datemostrecentfirst'] = 'Datum - det senaste först';
$string['datemostrecentlast'] = 'Datum - det senaste sist';
$string['day'] = 'dag';
$string['days'] = 'dagar';
$string['decodinginternallinks'] = 'Avkodar interna länkar';
$string['default'] = 'Standardvärde';
$string['defaultcoursestudent'] = 'Lärande';
$string['defaultcoursestudentdescription'] = 'Studenter/elever/deltagare/lärande har normalt sett färre rättigheter inom en kurs.';
$string['defaultcoursestudents'] = 'Lärande';
$string['defaultcoursesummary'] = 'Här kan Du skriva ett kortfattat och intressant stycke som förklarar vad denna kurs handlar om och vilka villkor som gäller för deltagande.';
$string['defaultcourseteacher'] = 'Distanslärare/<br />handledare/<br />coach etc';
$string['defaultcourseteacherdescription'] = '(Distans)lärare/handledare/mentorer/coacher  osv kan göra vad som helst inom ramen för   en kurs, inklusive det att ändra aktiviteter och betygssätta/avge omdömen om studenter/elever/deltagare/lärande.';
$string['defaultcourseteachers'] = 'Distanslärare/<br />handledare/<br />coacher etc';
$string['defaulteditor'] = 'Standardredigerare';
$string['delete'] = 'Ta bort';
$string['deleteablock'] = 'Ta bort ett block';
$string['deleteall'] = 'Ta bort alla';
$string['deleteallcannotundo'] = 'Ta bort allt - detta kan inte göras ogjort';
$string['deleteallcomments'] = 'Ta bort alla kommentarer';
$string['deleteallratings'] = 'Ta bort alla bedömningar/omdömen';
$string['deletecategory'] = 'Ta bort kategori: {$a}';
$string['deletecategorycheck'] = 'Är Du absolut säker på att Du vill ta bort den här kategorin <b>\'{$a}\'</b>?<br />Det här flyttar alla kurser till föräldrakategorin om det det finns någon eller till \'Övrigt\'.';
$string['deletecategorycheck2'] = 'Om du tar bort denna kategori måste du välja vad du vill göra med de kurser och underkategorier som den innehåller.';
$string['deletecategoryempty'] = 'Den här kategorin är tom.';
$string['deletecheck'] = 'Ta bort {$a} ?';
$string['deletecheckfiles'] = 'Är Du säker på att Du vill ta bort de här filerna?';
$string['deletecheckfull'] = 'Är Du säker på att Du vill ta bort hela {$a} ?';
$string['deletechecktype'] = 'Är du säker på att du vill ta bort denna {$a->type}?';
$string['deletechecktypename'] = 'Är du säker på att du vill ta bort {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Du håller på att ta bort dessa filer.';
$string['deletecomment'] = 'Ta bort den här kommentaren';
$string['deletecompletely'] = 'Ta bort helt';
$string['deletecourse'] = 'Ta bort en kurs';
$string['deletecoursecheck'] = 'Är Du säker på att Du vill ta bort hela denna kurs och alla data som den innehåller?';
$string['deleted'] = 'Borttaget';
$string['deletedactivity'] = 'Tog bort {$a}';
$string['deletedcourse'] = '{$a} har tagits bort helt';
$string['deletednot'] = 'Kunde inte ta bort {$a} !';
$string['deletelogs'] = 'Ta bort loggar';
$string['deleteselected'] = 'Ta bort det som är markerat';
$string['deleteselectedkey'] = 'Ta bort den valda nyckeln';
$string['deletingcourse'] = 'Tar bort {$a}';
$string['deletingexistingcoursedata'] = 'Tar bort befintliga kursdata';
$string['deletingolddata'] = 'Tar bort gamla data';
$string['department'] = 'Avdelning';
$string['desc'] = 'Fallande';
$string['description'] = 'Beskrivning';
$string['deselectall'] = 'Avmarkera allt';
$string['detailedless'] = 'Mindre detaljerad';
$string['detailedmore'] = 'Mer detaljerad';
$string['directory'] = 'Katalog';
$string['disable'] = 'Avaktivera';
$string['disabledcomments'] = 'Kommentarer är avaktiverat';
$string['displayingfirst'] = 'Bara de första {$a->count} {$a->things} visas.';
$string['displayingrecords'] = 'Visar {$a} poster';
$string['displayingusers'] = 'Visar användare {$a->start} till {$a->end}';
$string['displayonpage'] = 'Visa på sida';
$string['dndcourse'] = 'Du kan dra och släppa den här kursen för att ändra dess sortering eller för att flytta den till en annan kategori.';
$string['dndenabled_inbox'] = 'Du kan dra och släppa filer här för att lägga till dem.';
$string['dndnotsupported'] = 'Dra och släpp uppladdning stöds ej';
$string['dndnotsupported_help'] = 'Din webbläsare stödjer inte dra och släpp för uppladdning.</br>Den här funktionen är tillgänglig i alla nyare versioner av Chrome, Firefox and Safari, samt Internet Explorer version 10 eller högre.';
$string['dndnotsupported_insentence'] = 'Dra och släpp stöds ej';
$string['dnduploadwithoutcontent'] = 'Denna uppladdning har inget innehåll';
$string['dndworkingfile'] = 'Dra och släpp filer på kurssektioner för att ladda upp dem';
$string['dndworkingfilelink'] = 'Dra och släpp filer eller länkar på kurssektioner för att ladda upp dem';
$string['dndworkingfiletext'] = 'Dra och släpp filer eller text på kurssektioner för att ladda upp dem';
$string['dndworkingfiletextlink'] = 'Dra och släpp filer, text eller länkar på kurssektioner för att ladda upp dem';
$string['dndworkinglink'] = 'Dra och släpp länkar på kurssektioner för att ladda upp dem';
$string['dndworkingtext'] = 'Dra och släpp text på kursmoment att ladda upp den';
$string['dndworkingtextlink'] = 'Dra och släpp text eller länkar på kursmoment för att ladda upp dem';
$string['documentation'] = 'Dokumentation av Moodle';
$string['dontsortcategories'] = 'Sortera inte kategorier';
$string['dontsortcourses'] = 'Sortera inte kurser';
$string['down'] = 'Ner';
$string['download'] = 'Ladda ner';
$string['downloadall'] = 'Ladda ner allt';
$string['downloadexcel'] = 'Ladda ner i Excelformat';
$string['downloadfile'] = 'Ladda ner fil';
$string['downloadods'] = 'Ladda ner i ODS-format';
$string['downloadtext'] = 'Ladda ner i textformat';
$string['doyouagree'] = 'Har Du läst dessa villkor och förstått dem?';
$string['droptoupload'] = 'Släpp filer här för att ladda upp';
$string['duplicate'] = 'Kopiera';
$string['duplicateconfirm'] = 'Är du säker på att du vill duplicera {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Återgå till kursen';
$string['duplicatecontedit'] = 'Redigera den nya kopian';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname} &quot;har kopierats med framgång';
$string['duplicatinga'] = 'Kopierar: {$a}';
$string['edhelpaspellpath'] = 'För att använda stavningskontroll inom redigeraren så MÅSTE <strong>aspell 0.50</strong> eller senare vara installerad på Din server, och Du måste ange rätt sökväg för att få tillgång till aspell binary. På Unix/Linux-system, så är den här sökvägen normalt sett <strong>/usr/bin/aspell</strong>, men det kan vara någonting annat.';
$string['edhelpbgcolor'] = 'Definiera bakgrundsfärgen för det område som Du vill redigera.<br />Giltiga värden är t.ex. #ffffff eller "white".';
$string['edhelpcleanword'] = 'Den här inställningen aktiverar eller avaktiverar formatfiltrering som är specifik för Word.';
$string['edhelpenablespelling'] = 'Aktivera eller avaktivera stavningskontroll. När den är aktiverad så måste <strong>aspell</strong> vara aktiverat på servern.';
$string['edhelpfontfamily'] = 'Egenskapen för "font-family" (typsnittsfamilj) är en lista över namn på olika typsnitt eller på generella sådana (med eller utan seriffer t ex). Dessa namn på typsnitt måste vara kommaseparerade.';
$string['edhelpfontlist'] = 'Definiera de typsnitt som Du vill ha med i redigerarens utfällbara meny för typsnitt (fonter).';
$string['edhelpfontsize'] = 'Standardstorleken på typsnittet (fonten) anger storleken på typsnittet.<br />Giltiga värden är t.ex.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Redigera';
$string['edita'] = 'Redigera {$a}';
$string['editcategorysettings'] = 'Redigera inställningar för kategori';
$string['editcategorythis'] = 'Redigera den här kategorin';
$string['editcoursesettings'] = 'Redigera kursinställningar';
$string['editfiles'] = 'Redigera filer';
$string['editgroupprofile'] = 'Redigera grupp-profil';
$string['editinga'] = 'Redigera {$a}';
$string['editingteachershort'] = 'Redigerare';
$string['editlock'] = 'Detta värde kan Du inte redigera!';
$string['editmyprofile'] = 'Redigera profil';
$string['editorbgcolor'] = 'Bakgrundsfärg';
$string['editorcleanonpaste'] = 'Rensa av Word skapad HTML när Du klistrar in.';
$string['editorcommonsettings'] = 'Vanliga inställningar';
$string['editordefaultfont'] = 'Standardval av typsnitt';
$string['editorenablespelling'] = 'Aktivera stavningskontroll';
$string['editorfontlist'] = 'Lista över typsnitt';
$string['editorfontsize'] = 'Standardstorlek på typsnitt';
$string['editorresettodefaults'] = 'Återställ till standardvärden';
$string['editorsettings'] = 'Inställningar för redigerare';
$string['editorshortcutkeys'] = 'Kortkommandon för redigerare';
$string['editsettings'] = 'Redigera inställningar';
$string['editsummary'] = 'Redigera summeringen';
$string['editthisactivity'] = 'Redigera denna aktivitet';
$string['editthiscategory'] = 'Redigera denna kategori';
$string['edittitle'] = 'Redigera titel';
$string['edittitleinstructions'] = 'Escape för att avbryta, Enter för att avsluta';
$string['edituser'] = 'Redigera användarkonton';
$string['email'] = 'E-postadress';
$string['emailactive'] = 'E-post är aktiverat';
$string['emailagain'] = 'E-post (igen)';
$string['emailalreadysent'] = 'Ett meddelande om lösenordsåterställning har redan skickats. Vänligen kontrollera din epost.';
$string['emailcharset'] = 'Teckenuppsättning för e-post';
$string['emailconfirm'] = 'Bekräfta Ditt konto';
$string['emailconfirmation'] = 'Hej {$a->firstname}!

Någon (antagligen Du) har använt Din e-postadress
för att beställa ett nytt konto hos:
\'{$a->sitename}\'.

Om Du vill bekräfta detta nya konto, så är Du
varmt välkommen att besöka följande webbadress:

{$a->link}

I de flesta e-postprogram kommer denna adress att visas som en blå länk som Du bara behöver klicka på. Om det inte fungerar, kan Du klippa ut adressen här och klistra in den i adressrutan på Din webbläsare.


Om Du behöver hjälp så kan Du kontakta
vår administratören för vår webbplats,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: bekräftelse av konto';
$string['emailconfirmsent'] = '<p>Vi har skickat ett e-postbrev som Du bör ha fått<br /> till Din adress på <b>{$a}</b></p>
<p>Det innehåller enkla instruktioner som hjälper Dig<br />att fullfölja Din registrering.</p>
<p>Om Du stöter på problem, är Du välkommen att <br />kontakta den som ansvarar för webbplatsen.</p>';
$string['emaildigest'] = 'Sammanfattande e-postmeddelande';
$string['emaildigestcomplete'] = 'Komplett (dagliga e-postmeddelanden med hela inlägg).';
$string['emaildigest_help'] = 'Det här är inställningen för dagliga sammandrag som forum kommer använda som standard.

* Inget sammandrag - du kommer få ett epostmeddelande per foruminlägg;
* Sammandrag - hela inlägg - du kommer få ett sammandrag per dag via epost med det fullständiga innehållet i varje foruminlägg;
* Sammandrag - enbart titlar - du kommer få ett sammandrag per dag via epost som enbart innehåller titlarna på varje foruminlägg.

Du kan också välja olika inställningar för varje forum om du så vill.';
$string['emaildigestoff'] = 'Ingen sammanfattning (ett enskilt e-postmeddelande per inlägg i forum).';
$string['emaildigestsubjects'] = 'Ämnen (dagliga e-postmeddelanden endast  innehållande ämnen).';
$string['emaildisable'] = 'Den här e-postadressen är avaktiverad.';
$string['emaildisableclick'] = 'Klicka här för att avaktivera alla möjligheter att skicka e-post till den här adressen.';
$string['emaildisplay'] = 'Visning av e-post';
$string['emaildisplaycourse'] = 'Tillåt endast andra kursdeltagare att se min e-postadress.';
$string['emaildisplayhidden'] = 'Dölj e-postadress';
$string['emaildisplayno'] = 'Göm min riktiga e-postadress för alla.';
$string['emaildisplayyes'] = 'Tillåt alla att se min e-postadress.';
$string['emailenable'] = 'Den här e-postadressen är redan registrerad.';
$string['emailenableclick'] = 'Klicka här för att aktivera alla möjligheter att skicka e-post till den här adressen.';
$string['emailexists'] = 'Din e-postadress är redan registrerad.';
$string['emailformat'] = 'format för e-post';
$string['emailmustbereal'] = 'Obs! Din e-postadress måste vara giltig.';
$string['emailnotallowed'] = 'E-postadresser i de här domänerna är inte tillåtna ({$a}).';
$string['emailnotfound'] = 'Det gick inte att hitta e-postadressen i databasen.';
$string['emailonlyallowed'] = 'Det här e-postmeddelandet är inte ett av dem som är tillåtna ({$a}).';
$string['emailpasswordchangeinfo'] = 'Hej {$a->firstname},
Någon (troligen Du) har efterfrågat ett nytt lösenord för Ditt konto hos
\'{$a->sitename}\'.

För att byta lösenordet, vara snäll och gå till följande adress:

{$a->link}

I de flesta e-postprogram kommer den att visas som
en blå länk som Du bara behöver klicka på.

Om det inte fungerar, kan Du klippa ut adressen och klistra in den i adressfönstret på Din
webbläsare, klicka sedan på Gå eller tryck på
radmatningen (Enter).

Om Du behöver hjälp så är Du välkommen att
kontakta den som är ansvarig för webbplatsen,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hej {$a->firstname},
Någon (troligen Du) har efterfrågat
ett nytt lösenord för Ditt konto hos:

\'{$a->sitename}\'.

Tyvärr har Ditt konto på den här webbplatsen avaktiverats och det
går inte att återställa det.

Var snäll och kontakta administratören
för webbplatsen:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hej {$a->firstname},
Någon (troligen Du) har efterfrågat
ett nytt lösenord för Ditt konto hos:

\'{$a->sitename}\'.

Det går tyvärr inte att återställa
lösenord på den här webbplatsen.

Var snäll och kontakta administratören
för webbplatsen:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: information om byte av lösenord';
$string['emailpasswordconfirmation'] = 'Hej {$a->firstname}!

Någon (antagligen Du) har beställt ett nytt lösenord till Ditt konto på: \'{$a->sitename}\'.

Om Du vill bekräfta detta och att vi ska skicka
det nya lösenordet med e-post så behöver Du koppla
upp Dig till den följande webbadressen:

{$a->link}

I de flesta e-postprogram kommer den att visas som
en blå länk som Du bara behöver klicka på.

Om det inte fungerar, kan Du klippa ut adressen
här och klistra in den i adressfönstret på Din
webbläsare, klicka sedan på Gå eller tryck på
radmatningen (Enter).

Om Du behöver hjälp så är Du välkommen att
kontakta den som är ansvarig för webbplatsen,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: bekräftelse av ändrat lösenord';
$string['emailpasswordconfirmmaybesent'] = '<p>Om Du angav ett giltigt användarnamn eller adress så bör ett e-postmeddelande ha skickats till Dig.</p><p>Det innehåller enkla instruktioner för att bekräfta och fullfölja detta byte av lösenord. Om Du har fortsatta problem, vara snäll och kontakta den som är ansvarig för webbplatsen.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Användarkontot du specificerade har ingen epostadress registrerad.</p>
   <p>Vänligen kontakta webbplatsens administratör.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Användardetaljen du tillhandahöll identifierar inte ett existerande användarkonto.</p>
   <p>Vänligen kontrollera informationen du angav och försök sen igen.
Om problemen fortsätter, kontakta webbplatsens administratör.</p>';
$string['emailpasswordconfirmsent'] = 'Vi har skickat ett e-postbrev till Din adress på:
<b>{$a}</b>

Det innehåller enkla instruktioner för att Du ska
kunna bekräfta och fullfölja detta byte av lösenord.

Om Du stöter på problem, är Du välkommen att
kontakta den som ansvarar för webbplatsen.';
$string['emailpasswordsent'] = 'Tack för att Du bekräftade bytet av lösenord.

Vi har skickat ett e-postbrev som innehåller
lösenordet till Din adress på:
<b>{$a->email}</b>

Det nya lösenordet har skapats automatiskt -
och Du kanske vill <a href="{$a->link}">byta Ditt
lösenord</a> till något som är lättare att komma ihåg.';
$string['emailresetconfirmation'] = 'Hej {$a->firstname},

en återställning av lösenord har begärts för ditt konto \'{$a->username}\' på {$a->sitename}.

För att bekräfta den här begäran och sätta ett nytt lösenord för ditt konto, vänligen gå till följande adress:

{$a->link}
(Den här länken är giltig {$a->resetminutes} minuter från den tidpunkt då återställningen först begärdes)

Om lösenordsåterställningen inte begärdes av dig så krävs ingen åtgärd.

Om du behöver hjälp, vänligen kontakta webbplatsens administratör,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Begäran om återställning av lösenord';
$string['emailresetconfirmsent'] = 'Ett epostmeddelande har skickats till din adress <b>{$a}</b>.
<br />Det innehåller enkla instruktioner för att bekräfta och slutföra det här bytet av lösenord.
Om problemen fortsätter, kontakta webbplatsens administratör.';
$string['emptydragdropregion'] = 'tom region';
$string['enable'] = 'Aktivera';
$string['encryptedcode'] = 'Krypterad kod';
$string['english'] = 'Engelska';
$string['enrolmentmethods'] = 'Inskrivningsmetoder';
$string['entercourse'] = 'Klicka för att nå denna kurs';
$string['enteremail'] = 'Mata in Din e-postadress';
$string['enteremailaddress'] = 'Mata in Din e-postadress för att nollställa Ditt
lösenord så skickar vi det nya lösenordet till Dig via e-post.';
$string['enterusername'] = 'Mata in ditt användarnamn';
$string['entries'] = 'Bidrag';
$string['error'] = 'Fel';
$string['errorcreatingactivity'] = 'Det gick inte att skapainstans av aktiviteten \'{$a}\'';
$string['errorfiletoobig'] = 'Filen var större än gränsen på {$a} byte';
$string['errornouploadrepo'] = 'Det finns ingen arkiv för uppladdning aktiverat för den här webbplatsen';
$string['errorwhenconfirming'] = 'Du är inte bekräftad ännu eftersom det uppstod ett fel.
Om Du klickade på en länk i ett e-postmeddelande för att
komma hit så får Du kolla att raden med länken inte var uppdelad på två rader.
Du kanske måste "klippa och klistra" för att forma länken på rätt sätt.';
$string['eventcontentviewed'] = 'Innehåll visat';
$string['eventcoursecategorydeleted'] = 'Kategori borttagen';
$string['eventcoursecontentdeleted'] = 'Kursinnehåll borttaget';
$string['eventcoursecreated'] = 'Kurs skapad';
$string['eventcoursedeleted'] = 'Kurs borttagen';
$string['eventcoursemodulecreated'] = 'Kursmodul skapad';
$string['eventcoursemoduledeleted'] = 'Kursmodul borttagen';
$string['eventcoursemoduleupdated'] = 'Kursmodul uppdaterad';
$string['eventcourseresetended'] = 'Kursåterställning avslutad';
$string['eventcourseresetstarted'] = 'Kursåterställning startad';
$string['eventcourserestored'] = 'Kurs återskapad';
$string['eventcoursesectionupdated'] = 'Kurssektion uppdaterad';
$string['eventcourseupdated'] = 'Kurs uppdaterad';
$string['eventusercreated'] = 'Användare skapad';
$string['eventuserdeleted'] = 'Användare borttagen';
$string['eventuserlistviewed'] = 'Användarlista visad';
$string['eventuserloggedout'] = 'Användare loggade ut';
$string['eventuserprofileviewed'] = 'Användarprofil visad';
$string['eventuserupdated'] = 'Användare uppdaterad';
$string['everybody'] = 'Alla';
$string['executeat'] = 'Genomför vid';
$string['existing'] = 'Finns';
$string['existingadmins'] = 'Befintliga administratörer';
$string['existingcourse'] = 'Befintlig kurs';
$string['existingcourseadding'] = 'Befintlig kurs, lägger till data';
$string['existingcoursedeleting'] = 'Befintlig kurs, tar först bort den';
$string['existingcreators'] = 'Befintliga kursutvecklare';
$string['existingstudents'] = 'Registrerade studenter/<br />elever/<br />deltagare/<br />lärande';
$string['existingteachers'] = 'Befintliga distanslärare/<br />handledare/<br />coacher';
$string['expand'] = 'Expandera';
$string['expandall'] = 'Expandera allt';
$string['expandcategory'] = 'Expandera {$a}';
$string['explanation'] = 'Förklaring';
$string['extendenrol'] = 'Förläng registrering (individuellt)';
$string['extendperiod'] = 'Förlängd period';
$string['failedloginattempts'] = '{$a->attempts} misslyckade försök att logga in sedan Din senaste login.';
$string['failedloginattemptsall'] = '{$a->attempts} misslyckade försök att logga in för {$a->accounts} konton';
$string['feedback'] = 'Återkoppling';
$string['file'] = 'Fil';
$string['fileexists'] = 'Det finns redan en fil med namnet {$a}';
$string['filemissing'] = '{$a} saknas';
$string['files'] = 'Filer';
$string['filesanduploads'] = 'Filer och uppladdningar';
$string['filesfolders'] = 'Filer/mappar';
$string['filetoolarge'] = 'det är för stort för att ladda upp';
$string['fileuploadwithcontent'] = 'Filuppladdningar bör inte inkludera innehållsparametrar';
$string['filloutallfields'] = 'Var vänlig fyll i alla fält i detta formulär.';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Sök fler kurser...';
$string['first'] = 'Första';
$string['firstaccess'] = 'Första åtkomst';
$string['firstname'] = 'Förnamn';
$string['firstnamephonetic'] = 'Förnamn - fonetiskt';
$string['firsttime'] = 'Är det första gången Du är här?';
$string['folder'] = 'Katalog';
$string['folderclosed'] = 'Stängd katalog';
$string['folderopened'] = 'Öppnad katalog';
$string['followingoptional'] = 'Följande punkter är valfria';
$string['followingrequired'] = 'Följande punkter krävs';
$string['for'] = 'För';
$string['force'] = 'Tvinga';
$string['forcelanguage'] = 'Tvingande språkval';
$string['forceno'] = 'Tvinga inte';
$string['forcepasswordchange'] = 'Framtvinga ändring av lösenord';
$string['forcepasswordchangecheckfull'] = 'Är du helt säker på att du vill göra en ändring av lösenord till {$a}?';
$string['forcepasswordchange_help'] = 'Om kryssrutan är markerad, kommer användaren att uppmanas att ändra sitt lösenord vid nästa inloggning';
$string['forcepasswordchangenot'] = 'Det gick inte att tvinga ett lösenordbyte {$a}';
$string['forcepasswordchangenotice'] = 'Du måste använda Ditt lösenord för att kunna fortsätta.';
$string['forcetheme'] = 'Tvinga tema';
$string['forgotaccount'] = 'Förlorat lösenordet?';
$string['forgotten'] = 'Har Du glömt Ditt användarnamn och lösenord?';
$string['forgottenduplicate'] = 'Den här e-postadressen används i ett flertal konton, var snäll och ange ett användarnamn istället.';
$string['forgotteninvalidurl'] = 'URL till återställning av ogiltigt lösenord.';
$string['format'] = 'Format';
$string['format_help'] = 'Kursen formatet avgör layouten på kurssidan.

* Enkel aktivitetsformat - För att visa en enskild aktivitet eller resurs (t.ex. en frågesport eller SCORM paket) på kurssidan
* Socialformat - Ett forum visas på kurssidan
* Ämnesformat - Kursen sidan är organiserad i ämnessektioner
* Veckoformat - Kursens sidor är organiserade i veckosektioner, den första veckan börjar på kursen startdatum';
$string['formathtml'] = 'HTML-format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Ren text';
$string['formattext'] = 'Autoformat för Moodle';
$string['formattexttype'] = 'Formatering';
$string['framesetinfo'] = 'Det här dokumentet i ramverksformat innehåller:';
$string['from'] = 'Från';
$string['frontpagecategorycombo'] = 'Kombinerad lista';
$string['frontpagecategorynames'] = 'Visa en förteckning över kategorier';
$string['frontpagecourselist'] = 'Visa en kursförteckning';
$string['frontpagecoursesearch'] = 'Sökruta för kurser';
$string['frontpagedescription'] = 'Beskrivning på förstasidan';
$string['frontpagedescriptionhelp'] = 'Den här beskrivningen kan visas på förstasidan genom att använda kursens/webbplatsens sammanfattningsblock eller genom att inkludera en ämnessektion på förstasidan.';
$string['frontpageenrolledcourselist'] = 'Inskrivna kurser';
$string['frontpageformat'] = 'Formatering av ingångssidan (första/hem).';
$string['frontpageformatloggedin'] = 'Första sidan när man är inloggad';
$string['frontpagenews'] = 'Visa alla nya element';
$string['frontpagesettings'] = 'Inställningar för ingångssidan';
$string['fulllistofcourses'] = 'Alla kurser';
$string['fullname'] = 'Hela namnet';
$string['fullnamecourse'] = 'Hela namnet';
$string['fullnamecourse_help'] = 'Det fullständiga namnet på kursen visas längst upp på varje sida i kursen och i listan över kurser.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Hela namnet';
$string['fullprofile'] = 'Hela profilen';
$string['fullsitename'] = 'Hela webbplatsnamnet';
$string['functiondisabled'] = 'Den funktionaliteten är f.n. avaktiverad';
$string['general'] = 'Allmänt';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Hämta dessa loggar';
$string['go'] = 'Gå';
$string['gpl'] = 'Copyright, Upphovsrätt (C) 2001-2002  Martin Dougiamas  (http://dougiamas.com)

Det här programmet är fri (gratis) mjukvara. Du har rätt att distribuera det vidare och/eller modifiera(ändra)det i enlighet med villkoren i
\'the GNU General Public License\' (GNU Allmänna Offentliga Licens) såsom den har publicerats av
\'the Free Software Foundation\' ; antingen version 2 av Licensen0, eller (om Du hellre väljer det)
valfri senare version.

Det här programmet distribueras i förhoppningen att det ska vara användbart och till nytta men
UTAN VARJE FORM AV GARANTI
; utan t o m den (under)förstådda garantin  för \'MERCHANTABILITY\' eller \'FITNESS FOR A PARTICULAR PURPOSE\' (lämplighet för ett visst ändamål).  Ta del av
\'GNU General Public License\' för ytterligare information:

http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL licens';
$string['grade'] = 'Betyg';
$string['grades'] = 'Betyg';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> har aktiverats för den här webbplatsen. Om du inte laddar upp en profilbild Moodle kommer att försöka hämta en profilbild för dig från Gravatar.';
$string['group'] = 'Grupp';
$string['groupadd'] = 'Lägg till en ny grupp';
$string['groupaddusers'] = 'Lägg till det valda till grupp';
$string['groupextendenrol'] = 'Förläng registreringen för alla';
$string['groupfor'] = 'för grupp';
$string['groupinfo'] = 'Info om vald grupp';
$string['groupinfoedit'] = 'Redigera inställningar för grupp';
$string['groupinfomembers'] = 'Info om valda medlemmar';
$string['groupinfopeople'] = 'Info om valda personer';
$string['groupmembers'] = 'Gruppmedlemmar';
$string['groupmemberssee'] = 'Visa gruppmedlemmar';
$string['groupmembersselected'] = 'Medlemmar i vald grupp';
$string['groupmode'] = 'Gruppläge';
$string['groupmodeforce'] = 'Framtvinga gruppläge';
$string['groupmy'] = 'Min grupp';
$string['groupnonmembers'] = 'Personer som inte är med i någon grupp';
$string['groupnotamember'] = 'Du är tyvärr inte medlem i den gruppen.';
$string['grouprandomassign'] = 'Dela slumpmässigt in alla i grupper.';
$string['groupremove'] = 'Ta bort vald grupp';
$string['groupremovemembers'] = 'Ta bort valda medlemmar';
$string['groups'] = 'Grupper';
$string['groupsnone'] = 'Inga grupper';
$string['groupsseparate'] = 'Olika grupper';
$string['groupsvisible'] = 'Synliga grupper';
$string['guest'] = 'Gäst';
$string['guestdescription'] = 'Gäster har mycket begränsade rättigheter och kan normalt sett inte skriva in text någonstans.';
$string['guestskey'] = 'Tillåt gäster som har nyckeln.';
$string['guestsno'] = 'Tillåt inte gäster';
$string['guestsnotallowed'] = 'Tyvärr,  \'{$a}\'  tillåter inte tillträde för gäster.';
$string['guestsyes'] = 'Tillåt gäster utan nyckeln';
$string['guestuser'] = 'Gästanvändare';
$string['guestuserinfo'] = 'Denna användare är en speciell användare som tillåts endast läsbehörighet till några kurser.';
$string['help'] = 'Hjälp';
$string['helpprefix2'] = 'Hjälp med {$a}';
$string['helpwiththis'] = 'Hjälp med detta';
$string['hiddenassign'] = 'Dold uppgift';
$string['hiddenfromstudents'] = 'Dolt för studenter/deltagare/elever/lärande';
$string['hiddensections'] = 'Dolda sektioner';
$string['hiddensectionscollapsed'] = 'Dolda sektioner visas i  ihoppackat format.';
$string['hiddensections_help'] = '<p>Det h&auml;r alternativet g&ouml;r det m&ouml;jligt f&ouml;r Dig att avg&ouml;ra hur
de dolda  sektionerna i Din kurs ska visas f&ouml;r studenterna/eleverna/deltagarna/de l&auml;rande.</p>
<p>Som f&ouml;rinst&auml;lld standard s&aring; visas ett litet omr&aring;de(i f&ouml;rminskad form, vanligvis i gr&aring;tt) f&ouml;r att indikera
var den dolda sektionen finns. De kan dock inte se sj&auml;lva de dolda aktiviteterna och texterna.
Detta &auml;r s&auml;rskilt anv&auml;ndbart i veckoformatet. D&aring; kan Du v&auml;lja att visa bara den innevarande veckan aktiviteter.</p>
<p>Du kan &auml;ven v&auml;lja att d&ouml;lja sektionerna helt s&aring; att studenterna/eleverna/deltagarna/de l&auml;rande inte ens ser
att s&aring;dana finns.</p>';
$string['hiddensectionsinvisible'] = 'Dolda sektioner är helt och hållet osynliga.';
$string['hide'] = 'Dölj';
$string['hideadvancedsettings'] = 'Dölj avancerade inställningar.';
$string['hidepicture'] = 'Dölj bild.';
$string['hidesection'] = 'Dölj sektion {$a}';
$string['hidesettings'] = 'Dölj inställningar.';
$string['hideshowblocks'] = 'Dölja eller visa block';
$string['hits'] = 'Besök';
$string['hitsoncourse'] = 'Besök på {$a->coursename} av {$a->username}';
$string['hitsoncoursetoday'] = 'Dagens besök på {$a->coursename} av {$a->username}';
$string['home'] = 'Hem';
$string['hour'] = 'timme';
$string['hours'] = 'timmar';
$string['howtomakethemes'] = 'Så gör Du ett nytt tema.';
$string['htmleditor'] = 'Använd HTML-editor';
$string['htmleditoravailable'] = 'Richtext-redigeraren är tillgänglig';
$string['htmleditordisabled'] = 'Du har valt bort Richtext-redigeraren i Din användarprofil.';
$string['htmleditordisabledadmin'] = 'Administratören har valt bort Richtext-redigeraren för denna webbplats.';
$string['htmleditordisabledbrowser'] = 'HTML-redigeraren är inte tillgänglig eftersom Du inte använder Internet Explorer 5.5 eller senare versioner.';
$string['htmlfilesonly'] = 'Endast HTML-filer';
$string['htmlformat'] = 'Snyggt HTML- format';
$string['icon'] = 'Ikon';
$string['icqnumber'] = 'ICQ nummer';
$string['idnumber'] = 'ID nummer';
$string['idnumbercourse'] = 'ID-nummer för kurs';
$string['idnumbercoursecategory'] = 'Kategori ID-nummer';
$string['idnumbercoursecategory_help'] = 'ID-numret för en kurskategori används endast när kategorin matchas mot externa system och visas inte någonstans på webbplatsen. Om kategorin har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbercourse_help'] = '<p>ID-numret f&ouml;r en kurs anv&auml;nds bara n&auml;r Du beh&ouml;ver matcha den h&auml;r kursen mot externa system - det visas aldrig inom Moodle. Om Du har ett officiellt kodnamn f&ouml;r den h&auml;r kursen s&aring; ska Du anv&auml;nda det h&auml;r, annars kan Du l&auml;mna detta tomt</p>';
$string['idnumbergroup'] = 'ID-nummer för grupp';
$string['idnumbergroup_help'] = 'ID-numret för en grupp används bara när gruppen matchas mot externa system och visas inte någonstans på webbplatsen. Om gruppen har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbergrouping'] = 'Gruppering ID-nummer';
$string['idnumbergrouping_help'] = 'ID-numret för en gruppering används endast när grupperingen matchas mot externa system och visas inte någonstans på webbplatsen. Om grupperingen har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbermod'] = 'ID-nummer';
$string['idnumbermod_help'] = '<p>Genom att ställa in ett ID-nummer så kan du identifiera en aktivitet med tanke på hur betygen ska beräknas.
Om aktiviteten inte ingår i betygsunderlaget då behöver du inte skriva in något i fältet för ID-nummer.
<p> ID-numret kan även ställas in på sidan för att beräkna betyg i betygskatalogen. Du kan dock bara redigera det på sidan för att updatera aktiviteten.</p>';
$string['idnumbertaken'] = 'Det här ID-numret används redan';
$string['imagealt'] = 'Beskrivning av bild';
$string['import'] = 'Importera';
$string['importdata'] = 'Importera kursdata';
$string['importdataexported'] = 'Data har exporterats från \'från\'-kurs med framgång.<br />Fortsätt med att importera till Din \'till\'-kurs.';
$string['importdatafinished'] = 'Importen är klar!  Fortsätt till Din kurs.';
$string['importdatafrom'] = 'Hitta en kurs att importera data från:';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Ta med';
$string['includeallusers'] = 'Inkludera alla användare';
$string['includecoursefiles'] = 'Inkludera alla kursfiler';
$string['includecourseusers'] = 'Inkludera alla lärande';
$string['included'] = 'Ingår';
$string['includelogentries'] = 'Inkludera loggar';
$string['includemodules'] = 'Inkludera moduler';
$string['includemoduleuserdata'] = 'Ta med användardata för modulen';
$string['includeneededusers'] = 'Inkludera nödvändiga användare';
$string['includenoneusers'] = 'Inkludera icke-användare';
$string['includeroleassignments'] = 'Ta med rolltilldelningar';
$string['includesitefiles'] = 'Inkludera filer på webbplatsnivå som används i den här kursen';
$string['includeuserfiles'] = 'Inkludera användarfiler';
$string['increasesections'] = 'Utöka antalet sektioner';
$string['info'] = 'Information';
$string['institution'] = 'Institution';
$string['instudentview'] = 'i lärandevy';
$string['interests'] = 'Intressen';
$string['interestslist'] = 'Lista över intressen';
$string['interestslist_help'] = 'Ange dina intressen separerade med kommatecken. Dina intressen kommer att visas på din profilsida som taggar.';
$string['invalidemail'] = 'Ogiltig e-postadress';
$string['invalidlogin'] = 'Ogiltig login, var vänlig försök igen';
$string['invalidusername'] = 'Användarnamnet får bara innehålla alfanumeriska gemener, understreck (_), bindestreck (-), punkt (.), eller symbolen (@)';
$string['invalidusernameupload'] = 'Ogiltigt användarnamn';
$string['ip_address'] = 'IP-adress';
$string['jump'] = 'Hoppa';
$string['jumpto'] = 'Hoppa till...';
$string['keep'] = 'Behåll';
$string['keepsearching'] = 'Fortsätt att söka';
$string['langltr'] = 'Språkriktning vänster-till-höger';
$string['langrtl'] = 'Språkriktning höger-till-vänster';
$string['language'] = 'Språk';
$string['languagegood'] = 'Detta språkpaket är det senaste!  :-)';
$string['last'] = 'Sista';
$string['lastaccess'] = 'Senaste access';
$string['lastedited'] = 'Senast redigerad';
$string['lastlogin'] = 'Senaste login';
$string['lastmodified'] = 'Senast modifierad';
$string['lastname'] = 'Efternamn';
$string['lastnamephonetic'] = 'Efternamn - fonetiskt';
$string['lastyear'] = 'Det senaste året';
$string['latestlanguagepack'] = 'Sök efter det senaste språkpaketet på moodle.org.';
$string['layouttable'] = 'Tabell för layout';
$string['leavetokeep'] = 'Lämna detta tomt om Du vill behålla Ditt nuvarande lösenord.';
$string['legacythemeinuse'] = 'Denna webbplats visas för dig i kompatibilitetsläge eftersom din webbläsare är för gammal.';
$string['license'] = 'Licens';
$string['licenses'] = 'Licenser';
$string['liketologin'] = 'Vill Du logga in nu med ett komplett användarkonto?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista över filer i {$a}';
$string['listofallpeople'] = 'Lista över samtliga personer';
$string['listofcourses'] = 'Lista över kurser';
$string['loadinghelp'] = 'Laddar...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Lokala plugins';
$string['localpluginsmanage'] = 'Hantera lokala plugins';
$string['location'] = 'Plats';
$string['log_excel_date_format'] = 'åååå mmmm d t::m';
$string['loggedinas'] = 'Du är inloggad som {$a}';
$string['loggedinasguest'] = 'Du är f.n. inloggad som gäst';
$string['loggedinnot'] = 'Du har inte loggat in.';
$string['login'] = 'Logga in';
$string['loginalready'] = 'Du är redan inloggad.';
$string['loginas'] = 'Logga in som';
$string['loginaspasswordexplain'] = '<p>Du måste mata in det specifika "logga in som, lösenord" för att kunna utnyttja den här egenskapen.<br />Om Du inte kan lösenordet så får Du fråga Din serveradministratör</p>';
$string['login_failure_logs'] = 'Loggar över misslyckade försök att logga in.';
$string['loginguest'] = 'Logga in som gäst';
$string['loginsite'] = 'Logga in på webbplatsen';
$string['loginsteps'] = 'Hej!
<br />
Du måste bl.a. skapa ett nytt användarkonto på denna webbplats för att få tillgång till de kurser som Du vill delta i. Varje individuell kurs kan också ha en engångsnyckel "kursnyckel". Den behöver Du dock inte  förrän senare.
   Så här skapar Du Ditt konto:
   <ol size="2">
   <li>Fyll i formuläret på sidan <a href={$a}>
Nytt konto</a> med de efterfrågade
uppgifterna om Dig själv.</li>
   <li>Ett e-postmeddelande kommer därefter
omedelbart att sändas till
Din e-postadress.</li>
   <li>Läs din e-post, och klicka på webblänken som den innehåller.</li>
   <li>Ditt konto kommer därmed att bekräftas
och Du kommer att loggas in.</li>
   <li>Nu kan Du välja vilken kurs Du
vill delta i.</li>
   <li>Om Du måste ange en "kursnyckel" - så
får Du använda den som Din lärare  har
givit Dig. Med den kan Du registrera
Dig på en sådan kurs som kräver det.</li>
   <li>Nu kan Du använda hela kursen.
Från och med nu behöver Du bara skriva
in Ditt användarnamn och lösenord
(i formuläret till vänster på denna sida)
för att logga in och för att nå de kurser
som Du är registrerad på.</li>
   </ol>
OBS! Genom att Du bekräftar kontot så samtycker
Du till databehandling enligt Personuppgiftslagen.
Om Du är osäker på vad det innebär så kan Du hitta
mer information här: \'http://www.foi.se/FOI/templates/Page____3714.aspx
\'

Lycka till!';
$string['loginstepsnone'] = 'Hej!
<p>För att få full tillgång till de kurser som Du vill delta i måste Du skapa ett användarkonto. </p>
<p>Det enda Du behöver göra är att skaffa ett användarnamn och lösenord och använda det i formuläret tilll vänster på denna sida!</p>
<p>Om någon annan redan har valt Ditt användarnamn så får Du försöka igen med ett annat.</p>';
$string['loginto'] = 'Logga in till {$a}';
$string['logout'] = 'Logga ut';
$string['logoutconfirm'] = 'Vill du verkligen logga ut?';
$string['logs'] = 'Loggar';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mer</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mer</a> ]';
$string['lookback'] = 'Se tillbaka';
$string['mailadmins'] = 'Informera administratörer';
$string['mailstudents'] = 'Informera studenter/elever/deltagare/lärande';
$string['mailteachers'] = 'Informera (distans)lärare';
$string['maincoursepage'] = 'Huvudsida för kurs';
$string['makeafolder'] = 'Skapa en mapp';
$string['makeeditable'] = 'Om Du gör \'{$a}\' redigerbar via webbservern (t.ex. apache) så kan Du redigera denna fil direkt från denna sida.';
$string['makethismyhome'] = 'Gör detta till min sida standardsida';
$string['manageblocks'] = 'Block';
$string['managecategorythis'] = 'Administrera den här kategorin';
$string['managecourses'] = 'Administrera kurser';
$string['managedatabase'] = 'Databas';
$string['manageeditorfiles'] = 'Hantera filer som används av editorn';
$string['managefilters'] = 'Filter';
$string['managemodules'] = 'Moduler';
$string['manageroles'] = 'Roller och rättigheter';
$string['markedthistopic'] = 'Det här ämnet är markerat som det just nu aktuella ämnet.';
$string['markthistopic'] = 'Markera detta ämne som aktuellt  ämne.';
$string['matchingsearchandrole'] = 'Matchande \'{$a->search} "och {$a->role}';
$string['maxareabytesreached'] = 'Filen (eller den totala storleken av flera filer) är större än det kvarstående utrymmet i den här arean.';
$string['maxbytesforfile'] = 'Filen {$a} är större än den maximalt tillåtna storleken.';
$string['maxfilesize'] = 'Maximal storlek för nya filer: {$a}';
$string['maxfilesreached'] = 'Det är tillåtet att bifoga högst {$a} fil (er) till det här objektet';
$string['maximumchars'] = 'Maximum av {$a} tecken';
$string['maximumgrade'] = 'Maximum betyg';
$string['maximumgradex'] = 'Max betyg: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximal storlek på uppladdade filer.';
$string['maximumupload_help'] = '<p>Den h&auml;r inst&auml;llningen best&auml;mmer maximal storlek
p&aring; de filer som de l&auml;rande f&aring;r ladda upp till kursen.
Det finns dock ocks&aring; en &ouml;vergripande inst&auml;llning f&ouml;r
hela webbsajten som administrat&ouml;ren har angivit.</p>
<p>Du kan ytterligare begr&auml;nsa denna storlek genom
inst&auml;llningarna f&ouml;r varje aktivitetsmodul.</p>';
$string['maxnumberweeks'] = 'Maximalt antal sektioner';
$string['maxnumberweeks_desc'] = 'Det maximala värdet i rullgardinsmenyn för antalet sektioner (endast applicerbart på vissa kursformat).';
$string['maxnumcoursesincombo'] = 'Bläddra <a href="{$a->link}">{$a->numberofcourses} kurser</a>';
$string['maxsize'] = 'Max storlek: {$a}';
$string['maxsizeandareasize'] = 'Maximal storlek för nya filer: {$a->size}, total gräns: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximal storlek för nya filer: {$a->size}, max bilagor: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximal storlek för nya filer: {$a->size}, max bilagor: {$a->attachments}, övergripande gräns: {$a->areasize}';
$string['memberincourse'] = 'Personer i kursen.';
$string['messagebody'] = 'Brödtext i meddelande';
$string['messagedselectedusers'] = 'Markerade användare har blivit informerade och mottagarförteckningen har återställts.';
$string['messagedselectedusersfailed'] = 'Något fel uppstod under det att markerade användare skulle informeras. En del har möjligen inte fått något e-postmeddelande.';
$string['messageprovider:availableupdate'] = 'Meddelande om tillgängliga uppdateringar';
$string['messageprovider:backup'] = 'Meddelanden om säkerhetskopiering';
$string['messageprovider:badgecreatornotice'] = 'Märkesskapares anteckningar';
$string['messageprovider:badgerecipientnotice'] = 'Märkesmottagares anteckningar';
$string['messageprovider:courserequestapproved'] = 'Meddelande om godkänd begäran av ny kurs.';
$string['messageprovider:courserequested'] = 'Meddelande om begäran av ny kurs.';
$string['messageprovider:courserequestrejected'] = 'Meddelande om avvisad begäran av ny kurs.';
$string['messageprovider:errors'] = 'Allvarliga fel med webbplatsen';
$string['messageprovider:errors_help'] = 'Dessa är viktiga fel som en administratör bör veta om.';
$string['messageprovider:instantmessage'] = 'Personliga meddelanden mellan användare';
$string['messageprovider:instantmessage_help'] = 'Detta avsnitt konfigurerar vad som händer med meddelanden som skickas till dig direkt från andra användare på denna webbplats.';
$string['messageprovider:notices'] = 'Meddelanden om mindre problem';
$string['messageprovider:notices_help'] = 'Dessa är meddelanden som en administratör kan vara intresserad av att se.';
$string['messageselect'] = 'Markera den här användaren som mottagare av  meddelanden.';
$string['messageselectadd'] = 'Skicka meddelande';
$string['middlename'] = 'Mellannamn';
$string['migratinggrades'] = 'Migrerar (flyttar) betyg';
$string['min'] = 'minut';
$string['mins'] = 'minuter';
$string['minute'] = 'minut';
$string['minutes'] = 'minuter';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Du måste välja en kategori.';
$string['missingcity'] = 'Stad saknas';
$string['missingcountry'] = 'Land saknas';
$string['missingdescription'] = 'Beskrivning saknas';
$string['missingemail'] = 'E-postadress saknas';
$string['missingfirstname'] = 'Förnamn saknas';
$string['missingfromdisk'] = 'Saknas från skivan';
$string['missingfullname'] = 'Hela namnet saknas';
$string['missinglastname'] = 'Efternamn saknas';
$string['missingname'] = 'Ett namn saknas';
$string['missingnewpassword'] = 'Nytt lösenord saknas';
$string['missingpassword'] = 'Lösenord saknas';
$string['missingrecaptchachallengefield'] = 'Saknad reCAPTCHA fält';
$string['missingreqreason'] = 'Skäl saknas';
$string['missingshortname'] = 'Kort namn saknas';
$string['missingshortsitename'] = 'Kortform av webbplatsens namn saknas';
$string['missingsitedescription'] = 'Webbplatsbeskrivning saknas';
$string['missingsitename'] = 'Webbplatsnamn saknas';
$string['missingstrings'] = 'Kontrollera för oöversatta ord eller fraser';
$string['missingstudent'] = 'Du måste välja något';
$string['missingsummary'] = 'Sammanfattning saknas';
$string['missingteacher'] = 'Du måste välja något';
$string['missingurl'] = 'URL saknas';
$string['missingusername'] = 'Användarnamn saknas';
$string['modchooserdisable'] = 'Aktivitetsväljare av';
$string['modchooserenable'] = 'Aktivitetsväljare på';
$string['moddoesnotsupporttype'] = 'Aktiviteten {$a->modname} stöder inte uppladdning av filer av typen {$a->type}';
$string['modified'] = 'Modifierad';
$string['moduleintro'] = 'Beskrivning';
$string['modulesetup'] = 'Sätter upp modultabeller...';
$string['modulesuccess'] = '{$a} tabeller har satts upp korrekt.';
$string['modulesused'] = 'Använda moduler';
$string['month'] = 'Månad';
$string['months'] = 'Månader';
$string['moodledocs'] = 'Extern dokumentation av Moodle.';
$string['moodledocslink'] = 'Moodle Docs för den här sidan.';
$string['moodlerelease'] = 'Moodle version';
$string['moodleversion'] = 'Moodle version';
$string['more'] = 'mer';
$string['morehelp'] = 'Mera hjälp';
$string['moreinformation'] = 'Mer information om detta fel.';
$string['moreprofileinfoneeded'] = 'Berätta mer om dig själv';
$string['mostrecently'] = 'allra senaste';
$string['move'] = 'Flytta';
$string['movecategoriessuccess'] = 'Flyttade {$a->count} kategorier in i kategori \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Flyttade framgångsrikt {$a->count} kategorier till högsta nivå';
$string['movecategorycontentto'] = 'Flytta till';
$string['movecategorysuccess'] = 'Flyttade kategori \'{$a->moved}\' in i kategori \'{$a->to}\'';
$string['movecategoryto'] = 'Flytta kategori till:';
$string['movecategorytotopsuccess'] = 'Flyttade framgångsrikt kategori {$a->count} till högsta nivå';
$string['movecontent'] = 'Flytta {$a}';
$string['movecontentstoanothercategory'] = 'Flytta innehåll till en annan kategori';
$string['movecoursemodule'] = 'Flytta resurs';
$string['movecoursesection'] = 'Flytta sektion';
$string['movecourseto'] = 'Flytta kurs till:';
$string['movedown'] = 'Flytta ner';
$string['movefilestohere'] = 'Flytta filerna hit';
$string['movefull'] = 'Flytta {$a} hit:';
$string['movehere'] = 'Flytta hit:';
$string['moveleft'] = 'Flytta till vänster';
$string['moveright'] = 'Flytta till höger';
$string['movesection'] = 'Flytta sektion {$a}';
$string['moveselectedcategoriesto'] = 'Flytta valda kategorier till';
$string['moveselectedcoursesto'] = 'Flytta valda kurser till...';
$string['movetoanotherfolder'] = 'Flytta till en annan mapp';
$string['moveup'] = 'Flytta upp';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Det nya lösenordet måste vara ett annat än det som gäller f.n.';
$string['mustconfirm'] = 'Du måste bekräfta Din inloggning.';
$string['mycourses'] = 'Mina kurser';
$string['myfiles'] = 'Mina privata filer';
$string['myfilesmanage'] = 'Hantera mina privata filer';
$string['myhome'] = 'Mitt hem';
$string['mymoodledashboard'] = 'Min Moodle panel';
$string['myprofile'] = 'Min profil';
$string['name'] = 'Namn';
$string['nameforlink'] = 'Vad vill du kalla den här länken?';
$string['nameforpage'] = 'Namn';
$string['navigation'] = 'Navigering';
$string['needed'] = 'Nödvändig';
$string['never'] = 'Aldrig';
$string['neverdeletelogs'] = 'Ta aldrig bort dokumentationen (loggarna).';
$string['new'] = 'Nytt';
$string['newaccount'] = 'Nytt konto';
$string['newcourse'] = 'Ny kurs';
$string['newpassword'] = 'Nytt lösenord';
$string['newpasswordfromlost'] = '<strong>OBS!</strong>Ditt</strong> nuvarande lösenord<strong> har skickats till Dig i det<strong> andra</strong> av de två e-postmeddelanden som har skickats som del av den här processen för att återvinna lösenordet. Se till att Du har fått det ersättande lösenordet innan Du fortsätter med den här skärmen.';
$string['newpassword_help'] = 'Ange ett nytt lösenord eller lämna tomt för att behålla nuvarande lösenord.';
$string['newpasswordtext'] = 'Hej {$a->firstname},

Ditt lösenord på \'{$a->sitename}\' har blivit återställt
och Du har fått en nytt tillfälligt lösenord.

Din nuvarande inloggningsinformation är nu:
   användarnamn: {$a->username}
   lösenord: {$a->newpassword}

Var vänlig besök denna sida för att ändra Ditt lösenord:
   {$a->link}</p>

I de flesta e-postprogram kommer det att visas som
en blå länk som Du bara behöver klicka på.

Om det inte fungerar, kan Du klippa ut adressen här
och klistra in den i adressfönstret på Din webbläsare,
klicka sedan på Gå eller tryck på radmatningen (Enter).

Med vänlig hälsning från: \'{$a->sitename}\' administratören,
{$a->signoff}';
$string['newpicture'] = 'Ny bild';
$string['newpicture_help'] = '<p>Du kan ladda upp en bild fr&aring;n Din dator till den h&auml;r servern.
Denna bild kommer att anv&auml;ndas i olika sammanhang f&ouml;r att
representera Dig.</p>
<p>Av den h&auml;r anledningen &auml;r det b&auml;st med en
n&auml;rbild p&aring; Ditt ansikte, men Du kan anv&auml;nda vilken bild Du vill.</p>
<p>Bilden m&aring;ste vara i JPG- eller PNG-format (dvs filnamnen slutar vanligtvis p&aring; .jpg eller .png).</p>
<p>Du kan skapa en bildfil med en av de fyra nedanst&aring;ende metoderna:</p>
<ol>
<li>Du kan anv&auml;nda en digital kamera, vilket inneb&auml;r att Dina bilder
sannolikt redan finns i Din dator och i r&auml;tt format.</li>
<li>Du kan anv&auml;nda en scanner f&ouml;r att scanna en pappersbild.
Se till att Du sparar den i JPG- eller PNG-format.</li>
<li>Om Du &auml;r konstn&auml;rligt lagd s&aring; kan Du kanske teckna en bild
med hj&auml;lp av ett grafiskt program.</li>
<li>Slutligen kan Du hitta bilder p&aring; webben som n&aring;gon har st&auml;llt till fritt f&ouml;rfogande.
<br />Du b&ouml;r dock kontrollera att bilden verkligen &auml;r fri att anv&auml;nda.
<br />
Normalt sett s&aring; &auml;r bilder upphovsr&auml;ttsskyddade
och d&aring; m&aring;ste Du fr&aring;ga den som &auml;ger r&auml;ttigheterna om lov f&ouml;rst.
<br />
<a target="google" href="http://images.google.com/">http://images.google.com</a>
&auml;r en superb plats att leta efter bilder p&aring;. N&auml;r Du v&auml;l har funnit
en kan Du \'h&ouml;gerklicka\' p&aring; den med musen och v&auml;lja \'Spara bild\' fr&aring;n
menyn. Det kan skilja sig lite fr&aring;n dator till dator hur man g&ouml;r.</li>
</ol>
<p>F&ouml;r att ladda upp bilden ska Du klicka p&aring; \'Bl&auml;ddra\'-knappen
p&aring; den h&auml;r sidan och v&auml;lja bilden fr&aring;n Din h&aring;rddisk.
</p>
<p>OBS! F&ouml;rvissa Dig om att filen inte &auml;r st&ouml;rre &auml;n
den angivna maxstorleken, annars laddas den inte upp.</p>
<p>Klicka sedan p&aring; \'Uppdatera profil\' l&auml;ngst ner -
bilden kommer att formas om till en kvadrat och skalas ner till en storlek av
100x100 pixlar.</p>
<p>N&auml;r Du kommer till Din personliga presentationssida kanske det visar sig att bilden inte
har &auml;ndrats. Om det skulle vara s&aring; beh&ouml;ver Du bara anv&auml;nda funktionen
\'Ladda om sidan\' i Din webbl&auml;sare.</p>';
$string['newsitem'] = 'Notis';
$string['newsitems'] = 'nyhetsnotiser';
$string['newsitemsnumber'] = 'Nyhetsnotiser att visa';
$string['newsitemsnumber_help'] = '<p>I de b&aring;da formaten \'Veckoformat\' och \'Ämnesformat\'
finns ett speciellt forum som kallas \'Nyheter\'.
Det &auml;r ett bra st&auml;lle att publicera nyhetsnotiser
som alla l&auml;rande kan se. Standardvalet &auml;r att alla
l&auml;rande prenumererar p&aring; detta forum och att de kommer
att f&aring; Dina nyhetsnotiser med e-post.</p>
<p>Den h&auml;r inst&auml;llningen avg&ouml;r hur m&aring;nga
aktuella notiser som ska visas p&aring; hemsidan f&ouml;r Din
kurs. Detta i en nyhetsbox nere p&aring; h&ouml;ger sida.</p>
<p>Om Du st&auml;ller in detta till \'0 nyhetsnotiser\'
s&aring; kommer inte ens nyhetsboxen att synas.</p>';
$string['newuser'] = 'Ny användare';
$string['newusernewpasswordsubj'] = 'Nytt användarkonto';
$string['newusernewpasswordtext'] = 'Hej {$a->firstname},

Ett nytt konto har skapats för Dig vid
\'{$a->sitename}\' och Du har fått ett
tillfälligt lösenord.

Den data för login som gäller för Dig är nu:

användarnamn: {$a->username}
lösenord: {$a->newpassword}

Du måste ändra Ditt lösenord när Du
loggar in för första gången.

I de flesta e-postprogram kommer det att visas som
en blå länk som Du bara behöver klicka på.

Om det inte fungerar, kan Du klippa ut adressen här
och klistra in den i adressfönstret på Din webbläsare,
klicka sedan på Gå eller tryck på radmatningen (Enter).

Med vänlig hälsning från: \'{$a->sitename}\' administratören,
{$a->signoff}';
$string['newusers'] = 'Nya användare';
$string['newwindow'] = 'Nytt fönster';
$string['next'] = 'Nästa';
$string['nextsection'] = 'Nästa sektion';
$string['no'] = 'Nej';
$string['noblockstoaddhere'] = 'Det finns inga block som du kan lägga till den här sidan.';
$string['nobody'] = 'Ingen';
$string['nochange'] = 'Ingen förändring';
$string['nocomments'] = 'Inga kommentarer';
$string['nocourses'] = 'Inga kurser';
$string['nocoursesfound'] = 'Inga kurser som innehåller orden \'{$a}\' kunde hittas.';
$string['nocoursesyet'] = 'Inga kurser i denna kategori';
$string['nodstpresets'] = 'Administratören har inte aktiverat stöd för sommartid "Daylights Saving Time".';
$string['nofilesselected'] = 'Inga filer har valts för att återställas.';
$string['nofilesyet'] = 'Inga filer har laddats upp till Din kurs ännu.';
$string['nograde'] = 'Inget betyg';
$string['nohelpforactivityorresource'] = 'Det finns för närvarande ingen hjälp för denna resurs eller aktivitet';
$string['noimagesyet'] = 'Inga bilder har laddats upp till Din kurs ännu.';
$string['nologsfound'] = 'Det gick inte att hitta några loggar';
$string['nomatchingusers'] = 'Inga användare matchar \'{$a}\'';
$string['nomorecourses'] = 'Inga fler matchande kurser kunde hittas.';
$string['nomoreidnumber'] = 'För att undvika kollisioner används inga id-nummer.';
$string['none'] = 'Ingen';
$string['noneditingteacher'] = 'Icke-redigerande lärare';
$string['noneditingteacherdescription'] = 'Icke-redigerande (distans)lärare/handledare/mentor kan undervisa på kurser och betygssätta/avge omdömen om studenter/elever/deltagare/lärande men inte ändra aktiviteter.';
$string['nonstandard'] = 'Icke-standard';
$string['nopendingcourses'] = 'Det finns inga kurser i kö för att bli godkända.';
$string['nopotentialadmins'] = 'Inga möjliga administratörer';
$string['nopotentialcreators'] = 'Inga möjliga kursutvecklare';
$string['nopotentialstudents'] = 'Inga möjliga studenter/elever/deltagare/lärande';
$string['nopotentialteachers'] = 'Inga möjliga distanslärare/handledare/coacher';
$string['norecentactivity'] = 'Ingen nylig aktivitet';
$string['noreplybouncemessage'] = 'Du har skickat ett svar till e-postadress som inte tar emot några svar. Om Du försökte att besvara ett inlägg i ett forum, var då snäll och svara genom att använda {$a} forumen.

Det nedanstående är innehållet i Ditt e-postmeddelande:';
$string['noreplybouncesubject'] = '{$a} - returnerad e-post';
$string['noreplyname'] = 'Svara inte på detta e-postmeddelande';
$string['noresetrecord'] = 'Det finns inga uppgifter om den återställningbegäran. Vänligen starta en ny begäran om lösenordsåterställning.';
$string['noresults'] = 'Inga resultat';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normalt filter';
$string['nosite'] = 'Det gick inte att hitta en kurs på webbplatsnivå.';
$string['nostudentsfound'] = 'Hittade ingen/inga  {$a}';
$string['nostudentsingroup'] = 'Det finns inga studenter/elever/deltagare/lärande i den här gruppen ännu.';
$string['nostudentsyet'] = 'Inga studenter/elever/deltagare/lärande har antagits till denna kurs ännu.';
$string['nosuchemail'] = 'Ingen sådan e-postadress';
$string['notavailable'] = 'Ej tillgänglig';
$string['noteachersyet'] = 'Inga distanslärare/handledare/coacher för denna kurs ännu.';
$string['notenrolled'] = '{$a} har inte antagits till denna kurs.';
$string['notenrolledprofile'] = 'Den här profilen är inte tillgänglig eftersom den här användaren inte är registrerad på den här kursen.';
$string['noteusercannotrolldatesoncontext'] = 'Möjligheten att ändra  startdatum (rulla datum) vid återställning av denna säkerhetskopia har inaktiverats eftersom du saknar den behörighet som krävs';
$string['noteuserschangednonetocourse'] = 'OBS! När användardata återställs måste användarna av denna kurs också återställas. Denna inställning har ändrats för Dig.';
$string['nothingnew'] = 'Inget nytt sedan Din senaste inloggning.';
$string['nothingtodisplay'] = 'Inget att visa.';
$string['notice'] = 'Meddelande';
$string['noticenewerbackup'] = 'Den här säkerhetskopierade filen har skapats med Moodles {$a->backuprelease} ({$a->backupversion})och den är nyare än Din nyligen installerade Moodle {$a->serverrelease} ({$a->serverversion}). Det här kan skapa en del ev oönskade förändringar eftersom det inte går att garantera bakåtkompatibilitet för säkerhetskopierade filer.';
$string['notifications'] = 'Administration';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Användare: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Du kan se dessa loggar på {$a}/course/log.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Här är en lista över misslyckade försök att logga in på {$a} sedan Du senast fick meddelande om sådana.';
$string['notifyloginfailuressubject'] = '{$a} :: Information om misslyckade försök att logga in.';
$string['notincluded'] = 'Ingår ej';
$string['notingroup'] = 'Du måste tyvärr vara registrerad i en grupp för att ta del av den här aktiviteten.';
$string['notpublic'] = 'Inte offentlig';
$string['nousersfound'] = 'Det gick inte att hitta några användare';
$string['nousersmatching'] = 'Inga användare som matchar \'{$a}\'  kunde hittas.';
$string['nousersyet'] = 'Det finns inga användare ännu.';
$string['novalidcourses'] = 'Inga giltiga kurser kommer att visas';
$string['now'] = 'nu';
$string['numattempts'] = '{$a} misslyckade försök att logga in.';
$string['numberofcourses'] = 'Antal kurser';
$string['numberweeks'] = 'Antalet sektioner';
$string['numdays'] = '{$a} dagar';
$string['numhours'] = '{$a} timmar';
$string['numletters'] = '{$a} bokstäver';
$string['numminutes'] = '{$a} minuter';
$string['nummonths'] = '{$a} månader';
$string['numseconds'] = '{$a} sekunder';
$string['numviews'] = '{$a} besök';
$string['numweeks'] = '{$a} veckor';
$string['numwords'] = '{$a} ord';
$string['numyears'] = '{$a} år';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Nuvarande lösenord';
$string['olduserdirectory'] = 'Detta är den GAMLA katalogen över användare och den behövs inte längre. Du kan lugnt ta bort den. De filer som den innehåller har kopierats över till den NYA
katalogen över användare.';
$string['opentoguests'] = 'Gästbehörighet';
$string['optional'] = 'Valfri';
$string['options'] = 'alternativ';
$string['order'] = 'Order';
$string['originalpath'] = 'Original sökväg';
$string['orphanedactivitiesinsectionno'] = 'Föräldralösa aktiviteter (sektion {$a})';
$string['other'] = 'Annat';
$string['outline'] = 'Disposition';
$string['outlinereport'] = 'Rapport ang disposition';
$string['page'] = 'Sida';
$string['pagea'] = 'Sida {$a}';
$string['pageheaderconfigablock'] = 'Konfigurerar ett block i {$a->fullname}';
$string['pagepath'] = 'Sidans sökväg';
$string['pageshouldredirect'] = 'Denna sida bör automatiskt omdirigeras. Om ingenting händer kan du använda Fortsätt länken nedan.';
$string['parentcategory'] = 'Föräldrakategori';
$string['parentcoursenotfound'] = 'Det gick inte att hitta någon \'föräldra\'-kurs.';
$string['parentfolder'] = '\'Föräldra\'-katalog';
$string['participants'] = 'Deltagare';
$string['participantslist'] = 'Deltagarlistan';
$string['participationratio'] = 'Omfattning av deltagande';
$string['participationreport'] = 'Rapport om deltagande';
$string['password'] = 'Lösenord';
$string['passwordchanged'] = 'Lösenordet har ändrats.';
$string['passwordconfirmchange'] = 'Bekräfta ändring av lösenord';
$string['passwordextlink'] = 'Den följande länken är till för att hjälpa Dig att återvinna Ditt förlorade lösenord. Du kommer att lämna Moodle.';
$string['passwordforgotten'] = 'Förlorat lösenord';
$string['passwordforgotteninstructions'] = 'Moodle måste först hitta uppgifter om Din person i databasen. Var snäll och skriv i därför avsedd textruta in <strong> antingen</strong> Ditt användarnamn eller den e-postadress som Du har registrerat. Du behöver inte skriva in båda.';
$string['passwordforgotteninstructions2'] = 'För att återställa ditt lösenord, fyll i ditt användarnamn eller din e-postadress nedan. Om vi kan hitta dig i databasen kommer ett mail att skickas till din e-postadress med vidare instruktioner.';
$string['passwordnohelp'] = 'Det går inte att återvinna Ditt förlorade lösenord. Var snäll och kontakta administratören av Moodle.';
$string['passwordrecovery'] = 'Ja, hjälp mig att logga in.';
$string['passwordsdiffer'] = 'Dessa lösenord matchar inte.';
$string['passwordsent'] = 'Lösenord har skickats.';
$string['passwordsenttext'] = '<p>Vi har skickat ett e-postbrev till Din adress:<br /> {$a->email}.</p>
   <p><b>Läs e-postmeddelandet för att se Ditt nya lösenord</b></p>
   <p>Detta lösenord har skapats automatiskt och om Du vill kan Du<br />
   <a href="{$a->link}">ändra lösenordet</a>  till något som är lättare att komma ihåg.</p>';
$string['passwordset'] = 'Ditt lösenord har satts.';
$string['path'] = 'Sökväg';
$string['pathnotexists'] = 'Sökvägen finns inte på Din server!';
$string['pathslasherror'] = 'Sökvägar kan inte avslutas med snedstreck (slash)!!';
$string['paymentinstant'] = 'Använd knappen nedan för att betala och bli registrerad inom några minuter!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> avvaktande</small>)';
$string['paymentrequired'] = 'För att få tillgång till den här kursen måste Du betala först.';
$string['payments'] = 'Betalningar';
$string['paymentsorry'] = 'Tack för Din betalning! Tyvärr så har Din betalning ännu inte slutförts och Du är ännu ínte registrerad för att få tillgång till kursen "{$a->fullname}". Fortsätt gärna med att försöka få tillgång till kursen inom några sekunder men om Du har fortsatta problem så måste Du kontakta {$a->teacher} eller webbplatsens administratör.';
$string['paymentthanks'] = 'Tack för Din betalning! Du är nu registrerad på Din kurs: <br />"{$a}"';
$string['pendingrequests'] = 'Väntande förfrågningar';
$string['periodending'] = 'Perioden upphör ({$a})';
$string['perpage'] = 'Per sida';
$string['perpagea'] = 'Per sida: {$a}';
$string['personal'] = 'Personlig';
$string['personalprofile'] = 'Personlig profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-info';
$string['pictureof'] = 'Bild av {$a}';
$string['pictureofuser'] = 'Användarbild';
$string['pleaseclose'] = 'Var snäll och stäng det här fönstret nu.';
$string['pleasesearchmore'] = 'Var god och sök mer';
$string['pleaseusesearch'] = 'Använd sök';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Kontroll av plugins';
$string['plugindeletefiles'] = 'Alla data som är associerade med plugin \'{$a->name}\' har tagits bort från databasen. För att förhindra att plugin-et  installeras på nytt, bör du ta bort nu den här katalogen från servern: {$a->directory}';
$string['pluginsetup'] = 'Installerar tabeller för plugins';
$string['policyaccept'] = 'Jag förstår och accepterar';
$string['policyagree'] = 'Du måste acceptera denna policy för få fortsätta att använda denna webbplats. Accepterar Du denna policy?';
$string['policyagreement'] = 'Avtal angående webbplatsens policy.';
$string['policyagreementclick'] = 'Klicka här för att läsa avtalet angående webbplatsens policy.';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Öppna filen i ett nytt fönster .';
$string['popupwindowname'] = 'Popup-fönster';
$string['post'] = 'Inlägg';
$string['posts'] = 'Inlägg';
$string['potentialadmins'] = 'Möjliga administratörer';
$string['potentialcreators'] = 'Möjliga kursutvecklare';
$string['potentialstudents'] = 'Möjliga studenter/elever/deltagare/lärande';
$string['potentialteachers'] = 'Möjliga distanslärare/handledare/coacher';
$string['preferences'] = 'De val Du föredrar';
$string['preferredlanguage'] = 'Det språk Du föredrar att använda';
$string['preferredtheme'] = 'Det tema Du föredrar att använda';
$string['preprocessingbackupfile'] = 'Förbehandlar säkerhetskopian';
$string['prev'] = 'Föreg';
$string['preview'] = 'Förhandsgranska';
$string['previewhtml'] = 'Förhandsgranskning av HTLM-format';
$string['previeworchoose'] = 'Förhandsgranska eller välj ett tema';
$string['previous'] = 'Tidigare';
$string['previouslyselectedusers'] = 'Tidigare valda användare matchar inte \'{$a}\'';
$string['previoussection'] = 'Föregående sektion';
$string['primaryadminsetup'] = 'Registrera ett konto för administratör';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Den här profilbeskrivningen kommer inte att visas förrän denna person är inskriven i minst en kurs.';
$string['publicprofile'] = 'Offentlig profil';
$string['publicsitefileswarning'] = 'Obs! de filer som är placerade här är tillgängliga för alla.';
$string['publicsitefileswarning2'] = 'Obs! Filer placerade här kan nås av vem som helst som känner (eller kan gissa) URL. Av säkerhetsskäl rekommenderas att alla säkerhetskopior raderas omedelbart efter att återställts.';
$string['publicsitefileswarning3'] = 'Obs! Filer placerade här kan nås av vem som helst som känner (eller kan gissa) URL. <br /> Av säkerhetsskäl bör säkerhetskopior sparas i den säkra mappen för säkerhetskopior.';
$string['publish'] = 'Offentliggör';
$string['question'] = 'Fråga';
$string['questionsinthequestionbank'] = 'Frågor i frågebanken';
$string['readinginfofrombackup'] = 'Läser från säkerhetskopia';
$string['readme'] = 'LAESMIG';
$string['recentactivity'] = 'Aktuell aktivitet';
$string['recentactivityreport'] = 'Full rapport angående senaste aktiviteter.';
$string['recipientslist'] = 'Förteckning över mottagare.';
$string['recreatedcategory'] = 'Kategorin {$a} har återskapats.';
$string['redirect'] = 'Koppla vidare';
$string['reducesections'] = 'Minska antalet sektioner';
$string['refresh'] = 'Uppdatera';
$string['refreshingevents'] = 'Uppdaterar händelser...';
$string['registration'] = 'Registrering av Moodle';
$string['registrationcontact'] = 'Kontakt från användarna';
$string['registrationcontactno'] = 'Nej, jag vill inte ha något formulär för kontakt i listan över webbplatsen.';
$string['registrationcontactyes'] = 'Ja, lägg in ett formulär så att presumtiva moodlare kan kontakta mig.';
$string['registrationemail'] = 'Meddelanden via e-post';
$string['registrationinfo'] = '<p>Den här sidan hjälper Dig att registrera Din Moodle-sajt hos moodle.org. Registreringen är gratis.</p> Den största fördelen med att registrera sajten är att Du kommer med på en e-postlista (som skickar ut ett begränsat antal meddelanden) för utskick av viktig information om säkerhetsvarningar och nya versioner av Moodle.<p>Som standardval så kommer den information som Du lämnar att vara privat och kommer inte att säljas eller överlåtas till någon annan. Den enda anledningen till att vi samlar in den här informationen är för att erbjuda support och för att kunna skapa en statistisk bild av Moodle-gemenskapen i dess helhet.</p>
<p>
Om Du så väljer så kan Du tillåta att namnet på Din sajt, Ditt land och Din URL kommer med på listan över Moodle-sajter.</p>
<p>
Alla nya registreringar bekräftas manuellt innan de bifogas till listan med när Du väl är med så kan Du uppdater Din registrering (och Ditt bidrag till den offentliga listan) när som helst bara genom att fylla i och skicka det här formuläret igen. </p>';
$string['registrationinfotitle'] = 'Registreringsinformation';
$string['registrationno'] = 'Nej, jag vill inte ha någon e-post.';
$string['registrationsend'] = 'Skicka information för registrering till moodle.org.';
$string['registrationyes'] = 'Ja, var snäll och håll mig informerad om viktiga frågor.';
$string['reject'] = 'Avslå';
$string['rejectdots'] = 'Avslå...';
$string['reload'] = 'Uppdatera';
$string['remoteappuser'] = 'Fjärranvändare {$a}';
$string['remove'] = 'Ta bort';
$string['removeadmin'] = 'Ta bort administratör';
$string['removecreator'] = 'Ta bort kursutvecklare';
$string['removestudent'] = 'Ta bort studenter/elever/deltagare/lärande';
$string['removeteacher'] = 'Ta bort distanslärare/handledare/coach';
$string['rename'] = 'Döp om';
$string['renamefileto'] = 'Byt namn på <b>{$a}</b> till';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['repositories'] = 'Arkiv';
$string['requestcourse'] = 'Ansök om en kurs';
$string['requestedby'] = 'Ansökan gjord av';
$string['requestedcourses'] = 'Begärda kurser';
$string['requestreason'] = 'Skäl för att ansöka om kurs';
$string['required'] = 'Obligatorisk';
$string['requirespayment'] = 'För att få tillgång till den här kursen måste Du betala.';
$string['reset'] = 'Återställ';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Återställ kurs';
$string['resetinfo'] = 'Den här sidan låter Dig tömma en kurs på användardata samtidigt som aktiviteterna och andra inställningar bibehålls. Kom alltså ihåg att om Du väljer de nedanstående komponenterna och bekräftar Dina val på den här sidan så kommer Du, från den här kursen, permanent att ta bort de användardata som Du har valt.';
$string['resetnotimplemented'] = 'Återställning har inte implementerats';
$string['resetrecordexpired'] = 'Länken för lösenordsåterställning du använde är mer än {$a} minuter gammal och har löpt ut. Vänligen starta en ny lösenordsåterställning.';
$string['resetstartdate'] = 'Startdatum för återställning';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Uppgift';
$string['resettodefaults'] = 'Återställ till standardvärden';
$string['resortbyfullname'] = 'Efter fullnamn';
$string['resortbyidnumber'] = 'Efter idnummer';
$string['resortbyshortname'] = 'Efter kortnamn';
$string['resortcourses'] = 'Sortera kurser';
$string['resortsubcategoriesbyidnumber'] = 'Sortera underkategorier på id nummer';
$string['resortsubcategoriesbyname'] = 'Sortera underkategorier efter namn';
$string['resource'] = 'Resurs';
$string['resourcedisplayauto'] = 'Automatisk';
$string['resourcedisplaydownload'] = 'Tvinga fram nedladdning';
$string['resourcedisplayembed'] = 'Bädda in';
$string['resourcedisplayframe'] = 'I ram';
$string['resourcedisplaynew'] = 'Nytt fönster';
$string['resourcedisplayopen'] = 'Öppna';
$string['resourcedisplaypopup'] = 'I pop-up';
$string['resources'] = 'Resurser';
$string['resources_help'] = 'Resurstyper möjliggör nästan alla typer av webbinnehåll som skall införas i kursen.';
$string['restore'] = 'Återställ';
$string['restorecancelled'] = 'Återställning avbruten.';
$string['restorecannotassignroles'] = 'Återställ behöver tilldela roller och du inte har behörighet att göra det';
$string['restorecannotcreateorassignroles'] = 'Återställ behöver skapa eller tilldela roller och du inte har behörighet att göra det';
$string['restorecannotcreateuser'] = 'Återställningprocessen behöver skapa användarens \'{$a}\' från säkerhetskopian och du saknar behörighet att göra det';
$string['restorecannotoverrideperms'] = 'Återställningsprocessen behöver överskrida behörigheter och du saknar behörighet att göra det';
$string['restorecoursenow'] = 'Återställ denna kurs nu!';
$string['restoredaccount'] = 'Återställt konto';
$string['restoredaccountinfo'] = 'Detta konto har importerats från en annan server och lösenordet har gått förlorad. För att sätta ett nytt lösenord via e-post, klicka på &quot;Fortsätt&quot;';
$string['restorefinished'] = 'Återställning framgångsrikt avslutad.';
$string['restoreto'] = 'Återställ till';
$string['restoretositeadding'] = 'Varning: Du håller på att återställa ingångsidan genom att lägga data till det!';
$string['restoretositedeleting'] = 'Varning: Du håller på att återställa ingångsidan genom att ta bort data från det först!';
$string['restoreuserconflict'] = 'Försök att återställa användarens {$a} &quot;från säkerhetskopian kommer att orsaka konflikter';
$string['restoreuserinfofailed'] = 'Återställningen har stoppats eftersom du inte har behörighet att återställa användardata.';
$string['restoreusersprecheck'] = 'Kontrollerar användardata';
$string['restoreusersprecheckerror'] = 'Några problem upptäcktes vid kontroll av användardata';
$string['restricted'] = 'Begränsad';
$string['returningtosite'] = 'Återvänder Du till den här webbplatsen?';
$string['returntooriginaluser'] = 'Återgå till {$a}';
$string['revert'] = 'Återgå';
$string['role'] = 'Roll';
$string['roleassignments'] = 'Rolltilldelningar';
$string['rolemappings'] = 'Kartläggning av roller';
$string['rolerenaming'] = 'Byte av namn på roll';
$string['rolerenaming_help'] = 'Denna inställning tillåter ändring av namnen för rollerna som används i kursen.

Endast det visade namnet ändras - rollbehörigheter påverkas inte. Nya rollnamn visas på kursdeltagarnas sidan och på andra håll inom kursen.

Om rollen med det nya namnet är en roll som administratören har använt för att tilldela lärarroller, kommer det nya namnet att visas som en del av kurslistan.';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Antal aktuella RSS-artiklar';
$string['rsserror'] = 'Fel vid läsning av RSS-data';
$string['rsserrorauth'] = 'Din RSS-länk innehåller inte en giltig autentiseringstoken.';
$string['rsserrorguest'] = 'Detta flöde använder gäståtkomst för att få tillgång till data, men gäster har inte behörighet att läsa data. Besök den ursprungliga platsen (URL) för detta-RSS flöde som en giltig användare och få en ny RSS-länk därifrån.';
$string['rsskeyshelp'] = 'För att garantera säkerheten och personliga data, innehåller URL:en för RSS flöden speciella typ av kryptering som identifierar vilken användare den är för. Detta förhindrar andra användare från att komma åt områden i Moodle som de inte ska ha tillgång till via RSS flöden. </p><p> Den här krypteringen genereras automatiskt första gången du besöker ett område i Moodle som genererar ett RSS flöde. Om du tror att ditt krypterade RSS flöde har blivit osäkert kan du efterfråga ett nytt genom att klicka på Återställ länk här. Vänligen noterar att URL:en till dina nuvarande RSS flöden kommer sluta fungera.';
$string['rsstype'] = 'RSS-utmatningar för denna aktivitet.';
$string['saveandnext'] = 'Spara och visa nästa.';
$string['savechanges'] = 'Spara ändringar.';
$string['savechangesanddisplay'] = 'Spara och visa';
$string['savechangesandreturntocourse'] = 'Spara och återgå till kurs';
$string['savecomment'] = 'Spara kommentar';
$string['savedat'] = 'Sparad:';
$string['savepreferences'] = 'Spara inställningar.';
$string['saveto'] = 'Spara till';
$string['scale'] = 'Skala';
$string['scale_help'] = '<p>Distansl&auml;rare kan skapa nya standardskalor
som de kan anv&auml;nda i en kurs f&ouml;r alla
typer av bed&ouml;mning/v&auml;rdering/betygss&auml;ttning.</p>
<p>Namnet p&aring; skalan b&ouml;r vara en fras
som g&ouml;r att man k&auml;nner igen den. Den
visas p&aring; listorna &ouml;ver skalor som man
kan v&auml;lja och p&aring; hj&auml;lpknappar
som dyker upp i det givna sammanhanget.</p>
<p>Sj&auml;lva skalan best&aring;r av en kommaseparerad lista i en
viss ordning som str&auml;cker sig fr&aring;n det
negativa till det positiva. Som till exempel: </p>
<blockquote><i>
   Otillfredsst&auml;llande, Inte tillr&auml;ckligt bra, Mittemellan, Bra, Mycket bra, Utm&auml;rkt
</i></blockquote>
<p>Skalan b&ouml;r ocks&aring; inneh&aring;lla en bra beskrivning av vad den
betyder och hur man f&ouml;rv&auml;ntas anv&auml;nda den. Denna beskrivning
visas p&aring; hj&auml;lpsidor som b&aring;de distansl&auml;rare och l&auml;rande
kan se.</p>
<p>Slutligen s&aring; kan det finnas en eller flera \'standard\'-skalor p&aring; Din sajt som
systemadministrat&ouml;ren har definierat. Dessa kommer att vara tillg&auml;ngliga f&ouml;r alla
kurser.</p>';
$string['scales'] = 'Skalor';
$string['scalescustom'] = 'Egendefinierade skalor';
$string['scalescustomcreate'] = 'Lägg till en ny skala';
$string['scalescustomno'] = 'Inga egendefinierade skalor har ännu lagts till.';
$string['scalesstandard'] = 'Standardskalor';
$string['scalestandard'] = 'Standardskala';
$string['scalestandard_help'] = '<p>En standardskala är tillgänglig på hela webbplatsen för alla kurser.</p>';
$string['scalestip'] = 'För att skapa egendefinierade skalor så får Du använda länken \'Skalor\' på menyn för administration av Din kurs.';
$string['scalestip2'] = 'Om du vill skapa anpassade skalor, klicka på betygslänken i kursadministrationen menyn och välj Redigera, Skalor.';
$string['schedule'] = 'Schema';
$string['screenshot'] = 'Skärmdump';
$string['search'] = 'Sök';
$string['searchagain'] = 'Sök igen';
$string['searchbyemail'] = 'Sök enligt e-postadress';
$string['searchbyusername'] = 'Sök enligt användarnamn';
$string['searchcourses'] = 'Sök kurser';
$string['searchhelp'] = 'Du kan söka på flera ord samtidigt.<br /><br />ord: sök varje matchande ord inom texten<br />+ord: sök endast ord som matchar exakt<br />-ord: ta inte med resultat som innehåller detta ord.';
$string['search_help'] = 'För grundläggande sökning av ett eller flera ord var som helst i texten, skriv dem åtskilda av mellanslag. Alla ord längre än två tecken används.

För avancerad sökning, tryck på sök-knappen utan att skriva något i sökrutan för att komma åt den avancerade sökfunktionen.';
$string['searchoptions'] = 'Sökalternativ';
$string['searchresults'] = 'Sökresultat';
$string['sec'] = 'Sekund';
$string['seconds'] = 'sekunder';
$string['secondstotime172800'] = '2 dagar';
$string['secondstotime259200'] = '3 dagar';
$string['secondstotime345600'] = '4 dagar';
$string['secondstotime432000'] = '5 dagar';
$string['secondstotime518400'] = '6 dagar';
$string['secondstotime604800'] = '1 vecka';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Länken till bekräftelse av ändring av lösenord har redan använts, lösenordet har inte ändrats.';
$string['secs'] = 'Sekunder';
$string['section'] = 'Sektion';
$string['sectionname'] = 'Namn på sektion';
$string['sections'] = 'Sektioner';
$string['sectionusedefaultname'] = 'Använd standardnamn för sektionen';
$string['seealsostats'] = 'Se också: stats';
$string['selctauser'] = 'Välj en användare';
$string['select'] = 'Välj';
$string['selectacategory'] = 'Vänligen välj en kategori';
$string['selectacountry'] = 'Välj ett land';
$string['selectacourse'] = 'Välj en kurs';
$string['selectacoursesite'] = 'Välj en kurs eller site';
$string['selectagroup'] = 'Välj en grupp';
$string['selectall'] = 'Välj alla';
$string['selectamodule'] = 'Var snäll och välj en aktivitetsmodul';
$string['selectanaction'] = 'Välj en åtgärd';
$string['selectanoptions'] = 'Välj ett alternativ';
$string['selectaregion'] = 'Välj en region';
$string['selectcategorysort'] = 'Vilka kategorier skulle du vilja att sortera?';
$string['selectcategorysortby'] = 'Välj hur du vill sortera kategorier';
$string['selectcoursesortby'] = 'Välj hur du vill sortera kurser';
$string['selectdefault'] = 'Välj standardinställning';
$string['selectedcategories'] = 'Valda kategorier';
$string['selectedfile'] = 'Vald fil';
$string['selectednowmove'] = '{$a} filer är markerade för att bli flyttade. Gå nu till destinationen och välj "Flytta valda filer hit".';
$string['selectfiles'] = 'Välj filer';
$string['selectmoduletoviewhelp'] = 'Välj en aktivitet eller resurs för att visa dess hjälp.

Dubbelklicka på namnet på en aktivitet eller resurs för att snabbt lägga till den.';
$string['selectnos'] = 'Markera alla \'nej\'';
$string['selectperiod'] = 'Välj period';
$string['senddetails'] = 'Sänd mina uppgifter för inloggning via e-post.';
$string['separate'] = 'Separat';
$string['separateandconnected'] = 'Enskild (rationell) och social(empatisk) inriktning ang vetande (kunskap)';
$string['separateandconnectedinfo'] = 'Skalan baseras på teorin om separat och ansluten kunskap. Denna teori beskriver två olika sätt som vi kan utvärdera och lära oss om det vi ser och hör. <ul><li> <strong>Separata kunskaper</strong> förblir så objektiv som möjligt utan att inkludera känslor. I en diskussion med andra människor, tycker de om att försvara sina egna idéer genom att utnyttja logik för att hitta hål i motståndarens idéer. </li><li> <strong>Ansluten kunskap</strong> är mer känsliga för andra människor. De är duktiga på empati och tenderar att lyssna och ställa frågor tills de känner att de kan ansluta och "förstå saker ur deras synvinkel". De lär sig genom att dela de erfarenheter som ledde till den kunskap de hittar i andra människor. </li></ul>';
$string['servererror'] = 'Ett fel inträffade vid kommunikation med servern';
$string['serverlocaltime'] = 'Serverns lokala tid';
$string['setcategorytheme'] = 'Ställ tema för kategori';
$string['setpassword'] = 'Sätt lösenord';
$string['setpasswordinstructions'] = 'Var god ange och repetera ditt nya lösenord nedanför. Klicka sedan "Sätt lösenord". <br/>Ditt nya lösenord kommer sparas och du kommer loggas in.';
$string['settings'] = 'Inställningar';
$string['shortname'] = 'Kortnamn';
$string['shortnamecollisionwarning'] = '[*] = det här kortnamnet används redan för en annan kurs så Du måste byta det om kursen blir godkänd.';
$string['shortnamecourse'] = 'Kortnamn för kurs';
$string['shortnamecourse_help'] = '<p>M&aring;nga institutioner har kortnamn p&aring; sina kurser som t ex
BP102 eller COMMS. &Auml;ven om Du inte redan har ett s&aring;dant namn
s&aring; kan Du hitta p&aring; ett h&auml;r. Det kommer att anv&auml;ndas
p&aring; ett flertal st&auml;llen d&auml;r det l&aring;nga namnet inte
passar, som t ex p&aring; &auml;mnesraden i ett e-postmeddelande.
</p>';
$string['shortnametaken'] = 'Kortnamnet används redan av för en annan kurs {$a}.';
$string['shortnameuser'] = 'Användare kortnamn';
$string['shortsitename'] = 'Kortnamn för webbplats (t.ex. ett ord).';
$string['show'] = 'Visa';
$string['showactions'] = 'Visa handlingar';
$string['showadvancedsettings'] = 'Visa avancerade inställningar.';
$string['showall'] = 'Visa alla {$a}';
$string['showallcourses'] = 'Visa alla kurser';
$string['showallusers'] = 'Visa alla användare';
$string['showblockcourse'] = 'Visa en lista över kurser som innehåller block.';
$string['showcategory'] = 'Visa {$a}';
$string['showcomments'] = 'Visa/dölj kommentarer';
$string['showcommentsnonjs'] = 'Visa kommentarer';
$string['showdescription'] = 'Visa beskrivning på kurssidan';
$string['showdescription_help'] = 'Om aktiverad så kommer beskrivningen ovanför att visas på kurssidan strax under länken till aktiviteten eller resursen.';
$string['showgrades'] = 'Visa betygskatalogen för studenter/deltagare/elever/lärande';
$string['showgrades_help'] = '<p>M&aring;nga av aktiviteterna g&aring;r att betygss&auml;tta eller
avge omd&ouml;men om.</p>
<p>Standardvalet &auml;r att en &ouml;versikt av
alla betygs-/omd&ouml;mesresultat visas p&aring;
Betygs/Omd&ouml;messidan. Den kan n&aring;s fr&aring;n kursens
hemsida.</p>
<p>Om distansl&auml;raren inte vill anv&auml;nda betyg/omd&ouml;men
p&aring; en kurs, eller bara vill d&ouml;lja s&aring;dan information
f&ouml;r de l&auml;rande s&aring; kan han/hon avaktivera denna visning
i \'Inst&auml;llningar f&ouml;r kursen\'. Detta hindrar inte att man
kan s&auml;tta betyg/avge omd&ouml;men p&aring; individuella aktiviteter.
Det inneb&auml;r bara att de l&auml;rande inte f&aring;r se denna information.</p>';
$string['showingacourses'] = 'Visar alla {$a} kurser';
$string['showingxofycourses'] = 'Visar kurser {$a->start} till {$a->end} av {$a->total} kurser';
$string['showlistofcourses'] = 'Visa lista på kurser';
$string['showmodulecourse'] = 'Visa en lista över kurser som innehåller aktiviteter.';
$string['showonly'] = 'Visa bara';
$string['showperpage'] = 'Via {$a} per sida';
$string['showrecent'] = 'Visa senaste aktivitet';
$string['showreports'] = 'Visa aktivitetsrapporter';
$string['showreports_help'] = '<p>Varje aktiv deltagare f&aring;r se rapporter &ouml;ver de egna aktiviteterna
i den aktuella kursen. Det finns b&aring;de listor &ouml;ver deltagarens
bidrag och detaljerade loggar &ouml;ver n&auml;r deltagaren har kopplat
upp sig.</p>
<p>(Distans)l&auml;rare kan alltid f&aring; tillg&aring;ng till dessa
rapporter genom att anv&auml;nda knappen \'&ouml;gat\' (visa) p&aring; varje
deltagares profilsida.</p>
<p>Studenternas/elevernas/deltagarnas/de l&auml;randes tillg&aring;ng
till sina egna rapporter kontrolleras av (distans)l&auml;raren via
en inst&auml;llning f&ouml;r kursen.
F&ouml;r en del kurser kan detta vara ett anv&auml;ndbart verktyg
f&ouml;r att f&aring; studenterna/eleverna/deltagarna/de l&auml;rande
att reflektera &ouml;ver sina insatser och hur de framst&aring;r
i denna (p&aring; sitt s&auml;tt) offentliga milj&ouml;.
Det &auml;r dock kanske inte alltid n&ouml;dv&auml;ndigt.</p>
<p>En annan anledning till att avaktivera detta &auml;r att rapporten
kan komma att belasta servern i on&ouml;dan. F&ouml;r kurser med m&aring;nga deltagare
eller kurser som varar l&auml;nge kan det vara effektivare att avaktivera denna funktion.</p>';
$string['showsettings'] = 'Visa inställningar';
$string['showtheselogs'] = 'Visa dessa loggar';
$string['showthishelpinlanguage'] = 'Visa denna hjälp på språket: {$a}';
$string['since'] = 'Sedan';
$string['sincelast'] = 'sedan senaste login';
$string['site'] = 'Webbplats';
$string['sitedefault'] = 'Förinställt värde för webbplatsen';
$string['siteerrors'] = 'fel på webbplatsen';
$string['sitefiles'] = 'Webbplatsens filer';
$string['sitefilesused'] = 'De filer på webbplatsen som används i den här kursen';
$string['sitehome'] = 'Hem för webbplats';
$string['sitelegacyfiles'] = 'Ärvda filer på webbplatsnivå';
$string['sitelogs'] = 'Webbplatsloggar';
$string['sitemessage'] = 'Meddelande användare';
$string['sitenews'] = 'Webbplatsnyheter';
$string['sitepages'] = 'Sidor på webbplatsen';
$string['sitepartlist'] = 'Du har inte tillstånd att se förteckningen över deltagare.';
$string['sitepartlist0'] = 'Du måste vara registrerad som (distans)lärare på (global) webbplatsnivå för att få se förteckningen över samtliga deltagare på webbplatsen.';
$string['sitepartlist1'] = 'Du måste vara registrerad som (distans)lärare för att få se förteckningen över samtliga deltagare på webbplatsen.';
$string['sites'] = 'Webbplatser';
$string['sitesection'] = 'Ta med en sektion för ämnen.';
$string['sitesettings'] = 'Inställningar för  webbplatsen.';
$string['siteteachers'] = '(Distans)lärare på (global) webbplatsnivå';
$string['size'] = 'Storlek';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Överhoppad';
$string['skiptocategorylisting'] = 'Gå vidare till kategorilistor';
$string['skiptocoursedetails'] = 'Gå vidare till den detaljerade kursinformationen';
$string['skiptocourselisting'] = 'Gå vidare till kurslistor';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Gemenskapsforum - senaste tema';
$string['someallowguest'] = 'Några kurser kan tillåta gäster';
$string['someerrorswerefound'] = 'Några uppgifter saknades eller var felaktiga. Se nedan för detaljer.';
$string['sort'] = 'Sortera';
$string['sortby'] = 'Sortera enligt';
$string['sortbyx'] = 'Sortera enligt {$a} stigande';
$string['sortbyxreverse'] = 'Sortera enligt {$a} fallande';
$string['sortcategoriesbyidnumber'] = 'Sortera kategorier efter ID-nummer';
$string['sortcategoriesbyname'] = 'Sortera kategorier efter namn';
$string['sortcoursesbyfullname'] = 'Sortera kurser med fullständiga namn';
$string['sortcoursesbyidnumber'] = 'Sortera kurser efter ID-nummer';
$string['sortcoursesbyshortname'] = 'Sortera kurser på kortnamn';
$string['sorting'] = 'Sortering';
$string['sourcerole'] = 'Källa för roll';
$string['specifyname'] = 'Du måste ange ett  namn.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*]  = kurs i kö för att bli godkänd';
$string['startdate'] = 'Kursens startdatum';
$string['startdate_help'] = '<p>Det &auml;r h&auml;r Du anger startdatum f&ouml;r Din kurs,
i Din egen tidszon.</p>
<p>Om Du anv&auml;nder \'Vecko\'-format p&aring; kursen s&aring;
kommer detta att p&aring;verka hur veckorna visas.
Den f&ouml;rsta veckan kommer att b&ouml;rja p&aring; det datum
som Du st&auml;ller in h&auml;r. </p>
<p>Den h&auml;r inst&auml;llningen kommer inte att p&aring;verka
de kurser som anv&auml;nder \'Gemenskaps-\' eller \'Ämnes\'-format.</p>
<p>Inst&auml;llningen kommer dock att p&aring;verka
hur loggarna visas. De anv&auml;nder detta datum som det f&ouml;rsta
m&ouml;jliga datumet som Du kan visa.</p>
<p>Rent allm&auml;nt s&aring; kan det, oavsett kursformat, vara bra
att st&auml;lla in startdatum om Din kurs har ett faktiskt s&aring;dant.</p>';
$string['startingfrom'] = 'Med start från';
$string['startsignup'] = 'Starta nu genom att skapa ett nytt konto!';
$string['state'] = 'Stat/region';
$string['statistics'] = 'Statistik';
$string['statisticsgraph'] = 'Graf över statistik';
$string['stats'] = 'Statistik';
$string['statslogins'] = 'Inloggningar';
$string['statsmodedetailed'] = 'Detaljerad vy (användare)';
$string['statsmodegeneral'] = 'Allmän vy';
$string['statsnodata'] = 'Det finns inga tillgängliga data för den kombinationen av kurs och tidsperiod.';
$string['statsnodatauser'] = 'Det finns inga tillgängliga data för den kombinationen av kurs, användare och tidsperiod.';
$string['statsoff'] = 'Statistiken är f n inte aktiverad';
$string['statsreads'] = 'Visningar';
$string['statsreport1'] = 'Inloggningar';
$string['statsreport10'] = 'Aktivitet - användare';
$string['statsreport11'] = 'Mest aktiva kurser';
$string['statsreport12'] = 'Mest aktiva kurser (viktade)';
$string['statsreport13'] = 'Kurser med flest deltagare (registreringar)';
$string['statsreport14'] = 'Mest aktiva kurser (visningar/inlägg)';
$string['statsreport2'] = 'Visningar (lärare och lärande)';
$string['statsreport3'] = 'Inlägg (lärare och lärande)';
$string['statsreport4'] = 'Alla aktiviteter (lärare och lärande)';
$string['statsreport5'] = 'Alla aktiviteter av lärande (visningar och inlägg)';
$string['statsreport7'] = 'Aktiviteter av användare (visningar och inlägg)';
$string['statsreport8'] = 'All användaraktivitet';
$string['statsreport9'] = 'Inloggningar (webbplats kurs)';
$string['statsreportactivity'] = 'Alla aktiviteter (lärare och lärande)';
$string['statsreportactivitybyrole'] = 'All aktivitet (visningar och inlägg)';
$string['statsreportforuser'] = 'för';
$string['statsreportlogins'] = 'Inloggningar';
$string['statsreportreads'] = 'Visningar (lärare och lärande)';
$string['statsreporttype'] = 'Typ av rapport';
$string['statsreportwrites'] = 'Inlägg (lärare  och lärande)';
$string['statsstudentactivity'] = 'Aktiviteter - lärande';
$string['statsstudentreads'] = 'Vy - lärande';
$string['statsstudentwrites'] = 'Inlägg av studenter';
$string['statsteacheractivity'] = 'Aktiviteter - lärare';
$string['statsteacherreads'] = 'Vy lärare';
$string['statsteacherwrites'] = 'Inlägg av lärare';
$string['statstimeperiod'] = 'Tidsperiod - senast:';
$string['statsuniquelogins'] = 'Unika inloggningar';
$string['statsuseractivity'] = 'Alla aktiviteter';
$string['statsuserlogins'] = 'Inloggningar';
$string['statsuserreads'] = 'Vyer';
$string['statsuserwrites'] = 'Inlägg';
$string['statswrites'] = 'Inlägg';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Följande strängar är inte definierade i {$a}';
$string['studentnotallowed'] = 'Tyvärr, men Du kan inte registrera Dig på denna kurs som \'{$a}\'.';
$string['students'] = 'studenter/<br />elever/<br />deltagare/lärande';
$string['studentsandteachers'] = 'Studenter/<br />elever/<br />deltagare/l<br />ärande och (distans)lärare';
$string['subcategories'] = 'Underkategorier';
$string['subcategory'] = 'Underkategori';
$string['subcategoryof'] = 'Underkategori till {$a}';
$string['submit'] = 'Skicka in';
$string['success'] = 'Framgång';
$string['summary'] = 'Summering';
$string['summary_help'] = '<p>Tanken med en sammanfattning av ett &auml;mne &auml;r att f&ouml;rbereda
de l&auml;rande p&aring; aktiviteterna i detta &auml;mne (eller under denna vecka).</p>
<p>Varje sammanfattning b&ouml;r vara mycket kort s&aring; att kurssidan
inte blir f&ouml;r l&aring;ng.</p>
<p>Om Du uppt&auml;cker att Du vill informera med mer &auml;n en eller
tv&aring; meningar s&aring; b&ouml;r Du &ouml;verv&auml;ga att l&auml;gga till
en \'Resurs\' till det h&auml;r &auml;mnet ist&auml;llet.
Den f&ouml;rsta aktiviteten skulle t.ex. kunna vara en sida som kallas:
<b>\'Om detta &auml;mne\'</b>.</p>';
$string['summaryof'] = 'Summering av {$a}';
$string['supplyinfo'] = 'Mer detaljer';
$string['suspended'] = 'Spärrad';
$string['suspendedusers'] = 'Spärrade användare';
$string['switchdevicedefault'] = 'Växla till standard temat';
$string['switchdevicerecommended'] = 'Växla till den rekommenderade temat för enheten';
$string['switchrolereturn'] = 'Återgå till min normala roll';
$string['switchroleto'] = 'Byt roll till...';
$string['tag'] = 'Etikett';
$string['tagalready'] = 'Den här etiketten finns redan';
$string['tagmanagement'] = 'Lägg till/ta bort etiketter...';
$string['tags'] = 'etiketter';
$string['targetrole'] = 'Mål för roll';
$string['teacheronly'] = 'för {$a} endast';
$string['teacherroles'] = '{$a} roller';
$string['teachers'] = 'Distanslärare/<br />handledare/<br />coacher';
$string['textediting'] = 'Textredigerare';
$string['texteditor'] = 'Använd vanliga webbformulär.';
$string['textformat'] = 'Vanligt textformat';
$string['thanks'] = 'Tack';
$string['theme'] = 'Layouttema';
$string['themes'] = 'Layoutteman';
$string['themesaved'] = 'Nytt layouttema sparat.';
$string['therearecourses'] = 'Det finns {$a} kurser';
$string['thereareno'] = 'Det finns inga {$a} i den här kursen';
$string['thiscategory'] = 'Denna kategori';
$string['thiscategorycontains'] = 'Den här kategorin innehåller';
$string['time'] = 'Tid';
$string['timezone'] = 'Tidszon';
$string['to'] = 'Till';
$string['tocontent'] = 'Till "{$a}"';
$string['tocreatenewaccount'] = 'Hoppa vidare för att skapa ett nytt konto. ';
$string['today'] = 'Idag';
$string['todaylogs'] = 'Dagens loggar';
$string['toeveryone'] = 'till alla';
$string['toomanybounces'] = 'Den här e-postadressen har returnerat för många meddelanden. Du <b>måste</b> ändra den för att kunna fortsätta.';
$string['toomanytoshow'] = 'Det finns för många användare att visa.';
$string['toomanyusersmatchsearch'] = 'Alltför många användare ({$a->count}) matchar \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Alltför många användare ({$a}) att visa';
$string['toonly'] = 'endast till {$a}';
$string['top'] = 'Överst';
$string['topic'] = 'Tema';
$string['topichide'] = 'Dölj detta ämne för {$a}';
$string['topicoutline'] = 'Ämnesdisposition';
$string['topicshow'] = 'Visa detta ämne för {$a}';
$string['toplevelcategory'] = 'Toppnivåkategori';
$string['total'] = 'Totalt';
$string['totopofsection'] = 'Till toppen av avsnittet "{$a}"';
$string['trackforums'] = 'Spårning av forum';
$string['trackforumsno'] = 'Nej; spåra inte inlägg som jag har sett.';
$string['trackforumsyes'] = 'Ja: markera nya inlägg åt mig.';
$string['trysearching'] = 'Prova med att söka istället.';
$string['turneditingoff'] = 'Stäng av redigering';
$string['turneditingon'] = 'Aktivera redigering';
$string['undecided'] = 'Ej beslutad';
$string['unfinished'] = 'Oavslutad';
$string['unknowncategory'] = 'Okänd kategori';
$string['unlimited'] = 'Obegränsad';
$string['unpacking'] = 'Packar upp {$a}';
$string['unsafepassword'] = 'Osäkert lösenord - försök med något annat.';
$string['untilcomplete'] = 'Tills det är fullgjort';
$string['unusedaccounts'] = 'Konton som inte har använts på mer än {$a} dagar tas automatiskt bort.';
$string['unzip'] = 'Packa upp';
$string['unzippingbackup'] = 'Packar upp säkerhetskopia...';
$string['up'] = 'Upp';
$string['update'] = 'Uppdatera';
$string['updated'] = 'Uppdaterat {$a}';
$string['updatemymoodleoff'] = 'Sluta att standardisera den här sidan';
$string['updatemymoodleon'] = 'Standardisera den här sidan';
$string['updatemyprofile'] = 'Uppdatera profil';
$string['updatesevery'] = 'Uppdatering varje {$a} sekund';
$string['updatethis'] = 'Uppdatera {$a}';
$string['updatethiscourse'] = 'Uppdatera denna kurs';
$string['updatinga'] = 'Uppdatering av en {$a}';
$string['updatingain'] = 'Uppdatering av en {$a->what} i {$a->in}';
$string['upload'] = 'Ladda upp';
$string['uploadafile'] = 'Ladda upp en fil';
$string['uploadcantwrite'] = 'Det gick inte att skriva filen till disk.';
$string['uploadedfile'] = 'Filen laddades upp framgångsrikt.';
$string['uploadedfileto'] = 'Laddade upp {$a->file} till {$a->directory}';
$string['uploadedfiletoobig'] = 'Den här filen är tyvärr för stor (begränsningen är {$a} bytes).';
$string['uploadextension'] = 'Filuppladdning stoppad av PHP';
$string['uploadfailednotrecovering'] = 'Det gick inte att ladda upp Dina filer eftersom det uppstod ett problem med en av filerna, {$a->name}.<br/> Här är loggen  över problemen:<br />{$a->problem}<br /> återställer inte.';
$string['uploadfilelog'] = 'Logg för uppladdning av filen {$a}';
$string['uploadformlimit'] = 'Den uppladdade filen var större än vad som är tillåtet.';
$string['uploadlabel'] = 'Titel:';
$string['uploadlimitwithsize'] = '{$a->contextname} uppladdningsgräns ({$a->displaysize})';
$string['uploadnewfile'] = 'Ladda upp en ny fil';
$string['uploadnofilefound'] = 'Hittade ingen fil - är Du säker på att Du valde en att ladda upp?';
$string['uploadnotallowed'] = 'Det är inte tillåtet att ladda upp någonting.';
$string['uploadnotempdir'] = 'En temporär katalog saknas';
$string['uploadoldfilesdeleted'] = 'De gamla filerna i det område som laddar upp dem till har tagits bort.';
$string['uploadpartialfile'] = 'Filen laddades bara delvis upp.';
$string['uploadproblem'] = 'Ett okänt fel inträffade under uppladdning av filen \'{$a}\' (kanske var den för stor?)';
$string['uploadrenamedchars'] = 'Filen döptes om från {$a->oldname} till {$a->newname} eftersom den innehöll ogiltiga tecken.';
$string['uploadrenamedcollision'] = 'Filen döptes om från {$a->oldname} till {$a->newname} eftersom det uppstod en konflikt mellan filnamn.';
$string['uploadserverlimit'] = 'Den uppladdade filen var större än vad som är tillåtet.';
$string['uploadthisfile'] = 'Ladda upp denna fil';
$string['url'] = 'URL';
$string['used'] = 'Använd';
$string['usedinnplaces'] = 'Använd på {$a} ställen';
$string['usemessageform'] = 'eller använd formuläret här nedan för att skicka ett meddelande till de valda studenterna/eleverna/deltagarna/lärande';
$string['user'] = 'Användare';
$string['userconfirmed'] = 'Bekräftad {$a}';
$string['usercurrentsettings'] = 'Inställningar för min profil';
$string['userdata'] = 'Användardata';
$string['userdeleted'] = 'Ditt användarkonto har tagits bort.';
$string['userdescription'] = 'Beskrivning';
$string['userdescription_help'] = 'I denna ruta kan du skriva text om dig själv som sedan kommer att visas på din profilsida synlig för andra.';
$string['userdetails'] = 'Detaljer om användare';
$string['userfiles'] = 'Användarfiler';
$string['userlist'] = 'Lista över användare';
$string['username'] = 'Användarnamn';
$string['usernameemailmatch'] = 'Användarnamnet och e-postadressen relaterar inte till samma användare.';
$string['usernameexists'] = 'Detta användarnamn existerar redan, välj ett annat.';
$string['usernamelowercase'] = 'Endast små bokstäver (minuskler) är tillåtna.';
$string['usernamenotfound'] = 'Det gick inte att hitta användarnamnet i databasen.';
$string['usernameoremail'] = 'Skriv antingen in användarnamn eller e-postadress';
$string['usernotconfirmed'] = 'Det gick inte att bekräfta {$a}.';
$string['userpic'] = 'Bild på användare';
$string['users'] = 'Användare';
$string['userselectorautoselectunique'] = 'Om endast en användare matchar sökningen väljer den automatiskt';
$string['userselectorpreserveselected'] = 'Behåll utvalda användare, även om de inte längre matchar sökningen';
$string['userselectorsearchanywhere'] = 'Matcha söktexten var som helst i de visade fälten';
$string['usersnew'] = 'Nya användare';
$string['usersnoaccesssince'] = 'Visa användare som har varit inaktiva i mer än';
$string['userswithfiles'] = 'Användare med filer';
$string['useruploadtype'] = 'Användaruppladdning typ: {$a}';
$string['userviewingsettings'] = 'Profilinställningar för {$a}';
$string['userzones'] = 'Användar-zoner';
$string['usetheme'] = 'Använd tema';
$string['usingexistingcourse'] = 'Använder befintlig kurs.';
$string['valuealreadyused'] = 'Detta värde har redan använts.';
$string['version'] = 'Version';
$string['view'] = 'Visa';
$string['viewallcourses'] = 'Visa alla kurser';
$string['viewallcoursescategories'] = 'Visa alla kurser och kategorier';
$string['viewallsubcategories'] = 'Visa alla underkategorier';
$string['viewfileinpopup'] = 'Visa fil i ett popup-fönster';
$string['viewing'] = 'Tittar på {$a}';
$string['viewmore'] = 'Visa mer';
$string['viewprofile'] = 'Visa profil';
$string['views'] = 'Vyer';
$string['viewsolution'] = 'visa lösning';
$string['virusfound'] = 'Påkallar systemadministratörens uppmärksamhet! Clam AV har hittat ett virus i den fil som laddades upp av {$a->user} till kursen {$a->course}. Här är resultatet av clamscan>';
$string['virusfoundlater'] = 'En fil som Du laddade upp den {$a->date} med filnamnet {$a->filename} till kursen {$a->course} har visat sig innehålla ett virus. Här är ett sammandrag av vad som hände med Din fil:
 {$a->action}
Om det var ett inskickat arbete så kanske Du vill skicka om det så att Din distanslärare kan se det.';
$string['virusfoundlateradmin'] = 'Påkallar systemadministratörens uppmärksamhet! En fil som laddades upp den {$a->date} med filnamnet {$a->filename} till kursen {$a->course} av användaren {$a->user} har visat sig innehålla ett virus. Här är ett sammandrag av vad som hände med filen:
 {$a->action}
Användaren har också meddelats.';
$string['virusfoundlateradminnolog'] = 'Påkallar systemadministratörens uppmärksamhet! En fil som laddades upp med filnamnet {$a->filename}  har visat sig innehålla ett virus. Moodle kunde inte analysera problemet och returnera den informationen till användaren. Här är ett sammandrag av vad som hände med filen:
 {$a->action}';
$string['virusfoundsubject'] = '{$a}: Virus har hittats!';
$string['virusfounduser'] = 'Den fil som Du laddade upp med namnet, {$a->filename}, har skannats med ett antivirusprogram och det visade sig att den innehöll ett virus! Din fil laddades INTE upp på rätt sätt.';
$string['virusplaceholder'] = 'Den här filen som laddades upp visade sig innehålla ett virus. Den har flyttats eller tagits bort och användaren har meddelats.';
$string['visible'] = 'Synlig';
$string['visible_help'] = 'Det här alternativet avgör om kursen visas på listan över kurser.Förutom (distans)-lärare och administratörer så får inga användare logga in på kursen.
';
$string['visibletostudents'] = 'Synlig för {$a}';
$string['warning'] = 'Varning';
$string['warningdeleteresource'] = 'Varning: {$a} refereras i en resurs. Vill Du uppdatera resursen?';
$string['webpage'] = 'Webbsida';
$string['week'] = 'Vecka';
$string['weekhide'] = 'Dölj denna vecka för {$a}';
$string['weeklyoutline'] = 'Veckodisposition';
$string['weeks'] = 'veckor';
$string['weekshow'] = 'Visa denna vecka för {$a}';
$string['welcometocourse'] = 'Välkommen till {$a}';
$string['welcometocoursetext'] = 'Varmt välkommen till {$a->coursename}!

En av de första sakerna Du bör göra är att ändra Din profilsida
inuti kursen så att vi kan lära oss mer om Dig:

  {$a->profileurl}';
$string['whatforlink'] = 'Vad vill du göra med länken?';
$string['whatforpage'] = 'Vad vill du göra med texten?';
$string['whattocallzip'] = 'Vad vill Du kalla  .zip-filen?';
$string['whattodo'] = 'Saker att göra';
$string['windowclosing'] = 'Detta fönster bör stängas automatiskt. Om inte, stäng den nu.';
$string['withchosenfiles'] = 'Med valda filer';
$string['withdisablednote'] = '{$a} (avaktiverat)';
$string['withoutuserdata'] = 'Utan användardata';
$string['withselectedusers'] = 'Med valda användare...';
$string['withselectedusers_help'] = '* Skicka meddelande - för att skicka ett meddelande till en eller flera deltagare
* Lägg till en ny anteckning - För att lägga till en anteckning till en vald deltagare
* Lägg en gemensam anteckning - För att lägga till samma anteckning till mer än en deltagare';
$string['withuserdata'] = 'Med användardata';
$string['wordforstudent'] = 'Ditt ord i singular för lärande/student/<br />studerande/elev/deltagare etc.';
$string['wordforstudenteg'] = 't.ex. lärande, student, studerande,elev, deltagare etc';
$string['wordforstudents'] = 'Ditt ord i plural för lärande, studenter,<br /> studerande, deltagare etc';
$string['wordforstudentseg'] = 't.ex. lärande, studenter, studerande,<br /> deltagare, elever  etc';
$string['wordforteacher'] = 'Ditt ord i singular för distanslärare/<br />handledare/coach etc';
$string['wordforteachereg'] = 't.ex. (distans)lärare, ledare, koordinatör, utbildare, handledare, coach  etc.';
$string['wordforteachers'] = 'Ditt ord i plural för distanslärare/<br />handledare/coacher';
$string['wordforteacherseg'] = 't.ex. (distans)lärare, ledare, koordinatörer, utbildare, handledare, coacher  etc.';
$string['writingblogsinfo'] = 'Skriver blogginfo';
$string['writingcategoriesandquestions'] = 'Skriver kategorier och frågor...';
$string['writingcoursedata'] = 'Skriver kursdata...';
$string['writingeventsinfo'] = 'Skriver info om händelser...';
$string['writinggeneralinfo'] = 'Skriver allmän information';
$string['writinggradebookinfo'] = 'Skriver in info i betygs/omdömeskatalogen...';
$string['writinggroupingsgroupsinfo'] = 'Skriver information om gruppindelningar av grupper';
$string['writinggroupingsinfo'] = 'Skriver information om gruppindelningar';
$string['writinggroupsinfo'] = 'Skriver info om grupper...';
$string['writingheader'] = 'Skriver huvudrubrik...';
$string['writingloginfo'] = 'Skriver info om loggar...';
$string['writingmessagesinfo'] = 'Skriver info om meddelanden...';
$string['writingmoduleinfo'] = 'Skriver info om moduler...';
$string['writingscalesinfo'] = 'Skriver info om skalor...';
$string['writinguserinfo'] = 'Skriver info om användare...';
$string['wrongpassword'] = 'Fel lösenord för detta användarnamn.';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'år';
$string['years'] = 'år';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Du håller på att skapa en .zip-fil som innehåller';
$string['youaregoingtorestorefrom'] = 'Du håller på att starta en process för att återställa';
$string['youneedtoenrol'] = 'För att genomföra den åtgärden måste Du registrera Dig på den här kursen.';
$string['yourlastlogin'] = 'Din senaste inloggning var';
$string['yourself'] = 'Dig själv';
$string['yourteacher'] = 'Din {$a}';
$string['yourwordforx'] = 'Ditt ord för \'{$a}\'';
$string['zippingbackup'] = 'Packar ihop säkerhetskopian...';
