<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sv', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Lägg till kommentarer';
$string['addentry'] = 'Lägg till bidrag';
$string['addingcomment'] = 'Lägg till en kommentar';
$string['alias'] = 'Nyckelord';
$string['aliases'] = 'Synonymer';
$string['aliases_help'] = '<p>Varje bidrag kan ha vara kopplat till en lista med synomymer (eller alias).</p>

<p><b>Skriv in varje synonym (alias) p&aring; en ny rad</b> (inte separerad med komman).</p>

<p>De ord som anv&auml;nds synonymt (alias) kan anv&auml;ndas som alternativa s&auml;tt att referera till
bidraget.
   Till exempel, om Du anv&auml;nder filtret f&ouml;r automatisk l&auml;nkning av bidrag s&aring; kommer synonymerna att anv&auml;ndas (liksom bidragets egentliga ledord) n&auml;r det g&ouml;rs ett val att ord ska l&auml;nka till detta bidrag.</p>';
$string['allcategories'] = 'Alla kategorier';
$string['allentries'] = 'ALLA';
$string['allowcomments'] = 'Tillåt kommentarer till bidrag';
$string['allowcomments_help'] = '<p>Du kan ange om det ska vara till&aring;tet eller inte att kommentera
bidrag till ord- och begreppslistan.</p>
<p>Du kan välja om den egenskapen ska vara aktiverad eller inte.</p>
<p>Distanslärare kan alltid lägga till kommentarer till bidrag till ord- och begreppslistor.</p>';
$string['allowduplicatedentries'] = 'Det är tillåtet med dubblerade bidrag';
$string['allowduplicatedentries_help'] = '<p>Du kan ange om det ska vara till&aring;tet eller inte att
l&auml;gga till dubletter av bidrag till den aktuella
ord- och begreppslistan.</p>';
$string['allowprintview'] = 'Tillåt visning av utskrift';
$string['allowprintview_help'] = '<p>Studenter/elever/deltagare/l&auml;rande kan f&aring; till&aring;telse att
anv&auml;nda f&ouml;rhandsgranskning f&ouml;r utskrift av ord- och begreppslista</p>
<p>Du kan v&auml;lja om Du vill aktivera eller avaktivera detta alternativ</p>
<p>Distansl&auml;rare kan alltid anv&auml;nda f&ouml;rhandsgranskning f&ouml;r utskrift.</p>';
$string['andmorenewentries'] = 'och ytterligare {$a} nya bidrag.';
$string['answer'] = 'Svar';
$string['approve'] = 'Godkänn';
$string['areaattachment'] = 'Bilagor';
$string['areaentry'] = 'Definitioner';
$string['areyousuredelete'] = 'Är Du säker på att Du vill ta bort det här bidraget?';
$string['areyousuredeletecomment'] = 'Är Du säker på att Du vill ta bort den här  kommentaren?';
$string['areyousureexport'] = 'Är Du säker på att Du vill exportera det här bidraget till';
$string['ascending'] = '(stigande)';
$string['attachment'] = 'Bifogad fil';
$string['attachment_help'] = '<p>Som alternativ kan Du bifoga EN fil fr&aring;n Din dator
till varje enskilt bidrag i en ord- och begreppslista.
Denna fil laddas upp till servern och lagras tillsammans
med Ditt bidrag</p>
<p>Detta &auml;r anv&auml;ndbart n&auml;r Du vill visa en bild eller ett Word-dokument t.ex.</p>
<p>Denna fil kan vara i valfritt format men rekommendationen &auml;r &auml;nd&aring;
att filen har ett namn med ett filtill&auml;gg p&aring; 3 tecken enligt standarden
f&ouml;r Internet som t.ex. .doc, .jpg osv.
Detta underl&auml;ttar f&ouml;r dem som vill ladda ner och se Dina bilagor i sina
webbl&auml;sare.</p>
<p>Om Du redigerar om ett bidrag och bifogar en ny fil s&aring; kommer de tidigare
bilagorna till bidraget att ers&auml;ttas med de nya.</p>
<p>Om Du redigerar om ett bidrag med en bilaga och l&auml;mnar detta utrymme
tomt s&aring; kommer den ursprungliga bilagan att bli kvar.</p>';
$string['author'] = 'författare';
$string['authorview'] = 'Sök på författare';
$string['back'] = 'Tillbaka';
$string['cantinsertcat'] = 'Det går inte att lägga in en kategori';
$string['cantinsertrec'] = 'Det går inte att lägga in en post i databasen';
$string['cantinsertrel'] = 'Det går inte att lägga in ett bidrag till kategorin som bygger på relation';
$string['casesensitive'] = 'Det här bidraget gör <br />gör skillnad på stor och liten bokstav';
$string['casesensitive_help'] = '<p>Den h&auml;r inst&auml;llningen anger om ett bidrag ska vara s&ouml;kbart
med exakt samma storlek p&aring; bokst&auml;verna som det har f&ouml;r att
det ska l&auml;nkas automatiskt.</p>
<p>L&auml;gg m&auml;rke till att detta alternativ inte begr&auml;nsar det faktum
att ett begrepp kan vara inb&auml;ddat i ett annat. Anv&auml;nd alternativet
\'Matcha hela ord\' ist&auml;llet.</p>';
$string['cat'] = 'kategori';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categorydeleted'] = 'Borttagen kategori';
$string['categoryview'] = 'Efter kategori';
$string['changeto'] = 'ändra till {$a}';
$string['cnfallowcomments'] = 'Ange huruvida en ord- och begreppslista som standardval ska acceptera kommentarer på bidrag';
$string['cnfallowdupentries'] = 'Ange huruvida en ord- och begreppslista som standardval ska tillåta att man bidrar med dubbletter';
$string['cnfapprovalstatus'] = 'Ange huruvida ett bidrag av studenter/elever/deltagare/lärande som standardval ska accepteras eller ej.';
$string['cnfcasesensitive'] = 'Ange huruvida ett bidrag som standardval ska vara skiftlägeskänsligt när det länkas';
$string['cnfdefaulthook'] = 'Välj visning av standardurvalet när ord- och begreppslistan visas första gången';
$string['cnfdefaultmode'] = 'Välj visning av standardramen när ord- och begreppslistan visas första gången';
$string['cnffullmatch'] = 'Ange huruvida ett bidrag som standardval ska matcha stor/liten bokstav i måltexten när det länkas';
$string['cnflinkentry'] = 'Ange huruvida ett bidrag som standardval ska länkas automatiskt';
$string['cnflinkglossaries'] = 'Ange huruvida en ord- och begreppslista som standardval ska länkas automatiskt';
$string['cnfrelatedview'] = 'Välj visningsformat för automatisk länkning och bidrag';
$string['cnfshowgroup'] = 'Ange om grupp\'brytningen\' ska visas eller inte';
$string['cnfsortkey'] = 'Ange sorteringsnyckeln som standardval';
$string['cnfsortorder'] = 'Ange sorteringsordningen som standardval';
$string['cnfstudentcanpost'] = 'Ange huruvida studenterna/eleverna/deltagarna/de lärande som standardval ska kunna lägga in bidrag';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentaren har tagits bort';
$string['comments'] = 'Kommentarer';
$string['commentson'] = 'Kommentarer aktiverade';
$string['commentupdated'] = 'Kommentaren har uppdaterats';
$string['completionentries'] = 'Studenter/elever/deltagare/lärande måste lämna bidrag:';
$string['completionentriesgroup'] = 'Gör bidrag obligatoriska';
$string['concept'] = 'Begrepp';
$string['concepts'] = 'Begrepp';
$string['configenablerssfeeds'] = 'Den här omkopplaren kommer att aktivera RSS-inmatning för alla ord- och begreppslistor. Du  måste fortfarande aktivera inmatningarna manuellt i inställningarna för varje enskild ord- och begreppslista.';
$string['current'] = 'För närvarande sorterad {$a}';
$string['currentglossary'] = 'Aktuell ord- och begreppslista';
$string['date'] = 'datum';
$string['dateview'] = 'Bläddra enligt datum';
$string['defaultapproval'] = 'Standardval för godkännande';
$string['defaultapproval_help'] = '<p>Du kan ange om bidrag fr&aring;n studenter/elever/deltagare/l&auml;rande
ska vara automatiskt tillg&auml;ngliga f&ouml;r alla eller om bidragen f&ouml;rst ska
godk&auml;nnas av (distans)l&auml;raren.</p>';
$string['defaulthook'] = 'Förvald \'krok\'';
$string['defaultmode'] = 'Förvalt läge';
$string['defaultsortkey'] = 'Förvald nyckel för sortering';
$string['defaultsortorder'] = 'Förvald ordning för sortering';
$string['definition'] = 'Definition';
$string['definitions'] = 'Definitioner';
$string['deleteentry'] = 'Ta bort bidrag';
$string['deletenotenrolled'] = 'Ta bort bidrag gjorda av användare som inte är registrerade';
$string['deletingcomment'] = 'Tar bort kommentar';
$string['deletingnoneemptycategory'] = 'Om Du tar bort den här kaegorin så bidragen i den inte att tas bort - istället kommer de att markeras som inte-kategoriserade.';
$string['descending'] = '(fallande)';
$string['destination'] = 'Mål för importerade bidrag';
$string['destination_help'] = '<p>Du kan ange vart Du vill importera ett bidrag:</p>
<ul>
<li><strong>Den aktuella ord- och begreppslistan:</strong> Detta kommer att l&auml;gga till de importerade bidragen till
den f&ouml;r tillf&auml;llet &ouml;ppna ord- och begreppslistan.</li>
<li><strong>Ny ord- och begreppslista:</strong> Detta kommer att skapa en ord- och begreppslista
som baseras p&aring; den information som som finns i den markerade importfilen och de nya bidragen kommer att infogas i den.</li>
</ul>';
$string['displayformat'] = 'Format för visning';
$string['displayformatcontinuous'] = 'Fortlöpande men utan författare';
$string['displayformatdictionary'] = 'Enkel ordboksstil';
$string['displayformatencyclopedia'] = 'Encyklopedi';
$string['displayformatentrylist'] = 'Lista över bidrag';
$string['displayformatfaq'] = 'FAQ';
$string['displayformatfullwithauthor'] = 'Komplett med författare';
$string['displayformatfullwithoutauthor'] = 'Komplett utan författare';
$string['displayformat_help'] = '<p>Systemet har tre inbyggda format f&ouml;r att visa bidrag.
Du kan skapa Ditt eget format om Du vill.</p>
<p>Standardinst&auml;llningen inneb&auml;r en ganska enkel
form av presentation. Det ser ut som en vanlig ordlista (ordboksartikel).</p>
<p>Det andra visningsformatet visar bidraget i ett forumliknande format,
utan data om f&ouml;rfattaren.</p>
<p>Och det tredje visar ocks&aring; bidraget i i ett forumliknande format,
men med data om f&ouml;rfattaren.</p>
<hr />
<p>Om Du vill skapa Ditt eget format s&aring; ska Du skapa en .php-fil
och ge den ett nummer som namn. Titta efter i mod/glossary/format f&ouml;r att
f&aring; veta vilket det n&auml;sta numret b&ouml;r vara.</p>
<p>Skapa sedan en funktion som Du kallar
<b>glossary_print_entry_by_format($course, $cm, $glossary,
 $entry)</b> och fyll p&aring; med all Din kreativitet.</p>
<p>Det sista steget &auml;r att l&auml;gga in ett bidrag till varje spr&aring;kpaket
som Du anv&auml;nder. Det kallar Du <b>displayformat[number]</b>,
och ger det en meningsfull beskrivning.</p>';
$string['displayformats'] = 'Format för visning';
$string['displayformatssetup'] = 'Visa hur formaten har skapats';
$string['duplicateentry'] = 'Dubblerat bidrag';
$string['editalways'] = 'Redigera alltid';
$string['editalways_help'] = '<p>Det h&auml;r alternativet l&aring;ter Dig avg&ouml;ra om studenterna/eleverna/deltagarna/de l&auml;rande
ska kunna redigera sina bidrag n&auml;r som helst.</p>
<br />Du kan v&auml;lja:
<ul>
<li><b>Ja:</b> Bidrag g&aring;r alltid att redigera.</li>
<li><b>Nej:</b> Bidrag g&aring;r bara att redigera inom den angivna tiden.</li>
</ul>';
$string['editcategories'] = 'Redigera kategorier';
$string['editentry'] = 'Redigera bidrag';
$string['editingcomment'] = 'Redigerar kommentar';
$string['entbypage'] = 'Bidrag visade per sida';
$string['entries'] = 'bidrag';
$string['entrieswithoutcategory'] = 'Bidrag utan kategori';
$string['entry'] = 'bidrag';
$string['entryalreadyexist'] = 'Bidraget finns redan';
$string['entryapproved'] = 'Det här bidraget har godkänts';
$string['entrydeleted'] = 'Bidraget är borttaget';
$string['entryexported'] = 'Bidraget har framgångsrikt exporterats';
$string['entryishidden'] = '(det här bidraget är f n dolt)';
$string['entryleveldefaultsettings'] = 'Standardval för inställningar på ingångsnivån ';
$string['entrysaved'] = 'Det här bidraget har sparats';
$string['entryupdated'] = 'Det här bidraget har uppdaterats';
$string['entryusedynalink'] = 'Det här bidraget bör<br /> vara automatiskt länkat';
$string['entryusedynalink_help'] = '<p>Genom att aktivera det h&auml;r alternativet s&aring; kommer bidraget automatiskt
att l&auml;nkas n&auml;rhelst begrepp, ord och fraser dyker n&aring;gon annanstans i samma kurs.
Detta g&auml;ller f&ouml;r inl&auml;gg i forum, interna resurser, veckovisa sammanfattningar osv. </p>
<p>Om Du inte vill att en viss text ska l&auml;nkas (i ett inl&auml;gg i ett forum t ex)
d&aring; b&ouml;r Du l&auml;gga till  &lt;nolink&gt; och &lt;/nolink&gt; taggar runt texten.</p>
<p>F&ouml;r att Du ska kunna aktivera detta alternativ s&aring; m&aring;ste automatisk l&auml;nkning vara aktiverad p&aring; niv&aring;n ord- och begreppslista.</p>';
$string['errcannoteditothers'] = 'Du kan inte redigera andra personers bidrag.';
$string['errconceptalreadyexists'] = 'Det här begreppet finns redan med. Det är inte tillåtet med dubbleringar i den här ord- och begreppslistan.';
$string['errdeltimeexpired'] = 'Du kan inte ta bort det här. Tiden har gått ut!';
$string['erredittimeexpired'] = 'Tiden för att redigera det här bidraget har gått ut.';
$string['errorparsingxml'] = 'Det uppstod fel när filen skulle parsas. Säkerställ att det är en giltig syntax för XML.';
$string['explainaddentry'] = 'Lägg till ett nytt bidrag till den aktuella ord- och begreppslistan.<br />\'Begrepp\' och \'definition\' är obligatoriska fält.';
$string['explainall'] = '<b>ALLA</b> kommer att visa alla bidrag på en sida';
$string['explainalphabet'] = 'Välj den sida Du vill söka efter<p>';
$string['explainexport'] = 'En fil har skapats.<br />Ladda ned den och spara den på ett säkert ställe. Du kan importera den när helst Du vill, i den här kursen eller i någon annan.';
$string['explainimport'] = 'Du måste ange vilken fil som ska importeras och villkoren för processen.<p>Skicka in Din förfrågan och titta på resultaten igen.</p>';
$string['explainspecial'] = 'Visa alla begrepp som inte börjar med en bokstav';
$string['exportedentry'] = 'Exporterat bidrag';
$string['exportentries'] = 'Exportera bidrag';
$string['exportentriestoxml'] = 'Exportera bidragen till en XML-fil';
$string['exportfile'] = 'Exportera bidrag till fil';
$string['exportglossary'] = 'Exportera ord- och begreppslista';
$string['exporttomainglossary'] = 'Exportera till den övergripande (förklarande) ord- och begreppslistan';
$string['filetoimport'] = 'Fil att importera';
$string['filetoimport_help'] = '<p>Markera den XML-fil p&aring; Din dator som inneh&aring;ller de bidrag som Du vill importera.</p>';
$string['fillfields'] = '\'Begrepp\' och definition\' är obligatoriska fält';
$string['filtername'] = 'Länka ord- och begreppslista automatiskt';
$string['fullmatch'] = 'Matcha hela ord bara<br /><small>när de är automatiskt länkade</small>';
$string['fullmatch_help'] = '<p>Om Du anger att ett bidrag kan l&auml;nkas automatiskt
fr&aring;n andra resurser, s&aring; kommer bara de ord som
matchar detta bidrag fullst&auml;ndigt att l&auml;nkas.
Om Du st&auml;ller in det h&auml;r alternativet allts&aring;.</p>
<p>L&auml;gg  m&auml;rke till att det h&auml;r alternativet inte
kr&auml;ver att bokst&auml;verna har samma storlek. Anv&auml;nd
ist&auml;llet alternativet \'Skiftl&auml;gesk&auml;nslig\' f&ouml;r det.</p>';
$string['glossary:approve'] = 'Godkänn icke-godkända bidrag';
$string['glossary:comment'] = 'Skapa kommentarer';
$string['glossary:export'] = 'Exportera bidrag';
$string['glossary:exportentry'] = 'Exportera ett enskilt bidrag';
$string['glossary:exportownentry'] = 'Exportera ett enskilt eget bidrag';
$string['glossary:import'] = 'Importera bidrag';
$string['glossaryleveldefaultsettings'] = 'Standardval för inställningar på den globala nivån';
$string['glossary:managecategories'] = 'Administrera kategorier';
$string['glossary:managecomments'] = 'Administrera kommentarer';
$string['glossary:manageentries'] = 'Administrera bidrag';
$string['glossary:rate'] = 'Bedöm/värdera inlägg';
$string['glossarytype'] = 'Typ av ord- och begreppslista';
$string['glossarytype_help'] = '<p>Systemet till&aring;ter att bidrag exporteras till den &ouml;vergripande
ord- och begreppslistan f&ouml;r kursen
fr&aring;n vilken sekund&auml;r ord- och begreppslista som helst.</p>
<p>F&ouml;r att g&ouml;ra detta b&ouml;r Du ange vilken ord- och begreppslista det &auml;r
som &auml;r den &ouml;vergripande.</p>
<p>OBS! Du kan bara ha en &ouml;vergripande ord- och begreppslista per kurs.</p>

<p>Före Moodle 1.7, kunde bara (distans)lärare redigera den &ouml;vergripande ord- och begreppslistan f&ouml;r kursen. I Moodle
1.7 och senare, kan du påverka detta med hjälp av att tilldela användare roller med utökade
rättigheter.</p>';
$string['glossary:view'] = 'Visa ord-och begreppslista';
$string['glossary:viewallratings'] = 'Visa alla betyg/omdömen som har avgivits av individer';
$string['glossary:viewanyrating'] = 'Visa alla betyg/omdömen som någon har fått.';
$string['glossary:viewrating'] = 'Visa de sammanlagda bedömningar/värderingar som Du har fått';
$string['glossary:write'] = 'Skapa nya bidrag';
$string['guestnoedit'] = 'Gäster har inte tillstånd att redigera ord- coh begreppslistor';
$string['importcategories'] = 'Importera kategorier';
$string['importedcategories'] = 'Importerade kategorier';
$string['importedentries'] = 'Importerade bidrag';
$string['importentries'] = 'Importera bidrag';
$string['importentriesfromxml'] = 'Importera bidrag från XML-fil';
$string['includegroupbreaks'] = 'Ta med gruppbrytningar';
$string['isglobal'] = 'Är det här en global ord- och begreppslista?';
$string['isglobal_help'] = '<p>Systemet med ord- och begreppslistor l&aring;ter Dig definiera
begrepp som skulle kunna vara tillg&auml;ngliga p&aring; hela
webbsajten. De beskrivs som globala.</p>
<p>Du beh&ouml;ver allts&aring; ange vilken ord- och begreppslista som ska
vara global.</p>
<p>Du kan ha s&aring; m&aring;nga globala ord- och begreppslistor Du vill, och
de kan h&ouml;ra till vilken kurs som helst. Alla &ouml;vriga regler &auml;r
giltiga &auml;ven f&ouml;r den h&auml;r typen.</p>
<p>L&auml;gg m&auml;rke till att endast administrat&ouml;rer kan
skapa globala ord- och begreppslistor.</p>';
$string['letter'] = 'bokstav';
$string['linkcategory'] = 'Länka den här kategorin automatiskt';
$string['linkcategory_help'] = '<p>Du kan ange ifall Du vill att kategorierna ska vara
automatiskt l&auml;nkade eller inte.</p>
<p>OBS! L&auml;nkning av kategorier baseras p&aring; skiftl&auml;gesk&auml;nslig, komplett matchning.</p>';
$string['linking'] = 'Automatisk länkning';
$string['mainglossary'] = 'Den övergripande (förklarande) ord- och begreppslistan';
$string['maxtimehaspassed'] = 'Maxtiden för att redigera den här kommentaren har tyvärr gått ut ({$a})';
$string['modulename'] = 'Ord- och begreppslista';
$string['modulename_help'] = 'Modulen ord- och begreppslista gör det möjligt för deltagare att skapa och underhålla en lista över definitioner. Bidragen går att länka automatiskt varhelst de listade orden och fraserna uppträder i kursen.  ';
$string['modulenameplural'] = 'Ord- och begreppslistor';
$string['newentries'] = 'Nya bidrag till ord- och begreppslista';
$string['newglossary'] = 'Ny ord- och begreppslista';
$string['newglossarycreated'] = 'En ny ord- och begreppslista har skapats';
$string['newglossaryentries'] = 'Nya bidrag till ord- och begreppslistan';
$string['nocomment'] = 'Kunde inte hitta någon kommentar';
$string['nocomments'] = '(Det gick inte att hitta någon kommentar till det här bidraget)';
$string['noconceptfound'] = 'Det gick inte att hitta något begrepp eller definition';
$string['noentries'] = 'Hittade inga bidrag i den här sektionen';
$string['noentry'] = 'Hittade inget bidrag';
$string['nopermissiontodelcomment'] = 'Du kan inte ta bort andra användares kommentarer!';
$string['nopermissiontodelinglossary'] = 'Du kan inte lämna kommentarer i den här ord- och bergreppslistan!';
$string['nopermissiontoviewresult'] = 'Du kan bara söka resultat i Dina egna bidrag';
$string['notapproved'] = 'Det här bidraget till ord/begreppslistan har ännu inte godkänts.';
$string['notcategorised'] = 'Inte indelad i kategori';
$string['numberofentries'] = 'Antal bidrag';
$string['onebyline'] = '(en per rad)';
$string['pluginadministration'] = 'Administration av ord- och begreppslista';
$string['pluginname'] = 'Ord- och begreppslista';
$string['popupformat'] = 'Popup-format';
$string['printerfriendly'] = 'Utskriftsvänlig version';
$string['printviewnotallowed'] = 'Visning av utskrift är inte tillåten.';
$string['question'] = 'Fråga';
$string['rejectedentries'] = 'Bidrag som inte antagits';
$string['rejectionrpt'] = 'Rapport över icke antagna bidrag';
$string['resetglossaries'] = 'Ta bort bidrag från';
$string['resetglossariesall'] = 'Ta bort bidrag från alla ord- och begreppslistor';
$string['rssarticles'] = 'Antal aktuella RSS-artiklar';
$string['rssarticles_help'] = '<p>Det h&auml;r alternativet g&ouml;r det m&ouml;jligt f&ouml;r Dig att markera det antal
artiklar som Du vill ta med i RSS-matningen.</p>
<p>Ett antal mellan 5 och 20 b&ouml;r vara lagom f&ouml;r de flesta ord- och begreppslistor.
 &Ouml;ka detta antal om ord- och begreppslistan anv&auml;nds mycket flitigt.</p>';
$string['rsssubscriberss'] = 'Visa RSS-inmatningen för  \'{$a}\' koncept';
$string['rsstype'] = 'RSS-flöde för den här aktiviteten';
$string['rsstype_help'] = '<p>Det h&auml;r alternativet l&aring;ter Dig aktivera RSS-matningar till denna ord- och begreppslista.</p>
<p>Du kan v&auml;lja mellan tv&aring; sorters matningar:</p>
<ul>
<li><b>Med f&ouml;rfattare:</b>Om Du anv&auml;nder detta, s&aring; kommer de genererade matningarna att ta med
namnet p&aring; f&ouml;rfattaren i varje artikel.</li>
<li><b>Utan f&ouml;rfattare:</b>Om Du anv&auml;nder detta, s&aring; kommer de genererade matningarna INTE att ta med
namnet p&aring; f&ouml;rfattaren i varje artikel.</li>
</ul>';
$string['searchindefinition'] = 'Sök i begrepp OCH definitioner?';
$string['secondaryglossary'] = 'sekundär ord- och begreppslista';
$string['showall'] = 'Visa länken \'ALLA\'';
$string['showall_help'] = '<p>Du kan standardisera de s&auml;tt man kan anv&auml;nda
f&ouml;r att s&ouml;ka sig igenom en ord- och begreppslista.
Att s&ouml;ka p&aring; kategorier och datum g&aring;r alltid.
Du kan dock ange ytterligare tre alternativ:</p>
<p><b>VISA SPECIAL</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av
specialtecken som @, #, etc.</p>
<p><b>VISA ALFABETET</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av bokst&auml;ver.</p>
<p><b>VISA ALLA</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av att
visa alla bidrag p&aring; en g&aring;ng.</p>';
$string['showalphabet'] = 'Visa alfabetet';
$string['showalphabet_help'] = '<p>Du kan standardisera de s&auml;tt man kan anv&auml;nda
f&ouml;r att s&ouml;ka sig igenom en ord- och begreppslista.
Att s&ouml;ka p&aring; kategorier och datum g&aring;r alltid.
Du kan dock ange ytterligare tre alternativ:</p>
<p><b>VISA SPECIAL</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av
specialtecken som @, #, etc.</p>
<p><b>VISA ALFABETET</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av bokst&auml;ver.</p>
<p><b>VISA ALLA</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av att
visa alla bidrag p&aring; en g&aring;ng.</p>';
$string['showspecial'] = 'Visa länken \'Special\'';
$string['showspecial_help'] = '<p>Du kan standardisera de s&auml;tt man kan anv&auml;nda
f&ouml;r att s&ouml;ka sig igenom en ord- och begreppslista.
Att s&ouml;ka p&aring; kategorier och datum g&aring;r alltid.
Du kan dock ange ytterligare tre alternativ:</p>
<p><b>VISA SPECIAL</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av
specialtecken som @, #, etc.</p>
<p><b>VISA ALFABETET</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av bokst&auml;ver.</p>
<p><b>VISA ALLA</b>
<br />
Aktivera eller avaktivera s&ouml;kning med hj&auml;lp av att
visa alla bidrag p&aring; en g&aring;ng.</p>';
$string['sortby'] = 'Sortera efter';
$string['sortbycreation'] = 'Enligt datum för tillkomst';
$string['sortbylastupdate'] = 'Enligt senaste uppdateringen';
$string['sortchronogically'] = 'Sortera kronologiskt';
$string['special'] = 'Special';
$string['standardview'] = 'Standardvy';
$string['studentcanpost'] = 'Studenter/elever/deltagare/lärande kan lägga till bidrag';
$string['totalentries'] = 'Totalt antal bidrag';
$string['usedynalink'] = 'Länka bidrag automatiskt';
$string['usedynalink_help'] = '<p align="center"><b>
Att automatiskt l&auml;nka ord- och begreppslistor till andra moduler </b></p>
<p>Om Du anger att en ord- och begreppslista ska l&auml;nkas automatiskt s&aring;
kommer de ber&ouml;rda bidragen automatiskt att l&auml;nkas n&auml;rhelst de
dyker upp i andra resurser (forum, kommentarer osv)</p>
<p>Om Du inte vill att ett visst bidrag ska l&auml;nkas
s&aring; b&ouml;r Du b&auml;dda in det mellan taggarna
&lt;nolink> och &lt;/nolink> i HTML-(k&auml;ll)koden.</p>
<p>Om det &auml;r en kategori som har hittats s&aring; kommer den ocks&aring;
att l&auml;nkas. L&auml;gg m&auml;rke till att l&auml;nkning av kategorier
&auml;r skiftl&auml;gesk&auml;nsligt.</p>';
$string['waitingapproval'] = 'Väntar på att bli accepterad';
$string['warningstudentcapost'] = '(Gäller bara om det inte handlar om den övergripande ord- och  begreppslistan';
$string['withauthor'] = 'Begrepp med författare';
$string['withoutauthor'] = 'Begrepp utan författare';
$string['writtenby'] = 'Av';
$string['youarenottheauthor'] = 'Det är inte Du som har författat den här kommentaren och därför får Du inte redigera den.';
