<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'sv', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adress';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Infoga/redigera bokmärke';
$string['advanced:backcolor_desc'] = 'Välj bakgrundsfärg';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Blockcitat';
$string['advanced:blockquote_desc'] = 'Blockcitat';
$string['advanced:bold_desc'] = 'Fet (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Punktlista';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Infoga specialtecken';
$string['advanced:cleanup_desc'] = 'Städa upp i källkoden';
$string['advanced:clipboard_msg'] = 'Kopiera/klipp ut/klistra in är inte tillgängligt i din webbläsare.nVill du veta mer om detta?';
$string['advanced:code'] = 'Kodblock';
$string['advanced:code_desc'] = 'Redigera HTML källkoden';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiera';
$string['advanced:custom1_desc'] = 'Skriv in Din standardbeskrivning här';
$string['advanced:cut_desc'] = 'Klipp ut';
$string['advanced:dd'] = 'Definitionsbeskrivning';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = 'Utvecklare';
$string['advanced_dlg:about_general'] = 'Om';
$string['advanced_dlg:about_help'] = 'Hjälp';
$string['advanced_dlg:about_license'] = 'Licens';
$string['advanced_dlg:about_loaded'] = 'Laddade plug-ins';
$string['advanced_dlg:about_plugin'] = 'Om plug-in';
$string['advanced_dlg:about_plugins'] = 'Om plug-in';
$string['advanced_dlg:about_title'] = 'Om TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:anchor_name'] = 'Namn';
$string['advanced_dlg:anchor_title'] = 'Infoga/redigera bokmärke';
$string['advanced_dlg:charmap_title'] = 'Välj ett specialtecken';
$string['advanced_dlg:code_title'] = 'HTML källkodsläge';
$string['advanced_dlg:code_wordwrap'] = 'Bryt ord';
$string['advanced_dlg:colorpicker_color'] = 'Färg:';
$string['advanced_dlg:colorpicker_name'] = 'Namn:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Namngivna';
$string['advanced_dlg:colorpicker_named_title'] = 'Namngivna färger';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palett';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palettfärger';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Väljare';
$string['advanced_dlg:colorpicker_picker_title'] = 'Färgväljare';
$string['advanced_dlg:colorpicker_title'] = 'Välj en färg';
$string['advanced_dlg:image_align'] = 'Justering';
$string['advanced_dlg:image_align_baseline'] = 'Baslinje';
$string['advanced_dlg:image_align_bottom'] = 'Botten';
$string['advanced_dlg:image_align_left'] = 'Vänster';
$string['advanced_dlg:image_align_middle'] = 'Mitten';
$string['advanced_dlg:image_align_right'] = 'Höger';
$string['advanced_dlg:image_align_textbottom'] = 'Botten av texten';
$string['advanced_dlg:image_align_texttop'] = 'Toppen av texten';
$string['advanced_dlg:image_align_top'] = 'Toppen';
$string['advanced_dlg:image_alt'] = 'Bildens beskrivning';
$string['advanced_dlg:image_border'] = 'Ram';
$string['advanced_dlg:image_dimensions'] = 'Dimensioner';
$string['advanced_dlg:image_hspace'] = 'Horisontalrymd';
$string['advanced_dlg:image_list'] = 'Bildlista';
$string['advanced_dlg:image_src'] = 'Bildens URL';
$string['advanced_dlg:image_title'] = 'Infoga/redigera bild';
$string['advanced_dlg:image_vspace'] = 'Vertikalrymd';
$string['advanced_dlg:link_is_email'] = 'Länken du angav verkar vara en e-post adress. Vill du infoga mailto: prefixet på länken?';
$string['advanced_dlg:link_is_external'] = 'Länken du angav verkar vara en extern adress. Vill du infoga http:// prefixet på länken?';
$string['advanced_dlg:link_list'] = 'Länklista';
$string['advanced_dlg:link_target'] = 'Mål';
$string['advanced_dlg:link_target_blank'] = 'Öppna länken i ett nytt fönster';
$string['advanced_dlg:link_target_same'] = 'Öppna länken i samma fönster';
$string['advanced_dlg:link_title'] = 'Infoga/redigera länk';
$string['advanced_dlg:link_titlefield'] = 'Titel';
$string['advanced_dlg:link_url'] = 'Länkens URL';
$string['advanced:dt'] = 'Definitionsterm';
$string['advanced:fontdefault'] = 'Fontfamilj';
$string['advanced:font_size'] = 'Fontstorlek';
$string['advanced:forecolor_desc'] = 'Välj textfärg';
$string['advanced:h1'] = 'Rubrik 1';
$string['advanced:h2'] = 'Rubrik 2';
$string['advanced:h3'] = 'Rubrik 3';
$string['advanced:h4'] = 'Rubrik 4';
$string['advanced:h5'] = 'Rubrik 5';
$string['advanced:h6'] = 'Rubrik 6';
$string['advanced:help_desc'] = 'Hjälp';
$string['advanced:hr_desc'] = 'Infoga horisontell skiljelinje';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Infoga/redigera bild';
$string['advanced:image_props_desc'] = 'Bildinställningar';
$string['advanced:indent_desc'] = 'Indrag';
$string['advanced:italic_desc'] = 'Kursiv (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centrera';
$string['advanced:justifyfull_desc'] = 'Justera';
$string['advanced:justifyleft_desc'] = 'Vänsterställd';
$string['advanced:justifyright_desc'] = 'Högerställd';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Infoga/redigera länk';
$string['advanced:more_colors'] = 'Fler färger';
$string['advanced:newdocument'] = 'Är du säker på att du vill radera allt innehåll?';
$string['advanced:newdocument_desc'] = 'Nytt dokument';
$string['advanced:numlist_desc'] = 'Nummerlista';
$string['advanced:outdent_desc'] = 'Drag tillbaka';
$string['advanced:paragraph'] = 'Stycke';
$string['advanced:paste_desc'] = 'Klistra in';
$string['advanced:path'] = 'Element';
$string['advanced:pre'] = 'Förformaterad';
$string['advanced:redo_desc'] = 'Gör om (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Ta bort formatering';
$string['advanced:samp'] = 'Kodexempel';
$string['advanced:striketrough_desc'] = 'Genomstruken';
$string['advanced:style_select'] = 'Stilar';
$string['advanced:sub_desc'] = 'Subscript';
$string['advanced:sup_desc'] = 'Superscript';
$string['advanced:toolbar_focus'] = 'Hoppa till verktygsfältet - Alt+Q, Hoppa till redigeraren - Alt-Z, Hoppa till elementlistan - Alt-X';
$string['advanced:underline_desc'] = 'Understruken (Ctrl+U)';
$string['advanced:undo_desc'] = 'Ångra (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Ta bort länk';
$string['advanced:visualaid_desc'] = 'Visa/dölj visuella hjälpmedel';
$string['advhr:advhr_desc'] = 'Horisontell skiljelinje';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:noshade'] = 'Ingen skugga';
$string['advhr_dlg:size'] = 'Höjd';
$string['advhr_dlg:width'] = 'Bredd';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Justering';
$string['advimage_dlg:align_baseline'] = 'Baslinje';
$string['advimage_dlg:align_bottom'] = 'Botten';
$string['advimage_dlg:align_left'] = 'Vänster';
$string['advimage_dlg:align_middle'] = 'Mitten';
$string['advimage_dlg:align_right'] = 'Höger';
$string['advimage_dlg:align_textbottom'] = 'Botten av texten';
$string['advimage_dlg:align_texttop'] = 'Toppen av texten';
$string['advimage_dlg:align_top'] = 'Toppen';
$string['advimage_dlg:alt'] = 'Bildens beskrivning';
$string['advimage_dlg:alt_image'] = 'Alternativbild';
$string['advimage_dlg:border'] = 'Ram';
$string['advimage_dlg:classes'] = 'Klasser';
$string['advimage_dlg:constrain_proportions'] = 'Bibehåll proportionerna';
$string['advimage_dlg:dialog_title'] = 'Infoga/redigera bild';
$string['advimage_dlg:dimensions'] = 'Dimensioner';
$string['advimage_dlg:example_img'] = 'Exempelbild';
$string['advimage_dlg:general'] = 'Generellt';
$string['advimage_dlg:hspace'] = 'Horisontalrymd';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = 'Bildlista';
$string['advimage_dlg:langcode'] = 'Språkkod';
$string['advimage_dlg:langdir'] = 'Skriftriktning';
$string['advimage_dlg:list'] = 'Bildlista';
$string['advimage_dlg:long_desc'] = 'Lång beskrivning';
$string['advimage_dlg:ltr'] = 'Vänster till höger';
$string['advimage_dlg:map'] = 'Länkkarta';
$string['advimage_dlg:misc'] = 'Övrigt';
$string['advimage_dlg:missing_alt'] = 'Vill du fortsätta utan bildbeskrivning. Icke grafiska webbläsare kommer inte kunna tolka bilden för användaren.';
$string['advimage_dlg:mouseout'] = 'vid musen utanför';
$string['advimage_dlg:mouseover'] = 'vid musen ovanför';
$string['advimage_dlg:preview'] = 'Förhandsvisning';
$string['advimage_dlg:rtl'] = 'Höger till vänster';
$string['advimage_dlg:src'] = 'Bildens URL';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Utbytningsbild';
$string['advimage_dlg:tab_advanced'] = 'Avancerat';
$string['advimage_dlg:tab_appearance'] = 'Utseende';
$string['advimage_dlg:tab_general'] = 'Generellt';
$string['advimage_dlg:title'] = 'Titel';
$string['advimage_dlg:vspace'] = 'Vertikalrymd';
$string['advimage:image_desc'] = 'Infoga/redigera bild';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Snabbtangent';
$string['advlink_dlg:advanced_props'] = 'Avancerade inställningar';
$string['advlink_dlg:advanced_tab'] = 'Avancerat';
$string['advlink_dlg:anchor_names'] = 'Bokmärken';
$string['advlink_dlg:classes'] = 'Klasser';
$string['advlink_dlg:encoding'] = 'Teckenformattering';
$string['advlink_dlg:event_props'] = 'Händelser';
$string['advlink_dlg:events_tab'] = 'Händelser';
$string['advlink_dlg:general_props'] = 'Generella inställningar';
$string['advlink_dlg:general_tab'] = 'Generellt';
$string['advlink_dlg:id'] = 'Id';
$string['advlink_dlg:is_email'] = 'Länken du angav verkar vara en e-post adress. Vill du infoga mailto: prefixet på länken?';
$string['advlink_dlg:is_external'] = 'Länken du angav verkar vara en extern adress. Vill du infoga http:// prefixet på länken?';
$string['advlink_dlg:langcode'] = 'Språkkod';
$string['advlink_dlg:langdir'] = 'Skriftriktning';
$string['advlink_dlg:link_list'] = 'Länklista';
$string['advlink_dlg:list'] = 'Länklista';
$string['advlink_dlg:ltr'] = 'Vänster till höger';
$string['advlink_dlg:mime'] = 'MIME type';
$string['advlink_dlg:popup'] = 'Javascript popup';
$string['advlink_dlg:popup_dependent'] = 'Beroende av (Mozilla/Firefox enbart)';
$string['advlink_dlg:popup_location'] = 'Adressraden';
$string['advlink_dlg:popup_menubar'] = 'Menyrad';
$string['advlink_dlg:popup_name'] = 'Fönsternamn';
$string['advlink_dlg:popup_opts'] = 'Inställningar';
$string['advlink_dlg:popup_position'] = 'Position (x/y)';
$string['advlink_dlg:popup_props'] = 'Popup-inställningar';
$string['advlink_dlg:popup_resizable'] = 'Skalbart fönster';
$string['advlink_dlg:popup_return'] = 'Infoga \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Rullningslister';
$string['advlink_dlg:popup_size'] = 'Storlek';
$string['advlink_dlg:popup_statusbar'] = 'Statusfält';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Verktygsfält';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Relation (rel attribut)';
$string['advlink_dlg:rev'] = 'Omvänd relation (rev)';
$string['advlink_dlg:rtl'] = 'Höger till vänster';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Tabbindex';
$string['advlink_dlg:target'] = 'Mål';
$string['advlink_dlg:target_blank'] = 'Öppna i nytt fönster';
$string['advlink_dlg:target_langcode'] = 'Målspråk';
$string['advlink_dlg:target_name'] = 'Målnamn';
$string['advlink_dlg:target_parent'] = 'Öppna i överliggande fönster/ram';
$string['advlink_dlg:target_same'] = 'Öppna i detta fönster/ram';
$string['advlink_dlg:target_top'] = 'Öppna i toppramen (ersätter alla ramar)';
$string['advlink_dlg:title'] = 'Infoga/redigera länk';
$string['advlink_dlg:titlefield'] = 'Titel';
$string['advlink_dlg:url'] = 'Länkens URL';
$string['advlink:link_desc'] = 'Infoga/redigera länk';
$string['advlist:circle'] = 'Cirkel';
$string['advlist:def'] = 'Standardmässigt förval';
$string['advlist:disc'] = 'Disk';
$string['advlist:lower_alpha'] = 'Lägre alfa';
$string['advlist:lower_greek'] = 'Lägre grekiskt';
$string['advlist:lower_roman'] = 'Lägre roman';
$string['advlist:square'] = 'Fyrkant';
$string['advlist:types'] = 'Typer';
$string['advlist:upper_alpha'] = 'Övre alfa';
$string['advlist:upper_roman'] = 'Övre roman';
$string['autosave:restore_content'] = 'Återställ innehåll som har sparats automatiskt';
$string['autosave:unload_msg'] = 'De förändringar som du gjort kommer att gå förlorade om du lämnar sidan.';
$string['autosave:warning_message'] = 'Om Du återställer det sparade innehållet så kommer Du att förlora allt det innehåll som f n finns i redigeraren.

Är Du säker på att Du vill återställa det sparade innehållet?';
$string['common:apply'] = 'Applicera';
$string['common:browse'] = 'Bläddra';
$string['common:cancel'] = 'Avbryt';
$string['common:class_name'] = 'Klass';
$string['common:clipboard_msg'] = 'Kopiera/klipp ut/klistra in är inte tillgängligt i Mozilla och Firefox. Vill du veta mer?';
$string['common:clipboard_no_support'] = 'Funktionen är inte tillgänglig i din webbläsare, använd tangentbordsgenvägarna i stället.';
$string['common:close'] = 'Stäng';
$string['common:edit_confirm'] = 'Vill du använda WYSIWYG för denna textarea?';
$string['common:insert'] = 'Infoga';
$string['common:invalid_data'] = 'Fel: Inkorrekta värden har matats in, dessa är markerade i rött.';
$string['common:more_colors'] = 'Fler färger';
$string['common:not_set'] = '-- Inte satt --';
$string['common:popup_blocked'] = 'Popup blockerare detekterad. Stäng av den så att dialogerna kan öppnas.';
$string['common:update'] = 'Uppdatera';
$string['contextmenu:align'] = 'Justering';
$string['contextmenu:center'] = 'Centrerad';
$string['contextmenu:full'] = 'Utfyllnad';
$string['contextmenu:left'] = 'Vänster';
$string['contextmenu:right'] = 'Höger';
$string['directionality:ltr_desc'] = 'Skriftläge - vänster till höger';
$string['directionality:rtl_desc'] = 'Skriftläge - höger till vänster';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Gråter';
$string['emotions_dlg:desc'] = 'Smileys';
$string['emotions_dlg:embarassed'] = 'Skäms';
$string['emotions_dlg:foot_in_mouth'] = 'Foten i munnen';
$string['emotions_dlg:frown'] = 'Rynkar på näsan';
$string['emotions_dlg:innocent'] = 'Oskyldig';
$string['emotions_dlg:kiss'] = 'Kyss';
$string['emotions_dlg:laughing'] = 'Skrattande';
$string['emotions_dlg:money_mouth'] = 'Guld i mun';
$string['emotions_dlg:sealed'] = 'Tyst';
$string['emotions_dlg:smile'] = 'Glad';
$string['emotions_dlg:surprised'] = 'Förvånad';
$string['emotions_dlg:title'] = 'Infoga smiley';
$string['emotions_dlg:tongue_out'] = 'Tungan ute';
$string['emotions_dlg:undecided'] = 'Obestämd';
$string['emotions_dlg:wink'] = 'Flört';
$string['emotions_dlg:yell'] = 'Skrikandes';
$string['emotions:emotions_desc'] = 'Smileys';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumentinställningar';
$string['fullpage_dlg:active_color'] = 'Active färg';
$string['fullpage_dlg:add'] = 'Lägg till element';
$string['fullpage_dlg:add_base'] = 'Base-element';
$string['fullpage_dlg:add_comment'] = 'Kommentarsnod';
$string['fullpage_dlg:add_link'] = 'Länk-element';
$string['fullpage_dlg:add_meta'] = 'Meta-element';
$string['fullpage_dlg:add_script'] = 'Script-element';
$string['fullpage_dlg:add_style'] = 'Stil-element';
$string['fullpage_dlg:add_title'] = 'Titel-element';
$string['fullpage_dlg:advanced_props'] = 'Avancerat';
$string['fullpage_dlg:advanced_tab'] = 'Avancerat';
$string['fullpage_dlg:appearance_bgprops'] = 'Bakgrundsinställningar';
$string['fullpage_dlg:appearance_linkprops'] = 'Länkfärger';
$string['fullpage_dlg:appearance_marginprops'] = 'Body marginaler';
$string['fullpage_dlg:appearance_style'] = 'Stilmall och stilegenskaper';
$string['fullpage_dlg:appearance_tab'] = 'Utseende';
$string['fullpage_dlg:appearance_textprops'] = 'Textinställningar';
$string['fullpage_dlg:author'] = 'Författare';
$string['fullpage_dlg:base_element'] = 'Base-element';
$string['fullpage_dlg:bgcolor'] = 'Bakgrundsfärg';
$string['fullpage_dlg:bgimage'] = 'Bakgrundsbild';
$string['fullpage_dlg:bottom_margin'] = 'Bottenmarginal';
$string['fullpage_dlg:charset'] = 'Teckenuppsättning';
$string['fullpage_dlg:comment_element'] = 'Comment-element';
$string['fullpage_dlg:content'] = 'Innehåll';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Teckenkodning';
$string['fullpage_dlg:fontface'] = 'Textstil';
$string['fullpage_dlg:font_face'] = 'Textstil';
$string['fullpage_dlg:fontsize'] = 'Textstorlek';
$string['fullpage_dlg:font_size'] = 'Textstorlek';
$string['fullpage_dlg:general_props'] = 'Generellt';
$string['fullpage_dlg:head_elements'] = 'Head element';
$string['fullpage_dlg:hover_color'] = 'Hover färg';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Språkkod';
$string['fullpage_dlg:langdir'] = 'Skriftriktning';
$string['fullpage_dlg:langprops'] = 'Språk och kodning';
$string['fullpage_dlg:language'] = 'Språk';
$string['fullpage_dlg:left_margin'] = 'Vänstermarginal';
$string['fullpage_dlg:link_color'] = 'Länkfärg';
$string['fullpage_dlg:link_element'] = 'Link-element';
$string['fullpage_dlg:ltr'] = 'Vänster till höger';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Bekrivning';
$string['fullpage_dlg:meta_element'] = 'Meta-element';
$string['fullpage_dlg:meta_index_follow'] = 'Indexera och följ länkar';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexera men följ ej länkar';
$string['fullpage_dlg:meta_keywords'] = 'Nyckelord';
$string['fullpage_dlg:meta_noindex_follow'] = 'Indexera inte men följ länkar';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Indexera inte och följ ej länkar';
$string['fullpage_dlg:meta_props'] = 'Metainformation';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Generella';
$string['fullpage_dlg:meta_title'] = 'Titel';
$string['fullpage_dlg:movedown'] = 'Flytta det markerade elementet nedåt';
$string['fullpage_dlg:moveup'] = 'Flytta det markerade elementet uppåt';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Egenskaper';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Radera det markerade elementet';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Högermarginal';
$string['fullpage_dlg:rtl'] = 'Höger till vänster';
$string['fullpage_dlg:script_element'] = 'Script-element';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Style-element';
$string['fullpage_dlg:stylesheet'] = 'Stilmall';
$string['fullpage_dlg:target'] = 'Mål';
$string['fullpage_dlg:textcolor'] = 'Färg';
$string['fullpage_dlg:text_color'] = 'Textfärg';
$string['fullpage_dlg:title'] = 'Dokumentinställningar';
$string['fullpage_dlg:title_element'] = 'Titel-element';
$string['fullpage_dlg:top_margin'] = 'Toppmarginal';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Value';
$string['fullpage_dlg:visited_color'] = 'Visited färg';
$string['fullpage_dlg:xml_pi'] = 'XML deklaration';
$string['fullscreen:desc'] = 'Slå av/på fullskärmsläge';
$string['iespell:download'] = 'ieSpell kunde inte hittas, vill du installera denna nu?';
$string['iespell:iespell_desc'] = 'Rättstava';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Söndag,Måndag,Tisdag,Onsdag,Torsdag,Fredag,Lördag,Söndag';
$string['insertdatetime:day_short'] = 'Sön,Mån,Tis,Ons,Tors,Fre,Lör,Sön';
$string['insertdatetime:insertdate_desc'] = 'Infoga datum';
$string['insertdatetime:inserttime_desc'] = 'Infoga tid';
$string['insertdatetime:months_long'] = 'Januari,Februari,Mars,April,Maj,Juni,Juli,Augusti,September,Oktober,November,December';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Slå av/på absolut positionering';
$string['layer:backward_desc'] = 'Flytta bakåt';
$string['layer:content'] = 'Nytt lager...';
$string['layer:forward_desc'] = 'Flytta framåt';
$string['layer:insertlayer_desc'] = 'Infoga nytt lager';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Infoga/redigera inbäddad media';
$string['media_dlg:advanced'] = 'Avancerat';
$string['media_dlg:align'] = 'Justera';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'Bottom left';
$string['media_dlg:align_bottom_right'] = 'Bottom right';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'Left';
$string['media_dlg:align_right'] = 'Right';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Top left';
$string['media_dlg:align_top_right'] = 'Top right';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Starta automatiskt';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Bakgrundsfärg';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Klass';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Bibehåll proportionerna';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:enabled'] = 'Enabled';
$string['media_dlg:enablejavascript'] = 'Enable JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'Fil/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash options';
$string['media_dlg:flashvars'] = 'Flashvars';
$string['media_dlg:fullscreen'] = 'Fullskärm';
$string['media_dlg:general'] = 'Generellt';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Loopa';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Visa menyn';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Namn';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Spela upp automatiskt';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Spela varje bildruta';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preview'] = 'Förhandsvisning';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Quicktime options';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = 'Strömmande rtsp resurser bör läggas till till QT Src fältet under den advancerade tabben. Du borde också lägga till en icke-strömmande version till Src fältet.';
$string['media_dlg:quality'] = 'Kvalité';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:rmp_options'] = 'Real media player options';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skala';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Dimensioner';
$string['media_dlg:sound'] = 'Sound';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Infoga/redigera inbäddad media';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'UI Mode';
$string['media_dlg:volume'] = 'Volym';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows media player options';
$string['media:edit'] = 'Redigera inbäddad media';
$string['nonbreaking:nonbreaking_desc'] = 'Infoga icke radbrytande mellanslag';
$string['pagebreak:desc'] = 'Infoga sidbrytning';
$string['paste_dlg:text_linebreaks'] = 'Spara radbrytningar';
$string['paste_dlg:text_title'] = 'Använd ctrl-v på ditt tangentbord för att klistra in i detta fönster.';
$string['paste_dlg:word_title'] = 'Använd ctrl-v på ditt tangentbord för att klistra in i detta fönster.';
$string['paste:paste_text_desc'] = 'Klistra in som text';
$string['paste:paste_word_desc'] = 'Klistra in från Word';
$string['paste:plaintext_mode'] = '\'Klistra in\' är f n i läget för ren text. Klicka igen för att växla tillbaka till standardläget för \'Klistra in\'.';
$string['paste:selectall_desc'] = 'Markera allt';
$string['pluginname'] = 'TinyMCE HTML-redigeraren';
$string['preview:preview_desc'] = 'Förhandsgranska';
$string['print:print_desc'] = 'Skriv ut';
$string['save:cancel_desc'] = 'Hoppa över alla förändringar';
$string['save:save_desc'] = 'Spara';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Alla ställen där söksträngen kunde hittas har ersatts.';
$string['searchreplace_dlg:direction'] = 'Riktning';
$string['searchreplace_dlg:down'] = 'Neråt';
$string['searchreplace_dlg:findnext'] = 'Hitta nästa';
$string['searchreplace_dlg:findwhat'] = 'Hitta vad';
$string['searchreplace_dlg:mcase'] = 'Matcha gemener/versaler';
$string['searchreplace_dlg:notfound'] = 'Sökningen har slutförts. Söksträngen kunde inte hittas.';
$string['searchreplace_dlg:replace'] = 'Ersätt';
$string['searchreplace_dlg:replaceall'] = 'Ersätt alla';
$string['searchreplace_dlg:replace_title'] = 'Sök/ersätt';
$string['searchreplace_dlg:replacewith'] = 'Ersätt med';
$string['searchreplace_dlg:searchnext_desc'] = 'Sök igen';
$string['searchreplace_dlg:search_title'] = 'Sök';
$string['searchreplace_dlg:up'] = 'Uppåt';
$string['searchreplace:replace_desc'] = 'Sök/ersätt';
$string['searchreplace:search_desc'] = 'Sök';
$string['simple:bold_desc'] = 'Fet (Ctrl+B)';
$string['simple:bullist_desc'] = 'Punktlista';
$string['simple:cleanup_desc'] = 'Städa upp i källkoden';
$string['simple:italic_desc'] = 'Kursiv (Ctrl+I)';
$string['simple:numlist_desc'] = 'Nummerlista';
$string['simple:redo_desc'] = 'Gör om (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Genomstruken';
$string['simple:underline_desc'] = 'Understruken (Ctrl+U)';
$string['simple:undo_desc'] = 'Å
ngra (Ctrl+Z)';
$string['spellchecker:desc'] = 'Slå av/på rättstavningskontroll';
$string['spellchecker:ignore_word'] = 'Ignorera ord';
$string['spellchecker:ignore_words'] = 'Ignorera alla';
$string['spellchecker:langs'] = 'Språk';
$string['spellchecker:menu'] = 'Rättstavningsinställningar';
$string['spellchecker:no_mpell'] = 'Inga felstavningar funna.';
$string['spellchecker:no_sug'] = 'Inga förslag';
$string['spellchecker:sug'] = 'Förslag';
$string['spellchecker:wait'] = 'Var god vänta...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Redigera inline CSS';
$string['style_dlg:apply'] = 'Applicera';
$string['style_dlg:background_attachment'] = 'Fästpunkt';
$string['style_dlg:background_color'] = 'Bakgrundsfärg';
$string['style_dlg:background_hpos'] = 'Horisontell position';
$string['style_dlg:background_image'] = 'Bakgrundsbild';
$string['style_dlg:background_repeat'] = 'Upprepning';
$string['style_dlg:background_tab'] = 'Bakgrund';
$string['style_dlg:background_vpos'] = 'Vertikal position';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Teckenmellanrum';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Textjustering';
$string['style_dlg:block_text_indent'] = 'Textindrag';
$string['style_dlg:block_vertical_alignment'] = 'Vertikal justering';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Ordavbrytning';
$string['style_dlg:border_tab'] = 'Ramar';
$string['style_dlg:bottom'] = 'Botten';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Höjd';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Bredd';
$string['style_dlg:bullet_image'] = 'Punktbild';
$string['style_dlg:clip'] = 'Beskärning';
$string['style_dlg:color'] = 'Färg';
$string['style_dlg:height'] = 'Höjd';
$string['style_dlg:left'] = 'Vänster';
$string['style_dlg:list_tab'] = 'Listor';
$string['style_dlg:list_type'] = 'Listtyp';
$string['style_dlg:margin'] = 'Marginal';
$string['style_dlg:overflow'] = 'Överflöde';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Placering';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positionering';
$string['style_dlg:positioning_type'] = 'Positionstyp';
$string['style_dlg:right'] = 'Höger';
$string['style_dlg:same'] = 'Samma för alla';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text_blink'] = 'Blinka';
$string['style_dlg:text_case'] = 'Små/stora';
$string['style_dlg:text_color'] = 'Färg';
$string['style_dlg:text_decoration'] = 'Dekoration';
$string['style_dlg:text_font'] = 'Typsnitt';
$string['style_dlg:text_lineheight'] = 'Radhöjd';
$string['style_dlg:text_none'] = 'Inget';
$string['style_dlg:text_overline'] = 'Överstruken';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Storlek';
$string['style_dlg:text_striketrough'] = 'Genomstruken';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Understruken';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Tjocklek';
$string['style_dlg:title'] = 'Redigera inline CSS';
$string['style_dlg:top'] = 'Toppen';
$string['style_dlg:visibility'] = 'Synlighet';
$string['style_dlg:width'] = 'Bredd';
$string['style_dlg:zindex'] = 'Z-index';
$string['table:cell'] = 'Cell';
$string['table:cell_desc'] = 'Tabellcellsinställningar';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolumn';
$string['table:col_after_desc'] = 'Infoga kolumn efter';
$string['table:col_before_desc'] = 'Infoga kolumn före';
$string['table:copy_row_desc'] = 'Klistra in rad';
$string['table:cut_row_desc'] = 'Klipp ut rad';
$string['table:del'] = 'Radera tabell';
$string['table:delete_col_desc'] = 'Radera kolumn';
$string['table:delete_row_desc'] = 'Radera rad';
$string['table:desc'] = 'Infoga/redigera ny tabell';
$string['table_dlg:advanced_props'] = 'Avancerade inställningar';
$string['table_dlg:advanced_tab'] = 'Avancerat';
$string['table_dlg:align'] = 'Justering';
$string['table_dlg:align_bottom'] = 'Botten';
$string['table_dlg:align_default'] = 'Ingen';
$string['table_dlg:align_left'] = 'Vänster';
$string['table_dlg:align_middle'] = 'Mitten';
$string['table_dlg:align_right'] = 'Höger';
$string['table_dlg:align_top'] = 'Toppen';
$string['table_dlg:bgcolor'] = 'Bakgrundsfärg';
$string['table_dlg:bgimage'] = 'Bakgrundsbild';
$string['table_dlg:border'] = 'Ram';
$string['table_dlg:bordercolor'] = 'Ramfärg';
$string['table_dlg:caption'] = 'Överskrift';
$string['table_dlg:cell_all'] = 'Uppdatera alla celler i tabellen';
$string['table_dlg:cell_cell'] = 'Uppdatera nuvarande cell';
$string['table_dlg:cell_limit'] = 'Du kan inte skapa en tabell med fler än {$cells} celler.';
$string['table_dlg:cellpadding'] = 'Cellpadding';
$string['table_dlg:cell_row'] = 'Uppdatera alla celler i raden';
$string['table_dlg:cellspacing'] = 'Cellspacing';
$string['table_dlg:cell_title'] = 'Tabellcellsinställningar';
$string['table_dlg:cell_type'] = 'Celltyp';
$string['table_dlg:colgroup'] = 'Kolumngrupp';
$string['table_dlg:col_limit'] = 'Du kan inte ange fler än {$cols} kolumner.';
$string['table_dlg:cols'] = 'Kolumner';
$string['table_dlg:frame'] = 'Ram';
$string['table_dlg:frame_all'] = 'all';
$string['table_dlg:frame_cols'] = 'cols';
$string['table_dlg:frame_groups'] = 'groups';
$string['table_dlg:frame_none'] = 'none';
$string['table_dlg:frame_rows'] = 'rows';
$string['table_dlg:general_props'] = 'Generella inställningar';
$string['table_dlg:general_tab'] = 'Generellt';
$string['table_dlg:height'] = 'Höjd';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'Språkkod';
$string['table_dlg:langdir'] = 'Skriftriktning';
$string['table_dlg:ltr'] = 'Vänster till höger';
$string['table_dlg:merge_cells_title'] = 'Sammanfoga celler';
$string['table_dlg:mime'] = 'Den MIME-typ som är mål';
$string['table_dlg:missing_scope'] = 'Ör du säker på att du vill fortsätta utan att ange en omfattning, denna underlättar för icke-grafiska webbläsare.';
$string['table_dlg:row_all'] = 'Uppdatera alla rader i tabellen';
$string['table_dlg:row_even'] = 'Uppdatera jämna rader i tabellen';
$string['table_dlg:rowgroup'] = 'Radgrupp';
$string['table_dlg:row_limit'] = 'Du kan inte ange fler än {$rows} rader.';
$string['table_dlg:row_odd'] = 'Uppdatera udda rader i tabellen';
$string['table_dlg:row_row'] = 'Uppdatera nuvarande rad';
$string['table_dlg:rows'] = 'Rader';
$string['table_dlg:row_title'] = 'Tabellradsinställningar';
$string['table_dlg:rowtype'] = 'Radtyp';
$string['table_dlg:rtl'] = 'Höger till vänster';
$string['table_dlg:rules'] = 'Regler';
$string['table_dlg:rules_above'] = 'above';
$string['table_dlg:rules_below'] = 'below';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Omfattning';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Sammanfattning';
$string['table_dlg:tbody'] = 'tabellkropp';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'tabellfot';
$string['table_dlg:th'] = 'Huvud';
$string['table_dlg:thead'] = 'tabellhuvud';
$string['table_dlg:title'] = 'Infoga/redigera ny tabell';
$string['table_dlg:valign'] = 'Vertikal justering';
$string['table_dlg:width'] = 'Bredd';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Sammanfoga celler';
$string['table:paste_row_after_desc'] = 'Klistra in rad efter';
$string['table:paste_row_before_desc'] = 'Klistra in rad ovanför';
$string['table:props_desc'] = 'Tabellinställningar';
$string['table:row'] = 'Rad';
$string['table:row_after_desc'] = 'Infoga ny rad efter';
$string['table:row_before_desc'] = 'Infoga ny rad före';
$string['table:row_desc'] = 'Tabellradsinställningar';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Separera sammansatta celler';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Infoga en färdig mall';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Söndag,Måndag,Tisdag,Onsdag,Torsdag,Fredag,Lördag,Söndag';
$string['template_dlg:day_short'] = 'Sön,Mån,Tis,Ons,Tors,Fre,Lör,Sön';
$string['template_dlg:desc'] = 'Infoga en färdig mall';
$string['template_dlg:desc_label'] = 'Beskrivning';
$string['template_dlg:label'] = 'Mall';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Januari,Februari,Mars,April,Maj,Juni,Juli,Augusti,September,Oktober,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Förhandsgranska';
$string['template_dlg:select'] = 'Välj en mall';
$string['template_dlg:title'] = 'Mallar';
$string['template_dlg:warning'] = 'Varning: Uppdaterar en mall med en ny kan innebära att data försvinner.';
$string['visualchars:desc'] = 'Visa osynliga tecken';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Förkortning';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Redigera attribut';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Markera som struket';
$string['xhtmlxtras_dlg:attribs_title'] = 'Redigera attribut';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribut';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attribut';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Händelser';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Snabbtangent';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klass';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/Tid';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Språk';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Skriftriktning';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabbindex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Vänster till höger';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Höger till vänster';
$string['xhtmlxtras_dlg:events_tab'] = 'Händelser';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Attribut';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Händelser';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Generella inställningar';
$string['xhtmlxtras_dlg:general_tab'] = 'Generellt';
$string['xhtmlxtras_dlg:insert_date'] = 'Infoga nuvarande datum och tid';
$string['xhtmlxtras_dlg:option_ltr'] = 'Vänster till höger';
$string['xhtmlxtras_dlg:option_rtl'] = 'Höger till vänster';
$string['xhtmlxtras_dlg:remove'] = 'Radera';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Förkortning';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citat';
$string['xhtmlxtras_dlg:title_del_element'] = 'Markera som struket';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Markera som tillagt';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Markera som tillagt';
