<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'ja', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'あなたはこの小テストをプレビューすることができます。しかし、これが本当の受験の場合、あなたは次の理由でブロックされます:';
$string['action'] = '操作';
$string['activityoverview'] = 'あなたには有効期限の到来した小テストがあります。';
$string['adaptive'] = 'アダプティブモード';
$string['adaptive_help'] = 'このオプションを「Yes」にした場合、小テストを受験している最中でも複数回の解答することができます。例えば解答が間違っている場合、学生はすぐに解答しなおすことが許されます。しかし、「ペナルティを適用する」設定に基づき、通常間違った解答ごとに評点からペナルティが引かれます。';
$string['addaquestion'] = '問題を追加する ...';
$string['addarandomquestion'] = 'ランダム問題を追加する ...';
$string['addarandomquestion_help'] = 'ランダム問題を追加した場合、受験ごとに同じカテゴリよりランダムに問題が選択され、小テストに追加されます。これは学生が小テストを受験するとき、異なる種類の問題群が選択されることを意味します。小テストが再受験可能な場合、それぞれの受験では新しい問題群を含むことになります。';
$string['adddescriptionlabel'] = '説明/ラベルを追加する';
$string['addingquestion'] = '問題の追加';
$string['addingquestions'] = '<p> ここではデータベース内の問題を管理します。問題は整理しやすいようカテゴリごとに保存されます。また、「公開」を選択した場合、コース内または他のコースの小テストで使用することができます。</p>
<p> 問題カテゴリの作成を選択した後、問題の作成または編集を行うことができます。ページの反対側にある問題リストから問題を選択して、小テストに追加することができます。</p>';
$string['addmoreoverallfeedbacks'] = 'さらに {no} 個のフィードバックフィールドを追加する';
$string['addnewgroupoverride'] = 'グループオーバーライドを追加する';
$string['addnewpagesafterselected'] = '選択した問題の後に新しいページを追加する';
$string['addnewquestionsqbank'] = '「問題バンクコンテンツ」ツール内のカテゴリ {$a->catname} に問題を追加する: {$a->link}';
$string['addnewuseroverride'] = 'ユーザオーバーライドを追加する';
$string['addpagehere'] = 'ここにページを追加する';
$string['addquestion'] = '問題を追加する';
$string['addquestions'] = '問題を追加する';
$string['addquestionstoquiz'] = '現在の小テストに問題を追加する';
$string['addrandom'] = '{$a} 問のランダム問題を追加する';
$string['addrandom1'] = '<< 追加';
$string['addrandom2'] = 'ランダム問題';
$string['addrandomfromcategory'] = 'カテゴリからランダム問題を追加する:';
$string['addrandomquestion'] = 'ランダム問題を追加する';
$string['addrandomquestiontoquiz'] = 'ランダム問題を小テスト {$a} に追加する';
$string['addselectedtoquiz'] = '選択したものを小テストに追加する';
$string['addtoquiz'] = '小テストに追加する';
$string['affectedstudents'] = '影響を受ける {$a}';
$string['aftereachquestion'] = 'それぞれの問題を追加した後';
$string['afternquestions'] = '問題 {$a} 問を追加した後';
$string['age'] = '作成日時';
$string['allattempts'] = 'すべての受験';
$string['allinone'] = '無制限';
$string['allowreview'] = 'レビューを許可する';
$string['alreadysubmitted'] = 'あなたはすでにこの受験を送信しているようです。';
$string['alternativeunits'] = '代替単位';
$string['alwaysavailable'] = '常時利用可能';
$string['analysisoptions'] = '分析オプション';
$string['analysistitle'] = 'アイテム分析テーブル';
$string['answer'] = '答え';
$string['answered'] = '解答済み';
$string['answerhowmany'] = '単一または複数解答?';
$string['answers'] = '正解';
$string['answersingleno'] = '複数解答を許可する';
$string['answersingleyes'] = '単一の解答のみ';
$string['answertoolong'] = '{$a} 行以降の解答が長すぎます (最大、半角255文字)';
$string['aon'] = 'AONフォーマット';
$string['areyousureremoveselected'] = '選択した問題すべてを本当に削除してもよろしいですか?';
$string['asshownoneditscreen'] = '編集画面と同じ順で表示する';
$string['attempt'] = '受験  {$a}';
$string['attemptalreadyclosed'] = 'この受験はすでに終了しています。';
$string['attemptclosed'] = '受験はまだ終了していません。';
$string['attemptduration'] = '所要時間';
$string['attemptedon'] = '受験日時';
$string['attempterror'] = '現在、あなたはこの小テストを受験することができません。理由: {$a}';
$string['attemptfirst'] = '最初の受験';
$string['attemptincomplete'] = '{$a} による受験はまだ完了していません。';
$string['attemptlast'] = '最新の受験';
$string['attemptnumber'] = '受験';
$string['attemptquiznow'] = '問題を受験する';
$string['attempts'] = '受験';
$string['attemptsallowed'] = '受験可能回数';
$string['attemptsdeleted'] = '小テストの受験結果が削除されました。';
$string['attemptselection'] = 'どの受験を分析するかユーザごとに選択してください:';
$string['attemptsexist'] = 'あなたはこれ以上問題を追加または削除することはできません。';
$string['attemptsnum'] = '受験件数: {$a}';
$string['attemptsnumthisgroup'] = '受験件数: {$a->total} (このグループ: {$a->group})';
$string['attemptsnumyourgroups'] = '受験件数: {$a->total} (あなたのグループ: {$a->group})';
$string['attemptsonly'] = '受験済みの学生のみ表示';
$string['attemptstate'] = '状態';
$string['attemptstillinprogress'] = '進行中の受験';
$string['attemptsunlimited'] = '無制限';
$string['autosaveperiod'] = '自動保存間隔';
$string['autosaveperiod_desc'] = '学生の解答が数分ごとに自動保存されます。これは学生が作業を喪失する可能性を減らす代わりにサーバの負荷が増すというトレードオフとなります。';
$string['back'] = '問題のプレビューに戻る';
$string['backtocourse'] = 'コースに戻る';
$string['backtoquestionlist'] = '問題リストに戻る';
$string['backtoquiz'] = '小テストの編集に戻る';
$string['basicideasofquiz'] = '小テスト作成の基本的な考え方';
$string['bestgrade'] = '最高評点';
$string['bothattempts'] = '受験済みおよび未受験の学生を表示';
$string['browsersecurity'] = 'ブラウザセキュリティ';
$string['browsersecurity_help'] = 'Javaスクリプトセキュリティ対策を含んだフルスクリーンポップアップを選択した場合:

* 学生がJavaスクリプトの利用を有効にしているブラウザのみ、小テスト受験を開始することができます。
* 小テストはフルスクリーンのポップアップウィンドウ上に表示され、ナビゲーションコントロールはありません。
* 可能な範囲でコピー&ペーストのような機能を学生が使用できないようにします。
';
$string['calculated'] = '計算問題';
$string['calculatedquestion'] = '{$a} 行の計算された問題はサポートされていません。問題は無視されました。';
$string['cannotcreatepath'] = 'パス ({$a}) が作成できません。';
$string['cannoteditafterattempts'] = 'この小テストは受験されているため、あなたは問題を追加または削除することはできません。({$a})';
$string['cannotfindprevattempt'] = '直近の受験結果を構築するためのデータが見つかりませんでした。';
$string['cannotfindquestionregard'] = '再評定のための問題を取得できませんでした!';
$string['cannotinsert'] = '問題を追加できません。';
$string['cannotinsertrandomquestion'] = '新しいランダム問題を追加できませんでした!';
$string['cannotloadquestion'] = '問題オプションを読み込むことができませんでした。';
$string['cannotloadtypeinfo'] = '問題タイプの問題情報を読み込むことができません。';
$string['cannotopen'] = 'エクスポートファイル ({$a}) を開けません。';
$string['cannotrestore'] = '問題セッションをリストアできませんでした。';
$string['cannotreviewopen'] = '小テスト実施中のため、あなたはこの受験をレビューできません。';
$string['cannotsavelayout'] = 'レイアウトを保存できませんでした。';
$string['cannotsavenumberofquestion'] = 'ページごとの問題数を保存できませんでした。';
$string['cannotsavequestion'] = '問題リストを保存できません。';
$string['cannotsetgrade'] = '小テストの新たな最大評点を設定できませんでした。';
$string['cannotsetsumgrades'] = '評点合計を設定できませんでした。';
$string['cannotstartgradesmismatch'] = 'この小テストの受験を開始できません。小テストは最大評点 {$a->grade} に設定されているようですが、小テスト内に評定できる問題が存在しません。これは「小テストの編集」ページにて修正することができます。';
$string['cannotstartmissingquestion'] = 'この小テストの受験を開始できません。小テストの定義に存在しない問題が含まれています。';
$string['cannotstartnoquestions'] = 'この小テストの受験を開始できません。まだ、小テストが設定されていません。問題が追加されていません。';
$string['cannotwrite'] = 'エクスポートファイル ({$a}) を書き込めません。';
$string['caseno'] = 'いいえ、文字の大小は重要ではありません。';
$string['casesensitive'] = '大文字小文字の区別';
$string['caseyes'] = 'はい、文字の大小は合致する必要があります。';
$string['categories'] = 'カテゴリ';
$string['category'] = 'カテゴリ';
$string['categoryadded'] = 'カテゴリ「 {$a} 」が追加されました。';
$string['categorydeleted'] = 'カテゴリ「 {$a} 」が削除されました。';
$string['categorynoedit'] = 'あなたはカテゴリ「 {$a} 」における編集権限がありません。';
$string['categoryupdated'] = 'カテゴリが正常に更新されました。';
$string['close'] = 'ウィンドウを閉じる';
$string['closebeforeopen'] = '小テストを更新できませんでした。あなたは小テスト終了日時を小テスト公開日時の前に設定しました。';
$string['closed'] = '終了';
$string['closepreview'] = 'プレビューを閉じる';
$string['closereview'] = 'レビューを閉じる';
$string['comment'] = 'コメント';
$string['commentorgrade'] = 'コメント作成または評点を上書きする';
$string['comments'] = 'コメント';
$string['completedon'] = '完了日時';
$string['configadaptive'] = 'あなたがこのオプションを有効にした場合、同じ小テスト内の受験だとしても、学生は問題に対して複数回の解答を許可されます。';
$string['configattemptsallowed'] = '小テストで学生が許可される受験回数の制限です。';
$string['configdecimaldigits'] = '評定を表示する場合、小数点以下に表示される評点の桁数を設定します。';
$string['configdecimalplaces'] = '小テストの評定を表示する場合、小数点以下に表示される評点の桁数を設定します。';
$string['configdecimalplacesquestion'] = '個々の問題の評定を表示する場合、小数点以下に表示される評点の桁数を設定します。';
$string['configdelay1'] = 'あなたが待ち時間を設定した場合、次の小テストを受験できるまで、最初の受験終了後、学生は指定された時間待つ必要があります。';
$string['configdelay1st2nd'] = 'あなたがここで待ち時間を設定した場合、最初の受験終了後、ここで設定した時間が経過するまで、学生は2回目の受験を開始できません。';
$string['configdelay2'] = 'あなたがここで待ち時間を設定した場合、2回目またはそれ以降の小テストを受験できるまで、学生は指定された時間待つ必要があります。';
$string['configdelaylater'] = 'あなたがここで待ち時間を設定した場合、前回の受験終了後、ここで設定した時間が経過するまで、学生は3回目、4回目、... の受験を開始できません。';
$string['configeachattemptbuildsonthelast'] = '複数解答が許可されている場合、それぞれの新しい受験に前の受験結果を含みます。';
$string['configgrademethod'] = '複数解答が許可されている場合、小テストにおける学生の最終評点に関して、どの評定方法を使用するか設定します。';
$string['configintro'] = 'あなたがここで設定した値は、新しい小テスト作成時のデフォルト値として使用されます。また、どの小テスト設定が「高度な設定」とみなされるか設定することもできます。';
$string['configmaximumgrade'] = '設定値を基に小テスト評定が増減されるデフォルトの評点です。';
$string['confignavmethod'] = 'フリーナビゲーションでは、ナビゲーションを使って問題にどのような順序でも解答することができます。順次では、固定された順番で問題に解答する必要があります。';
$string['confignewpageevery'] = '問題を小テストに追加する場合、あなたがここで選択した設定に基づき、改ページ (Page break) が自動的に挿入されます。';
$string['configoutcomesadvanced'] = 'このオプションを有効にした場合、小テスト編集フォームのアウトカムは高度な設定になります。';
$string['configpenaltyscheme'] = 'アダプティブモードの場合、それぞれの誤答に関して、ペナルティーが差し引かれます。';
$string['configpopup'] = '小テストの受験時、ポップアップウィンドを開きます。また、小テストの受験中、コピー&ペースト等を制限するため、Javaスクリプトを使用します。';
$string['configrequirepassword'] = '学生が小テストを受験するには、このパスワードを事前に入力する必要があります。';
$string['configrequiresubnet'] = '学生は、これらのコンピュータからのみ小テストを受験することができます。';
$string['configreviewoptions'] = 'これらのオプションでは、ユーザが小テスト受験をレビューまたは小テストレポートを閲覧する場合、どの情報を閲覧できるかコントロールします。';
$string['configshowblocks'] = '小テスト受験中にブロックを表示します。';
$string['configshowuserpicture'] = '受験中、画面にユーザ写真を表示します。';
$string['configshufflequestions'] = 'あなたがこのオプションを有効にした場合、学生の小テスト受験ごとに、小テストの問題順はランダムにシャッフルされます。';
$string['configshufflewithin'] = 'あなたがこのオプションを有効にした場合、学生の小テスト受験開始ごとに、個々の問題を構成している部品がランダムにシャッフルされます。';
$string['configtimelimit'] = '小テストのデフォルトの制限時間 (分) です。ゼロは、制限時間なしを意味します。';
$string['configtimelimitsec'] = '小テストのデフォルトの制限時間 (秒) です。ゼロは、制限時間なしを意味します。';
$string['configurerandomquestion'] = '問題の設定';
$string['confirmclose'] = '送信した場合、この受験に関して、これ以上あなたの答えを変更することはできません。';
$string['confirmserverdelete'] = '本当にサーバ <b>{$a}</b> をリストから削除してもよろしいですか?';
$string['confirmstartattemptlimit'] = 'この小テストの受験回数: {$a} あなたは新しい受験を開始しようとしています。本当に続けてもよろしいですか?';
$string['confirmstartattempttimelimit'] = 'この小テストには制限時間があり、受験回数は {$a} 回に制限されています。あなたは新しい受験を開始しようとしています。本当に続けてもよろしいですか?';
$string['confirmstarttimelimit'] = '小テストには制限時間があります。本当に開始してもよろしいですか?';
$string['connectionerror'] = 'ネットワークコネクションが切断されました (自動保存失敗)。

このページで入力した最後の数分間の解答をメモした後、再接続を試みてください。

接続が再確立された場合、あなたの解答は保存され、このメッセージは表示されなくなります。';
$string['connectionok'] = 'ネットワークコネクションが復元されました。あなたは安全に続けることができます。';
$string['containercategorycreated'] = 'このカテゴリは、下記の原因によりサイトレベルで移動されたすべてのオリジナルカテゴリを保存するために作成されました。';
$string['continueattemptquiz'] = '前回の受験を続ける';
$string['continuepreview'] = '前回受験のプレビューを続ける';
$string['copyingfrom'] = '問題「 {$a} 」のコピーを作成';
$string['copyingquestion'] = '問題のコピー';
$string['correct'] = '正解';
$string['correctanswer'] = '正解';
$string['correctanswerformula'] = '正解の公式';
$string['correctansweris'] = '正解: {$a}';
$string['correctanswerlength'] = '有効数字';
$string['correctanswers'] = '正解';
$string['correctanswershows'] = '正解の表示';
$string['corrresp'] = '正解';
$string['countdown'] = 'カウントダウン';
$string['countdownfinished'] = 'この小テストは終了します。あなたの解答を送信してください。';
$string['countdowntenminutes'] = '小テストは10分後に終了します。';
$string['coursetestmanager'] = 'Course Test Managerフォーマット';
$string['createcategoryandaddrandomquestion'] = 'カテゴリを作成してランダム問題を追加する';
$string['createfirst'] = '最初に記述問題を作成してください。';
$string['createmultiple'] = '複数問題の作成';
$string['createnewquestion'] = '問題の作成';
$string['createquestionandadd'] = '新しい問題を作成して、小テストに追加する';
$string['custom'] = 'カスタムフォーマット';
$string['dataitemneed'] = '有効な問題を作成するには、あなたは少なくとも一組のデータアイテムを追加する必要があります。';
$string['datasetdefinitions'] = 'カテゴリ {$a} の再利用可能なデータセット定義';
$string['datasetnumber'] = 'No.';
$string['daysavailable'] = '日利用可能';
$string['decimaldigits'] = '評点の小数点以下桁数';
$string['decimalplaces'] = '評点の小数位';
$string['decimalplaces_help'] = 'この設定では評点を表示または評定するときに、小数点以下を何桁表示するか指定します。この設定は評点の表示のみに影響します。データベースに保存された評点および常に完全精度のため実行される内部計算には影響しません。';
$string['decimalplacesquestion'] = '問題評点の小数位';
$string['decimalplacesquestion_help'] = '<p>個々の問題の評点を表示する場合、小テスト全体の評点に対して、あなたは異なる精度を選択することができます。例えば、個々の問題では分数の評点を使用するのに対して、小テストの最終評点では最も近い整数に丸めたいこともあるでしょう。</p>';
$string['decimalpoints'] = '小数点';
$string['default'] = 'デフォルト';
$string['defaultgrade'] = '評点のデフォルト値';
$string['defaultinfo'] = '問題の標準カテゴリ';
$string['delay1'] = '最初と2回目の受験の待ち時間';
$string['delay1st2nd'] = '最初と2回目の受験の強制待ち時間';
$string['delay1st2nd_help'] = '有効にした場合、最初の受験後、学生が2回目の小テストを受験するには設定された時間待つ必要があります。';
$string['delay2'] = '2回目以降の受験の待ち時間';
$string['delaylater'] = '2回目以降の受験の強制待ち時間';
$string['delaylater_help'] = '有効にした場合、前の受験後、学生が3回目またはそれ以降の小テストを受験するには設定された時間待つ必要があります。';
$string['deleteattemptcheck'] = '本当にこれらの受験内容を削除してもよろしいですか?';
$string['deleteselected'] = '選択したものを削除する';
$string['deletingquestionattempts'] = '問題受験結果の削除';
$string['description'] = '説明';
$string['disabled'] = '無効';
$string['displayoptions'] = '表示オプション';
$string['donotuseautosave'] = '自動保存を使用しない';
$string['download'] = 'エクスポートしたカテゴリファイルをダウンロードする';
$string['downloadextra'] = '(ファイルはコースファイル内の /backupdata/quizフォルダにも保存されます。)';
$string['duplicateresponse'] = 'あなたは前に同じ解答を送信していますので、この送信は無視されました。';
$string['eachattemptbuildsonthelast'] = '直近の解答内容を反映させる';
$string['eachattemptbuildsonthelast_help'] = '複数回の受験が許可され、この設定を「Yes」にした場合、それぞれの新しい受験では直近の解答内容が反映されます。これにより、複数回の受験で小テストが終了するよう設定できます。';
$string['editcategories'] = 'カテゴリを編集する';
$string['editcategory'] = 'カテゴリを編集する';
$string['editcatquestions'] = 'カテゴリ・問題の編集';
$string['editingquestion'] = '問題の編集';
$string['editingquiz'] = '小テストの編集';
$string['editingquiz_help'] = '小テスト作成におけるメインコンセプトは下記のとおりです:

* 小テストは1ページまたはそれ以上のページに問題を含みます。
* 問題バンクにはすべての問題がカテゴリにより整理されて保存されます。
* ランダム問題 - 小テスト受験時、学生は毎回異なる問題を受験します。また、学生ごとに異なる問題を受験することができます。';
$string['editingquizx'] = '小テストの編集: {$a}';
$string['editoverride'] = 'オーバーライドを編集する';
$string['editqcats'] = '問題カテゴリを編集する';
$string['editquestions'] = '問題の編集';
$string['editquiz'] = '小テストを編集する';
$string['editquizquestions'] = '小テスト問題の編集';
$string['emailconfirmbody'] = '{$a->username} さん

以下の解答をお送りいただきまして、ありがとうございます。

小テスト名: {$a->quizname}
コース名: {$a->coursename}
送信日時: {$a->submissiontime}

私たちがあなたの解答を正常に受信しましたので、この確認メールをお送りします。

あなたは {$a->quizurl} にて、小テストにアクセスすることができます。';
$string['emailconfirmsmall'] = '「 {$a->quizname} 」へのあなたの解答送信、ありがとうございます。';
$string['emailconfirmsubject'] = '送信確認: {$a->quizname}';
$string['emailnotifybody'] = '{$a->username} さん

以下のユーザが小テストを完了しました。

ユーザ名: {$a->studentname}
小テスト名: {$a->quizname}
URL: {$a->quizurl}
コース名: {$a->coursename}

あなたはこの受験を、{$a->quizreviewurl} でレビューすることができます。';
$string['emailnotifysmall'] = '{$a->studentname} が {$a->quizname} を完了しました。詳細は {$a->quizreviewurl} をご覧ください。';
$string['emailnotifysubject'] = '{$a->studentname} が {$a->quizname} を完了しました。';
$string['emailoverduebody'] = '{$a->studentname} さん

あなたはコース「 {$a->coursename} 」の小テスト「 {$a->quizname} 」の受験を開始しましたが、一度も送信していないようです。あなたの受験は {$a->attemptduedate} までに送信される必要があります。

Iあなたがこの受験をまだ送信したいと思う場合、{$a->attemptsummaryurl} にアクセスして送信ボタンをクリックしてください。この作業は {$a->attemptgraceend} までに実施してください。そうでない場合、あなたの受験はカウントされないことになります。';
$string['emailoverduesmall'] = 'あなたは {$a->quizname} の受験を送信していないようです。あなたがまだ受験を送信したいと思う場合、{$a->attemptgraceend} までに {$a->attemptsummaryurl} にアクセスしてください。';
$string['emailoverduesubject'] = '受験期限切れ: {$a->quizname}';
$string['empty'] = '空';
$string['enabled'] = '有効';
$string['endtest'] = 'テスト終了 ...';
$string['erroraccessingreport'] = 'あなたはこのレポートにアクセスできません。';
$string['errorinquestion'] = '問題のエラー';
$string['errormissingquestion'] = 'エラー: id {$a} の問題はありません。';
$string['errornotnumbers'] = 'エラー - 答えは数字を使用してください。';
$string['errorunexpectedevent'] = '受験「 {$a->attemptid} 」の問題「 {$a->questionid} 」に予期しないイベントコード「 {$a->event} 」が見つかりました。';
$string['essay'] = '作文問題';
$string['essayquestions'] = '問題';
$string['eventquizattemptabandoned'] = '小テスト受験が放棄されました。';
$string['eventquizattemptstarted'] = '小テスト受験が開始されました。';
$string['eventquizattemptsubmitted'] = '小テスト受験が送信されました。';
$string['eventquizattempttimelimitexceeded'] = '小テスト受験の時間制限を超過しました。';
$string['everynquestions'] = '問題 {$a} 問ごと';
$string['everyquestion'] = '問題１問ごと';
$string['everythingon'] = 'すべて有効';
$string['export'] = 'エクスポート';
$string['exportcategory'] = 'エクスポートカテゴリ';
$string['exporterror'] = 'エクスポート処理中にエラーが発生しました。';
$string['exportingquestions'] = '問題がファイルにエクスポートされました。';
$string['exportname'] = 'ファイル名';
$string['exportquestions'] = '問題をファイルにエクスポートする';
$string['extraattemptrestrictions'] = '受験に関する特別制限';
$string['false'] = '×';
$string['feedback'] = 'フィードバック';
$string['feedbackerrorboundaryformat'] = 'フィードバック評点境界は、パーセンテージまたは数値で入力してください。あなたが入力した境界 {$a} は認められません。';
$string['feedbackerrorboundaryoutofrange'] = 'フィードバック評点境界は、0%から100%の間で入力してください。あなたが入力した境界 {$a} は範囲外です。';
$string['feedbackerrorjunkinboundary'] = 'あなたは評点境界ボックスに対して、ギャップなしで入力する必要があります。';
$string['feedbackerrorjunkinfeedback'] = 'フィードバックボックスには、ギャップなしで入力してください。';
$string['feedbackerrororder'] = 'フィードバック評点境界は最初に最高値から順に入力してください。あなたが入力した境界 {$a} の順番は正しくありません。';
$string['file'] = 'ファイル';
$string['fileformat'] = 'ファイルフォーマット';
$string['fillcorrect'] = '正解を表示する';
$string['filloutnumericalanswer'] = 'あなたは少なくとも1つの答えおよび許容誤差を入力しました。最初の組み合わせの答えは、評点とフィードバックを決定するために使用されます。あなたが最後に答えのないフィードバックを提供した場合、学生には解答が他のどの答えとも合致していない旨が表示されてしまいます。';
$string['filloutoneanswer'] = 'あなたは1つ以上の考えられる答えを入力する必要があります。空白の答えは使用されません。「*」は、どのような文字にでも合致するワイルドカードとして使用することができます。最初の組み合わせの答えは評点およびフィードバックを決定するため使用されます。';
$string['filloutthreequestions'] = '組み合わせの答えがある問題を、少なくとも3つ入力してください。答えが空白の問題を使用して、誤答を余分に提供することもできます。問題と答えの両方が空白のエントリは無視されます。';
$string['fillouttwochoices'] = '2つ以上の選択肢を入力してください。空白は使用できません。';
$string['finishattemptdots'] = '受験を終了する ...';
$string['finishreview'] = 'レビューを終了する';
$string['forceregeneration'] = 'データを再生成する';
$string['formatnotfound'] = 'インポート/エクスポートフォーマット {$a} が見つかりませんでした。';
$string['formatnotimplemented'] = 'フォーマットが正しく実装されていません。バグレポートに投稿してください。';
$string['formulaerror'] = '公式エラー!';
$string['fractionsaddwrong'] = 'あなたが選択したプラス評点の合計が、100%になっていません。<br />現在の評点合計は {$a}% です。<br />戻ってこの問題を修正しますか?';
$string['fractionsnomax'] = 'この問題で満点を取ることができるよう、<br />答えの1つは、100%でなければなりません。 <br />戻ってこの問題を修正しますか?';
$string['fromfile'] = 'ファイルからインポートする:';
$string['functiondisabledbysecuremode'] = 'この機能は現在無効にされています。';
$string['generalfeedback'] = '全般に対するフィードバック';
$string['generalfeedback_help'] = '<p>全般に対するフィードバックは問題の受験後、学生に表示されるテキストです。問題タイプおよび学生の解答によって決まるフィードバックとは異なり、同じ全般に対するフィードバックテキストがすべての学生に表示されます。</p>

<p>全般に対するフィードバックがいつ表示されるか、小テスト設定ページの「学生はレビューできる」チェックボックスでコントロールすることができます。</p>

<p>どのような知識がこの問題で問われているのかという背景に関して、全般に対するフィードバックを使用して学生に提示することができます。または問題が分からない場合、さらなる情報のリンクを与えて学生が利用できるようにすることもできます。</p>';
$string['graceperiod'] = '送信猶予期間';
$string['graceperiod_desc'] = '制限時間経過後に関して、「開いている受験を送信できる場合は猶予期間を設けますが、さらに問題に解答することはできません」が設定されている場合、デフォルトの猶予期間 (秒) が許可されます。';
$string['graceperiod_help'] = '制限時間経過後に関して、「開いている受験を送信できる場合は猶予期間を設けますが、さらに問題に解答することはできません」が設定されている場合、デフォルトの猶予期間 (秒) が許可されます。';
$string['graceperiodmin'] = '最終送信の猶予期間 (秒)';
$string['graceperiodmin_desc'] = '小テストの終わりに関して、潜在的な問題があります。時間切れ時点でタイマーが小テストを自動的に送信させることにより、私たちは最後の秒まで学生に小テストを受験を続けさせたいと思います。しかし、サーバに負荷が掛かることにより、解答処理に時間を要する場合があります。そのため、サーバの遅延を原因としてペナルティが課せられないよう、私たちは制限時間後に最大ここで設定した時間だけ解答を受け付けることができます。しかし、学生はこの時間 (秒) を小テストの解答に不正に使うことができてしまいます。小テストの受験中、あなたのサーバのパフォーマンスをどれだけ信用するかをトレードオフにする必要があります。';
$string['graceperiodtoosmall'] = '送信猶予期間は {$a} 以上に設定してください。';
$string['grade'] = '評点';
$string['gradeall'] = 'すべてを評定する';
$string['gradeaverage'] = '平均評点';
$string['gradeboundary'] = '評点境界';
$string['gradeessays'] = '作文問題を評定する';
$string['gradehighest'] = '最高評点';
$string['grademethod'] = '評定方法';
$string['grademethod_help'] = '<p>複数回の受験が許可されている場合、異なる方法で学生の最終評点を計算することができます。</p>

<h2>最高評点</h2>

<p>すべての受験の中の最高 (最良) 評点が最終評点です。</p>

<h2>平均評点</h2>
<p>最終評点はすべての受験の平均評点 (単純平均) です。</p>

<h2>最初の受験</h2>
<p>最終評点は一番最初の受験で得点した評点です (他は無視されます)。</p>

<h2>前回の受験</h2>
<p>最終評点には直近の受験で得点した評点のみ考慮されます。</p>';
$string['gradesdeleted'] = '小テストの評定が削除されました。';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}';
$string['gradingdetails'] = 'この解答の評点: {$a->raw}/{$a->max}';
$string['gradingdetailsadjustment'] = '前のペナルティにより <strong>{$a->cur}/{$a->max}</strong> に調整されます。';
$string['gradingdetailspenalty'] = 'この解答のペナルティ: {$a}';
$string['gradingdetailszeropenalty'] = 'この解答にペナルティはありません。';
$string['gradingmethod'] = '評定方法: {$a}';
$string['groupoverrides'] = 'グループオーバーライド';
$string['groupsnone'] = 'このコースにはグループはありません。';
$string['guestsno'] = '申し訳ございません、ゲストユーザは小テストの表示または解答ができません。';
$string['hidebreaks'] = '改ページ (Page break) を隠す';
$string['hidereordertool'] = '並べ替えツールを隠す';
$string['history'] = '解答履歴:';
$string['howquestionsbehave_desc'] = '小テストにおける問題動作のデフォルト設定です。';
$string['imagedisplay'] = '表示イメージ';
$string['import'] = 'インポート';
$string['importcategory'] = 'ファイルからカテゴリをインポートする';
$string['importerror'] = 'インポート処理中にエラーが発生しました。';
$string['importfilearea'] = 'すでにコース内にあるファイルからインポートする ...';
$string['importfileupload'] = 'アップロードしたファイルからインポートする ...';
$string['importfromthisfile'] = 'このファイルからインポートする';
$string['import_help'] = 'この機能では外部テキストファイルから問題をインポートすることができます。

あなたのファイルが非ASCII文字コードを含んでいる場合、 UTF-8エンコードを使用する必要があります。正常に処理できない特別エンコーディングを使用する場合がありますので、Microsoft Officeアプリケーションで作成されたファイルには特に注意してください。

インポートおよびエクスポートフォーマットは着脱可能なリソースです。他の任意のフォーマットはModules and Pluginsより入手することができます。';
$string['importingquestions'] = '{$a} 問の問題をファイルからインポートする';
$string['importmax10error'] = '問題にエラーがあります。10以上の答えを設定することはできません。';
$string['importmaxerror'] = '問題にエラーがあります。答えが多すぎます。';
$string['importquestions'] = 'ファイルから問題をインポートする';
$string['inactiveoverridehelp'] = '* 学生に小テストを受験するための正しいグループまたはロールがありません。';
$string['incorrect'] = '不正解';
$string['indivresp'] = '各問題に対する解答内容';
$string['info'] = 'インフォメーション';
$string['infoshort'] = 'i';
$string['inprogress'] = '進行中';
$string['introduction'] = '説明';
$string['invalidattemptid'] = 'そのような受験IDはありません。';
$string['invalidcategory'] = 'カテゴリIDが正しくありません。';
$string['invalidnumericanswer'] = 'あなたが入力した答えの1つが、有効な数値ではありません。';
$string['invalidnumerictolerance'] = 'あなたが入力した許容誤差の1つが、有効な数値ではありません。';
$string['invalidoverrideid'] = '無効なオーバーライドID';
$string['invalidquestionid'] = '問題IDが正しくありません。';
$string['invalidquizid'] = '小テストIDが正しくありません。';
$string['invalidsource'] = 'ソースは有効ではありません。';
$string['invalidsourcetype'] = 'ソースタイプが正しくありません。';
$string['invalidstateid'] = '状態IDが正しくありません。';
$string['lastanswer'] = 'あなたの直近の答えは';
$string['layout'] = 'レイアウト';
$string['layoutasshown'] = '表示されているページレイアウトです。';
$string['layoutasshownwithpages'] = '表示されているページレイアウトです。<small>({$a} 問ごとに新しいページが自動作成されます)</small>';
$string['layoutshuffledandpaged'] = '1ページあたり {$a} 問の問題がランダムにシャッフルされます。';
$string['layoutshuffledsinglepage'] = '1ページ内で問題すべてがランダムにシャッフルされます。';
$string['link'] = 'リンク';
$string['listitems'] = '問題リスト';
$string['literal'] = '定数';
$string['loadingquestionsfailed'] = '問題の読み込みに失敗しました: {$a}';
$string['makecopy'] = '新しい問題として保存する';
$string['managetypes'] = '問題タイプとサーバの管理';
$string['manualgrading'] = '評定';
$string['mark'] = '送信';
$string['markall'] = 'ページを送信する';
$string['marks'] = '得点';
$string['marks_help'] = 'それぞれの問題の評点および全体的な受験の評点です。';
$string['match'] = '組み合わせ問題';
$string['matchanswer'] = '組み合わせの答え';
$string['matchanswerno'] = '組み合わせの答え {$a}';
$string['max'] = '最大';
$string['messageprovider:attempt_overdue'] = 'あなたの小テスト受験が制限時間を過ぎた場合の警告';
$string['messageprovider:confirmation'] = 'あなた自身の小テスト送信確認';
$string['messageprovider:submission'] = '小テスト送信通知';
$string['min'] = '最小';
$string['minutes'] = '分';
$string['missingcorrectanswer'] = '正しい答えを設定してください。';
$string['missingitemtypename'] = '名前がありません。';
$string['missingquestion'] = 'この問題は存在していないようです。';
$string['modulename'] = '小テスト';
$string['modulename_help'] = '小テスト活動において、教師は多肢選択問題、組み合わせ問題、記述問題および数値問題を含む様々なタイプの問題を含む小テストを作成することができます。

教師は問題をシャッフルまたは問題バンクからランダムに選択して、複数回の小テスト受験を許可することができます。また、時間制限を設定することもできます。

それぞれの受験は記述問題を除いて自動的に評定され、評点は評定表に記録されます。

教師は学生に対するヒント、フィードバックおよび正解の表示に関して、いつ表示するのか、および表示するのかどうか選択することができます。

小テストは下記のように使用することができます:

* コーステストとして
* 読書課題またはトピックの最後のミニテストとして
* 過去問題を使用した試験練習として
* パフォーマンスに関する即時フィードバックを提供するため
* 自己評価のため';
$string['modulenameplural'] = '小テスト';
$string['moveselectedonpage'] = '選択した問題を移動する >> ページ: {$a}';
$string['multichoice'] = '多肢選択問題';
$string['multipleanswers'] = '少なくとも1つの答えを選択してください。';
$string['multiplier'] = '乗数';
$string['mustbesubmittedby'] = 'この受験は {$a} までに送信される必要があります。';
$string['name'] = '名称';
$string['navmethod'] = 'ナビゲーションメソッド';
$string['navmethod_free'] = 'フリー';
$string['navmethod_help'] = '順次ナビゲーションメソッドでは、学生は小テストを順番に受験する必要があります。また、前のページに戻ったり、先にスキップすることはできません。';
$string['navmethod_seq'] = '順次';
$string['navnojswarning'] = 'これらのリンクでは、あなたの解答を保存しません。ページ下部の「次へ」ボタンを使用してください。';
$string['neverallononepage'] = 'なし、すべての問題を1ページに表示する';
$string['newattemptfail'] = 'エラー: 小テストの新しい受験を開始できませんでした。';
$string['newpage'] = '新しいページ';
$string['newpageevery'] = '新しいページを自動的に開始する';
$string['newpage_help'] = '<p>問題数の多い小テストの場合、1ページあたりの問題数を制限して、小テストを複数のページに分けることは理にかなっています。小テストのページに問題を追加する場合、この設定にしたがって改ページ (Page break) が自動的に挿入されます。後で小テストの編集ページにて、手動で改ページ (Page break) の位置を変えることもできます。 </p>';
$string['noanswers'] = '答えが選択されていません!';
$string['noattempts'] = 'この小テストは受験されていません。';
$string['noattemptsfound'] = '受験は見つかりませんでした。';
$string['noattemptstoshow'] = '表示する受験結果はありません。';
$string['nocategory'] = 'カテゴリが正しくないか、指定されていません。';
$string['noclose'] = '終了日時なし';
$string['nocommentsyet'] = 'まだコメントはありません。';
$string['noconnection'] = '現在、この問題を処理できるウェブサービスとの接続がありません。管理者に連絡してください。';
$string['nodataset'] = 'なし - ワイルドカードではありません。';
$string['nodatasubmitted'] = '送信されたデータはありません。';
$string['noessayquestionsfound'] = '手動評定問題が見つかりませんでした。';
$string['nogradewarning'] = 'この小テストは評定されていません。そのため、あなたは評点ごとに異なる全体のフィードバックを設定することはできません。';
$string['nomoreattempts'] = 'これ以上受験できません。';
$string['none'] = 'なし';
$string['noopen'] = '開始日時なし';
$string['nooverridedata'] = 'あなたは少なくとも1つの小テスト設定をオーバーライドする必要があります。';
$string['nopossibledatasets'] = '利用可能なデータセットはありません。';
$string['noquestionintext'] = '問題テキストが埋め込み問題を含んでいません。';
$string['noquestions'] = '問題が追加されていません。';
$string['noquestionsfound'] = '問題が見つかりませんでした。';
$string['noquestionsinquiz'] = 'この小テストには問題がありません。';
$string['noquestionsnotinuse'] = 'カテゴリが空のため、このランダム問題は使用されません。';
$string['noquestionsonpage'] = '空のページ';
$string['noresponse'] = '解答なし';
$string['noreview'] = 'あなたはこの小テストのレビューを許可されていません。';
$string['noreviewattempt'] = 'あなたはこの受験のレビューを許可されていません。';
$string['noreviewshort'] = '許可なし';
$string['noreviewuntil'] = 'あなたは {$a} までこの小テストのレビューはできません。';
$string['noreviewuntilshort'] = '利用可能 {$a}';
$string['noscript'] = '続けるにはJavaスクリプトを有効にしてください!';
$string['notavailabletostudents'] = '注意: 現在あなたの学生は、この小テストを利用できません。';
$string['notenoughrandomquestions'] = '問題 {$a->name} ({$a->id}) を作成するために十分な問題がカテゴリ {$a->category} 内にありません。';
$string['notenoughsubquestions'] = '十分な副問題が定義されていません！<br />この問題を修正しますか？';
$string['notimedependentitems'] = '現在、時間に依存する問題は小テストモジュールでサポートされていません。代わりに小テスト全体に対して制限時間を設定してください。他の問題を選択しますか (または無視してこの問題を使いますか) ?';
$string['notyetgraded'] = '未評定';
$string['notyetviewed'] = '未閲覧';
$string['notyourattempt'] = 'これはあなたの受験ではありません!';
$string['noview'] = 'ログインユーザは、この小テストを閲覧できません。';
$string['numattempts'] = '{$a->studentnum} 名の {$a->studentstring} が {$a->attemptnum} 回受験しました。';
$string['numattemptsmade'] = 'この小テストは {$a} 回受験されました。';
$string['numberabbr'] = '#';
$string['numerical'] = '数値問題';
$string['numquestionsx'] = '問題: {$a}';
$string['oneminute'] = '1 分';
$string['onlyteachersexport'] = '教師のみ問題をエクスポートできます。';
$string['onlyteachersimport'] = '権限のある教師のみ問題をインポートできます。';
$string['onthispage'] = 'このページ';
$string['open'] = '未解答';
$string['openclosedatesupdated'] = '小テスト公開日時および終了日時が更新されました。';
$string['optional'] = 'オプション';
$string['orderandpaging'] = '問題順およびページング';
$string['orderandpaging_help'] = 'それぞれの問題の反対側にある番号10、20、30、 ... は問題順を意味します。問題を追加できるよう、番号は10ずつ増やされます。問題順を並べ替えるには、番号を変更した後、「問題を並べ替える」ボタンをクリックしてください。

特定の問題の後に改ページを追加するには、問題の横にあるチェックボックスをチェックした後、「選択した問題の後に改ページを追加する」ボタンをクリックしてください。

1ページあたりの問題数を調整するには、「改ページ調整」ボタンをクリックして、希望する1ページあたりの問題数を入力してください。';
$string['orderingquiz'] = '問題順およびページング';
$string['orderingquizx'] = '問題順およびページング: {$a}';
$string['outcomesadvanced'] = 'アウトカムを高度な設定にする';
$string['outof'] = '{$a->grade} / {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} / {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade} / {$a->maxgrade}';
$string['overallfeedback'] = '全体のフィードバック';
$string['overallfeedback_help'] = '<p>全体のフィードバックは小テストの受験終了後、学生に表示されるテキストです。表示されるテキストは学生の評点によって表示内容を変えることができます。</p>

<p>例えば、あなたが下記のように入力したとします:</p>

<p>評点境界: 100%<br />
フィードバック: よくできました。<br />
評点境界: 40%<br />
フィードバック: 今週の課題をもう一度学習してください。<br />
...<br />
評点境界: 0%</p>

<p>この場合、評点が100%から40%の学生にはメッセージ「よくできました。」が表示され、39.9%から0%の学生には他のメッセージが表示されます。つまり、評点境界は評点の幅を決定し、該当する範囲に入る評点に対して、それぞれのフィードバックが表示されます。</p>

<p>評点境界には「31.41%」のようなパーセンテージ、または「7」のような数値を指定することができます。あなたの小テストが最大評点10点で評点境界が7の場合、7/10またはそれ以上を意味します。</p>';
$string['overdue'] = '期限切れ';
$string['overduehandling'] = '制限時間を経過した場合';
$string['overduehandlingautoabandon'] = '受験は制限時間内に送信される必要がありますが、そうでない場合はカウントされません';
$string['overduehandlingautosubmit'] = '開いている受験は自動的に送信されます';
$string['overduehandling_desc'] = '制限時間の前に学生が小テストを送信しなかった場合、デフォルトでどのようにしますか。';
$string['overduehandlinggraceperiod'] = '開いている受験を送信できる場合は猶予期間を設けますが、さらに問題に解答することはできません';
$string['overduehandling_help'] = 'この設定では、学生が制限時間の前に小テスト受験の送信に失敗した場合の処理をコントロールします。その時点で学生が小テストの受験に取り組んでいる場合、カウントダウンタイマーは常に学生のために受験を自動送信します。しかし、学生がログアウトしている場合、この設定が処理をコントロールします。';
$string['overduemustbesubmittedby'] = 'この受験は制限時間を過ぎています。そして、すでに送信されている必要があります。あなたがこの小テストの評定を希望する場合、{$a} までに送信してください。それまでに送信しない場合、この受験の評点はカウントされません。';
$string['override'] = 'オーバーライド';
$string['overridedeletegroupsure'] = '本当にこのグループ {$a} のオーバーライドを削除してもよろしいですか?';
$string['overridedeleteusersure'] = '本当にこのユーザ {$a} のオーバーライドを削除してもよろしいですか?';
$string['overridegroup'] = 'グループをオーバーライドする';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'オーバーライド';
$string['overrideuser'] = 'ユーザをオーバーライドする';
$string['overrideusereventname'] = '{$a->quiz} - オーバーライド';
$string['page-mod-quiz-attempt'] = '小テスト受験ページ';
$string['page-mod-quiz-edit'] = '小テストページを編集する';
$string['page-mod-quiz-report'] = '小テストレポートページ';
$string['page-mod-quiz-review'] = '小テスト受験レビューページ';
$string['page-mod-quiz-summary'] = '小テスト受験概要ページ';
$string['page-mod-quiz-view'] = '小テスト情報ページ';
$string['page-mod-quiz-x'] = 'すべての小テストモジュールページ';
$string['pagesize'] = 'ページサイズ';
$string['parent'] = '親';
$string['parentcategory'] = '親カテゴリ';
$string['parsingquestions'] = 'インポートファイルより問題を解析しています。';
$string['partiallycorrect'] = '部分的に正解';
$string['penalty'] = 'ペナルティ';
$string['penaltyscheme'] = 'ペナルティを適用する';
$string['penaltyscheme_help'] = '<p>小テストがアダプティブモードで動作している場合、学生は間違った解答の後に問題を再受験することができます。この場合、問題の最終評点からペナルティ分の点数を差し引くことができます。ペナルティの点数は設定または編集時にそれぞれの問題で指定します。</p>

<p>小テストがアダプティブモードで動作しない限り、この設定は影響しません。</p>';
$string['percentcorrect'] = '正解率';
$string['pleaseclose'] = 'あなたのリクエストは処理されました。このウィンドウを閉じてください。';
$string['pluginadministration'] = '小テスト管理';
$string['pluginname'] = '小テスト';
$string['popup'] = '小テストを「セキュア」ウィンドウに表示する';
$string['popupblockerwarning'] = 'これからテストはセキュアモードで表示されますので、あなたは新しいセキュアウィンドウを開く必要があります。現在使用中のポップアップブロッカーを解除してください。ありがとうございます。';
$string['popupnotice'] = '学生は、この小テストをセキュアウィンドウで見ます。';
$string['preprocesserror'] = '前処理中にエラーが発生しました!';
$string['preview'] = 'プレビュー';
$string['previewquestion'] = '問題のプレビュー';
$string['previewquiz'] = '{$a} のプレビュー';
$string['previewquiznow'] = '小テストをプレビューする';
$string['previous'] = '前の状態に戻す';
$string['publish'] = '公開';
$string['publishedit'] = 'このカテゴリへ問題を追加または編集するには、あなたにはコース公開に関するパーミッションが割り当てられている必要があります。';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = '問題名';
$string['qti'] = 'IMS QTIフォーマット';
$string['qtypename'] = '問題タイプ、問題名';
$string['question'] = '問題';
$string['questionbankcontents'] = '問題バンクコンテンツ';
$string['questionbankmanagement'] = '問題バンク管理';
$string['questionbehaviour'] = '問題の挙動';
$string['questioncats'] = '問題カテゴリ';
$string['questiondeleted'] = 'この問題は削除されました。あなたの先生に連絡してください。';
$string['questioninuse'] = '問題「 {$a->questionname} 」は現在使用されています: <br />{$a->quiznames}<br />問題はこれらの小テストから削除されませんが、カテゴリ一覧からのみ削除されます。';
$string['questionmissing'] = 'このセッションの問題がありません。';
$string['questionname'] = '問題名';
$string['questionnonav'] = '<span class="accesshide">問題 </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">インフォメーション </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '問題「 {$a} 」は、データベースから読み込まれませんでした。';
$string['questionorder'] = '問題順';
$string['questionposition'] = '問題 {$a} 順番の新しいポジション';
$string['questions'] = '問題';
$string['questionsinclhidden'] = '問題 (隠された問題を含む)';
$string['questionsinthisquiz'] = 'この小テストの問題';
$string['questionsperpage'] = '1ページあたりの問題数';
$string['questionsperpageselected'] = '1ページあたりの問題数が設定されたため、現在ページングは固定されています。結果として「改ページ調整」ボタンは、無効にされました。あなたは {$a} にて、この設定を変更することができます。';
$string['questionsperpagex'] = '1ページあたりの問題数: {$a}';
$string['questiontext'] = '問題テキスト';
$string['questiontextisempty'] = '[空の問題テキスト]';
$string['questiontype'] = '問題タイプ {$a}';
$string['questiontypesetupoptions'] = '問題タイプのオプション設定';
$string['quiz:addinstance'] = '新しい小テストを追加する';
$string['quiz:attempt'] = '小テストを受験する';
$string['quizavailable'] = '小テストは {$a} まで利用できます。';
$string['quizclose'] = '小テスト終了日時';
$string['quizclosed'] = 'この小テストは {$a} に終了しました。';
$string['quizcloses'] = '終了日時';
$string['quizcloseson'] = 'この小テストは {$a} に終了します。';
$string['quiz:deleteattempts'] = '小テストの受験結果を削除する';
$string['quiz:emailconfirmsubmission'] = '解答を送信した旨の確認メールを受信する';
$string['quiz:emailnotifysubmission'] = '解答が送信された旨の通知メールを受信する';
$string['quiz:emailwarnoverdue'] = '受験が制限時間に達して送信する必要がある場合、通知メッセージを取得します。';
$string['quiz:grade'] = '小テストを手動で評定する';
$string['quiz:ignoretimelimits'] = '小テストの制限時間を無視する';
$string['quizisclosed'] = 'この小テストは終了しています。';
$string['quizisclosedwillopen'] = '小テスト終了 (公開 {$a})';
$string['quizisopen'] = 'この小テストは公開されています。';
$string['quizisopenwillclose'] = '小テスト公開中 (終了 {$a})';
$string['quiz:manage'] = '小テストを管理する';
$string['quiz:manageoverrides'] = '小テストのオーバーライドを管理する';
$string['quiznavigation'] = '小テストナビゲーション';
$string['quizopen'] = '小テスト公開日時';
$string['quizopenclose'] = '公開および終了日時';
$string['quizopenclose_help'] = '学生は公開日時以降のみ受験を開始することができます。また、終了日時の前に受験を完了する必要があります。';
$string['quizopened'] = 'この小テストは公開されています。';
$string['quizopenedon'] = 'この小テストは {$a} に公開されます。';
$string['quizopens'] = '公開日時';
$string['quizopenwillclose'] = 'この小テストは公開中です。{$a} に終了します。';
$string['quizordernotrandom'] = '小テスト順 はシャッフルされません。';
$string['quizorderrandom'] = '*小テスト順 はシャッフルされます。';
$string['quiz:preview'] = '小テストをプレビューする';
$string['quiz:regrade'] = '小テストの受験を再評定する';
$string['quiz:reviewmyattempts'] = 'あなたの受験をレビューする';
$string['quizsettings'] = '小テスト設定';
$string['quiztimer'] = '小テストタイマー';
$string['quiz:view'] = '小テスト情報を表示する';
$string['quiz:viewreports'] = '小テストレポートを表示する';
$string['quizwillopen'] = 'この小テストは {$a} に公開されます。';
$string['random'] = 'ランダム問題';
$string['randomcreate'] = 'ランダム問題の作成';
$string['randomfromcategory'] = '次のカテゴリからのランダム問題:';
$string['randomfromexistingcategory'] = '既存のカテゴリからのランダム問題';
$string['randomnosubcat'] = 'サブカテゴリからではなく、このカテゴリからのみの問題です。';
$string['randomquestionusinganewcategory'] = '新しいカテゴリを使用するランダム問題';
$string['randomwithsubcat'] = 'このカテゴリおよびサブカテゴリからの問題です。';
$string['readytosend'] = '評定のためにすべての小テストを送信します。本当に送信してもよろしいですか?';
$string['reattemptquiz'] = 'もう一度受験する';
$string['recentlyaddedquestion'] = '最新の問題!';
$string['recurse'] = 'サブカテゴリの問題も含む';
$string['regrade'] = 'すべての受験を再評定する';
$string['regradecomplete'] = 'すべての受験が再評定されました。';
$string['regradecount'] = '{$a->attempt} 中 {$a->changed} の評点が変更されました。';
$string['regradedisplayexplanation'] = '再評定により変更された受験結果は、ハイパーリンクとして問題レビューウィンドウに表示されます。';
$string['regradenotallowed'] = 'あなたには、この小テストを再評定するパーミッションがありません。';
$string['regradingquestion'] = '「 {$a} 」の再評定';
$string['regradingquiz'] = '問題「 {$a} 」の再評定';
$string['remove'] = '削除';
$string['removeallquizattempts'] = 'すべての小テスト受験結果を削除する';
$string['removeemptypage'] = '空のページを削除する';
$string['removeselected'] = '選択したものを削除する';
$string['rename'] = 'リネーム';
$string['renderingserverconnectfailed'] = 'サーバ {$a} がRQPリクエストの処理に失敗しました。URLが正しいか確認してください。';
$string['reorderquestions'] = '問題を並べ替える';
$string['reordertool'] = '並べ替えツールを表示する';
$string['repaginate'] = '1ページあたりの問題数: {$a}';
$string['repaginatecommand'] = '改ページ調整';
$string['repaginatenow'] = 'すぐに改ページ調整する';
$string['replace'] = '置換';
$string['replacementoptions'] = '置換';
$string['report'] = 'レポート';
$string['reportanalysis'] = 'アイテム分析';
$string['reportattemptsfrom'] = '受験者';
$string['reportattemptsthatare'] = '受験状況';
$string['reportdisplayoptions'] = '表示オプション';
$string['reportfullstat'] = '詳細統計';
$string['reportmulti_percent'] = 'マルチ - パーセンテージ';
$string['reportmulti_q_x_student'] = 'マルチ - 学生選択';
$string['reportmulti_resp'] = '個別の解答';
$string['reportmustselectstate'] = 'あなたは少なくとも1つの状態を選択する必要があります。';
$string['reportnotfound'] = '不明なレポート ({$a}) です。';
$string['reportoverview'] = '概要';
$string['reportregrade'] = '受験の再評定';
$string['reportresponses'] = '解答詳細';
$string['reports'] = 'レポート';
$string['reportshowonly'] = '受験のみ表示する';
$string['reportshowonlyfinished'] = 'ユーザごとに最大1件の終了した受験を表示する ({$a})';
$string['reportsimplestat'] = '単純統計';
$string['reportusersall'] = '小テストを受験したユーザすべて';
$string['reportuserswith'] = '小テストを受験したことのある登録ユーザ';
$string['reportuserswithorwithout'] = '小テストを受験したことのある、または受験したことのない登録ユーザ';
$string['reportuserswithout'] = '小テストを受験したことのない登録ユーザ';
$string['reportwhattoinclude'] = 'レポートに含む内容';
$string['requirepassword'] = 'パスワード';
$string['requirepassword_help'] = 'ここにパスワードを設定した場合、参加者は小テストを受ける前に同じパスワードを入力する必要があります。';
$string['requiresubnet'] = 'ネットワークアドレス';
$string['requiresubnet_help'] = '<p>このフィールドは任意フィールドです。</p>

<p>LAN上の特定のサブネットまたはインターネットから小テストへのアクセスを、カンマで区切った部分的または完全なIPアドレスで制限することができます。</p>

<p>これは特に特定の部屋の人のみ小テストにアクセスすることができる試験監督付き小テストの実施に便利です。</p>

<p>例えば:  <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b> のように指定します。</p>

<p>ここでは4種類の数値を使うことができます (example.comのようなテキストベースのドメイン名は使用できません):
<ol>
<li><b>192.168.10.1</b> のような完全なIPアドレス。1台のコンピュータ (またはプロクシ) と一致します。</li>
<li><b>192.168</b> のような部分的なIPアドレス。この数値から始まるコンピュータと一致します。</li>
<li><b>231.54.211.0/20</b> のようなCIDR表記法。より詳細なサブネットを指定することができます。</li>
<li><b>231.3.56.10-20</b> のようなIPアドレスの範囲。範囲はIPアドレスの最後の部分に適用されます。この場合、231.3.56.10 から 231.3.56.20 の範囲を意味します。</li>
</ol>
</p>

<p>空白は無視されます。</p>';
$string['response'] = '解答';
$string['responses'] = '解答';
$string['results'] = '受験結果';
$string['returnattempt'] = '受験に戻る';
$string['reuseifpossible'] = '前に削除したデータを再利用する';
$string['reverttodefaults'] = '小テストのデフォルトに戻す';
$string['review'] = 'レビュー';
$string['reviewafter'] = '小テスト終了後にレビューを許可する';
$string['reviewalways'] = '常にレビューを許可する';
$string['reviewattempt'] = '受験をレビューする';
$string['reviewbefore'] = '小テスト実施中にレビューを許可する';
$string['reviewclosed'] = '小テスト終了後';
$string['reviewduring'] = '受験中';
$string['reviewimmediately'] = '受験後すぐに';
$string['reviewnever'] = 'レビューを許可しない';
$string['reviewofattempt'] = '受験 {$a} のレビュー';
$string['reviewofpreview'] = 'プレビューのレビュー';
$string['reviewopen'] = '後で、小テスト実施中';
$string['reviewoptions'] = '学生はレビューできる';
$string['reviewoptionsheading'] = 'レビューオプション';
$string['reviewoptionsheading_help'] = 'このオプションでは小テスト受験結果をレビューまたは小テストレポートを表示する場合、どの情報をユーザが閲覧することができるかコントロールします。

**受験中** は「複数受験インタラクティブ」のような特定の挙動のみに関連します。

**受験後すぐに** はユーザが「すべてを送信して終了する」ボタンクリックして受験を終了した後、2分以内を意味します。

**後で、小テスト実施中** は今後および小テスト終了日時の前を意味します。

**小テスト終了後** は小テスト終了日時経過後を意味します。小テストに終了日時が設定されていない場合、この状態に達することはありません。';
$string['reviewoverallfeedback'] = '全体のフィードバック';
$string['reviewoverallfeedback_help'] = '学生の合計点に応じて、受験の最後に与えられるフィードバックです。';
$string['reviewresponse'] = '解答のレビュー';
$string['reviewresponsetoq'] = '解答のレビュー (問題 {$a})';
$string['reviewthisattempt'] = 'この受験に関して、あなたの解答をレビューします。';
$string['rqp'] = 'リモート問題';
$string['rqps'] = 'リモート問題';
$string['sameasoverall'] = '全体の評点と同じ';
$string['save'] = '保存';
$string['saveandedit'] = '変更内容の保存および問題の編集';
$string['saveattemptfailed'] = '現在の受験内容の保存に失敗しました。';
$string['savedfromdeletedcourse'] = '削除コース「 {$a} 」より保存';
$string['savegrades'] = '評点を保存する';
$string['savemyanswers'] = '私の答えを保存する';
$string['savenosubmit'] = '送信せずに保存する';
$string['saveoverrideandstay'] = '保存して別のオーバーライドを設定する';
$string['savequiz'] = 'この小テスト全体を保存する';
$string['saving'] = '保存';
$string['savingnewgradeforquestion'] = '問題ID {$a} の新しい評定を保存';
$string['savingnewmaximumgrade'] = '新しい最大評点の保存';
$string['score'] = '得点状況';
$string['scores'] = '得点';
$string['select'] = '選択';
$string['selectall'] = 'すべてを選択する';
$string['selectcategory'] = 'カテゴリを選択する';
$string['selectedattempts'] = '選択された受験 ...';
$string['selectnone'] = 'すべての選択を解除する';
$string['selectquestiontype'] = '-- 問題タイプを選択してください --';
$string['serveradded'] = 'サーバ追加';
$string['serveridentifier'] = '識別子';
$string['serverinfo'] = 'サーバ情報';
$string['servers'] = 'サーバ';
$string['serverurl'] = 'サーバURL';
$string['settingsoverrides'] = '設定オーバーライド';
$string['shortanswer'] = '記述問題';
$string['show'] = '表示';
$string['showall'] = 'すべての問題を1ページに表示する';
$string['showblocks'] = '小テスト受験中にブロックを表示する';
$string['showblocks_help'] = '有効にした場合、小テストの受験中に通常のブロックを表示します。';
$string['showbreaks'] = '改ページ (Page break) を表示する';
$string['showcategorycontents'] = 'カテゴリコンテンツを表示する {$a->arrow}';
$string['showcorrectanswer'] = 'フィードバックの中に正解を表示しますか?';
$string['showdetailedmarks'] = '評点の詳細を表示する';
$string['showeachpage'] = '一度に1ページのみ表示する';
$string['showfeedback'] = '解答後にフィードバックを表示しますか?';
$string['showinsecurepopup'] = '受験に「セキュア」ポップアップを使用する';
$string['showlargeimage'] = '大きなイメージ';
$string['shownoattempts'] = '未受験の学生を表示';
$string['shownoattemptsonly'] = '未受験の学生のみ表示';
$string['shownoimage'] = 'イメージなし';
$string['showreport'] = 'レポートを表示する';
$string['showsmallimage'] = '小さなイメージ';
$string['showteacherattempts'] = '教師の受験を表示';
$string['showuserpicture'] = 'ユーザ写真を表示する';
$string['showuserpicture_help'] = '<p>あなたがこのオプションを有効にした場合、受験中およびレビュー時、画面に学生の氏名および写真が表示されます。</p>

<p>1つの例として、試験監督による試験時、ユーザがその人自身でログインしているかどうか確認するため、使用できます。</p>';
$string['shuffle'] = 'シャッフル';
$string['shuffleanswers'] = '答えをシャッフルする';
$string['shuffledrandomly'] = 'ランダムにシャッフルする';
$string['shufflequestions'] = '問題をシャッフルする';
$string['shufflequestionsselected'] = '「ランダムにシャッフルする」が設定されたため、ページに関するいくつかの操作を利用できません。{$a} にて、シャッフルオプションを変更することができます。';
$string['shufflewithin'] = '問題内部をシャッフルする';
$string['shufflewithin_help'] = '<p>このオプションを「Yes」にした場合、学生がこの小テストの受験を開始するたびに、個々の問題の構成要素がランダムにシャッフルされます。この場合、各問題の設定にあるシャッフルオプションも「Yes」にする必要があります。</p>

<p>問題の構成要素をシャッフルする意図は学生同士が答えをコピーし合うことを、少しだけ難しくすることにあります。</p>

<p>このオプションは多肢選択問題や組み合わせ問題のように、複数の構成要素を持つ問題にのみ適用されます。多肢選択問題ではこのオプションが「Yes」にされた場合のみ、答えの順番がシャッフルされます。組み合わせ問題では常に答えがシャッフルされ、この設定は「問題 - 答え」の組み合わせをシャッフルするかどうかコントロールします。</p>

<p>このオプションはランダム問題の利用には関係しません。</p>';
$string['singleanswer'] = '1つの答えを選択してください。';
$string['sortage'] = '作成日時で並べ替える';
$string['sortalpha'] = '問題名で並べ替える';
$string['sortquestionsbyx'] = '問題を並べ替える: {$a}';
$string['sortsubmit'] = '問題を並べ替える';
$string['sorttypealpha'] = '問題タイプ・問題名で並べ替える';
$string['specificapathnotonquestion'] = '指定されたパスが問題にありません。';
$string['specificquestionnotonquiz'] = '指定された問題が小テストにありません。';
$string['startagain'] = 'もう一度始める';
$string['startattempt'] = '受験を開始する';
$string['startedon'] = '開始日時';
$string['startnewpreview'] = '新しいプレビューを開始する';
$string['stateabandoned'] = '未送信';
$string['statefinished'] = '終了';
$string['statefinisheddetails'] = '送信日時 {$a}';
$string['stateinprogress'] = '進行中';
$string['statenotloaded'] = '問題「 {$a} 」の状態は、データベースから読み込まれませんでした。';
$string['stateoverdue'] = '期限切れ';
$string['stateoverduedetails'] = '送信期限: {$a}';
$string['status'] = 'ステータス';
$string['stoponerror'] = 'エラーで中止する';
$string['submitallandfinish'] = 'すべてを送信して終了する';
$string['subneterror'] = '申し訳ございません、この小テストは特定の場所からのみアクセスすることができます。あなたのコンピュータは、この小テストを利用できるコンピュータではありません。';
$string['subnetnotice'] = '特定の場所からのみアクセスできるように、この小テストはロックされています。現在、あなたのコンピュータは、この小テストの使用を許可されていません。教師として、プレビューすることは許可されています。';
$string['subplugintype_quiz'] = 'レポート';
$string['subplugintype_quizaccess'] = 'アクセスルール';
$string['subplugintype_quizaccess_plural'] = 'アクセスルール';
$string['subplugintype_quiz_plural'] = 'レポート';
$string['substitutedby'] = 'が次の値と置換されます:';
$string['summaryofattempt'] = '受験概要';
$string['summaryofattempts'] = 'あなたの前回受験の概要';
$string['temporaryblocked'] = 'あなたは小テストを一時的に受験することができません。<br /> 次に小テストを受験できる日時は:';
$string['theattempt'] = '受験';
$string['theattempt_help'] = '学生が受験すべてをレビューできるかどうか設定します。';
$string['time'] = '時間';
$string['timecompleted'] = '受験完了';
$string['timedelay'] = '次の小テストを受験するまでの待ち時間を経過していないため、あなたは小テストを受験することができません。';
$string['timeleft'] = '残り時間';
$string['timelimit'] = '制限時間';
$string['timelimitexeeded'] = '申し訳ございません! 小テストの制限時間を経過しました!';
$string['timelimit_help'] = '有効にした場合、小テストの初期ページにて時間制限が開始されます。同時に小テストナビゲーションブロックにカウントダウンタイマーが表示されます。';
$string['timelimitmin'] = '制限時間 (分)';
$string['timelimitsec'] = '制限時間 (秒)';
$string['timestr'] = '%y/%m/%d  %H:%M:%S';
$string['timesup'] = '時間終了!';
$string['timetaken'] = '所要時間';
$string['timing'] = 'タイミング';
$string['tofile'] = '>> ファイル';
$string['tolerance'] = '許容誤差';
$string['toomanyrandom'] = '要求されたランダム問題数は、このカテゴリに含まれている数 ({$a}) より多くなっています!';
$string['top'] = 'トップ';
$string['totalmarksx'] = '合計評点: {$a}';
$string['totalquestionsinrandomqcategory'] = 'カテゴリ内に合計 {$a} 問の問題があります。';
$string['true'] = '○';
$string['truefalse'] = '○/×問題';
$string['type'] = '問題タイプ';
$string['unfinished'] = '未了';
$string['ungraded'] = '未評定';
$string['unit'] = '単位';
$string['unknowntype'] = '{$a} 行目の問題タイプはサポートされていません。問題は無視されます。';
$string['unusedcategorydeleted'] = 'コースを削除した後、カテゴリ内の問題が使用されませんでしたので、このカテゴリは削除されました。';
$string['updatesettings'] = '問題設定の更新';
$string['updatingatttemptgrades'] = '受験評点の更新';
$string['updatingfinalgrades'] = '最終評点の更新';
$string['updatingthegradebook'] = '評定表の更新';
$string['upgradesure'] = '小テストモジュールは広範囲におよぶ小テストデータベーステーブルの変更を行うことがあります。また、このアップグレードに関する十分なテストは行われていません。アップグレード処理の前に必ずデータベースのバックアップを行ってください。';
$string['upgradingquizattempts'] = '小テスト受験のアップグレード: 小テスト {$a->done}/{$a->outof} (小テストID {$a->info})';
$string['upgradingveryoldquizattempts'] = '非常に古い小テスト受験のアップグレード: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'このカテゴリは公開され、他のコースで使用されているため、維持したままサイトレベルに移動されました。';
$string['useroverrides'] = 'ユーザオーバーライド';
$string['usersnone'] = 'この小テストにアクセスした学生はいません。';
$string['validate'] = '確認';
$string['viewallanswers'] = '{$a} 件の受験結果を表示する';
$string['viewallreports'] = '{$a} 件の受験レポートを表示する';
$string['viewed'] = '閲覧済み';
$string['warningmissingtype'] = '<b>この問題タイプは、あなたのMoodleにまだインストールされていません。<br />あなたのMoodle管理者に連絡してください。</b>';
$string['wheregrade'] = '私の評点は?';
$string['wildcard'] = 'ワイルドカード';
$string['windowclosing'] = 'このウィンドウは間もなく閉じられます。';
$string['withsummary'] = '(統計概要を含む)';
$string['wronguse'] = 'あなたはこのページをそのように使うことはできません。';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'この小テストを受験する前に、このコースに受講登録する必要があります。';
$string['yourfinalgradeis'] = 'あなたの小テスト最終評点は {$a} です。';
