<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ja', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '本アプリについて';
$string['activity'] = '活動';
$string['add'] = '追加';
$string['addcontact'] = 'コンタクトに追加';
$string['addedtoqueue'] = 'オフライン中：操作はタスクキューに追加されます。';
$string['addfakenotifications'] = 'テスト通知を追加';
$string['addnote'] = 'ノートを追加';
$string['address'] = 'アドレス';
$string['addsite'] = 'サイトを追加';
$string['addsubmission'] = '提出の追加';
$string['allcachesinvalidated'] = '全てのキャッシュを無効にしました';
$string['allcachespurged'] = '全てのキャッシュは消去されました';
$string['allowsubmissionsfromdate'] = 'フォーム提出の許可';
$string['appstoredescription'] = '注意：この公式Moodle Mobileアプリは、利用許可設定がなされたMoodleサイトで「のみ」利用できます。接続時に問題があった場合、あなたのMoodleサイト管理者に連絡してください。

あなたのMoodleサイトの設定が正しければ、本アプリを用いて以下のことができます。

 - あなたのコースの内容の閲覧。オフラインでも。
 - メッセージその他について即座に通知の受信
 - あなたのコースに属する他の利用者の素早い検索と連絡
 - 画像、音声、映像その他あたなのモバイルデバイスからのファイルアップロード
 - あなたのコースでの評定の閲覧
 - それ以上のこと！

最新の情報すべては、 http://docs.moodle.org/en/Mobile_app に掲載されています。

私たちは、皆さんからこれまで寄せられているよい評価に対して心より感謝します。本アプリに追加してほしい機能など、ご意見をお寄せください！

本アプリは以下の許諾を必要とします。
オーディオ記録 - オーディオ記録をMoodleにアップロードするため
SDカード内容の読み取りと変更 - SDカードへコンテンツをダウンロードしてオフライン参照できるようにします
ネットワークアクセス - Moodleサイトへの接続を可能とし、オフラインモードへ切り替わっておらず接続しているかどうかのチェックのため
起動時に実行 - アプリがバックグラウンドで実行している間通知を受け取れるようにするため
電話がスリープするのを防ぐ - プッシュ通知をいつでも受け取れるようにするため';
$string['areyousurereset'] = '本当にアプリをリセットしますか？　追加したサイトの情報はすべて消去されます。';
$string['attempnumber'] = '提出回数';
$string['audionotavailable'] = '音声入力装置がありません';
$string['audiorecordinstructions'] = '記録を始めるには記録ボタンを、止めるには停止ボタンを押し、ファイルをアップロードします。';
$string['authenticating'] = '認証中';
$string['author'] = '著者';
$string['average'] = '平均';
$string['back'] = '戻る';
$string['blockcontact'] = 'コンタクトをブロック';
$string['blockedusers'] = 'ブロックしたユーザ ({$a})';
$string['browsephotoalbums'] = 'フォトアルバム';
$string['cacheexpirationtime'] = 'キャッシュ有効期限（ミリ秒単位）';
$string['cancel'] = 'キャンセル';
$string['cannotaddnote'] = 'ネットワークがつながりません。ノートはタスクキューに保存されており、オンラインになったときに再送できます。';
$string['cannotconnect'] = '接続できません：正しいURLを入力しているか、サイトのMoodleが2.4以降であることを確認してください。';
$string['cannotconnectssl'] = '接続できません：正しいURLを入力しているか、サイトのMoodleが2.4以降であること、SSL証明書が正当なものであることを確認してください。';
$string['cannotsendmessage'] = 'ネットワークがつながりません。メッセージはタスクキューに保存されており、オンラインになったときに再送できます。';
$string['chooseaccountuploadfile'] = 'ファイルをアップロードするアカウントの選択：';
$string['choosefile'] = 'ファイルの選択';
$string['city'] = '市町村';
$string['close'] = '閉じる';
$string['completed'] = '完了';
$string['confirmcontinuedownload'] = '本当にファイルのダウンロードを継続しますか？';
$string['confirmdeletetask'] = '本当にこのタスクを消去しますか？';
$string['confirmuploadfile'] = '{$a}をアップロードしようとしています。続けますか？';
$string['confirmuploadfiletosite'] = 'このファイルをサイト{$a}へアップロードしますか？';
$string['contact'] = 'コンタクト';
$string['contactadd'] = 'コンタクトがあなたの電話の連絡帳に追加されました。';
$string['contacts'] = 'コンタクト';
$string['content'] = 'コンテンツ';
$string['contents'] = 'コンテンツ';
$string['contentyetnotavailable'] = 'この活動はモバイル・アプリ経由では利用できません';
$string['continue'] = '継続';
$string['contributiontocoursetotal'] = 'コース全体に対する貢献';
$string['country'] = '国';
$string['course'] = 'コース';
$string['coursename'] = 'コース名';
$string['csssynced'] = '同期したリモートのCSS';
$string['cutoffdate'] = '最終提出期限';
$string['date'] = '日付';
$string['days'] = '日';
$string['delete'] = '消去';
$string['deletesite'] = 'このサイトを消去しますか？';
$string['deletesiteb'] = 'サイトの消去';
$string['deletesitefiles'] = '本当にこのサイトからダウンロードしたファイルを消去しますか？';
$string['description'] = '説明';
$string['details'] = '詳細';
$string['development'] = '開発';
$string['deviceinfo'] = 'デバイス情報';
$string['disabled'] = '無効';
$string['disablenotificationforevent'] = 'このイベントの通知を無効にする';
$string['disablenotifications'] = '通知を無効にする';
$string['disablerdebugger'] = 'リモートデバッグを無効にする';
$string['discussions'] = 'ディスカッション';
$string['docsurl'] = 'http://docs.moodle.org/en/Mobile_app';
$string['downloadremotefile'] = 'リモートファイルのダウンロード';
$string['downloadtime'] = 'ダウンロード日時';
$string['duedate'] = '締切日';
$string['duedateno'] = '締切日なし';
$string['email'] = 'Email';
$string['empty'] = '空白';
$string['enableautosync'] = '自動同期を有効にする';
$string['enableautosynccss'] = '追加CSSスタイルシートを同期する';
$string['enableautosynclang'] = '言語ファイルを同期する';
$string['enableautosyncws'] = '操作とデータを同期する';
$string['enablecss3transitions'] = 'CSS3 Transitionsを有効にする';
$string['enabledebugging'] = 'デバッグを有効にする';
$string['enableeventnotifications'] = 'イベント通知を有効にする';
$string['enablenotifications'] = '通知を有効にする';
$string['enablenotificationscheck'] = '<p>Moodleサイトがモバイル通知をサポートしているかを確認するには、まずMoodleサイトを開いて、管理 / マイプロファイル設定 / メッセージング の項目を開いてください。モバイル通知が有効ならば、モバイル通知の項目がチェックできるようになっているはずです。</p>';
$string['enablenotificationswarning'] = '<p>通知を有効にするため、Moodleサイトにあなたのモバイルデバイスのモデルやオペレーティングシステム等の情報を登録する必要があります。</p>';
$string['enablerdebugger'] = 'リモートデバッグを有効にする';
$string['enablesyncwifi'] = 'Wi-Fi環境でのみ同期する';
$string['error'] = 'エラー';
$string['errorcamera'] = 'カメラへのアクセスエラー';
$string['errorcameramsg'] = 'デバイスはカメラをサポートしていません';
$string['errorcapturingaudio'] = '音声キャプチャーのエラー';
$string['errorcapturingvideo'] = 'ビデオキャプチャーのエラー';
$string['errordownloading'] = 'ファイルのダウンロードのエラー';
$string['errorduringdevicetokenrequest'] = 'デバイストークン要求中のエラー';
$string['errorduringdevicetokenrequesttoapns'] = 'APNSへのデバイストークン要求中のエラー';
$string['errorlistingfiles'] = 'このディレクトリにあるファイル取得のエラー';
$string['errornoconnectednocache'] = '要求されたオプションを実行するためのデバイスが接続されておらず、キャッシュされた情報もありません';
$string['errorreadingfile'] = 'ファイル"{$a}"の読み取りエラー';
$string['errorreceivefilenosites'] = '登録されているサイトがありません。ファイルをアップロードする前にサイトを追加してください。';
$string['errorregisteringdeviceinmoodle'] = 'Moodleへのデバイス登録エラー';
$string['errorretrievinggradeinformation'] = '成績情報取得エラー';
$string['erroruploading'] = 'ファイルアップロードエラー';
$string['estimatedfreespace'] = '概算の空き容量';
$string['events'] = 'カレンダーイベント';
$string['feedback'] = 'フィードバック';
$string['file'] = 'ファイル';
$string['filedownloaded'] = 'ダウンロードしたファイル';
$string['filename'] = 'ファイル名';
$string['filesize'] = '大きさ';
$string['fileuploaded'] = 'アップロードしたファイル';
$string['fileuploadedwithname'] = 'ファイル名{$a}としてアップロードに成功しました。';
$string['fileurl'] = 'ファイルのURL';
$string['forcecsssync'] = 'いますぐCSS同期する';
$string['forceofflinemode'] = 'オフラインモードにする';
$string['forumnodiscussionsyet'] = 'このフォーラムにはまだディスカッショントピックがありません';
$string['forumnumreplies'] = '返信';
$string['frontpage'] = 'フロントページ';
$string['fullname'] = '氏名';
$string['general'] = '一般';
$string['grade'] = '成績';
$string['grades'] = '成績';
$string['groupeventsnotdisplayed'] = 'グループイベントは表示されません';
$string['help'] = 'ヘルプ';
$string['helpmelogin'] = '<p>世界中に無数のMoodleサイトが存在しますが、本アプリはモバイルアプリからのアクセスを有効にした特別なMoodleサイトでなければ接続できません。</p><p>あなたのMoodleサイトにアプリから接続できず、それをできるようにしてもらいたいときには、Moodleサイトの管理ユーザに<a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a>を読むよう依頼してみてください。</p><p>Moodleでもサイトでアプリをテストするには、<em>サイトURL</em>の欄に<i>teacher</i>あるいは<i>student</i>を入力し、<b>追加</b>ボタンを押してください。</p>';
$string['hours'] = '時間';
$string['icantlogin'] = 'ログインできません';
$string['imagestored'] = 'あなたの画像がプライベートエリアに保存されました。';
$string['info'] = '情報';
$string['initializing'] = '初期設定中...';
$string['invalidaccount'] = 'あなたがログインするのに必要な情報を再確認し、サイト管理者にサイトの設定と合致しているか確認するよう依頼してください。';
$string['invalidmoodleversion'] = 'Moodleのバージョンが古すぎます。少なくともこれより新しいMoodleである必要があります：';
$string['invalidscheme'] = '正しいサイトURLを入力してください。';
$string['invalidsite'] = 'サイトURLが正しくありません。';
$string['itemname'] = '評定項目';
$string['keepsynchronising'] = '投稿をサーバと同期し続ける';
$string['language'] = '言語';
$string['lettergrade'] = '評定の文字';
$string['license'] = 'ライセンス';
$string['loadcordovaemulator'] = 'Cordvaエミュレータをロード';
$string['loading'] = '読込中';
$string['localpath'] = 'ローカルパス';
$string['location'] = 'ロケーション';
$string['logininsiterequired'] = 'ブラウザウインドウからサイトにログインする必要があります。';
$string['logout'] = 'ログアウト';
$string['lostconnection'] = 'あなたのトークンが無効になったため、再接続に必要な情報がサーバにはありません。';
$string['manageaccounts'] = 'アカウントの設定';
$string['message'] = 'メッセージ';
$string['messages'] = 'メッセージ';
$string['messagesent'] = '送信したメッセージ';
$string['minutes'] = '分';
$string['mobileservicesnotenabled'] = 'あなたのサイトではモバイルサービスが有効になっていません。モバイルアクセスが必要と思うなら、あなたのMoodleサイト管理者にその相談をしてください。';
$string['modulename'] = 'モジュール名';
$string['months'] = '月';
$string['moodlehelp'] = 'ヘルプ';
$string['mycourses'] = 'マイコース';
$string['myfiles'] = 'マイファイル';
$string['name'] = '名称';
$string['networkerror'] = 'ネットワーク接続できません';
$string['networkerrormsg'] = 'ネットワークが無効もしくは機能していません';
$string['next'] = '次へ';
$string['no'] = 'いいえ';
$string['noevents'] = 'イベントはありません';
$string['nomessagesfound'] = 'メッセージは見つかりませんでした';
$string['norefreshdisconnected'] = 'リフレッシュオプションにはネットワーク接続が必要です';
$string['notaskstobesynchronized'] = '同期が必要なタスクはありません';
$string['noteadded'] = 'ノートが追加されました';
$string['noticelargefile'] = 'ダウンロードしようとしているこのファイルは大きいので、完了まで非常に時間がかかります。';
$string['notificationpreferencesnotconfigured'] = 'あなたはまだモバイル通知を設定していません。WebブラウザでMoodleサイトにログインし、ユーザプロフィールの下にあるメッセージの設定画面から設定してください。';
$string['notifications'] = '通知';
$string['notificationsdisabled'] = '通知は無効です';
$string['notificationsenabled'] = 'すべてのMoodleサイトに対して通知が有効です';
$string['nousersfound'] = 'ユーザは見つかりませんでした';
$string['offlinecontacts'] = 'オフラインのコンタクト ({$a})';
$string['offlinemode'] = 'オフラインモード';
$string['ok'] = 'はい';
$string['onlinecontacts'] = 'オフラインのコンタクト ({$a})';
$string['openinbrowser'] = 'ブラウザを開く';
$string['others'] = 'その他';
$string['participant'] = '参加者';
$string['participants'] = '参加者';
$string['password'] = 'パスワード';
$string['passwordlabel'] = 'パスワード';
$string['passwordnotnull'] = 'パスワードを入力してください';
$string['passwordrequired'] = 'パスワードがありません';
$string['percentage'] = 'パーセンテージ';
$string['phone1'] = '電話';
$string['phone2'] = '携帯電話';
$string['pluginname'] = 'Moodle Mobile言語文字列';
$string['preview'] = 'プレビュー';
$string['previous'] = '前へ';
$string['privatefiles'] = 'プライベートファイル';
$string['purgecaches'] = 'キャッシュの消去';
$string['range'] = '範囲';
$string['rank'] = 'ランク';
$string['rdebuggingenabledfor'] = 'この秒数後にリモートデバッグが有効になります：';
$string['readingfile'] = 'ファイル読み取り';
$string['record'] = '記録';
$string['recordaudio'] = '音声';
$string['recordstored'] = '記録があなたのプライベートエリアに保存されました';
$string['remotesystemnotconfiguredfornotifications'] = 'Moodleサイトがモバイル通知を送信するよう設定されていません。モバイル通知が必要と思うなら、あなたのMoodleサイト管理者に相談してください。';
$string['removecontact'] = 'コンタクトを削除';
$string['replay'] = '再生';
$string['reply'] = '返信';
$string['reportabug'] = 'バグを報告';
$string['reportbuginfo'] = '「バグを報告」ボタンをタップして説明を表示します。';
$string['reportbugurl'] = 'https://docs.moodle.org/en/Moodle_Mobile#How_to_report_a_bug';
$string['requiredfields'] = '必須フィールドはすべて記入してください。';
$string['reset'] = 'リセット';
$string['resetapp'] = 'アプリのリセット';
$string['save'] = '保存';
$string['saving'] = '保存中...';
$string['seconds'] = '秒';
$string['select'] = '選択';
$string['selectsite'] = 'サイトの選択';
$string['send'] = '送信';
$string['sendall'] = 'すべて送信';
$string['sendmessage'] = 'メッセージ送信';
$string['sendnow'] = 'いますぐ送信';
$string['settings'] = '設定';
$string['showall'] = 'すべて表示';
$string['showlog'] = 'ログを表示';
$string['showmore'] = 'もっと見る';
$string['siteexists'] = 'このサイトはすでに存在しています。';
$string['sitefiles'] = 'サイトファイル';
$string['siteinmaintenance'] = 'このサイトはメンテナンス中です';
$string['sitename'] = 'サイト名';
$string['sites'] = 'サイト';
$string['siteurl'] = 'サイトURL';
$string['siteurllabel'] = 'サイトRUL';
$string['siteurlrequired'] = 'サイトURLがありません。書き方は、例えば次の通りです：<i>http://www.yourmoodlesite.abc あるいは https://www.yourmoodlesite.efg</i>';
$string['spaceusage'] = '保存領域使用量';
$string['stop'] = '停止';
$string['strings'] = '文字列';
$string['submissions'] = '提出物';
$string['synchronization'] = '同期';
$string['syncthistasknow'] = 'このタスクをいますぐ同期';
$string['system'] = 'システム';
$string['takephoto'] = '写真を撮影';
$string['takepicture'] = 'カメラ';
$string['taskqueue'] = 'タスクキュー';
$string['therearentnotificationsyet'] = '通知はありません';
$string['threemonthsmore'] = '3ヶ月以上を表示';
$string['timecreated'] = '日付が追加されました';
$string['timeduration'] = '利用時間';
$string['timemodified'] = '最終更新';
$string['timestart'] = '開始時間';
$string['total'] = '総計';
$string['totalusage'] = '総使用量';
$string['type'] = '種類';
$string['unblockcontact'] = 'コンタクトのブロックを解除';
$string['unexpectederror'] = '不明なエラー。アプリを閉じて再起動してみてください。';
$string['update'] = 'アップデート';
$string['updatesite'] = 'サイトをアップデート';
$string['upload'] = 'アップロード';
$string['uploadfile'] = 'ファイルのアップロード';
$string['uploadfileinstructions'] = 'ファイルをアップロードするには、下のボタンをクリックしてアップロードするファイルを選択してください。';
$string['uploading'] = 'アップロード中';
$string['uploadingtoprivatefiles'] = 'プライベートファイルエリアへアップロード';
$string['uselocalmobileplugin'] = 'Moodleサイトにオプションのモバイルプラグインがインストールされていればこのページはよりうまく操作できます';
$string['userfrom'] = '差出人';
$string['username'] = 'ユーザー名';
$string['usernamelabel'] = 'ユーザー名';
$string['usernamerequired'] = 'ユーザー名がありません';
$string['video'] = 'ビデオ';
$string['videofilenameprefix'] = 'iphone_upload-video';
$string['videostored'] = 'ビデオはあなたのプライベートエリアに保存されました';
$string['view'] = '表示';
$string['viewableonthisapp'] = '本アプリで表示可能';
$string['viewsubmission'] = '提出物を表示';
$string['warning'] = '警告';
$string['webservicesnotenabled'] = 'あなたのサイトでWebサービスが有効になっていません。モバイルアクセスが必要と思うなら、あなたのMoodleサイト管理者に相談してください。';
$string['webservicesuccessfullyexecuted'] = 'Webサービスが正常に実行されました';
$string['website'] = 'ウェブサイト';
$string['weight'] = '重み';
$string['welcome'] = 'Moodle Mobileアプリへようこそ';
$string['writeherethebug'] = 'ここに生じた問題についての詳細な説明を記入してください';
$string['years'] = '年';
$string['yes'] = 'はい';
$string['youarein'] = 'カレントフォルダ：';
$string['yourpassword'] = 'パスワード';
$string['yoursiteurl'] = 'https://yourmoodle.com';
$string['yourusername'] = 'ユーザ名';
