<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'zal geïnstalleerd worden';
$string['action'] = 'Actie';
$string['actionchoice'] = 'Wat wil je doen met het bestand \'{$a}\'?';
$string['actions'] = 'Acties';
$string['active'] = 'Actief';
$string['activeusers'] = 'Actieve gebruikers';
$string['activities'] = 'Activiteiten';
$string['activities_help'] = 'Met activiteiten zoals forums, testen en wiki\'s kun je interactieve inhoud aan je cursus toevoegen.';
$string['activity'] = 'Activiteit';
$string['activityclipboard'] = 'Deze activiteit aan het verplaatsen: {$a}';
$string['activityiscurrentlyhidden'] = 'Sorry, deze activiteit is nu verborgen';
$string['activitymodule'] = 'Activiteitenmodule';
$string['activitymodules'] = 'Activiteitenmodules';
$string['activityreport'] = 'Activiteitenrapport';
$string['activityreports'] = 'Activiteitenrapporten';
$string['activityselect'] = 'Selecteer deze activiteit om ze te verplaatsen';
$string['activitysince'] = 'Activiteit sinds {$a}';
$string['activityweighted'] = 'Activiteit per gebruiker';
$string['add'] = 'Voeg toe';
$string['addactivity'] = 'Activiteit toevoegen';
$string['addactivitytosection'] = 'Voeg een activiteit toe aan sectie \'{$a}\'';
$string['addadmin'] = 'Voeg beheerder toe';
$string['addblock'] = 'Blok toevoegen';
$string['addcomment'] = 'Notitie toevoegen';
$string['addcountertousername'] = 'Gebruiker toevoegen door een getal achter de gebruikersnaam te zetten';
$string['addcreator'] = 'Voeg een cursus-aanmaker toe';
$string['adddots'] = 'Voeg toe...';
$string['added'] = '{$a} toegevoegd';
$string['addedrecip'] = '{$a} nieuwe ontvanger toegevoegd';
$string['addedrecips'] = '{$a} nieuwe ontvangers toegevoegd';
$string['addedtogroup'] = 'Toegevoegd aan groep {$a}';
$string['addedtogroupnot'] = 'Niet toegevoegd aan groep {$a}';
$string['addedtogroupnotenrolled'] = 'Niet toegevoegd aan groep {$a}, omdat die niet aangemeld is in deze cursus';
$string['addfilehere'] = 'Bestand(en) hier toevoegen';
$string['addinganew'] = 'Een nieuwe {$a} toevoegen';
$string['addinganewto'] = 'Een nieuwe {$a->what} aan {$a->to} toevoegen';
$string['addingdatatoexisting'] = 'Gegevens toevoegen aan bestaande';
$string['additionalnames'] = 'Extra namen';
$string['addlinkhere'] = 'Link hier toevoegen';
$string['addnewcategory'] = 'Voeg een nieuwe categorie toe';
$string['addnewcourse'] = 'Voeg een nieuwe cursus toe';
$string['addnewuser'] = 'Toevoegen';
$string['addnousersrecip'] = 'Voeg gebruikers aan de ontvangerslijst toe die deze {$a} nog niet bezocht hebben';
$string['addpagehere'] = 'Tekst hier toevoegen';
$string['addresource'] = 'Bron toevoegen';
$string['addresourceoractivity'] = 'Activiteit of bron toevoegen';
$string['addresourcetosection'] = 'Voeg een bron toe aan sectie \'{$a}\'';
$string['address'] = 'Adres';
$string['addstudent'] = 'Voeg een leerling toe';
$string['addsubcategory'] = 'Voeg subcategorie toe';
$string['addteacher'] = 'Voeg een leraar toe';
$string['admin'] = 'Beheer';
$string['adminhelpaddnewuser'] = 'Handmatig een nieuwe account aanmaken';
$string['adminhelpassignadmins'] = 'Beheerders kennen geen beperkingen en hebben overal toegang binnen de site';
$string['adminhelpassigncreators'] = 'Cursus-aanmakers kunnen nieuwe cursussen aanmaken';
$string['adminhelpassignsiteroles'] = 'Gedefinieerde rollen toepassen op specifieke gebruikers';
$string['adminhelpassignstudents'] = 'Ga naar een cursus en voeg leerlingen toe door middel van het beheerdersmenu';
$string['adminhelpauthentication'] = 'Je kunt interne gebruikeraccounts of externe databases gebruiken';
$string['adminhelpbackup'] = 'Configureer hoe de back-ups werken';
$string['adminhelpconfiguration'] = 'Stel in hoe de site er uitziet  en werkt';
$string['adminhelpconfigvariables'] = 'Stel variabelen in die het algemene werken van de site beïnvloeden';
$string['adminhelpcourses'] = 'Definieer cursussen en cursuscategorieën en voeg mensen aan de cursussen toe';
$string['adminhelpeditorsettings'] = 'Definiëer basisinstellingen voor de HTML-editor';
$string['adminhelpedituser'] = 'Bekijk de lijst met gebruikersaccounts en bewerk de accounts';
$string['adminhelpenvironment'] = 'Controleer of je server voldoet aan de systeemvereisten';
$string['adminhelpfailurelogs'] = 'Blader door de logs van mislukte aanmeldingen';
$string['adminhelplanguage'] = 'Voor het controleren en bewerken van het huidige taalpakket';
$string['adminhelplogs'] = 'Bekijk de logs van alle activiteiten op deze site';
$string['adminhelpmanageblocks'] = 'Beheer de geïnstalleerde blokken en hun instellingen';
$string['adminhelpmanagedatabase'] = 'Gebruik/beheer de database op directe wijze (voorzichtig!)';
$string['adminhelpmanagefilters'] = 'Kies tekstfilters en daarmee samenhangende instellingen';
$string['adminhelpmanagemodules'] = 'Beheer de geïnstalleerde modules en hun instellingen';
$string['adminhelpmanageroles'] = 'Definieer rollen die toegepast kunnen worden op gebruikers';
$string['adminhelpmymoodle'] = 'Configureer het blok Mijn Moodle voor de gebruikers';
$string['adminhelpreports'] = 'Rapporten op site-niveau';
$string['adminhelpsitefiles'] = 'Voor het publiceren van algemene bestanden of het uploaden van externe back-ups';
$string['adminhelpsitesettings'] = 'Definieer hoe de voorpagina van de site eruit ziet';
$string['adminhelpstickyblocks'] = 'Configureer permanent zichtbare blokken in heel Moodle';
$string['adminhelpthemes'] = 'Kies hoe de site eruit ziet (kleuren, lettertypen, etc.)';
$string['adminhelpuploadusers'] = 'Importeer nieuwe gebruikersaccounts vanuit een tekstbestand';
$string['adminhelpusers'] = 'Definieer je gebruikers en stel de authenticatie in';
$string['adminhelpxmldbeditor'] = 'Interface om de XMLDB-bestanden te bewerken. Enkel voor ontwikkelaars';
$string['administration'] = 'Beheer';
$string['administrationsite'] = 'Sitebeheer';
$string['administrator'] = 'Beheerder';
$string['administratordescription'] = 'Beheerders kunnen gewoonlijk op de hele site alles doen, in alle cursussen.';
$string['administrators'] = 'Beheerders';
$string['administratorsall'] = 'Alle beheerders';
$string['administratorsandteachers'] = 'Beheerders en leraren';
$string['advanced'] = 'Geavanceerd';
$string['advancedfilter'] = 'Geavanceerd zoeken';
$string['advancedsettings'] = 'Geavanceerde instellingen';
$string['afterresource'] = 'Na "{$a}"';
$string['aftersection'] = 'Na sectie "{$a}"';
$string['again'] = 'nogmaals';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX en Javascript';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle acties';
$string['allactivities'] = 'Alle activiteiten';
$string['allcategories'] = 'Alle categorieën';
$string['allchanges'] = 'Alle wijzigingen';
$string['alldays'] = 'Alle dagen';
$string['allfieldsrequired'] = 'Alle velden zijn verplicht';
$string['allfiles'] = 'Alle bestanden';
$string['allgroups'] = 'Alle groepen';
$string['alllogs'] = 'Alle logs';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Sta toe';
$string['allowinternal'] = 'Laat interne methodes ook toe';
$string['allownone'] = 'Laat niemand toe';
$string['allownot'] = 'Sta niet toe';
$string['allparticipants'] = 'Alle deelnemers';
$string['allteachers'] = 'Alle leraren';
$string['alphanumerical'] = 'Mag alleen maar alphanummerieke tekens, liggend streepje (-) of punt (.) bevatten';
$string['alreadyconfirmed'] = 'De registratie is al bevestigd';
$string['alternatename'] = 'Alternatieve naam';
$string['always'] = 'Altijd';
$string['and'] = '{$a->one} en {$a->two}';
$string['answer'] = 'Antwoord';
$string['any'] = 'Alle';
$string['appearance'] = 'Verschijnen';
$string['approve'] = 'Keur goed';
$string['areyousure'] = 'Weet je het zeker?';
$string['areyousuretorestorethis'] = 'Ben je er zeker van dat je dit wil terugzetten?';
$string['areyousuretorestorethisinfo'] = 'Op een later moment in dit proces heb je de keuze om deze back-up toe te voegen aan een bestaand cursus of om een compleet nieuwe cursus aan te maken.';
$string['asc'] = 'oplopend';
$string['assessment'] = 'Beoordeling';
$string['assignadmins'] = 'Wijs beheerders aan';
$string['assigncreators'] = 'Wijs cursus-aanmakers aan';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Site rollen toewijzen';
$string['authenticateduser'] = 'Geauthenticeerde gebruiker';
$string['authenticateduserdescription'] = 'Alle aangemelde gebruikers.';
$string['authentication'] = 'Authenticatie';
$string['authenticationplugins'] = 'Authenticatie-plugins';
$string['autosubscribe'] = 'Automatisch inschrijven op het forum';
$string['autosubscribeno'] = 'Neen: schrijf me niet automatisch in op forums';
$string['autosubscribeyes'] = 'Ja: schrijf me automatisch in op forums wanneer ik er een bericht in post';
$string['availability'] = 'Beschikbaarheid';
$string['availablecourses'] = 'Beschikbare cursussen';
$string['back'] = 'Terug';
$string['backto'] = 'Terug naar {$a}';
$string['backtocourselisting'] = 'Terug naar cursuslijst';
$string['backtopageyouwereon'] = 'Terug naar vorige pagina';
$string['backtoparticipants'] = 'Terug naar deelnemerslijst';
$string['backup'] = 'Back-up';
$string['backupactivehelp'] = 'Automatische back-ups gebruiken?';
$string['backupcancelled'] = 'Back-up geannuleerd';
$string['backupcoursefileshelp'] = 'Selecteer als je de bestanden van de cursus in de back-up wil';
$string['backupdate'] = 'Datum back-up';
$string['backupdatenew'] = '{$a->TAG} is nu {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} was {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Details van de back-up';
$string['backupexecuteathelp'] = 'Starttijd automatische back-ups';
$string['backupfailed'] = 'Sommige cursussen zijn niet bewaard!';
$string['backupfilename'] = 'back-up';
$string['backupfinished'] = 'De back-up is succesvol afgerond';
$string['backupfromthissite'] = 'Was de back-up op deze site gemaakt?';
$string['backupgradebookhistoryhelp'] = 'Indien ingeschakeld zal de geschiedenis van de cijferlijst meegenomen worden in de automatische back-ups. Merk op dat cijfergeschiedenis niet mag uitgeschakeld zijn in de serverinstellingen om dit te laten werken';
$string['backupincludemoduleshelp'] = 'Selecteer als je cursusmodules met of zonder gebruikersgegevens in de back-up wil';
$string['backupincludemoduleuserdatahelp'] = 'Gebruikersdata aan automatische back-ups toevoegen?';
$string['backupkeephelp'] = 'Hoeveel recente back-ups wil je houden voor elke cursus? (oudere zullen automatisch verwijderd worden)';
$string['backuplogdetailed'] = 'Gedetailleerde log van de bewerking';
$string['backuploglaststatus'] = 'Laatste log van de bewerking';
$string['backupmissinguserinfoperms'] = 'Opmerking: deze back-up bevat geen gebruikersgegevens. Oefening en Workshop-activiteiten zullen niet in de back-up zitten omdat dieze modules niet compatibel zijn met dit type back-up.';
$string['backupnext'] = 'Volgende back-up';
$string['backupnonisowarning'] = 'Waarschuwing: deze back-up is er één van een niet-unicodeversie van Moodle (voor 1.6). Als deze back-up andere dan ISO-8859-1 teksten bevat, dan kunnen deze CORRUPT worden als je ze probeert in een unicode versie van Moodle terug te zetten. Zie de <a href="http://docs.moodle.org/en/Backup_FAQ">Back-up FAQ</a> voor meer informatie over hoe je deze back-up wel kunt terugzetten.';
$string['backupnotyetrun'] = 'Automatiche backup bezig';
$string['backuporiginalname'] = 'Naam back-up';
$string['backuproleassignments'] = 'Back-up de roltoewijzingen voor deze rollen';
$string['backupsavetohelp'] = 'Volledig pad naar de map waar je de back-upbestanden wil bewaren<br />(laat blanco als je ze in de standaardmap van de cursus wil bewaren)';
$string['backupsitefileshelp'] = 'Indien ingeschakeld worden site-bestanden die in cursussen gebruikt worden mee in de automatische back-ups opgenomen.';
$string['backuptakealook'] = 'Controleer je back-uplogs op:
{$a}';
$string['backupuserfileshelp'] = 'Selecteer als je gebruikersbestanden in de back-up wil';
$string['backupversion'] = 'Back-upversie';
$string['badges'] = 'Badges';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Een {$a} blok configureren';
$string['blockconfigbad'] = 'Dit blok is niet juist geïmplementeerd en kan dus geen configuratie-interface tonen. Cursus:';
$string['blocks'] = 'Blokken';
$string['blocksaddedit'] = 'Blokken toevoegen/bewerken';
$string['blockseditoff'] = 'Blokken bewerken uitschakelen';
$string['blocksediton'] = 'Blokken bewerken inschakelen';
$string['blocksetup'] = 'Installeren van de tabellen voor blokken';
$string['blocksuccess'] = '{$a} tabellen zijn juist geïnstalleerd';
$string['brief'] = 'Kort';
$string['bulkactions'] = 'Bulk-acties';
$string['bulkactionselect'] = '{$a} bulkactie selectie';
$string['bulkmovecoursessuccess'] = '{$a->courses} cursussen verplaatst naar {$a->category}';
$string['bycourseorder'] = 'In volgorde van de cursus';
$string['byname'] = 'volgens {$a}';
$string['bypassed'] = 'Omzeild';
$string['cachecontrols'] = 'Cache controles';
$string['cancel'] = 'Annuleer';
$string['cancelled'] = 'Geannuleerd';
$string['categories'] = 'Cursuscategorieën';
$string['categoriesandcoures'] = 'Cursuscategorieën en cursussen';
$string['category'] = 'Categorie';
$string['categoryadded'] = 'De categorie \'{$a}\'  werd toegevoegd';
$string['categorybulkaction'] = 'Bulkacties voor geselecteerde categorieën';
$string['categorycontents'] = 'Subcategorieën en cursussen';
$string['categorycurrentcontents'] = 'Inhoud van {$a}';
$string['categorydeleted'] = 'De categorie \'{$a}\'  werd verwijderd';
$string['categoryduplicate'] = 'Er bestaat al een categorie met de naam \'{$a}\'!';
$string['categorymodifiedcancel'] = 'Categorie gewijzigd! Annuleer en probeer opnieuw.';
$string['categoryname'] = 'Categorienaam';
$string['categorysubcategoryof'] = '{$a->category} - subcategorie van {$a->parentcategory}';
$string['categoryupdated'] = 'De categorie \'{$a}\' is aangepast';
$string['changedpassword'] = 'Het wachtwoord is veranderd';
$string['changepassword'] = 'Verander wachtwoord';
$string['changesmadereallygoaway'] = 'Je hebt dingen gewijzigd. Weet je zeker dat je van deze pagina weg wil navigeren en je wijzigingen verliezen?';
$string['changessaved'] = 'De veranderingen zijn bewaard';
$string['check'] = 'Controleer';
$string['checkall'] = 'Selecteer alles';
$string['checkingbackup'] = 'Back-up controleren';
$string['checkingcourse'] = 'Cursus controleren';
$string['checkingforbbexport'] = 'Controleren voor export naar BlackBoard';
$string['checkinginstances'] = 'Exemplaren controleren';
$string['checkingsections'] = 'Secties controleren';
$string['checklanguage'] = 'Controleer taal';
$string['checknone'] = 'Annuleer selectie';
$string['childcoursenotfound'] = 'Onderliggende cursus niet gevonden!';
$string['childcourses'] = 'Onderliggende cursussen';
$string['choose'] = 'Kies';
$string['choosecourse'] = 'Kies een cursus';
$string['choosedots'] = 'Kies...';
$string['chooselivelogs'] = 'Of bekijk de huidige activiteit';
$string['chooselogs'] = 'Kies welke logs je wilt zien';
$string['choosereportfilter'] = 'Kies een filter voor het rapport';
$string['choosetheme'] = 'Kies een thema';
$string['chooseuser'] = 'Kies een gebruiker';
$string['city'] = 'Plaats';
$string['clambroken'] = 'Je beheerder heeft viruscontrole voor geüploade bestanden ingeschakeld, maar heeft iets fout geconfigureerd.<br />Je bestand is NIET geüpload. Er is een e-mail naar je beheerder gestuurd om hem te waarschuwen, zodat hij het kan herstellen.<br />Misschien moet je later nog eens proberen dit bestand te uploaden.';
$string['clamdeletedfile'] = 'Dit bestand is verwijderd';
$string['clamdeletedfilefailed'] = 'Dit bestand kon niet verwijderd worden';
$string['clamemailsubject'] = '{$a}:: Clam AV-melding';
$string['clamfailed'] = 'Clam AV is vastgelopen. De foutmelding was {$a}. Hier is de melding van Clam:';
$string['clamlost'] = 'Moodle is geconfigureerd om Clam te gebruiken voor bestandsupload, maar het pad naar Clam AV, {$a}, was niet juist.';
$string['clamlostandactinglikevirus'] = 'Moodle is zo geconfigureerd dat, wanneer Clam niet werkt, alle bestanden als virussen behandeld worden. Dit heeft natuurlijk als gevolg dat geen enkele leerling bestanden kan uploaden tot je dit hersteld hebt';
$string['clammovedfile'] = 'Het bestand is naar je quarantainemap verplaatst. De nieuwe locatie is {$a}';
$string['clammovedfilebasic'] = 'Het bestand is in de quarantainemap gezet';
$string['clamquarantinedirfailed'] = 'Het bestand kon niet naar de quarantainemap, {$a}, verplaatst worden. Je moet dit herstellen want de bestanden die als besmet beschouwdworden, worden verwijderd.';
$string['clamunknownerror'] = 'Er was een onbekende fout met clam.';
$string['cleaningtempdata'] = 'Schoon de tijdelijke data op';
$string['clear'] = 'Wis';
$string['clickhelpiconformoreinfo'] = '... gaat verder ... Klik op het helpicoontje om het volledige artikel te lezen';
$string['clickhere'] = 'Klik hier...';
$string['clicktochangeinbrackets'] = '{$a} (Klik om te wijzigen)';
$string['clicktohideshow'] = 'Klik om te vergroten of te verkleinen';
$string['closebuttontitle'] = 'Sluit';
$string['closewindow'] = 'Sluit dit venster';
$string['collapse'] = 'Samenklappen';
$string['collapseall'] = 'Alles samenklappen';
$string['collapsecategory'] = '{$a} samenklappen';
$string['commentincontext'] = 'Zoek deze notitie in haar context';
$string['comments'] = 'Notities';
$string['commentsnotenabled'] = 'commentaarfunctie niet ingeschakeld';
$string['commentsrequirelogin'] = 'Je moet aangemeld zijn om commentaren te zien';
$string['comparelanguage'] = 'Vergelijk en bewerk huidige taal';
$string['complete'] = 'Voltooid';
$string['completereport'] = 'Volledig rapport';
$string['configuration'] = 'Configuratie';
$string['confirm'] = 'Bevestig';
$string['confirmcheckfull'] = 'Ben je zeker dat je {$a} wil bevestigen?';
$string['confirmcoursemove'] = 'Weet je zeker dat je cursus ({$a->course}) naar categorie ({$a->category}) wil verplaatsen?';
$string['confirmed'] = 'Je registratie is bevestigd';
$string['confirmednot'] = 'Je registratie is nog niet bevestigd !';
$string['content'] = 'Inhoud';
$string['continue'] = 'Ga door';
$string['continuetocourse'] = 'Klik hier om je cursus binnen te gaan';
$string['convertingwikitomarkdown'] = 'Wiki naar Markdown aan het converteren';
$string['cookiesenabled'] = 'Cookies moeten aanstaan in je browser';
$string['cookiesenabled_help'] = '<p>Deze site gebruikt twee cookies.</p>

<p>De essentiële cookie is de \'session cookie\', meestal heet deze <b>MoodleSession</b>. Je moet deze cookie in je
browser toestaan om continuïteit en het behouden van je login van pagina naar pagina te garanderen. Als je uitlogt of de
browser afsluit dan wordt deze cookie verwijderd (binnen de browser en op de server).</p>

<p>De andere cookie is er alleen maar voor het gemak. Meestal heet deze iets als <b>MOODLEID</b>. Deze onthoudt slechts
je gebruikersnaam binnen de browser. Deze cookie zorgt ervoor dat wanneer je terugkomt op deze site het veld met de gebruikersnaam ingevuld op
de inlogpagina staat. Het is veilig om deze cookie te weigeren - je zult dan elke keer je gebruikersnaam opnieuw moeten
 intypen.</p>';
$string['cookiesnotenabled'] = 'Het gebruik van cookies is door je browser niet toegelaten. Met deze instelling kun je deze site niet gebruiken.';
$string['copy'] = 'Kopie';
$string['copyasnoun'] = 'Kopie';
$string['copyingcoursefiles'] = 'Cursusbestanden kopiëren';
$string['copyingsitefiles'] = 'Site-bestanden, gebruikt in cursussen aan het kopieëren';
$string['copyinguserfiles'] = 'Gebruikersbestanden kopiëren';
$string['copyingzipfile'] = 'ZIP-bestanden kopiëren';
$string['copyrightnotice'] = 'Auteursrechtenverklaring';
$string['coresystem'] = 'Systeem';
$string['cost'] = 'Prijs';
$string['costdefault'] = 'Standaardprijs';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Cursus';
$string['courseadministration'] = 'Cursusbeheer';
$string['courseapprovedemail'] = 'De cursus {$a->name} die je vroeg, is goedgekeurd en je bent er als {$a->teacher} aangewezen. Om je nieuwe cursus te openen, ga je naar {$a->url}';
$string['courseapprovedemail2'] = 'Je aangevraagde cursus, {$a->name}, is goedgekeurd. Volg de link {$a->url} om je cursus binnen te gaan';
$string['courseapprovedfailed'] = 'Het goedkeuren van deze cursus is mislukt!';
$string['courseapprovedsubject'] = 'Je cursus is goedgekeurd';
$string['courseavailable'] = 'Deze cursus is zichtbaar';
$string['courseavailablenot'] = 'Deze cursus is niet zichtbaar';
$string['coursebackup'] = 'Back-up  van cursussen';
$string['coursebulkaction'] = 'Bulkacties voor geselecteerde cursussen';
$string['coursecategories'] = 'Cursuscategorieën';
$string['coursecategory'] = 'Cursuscategorie';
$string['coursecategorydeleted'] = 'Verwijder cursuscategorie {$a}';
$string['coursecategory_help'] = 'Deze instelling bepaalt de categorie waarin je cursus verschijnt in de cursussenlijst.';
$string['coursecatmanagement'] = 'Cursus- en categoriebeheer';
$string['coursecompletion'] = 'Cursus voltooien';
$string['coursecompletions'] = 'Cursus voltooien';
$string['coursecreators'] = 'Cursus-aanmakers';
$string['coursecreatorsdescription'] = 'Cursusaanmakers kunnen nieuwe cursussen aanmaken.';
$string['coursedeleted'] = 'Verwijder cursus {$a}';
$string['coursedisplay'] = 'Cursus-layout';
$string['coursedisplay_help'] = 'Deze instelling bepaalt of de hele cursus wordt getoond op één pagina of opgesplitst over meerdere pagina\'s.';
$string['coursedisplay_multi'] = 'Toon één sectie per pagina';
$string['coursedisplay_single'] = 'Toon alle secties op één pagina';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Verouderde cursusbestanden';
$string['coursefilesedit'] = 'Bewerk verouderde cursusbestanden';
$string['coursefileswarning'] = 'Cursusbestanden worden niet meer ondersteund';
$string['coursefileswarning_help'] = 'Vanaf Moodle 2.0 worden cursusbestanden niet meer ondersteund. Gebruik externe opslagruimtes hiervoor.';
$string['courseformatdata'] = 'Gegevens cursusindeling';
$string['courseformatoptions'] = 'Opmaakopties voor {$a}';
$string['courseformats'] = 'Cursusindelingen';
$string['courseformatudpate'] = 'Opmaak aanpassen';
$string['coursegrades'] = 'Cursuscijfers';
$string['coursehelpcategory'] = 'Plaatst de cursus in de cursuslijst en maakt die zo gemakkelijker te vinden voor leerlingen';
$string['coursehelpforce'] = 'Verplicht de groepmodus voor elke activiteit in de cursus.';
$string['coursehelpformat'] = 'De hoofdpagina van de cursus zal in deze format getoond worden.';
$string['coursehelphiddensections'] = 'Hoe de verborgen secties van een cursus aan leerlingen getoond worden.';
$string['coursehelpmaximumupload'] = 'Bepaal de maximale grootte van een bestand dat binnen een cursus kan geüpload worden (beperkt door de site instelling).';
$string['coursehelpnewsitemsnumber'] = 'Aantal recente items die getoond worden op de startpagina van de cursus in een nieuwsblok. Als je dit op nul zet, verschijnt het nieuwsblok niet.';
$string['coursehelpnumberweeks'] = 'Aantal secties in de cursus (geldt enkel voor sommige cursusformaten).';
$string['coursehelpshowgrades'] = 'Schakelt het tonen van de cijferlijst in. Dit verhindert niet dat cijfers getoond worden binnen de afzonderlijke activiteiten.';
$string['coursehidden'] = 'Deze cursus is nu niet beschikbaar voor leerlingen';
$string['courseinfo'] = 'Cursusinformatie';
$string['courselegacyfiles'] = 'Verouderde cursusbestanden';
$string['courselegacyfiles_help'] = 'De cursusbestandenzone geeft wat terugwaartse compatibiliteit met Moodle 1.9 en vroeger. Alle bestanden in deze zone zijn altijd toegankelijk voor alle deelnemers van de cursus, of je ze nu linkt of niet, en er is geen manier om te weten te komen of deze bestanden gebruikt worden binnen Moodle of niet.

Als je ze gebruikt binnen Moodle, dan stel je jezelf bloot aan een reeks beveiligings- en privacy-problemen en bijkomend problemen met ontbrekende bestanden in back-ups of bij het uitwisselen en hergebruiken van cursussen. Daarom kun je deze zone  beter niet gebruiken, tenzij je goed weet wat je doet.';
$string['courselegacyfilesofcourse'] = 'Oude cursusbestanden: {$a}';
$string['coursemessage'] = 'Bericht voor de gebruikers van de cursus';
$string['coursenotaccessible'] = 'Deze cursus is niet publiek toegankelijk';
$string['courseoverview'] = 'Cursusoverzicht';
$string['courseoverviewfiles'] = 'Cursus samenvattingsbestanden';
$string['courseoverviewfilesext'] = 'Cursussamenvattingsbestandsextenties';
$string['courseoverviewfiles_help'] = 'Cursussamenvattingsbestanden, zoals afbeeldingen, worden in de lijst met cursussen getoond, samen met de samenvatting.';
$string['courseoverviewfileslimit'] = 'Limiet cursussamenvattingsbestanden';
$string['courseoverviewgraph'] = 'Grafiek cursusoverzicht';
$string['courseprofiles'] = 'Cursusprofielen';
$string['coursereasonforrejecting'] = 'Jouw reden om de aanvraag te verwerpen';
$string['coursereasonforrejectingemail'] = 'Dit zal via e-mail naar de aanvrager verstuurd worden';
$string['coursereject'] = 'Verwerp een cursusaanvraag';
$string['courserejected'] = 'De cursusaanvraag is niet goedgekeurd en de aanvrager is daarvan op de hoogte gebracht.';
$string['courserejectemail'] = 'Sorry, maar je aanvraag voor een nieuwe cursus, is niet goedgekeurd. De opgegeven reden is:

{$a}';
$string['courserejectreason'] = 'Motiveer hier waarom je deze cursus niet goedkeurt<br />(die tekst zal naar de aanvrager via e-mail verstuurd worden)';
$string['courserejectsubject'] = 'Je cursus is niet goedgekeurd';
$string['coursereport'] = 'cursusrapport';
$string['coursereports'] = 'Cursusrapporten';
$string['courserequest'] = 'Nieuwe cursus aanvragen';
$string['courserequestdetails'] = 'Details van je gevraagde cursus';
$string['courserequestfailed'] = 'Door een onbekende fout kon je aanvraag voor een nieuwe cursus niet bewaard worden.';
$string['courserequestintro'] = 'Gebruik dit formulier om je site-beheerders te vragen een nieuwe cursus te maken.<br />Probeer zo veel mogelijk informatie te geven, zodat de site-beheerders begrijpen waarom je deze nieuwe cursus zou willen.';
$string['courserequestreason'] = 'Motiveer je aanvraag voor een nieuwe cursus';
$string['courserequestsuccess'] = 'Je aanvraag voor een nieuwe cursus is bewaard. Je kunt binnen enkele dagen een e-mail verwachten met een antwoord op je vraag';
$string['courserequestsupport'] = 'Meer informatie die de beheerder helpt met het evalueren van deze aanvraag';
$string['courserestore'] = 'Back-up van cursussen terugzetten';
$string['courses'] = 'Cursussen';
$string['coursesectionsummaries'] = 'Cursus sectiesamenvattingen';
$string['coursesettings'] = 'Standaardinstellingen van de cursus';
$string['coursesmovedout'] = 'Cursussen verplaatst uit {$a}';
$string['coursespending'] = 'Cursussen die wachten om goedgekeurd te worden';
$string['coursestart'] = 'Cursus start';
$string['coursesummary'] = 'Samenvatting cursus';
$string['coursesummary_help'] = 'De samenvatting van de cursus wordt getoond in de lijst met cursussen. Wanneer je naar een cursus zoekt, wordt de samenvattingstekst mee doorzocht met de cursusnamen.';
$string['courseupdates'] = 'Cursusupdates';
$string['create'] = 'Maak';
$string['createaccount'] = 'Maak mijn nieuwe account aan';
$string['createcategory'] = 'Maak een categorie';
$string['createfolder'] = 'Maak een map in {$a}';
$string['createnew'] = 'Maak nieuw';
$string['createnewcategory'] = 'Maak een nieuwe categorie';
$string['createnewcourse'] = 'Maak een nieuwe cursus';
$string['createnewsubcategory'] = 'Maak een nieuwe subcategorie';
$string['createsubcategoryof'] = 'Maak een subcategorie van {$a}';
$string['createuser'] = 'Maak gebruiker';
$string['createuserandpass'] = 'Kies een gebruikersnaam en wachtwoord';
$string['createziparchive'] = 'Maak een ZIP-archief';
$string['creatingblocks'] = 'Blokken maken';
$string['creatingblocksroles'] = 'Roltoewijzingen en overschrijvingen aan het maken op blokniveau.';
$string['creatingblogsinfo'] = 'Bloginfo aanmaken';
$string['creatingcategoriesandquestions'] = 'Categorieën en vragen maken';
$string['creatingcoursemodules'] = 'Cursusmodules maken';
$string['creatingcourseroles'] = 'Roltoewijzingen en overschrijvingen aan het maken op cursusniveau.';
$string['creatingevents'] = 'Gebeurtenissen maken';
$string['creatinggradebook'] = 'Cijferlijst maken';
$string['creatinggroupings'] = 'Maak groeperingen';
$string['creatinggroupingsgroups'] = 'Groepen in groeperingen aan het toevoegen';
$string['creatinggroups'] = 'Groepen maken';
$string['creatinglogentries'] = 'Loginvoer maken';
$string['creatingmessagesinfo'] = 'Informatie voor berichten maken';
$string['creatingmodroles'] = 'Roltoewijzingen en overschrijvingen aan het maken op moduleniveau.';
$string['creatingnewcourse'] = 'Nieuwe cursus maken';
$string['creatingrolesdefinitions'] = 'Roldefinities maken';
$string['creatingscales'] = 'Schalen maken';
$string['creatingsections'] = 'Secties maken';
$string['creatingtemporarystructures'] = 'Tijdelijke structuren maken';
$string['creatinguserroles'] = 'Roltoewijzingen en overschrijvingen aan het maken op gebruikersniveau.';
$string['creatingusers'] = 'Gebruikers maken';
$string['creatingxmlfile'] = 'XML-bestand maken';
$string['currency'] = 'Munteenheid';
$string['currentcourse'] = 'Huidige cursus';
$string['currentcourseadding'] = 'Huidige cursus, data toevoegen';
$string['currentcoursedeleting'] = 'Huidig cursus, het eerst verwijderen';
$string['currentlanguage'] = 'Huidige taal';
$string['currentlocaltime'] = 'Hoe laat is het nu bij jou? (instellen lokale tijd)';
$string['currentlyselectedusers'] = 'Geselecteerde gebruikers';
$string['currentpicture'] = 'Huidige foto';
$string['currentrelease'] = 'Informatie over de huidige release';
$string['currentversion'] = 'Huidige versie';
$string['databasechecking'] = 'De Moodledatabase van versie {$a->oldversion} naar versie {$a->newversion} aan het opwaarderen...';
$string['databaseperformance'] = 'Performantie van de databank';
$string['databasesetup'] = 'Klaarmaken van de database';
$string['databasesuccess'] = 'De database werd met succes opgewaardeerd';
$string['databaseupgradebackups'] = 'Back-upversie is nu {$a}';
$string['databaseupgradeblocks'] = 'De versie van de blokken is nu {$a}';
$string['databaseupgradegroups'] = 'Versie groepen is nu {$a}';
$string['databaseupgradelocal'] = 'Versie van de locale databankaanpassingen is nu {$a}';
$string['databaseupgrades'] = 'Opwaarderen van de database';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum gewijzigd';
$string['datemostrecentfirst'] = 'Datum - nieuwste eerst';
$string['datemostrecentlast'] = 'Datum - oudste eerst';
$string['day'] = 'dag';
$string['days'] = 'dagen';
$string['decodinginternallinks'] = 'Interne links decoderen';
$string['default'] = 'Standaard';
$string['defaultcoursestudent'] = 'Leerling';
$string['defaultcoursestudentdescription'] = 'Leerlingen hebben gewoonlijk minder rechten in een cursus';
$string['defaultcoursestudents'] = 'Leerlingen';
$string['defaultcoursesummary'] = 'Schrijf hier een korte en interessante paragraaf waarin wordt uitgelegd waarover deze cursus gaat';
$string['defaultcourseteacher'] = 'Leraar';
$string['defaultcourseteacherdescription'] = 'Leraren kunnen alles doen binnen hun cursus, ook het wijzigen van de activiteiten en het beoordelen van leerlingen';
$string['defaultcourseteachers'] = 'Leraren';
$string['defaulteditor'] = 'Standaard editor';
$string['delete'] = 'Verwijder';
$string['deleteablock'] = 'Verwijder een blok';
$string['deleteall'] = 'Verwijder alle';
$string['deleteallcannotundo'] = 'Verwijder alles - kan niet ongedaan gemaakt worden';
$string['deleteallcomments'] = 'Verwijder alle commentaren';
$string['deleteallratings'] = 'Verwijder alle beoordelingen';
$string['deletecategory'] = 'Verwijder  categorie {$a}';
$string['deletecategorycheck'] = 'Ben je er zeker van dat je heel de categorie <b>\'{$a}\'</b> wil verwijderen?<br /> Hierdoor zullen alle cursussen van die categorie verplaatst worden: indien mogelijk naar de bovenliggende categorie en indien niet mogelijk naar de categorie \'Diversen\'.';
$string['deletecategorycheck2'] = 'Als je deze categorie verwijderd, moet je kiezen wat je doe met de cursussen en de subcategorieën die ze bevat.';
$string['deletecategoryempty'] = 'Deze categorie is leeg';
$string['deletecheck'] = 'Verwijder {$a}?';
$string['deletecheckfiles'] = 'Weet je zeker dat je deze bestanden wilt verwijderen?';
$string['deletecheckfull'] = 'Weet je zeker dat je {$a} volledig wilt verwijderen?';
$string['deletechecktype'] = 'Weet je zeker dat je dit wil verwijderen: {$a->type}?';
$string['deletechecktypename'] = 'Weet je zeker dat je dit wil verwijderen: {$a->type} "{$a->name}"';
$string['deletecheckwarning'] = 'Je staat op het punt deze bestanden te verwijderen';
$string['deletecomment'] = 'Verwijder deze notitie';
$string['deletecompletely'] = 'Verwijder volledig';
$string['deletecourse'] = 'Verwijder een cursus';
$string['deletecoursecheck'] = 'Weet je zeker dat je deze cursus en alle gegevens die erin zitten volledig wilt verwijderen?';
$string['deleted'] = 'Verwijderd';
$string['deletedactivity'] = '{$a} verwijderd';
$string['deletedcourse'] = '{$a} is volledig verwijderd';
$string['deletednot'] = 'Kon {$a} niet verwijderen!';
$string['deletelogs'] = 'Verwijder logs';
$string['deleteselected'] = 'Verwijder geselecteerde';
$string['deleteselectedkey'] = 'Verwijder geselecteerde sleutel';
$string['deletingcourse'] = '{$a} verwijderen';
$string['deletingexistingcoursedata'] = 'Bestaande data van een cursus verwijderen';
$string['deletingolddata'] = 'Oude data verwijderen';
$string['department'] = 'Afdeling';
$string['desc'] = 'Aflopend';
$string['description'] = 'Beschrijving';
$string['deselectall'] = 'Niets selecteren';
$string['detailedless'] = 'Minder gedetailleerd';
$string['detailedmore'] = 'Meer gedetailleerd';
$string['directory'] = 'Map';
$string['disable'] = 'Schakel uit';
$string['disabledcomments'] = 'Notities zijn uitgeschakeld';
$string['displayingfirst'] = 'Alleen de eerste {$a->count} {$a->things} worden getoond.';
$string['displayingrecords'] = '{$a} records worden getoond';
$string['displayingusers'] = 'Gebruikers {$a->start} tot en met {$a->end} worden getoond';
$string['displayonpage'] = 'Toon op pagina';
$string['dndcourse'] = 'Je kunt deze cursus slepen om de sorteervolgorde te wijzigen of om hem in een andere categorie te plaatsen.';
$string['dndenabled_inbox'] = 'Je kunt bestanden toevoegen door ze te slepen en hier neer te zetten';
$string['dndnotsupported'] = 'Uploaden door slepen en neerzetten wordt niet ondersteund.';
$string['dndnotsupported_help'] = 'Je browser ondersteunt het uploaden met nslepen en neerzetten niet.<br />Deze functie is beschikbaar op alle recente versies van Chrome, Firefox en Safari en ook op Internet Explorer 10 en hoger.';
$string['dndnotsupported_insentence'] = 'Slepen en neerzetten wordt niet ondersteund.';
$string['dnduploadwithoutcontent'] = 'Deze upload heeft geen inhoud';
$string['dndworkingfile'] = 'Bestanden slepen en neerzetten op cursussecties om ze te uploaden';
$string['dndworkingfilelink'] = 'Bestanden of links slepen en neerzetten op cursussecties om ze te uploaden';
$string['dndworkingfiletext'] = 'Slepen en neerzetten van tekst up cursussecties om die te uploaden';
$string['dndworkingfiletextlink'] = 'Slepen en neerzetten van bestanden, tekst of links op cursussecties om ze te uploaden';
$string['dndworkinglink'] = 'Slepen en neerzetten van links op cursussecties om ze te uploaden';
$string['dndworkingtext'] = 'Slepen en neerzetten van tekst op cursussecties om die te uploaden';
$string['dndworkingtextlink'] = 'Slepen en neerzetten van tekst of links op cursussecties om ze te uploaden';
$string['documentation'] = 'Moodledocumentatie';
$string['dontsortcategories'] = 'Categorieën niet sorteren';
$string['dontsortcourses'] = 'Cursussen niet sorteren';
$string['down'] = 'Omlaag';
$string['download'] = 'Download';
$string['downloadall'] = 'Download alles';
$string['downloadexcel'] = 'Download in Excel-formaat';
$string['downloadfile'] = 'Download bestand';
$string['downloadods'] = 'Download in ODS-formaat';
$string['downloadtext'] = 'Download in tekstformaat';
$string['doyouagree'] = 'Heb je deze voorwaarden gelezen en begrepen?';
$string['droptoupload'] = 'Zet bestanden hier neer om ze te uploaden';
$string['duplicate'] = 'Dupliceer';
$string['duplicateconfirm'] = 'Ben je zeker dat je {$a->modtype}  \'{$a->modname}\' wil dupliceren?';
$string['duplicatecontcourse'] = 'Keer terug naar cursus';
$string['duplicatecontedit'] = 'Bewerk nieuwe kopie';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' is gedupliceerd';
$string['duplicatinga'] = '{$a} aan het dupliceren';
$string['edhelpaspellpath'] = 'Om spellingscontrole te kunnen gebruiken in de editor heb je <strong>aspell 0.50</strong> of later nodig op je server en moet je het juiste pad ingeven om de aspell-bestanden aan te spreken. Op een Unix/Linux systeem is dit pad gewoonlijk <strong>/usr/bin/aspell</strong>, maar het kan natuurlijk anders zijn.';
$string['edhelpbgcolor'] = 'Definiëer de achtergrondkleur van het bewerkingsscherm.<br />Geldige waarden zijn bijvoorbeeld:#ffffff of white';
$string['edhelpcleanword'] = 'Deze instelling schakelt Word-specifieke opmaakfiltering in of uit.';
$string['edhelpenablespelling'] = 'Schakel spellingscontrole in of uit. Wanneer je dit inschakelt moet <strong>aspell</strong> geïnstalleerd zijn  op deze server.';
$string['edhelpfontfamily'] = 'De eigenschap font-family is een lijst van namen van lettertypefamilies. De familienamen moeten gescheiden worden met een komma.';
$string['edhelpfontlist'] = 'Definiëer de lettertypes die gebruikt zullen worden voor het menu van de editor.';
$string['edhelpfontsize'] = 'De standaard lettertype-grootte stelt de grootte in van een lettertype<br />Geldige waarden zijn bijvoorbeeld: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Bewerk';
$string['edita'] = 'Bewerk {$a}';
$string['editcategorysettings'] = 'Wijzig categorie-instellingen';
$string['editcategorythis'] = 'Wijzig deze categorie';
$string['editcoursesettings'] = 'Wijzig cursusinstellingen';
$string['editfiles'] = 'Bewerk bestanden';
$string['editgroupprofile'] = 'Wijzig groepsprofiel';
$string['editinga'] = 'Een {$a} bewerken';
$string['editingteachershort'] = 'Bewerker';
$string['editlock'] = 'Deze waarde kan niet bewerkt worden!';
$string['editmyprofile'] = 'Wijzig profiel';
$string['editorbgcolor'] = 'Achtergrondkleur';
$string['editorcleanonpaste'] = 'Opgekuiste Word-HTML  bij plakken';
$string['editorcommonsettings'] = 'Algemene instellingen';
$string['editordefaultfont'] = 'Standaardlettertype';
$string['editorenablespelling'] = 'Schakel spellingcontrole in';
$string['editorfontlist'] = 'Lettertypenlijst';
$string['editorfontsize'] = 'Standaardlettertypegrootte';
$string['editorresettodefaults'] = 'Terug naar standaardinstellingen';
$string['editorsettings'] = 'Instellingen editor';
$string['editorshortcutkeys'] = 'Snelkoppelingen editor';
$string['editsettings'] = 'Bewerk instellingen';
$string['editsummary'] = 'Wijzig beschrijving';
$string['editthisactivity'] = 'Wijzig deze activiteit';
$string['editthiscategory'] = 'Bewerk deze categorie';
$string['edittitle'] = 'Bewerk titel';
$string['edittitleinstructions'] = 'Escape om te annuleren, Enter wanneer je klaar bent';
$string['edituser'] = 'Wijzig gebruikersaccounts';
$string['email'] = 'E-mailadres';
$string['emailactive'] = 'E-mail actief';
$string['emailagain'] = 'E-mail (nogmaals)';
$string['emailalreadysent'] = 'Er is al een e-mail verstuurd om je wachtwoord te resetten. Controleer je e-mail.';
$string['emailcharset'] = 'Tekenset voor e-mail';
$string['emailconfirm'] = 'Bevestig je account';
$string['emailconfirmation'] = 'Beste {$a->firstname},

Er is een nieuwe account aangevraagd bij \'{$a->sitename}\' met gebruik van dit e-mailadres.
Klik op de onderstaande link om de account in werking te stellen:

{$a->link}

In de meeste e-mailprogramma\'s kun je op de bovenstaande link klikken. Als dat niet lukt kun je het adres knippen en vervolgens plakken in het adresveld van je browservenster.

Veel succes en met vriendelijke groet,

{$a->admin}
(Beheerder van \'{$a->sitename}\')';
$string['emailconfirmationsubject'] = '{$a}: Bevestiging van de account';
$string['emailconfirmsent'] = '<p>Als het goed is, is er een e-mail verzonden naar <b>{$a}</b></p>
<p>Daarin staan eenvoudige instructies voor het voltooien van de registratie.</p>
<p>Indien je moeilijkheden blijft ondervinden, neem dan contact op met je sitebeheerder.</p>';
$string['emaildigest'] = 'Type samenvattende e-mail';
$string['emaildigestcomplete'] = 'Volledige samenvatting  (dagelijkse e-mail met alle berichten)';
$string['emaildigest_help'] = 'Dit zijn de instellingen voor het versturen van een samenvattende mail die forums zullen gebruiken:

* Geen samenvattende mail - je zult één e-mail per forumbericht ontvangen;
* Samenvattende mail - volledige berichten - je zult één samenvattende mail per dag ontvangen waarin de volledige inhoud van elk forumbericht van die dag zit;
Samenvattende mail - enkel onderwerpen je zult één samenvattende mail per dag ontvangen waarin alleen de onderwerpen van elk forumbericht zal zitten.

Als je wil kun jJe kunt andere instellingen voor elk forum gebruiken.';
$string['emaildigestoff'] = 'Geen samenvatting (voor elk forumbericht een e-mail)';
$string['emaildigestsubjects'] = 'Onderwerpen (dagelijkse e-mail met alleen de onderwerpen van de berichten)';
$string['emaildisable'] = 'Dit e-mailadres is uitgeschakeld';
$string['emaildisableclick'] = 'Klik hier om ervoor te zorgen dat Moodle geen e-mail naar dit adres stuurt';
$string['emaildisplay'] = 'E-mailweergave';
$string['emaildisplaycourse'] = 'Laat mijn e-mailadres alleen maar zien aan andere leden van deze cursus';
$string['emaildisplayhidden'] = 'E-mail verborgen';
$string['emaildisplayno'] = 'Verberg mijn e-mailadres voor iedereen';
$string['emaildisplayyes'] = 'Toon mijn e-mailadres aan iedereen';
$string['emailenable'] = 'Dit e-mailadres is ingeschakeld';
$string['emailenableclick'] = 'Klik hier om ervoor te zorgen dat Moodle terug e-mail naar dit adres stuurt';
$string['emailexists'] = 'Dit e-mailadres is al geregistreerd.';
$string['emailformat'] = 'E-mailopmaak';
$string['emailmustbereal'] = 'N.B. je e-mailadres moet een bestaand en werkend adres zijn';
$string['emailnotallowed'] = 'E-mailadressen van deze domeinen zijn niet toegelaten ({$a})';
$string['emailnotfound'] = 'Het e-mailadres is niet teruggevonden in de databank';
$string['emailonlyallowed'] = 'Dit e-mailadres behoort tot een domein dat niet toegelaten is ({$a})';
$string['emailpasswordchangeinfo'] = 'Beste {$a->firstname},

Iemand (waarschijnlijk jijzelf) heeft een nieuw wachtwoord gevraagd voor je account op \'{$a->sitename}\'.

Ga naar onderstaand adres om dit te bevestigen en om een nieuw wachtwoord te krijgen via mail:

{$a->link}

In de meeste e-mailprogramma\'s zou dit moeten verschijnen als een blauwe link waarop je kunt klikken. Als dat niet werkt, knip en plak het adres dan in de adresbalk van je browser.

Als je hulp nodig hebt, neem dan contact op met de sitebeheerder, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Beste {$a->firstname},

Iemand (waarschijnlijk jijzelf) heeft een nieuw wachtwoord gevraagd voor je account op \'{$a->sitename}\'.

Jammer genoeg is je account uitgeschakeld op deze site, waardoor je geen toegang meer hebt.
Neem contact op met de sitebeheerder, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Beste {$a->firstname},

Iemand (waarschijnlijk jijzelf) heeft een nieuw wachtwoord gevraagd voor je account op \'{$a->sitename}\'.

Jammer genoeg kunnen wachtwoorden op deze site niet gewijzigd worden. Neem contact op met de sitebeheerder, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informatie over wachtwoordwijziging';
$string['emailpasswordconfirmation'] = 'Beste {$a->firstname},

Iemand (waarschijnlijk jijzelf) heeft een nieuw wachtwoord gevraagd voor je account op \'{$a->sitename}\'.

Ga naar onderstaand adres om dit te bevestigen en om een nieuw wachtwoord te krijgen via mail:

{$a->link}

In de meeste e-mailprogramma\'s zou dit moeten verschijnen als een blauwe link waarop je kunt klikken. Als dat niet werkt, knip en plak het adres dan in de adresbalk van je browser.

Als je hulp nodig hebt, neem dan contact op met de sitebeheerder, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: bevestiging van de wijziging van het wachtwoord';
$string['emailpasswordconfirmmaybesent'] = '<p>Als je de juiste gebruikersnaam of e-mailadres hebt ingegeven, ontvang je automatisch een e-mail.</p><p>Daarin lees je eenvoudig hoe je opnieuw toegang kunt krijgen. Daarna kun je meteen je nieuwe wachtwoord bepalen.</p><p>Mocht je moeilijkheden blijven ondervinden, dan kun je het beste contact opnemen met de beheerder van de site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>De gebruikersaccount die jij opgeeft, heeft geen e-mailadres opgegeven.</p>
<p>Neem contact op met de site-beheerder.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Met de gegevens die je ingegeven hebt, konden we geen bestaande gebruikersaccount vinden.</p>
<p>Controleer de informatie en probeer nog eens. Als je blijft problemen ondervinden, neem dan contact op met je site-beheerder.</p>';
$string['emailpasswordconfirmsent'] = 'Er is een e-mail verstuurd naar jouw adres: <b>{$a}</b>.
Indien je moeilijkheden blijft ondervinden, neem dan contact op met je sitebeheerder.';
$string['emailpasswordsent'] = 'Bedankt voor de bevestiging van de wijziging van je wachtwoord.
Er is een e-mail met je nieuw wachtwoord naar <br /><b>{$a->email}</b><br /> gestuurd.<br />
Het nieuwe wachtwoord werd automatisch gegenereerd. Misschien wil je het <a href="{$a->link}">wachtwoord veranderen</a> in iets wat je gemakkelijker kunt onthouden.';
$string['emailresetconfirmation'] = 'Hallo {$a->firstname},

Er is een nieuw wachtwoord gevraagd voor jouw account \'{$a->username}\' op {$a->sitename}.

Ga naar volgend adres om deze vraag te bevestigen en een nieuw wachtwoord voor je account te krijgen:

{$a->link}
(Deze link is {$a->resetminutes} minuten geldig vanaf het moment dat de aanvraag voor het nieuwe wachtwoord is gebeurd)

Als je geen nieuw wachtwoord gevraagd hebt, dan hoef je verder niets te doen.

Als je hulp nodig hebt, neem dan contact op met {$a->admin}, je site-beheerder.';
$string['emailresetconfirmationsubject'] = '{$a}: Wachtwoord reset aangevraagd';
$string['emailresetconfirmsent'] = 'Er is een e-mail verstuurd naar <b>{$a}</b>.
<br />Daar staan eenvoudige instructies in om je wachtwoord te wijzigen.
Als dit je aanmeldprobleem niet oplost, neem dan contact op met je site-beheerder.';
$string['emptydragdropregion'] = 'lege zone';
$string['enable'] = 'Schakel in';
$string['encryptedcode'] = 'Geëncrypteerde code';
$string['english'] = 'Engels';
$string['enrolmentmethods'] = 'Aanmeldingsmethodes';
$string['entercourse'] = 'Klik om deze cursus binnen te gaan';
$string['enteremail'] = 'Geef hier je e-mailadres';
$string['enteremailaddress'] = 'Typ je e-mailadres om je wachtwoord te resetten en via e-mail een nieuw wachtwoord te ontvangen.';
$string['enterusername'] = 'Geef je gebruikersnaam';
$string['entries'] = 'Invoer';
$string['error'] = 'Fout';
$string['errorcreatingactivity'] = 'Kon geen instantie van activiteit \'{$a}\' maken';
$string['errorfiletoobig'] = 'Het bestand is groter dan de limiet van {$a} bytes';
$string['errornouploadrepo'] = 'Er is geen upload opslagruimte ingeschakeld voor deze site';
$string['errorwhenconfirming'] = 'Je account is nog niet bevestigd omdat er iets fout gelopen is. Als je hier gekomen bent door op een link in een e-mail te klikken, kijk dan eens goed of die lijn in je mail niet onderbroken of vervormd was. Het is mogelijk dat je knippen en plakken moet gebruiken om de link op de juiste manier te reconstrueren.';
$string['eventcontentviewed'] = 'Inhoud bekeken';
$string['eventcoursecategorydeleted'] = 'Categorie verwijderd';
$string['eventcoursecontentdeleted'] = 'Cursusinhoud verwijderd';
$string['eventcoursecreated'] = 'Cursus gemaakt';
$string['eventcoursedeleted'] = 'Cursus verwijderd';
$string['eventcoursemodulecreated'] = 'Cursusmodule gemaakt';
$string['eventcoursemoduledeleted'] = 'Cursusmodule verwijderd';
$string['eventcoursemoduleupdated'] = 'Cursusmodule aangepast';
$string['eventcourseresetended'] = 'Cursus reset afgelopen';
$string['eventcourseresetstarted'] = 'Cursus reset gestart';
$string['eventcourserestored'] = 'Cursus teruggezet';
$string['eventcoursesectionupdated'] = 'Cursussectie aangepast';
$string['eventcourseupdated'] = 'Cursus aangepast';
$string['eventusercreated'] = 'Gebruikersaccount aangemaakt';
$string['eventuserdeleted'] = 'Gebruikersaccount verwijderd';
$string['eventuserlistviewed'] = 'Gebruikerslijst bekeken';
$string['eventuserloggedout'] = 'Gebruiker afgemeld';
$string['eventuserprofileviewed'] = 'Gebruikersprofiel bekeken';
$string['eventuserupdated'] = 'Gebruikersaccount aangepast';
$string['everybody'] = 'Iedereen';
$string['executeat'] = 'Voer uit op';
$string['existing'] = 'Bestaande';
$string['existingadmins'] = 'Bestaande beheerders';
$string['existingcourse'] = 'Bestaande cursus';
$string['existingcourseadding'] = 'Bestaande cursus, data toevoegen';
$string['existingcoursedeleting'] = 'Bestaande cursus eerst verwijderen';
$string['existingcreators'] = 'Bestaande cursus-aanmakers';
$string['existingstudents'] = 'Aangemelde leerlingen';
$string['existingteachers'] = 'Bestaande leraren';
$string['expand'] = 'Uitklappen';
$string['expandall'] = 'Alles openklappen';
$string['expandcategory'] = '{$a} openklappen';
$string['explanation'] = 'Verklaring';
$string['extendenrol'] = 'Verleng aanmelding';
$string['extendperiod'] = 'Verlengde periode';
$string['failedloginattempts'] = '{$a->attempts} mislukte aanmeldingen sinds je laatste aanmelding';
$string['failedloginattemptsall'] = '{$a->attempts} mislukte aanmelding bij {$a->accounts} accounts';
$string['feedback'] = 'Feedback';
$string['file'] = 'Bestand';
$string['fileexists'] = 'Er is al een bestand met de naam {$a}';
$string['filemissing'] = '{$a} ontbreekt';
$string['files'] = 'Bestanden';
$string['filesanduploads'] = 'Bestanden en uploads';
$string['filesfolders'] = 'Bestanden/mappen';
$string['filetoolarge'] = 'is te groot om te uploaden';
$string['fileuploadwithcontent'] = 'Bestand uploads zouden de content parameter niet mogen meegeven';
$string['filloutallfields'] = 'Vul alsjeblieft alle velden in dit formulier in';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Vind meer cursussen...';
$string['first'] = 'Eerste';
$string['firstaccess'] = 'Eerste toegang';
$string['firstname'] = 'Voornaam';
$string['firstnamephonetic'] = 'Voornaam - phonetisch';
$string['firstsiteaccess'] = 'Eerste toegang tot de site';
$string['firsttime'] = 'Is dit de eerste keer dat je hier bent?';
$string['folder'] = 'Map';
$string['folderclosed'] = 'Gesloten map';
$string['folderopened'] = 'Geopende map';
$string['followingoptional'] = 'De volgende velden zijn niet verplicht';
$string['followingrequired'] = 'De volgende velden zijn verplicht';
$string['for'] = 'Voor';
$string['force'] = 'Verplicht';
$string['forcelanguage'] = 'Verplicht taal';
$string['forceno'] = 'Verplicht niet';
$string['forcepasswordchange'] = 'Verplicht het wijzigen van het wachtwoord';
$string['forcepasswordchangecheckfull'] = 'Ben je zeker dat je de wachtwoordswijziging wil afdwingen voor {$a} ?';
$string['forcepasswordchange_help'] = 'Vraag de gebruiker het wachtwoord te wijzigen bij de volgend login.';
$string['forcepasswordchangenot'] = 'Kon geen wachtwoordswijziging afdwingen voor {$a}';
$string['forcepasswordchangenotice'] = 'Je moet je wachtwoord wijzigen om verder te kunnen gaan';
$string['forcetheme'] = 'Leg dit thema op';
$string['forgotaccount'] = 'Wachtwoord vergeten?';
$string['forgotten'] = 'Ben je je gebruikersnaam of wachtwoord vergeten?';
$string['forgottenduplicate'] = 'Dit e-mailadres wordt ook door verschillende andere gebruikers gebruikt. Geef je gebruikersnaam in plaats van je e-mailadres.';
$string['forgotteninvalidurl'] = 'Ongeldig wachtwoord reset URL';
$string['format'] = 'Format';
$string['format_help'] = 'De cursus-indeling bepaalt de lay-out van de cursus pagina.

* Enkele activiteit formaat - Voor het weergeven van één enkele activiteit of bron (zoals een test of SCORM-pakket) op de cursus pagina
* Sociaal formaat - Er wordt een forum weergegeven op de cursus pagina
* Onderwerp formaat - De cursuspagina is opgedeeld in secties
* Week formaat - De cursuspagina is georganiseerd in weeksecties, met de eerste week beginnend op de cursus startdatum';
$string['formathtml'] = 'HTML-opmaak';
$string['formatmarkdown'] = 'Markdown-opmaak';
$string['formatplain'] = 'Plattetekstopmaak';
$string['formattext'] = 'Moodle auto-opmaak';
$string['formattexttype'] = 'Opmaken';
$string['framesetinfo'] = 'Dit frameset document bevat:';
$string['from'] = 'Van';
$string['frontpagecategorycombo'] = 'Combolijst';
$string['frontpagecategorynames'] = 'Toon een lijst met categorieën';
$string['frontpagecourselist'] = 'Toon een lijst met alle cursussen';
$string['frontpagecoursesearch'] = 'Cursus zoekvak';
$string['frontpagedescription'] = 'Beschrijving startpagina';
$string['frontpagedescriptionhelp'] = 'Deze beschrijving van de site kan getoond worden op de startpagina via het cursusbeschrijvingsblok of door een onderwerpssectie toe te voegen aan de startpagina.';
$string['frontpageenrolledcourselist'] = 'Aangemelde cursussen';
$string['frontpageformat'] = 'Format startpagina';
$string['frontpageformatloggedin'] = 'Startpaginaopmaak wanneer aangemeld';
$string['frontpagenews'] = 'Toon nieuwsberichten';
$string['frontpagesettings'] = 'Instellingen startpagina';
$string['fulllistofcourses'] = 'Alle cursussen';
$string['fullname'] = 'Volledige naam';
$string['fullnamecourse'] = 'Volledige naam van de cursus';
$string['fullnamecourse_help'] = 'De volledoige naam van de cursus wordt bovenaan elke pagina en in de lijst met cursussen getoond';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Volledige naam van de gebruiker';
$string['fullprofile'] = 'Volledig profiel';
$string['fullsitename'] = 'Volledige naam van de site';
$string['functiondisabled'] = 'Deze functie is nu uitgeschakeld';
$string['general'] = 'Algemeen';
$string['geolocation'] = 'breedtegraad - lengtegraad';
$string['gettheselogs'] = 'Toon logs';
$string['go'] = 'Start';
$string['gpl'] = 'Copyright (C) 1999 en verder Martin Dougiamas
(http://moodle.com)

Dit programma is gratis software; je kunt het redistribueren en/of wijzigen volgens de voorwaarden van de GNU General Public License zoals deze is gepubliceerd door de Free Software Foundation; versie 2 van de licentie (of een latere versie als daar je voorkeur naar uit gaat).

Dit programma is gedistribueerd met de hoop dat het bruikbaar is, maar ZONDER ENIGE GARANTIE; zelfs zonder een geïmpliceerde garantie tot VERKOOPBAARHEID (merchantability) of BRUIKBAARHEID VOOR EEN BEPAALDE DOELSTELLING (fitness for a particular purpose). Bekijk de Moodle License information pagina voor meer details:

http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 en verder Martin Dougiamas (http://moodle.com)

VERTALING NIET OFFICIEEL
Dit programma is vrije software: je mag het herverdelen en/of wijzigen volgens de bepalingen van de GNU Public licence zoals gepubliceerd door de Free Software Foundation, Versie 3 of (volgens jouw keuze) latere versie.

Dit programma wordt verdeeld met de hoop dat het bruikbaar is, maar  ZONDER ENIGE GARANTIE; zonder zelfs de veronderstelde garantie van VERKOOPBAARHEID of GESCHIKTHEID VOOR EEN BEPAALD DOEL.

Bekijk de Moodle-licentie informatiepagina voor alle details (Engels):  http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL Licentie';
$string['grade'] = 'Cijfer';
$string['grades'] = 'Cijfers';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> is ingeschakeld voor deze site. Als je geen profielafbeelding upload, zal Moodle er proberen één te downloaden van Gravatar.';
$string['group'] = 'Groep';
$string['groupadd'] = 'Nieuwe groep';
$string['groupaddusers'] = 'Voeg selectie toe aan groep';
$string['groupextendenrol'] = 'Verleng aanmeldingsperiode (algemeen)';
$string['groupfor'] = 'voor groep';
$string['groupinfo'] = 'Info over geselecteerde groep';
$string['groupinfoedit'] = 'Bewerk instellingen van de groep';
$string['groupinfomembers'] = 'Info over geselecteerde leden';
$string['groupinfopeople'] = 'Info over geselecteerde personen';
$string['groupmembers'] = 'Groepsleden';
$string['groupmemberssee'] = 'Bekijk de groepsleden';
$string['groupmembersselected'] = 'Leden van geselecteerde groep';
$string['groupmode'] = 'Groepsmodus';
$string['groupmodeforce'] = 'Verplicht groepsmodus';
$string['groupmy'] = 'Mijn groep';
$string['groupnonmembers'] = 'Personen niet in een groep';
$string['groupnotamember'] = 'Je behoort niet tot die groep';
$string['grouprandomassign'] = 'Wijs willekeurig aan een groep toe';
$string['groupremove'] = 'Verwijder geselecteerde groep';
$string['groupremovemembers'] = 'Verwijder geselecteerde leden';
$string['groups'] = 'Groepen';
$string['groupsnone'] = 'Geen groepen';
$string['groupsseparate'] = 'Gescheiden groepen';
$string['groupsvisible'] = 'Zichtbare groepen';
$string['guest'] = 'Gast';
$string['guestdescription'] = 'Gasten hebben heel beperkte rechten en kunnen gewoonlijk nergens tekst invoeren';
$string['guestskey'] = 'Laat gasten die de sleutel hebben toe';
$string['guestsno'] = 'Laat geen gasten toe';
$string['guestsnotallowed'] = 'Sorry, gasten zijn in \'{$a}\' niet toegelaten';
$string['guestsyes'] = 'Laat gasten zonder sleutel toe';
$string['guestuser'] = 'Gastgebruiker';
$string['guestuserinfo'] = 'Deze gebruiker is een speciale gebruiker met alleen-lezen toegang tot sommige cursussen.';
$string['help'] = 'Help';
$string['helpprefix2'] = 'Hulp voor {$a}';
$string['helpwiththis'] = 'Hulp hierbij';
$string['hiddenassign'] = 'Verborgen rol';
$string['hiddenfromstudents'] = 'Verborgen voor leerlingen';
$string['hiddensections'] = 'Verborgen onderwerpen';
$string['hiddensectionscollapsed'] = 'Verborgen secties worden samengeklapt getoond';
$string['hiddensections_help'] = '<p>Met deze optie kun je kiezen hoe je de verborgen secties in je cursus toont aan je leerlingen.</p>

<p>Standaard wordt er een kleine zone getoond (in samengeklapte vorm, meestal grijs) om aan te geven waar de verborgen sectie zich bevindt, hoewel de verborgen activiteiten en teksten zelf niet zichtbaar zijn. Dit is vooral nuttig in cursussen met weken, zodat het duidelijk is welke weken er geen les is.</p>

<p>Als je ervoor kiest kun je die secties helemaal verbergen, zodat de leerlingen zelfs niet weten dat er delen van de cursus verborgen zijn.</p>';
$string['hiddensectionsinvisible'] = 'Verborgen secties worden helemaal niet getoond';
$string['hide'] = 'Verberg';
$string['hideadvancedsettings'] = 'Verberg geavanceerde instellingen';
$string['hidepicture'] = 'Verberg afbeelding';
$string['hidesection'] = 'Verberg sectie {$a}';
$string['hidesettings'] = 'Verberg instellingen';
$string['hideshowblocks'] = 'Verberg of toon blokken';
$string['hits'] = 'Hits';
$string['hitsoncourse'] = 'Hits voor {$a->coursename} door {$a->username}';
$string['hitsoncoursetoday'] = 'Hits van vandaag voor {$a->coursename} door {$a->username}';
$string['home'] = 'Home';
$string['hour'] = 'uur';
$string['hours'] = 'uren';
$string['howtomakethemes'] = 'Hoe je nieuwe thema\'s kunt maken';
$string['htmleditor'] = 'Gebruik HTML-editor';
$string['htmleditoravailable'] = 'De HTML-editor is beschikbaar';
$string['htmleditordisabled'] = 'Je hebt de HTML-editor uitgezet in je gebruikersprofiel';
$string['htmleditordisabledadmin'] = 'De beheerder heeft de HTML-editor uitgezet op deze site';
$string['htmleditordisabledbrowser'] = 'De HTML-editor is niet beschikbaar omdat je browser er niet compatibel mee is';
$string['htmlfilesonly'] = 'Enkel HTML-bestanden';
$string['htmlformat'] = 'Mooie HTML-opmaak';
$string['icon'] = 'Icoon';
$string['icqnumber'] = 'ICQ-nummer';
$string['idnumber'] = 'Nummer (ID)';
$string['idnumbercourse'] = 'Nummer (ID) van de cursus';
$string['idnumbercoursecategory'] = 'Categorie ID nummer';
$string['idnumbercoursecategory_help'] = 'Het ID-nummer van een cursuscategorie wordt alleen gebruikt als de categorie moet gekoppeld worden met externe systemen en wordt nergens anders op de site getoond. Als de categorie een officiële code heeft, kan die hier ingegeven worden, anders mag je dit veld leeglaten.';
$string['idnumbercourse_help'] = '<p>Het ID-nummer van een cursus wordt alleen gebruikt wanneer deze cursus moet gekoppeld worden aan externe systemen - het wordt nooit getoond binnen Moodle. Als je een officiële codenaam hebt voor deze cursus, gebruik die dan hier ... anders kun je dit veld gewoon leeg laten.</p>';
$string['idnumbergroup'] = 'Groep ID nummer';
$string['idnumbergroup_help'] = 'Het ID nummer van een groep wordt alleen gebruikt wanneer de groep moet gekoppeld worden aan een extern systeem en wordt nergens getoond op de site. Als de groep een officiële codenama heeft, kan die hier gebruikt worden, anders mag het veld leeg gelaten worden.';
$string['idnumbergrouping'] = 'Groepering ID nummer';
$string['idnumbergrouping_help'] = 'Het ID nummer van een groepering wordt alleen gebruikt wanneer de groep moet gekoppeld worden aan een extern systeem en wordt nergens getoond op de site. Als de groep een officiële codenama heeft, kan die hier gebruikt worden, anders mag het veld leeg gelaten worden.';
$string['idnumbermod'] = 'ID-nummer';
$string['idnumbermod_help'] = 'Een ID-nummer instellen geeft een manier om de activiteit te identificeren voor de berekening van cijfers. Als de activiteit niet in een cijferberekening opgenomen wordt, dan mag dit veld leeg gelaten worden.

Het ID-nummer kan ook ingesteld worden op de "Bewerk cijferberekening" -pagina in de cijferlijst - het kan echter alleen bewerkt worden op de instellingspagina van de activiteit.';
$string['idnumbertaken'] = 'Dit ID-nummer is al in gebruik';
$string['imagealt'] = 'Afbeeldingsbeschrijvingen';
$string['import'] = 'Importeer';
$string['importdata'] = 'Importeer gegevens uit een cursus';
$string['importdataexported'] = 'Gegevens met succes uit de broncursus geëxporteerd.<br />Ga verder om te importeren in de doelcursus.';
$string['importdatafinished'] = 'Import volledig! Ga terug naar je cursus';
$string['importdatafrom'] = 'Zoek de cursus waarvan je gegevens wil importeren:';
$string['inactive'] = 'Niet actief';
$string['include'] = 'Voeg toe';
$string['includeallusers'] = 'Voeg alle gebruikers toe';
$string['includecoursefiles'] = 'Voeg de bestanden voor de cursus toe';
$string['includecourseusers'] = 'Voeg de gebruikers van de cursus toe';
$string['included'] = 'Ingevoegd';
$string['includelogentries'] = 'Voeg het logboek toe';
$string['includemodules'] = 'Voeg modules toe';
$string['includemoduleuserdata'] = 'Gebruikersgegevens van de modules toevoegen';
$string['includeneededusers'] = 'Voeg de nodige gebruikers toe';
$string['includenoneusers'] = 'Voeg geen gebruikers toe';
$string['includeroleassignments'] = 'Roltoewijzingen toevoegen';
$string['includesitefiles'] = 'Site-bestanden, gebruikt in deze cursus, toevoegen';
$string['includeuserfiles'] = 'Voeg gebruikersbestanden toe';
$string['increasesections'] = 'Vergroot het aantal secties';
$string['info'] = 'Informatie';
$string['institution'] = 'Instituut';
$string['instudentview'] = 'Als leerling';
$string['interests'] = 'Interesses';
$string['interestslist'] = 'Lijst met interesses';
$string['interestslist_help'] = 'Geef je interesses in, gescheiden door komma\'s';
$string['invalidemail'] = 'Ongeldig e-mailadres';
$string['invalidlogin'] = 'Ongeldige login, probeer nog eens';
$string['invalidusername'] = 'De gebruikersnaam mag alleen kleine alphanumerieke tekens, liggend streepje (-), underscore (_), punt(.) of het at-symbool (@).';
$string['invalidusernameupload'] = 'Ongeldige gebruikersnaam';
$string['ip_address'] = 'IP-adres';
$string['jump'] = 'Spring';
$string['jumpto'] = 'Ga naar...';
$string['keep'] = 'Houden';
$string['keepsearching'] = 'Blijf zoeken';
$string['langltr'] = 'Taalrichting van links naar rechts';
$string['langrtl'] = 'Taalrichting van rechts naar links';
$string['language'] = 'Taal';
$string['languagegood'] = 'Dit taalpakket is helemaal bijgewerkt! :-)';
$string['last'] = 'Laatste';
$string['lastaccess'] = 'Laatste bezoek';
$string['lastcourseaccess'] = 'Laatste toegang tot de cursus';
$string['lastedited'] = 'Laatste wijziging';
$string['lastlogin'] = 'Laatste login';
$string['lastmodified'] = 'Laatste wijziging';
$string['lastname'] = 'Achternaam';
$string['lastnamephonetic'] = 'Achternaam - phonetisch';
$string['lastsiteaccess'] = 'Laatste toegang tot de site';
$string['lastyear'] = 'Vorig jaar';
$string['latestlanguagepack'] = 'Haal het meest recente taalpakket van moodle.org';
$string['layouttable'] = 'Opmaaktabel';
$string['leavetokeep'] = 'Laat leeg om je huidige wachtwoord te behouden';
$string['legacythemeinuse'] = 'Je ziet de site in compatibiliteitsmodus omdat je browser te oud is.';
$string['license'] = 'Licentie';
$string['licenses'] = 'Licenties';
$string['liketologin'] = 'Wil je je nu aanmelden met een volledige gebruikersaccount?';
$string['list'] = 'Lijst';
$string['listfiles'] = 'Lijst met bestanden in {$a}';
$string['listofallpeople'] = 'Lijst van alle mensen';
$string['listofcourses'] = 'Cursuslijst';
$string['loadinghelp'] = 'Laden...';
$string['local'] = 'Lokaal';
$string['localplugins'] = 'Lokale plugins';
$string['localpluginsmanage'] = 'Beheer lokale plugins';
$string['location'] = 'Plaats';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Je bent ingelogd als {$a}';
$string['loggedinasguest'] = 'Je gebruikt nu de gast-account';
$string['loggedinnot'] = 'Je bent niet ingelogd';
$string['login'] = 'Login';
$string['loginalready'] = 'Je bent al aangemeld';
$string['loginas'] = 'Login als';
$string['loginaspasswordexplain'] = '<p>Je moet het speciale "loginas" wachtwoord ingeven om deze functie te kunnen gebruiken.<br />Als je dit niet kent, vraag het dan aan je serverbeheerder.</p>';
$string['login_failure_logs'] = 'Logs mislukte aanmelding';
$string['loginguest'] = 'Inloggen als gast';
$string['loginsite'] = 'Op de site inloggen';
$string['loginsteps'] = 'Hallo! Om volledige toegang tot de cursussen te krijgen moet je even de tijd nemen om een nieuwe account voor jezelf aan te maken op deze website.
Elke cursus kan ook een eenmalige "Cursussleutel" hebben die je pas later nodig hebt. Hier zijn de stappen die je moet volgen:
<ol>
<li>Vul het formulier <a href="{$a}">Nieuwe account</a> in.</li>
<li>Er wordt meteen een e-mail verstuurd naar je e-mailadres.</li>
<li>Lees de e-mail en klik op de link die erin staat.</li>
<li>Je account wordt bevestigd en je bent dan ingelogd.</li>
<li>Kies nu de cursus die je wil volgen.</li>
<li>Als je wordt gevraagd om een "Cursussleutel", gebruik dan de sleutel die je van je leraar gekregen hebt. Dit zorgt ervoor dat je lid wordt van de cursus.</li>
<li>Je hebt nu toegang tot de hele cursus. Vanaf nu hoef je alleen nog maar je gebruikersnaam en wachtwoord in het formulier op deze pagina in te vullen om in te loggen en toegang te krijgen tot de cursussen waarvan je lid bent.</li>
</ol>';
$string['loginstepsnone'] = 'Hallo!<p>Om volledige toegang te krijgen tot de verschillende cursussen moet je een account voor jezelf aanmaken.</p>
<p>Het enige wat je hoeft te doen is een gebruikersnaam en wachtwoord bedenken en deze gebruiken in het formulier op deze pagina!
</p>
<p>Als iemand anders de gebruikersnaam al heeft gebruikt zul je het nog een keer met een andere gebruikersnaam moeten proberen.</p>';
$string['loginto'] = 'Login op {$a}';
$string['logout'] = 'Log uit';
$string['logoutconfirm'] = 'Wil je echt afmelden?';
$string['logs'] = 'Logs';
$string['logtoomanycourses'] = '[<a href="{$a->url}">meer</a>]';
$string['logtoomanyusers'] = '[<a href="{$a->url}">meer</a>]';
$string['lookback'] = 'rapportperiode';
$string['mailadmins'] = 'Informeer beheerders';
$string['mailstudents'] = 'Informeer leerlingen';
$string['mailteachers'] = 'Informeer leraren';
$string['maincoursepage'] = 'Hoofdpagina cursus';
$string['makeafolder'] = 'Maak een map';
$string['makeeditable'] = 'Als je \'{$a}\' bewerkbaar maakt door het proces op de webserver (bijv. Apache), dan kun je dit bestand rechtstreeks vanuit deze pagina bewerken';
$string['makethismyhome'] = 'Maak deze pagina als mijn standaard startpagina';
$string['manageblocks'] = 'Blokken';
$string['managecategorythis'] = 'Beheer deze categorie';
$string['managecourses'] = 'Beheer cursussen';
$string['managedatabase'] = 'Beheer de database';
$string['manageeditorfiles'] = 'Beheer bestanden gebruikt door de editor';
$string['managefilters'] = 'Filters';
$string['managemodules'] = 'Modules';
$string['manageroles'] = 'Rollen en rechten';
$string['markedthistopic'] = 'Dit onderwerp is geselecteerd als het huidige onderwerp';
$string['markthistopic'] = 'Selecteer dit onderwerp als het huidige onderwerp';
$string['matchingsearchandrole'] = 'Overeenkomstige \'{$a->search}\' en {$a->role}';
$string['maxareabytesreached'] = 'Het bestand (of de totale grootte van meerder bestanden) is groter dan de resterende plaats in deze zone.';
$string['maxbytesforfile'] = 'Het bestand {$a} is groter dan de maximaal toegestane grootte.';
$string['maxfilesize'] = 'Maximale grootte voor nieuwe bestanden: {$a}';
$string['maxfilesreached'] = 'Je mag maximaal {$a} bestanden aan dit item koppelen';
$string['maximumchars'] = 'Een maximum van {$a} characters';
$string['maximumgrade'] = 'Hoogst haalbare cijfer';
$string['maximumgradex'] = 'Maximumcijfer: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximale uploadgrootte';
$string['maximumupload_help'] = 'Deze instelling bepaalt de maximale grootte van bestanden die naar een cursus geüpload kunnen worden. Dit wordt begrensd door een site-instelling, gekozen door de beheerder. Het is mogelijk om deze grootte verder in te krimpen
via de instellingen in elke activiteitsmodule.';
$string['maxnumberweeks'] = 'Maximaal aantal secties';
$string['maxnumberweeks_desc'] = 'Dit controleert het maximaal aantal secties in het rolmenu (geldt slechts voor bepaalde cursusformaten).';
$string['maxnumcoursesincombo'] = 'Blader in <a href="{$a->link}">{$a->numberofcourses} cursussen</a>.';
$string['maxsize'] = 'Maximale grootte: {$a}';
$string['maxsizeandareasize'] = 'Maximale grootte voor nieuwe bestanden: {$a->size}, algemene limiet: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximale grootte voor nieuwe bestanden: {$a->size}, maximum aantal bijlagen: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximale grootte voor nieuwe bestanden: {$a->size}, maximaal aantal bijlagen: {$a->attachements}, algemene limiet: {$a->areasize}';
$string['memberincourse'] = 'Mensen in de cursus';
$string['messagebody'] = 'Inhoud van het bericht';
$string['messagedselectedusers'] = 'De geselecteerde gebruikers hebben het bericht gekregen en de lijst met ontvangers is leeggemaakt';
$string['messagedselectedusersfailed'] = 'Er ging wat fout tijdens het versturen van het bericht naar de geselecteerde gebruikers. Sommigen kunnen de boodschap gekregen hebben, anderen niet.';
$string['messageprovider:availableupdate'] = 'Beschikbare update meldingen';
$string['messageprovider:backup'] = 'Back-upmeldingen';
$string['messageprovider:badgecreatornotice'] = 'Meldingen voor wie badges maakt';
$string['messageprovider:badgerecipientnotice'] = 'Meldingen voor wie badges ontvangt';
$string['messageprovider:courserequestapproved'] = 'Melding voor goedkeuring nieuwe cursus';
$string['messageprovider:courserequested'] = 'Melding voor aanvraag nieuwe cursus';
$string['messageprovider:courserequestrejected'] = 'Melding voor weigering nieuwe cursus';
$string['messageprovider:errors'] = 'Site vertoont belangrijke fouten';
$string['messageprovider:errors_help'] = 'Dit zijn belangrijke foutmeldingen. Breng een beheerder ervan op de hoogte.';
$string['messageprovider:instantmessage'] = 'Persoonlijke berichten tussen gebruikers';
$string['messageprovider:instantmessage_help'] = 'Met deze sectie configureer je wat er gebeurt met berichten van andere gebruikers van de site die rechtstreeks naar jou gestuurd worden.';
$string['messageprovider:notices'] = 'Opmerkingen over kleine problemen';
$string['messageprovider:notices_help'] = 'Dit zijn opmerkingen die interessant zijn voor een beheerder.';
$string['messageselect'] = 'Selecteer deze gebruiker om berichten te ontvangen';
$string['messageselectadd'] = 'Stuur bericht';
$string['middlename'] = 'Middennaam';
$string['migratinggrades'] = 'Cijfers aan het migreren';
$string['min'] = 'minuut';
$string['mins'] = 'minuten';
$string['minute'] = 'minuut';
$string['minutes'] = 'minuten';
$string['miscellaneous'] = 'Diversen';
$string['missingcategory'] = 'Je moet een categorie kiezen';
$string['missingcity'] = 'Plaats ontbreekt';
$string['missingcountry'] = 'Land ontbreekt';
$string['missingdescription'] = 'Beschrijving ontbreekt';
$string['missingemail'] = 'e-mailadres ontbreekt';
$string['missingfirstname'] = 'Voornaam ontbreekt';
$string['missingfromdisk'] = 'Ontbrekend op schijf';
$string['missingfullname'] = 'Volledige naam ontbreekt';
$string['missinglastname'] = 'Achternaam ontbreekt';
$string['missingname'] = 'Naam ontbreekt';
$string['missingnewpassword'] = 'Nieuw wachtwoord ontbreekt';
$string['missingpassword'] = 'Wachtwoord ontbreekt';
$string['missingrecaptchachallengefield'] = 'Ontbrekend reCAPTCHA challenge veld';
$string['missingreqreason'] = 'Motivatie ontbreekt';
$string['missingshortname'] = 'Korte naam ontbreekt';
$string['missingshortsitename'] = 'Korte naam van de site ontbreekt';
$string['missingsitedescription'] = 'Omschrijving van de site ontbreekt';
$string['missingsitename'] = 'Naam van de site ontbreekt';
$string['missingstrings'] = 'Controleer op ontbrekende woorden of zinnen';
$string['missingstudent'] = 'Je moet iets kiezen';
$string['missingsummary'] = 'Beschrijving ontbreekt';
$string['missingteacher'] = 'Je moet iets kiezen';
$string['missingurl'] = 'URL ontbreekt';
$string['missingusername'] = 'Gebruikersnaam ontbreekt';
$string['modchooserdisable'] = 'Activiteitskiezer uit';
$string['modchooserenable'] = 'Activiteitskiezer aan';
$string['moddoesnotsupporttype'] = 'Module {$a->modname} ondersteunt geen uploads van het type {$a->type}';
$string['modified'] = 'Gewijzigd';
$string['moduleintro'] = 'Beschrijving';
$string['modulesetup'] = 'Klaarmaken van de tabellen van de module';
$string['modulesuccess'] = '{$a} tabellen zijn met succes klaargemaakt';
$string['modulesused'] = 'Gebruikte modules';
$string['month'] = 'Maand';
$string['months'] = 'Maanden';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Hulp uit Moodle Docs voor deze pagina';
$string['moodlerelease'] = 'Moodle release';
$string['moodleversion'] = 'Moodleversie';
$string['more'] = 'meer';
$string['morehelp'] = 'Meer hulp';
$string['moreinformation'] = 'Meer informatie over deze fout';
$string['moreprofileinfoneeded'] = 'Vertel ons meer over jezelf';
$string['mostrecently'] = 'meest recente';
$string['move'] = 'Verplaats';
$string['movecategoriessuccess'] = '{$a->count} categorieën in categorie {$a->to} geplaatst';
$string['movecategoriestotopsuccess'] = '{$a->count} categorieën verplaatst naar het topniveau.';
$string['movecategorycontentto'] = 'Verplaats informatie';
$string['movecategorysuccess'] = 'Categorie {$a->moved} in categorie {$a->to} geplaatst';
$string['movecategoryto'] = 'Verplaats categorie naar:';
$string['movecategorytotopsuccess'] = 'Categorie \'{$a->moved}\' naar het topniveau verplaatst';
$string['movecontent'] = 'Verplaats {$a}';
$string['movecontentstoanothercategory'] = 'Verplaats inhoud naar een andere categorie';
$string['movecoursemodule'] = 'Verplaats bron';
$string['movecoursesection'] = 'Verplaat sectie';
$string['movecourseto'] = 'Verplaats cursus naar:';
$string['movedown'] = 'Verplaats naar beneden';
$string['movefilestohere'] = 'Verplaats de bestanden hier naar toe';
$string['movefull'] = 'Verplaats {$a} naar deze locatie';
$string['movehere'] = 'Verplaats naar hier';
$string['moveleft'] = 'Verplaats naar links';
$string['moveright'] = 'Verplaats naar rechts';
$string['movesection'] = 'Verplaats sectie {$a}';
$string['moveselectedcategoriesto'] = 'Verplaats geselecteerde categorieën naar';
$string['moveselectedcoursesto'] = 'Verplaats geselecteerde cursussen naar...';
$string['movetoanotherfolder'] = 'Verplaats naar een andere map';
$string['moveup'] = 'Verplaats naar boven';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Het nieuwe wachtwoord moet anders zijn dan het huidige';
$string['mustconfirm'] = 'Je moet de login bevestigen';
$string['mycourses'] = 'Mijn cursussen';
$string['myfiles'] = 'Mijn privébestanden';
$string['myfilesmanage'] = 'Beheer mijn privébestanden';
$string['myhome'] = 'Mijn startpagina';
$string['mymoodledashboard'] = 'Mijn Moodle dashboard';
$string['myprofile'] = 'Mijn profiel';
$string['name'] = 'Naam';
$string['nameforlink'] = 'Hoe wil je deze link noemen';
$string['nameforpage'] = 'Naam';
$string['navigation'] = 'Navigatie';
$string['needed'] = 'Nodig';
$string['never'] = 'Nooit';
$string['neverdeletelogs'] = 'Verwijder de logs nooit';
$string['new'] = 'Nieuw';
$string['newaccount'] = 'Nieuwe account';
$string['newcourse'] = 'Nieuwe cursus';
$string['newpassword'] = 'Nieuw wachtwoord';
$string['newpasswordfromlost'] = '<strong>OPMERKING:</strong> Je <strong>huidige wachtwoord</strong> zal je toegestuurd worden in de <strong>tweede</strong> van de twee e-mails die je toegestuurd worden voor het terugkrijgen van je wachtwoord. Zorg er voor dat je je nieuwe wachtwoord gekregen hebt voor je verder gaat met dit scherm.';
$string['newpassword_help'] = 'Laat dit veld leeg om het huidige wachtwoord te behouden.';
$string['newpasswordtext'] = 'Beste {$a->firstname},

Het wachtwoord voor je account op \'{$a->sitename}\' is gereset en je hebt een nieuw tijdelijk wachtwoord gekregen.

Je inloginformatie is nu:
gebruikersnaam: {$a->username}
wachtwoord: {$a->newpassword}

Ga naar deze pagina om je wachtwoord te wijzigen:
{$a->link}

In de meeste mailprogramma\'s kun je op de bovenstaande link klikken. Als dat niet lukt kun je het adres op knippen en plakken in het adresveld van je browservenster.

Veel succes en met vriendelijke groet,

{$a->signoff}
(Beheerder van \'{$a->sitename}\')

{$a->signoff}';
$string['newpicture'] = 'Nieuwe foto';
$string['newpicture_help'] = 'Om een nieuwe afbeelding toe te voegen, blader en selecteer je een afbeelding (in JPG- of PNG-formaat), klik dan op "Profiel bijwerken". De afbeelding zal verkleind worden tot een vierkant en herschaald worden naar 100x100 pixels.';
$string['newsitem'] = 'Nieuwsitem';
$string['newsitems'] = 'Nieuwsitems';
$string['newsitemsnumber'] = 'Weer te geven nieuwsitems';
$string['newsitemsnumber_help'] = '<p>In het "week-" en het "onderwerp"-format verschijnt er een speciaal forum dat "Nieuws" heet. Het is de ideale plek om nota\'s te posten die alle leerlingen moeten zien. (Standaard zijn alle leerlingen ingeschreven (lid) in dit forum en zullen ze je notitie krijgen via e-mail).</p>
<p>Deze instelling bepaalt hoeveel recente nieuwsitems verschijnen op de startpagina van je cursus.</p>
<p>Als je dit instelt op 0, dan verschijnt het "Laatste nieuws" niet.</p>';
$string['newuser'] = 'Nieuwe gebruiker';
$string['newusernewpasswordsubj'] = 'Nieuwe account';
$string['newusernewpasswordtext'] = 'Hallo {$a->username},

Er is voor jou een nieuwe account gemaakt op \'{$a->sitename}\' en je hebt daarvoor een nieuw, tijdelijk wachtwoord gekregen.

De informatie die je nu nodig hebt om op de site in te loggen is:
gebruikersnaam: {$a->username}
wachtwoord: {$a->newpassword}
(je zult je wachtwoord moeten wijzigen wanneer je je de eerste keer aanmeldt op de site)

Om \'{$a->sitename}\' te beginnen gebruiken, klik op {$a->link}

In de meeste e-mailprogramma\'s zal de bovenstaande regel een blauw, onderlijnde link zijn, waarop je gewoon kunt klikken. Als dat niet werkt, knip en plak dan dit adres in de adresbalk bovenaan in je internetbrowser.

Vriendelijke groeten van de \'{$a->sitename}\'-beheerder,
{$a->signoff}';
$string['newusers'] = 'Nieuwe gebruikers';
$string['newwindow'] = 'Nieuw venster';
$string['next'] = 'Volgende';
$string['nextsection'] = 'Nieuwe sectie';
$string['no'] = 'Nee';
$string['noblockstoaddhere'] = 'Er zijn geen blokken die je aan deze pagina kunt toevoegen.';
$string['nobody'] = 'Niemand';
$string['nochange'] = 'Geen wijziging';
$string['nocomments'] = 'Geen commentaren';
$string['nocourses'] = 'Geen cursussen';
$string['nocoursesfound'] = 'Er zijn geen cursussen gevonden met het woord \'{$a}\'';
$string['nocoursesyet'] = 'Er zijn geen cursussen in deze categorie';
$string['nodstpresets'] = 'De beheerder heeft de ondersteuning voor zomertijd niet ingeschakeld.';
$string['nofilesselected'] = 'Er zijn geen bestanden geselecteerd om terug te zetten';
$string['nofilesyet'] = 'Er zijn nog geen bestanden naar deze cursus geüpload';
$string['nograde'] = 'Nog geen cijfer';
$string['nohelpforactivityorresource'] = 'Er is nog geen hulp geassocieerd met deze bron of activiteit';
$string['noimagesyet'] = 'Er zijn nog geen afbeeldingen naar deze cursus geüpload';
$string['nologsfound'] = 'Geen logs gevonden';
$string['nomatchingusers'] = 'Geen gebruikers komen overeen met \'{$a}\'';
$string['nomorecourses'] = 'Er kunnen geen passende cursussen meer worden gevonden';
$string['nomoreidnumber'] = 'Er wordt geen idnummer gebruikt om botsingen te vermijden';
$string['none'] = 'Geen';
$string['noneditingteacher'] = 'Leraar zonder bewerken';
$string['noneditingteacherdescription'] = 'Een leraar zonder bewerken kan les geven in een cursus en kan leerlingen beoordelen, maar kan de activiteiten niet wijzigen';
$string['nonstandard'] = 'Niet-standaard';
$string['nopendingcourses'] = 'Er zijn geen cursusaanvragen die wachten op goedkeuring';
$string['nopotentialadmins'] = 'Geen mogelijke beheerders';
$string['nopotentialcreators'] = 'Geen mogelijke cursus-aanmakers';
$string['nopotentialstudents'] = 'Geen mogelijke leerlingen';
$string['nopotentialteachers'] = 'Geen mogelijke leraren';
$string['norecentactivity'] = 'Geen recente activiteit';
$string['noreplybouncemessage'] = 'Je hebt geantwoord op een niet-beantwoorden e-mailadres. Als je probeerde te antwoorden op een forumbericht, doe dat dan door gebruik te maken van de {$a} forums.

Dit was de inhoud van je e-mail:';
$string['noreplybouncesubject'] = '{$a} - geweigerde e-mail';
$string['noreplyname'] = 'Beantwoord deze e-mail niet door op "beantwoorden" te klikken.';
$string['noresetrecord'] = 'We hebben geen weet van deze aanvraag voor een nieuw wachtwoord. Vraag het wachtwoord opnieuw aan.';
$string['noresults'] = 'Geen resultaten';
$string['normal'] = 'Normaal';
$string['normalfilter'] = 'Gewoon zoeken';
$string['nosite'] = 'Kon geen site-niveaucursus vinden';
$string['nostudentsfound'] = 'Geen {$a} gevonden';
$string['nostudentsingroup'] = 'Er zijn nog geen leerlingen in deze groep';
$string['nostudentsyet'] = 'Er zijn nog geen leerlingen lid van deze cursus';
$string['nosuchemail'] = 'Dit e-mailadres is hier niet bekend';
$string['notavailable'] = 'Niet beschikbaar';
$string['noteachersyet'] = 'Er zijn nog geen leraren voor deze cursus';
$string['notenrolled'] = '{$a} is geen lid van deze cursus.';
$string['notenrolledprofile'] = 'Dit profiel kan niet bekeken worden omdat de gebruiker niet aangemeld is in deze cursus.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Opmerking:</strong>  de mogelijkheid om data te wijzigen tijdens het terugzetten van een back-up is uitgeschakeld omdat je het vereiste recht niet hebt.';
$string['noteuserschangednonetocourse'] = 'Let op: de gebruikers van een cursus moeten worden hersteld op het moment dat je gebruikersdata aan het terugzetten bent. Deze instelling is voor je veranderd.';
$string['nothingnew'] = 'Niets nieuws sinds je laatste login';
$string['nothingtodisplay'] = 'Er is niets om te tonen';
$string['notice'] = 'Opmerking';
$string['noticenewerbackup'] = 'Dit back-upbestand is gemaakt met Moodle {$a->backuprelease} ({$a->backupversion}) en is nieuwer dan je geïnstalleerde Moodle {$a->serverrelease} ({$a->serverversion}). Dit kan wat problemen veroorzaken omdat terugwaartse compatibiliteit van back-upbestanden niet gegarandeerd kan worden.';
$string['notifications'] = 'Meldingen';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP-adres: {$a->ip}, Gebruiker: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Je kunt deze logs bekijken op {$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Hier is een lijst van mislukte aanmeldingen op {$a} sinds je laatste notificatie';
$string['notifyloginfailuressubject'] = '{$a}::Notificatie van mislukte aanmeldingen';
$string['notincluded'] = 'Niet ingevoegd';
$string['notingroup'] = 'Om deze activiteit te kunnen zien moet je lid zijn van een groep.';
$string['notpublic'] = 'Niet publiek!';
$string['nousersfound'] = 'Geen gebruikers gevonden';
$string['nousersmatching'] = 'Er zijn geen gebruikers gevonden met de zoekterm \'{$a}\'';
$string['nousersyet'] = 'Er zijn nog geen gebruikers';
$string['novalidcourses'] = 'Er zijn geen geldige cursussen om te tonen.';
$string['now'] = 'Nu';
$string['numattempts'] = '{$a} mislukte aanmeldingspogingen';
$string['numberofcourses'] = 'Aantal cursussen';
$string['numberweeks'] = 'Aantal secties';
$string['numdays'] = '{$a} dagen';
$string['numhours'] = '{$a} uren';
$string['numletters'] = '{$a} letters';
$string['numminutes'] = '{$a} minuten';
$string['nummonths'] = '{$a} maanden';
$string['numseconds'] = '{$a} seconden';
$string['numviews'] = '{$a} keer bekeken';
$string['numweeks'] = '{$a} weken';
$string['numwords'] = '{$a} woorden';
$string['numyears'] = '{$a} jaren';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Huidig wachtwoord';
$string['olduserdirectory'] = 'Dit is de OUDE gebruikersmap. Deze is niet meer nodig. Je mag hem veilig verwijderen. De bestanden zijn naar de nieuwe gebruikersmap gekopiëerd.';
$string['opentoguests'] = 'Toegang voor gasten';
$string['optional'] = 'niet verplicht';
$string['options'] = 'opties';
$string['order'] = 'Volgorde';
$string['originalpath'] = 'Oorspronkelijk pad';
$string['orphanedactivitiesinsectionno'] = 'Verweesde activiteiten (sectie {$a})';
$string['other'] = 'Andere';
$string['outline'] = 'Overzicht';
$string['outlinereport'] = 'Overzichtsrapport';
$string['page'] = 'Pagina';
$string['pagea'] = 'Pagina {$a}';
$string['pageheaderconfigablock'] = 'Blok configureren in {$a->fullname}';
$string['pagepath'] = 'Paginapad';
$string['pageshouldredirect'] = 'Deze pagina zou je automatisch moeten doorverwijzen. Als er niets gebeurt, gebruik dan onderstaande link.';
$string['parentcategory'] = 'Bovenliggende categorie';
$string['parentcoursenotfound'] = 'Bovenliggende cursus niet gevonden';
$string['parentfolder'] = 'Bovenliggende map';
$string['participants'] = 'Deelnemers';
$string['participantslist'] = 'Deelnemerslijst';
$string['participationratio'] = 'Deelnemersratio';
$string['participationreport'] = 'Deelnemersrapport';
$string['password'] = 'Wachtwoord';
$string['passwordchanged'] = 'Het wachtwoord is veranderd';
$string['passwordconfirmchange'] = 'Bevestig de wijziging van het wachtwoord';
$string['passwordextlink'] = 'Volgende link dient om je verloren wachtwoord terug te krijgen. Hiermee zul je Moodle verlaten';
$string['passwordforgotten'] = 'Vergeten wachtwoord';
$string['passwordforgotteninstructions'] = 'Eerst moeten je gegevens in de databank gevonden worden. Zet daarom <strong>ofwel</strong> je gebruikersnaam of het e-mailadres dat je registreerde, in het juiste vakje. Het is niet nodig beide in te vullen.';
$string['passwordforgotteninstructions2'] = 'Stuur je gebruikersnaam of je e-mailadres in om je wachtwoord te resetten. Als we je terugvinden in de databank sturen we je een mail met instructies, zodat je je opnieuw kunt aanmelden.';
$string['passwordnohelp'] = 'Het is niet mogelijk je verloren wachtwoord terug te vinden. Neem contact op met de beheerder van deze Moodle site.';
$string['passwordrecovery'] = 'Ja, help me met inloggen';
$string['passwordsdiffer'] = 'De wachtwoorden komen niet overeen';
$string['passwordsent'] = 'Het wachtwoord is verzonden';
$string['passwordsenttext'] = '<p>Er is een e-mail verstuurd naar {$a->email}.</p>
<p><b>Bekijk je e-mail voor je nieuwe wachtwoord</b></p>
<p>Het nieuwe wachtwoord is automatisch aangemaakt, dus misschien wil je het <a hrefr="{$a->link}">wijzigen naar iets wat makkelijker te onthouden is</a>.</p>';
$string['passwordset'] = 'Je wachtwoord is ingesteld';
$string['path'] = 'Pad';
$string['pathnotexists'] = 'Dit pad bestaat niet op je server!';
$string['pathslasherror'] = 'Het pad mag niet eindigen met een schuine streep!';
$string['paymentinstant'] = 'Gebruik de knop om te betalen en je zult binnen enkele minuten aangemeld zijn!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> open</small>)';
$string['paymentrequired'] = 'Betaling vereist om deze cursus binnen te gaan.';
$string['payments'] = 'Betalingen';
$string['paymentsorry'] = 'Bedankt voor je betaling! Jammer genoeg is je betaling nog niet volledig verwerkt en ben je nog niet geregistreerd om de cursus "{$a->fullname}" binnen te gaan. Probeer binnen enkele seconden nog eens de cursus binnen te gaan, maar als je blijft problemen hebben, waarschuw dan de {$a->teacher} of de site beheerder';
$string['paymentthanks'] = 'Bedankt voor je betaling! Je bent nu aangemeld in je cursus:<br />"{$a}"';
$string['pendingrequests'] = 'Wachtende aanvragen';
$string['periodending'] = 'Periode eindigt ({$a})';
$string['perpage'] = 'Per pagina';
$string['perpagea'] = 'Per pagina: {$a}';
$string['personal'] = 'Persoonlijk';
$string['personalprofile'] = 'Persoonlijk profiel';
$string['phone'] = 'Telefoon';
$string['phone2'] = 'Mobiele telefoon';
$string['phpinfo'] = 'PHP-info';
$string['pictureof'] = 'Foto van {$a}';
$string['pictureofuser'] = 'Gebruikersafbeelding';
$string['pleaseclose'] = 'Sluit dit venster.';
$string['pleasesearchmore'] = 'Zoek verder';
$string['pleaseusesearch'] = 'Gebruik de zoekfunctie';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Controle van de plugins';
$string['plugindeletefiles'] = 'Alle gegevens die geassocieerd zijn met \'{$a->name}\' zijn uit de databank  verwijderd. Om te voorkomen dat de plugin zichzelf opnieuw installeerd, moet je nu deze map van je server verwijderen: {$a->directory}';
$string['pluginsetup'] = 'Installeren van plugintabellen';
$string['policyaccept'] = 'Ik begrijp het en ga akkoord';
$string['policyagree'] = 'Je moet akkoord gaan met deze overeenkomst voor je verder kunt gaan met het gebruiken van deze site. Ga je akkoord?';
$string['policyagreement'] = 'Overeenkomst voor  het gebruik van deze site';
$string['policyagreementclick'] = 'Link naar de gebruiksovereenkomst voor deze site';
$string['popup'] = 'pop-up';
$string['popupwindow'] = 'Open het bestand in een nieuw venster';
$string['popupwindowname'] = 'Pop-upvenster';
$string['post'] = 'Posten';
$string['posts'] = 'Berichten';
$string['potentialadmins'] = 'Mogelijke beheerders';
$string['potentialcreators'] = 'Mogelijke cursus-aanmakers';
$string['potentialstudents'] = 'Mogelijke leerlingen';
$string['potentialteachers'] = 'Mogelijke leraren';
$string['preferences'] = 'Voorkeuren';
$string['preferredlanguage'] = 'Voorkeurstaal';
$string['preferredtheme'] = 'Voorkeursthema';
$string['preprocessingbackupfile'] = 'Voorbereiding back-upbestand';
$string['prev'] = 'Vorige';
$string['preview'] = 'Bekijk';
$string['previewhtml'] = 'Voorbeeld HTML-opmaak';
$string['previeworchoose'] = 'Bekijk of kies een thema';
$string['previous'] = 'Vorige';
$string['previouslyselectedusers'] = 'Eerder geselecteerde gebruikers die niet overeenkomen met \'{$a}\'';
$string['previoussection'] = 'Vorige sectie';
$string['primaryadminsetup'] = 'Instellingen van de beheerdersaccount';
$string['profile'] = 'Profiel';
$string['profilenotshown'] = 'Deze profielbeschrijving zal niet getoond worden tot deze persoon aangemeld is in minstens één cursus';
$string['publicprofile'] = 'Publiek profiel';
$string['publicsitefileswarning'] = 'Let op: bestanden die hier worden geplaatst zijn voor iedereen toegankelijk';
$string['publicsitefileswarning2'] = 'Opmerking: Bestanden die hier staan kunnen door iedereen die de URL weet (of kan raden) gelezen worden. Om veiligheidsredenen wordt aangeraden om back-upbestanden onmiddellijk te verwijderen na terugzetten.';
$string['publicsitefileswarning3'] = 'Opmerking: Bestanden die hier staan kunnen door iedereen die de URL weet (of kan raden) gelezen worden.<br /> Om veiligheidsredenen wordt aangeraden om back-upbestanden alleen te bewaren in een de veilige back-upmap.';
$string['publish'] = 'Publiceer';
$string['question'] = 'Vraag';
$string['questionsinthequestionbank'] = 'Vragen in de vragenbank';
$string['readinginfofrombackup'] = 'Info van de back-up lezen';
$string['readme'] = 'LEESME';
$string['recentactivity'] = 'Recente activiteit';
$string['recentactivityreport'] = 'Volledig rapport van recente wijzigingen...';
$string['recipientslist'] = 'Lijst ontvangers';
$string['recreatedcategory'] = 'Categorie {$a} opnieuw gemaakt';
$string['redirect'] = 'Doorverwijspagina';
$string['reducesections'] = 'Verminder het aantal secties';
$string['refresh'] = 'Vernieuw';
$string['refreshingevents'] = 'Kalender bijwerken';
$string['registration'] = 'Moodleregistratie';
$string['registrationcontact'] = 'Publiek contact';
$string['registrationcontactno'] = 'Nee, ik wil geen contactformulier op de site';
$string['registrationcontactyes'] = 'Ja, toon een formulier zodat andere Moodlegebruikers me kunnen contacteren';
$string['registrationemail'] = 'E-mailmeldingen';
$string['registrationinfo'] = '<p>Deze pagina laat je toe om Moodle te registreren bij moodle.org.
De registratie is gratis.
Het belangrijkste voordeel is dat registratie je toevoegt aan een mailinglist, uitsluitend voor belangrijke meldingen zoals beveiligingsproblemen en nieuwe releases van Moodle.
<p>Je informatie wordt privé gehouden en zal nooit verkocht of doorgegeven worden aan derden. De enige reden voor het inzamelen van deze informatie, is het leveren van hulp en het uitbouwen van een statistisch beeld van de Moodle-gemeenschap.</p>
<p>Als je wil kan je toelaten om je sitenaam, land en URL toe te voegen aan de openbare lijst van Moodle Sites.</p>
<p>Alle nieuwe registraties worden manueel gecontroleerd voor ze toegevoegd worden aan de lijst. Je kunt je gegevens steeds bijwerken door dit formulier terug te posten.</p>';
$string['registrationinfotitle'] = 'Registratie-informatie';
$string['registrationno'] = 'Nee, ik wil geen e-mail ontvangen';
$string['registrationsend'] = 'Stuur de registratie-informatie naar moodle.org';
$string['registrationyes'] = 'Ja, laat me iets weten als er iets belangrijks gebeurt';
$string['reject'] = 'Verwerp';
$string['rejectdots'] = 'Verwerp...';
$string['reload'] = 'Opnieuw laden';
$string['remoteappuser'] = 'Gebruiker {$a} op andere server';
$string['remove'] = 'Verwijder';
$string['removeadmin'] = 'Verwijder beheerder';
$string['removecreator'] = 'Verwijder cursus-aanmaker';
$string['removestudent'] = 'Verwijder leerling';
$string['removeteacher'] = 'Verwijder leraar';
$string['rename'] = 'Hernoem';
$string['renamefileto'] = 'Hernoem <b>{$a}</b> naar';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporten';
$string['repositories'] = 'Bibliotheken';
$string['requestcourse'] = 'Vraag een nieuwe cursus';
$string['requestedby'] = 'Gevraagd door';
$string['requestedcourses'] = 'Gevraagde cursussen';
$string['requestreason'] = 'Motivatie voor de vraag';
$string['required'] = 'Verplicht';
$string['requirespayment'] = 'Voor toegang tot deze cursus is betaling vereist';
$string['reset'] = 'Standaardinstellingen';
$string['resetcomponent'] = 'Component';
$string['resetcourse'] = 'Cursus terug op standaardinstellingen';
$string['resetinfo'] = 'Met deze pagina kun je de gebruikersgegevens uit een cursus halen, terwijl je de activiteiten en andere instellingen behoudt. Let op: het kiezen van de onderstaande instellingen en het insturen van deze pagina zal de gekozen gebruikersgegevens voor altijd verwijderen!';
$string['resetnotimplemented'] = 'Reset niet geïmplementeerd';
$string['resetrecordexpired'] = 'De link om je wachtwoord te resetten is meer dan {$a} minuten oud en is verlopen.
Vraag opnieuw een nieuw wachtwoord aan.';
$string['resetstartdate'] = 'Standaardwaarde datum';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Taak';
$string['resettodefaults'] = 'Herstel standaardinstellingen';
$string['resortbyfullname'] = 'Op volledige naam';
$string['resortbyidnumber'] = 'Op IDnummer';
$string['resortbyshortname'] = 'Op korte naam';
$string['resortcourses'] = 'Sorteer cursussen';
$string['resortsubcategoriesbyidnumber'] = 'Sorteer subcategorieën op IDnummer';
$string['resortsubcategoriesbyname'] = 'Sorteer subcategorieën op naam';
$string['resource'] = 'Bron';
$string['resourcedisplayauto'] = 'Automatisch';
$string['resourcedisplaydownload'] = 'Download verplicht';
$string['resourcedisplayembed'] = 'In browser';
$string['resourcedisplayframe'] = 'In frame';
$string['resourcedisplaynew'] = 'Nieuw venster';
$string['resourcedisplayopen'] = 'Open ';
$string['resourcedisplaypopup'] = 'In pop-up';
$string['resources'] = 'Bronnen';
$string['resources_help'] = 'Met bronnen kun je bijna alle soorten webinhoud aan je cursus toevoegen';
$string['restore'] = 'Terugzetten';
$string['restorecancelled'] = 'Back-up terugzetten geannuleerd';
$string['restorecannotassignroles'] = 'Het proces dat de back-up terugzet moet rollen toewijzen en jij hebt daar niet het recht toe';
$string['restorecannotcreateorassignroles'] = 'Het proces dat de back-up terugzet moet rollen maken of toewijzen en jij hebt daar niet het recht toe';
$string['restorecannotcreateuser'] = 'Het terugzetten van de back-up vereist het aanmaken van gebruiker \'{$a}\' uit het back-upbestand en jij het het recht niet om dat te doen';
$string['restorecannotoverrideperms'] = 'Het proces dat de back-up terugzet moet rollen overschrijven en jij hebt daar niet het recht toe';
$string['restorecoursenow'] = 'Deze cursus nu terugzetten!';
$string['restoredaccount'] = 'Teruggezette account';
$string['restoredaccountinfo'] = 'Deze account is geïmporteerd uit een andere server en het wachtwoord ervan is verloren gegaan. Om eeen nieuw wachtwoord via e-mail in te stellen, klik op "Ga verder"';
$string['restorefinished'] = 'Terugzetten was succesvol';
$string['restoreto'] = 'Zet de back-up terug naar';
$string['restoretositeadding'] = 'Waarschuwing: je gaat terugzetten naar de startpagina van de site en er gegevens aan toevoegen!';
$string['restoretositedeleting'] = 'Waarschuwing: je gaat terugzetten naar de startpagina van de site waarbij eerst gegevens zullen verwijderd worden!';
$string['restoreuserconflict'] = 'Het terugzetten van gebruiker \'{$a}\' uit de back-up zal een conflict veroorzaken';
$string['restoreuserinfofailed'] = 'Het terugzetten van de back-up is gestopt omdat je het recht niet hebt om gebruikersgegevens terug te zetten.';
$string['restoreusersprecheck'] = 'Gebruikersgegevens controleren';
$string['restoreusersprecheckerror'] = 'Er zijn problemen gevonden bij het controleren van gebruikersgegevens';
$string['restricted'] = 'Beperkt';
$string['returningtosite'] = 'Al eerder op deze website geweest?';
$string['returntooriginaluser'] = 'Keer terug naar {$a}';
$string['revert'] = 'Keer terug';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Roltoewijzingen';
$string['rolemappings'] = 'Rollen koppelen';
$string['rolerenaming'] = 'Hernoemen van rollen';
$string['rolerenaming_help'] = 'Met deze opties kun je de getoonde namen van rollen die je in je cursus gebruikt wijzigen. Enkel de getoonde naam wordt gewijzigd - de onderliggende rechten van de rol worden niet gewijzigd.
Deze nieuwe rolnamen zullen verschijnen op de deelnemerspagina van de cursus en op andere plaatsen in de cursus waar rollen getoond worden. Als de hernoemde rol er één is die de beheerder als "leraar" in de cursus aangeduid heeft, dan zal de nieuwe rolnaam ook verschijnen in de  cursusbeschrijving.';
$string['roles'] = 'Rollen';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Aantal recente RSS-artikels';
$string['rsserror'] = 'Fout tijdens het lezen van de RSS-gegevens';
$string['rsserrorauth'] = 'Je RSS-link bevat geen geldig authenticatietoken.';
$string['rsserrorguest'] = 'Deze feed gebruikt gasttoegang om toegang tot de gegevens te krijgen, maar de gast-account heeft geen rechten om de gegevens te lezen. Bezoek de oorspronkelijke locatie van deze feed als geldige gebruiker en haal daar een nieuwe RSS-link';
$string['rsskeyshelp'] = 'Om veiligheid en privacy te verzekeren, bevatten de RSS feed URL\'s een token dat de gebruiker identificeerd waarvoor ze bestemd zijn. Dit voorkomt dat andere gebruikers toegang hebben tot delen van Moodle die ze niet zouden moeten hebben door RSS feeds te gebruiken.</p><p>Dit token wordt de eerste keer dat je in een zone komt die RSS feeds maakt automatisch gegenereerd. Als je denkt dat jouw RSS feed token misbruikt wordt, dan kun je een nieuw token vragen door te klikken op  \'Link resetten\'. Merk op dat je huidige RSS feed URL\'s niet meer zullen werken.';
$string['rsstype'] = 'RSS-feed voor deze activiteit';
$string['saveandnext'] = 'Bewaar en toon volgende';
$string['savechanges'] = 'Bewaar de wijzigingen';
$string['savechangesanddisplay'] = 'Bewaar de wijzigingen en toon';
$string['savechangesandreturntocourse'] = 'Bewaar de wijzigingen en keer terug naar de cursuspagina';
$string['savecomment'] = 'Bewaar notitie';
$string['savedat'] = 'Bewaard op:';
$string['savepreferences'] = 'Instellingen bewaren';
$string['saveto'] = 'Bewaar op';
$string['scale'] = 'Schaal';
$string['scale_help'] = '<p>Leraren kunnen nieuwe, aangepaste schalen maken om in hun cursus te gebruiken voor allerlei beoordelingen.
</p>

<p>De naam van de schaal zou de schaal duidelijk moeten identificeren: deze naam zal verschijnen in een schaal-selectielijst
en onder contextgevoelige helpknoppen</p>

<p>De schaal zelf wordt gedefinieerd door een geordende lijst van waarden, gerangschikt van negatief naar positief en gescheiden door komma\'s. Bijvoorbeeld:</p>

<blockquote><em>
   Teleurstellend, Niet goed genoeg, Matig, Goed, Zeer goed, Uitstekend!
</em></blockquote>

<p>Een schaal moet ook voorzien worden van een goede beschrijving over wat ze bedoelt en hoe ze zou moeten gebruikt worden.
Deze beschrijving zal verschijnen in helppagina\'s voor leerlingen en leraren.</p>
<p>Met behulp van het edit-icoon kan de schaal achteraf nog gewijzigd worden, met het kruisje kun je de schaal verwijderen</p>

<p>De beheerder van de site kan van een aangepaste schaal van een cursus in de groep van de standaardschalen zetten. Op die manier kan  die schaal in alle cursussen gebruikt worden. De beheerder kan dit doen door in gelijk welke cursus een schaal met het pijltje te verplaatsen van de groep van de aangepaste schalen naar de groep met de standaardschalen.Tenslotte kunnen er één of meer "Standaard" schalen gedefiniëerd worden door je systeembeheerder.</p>
<p>Let op: wanneer een schaal in gebruik is, kan er niets meer aan gewijzigd worden. Ze kan ook niet meer van groep (standaardschalen , aangepaste schalen) verwisselen.</p>';
$string['scales'] = 'Schalen';
$string['scalescustom'] = 'Aangepaste schalen';
$string['scalescustomcreate'] = 'Voeg een nieuwe schaal toe';
$string['scalescustomno'] = 'Er zijn nog geen aangepaste schalen gemaakt';
$string['scalesstandard'] = 'Standaardschalen';
$string['scalestandard'] = 'Standaardschaal';
$string['scalestandard_help'] = '<p>Een standaardschaal is een schaal die voor de hele site beschikbaar is, voor alle cursussen.</p>';
$string['scalestip'] = 'Om aangepaste schalen te maken, gebruik je de link
\'Schalen...\'in het beheermenu van je cursus';
$string['scalestip2'] = 'Om aangepaste beoordelingsschalen te maken klik je op Cijfers in het beheermenu van de cursus, kies dan Bewerk, Schalen.';
$string['schedule'] = 'Planning';
$string['screenshot'] = 'Schermafdruk';
$string['search'] = 'Zoek';
$string['searchagain'] = 'Zoek nog een keer';
$string['searchbyemail'] = 'Zoek op e-mailadres';
$string['searchbyusername'] = 'Zoek op gebruikersnaam';
$string['searchcourses'] = 'Zoek cursussen';
$string['searchhelp'] = '<p>Je kunt naar meer woorden tegelijkertijd zoeken.</p>
<ul>
<li>woord : zoek naar elke instantie van dit woord in de tekst.</li>
<li>+word : alleen precies passende woorden worden gevonden.<:li>
<li>-word : de resultaten waar dit woord in voorkomt worden niet getoond.</li>
</ul>';
$string['search_help'] = 'Voor het standaard zoeken met één of meer worden in de tekst, geef je je zoektermen in gescheiden door spaties. Alle woorden, langer dan twee tekens worden gebruikt.

Voor geavanceerd zoeken, klik je op op de zoekknop zonder iets in het zoekvenster te typen om zo in het formulier voor geavanceerd zoeken terecht te komen.';
$string['searchoptions'] = 'Zoekopties';
$string['searchresults'] = 'Zoekresultaten';
$string['sec'] = 'seconde';
$string['seconds'] = 'seconden';
$string['secondstotime172800'] = '2 dagen';
$string['secondstotime259200'] = '3  dagen';
$string['secondstotime345600'] = '4  dagen';
$string['secondstotime432000'] = '5  dagen';
$string['secondstotime518400'] = '6 dagen';
$string['secondstotime604800'] = '1 week';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'De link voor het wijzigen van het wachtwoord was al gebruikt - wachtwoord niet gewijzigd';
$string['secs'] = 'seconden';
$string['section'] = 'Sectie';
$string['sectionname'] = 'Sectienaam';
$string['sections'] = 'Secties';
$string['sectionusedefaultname'] = 'Gebruik standaard sectienaam';
$string['seealsostats'] = 'Zie ook: statistieken';
$string['selctauser'] = 'Selecteer een gebruiker';
$string['select'] = 'Kies';
$string['selectacategory'] = 'Selecteer een categorie';
$string['selectacountry'] = 'Kies een land';
$string['selectacourse'] = 'Selecteer een cursus';
$string['selectacoursesite'] = 'Selecteer een cursus of site';
$string['selectagroup'] = 'Selecteer een groep';
$string['selectall'] = 'Selecteer alles';
$string['selectamodule'] = 'Kies een activiteitenmodule';
$string['selectanaction'] = 'Selecteer een actie';
$string['selectanoptions'] = 'Selecteer een optie';
$string['selectaregion'] = 'Kies een plaats';
$string['selectcategorysort'] = 'Welke categorieën je wil sorteren?';
$string['selectcategorysortby'] = 'Selecteer hoe je categorieën wil sorteren';
$string['selectcoursesortby'] = 'Selecteer hoe je curussen wil sorteren';
$string['selectdefault'] = 'Kies standaard';
$string['selectedcategories'] = 'Geselecteerde categorieën';
$string['selectedfile'] = 'Kies een bestand';
$string['selectednowmove'] = '{$a} bestanden zijn geselecteerd voor verplaatsen. Ga nu naar de bestemmingsmap en klik op \'Verplaats bestanden hier naar toe\'';
$string['selectfiles'] = 'Selecteer bestanden';
$string['selectmoduletoviewhelp'] = 'Kies een activiteit of bron en er zal hulp voor verschijnen.

Dubbelklik een activiteit of bron om ze vlug toe te voegen.';
$string['selectnos'] = 'Kies overal \'nee\'';
$string['selectperiod'] = 'Kies periode';
$string['senddetails'] = 'Stuur me mijn gebruikersnaam en een nieuw wachtwoord';
$string['separate'] = 'Gescheiden';
$string['separateandconnected'] = 'Gescheiden en Verbonden/relationele manieren van kennen';
$string['separateandconnectedinfo'] = 'De schaal is gebaseerd op de theorie van gescheiden en relationele manieren van kennen. Deze theorie beschrijft twee verschillende manieren waarop we wat we zien en horen kunnen evalueren en leren.
<ul>
<li><strong>Gescheiden kenners</strong> blijven zo objectief mogelijk zonder gevoelens en emoties op te nemen. In een discussie met anderen zullen zij graag hun eigen ideeën verdedigen door het gebruik van logica en het vinden van fouten in de ideën van hun tegenstanders.</li><li><strong>Relationele kenners</strong> zijn meer gevoelig voor anderen. Zij zijn bedreven in de empathie en luisteren en stellen vragen tot ze verbondenheid voelen en de dingen "begrijpen vanuit hun standpunt". Zij leren door te proberen  ervaringen te delen die lijden tot de kennis die ze in anderen vinden.</li><ul>';
$string['servererror'] = 'Er is een fout opgetreden tijdens de communicatie met de server';
$string['serverlocaltime'] = 'De lokale tijd van de server';
$string['setcategorytheme'] = 'Kies categoriethema';
$string['setpassword'] = 'Wachtwoord aanpassen';
$string['setpasswordinstructions'] = 'Geef en herhaal hier je nieuwe wachtwoord. Klik dan op "Wachtwoord aanpassen".<br />Je nieuwe wachtwoord wordt bewaard en je zult aangemeld worden.';
$string['settings'] = 'Instellingen';
$string['shortname'] = 'Korte naam';
$string['shortnamecollisionwarning'] = '[*]=Deze korte naam is al in gebruik door een andere cursus en zal gewijzigd moeten worden tijdens het goedkeuren';
$string['shortnamecourse'] = 'Korte naam van de cursus';
$string['shortnamecourse_help'] = '<p>Veel instituten hebben afkortingen die verwijzen naar cursussen, zoals BP102 of COMMS.
Zelfs al heb je zo\'n afkortingen niet, dan is het nog interessant er hier één te maken. De afkorting wordt gebruikt
waar de lange naam niet nodig is (zoals bij het onderwerp in een e-mail)</p>';
$string['shortnametaken'] = 'Korte naam is al in gebruik voor een andere cursus ({$a})';
$string['shortnameuser'] = 'Korte naam van de gebruiker';
$string['shortsitename'] = 'Korte naam van de site (bijv. één woord)';
$string['show'] = 'Toon';
$string['showactions'] = 'Toon acties';
$string['showadvancedsettings'] = 'Toon geavanceerde instellingen';
$string['showall'] = 'Laat alle {$a} zien';
$string['showallcourses'] = 'Laat alle cursussen zien';
$string['showallusers'] = 'Laat alle gebruikers zien';
$string['showblockcourse'] = 'Toon een lijst met cursussen met dit blok';
$string['showcategory'] = 'Toon {$a}';
$string['showcomments'] = 'Toon/verberg notities';
$string['showcommentsnonjs'] = 'Toon commentaren';
$string['showdescription'] = 'Toon beschrijving op cursuspagina';
$string['showdescription_help'] = 'Indien ingeschakeld zal de introductie/beschrijving  hierboven getoond worden op de cursuspagina juist onder de link naar de activiteit/bron.';
$string['showgrades'] = 'Laat cijfers aan leerlingen zien';
$string['showgrades_help'] = '<p>Voor de meeste activiteiten is het mogelijk cijfers te geven.</p>

<p>De standaardinstelling is dat de resultaten van alle activiteiten binnen een
 cursus bekeken kunnen worden op de cijferpagina. Die is beschikbaar vanuit de hoofdpagina
 van de cursus.</p>

<p>Als een leraar niet geïnteresseerd is in het gebruiken van cijfers binnen
 een cursus, of als hij de cijfers wil verbergen voor de leerlingen, dan
  kan het tonen van cijfers uitgezet worden bij de vakinstellingen. Het is
   dan nog wel mogelijk om cijfers te geven voor individuele activiteiten, de
   cijfers zullen alleen niet worden getoond.</p>';
$string['showingacourses'] = 'Toon alle {$a} cursussen';
$string['showingxofycourses'] = 'Toon cursussen {$a->start} tot {$a->end} van {$a->total} cursussen';
$string['showlistofcourses'] = 'Laat de lijst met cursussen zien';
$string['showmodulecourse'] = 'Toon een lijst met cursussen met deze activiteit';
$string['showonly'] = 'Toon enkel';
$string['showperpage'] = 'Toon {$a} per pagina';
$string['showrecent'] = 'Laat recente wijzigingen zien';
$string['showreports'] = 'Toon activiteitenrapporten';
$string['showreports_help'] = '<p>Elke deelnemer van een cursus kan zijn activiteitenrapporten raadplegen. Zij tonen zijn activiteiten binnen
de huidige cursus, net als lijsten van al zijn bijdragen. In deze rapporten zie je gedetailleerde logs.</p>

<p>Leraren hebben altijd toegang tot die rapporten met de knop die te vinden is op de pagina met het gebruikersprofiel
van elke deelnemer.</p>

<p>De toegang van leerlingen tot hun eigen rapporten wordt gecontroleerd door de leraar via de cursusinstellingen. Voor
sommige cursussen kunnen deze rapporten nuttig zijn om de leerlingen te laten terugblikken op hun eigen inzet en
aanwezigheid binnen de elektronische leeromgeving, voor andere cursussen kan dit overbodig zijn.</p>

<p>Een andere reden waarom je activiteitenrapporten zou af zetten, is dat het genereren van het rapport een grote serverbelasting kan
veroorzaken. Voor grote klassen en langlopende cursussen kan het beter zijn om de optie te laten afstaan.<p>';
$string['showsettings'] = 'Toon instellingen';
$string['showtheselogs'] = 'Toon deze logs';
$string['showthishelpinlanguage'] = 'Toon dit helpbestand in het {$a}';
$string['since'] = 'Sinds';
$string['sincelast'] = 'sinds laatste aanmelding';
$string['site'] = 'Site';
$string['sitedefault'] = 'Standaardinstelling voor de site';
$string['siteerrors'] = 'Sitefouten';
$string['sitefiles'] = 'Sitebestanden';
$string['sitefilesused'] = 'Site-bestanden in deze cursus gebruikt';
$string['sitehome'] = 'Site startpagina';
$string['sitelegacyfiles'] = 'Verouderde site-bestanden';
$string['sitelogs'] = 'Sitelogs';
$string['sitemessage'] = 'Bericht gebruikers';
$string['sitenews'] = 'Sitenieuws';
$string['sitepages'] = 'Site pagina\'s';
$string['sitepartlist'] = 'Je hebt onvoldoende rechten om de deelnemerslijst te zien';
$string['sitepartlist0'] = 'Je moet een leraar van de site zijn om de deelnemerslijst te kunnen zien';
$string['sitepartlist1'] = 'Je moet een leraar zijn om de deelnemerslijst van de site te kunnen zien';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Voeg een onderwerpsectie toe';
$string['sitesettings'] = 'Site-instellingen';
$string['siteteachers'] = 'Siteleraren';
$string['size'] = 'Grootte';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Overgeslagen';
$string['skiptocategorylisting'] = 'Ga onmiddellijk naar categorielijsten';
$string['skiptocoursedetails'] = 'Ga onmiddellijk naar gedetailleerde cursusinformatie';
$string['skiptocourselisting'] = 'Ga onmiddellijk naar cursuslijsten';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Sociale forum - meest recente onderwerpen';
$string['someallowguest'] = 'Gasten hebben toegang tot sommige cursussen';
$string['someerrorswerefound'] = 'Bepaalde informatie ontbrak of was fout. Kijk hieronder voor de details.';
$string['sort'] = 'Sorteer';
$string['sortby'] = 'Sorteer volgens';
$string['sortbyx'] = 'Sorteer volgens {$a} oplopend';
$string['sortbyxreverse'] = 'Sorteer volgens {$a} aflopend';
$string['sortcategoriesbyidnumber'] = 'Sorteer categorieën op IDnummer';
$string['sortcategoriesbyname'] = 'Sorteer categorieën op naam';
$string['sortcoursesbyfullname'] = 'Sorteer cursussen op volledige naam';
$string['sortcoursesbyidnumber'] = 'Sorteer cursussen op IDnummer';
$string['sortcoursesbyshortname'] = 'Sorteer cursussen op korte naam';
$string['sorting'] = 'Sorteren';
$string['sourcerole'] = 'Bron rol';
$string['specifyname'] = 'Je moet een naam geven';
$string['standard'] = 'Standaard';
$string['starpending'] = '[*]=cursus wacht op goedkeuring';
$string['startdate'] = 'Begindatum van de cursus';
$string['startdate_help'] = 'Deze instelling bepaalt de start van de eerste week voor een cursus in weekformat. Ze bepaalt ook de vroegste datum waarvoor logs voor deze cursus beschikbaar zullen zijn.';
$string['startingfrom'] = 'Starten vanaf';
$string['startsignup'] = 'Nieuwe account maken';
$string['state'] = 'Staat / Provincie';
$string['statistics'] = 'Statistieken';
$string['statisticsgraph'] = 'Statistieken: grafiek';
$string['stats'] = 'Statistieken';
$string['statslogins'] = 'Aanmeldingen';
$string['statsmodedetailed'] = 'Meer details';
$string['statsmodegeneral'] = 'Algemeen overzicht';
$string['statsnodata'] = 'Er zijn geen gegevens voor die combinatie van cursus en tijdsperiode.';
$string['statsnodatauser'] = 'Er zijn geen gegevens voor die combinatie van vak, gebruiker en tijdsperiode.';
$string['statsoff'] = 'Statistieken zijn uitgeschakeld';
$string['statsreads'] = 'Bekeken pagina\'s';
$string['statsreport1'] = 'Login';
$string['statsreport10'] = 'Gebruikersactiviteit';
$string['statsreport11'] = 'Meest actieve cursussen';
$string['statsreport12'] = 'Meest actieve cursussen (gewogen)';
$string['statsreport13'] = 'Meest deelnemende cursus (aanmeldingen)';
$string['statsreport14'] = 'Meest deelnemende cursus (bekeken pagina\'s/berichten)';
$string['statsreport2'] = 'Pagina\'s (alle rollen)';
$string['statsreport3'] = 'Berichten (alle rollen)';
$string['statsreport4'] = 'Alle activiteiten (alle rollen)';
$string['statsreport5'] = 'Alle activiteit (pagina\'s en berichten)';
$string['statsreport7'] = 'Gebruikersactiviteit (pagina\'s en berichten)';
$string['statsreport8'] = 'Alle gebruikersactiviteit';
$string['statsreport9'] = 'Login (site cursus)';
$string['statsreportactivity'] = 'Alle activiteit (alle rollen)';
$string['statsreportactivitybyrole'] = 'Alle activiteiten (bekeken pagina\'s en ingestuurde berichten)';
$string['statsreportforuser'] = 'voor';
$string['statsreportlogins'] = 'Login';
$string['statsreportreads'] = 'Pagina\'s (alle rollen)';
$string['statsreporttype'] = 'Rapporttype';
$string['statsreportwrites'] = 'Berichten (alle rollen)';
$string['statsstudentactivity'] = 'Leerlingactiviteit';
$string['statsstudentreads'] = 'Leerling: pagina\'s';
$string['statsstudentwrites'] = 'Leerling: berichten';
$string['statsteacheractivity'] = 'Lerarenactiviteit';
$string['statsteacherreads'] = 'Leraar: pagina\'s';
$string['statsteacherwrites'] = 'Leraar: berichten';
$string['statstimeperiod'] = 'Periode:';
$string['statsuniquelogins'] = 'Unieke login';
$string['statsuseractivity'] = 'Alle activiteit';
$string['statsuserlogins'] = 'Login';
$string['statsuserreads'] = 'Pagina\'s';
$string['statsuserwrites'] = 'Berichten';
$string['statswrites'] = 'Berichten';
$string['status'] = 'Status';
$string['stringsnotset'] = 'De volgende strings zijn niet gedefinieerd in {$a}';
$string['studentnotallowed'] = 'Het spijt me, maar je kunt deze cursus niet binnengaan als \'{$a}\'';
$string['students'] = 'Leerlingen';
$string['studentsandteachers'] = 'Leerlingen en leraren';
$string['subcategories'] = 'Subcategorieën';
$string['subcategory'] = 'Subcategorie';
$string['subcategoryof'] = 'Subcategorie van {$a}';
$string['submit'] = 'Insturen';
$string['success'] = 'Succes';
$string['summary'] = 'Beschrijving';
$string['summary_help'] = '<p>Een onderwerpbeschrijving is een korte tekst die de leerlingen voorbereidt op de activiteiten
binnen dit onderwerp (of week).</p>


<p>De beschrijving zou erg kort moeten zijn, zodat de pagina met de cursussenlijst niet te lang wordt.</p>


<p>Als je vindt dat je meer wil schrijven dan een tweetal zinnen, overweeg dan om een bron
aan dit onderwerp toe te voegen. (de eerste activiteit zou bijvoorbeeld een pagina kunnen
zijn die heet <b>Over dit onderwerp</b>).</p>';
$string['summaryof'] = 'Beschrijving van {$a}';
$string['supplyinfo'] = 'Meer details';
$string['suspended'] = 'Geschorst';
$string['suspendedusers'] = 'Geschorste gebruikers';
$string['switchdevicedefault'] = 'Schakel over naar standaard thema';
$string['switchdevicerecommended'] = 'Schakel over naar het aangewezen thema voor jou toestel';
$string['switchrolereturn'] = 'Terug naar mijn rol';
$string['switchroleto'] = 'Wijzig rol naar ...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Deze tag bestaat al';
$string['tagmanagement'] = 'Tags beheren';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Doel rol';
$string['teacheronly'] = 'alleen maar voor de {$a}';
$string['teacherroles'] = '{$a} rollen';
$string['teachers'] = 'leraren';
$string['textediting'] = 'Teksteditor';
$string['texteditor'] = 'Gebruik standaardwebformulieren';
$string['textformat'] = 'Plattetekstopmaak';
$string['thanks'] = 'Bedankt';
$string['theme'] = 'Thema';
$string['themes'] = 'Thema\'s';
$string['themesaved'] = 'Het nieuwe thema is bewaard';
$string['therearecourses'] = 'Er zijn {$a} cursussen';
$string['thereareno'] = 'Er zijn geen {$a} in deze cursus';
$string['thiscategory'] = 'Deze categorie';
$string['thiscategorycontains'] = 'Deze categorie bevat';
$string['time'] = 'Tijd';
$string['timezone'] = 'Tijdzone';
$string['to'] = 'Tot';
$string['tocontent'] = 'Naar item "{$a}"';
$string['tocreatenewaccount'] = 'Overslaan om een nieuwe account te maken';
$string['today'] = 'Vandaag';
$string['todaylogs'] = 'Logs van vandaag';
$string['toeveryone'] = 'Aan iedereen';
$string['toomanybounces'] = 'Dat e-mailadres heeft te veel e-mails teruggestuurd. Je <b>moet</b> het wijzigen voor je verder kunt.';
$string['toomanytoshow'] = 'Er zijn te veel gebruikers om te laten zien';
$string['toomanyusersmatchsearch'] = 'Teveel gebruikers \'{$a->count}\' komen overeen met \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Teveel gebruikers ({$a}) om te tonen';
$string['toonly'] = 'Aan {$a} alleen';
$string['top'] = 'Hoogste niveau';
$string['topic'] = 'Onderwerp';
$string['topichide'] = 'Verberg dit onderwerp voor {$a}';
$string['topicoutline'] = 'Overzicht van het onderwerp';
$string['topicshow'] = 'Toon dit onderwerp aan {$a}';
$string['toplevelcategory'] = 'Bovenste categorie';
$string['total'] = 'Totaal';
$string['totopofsection'] = 'Naar bovenaan sectie "{$a}"';
$string['trackforums'] = 'Forum opvolgen';
$string['trackforumsno'] = 'Nee: hou niet bij welke berichten ik al heb gelezen';
$string['trackforumsyes'] = 'Ja: markeer berichten die ik nog niet heb gelezen';
$string['trysearching'] = 'Probeer te zoeken';
$string['turneditingoff'] = 'Zet wijzigen uit';
$string['turneditingon'] = 'Zet wijzigen aan';
$string['undecided'] = 'Onbeslist';
$string['unfinished'] = 'Niet klaar';
$string['unknowncategory'] = 'Onbekende categorie';
$string['unknownerror'] = 'Onbekende fout';
$string['unlimited'] = 'Onbeperkt';
$string['unpacking'] = '{$a} wordt uitgepakt';
$string['unsafepassword'] = 'Dit wachtwoord is niet veilig - probeer iets anders';
$string['untilcomplete'] = 'Tot volledig';
$string['unusedaccounts'] = 'Het lidmaatschap van accounts die meer dan {$a} dagen niet worden gebruikt wordt automatisch opgezegd.';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Back-up unzippen';
$string['up'] = 'Omhoog';
$string['update'] = 'Wijzig';
$string['updated'] = '{$a} gewijzigd';
$string['updatemymoodleoff'] = 'Stop met bewerken van deze pagina';
$string['updatemymoodleon'] = 'Bewerk deze pagina';
$string['updatemyprofile'] = 'Wijzig het profiel';
$string['updatesevery'] = 'Wordt elke {$a} seconden bijgewerkt';
$string['updatethis'] = 'Wijzig {$a}';
$string['updatethiscourse'] = 'Wijzig deze cursus';
$string['updatinga'] = 'Een {$a} wijzigen';
$string['updatingain'] = 'Een {$a->what} wijzigen in {$a->in}';
$string['upload'] = 'Upload';
$string['uploadafile'] = 'Upload een bestand';
$string['uploadcantwrite'] = 'Schrijven naar schijf mislukt';
$string['uploadedfile'] = 'Bestand met succes geüpload';
$string['uploadedfileto'] = '{$a->file} is geüpload naar {$a->directory}';
$string['uploadedfiletoobig'] = 'Sorry, maar dit bestand is te groot (limiet is {$a} bytes)';
$string['uploadextension'] = 'Bestandsupload gestopt door een PHP extentie';
$string['uploadfailednotrecovering'] = 'Je bestandsupload is mislukt omdat er een probleem was met één van de bestanden, {$a->name}.<br/>Hier is een log van de problemen:<br/>{$a->problem}<br/>Niet te herstellen.';
$string['uploadfilelog'] = 'Uploadlog voor bestand {$a}';
$string['uploadformlimit'] = 'Het geüploade bestand {$a} is groter dan de maximale grootte ingesteld op het formulier';
$string['uploadlabel'] = 'Titel:';
$string['uploadlimitwithsize'] = '{$a->contextname} oploadlimiet ({$a->displaysize})';
$string['uploadnewfile'] = 'Upload nieuw bestand';
$string['uploadnofilefound'] = 'Er is geen bestand gevonden - weet je zeker dat je een bestand geselecteerd hebt om te uploaden?';
$string['uploadnotallowed'] = 'Uploads niet toegestaan';
$string['uploadnotempdir'] = 'Tijdelijke map ontbreekt';
$string['uploadoldfilesdeleted'] = 'Het oude bestand(en) in je uploadzone is verwijderd';
$string['uploadpartialfile'] = 'Het bestand was slechts gedeeltelijk geüpload';
$string['uploadproblem'] = 'Een was een onbekend probleem tijdens het uploaden van bestand \'{$a}\' (was het misschien te groot?)';
$string['uploadrenamedchars'] = 'Het bestand is hernoemd van {$a->oldname} naar {$a->newname} omdat er ongeldige tekens in staan.';
$string['uploadrenamedcollision'] = 'Het bestand is hernoemd van {$a->oldname} naar {$a->newname} omdat er een bestandsnaamconflict was.';
$string['uploadserverlimit'] = 'Het geüploade bestand is groter dan de maximale grootte die op deze server ingesteld is.';
$string['uploadthisfile'] = 'Upload dit bestand';
$string['url'] = 'URL';
$string['used'] = 'Gebruikt';
$string['usedinnplaces'] = 'Gebruik op {$a} plaatsen';
$string['usemessageform'] = 'of gebruik het formulier hieronder om een bericht te sturen naar de geselecteerde leerlingen';
$string['user'] = 'Gebruiker';
$string['userconfirmed'] = '{$a} bevestigd';
$string['usercurrentsettings'] = 'Mijn profielinstellingen';
$string['userdata'] = 'Gebruikersgegevens';
$string['userdeleted'] = 'De account van deze gebruiker is verwijderd';
$string['userdescription'] = 'Beschrijving';
$string['userdescription_help'] = 'Hier kun je wat tekst over jezelf ingeven. De tekst zal getoond worden op je profielpagina, zodat anderen ze kunnen bekijken';
$string['userdetails'] = 'Gebruikersdetails';
$string['userfiles'] = 'Bestanden van de gebruiker';
$string['userlist'] = 'Gebruikerslijst';
$string['username'] = 'Gebruikersnaam';
$string['usernameemailmatch'] = 'Deze gebruikersnaam en dit e-mailadres zijn niet van dezelfde gebruiker';
$string['usernameexists'] = 'Deze gebruikersnaam bestaat al, kies een andere';
$string['usernamelowercase'] = 'Alleen kleine letters toegestaan';
$string['usernamenotfound'] = 'Deze gebruikersnaam komt niet voor in de databank';
$string['usernameoremail'] = 'Geef gebruikersnaam of e-mailadres';
$string['usernotconfirmed'] = 'Kon {$a} niet bevestigen';
$string['userpic'] = 'Gebruikersfoto';
$string['users'] = 'Gebruikers';
$string['userselectorautoselectunique'] = 'Als slechts één gebruiker overeen komt met de zoekopdracht, selecteer hem dan automatisch';
$string['userselectorpreserveselected'] = 'Houd de geselecteerde gebruikers in de lijst, zelfs als ze niet meer overeenkomen met de zoekopdracht';
$string['userselectorsearchanywhere'] = 'Tekst mag overal in de getoonde velden voorkomen';
$string['usersnew'] = 'Nieuwe gebruikers';
$string['usersnoaccesssince'] = 'Toon de gebruikers die langer inactief waren dan';
$string['userswithfiles'] = 'Gebruikers met bestanden';
$string['useruploadtype'] = 'Gebruiker upload type: {$a}';
$string['userviewingsettings'] = 'Profielinstellingen voor {$a}';
$string['userzones'] = 'Gebruikerzones';
$string['usetheme'] = 'Gebruik thema';
$string['usingexistingcourse'] = 'Gebruik bestaande cursus';
$string['valuealreadyused'] = 'Deze waarde is al gebruikt.';
$string['version'] = 'Versie';
$string['view'] = 'Bekijken';
$string['viewallcourses'] = 'Bekijk alle cursussen';
$string['viewallcoursescategories'] = 'Bekijk alle cursussen en categorieën';
$string['viewallsubcategories'] = 'Bekijk alle subcategorieën';
$string['viewfileinpopup'] = 'Bekijk bestand in pop-upvenster';
$string['viewing'] = 'Bekijken:';
$string['viewmore'] = 'Bekijk meer';
$string['viewprofile'] = 'Bekijk profiel';
$string['views'] = 'Bekeken pagina\'s';
$string['viewsolution'] = 'Bekijk oplossing';
$string['virusfound'] = 'Opgelet beheerder! Clam AV vond een virus in een bestand, geüpload door {$a->user} voor de cursus {$a->course}. Hier is de boodschap van clamscan:';
$string['virusfoundlater'] = 'Een bestand dat geüpload werd op {$a->date} met als bestandsnaam {$a->filename} voor de cursus {$a->course} is  besmet met een virus. Hier is een samenvatting van wat er met je bestand gebeurd is:

{$a->action}

Als dit een taak was, dan wil je het misschien terug insturen, zodat je leraar het kan nakijken.';
$string['virusfoundlateradmin'] = 'Opgelet beheerder! Een bestand dat geüpload werd op {$a->date} met als bestandsnaam {$a->filename} voor de cursus {$a->course} is  besmet met een virus. Hier is een samenvatting van wat er met het bestand gebeurd is:

{$a->action}

De gebruiker is ook gewaarschuwd.';
$string['virusfoundlateradminnolog'] = 'Opgelet beheerder! Een bestand dat geüpload werd met bestandsnaam {$a->filename} bevat een virus. Moodle kon dit bestand niet terugsturen naar de gebruiker die het oorspronkelijk geüpload had.

Hier is een samenvatting van wat er met dat bestand gebeurd is:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Virus gevonden!';
$string['virusfounduser'] = 'Het bestand {$a->filename} dat je geüpload hebt is door een virusscanner gecontroleerd en is geïnfecteerd! Je bestandsupload is mislukt.';
$string['virusplaceholder'] = 'Dit geüploade bestand bevat een virus en is verplaatst of verwijderd. De gebruiker is gewaarschuwd.';
$string['visible'] = 'Zichtbaar';
$string['visible_help'] = 'Deze instelling bepaalt wanneer een cursus verschijnt in de cursuslijst. Behalve leraren en beheerders hebben gebruikers geen toegang tot deze cursus.';
$string['visibletostudents'] = 'Zichtbaar voor {$a}';
$string['warning'] = 'Waarschuwing';
$string['warningdeleteresource'] = 'Waarschuwing: Er is naar {$a} verwezen vanuit een bron. Wil je de bron aanpassen?';
$string['webpage'] = 'Website';
$string['week'] = 'Week';
$string['weekhide'] = 'Verberg deze week voor {$a}';
$string['weeklyoutline'] = 'Overzicht van de weken';
$string['weeks'] = 'weken';
$string['weekshow'] = 'Toon deze week aan  {$a}';
$string['welcometocourse'] = 'Welkom bij {$a}';
$string['welcometocoursetext'] = 'Welkom bij {$a->coursename}!

Eén van de eerste dingen die je zou moeten doen is het invullen van je gebruikersprofiel, zodat we wat meer over jou te weten kunnen komen:

{$a->profileurl}';
$string['whatforlink'] = 'Wat wil je doen met de link?';
$string['whatforpage'] = 'Wat wil je doen met de tekst?';
$string['whattocallzip'] = 'Hoe wil je het zip-bestand noemen?';
$string['whattodo'] = 'Wat moet ik doen';
$string['windowclosing'] = 'Dit venster zou automatisch moeten sluiten. Indien niet, sluit het dan nu.';
$string['withchosenfiles'] = 'Met geselecteerde bestanden';
$string['withdisablednote'] = '{$a} (uitgeschakeld)';
$string['withoutuserdata'] = 'zonder gebruikersgegevens';
$string['withselectedusers'] = 'Met de geselecteerde gebruikers...';
$string['withselectedusers_help'] = '* Stuur bericht - voor het sturen van een bericht naar één of meer deelnemers
* Nieuwe notitie toevoegen - om een notitie aan een geselecteerde deelnemer toe te voegen
* Nieuwe algemene notitie toevoegen - om dezelfde notitie toe te voegen bij meer dan één deelnemer';
$string['withuserdata'] = 'met gebruikersgegevens';
$string['wordforstudent'] = 'Jouw woord voor leerling';
$string['wordforstudenteg'] = 'bijv. student, deelnemer, cursist, etc.';
$string['wordforstudents'] = 'Jouw woord voor leerlingen';
$string['wordforstudentseg'] = 'bijv. studenten, deelnemers, cursisten, etc.';
$string['wordforteacher'] = 'Jouw woord voor leraar';
$string['wordforteachereg'] = 'bijv. leraar, mentor, coach, begeleider, etc.';
$string['wordforteachers'] = 'Jouw woord voor leraren';
$string['wordforteacherseg'] = 'bijv. leraren, mentoren, coaches, begeleiders, etc.';
$string['writingblogsinfo'] = 'Blogsinfo wegschrijven';
$string['writingcategoriesandquestions'] = 'Categorieën en vragen schrijven';
$string['writingcoursedata'] = 'Cursusdata schrijven';
$string['writingeventsinfo'] = 'Gebeurtenisseninfo schrijven';
$string['writinggeneralinfo'] = 'Algemene info schrijven';
$string['writinggradebookinfo'] = 'Cijferlijst-info schrijven';
$string['writinggroupingsgroupsinfo'] = 'Groepering-groepinformanite wegschrijven';
$string['writinggroupingsinfo'] = 'Groeperingsinformatie wegschrijven';
$string['writinggroupsinfo'] = 'Info groepen schrijven';
$string['writingheader'] = 'Header schrijven';
$string['writingloginfo'] = 'Loginfo schrijven';
$string['writingmessagesinfo'] = 'Berichteninfo schrijven';
$string['writingmoduleinfo'] = 'Moduleninfo schrijven';
$string['writingscalesinfo'] = 'Schaleninfo schrijven';
$string['writinguserinfo'] = 'Gebruikersinfo schrijven';
$string['wrongpassword'] = 'Ongeldig wachtwoord voor deze gebruikersnaam';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'Jaar';
$string['years'] = 'Jaren';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Je staat op het punt een ZIP-bestand te maken met daarin';
$string['youaregoingtorestorefrom'] = 'Je gaat een reservekopie terugzetten van';
$string['youneedtoenrol'] = 'Om die actie te kunnen doen, moet je aangemeld zijn in deze cursus.';
$string['yourlastlogin'] = 'Je laatste login was';
$string['yourself'] = 'jezelf';
$string['yourteacher'] = 'Jouw {$a}';
$string['yourwordforx'] = 'Jouw woord voor \'{$a}\'';
$string['zippingbackup'] = 'Back-up zippen';
