<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Er zijn nieuwe forumberichten';
$string['addanewdiscussion'] = 'Voeg een nieuw discussieonderwerp toe';
$string['addanewquestion'] = 'Voeg een nieuwe vraag toe';
$string['addanewtopic'] = 'Voeg een nieuw onderwerp toe';
$string['advancedsearch'] = 'Uitgebreid zoeken';
$string['allforums'] = 'Alle forums';
$string['allowdiscussions'] = 'Mag een {$a} berichten posten?';
$string['allowsallsubscribe'] = 'In dit forum kan iedereen kiezen om e-mail er van te krijgen of niet';
$string['allowsdiscussions'] = 'In dit forum mag iedereen precies één discussie starten.';
$string['allsubscribe'] = 'Ik wil mail van alle forums';
$string['allunsubscribe'] = 'Ik wil van geen enkel forum mail';
$string['alreadyfirstpost'] = 'Dit is al het eerste bericht in de discussie';
$string['anyfile'] = 'Een bestand';
$string['areaattachment'] = 'Bijlagen';
$string['areapost'] = 'Berichten';
$string['attachment'] = 'Bijlage';
$string['attachment_help'] = 'Je kunt optioneel één of meer bestanden als bijlage bij een forumbericht voegen. Als je een afbeelding toevoegt, dan zal die onder het bericht getoond worden.';
$string['attachmentnopost'] = 'Je kunt bijlagen niet exporteren zonder post ID';
$string['attachments'] = 'Bijlagen';
$string['attachmentswordcount'] = 'Bijlagen en aantal woorden';
$string['blockafter'] = 'Maximaal aantal berichten voor blokkeren';
$string['blockafter_help'] = 'Deze instelling specificeert het maximale aantal berichten dat een gebruiker kan posten in een zekere tijdsspanne. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben geen limiet.';
$string['blockperiod'] = 'Blokkeertijd';
$string['blockperioddisabled'] = 'Niet blokkeren';
$string['blockperiod_help'] = 'Leerlingen kunnen geblokkeerd worden voor het versturen van berichten als ze meer dan een bepaald aantal berichten sturen in een gegeven tijdslimiet. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben geen limiet.';
$string['blogforum'] = 'Standaardforum, getoond in blogstijl';
$string['bynameondate'] = 'door  {$a->name}  - {$a->date}';
$string['cannotadd'] = 'Kon de discussie niet toevoegen aan dit forum';
$string['cannotadddiscussion'] = 'Om discussies aan dit forum te kunnen toevoegen, moet je lid zijn van deze groep';
$string['cannotadddiscussionall'] = 'Je hebt het recht niet om een nieuw discussieonderwerp te starten voor alle deelnemers.';
$string['cannotaddsubscriber'] = 'Kon gebruiker met ID {$a} niet inschrijven voor het ontvangen van e-mail van dit forum!';
$string['cannotaddteacherforumto'] = 'Kon het geconverteerde leraarsforum niet toevoegen aan sectie 0 van de cursus';
$string['cannotcreatediscussion'] = 'Kon geen nieuwe discussie starten';
$string['cannotcreateinstanceforteacher'] = 'Kon geen nieuwe cursusmodule maken voor het leraarsforum';
$string['cannotdeletepost'] = 'Je kunt dit bericht niet verwijderen!';
$string['cannoteditposts'] = 'Je kunt een bericht van andere gebruikers niet wijzigen!';
$string['cannotfinddiscussion'] = 'Kon die discussie in dit forum niet vinden';
$string['cannotfindfirstpost'] = 'Kon het eerste bericht van dit forum niet vinden';
$string['cannotfindorcreateforum'] = 'Kon geen nieuwforum maken of vinden voor deze site';
$string['cannotfindparentpost'] = 'Kon top ouder van bericht {$a} niet vinden';
$string['cannotmovefromsingleforum'] = 'Kan de discussie van een eenvoudig enkele discussieforum niet verplaatsen';
$string['cannotmovenotvisible'] = 'Forum niet zichtbaar';
$string['cannotmovetonotexist'] = 'Je kunt dat forum niet verplaatsen - het bestaat niet!';
$string['cannotmovetonotfound'] = 'Doelforum niet gevonden in deze cursus';
$string['cannotmovetosingleforum'] = 'Kan discussie niet verplaatsen naar een één discussie forum';
$string['cannotpurgecachedrss'] = 'Kon de RSS-feeds in de cache voor de bron en/of bestemmingsforums niet verwijderen - controleer je bestandsrechten';
$string['cannotremovesubscriber'] = 'Kon gebruiker met ID {$a} niet uitschrijven voor het ontvangen van e-mail van dit forum!';
$string['cannotreply'] = 'Je kunt dit bericht niet beantwoorden';
$string['cannotsplit'] = 'Discussies van dit forum kunnen niet gesplitst worden';
$string['cannotsubscribe'] = 'Je moet lid van een groep zijn om e-mail van dit forum te kunnen ontvangen.';
$string['cannottrack'] = 'Kon het volgen van dit forum niet stoppen';
$string['cannotunsubscribe'] = 'Kon er niet voor zorgen dat je van dit forum geen mail meer ontvangt.';
$string['cannotupdatepost'] = 'Je kunt dit bericht niet updaten';
$string['cannotviewpostyet'] = 'Je kunt de vragen van andere leerlingen in deze discussie nog niet lezen, omdat je zelf nog niets gepost hebt';
$string['cannotviewusersposts'] = 'Deze gebruiker heeft geen berichten gepost die jij kunt zien';
$string['cleanreadtime'] = 'Markeer oude berichten als gelezen';
$string['completiondiscussions'] = 'Leerling moet discussies starten:';
$string['completiondiscussionsgroup'] = 'Discussies vereist';
$string['completiondiscussionshelp'] = 'discussies vereist om af te werken';
$string['completionposts'] = 'Leerling moet discussies starten of beantwoorden:';
$string['completionpostsgroup'] = 'Berichten vereist';
$string['completionpostshelp'] = 'discussies of antwoorden vereist voor voltooien';
$string['completionreplies'] = 'Leerling moet antwoorden posten:';
$string['completionrepliesgroup'] = 'Antwoorden vereist';
$string['completionreplieshelp'] = 'antwoorden vereist voor voltooien';
$string['configcleanreadtime'] = 'Het uur van de dag waarop oude berichten van de \'gelezen\'-tabel moeten verwijderd worden.';
$string['configdigestmailtime'] = 'Gebruikers die ervoor kiezen dat de e-mails hun als samenvatting toegezonden worden, zullen dagelijks een e-mail ontvangen. Deze instelling controleert op welk moment van de dag deze dagelijkse mail verzonden wordt (de mail wordt verstuurd door de cron die volgt op het uur dat hier gekozen wordt)';
$string['configdisplaymode'] = 'De standaardmanier voor het weergeven van discussies als er geen methode is ingesteld.';
$string['configenablerssfeeds'] = 'Met deze instelling kun je de mogelijkheid voor het maken van RSS-feeds inschakelen voor alle forums. Je zult wel nog voor elk forum afzonderlijk het maken van de RSS-feeds moeten  inschakelen.';
$string['configenabletimedposts'] = 'Zet op \'Ja\' als je een tijdvak wil instellen wanneer je een nieuwe discussie start';
$string['configlongpost'] = 'Elk bericht dat langer is dan deze waarde (HTML-code niet inbegrepen) wordt als lang beschouwd.';
$string['configmanydiscussions'] = 'Maximale aantal discussies van een forum die per pagina getoond worden';
$string['configmaxattachments'] = 'Standaard maximale aantal bijlagen per bericht';
$string['configmaxbytes'] = 'Standaard maximale grootte voor alle forumbijlagen op deze site (afhankelijk van vaklimieten en andere lokale instellingen)';
$string['configoldpostdays'] = 'Aantal dagen waarna elk bericht als gelezen moet beschouwd worden.';
$string['configreplytouser'] = 'Wil je dat de e-mail van een bericht op het forum het e-mailadres van de verstuurder bevat, zodat de ontvangers eventueel ook persoonlijk kunnen antwoorden, eerder dan via het forum? Zelfs als je hier \'Ja\' instelt, kunnen gebruikers ervoor kiezen hun e-mailadres privé te houden via hun profielpagina';
$string['configshortpost'] = 'Elk bericht dat korter is dan deze waarde (HTML-code niet inbegrepen) wordt als kort beschouwd.';
$string['configtrackingtype'] = 'Standaardinstelling voor het opvolgen van lezen.';
$string['configtrackreadposts'] = 'Zet op \'ja\' als je gelezen/ongelezen wil bijhouden voor elke gebruiker.';
$string['configusermarksread'] = 'Indien \'ja\' moet de lezer de berichten manueel als gelezen markeren. Indien \'nee\' wordt het bericht als gelezen gemarkeerd wanneer het geopend werd.';
$string['confirmsubscribe'] = 'Wil je echt inschrijven op forum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Wil je echt uitschrijven van forum \'{$a}\'?';
$string['couldnotadd'] = 'Door een onbekende fout was het niet mogelijk om je bericht toe te voegen .';
$string['couldnotdeletereplies'] = 'Helaas, dit kan niet worden verwijderd omdat er al op geantwoord is.';
$string['couldnotupdate'] = 'Kon je bericht niet bijwerken door een onbekende fout.';
$string['delete'] = 'Verwijder';
$string['deleteddiscussion'] = 'De discussie is verwijderd';
$string['deletedpost'] = 'Het bericht  is verwijderd';
$string['deletedposts'] = 'Deze berichten werden verwijderd';
$string['deletesure'] = 'Weet je zeker dat je dit bericht wilt verwijderen?';
$string['deletesureplural'] = 'Weet je zeker dat je dit bericht en alle antwoorden erop wil verwijderen? ({$a} berichten)';
$string['digestmailheader'] = 'Dit is je dagelijkse samenvattende e-mail met de nieuwe berichten van de forums van {$a->sitename}. Als je jouw voorkeurinstellingen voor de e-maildienst van de forums wil wijzigen, ga dan naar {$a->userprefs}.';
$string['digestmailpost'] = 'Wijzig je voorkeuren voor de samenvattende e-mail van forums';
$string['digestmailprefs'] = 'Jouw gebruikersprofiel';
$string['digestmailsubject'] = 'Dagelijkse forumsamenvatting van {$a}';
$string['digestmailtime'] = 'Uur om e-mail met verzamelde berichten te versturen';
$string['digestsentusers'] = 'Samenvattende e-mail met succes naar {$a} gebruikers gestuurd.';
$string['disallowsubscribe'] = 'Inschrijven niet toegelaten';
$string['disallowsubscribeteacher'] = 'Inschrijven niet toegelaten (behalve voor leraren)';
$string['discussion'] = 'Discussie';
$string['discussionmoved'] = 'Deze discussie is verplaatst naar \'{$a}\'.';
$string['discussionmovedpost'] = 'Deze discussie is verplaatst naar <a href="{$a->discusshref}">deze plaats</a> in het forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Discussienaam';
$string['discussions'] = 'Discussies';
$string['discussionsstartedby'] = 'Discussies die door {$a} zijn gestart';
$string['discussionsstartedbyrecent'] = 'Discussies die recentelijk door {$a} zijn gestart';
$string['discussionsstartedbyuserincourse'] = 'Discussies, gestart door {$a->fullname} in {$a->coursename}';
$string['discussthistopic'] = 'Draag bij aan de discussie';
$string['displayend'] = 'Toon einde';
$string['displayend_help'] = '<p>Je kunt kiezen of je forumbericht pas vanaf een bepaalde datum getoond wordt, tot een bepaalde datum getoond wordt of gedurende een bepaalde periode getoond wordt.</p>

<p>Deselecteer de gewenste schakelopties om een start en/of einddatum te kunnen kiezen.</p>

<p>Merk op dat gebruikers met beheerrechten de berichten ook kunnen zien voor en na de zichtbare periode.</p>';
$string['displaymode'] = 'Toon modus';
$string['displayperiod'] = 'Toon periode';
$string['displaystart'] = 'Toon start';
$string['displaystart_help'] = '<p>Je kunt kiezen of je forumbericht pas vanaf een bepaalde datum getoond wordt, tot een bepaalde datum getoond wordt of gedurende een bepaalde periode getoond wordt.</p>

<p>Deselecteer de gewenste schakelopties om een start en/of einddatum te kunnen kiezen.</p>

<p>Merk op dat gebruikers met beheerrechten de berichten ook kunnen zien voor en na de zichtbare periode.</p>';
$string['displaywordcount'] = 'Toon woorden tellen';
$string['displaywordcount_help'] = 'Deze instelling bepaalt of het aantal woorden voor elk bericht getoond moet worden of niet.';
$string['eachuserforum'] = 'Iedereen voegt één discussie toe';
$string['edit'] = 'Wijzig';
$string['editedby'] = 'Bewerkt door {$a->name} - oorspronkelijk bericht van {$a->date}';
$string['editedpostupdated'] = '{$a}\'s bericht is aangepast';
$string['editing'] = 'Wijzigen';
$string['emaildigest_0'] = 'Je zult één e-mail per forumbericht ontvangen.';
$string['emaildigest_1'] = 'Je zult één samenvattende e-mail per dag ontvangen waarin de inhoud van alle forumberichten zit.';
$string['emaildigest_2'] = 'Je zult één samenvattende e-mail per dag ontvangen waarin het onderwerp van elk forumbericht zit.';
$string['emaildigestcompleteshort'] = 'Volledige berichten';
$string['emaildigestdefault'] = 'Standaard ({$a})';
$string['emaildigestoffshort'] = 'Geen samenvattende mail';
$string['emaildigestsubjectsshort'] = 'Enkel onderwerpen';
$string['emaildigesttype'] = 'Opties samenvattende mail';
$string['emaildigesttype_help'] = 'Het type melding dat je zult krijgen voor elk forum.

* Standaard - volg de instelling voor samenvattende mail in je gebruikersprofiel. Als je je profiel aanpast, zal dat hier ook wijzigen;
* Geen samenvattende e-mail - je zult één e-mail krijgen per forumbericht;
* Samenvattende e-mail - volledige berichten - je krijgt één samenvattende e-mail per dag met daarin de volledige inhoud van elk forumbericht;
* Samenvattende e-mail - enkel onderwerpen - je krijgt één samenvattende e-mail per dag met daarin enkel het onderwerp van elk forumbericht.';
$string['emaildigestupdated'] = 'De optie voor verzamelde mail is gewijzigd naar \'{$a->maildigesttitle}\' voor forum \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'De standaardinstelling van je profiel \'{$a->maildigesttitle}\' werd gebruikt voor forum \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Er was iets mis met je bericht. Misschien heb je het leeg gelaten of was de bijlage te groot. Je wijzigingen zijn NIET bewaard.';
$string['erroremptymessage'] = 'Bericht kan niet leeg zijn';
$string['erroremptysubject'] = 'Onderwerp kan niet leeg zijn';
$string['errorenrolmentrequired'] = 'Je moet aangemeld zijn in deze cursus om de inhoud te zien';
$string['errorwhiledelete'] = 'Er is een fout opgetreden bij het verwijderen van een record';
$string['event_assessable_uploaded'] = 'Er is inhoud gepost';
$string['everyonecanchoose'] = 'Iedereen kan kiezen om al dan niet e-mail van dit forum te ontvangen';
$string['everyonecannowchoose'] = 'Iedereen kan er voor kiezen om e-mail van dit forum te ontvangen';
$string['everyoneisnowsubscribed'] = 'Iedereen ontvangt nu e-mail van dit forum';
$string['everyoneissubscribed'] = 'Iedereen ontvangt e-mail van dit forum';
$string['existingsubscribers'] = 'Krijgen al e-mail van dit forum';
$string['exportdiscussion'] = 'Exporteer hele discussie';
$string['forcedreadtracking'] = 'Sta \'verplicht forum volgen\' toe';
$string['forcedreadtracking_desc'] = 'Maakt het mogelijk om forums in te stellen op verplicht lezen opvolgen. Dat zal resulteren in verminderde performantie voor sommige gebruikers, vooral dan in cursussen met veel forums en veel berichten. Wanneer je dit uitschakeld, zal elk forum dat voorheen op verplicht stond als optioneel behandeld worden.';
$string['forcessubscribe'] = 'Iedereen krijgt verplicht e-mail van dit forum';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Voeg een nieuw forum toe';
$string['forum:addnews'] = 'Voeg nieuws toe';
$string['forum:addquestion'] = 'Voeg vraag toe';
$string['forum:allowforcesubscribe'] = 'Inschrijven op forum verplichten toestaan';
$string['forumauthorhidden'] = 'Auteur (verborgen)';
$string['forumblockingalmosttoomanyposts'] = 'Je nadert de berichtenlimiet. Je hebt {$a->numposts} berichten in de afgelopen {$a->blockperiod} gepost en de limiet is {$a->blockafter} berichten.';
$string['forumbodyhidden'] = 'Je kunt dit bericht niet bekijken. Mogelijke oorzaken: je hebt zelf nog niets gepost in deze discussie, de maximale tijd tussen twee bewerkingen is nog niet verstreken, de discussie is nog niet gestart of de discussie is afgelopen.';
$string['forum:createattachment'] = 'Bijlage toevoegen';
$string['forum:deleteanypost'] = 'Gelijk welk bericht verwijderen (altijd)';
$string['forum:deleteownpost'] = 'Eigen berichten verwijderen (binnen bepaalde tijd)';
$string['forum:editanypost'] = 'Gelijk welk bericht bewerken';
$string['forum:exportdiscussion'] = 'Exporteer de hele discussie';
$string['forum:exportownpost'] = 'Exporteer je eigen bericht';
$string['forum:exportpost'] = 'Exporteer bericht';
$string['forumintro'] = 'Beschrijving';
$string['forum:managesubscriptions'] = 'Beheer het ontvangen van e-mail';
$string['forum:movediscussions'] = 'Discussies verplaatsen';
$string['forumname'] = 'Naam van het forum';
$string['forumposts'] = 'Forumberichten';
$string['forum:postwithoutthrottling'] = 'Vrijgesteld van beperkingen om te posten';
$string['forum:rate'] = 'Berichten beoordelen';
$string['forum:replynews'] = 'Beantwoord nieuws';
$string['forum:replypost'] = 'Berichten beantwoorden';
$string['forums'] = 'Forums';
$string['forum:splitdiscussions'] = 'Discussies splitsen';
$string['forum:startdiscussion'] = 'Nieuwe discussies starten';
$string['forumsubjecthidden'] = 'Onderwerp (verborgen)';
$string['forumtracked'] = 'Volgen ongelezen post ingeschakeld';
$string['forumtrackednot'] = 'Volgen ongelezen post uitgeschakeld';
$string['forumtype'] = 'Soort forum';
$string['forumtype_help'] = 'Er zijn 5 forumtypes

* Eén eenvoudige discussie - Eén enkel discussie-onderwerp waarop iedereen kan antwoorden (kan niet gebruikt worden met gescheiden groepen)
* Iedereen post één discussie - Elke leerling kan juist één nieuw discussieonderwerp posten, waar iedereen da, kan op antwoorden
* Vraag- en antwoordforum - Leerlingen moeten eerst hun bericht posten voor ze de berichten van anderen kunnen zien
* Standaardforum getoond in een blog-stijl format - een open forum waar iedereen een nieuwe discussie kan starten en waar de onderwerpen getoond worden op één pagina met \'Discussieer over dit onderwerp\' -links
* Standaardforum voor algemeen gebruik - Een open fourm waar iedereen op elk moment een nieuwe discussie kan starten';
$string['forum:viewallratings'] = 'Bekijk de ruwe gegevens van de beoordelingen.';
$string['forum:viewanyrating'] = 'Bekijk alle totaalbeoordelingen';
$string['forum:viewdiscussion'] = 'Discussies bekijken';
$string['forum:viewhiddentimedposts'] = 'Verborgen berichten bekijken';
$string['forum:viewqandawithoutposting'] = 'Altijd Vraag en Antwoord berichten bekijken';
$string['forum:viewrating'] = 'Bekijk jouw algemene beoordeling';
$string['forum:viewsubscribers'] = 'Bekijk wie e-mail ontvangt';
$string['generalforum'] = 'Standaardforum voor algemeen gebruik';
$string['generalforums'] = 'Algemene forums';
$string['hiddenforumpost'] = 'Verborgen forumbericht';
$string['inforum'] = 'in {$a}';
$string['introblog'] = 'De berichten in dit forum zijn automatisch naar hier gekopieerd van blogs van gebruikers in deze cursus omdat deze blogs niet langer beschikbaar zijn';
$string['intronews'] = 'Algemeen nieuws en aankondigingen';
$string['introsocial'] = 'Een open forum om te chatten over wat je maar wilt';
$string['introteacher'] = 'Een forum alleen bestemd voor discussies en aantekeningen van leraren';
$string['invalidaccess'] = 'Deze pagina is niet correct opgevraagd';
$string['invaliddigestsetting'] = 'Er is een ongeldige verzamele-mailvoorkeur opgegeven';
$string['invaliddiscussionid'] = 'Discussie ID was fout of bestaat niet meer';
$string['invalidforcesubscribe'] = 'Ongeldige inschrijving verplicht modus';
$string['invalidforumid'] = 'Forum ID was fout';
$string['invalidparentpostid'] = 'Ouder bericht ID was fout';
$string['invalidpostid'] = 'Post ID {$a} was fout';
$string['lastpost'] = 'Laatste bericht';
$string['learningforums'] = 'Leerforums';
$string['longpost'] = 'Lang bericht';
$string['mailnow'] = 'Stuur nu e-mail';
$string['manydiscussions'] = 'Discussies per pagina';
$string['markalldread'] = 'Markeer alle berichten in deze discussie als gelezen';
$string['markallread'] = 'Markeer alle berichten in dit forum als gelezen';
$string['markread'] = 'Markeer als gelezen';
$string['markreadbutton'] = 'Markeer als<br />gelezen';
$string['markunread'] = 'Markeer als ongelezen';
$string['markunreadbutton'] = 'Markeer als<br />ongelezen';
$string['maxattachments'] = 'Maximale aantal bijlagen';
$string['maxattachments_help'] = 'Deze instelling bepaalt het maximale aantal bestanden dat als bijlage bij een forumbericht mag gevoegd worden.';
$string['maxattachmentsize'] = 'Maximale grootte van bijlagen';
$string['maxattachmentsize_help'] = 'Deze instelling bepaalt de maximale grootte van bestanden die als bijlage bij een forumbericht gevoegd kunnen worden.';
$string['maxtimehaspassed'] = 'Helaas is de maximale tijd voor het wijzigen van dit bericht ({$a}) verstreken!';
$string['message'] = 'Bericht';
$string['messageprovider:digests'] = 'Ingeschreven op forum voor verzamele-mail';
$string['messageprovider:posts'] = 'Ingeschreven op forum voor berichten';
$string['missingsearchterms'] = 'Volgende zoektermen komen alleen in de HTML-opmaak van deze boodschap voor:';
$string['modeflatnewestfirst'] = 'Laat de antwoorden in één lijst zien, met de nieuwste eerst';
$string['modeflatoldestfirst'] = 'Laat de antwoorden in één lijst zien, met de oudste eerst';
$string['modenested'] = 'Laat de antwoorden \'genest\' zien';
$string['modethreaded'] = 'Laat de antwoorden in hun \'draden\' zien';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Met de forum-acticviteitsmodule kunnen deelnemers asynchrone discurssies voeren over een lange tijdsperiode.

Er zijn verschillende forumtypes om uit te kiezen, zoals standaard forum, waarbij iedereen een nieuwe discussie kan starten, een forum waarbij elke leerling slechts één discussie kan starten, of een vraag en antwoordforum, waar leerlingen eerst moeten posten, voor ze de berichten van andere leerlingen kunnen zien. Een leraar kan toestaan om bestanden als bijlage bij een bericht te laten voegen. Als dit afbeeldingen zijn, dan worden die getoond in het bericht.

Deelnemers kunnen zich inschrijven op een forum, zodat ze meldingen krijgen van nieuwe forumberichten. Een leraar kan die inschrijvingsmodus op optioneel, verplicht of automatich zetten of het inschrijven volledig blokkeren. Indien nodig kunnen leerlingen geblokkeerd worden als ze meer dan een bepaald aantal berichten posten per tijdsperiode; dit kan verhinderen dat sommigen de discussie domineren.

Forumberichten kunnen beoordeeld worden door leraars of door leerlingen (peer-evaluatie). De beoordelingen kunnen samengeteld worden om een eindbeoordeling voor het forum te bekomen, die dan in de cijferlijst opgenomen wordt.

Forums kunnen voor veel zaken gebruikt worden, zoals

* een sociale ruimte waar leerlingen elkaar kunnen leren kennen
* voor cursusmededelingen (door gebruik te maken van een nieuwsforum met verplicht ontvangen van meldingen)
* om de inhoud van de cursus of leesmateriaal te bespreken
* om online verder te gaan over een onderwerp dat aan bod kwam tijdens een klasgebeuren
* voor discussies tussen leraren (in een verborgen forum)
* als helpcentrum waar leraren en leerlingen advies kunnen geven
* als één-op-één ondersteuningszone voor een privé leraar-leerling communicatie (door een forum met groepen te gebruiken met 1 leerling per groep)
* voor uitbreidingsoefeningen, met uitdagende denkoefeningen waar leerlingen kunnen over nadenken, discussieren en oplossingen voorstellen.';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'meer';
$string['movedmarker'] = '(Verplaatst)';
$string['movethisdiscussionto'] = 'Verplaats deze discussie naar ...';
$string['mustprovidediscussionorpost'] = 'You moet ofwel een discussie ID of een bericht ID geven om te exporteren';
$string['namenews'] = 'Nieuwsforum';
$string['namenews_help'] = 'Het nieuwsforum is een speciaal forum dat automatisch aangemaakt wordt in elke cursus en op de startpagina van de site. Het is een plaats voor algemene mededelingen. Je kunt er zo maar één per cursus hebben. Enkel leraren en beheerders kunnen posten in dit forum. Leerlingen kunnen er niet op antwoorden. Het "Laatste nieuws"-blok toont de recente discussies van dit speciale forum.';
$string['namesocial'] = 'Sociaal forum';
$string['nameteacher'] = 'Forum voor leraren';
$string['newforumposts'] = 'Nieuwe forumberichten';
$string['noattachments'] = 'Er zijn geen bijlagen bij dit bericht';
$string['nodiscussions'] = 'Er zijn nog geen discussies in dit forum';
$string['nodiscussionsstartedby'] = '{$a} heeft nog geen discussies gestart';
$string['nodiscussionsstartedbyyou'] = 'Je hebt nog geen discussies gestart';
$string['noguestpost'] = 'Sorry, gasten mogen geen berichten posten';
$string['noguesttracking'] = 'Sorry, gasten kunnen de instellingen voor het volgen van forumberichten niet wijzigen.';
$string['nomorepostscontaining'] = 'Er zijn geen berichten met \'{$a}\' meer gevonden';
$string['nonews'] = 'Er zijn nog geen nieuwsberichten';
$string['noonecansubscribenow'] = 'Inschrijven is nu niet toegelaten';
$string['nopermissiontosubscribe'] = 'Je hebt het recht niet te zien wie e-mail van dit forum ontvangt';
$string['nopermissiontoview'] = 'Je mag dit bericht niet zien';
$string['nopostforum'] = 'Sorry, je mag geen berichten posten in dit forum';
$string['noposts'] = 'Geen berichten';
$string['nopostsmadebyuser'] = '{$a} heeft geen berichten gepost';
$string['nopostsmadebyyou'] = 'Je hebt geen berichten gepost';
$string['noquestions'] = 'Er zijn nog geen vragen in dit forum';
$string['nosubscribers'] = 'Niemand krijgt e-mail van dit forum';
$string['notexists'] = 'Discussie bestaat niet meer';
$string['nothingnew'] = 'Niets nieuw voor {$a}';
$string['notingroup'] = 'Sorry, je moet bij een groep horen om dit forum te kunnen zien.';
$string['notinstalled'] = 'De forummodule is niet geïnstalleerd';
$string['notpartofdiscussion'] = 'Dit bericht is geen deel van een discussie!';
$string['notrackforum'] = 'Schakel volgen van ongelezen berichten uit';
$string['noviewdiscussionspermission'] = 'Je mag de discussies in dit forum niet zien';
$string['nowallsubscribed'] = 'Je krijgt mail van alle forums in {$a}';
$string['nowallunsubscribed'] = 'Je krijgt van geen enkel forum in {$a} mail';
$string['nownotsubscribed'] = '{$a->name} zal GEEN meldingen over nieuwe forumberichten in  \'{$a->forum}\' ontvangen';
$string['nownottracking'] = '{$a->name} volgt niet langer het forum \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} zal meldingen ontvangen over nieuwe forumberichtingen in \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} volgt nu het forum \'{$a->forum}\'.';
$string['numposts'] = '{$a} berichten';
$string['olderdiscussions'] = 'Oudere discussies';
$string['oldertopics'] = 'Oudere onderwerpen';
$string['oldpostdays'] = 'Gelezen na aantal dagen';
$string['openmode0'] = 'Geen nieuwe discussies, geen antwoorden';
$string['openmode1'] = 'Geen nieuwe discussies mogelijk, maar antwoorden zijn toegestaan';
$string['openmode2'] = 'Nieuwe discussies en antwoorden zijn toegestaan';
$string['overviewnumpostssince'] = '{$a} berichten sinds je laatste login';
$string['overviewnumunread'] = '{$a} in totaal niet gelezen';
$string['page-mod-forum-discuss'] = 'Forum module discussiedraad pagina';
$string['page-mod-forum-view'] = 'Forummodule hoofdpagina';
$string['page-mod-forum-x'] = 'Elke forummodule pagina';
$string['parent'] = 'Toon discussiestart';
$string['parentofthispost'] = 'Discussiestart van dit bericht';
$string['pluginadministration'] = 'Forumbeheer';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Je bericht is gepost.</p><p> Je hebt {$a} de tijd om dit bericht te wijzigen als je nog iets wilt veranderen.</p>';
$string['postaddedsuccess'] = 'Je bericht werd toegevoegd.';
$string['postaddedtimeleft'] = 'Je hebt {$a} om het te bewerken als je nog wijzigingen wil aanbrengen.';
$string['postbyuser'] = '{$a->post} door {$a->user}';
$string['postincontext'] = 'Bekijk dit bericht in zijn context';
$string['postmailinfo'] = 'Dit is een kopie van een bericht dat op de {$a} website is toegevoegd.

Klik op deze link om jouw antwoord via de website toe te voegen:';
$string['postmailnow'] = '<p>Dit bericht zal onmiddellijk verstuurd worden naar iedereen die e-mail van dit forum wil.</p>';
$string['postrating1'] = 'Vooral Separate Knowing';
$string['postrating2'] = 'Separate en Connected Knowing';
$string['postrating3'] = 'Vooral Connected Knowing';
$string['posts'] = 'Berichten';
$string['postsmadebyuser'] = 'Berichten gepost door {$a}';
$string['postsmadebyuserincourse'] = 'Berichten gepost door {$a->fullname} in {$a->coursename}';
$string['posttoforum'] = 'Plaats op het forum';
$string['postupdated'] = 'Je bericht is bijgewerkt';
$string['potentialsubscribers'] = 'Deelnemers van de cursus die nog geen e-mail van dit forum krijgen';
$string['processingdigest'] = 'E-mailsamenvatting aan het verwerken voor gebruiker {$a}';
$string['processingpost'] = 'Bericht {$a} aan het verwerken';
$string['prune'] = 'Splits discussie';
$string['prunedpost'] = 'Er is een nieuwe discussie gestart met dat bericht';
$string['pruneheading'] = 'Splits deze discussie en begin met dit bericht een nieuwe discussie';
$string['qandaforum'] = 'Vraag- en antwoordforum';
$string['qandanotify'] = 'Dit is een vraag- en antwoordforum. Om de andere antwoorden op deze vraag te kunnen zien, moet je eerst je eigen antwoord posten.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Lees de rest van deze discussie';
$string['replies'] = 'Antwoorden';
$string['repliesmany'] = '{$a} antwoorden tot nu toe';
$string['repliesone'] = '{$a} antwoord tot nu toe';
$string['reply'] = 'Antwoord';
$string['replyforum'] = 'Antwoord op het forum';
$string['replytouser'] = 'Gebruik e-mailadres in antwoord';
$string['resetdigests'] = 'Verwijder alle gebruikersindividuele verzamel e-mail voorkeuren';
$string['resetforums'] = 'Verwijder berichten van';
$string['resetforumsall'] = 'Verwijder alle berichten';
$string['resetsubscriptions'] = 'Laat niemand nog e-mail van dit forum ontvangen';
$string['resettrackprefs'] = 'Verwijder alle voorkeuren voor berichtenopvolging';
$string['rssarticles'] = 'Aantal recente RSS artikels';
$string['rssarticles_help'] = '<p>Met deze instelling kun je kiezen hoeveel artikels je in de RSS-feed wil zetten.</p>

<p>Een getal tussen 5 en 20 zou goed moeten zijn voor de meeste forums. Verhoog het getal als het forum erg veel gebruikt wordt.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS-feed van discussies';
$string['rsssubscriberssposts'] = 'RSS-feed van berichten';
$string['rsstype'] = 'RSS-feed voor deze activiteit';
$string['rsstype_help'] = '<p>Met deze optie kun je een RSS-feed maken van dit forum.</p>
<p>Je kunt kiezen tussen twee forumtypes:</p>
<ul>
<li><b>Discussies:</b> Als je deze instelling gebruikt, dan zal de RSS-feed nieuwe discussies met hun eerste bericht bevatten.</li>
<li><b>Berichten:</b> Als je deze instelling gebruikt, dan zal de RSS-feed elk nieuw bericht van dit forum bevatten.</li>
</ul>';
$string['search'] = 'Zoek';
$string['searchdatefrom'] = 'Berichten nieuwer dan dit';
$string['searchdateto'] = 'Berichten ouder dan dit';
$string['searchforumintro'] = 'Geef zoekwoorden in één of meer van volgende velden:';
$string['searchforums'] = 'Zoeken in forums';
$string['searchfullwords'] = 'Deze woorden moeten als volledige woorden voorkomen';
$string['searchnotwords'] = 'Deze woorden mogen NIET voorkomen';
$string['searcholderposts'] = 'Doorzoek oudere berichten...';
$string['searchphrase'] = 'Dit zinsdeel moet exact voorkomen in het bericht';
$string['searchresults'] = 'Zoekresultaten';
$string['searchsubject'] = 'Deze woorden moeten in het onderwerp staan';
$string['searchuser'] = 'Dit is de naam van de auteur';
$string['searchuserid'] = 'Dit is de Moodle ID van de auteur';
$string['searchwhichforums'] = 'Kies in welke forums je wil zoeken';
$string['searchwords'] = 'Deze woorden mogen overal in het bericht voorkomen';
$string['seeallposts'] = 'Bekijk alle berichten die deze gebruiker gepost heeft.';
$string['shortpost'] = 'Kort bericht';
$string['showsubscribers'] = 'Toon / wijzig wie e-mail van dit forum krijgt.';
$string['singleforum'] = 'Eén eenvoudige discussie';
$string['smallmessage'] = '{$a->user} heeft gepost in {$a->forumname}';
$string['startedby'] = 'Begonnen door';
$string['subject'] = 'Onderwerp';
$string['subscribe'] = 'Ik wil e-mail van dit forum';
$string['subscribeall'] = 'Laat alle deelnemers van deze cursus e-mail van dit forum ontvangen';
$string['subscribed'] = 'Je krijgt e-mail';
$string['subscribeenrolledonly'] = 'Enkel aangemelde gebruikers mogen inschrijven op een forum om meldingen over nieuwe forumberichten te ontvangen';
$string['subscribenone'] = 'Laat niemand van deze cursus e-mail van dit forum ontvangen';
$string['subscribers'] = 'Krijgen e-mail';
$string['subscribersto'] = 'Krijgen e-mail van \'{$a}\'';
$string['subscribestart'] = 'Stuur me een kopie per e-mail wanneer iemand een bericht op dit forum plaatst';
$string['subscribestop'] = 'Ik wil geen kopie van inzendingen op dit forum per e-mail ontvangen';
$string['subscription'] = 'E-mail krijgen';
$string['subscriptionandtracking'] = 'E-mail krijgen en opvolgen';
$string['subscriptionauto'] = 'Initieel inschrijven';
$string['subscriptiondisabled'] = 'Inschrijven uitgeschakeld';
$string['subscriptionforced'] = 'Verplicht inschrijven';
$string['subscription_help'] = '<p> Een persoon die ingeschreven is op een forum krijgt een kopie per e-mail van elk bericht in dat forum.
De mails worden na ongeveer <?PHP echo $CFG->maxeditingtime/60 ?> minutem verzonden (nadat het bericht voor het eerst
bewaard werd).</p>

<p>Meestal kun je kiezen of je e-mails van een forum wil ontvangen of niet.</p>

<p>Als leraar kun je het krijgen van e-mails van een bepaald forum verplichten. De keuze is dan niet zichtbaar en alle leden
van de cursus zullen kopieën per e-mail krijgen.</p>

<p>Dit is vooral nuttig in het Nieuwsforum en aan het begin van een cursus (voor iedereen ontdekt heeft
dat hij zich zelf kan inschrijven op deze e-mails).</p>';
$string['subscriptionmode'] = 'Inschrijvingsmodus';
$string['subscriptionmode_help'] = 'Wanneer een persoon ingeschreven wordt op een forum, dan betekent dit dat hij e-mailkopieën zal krijgen van elk bericht in dat forum.

Er zijn vier mogelijke manieren om in te schrijven op een forum:

* Optioneeel - Deelnemers kunnen kiezen of ze ingeschreven willen zijn
* Verplicht - Iedereen is ingeschreven en kan niet uitschrijven
* Initieel - Iedereen is initieel ingeschreven, maar kan zich elk moment terug uitschrijven
* Uitgeschakeld - Inschrijven is niet toegestaan

Merk op: wijzigingen van deze instellingen zijn enkel van toepassing op gebruikers die zich na de wijziging in de cursus inschrijven, niet voor bestaande gebruikers.';
$string['subscriptionoptional'] = 'Optioneel inschrijven';
$string['subscriptions'] = 'Deze deelnemers krijgen e-mail';
$string['thisforumisthrottled'] = 'Dit forum heeft een limiet op het aantal berichten dat je kan posten in een bepaalde periode - deze is nu ingesteld op {$a->blockafter} bericht(en) in {$a->blockperiod}';
$string['timedposts'] = 'Getimed bericht';
$string['timestartenderror'] = 'De datum van het einde kan niet voor de startdatum zijn.';
$string['trackforum'] = 'Volg ongelezen berichten op';
$string['tracking'] = 'Volgen';
$string['trackingoff'] = 'Uit';
$string['trackingon'] = 'Verplicht';
$string['trackingoptional'] = 'Optioneel';
$string['trackingtype'] = 'Lezen van dit forum opvolgen';
$string['trackingtype_help'] = 'Als \'Volgen forum\' is ingeschakeld, dan zien gebruikers welke berichten ze gelezen hebben en welke berichten niet.

Er zijn drie keuzemogelijkheden voor deze instelling:

* Optioneel - deelnemers kunnen volgen inschakelen of uitschakelen voor dit forum zoals ze zelf willen
* Verplicht - volgen is altijd ingeschakeld
* Uit - volgen is altijd uitgeschakeld';
$string['unread'] = 'Niet gelezen';
$string['unreadposts'] = 'Niet gelezen berichten';
$string['unreadpostsnumber'] = '{$a} ongelezen berichten';
$string['unreadpostsone'] = '1 ongelezen bericht';
$string['unsubscribe'] = 'Ik wil van dit forum geen e-mail meer ontvangen';
$string['unsubscribeall'] = 'Van geen enkel forum nog e-mail ontvangen';
$string['unsubscribeallconfirm'] = 'je ontvangt nu e-mail van {$a} forums. Wil je echt van geen enkel forum nog e-mail ontvangen en het automatisch ontvangen van e-mail van forums uitschakelen?';
$string['unsubscribealldone'] = 'Alle optionele foruminschrijvingen zijn verwijderd. Je zult nog wel meldingen krijgen van verplichte foruminschrijvingen. Om meldingen van forumberichten te configureren ga je naar Berichten in Mijn profielinstelligen.';
$string['unsubscribeallempty'] = 'Je krijgt van geen enkel forum meldingen. Als je van deze site geen enkel bericht wil ontvangen, ga dan naar Berichten in Mijn profielinstellingen.';
$string['unsubscribed'] = 'Je zult geen mail meer ontvangen';
$string['unsubscribeshort'] = 'Ik wil geen mail meer';
$string['usermarksread'] = 'Manueel bericht als gelezen aanduiden';
$string['viewalldiscussions'] = 'Bekijk alle discussies';
$string['warnafter'] = 'Waarschuw bij maximale aantal berichten bereikt';
$string['warnafter_help'] = 'Leerlingen kunnen gewaarschuwd worden wanneer ze het maximale aantal toegestane berichten bereiken in een bepaalde periode. Deze instelling specificeert na hoeveel berichten ze gewaarschuwd worden. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben deze limiet niet.';
$string['warnformorepost'] = 'Waarschuwing: er is meer dan één discussie in dit forum. De meest recente discussie wordt gebruikt';
$string['yournewquestion'] = 'Je nieuwe vraag';
$string['yournewtopic'] = 'Je nieuwe discussieonderwerp';
$string['yourreply'] = 'Jouw antwoord';
