<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Toegang geweigerd';
$string['accounts'] = 'Gebruikers';
$string['addcategory'] = 'Categorie toevoegen';
$string['additionalhtml'] = 'Bijkomende HTML';
$string['additionalhtml_desc'] = 'Met deze instelling kun je HTML opgeven die je op elke pagina wil laten zien. Je kunt HTML opgeven die tussen de HEAD-tag van de pagina gezet wordt, onmiddellijk nadat de BODY-tag geopend wordt of vlak voor de BODY-tag gesloten wordt. <br />Hierdoor kun je aangepaste headers en footers op elke pagina zetten of kun je heel gemakkelijk ondersteuning voor diensten zoals Google Analytics toevoegen, onafhankelijk van je gekozen thema.';
$string['additionalhtmlfooter'] = 'Voor BODY gesloten wordt';
$string['additionalhtmlfooter_desc'] = 'De inhoud die je hier plaatst zal op elke pagina gezet worden voor de BODY tag gesloten wordt.';
$string['additionalhtmlhead'] = 'In HEAD';
$string['additionalhtmlhead_desc'] = 'De inhoud hier zal onderaan in de HEAD-tag geplaatst worden voor elke pagina.';
$string['additionalhtml_heading'] = 'Bijkomende HTML om op elke pagina toe te voegen.';
$string['additionalhtmltopofbody'] = 'Wanneer de BODY-tag opent';
$string['additionalhtmltopofbody_desc'] = 'De inhoud die hier geplaatst wordt zal op elke pagina gezet worden, vlak na het openen van de BODY-tag';
$string['admincategory'] = 'Categorie: {$a}';
$string['adminseesall'] = 'Beheerders zien alles';
$string['adminseesallevents'] = 'Beheerders zien alle gebeurtenissen';
$string['adminseesownevents'] = 'Beheerders zien niet alle gebeurtenissen';
$string['advancedfeatures'] = 'Geavanceerd';
$string['allcountrycodes'] = 'Alle landcodes';
$string['allowbeforeblock'] = 'Lijst met toegelaten adressen zal eerst verwerkt worden';
$string['allowbeforeblockdesc'] = 'Standaard zal de lijst met geblokkeerde adressen eerst verwerkt worden. Als deze optie is ingeschakeld, dan zullen de toegelaten adressen verwerkt worden vóór de lijst met geblokkeerde adressen.';
$string['allowblockstodock'] = 'Sta toe dat blokken het zijpaneel gebruiken';
$string['allowcategorythemes'] = 'Categoriethema\'s toestaan';
$string['allowcoursethemes'] = 'Cursusthema\'s toestaan';
$string['allowediplist'] = 'Lijst met toegelaten IP\'s';
$string['allowemailaddresses'] = 'E-maildomeinen toestaan';
$string['allowframembedding'] = 'Frame-embedding toestaan';
$string['allowframembedding_help'] = 'Sta het embedden van deze site in frames op een andere site toe. Deze functie inschakelen wordt afgeraden om beveiligingsredenen.';
$string['allowguestmymoodle'] = 'Gasttoegang tot Mijn startpagina toestaan';
$string['allowobjectembed'] = 'EMBED en OBJECT tags toestaan';
$string['allowthemechangeonurl'] = 'Verandering van thema toestaan via de URL';
$string['allowuserblockhiding'] = 'Gebruikers mogen blokken verbergen';
$string['allowuserswitchrolestheycantassign'] = 'Gebruikers zonder het recht om rollen toe te wijzen toelaten om de rol wijzigen schakelaar op de cursuspagina te gebruiken';
$string['allowuserthemes'] = 'Gebruikersthema\'s toestaan';
$string['antivirus'] = 'Anti-virus';
$string['appearance'] = 'Uiterlijk';
$string['aspellpath'] = 'Pad naar aspell';
$string['authentication'] = 'Authenticatie';
$string['authpreventaccountcreation'] = 'Verhinder het aanmaken van een account bij het authenticeren';
$string['authpreventaccountcreation_help'] = 'Wanneer een gebruiker authenticeert, wordt er automatisch een gebruikersaccount aangemaakt als die nog niet bestaat. Als je een externe databank gebruikt, zoals LDAP, en je wil het aanmelden beperken tot gebruikers die al een account hebben, dan moet je deze optie inschakelen. Nieuwe accounts zullen dan manueel of via gebruikers uploaden moeten aangemaakt worden. Merk op dat deze instelling niet van toepassing is op MNET authenticatie. ';
$string['authsettings'] = 'Beheer authenticatie';
$string['autolang'] = 'Taal automatisch detecteren';
$string['autologinguests'] = 'Gasten automatisch inloggen';
$string['availablelicenses'] = 'Beschikbare licenties';
$string['availableto'] = 'Beschikbaar voor';
$string['backgroundcolour'] = 'Transparant';
$string['backups'] = 'Back-ups';
$string['backup_shortname'] = 'Gebruik de cursusnaam in de bestandsnaam van de back-up';
$string['backup_shortnamehelp'] = 'Gebruik de cursusnaam als deel van de bestandsnaam van de back-up.';
$string['badwordsconfig'] = 'Geef je lijst te censureren woorden in, gescheiden door komma\'s';
$string['badwordsdefault'] = 'Je aangepaste lijst is leeg. Er zal een standaardlijst uit het talenpakket gebruikt worden';
$string['badwordslist'] = 'Aangepaste lijst te censureren woorden';
$string['blockediplist'] = 'Lijst met geblokkeerde IP\'s';
$string['blockeditingmenu'] = 'Blokkeer bewerkmenu\'s';
$string['blockeditingmenu_desc'] = 'Wanneer dit ingeschakeld is zullen heel wat bewerk-icoontjes voor blokken verschijnen in en rolmenuutje. Dit vermindert de scherminhoud door het verbergen van icoontjes tot ze nodig zijn.';
$string['blockinstances'] = 'In gebruik';
$string['blockmultiple'] = 'Meer';
$string['blockprotect'] = 'Bescherm blok';
$string['blockprotect_help'] = 'Als je een bepaald type blok beschermt, dan zal niemand exemplaren van dit blok kunnen toevoegen of verwijderen. (Je kunt de bescherming natuurlijk opheffen als je exemplaren van dit blok moet bewerken.)

Dit wordt vooral gebruikt om het navigatie- en instellingenblok te beschermen. Die zijn erg moeilijk terug te zetten zijn indien ze per ongeluk verwijderd worden.';
$string['blocksettings'] = 'Beheer blokken';
$string['blockunprotect'] = 'Onbeschermd';
$string['bloglevel'] = 'Zichtbaarheid blogs';
$string['bookmarkadded'] = 'Bladwijzer toegevoegd';
$string['bookmarkalreadyexists'] = 'Bladwijzer bestaat al';
$string['bookmarkdeleted'] = 'Bladwijzer verwijderd';
$string['bookmarkthispage'] = 'Bladwijzer maken';
$string['cacheapplication'] = 'Toepassingscache';
$string['cacheapplicationhelp'] = 'Items in de cache worden door alle gebruikers gedeeld en vervallen na een welbepaalde ttl (time to live)';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Het cachen en comprimeren van Javascript verbetert de performantie van het laden van pagina\'s aanzienlijk. Het wordt dan ook sterk aangeraden in te schakelen op productieservers. Ontwikkelaars kunnen deze instelling best uitschakelen.';
$string['cacherequest'] = 'Vraag cache';
$string['cacherequesthelp'] = 'Gebruikersspecifieke cache die vervalt wanneer de vraag afgerond is. Ontworpen om zones waar we statische opslag gebruiken te vervangen.';
$string['cachesession'] = 'Sessie cache';
$string['cachesessionhelp'] = 'Gebruikersspecifieke cache die vervalt wanneer de sessie van de gebruiker eindigt. Ontworpen om de sessiebelasting te verlagen';
$string['cachesettings'] = 'Cache instellingen';
$string['cachetext'] = 'Hoelang mag tekst in cache blijven';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Kalender export beveiliging';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertype';
$string['calendartype_desc'] = 'Kies een kalendertype voor de hele site. Deze instelling kan overschreven worden in de cursusinstellingen of door gebruikers in hun profiel.';
$string['calendar_weekend'] = 'Weekend';
$string['cannotdeletemodfilter'] = 'Je kunt de filter \'{$a->filter}\' niet verwijderen omdat die deel uitmaakt van de module \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} kan niet verwijderd worden;';
$string['cfgwwwrootslashwarning'] = 'Je hebt $CFG->wwwroot fout ingesteld in het bestand config.php. Je hebt een \'/\' aan het einde van je pad gezet. Verwijder dit. Je kunt er vreemde bugs mee ondervinden, zoals  <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['cfgwwwrootwarning'] = 'Je hebt $CFG->wwwroot fout ingesteld in het bestand config.php. Het pad komt niet overeen met de URL die je bebruikt om toegang te krijgen tot deze pagina  Pas dit aan. Je kunt er vreemde bugs mee ondervinden, zoals  <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['change'] = 'wijzig';
$string['checkboxno'] = 'Nee';
$string['checkboxyes'] = 'Ja';
$string['choosefiletoedit'] = 'Kies een te bewerken bestand uit bovenstaande lijst';
$string['clamfailureonupload'] = 'Als Clam AV faalt';
$string['cleanup'] = 'Opschonen';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'j';
$string['cliincorrectvalueerror'] = 'Fout, waarde "{$a->value}" voor de optie "{$a->option}" is niet juist';
$string['cliincorrectvalueretry'] = 'Foute waarde. Probeer opnieuw';
$string['clistatusdisabled'] = 'Status: uitgeschakeld';
$string['clistatusenabled'] = 'Status: ingeschakeld';
$string['clistatusenabledlater'] = 'status: CLI onderhoudsmodus zal ingeschakeld worden op {$a}';
$string['clitypevalue'] = 'type waarde';
$string['clitypevaluedefault'] = 'type waarde, druk op Enter om de standaardwaarde te gebruiken ({$a})';
$string['cliunknowoption'] = 'Onherkenbare opties:
{$a}
gebruik --help optie.';
$string['cliupgradefinished'] = 'Upgrade via commandovenster gelukt.';
$string['cliupgradenoneed'] = 'Geen upgrade nodig voor de geïnstalleerde versie {$a}. Toch bedankt voor het bezoek!';
$string['cliyesnoprompt'] = 'typ j (ja) of n (nee)';
$string['commentsperpage'] = 'Commentaren per pagina';
$string['commonfiltersettings'] = 'Algemene filterinstellingen';
$string['commonsettings'] = 'Algemene instellingen';
$string['componentinstalled'] = 'Onderdeel geïnstalleerd';
$string['computedfromlogs'] = 'Berekend uit logs sinds {$a}';
$string['condifmodeditdefaults'] = 'Er worden standaardwaarden gebruikt in het instellingenformulier wanneer je een nieuwe bron of activiteit maakt.';
$string['confeditorhidebuttons'] = 'Kies de knoppen die in de HTML-editor verborgen moeten zijn.';
$string['configallcountrycodes'] = 'Dit is de lijst van landen die op verschillende plaatsen geselecteerd zijn, bijvoorbeeld in een gebruikersprofiel. Als die leeg is (standaardinstelling) dan wordt de lijst in countries.php in het standaard Engelstalig taalpkakket gebruikt. Dat is de lijst van ISO-3166-1. Je kunt ook een kommagescheiden lijst met codes geven, bijvoorbeeld \'GB, FR, ES\'. Als je nieuwe , niet-standaardcodes hier toevoegt, dan moet je ze ook toevoegen in countries.php in \'en\' een in je taalpakket.';
$string['configallowassign'] = 'Je kunt mensen met de rollen aan de linkerkant toestaan om sommige rollen uit de kolom aan anderen te geven.';
$string['configallowblockstodock'] = 'Indien dit ingeschakeld is en ondersteund wordt door het gekozen thema, dan kunnen gebruikers blokken verplaatsen naar een speciaal paneel.';
$string['configallowcategorythemes'] = 'Als je dit inschakelt, dan kunnen thema\'s op categorieniveau gekozen worden. Die keuze wordt dan doorgetrokken naar alle onderliggende categorieën en cursussen, tenzij daar een eigen thema ingesteld is. WAARSCHUWING: het inschakelen van categoriethema\'s kan de performantie negatief beïnvloeden.';
$string['configallowcoursethemes'] = 'Als je dit inschakelt, dan kan elke cursus zijn eigen thema instellen. De thema\'s van de cursussen zullen alle andere thema\'s overschrijven (site, gebruiker of sessiethema\'s)';
$string['configallowemailaddresses'] = 'Als je nieuwe e-mailadressen wil beperken tot bepaalde domeinen, zet ze dan hier in een lijst met een spatie als scheidingsteken. Alle andere domeinen zullen niet geaccepteerd worden. Om subdomeinen toe te staan, kun je de domeinnaam laten vooraf gaan door een ".".bv <strong>onzeschool.edu.be .onscollege.nl</strong>';
$string['configallowguestmymoodle'] = 'Indien ingeschakeld kunnen gasten "Mijn startpagina" bezoeken, anders worden gasten naar de site startpagina gestuurd.';
$string['configallowobjectembed'] = 'Als standaard beveiligingsmaatregel kunnen gewone gebruikers geen multimedia (zoals Flash) in teksten insluiten door gebruik te maken van EMBED en OBJECT tags in hun HTML (hoewel het veilig ingesloten kan worden met de mediaplugins filter). Als je deze tags toch wil laten gebruiken, dan kun je deze optie inschakelen';
$string['configallowoverride'] = 'Je kunt toestaan om mensen met rollen aan de linkerkant sommige rollen te overschrijven';
$string['configallowoverride2'] = 'Kies welke rol(len) overschreven kan worden door een andere rol in de linker kolom.<br /> Merk op dat deze instelling enkel geldt voor gebruikers waarvan de mogelijkheid  moodle/role:override of de mogelijkheid moodle/role:safeoverride toegelaten is.';
$string['configallowswitch'] = 'Selecteer naar welke rollen een gebruiker mag schakelen, gebaseerd op de rollen die hij al heeft. Bovenop de instellingen in deze tabel heeft een gebruiker ook de mogelijkheid moodle/role:switchroles nodig om zijn rol te kunnen omschaklen. <br />Merk op dat het alleen mogelijlk is te schakelen naar rollen die de moodle/course:view mogelijkheid hebben en die niet de mogelijkheid moodle/site:doanything hebben. Daarom kunnen sommige kolommen in deze tabel uitgeschakeld zijn.';
$string['configallowthemechangeonurl'] = 'Als je deze instelling inschakelt, dan kan het thema gewijzigd worden door het volgende toe te voegen: <br /> ofwel ?theme=themename aan gelijk welke Moodle URL (vb: mymoodlesite.com/?theme=afterburner ) of <br />&theme=themename aan elke interne  Moodle URL (vb: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Wil je gebruikers toelaten om blokken te verbergen of te tonen? Deze functie gebruikt Javascript en cookies om de status van elk samenklapbaar blok te bewaren en heeft enkel gevolg voor het beeld van de individuele gebruiker.';
$string['configallowuserswitchrolestheycantassign'] = 'Standaard is moodle/role:assign vereist om gebruikers toe te laten de schakelaar om van rol te wisselen te gebruiken. Deze instelling inschakelen verwijdert deze vereiste, waardoor de mogelijke rollen in het rolmenu alleen nog bepaald worden door de instellingen in de "Toewijzen van rollen toestaan"-tabel.
Het is aangewezen in dde "Toewijzen van rollen toestaan"-tabel gebruikers niet het recht te geven rollen toe te wijzen met meer mogelijkheden dan hun eigen rol.';
$string['configallowuserthemes'] = 'Als je dit inschakelt, dan kunnen gebruikers hun eigen thema kiezen. Gebruikersthema\'s gaan boven sitethema\'s (maar niet boven cursusthema\'s)';
$string['configallusersaresitestudents'] = 'Moeten ALLE gebruikers als leerlingen beschouwd worden voor activiteiten op de startpagina van de site? Als je hier "Ja" kiest, dan zullen alle bevestigde accounts hier als leerling kunnen meedoen aan alle activiteiten. Als je hier "Nee" kiest, dan zullen alleen gebruikers die minstens van één cursus lid zijn kunnen meedoen aan die startpagina-activiteiten.';
$string['configauthenticationplugins'] = 'Kies de authenticatieplugins die je wenst te gebruiken en rangschik ze in volgorde, zodat diegene met het meeste kans op succes heeft, bovenaan staat.';
$string['configautolang'] = 'Detecteer de standaardtaal uit de browserinstelling. Indien uitgeschakeld, wordt de standaardtaal van de site gebruikt.';
$string['configautologinguests'] = 'Moeten bezoekers automatisch als gast aangemeld worden als ze cursussen met toegangsrecht voor gasten binnengaan ?';
$string['configbloglevel'] = 'Met deze instelling kun je het niveau beperken waarop gebruikers blogs op deze site kunnen zien. Merk op dat ze een maximum zetten voor wie KIJKT, niet voor wie berichten post of de mogelijke types berichten die gepost kunnen worden. Blogs kunnen ook uitgeschakeld worden als je ze niet wil.';
$string['configcachetext'] = 'Deze instelling kan de snelheid vergroten voor grotere sites of voor sites die tekstfilters gebruiken. kopieën van teksten zullen in hun gecompileerde vorm bewaard worden voor de tijd die je hier instelt. Als je deze tijd te kort instelt, zou je zelfs een kleine vertraging kunnen krijgen, maar de tijd te lang instellen kan ervoor zorgen dat het te lang duurt voor teksten vernieuwd worden (met nieuwe links bijvoorbeeld).';
$string['configcalendarcustomexport'] = 'Aangepast datumbereik inschakelen voor het exporteren van de kalender';
$string['configcalendarexportsalt'] = 'Deze willekeurige tekst wordt gebruikt om de beveiliging van authenticatie-tokens te verbeteren. Deze tokens worden gebruikt bij het exporteren van kalenders. Alle huidige tokens worden ongeldig als je deze tekst wijzigt.';
$string['configclamactlikevirus'] = 'Behandel bestanden als virussen';
$string['configclamdonothing'] = 'Behandel bestanden als OK';
$string['configclamfailureonupload'] = 'Als je clam geconfigureerd hebt om geüploade bestanden op virussen te scannen, maar het is slecht geconfigureerd of loopt niet om één of andere reden, hoe moet Moodle zich dan gedragen? Als je kiest voor "Behandel alle bestanden als virussen", dan zullen alle bestanden naar de quarantainezone  verplaatst worden of verwijderd worden. Als je kiest voor "Behandel bestanden als OK", dan zullen de bestanden naar de bedoelde map verplaatst worden zoals normaal. In beide gevallen wordt de beheerder op de hoogte gebracht van het slecht werken van clam. Als je kiest voor "Behandel bestanden als virussen" en om één of andere reden werkt clam niet (gewoonlijk omdat je een verkeerd pad naar clam gegeven hebt), dan zullen ALLE geüploade bestanden naar de quarantainezone verplaatst worden of verwijderd worden. Wees voorzichtig met deze instelling.';
$string['configconvertformat'] = '	
Als <i>latex</i>, <i>dvips</i> en <i>convert</i> beschikbaar zijn, dan kunnen de afbeeldingen gemaakt worden met het opgegeven formaat. Anders zal mimeTeX gebruikt worden en dat maakt GIF-afbeeldingen.';
$string['configcookiehttponly'] = 'Schakelt nieuwe PHP 5.2.0-mogelijkheid in - browsers moeten cookies alleen met echte http-requests verzenden, cookies zouden niet toegankelijk mogen zijn voor script-talen. Dit wordt niet in alle browsers ondersteund en het is mogelijk dat het nog niet compatibel is met alle huidige code. Het helpt sommige types van XSS-aanvallen te voorkomen.';
$string['configcookiesecure'] = 'Als de server alleen https-verbindingen aanvaardt, dan is het aangeraden om het versturen van secure cookies in te schakelen. Als dit ingeschakeld is, zorg er dan voor dat de webserver geen http:// toelaat of zet een permanente redirectie op naar een https://-adres. Wanneer het <em>wwwroot</em> niet begint met https://, dan wordt deze instelling automatisch uitgeschakeld.';
$string['configcountry'] = 'Als je hier een land invult, wordt dit land als standaard geselecteerd bij nieuwe gebruikersaccounts. Laat dit veld gewoon leeg om gebruikers te dwingen een land te kiezen.';
$string['configcourseoverviewfilesext'] = 'Een kommagescheiden lijst van toegestane bestandsextenties voor cursussamenvattingen.';
$string['configcourseoverviewfileslimit'] = 'Het maximaal aantal bestanden dat als bijlage bij een cursussamenvatting kan gevoegd worden.';
$string['configcourserequestnotify'] = 'Geef de gebruikersnaam van de gebruiker die een melding moeten krijgen wanneer er een nieuwe cursus aangevraagd wordt.';
$string['configcourserequestnotify2'] = 'Gebruikers die een melding zullen krijgen als er een nieuwe cursus wordt aangevraagd. Alleen gebruikers die een cursus kunnen goedkeuren, worden hier getoond.';
$string['configcoursesperpage'] = 'Geef het maximale aantal te tonen cursussen per pagina in een cursuslijst';
$string['configcourseswithsummarieslimit'] = 'Het maximale aantal te tonen cursussen in een cursuslijst met samenvattingen voor terug te vallen op een eenvoudigere lijst.';
$string['configcronclionly'] = 'Als dit is ingesteld, dan kan cron alleen vanaf de command prompt gestart worden en niet via het web. Dit gaat voor op de wachtwoordinstelling van cron hieronder.';
$string['configcronremotepassword'] = 'Dit betekent dat het script cron.php niet vanuit een webbrowser gestart kan worden zonder het wachtwoord te geven in volgend formulier <pre>
http://site.voorbeeld.com/admin/cron.php?password=opensesame
</pre> Als dit leeggelaten wordt, is er geen wachtwoord nodig';
$string['configcurlcache'] = 'Levenduur van cURL-cache in sekonden.';
$string['configcustommenuitems'] = 'Je kunt hier een aangepast menu laten tonen door thema\'s. Elke lijn bestaat uit wat menu tekst, een URL (optioneel), een tooltip titel (optioneel) en een taalcode of kommagescheiden lijst met codes (optioneel, om de lijn aan gebruikers van een bepaalde taal te tonen), gescheiden door pipe tekens ( | ). Je kunt de structuur opgeven met liggende streepjes. Bijvoorbeeld:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Tracker|https://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
-Moodle.com|https://moodle.com/
</pre>';
$string['configdbsessions'] = 'Als dit ingeschakeld is, dan zal de databank gebruikt worden om informatie over de sessies te bewaren. Merk op dat het wijzigen van deze instelling alle gebruikers zal afmelden (jij inbegrepen).
Indien je MySQL gebruikt, zorg er dan voor dat \'max_allowed_packet\' in my.cnf (of my.ini) minstens 4M is. Andere sessiedrivers kunnen juist geconfigureerd worden in config.php - raadpleeg config-dist.php voor meer informatie. Deze optie verdwijnt als je een sessiedriver opgeeft in je config.php-bestand.';
$string['configdebug'] = 'Als je dit aan zet zullen er meer PHP-fouten op het scherm worden weergegeven. Dit is alleen maar handig voor ontwikkelaars van de applicatie.';
$string['configdebugdisplay'] = 'Als je dit inschakelt, dan gaat de foutmelding naar de HTML pagina. Dit is handig, maar het breekt XHTML, JS, Cookies en HTTP-headers in het algemeen. Als je dit uitschakelt, dan zal de output naar je serverlogs weggeschreven worden, wat een betere foutopsporing mogelijk maakt. De PHP-instelling error_log controleert naar welk logbestand dit gaat.';
$string['configdebugpageinfo'] = 'Schakel in als je paginainformatie onderaan de pagina wil zien';
$string['configdebugsmtp'] = 'Schakel het tonen van foutopsporingsinformatie tijdens het sturen van e-mailberichten naar de SMTP-server.';
$string['configdebugvalidators'] = 'Schakel dit in als je links naar externe paginavalidators wil zien onderaan elke pagina. Het is mogelijk dat je een nieuwe gebruikersaccount moet maken <em>w3cvalidator</em>, en gasttoegang moet inschakelen. Deze wijzigingen kunnen ongeauthenticeerde toegang tot de server mogelijk maken, schakel dit niet in op productiesites!';
$string['configdefaulthomepage'] = 'Dit bepaalt de startpagina voor aangemelde gebruikers';
$string['configdefaultrequestcategory'] = 'Cursussen die door gebruikers aangevraagd worden zullen automatisch in deze categorie gezet worden.';
$string['configdefaultrequestedcategory'] = 'Standaardcategorie om aangevraagde cursussen te plaatsen nadat ze goedgekeurd zijn.';
$string['configdefaultuserroleid'] = 'Alle aangemelde gebruikers zullen de rechten krijgen van de rol die je hier op siteniveau opgeeft. Deze rol is bijkomend bij andere rollen die je misschien al gegeven hebt. De standaardrol is de rol van geauthenticeerde gebruiker.
Merk op dat dit geen conflict geeft met andere rollen die je gebruikers al hebben - het zorgt er alleen voor dat alle gebruikers mogelijkheden krijgen op site-niveau, die niet kunnen toegewezen worden op cursusniveau  (vb het posten van blogs, beheren van eigen kalender enz.)';
$string['configdeleteincompleteusers'] = 'Na deze periode zullen oude, niet volledig ingestelde accounts verwijderd worden.';
$string['configdeleteunconfirmed'] = 'Als je met e-mailauthenticatie werkt dan is dit de periode waarbinnen gebruikers moeten reageren op de bevestigingsmail voor de nieuwe account. Na deze periode zullen oude, niet-bevestigde accounts verwijderd worden.';
$string['configdenyemailaddresses'] = 'Om e-mailadressen van bepaalde domeinen te weigeren, kun je ze hier op dezelfde manier opnemen. Alle andere domeinen zullen aanvaard worden. Om subdomeinen te weigeren, geef je de domeinnaam, voorafgegaan door een \'.\' bv <strong>hotmail.com yahoo.co.uk; .live.com</strong>';
$string['configdisableuserimages'] = 'Schakel het wijzigen van het profielprentje uit voor alle gebruikers.';
$string['configdisplayloginfailures'] = 'Dit zal informatie tonen over mislukte aanmeldingen van de geselecteerde gebruikers';
$string['configdndallowtextandlinks'] = 'Slepen en neerzetten van teksten en links inschakelen of uitschakelen, samen met het slepen en neerzetten van bestanden. Merk op dat het slepen van tekst in Firefox of tussen verschillende browsers onbetrouwbaar is en kan resulteren in geen of verminkte gegevens die geuploaded worden.';
$string['configdocroot'] = 'Bepaalt het pad naar Moodle Docs voor contextgevoelige hulp via de link \'MoodleDocs voor deze pagina\' onderaan elke pagina. Als dit veld leeg gelaten wordt, dan wordt er geen link getoond.';
$string['configdoctonewwindow'] = 'Als je dit aanzet zullen links naar Moodle Docs geopend worden in een nieuw venster';
$string['configeditordictionary'] = 'Deze waarde zal gebruikt worden als aspell geen woordenlijst heeft voor de eigen taal van een gebruiker.';
$string['configeditorfontlist'] = 'Kies de lettertypes die in het dropdownmenu van de editor zouden moeten verschijnen';
$string['configemailchangeconfirmation'] = 'Als een gebruiker zijn e-mailadres wil wijzigen, moet die dat dan bevestigen via een bevestigingsmail? Deze optie inschakelen is nuttig op sites waar gebruikers zelf accounts kunnen aanmaken en wijzigen en waarbij die accounts gebruikt kunnen worden voor het versturen van spam.';
$string['configenableajax'] = 'Met deze instelling kun je het gebruik van AJAX  controleren voor de hele site. AJAX is vereist voor functies als slepen en neerzetten';
$string['configenableblogs'] = 'Hiermee geef je alle gebruikers op de site hun eigen blog.';
$string['configenablecalendarexport'] = 'Exporteren of abonneren op kalenders inschakelen';
$string['configenablecomments'] = 'Commentaren inschakelen';
$string['configenablecourserequests'] = 'Hiermee kan elke gebruiker aanvragen om een nieuwe cursus aan te maken.';
$string['configenabledevicedetection'] = 'Maakt het detecteren van telefoons, smartphones, tabletcomputers of andere standaardapparatuur (desktops, laptops enz) mogelijk voor het toepassen van thema\'s en andere functies.';
$string['configenablegroupmembersonly'] = 'Deze instelling schakelt de \'enkel groepsleden\' mogelijkheid in. Merk op dat dit de belasting op je server vergroot.
Je moet ook categorieën instellen in je puntenboek en wel zo dat activiteiten niet zichtbaar zijn voor niet-groepsleden.';
$string['configenablemobilewebservice'] = 'Schakel de mobiele service in voor de officiële Moodle app of voor andere toepassingen die dat nodig hebben. Lees voor meer informatie {$a}';
$string['configenablerssfeeds'] = 'Met deze instelling maak je RSS-feeds mogelijk voor functies over de hele site, zoals blogs, databanken, forums en woordenlijsten. Merk op dat RSS ook moet ingeschakeld worden op het niveau van de activiteitsmodule.';
$string['configenablerssfeedsdisabled'] = 'Dit is niet beschikbaar omdat RSS voor heel de site is uitgeschakeld. Om RSS in te schakelen ga je naar Configureer variablen onder Beheer Configuratie.';
$string['configenablerssfeedsdisabled2'] = 'RSS-feeds zijn uitgeschakeld op serverniveau. Je moet ze inschakelen in Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Hiermee voeg je de keuze "Safe exam browser vereist\' toe aan het browserbeveiligingsveld op de instellingenpagina van een test. Kijk op http://www.safeexambrowser.org/ voor meer informatie.';
$string['configenablestats'] = 'Als je hier \'ja\' kiest, zal de cron van Moodle de logbestanden verwerken en statistieken aanmaken. Afhankelijk van de hoeveelheid verkeer op je site, kan dit wel even duren. Als je dit inschakelt kun je interessante grafieken en statistieken zien over elke cursus of over de hele site.';
$string['configenabletrusttext'] = 'Moodle zal altijd tekst, afkomstig van gebruikers, grondig opschonen. Zo worden gevaarlijke scripts, media enz., die een beveiligingsrisico kunnen zijn, verwijderd. Het vertrouwde inhoudsysteem is een manier om het voor bepaalde gebruikers toch mogelijk te maken om geavanceerde functies in hun cursusmateriaal te gebruiken. Om dit systeem in te schakelen, moet je eerst hier de instelling inschakelen en dan het Vertrouwde Inhoud-recht toekennen aan een specifieke Moodle rol. Teksten die gemaakt of geüpload worden door gebruikers met die rol, zullen als vertrouwd gemarkeerd worden en zullen niet opgeschoond worden voor ze getoond worden.';
$string['configenablewebservices'] = 'Webservices maken het mogelijk dat andere systemen aanmelden in deze Moodle-installatie en acties uitvoeren. Voor extra veiligheid moet dit uitgeschakeld worden tenzij je het echt gebruikt.';
$string['configenablewsdocumentation'] = 'Schakel het automatisch genereren van web services documentatie in. Een gebruiker kan toegang krijgen tot zijn eigen documentatie op zijn beveiligingssleutelpagina {$a}. Dit toont enkel de documentatie voor de ingeschakelde protocols.';
$string['configerrorlevel'] = 'Kies hoeveel PHP-waarschuwingen je wilt dat Moodle laat zien. \'Normaal\' is meestal de beste keuze.';
$string['configexportlookahead'] = 'Aantal dagen vooruit kijken tijdens export';
$string['configexportlookback'] = 'Aantal dagen terug kijken tijdens export';
$string['configextendedusernamechars'] = 'Schakel deze optie in om het mogelijk te maken dat gelijk welke karakters in de gebruikersnaam gebruikt kunnen worden (merk op dat deze instelling geen invloed heeft op de voornaam of achternaam). De standaardinstelling is "false", wat ervoor zorgt dat alleen alfanumerieke kleine tekens gebruikt kunnen worden en underscore (_), liggend streppje (-), punt (.) en het at-symbool (@).';
$string['configextramemorylimit'] = 'Sommige scripts, zoals zoeken, back-up en terugzetten en crom hebben meer geheugen nodig. Zet dit hoger voor grote sites.';
$string['configfilterall'] = 'Filter alle strings: hoofdingen, titels, navigatiebalk enz. inbegrepen. Dit is meestal slechts nuttig wanneer je de multilang-filter gebruikt. Anders zal het alleen maar een extra belasting op je server veroorzaken zonder meerwaarde.';
$string['configfiltermatchoneperpage'] = 'Automatische link-filters zullen slechts één link per pagina genereren, namelijk de eerste overeenkomst die gevonden wordt op de hele pagina. Alle andere overeenkomsten worden genegeerd.';
$string['configfiltermatchonepertext'] = 'Automatische link-filters zullen slechts één link per tekstonderdeel  (bron, blok) genereren. Alle andere overeenkomsten worden genegegeerd. Deze instelling wordt genegeerd als de instelling één per pagina op <i>ja</i> staat.';
$string['configfilteruploadedfiles'] = 'Verwerk alle geüploade HTML- en tekstbestanden met de gekozen filters voor ze getoond worden, enkel geüploade HTML-bestanden of niets.';
$string['configforcelogin'] = 'Standaard kunnen de startpagina van de site en de lijst van cursussen (maar niet de cursussen zelf) bekeken worden door iedereen, zonder zich aan te melden op de site. Als je wil afdwingen dat er moet aangemeld worden voor er maar iets van de site te zien is, dan kan dat door deze instelling aan te zetten.';
$string['configforceloginforprofiles'] = 'Schakel deze optie in om gebruikers te dwingen zich aan te melden met een echte (niet gast-) account voor ze de pagina\'s met gebruikersprofielen kunnen zien. Standaard staat deze instelling ingeschakeld.
Als je deze optie uitschakeld, dan zou het kunnen dat sommige gebruikers advertenties (spam) of andere ongepaste inhoud in hun profiel zetten, dat dan zichtbaar is voor de hele wereld.';
$string['configfrontpage'] = 'De hierboven gekozen items zullen op de startpagina van de site getoond worden.';
$string['configfrontpagecourselimit'] = 'Maximaal aantal cursussen';
$string['configfrontpagecourselimithelp'] = 'Het maximaal aantal te tonen cursussen op de startpagina in de cursussenlijst.';
$string['configfrontpageloggedin'] = 'De hierboven gekozen items zullen op de startpagina van de site getoond worden, wanneer een gebruiker aangemeld is.';
$string['configfullnamedisplay'] = 'Deze instelling bepaalt hoe de volledige namen getoond worden. De standaardwaarde, "Taal", laat het over aan de string "fullnamedisplay" in het huidige taalpakket. Sommige talen hebben verschillende conventies voor het tonen van namen.

Voor de meeste eentalige sites is de beste instelling de standaardinstelling, nl "voornaam + achternaam", maar je kunt ervoor kiezen de achternaam te verbergen. Er kunnen plaatshouders gebruikt worden, zoals firstname, lastname, firstnamephonetic, lastnamephonetic, middlename en alternatename.';
$string['configgeoipfile'] = 'Plaats van het GeoIP City binair data bestand. Dit bestand is geen deel van de Moodledistributie en moet apart bekomen worden van  <a href="http://www.maxmind.com/">MaxMind</a>. Je kunt ofwel een commerciële versie bekomen of de gratis versie gebruiken.<br />Download <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> en unzip het in de map "{$a}" op je server.';
$string['configgetremoteaddrconf'] = 'Als je server zich achter een reverse proxy bevindt, dan kun je deze instelling gebruiken om te specifiëren welke HTTP headers vertrouwd kunnen worden dat ze het IP-adres van de client bevatten. De headers worden in volgorde gelezen. De eerste die gevonden wordt, word gebruikt.';
$string['configgradebookroles'] = 'Deze instelling bepaalt wie er in de cijferlijsten verschijnt. Gebruikers moeten minstens één van deze rollen hebben om in de cijferlijsten voor die cursus te verschijnen.';
$string['configgradeexport'] = 'Kies welke formaten je wil om je punten te exporteren. De gekozen plugins worden dan ingesteld en gebruiken een "laatst geëxporteerd veld" voor elk cijfer. Dit kan er bijvoorbeeld voor zorgen dat geëxporteerde records geïdentificeerd worden als nieuw of aangepast. Als je niet zeker bent van deze instelling, laat dan alles staan zonder vinkje.';
$string['confighiddenuserfields'] = 'Kies welke velden van de gebruikersinformatie je wil verbergen voor andere gebruikers dan leraren en beheerders. Hierdoor kun je de privacy van je gebruikers vergroten. Gebruik de Ctrl-toets om meerdere velden te selecteren.';
$string['configidnumber'] = 'Deze optie specificeert of (a) de gebruikers helemaal niet worden gevraagd om een leerlingnummer, (b) gebruikers wel worden gevraagd om een leerlingnummer maar dit leeg kunnen laten of (c) gebruikers worden gevraagd om het leerlingnummer en dit niet leeg kunnen laten. Als het leerlingnummer wordt opgegeven dan wordt dit getoond in het profiel.';
$string['configintro'] = 'Op deze pagina kun je een aantal variabelen voor de configuratie instellen die Moodle kunnen helpen om goed werken op jouw server. Maak je er niet teveel zorgen over, de standaardwaarden werken meestal prima en je kunt later altijd nog op deze pagina terugkomen en deze instellingen opnieuw wijzigen.';
$string['configintroadmin'] = 'Op deze pagina configureer je de account van de beheerder die de volledige controle over de site zal hebben. Geef de beheerder een veilige gebruikersnaam en wachtwoord en een geldig e-mailadres. Je kunt later beheerderaccounts bijmaken.';
$string['configintrosite'] = 'Op deze pagina configureer je de startpagina en de naam van deze nieuwe site. Je kunt deze instellingen later bijwerken door de beheermenu\'s te gebruiken.';
$string['configiplookup'] = 'Wanneer je op een IP-adres klikt (zoals 33.54.123.43), bijvoorbeeld in de logs, dan krijg je  een kaart te zien met een goede gok van waar dat IP-adres gelegen is. Er zijn verschillende plugins waaruit je kunt kiezen, elk met zijn voor-en nadelen.';
$string['configkeeptagnamecase'] = 'Schakel in om hoofdletters in tag-namen te behouden zoals ze door de gebruikers bij aanmaken ingegeven zijn.';
$string['configlang'] = 'Kies een standaardtaal voor de gehele site. Gebruikers kunnen deze instelling later eventueel wijzigen in hun profiel.';
$string['configlanglist'] = 'Laat dit vak blanco om gebruikers de mogelijkheid te geven om te kiezen uit elke beschikbare taal in deze Moodle-installatie. Je kunt het keuzemenu voor talen inkorten door een lijst in te geven met de gewenste talen, gescheiden door komma\'s. Bijvoorbeeld:en,es_es,fr,it,nl';
$string['configlangmenu'] = 'Kies of je de gebruiker een taalkeuze wil laten maken op de startpagina, de aanmeldpagina enz. Dit neemt de mogelijkheid niet weg dat de gebruiker een taal kan kiezen in zijn eigen profiel.';
$string['configlangstringcache'] = 'Maakt een cache van alle taalstrings in gecompileerde bestanden in de datamap. Als je Moodle vertaalt of je wijzigt strings in de broncode van Moodle, dan wil je dit waarschijnlijk uitschakelen. Laat het anders aanstaan voor performantie.';
$string['configlatinexcelexport'] = 'Kies de encoding voor Excel export';
$string['configlocale'] = 'Kies een sitebrede \'locale\' - dit zal de opmaak en taal van data van alle gebruikte taalpakketten beïnvloeden (de namen van de dagen in de kalender worden niet gewijzigd). Deze \'locale\' moet al geïnstalleerd zijn op je besturingssysteem. (Bijvoorbeeld en_US.UTF8 of es_ES.UTF8). Voor de meeste installaties MOET DIT VELD LEEG GELATEN WORDEN.';
$string['configloginhttps'] = 'Als je dit inschakelt gebruikt Moodle een veilige https-verbinding voor de inlogpagina (zodat de aanmelding veilig gebeurt), en keert dan terug naar de gewone http-URL voor de snelheid. OPGELET: deze instelling VEREIST dat https ingeschakeld is op de webserver - indien dat niet het geval is KUN JE JEZELF UITSLUITEN VAN TOEGANG TOT JE SITE.';
$string['configloglifetime'] = 'Dit specificeert de lengte van de periode waarin logs van gebruikersactiviteit worden bewaard. Logs die ouder zijn worden automatisch verwijderd. Het is verstandig om de logs zo lang mogelijk te bewaren, je kunt ze immers altijd nog nodig hebben. Maar als je een zeer drukke server hebt en prestatieproblemen ondervindt, kun je de periode misschien beter minder lang maken. Waardes lager dan 30 worden niet aangeraden omdat statistieken dan niet correct meer werken.';
$string['configlookahead'] = 'Aantal dagen vooruit kijken';
$string['configmaxbytes'] = 'Dit bepaalt de maximale grootte van geüploade bestanden in heel de site. De instelling is beperkt door de PHP-instelling upload_max_filesize en de Apache-instelling LimitRequestBody. Anderzijds beperkt maxbytes het bereik van groottes dat gekozen kan worden op cursus- of moduleniveau. Als je kiest voor de serverlimiet, dan zal de limiet van de serverinstellingen gekozen worden.';
$string['configmaxconsecutiveidentchars'] = 'Wachtwoorden mogen niet meer dan dit aantal opeenvolgende identieke tekens hebben. Gebruik 0 om deze controle uit te schakelen.';
$string['configmaxeditingtime'] = 'Dit bepaalt hoe lang mensen de tijd hebben om hun forumbijdrage, feedback en dergelijke te wijzigen. Meestal is 30 minuten een goede tijd.';
$string['configmaxevents'] = 'Aantal gebeurtenissen vooruit kijken';
$string['configmaxusersperpage'] = 'Het maximaal aantal te tonen gebruikers in de gebruikersselector in cursus, groep, webservice, enz.';
$string['configmessaging'] = 'Wil je dat het boodschappensysteem voor sitegebruikers ingeschakeld wordt?';
$string['configmessagingallowemailoverride'] = 'Sta gebruikers toe om berichten via e-mail te laten verzenden naar een andere e-mailadres dan dat wat in hun profiel is ingesteld.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Gelezen notificaties kunnen gewist worden om ruimte te besparen. Hoe lang nadat de melding gelezen is mag die verwijderd worden?';
$string['configmessaginghidereadnotifications'] = 'Verberg de gelezen meldingen van gebeurtenissen zoals forumberichten wanneer je de berichtengeschiedenis bekijkt';
$string['configminpassworddigits'] = 'Minimaal aantal cijfers voor wachtwoorden';
$string['configminpasswordlength'] = 'Minimaal aantal tekens voor wachtwoorden';
$string['configminpasswordlower'] = 'Minimaal aantal kleine letters voor wachtwoorden';
$string['configminpasswordnonalphanum'] = 'Minimaal aantal niet-alphanumerieke tekens voor wachtwoorden';
$string['configminpasswordupper'] = 'Minimaal aantal hoofdletters voor wachtwoorden';
$string['configmobilecssurl'] = 'Een CSS-bestand om je mobiele app interface aan te passen.';
$string['configmodchooserdefault'] = 'Moet de activiteitskiezer standaard aan de gebruikers getoond worden?';
$string['configmycoursesperpage'] = 'Het maximale aantal cursussen dat in een cursuslijst van een gebruiker mogen getoond worden.';
$string['configmymoodleredirect'] = 'Deze instelling dwingt een verwijzing af naar de map /my voor niet-beheerders bij het aanmelden en vervangt het broodkruimelmenu door /my';
$string['configmypagelocked'] = 'Deze instelling verhindert dat de standaardpagina gewijzigd wordt door niet-beheerders';
$string['confignavcourselimit'] = 'Beperkt het aantal cursussen getoont aan de gebruiker wanneer ze niet ingelogd zijn of wanneer ze bij geen enkele cursus aangemeld zijn.';
$string['confignavshowallcourses'] = 'Deze instelling bepaalt of gebruikers die aangemeld zijn in cursussen de lijst met alle cursussen kunnen zien in de navigatie, naast "Mijn cursussen" (de lijst met alle cursussen waarin ze aangemeld zijn).';
$string['confignavshowcategories'] = 'Toon cursuscategorieën in de navigatiebalk en navigatieblokken. Dit doet zich niet voor met cursussen waarin de gebruiker aangemeld is, die zullen getoond worden onder mijn cursussen zonder categorieën.';
$string['confignotifyloginfailures'] = 'Als er mislukte aanmeldingen gelogd worden, dan kunnen er e-mailnotificaties verstuurd worden. Wie moet deze notificaties zien?';
$string['confignotifyloginthreshold'] = 'Als notificaties over mislukte aanmeldingen verzonden moeten worden, hoeveel aanmeldingspogingen  door één gebruiker of vanaf één IP-adres zijn het melden waard?';
$string['confignotloggedinroleid'] = 'Gebruikers die niet aangemeld zijn bij de site zullen behandeld worden alsof ze binnen de site deze rol gekregen hebben.
Gast is meestal wat je hier wil, maar het is mogelijlk dat je hier een rol wil creëren die meer of minder beperkend is. Zaken zoals het posten van berichten zullen altijd vereisen dat de gebruiker met een account is aangemeld.';
$string['configopentogoogle'] = 'Als je deze instelling inschakelt, dan zal Google als gast toegelaten worden tot je site. Mensen die jouw site binnenkomen via Google zullen automatisch als gast aangemeld zijn. Merk op dat dit alleen toegang zal geven tot cursussen waar toegang voor gasten toegelaten is.';
$string['configoverride'] = 'Gedefinieerd in config.php';
$string['configpasswordpolicy'] = 'Deze instelling maakt dat Moodle controleert of wachtwoorden voldoen aan een wachtwoordenbeleid.Gebruik onderstaande instellingen om je beleid op te maken (de instellingen zullen genegeerd worden als je deze instelling op \'Nee\' zet).';
$string['configpasswordresettime'] = 'Dit bepaalt hoeveel tijd gebruikers hebben om te klikken op de link in de reset wachtwoord e-mail voor die verloopt.
30 minuten is gewoonlijk een goede waarde.';
$string['configpathtoclam'] = 'Pad naar clam AV. Gewoonlijk iets als /usr/bin/clamscan of /usr/bin/clamdscan. Je hebt dit nodig om clam AV te laten lopen.';
$string['configpathtodu'] = 'Pad naar du. Waarschijnlijk iets als /usr/bin/du. Als je dit invult, dan zullen pagina\'s die mapinhoud tonen veel sneller openen bij mappen met veel bestanden in.';
$string['configperfdebug'] = 'Als je dit inschakelt wordt er informatie over de performantie getoond onderaan de pagina. Je moet hiervoor het standaard thema gebruiken.';
$string['configprofileroles'] = 'Lijst met rollen die zichtbaar zijn op gebruikersprofielen en deelnemerspagina.';
$string['configprofilesforenrolledusersonly'] = 'Om misbruik door spammers te vermijden worden profielbeschrijvingen van gebruikers die in geen enkele cursus aangemeld zijn, verborgen. Nieuwe gebruikers moeten in minstens één cursus aangemeld zijn voor zij een profielbeschrijving kunnen toevoegen.';
$string['configprotectusernames'] = 'De standaardinstelling voor forget_password.php is dat er geen hints getoond worden die het zouden mogelijk maken een gebruikersnaam of e-mailadres te raden.';
$string['configproxybypass'] = 'Kommagescheiden lijst of (gedeeltelijke) hostnamen of IP-adressen die de proxyserver zouden moeten negeren (vb., 192.168., .mijndomein.com)';
$string['configproxyhost'] = 'Als deze <b>server</b> een proxyserver (zoals bijvoorbeeld een firewall) nodig heeft om op het internet te komen, vul hier dan de hostname en de poort van de proxy in. Laat het veld leeg als dit niet het geval is.';
$string['configproxypassword'] = 'Wachtwoord nodig om door een proxy op het internet te komen, leeg indien geen wachtwoord (PHP cURL extentie nodig).';
$string['configproxyport'] = 'Als deze server een proxyserver gebruikt, zet dan hier de gebruikte poort.';
$string['configproxytype'] = 'Type web proxy (PHP5 en cURL extentie nodig voor SOCKS5 ondersteuning).';
$string['configproxyuser'] = 'Gebruikersnaam nodig om door een proxy op het internet te komen, leeg indien geen wachtwoord (PHP cURL extentie nodig).';
$string['configquarantinedir'] = 'Als je wil dat clam AV besmette bestanden naar een quarantainemap verplaatst, zet het pad dan hier. Het moet beschrijfbaar zijn voor de webserver. Als je dit leeg laat of als je een map opgeeft die niet bestaat of niet beschrijfbaar is, dan zullen besmette bestanden verwijderd worden. Gebruik geen schuine streep achteraan het pad.';
$string['configrecaptchaprivatekey'] = 'Variable, nodig om je Moodle server te laten communiceren met de recaptcha.net server. Je kunt deze voor jouw site bekomen via http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Variable, gebruikt om het reCAPTCHA-element te tonen in het inschrijvingsformulier voor e-mail zelfregistratie. Gegenereerd door http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'De selectie van een categorie toestaan bij het aanvragen van een cursus.';
$string['configrequestedstudentname'] = 'Woord voor leerling, gebruikt in aangevraagde cursussen';
$string['configrequestedstudentsname'] = 'Woord voor leerlingen, gebruikt in aangevraagde cursussen';
$string['configrequestedteachername'] = 'Woord voor leraar, gebruikt in aangevraagde cursussen';
$string['configrequestedteachersname'] = 'Woord voor leraren, gebruikt in aangevraagde cursussen';
$string['configrequiremodintro'] = 'Schakel deze optie uit als je gebruikers niet wil dwingen een beschrijving in te geven bij elke activiteit';
$string['configrunclamavonupload'] = 'Als je dit inschakeld zal Clam AV alle geüploade bestanden scannen op virussen.';
$string['configrunclamonupload'] = 'Clam AV laten lopen bij het uploaden van een bestand? Je hebt dan een juist pad nodig in pathtoclam om dit te laten werken. (Clam AV is een gratis virusscanner die je kunt downloaden van http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'E-mail';
$string['configsectionmaintenance'] = 'Onderhoud';
$string['configsectionmisc'] = 'Varia';
$string['configsectionoperatingsystem'] = 'Besturingssysteem';
$string['configsectionpermissions'] = 'Rechten';
$string['configsectionrequestedcourse'] = 'Cursusaanvragen';
$string['configsectionsecurity'] = 'Beveiliging';
$string['configsectionstats'] = 'Statistieken';
$string['configsectionuser'] = 'Gebruiker';
$string['configsecureforms'] = 'Moodle kan een extra beveiliging toepassen wanneer het gegevens aanneemt van webformulieren. Als je dit inschakelt, dan wordt de variable HTTP_REFERER vergeleken met het huidige formulieradres. In zeldzame gevallen kan dit problemen veroorzaken als de gebruiker een firewall gebruikt (zoals Zonealarm) die geconfigureerd is om HTTP_REFERER uit het webverkeer te filteren. Het symptoom is: vastgeraken op een formulier. Als je gebruikers problemen hebben met de inlogpagina (bijvoorbeeld) dan zou je kunnen overwegen om deze instelling uit te zetten, hoewel dit je site meer blootstelt aan brute kracht-aanvallen op je wachtwoord. Bij twijfel laat je deze instelling op \'ja\' staan.';
$string['configsessioncookie'] = 'Met deze instelling kun je de naam van de cookie die gebruikt wordt voor Moodlesessies, aanpassen. Deze instelling is optioneel en enkel nuttig om te verhinderen dat cookies in conflict komen wanneer meer dan één exemplaar van Moodle binnen dezelfde website draait.';
$string['configsessioncookiedomain'] = 'Hiermee kun je het domein wijzigen waarvan de Moodle-cookies afkomstig zijn. Dit is nuttig voor aanpassingen van Moodle die sessie-informatie van Moodle moeten delen met een webapplicatie op een ander subdomein (v.b. authenticatie of aanmeldingsplugins). <strong> WAARSCHUWING: laat deze instelling leeg (= standaardinstelling) - een verkeerde waarde zal aanmelding op de site onmogelijk maken.</strong>';
$string['configsessioncookiepath'] = 'Als het nodig is dat je de standaardlocatie naar waar browsers de Moodle cookies sturen wijzigt, dan kun je hier een subdirectory van je website instellen. Normaal gezien is de standaard \'/\' goed.';
$string['configsessiontimeout'] = 'Als mensen die ingelogd zijn op deze site voor een lange tijd niets doen (ze laden geen nieuwe pagina\'s) worden ze automatisch uitgelogd (hun sessie is beëindigd). Deze variabele geeft aan hoe lang deze tijd moet zijn.';
$string['configshowcommentscount'] = 'Toon aantal commentaren. Het zal één extra query kosten om commentaarlinks te tonen';
$string['configshowicalsource'] = 'Toon broninformatie voor iCal-gebeurtenissen.';
$string['configshowsiteparticipantslist'] = 'Al deze site leerlingen en site leraren zullen op de site deelnemerslijst getoond worden. Wie heeft het recht om deze lijs te zien?';
$string['configsitedefaultlicense'] = 'Standaard site licentie';
$string['configsitedefaultlicensehelp'] = 'Standaarlicentie die gebruikt zal worden voor het tonen van inhoud op deze site.';
$string['configsitemaxcategorydepth'] = 'Maximale categoriediepte';
$string['configsitemaxcategorydepthhelp'] = 'Dit specificeert de maximale diepte van getoonde onderliggende categorieën of combolijsten. Diepere categorieën zullen verschijnen als links en gebruikers kunnen ze uitvergroten via AJAX.';
$string['configslasharguments'] = 'Bestanden (afbeeldingen, uploads en dergelijke) worden via een script aangeleverd dat gebruik maakt van \'slash arguments\'. Deze methode zorgt ervoor dat bestanden makkelijker in webbrowsers, proxyservers en dergelijke kunnen worden gecachet. Helaas staan sommige PHP-servers deze methode niet toe. Zet deze optie uit als je problemen hebt met het bekijken van geüploade bestanden.';
$string['configsmartpix'] = 'Met deze optie ingeschakeld worden icoontjes opgehaald door een PHP-script dat eerst het huidige thema doorzoekt, dan alle bovenliggende thema\'s en dan de Moodle/pix map. Hierdoor is het niet nodig de afbeeldingsbestanden te dupliceren over de verschillende thema\'s. Het heeft wel een kleine performantiekost.';
$string['configstartwday'] = 'Begin van de week';
$string['configstatsfirstrun'] = 'Hiermee stel je in hoever terug in de tijd dat de logs moeten herwerkt worden tijdens de <b>eerste keer</b> dat de crontaak de statistieken probeert te verwerken. Als je wel wat verkeer hebt en je server is een shared host, dan is het waarschijnlijk geen goed idee om te ver terug te gaan. Het erg zware proces zou wel eens lang kunnen lopen. (merk op voor deze instelling: 1 maand is 28 dagen. Op de grafieken en in de rapporten is een maand een kalendermaand.)';
$string['configstatsmaxruntime'] = 'Het verwerken van statistieken is een erg belastende taak. Gebruik dus de combinatie van dit veld en het volgende om aan te geven wanneer en hoe lang het proces zal lopen.';
$string['configstatsmaxruntime2'] = 'Het berekenen van statistieken kan voor je server een zeer belastende taak zijn. Specificeer een maximale tijd dat de server mag werken aan de statistieken van één dag. Het maximale aantal verwerkte dagen per cron cyclus is 31.';
$string['configstatsmaxruntime3'] = 'Specificeer de maximale toegelaten tijd om de statistieken voor één dag te berekenen. Hou er rekening mee dat het verwerken van de statistieken een grote belasting voor je server kan betekenen. Het maximale aantal dagen, berekend in één cron, kun je met de volgende instelling kiezen.';
$string['configstatsruntimedays'] = 'Specificeer het maximale aantal dagen die verwerkt mogen worden in één statistiek-berekeningscyclus. Wanneer de statistieken up-to-date zijn, zal er slechts één dag verwerkt worden. Pas deze waarde aan, rekening houdend met de belasting van je server. Maak ze kleiner als de cron-taak korter moet.';
$string['configstatsruntimestart'] = 'Op welk tijdstip moet de crontaak die de statistieken verwerk starten? Geef verschillende tijden op als er meerdere Moodles op één fysieke machine staan.';
$string['configstatsuserthreshold'] = 'Deze instelling geeft het minimaal aantal aangemelde gebruikers die een cursus moet hebben om in de statistiekenberekeningen opgenomen te worden.';
$string['configstrictformsrequired'] = 'Indien ingeschakeld moeten gebruikers meer invullen in een formulier dan alleen een spatie of nieuwe regel.';
$string['configstripalltitletags'] = 'Schakel deze optie uit om HTML-tags to te laten in activiteits- en bronnamen.';
$string['configsupportemail'] = 'Dit e-mailadres zal gepubliceerd worden aan sitegebruikers als het e-mailadres dat ze kunnen contacteren om algemene hulp te krijgen (zoals bij het creëren van een nieuwe account). Als dit veld leeg gelaten wordt, dan wordt er zo geen e-mailadres aangeboden.';
$string['configsupportname'] = 'Dit is de naam van een persoon of dienst die de algemene hulp aanbiedt.';
$string['configsupportpage'] = 'Deze URL zal gepubliceerd worden aan sitegebruikers als de plaats waar naartoe  te gaan als ze algemene hulp nodig hebben (bijvoorbeeld wanneer nieuwe gebruikers hun eigen accounts aanmaken). Als dit veld leeggelaten wordt, dan wordt er geen link aangeboden.';
$string['configthemedesignermode'] = 'Normaal gezien worden alle thema-afbeeldingen en stijlbestanden lange tijd gecached in browsers en op de server voor de performantie. Als je een thema aan het ontwerpen bent of je ontwikkeld code, dan wil je deze instelling waarschijnlijk inschakelen, zodat je geen gecachede versie te zien krijgt. Let op: dit zal je site trager maken voor alle gebruikers! Het alternatief is dat je de thema cache manueel leegmaakt vanop de thema selectie pagina.';
$string['configthemelist'] = 'Laat dit leeg om gelijk welk geldig thema te gebruiken. Geef hier een door komma\'s gescheiden lijst met thema-namen als je het thema-menu wil inkorten. Bijvoorbeeld: standard,orangewhite. Let op: geen spaties!';
$string['configtimezone'] = 'Hier kun je de standaardtijdzone instellen - elke gebruiker kan deze instelling voor zichzelf wijzigen in zijn profiel. Op deze plaats zal de optie "Servertijd" de standaardtijd in Moodle gelijkzetten met de tijd van PHP van de server, maar in het profiel van de gebruikers zal de instelling "Servertijd" de hier ingestelde tijdzone zijn.
Aanbevolen wordt om de tijdzone juist te zetten en dan een benoemde tijdzone kiest, specifiek voor jouw regio.';
$string['configuseblogassociations'] = 'Moeten gebruikers hun blogs kunnen organiseren door blogitems te associëren met cursussen en cursusmodules?';
$string['configuseexternalyui'] = 'In de plaats van gebruik te maken va lokale bestanden, gebruik de bestanden van  de Yahoo servers. WAARSCHUWING: hiervoor moet je server een verbinding met het internet hebben of AJAX zal niet werken. Deze instelling is niet compatibel met sites die https gebruiken.';
$string['configuserquota'] = 'Het maximale aantal bytes dat een gebruiker kan bewaren in zijn eigen bestandenzone. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Indien ingeschakeld zal de korte naam voor de site gebruikt worden in de navigatie in plaats van \'Site pagina\'s\'';
$string['configusetags'] = 'Tags functionaliteit over de hele site inschakelen?';
$string['configvariables'] = 'Configureer variabelen';
$string['configverifychangedemail'] = 'Schakelt verificatie in van gewijzigde e-mail-adressen wanneer je toegelaten en verboden domeinen gebruikt. Als deze instelling is uitgeschakeld, dan worden de domeinen enkel opgelegd voor het aanmaken van nieuwe gebruikers.';
$string['configvisiblecourses'] = 'Toon cursussen in verborgen categorieën';
$string['configwarning'] = 'Wees voorzichtig met het veranderen van deze instellingen. Vreemde waarden kunnen problemen opleveren.';
$string['configyuicomboloading'] = 'Deze opties schakelen gecombineerde bestands laadoptimalisaties in voor YUI bibliotheken. Deze instelling zou ingeschakeld moeten zijn op productieservers voor performantie.';
$string['confirmation'] = 'Bevestiging';
$string['confirmdeletecomments'] = 'Je gaat notities verwijderen. Ben je zeker?';
$string['confirmed'] = 'Bevestigd';
$string['convertformat'] = '<i>convert</i> output formaat';
$string['cookiehttponly'] = 'Enkel http cookies';
$string['cookiesecure'] = 'Enkel secure cookies';
$string['country'] = 'Standaard landinstelling';
$string['coursecontact'] = 'Cursus beheerders';
$string['coursecontact_desc'] = 'Deze instelling maakt het mogelijk te controleren wie je toont in de cursusbeschrijving. Gebruikers moeten minstens één van deze rollen in een cursus hebben om getoond te worden in de cursusbeschrijving van een bepaalde cursus.';
$string['courselistshortnames'] = 'Toon uitgebreide cursusnamen';
$string['courselistshortnames_desc'] = 'Toon zowel korte als volledige namen tijdens het tonen van lijsten van cursussen of tijdens het verwijzen naar cursussen op beheerschermen. Wanneer je deze instelling inschakeld, wordt  de taalstring \'courseextendednamedisplay\' gebruikt en kun je door die aan te passen via \'Taalpakket aanpassen\', kiezen wat getoond wordt.';
$string['coursemgmt'] = 'Beheer cursussen en categorieën';
$string['courseoverview'] = 'Cursusoverzicht';
$string['courserequestnotify'] = 'Melding cursusaanvragen';
$string['courserequestnotifyemail'] = 'Gebruiker {$a->user} vroeg een nieuwe cursus aan op {$a->link}';
$string['courserequests'] = 'Cursusaanvragen';
$string['courserequestspending'] = 'Cursusaanvragen';
$string['courses'] = 'Cursussen';
$string['coursesperpage'] = 'Cursussen per pagina';
$string['courseswithsummarieslimit'] = 'Limiet van cursussen met samenvatting';
$string['creatornewroleid'] = 'De rol van de cursusaanmaker in nieuwe cursussen';
$string['creatornewroleid_help'] = 'Als de gebruiker het recht nog niet heeft om de nieuwe cursus te beheren, dan zal de gebruiker automatisch aangemeld worden met deze rol.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Cron enkel via command prompt';
$string['cronerrorclionly'] = 'Sorry, internettoegang tot deze pagina is door de beheerder uitgeschakeld.';
$string['cronerrorpassword'] = 'Sorry, maar je kon geen geldig wachtwoord ingeven om deze pagina te bezoeken.';
$string['cron_help'] = 'Het cron.php onderhoudsscript helpt sommige Moodle modules om taken te doen volgens een planning, zoals het versturen van forumberichten. Er is een mechanisme vereist om er voor te zorgen dat het script regelmatig, bijvoorbeeld om de 5 minuten, loopt.';
$string['cronremotepassword'] = 'Cron wachtwoord voor toegang op afstand';
$string['cronwarning'] = 'Het onderhoudsscript <a href="cron.php">cron.php</a> heeft de laatste 24 uur niet gelopen.';
$string['ctyperecommended'] = 'Het installeren van de optionele ctype PHP extentie is aanbevolen om de performantie van de site te verhogen, vooral als op je site niet-latijnse talen gebruikt worden.';
$string['ctyperequired'] = 'De ctype PHP-extentie is nu vereist in Moodle om de performantie te verhogen en om multi-talencompatibiliteit mogelijk te maken.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'Het installeren van de optionele Curl bibliotheek wordt ten zeerste aangeraden om de netwerkmogelijkheden van Moodle in te schakelen';
$string['curlrequired'] = 'De cURL PHP-extentie is nu vereist in Moodle om te kunnen communiceren met Moodle bewaarplaats';
$string['curltimeoutkbitrate'] = 'Te gebruiken bitrate bij het berekenen van cURL timeouts (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Deze instelling wordt gebruikt om een juiste timeout te berekenen bij het uitvoeren van lange cURL requests. Als deel van de berekening wordt een HTTP HEAD request gemaakt om de grootte van de inhoud te bepalen. Als je dit op 0 zet, wordt de request niet gedaan.';
$string['currenttheme'] = 'Dit thema';
$string['customcheck'] = 'Andere controles';
$string['custommenu'] = 'Aangepast menu';
$string['custommenuitems'] = 'Aangepast menu items';
$string['datarootsecurityerror'] = '<p><strong>BEVEILIGINGSWAARSCHUWING!</strong></p><p>Je dataroot map staat op de verkeerde plaats en is bereikbaar vanop het internet. Dit betekent dat al je bestanden voor iedereen beschikbaar zijn en dat sommige bestanden kunnen gebruikt worden door een cracker om toegang tot je site te krijgen als beheerder!</p>
<p>Je <em>moet</em> de dataroot map ({$a}) verplaatsen naar een andere plaats die buiten je publieke webmap is en de <code>$CFG->dataroot</code>-instelling in je config.php aanpassen.</p>';
$string['datarootsecuritywarning'] = 'De configuratie van je site zou onveilig kunnen zijn. Zorg er voor dat je dataroot map ({$a}) niet toegankelijk is vanaf het internet.';
$string['dbmigrate'] = 'Migratie van de Moodle databank';
$string['dbmigrateconnecerror'] = 'Kon niet met de opgegeven databank verbinden';
$string['dbmigrateencodingerror'] = 'De opgegeven databank heeft {$a} als encodering en dat zou moeten UNICODE/UTF8 zijn.<br />Kies een andere.';
$string['dbmigratepostgres'] = 'Je gebruikt blijkbaar PostgreSQL als databank server. Om verder te gaan met het migratieproces, moet je manueel een nieuwe databank aanmaken met de encoding "UNICODE" (PostgreSQL 7 of "UTF8" (PostgreSQL 8) om de gemigreerde data in te bewaren. Geef hieronder de connectie-instellingen van je nieuwe databank in om verder te kunnen gaan.';
$string['dbmigratewarning'] = 'Zorg voor een back-up van je databank voor je aan deze procedure begint. Als je niet goed weet hoe dat te doen, neem dan contact op met je systeembeheerder. Zodra je de migratie begint, wordt je Moodle-site in onderhoudsmodus gezet.';
$string['dbmigratewarning2'] = '<b>Waarschuwing: zodadelijk ga je het databank migratieproces starten. Zorg er voor dat je een goede back-up hebt van je Moodle databank.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Deze databank is gemigreerd naar een nieuwe UTF8 databank en is buiten werking gesteld. Bewerk je config.php om de nieuwe databank te gebruiken voor deze Moodle-installatie.</font>';
$string['dbmigrationdupfailed'] = 'Databankduplicatie mislukt met als mogelijke fout: <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Gebruik databank voor sessie-informatie';
$string['debug'] = 'Foutopsporingsmeldingen';
$string['debugall'] = 'E_ALL: toon alle zinnige feedback';
$string['debugdeveloper'] = 'ONTWIKKELAAR: extra Moodle debugberichten voor ontwikkelaars';
$string['debugdisplay'] = 'Toon meldingen voor foutopsporing';
$string['debugging'] = 'Fouten opsporen';
$string['debugminimal'] = 'MINIMAL: toon enkel fatale fouten';
$string['debugnone'] = 'GEEN: toon geen foutopsporingsmeldingen';
$string['debugnormal'] = 'NORMAAL: toon fouten, waarschuwingen en opmerkingen';
$string['debugpageinfo'] = 'Toon paginainformatie';
$string['debugsmtp'] = 'Foutopsporing voor versturen van e-mail';
$string['debugstringids'] = 'Toon oorsprong van taalstrings';
$string['debugstringids_desc'] = 'Deze optie is ontworpen om vertalers te helpen. Wanneer deze optie is ingeschakeld, dan zal het taalbestand en de string id naast elke string getoond worden wanneer je de parameter ?strings=1 toevoegd aan de URL.';
$string['debugvalidators'] = 'Toon validatorlinks';
$string['defaultcity'] = 'Standaard stad';
$string['defaultcity_help'] = 'Wanneer je nieuwe gebruikersaccounts aanmaakt, dan zal de stad die je hier opgeeft als standaardinstelling gebruikt worden';
$string['defaultformatnotset'] = 'Fout bij het bepalen van de standaard cursusopmaak. Controleer je instellingen.';
$string['defaulthomepage'] = 'Standaard startpagina voor gebruikers';
$string['defaultrequestcategory'] = 'Standaardcategorie voor cursusaanvragen';
$string['defaultsettinginfo'] = 'Standaard: {$a}';
$string['defaultuserroleid'] = 'Standaardrol voor alle gebruikers';
$string['deleteincompleteusers'] = 'Verwijder onvolledig ingestelde accounts na';
$string['deleteunconfirmed'] = 'Verwijder niet-bevestigde gebruikers na';
$string['deleteuser'] = 'Verwijder gebruiker';
$string['density'] = 'Dichtheid';
$string['denyemailaddresses'] = 'Verboden e-maildomeinen';
$string['development'] = 'Ontwikkeling';
$string['devicedetectregex'] = 'Regular expressions voor de bepaling van het aparaat';
$string['devicedetectregex_desc'] = '<p>Moodle kan toestellen detecteren van het type standaard (desktops, laptops, enz.), mobiel (smart phones en kleine palmtop toestellen), tablet (iPad, Android tablets) en verouderd (Internet Explorer 6 gebruikers). De thema-kiezer kan gebruikt worden om een apart thema te kiezen voor elk type toestel. Deze instelling maakt regular expressions mogelijk om die toestellen te detecteren (deze gaan voor op de standaard types).</p><p>Je zou bijvoorbeeld de expressie \'/(MIDP-1.0|Maemo|Windows CE)/\' kunnen gebruiken om een veelgebruikt smart phone type te detecteren en de waarde \'smart phone\' teruggeven. Dit voegt \'Smart phone\' toe aan de thema-kiezer dat je dan de mogelijkheid geeft een thema toe te wijzen om te gebruiken op die toestellen. Andere telefoons gebruiken dan nog steeds het thema geselecteerd voor het mobiel toestel.</p>';
$string['devicedetectregexexpression'] = 'Regular expressions';
$string['devicedetectregexvalue'] = 'Teruggegeven waarde';
$string['devicetype'] = 'Toesteltype';
$string['disableuserimages'] = 'Schakel profielprentjes uit.';
$string['displayerrorswarning'] = 'Het inschakelen van de PHP-instelling <em>display_errors</em> is niet aangewezen op productie-sites omdat sommige foutmeldingen gevoelige informatie over de server kunnen vrijgeven.';
$string['displayloginfailures'] = 'Toon loginfouten aan';
$string['dndallowtextandlinks'] = 'Slepen en neerzetten';
$string['docroot'] = 'Startpagina Moodle Docs';
$string['doctonewwindow'] = 'Open in nieuw venster';
$string['download'] = 'Download';
$string['edithelpdocs'] = 'Bewerk helpbestanden';
$string['editingnoncorelangfile'] = 'Je probeert een vertaling van een niet-standaard module te wijzigen. Je kunt de vertaling alleen bewaren in je _local map. Misschien wil je daarna de vertaling verplaatsen naar de lang-map van de module en/of de vertaling naar de maker van de module sturen.';
$string['editlang'] = '<b>Bewerk</b>';
$string['editorbackgroundcolor'] = 'Achtergrondkleur';
$string['editordictionary'] = 'Editor woordenboek';
$string['editorfontfamily'] = 'Lettertypefamilie';
$string['editorfontlist'] = 'Lettertypelijst';
$string['editorfontsize'] = 'Lettertypegrootte';
$string['editorhidebuttons'] = 'Verborgen knoppen';
$string['editorkillword'] = 'Word-document opschonen';
$string['editorspelling'] = 'Editor spelling';
$string['editorspellinghelp'] = 'Inschakelen of uitschakelen van spellingscontrole. Wanneer je dit inschakeld, moet <strong>aspell</strong> op de server geïnstalleerd zijn.';
$string['editstrings'] = 'Bewerk woorden en zinnen';
$string['emailchangeconfirmation'] = 'Bevestiging van wijziging e-mailadres';
$string['emoticonalt'] = 'Alternatieve tekst';
$string['emoticoncomponent'] = 'Afbeeldingscomponent';
$string['emoticonimagename'] = 'Afbeeldingsnaam';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Dit formulier bepaalt de emoticons (of smileys) die op jouw site gebruikt worden. Om een rij van de tabel te verwijderen kun je het formulier bewaren met een lege waarde in elk vereist veld. Om een nieuw emoticon te registreren kun je de lege velden invullen op de laatste rij. Om alle velden terug op standaardinstellingen te zetten volg je bovenstaande link.

* Tekst (vereist) - Deze tekst zal vervangen worden door de afbeelding van het emoticon. Deze tekst moet minstens twee tekens lang zijn.
* Afbeeldingsnaam (vereist) - De bestandsnaam van het emoticon zonder de extentie, relatief ten opzichte van de component pix map.
* Afbeeldingscomponent (vereist) - De component die het icoon levert.
* Alternatieve tekst (optionneel) - Identificatiestring en component van de alternatieve tekst voor het emoticon;';
$string['emoticonsreset'] = 'Zet de instellingen voor emoticons terug op standaardinstellingen';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Leeg';
$string['enableajax'] = 'AJAX inschakelen';
$string['enableblogs'] = 'Blogs inschakelen';
$string['enablecalendarexport'] = 'Kalenderexport inschakelen';
$string['enablecomments'] = 'Commentaren inschakelen';
$string['enablecourserequests'] = 'Cursusaanvragen inschakelen';
$string['enablecssoptimiser'] = 'CSS optimiser inschakelen';
$string['enablecssoptimiser_desc'] = 'Wanneer ingeschakeld zal CSS door een optimalisatieproces gestuurd worden voor het gecached wordt. Het optimalisatieproces verwijderd dubbele regels en stijlen evenals herformateren van witruimte. Als je dit inschakeld, samen met de thema ontwerper modus, dan is de performantie verschrikkelijk slecht, maar het helpt thema-ontwerpers om geoptimaliseerde CSS te maken.';
$string['enabled'] = 'Ingeschakeld';
$string['enabledevicedetection'] = 'Toesteldetectie inschakelen';
$string['enablegravatar'] = 'Gravatar inschakelen';
$string['enablegravatar_help'] = 'Als je dit inschakeld zal Moodle proberen een gebruikersprofielfoto van Gravataar te halen als de gebruiker nog geen afbeelding geüpload heeft.';
$string['enablegroupmembersonly'] = 'Enkel groepsleden inschakelen';
$string['enablemobilewebservice'] = 'Webservices voor mobiele toestellen inschakelen';
$string['enablerecordcache'] = 'Record cache inschakelen';
$string['enablerssfeeds'] = 'RSS-feeds inschakelen';
$string['enablesafebrowserintegration'] = 'Schakel Safe Exam Browser integratie in';
$string['enablestats'] = 'Statistieken inschakelen';
$string['enabletgzbackups'] = 'Schakel nieuw backupformaat in';
$string['enabletgzbackups_desc'] = 'Indien ingeschakeld zullen nieuwe backups gemaakt worden met een nieuwe compressiestandaard voor de .mbz-bestanden (intern worden dat tar.gz-bestanden). Hierdoor verdwijnt de 4GB limiet voor backupbestanden en verbetert de performantie. Het terugzetten ondersteunt beide formaten en gebruikers zullen geen verschil opmerken.';
$string['enabletgzbackups_nozlib'] = 'De PHP-extentie  &lsquo;zlib&rsquo; is niet beschikbaar. Het nieuwe backupformaat heeft dit nodig en zal uitgeschakeld worden tot zlib geïnstalleerd en ingeschakeld is.';
$string['enabletrusttext'] = 'Vertrouwde Inhoud inschakelen';
$string['enablewebservices'] = 'Webservices inschakelen';
$string['enablewsdocumentation'] = 'Documentatie Webservices';
$string['enrolinstancedefaults'] = 'Aanmeldingsstandaarden';
$string['enrolinstancedefaults_desc'] = 'Standaard aanmeldingsinstellingen in nieuwe cursussen.';
$string['enrolmultipleusers'] = 'Gebruikers aanmelden';
$string['environment'] = 'Omgeving';
$string['environmenterrortodo'] = 'Je moet all de problemen over de installatie-omgeving die hierboven gevonden zijn, oplossen. Ga pas dan verder met het installeren van deze Moodleversie.';
$string['environmenterrorupgrade'] = 'Waarschuwing: je moet eerst alle hierboven gemelde omgevingsproblemen oplossen voor je verder gaat met de upgrade van Moodle! Upgraden zonder deze vereiste omgeving kan problemen zoals gegevensverlies veroorzaken. Ben je er zeker van dat je verder wil doen met deze upgrade?';
$string['environmentmustfixsetting'] = 'PHP-instelling moet gewijzigd worden';
$string['environmentok'] = 'Je server voldoet aan alle minimumeisen';
$string['environmentrecommendcustomcheck'] = 'Als deze test faalt, dan wijst dat op een mogelijk probleem';
$string['environmentrecommendinstall'] = 'wordt aangeraden om te installeren of in te schakelen';
$string['environmentrecommendversion'] = 'je kunt betere versie {$a->needed} gebruiken en je gebruikt nu versie {$a->current}';
$string['environmentrequirecustomcheck'] = 'Deze test moet OK zijn';
$string['environmentrequireinstall'] = 'moet geïnstalleerd/ingeschakeld zijn';
$string['environmentrequireversion'] = 'versie {$a->needed} is vereist en je gebruikt nu versie {$a->current}';
$string['environmentsettingok'] = 'aanbevolen instelling gedetecteerd';
$string['environmentshouldfixsetting'] = 'PHP-instelling zou gewijzigd moeten worden.';
$string['environmentxmlerror'] = 'Fout bij het lezen van de omgevingsdata ({$a->error_code})';
$string['errordeletingconfig'] = 'Er is een fout opgetreden bij het verwijderen van de configuratierecords voor plugin \'{$a}\'';
$string['errorsetting'] = 'Kon instelling niet bewaren';
$string['errorwithsettings'] = 'Sommige instellingen zijn door een fout niet gewijzigd.';
$string['everyonewhocan'] = 'Iedereen die kan \'{$a}\'';
$string['exceptions'] = 'uitzonderingen';
$string['execpathnotallowed'] = 'Uitvoerbare paden uitschakelen in config.php';
$string['experimental'] = 'Experimenteel';
$string['experimentalsettings'] = 'Experimentele instellingen';
$string['extendedusernamechars'] = 'Uitgebreide tekenset in gebruikersnamen toestaan';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalmagicquotesruntime'] = '<p>Ernstige configuratiefout gevonden. Verwittig je serverbeheerder.</p><p>Om goed te functioneren moet de beheerder de PHP-instellingen aanpassen.</p><p><code>magic_quotes_runtime</code> moet op<code>off</code> gezet worden.</p><p>Deze instelling kan gewijzigd worden door het bestand <code>php.ini</code>, Apache/IIS <br />-configuratie of het bestand <code>.htaccess</code> op de server aan te passen.</p>';
$string['fatalsessionautostart'] = '<p>Ernstige configuratiefout gevonden. Waarschuw je serverbeheerder.</p><p>Om goed te functioneren moet de beheerder de PHP-instellingen aanpassen.</p><p><code>session.auto_start</code> moet op<code>off</code> gezet worden.</p><p>Deze instelling kan gewijzigd worden door het bestand <code>php.ini</code>, Apache/IIS <br />-configuratie of het bestand <code>.htaccess</code> op de server aan te passen.</p>';
$string['filecreated'] = 'Nieuw bestand aangemaakt';
$string['filestoredin'] = 'Bewaar bestand in map';
$string['filestoredinhelp'] = 'Bestandslocatie';
$string['filterall'] = 'Filter alle strings';
$string['filtermatchoneperpage'] = 'Filter maakt één koppeling per pagina';
$string['filtermatchonepertext'] = 'Filter maakt één koppeling per tekst';
$string['filters'] = 'Filters';
$string['filtersettings'] = 'Beheer filters';
$string['filtersettingsgeneral'] = 'Algemene filterinstellingen';
$string['filteruploadedfiles'] = 'Gebruik de filters in geüploade bestanden';
$string['forcelogin'] = 'Verplicht aanmelden';
$string['forceloginforprofileimage'] = 'Verplicht gebruikers aan te melden om gebruikersfoto\'s te zien';
$string['forceloginforprofileimage_help'] = 'Indien ingeschakeld moeten gebruikers aangemeld zijn om foto\'s van gebruikers te zien. De standaard gebruikersfoto zal gebruikt worden in alle e-mailmeldingen.';
$string['forceloginforprofiles'] = 'Verplicht aanmelden voor profielen';
$string['forcetimezone'] = 'Verplicht standaard tijdzone';
$string['formatuninstallwithcourses'] = 'Er zijn {$a->count} cursussen die {$a->format} gebruiken. De opmaak ervan zal gewijzigd worden naar {$a->defaultformat} (standaard cursusopmaak voor deze site). Sommige opmaakspecifieke data kunnen verloren gaan. Weet je zeker dat je verder wil gaan?';
$string['frontpage'] = 'Startpagina';
$string['frontpagebackup'] = 'Back-up startpagina';
$string['frontpagedefaultrole'] = 'Standaardrol voor startpagina';
$string['frontpagefilters'] = 'Startpagina filters';
$string['frontpageloggedin'] = 'Startpagina-items als aangemeld';
$string['frontpageoverrides'] = 'Startpagina rechten overschrijven';
$string['frontpagequestions'] = 'Vragen startpagina';
$string['frontpagerestore'] = 'Restore startpagina';
$string['frontpageroles'] = 'Rollen startpagina';
$string['frontpagesettings'] = 'Instellingen startpagina';
$string['fullnamedisplay'] = 'Volledige naam opmaak';
$string['fullnamedisplayprivate'] = 'Volledige naam - privé';
$string['gdrecommended'] = 'De GD-extentie wordt gebruikt voor de conversie van afbeeldingen. Sommige mogelijkeden, zoals afbeeldingen in gebruikersprofielen zullen zonder GD niet werken.';
$string['gdrequired'] = 'De GD-extentie is vereist door Moodle voor conversie van afbeeldingen';
$string['generalsettings'] = 'Algemene instellingen';
$string['geoipfile'] = 'GeoIP City databestand';
$string['getremoteaddrconf'] = 'IP-adres in de logs';
$string['globalswarning'] = '<p><strong>Veiligheidswaarschuwing</strong>:om Moodle goed te laten werken, is het nodig <br />dat je enkele wijzigingen maakt in je huidige PHP-instellingen.</p><p>Je <em>moet</em> <code>register_globals=off</code> instellen.</p><p>Deze instelling kan aangepast worden door je <code>php.ini</code>, Apache/IIS <br /> configuratie aan te passen of door een <code>.htaccess</code>-bestand te gebruiken.';
$string['googlemapkey3'] = 'Google Maps API V3 sleutel';
$string['googlemapkey3_help'] = 'Je moet een speciale sleutel ingeven om Google Maps voor IP-adreslocalisatie te kunnen gebruiken. Die kun je gratis bekomen op <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Ga naar de eerste ontbrekende string';
$string['gradebook'] = 'Cijferlijst';
$string['gradebookroles'] = 'Rollen in cijferlijst';
$string['gradeexport'] = 'Primaire cijferexportmethode';
$string['gravatardefaulturl'] = 'Gravatar standaard afbeeldings URL';
$string['gravatardefaulturl_help'] = 'Gravatar heeft een standaard afbeelding nodig om te tonen als het geen afbeelding voor een bepaalde gebruiker kan vinden. Geef een volledige URL voor een afbeelding. Als je deze instelling leeg laat, dan zal Moodle proberen de meest geschikte afbeelding voor de pagina die je aan het bekijken bent te kiezen. Merk ook op dat Gravatar een aantal codes heeft waarmee <a href="https://en.gravatar.com/site/implement/images/#default-image">standaardafbeeldingen gegenereerd kunnen worden</a> .';
$string['groupenrolmentkeypolicy'] = 'Beleid voor aanmeldingssleutel groepen';
$string['groupenrolmentkeypolicy_desc'] = 'Dit inschakelen laat Moodle de aanmeldingssleutels voor groepen controleren voor geldigheid tegen het wachtwoordbeleid.';
$string['guestroleid'] = 'Rol voor gasten';
$string['guestroleid_help'] = 'Deze rol wordt automatisch toegewezen aan de gastgebruiker. Deze rol wordt ook tijdelijk toegewezen aan niet aangemelde gebruikers als ze een cursus openen via de gastaanmeldingsplugin.';
$string['helpadminseesall'] = 'Zien beheerders alle gebeurtenissen in de kalender of alleen diegene die ze zelf nodig hebben?';
$string['helpcalendarcustomexport'] = 'Aangepast datumbereikoptie inschakelen in kalenderexport. Kalenderexport moet ingeschakeld zijn voor dit kan werken.';
$string['helpexportlookahead'] = 'Hoeveel dagen moet de kalender in de toekomst kijken naar gebeurtenissen voor de aangepaste exportfunctie?';
$string['helpexportlookback'] = 'Hoeveel dagen in het verleden moet de calender kijken voor de aangepaste exportfunctie?';
$string['helpforcetimezone'] = 'Je kunt je gebruikers elk hun eigen tijdzone laten kiezen of een tijdzone opleggen voor iedereen.';
$string['helpshowicalsource'] = 'Schakel deze instelling in als de iCal inschrijvingsnaam en link wil tonen voor geïmporteerde gebeurtenissen.';
$string['helpsitemaintenance'] = 'Voor upgrades en ander onderhoud';
$string['helpstartofweek'] = 'Welke dag start de week in de kalender?';
$string['helpupcominglookahead'] = 'Hoeveel dagen is de standaardinstelling om kalender vooruit te laten kijken naar aankomende activiteiten?';
$string['helpupcomingmaxevents'] = 'Hoeveel aankomende activiteiten worden er maximaal getoond aan de gebruikers?';
$string['helpweekenddays'] = 'Welke dagen van de week worden als "weekend" beschouwd en dus in een andere kleur getoond?';
$string['hiddenuserfields'] = 'Verberg gebruikersvelden';
$string['hidefromall'] = 'Verberg voor alle gebruikers';
$string['hidefromnone'] = 'Verberg voor niemand';
$string['hidefromstudents'] = 'Verberg voor leerlingen';
$string['htmleditor'] = 'HTML-editor';
$string['htmleditorsettings'] = 'Instellingen HTML-editor';
$string['htmlsettings'] = 'HTML-instellingen';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP Security';
$string['hubs'] = 'Hubs';
$string['iconvrecommended'] = 'Als je site andere talen dan die uit de Latin1 tekenset gebruikt, dan is het installeren van de optionele ICONV library ten zeerste aangeraden om de performantie van de site te verhogen.';
$string['iconvrequired'] = 'Het installeren van de ICONV-extentie is vereist.';
$string['ignore'] = 'Negeer';
$string['includemoduleuserdata'] = 'Ook gebruikersdata van modules';
$string['incompatibleblocks'] = 'Niet-compatibele blokken';
$string['installhijacked'] = 'De installatie moet worden voltooid vanaf het oorspronkelijk IP-adres';
$string['installsessionerror'] = 'Kan geen PHP-sessie initialiseren. Controleer of je browser cookies accepteerd.';
$string['intlrecommended'] = 'Intl-extentie wordt gebruikt om de ondersteuning van internationalisering te verbeteren, zoals sorteren op basis van de ingestelde locale.';
$string['invalidsection'] = 'Ongeldige sectie';
$string['invaliduserchangeme'] = 'De gebruikersnaam "changeme" kan niet als gebruikersnaam gebruikt worden. Kies een andere.';
$string['ipblocked'] = 'Deze site is nu niet beschikbaar.';
$string['ipblocker'] = 'IP blokkeren';
$string['ipblockersyntax'] = 'Zet elk item op één lijn. Geldige itmes zijn volledige IP-adressen, zoals 192.168.0.1, die overeenkomen met één enkele machine; gedeeltelijke IP-adressen, zoals 192.168 die overeenkomen met alle IP-adressen die met die nummers beginnen: of CIDR notatie van IP-adressen, zoals 231.3.56.10-20 waar een bereik van toepasing is op het laatste deel van het adres. Domeinnamen, zoals voorbeeld.com worden niet ondersteund. Vrije regels worden genegeerd.';
$string['iplookup'] = 'IP-adres opzoeken';
$string['iplookupgeoplugin'] = 'De <a href="http://www.geoplugin.com">geoPlugin</a> service wordt gebruikt om geografische informatie op te zoeken. Voor meer accurate resultatien kun je beter een lokale kopie van de MaxMind GeoLite databank installeren.';
$string['iplookupinfo'] = 'Standaard gebruikt Moodle de gratis  NetGeo (The Internet Geographic Database) server om de plaats van IP-adressen op te zoeken. Jammer genoeg wordt deze databank niet meer onderhouden en kan  <em>foute</em> data weergeven.
Het is dan ook aangeraden om een lokale kopie van de gratis GeoLite City database van MaxMind te installeren.<br />
IP-adreslocatie wordt dan getoond op een eenvoudige kaart of op een kaart van Google Maps. Merk op dat je hiervoor een Google account nodig hebt en een gratis Google Maps API sleutel moet aanvragen om de interactieve kaarten in te schakelen.';
$string['iplookupmaxmindnote'] = 'Dit product bevat GeoLite data gemaakt door  <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Hoofdletters tag-namen behouden';
$string['lang'] = 'Standaardtaal';
$string['langcache'] = 'Cache taalmenu';
$string['langcache_desc'] = 'Cache het taalmenu. Indien ingeschakeld wordt de lijst met beschikbare talen gecached. De cache wordt automatisch ververst wanneer je een taalpakket installeert of verwijderd met de ingebouwde taalbeheerfuncties. Als je manueel een nieuw taalpakket installeert, dan moet je de functie cache leegmaken gebruiken om de cache lijst te verversen.';
$string['langlist'] = 'Talen in taalmenu';
$string['langmenu'] = 'Toon taalmenu';
$string['langpackwillbeupdated'] = 'Opmerking: tijdens de upgrade zal Moodle proberen updates te downloaden voor je geïnstalleerde taalpakketten.';
$string['langstringcache'] = 'Cache alle taalstrings';
$string['languagesettings'] = 'Instellingen';
$string['latexpreamble'] = 'LaTeX inleiding';
$string['latexsettings'] = 'LaTeX  renderer instellingen';
$string['latinexcelexport'] = 'Excel encoding';
$string['legacyfilesaddallowed'] = 'Cursusbestanden toevoegen volgens verouderd systeem toestaan';
$string['legacyfilesaddallowed_help'] = 'Toestaan om nog nieuwe cursusbestanden en mappen toe te voegen als een cursus nog bestanden gebruikt volgens het oude systeem.';
$string['legacyfilesinnewcourses'] = 'Standaard cursusbestanden in nieuwe cursussen';
$string['legacyfilesinnewcourses_help'] = 'Standaard zijn de verouderde cursusbestanden alleen beschikbaar in geüpgraded cursussen. Merk op dat sommige functies zoals back-up/terugzetten van afzonderlijke activiteiten niet compatibel zijn met deze instelling.';
$string['licensesettings'] = 'Licentieinstellingen';
$string['linkadmincategories'] = 'Link beheercategorieën';
$string['linkadmincategories_help'] = 'Indien ingeschakeld zullen beheerinstellingscategorieën als links getoond worden in de navigatie en zullen die je naar de beheercategorieënpagina\'s brengen.';
$string['loading'] = 'Laden';
$string['localetext'] = 'Locale voor de site';
$string['localstringcustomization'] = 'Taalpakket aanpassen voor lokaal gebruik';
$string['location'] = 'Plaats';
$string['locationsettings'] = 'Locatie-instellingen';
$string['locked'] = 'Geblokkeerd';
$string['lockoutduration'] = 'Duur geblokkeerde account';
$string['lockoutduration_desc'] = 'De geblokkeerde account wordt automatisch terug vrijgegeven na deze tijd.';
$string['lockoutemailbody'] = 'Je account {$a->username} op {$a->sitename} is geblokkeerd na meerdere mislukte pogingen om aan te melden.

Om je account onmiddellijk vrij te geven ga je naar volgend adres:

{$a->link}

In de meeste e-mailprogramma\'s zou dit als een blauwe link moeten verschijnen, waarop je gewoon kunt klikken. Als dat niet werkt, kopieer en plak de link dan in de adresbalk van je webbrowser.

Als je meer hulp nodig hebt, neem dan contact op met je site-beheerder, {$a->admin}';
$string['lockoutemailsubject'] = 'Je account op {$a} is geblokkeerd';
$string['lockouterrorunlock'] = 'Ongeldige deblokkeerinformatie gegeven.';
$string['lockoutthreshold'] = 'Duur blokkering account';
$string['lockoutthreshold_desc'] = 'Kies het aantal mislukte loginpogingen waardoor een account geblokkeerd zal worden. Deze functie kan misbruikt worden voor denial of service-aanvallen.';
$string['lockoutwindow'] = 'Observatievenster geblokkeerde accounts';
$string['lockoutwindow_desc'] = 'Observatietijd voor blokkeringsduur. Als er geen mislukte aanmeldingen zijjn na deze tijd, dan wordt de teller terug op nul gezet/';
$string['log'] = 'Logs';
$string['logguests'] = 'Log gasttoegang';
$string['logguests_help'] = 'Deze instelling maakt het mogelijk om activiteiten van de gast account en van niet aangemelde gebruikers te loggen. Voor sites met hoge belasting kan het nodig zijn deze instelling uit te schakelen voor om performantieredenen. Anders is het goed om dit ingeschakeld te laten op productiesites.';
$string['loginhttps'] = 'Gebruik HTTPS voor logins';
$string['loginpageautofocus'] = 'Autofocus loginformulier';
$string['loginpageautofocus_help'] = 'Deze functie inschakelen verhoogt het gebruiksgemak op de loginpagina, maar het automatisch focussen van velden wordt gezien als een toegankelijkheidsprobleem.';
$string['loginpasswordautocomplete'] = 'Wachtwoord aanvullen uitschakelen op loginformulier';
$string['loginpasswordautocomplete_help'] = 'Indien uitgeschakeld kunnen gebruikers hun wachtwoord bewaren in hun browser. Het inschakelen van deze optie zal er voor zorgen dat je site niet meer voldoet aan de XHTML strict validatieregels.';
$string['loglifetime'] = 'Logs bijhouden';
$string['longtimewarning'] = '<b>Opgelet: dit proces kan lang duren</b>';
$string['maintenancemode'] = 'In onderhoudsmodus';
$string['maintenancemodeisscheduled'] = 'De site wordt binnen {$a} minuten in onderhoudsmodus gezet.';
$string['maintfileopenerror'] = 'Fout bij het openen van de onderhoudsbestanden!';
$string['maintinprogress'] = 'Onderhoud bezig...';
$string['manageformats'] = 'Beheer cursusopmaak';
$string['manageformatsgotosettings'] = 'Standaardopmaak kan gewijzigd worden in {$a}';
$string['managelang'] = '<b>Beheer</b>';
$string['managelicenses'] = 'Beheer licenties';
$string['manageqbehaviours'] = 'Beheer gedrag van vragen';
$string['manageqtypes'] = 'Beheer vraagtypes';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release kandidaat';
$string['maturity200'] = 'Stabiele versie';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Hint: misschien wil je dit script met de --allow-unstable optie laten lopen';
$string['maturitycoreinfo'] = 'Je site draait momenteel op de ontwikkelcode van de onstabiele  versie "{$a}"';
$string['maturitycorewarning'] = 'De Moodleversie die je gaat installeren of upgraden bevat onstabiele "{$a}"-ontwikkelingscode en die is niet geschikt voor de meeste productiesites. Als dit niet is wat je wil, zorg er dan voor dat je update van een STABLE branch van de Moodle code. Zie Moodle Docs voor meer details.';
$string['maxbytes'] = 'Maximale grootte voor bestandsupload';
$string['maxconsecutiveidentchars'] = 'Opeenvolgende identieke tekens';
$string['maxeditingtime'] = 'Maximale tijd om berichten te bewerken';
$string['maxusersperpage'] = 'Maximaal aantal gebruikers per pagian';
$string['mbstringrecommended'] = 'Als je site andere talen dan die uit de Latin1 tekenset gebruikt, dan is het installeren van de optionele MBSTRING library ten zeerste aangeraden om de performantie van de site te verhogen.';
$string['mediapluginavi'] = 'Gebruik .avi-filter';
$string['mediapluginflv'] = 'Gebruik .flv-filter';
$string['mediapluginimg'] = 'Het automatisch insluiten van gelinkte afbeeldingen inschakelen';
$string['mediapluginmov'] = 'Gebruik .mov-filter';
$string['mediapluginmp3'] = 'Gebruik .mp3-filter';
$string['mediapluginmpg'] = 'Gebruik .mpg-filter';
$string['mediapluginogg'] = 'Schakel .ogg-filter in';
$string['mediapluginogv'] = 'Schakel .ogv-filter in';
$string['mediapluginram'] = 'Gebruik .ram-filter';
$string['mediapluginrm'] = 'Gebruik .rm-filter';
$string['mediapluginrpm'] = 'Gebruik .rpm-filter';
$string['mediapluginswf'] = 'Gebruik .swf-filter';
$string['mediapluginswfnote'] = 'Het is niet veilig om gewone gebruikers toe te laten swf flash bestanden te gebruiken in hun webpagina\'s.';
$string['mediapluginwmv'] = 'Gebruik .wmv-filter';
$string['mediapluginyoutube'] = 'Youtube linkfilter inschakelen';
$string['messaging'] = 'Berichtensysteem inschakelen';
$string['messagingallowemailoverride'] = 'Notificatie e-mail overschrijven';
$string['messagingdeletereadnotificationsdelay'] = 'Verwijder meldingen voor gelezen';
$string['messaginghidereadnotifications'] = 'Verberg meldingen voor gelezen';
$string['minpassworddigits'] = 'Tekens';
$string['minpasswordlength'] = 'Wachtwoordlengte';
$string['minpasswordlower'] = 'Kleine letters';
$string['minpasswordnonalphanum'] = 'Niet-alphanumerieke tekens';
$string['minpasswordupper'] = 'Hoofdletters';
$string['misc'] = 'Andere';
$string['mnetrestore_extusers'] = '<strong>Opmerking:</strong> Dit back-upbestand bevat Moodle Netwerk accounts, die zullen teruggezet worden als deel van dit proces';
$string['mnetrestore_extusers_admin'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Network accounts. Tijdens het terugzetten ervan zal Moodle proberen om die gebruikers aan de juiste Moodle Netwerk server te koppelen. Diegene die niet gekoppeld kunnen worden, zullen met interne aanmelding in plaats van mnet aangemaakt worden. Het logscherm van het terugzetten zal je hierover informeren.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Netwerk accounts die mogelijk niet teruggezet kunnen worden. Deze operatie wordt niet ondersteund. Als je er zeker van bent dat dit bestand op deze Moodle installatie werd gemaakt of je kunt er zeker van zijn dat alle nodige Moodle Netwerk Hosts geconfigureerd zijn, dan kun je toch proberen deze back-up terug te zetten.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Network accounts. Je hebt niet het recht om zo een back-up terug te zetten. Contacteer je sitebeheerder of zet deze cursus terug zonder gebruikersgegevens.';
$string['mnetrestore_extusers_switchuserauth'] = 'Moodle Netwerkgebruiker  {$a->username} (komt van {$a->mnethosturl}) is ombeschakeld naar een lokale  {$a->auth} geauthenticeerde gebruiker.';
$string['mobile'] = 'Mobiel';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Activiteitskiezer standaard';
$string['modeditdefaults'] = 'Standaardwaarden voor activiteitsinstellingen';
$string['modeditingmenu'] = 'Bewerkmenu\'s activiteiten';
$string['modeditingmenu_desc'] = 'Indien ingeschakeld zullen veel van de icoontjes voor het bewerken van activiteiten getoond worden in een rolmenuutje. Dit vermindert de hoeveelheid inhoud op het scherm wanneer je een cursus bewerkt door het verbergen van de icoontjes tot je ze nodig hebt.';
$string['modsettings'] = 'Beheer activiteiten';
$string['modulesecurity'] = 'Moduleveiligheid';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Forceer oude multilang syntax: <span> zonder de class="multilang" en <lang>';
$string['mustenablestats'] = 'Op deze server zijn Statistieken nog uitgeschakeld';
$string['mycoursesperpage'] = 'Maximaal aantal cursussen';
$string['mydashboard'] = 'Standaard dashboard van het systeem';
$string['mymoodle'] = 'Mijn startpagina';
$string['mymoodleredirect'] = 'Mijn Moodle verplichten';
$string['mypage'] = 'Standaard "Mijn startpagina"';
$string['mypagelocked'] = 'Blokkeer standaardpagina';
$string['myprofile'] = 'Standaard profielpagina';
$string['mysql416bypassed'] = 'Als je site echter UITSLUITEND iso-8859-1 (latin) talen gebruikt, dan kun je MySQL 4.1.12 (of hoger) blijven gebruiken.';
$string['mysql416required'] = 'MySQL 4.1.16 is de minimumversie die nodig is voor Moodle 1.6 om te kunnen garanderen dat alle gegevens naar UTF-8 geconverteerd zullen worden.';
$string['navadduserpostslinks'] = 'Voeg links toe om gebruikersberichten te zien';
$string['navadduserpostslinks_help'] = 'Indien ingeschakeld zullen er twee links toegevoegd worden bij elke gebruiker in de navigatie om discussies te zien die zij gestart hebben en berichten die de gebruikers geplaatst heeft in forums over heel de site of in bepaalde cursussen.';
$string['navcourselimit'] = 'Cursuslimiet';
$string['navigationupgrade'] = 'Deze upgrade introduceert twee nieuwe navigatieblokken die volgende blokken zal vervangen: Beheer, cursussen, activiteiten en deelnemers. Als je op deze blokken speciale rechten had toegepast, dan moet je controleren of alles wel werkt zoals je wil.';
$string['navshowallcourses'] = 'Toon alle curssusen';
$string['navshowcategories'] = 'Toon cursuscategorieën';
$string['navshowfrontpagemods'] = 'Toon startpagina-activiteiten in de navigatie';
$string['navshowfrontpagemods_help'] = 'Indien ingeschakeld worden activiteiten op de startpagina getoond in de navigatie onder site pagina\'s';
$string['navshowfullcoursenames'] = 'Toon volledige cursusnamen';
$string['navshowfullcoursenames_help'] = 'Indien dit is ingeschakeld zullen cursussen met hun volledige naam, eerder dan met hun korte naam, in het navigatieblok getoond worden.';
$string['navshowmycoursecategories'] = 'Toon mijn cursuscategorieën';
$string['navshowmycoursecategories_help'] = 'Indien ingeschakeld worden cursus in de Mijn cursussen vertakking in categorieën getoond.';
$string['navsortmycoursessort'] = 'Sorteer mijn cursussen';
$string['navsortmycoursessort_help'] = 'Bepaalt hoe de cursussen op de Mijn cursussen-tak van de navigatie gesorteerd zullen worden. (de volgorde in Instellingen > Site beheer > Cursussen > Curussen toevoegen/bewerken) of alfabetisch volgens cursusinstelling.';
$string['neverdeleteruns'] = 'Nooit verwijderen';
$string['nobookmarksforuser'] = 'Je hebt geen bladwijzers.';
$string['nodatabase'] = 'Geen databank';
$string['nohttpsformobilewarning'] = 'Aangeraden wordt om HTTPS in te schakelen met een geldig certificaat. De Moodle app zal altijd eerst proberen een beveiligde verbinding te gebruiken.';
$string['nomissingstrings'] = 'Geen ontbrekende woorden of zinnen';
$string['nonewsettings'] = 'Er zijn geen nieuwe instellingen toegevoegd tijdens deze upgrade';
$string['nonexistentbookmark'] = 'De bladwijzer die je vroeg, bestaat niet.';
$string['noresults'] = 'Geen resultaten gevonden';
$string['noroles'] = 'Geen rollen';
$string['notifications'] = 'Meldingen';
$string['notifyloginfailures'] = 'Loginfouten mailen naar';
$string['notifyloginthreshold'] = 'Minimaal aantal fouten voor e-mailnotificatie';
$string['notloggedinroleid'] = 'Rol voor bezoekers';
$string['numberofmissingstrings'] = 'Aantal ontbrekende woorden of zinnen: {$a}';
$string['numberofstrings'] = 'Aantal woorden/zinnen: {$a->strings}<br />Ontbrekend: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'PHP opcode caching verbetert de performantie en vermindert de geheugenvereisten. De OPcache-extentie wordt aanbevolen en volledig ondersteund.';
$string['opensslrecommended'] = 'Het installeren van de OpenSSL bibliotheek is sterk aangeraden -- het maakt Moodle Networking mogelijk.';
$string['opentogoogle'] = 'Open voor Google';
$string['optionalmaintenancemessage'] = 'Optionele onderhoudsboodschap';
$string['order1'] = 'Eerste';
$string['order2'] = 'Tweede';
$string['order3'] = 'Derde';
$string['order4'] = 'Vierde';
$string['passwordpolicy'] = 'Wachtwoordbeleid';
$string['passwordresettime'] = 'Maximumtijd om een wachtwoordreset te valideren';
$string['pathconvert'] = 'Pad van <i>convert</i> binary';
$string['pathdvips'] = 'Pad van <i>dvips</i> binary';
$string['pathlatex'] = 'Pad van <i>latex</i> binary';
$string['pathtoclam'] = 'Clam AV-pad';
$string['pathtodot'] = 'Pad naar dot';
$string['pathtodot_help'] = 'Pad naar dot. Waarschijnlijk iets als /usr/bin/dot. Om het mogelijk te maken grafische bestanden te maken van DOT-bestanden, heb je dot nodig en moet je hier opgeven waar het op je server te vinden is.';
$string['pathtodu'] = 'Pad naar du';
$string['pathtopgdump'] = 'Pad naar pg_dump';
$string['pathtopgdumpdesc'] = 'Je moet dit enkel ingeven als je meer dan één pg_dump op je systeem hebt (bijvoorbeeld als je meer dan één versie van postgresql geïnstalleerd hebt)';
$string['pathtopgdumpinvalid'] = 'Ongeldig pad naar pg_dump - ofwel verkeerd pad of niet uitvoerbaar';
$string['pathtopsql'] = 'Pad naar psql';
$string['pathtopsqldesc'] = 'Dit is enkel nodig als je meer dan één psql op je systeem hebt (bijvoorbeeld als je meer dan één versie van postgresql geïnstalleerd hebt)';
$string['pathtopsqlinvalid'] = 'Ongeldig pad naar psql - ofwel verkeerd pad ofwel niet uitvoerbaar';
$string['pcreunicodewarning'] = 'Het wordt sterk aangeraden om de PCRE PHP-extentie te gebruiken die compatibel is met Unicode tekens';
$string['perfdebug'] = 'Performantie-informatie';
$string['performance'] = 'Prestaties';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = '<pre>PostgeSQL versie/cluster parameter voor operaties via commandprompt. Als je slechts één PostgreSQL op je systeem hebt of je weet niet wat dit is, laat dit veld dan leeg.</pre>';
$string['php50restricted'] = 'PHP 5.0.x heeft een heel aantal bekende problemen. Upgrade naar 5.1.x of downgrade naar 4.3.x of 4.4.x';
$string['php533warning'] = 'PHP 5.3.3 en hoger aangeraden';
$string['phpfloatproblem'] = 'Onverwacht probleem gevonden bij het behandelen van PHP float numbers - {$a}';
$string['pleaserefreshregistration'] = 'Je site is geregistreerd bij moodle.org. Update je registratie als er grote wijzigingen aan je site zijn sinds je laatste registratie.';
$string['pleaseregister'] = 'Registreer aub je site.  Op die manier kun je deze knop verwijderen.';
$string['plugin'] = 'Module';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Controle plugin-afhankelijkheden';
$string['pluginscheckfailed'] = 'Afhankelijkheidscontrole mislukt voor {$a->pluginlist}';
$string['pluginschecktodo'] = 'Je moet eerst alle pluginvereisten oplossen voor je verder kunt gaan met het installeren van deze Moodleversie!';
$string['pluginsoverview'] = 'Overzicht plugins';
$string['pluginsoverviewsee'] = 'Zie <a href="{$a->url}">pluginoverzichtspagina</a> voor meer details.';
$string['profilecategory'] = 'Categorie';
$string['profilecategoryname'] = 'Categorienaam (moet uniek zijn)';
$string['profilecategorynamenotunique'] = 'Deze categorienaam is al in gebruik';
$string['profilecommonsettings'] = 'Algemene instellingen';
$string['profileconfirmcategorydeletion'] = 'Er is/zijn {$a} veld(en) in deze categorie die naar de bovenliggende categorie verplaats zullen worden (of lager als ze in de bovenste categorie zijn).<br />Wil je nog steeds deze categorie verwijderen?';
$string['profileconfirmfielddeletion'] = 'Er is/zijn {$a} gebruikersrecord(s) voor dit veld die verwijderd zullen worden.<br />Wil je nog steeds dit veld verwijderen?';
$string['profilecreatecategory'] = 'Maak een nieuwe profielcategorie';
$string['profilecreatefield'] = 'Maak een nieuw profielveld';
$string['profilecreatenewcategory'] = 'Nieuwe categorie maken ...';
$string['profilecreatenewfield'] = 'Nieuw "{$a}" profielveld maken';
$string['profiledefaultcategory'] = 'Andere velden';
$string['profiledefaultchecked'] = 'Standaard gecontroleerd';
$string['profiledefaultdata'] = 'Standaardwaarde';
$string['profiledeletecategory'] = 'Categorie verwijderen...';
$string['profiledeletefield'] = 'Veld "{$a}" verwijderen...';
$string['profiledescription'] = 'Veldbeschrijving';
$string['profiledscript'] = 'Dit script is al geprofiled';
$string['profiledscriptview'] = 'Bekijk profiling-informatie voor dit script';
$string['profileeditcategory'] = 'Bewerk categorie: {$a}';
$string['profileeditfield'] = 'Bewerk profielveld: {$a}';
$string['profilefield'] = 'Profielveld';
$string['profilefieldcolumns'] = 'Kolommen';
$string['profilefieldispassword'] = 'Is dit een wachtwoordveld?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Om tekst om te vormen in een link, geef je een URL in die $$ bevat, waar $$ vervangen zal worden door de tekst. Om bijvoorbeeld een Twitter ID om te zetten in een link, typ je http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Link doel';
$string['profilefieldmaxlength'] = 'Maximale lengte';
$string['profilefieldrows'] = 'Rijen';
$string['profilefields'] = 'Profielvelden';
$string['profilefieldsize'] = 'Schermgrootte';
$string['profileforceunique'] = 'Moeten de gegevens uniek zijn?';
$string['profileinvaliddata'] = 'Ongeldige waarde';
$string['profilelocked'] = 'Is dit veld geblokkeerd?';
$string['profilemenudefaultnotinoptions'] = 'De standaardwaarde is niet één van deze opties';
$string['profilemenunooptions'] = 'Geen menuopties voorzien';
$string['profilemenuoptions'] = 'Menuopties (één per lijn)';
$string['profilemenutoofewoptions'] = 'Je moet minstens 2 opties geven';
$string['profilename'] = 'Naam';
$string['profilenofieldsdefined'] = 'Er zijn nog geen velden gedefinieerd';
$string['profilerequired'] = 'Is dit veld vereist?';
$string['profileroles'] = 'Rollen voor zichtbaar profiel';
$string['profilesforenrolledusersonly'] = 'Profielen alleen voor aangemelde gebruikers';
$string['profileshortname'] = 'Korte naam (moet uniek zijn)';
$string['profileshortnamenotunique'] = 'Deze korte naam is al in gebruik';
$string['profilesignup'] = 'Tonen op inschrijvingspagina?';
$string['profilespecificsettings'] = 'Specifieke instellingen';
$string['profilevisible'] = 'Voor wie is dit veld zichtbaar?';
$string['profilevisibleall'] = 'Zichtbaar voor iedereen';
$string['profilevisible_help'] = '<p>Elk eigen profielveld kan drie mogelijke instellingen hebben voor wie het veld kan zien: onzichtbaar, iedereen of gebruiker. Deze keuze wordt gemaakt door een beheerder die privégegevens van de gebruikers wil bewaren. \'Gebruiker\' wordt meestal gekozen wanneer dat veld gevoelige informatie bevat, terwijl \'iedereen\' gekozen wordt voor andere informatie.</p>';
$string['profilevisiblenone'] = 'Niet zichtbaar';
$string['profilevisibleprivate'] = 'Zichtbaar voor gebruiker';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Continu profilen';
$string['profilingallowall_help'] = 'Als je deze instelling inschakeld, dan kun je altijd gebruik maken van de PROFILEALL parameter (PGC) om profiling in te schakelen voor alle uitgevoerde scripts tijdens de duur van je Moodlesessie. Analoog kun je de PROFILEALLSTOP parameter gebruiken om het te stoppen';
$string['profilingallowme'] = 'Selectief profilen';
$string['profilingallowme_help'] = 'Als je deze instelling inschakeld, dan kun je gebruik maken van de PROFILEME parameter (PGC) om profiling in te schakelen voor een script. Analoog kun je de DONTPROFILEME parameter gebruiken om het te stoppen';
$string['profilingautofrec'] = 'Automatisch profilen';
$string['profilingautofrec_help'] = 'Door deze instelling te configureren, zullen sommige requests (willekeurig, gebaseerd op de opgegeven frequentie - 1 van N) er uitgekozen worden en automatisch geprofiled worden, waarbij de resultaten voor verdere analyse bewaard worden. Merk op dat deze manier van profilen de include/exclude instellingen bekijkt. Zet dit op 0 om automatisch profilen uit te schakelen.';
$string['profilingenabled'] = 'Profilen inschakelen';
$string['profilingenabled_help'] = 'Als je deze instelling inschakeld, dan zal pofiling op deze site mogelijk zijn en zul je het gedrag ervan kunnen bepalen met onderstaande opties.';
$string['profilingexcluded'] = 'Profilen uitsluiten';
$string['profilingexcluded_help'] = 'Lijst met URL\'s (kommagescheiden, absoluut wwwroot overslaan, aanroepbaar) die uitgesloten zullen worden van diegene die met de \'Profile deze\' instelling gedefinieerd worden.';
$string['profilingimportprefix'] = 'Profiling import prefix';
$string['profilingimportprefix_desc'] = 'Om gemakkelijker terug te vinden krijgen alle profiling runs de hier opgegeven waarde als prefix.';
$string['profilingincluded'] = 'Profile deze';
$string['profilingincluded_help'] = 'Lijst met URL\'s (kommagescheiden, absoluut wwwroot overslaan, aanroepbaar) die automatisch geprofiled zullen worden. Voorbeelden: /index.php,/course/view.php. Ook het jokerteken * wordt aanvaard op elke plaats. Voorbeelden: /mod/forum/*,/mod/*/viep.php';
$string['profilinglifetime'] = 'Profile runs behouden';
$string['profilinglifetime_help'] = 'Bepaal hoe lang je informatie over oude profile runs wil behouden. Oude runs zullen automatisch verwijderd worden. Merk op dat dit niet zal gebeuren voor runs die als \'reference run\' gemarkeerd worden.';
$string['protectusernames'] = 'Bescherm gebruikersnamen';
$string['proxybypass'] = 'Proxy bypass hosts';
$string['proxyhost'] = 'Proxyserver';
$string['proxypassword'] = 'Proxy wachtwoord';
$string['proxyport'] = 'Proxy poort';
$string['proxytype'] = 'Proxy type';
$string['proxyuser'] = 'Proxy gebruikersnaam';
$string['purgecaches'] = 'Alle caches leegmaken';
$string['purgecachesconfirm'] = 'Moodle kan thema\'s cachen, javascript, taalstrings, gefilterde tekst, rss-feeds en veel andere stukken berekende gegevens. Het leegmaken van deze caches zal alle gegevens verwijderen van de server en zal browsers forceren om de gegevens te verversen, zodat je er zeker kan van zijn dat de meest recente waardes die je huidige code produceert, getoond worden. Er is geen gevaar verbonden aan het verwijderen van caches, maar je server kan trager lijken tot je server en de clients de nieuwe informatie berekend en gecached hebben.';
$string['purgecachesfinished'] = 'Alle caches zijn leeggemaakt.';
$string['qtyperqpwillberemoved'] = 'Tijdens de upgrade zal het RQP vraagtype verwijderd worden. Je gebruikte deze vraag niet, dus je zult hier geen problemen mee krijgen.';
$string['qtyperqpwillberemovedanyway'] = 'Tijdens de upgrade zal het RQP vraagtype verwijderd worden. Er zijn vragen van dit type in je database. Die zullen stoppen met werken, tenzij je de code herinstalleert van  http://moodle.org/mod/data/view.php?d=13&amp;rid=797 voor je verder gaat met de upgrade.';
$string['quarantinedir'] = 'Quarantainemap';
$string['question'] = 'Vragen';
$string['questionbehaviours'] = 'Gedrag vragen';
$string['questioncwqpfscheck'] = 'Eén of meer willekeurige vragen in een test zijn insgesteld om vragen te kiezen uit gedeelde en niet gedeelde vragencategorieën. Er is een meer gedetailleerd rapport <a href="{$a->reporturl}">hier</a> en je kunt de Moodle Docs-pagina <a href="{$a->docsurl}">hier</a> bekijken.';
$string['questioncwqpfsok'] = 'Goed. Er zijn geen willekeurige vragen in je testen die opgemaakt zijn om vragen uit zowel gedeelde als niet gedeelde vragencategorieën te kiezen.';
$string['questiontype'] = 'Vraagtype';
$string['questiontypes'] = 'Vraagtypes';
$string['quizattemptsupgradedmessage'] = 'In Moodle 2.1 was eer een grote upgrade van de vragen. Het was toen mogelijk om delen van de databankupgrade uit te stellen tot later. Voor je kunt upgraden naar Moodle 2.7 moet deze upgrade volledig uitgevoerd zijn.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA private sleutel';
$string['recaptchapublickey'] = 'ReCAPTCHA publieke sleutel';
$string['register'] = 'Registreer je site';
$string['registermoodleorg'] = 'Als je je site registreert met {$a}';
$string['registermoodleorgli1'] = 'Je wordt toegevoegd aan een laag-volume mailinglijst voor belangrijke berichten in verband met veiligheidsproblemen en nieuwe Moodleversies.';
$string['registermoodleorgli2'] = 'Statistieken over je site zullen aan {$a} van de wereldwijde Moodlegemeenschap toegevoegd worden.';
$string['registermoodleorgli3'] = 'Je site is ook geregistreerd bij Moodle.net ({$a}), waardoor gebruikers die de mogelijkheid hebben om cursussen te publiceren (standaard enkel managers) de optie hebben om cursussen te publiceren op Moodle.net.';
$string['registerwithmoodleorg'] = 'Registreer bij Moodle.org';
$string['registration'] = 'Registratie';
$string['registration_help'] = 'Het is aan te raden om te registreren bij Moodle.org om veiligheidsmeldingen via e-mail te ontvangen, om mee te helpen aan de groei van Moodle en de <a href="http://moodle.org/stats">Moodle statistieken</a> of om cursussen te kunnen delen op <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Je site is nog niet geregistreerd.';
$string['releasenoteslink'] = 'Bekijk de online <a target="_new" href="{$a}">Release Notes</a> voor informatie over deze versie van Moodle.';
$string['rememberusername'] = 'Gebruikersnaam onthouden';
$string['rememberusername_desc'] = 'Schakel dit in als je permanente cookies wil bewaren met de gebruikersnaam tijdens het aanmelden. Permanente cookies kunnen een privacyprobleem stellen als ze niet met zorg gebruikt worden.';
$string['reportsmanage'] = 'Beheer rapporten';
$string['requestcategoryselection'] = 'Categorieselectie inschakelen';
$string['requiredentrieschanged'] = '<strong>BELANGRIJK - LEES DIT<br /> (Deze waarschuwingsboodschap zal alleen tijdens deze upgrade getoond worden)</strong><br /> Door een bug fix zal het gedrag van databankactiviteiten die gebruik maken van \'Vereiste items\' en \'Vereiste items voor bekijken\' wijzigen. Een meer gedetailleerde beschrijving vind je in <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">the database module forum</a>. Het verwachte gedrag van deze instellingen kun je ook nalezen op  <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.<br/><br/>
Deze wijziging heeft effect op volgende databanken in je systeem (bewaar deze lijst nu, zodat je na de upgrade kunt testen of de activiteiten nog steeds werken zoals de leraar het bedoelt): <br/><strong style="color:red">{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Beschrijving van de activiteit vereist';
$string['requires'] = 'Vereist';
$string['restorernewroleid'] = 'De rol in cursussen van degene die een back-up terugzet';
$string['restorernewroleid_help'] = 'Als de gebruiker nog geen toestemming heeft om de pas teruggezette cursus te beheren, dan krijgt de gebruiker automatisch deze rol en wordt aangemeld indien nodig. Selecteer "Geen" als u niet wil dat diegenen die de cursus hebben teruggezet nog wijzigingen mogen aanbrengen.';
$string['reverseproxy'] = 'Reverse proxy';
$string['riskconfig'] = 'Gebruikers zouden de configuratie en het gedrag van de site kunnen wijzigen';
$string['riskconfigshort'] = 'Configuratierisico';
$string['riskdataloss'] = 'Gebruikers zouden grote hoeveelheden inhoud of informatie kunnen vernietigen';
$string['riskdatalossshort'] = 'Risico op dataverlies';
$string['riskmanagetrust'] = 'Gebruikers kunnen vertrouwelijke instellingen van anderen wijzigen';
$string['riskmanagetrustshort'] = 'Beheer vertrouwensrelaties';
$string['riskpersonal'] = 'Gebruikers kunnen toegang krijgen tot privé-informatie van andere gebruikers';
$string['riskpersonalshort'] = 'Privacy-risico';
$string['riskspam'] = 'Gebruikers kunnen spam sturen naar sitegebruikers of anderen';
$string['riskspamshort'] = 'Spam-risico';
$string['riskxss'] = 'Gebruikers kunnen bestanden en teksten toevoegen die  cross-site scripting (XSS) mogelijk maken.';
$string['riskxssshort'] = 'XSS-risico';
$string['roleswithexceptions'] = '{$a->roles}, met {$a->exceptions}';
$string['rssglobaldisabled'] = 'Uitgeschakeld op serverniveau';
$string['runclamavonupload'] = 'Gebruik clam AV voor geüploade bestanden';
$string['save'] = 'Bewaar';
$string['savechanges'] = 'Bewaar wijzigingen';
$string['search'] = 'Zoek';
$string['searchinsettings'] = 'Zoek in instellingen';
$string['searchresults'] = 'Zoekresultaten';
$string['sectionerror'] = 'Sectiefout!';
$string['secureforms'] = 'Gebruik bijkomende formulierbeveiliging';
$string['security'] = 'Veiligheid';
$string['selectdevice'] = 'Selecteer toestel';
$string['selecttheme'] = 'Selecteer thema voor {$a} toestel';
$string['server'] = 'Server';
$string['serverchecks'] = 'Servercontroles';
$string['serverlimit'] = 'Serverlimiet';
$string['sessionautostartwarning'] = '<p>Belangrijke configuratiefout gedetecteerd, waarschuw de systeembeheerder.</p><p> Moodle vereist dat de beheerder de php-instellingen wijzigt om goed te kunnen werken.</p><p><code>session.auto_start</code> moet ingesteld zijn op <code>off</code>.</p><p>Deze instelling kan gewijzigd worden door <code>php.ini</code>, Apache/IIS <br />configuratie of het <code>.htaccess</code> bestand op de server te wijzigen.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookie domein';
$string['sessioncookiepath'] = 'Cookie pad';
$string['sessionhandling'] = 'Sessie afhandeling';
$string['sessiontimeout'] = 'Timeout';
$string['settingfileuploads'] = 'Het uploaden van bestanden is vereist voor het normaal functioneren van Moodle. Schakel het in in je PHP-configuratie.';
$string['settingmemorylimit'] = 'Onvoldoende geheugen gedetecteerd. Zet de geheugenlimiet hoger in je PHP-instellingen.';
$string['settingsafemode'] = 'Moodle is niet volledig compatibel met safe mode. Vraag je serverbeheerder om het uit te schakelen. Moodle draaien met safe mode ingeschakeld wordt niet ondersteund - je kunt je aan verschillende problemen verwachten.';
$string['showcommentscount'] = 'Toon aantal commentaren';
$string['showdetails'] = 'Toon details';
$string['showuseridentity'] = 'Toon de identiteit van de gebruiker';
$string['showuseridentity_desc'] = 'Bij het selecteren of het zoeken naar gebruikers, en bij het tonen van lijsten van gebruikers, kunnen deze velden getoond worden in aanvulling op hun naam. De velden worden alleen getoond aan gebruikers die beschikken over de moodle/site:viewuseridentity capability; normaal gezien leraren en managers. (Deze optie is het meest zinvol als u één of twee velden kiest die verplicht zijn in uw instelling.)';
$string['simplexmlrequired'] = 'De SimpleXML PHP-extentie is nu vereist voor Moodle.';
$string['sitemaintenance'] = 'De site is in onderhoud en is op dit ogenblik niet beschikbaar';
$string['sitemaintenancemode'] = 'Onderhoudsmodus';
$string['sitemaintenanceoff'] = 'De onderhoudsmodus is uitgeschakeld en de site loopt nu terug normaal';
$string['sitemaintenanceon'] = 'Je site is nu in onderhoudsmodus (alleen beheerders kunnen inloggen of gebruik maken van de site)';
$string['sitemaintenanceoncli'] = 'Je site loopt in CLI onderhoudsmodus. Toegang via de webinterface is niet mogelijk.';
$string['sitemaintenancewarning'] = 'Je site is nu in onderhoudsmodus (alleen beheerders kunnen inloggen of gebruik maken van de site). Om terug te keren naar normale werking: <a href="maintenance.php">onderhoudsmodus uitschakelen</a>';
$string['sitemaintenancewarning2'] = 'Je site is in onderhoudsmodus (enkel beheerders kunnen inloggen). <a href="{$a}">Schakel onderhoudsmodus uit</a> om de site terug normaal te laten werken';
$string['sitepolicies'] = 'Site reglement';
$string['sitepolicy'] = 'URL voor site afspraken';
$string['sitepolicyguest'] = 'Site reglement URL voor gasten';
$string['sitepolicyguest_help'] = 'Als je een site-reglement hebt dat alle gasten moeten zien voor ze de site gebruiken, dan moet je hier de URL er naar invullen. Als niet, dan laat je dit veld leeg.
Deze instelling kan gelijk welke publiek zichtbare URL bevatten. Merk op: toegang van niet aangemelde gebruikers kan verhinderd worden met de aanmelding verplicht instelling.';
$string['sitepolicy_help'] = 'Als je een overeenkomst hebt voor het gebruik van de site die alle gebruikers moeten zien voor ze deze site gebruiken, geef dan hier een de URL naar die pagina op, anders laat je dit veld leeg. De URL kan naar gelijk waar verwijzen - een voor de hand liggende plaats zou een bestand tussen de sitebestanden zijn, bijvoorbeeld http://jouwsite/file.php/1/overeenkomst.html';
$string['sitesectionhelp'] = 'Indien gekozen wordt er een onderwerpsectie getoond op de startpagina van de site';
$string['slasharguments'] = 'Gebruik slash arguments';
$string['smartpix'] = 'Slim afbeeldingen zoeken';
$string['soaprecommended'] = 'Het installeren van de optionele Soap-extentie is nuttig voor webservices en sommige modules uit contrib.';
$string['sort_fullname'] = 'Volledige naam cursus';
$string['sort_idnumber'] = 'ID-nummer cursus';
$string['sort_shortname'] = 'Korte naam cursus';
$string['sort_sortorder'] = 'Sorteervolgorde';
$string['spellengine'] = 'spellingscorrector';
$string['spelllanguagelist'] = 'Taallijst voor spelling';
$string['splrequired'] = 'De SPL PHP-extentie is nu vereist voor Moodle';
$string['stats'] = 'Statistieken';
$string['statsfirstrun'] = 'Maximaal verwerkingsinterval';
$string['statsmaxruntime'] = 'Maximale verwerktijd';
$string['statsmoodleorg'] = 'statistieken';
$string['statsruntimedays'] = 'Aantal te verwerken dagen';
$string['statsruntimestart'] = 'Start om';
$string['statsuserthreshold'] = 'Gebruikermarge';
$string['stickyblocks'] = 'Permanent blok';
$string['stickyblockscourseview'] = 'Cursuspagina';
$string['stickyblocksduplicatenotice'] = 'Als je hier een blok toevoegt dat al op een bepaalde pagina staat, krijg je er twee.<br />Alleen het vastgezette blok zul je niet kunnen bewerken, het tweede zul je wel kunnen bewerken.';
$string['stickyblocksmymoodle'] = 'Mijn Moodle';
$string['stickyblockspagetype'] = 'Te configureren paginatype';
$string['strictformsrequired'] = 'Strikte validatie van vereiste velden';
$string['stripalltitletags'] = 'Verwijder HTML-tags van alle activiteitsnamen';
$string['supportcontact'] = 'Helpdesk';
$string['supportemail'] = 'E-mail helpdesk';
$string['supportname'] = 'Naam helpdesk';
$string['supportpage'] = 'URL helpdesk';
$string['suspenduser'] = 'Schors gebruikersaccount';
$string['switchlang'] = 'Wissel map voor taalbestanden';
$string['systempaths'] = 'Systeempaden';
$string['tablenosave'] = 'Wijzigingen in bovenstaande tabel worden automatisch bewaard.';
$string['tablesnosave'] = 'Wijzigingen in bovenstaande tabellen worden automatisch bewaard.';
$string['tabselectedtofront'] = 'Moet bij tabellen met tabs de nu geselecteerde tab vooraan gezet worden?';
$string['tabselectedtofronttext'] = 'Breng de rij van de geselecteerde tab naar voor';
$string['testsiteupgradewarning'] = 'Je gebruikt nu de {$a} test site. Je kunt beter de command line tool gebruiken om te upgraden';
$string['themedesignermode'] = 'Thema ontwerpermodus';
$string['themelist'] = 'Thema lijst';
$string['themenoselected'] = 'Geen thema gekozen';
$string['themeresetcaches'] = 'Maak themacaches leeg';
$string['themeselect'] = 'Wijzig thema';
$string['themeselector'] = 'Kies thema';
$string['themesettings'] = 'Thema instellingen';
$string['therewereerrors'] = 'Er waren fouten in je gegevens';
$string['thirdpartylibrary'] = 'Bibliotheek';
$string['thirdpartylibrarylocation'] = 'Plaats';
$string['thirdpartylibs'] = 'Externe bibliotheken';
$string['timezone'] = 'Standaard tijdzone';
$string['timezoneforced'] = 'Dit is opgelegd door de sitebeheerder';
$string['timezoneisforcedto'] = 'Iedereen gebruikt';
$string['timezonenotforced'] = 'Gebruikers kunnen hun eigen tijdzone kiezen';
$string['tokenizerrecommended'] = 'Het installeren van de optionnele PHP Tokenizer extentie wordt aangeraden -- het verbetert de Moodle Networking functionnaliteit';
$string['tools'] = 'Beheertools';
$string['toolsmanage'] = 'Beheer beheertools';
$string['unattendedoperation'] = 'Automatische installatie';
$string['unbookmarkthispage'] = 'Verwijder de bladwijzer naar deze pagina';
$string['unicoderecommended'] = 'Aanbevolen wordt om al je data als Unicode (UTF-8) te bewaren. Nieuwe installaties zouden moeten geïnstalleerd worden met Unicode als standaard tekenset voor de databank. Als je upgrade, moet je het UTF-8 migratieproces laten lopen (zie pagina Beheer).';
$string['unicoderequired'] = 'Je moet al je data als Unicode (UTF-8) bewaren. Nieuwe installaties moeten geïnstalleerd worden met Unicode als standaard tekenset voor de databank. Als je upgrade, moet je het UTF-8 migratieproces laten lopen (zie pagina Beheer).';
$string['uninstallplugin'] = 'Verwijder';
$string['unlockaccount'] = 'Deblokkeer account';
$string['unsettheme'] = 'Zet thema uit';
$string['unsupported'] = 'Niet ondersteund';
$string['unsuspenduser'] = 'Activeer gebruikersaccount';
$string['updateaccounts'] = 'Update bestaande accounts';
$string['updateautocheck'] = 'Automatisch controleren op beschikbare updates';
$string['updateautocheck_desc'] = 'Indien ingeschakeld, wordt er automatisch gecontroleerd op beschikbare updates zowel voor Moodle-code als voor alle aanvullende plug-ins. Als er een nieuwe update beschikbaar is, wordt een melding gestuurd naar de site-beheerders.';
$string['updateautodeploy'] = 'Updates uitrollen inschakelen';
$string['updateautodeploy_desc'] = 'Indien ingeschakeld, zul je beschikbare updates automatisch kunnen downloaden en installeren vanaf de Moodle beheerpagina\'s. Merk op dat je werbserver schrijfrechten moet hebben in de mappen met de Moodleinstallatie om dit mogelijk te maken. Dit kan als een mogelijk beveiligingsrisico gezien worden.';
$string['updateavailable'] = 'Er is een nieuwere Moodle versie beschikbaar!';
$string['updateavailabledetailslink'] = 'Zie {$a->url} voor meer details';
$string['updateavailableforplugin'] = 'Er is een nieuwere versie voor een aantal van uw plugins beschikbaar!';
$string['updateavailableinstall'] = 'Installeer deze update';
$string['updateavailable_moreinfo'] = 'Meer info ...';
$string['updateavailablenot'] = 'Uw Moodle-code is up-to-date!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versie {$a}';
$string['updatecomponent'] = 'Update component';
$string['updateminmaturity'] = 'Vereiste code-maturiteit';
$string['updateminmaturity_desc'] = 'Enkel meldingen geven over beschikbare updates als de beschikbare code minstens het geselecteerde maturiteitsniveau heeft. Updates voor plugins die hun maturiteitsniveau hebben niet geven, worden altijd gemeld, ongeacht deze instelling.';
$string['updatenotificationfooter'] = 'Je Moodlesite {$a->siteurl} is geconfigureerd om automatisch te controleren op beschikbare updates. Je ontvangt dit bericht als site-beheerder. Je kunt het automatisch controleren van updates blokkeren in de sectie Site-beheer van het blok Instellingen. Je kunt de melding van dit bericht aanpassen via je persoonlijke berichten instelling in de sectie Mijn profiel-instellingen.';
$string['updatenotifications'] = 'Update meldingen';
$string['updatenotificationsubject'] = 'Er zijn Moodle updates beschikbaar voor {$a->siteurl}.';
$string['updatenotifybuilds'] = 'Stuur melding bij nieuwe versies';
$string['updatenotifybuilds_desc'] = 'Indien ingeschakeld wordt de beschikbaarheid van een update van de Moodle-code als er een nieuwe build van de huidige versie beschikbaar is. Builds zijn voortdurende verbeteringen van een bepaalde Moodleversie. Ze worden gewoonlijk elke week gebouwd; Indien uitgeschakeld wordt als beschikbare update alleen gerapporteerd als er een nieuwe Moodleversie beschikbaar is. Controles voor plugins worden niet beïnvloed door deze instelling.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 bevat een aantal oplossingen voor beveiligingsproblemen in verband met gebruikerswachtwoorden en back-ups om de gebruikersgegevens van jouw site te beschermen. Hierdoor kunnen sommige instellingen en rechten die verband houden met het nemen van back-ups gewijzigd zijn.<br />
Kijk op <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> voor alle details.</p>';
$string['upgrade197noticesubject'] = 'Beveiligingswaarschuwingen voor de Moodle 1.9.7 upgrade';
$string['upgrade197salt'] = 'Om het risico op wachtwoorddiefstal te verminderen wordt je sterk aangeraden om een password salt in te stellen.<br />Zie See the <a href="{$a}" target="_blank">password salting documentation</a> voor details.';
$string['upgradeerror'] = 'Onbekende fout bij het upgraden van {$a->plugin} naar versie {$a->version}. Kan niet verder doen.';
$string['upgradeforumread'] = 'Vanaf Moodle 1.5 kun je bijhouden of forumberichten al gelezen zijn of niet.<br /> Om deze functie te kunnen gebruiken moet je <a href="{$a}">je tabellen upgraden</a>.';
$string['upgradeforumreadinfo'] = 'Vanaf Moodle 1.5 kun je bijhouden of forumberichten al gelezen zijn of niet.<br /> Om deze functie te kunnen gebruiken moet je je tabellen upgraden met alle niet gelezen/gelezen informatie voor de bestaande berichten. Afhankelijk van de grootte van je site kan dit lang duren (uren) en kan je databank behoorlijk belasten. Het is dus aangeraden dit te doen tijdens een rustige periode. Je site zal blijven werken tijdens deze upgrade en je gebruikers zullen er weinig hinder van ondervinden. Als je dit proces start moet je het laten aflopen (laat je browser-venster open). Geen paniek als je het proces toch zou stoppen door je venster te sluiten: je kunt terug opnieuw beginnen .<br /><br />Wil je het upgrade-proces nu starten?';
$string['upgradelogs'] = 'Om volledige functionaliteit te verkrijgen, moeten je oude logbestanden geüpgraded worden. <a href="{$a}">Meer informatie</a>';
$string['upgradelogsinfo'] = 'Sommige wijzigingen hebben invloed op de manier waarop de logs worden opgeslagen. Om al je oude logs per activiteit te kunnen bekijken, moeten je oude logs geüpdated worden. Afhankelijk van je site kan dit lang duren (zelfs enkele uren) en voor lange sites kan dat de databank zwaar belasten. Als je het proces start, dan zou je het moeten laten aflopen (door het browservenster open te laten). Maak je geen zorgen, terwijl je de logs upgradet, zal de site blijven werken voor je gebruikers.<br /><br />Wil je je logs nu upgraden?';
$string['upgradepluginsfirst'] = 'Je kunt best de beschikbare updates eerst installeren';
$string['upgradepluginsinfo'] = 'Plugins aan het updaten';
$string['upgradepluginsinfo_help'] = 'Er zijn updates beschikbaar voor sommige van je plugins. Je moet ze allemaal installeren voor je Moodle upgrade. Als je site nog geen automatische updates ondersteunt, moet je de nieuwe plugins manueel op je server installeren.';
$string['upgradesettings'] = 'Nieuwe instellingen';
$string['upgradesettingsintro'] = 'Onderstaande instellingen werden toegevoegd sinds je laatste Moodle upgrade. Wijzig de standaardinstellingen waar nodig en klik op de "Bewaar instellingen"-knop onderaan deze pagina.';
$string['upgradestalefiles'] = 'Gemengde Moodleversies gedetecteerd, upgrade kan niet verder gaan.';
$string['upgradestalefilesinfo'] = 'Het Moodle updateproces is gepauseerd, omdat er PHP scripts van minstens 2 Moodleversies gedetecteerd zijn in je Moodlemap.

Dit kan grote problemen opleveren, dus om verder te gaan moet je er voor zorgen dat de Moodlemap enkel bestanden van één enkele versie bevat.

Je kunt het volgende doen om je Moodlemap op te schonen:

*hernoem je huidige Moodlemap naar "moodle_oud"
*maak een nieuwe Moodlemap met enkel bestanden van een standaard Moodleversie, die je download of via Git bekomt.
*verplaats het oorspronkelijke config.php-bestand en alle niet-standaard plugins van je moodle_oud map naar je nieuwe Moodlemap

Wanneer je een propere Moodlemap hebt, ververs dan de pagina om de upgrade verder te zetten.

Deze waarschuwing wordt gewoonlijk veroorzaakt door een standaard Moodlepakket te unzippen over een vorige versie van Moodle. Terwijl dit kan voor kleine updates, wordt het ten zeerste afgerade voor grote Moodle upgrades.

Deze waarschuwing kan ook veroorzaakt worden door een onvolledige checkout van Git, waarbij je gewoonlijk moet wachten tot de update operatie klaar is of het juiste opschoonscript te laten lopen en de operatie opnieuw te proberen.

Je kunt meer informatie vinden in de upgrade documentatie op <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Moodledatabank nu bijwerken';
$string['upgradesure'] = '<p>De bestanden op je Moodleserver zijn gewijzigd en je gaat zo dadelijk je server automatisch upgraden naar versie: </p>
<p><strong>{$a}</strong></p>
<p>Als je dit doet, kun je niet meer terug.</p>
<p>Ben je er er zeker van dat je deze server naar die versie wil upgraden?</p>';
$string['upgradetimedout'] = 'Er is een time-out opgetreden. Herstart de upgrade.';
$string['upgradingdata'] = 'Bezig met het upgraden van de gegevens';
$string['upgradinglogs'] = 'Bezig met upgraden van logs';
$string['upgradingversion'] = 'Upgraden naar nieuwe versie';
$string['upwards'] = 'hoger';
$string['useblogassociations'] = 'Associaties inschakelen';
$string['useexternalyui'] = 'Gebruik online YUI-libraries';
$string['user'] = 'Gebruiker';
$string['userbulk'] = 'Gebruikers in bulk beheren';
$string['userlist'] = 'Lijst';
$string['userpolicies'] = 'Gebruikersregels';
$string['userpreference'] = 'Gebruikersvoorkeur';
$string['userquota'] = 'Gebruikersquotum';
$string['users'] = 'Gebruikers';
$string['usesitenameforsitepages'] = 'Gebruik site naam voor site pagina\'s';
$string['usetags'] = 'Tags functionaliteit inschakelen';
$string['validateerror'] = 'Deze waarde is niet geldig';
$string['verifychangedemail'] = 'Beperk toegelaten domeinen bij het wijzigen van e-mailadres';
$string['warningcurrentsetting'] = 'Foute waarde: {$a}';
$string['warningiconvbuggy'] = 'Je versie van de iconv bibliotheek ondersteunt de //IGNORE modifier niet. Je moet de mbstring extentie installeren die in de plaats gebruikt kan worden om strings te zuiveren van ongeldige UTF-8 tekens';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Vul onderstaande opties in als je Moodle server niet rechtstreeks op internet kan. Internettoegang is nodig voor de download van geografische informatie, taalpakketten, RSS-feeds, tijdzones enz.<br /><em>Je kunt best de PHP cURL extentie installeren.</em>';
$string['xmlrpcrecommended'] = 'Het installeren van de optionele XMLRPC-extentie is nuttig voor de werking van Moodle Netwerk';
$string['yuicomboloading'] = 'YUI combo aan het laden';
$string['ziprequired'] = 'De ZIP-PHP-extentie is nu vereist voor Moodle. Info-ZIP en PclZip worden niet meer gebruikt.';
$string['zlibenabled'] = 'zlib ingeschakeld';
