<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   simplecertificate
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allusers'] = 'Alle Teilnehmer/innen';
$string['awardedsubject'] = 'Das ausgezeichnete Zertifikat: {$a->certificate} wurde ausgestellt für {$a->student}';
$string['awardedto'] = 'Verliehen an';
$string['bulkaction'] = 'Wähle Massenvorgang';
$string['bulkbuttonlabel'] = 'Senden';
$string['bulkview'] = 'Massenvorgänge';
$string['cantdeleteissue'] = 'Fehler beim Entfernen der ausgestellten Zertifikate';
$string['cantissue'] = 'Das Zertifikat kann nicht erteilt werden, da der Benutzer nicht die Aktivitätsanforderungen erfüllt';
$string['certificatecopy'] = 'Kopieren';
$string['certificateimage'] = 'Zertifikatsbilddatei';
$string['certificateimage_help'] = 'Das ist das Bild, das in dem Zertifikat verwendet wird';
$string['certificatename'] = 'Zertifikatsname';
$string['certificatename_help'] = 'Zertifikatsname';
$string['certificatenot'] = 'Die Instanz des einfachen Zertifikats wurde nicht gefunden';
$string['certificatetext'] = 'Zertifikatstext';
$string['certificatetext_help'] = 'Dies ist der Text, der im Zertifikat verwendet wird. Einige spezielle Wörter werden mit Variablen wie Kursname, Teinehmername, Klasse etc. ersetzt
Diese sind:
<ul>
<li>{USERNAME} -> vollständiger Benutzername</li
<li>{COURSENAME} -> vollständiger Kursname (oder definierter alternativer Kursname)</li
<li>{GRADE} -> formatierte Bewertung</li>
<li>{DATE} -> formatiertes Datum</li>
<li>{OUTCOME} -> Ergebnisse</li>
<li>{TEACHERS} -> Trainer/in-Liste</li>
<li>{IDNUMBER} -> ID Nummer der Nutzer/in</li>
<li>{FIRSTNAME} -> Vorname der Nutzer/in</li>
<li>{LASTNAME} -> Nachname der Nutzer/in</li>
<li>{EMAIL} -> Emailadresse der Nutzer/in</li>
<li>{ICQ} -> ICQ der Nutzer/in</li>
<li>{YAHOO} -> yahoo messenger der Nutzer/in</li>
<li>{AIM} ->AIM der Nutzer/in</li>
<li>{MSN} ->der Nutzer/in</li>
<li>{PHONE1} -> 1° Telefonnummer der Nutzer/in</li>
<li>{PHONE2} -> 2° Telefonnummer der Nutzer/in</li>
<li>{INSTITUTION} -> Institiution der Nutzer/in</li>
<li>{DEPARTMENT} -> Abteilung der Nutzer/in</li>
<li>{ADDRESS} -> Adresse der Nutzer/in</li>
<li>{CITY} ->Stadt der Nutzer/in</li>
<li>{COUNTRY} ->Land der Nutzer/in</li>
<li>{URL} ->Webseite des Nutzers</li>
<li>{CERTIFICATECODE} -> einmaliger Codetext des Zertifikats</li>
<li>{USERROLENAME} ->Rollename der Nutzer/in im Kurs </li>
<li>{TIMESTART} -> das Startdatum der Nutzereinschreibung im Kurs</li>
<li>{USERIMAGE} -> das Bild des Benutzersprofils</li>
<li>{USERRESULTS} ->Ergebnisse Bewertungen) der Nutzer/in in den anderen Kursen</li>
<li>{PROFILE_xxxx} -> Profilfelder der Nutzer/in</li>
</ul>
In Bereichen der benutzerdefinierte Profile wird "PORFILE_" als Prefix verwendet. Zum Beispiel: es wird ein Nutzerprofil mit dem Kurzname "birthday," erstellt, so dass auf dem Zertifikat {PROFILE_BIRTHDAY} erscheint.
Im Text können einfaches html, einfache Schriftarten und Tabellen verwendet werden, jedoch soll jegliche Definition der Position vermieden werden.';
$string['certificatetextx'] = 'Zertifikatstext horizontal positionieren';
$string['certificatetexty'] = 'Zertifikatstext vertikal positionieren';
$string['certificateverification'] = 'Verifizierung des Zertifikats';
$string['certlifetime'] = 'Bewahren Sie die ausgestellten Zertifikate: (in Monaten)';
$string['certlifetime_help'] = 'Dies spezifiziert die Aufbewahrungsfrist der ausgestellten Zertifikate. Die Zertifikate, deren Alter den angegebene Zeitraum überschreiten , werden automatisch gelöscht.';
$string['code'] = 'Code';
$string['codex'] = 'OQ Code des Zertifikates horizontal positionieren';
$string['codey'] = 'OQ Code des Zertifikates vertikal positionieren';
$string['completedusers'] = 'Nutzer/innen, die die Aktivitätsvoraussetzungen erfüllt haben';
$string['completiondate'] = 'Kursabschluss';
$string['coursegrade'] = 'Kursbewertung';
$string['coursename'] = 'Alternativer Kursname';
$string['coursename_help'] = 'Alternativer Kursname';
$string['coursenotfound'] = 'Der Kurs wurde nicht gefunden.';
$string['coursetimereq'] = 'Erforderliche Minuten im Kurs';
$string['coursetimereq_help'] = 'Geben Sie hier die Mindestzeit in Minuten an, die ein/e Teilnehmer/in im Kurs eingeloggt sein muss, bevor das Zertifikat ausgestellt werden kann.';
$string['datefmt'] = 'Datumsformat';
$string['datefmt_help'] = 'Geben Sie ein gültiges PHP Muster des Datumsformats (<a href="http://www.php.net/manual/en/function.strftime.php"> Date Formats</a>) an, oder lassen Sie es leer, um das Format der vom Nutzer gewählte Sprache zu verwenden';
$string['defaultcertificatetextx'] = 'Standardtext horizontal positionieren';
$string['defaultcertificatetexty'] = 'Standardtext vertikal positionieren';
$string['defaultcodex'] = 'Horizontaler Standard  der QR Codes positionieren';
$string['defaultcodey'] = 'Vertikaler Standard  der QR Codes positionieren';
$string['defaultheight'] = 'Standardhöhe';
$string['defaultperpage'] = 'Pro Seite';
$string['defaultperpage_help'] = 'Die Anzahl der Zertifikate, die pro Seite angezeigt werden (Max.200)';
$string['defaultwidth'] = 'Standardbreite';
$string['deletissuedcertificates'] = 'Löschen der ausgestellten Zertifikate';
$string['delivery'] = 'Übergabe';
$string['delivery_help'] = 'Wählen Sie hier, wie Sie das ausgestellte Zertifikat an Teilnehmer/innen übergeben möchten.
<ul>
<li>Öffnen im Browser: Es wird das Zertifikat in einem neuen Browserfenster geöffnet.</li>
<li>Automatischer Download: Es wird die Browser-Datei im Download-Fenster geöffnet.</li>
<li>Zertifikat per Email: Bei der Wahl dieser Option wird das Zertifikat für die Teilnehmer/innen per Email im Anhang gesendet</li>
<li>Nachdem der Benutzer seine Zertifikate bekommen hat, kann er auf den Zertifikatslink von der Kurswebseite klicken , um das Datum des erhaltenen Zertifikats zu sehen und zu überprüfen.</li>
</ul>';
$string['designoptions'] = 'Designoptionen';
$string['download'] = 'Automatischer Download';
$string['emailcertificate'] = 'Email';
$string['emailfrom'] = 'Email von Name';
$string['emailfrom_help'] = 'Ersatz für den Emailnamen';
$string['emailothers'] = 'Sonstige Emails';
$string['emailothers_help'] = 'Geben Sie hier die Email-Adresse (durch Kommata getrennt) von denen ein, die mit einer E-Mail benachrichtigt werden sollen, wenn Teilnehmer/innen Ihre Zertifikate erhalten.';
$string['emailsent'] = 'Die E-Mails wurden gesendet';
$string['emailstudentsubject'] = 'Ihr Zertifikate für {$a->course}';
$string['emailstudenttext'] = 'Hallo {$a->username},

		Beigefügt ist das Zertifikat für  {$a->course}.

DIES IST EINE AUTOMATISCHE NACHRICHT - BITTE ANTWORTEN SIE NICHT';
$string['emailteachermail'] = '{$a->student} hat Ihr Zertifikate erhalten: \'{$a->certificate}\'
für {$a->course}.

Sie können es hier überblicken:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} hat Ihr Zertifikate erhalten: \'<i>{$a->certificate}</i>\'
für {$a->course}.

Sie können es hier überblicken:

    <a href="{$a->url}">Zertifikatsbericht</a>.';
$string['emailteachers'] = 'Email vom Trainer';
$string['emailteachers_help'] = 'Wenn aktiv, werden die Trainer mit einer E-Mail benachrichtigt, wenn die Teilnehmer/innen Zertifikate erhalten.';
$string['enablesecondpage'] = 'Aktviert "Back Page" für das Zertifikat';
$string['enablesecondpage_help'] = 'Aktivieren Sie Zertifikat "Zurück Seite Ausgabe", wenn deaktiviert ist, nur Zertifikat QR-Code wird in Rückseite gedruckt werden (wenn der QR-Code aktiviert ist)';
$string['filenotfound'] = 'Datei nicht gefunden';
$string['getcertificate'] = 'Erhalte Zertifikat';
$string['grade'] = 'Bewertung';
$string['gradefmt'] = 'Bewertungsformat';
$string['gradefmt_help'] = 'Es gibt drei möglichWenn Sie sich entscheiden, eine Bewertung auf Das Zertifikat zu drucken, gibt es drei mögliche Formate:

<ul>
<li>Prozent-Bewertung: Druckt die Bewertung als Prozentsatz.</li>
<li>Punkt-Bewertung: Druckt die Bewertung als Punktwert.</li>
<li>Buchstaben-Bewertung: Druckt die Bewertung als Buchstaben.</li>
</ul>';
$string['gradeletter'] = 'Buchstaben-Bewertung';
$string['gradepercent'] = 'Prozent-Bewertung';
$string['gradepoints'] = 'Punkt-Bewertung';
$string['height'] = 'Zertifikatshöhe';
$string['hours'] = 'Stunden';
$string['intro'] = 'Einführung';
$string['invalidcode'] = 'Ungültiger Zertifikatscode';
$string['issued'] = 'Ausgestellt';
$string['issuedcertificatenotfound'] = 'Das ausgestellte Zertifikat wurde nicht gefunden';
$string['issueddate'] = 'Austellungsdatum';
$string['issueddownload'] = 'Das ausgestellte Zertifikat [id: {$a}] wurde heruntergeladen';
$string['issuedview'] = 'Ausgestellte Zertifikate';
$string['issueoptions'] = 'Ausstellungsoptionen';
$string['keywords'] = 'Zertifikat, Kurs, PDF, moodle';
$string['modulename'] = 'Einfaches Zertifikat';
$string['modulename_help'] = 'Das einfache Zertifikat-Aktivitätsmodul erlaubt der Tainer/in benutzerdefinierte Zertifikate zu erstellen, die an Teilnehmer/innen, die die spezifischen Anforderungen der Trainer/in erfüllen, ausgestellt werden können.';
$string['modulenameplural'] = 'Einfache Zertifikate';
$string['multipdf'] = 'Laden Sie Zertifikate in Zip-Dateien herunter';
$string['neverdeleteoption'] = 'Niemals löschen';
$string['nocertificatesissued'] = 'Es wurden keine Zertifikate ausgestellt.';
$string['nodelivering'] = 'Versand ist nicht möglich, die Nutzer/in erhält das Zertifikat auf anderem Wege.';
$string['onepdf'] = 'Zertifikate in einer PDF-Datei herunterladen';
$string['openbrowser'] = 'In neuem Fenster öffnen';
$string['opendownload'] = 'Klicken Sie auf das untere Feld, um das Zertifikat auf Ihrem Computer zu speichern.';
$string['openemail'] = 'Klicken Sie auf das untere Feld, um sich Ihr Zertifikat als E-Mail-Anhang schicken zu lassen.';
$string['openwindow'] = 'Klicken Sie auf das untere Feld, um Ihr Zertifikat in einem neuen Browserfenster zu öffnen.';
$string['pluginadministration'] = 'Zertifikats-Administration';
$string['pluginname'] = 'Einfaches Zertifikat';
$string['printdate'] = 'Druck-Datum';
$string['printdate_help'] = 'Das ist das Datum das gedruckt wird, wenn ein Druck-Datum ausgewählt wurde.';
$string['printgrade'] = 'Druckbewertung';
$string['printgrade_help'] = 'Sie können jedes verfügbare Kursbewertungs-Item aus dem Bewertungsbuch auswählen, um die Bewertung, die die Nutzer/in für dieses Item erhalten hat, auf das Zertifikat zu drucken. Die Bewertungs-Items sind in der Reihenfolge, in der Sie im Bewertungsbuch auftauchen angeordnet. Wählen Sie das Format der Bewertung unten aus.';
$string['printoutcome'] = 'Druckergebnis';
$string['printoutcome_help'] = 'Sie können jedes Kursergebnis auswählen, um den Namen des Ergebnisses und das Ergebnis, das die Nutzer/in erhalten hat, auf das Zertifikat drucken zu lassen. Ein Beispiel wäre: Arbeitsergebnis: Verhandlungssicher.';
$string['printqrcode'] = 'Druckzertifikat QR Code';
$string['printqrcode_help'] = 'Zertifikat (Druck optional) QR Code';
$string['qrcodefirstpage'] = 'QR Code in die erste Seite drucken';
$string['qrcodefirstpage_help'] = 'QR Code in die erste Seite drucken';
$string['qrcodeposition'] = 'Position des QR Codes im Zertifikat';
$string['qrcodeposition_help'] = 'Dies sind die XY Koordinaten (in Millimeter) des QR Codes für das Zertifikat';
$string['receiveddate'] = 'Datum erhalten';
$string['report'] = 'Bericht';
$string['requiredtimenotmet'] = 'YSie müssen wenigstens {$a->requiredtime} Minuten in diesem Kurs absolviert haben, um das Zertifikat zu erhalten';
$string['secondimage'] = 'Bilddatei für die Rückseite des Zertifikates';
$string['secondimage_help'] = 'Dies ist das Bild, das auf der Rückseite des Zertifikates verwendet wird';
$string['secondpageoptions'] = 'Rückseite des Zertifikates';
$string['secondpagetext'] = 'Text für die Rückseite des Zertifikates';
$string['secondpagex'] = 'Text für die Rückseite des Zertifikates, horizontal positioniert';
$string['secondpagey'] = 'Text für die Rückseite des Zertifikates, vertikal positioniert';
$string['secondtextposition'] = 'Postion des Textes auf der Rückseite des Zertifikates';
$string['secondtextposition_help'] = 'Dies sind die XY Koordinaten (in Millimetern) für den Text auf der Rückseitte des Zertifikates';
$string['sendtoemail'] = 'An E-Mailadresse der Nutzer/in senden';
$string['showusers'] = 'Zeigen';
$string['simplecertificate:addinstance'] = 'Einfache Zertifikataktivität hinzufügen';
$string['simplecertificate:manage'] = 'Einfache Zertifikataktivitäten managen';
$string['simplecertificate:view'] = 'Einfache Zertifikataktivität managen';
$string['size'] = 'Zertifikatsgröße';
$string['size_help'] = 'Dies ist die Breite und Höhe (in Millimetern) des Zertifikates, die Standargröße ist A4';
$string['standardview'] = 'Testzertifikat ausstellen';
$string['summaryofattempts'] = 'Zusammenfassung der bisher erhaltenen Zertifikate';
$string['textposition'] = 'Position des Zertifikattextes';
$string['textposition_help'] = 'Dies sind die XY Koordinaten (in Millimetern) des Zertifikattextes';
$string['timestartdatefmt'] = 'Das Datum der Einschreibung';
$string['timestartdatefmt_help'] = 'Geben Sie ein gültiges PHP Datumsmuster (<a href="http://www.php.net/manual/en/function.strftime.php"> Date Formats</a>)ein, oder lassen Sie dieses Feld frei, um das Format der von der Nuzer/in ausgewählten Sprachen zu benutzen.';
$string['upgradeerror'] = 'Fehler beim Upgraden von $a';
$string['usercontextnotfound'] = 'Nuzer/innen Kontext nicht gefunden';
$string['userdateformat'] = 'Nutzer/innensprache Datumsformat';
$string['usernotfound'] = 'Nutzer/in nicht gefunden';
$string['variablesoptions'] = 'Andere Optionen';
$string['verifycertificate'] = 'Zertifikat verifizeren';
$string['viewcertificateviews'] = 'Ausgeteilte Zertifikate ansehen {$a}';
$string['width'] = 'Zertifikatsweite';
