<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = 'Über Moodle Mobile';
$string['activity'] = 'Aktivität';
$string['add'] = 'Hinzufügen';
$string['addcontact'] = 'Als Kontakt hinzufügen';
$string['addedtoqueue'] = 'Offline: Der Vorgang wurde in die Warteschlage gesichert.';
$string['addfakenotifications'] = 'Fake-Mitteilungen hinzufügen';
$string['addnote'] = 'Hinweis hinzufügen';
$string['address'] = 'Adresse';
$string['addsite'] = 'Website hinzufügen';
$string['addsubmission'] = 'Abgabe hinzufügen';
$string['allcachesinvalidated'] = 'Alle Caches sind ungültig';
$string['allcachespurged'] = 'Cache gelöscht';
$string['allowsubmissionsfromdate'] = 'Abgaben erlauben von';
$string['appstoredescription'] = 'Die Moodle Mobile App funktioniert nur mit Moodle-Websites, wenn die mobilen Webservices freigeschaltet wurden. Bei Problemen kontaktieren Sie bitte Ihren Moodle-Administrator.

Wenn Ihr Moodle richtig konfiguriert wurde, können Sie die App für folgende Aufgaben verwenden:

- Kursinhalte durchblättern, auch wenn Sie offline sind
- Mitteilungen zu Nachrichten und Events empfangen
- Kontakt zu anderen Personen in Ihren Kursen aufnehmen
- Bilder, Audio, Videos und andere Dateien hochladen
- Ihre persönliche Bewertungsübersicht anzeigen
- und mehr!

Bitte lesen Sie aktuelle Informationen auf   http://docs.moodle.org/de/Mobile_app .

Über gute Kritiken und Ihre Anregungen würden wir uns freuen.


Die App benötigt folgende Systemrechte auf dem mobilen Gerät:
- Audio-, Foto- und Video-Aufnahme
- Lese- und Schreibzugriff auf die SD-Card
- Netzwerkzugriff
- Run at Startup, um Nachrichten im Hintergrund empfangen zu können
- Ruhemodus verhindern, um Push-Nachrichten jederzeit empfangen zu können';
$string['areyousurereset'] = 'Möchten Sie Moodle Mobile wirklich zurücksetzen? Alle gespeicherten Websites werden gelöscht.';
$string['attempnumber'] = 'Versuch Nr.';
$string['audionotavailable'] = 'Keine Audioeingabe vorhanden';
$string['audiorecordinstructions'] = 'Audiodatei aufnehmen und hochladen';
$string['authenticating'] = 'Wird authentifiziert...';
$string['author'] = 'Autor/in';
$string['average'] = 'Durchschnitt';
$string['back'] = 'Zurück';
$string['blockcontact'] = 'Kontakt blockieren';
$string['blockedusers'] = 'Blockierte Kontakte ({$a})';
$string['browsephotoalbums'] = 'Fotos';
$string['cacheexpirationtime'] = 'Cache-Dauer (Millisekunden)';
$string['cancel'] = 'Abbrechen';
$string['cannotaddnote'] = 'Kein Netzwerk: Der Hinweis wurde in der Warteschlange gespeichert und wird später gesendet.';
$string['cannotconnect'] = 'Keine Verbindung: Stellen Sie sicher, dass die URL richtig ist und dass mindestens Moodle 2.4 benutzt wird.';
$string['cannotconnectssl'] = 'Keine Verbindung: Stellen Sie sicher, dass die URL richtig ist und dass mindestens Moodle 2.4 und ein gültiges SSL-Zertifikat benutzt wird.';
$string['cannotsendmessage'] = 'Kein Netzwerk: Die Nachricht wurde in der Warteschlange gesichert und wird später gesendet.';
$string['chooseaccountuploadfile'] = 'Nutzerkonto für Dateiupload wählen';
$string['choosefile'] = 'Datei wählen';
$string['city'] = 'Stadt';
$string['close'] = 'Schließen';
$string['completed'] = 'Vollständig';
$string['confirmcontinuedownload'] = 'Möchten Sie die Datei wirklich herunterladen?';
$string['confirmdeletetask'] = 'Möchten Sie diesen Prozess wirklich löschen?';
$string['confirmuploadfile'] = 'Möchten Sie \'{$a}\' wirklich hochladen?';
$string['confirmuploadfiletosite'] = 'Möchten Sie die Datei wirklich hochladen auf \'{$a}\'?';
$string['contact'] = 'Kontakt';
$string['contactadd'] = 'Kontakt in die Kontaktliste hinzugefügt';
$string['contacts'] = 'Kontakte';
$string['content'] = 'Inhalt';
$string['contents'] = 'Inhalte';
$string['contentyetnotavailable'] = 'Diese Aktivität wird von Moodle Mobile nicht unterstützt.';
$string['continue'] = 'Fortsetzen';
$string['contributiontocoursetotal'] = 'Beitrag zum Kurs';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['coursename'] = 'Kursname';
$string['csssynced'] = 'CSS synchronisiert';
$string['cutoffdate'] = 'Stichtag';
$string['date'] = 'Datum';
$string['days'] = 'Tage';
$string['delete'] = 'Löschen';
$string['deletesite'] = 'Website wirklich entfernen?';
$string['deletesiteb'] = 'Website entfernen';
$string['deletesitefiles'] = 'Möchten Sie wirklich alle von dieser Website geladenen Dateien löschen?';
$string['description'] = 'Beschreibung';
$string['details'] = 'Details';
$string['development'] = 'Entwicklung';
$string['deviceinfo'] = 'Geräteinformation';
$string['disabled'] = 'Deaktiviert';
$string['disablenotificationforevent'] = 'Mitteilungen zu diesem Event deaktivieren';
$string['disablenotifications'] = 'Mitteilungen deaktivieren';
$string['disablerdebugger'] = 'Remote-Debugging deaktivieren';
$string['discussions'] = 'Themen';
$string['docsurl'] = 'http://docs.moodle.org/de/Mobile_app';
$string['downloadremotefile'] = 'Datei herunterladen';
$string['downloadtime'] = 'Heruntergeladen';
$string['duedate'] = 'Fälligkeitsdatum';
$string['duedateno'] = 'Kein Fälligkeitsdatum';
$string['email'] = 'E-Mail';
$string['empty'] = 'Leer';
$string['enableautosync'] = 'Auto-sync aktivieren';
$string['enableautosynccss'] = 'Synchronisation von CSS-Dateien';
$string['enableautosynclang'] = 'Synchronisation von Sprachdateien';
$string['enableautosyncws'] = 'Synchronisation von Anweisungen und Daten';
$string['enablecss3transitions'] = 'CSS3-Transitions';
$string['enabledebugging'] = 'Debugging';
$string['enableeventnotifications'] = 'Mitteilungen zu Events aktivieren';
$string['enablenotifications'] = 'Mitteilungen aktivieren';
$string['enablenotificationscheck'] = '<p>Prüfen Sie, ob Ihre Website mobile Mitteilungen unterstützt. Melden Sie in Ihrer Website an und öffnen Sie \'Einstellungen > Mein Profil > Mitteilungen\'. Wenn die mobilen Mitteilungen aktiviert sind, sollten Sie eine entsprechende Spalte sehen.</p>';
$string['enablenotificationswarning'] = '<p>Um die mobilen Mitteilungen zu nutzen, müssen Informationen über Ihr mobiles Endgerät in Moodle gespeichert sein. </p>';
$string['enablerdebugger'] = 'Remote-Debugging aktivieren';
$string['enablesyncwifi'] = 'Synchronisation nur bei Wifi erlauben';
$string['error'] = 'Fehler';
$string['errorcamera'] = 'Fehler beim Kamerazugriff';
$string['errorcameramsg'] = 'Das Gerät unterstützt keine Kamera.';
$string['errorcapturingaudio'] = 'Fehler bei der Audioaufnahme';
$string['errorcapturingvideo'] = 'Fehler bei der Videoaufnahme';
$string['errordownloading'] = 'Fehler beim Herunterladen der Datei';
$string['errorduringdevicetokenrequest'] = 'Fehler bei der Tokenanforderung des Geräts';
$string['errorduringdevicetokenrequesttoapns'] = 'Fehler bei der Tokenanforderung des Geräts an APNS';
$string['errorlistingfiles'] = 'Fehler bei der Dateiauflistung in diesem Verzeichnis';
$string['errornoconnectednocache'] = 'Das Gerät ist nicht verbunden. Informationen für die angeforderte Option sind nicht im Cache gespeichert.';
$string['errorreadingfile'] = 'Fehler beim Lesen der Datei \'{$a}\'';
$string['errorreceivefilenosites'] = 'Keine Websites gespeichert. Bitte wählen Sie eine Website und laden Sie die Datei dann hoch.';
$string['errorregisteringdeviceinmoodle'] = 'Fehler bei der Anmeldung des Geräts';
$string['errorretrievinggradeinformation'] = 'Fehler beim Abrufen der Bewertungsinformationen';
$string['erroruploading'] = 'Fehler beim Hochladen der Datei';
$string['estimatedfreespace'] = 'Verfügbarer Platz';
$string['events'] = 'Kalendereinträge';
$string['feedback'] = 'Feedback';
$string['file'] = 'Datei';
$string['filedownloaded'] = 'Datei heruntergeladen';
$string['filename'] = 'Dateiname';
$string['filesize'] = 'Größe';
$string['fileuploaded'] = 'Datei hochgeladen';
$string['fileuploadedwithname'] = 'Datei \'{$a}\' erfolgreich hochgeladen';
$string['fileurl'] = 'Datei-URL';
$string['forcecsssync'] = 'CSS synchronisieren';
$string['forceofflinemode'] = 'Verbindung unterbrechen';
$string['forumnodiscussionsyet'] = 'Keine Diskussionsthemen im Forum';
$string['forumnumreplies'] = 'Antworten';
$string['frontpage'] = 'Startseite';
$string['fullname'] = 'Vollständiger Name';
$string['general'] = 'Allgemein';
$string['grade'] = 'Bewertung';
$string['grades'] = 'Bewertungen';
$string['groupeventsnotdisplayed'] = 'Gruppentermine werden nicht angezeigt';
$string['help'] = 'Hilfe';
$string['helpmelogin'] = '<p>Diese App kann sich nur mit Moodle-Websites verbinden, für die der mobile Zugriff aktiviert wurde.</p>
<p>Wenn Sie sich mit der App nicht verbinden können, kontaktieren Sie den Administrator der Website. <a href=\'http://docs.moodle.org/de/Mobile_App\' target=\'_blank\'>http://docs.moodle.org/de/Mobile_App</a>.</p>
<p>Um die App mit einer Demo-Website zu testen, tragen Sie bitte <i>teacher</i> oder <i>student</i> in das Feld <i>URL der Website</i> ein und klicken Sie auf <b>Hinzufügen</b>.</p>';
$string['hours'] = 'Stunden';
$string['icantlogin'] = 'Hilfe anzeigen';
$string['imagestored'] = 'Das Bild wurde in \'Meine Dateien\' gesichert.';
$string['info'] = 'Info';
$string['initializing'] = 'Wird initialisiert...';
$string['invalidaccount'] = 'Prüfen Sie Ihre Anmeldedaten oder wenden Sie sich an den Administrator.';
$string['invalidmoodleversion'] = 'Notwendig ist mindestens die Moodle-Version:';
$string['invalidscheme'] = 'Bitte geben Sie eine gültige URL an.';
$string['invalidsite'] = 'Die URL der Website ist falsch.';
$string['itemname'] = 'Bewertungselement';
$string['keepsynchronising'] = 'Beiträge mit dem Server synchronisieren';
$string['language'] = 'Sprache';
$string['lettergrade'] = 'Buchstabenwertung';
$string['license'] = 'Lizenz';
$string['loadcordovaemulator'] = 'Cordova-Emulator laden';
$string['loading'] = 'Wird geladen...';
$string['localpath'] = 'Lokaler Pfad';
$string['location'] = 'Ort';
$string['logininsiterequired'] = 'Sie müssen sich für diese Website im Browser anmelden.';
$string['logout'] = 'Abmelden';
$string['lostconnection'] = 'Verbindung unterbrochen. Ihr Token ist jetzt ungültig.';
$string['manageaccounts'] = 'Konten verwalten';
$string['message'] = 'Nachricht';
$string['messages'] = 'Nachrichten';
$string['messagesent'] = 'Nachricht gesendet';
$string['minutes'] = 'Minuten';
$string['mobileservicesnotenabled'] = 'Mobile Webservices sind für diese Website nicht aktiviert. Bitte kontaktieren Sie Ihren Administrator, wenn Sie den mobilen Zugriff aktiviert haben möchten.';
$string['modulename'] = 'Modulname';
$string['months'] = 'Monate';
$string['moodlehelp'] = 'Hilfe';
$string['mycourses'] = 'Meine Kurse';
$string['myfiles'] = 'Meine Dateien';
$string['name'] = 'Name';
$string['networkerror'] = 'Kein Netzwerk';
$string['networkerrormsg'] = 'Kein Netzwerk oder Fehler';
$string['next'] = 'Weiter';
$string['no'] = 'Nein';
$string['noevents'] = 'Keine Events';
$string['nomessagesfound'] = 'Keine Nachrichten';
$string['norefreshdisconnected'] = 'Die Option \'Aktualisieren\' erfordert eine Netzwerkverbindung.';
$string['notaskstobesynchronized'] = 'Kein Prozess zum Synchronisieren';
$string['noteadded'] = 'Hinweis hinzugefügt';
$string['noticelargefile'] = 'Die Datei ist sehr groß. Das Herunterladen wird einige Zeit dauern.';
$string['notificationpreferencesnotconfigured'] = 'Die Einstellungen für mobile Mitteilungen sind nicht konfiguriert. Melden Sie sich mit einem Browser auf der Website an und ändern Sie die Einstellungen für die \'Mitteilungen\' in Ihrem Nutzerprofil.';
$string['notifications'] = 'Mitteilungen';
$string['notificationsdisabled'] = 'Mitteilungen sind deaktiviert';
$string['notificationsenabled'] = 'Mitteilungen für alle Ihre Moodle aktiviert';
$string['nousersfound'] = 'Keine Nutzer/innen';
$string['offlinecontacts'] = 'Kontakte offline ({$a})';
$string['offlinemode'] = 'Offline';
$string['ok'] = 'OK';
$string['onlinecontacts'] = 'Kontakte online ({$a})';
$string['openinbrowser'] = 'Im Browser öffnen';
$string['others'] = 'Andere';
$string['participant'] = 'Person';
$string['participants'] = 'Personen';
$string['password'] = 'Kennwort';
$string['passwordlabel'] = 'Kennwort';
$string['passwordnotnull'] = 'Bitte geben Sie Ihr Kennwort ein.';
$string['passwordrequired'] = 'Kennwort notwendig';
$string['percentage'] = 'Prozentsatz';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobil';
$string['pluginname'] = 'Texte für Moodle Mobile';
$string['preview'] = 'Vorschau';
$string['previous'] = 'Zurück';
$string['privatefiles'] = 'Meine Dateien';
$string['purgecaches'] = 'Cache löschen';
$string['range'] = 'Bandbreite';
$string['rank'] = 'Rang';
$string['rdebuggingenabledfor'] = 'Remote-Debugging ist für Sekunden aktiviert:';
$string['readingfile'] = 'Datei wird gelesen';
$string['record'] = 'Aufnahme';
$string['recordaudio'] = 'Audio';
$string['recordstored'] = 'Die Aufnahme wurde in \'Meine Dateien\' gesichert.';
$string['remotesystemnotconfiguredfornotifications'] = 'Diese Website ist nicht für das Senden von mobilen Mitteilungen konfiguriert. Wenden Sie sich an Ihren Administrator, falls Sie die mobilen Mitteilungen aktiviert haben möchten.';
$string['removecontact'] = 'Kontakt entfernen';
$string['replay'] = 'Wiederholung';
$string['reply'] = 'Antworten';
$string['reportabug'] = 'Fehler melden';
$string['reportbuginfo'] = 'Tippen Sie auf die Taste \'Fehlerbericht\', um weitere Anleitungen zu bekommen.';
$string['reportbugurl'] = 'https://docs.moodle.org/en/Moodle_Mobile#How_to_report_a_bug';
$string['requiredfields'] = 'Alle Pflichtfelder müssen ausgefüllt werden.';
$string['reset'] = 'Zurücksetzen';
$string['resetapp'] = 'App zurücksetzen';
$string['save'] = 'Sichern';
$string['saving'] = 'Wird gesichert...';
$string['seconds'] = 'Sekunden';
$string['select'] = 'Auswählen';
$string['selectsite'] = 'Website auswählen';
$string['send'] = 'Senden';
$string['sendall'] = 'Alles senden';
$string['sendmessage'] = 'Nachricht senden';
$string['sendnow'] = 'Senden';
$string['settings'] = 'Einstellungen';
$string['showall'] = 'Alles anzeigen';
$string['showlog'] = 'Logdaten anzeigen';
$string['showmore'] = 'Mehr anzeigen';
$string['siteexists'] = 'Diese Website ist bereits vorhanden.';
$string['sitefiles'] = 'Dateien';
$string['siteinmaintenance'] = 'Die Website ist im Wartungsmodus.';
$string['sitename'] = 'Name der Website';
$string['sites'] = 'Websites';
$string['siteurl'] = 'URL der Website';
$string['siteurllabel'] = 'URL der Website';
$string['siteurlrequired'] = 'Die URL der Website ist notwendig, z.B. https://meinmoodle.de';
$string['spaceusage'] = 'Speicherplatz';
$string['stop'] = 'Stopp';
$string['strings'] = 'Texte';
$string['submissions'] = 'Einsendungen';
$string['synchronization'] = 'Synchronisation';
$string['syncthistasknow'] = 'Prozess synchronisieren';
$string['system'] = 'System';
$string['takephoto'] = 'Foto aufnehmen';
$string['takepicture'] = 'Kamera';
$string['taskqueue'] = 'Warteschlange';
$string['therearentnotificationsyet'] = 'Keine Mitteilungen vorhanden';
$string['threemonthsmore'] = 'Weitere 3 Monate anzeigen';
$string['timecreated'] = 'Termin hinzugefügt';
$string['timeduration'] = 'Zeitdauer';
$string['timemodified'] = 'Zuletzt geändert';
$string['timestart'] = 'Beginn';
$string['total'] = 'Gesamt';
$string['totalusage'] = 'Gesamtnutzung';
$string['type'] = 'Typ';
$string['unblockcontact'] = 'Kontakt freigeben';
$string['unexpectederror'] = 'Unbekannter Fehler! Beenden Sie die App und versuchen Sie es dann noch einmal.';
$string['update'] = 'Aktualisieren';
$string['updatesite'] = 'Website aktualisieren';
$string['upload'] = 'Hochladen';
$string['uploadfile'] = 'Datei hochladen';
$string['uploadfileinstructions'] = 'Um eine Datei hochzuladen, tippen Sie auf die Taste und wählen Sie die Datei aus.';
$string['uploading'] = 'Wird hochgeladen...';
$string['uploadingtoprivatefiles'] = 'Wird in \'Meine Dateien\' hochgeladen...';
$string['uselocalmobileplugin'] = 'Diese Website funktioniert besser, wenn das optionale Plugin \'Moodle Mobile - Zusatzfeatures\' installiert ist.';
$string['userfrom'] = 'Von';
$string['username'] = 'Anmeldename';
$string['usernamelabel'] = 'Anmeldename';
$string['usernamerequired'] = 'Anmeldename notwendig';
$string['video'] = 'Video';
$string['videofilenameprefix'] = 'mobile-video';
$string['videostored'] = 'Das Video wurde in \'Meine Dateien\' gesichert.';
$string['view'] = 'Anzeigen';
$string['viewableonthisapp'] = 'Anzeige in der App';
$string['viewsubmission'] = 'Einsendung anzeigen';
$string['warning'] = 'Warnung';
$string['webservicesnotenabled'] = 'Webservices sind für diese Website nicht aktiviert. Bitte sprechen Sie mit Ihrem Administrator, wenn Sie den mobilen Zugriff aktiviert haben möchten.';
$string['webservicesuccessfullyexecuted'] = 'Webservice erfolgreich ausgeführt';
$string['website'] = 'Website';
$string['weight'] = 'Gewichtung';
$string['welcome'] = 'Willkommen bei Moodle Mobile';
$string['writeherethebug'] = 'Beschreiben Sie das Problem bitte möglichst genau.';
$string['years'] = 'Jahre';
$string['yes'] = 'Ja';
$string['youarein'] = 'Sie sind in:';
$string['yourpassword'] = 'Kennwort';
$string['yoursiteurl'] = 'https://meinmoodle.de';
$string['yourusername'] = 'Anmeldename';
