<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Zugriffssteuerung';
$string['actionaftercorrectanswer'] = 'Aktion nach richtiger Antwort';
$string['actionaftercorrectanswer_help'] = 'Nachdem eine Frage richtig beantwortet wurde, gibt es 3 Optionen für eine Fortsetzung:

* Normal - dem Pfad der Lektion folgen
* Ungesehene Seite zeigen - die Seiten werden in zufälliger Reihenfolge gezeigt, ohne eine Seite doppelt aufzurufen
* Unbeantwortete Seite zeigen - die Seiten werden in zufälliger Reihenfolge gezeigt, wobei Seiten mit unbeantworteten Fragen auch nochmal aufgerufen werden
';
$string['actions'] = 'Aktionen';
$string['activitylink'] = 'Folgeaktivität';
$string['activitylink_help'] = 'Um einen Link am Ende der Lektion zu einer weiteren Aktivität im Kurs einzufügen, wählen Sie die Aktivität aus dem  Auswahlmenü.';
$string['activitylinkname'] = 'Zu \'{$a}\' gehen';
$string['activityoverview'] = 'Eine oder mehrere Lektionen sind fällig';
$string['addabranchtable'] = 'Inhaltsseite einfügen';
$string['addanendofbranch'] = 'Verzweigungsende einfügen';
$string['addanewpage'] = 'Neue Seite einfügen';
$string['addaquestionpage'] = 'Frageseite einfügen';
$string['addaquestionpagehere'] = 'Frageseite hier einfügen';
$string['addbranchtable'] = 'Inhaltsseite einfügen';
$string['addcluster'] = 'Cluster einfügen';
$string['addedabranchtable'] = 'Inhaltsseite eingefügt';
$string['addedanendofbranch'] = 'Verzweigungsende eingefügt';
$string['addedaquestionpage'] = 'Fragenseite eingefügt';
$string['addedcluster'] = 'Cluster eingefügt';
$string['addedendofcluster'] = 'Clusterende eingefügt';
$string['addendofcluster'] = 'Clusterende einfügen';
$string['addpage'] = 'Seite einfügen';
$string['anchortitle'] = 'Start des Hauptinhalts';
$string['and'] = 'UND';
$string['answer'] = 'Antwort';
$string['answeredcorrectly'] = 'der Zuordnungen waren richtig';
$string['answersfornumerical'] = 'Bei numerischen Fragen können ein Minimal- und ein Maximalwert als richtige Lösung angegeben werden.';
$string['arrangebuttonshorizontally'] = 'Verzweigungstasten horizontal anordnen?';
$string['attempt'] = 'Versuch: {$a}';
$string['attempts'] = 'Versuche';
$string['attemptsdeleted'] = 'Versuche gelöscht';
$string['attemptsremaining'] = 'Verbleibende Versuche: {$a}';
$string['available'] = 'Verfügbar ab';
$string['averagescore'] = 'Durchschnittliche Bewertung';
$string['averagetime'] = 'Durchschnittliche Zeit';
$string['branch'] = 'Inhalt';
$string['branchtable'] = 'Inhaltsseite';
$string['cancel'] = 'Abbrechen';
$string['cannotfindanswer'] = 'Fehler: Antwort konnte nicht gefunden werden';
$string['cannotfindattempt'] = 'Fehler: Versuch konnte nicht gefunden werden';
$string['cannotfindessay'] = 'Fehler: Freitext-Antwort konnte nicht gefunden werden';
$string['cannotfindfirstgrade'] = 'Fehler: Bewertungen konnten nicht gefunden werden';
$string['cannotfindfirstpage'] = 'Erste Seite konnte nicht gefunden werden';
$string['cannotfindgrade'] = 'Fehler: Bewertungen konnten nicht gefunden werden';
$string['cannotfindnewestgrade'] = 'Fehler: Aktuelle Bewertung konnte nicht gefunden werden';
$string['cannotfindnextpage'] = 'Lektionssicherung: Nächste Seite wurde nicht gefunden!';
$string['cannotfindpagerecord'] = 'Verzweigungsende hinzufügen: Seitendaten wurden nicht gefunden';
$string['cannotfindpages'] = 'Lektionsseiten konnten nicht gefunden werden';
$string['cannotfindpagetitle'] = 'Löschen bestätigen: Seitentitel wurde nicht gefunden';
$string['cannotfindpreattempt'] = 'Vorheriger Versuch konnte nicht gefunden werden!';
$string['cannotfindrecords'] = 'Fehler: Lektionsdaten konnten nicht gefunden werden';
$string['cannotfindtimer'] = 'Fehler: Die Daten lesson_timer konnten nicht gefunden werden';
$string['cannotfinduser'] = 'Fehler: Nutzer/innen konnten nicht gefunden werden';
$string['canretake'] = 'Wiederholungen';
$string['casesensitive'] = 'Reguläre Ausdrücke verwenden';
$string['casesensitive_help'] = 'Wenn diese Option aktiviert ist, werden reguläre Ausdrücke für die Auswertung der Antworten verwendet';
$string['checkbranchtable'] = 'Inhaltsseite testen';
$string['checkedthisone'] = 'Diese wurde geprüft.';
$string['checknavigation'] = 'Navigation testen';
$string['checkquestion'] = 'Frage testen';
$string['classstats'] = 'Statistik';
$string['clicktodownload'] = 'Klicken Sie auf den Link, um die Datei herunter zu laden.';
$string['clicktopost'] = 'Klicken Sie hier, um Ihre Bewertung auf der Bestenliste zu veröffentlichen.';
$string['cluster'] = 'Cluster';
$string['clusterjump'] = 'Ungesehene Frage innerhalb des Clusters';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Kurzform';
$string['comments'] = 'Ihr Feedback';
$string['completed'] = 'Abgeschlossen';
$string['completederror'] = 'Lektion abschließen';
$string['completethefollowingconditions'] = 'Sie müssen die folgende(n) Bedingung(en) in der Lektion <b>{$a}</b> erfüllen, um fortfahren zu dürfen:';
$string['conditionsfordependency'] = 'Bedingungen für Abhängigkeit';
$string['configactionaftercorrectanswer'] = 'Standardaktion nach einer richtigen Antwort';
$string['configmaxanswers'] = 'Maximale Anzahl von Antworten pro Seite';
$string['configmaxhighscores'] = 'Länge der Bestenliste';
$string['configmediaclose'] = 'Taste \'Schließen\' im Popup-Fenster für eine verlinkte Mediendatei anzeigen';
$string['configmediaheight'] = 'Höhe des Popup-Fensters für eine verlinkte Mediendatei';
$string['configmediawidth'] = 'Breite des Popup-Fensters für eine verlinkte Mediendatei';
$string['configslideshowbgcolor'] = 'Hintergrundfarbe der Slideshow, falls sie aktiviert ist';
$string['configslideshowheight'] = 'Höhe der Slideshow, falls sie aktiviert ist';
$string['configslideshowwidth'] = 'Breite der Slideshow, falls sie aktiviert ist';
$string['confirmdelete'] = 'Seite löschen';
$string['confirmdeletionofthispage'] = 'Diese Seite löschen?';
$string['congratulations'] = 'Ende der Lektion.';
$string['continue'] = 'Fortsetzen';
$string['continuetoanswer'] = 'Weitere Antworten ändern';
$string['continuetonextpage'] = 'Auf der nächsten Seite fortsetzen';
$string['correctanswerjump'] = 'Sprung bei richtiger Antwort';
$string['correctanswerscore'] = 'Bewertung bei richtiger Antwort';
$string['correctresponse'] = 'Feedback bei richtiger Antwort';
$string['createaquestionpage'] = 'Fragenseite anlegen';
$string['credit'] = 'Bewertung';
$string['customscoring'] = 'Standardbewertung (Punkte)';
$string['customscoring_help'] = 'Wenn diese Option aktiviert ist, kann jede Antwort mit einer numerischen Punktzahl zu versehen werden, wobei auch negative Punkte möglich sind.';
$string['deadline'] = 'Verfügbar bis';
$string['defaultessayresponse'] = 'Die Freitext-Antwort wird später bewertet.';
$string['deleteallattempts'] = 'Alle Versuche der Lektion löschen';
$string['deletedefaults'] = '{$a} x Lektionen gelöscht';
$string['deletedpage'] = 'Seite gelöscht';
$string['deleting'] = 'Lösche';
$string['deletingpage'] = 'Lösche Seite {$a}';
$string['dependencyon'] = 'Abhängigkeit von anderen Lektionen';
$string['dependencyon_help'] = 'Diese Option ermöglicht es, den Zugriff auf diese Lektion vom Ergebnis einer anderen Lektion innerhalb des Kurses abhängig zu machen. Dabei ist jede Kombination aus den Faktoren \'aufgewendete Zeit\', \'abgeschlossen\' oder \'Bewertung besser als\' möglich.';
$string['description'] = 'Beschreibung';
$string['detailedstats'] = 'Ergebnisanalyse';
$string['didnotanswerquestion'] = 'Hat diese Frage nicht beantwortet.';
$string['didnotreceivecredit'] = 'Hat keine Bewertung erhalten';
$string['displaydefaultfeedback'] = 'Standardfeedback benutzen';
$string['displaydefaultfeedback_help'] = '<h2>Standardrückmeldung anzeigen</h2>

<p>Bei der Einstellung <strong>Ja</strong> wird die Standardrückmeldung (Richtig/Falsch) angezeigt, sofern keine individuelle Rückmeldung vorhanden ist.</p>
<p>Bei der Einstellung <strong>Nein</strong> wird keine Rückmeldung angezeigt, sofern keine individuelle Rückmeldung vorhanden ist. Die Teilnehmer/innen werden dann automatisch zur nächsten Seite der Lektion geführt. </p>';
$string['displayhighscores'] = 'High Scores anzeigen';
$string['displayinleftmenu'] = 'Im linken Seitenmenü anzeigen?';
$string['displayleftif'] = 'Menü nur anzeigen, wenn die Bewertung höher ist als';
$string['displayleftif_help'] = 'Diese Einstellung legt fest, ob eine bestimmte Bewertung erreicht sein muss, bevor das linke Seitenmenü sichtbar wird. Dies zwingt die Teilnehmer/innen dazu, bei ihren ersten Versuchen durch die gesamte Lektion zu gehen. Erst nach dem Erreichen einer bestimmten Punktzahl kann das linke Seitenmenü benutzet werden, um sich die Lösungen nochmals anzuschauen.';
$string['displayleftmenu'] = 'Linkes Seitenmenü anzeigen';
$string['displayleftmenu_help'] = 'Wenn diese Option aktiviert ist, wird am linken Rand ein Seitenmenü mit der Liste aller Inhaltsseiten angezeigt.';
$string['displayofgrade'] = 'Anzeige der Bewertungen (für Teilnehmer/innen)';
$string['displayreview'] = 'Wiederholung bei falscher Antwort';
$string['displayreview_help'] = 'Diese Option zeigt nach einer falsch beantworteten Frage eine Taste, mit der die Teilnehmer/innen zur Frage zurückgehen und diese noch einmal antworten können.';
$string['displayscorewithessays'] = '<p>Sie haben bisher {$a->score} von {$a->tempmaxgrade} Punkten für die automatisch bewerteten Fragen erzielt.</p><p> Die Freitext-Aufgaben ({$a->essayquestions}) werden später bewertet und zur Gesamtpunktzahl hinzugefügt .</p><p>Ihre derzeitige Bewertung:  {$a->score} von {$a->grade} Punkten.</p>';
$string['displayscorewithoutessays'] = 'Ihre Bewertung:  {$a->score} von {$a->grade} Punkten';
$string['edit'] = 'Bearbeiten';
$string['editingquestionpage'] = 'Frageseite {$a} bearbeiten';
$string['editlessonsettings'] = 'Einstellungen für Lektion bearbeiten';
$string['editpage'] = 'Seite bearbeiten';
$string['editpagecontent'] = 'Inhalt der Seite bearbeiten';
$string['email'] = 'E-Mail';
$string['emailallgradedessays'] = 'E-Mail an alle versenden, deren Freitexte bewertet wurden';
$string['emailgradedessays'] = 'E-Mail mit Freitext-Bewertung versenden';
$string['emailsuccess'] = 'E-Mails erfolgreich gesendet';
$string['emptypassword'] = 'Das Kennwort muss eingegeben werden';
$string['endofbranch'] = 'Verzweigungsende';
$string['endofcluster'] = 'Clusterende';
$string['endofclustertitle'] = 'Clusterende';
$string['endoflesson'] = 'Ende der Lektion';
$string['enteredthis'] = 'der Antworten';
$string['entername'] = 'Geben Sie einen Aliasnamen (nickname) für die Bestenliste ein.';
$string['enterpassword'] = 'Bitte geben Sie das Kennwort ein:';
$string['eolstudentoutoftime'] = 'Achtung: Die verfügbare Zeit ist abgelaufen. Die letzte Frage wird nicht bewertet, wenn die Antwort nach Zeitablauf abgegeben wurde.';
$string['eolstudentoutoftimenoanswers'] = 'Sie haben keine Fragen beantwortet. Sie erhalten daher 0 Punkte für die Lektion.';
$string['essay'] = 'Freitext';
$string['essayemailmessage'] = '<p>Freitextfrage: <blockquote>{$a->question}</blockquote></p>
<p>Ihre Freitext-Antwort: <blockquote><em>{$a->response}</em></blockquote></p>
<p>Feedback von {$a->teacher}: <blockquote><em>{$a->comment}</em></blockquote></p>
<p>Sie haben {$a->earned} Punkte von {$a->outof} Punkten für Ihre Freitext-Antwort erhalten.</p>
<p>Ihre aktuelle Bewertung für diese Lektion ist nun {$a->newgrade}.</p>';
$string['essayemailmessage2'] = '<p>Freitextfrage:<blockquote>{$a->question}</blockquote></p><p>Ihre Antwort:<blockquote><em>{$a->response}</em></blockquote></p><p>Feedback von Trainer/in:<blockquote><em>{$a->comment}</em></blockquote></p><p>Sie haben {$a->earned} Punkte von {$a->outof} möglichen Punkten für diese Frage erhalten.</p><p>Ihre aktuelle Bewertung für diese Frage ist nun {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'Freitext-Bewertung für {$a}';
$string['essays'] = 'Freitexte';
$string['essayscore'] = 'Freitext-Bewertung';
$string['fileformat'] = 'Dateiformat';
$string['finish'] = 'Fertigstellen';
$string['firstanswershould'] = 'Die erste Antwort sollte zur Seite mit der Antwort "richtig" verzweigen';
$string['firstwrong'] = 'Ihre Antwort ist falsch. Wollen Sie noch einmal (ohne Bewertung) wiederholen?';
$string['flowcontrol'] = 'Ablaufkontrolle';
$string['full'] = 'Erweitert';
$string['general'] = 'Grundeinstellungen';
$string['gotoendoflesson'] = 'Zum Lektionende gehen';
$string['grade'] = 'Relative Bewertung';
$string['gradebetterthan'] = 'Bewertung besser als (%)';
$string['gradebetterthanerror'] = 'Bewertung muss besser als {$a} Prozent sein';
$string['gradeessay'] = 'Freitextfragen bewerten ({$a->notgradedcount} - nicht bewertet, {$a->notsentcount} - nicht gesendet)';
$string['gradeis'] = 'Ihre Bewertung: {$a}';
$string['gradeoptions'] = 'Bewertung';
$string['handlingofretakes'] = 'Bewertung bei Wiederholungen';
$string['handlingofretakes_help'] = '<h2>Bewertung bei Wiederholungen</h2>
<p>Wenn die Teilnehmer/innen eine Lektion wiederholen dürfen, kann die
Bewertung entweder als Durchnittsnote
oder als Bestnote aller Versuche eines Teilnehmenden erfolgen.</p>
<p>Diese Option kann jederzeit geändert werden.</p>';
$string['havenotgradedyet'] = 'Noch nicht bewertet';
$string['here'] = 'hier';
$string['highscore'] = 'Beste Bewertung';
$string['highscores'] = 'Beste Bewertung';
$string['hightime'] = 'Beste Zeit';
$string['importcount'] = '{$a} Fragen importieren';
$string['importquestions'] = 'Fragen importieren';
$string['importquestions_help'] = 'Diese Option ermöglicht den Import von Fragen in unterschiedlichen Formaten über eine Textdatei.';
$string['insertedpage'] = 'Seite eingefügt';
$string['invalidfile'] = 'Ungültige Datei';
$string['invalidid'] = 'Keine Kursmodul-ID oder Lektions-ID angegeben';
$string['invalidlessonid'] = 'Falsche Lektions-ID';
$string['invalidpageid'] = 'Ungültige Seiten-ID';
$string['jump'] = 'Sprung';
$string['jumps'] = 'Sprünge';
$string['jumps_help'] = 'Jede Antwort (bei Fragen) oder jede Beschreibung (bei Inhaltsseiten) besitzt einen zugehörigen Sprung. Der Sprung kann relative sein, z.B. zu dieser Seite oder zur nächsten Seite führen. Oder der Sprung kann absolut sein, wobei dann jede Seite in der Lektion angesteuert werden kann';
$string['jumpsto'] = 'Sprung zu <em>{$a}</em>';
$string['leftduringtimed'] = 'Sie haben die Lektion abgebrochen. Die Bearbeitung der Lektion ist zeitlich begrenzt. <br />Klicken Sie auf Fortsetzen, um die Lektion erneut zu beginnen.';
$string['leftduringtimednoretake'] = 'Sie haben die Lektion abgebrochen. Die Bearbeitung der Lektion ist zeitlich begrenzt. <br />Sie können diese Lektion nicht mehr bearbeiten.';
$string['leftduringtimedsession'] = 'Sie haben eine zeitbegrenzte Lektion abgebrochen..';
$string['lesson:addinstance'] = 'Lektion hinzufügen';
$string['lessonattempted'] = 'Lektion wurde versucht';
$string['lessonclosed'] = 'Die Lektion war verfügbar bis {$a}';
$string['lessoncloses'] = 'Verfügbarkeit der Lektion endet';
$string['lessoncloseson'] = 'Verfügbarkeit der Lektion endet: {$a}';
$string['lesson:edit'] = 'Lektion bearbeiten';
$string['lessonformating'] = 'Lektion wird formatiert';
$string['lesson:manage'] = 'Lektion verwalten';
$string['lessonmenu'] = 'Seitenmenü';
$string['lessonnotready'] = 'Diese Lektion ist noch nicht verfügbar. Nehmen Sie bitte mit {$a} Kontakt auf.';
$string['lessonnotready2'] = 'Diese Lektion kann noch nicht bearbeitet werden.';
$string['lessonopen'] = 'Diese Lektion ist ab {$a} verfügbar.';
$string['lessonopens'] = 'Lektion verfügbar';
$string['lessonpagelinkingbroken'] = 'Die erste Seite wurde nicht gefunden. Die Verlinkung der Seite weist einen Fehler auf. Sprechen Sie den Administrator an.';
$string['lessonstats'] = 'Statistik';
$string['linkedmedia'] = 'Verlinkte Medien';
$string['loginfail'] = 'Der Login ist gescheitert. Bitte versuchen Sie es noch einmal.';
$string['lowscore'] = 'Schlechteste Bewertung';
$string['lowtime'] = 'Schlechteste Zeit';
$string['manualgrading'] = 'Freitext-Bewertung';
$string['matchesanswer'] = 'Zugeordnete Antwort';
$string['matching'] = 'Zuordnung';
$string['matchingpair'] = 'Passendes Paar {$a}';
$string['maxgrade'] = 'Maximale Bewertung';
$string['maxgrade_help'] = 'Dieser Wert bestimmt die maximale Bewertung für die Lektion. Wenn Sie diesen Wert auf 0 setzen, erscheint die Lektion in der Bewertungsübersicht.';
$string['maxhighscores'] = 'Länge der Bestenliste';
$string['maximumnumberofanswersbranches'] = 'Höchstzahl der Antworten
';
$string['maximumnumberofanswersbranches_help'] = 'Dieser Wert legt fest, wie viele Antworten bzw. Verzweigungen in der Lektion pro Frage benutzt werden dürfen. Wenn ausschließlich Wahr/Falsch-Fragen vorkommen, kann der Wert auf 2 gesetzt werden. Die Einstellung kann jederzeit geändert werden. Eingegebene Daten werden bei der Änderung nicht berührt.';
$string['maximumnumberofattempts'] = 'Höchstzahl der Versuche';
$string['maximumnumberofattempts_help'] = 'Dieser Wert legt die Zahl der maximal zulässigen Versuche für jede einzelne Frage fest. Wenn die Höchstzahl der zulässigen Versuche erreicht ist, wird automatisch die nächste Seite der Lektion angezeigt.';
$string['maximumnumberofattemptsreached'] = 'Sie haben die Höchstzahl der Versuche erreicht - weiter zur nächsten Seite';
$string['maxtime'] = 'Zeitbegrenzung (Minuten)';
$string['maxtimewarning'] = 'Sie haben noch {$a} Minute(n), um die Lektion zu beenden.';
$string['mediaclose'] = 'Schließen-Taste:';
$string['mediafile'] = 'Datei-Popup';
$string['mediafile_help'] = 'Um ein Popup-Fenster für eine Mediendatei in eine Lektion einzufügen, wählen Sie die anzuzeigende Datei aus. Jede Lektionsseite enthält dann einen Link zum Öffnen des Popup-Fensters.';
$string['mediafilepopup'] = 'Link zur Mediendatei';
$string['mediaheight'] = 'Höhe des Popup-Fensters:';
$string['mediawidth'] = 'Breite des Popup-Fensters:';
$string['messageprovider:graded_essay'] = 'Mitteilung zur Freitextbewertung';
$string['minimumnumberofquestions'] = 'Mindestzahl der Fragen';
$string['minimumnumberofquestions_help'] = 'Dieser Wert legt eine untere Grenze für die Anzahl an Fragen fest, die in die Bewertung der Aktivität eingehen. Falls die Lektion mindestens eine Verzweigungsseite enthält, sollte der Wert auf 0 gesetzt werden.

Wenn Sie den Wert auf 20 setzen, so wird empfohlen, dass Sie dies in einem Text auf der Startseite der Lektion ankündigen, beispielsweise so: "In dieser Lektion wird von Ihnen erwartet, dass Sie mindestens 20 Fragen bearbeiten. Sie dürfen auch mehr Fragen versuchen, wenn Sie möchten. Falls Sie allerdings nur weniger als 20 Fragen bearbeiten, so wird Ihre Bewertung trotzdem so berechnet, als ob Sie 20 Fragen versucht hätten."';
$string['missingname'] = 'Bitte geben Sie einen Nicknamen ein';
$string['modattempts'] = 'Wiederholung erlauben';
$string['modattempts_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen erneut durch die Lektion navigieren.';
$string['modattemptsnoteacher'] = 'Navigation nur für Teilnehmer/innen möglich';
$string['modulename'] = 'Lektion';
$string['modulename_help'] = 'Lektionen bestehen aus einer Reihe von Seiten und Verlinkungen zwischen den Seiten. Führen Sie die Teilnehmer/innen stringent von Seite zu Seite oder bieten Sie ihnen Auswahlmöglichkeiten.

Bei Testfrageseiten können Folgeseiten von der abgegebenen Antwort abhängig gemacht werden.

Alle Inhalte der Lektion können im Unterschied zu Lernpaketen oder IMS-Content direkt in Moodle erstellt werden.';
$string['modulenameplural'] = 'Lektionen';
$string['move'] = 'Seite verschieben';
$string['movedpage'] = 'Seite verschoben';
$string['movepagehere'] = 'Seite hierher verschieben';
$string['moving'] = 'Seite {$a} verschieben';
$string['multianswer'] = 'Mehrere Antworten';
$string['multianswer_help'] = 'Aktivieren Sie diese Option, wenn mehr als eine Antwort richtig sein kann.';
$string['multichoice'] = 'Multiple-Choice';
$string['multipleanswer'] = 'Mehrfachantwort';
$string['nameapproved'] = 'Name akzeptiert';
$string['namereject'] = 'Der eingegebene Name wurde zurückgewiesen.<br />Bitte versuchen Sie es mit einem anderem Namen noch einmal.';
$string['new'] = 'Neu';
$string['nextpage'] = 'Nächste Seite';
$string['noanswer'] = 'Eine oder mehrere Fragen wurden nicht beantwortet. Gehen Sie zurück und geben Sie die Antworten ein.';
$string['noattemptrecordsfound'] = 'Keine aufgezeichneten Daten gefunden: Keine Bewertung vorgenommen';
$string['nobranchtablefound'] = 'Keine Inhaltsseite gefunden';
$string['nocommentyet'] = 'Bisher kein Feedback';
$string['nocoursemods'] = 'Keine Aktivitäten gefunden';
$string['nocredit'] = 'Keine Bewertung';
$string['nodeadline'] = 'Keine zeitliche Beschränkung';
$string['noessayquestionsfound'] = 'Keine Freitext-Fragen in der Lektion vorhanden';
$string['nohighscores'] = 'Keine Bestenliste';
$string['nolessonattempts'] = 'Bisher keine Versuche';
$string['nooneansweredcorrectly'] = 'Niemand hat richtig geantwortet.';
$string['nooneansweredthisquestion'] = 'Niemand hat diese Frage beantwortet.';
$string['noonecheckedthis'] = 'Niemand hat dies ausgewählt.';
$string['nooneenteredthis'] = 'Niemand hat dies eingegeben.';
$string['noonehasanswered'] = 'Bisher wurden keine Freitextfragen beantwortet.';
$string['noretake'] = 'Sie können diese Lektion nicht wiederholen.';
$string['normal'] = 'Dem Pfad der Lektion folgen';
$string['notcompleted'] = 'Nicht beendet';
$string['notdefined'] = 'Nicht definiert';
$string['nothighscore'] = 'Sie haben keine Bestenliste angelegt.';
$string['notitle'] = 'Kein Titel';
$string['numberofcorrectanswers'] = 'Richtige Antworten: {$a}';
$string['numberofcorrectmatches'] = 'Anzahl der richtigen Zuordnungen: {$a}';
$string['numberofpagestoshow'] = 'Zahl der zu zeigenden Seiten';
$string['numberofpagestoshow_help'] = 'Diese Einstellung legt die Zahl der Seiten fest, die in der Lektion gezeigt werden sollen. Eine Begrenzung ist sinnvoll für Lektionen, bei denen die Seiten in einer zufälligen Reihenfolge gezeigt werden, wenn also die Option "Aktion nach einer richtigen Antwort" auf "Ungesehene Seite anzeigen" oder "Unbeantwortete Seite anzeigen" gesetzt wurde.

Wenn die "Zahl der zu zeigenden Seiten" auf 0 gesetzt wird, dann werden alle Seiten in der Lektion angezeigt.';
$string['numberofpagesviewed'] = 'Beantwortete Fragen: {$a}';
$string['numberofpagesviewednotice'] = 'Beantwortete Fragen: {$a->nquestions} (mindestens zu beantworten: {$a->minquestions})';
$string['numerical'] = 'Numerisch';
$string['ongoing'] = 'Aktuelle Bewertung anzeigen';
$string['ongoingcustom'] = 'Gesamtpunktzahl: {$a->score} / {$a->currenthigh}';
$string['ongoing_help'] = 'Wenn diese Option aktiviert ist, wird den Teilnehmer/innen auf jeder Seite ihre aktuelle Bewertung zusammen mit der maximal erreichbaren Bewertung angezeigt.';
$string['ongoingnormal'] = 'Richtige Antworten: {$a->correct} / {$a->viewed}';
$string['onpostperpage'] = 'Nur eine Mitteilung pro Bewertung';
$string['options'] = 'Optionen';
$string['or'] = 'ODER';
$string['ordered'] = 'Geordnet';
$string['other'] = 'Weitere Einstellungen';
$string['outof'] = 'von {$a}';
$string['overview'] = 'Übersicht';
$string['overview_help'] = 'Eine Lektion besteht mehreren Seiten und optionalen Inhaltsseiten.

Eine Seite stellt den Lerninhalt bereit und endet normalerweise mit einer Frage. Zugeordnet zu jeder Antwortmöglichkeit ist ein Sprung. Der Sprung kann relativ sein, also diese oder die nächste Seite adressieren. Ein Sprung kann aber auch absolut sein und dann jede beliebige Seite in der Lektion erreichen.

Eine Inhaltsseite enthält eine ganze Reihe von Links zu anderen Seiten der Lektion, wie beispielsweise ein Inhaltsverzeichnis.';
$string['page'] = 'Seite: {$a}';
$string['pagecontents'] = 'Seiteninhalt';
$string['page-mod-lesson-edit'] = 'Lektionsbearbeitungsseite';
$string['page-mod-lesson-view'] = 'Lektionsansichtsseite';
$string['page-mod-lesson-x'] = 'Alle Lektionsseiten';
$string['pages'] = 'Seiten';
$string['pagetitle'] = 'Seitentitel';
$string['password'] = 'Kennwort';
$string['passwordprotectedlesson'] = 'Lektion {$a} erfordert ein Kennwort.';
$string['pleasecheckoneanswer'] = 'Antwort auswählen und absenden';
$string['pleasecheckoneormoreanswers'] = 'Wählen Sie eine oder mehrere Antworten.';
$string['pleaseenteryouranswerinthebox'] = 'Bitte schreiben Sie Ihre Antwort ins Eingabefeld';
$string['pleasematchtheabovepairs'] = 'Ordnen Sie die obigen Paare einander zu';
$string['pluginadministration'] = 'Lektions-Administration';
$string['pluginname'] = 'Lektion';
$string['pointsearned'] = 'Erreichte Punkte';
$string['postprocesserror'] = 'Fehler während der Verarbeitung aufgetreten! (post-processing)';
$string['postsuccess'] = 'Erfolgreich gesendet';
$string['practice'] = 'Übungslektion';
$string['practice_help'] = 'Übungslektionen gehen nicht in die Gesamtbewertungen des Kurses ein.';
$string['preprocesserror'] = 'Fehler während der Verarbeitung aufgetreten! (pre-processing)';
$string['prerequisitelesson'] = 'Abhängige Lektion';
$string['preview'] = 'Vorschau';
$string['previewlesson'] = 'Vorschau {$a}';
$string['previouspage'] = 'Vorherige Seite';
$string['processerror'] = 'Fehler während der Verarbeitung aufgetreten!';
$string['progressbar'] = 'Fortschrittsbalken';
$string['progressbar_help'] = 'Wenn diese Option aktiviert ist, wird ein Fortschrittsbalken unten auf den Lektionsseiten angezeigt, der einen ungefähren Prozentwert der Bearbeitung darstellt.';
$string['progressbarteacherwarning'] = 'Fortschrittsbalken wird für {$a} nicht anzeigen';
$string['progressbarteacherwarning2'] = 'Die Fortschrittsanzeige wird Ihnen nicht angezeigt, da Sie diese Lektion als Trainer/in bearbeiten können.';
$string['progresscompleted'] = 'Sie haben {$a}% der Lektion erledigt';
$string['qtype'] = 'Seitentyp';
$string['question'] = 'Frage';
$string['questionoption'] = 'Zusatzoption';
$string['questiontype'] = 'Fragetyp';
$string['randombranch'] = 'Zufällige Inhaltsseite';
$string['randompageinbranch'] = 'Zufällige Frage innerhalb des Zweiges';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Absolute Bewertung';
$string['receivedcredit'] = 'Bewertung';
$string['redisplaypage'] = 'Seite erneut anzeigen';
$string['report'] = 'Bericht';
$string['reports'] = 'Ergebnisse';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Wiederholungen zulässig';
$string['retakesallowed_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen die Lektion mehrfach bearbeiten.';
$string['returnto'] = 'Zurückkehren zu {$a}';
$string['returntocourse'] = 'Zurück zur Kursseite';
$string['review'] = 'Rückschau';
$string['reviewlesson'] = 'Zur Lektion';
$string['reviewquestionback'] = 'Wiederholen';
$string['reviewquestioncontinue'] = 'Fortsetzen';
$string['sanitycheckfailed'] = 'Verständlichkeitsprüfung gescheitert: Der Versuch wurde gelöscht.';
$string['savechanges'] = 'Änderungen speichern';
$string['savechangesandeol'] = 'Alle Änderungen speichern und zum Ende der Lektion gehen.';
$string['savepage'] = 'Seite speichern';
$string['score'] = 'Bewertung';
$string['score_help'] = 'Punkte werden nur verwendet, wenn eine benutzerdefinierte Bewertung aktiviert ist. Jeder Antwort kann einen (positiver oder negativer) Zahlenwert gegeben werden.';
$string['scores'] = 'Bewertung';
$string['secondpluswrong'] = 'Nicht ganz. Wollen Sie noch einmal wiederholen?';
$string['selectaqtype'] = 'Fragetyp auswählen';
$string['shortanswer'] = 'Kurzantwort';
$string['showanunansweredpage'] = 'Noch nicht beantwortete Seite anzeigen';
$string['showanunseenpage'] = 'Noch nicht angezeigte Seite anzeigen';
$string['singleanswer'] = 'Einzelne Antwort';
$string['skip'] = 'Keine Navigation';
$string['slideshow'] = 'Slideshow';
$string['slideshowbgcolor'] = 'Hintergrundfarbe für Slideshow';
$string['slideshowheight'] = 'Höhe für Slideshow';
$string['slideshow_help'] = 'Wenn diese Option aktiviert ist, wird die Lektion als Diashow mit einer festgelegten Breite und Höhe gezeigt.';
$string['slideshowwidth'] = 'Breite für Slideshow';
$string['startlesson'] = 'Lektion bearbeiten';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}: Versuch Nr. {$a->attempt}';
$string['studentname'] = 'Name';
$string['studentoneminwarning'] = 'Warnung: Sie haben noch eine Minute oder weniger Zeit, um die Lektion abzuschließen.';
$string['studentresponse'] = '{$a}\'s  Antwort';
$string['submit'] = 'Einreichen';
$string['submitname'] = 'Absenden';
$string['teacherjumpwarning'] = 'In der Lektion werden \'{$a->cluster}\'-Sprünge und/oder \'{$a->unseen}\'-Sprünge verwendet. Diese Sprünge werden durch \'Nächste Seite\'-Sprünge ersetzt. Melden Sie sich als Teilnehmer/in an, um die Sprünge zu testen.';
$string['teacherongoingwarning'] = 'Die aktuelle Bewertung wird nur für Teilnehmer/innen angezeigt. Melden Sie sich als Teilnehmer/in an, um diese Funktion zu testen.';
$string['teachertimerwarning'] = 'Die Zeitbegrenzung funktioniert nur für Teilnehmer/innen. Melden Sie sich als Teilnehmer/in an, um diese Funktion zu testen.';
$string['thatsthecorrectanswer'] = 'Richtig';
$string['thatsthewronganswer'] = 'Falsch';
$string['thefollowingpagesjumptothispage'] = 'Die folgenden Seiten springen auf diese Seite';
$string['thispage'] = 'Diese Seite';
$string['timeisup'] = 'Die Zeit ist abgelaufen';
$string['timeremaining'] = 'Verbleibende Zeit';
$string['timespenterror'] = 'Bearbeiten Sie diese Lektion mindestens {$a} Minuten lang.';
$string['timespentminutes'] = 'Aufgewendete Zeit (Minuten)';
$string['timetaken'] = 'Aufgewendete Zeit';
$string['topscorestitle'] = 'Top {$a} Bestenliste';
$string['truefalse'] = 'Wahr/Falsch';
$string['unabledtosavefile'] = 'Die hochgeladene Datei konnte nicht gesichert werden';
$string['unknownqtypesnotimported'] = '$ Fragen mit nicht unterstützten Fragetypen wurden nicht importiert';
$string['unseenpageinbranch'] = 'Noch nicht angezeigte Frage innerhalb des Zweiges';
$string['unsupportedqtype'] = 'Der Fragetyp ({$a}) wird nicht unterstützt!';
$string['updatedpage'] = 'Seite aktualisiert';
$string['updatefailed'] = 'Aktualisierung fehlgeschlagen';
$string['usemaximum'] = 'Bester Versuch';
$string['usemean'] = 'Durchschnitt';
$string['usepassword'] = 'Erfordert Kennwort';
$string['usepassword_help'] = 'Wenn Sie diese Option aktivieren, ist die Lektion durch ein Kennwort geschützt. Teilnehmer/innen haben nur Zugang, wenn sie das richtige Kennwort eingeben.';
$string['viewgrades'] = 'Bewertungen anzeigen';
$string['viewhighscores'] = 'Bestenliste anzeigen';
$string['viewreports'] = '{$a->attempts} abgeschlossene von {$a->student} Versuchen anzeigen';
$string['viewreports2'] = 'Zeige {$a} komplette Versuche';
$string['welldone'] = 'In den Kurs gelangen Sie mit Klick auf "Zurückkehren zu ..."';
$string['whatdofirst'] = 'Was wollen Sie zuerst tun?';
$string['wronganswerjump'] = 'Sprung bei falscher Antwort';
$string['wronganswerscore'] = 'Bewertung bei falscher Antwort';
$string['wrongresponse'] = 'Feedback bei falscher Antwort';
$string['xattempts'] = '{$a} Versuche';
$string['youhaveseen'] = 'Sie haben einige Seiten der Lektion schon einmal bearbeitet. <br />Wollen Sie an der Stelle fortsetzen, an der Sie damals aufgehört haben?';
$string['youmadehighscore'] = 'Sie kommen in die Bestenliste der {$a} besten Bewertungen.';
$string['youranswer'] = 'Ihre Antwort';
$string['yourcurrentgradeis'] = 'Derzeitige Bewertung: {$a}';
$string['yourcurrentgradeisoutof'] = 'Ihre derzeitige Bewertung ist {$a->grade} von {$a->total}';
$string['youshouldview'] = 'mindestens zu beantworten: {$a}';
