<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   webservice
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Dostopaj do kontrolne izjeme';
$string['actwebserviceshhdr'] = 'Aktivni spletno storitveni protokoli';
$string['addaservice'] = 'Dodaj storitev';
$string['addcapabilitytousers'] = 'Preveri uporabniško sposobnost';
$string['addcapabilitytousersdescription'] = 'Uporabniki morajo imeti dve sposobnosti -
webservice:createtoken in sposobnost ujemanja uporabljenih protokolov, za ta primer webservice/rest:use, webservice/soap:use. Da dosežete to, ustvarite vlogo spletnih storitev z primernimi zmožnostmi, ki jih dovolite in določite uporabniku spletnih storitev kot sistemsko vlogo.';
$string['addfunction'] = 'Dodaj funkcijo';
$string['addfunctions'] = 'Dodaj funkcije';
$string['addfunctionsdescription'] = 'Izberite potrebne funkcije za novo ustvarjeno storitev.';
$string['addservice'] = 'Dodaj novo storitev: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Dodaj funkcije v storitev "{$a}"';
$string['allusers'] = 'Vsi uporabniki';
$string['amftestclient'] = 'AMF testni klient';
$string['arguments'] = 'Argumenti';
$string['authmethod'] = 'Metoda preverjanja';
$string['checkusercapability'] = 'Preveti uporabniške sposobnosti';
$string['checkusercapabilitydescription'] = 'Uporabniki naj imajo primerne zmožnosti za protokole, ki so uporabaljeni, na primer webservice/rest:use, webservice/soap:use.  Da dosežete to, ustvarite vlogo spletnih storitev z protokolnimi zmožnostmi, ki jih dovolite in določite uporabniku spletnih storitev kot sistemsko vlogo.';
$string['configwebserviceplugins'] = 'Zavoljo varnostnih razlogov, naj bodo omogočeni samo protokoli, ki so v uporabi.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'Storitev je nastavljena iz funkcij spletne storitve. Doviljeno do bilo uporabniku da dostopa do nove storitve. Na <strong>Dodaj storitev</strong>strani označite \'Omogoči\' in \'Dovoljeni uporabniki\'. Označite \'Ni potrebne zmožnosti\'.';
$string['createserviceforusersdescription'] = 'Storitev je se nabor funkcij spletnih storitev. Dovolili boste uporabnikom da dostopajo do nove storitve.  Na <strong>Dodaj storitev</strong> strani označite \'Omogoči\' in odznačite možnost \'Avtorizirani uporabniki\'. Označite \'Ni zahtevane zmožnosti\'.';
$string['createtoken'] = 'Ustvari žeton';
$string['createtokenforuser'] = 'Ustvari žeton za uporabnika';
$string['createtokenforuserdescription'] = 'Ustvari žeton za uporabnika spletnih storitev.';
$string['createuser'] = 'Ustvari specifičnega uporabnika';
$string['createuserdescription'] = 'Uporabnik spletnih storitev je potreben za reprezentacijo sistema, ki kontrolira Moodle.';
$string['criteriaerror'] = 'Nimate dovoljenja za iskanje po kriterijih';
$string['default'] = 'Privzeto na "{$a}"';
$string['deleteservice'] = 'Izbriši storitev: {$a->name} (id: {$a->id}';
$string['deleteserviceconfirm'] = 'Izbris storitve bo tudi izbrisal žetone sorodne tej storitvi. Si res želite izbrisati zunanjo storitev "{$a}"!';
$string['deletetokenconfirm'] = 'Si res želite izbrisati ta žeton spletne storitve za <strong>{$a->user}</strong> na storitvi <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Vsi spletno storitveni protokoli so onemogočeni. "Omogoči spletne storitve" nastavitev lahko najdete v Naprednih funkcijah.';
$string['doc'] = 'Dokumentacija';
$string['docaccessrefused'] = 'Ni vam dovoljen ogled dokumentacije za ta žeton';
$string['documentation'] = 'dokumentacija spletnih storitev';
$string['editaservice'] = 'Uredi storitev';
$string['editservice'] = 'Uredi storitev: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Omogočeno';
$string['enabledocumentation'] = 'Omogoči razvijalsko dokumentacijo';
$string['enabledocumentationdescription'] = 'Detajlna dokumentacija spletnih storitev je za omogočene protokole na voljo.';
$string['enablemobilewsoverview'] = 'Pojdite na stran {$a->manageservicelink}, vklopite nastavitev "{$a->enablemobileservice}" in shranite. Vse ostalo bo samodejno nastavljeno in uporabniki bodo lahko uporabljali Moodle aplikacijo. Trenutni status: {$a->wsmobilestatus}';
$string['enableprotocols'] = 'Omogoči protokole';
$string['enableprotocolsdescription'] = 'Vsaj n protokol mora biti omogočen. Zavoljo varnostnih razlogov naj bodo omogočeni samo protokoli, ki jih uporabljate.';
$string['enablews'] = 'Omogoči spletne storitve';
$string['enablewsdescription'] = 'Spletne storitve morajo biti omogočene v Naprednih lastnostih.';
$string['error'] = 'Napaka: {$a}';
$string['errorcatcontextnotvalid'] = 'V kontekstu kategorije ne morete zagnati funkcij (category id:{$a->catid}). Kontekstno sporočilo o napaki je bilo: {$a->message}';
$string['errorcodes'] = 'Sporočilo o napaki';
$string['errorcoursecontextnotvalid'] = 'Ne porete izvajati funkcij v kontekstu predmeta (id predmeta:{$a->courseid}). Kontekstno sporočilo o napaki je bilo: {$a->message}';
$string['errorinvalidparam'] = 'Parameter "{$a}" je napravilen.';
$string['errornotemptydefaultparamarray'] = 'Parameter opisa spletne storitve imenovanega \'{$a}\' je enojna ali večja struktura. Privzeto je lahko samo ena zbirka. Preverite opis spletne storitve.';
$string['erroroptionalparamarray'] = 'Parameter opisa spletne storitve imenovanega \'{$a}\' je enojna ali večja struktura. Ne more biti nastavljeno kot VALUE_OPTIONAL. Preverite opis spletne storitve.';
$string['execute'] = 'Zaženi';
$string['executewarnign'] = 'OPOZORILO: Če pritisnite izvedi, bo vaša podatkovna baza spremenjena in splemembe ne bodo mogle biti avtomatsko povrnjene!';
$string['externalservice'] = 'Zunanja storitev';
$string['externalservicefunctions'] = 'Funkcije zunanje storitve';
$string['externalservices'] = 'Zunanje storitve';
$string['externalserviceusers'] = 'Uporabniki zunanjih storitev';
$string['failedtolog'] = 'Napaka pri prijavi';
$string['function'] = 'Funkcija';
$string['functions'] = 'Funkcije';
$string['generalstructure'] = 'Splošna struktura';
$string['information'] = 'Informacije';
$string['installexistingserviceshortnameerror'] = 'Apletna storitev s kratkim imenom "{$a}" že obstaja. Ne morem posodobiti/namestiti druge spletne storitve s tem kratkim imenom.';
$string['installserviceshortnameerror'] = 'Napaka pri kodiranju: kratko ime storitve "{$a}" naj vsebuje številke, črke in samo _-.. .';
$string['invalidextparam'] = 'Nepravilni zunanji api paramater: {$a}';
$string['invalidextresponse'] = 'Nepravilni zunanji api odziv: {$a}';
$string['invalidiptoken'] = 'Nepravilni žeton - vaš IP ni podprt';
$string['invalidtimedtoken'] = 'Nepravilni žeton - žeton je potekel';
$string['invalidtoken'] = 'Nepravilni žeton - žeton ni najden';
$string['iprestriction'] = 'IP restrikcije';
$string['iprestriction_help'] = 'Uporabnik bo moral klicati spletno storitev iz naštetih IP-jev.';
$string['key'] = 'Ključ';
$string['keyshelp'] = 'Ključi so uporabljeni za dostop do Moodle računa iz zunanjih aplikacij.';
$string['manageprotocols'] = 'Urejaj protokole';
$string['managetokens'] = 'Urejaj žetone';
$string['missingcaps'] = 'Manjkajoče zmožnosti';
$string['missingcaps_help'] = 'Seznam zahtevanih zmožnosti za to storitev, ki jih označeni uporabniki nimajo. Manjkajoče zmožnosti morajo biti dodane v uporabniško vlogo, če želite uporabljati to storitev.';
$string['missingpassword'] = 'Manjkajoče geslo';
$string['missingusername'] = 'Manjkajoče uporabniško ime';
$string['missingversionfile'] = 'Napaka pri kodiranju: version.php datoteka manjka za komponento {$a}';
$string['mobilewsdisabled'] = 'Onemogočeno';
$string['mobilewsenabled'] = 'Omogočeno';
$string['nofunctions'] = 'Ta storitev nima funkcij.';
$string['norequiredcapability'] = 'Ni potrebovane zmožnosti';
$string['notoken'] = 'Seznam žetonov je prazen.';
$string['onesystemcontrolling'] = 'En sistem kontrolira Moodle z žetonom';
$string['onesystemcontrollingdescription'] = 'Naslednji koraki vam pomagajo namestiti Moodle spletno storitev za sistem, ki kontrolira Moodle. Ti koraki pomagajo tudi pri namestitvi pristnostne metode priporočljivega žetona (varnostni ključi).';
$string['operation'] = 'Operacija';
$string['optional'] = 'Opcijsko';
$string['passwordisexpired'] = 'Geslo je poteklo.';
$string['phpparam'] = 'XML-RPC (PHP struktura)';
$string['phpresponse'] = 'XML-RPC (PHP struktura)';
$string['potusers'] = 'Ni avtoriziranih uporabnikov';
$string['potusersmatching'] = 'Ni ujemajočih avtoriziranih uporabnikov';
$string['print'] = 'Natisni vse';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Odstrani';
$string['removefunctionconfirm'] = 'Si res želite odstraniti funkcijo "{$a->function}" iz storitve "{$a->service}"?';
$string['required'] = 'Potrebovano';
$string['requiredcapability'] = 'Zahtevana sposobnost';
$string['requiredcapability_help'] = 'Če je nastavljeno, lahko dostopajo damo uporabniki z zahtevanimi zmožnostmi.';
$string['requiredcaps'] = 'Zahtevane sposobnosti';
$string['resettokenconfirm'] = 'SI res želite ponastaviti ta ključ spletne storitve za <strong>{$a->user}</strong> na storitvi <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Si res želite ponastaviti ta ključ? Vse shranjene povezave, ki vsebujejo stari ključ ne bodo več delovale.';
$string['response'] = 'Odziv';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Obnovljeni račun potrebuje resetiranje gesla pred dobavo žetona.';
$string['restparam'] = 'REST (POST parametri)';
$string['restrictedusers'] = 'Samo avtorizirani uporabniki';
$string['restrictedusers_help'] = 'Ta nastavitev določa ali lahko vsi uporabniki z dovoljenjem za ustvaritev žetona spletne storitve, lahko ustvarijo žeton za to storitev preko svojie strani varnostnih ključev ali pa lahko samo avtorizirani uporabniki to naredijo.';
$string['securitykeys'] = 'Varnostni ključi';
$string['selectauthorisedusers'] = 'Izberi avtorizirane uporabnike';
$string['selectedcapabilitydoesntexit'] = 'Trenutno nastavljena potrebna zmožnost ({$a}) ne obstaja več. Prosim spremenite jo in shranite spremembe.';
$string['selectservice'] = 'Označi storitev';
$string['selectspecificuser'] = 'Označi določenega uporabnika';
$string['selectspecificuserdescription'] = 'Dodaj uporabnika spletnih storitev kot avtoriziranega uporabnika.';
$string['service'] = 'Storitev';
$string['servicehelpexplanation'] = 'Storitev je zbirka funkcij. Storitev je lahko dostopana s strani uporabnikov ali samo določenih uporabnikov.';
$string['servicename'] = 'Ime storitve';
$string['servicesbuiltin'] = 'Vgrajene storitve';
$string['servicescustom'] = 'Storitve po meri';
$string['serviceusers'] = 'Avtorizirani uporabniki';
$string['serviceusersettings'] = 'Uporabniške nastavitve';
$string['serviceusersmatching'] = 'Ujemanje avtoriziranih uporabnikov';
$string['serviceuserssettings'] = 'Spremenite nastavitve za avtorizirane uporabnike';
$string['simpleauthlog'] = 'Prijava z enostavno avtentikacijo';
$string['step'] = 'Korak';
$string['supplyinfo'] = 'Več podrobnosti';
$string['testauserwithtestclientdescription'] = 'Simuliraj zunanji dostop do storitve z uporabno testnega klienta spletne storitve. Preden to naredite se prijavite kot uporabnik z moodle/webservice:createtoken zmožnostjo in pridobite varnostni ključ (žeton) preko Mojih profilnih nastavitev. Ta žeton boste uporabljali v testnem klientu. V testnem klientu izberite tudi omogočen protokol z žetonsko antentifikacijo
<strong>OPOZORILO: Funkcije, ki jih testirate BODO IZVRŠENE, tako da pravilno izberite kaj želite testirati!</strong>';
$string['testclient'] = 'Testni klient spletne storitve';
$string['testclientdescription'] = '* Testni klient spletne storitve<strong>izvrši</strong> funkcijo za <strong>REAL</strong>. Ne testirajte funkcij, ki jih ne poznate.<br/>* Vse obstoječe funkcije spletne storitve niso še vgrajene v testni klient. <br/>* Če želite to preveriti, uporabnik ne more dostopati do nekaterih funkcij. Testirate lahko nekatere funkcije, ki jih niste dovolili.<br/>* Za ogled čistejšega sporočila o napaki, nastavite na razhroščevanje na <strong>{$a->mode}</strong> v {$a->atag}<br/>* Dostopajte do {$a->amfatag}.';
$string['testwithtestclient'] = 'Testiraj storitev';
$string['testwithtestclientdescription'] = 'Simuliraj zunanji dostop do storitve z uporabno testnega klienta spletne storitve. Uporabite omogočen protokol z žetonko avtentikacijo.<strong>OPOZORILO: Funkcije, ki jih testirate BODO IZVRŠENE, tako da pravilno izberite kaj želite testirati!</strong>';
$string['token'] = 'Žeton';
$string['tokenauthlog'] = 'Avtentifikacija žetona';
$string['tokencreator'] = 'Ustvarjalec';
$string['updateusersettings'] = 'Posodobitev';
$string['userasclients'] = 'Uporabniki kot klienti z žetonom';
$string['userasclientsdescription'] = 'Sledeči koraki vam pomagajo da nastavite Moodle spletno storitev za uporabnike in kliente. Ti koraki vam tudi pomagajo pri nastavitvi proporočljive žetonske (varnostni ključi) pristnostne metode. V tem primeru bo uporabnik generiral svoj žeton iz strani varnostnih ključev preko Mojih profilnih nastavitev.';
$string['usermissingcaps'] = 'Manjkajoče zmožnosti: {$a}';
$string['usernameoridoccurenceerror'] = 'Obstaja vevč kot en uporabnik s tem uporabniškim imenom. Vnesite uporabnikov ID.';
$string['usernotallowed'] = 'Temu uporabniku ni dovoljena ta storitev. Prvo morate dovoliti temu uporabniku na {$a} skrbniški strani dovoljenih uporabnikov.';
$string['usersettingssaved'] = 'Uporabniške nastavitve shranjene';
$string['validuntil'] = 'Velja do';
$string['validuntil_help'] = 'Če je nastavljeno, bo storitev za tega uporabnika neaktivirana po tem datumu.';
$string['webservice'] = 'Spletna storitev';
$string['webservices'] = 'Spletne storitve';
$string['webservicesoverview'] = 'Pregled';
$string['webservicetokens'] = 'Žetoni spletne storitve';
$string['wrongusernamepassword'] = 'Napačno uporabniško ime in geslo';
$string['wsaccessusernologin'] = 'Zavrnjen dostop do spletne storitve za neprijavljeno avtenticirano uporabniško ime: {$a}';
$string['wsaccessusersuspended'] = 'Zavrnjen dostop do spletne storitve za suspendirano uporabniško ime: {$a}';
$string['wsaccessuserunconfirmed'] = 'Zavrnjen dostop do spletne storitve za nepotrjeno uporabniško ime: {$a}';
$string['wsclientdoc'] = 'Dokumentacija klienta Moodle spletne storitve';
$string['wsdocumentationdisable'] = 'Dokumentacija spletne storitve je onemogočena.';
$string['wsdocumentationintro'] = 'Za ustvaritev klienta svetujemo da preberete {$a->doclink}';
$string['wspassword'] = 'Geslo spletne storitve';
$string['wsusername'] = 'Uporabniško ime spletne storitve';
