<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_uploaduser', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   tool_uploaduser
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowdeletes'] = 'Dovoli brisanje';
$string['allowrenames'] = 'Dovoli preimenovanja';
$string['csvdelimiter'] = 'Ločilo CSV';
$string['defaultvalues'] = 'Privzete vrednosti';
$string['deleteerrors'] = 'Privzete napake';
$string['encoding'] = 'Kodiranje';
$string['errors'] = 'Napake';
$string['nochanges'] = 'Brez sprememb';
$string['renameerrors'] = 'Napake v preimenovanjih';
$string['requiredtemplate'] = 'Zahtevano. Tu lahko uporabite sintakso predlog (%l = priimek, %f = ime, %u = uporabniško ime). Za podrobnosti in primere si oglejte pomoč.';
$string['rowpreviewnum'] = 'Predogled vrstic';
$string['uploadpicture_baduserfield'] = 'Neveljavna lastnost uporabnika. Prosim, poskusite ponovno.';
$string['uploadpicture_cannotmovezip'] = 'Ne morem premakniti datoteke .zip v začasni imenik.';
$string['uploadpicture_cannotprocessdir'] = 'Ne morem obdelati razširjenih datotek .zip.';
$string['uploadpicture_cannotsave'] = 'Ne morem shraniti slike za uporabnika {$a}. Preveri izvirno datoteko s sliko.';
$string['uploadpicture_cannotunzip'] = 'Ne morem razširiti datoteke s sliko.';
$string['uploadpicture_invalidfilename'] = 'Slika {$a} ima v imenu neveljavne znake, zato je preskočena.';
$string['uploadpicture_overwrite'] = 'Prepis obstoječih slik uporabnikov?';
$string['uploadpictures'] = 'Naloži slike uporabnikov';
$string['uploadpictures_help'] = '<p>Slike uporabnikov lahko prenesete v obliki ZIP datoteke ali slikovnih datotek. Imena slik mora biti v formatu <i>izbrano-polje-uporabnika.razširitev</i>. Na primer: če je izbrano polje uporabnika za ujemanje s sliko uporabniško ime in če ima uporabnik uporabniško ime user1234, potem mora biti ime datoteke user1234.jpg.</p>
<p>Podprti formati slik so gif, jpg in png.</p>
<p>Imena slik niso občutljiva na velikost črk.</p>';
$string['uploadpicture_userfield'] = 'Lastnost uporabnika, ki naj jo uporabim za določanje slike:';
$string['uploadpicture_usernotfound'] = 'Uporabnik z vrednostjo \'{$a->uservalue}\' polja \'{$a->userfield}\' ne obstaja, zato je preskočen.';
$string['uploadpicture_userskipped'] = 'Preskakujem uporabnika {$a} (že ima sliko).';
$string['uploadpicture_userupdated'] = 'Slika uporabnika {$a} je osvežena.';
$string['uploadusers'] = 'Nalaganje uporabnikov';
$string['uploadusers_help'] = '<p>Najprej, opomba: <strong>ponavadi množično nalaganje uporabnikov ni potrebno</strong>. Za zmanjšanje administracije najprej preverite načine preverjanja pristnosti, ki ne zahtevajo ročne administracije - denimo povezovanje z obstoječimi zbirkami uporabnikov ali pa omogočanje uporabnikom, da si svoje uporabniške račune ustvarijo sami. Za več informacij si oglejte področje Avtentikacija v skrbniškem meniju.</p>

<p>Če ste prepričani, da želite iz tekstovne datoteke uvoziti uporabnike, potem mora biti ta datoteka v sledeči obliki:</p>

<ul>
  <li>Vsaka vrstica datoteke pomeni en zapis</li>
  <li>Vsak zapis je zaporedje podatkov, ločenih z vejico (ali drugim ločilom)</li>
  <li>Prvi zapis datoteke je drugačen in vključuje spisek polj. Ta vrstica definira obliko preostanka datoteke.
    <blockquote>
      <p><strong>Zahtevana imena polj:</strong> ta polja morajo biti vključena v prvi vrstici in določena za vsakega uporabnika</p>
      <p><code>firstname, lastname</code> ob vnosu ali <code>username</code> ob posodabljanju</p>
      <p><strong>Opcijska imena polj:</strong> ta polja so poljubna. Če zapis vključuje podatek v tem polju, bo uporabljen; v nasprotnem primeru bo uporabljena privzeta vrednost za to polje.</p>
      <p><code>institution, department, city, country, lang, auth, ajax, timezone, idnumber, icq, phone1, phone2, address, url, description, mailformat, maildisplay, htmleditor, autosubscribe, emailstop</code></p>
      <p><strong>Imena polj po meri:</strong> niso nujna. Denimo, da je "xxxxx" pravo ime polja po meri iz profila uporabnika (denimo enolično kratko ime)</p>
      <p><code>profile_field_xxxxx</code></p>
      <p><strong>Posebna imena polj:</strong> uporabna za spreminjanje uporabniških imen in brisanje uporabnikov - več informacij je spodaj</p>
      <p><code>deleted, oldusername</code></p>
      <p><strong>Polja, povezana s predmeti (ni nujno):</strong> Imena predmetov so &quot;kratice&quot; predmetov - če so prisotna, potem bo uporabnik vpisan v te predmete. &quot;Type1&quot; pomeni vrsto vloge v predmetu, ki bo uporabljena. Vrednost 1 pomeni privzeta vloga v predmetu, vrednost 2 je podedovana vloga učitelja (legacy Teacher), vrednost 3 pa predstavlja podedovano vlogo učitelja brez urejanja (legacy Non-editing teacher). Polje za vlogo lahko uporabite tudi za direktno določanje vlog glede na kratko ime vloge ali ID (številčna imena vlog niso podprta). Uporabniki so lahko dodeljeni tudi skupini v predmetu (group1 v course1, group 2 v course 2 ipd). Skupine so določene z njihovimi imeni ali ID (številčna imena skupin niso podprta).</p>
      <p><code>course1, type1, role1, group1, course2, type2, role2, group2, etc.</code></p>
    </blockquote>
    </li>
  <li>Vejice v podatkih morajo biti zapisane kot &amp;#44 - skripta bo te podatke samodejno pretvorila v vejice.</li>
  <li>Za logična polja tipa Boolean uporabite 0 za FALSE in 1 za TRUE.</li>
</ul>
<p>Primer veljavne datoteke za uvoz:</p>
<p><code>username, password, firstname, lastname, email, lang, idnumber, maildisplay, course1, group1, type1<br />
jonest, verysecret, Tom, Jones, jonest@someplace.edu, en, 3663737, 1, Intro101, Section 1, 1<br />
reznort, somesecret, Trent, Reznor, reznort@someplace.edu, en_us, 6736733, 0, Advanced202, Section 3, 3
</code></p>

<h2>Predloge</h2>
<p>Privzete vrednosti so obdelane kot predloge, ki podpirajo naslednje spremenljivke:</p>
<ul>
<li><code>%l</code> - bo zamenjano s priimkom</li>
<li><code>%f</code> - bo zamenjano z imenom</li>
<li><code>%u</code> - bo zamenjano z uporabniškim imenom</li>
<li><code>%%</code> - bo zamenjano z znakom %</li>
</ul>
<p>Med znakom za odstotek (%) in kodo spremenljivke (l, f ali u) so dovoljeni naslednji parametri:</p>
<ul>
<li>(-) znak minus - informacije bodo pretvorjene v male črke</li>
<li>(+) znak plus - informacije bodo pretvorjene v VELIKE ČRKE</li>
<li>(~) znak tilda - informacije bodo pretvorjene v Velike Začetnice Besed</li>
<li>decimalno število - informacije bodo okleščene na največ toliko znakov (odvečni bodo izbrisani)</li>
</ul>

<p>Če je na primer prvo ime John in priimek Doe, bi z uporabo naslednjih predlog dobili sledeče vrednosti:</p>
<ul>
<li>%l%f = DoeJohn</li>
<li>%l%1f = DoeJ</li>
<li>%-l%+f = doeJOHN</li>
<li>%-f_%-l = john_doe</li>
<li>http://www.example.com/~%u/ = http://www.example.com/~jdoe/ (če je uporabniško ime jdoe ali %-1f%-l)</li>
</ul>
<p>Obdelava predlog je možna samo na privzetih vrednostih, ne na vrednostih, ki jih uvozimo iz datoteke CSV.</p>

<p>Za tvorjenje pravilnih uporabniških imen Moodle je uporabniško ime vedno pretvorjeno v male črke. Če je možnost &quot;Dovoli razširjene znake v uporabniških imenih&quot; v skrbniških nastavitvah onemogočena, bodo znaki, drugačni od črk, številk, minusa (-) in pike (.) odstranjeni. Če je na primer uporabniku ime John Jr., priimek pa je Doe, bo uporabniško ime %-f_%-l ob omogočenih razširjenih znakih john jr._doe, ob onemogočenih pa johnjr.doe</p>

<p>Če je možnost "Obravnava podvojenih uporabniških imen" nastavljena na Dodaj števec, bo uporabniškim imenom, tvorjenim s predlogo, ki se pojavijo večkrat, dodan števec. Če denimo datoteka CSV vključuje uporabnike John Doe, Jane Doe in Jenny Doe brez podanih uporabniških imen, privzeto uporabniško ime je nastavljeno na %-1f%-l, Obravnava podvojenih uporabniških imen pa je nastavljena na Dodaj števec, bodo ustvarjena uporabniška imena jdoe, jdoe2 in jdoe3.</p>

<h2>Posodabljanje obstoječih uporabniških računov</h2>

<p>Moodle privzeto predpostavlja, da boste ustvarjali nove uporabniške račune, zato preskoči tiste zapise, katerih uporabniško ime že obstaja. Če omogočite posodabljanje uporabniških računov, pa bodo podatki obstoječega uporabniškega računa posodobljeni.</p>

<p>Ob posodabljanju obstoječih uporabniških računov lahko tudi spremenite uporabniška imena. Možnost "Dovoli preimenovanje" nastavite na <b>Da</b>, v svojo datoteko pa dodajte polje, imenovano <code>oldusername</code>, v katerem je shranjeno prejšnje uporabniško ime.</p>

<p><b>Opozorilo:</b> morebitne napake pri posodabljanju obstoječih uporabniških računov lahko vašim uporabnikom povzročijo veliko težav. Bodite pazljivi pri uporabi te funkcije.</p>

<h2>Brisanje uporabniških računov</h2>
<p>Če v datoteki CSV obstaja polje <code>deleted</code>, bodo uporabniki, katerih zapisi imajo vrednost tega polja nastavljeno na 1, izbrisani. V tem primeru lahko izpustite vrednosti vseh ostalih polj razen polja z uporabniškim imenom - <code>username</code>.</p>
<p>Brisanje in nalaganje uporabniških računov lahko naredite z eno samo datoteko CSV. Naslednji primer bo dodal uporabnika Tom Jones in izbrisal uporabnika reznort:</p>
<p><code>username, firstname, lastname, deleted<br />
jonest, Tom, Jones, 0<br />
reznort, , , 1
</code></p>';
$string['uploaduserspreview'] = 'Predogled naloženih uporabnikov';
$string['uploadusersresult'] = 'Rezultat nalaganja uporabnikov';
$string['useraccountupdated'] = 'Uporabnik posodobljen';
$string['useraccountuptodate'] = 'Uporabnik aktualen';
$string['userdeleted'] = 'Uporabnik izbrisan';
$string['userrenamed'] = 'Uporabnik preimenovan';
$string['userscreated'] = 'Uporabniki ustvarjeni';
$string['usersdeleted'] = 'Uporabniki izbrisani';
$string['usersrenamed'] = 'Uporabniki preimenovani';
$string['usersskipped'] = 'Uporabniki preskočeni';
$string['usersupdated'] = 'Uporabniki posodobljeni';
$string['usersweakpassword'] = 'Uporabniki s slabim geslom';
$string['uubulk'] = 'Izberi za množična dejanja';
$string['uubulkall'] = 'Vsi uporabniki';
$string['uubulknew'] = 'Novi uporabniki';
$string['uubulkupdated'] = 'Posodobljeni uporabniki';
$string['uucsvline'] = 'CSV vrstica';
$string['uulegacy1role'] = '(Original Student) typeN=1';
$string['uulegacy2role'] = '(Original Teacher) typeN=2';
$string['uulegacy3role'] = '(Original Non-editing teacher) typeN=3';
$string['uunoemailduplicates'] = 'Onemogoči podvajanje e-poštnih naslovov';
$string['uuoptype'] = 'Vrsta nalaganja';
$string['uuoptype_addinc'] = 'Dodaj vse, po potrebi dodaj uporabniškim imenom števec';
$string['uuoptype_addnew'] = 'Dodaj samo nove, preskoči obstoječe uporabnike';
$string['uuoptype_addupdate'] = 'Dodaj nove in posodobi obstoječe uporabnike';
$string['uuoptype_update'] = 'Posodobi samo obstoječe uporabnike';
$string['uupasswordcron'] = 'Izdelano v cron-u';
$string['uupasswordnew'] = 'Geslo za nove uporabnike';
$string['uupasswordold'] = 'Geslo za obstoječe uporabnike';
$string['uustandardusernames'] = 'Standardiziraj uporabniška imena';
$string['uuupdateall'] = 'Prepiši z datoteko in privzetimi vrednostmi';
$string['uuupdatefromfile'] = 'Prepiši z datoteki';
$string['uuupdatemissing'] = 'Dodaj manjkajoče podatke iz datoteke in glede na privzete vrednosti';
$string['uuupdatetype'] = 'Obstoječi uporabniški podatki';
$string['uuusernametemplate'] = 'Predloga uporabniških imen';
