<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Dodajanje nove vloge';
$string['addrole'] = 'Dodaj novo vlogo';
$string['advancedoverride'] = 'Napradna povozitev vloge';
$string['allow'] = 'Dovoli';
$string['allowassign'] = 'Dovoli dodelitev vlog';
$string['allowed'] = 'Dovoljeno';
$string['allowoverride'] = 'Dovoli povozitve vlog';
$string['allowroletoassign'] = 'Dovoli uporabnikom z vlogo {$a->fromrole} da določijo vlogo {$a->targetrole}';
$string['allowroletooverride'] = 'Dovoli uporabnikom z vlogo {$a->fromrole} da povozijo vlogo {$a->targetrole}';
$string['allowroletoswitch'] = 'Dovoli uporabnikom z vlogo {$a->fromrole} da zamenjajo vloge na {$a->targetrole}';
$string['allowswitch'] = 'Dovoli zamenjave vlog';
$string['allsiteusers'] = 'Vsi uporabniki strani';
$string['archetype'] = 'Arhetip vloge';
$string['archetypecoursecreator'] = 'ARHETIP: kreator predmeta';
$string['archetypeeditingteacher'] = 'ARHETIP: Učitelj (urejanje)';
$string['archetypefrontpage'] = 'ARHETIP: Potrjeni uporabnik na prvi strani';
$string['archetypeguest'] = 'ARHETIP: gost';
$string['archetype_help'] = 'Arhetip vloge določa dovoljenja kdaj je vloga povrnjena na privzeto. Določa tudi vsako novo dovoljenje za vlogo, ko je stran nadgrajena.';
$string['archetypemanager'] = 'ARHETIP: Upravljalec';
$string['archetypestudent'] = 'ARHETIP: Udeleženec';
$string['archetypeteacher'] = 'ARHETIP: Učitelj (brez urejanja)';
$string['archetypeuser'] = 'ARHETIP: Potrjeni uporabnik';
$string['assignanotherrole'] = 'Dodeli še eno vlogo';
$string['assignedroles'] = 'Dodeli vloge';
$string['assignerror'] = 'Pri dodeljevanju vloge {$a->role} uporabniku {$a->user} je prišlo do napake.';
$string['assignglobalroles'] = 'Dodeli globalne vloge';
$string['assignrole'] = 'Dodeli vlogo';
$string['assignrolenameincontext'] = 'Dodeli vlogo \'{$a->role}\' v {$a->context}';
$string['assignroles'] = 'Dodeli vloge';
$string['assignroles_help'] = '<p>
Z določanjem vlog uporabniku v kontekstu mu dodelite dovoljenja določene vloge za trenuten kontekst in vse "nižje" (podrejene) kontekste.
</p>

<p>
Konteksti:
</p>
<ol>
<li>Spletno mesto/sistem</li>
<li>Kategorije predmetov</li>
<li>Predmeti</li>
<li>Bloki in dejavnosti</li>
</ol>

<p>
Primer: če uporabniku v kontekstu Predmeta določite vlogo Udeleženca, bo uporabnik imel to vlogo v predmetu in tudi pri vseh blokih in dejavnostih v predmetu. Uporabnikova dejanska dovoljenja so lahko odvisna tudi od drugih vlog, ki jih ima uporabnik in ki morda lahko povozijo določene nastavitve.
</p>

<p>
Poglejte še
<a href="help.php?file=roles.html">Vloge</a>,
<a href="help.php?file=contexts.html">Konteksti</a>,
<a href="help.php?file=permissions.html">Dovoljenja</a> in
<a href="help.php?file=overrides.html">Povozitve</a>.
</p>';
$string['assignrolesin'] = 'Dodeli vloge v {$a}';
$string['assignrolesrelativetothisuser'] = 'Dodeli vloge relativne za tega uporabnika';
$string['backtoallroles'] = 'Nazaj na seznam vseh vlog';
$string['backup:anonymise'] = 'Anonimiziraj uporabniške podatke v varnostnih kopijah';
$string['backup:backupactivity'] = 'Varnostno kopiraj aktivnosti';
$string['backup:backupcourse'] = 'Varnostno kopiraj predmete';
$string['backup:backupsection'] = 'Varnostno kopiraj področja';
$string['backup:backuptargethub'] = 'Varnostna kopija za vozlišče';
$string['backup:backuptargetimport'] = 'Varnostne kopije za uvoz';
$string['backup:configure'] = 'Konfiguriraj možnosti varnostnih kopij';
$string['backup:downloadfile'] = 'Prenesi datoteke iz področji varnostnih kopij';
$string['backup:userinfo'] = 'Varnistna kopija uporabniških podatkov';
$string['badges:awardbadge'] = 'Podeli priznanje uporabniku';
$string['badges:configurecriteria'] = 'Nastavi/določi kriterije za pridobivanje priznanja';
$string['badges:configuredetails'] = 'Nastavi/določi podrobnosti priznanja';
$string['badges:configuremessages'] = 'Nastavi sporočila priznanja';
$string['badges:createbadge'] = 'Ustvari/podvoji priznanja';
$string['badges:deletebadge'] = 'Izbriši priznanja';
$string['badges:earnbadge'] = 'Pridobi priznanje';
$string['badges:manageglobalsettings'] = 'Upravljaj z globalnimi nastavitvami Priznanj';
$string['badges:manageownbadges'] = 'Prikaži in upravljaj z mojimi pridobljenimi priznanji';
$string['badges:viewawarded'] = 'Prikaži uporabnike, ki so zaslužili določeno priznanje, a ga ne morejo dobiti podeljenega';
$string['badges:viewbadges'] = 'Prikaži priznanja, ki so na voljo';
$string['badges:viewotherbadges'] = 'Prikaži javna Priznanja v profilih drugih uporabnikov';
$string['block:edit'] = 'Uredi nastavitve bloka';
$string['block:view'] = 'Ogled bloka';
$string['blog:associatecourse'] = 'Združi blog vnose s predmeti';
$string['blog:associatemodule'] = 'Združi blog vnose z aktivnostnimi moduli';
$string['blog:create'] = 'Ustvarjanje novih objav bloga';
$string['blog:manageentries'] = 'Urejanje in uporabljanje objav';
$string['blog:manageexternal'] = 'Uredi in upravljaj zunanje bloge';
$string['blog:manageofficialtags'] = 'Upravljanje uradnih oznak';
$string['blog:managepersonaltags'] = 'Upravljanje z osebnimi oznakami';
$string['blog:search'] = 'Išči po blog vnosih';
$string['blog:view'] = 'Ogled vnosov bloga';
$string['blog:viewdrafts'] = 'Ogled osnutka blog vpisa';
$string['calendar:manageentries'] = 'Upravljanje katerihkoli vnosov koledarja';
$string['calendar:managegroupentries'] = 'Upravljanje skupinskih vnosov koledarja';
$string['calendar:manageownentries'] = 'Upravljanje lastnih vnosov koledarja';
$string['capabilities'] = 'Zmožnosti';
$string['capability'] = 'Zmožnost';
$string['category:create'] = 'Ustvarjanje kategorij';
$string['category:delete'] = 'Brisanje kategorij';
$string['category:manage'] = 'Upravljanje kategorij';
$string['category:update'] = 'Posodabljanje kategorij';
$string['category:viewhiddencategories'] = 'Ogled skritih kategorij';
$string['category:visibility'] = 'Ogled skritih kategorij';
$string['checkglobalpermissions'] = 'Preveri sistemska dovoljenja';
$string['checkpermissions'] = 'Preveri dovoljenja';
$string['checkpermissionsin'] = 'Preveri dovoljenja v {$a}';
$string['checksystempermissionsfor'] = 'Preveri sistemska dovoljenja za {$a->fullname}';
$string['checkuserspermissionshere'] = 'Preveri katera dovoljenja {$a->fullname} ima za ta {$a->contextlevel}';
$string['chooseroletoassign'] = 'Prosimo izberite vlogo za dodelitev';
$string['cohort:assign'] = 'Dodaj in odstrani kohortne člane';
$string['cohort:manage'] = 'Ustvari, izbriši in premakni kohorte';
$string['cohort:view'] = 'Ogled kohortov po celotni strani';
$string['comment:delete'] = 'Izbriši komentarje';
$string['comment:post'] = 'Objavi komentarje';
$string['comment:view'] = 'Preberi komenratje';
$string['community:add'] = 'Uporabi skupnostni blok za iskanje vozlišč in predmetov';
$string['community:download'] = 'Prenesi predmet iz skupnostnega bloka';
$string['confirmaddadmin'] = 'Res želite dodati uporabnika<strong>{$a}</strong> kot novega skrbnika strani?';
$string['confirmdeladmin'] = 'Res želite odstraniti uporabnika<strong>{$a}</strong> iz seznama skrbnikov sistema?';
$string['confirmroleprevent'] = 'Res želite odstraniti<strong>{$a->role}</strong> iz seznama dovoljenih vlog za kompatibilnost{$a->cap} v kontekstu {$a->context}?';
$string['confirmroleunprohibit'] = 'Res želite odstraniti <strong>{$a->role}</strong> iz seznama nedovoljenih vlog za kompatibilnost {$a->cap} v kontekst {$a->context}?';
$string['confirmunassign'] = 'Ste prepričani, da želite odstraniti to vlogo iz tega uporabnika?';
$string['confirmunassignno'] = 'Prakliči';
$string['confirmunassigntitle'] = 'Potrdi spremembo vloge';
$string['confirmunassignyes'] = 'Odstrani';
$string['context'] = 'Kontekst';
$string['course:activityvisibility'] = 'Skrivanje/prikazovanje dejavnosti';
$string['course:bulkmessaging'] = 'Pošiljanje sporočil večim osebam';
$string['course:changecategory'] = 'Spremeni kategorijo predmeta';
$string['course:changefullname'] = 'Spreminjanje polnega imena predmeta';
$string['course:changeidnumber'] = 'Spreminjanje ID številko predmeta';
$string['course:changeshortname'] = 'Spreminjanje kratkega imena predmeta';
$string['course:changesummary'] = 'Spremeni povzetek predmeta';
$string['course:create'] = 'Ustvarjanje predmetov';
$string['course:delete'] = 'Brisanje predmetov';
$string['course:enrolconfig'] = 'Konfiguriraj vpisne primere v predmetih';
$string['course:enrolreview'] = 'Preglej vpise v predmet';
$string['course:manageactivities'] = 'Upravljanje dejavnosti';
$string['course:managefiles'] = 'Upravljanje datotek';
$string['course:managegrades'] = 'Upravljanje ocen';
$string['course:managegroups'] = 'Upravljanje skupin';
$string['course:managescales'] = 'Upravljanje lestvic';
$string['course:markcomplete'] = 'Označi uporabnike kot končane v dokončanju predmeta';
$string['course:publish'] = 'Objavi predmet v vozlišče';
$string['course:request'] = 'Zahtevanje novih predmetov';
$string['course:reset'] = 'Ponastavitev predmeta';
$string['course:sectionvisibility'] = 'Nadzor nad vidnostjo odsekov';
$string['course:setcurrentsection'] = 'Nastavitev trenutnega odseka';
$string['course:update'] = 'Posodobitev nastavitev predmeta';
$string['course:useremail'] = 'Omogočanje/onemogočanje e-poštnih naslovov';
$string['course:view'] = 'Ogled predmetov';
$string['course:viewcoursegrades'] = 'Ogled ocen predmeta';
$string['course:viewhiddenactivities'] = 'Ogled skritih dejavnosti';
$string['course:viewhiddencourses'] = 'Ogled skritih predmetov';
$string['course:viewhiddensections'] = 'Ogled skritih odsekov';
$string['course:viewhiddenuserfields'] = 'Ogled skritih uporabniških polj';
$string['course:viewparticipants'] = 'Ogled udeležencev';
$string['course:viewscales'] = 'Ogled lestvic';
$string['course:viewsuspendedusers'] = 'Prikaži začasno onemogočene uporabnike';
$string['course:visibility'] = 'Skrivanje/prikazovanje predmetov';
$string['createrolebycopying'] = 'Ustvari novo vlogo s kopiranjem {$a}';
$string['createthisrole'] = 'Ustvari to vlogo';
$string['currentcontext'] = 'Trenuten kontekst';
$string['currentrole'] = 'Trenutna vloga';
$string['defaultrole'] = 'Privzeta vloga';
$string['defaultx'] = 'Privzeto: {$a}';
$string['defineroles'] = 'Določi vloge';
$string['deletecourseoverrides'] = 'Izbriši vse povozitve v predmetu';
$string['deletelocalroles'] = 'Izbriši vse lokalne določitve vlog';
$string['deleterolesure'] = 'Ali ste prepričani, da želite izbrisati vlogo "{$a->name} ({$a->shortname})"?</p><p>Trenutno je vloga določena {$a->count} uporabnikom.';
$string['deletexrole'] = 'Izbriši vlogo {$a}';
$string['duplicaterole'] = 'Podvoji vlogo';
$string['duplicaterolesure'] = 'Ali ste prepričani, da želite podvojiti vlogo "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Urejanje vloge \'{$a}\'';
$string['editrole'] = 'Uredi vlogo';
$string['editxrole'] = 'Uredi vlogo {$a}';
$string['errorbadrolename'] = 'Nepravilno ime vloge';
$string['errorbadroleshortname'] = 'Nepravilno ime vloge';
$string['errorexistsrolename'] = 'Vloga s tem imenom že obstaja';
$string['errorexistsroleshortname'] = 'Vloga s tem imenom že obstaja';
$string['existingadmins'] = 'Trenutni skrbniki strani';
$string['existingusers'] = '{$a} obstoječih uporabnikov';
$string['explanation'] = 'Razlaga';
$string['extusers'] = 'Obstoječi uporabniki';
$string['extusersmatching'] = 'Obstoječi uporabniki ki se ujemajo z \'{$a}\'';
$string['filter:manage'] = 'Upravljaj lokalne nastavitve filtra';
$string['frontpageuser'] = 'Potrjeni uporabnik na prvi strani';
$string['frontpageuserdescription'] = 'Vsi prijavljeni uporabniki v predmetu na prvi strani.';
$string['globalrole'] = 'Sistemska vloga';
$string['globalroleswarning'] = 'OPOZORILO! Katerekoli vloge dodeljene preko te strani, bodo uporabnikom dodeljene za celotno spletno mestu, vključujoč naslovno stran in vse predmete.';
$string['gotoassignroles'] = 'Pojdi na Dodeli vloge temu {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Pojdi na Dodelitev sistemskih vlog';
$string['grade:edit'] = 'Urejanje ocen';
$string['grade:export'] = 'Izvažanje ocen';
$string['grade:hide'] = 'Skrivanje/prikazovanje ocen ali postavk';
$string['grade:import'] = 'Uvažanje ocen';
$string['grade:lock'] = 'Zaklepanje ocen ali postavk';
$string['grade:manage'] = 'Upravljanje postavk ocen';
$string['grade:manageletters'] = 'Upravljanje ocen ECTS';
$string['grade:manageoutcomes'] = 'Upravljanje izidov ocen';
$string['grade:override'] = 'Povozitev ocen';
$string['grade:unlock'] = 'Odklepanje ocen ali postavk';
$string['grade:view'] = 'Ogled lastnih ocen';
$string['grade:viewall'] = 'Ogled ocen drugih uporabnikov';
$string['grade:viewhidden'] = 'Ogled skritih ocen za lastnika';
$string['hidden'] = 'Skrito';
$string['highlightedcellsshowdefault'] = 'Označena dovoljenja v spodnji tabeli so privzete vrednosti za arhetip vloge označene zgoraj';
$string['highlightedcellsshowinherit'] = 'Povdarjene celice v spodnji tabeli prikazujejo dovoljenja (če obstajajo), ki bodo podedovana. Za razliko od kompatibilnosti katerih dovoljenja dejansko želite spremeniti, morate pustiti vse na podedovano.';
$string['inactiveformorethan'] = 'nedejaven več kot {$a->timeperiod}';
$string['ingroup'] = 'v skupini "{$a->group}"';
$string['inherit'] = 'Podeduj';
$string['legacy:admin'] = 'PODEDOVANA VLOGA: Skrbnik';
$string['legacy:coursecreator'] = 'PODEDOVANA VLOGA: Ustvajalec predmeta';
$string['legacy:editingteacher'] = 'PODEDOVANA VLOGA: Izvajalec (Urejevalnik)';
$string['legacy:guest'] = 'PODEDOVANA VLOGA: Gost';
$string['legacy:student'] = 'PODEDOVANA VLOGA: Udeleženec';
$string['legacy:teacher'] = 'PODEDOVANA VLOGA: Izvajalec (Ni urejevalnik)';
$string['legacytype'] = 'Vrsta podedovane vloge';
$string['legacy:user'] = 'PODEDOVANA VLOGA: Avtenticiran uporabnik';
$string['listallroles'] = 'Seznam vseh vlog';
$string['localroles'] = 'Lokalno določene vloge';
$string['manageadmins'] = 'Upravljaj z skrbniki strani';
$string['manager'] = 'Upravljalec';
$string['managerdescription'] = 'Upravljalec lahko dostopa do predmeta in ga spreminja. Po navadi ne sodelujejo v predmetih.';
$string['manageroles'] = 'Upravljanje vlog';
$string['maybeassignedin'] = 'Vrste konteksta kamor je lahko ta vloga dodeljena';
$string['morethan'] = 'Več kot {$a}';
$string['multipleroles'] = 'Večkratne vloge';
$string['my:configsyspages'] = 'Nastavite sistemske predloge za My Moodle strani';
$string['my:manageblocks'] = 'Upravljaj bloke na strani Moj dom';
$string['neededroles'] = 'Vloge z dovoljenju';
$string['nocapabilitiesincontext'] = 'Ni dostopnih zmožnosti za ta kontekst';
$string['noneinthisx'] = 'Nič v tem {$a}';
$string['noneinthisxmatching'] = 'Ni uporabnikov, ki se ujemajo z \'{$a->search}\' v tem {$a->contexttype}';
$string['noroleassignments'] = 'Ta uporabnik nima nobenih dodeljenih vlog nikjer na spletnem mestu.';
$string['noroles'] = 'Ni vlog';
$string['notabletoassignroleshere'] = 'Tukaj vam ni omogočeno dodeljevanje vlog';
$string['notes:manage'] = 'Upravljanje opomb';
$string['notes:view'] = 'Ogled opomb';
$string['notset'] = 'Ni določeno';
$string['overrideanotherrole'] = 'Povozi drugo vlogo';
$string['overridecontext'] = 'Povozi kontekst';
$string['overridepermissions'] = 'Povozi dovoljenja';
$string['overridepermissionsforrole'] = 'Povozi dovoljenja za vlogo \'{$a->role}\' v {$a->context}';
$string['overridepermissions_help'] = '<p>Povozitve so določena dovoljenja, ki so oblikovana z namenom povozitve vloge v določenem kontekstu, kar vam omogoča nastavljanje dovoljenj po potrebi.
</p>

<p>Npr. če lahko uporabniki v vašem predmetu z vlogo Udeležencev ponavadi začnejo novo razpravo na forumih, vendar si za nek forum želite omejiti to zmožnost, lahko nastavite povozitev, ki ONEMOGOČI zmožnost Udeležencev za "Začetek novih razprav".</p>

<p>Povozitve je možno uporabiti tudi za "odprtje" delov spletnega mesta in predmetov ter pri tem uporabnikom dodeliti več dovoljenj (seveda kjer je to smiselno). Npr. morda si želite eksperimentirati z možnostjo, da Udeleženci ocenjujejo določene naloge.
</p>

<p>Vmesnik je podoben vmesniku za določanje vloge, s to razliko, da so včasih prikazane samo relevantne zmožnosti, prav tako boste videli, da so nekatere zmožnosti poudarjene in vam s tem kažejo, kakšna bi bila dovoljenja za trenutno vlogo BREZ nobenih aktivnih povozitev (npt. ko imate povozitev nastavljeno na PODEDOVANO).
</p>

<p>
Poglejte še
<a href="help.php?file=roles.html">Vloge</a>,
<a href="help.php?file=contexts.html">Konteksti</a>,
<a href="help.php?file=assignroles.html">Dodeljevanje vlog</a> in
<a href="help.php?file=permissions.html">Dovoljenja</a>.
</p>';
$string['overridepermissionsin'] = 'Povozi dovoljenja v {$a}';
$string['overrideroles'] = 'Povozi vloge';
$string['overriderolesin'] = 'Povozi vloge v {$a}';
$string['overrides'] = 'Povozitve';
$string['permission'] = 'Dovoljenja';
$string['permission_help'] = '<p>Dovoljenja so nastavitve, ki jih določite za posamezne zmožnosti.
</p>

<p>
Primer zmožnosti je recimo "Začetek novih razprav" (na forumih).
</p>

<p>
V vsaki vlogi lahko dovoljenje za vsako takšno zmožnost nastavite na eno izmed štirih vrednosti:
<dl>
<dt>NI DOLOČENO</dt>
<dd>To je ponavadi privzeta nastavitev. Je nevtralna nastavitev, ki pomeni, "uporabi katerokoli nastavitev, ki jo uporabnik že ima". Če je vloga dodeljena nekomu (npr. v predmetu), ki ima to dovoljenje za zmožnost, potem bo dovoljenje enako tistemu, ki ga ima uporabnik na višjem nivoju (npr. na nivoju kategorij predmetov ali na nivoju spletnega mesta). V primeru, da dovoljenje ni določeno na nobenem nivoju, uporabnik za to zmožnost ne bo imel dovoljenja.
    </dd>

<dt>DOVOLI</dt>
<dd>Z izbiro te vrednosti uporabnikom, ki imajo določeno trenutno vlogo, dodelite dovoljenje za zmožnost. Dovoljenje velja za kontekst, v katerem se vloga določi in za vse "nižje" (podrejene) kontekste. Npr. če se ta vloga določi udeležencu v predmetu, bo udeleženec imel zmožnost "Začeti novo razpravo" na vseh forumih v predmetu, RAZEN če forum vsebuje povozitev ali novo določitev za zmožnost z vrednostma Prepreči ali Prepovej.
</dd>

<dt>PREPREČI</dt>
<dd>Z izbiro te vrednosti odstranite dovoljenje za zmožnost. To velja tudi v primeru, da je uporabnikom s to vlogo zmožnost dovoljena v višjem (nadrejenem) kontekstu.</dd>

<dt>PREPOVEJ</dt>
<dd>Ta vrednost je redko potrebna, vendar boste morda včasih želeli popolnoma prepovedati dovoljenje za vlogo na tak način, da NE more biti povožena na nižjem kontekstu. Primer uporabe je recimo situacijo, ko želi skrbnik strani eni osebi preprečiti zmožnost začetka novih razprav na kateremkoli forumu na spletnem mestu. V tem primeru lahko skrbnik ustvari novo vlogo, pri kateri bo ta zmožnost nastavljena na "Prepovej" in nato vlogo uporabniku dodeli v kontekstu spletnega mesta (globalna vloga).
  </dd>

</dl>
</p>


<p>Dovoljenja v "nižjih" (podrejenih) kontekstih bodo ponavadi povozila karkoli v "višjih" kontekstih (to se nanaša na povozitve in določene vloge). Izjema je vrednost PREPOVEJ, ki se jo ne da povoziti na nižjih nivojih.
</p>

<p>Če sta v istem kontekstu isti osebi določeni dve vlogi, ena z DOVOLI in ena z PREPREČI, kdo zmaga? V tem primeru bo Moodle za odločitev pogledal višje v kontekstno drevo.</p>

<p>Npr. če ima udeleženec v predmetu dve vlogi, eno, ki mu določa začetek novih razprav in drugo, ki mu to preprečuje. V tem primeru se preverita konteksta kategorij predmetov in spletnega mesta, pri čemer se išče drugo dovoljenje, ki bi lahko pomagalo pri določitvi. Če se le-to ne najde, potem bo dovoljenje privzeto postalo PREPREČI (ker se nastavitvi medsebojno izključujeta in tako nimamo dovoljenja za vlogo.
</p>


<p>Vedite, da bo gostujočemu uporabniku ponavadi preprečena objava vsebin (npr. forumi, vnosi v koledar, blogi), tudi če mu dodelite to zmožnost.
</p>

<p>
Poglejte še
<a href="help.php?file=roles.html">Vloge</a>,
<a href="help.php?file=contexts.html">Konteksti</a>,
<a href="help.php?file=assignroles.html">Določanje vlog</a> in
<a href="help.php?file=overrides.html">Povozitve</a>.
</p>';
$string['permissions'] = 'Dovoljenja';
$string['permissionsforuser'] = 'Dovoljenja za uporabnika {$a}';
$string['permissionsincontext'] = 'Dovoljenja v {$a}';
$string['portfolio:export'] = 'Izvozi v listovnik';
$string['potentialusers'] = '{$a} možnih uporabnikov';
$string['potusers'] = 'Potencialni uporabniki';
$string['potusersmatching'] = 'Potencialni uporabniki, ki se ujemajo \'{$a}\'';
$string['prevent'] = 'Prepreči';
$string['prohibit'] = 'Prepovej';
$string['prohibitedroles'] = 'Prepovedano';
$string['question:add'] = 'Dodajanje novih vprašanj';
$string['question:config'] = 'Nastavitev vrst vprašanj';
$string['question:editall'] = 'Urejanje vseh vprašanj';
$string['question:editmine'] = 'Urejanje lastnih vprašanj';
$string['question:flag'] = 'Označi vprašanja med poskušanjem';
$string['question:managecategory'] = 'Upravljanje kategorij vprašanj';
$string['question:moveall'] = 'Premikanje vseh vprašanj';
$string['question:movemine'] = 'Premikanje lastnih vprašanj';
$string['question:useall'] = 'Uporaba vseh vprašanj';
$string['question:usemine'] = 'Uporaba lastnih vprašanj';
$string['question:viewall'] = 'Ogled vseh vprašanj';
$string['question:viewmine'] = 'Ogled lastnih vprašanj';
$string['rating:rate'] = 'Dodaj ocene na predmete';
$string['rating:view'] = 'Ogled vseh ocen, ki ste jih prejeli';
$string['rating:viewall'] = 'Ogled vseh surovih ocen, ki so jih dodelili posamezniki';
$string['rating:viewany'] = 'Ogled vseh ocen, ki jih je kdorkoli prejel';
$string['resetrole'] = 'Ponastavitev na privzeto';
$string['restore:configure'] = 'Nastavi obnovitvene možnosti';
$string['restore:createuser'] = 'Ustvari uporabnike pri obnovitvi';
$string['restore:restoreactivity'] = 'Obnovi aktivnosti';
$string['restore:restorecourse'] = 'Obnovi predmete';
$string['restore:restoresection'] = 'Obnovi sekcije';
$string['restore:restoretargethub'] = 'Obnovi iz datotek, označenih kot vozlišče';
$string['restore:restoretargetimport'] = 'Obnovi iz datotek, označenih za uvoz';
$string['restore:rolldates'] = 'Ob obnovitvi je dovoljen vpis nastavitev konfiguracije';
$string['restore:uploadfile'] = 'Naloži datoteke na področje za varnostne kopije';
$string['restore:userinfo'] = 'Obnovi uporabniške podatke';
$string['restore:viewautomatedfilearea'] = 'Obnovi predmete iz avtomatskih varnostnih kopij';
$string['risks'] = 'Nevarnosti';
$string['roleallowheader'] = 'Dovoli vlogo:';
$string['roleallowinfo'] = 'Označite vlogo, ki bo dodana na seznam dovoljenih vlog v kontekstu {$a->context}, zmožnosti  {$a->cap}:';
$string['role:assign'] = 'Dodeljevanje vlog uporabnikom';
$string['roleassignments'] = 'Določitve vlog';
$string['roledefinitions'] = 'Definicije vlog';
$string['rolefullname'] = 'Ime';
$string['role:manage'] = 'Ustvarjanje in upravljanje vlog';
$string['role:override'] = 'Povozitve dovoljenj za ostale';
$string['roleprohibitheader'] = 'Prepovej vlogo';
$string['roleprohibitinfo'] = 'Označite vlogo, ki bo dodana na seznam nedovoljenih vlog v kontekstu {$a->context}, zmožnosti  {$a->cap}:';
$string['role:review'] = 'Preglej dovoljenja za ostale';
$string['roles'] = 'Vloge';
$string['role:safeoverride'] = 'Povozitve varnih dovoljenj za ostale';
$string['roleselect'] = 'Označi vlogo';
$string['roles_help'] = '<p>Vloga je zbirka dovoljenj, določenih za celotno spletno mesto, ki jih lahko dodelite določenim uporabnikom v določenih kontekstih.
</p>

<p>Npr. lahko imate vlogo z imenom "izvajalec", ki je nastavljena tako, da izvajalcem predmeta omogoča določena dejanja (vendar ne vseh). Ko enkrat ta vloga obstaja, jo lahko dodelite uporabniku v predmetu in s tem uporabnika naredite za "Izvajalca". Lahko bi to vlogo uporabniku dodelili na nivoju kategorije predmetov, s čemer bi uporabnik postal "Izvajalec" za vse predmete v izbrani kategoriji. Lahko bi vlogo določili tudi na nivoju posameznega foruma in tako uporabniku posebne zmožnosti omogočili samo za izbran forum.
</p>

<p>
Vsaka vloga mora imeti <strong>ime</strong>. Če potrebujete različno ime za vlogo v različnih jezikih, lahko uporabite večjezično sintakso, kot npr:<pre>
  &lt;span lang="sl">Učitelj&lt;/span>
  &lt;span lang="en">Teacher&lt;/span>
  </pre>Če to storite, se prepričajte, da imate v svoji Moodle inštalaciji omogočeno nastavitev "filtriraj nize".
</p>

<p>
<strong>Kratko ime</strong> vloge je potrebno za druge Moodle vtičnike, ki bi utegnili potrebovati sklic na vaše vloge (npr. pri nalaganju uporabnikov iz datoteke ali nastavitve vpisov preko vtičnika za vpisovanje).
</p>

<p>
<strong>Opis</strong> vloge enostavno opiše vlogo z vašimi lastnimi besedami, kar omogoča, da vsi na enak način razumejo pomen vloge.
</p>

<p>
Poglejte še
<a href="help.php?file=contexts.html">Konteksti</a>,
<a href="help.php?file=permissions.html">Dovoljenja</a>,
<a href="help.php?file=assignroles.html">Določanje vlog</a> in
<a href="help.php?file=overrides.html">Povozitve</a>.
</p>';
$string['roleshortname'] = 'Kratko ime';
$string['role:switchroles'] = 'Preklapljanje v druge vloge';
$string['roletoassign'] = 'Vloga za dodelitev';
$string['roletooverride'] = 'Vloga za povozitev';
$string['safeoverridenotice'] = 'Pomni: Zmožnosti z višjim tveganjem so zaklenjene, saj imate dovoljenje samo za upravljanje varnih zmožnosti.';
$string['selectanotheruser'] = 'Izberite drugega uporabnika';
$string['selectauser'] = 'Izberite uporabnika';
$string['selectrole'] = 'Izberite vlogo';
$string['showallroles'] = 'Pokaži vse vloge';
$string['showthisuserspermissions'] = 'Prikaži dovoljenja tega uporabnika';
$string['site:accessallgroups'] = 'Dostop do vseh skupin';
$string['siteadministrators'] = 'Skrbniki strani';
$string['site:approvecourse'] = 'Odobritev ustvarjanja predmeta';
$string['site:backup'] = 'Ustvarjanje varnostnih kopij predmeta';
$string['site:config'] = 'Spreminjanje konfiguracije spletnega mesta';
$string['site:doanything'] = 'Dovoljenje za vsa dejanja';
$string['site:doclinks'] = 'Prikaz povezav na dokumente na drugih straneh';
$string['site:import'] = 'Uvoz drugih predmetov v predmet';
$string['site:manageblocks'] = 'Upravljanje blokov na strani';
$string['site:mnetloginfromremote'] = 'Prijava iz oddaljenega Moodla';
$string['site:mnetlogintoremote'] = 'Uporaba oddaljenih Moodlov';
$string['site:readallmessages'] = 'Branje vseh sporočil na strani';
$string['site:restore'] = 'Ponastavitev predmetov';
$string['site:sendmessage'] = 'Pošiljanje sporočil kateremukoli uporabniku';
$string['site:trustcontent'] = 'Zanesljivost objavljene vsebine';
$string['site:uploadusers'] = 'Nalaganje novih uporabnikov iz datoteke';
$string['site:viewfullnames'] = 'Vedno vidi polna imena uporabnikov';
$string['site:viewparticipants'] = 'Ogled udeležencev';
$string['site:viewreports'] = 'Ogled poročil';
$string['tag:create'] = 'Ustvarjanje novih oznak';
$string['tag:edit'] = 'Urejanje obstoječih oznak';
$string['tag:editblocks'] = 'Urejanje blokov na straneh oznak';
$string['tag:flag'] = 'Obeleži oznake kot neprimerne';
$string['tag:manage'] = 'Upravljanje oznak';
$string['thisusersroles'] = 'Določene vloge za tega uporabnika';
$string['unassignarole'] = 'Oddeli vlogo {$a}';
$string['unassignconfirm'] = 'Ali res želite oddeliti "{$a->role}" vlogo od uporabnika "{$a->user}"?';
$string['unassignerror'] = 'Pri odvzemanju vloge {$a->role} uporabniku {$a->user} je prišlo do napake.';
$string['user:changeownpassword'] = 'Spreminjanje lastnega gesla';
$string['user:create'] = 'Ustvarjanje uporabnikov';
$string['user:delete'] = 'Brisanje uporabnikov';
$string['user:editmessageprofile'] = 'Uredi uporabnikov sporočilni profil';
$string['user:editownmessageprofile'] = 'Uredite svoj uporabniško sporočilni profil';
$string['user:editownprofile'] = 'Urejanje lastnega uporabniškega progila';
$string['user:editprofile'] = 'Urejanje uporabniškega profila';
$string['user:loginas'] = 'Prijava kot drugi uporabnik';
$string['user:manageblocks'] = 'Uredi bloke na uporabniškem profilu ostalih uporabnikov';
$string['user:manageownblocks'] = 'Uredi bloke na uporabniškem profilu ostalih uporabnikov';
$string['user:manageownfiles'] = 'Urejaj datoteke na vaših privatnih datotečnih področjih';
$string['user:managesyspages'] = 'Nastavite privzeto razporeditev strani za javne uporabniške profile';
$string['user:readuserblogs'] = 'Ogled vseh blogov uporabnikov';
$string['user:readuserposts'] = 'Ogled vseh objav uporabnikov';
$string['usersfrom'] = 'Uporabniki iz {$a}';
$string['usersfrommatching'] = 'Uporabniki iz {$a->contextname}, ki se ujemajo \'{$a->search}\'';
$string['usersinthisx'] = 'Uporabniki v tem {$a}';
$string['usersinthisxmatching'] = 'Uporabniki v tem {$a->contexttype}, ki se ujemajo \'{$a->search}\'';
$string['userswithrole'] = 'Vsi uporabniki z vlogo';
$string['userswiththisrole'] = 'Uporabniki z vlogo';
$string['user:update'] = 'Posodobitev uporabniških profilov';
$string['user:viewalldetails'] = 'Ogled vseh uporabnikovih podatkov';
$string['user:viewdetails'] = 'Ogled uporabniških profilov';
$string['user:viewhiddendetails'] = 'Ogled skritih podrobnosti uporabnikov';
$string['user:viewuseractivitiesreport'] = 'Ogled poročil dejavnosti uporabnikov';
$string['user:viewusergrades'] = 'Ogled ocen uporabnikov';
$string['useshowadvancedtochange'] = 'Uporabi \'Prikaži napredno\' za spremembo';
$string['viewingdefinitionofrolex'] = 'Ogled definicije vloge \'{$a}\'';
$string['viewrole'] = 'Ogled podrobnosti vloge';
$string['webservice:createmobiletoken'] = 'Ustvari žeton spletne storitve za mobilni dostop';
$string['webservice:createtoken'] = 'Ustvari žeton spletne storitve';
$string['xroleassignments'] = 'Določene vloge za {$a}';
$string['xuserswiththerole'] = 'Uporabniki z vlogo "{$a->role}": {$a->number}';
