<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Ta kviz si lahko prej ogledate ampak, če bi bil to pravi poskus, bi bili blokirani ker:';
$string['action'] = 'Dejanje';
$string['adaptive'] = 'Prilagodljiv način';
$string['adaptive_help'] = 'Če je omogočeno, je v enem poskusu kviza možnih več odgovorov. Na primer, če je odgovor zaznamovan kot napačen, bo udeleženec lahko takoj poskušal znova. Ampak upoštevajoč nastavitve "odbitka", bo odbitek običajno odštet za vsak napačen poskus.';
$string['addaquestion'] = 'Dodaj vprašanje ...';
$string['addarandomquestion'] = 'Dodaj naključno vprašanje ...';
$string['addarandomquestion_help'] = 'Ko vstavimo naključno vprašanje, je rezultat naključno izbrano vprašanje iz kategorije, ki jo vstavimo v kviz. To pomeni, da bodo različni udeleženci dobili različne selekcije vprašanj. Če kviz omogoča več poskusov, je možnost da bo vsak poskus vseboval novo selekcijo vprašanj.';
$string['adddescriptionlabel'] = 'Dodaj opis/oznako';
$string['addingquestion'] = 'Dodajanje vprašanja';
$string['addingquestions'] = 'Na tem delu strani upravljate z vašo podatkovno zbirko vprašanj. Vprašanja so shranjena v kategorijah, da jih lažje ohranite organizirane in jih lahko uporabite v poljubnem kvizu v vašem predmetu ali celo v drugih predmetih, če se odločite in jih \'objavite\'. <br /><br />Ko izberete ali ustvarite kategorijo vprašanj, lahko ustvarite ali uredite vprašanja. Izberete in vašemu kvizu dodate lahko katerokoli izmed teh vprašanj na drugi strani te strani.';
$string['addmoreoverallfeedbacks'] = 'Dodaj {no} polja za odziv';
$string['addnewgroupoverride'] = 'Dodaj povozitev skupine';
$string['addnewpagesafterselected'] = 'Dodaj nove strani po izbranih vprašanjih';
$string['addnewquestionsqbank'] = 'Dodaj vprašanje v kategorijo {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj povozitev uporabnika';
$string['addpagehere'] = 'Tukaj dodaj stran';
$string['addquestion'] = 'Dodaj vprašanje';
$string['addquestions'] = 'Dodaj vprašanja';
$string['addquestionstoquiz'] = 'Dodaj vprašanja trenutnemu kvizu';
$string['addrandom'] = 'Dodaj {$a} naključnih vprašanj';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'naključna vprašanja';
$string['addrandomfromcategory'] = 'Dodaj naljkučne vprašanja iz kategorije:';
$string['addrandomquestion'] = 'Dodaj naključno vprašanje';
$string['addrandomquestiontoquiz'] = 'Dodaj naključno vprašanje v kviz {$a}';
$string['addselectedtoquiz'] = 'Dodaj izbrana v kviz';
$string['addtoquiz'] = 'Dodaj v kviz';
$string['affectedstudents'] = 'Prizadetih {$a}';
$string['aftereachquestion'] = 'Po dodajanju vsakega vprašanja';
$string['afternquestions'] = 'Po dodajanju {$a} vprašanj';
$string['age'] = 'starost';
$string['allattempts'] = 'Vsi poskusi';
$string['allinone'] = 'Neomejeno';
$string['allowreview'] = 'Dovoli pregled';
$string['alreadysubmitted'] = 'Verjetno ste že oddali ta poskus';
$string['alternativeunits'] = 'Alternativne mere';
$string['alwaysavailable'] = 'Vedno na voljo';
$string['analysisoptions'] = 'Možnosti analize';
$string['analysistitle'] = 'Preglednica analize elementov';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovorjeno';
$string['answerhowmany'] = 'Ena ali več rešitev?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dovoljeno več odgovorov';
$string['answersingleyes'] = 'Samo en odgovor';
$string['answertoolong'] = 'Odgovor predolg po vrstici {$a} (največ 255 znakov)';
$string['aon'] = 'AON format';
$string['areyousureremoveselected'] = 'Ste prepričani, da želite izbrisati vsa označena vprašanja?';
$string['asshownoneditscreen'] = 'Kot je prikazano na urejevalni strani';
$string['attempt'] = 'Poskus {$a}';
$string['attemptalreadyclosed'] = 'Ta poskus je bil že zaključen.';
$string['attemptclosed'] = 'Poskus ni bil še zaprt';
$string['attemptduration'] = 'Porabljeni čas';
$string['attemptedon'] = 'Poskus dne';
$string['attempterror'] = 'Trenutno vam ni dovoljeno opravljanje tega kviz zaradi: {$a}';
$string['attemptfirst'] = 'Prvi poskus';
$string['attemptincomplete'] = 'Ta poskus (od {$a}) še ni zaključen.';
$string['attemptlast'] = 'Zadnji poskus';
$string['attemptnumber'] = 'Poskus';
$string['attemptquiznow'] = 'Poskusi kviz zdaj';
$string['attempts'] = 'Poskusi';
$string['attemptsallowed'] = 'Dovoljeno poskusov';
$string['attemptsdeleted'] = 'Poskusi kviza so bili izbrisani';
$string['attemptselection'] = 'Izberite katere poskuse za uporabnika naj analiziram:';
$string['attemptsexist'] = 'Ne morete več dodati ali odstraniti vprašanj.';
$string['attemptsnum'] = 'Poskusi: {$a}';
$string['attemptsnumthisgroup'] = 'Poskusi: {$a->total} ({$a->group} iz te skupine)';
$string['attemptsnumyourgroups'] = 'Poskusi: {$a->total} ({$a->group} iz vaših skupin)';
$string['attemptsonly'] = 'Pokaži samo udeležence s poskusi';
$string['attemptstate'] = 'Stanje';
$string['attemptstillinprogress'] = 'Poskus še vedno v teku';
$string['attemptsunlimited'] = 'Neomejeno poskusov';
$string['autosaveperiod'] = 'Čas samodejnega shranjevanja';
$string['autosaveperiod_desc'] = 'Odgovori udeležencev se lahko med reševanjem kviza samodejno shranjujejo, kar obremenjuje strežnik, zmajnšuje pa možnost, da se udeležencem izgubijo odgovori.';
$string['back'] = 'Nazaj na predogled vprašanja';
$string['backtocourse'] = 'Nazaj na predmet';
$string['backtoquestionlist'] = 'Nazaj na seznam vprašanj';
$string['backtoquiz'] = 'Nazaj v urejanje kviza';
$string['basicideasofquiz'] = 'Osnovne ideja o ustvarjanju kviza';
$string['bestgrade'] = 'Najboljša ocena';
$string['bothattempts'] = 'Pokaži udeležence z in brez poskusov';
$string['browsersecurity'] = 'Zaščita spletnega brskalnika';
$string['browsersecurity_help'] = 'Če je "Full screen pop-up with some JavaScript security" označeno,

* Kviz se bo zagnal samo, če imajo udeleženci spletni brskalnik z vključenim JavaScript-om
* Kviz se prikaže v celozaslonskem pojavnem oknu, ki zakrije vsa ostala okna in nima navigacijskih kontrol
* Kolikor je mogoče je udeležencem preprečeno uporabljanje funkcij, kot na primer kopiraj in prilepi';
$string['calculated'] = 'Izračunano';
$string['calculatedquestion'] = 'Izračunano vprašanje ni podprto v vrstici {$a}. Vprašanje bo prezrto';
$string['cannotcreatepath'] = 'Poti ni možno ustvariti ({$a})';
$string['cannoteditafterattempts'] = 'Ne moreta dodati ali odstraniti vprašanj, saj ima kviz že opravljene poskuse.';
$string['cannotfindprevattempt'] = 'Ne morem najti prejšnjega poskusa, na katerem bi gradili.';
$string['cannotfindquestionregard'] = 'Napaka pri pridobivanju vprašanj za ponovno ocenjevanje!';
$string['cannotinsert'] = 'Ni možno vstaviti vprašanja';
$string['cannotinsertrandomquestion'] = 'Ne morem vstaviti novega naključnega vprašanja!';
$string['cannotloadquestion'] = 'Ne morem naložiti možnosti vprašanja';
$string['cannotloadtypeinfo'] = 'Napaka pri nalaganju podatkov o vprašanju izbranega tipa';
$string['cannotopen'] = 'Ni možno odpreti izvozne datoteke ({$a})';
$string['cannotrestore'] = 'Ne morem obnoviti seje vprašanj';
$string['cannotreviewopen'] = 'Tega poskusa ne morete pregledati, ker je še odprt.';
$string['cannotsavelayout'] = 'Ni mogoče shraniti postavitve';
$string['cannotsavenumberofquestion'] = 'Ni mogoče shraniti izbrano število vprašanj na stran';
$string['cannotsavequestion'] = 'Ni mogoče shraniti seznama vprašanj';
$string['cannotsetgrade'] = 'Ni mogoče nastaviti nove najvišje ocene kviza';
$string['cannotstartmissingquestion'] = 'Ni mogoče začeti poskusa kviza. Kviz vsebuje vprašanje, ki ne obstaja.';
$string['cannotstartnoquestions'] = 'Ni mogoče začeti poskusa kviza. Kviz še ni dodelan. Kviz ne vsebuje nobenega vprašanja.';
$string['cannotwrite'] = 'Ni možno pisati v izvozno datoteko ({$a})';
$string['caseno'] = 'Ne, velike začetnice niso pomembne';
$string['casesensitive'] = 'Občutljivo na velike začetnice';
$string['caseyes'] = 'Da, velike začetnice se morajo ujemati';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija \'{$a}\' je bila dodana';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je bila izbrisana';
$string['categorynoedit'] = 'Nimate pravic urejanja v kategoriji \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je bila uspešno posodobljena';
$string['close'] = 'Zapri okno';
$string['closebeforeopen'] = 'Posodobitev kviza ni uspela. Določen datum konca ste določili pred datumom začetka.';
$string['closed'] = 'Zaprto';
$string['closepreview'] = 'Zapri predogled';
$string['closereview'] = 'Zapri pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentiraj ali preglasi oceno';
$string['comments'] = 'Komentarji';
$string['completedon'] = 'Dokončano dne';
$string['configadaptive'] = 'Če za to nastavitev izberete Da, bodo udeleženci lahko dali več odgovorov na vprašanje, celo v istem poskusu kviza.';
$string['configattemptsallowed'] = 'Omejitev števila poskusov, ki so v kvizu dovoljeni udeležencem.';
$string['configdecimalplaces'] = 'Število decimalk, ki bodo prikazane po decimalni piki, pri prikazu ocen kviza.';
$string['configdecimalplacesquestion'] = 'Število decimalk, ki bodo prikazane po decimalni piki, pri prikazu ocen za posamezna vprašanja.';
$string['configdelay1st2nd'] = 'Če tukaj nastavite časovni zamik, udeleženci ne bodo mogli začeti drugega poskusa dokler ne preteče toliko časa od konca njihovega prvega poskusa.';
$string['configdelaylater'] = 'Če tukaj nastavite časovni zamik, udeleženci ne bodo mogli začeti tretjega, četrtega, ... poskusa dokler ne preteče toliko časa od konca njihovega prejšnjega poskusa.';
$string['configeachattemptbuildsonthelast'] = 'Če je dovoljenih več poskusov, potem vsak nov poskus vsebuje rezultate od prejšnjega poskusa.';
$string['configgrademethod'] = 'Ko je dovoljenih več poskusov, katera metoda naj se uporabi za seštevanje končne ocene udeleženca kviza.';
$string['configintro'] = 'Vrednosti, ki jih tukaj nastavite definirajo privzete vrednosti, ki so uporabljene v nastavitvenem obrazcu, ko ustvarite nov kviz. Lahko tudi nastavite, katere nastavitve kviza bodo napredne.';
$string['configmaximumgrade'] = 'Privzeta ocena po kateri je narejna lestvica ocen kviza.';
$string['confignavmethod'] = 'Ko je izbrana metoda "prosto", lahko študent odgovarja vprašanja v poljubnem redu, uporabljajoč navigacijo naprej in nazaj. Pri "zaporedni" metodi se morajo vprašanja odgovarjati striktno po v kvizu določenem zaporedju.';
$string['confignewpageevery'] = 'Pri dodajanju vprašanj v kviz, bodo avtomatsko ustvarjene prelomnice strani upoštevajoč nastavitev, ki jo tukaj izberete.';
$string['configpenaltyscheme'] = 'Odbitek za vsak napačen odgovor v prilagodljivostnem načinu.';
$string['configpopup'] = 'Prisili poskus, da se odpre v pojavnem oknu in uporablja JavaScript trike za omejitev funkcij kopiraj in prilepi itd. med poskusi kviza.';
$string['configrequirepassword'] = 'Udeleženci morajo preden poskusijo kviz vnesti to kodo.';
$string['configrequiresubnet'] = 'Udeleženci lahko poskusijo kviz samo iz teh računalnikov.';
$string['configreviewoptions'] = 'Te nastavitve kontrolirajo informacije, ki jih lahko vidijo uporabniki, ko pregledujejo poskus ali poročila kviza.';
$string['configshowblocks'] = 'Prikaži bloke med poskusi kviza.';
$string['configshowuserpicture'] = 'Med poskusi prikaži na zaslonu uporabnikovo sliko.';
$string['configshufflequestions'] = 'Če omogočite to možnost, bodo vprašanja kviza premešana vsakokrat ko udeleženec poskuša kviz.';
$string['configshufflewithin'] = 'Če omogočite to možnost, bodo deli, ki sestavljajo individualna vprašanja naključno premešani vsakokrat, ko udelešenec začne kviz. V nastavitvah vprašanja mora biti tudi ta nastavitev vključena.';
$string['configtimelimitsec'] = 'Privzeta časovna omejitev kvizov v sekundah. 0 pomeni da ni časovne omejitve.';
$string['configurerandomquestion'] = 'Konfigururaj vprašanje';
$string['confirmclose'] = 'Zaprli boste za poskus. Ko boste zaprli poskus, ne boste več mogli spremeniti vaših odgovorov.';
$string['confirmserverdelete'] = 'Ste prepričani, da želite iz seznama odstraniti strežnik <b>{$a}</b>?';
$string['confirmstartattemptlimit'] = 'Ta kviz ima omejeno število poskusov. Število dovoljenih poskusov je {$a}. Dostop do kviza bo štel kot poskus.  Želite nadaljevati?';
$string['confirmstartattempttimelimit'] = 'Ta kviz ima časovno omejitev in omejitev števila poskusov. Število dovoljenih poskusov je {$a}. Dostop do kviza bo štel kot poskus.  Želite nadaljevati?';
$string['confirmstarttimelimit'] = 'Kviz ima časovno omejitev. Ste prepričani, da želite začeti?';
$string['containercategorycreated'] = 'Ta kategorija je bila ustvarjena za hranjenje vseh originalnih kategorij premaknjenih na raven strani iz spodaj navedenih vzrokov.';
$string['continueattemptquiz'] = 'Nadaljuj zadnji poskus';
$string['continuepreview'] = 'Nadaljuj zadnji predogled';
$string['copyingfrom'] = 'Ustvarjanje kopije vprašanja \'{$a}\'';
$string['copyingquestion'] = 'Kopiranje vprašanja';
$string['correct'] = 'Pravilno';
$string['correctanswer'] = 'Pravilen odgovor';
$string['correctanswerformula'] = 'Pravilna formula odgovora';
$string['correctansweris'] = 'Pravilen odgovor: {$a}';
$string['correctanswerlength'] = 'Pomembna dejstva';
$string['correctanswers'] = 'Pravilni odgovori';
$string['correctanswershows'] = 'Pravilni odgovor prikazan';
$string['corrresp'] = 'Pravilen odziv';
$string['countdown'] = 'Odštevanje';
$string['countdownfinished'] = 'Kviz se zaključuje, svoje odgovore morate zdaj oddati.';
$string['countdowntenminutes'] = 'Kviz se bo zaključil čez deset minut.';
$string['coursetestmanager'] = 'Course Test Manager format';
$string['createcategoryandaddrandomquestion'] = 'Ustvarite kategorijo in dodajte naključno vprašanje';
$string['createfirst'] = 'Najprej morate ustvariti nekaj vprašanj s kratkimi odgovori.';
$string['createmultiple'] = 'Dodaj nekaj naključnih vprašanj v kviz';
$string['createnewquestion'] = 'Ustvari novo vprašanje';
$string['createquestionandadd'] = 'Ustvarite novo vprašanje in dodajte ga v kviz.';
$string['custom'] = 'Oblika po meri';
$string['dataitemneed'] = 'Dodati morate vsaj en nabor podatkovnih elementov, da dobite veljavno vprašanje';
$string['datasetdefinitions'] = 'Ponovno uporabne definicije naborov podatkov za kategorijo {$a}';
$string['datasetnumber'] = 'Številka';
$string['daysavailable'] = 'Dnevi na voljo';
$string['decimaldigits'] = 'Decimalna števila v ocenah';
$string['decimalplaces'] = 'Decimalna mesta v ocenah';
$string['decimalplaces_help'] = '<p>Z uporabo te nastavitve lahko izberete, koliko decimalnih mest naj bo prikazanih za decimalno vejico ob prikazu rezultatov ali ocen udeležencu. Z izborom \'0\', na primer, bodo prikazane ocene zaokrožene na cela števila.
</p><p>
Ta nastavitev vpliva samo na prikaz ocen. Ne vpliva na notranje izračune in zaokroževanje ocen.
</p>';
$string['decimalplacesquestion'] = 'Decimalna mesta v ocenah vprašanj';
$string['decimalplacesquestion_help'] = 'Ta nastavitev določa število decimalk po decimalni vejici pri prikazu ocen za posamezna vprašanja.';
$string['decimalpoints'] = 'Decimalne vejice';
$string['default'] = 'Privzeto';
$string['defaultgrade'] = 'Privzeta ocena vprašanja';
$string['defaultinfo'] = 'Privzeta kategorija za vprašanja.';
$string['delay1'] = 'Časovna zakasnitev med prvim in drugim poskusom';
$string['delay1st2nd'] = 'Prisiljen zamik med prvim in drugim poskusom';
$string['delay1st2nd_help'] = '<p>Če nastavite časovno zakasnitev, bo moral udeleženec počakati toliko časa, preden bo lahko ponovno reševal kviz.</p>';
$string['delay2'] = 'Časovni zamik med naslednjimi poskusi';
$string['delaylater'] = 'Prisilite zamik med kasnejšimi poskusi';
$string['delaylater_help'] = '<p>Če tu nastavite časovno zakasnitev, bo moral udeleženec počakati toliko časa, preden bo lahko opravljal svoj tretji ali poznejši poskus.</p>';
$string['deleteattemptcheck'] = 'Ste popolnoma prepričani, da želite popolnoma izbrisati te poskuse?';
$string['deleteselected'] = 'Izbriši izbrano';
$string['deletingquestionattempts'] = 'Brisanje poskusov';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogočeno';
$string['displayoptions'] = 'Možnosti za prikaz';
$string['donotuseautosave'] = 'Ne uporabljaj samodejnega shranjevanja';
$string['download'] = 'Kliknite za prenos izvožene datoteke kategorije';
$string['downloadextra'] = '(datoteka je shranjena tudi med datotekami predmeta v mapi /backupdata/quiz)';
$string['duplicateresponse'] = 'Oddaja je bila prezrta, ker ste enakovreden odgovor že oddali.';
$string['eachattemptbuildsonthelast'] = 'Vsak poskus temelji na prejšnjem';
$string['eachattemptbuildsonthelast_help'] = '<p>Če je dovoljenih več poskusov in je ta nastavitev nastavljena na <b>Da</b>, potem vsak nov poskus vsebuje rezultate prejšnjih poskusov. To omogoča dokončanje kviza v večih poskusih.</p>

<p>Za prikaz novega kviza ob vsakem poskusu, izberite <b>Ne</b> za to nastavitev.</p>';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategory'] = 'Uredi kategorijo';
$string['editcatquestions'] = 'Uredi vprašanja kategorije';
$string['editingquestion'] = 'Urejanje vprašanja';
$string['editingquiz'] = 'Urejanje kviza';
$string['editingquiz_help'] = 'Glavni koncepti pri ustvarjanju kviza so:

* Kviz vsebuje vprašanja na eni ali več straneh
* Banka vprašanj, v kateri se shranjujejo kopije vseh vprašanj, organiziranih v kategorije
* Naključna vprašanja - Udeleženec dobi drugačna vprašnja vsakokrat, ko poskuša kviz. Različni udeleženci lahko dobijo različna vprašanja';
$string['editingquizx'] = 'Urejanje kviza: {$a}';
$string['editoverride'] = 'Uredi povozitev';
$string['editqcats'] = 'Uredi kategorije vprašanj';
$string['editquestions'] = 'Uredi vprašanja';
$string['editquiz'] = 'Uredi kviz';
$string['editquizquestions'] = 'Uredi vprašanja kviza';
$string['emailconfirmbody'] = 'Dragi/a {$a->username},

Zahvaljujemo se vam za odpravljanje kviza
\'{$a->quizname}\'
v predmetu \'{$a->coursename}\'
dne {$a->submissiontime}.

To sporočilo potrjuje, da so bili vaši odgovori varno prejeti.

Do tega kviza lahko dostopate na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala za oddajo odgovorov v \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potrditev opravljanja kviza: {$a->quizname}';
$string['emailnotifybody'] = 'Dragi/a {$a->username},

{$a->studentname} je opravil/a kviz
\'{$a->quizname}\' ({$a->quizurl})
v predmetu \'{$a->coursename}\'

Ta poskus lahko pregledate na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je končal/a {$a->quizname}';
$string['emailnotifysubject'] = '{$a->studentname} je opravil/a kviz {$a->quizname}';
$string['emailoverduebody'] = 'Dragi/a {$a->studentname},

Začeli ste reševati kviz \'{$a->quizname}\'
pri predmetu \'{$a->coursename}\', vendar niste oddali odgovorov. To morate storiti do {$a->attemptduedate}.

Če želite dokončati ta kviz, pojdite na {$a->attemptsummaryurl} in kliknite gumb za oddajo. To morate storiti do {$a->attemptgraceend}, sicer se vam poskus ne bo štel.';
$string['emailoverduesmall'] = 'Niste oddali odgovorov kviza {$a->quizname}. Pojdite na {$a->attemptsummaryurl} pred {$a->attemptgraceend}, če jih želite oddati.';
$string['emailoverduesubject'] = 'Čas reševanje kviza {$a->quizname} je potekel';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogočeno';
$string['endtest'] = 'Končaj poskus ...';
$string['erroraccessingreport'] = 'Ne morete dostopati do tega poročila';
$string['errorinquestion'] = 'Napaka v vprašanju';
$string['errormissingquestion'] = 'Napaka: Sistem ne najde vprašanja z identifikacijo {$a}';
$string['errornotnumbers'] = 'Napaka - odgovori morajo biti številski';
$string['errorunexpectedevent'] = 'Nepričakovana koda dogodka {$a->event} ugotovljena za vprašanje {$a->questionid} pri poskusu {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Vprašanja';
$string['eventquizattemptsubmitted'] = 'Rezultati kviza so oddani';
$string['eventquizattempttimelimitexceeded'] = 'Čas za reševanje kviza je potekel';
$string['everynquestions'] = 'Vsakih {$a} vprašanj';
$string['everyquestion'] = 'Vsako vprašanje';
$string['everythingon'] = 'Vse o';
$string['export'] = 'Izvozi';
$string['exportcategory'] = 'izvozi kategorijo';
$string['exporterror'] = 'Prišlo je do napake med obdelavo izvoza';
$string['exportingquestions'] = 'Vprašanja se izvažajo v datoteko';
$string['exportname'] = 'Ime datoteke';
$string['exportquestions'] = 'Izvoz vprašanj v datoteko';
$string['extraattemptrestrictions'] = 'Dodatne omejitve pri poskusih';
$string['false'] = 'Ne drži';
$string['feedback'] = 'Odziv';
$string['feedbackerrorboundaryformat'] = 'Meje za odziv na oceno morajo biti določene s procentom ali s številko. Vrednost vnesena v mejo {$a} ni bila prepoznana.';
$string['feedbackerrorboundaryoutofrange'] = 'Meje za odziv na oceno morajo biti med 0 % in 100 &. Vrednoste vnesena v mejo {$a} ni v zalogi vrednosti.';
$string['feedbackerrorjunkinboundary'] = 'Polja za mejo za odziv na oceno morate izpolniti brez praznin.';
$string['feedbackerrorjunkinfeedback'] = 'Polja za odziv morate izpolnite brez praznin.';
$string['feedbackerrororder'] = 'Meje za odziv na oceno morajo biti v vrstnem redu od najvišje do najnižje. Vrednosti, ki ste jo vnesli v mejo {$a} ni v zaporedju.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Format datoteke';
$string['fillcorrect'] = 'Pravilno izpolni';
$string['filloutnumericalanswer'] = 'Vnesite vsaj en možno odgovor in odstopanje. Ta prvi ujemajoči odgovor bo uporabljen za določanje točk in odziva. Če boste na koncu vnesli odziv brez odgovora, bo le-ta prikazan udeležencem, katerih rešitev se ne bo ujemala s katerimkoli drugim odgovorom.';
$string['filloutoneanswer'] = 'Izpolniti morate vsaj en možen odgovor.  Prazni odgovori ne bodo uporabljeni. \'*\' lahko uporabite kot nadomestni znak za ujemanje s katerimkoli znakom. Prvi ujemajoči odgovor bo uporabljen za določanje točk in odziva.';
$string['filloutthreequestions'] = 'Podati morate vsaj tri vprašanja in ujemajoče odgovore. Podate lahko tudi več napačnih odgovorov s tem, da vpišete odgovor s praznim vprašanjem. Vnosi, pri katerih sta tako vprašanje kot odgovor prazna, ne bodo uporabljeni.';
$string['fillouttwochoices'] = 'Izpolniti morate vsaj dve izbiri.  Prazne izbire ne bodo uporabljene.';
$string['finishattemptdots'] = 'Končak poskus...';
$string['finishreview'] = 'Končaj pregled';
$string['forceregeneration'] = 'vsili obnovitev';
$string['formatnotfound'] = 'Uvozni/izvozni format {$a} ni najden';
$string['formatnotimplemented'] = 'Ta format ni pravilno implementiran, prosimo objavite poročilo o napaki (hrošču) v kodi';
$string['formulaerror'] = 'Napake v formuli!';
$string['fractionsaddwrong'] = 'Pozitivne ocene, ki ste jih izbrali, skupaj ne sestavljajo 100 %<br />Namesto tega sestavljajo {$a} %<br />Se želite vrniti in popraviti to vprašanje?';
$string['fractionsnomax'] = 'Eden izmed odgovorov mora biti 100 % tako, da je<br />možno dobiti polno oceno za to vprašanje.<br />Se želite vrniti in popraviti to vprašanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ta funkcijonalnost je trenutno onemogočena';
$string['generalfeedback'] = 'Splošni odziv';
$string['generalfeedback_help'] = '<p>Splošni odziv vprašanja je besedilo, ki se udeležencu prikaže za tem, ko odgovori na vprašanje. Za razliko navadnega odziva, ki je odvisen od vrste vprašanja in odgovora udeleženca, se vsem udeležencem prikaže isto besedilo splošnega odziva.</p>

<p>Z uporabo potrdilnih polj "Udeleženci lahko pregledujejo" v obrazcu za urejanje kviza lahko nadzorujete, kdaj se splošni odziv prikaže udeležencem.</p>

<p>Splošni odziv lahko uporabite npr. za to, da udeležencem podate informacije o tem, katera znanja je vprašanje preverjalo. Lahko jim tudi podate povezavo do informacij, ki jo lahko uporabijo, če vprašanja niso razumeli.</p>';
$string['graceperiod'] = 'Dodaten čas/podaljšek za oddajo.';
$string['graceperiod_desc'] = 'Ko se kviz zapre in je nastavljena nastavitev \'Dovoli dodaten čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov\', lahko določimo količino dodatnega časa v sekundah.';
$string['graceperiod_help'] = 'Ko se kviz zapre in je nastavljena nastavitev \'Dovoli dodaten čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov\', je to količina dodatnega časa.';
$string['graceperiodmin'] = 'Zadnji dovoljen čas za oddajo';
$string['graceperiodmin_desc'] = 'Obstaja potencialna težava ob koncu kviza. Po eni strani želimo študentu dovoliti reševanje do zadnje sekunde z nastavitvijo avtomatske oddaje ko se čas izteče, po drugi strani pa je lahko v tistem trenutki strežnik preobremenjen in potrebuje več časa da sprocesira odzive. Zatorej sprejmemo odzive v obdobju dodatnih x sekund po zaprtju kviza zaradi možnih težav s strežnikom. Vendar lahko študent goljufa in uporabi dodatne sekunde za reševanje kviza. Za pravo nastavitev se je treba odločiti na podlagi podatkov o odzivnosti in sposobnosti strežnika.';
$string['graceperiodtoosmall'] = 'Dovoljen čas mora biti večji kot {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceni vse';
$string['gradeaverage'] = 'Povprečna ocena';
$string['gradeboundary'] = 'Meja ocene';
$string['gradeessays'] = 'Oceni eseje';
$string['gradehighest'] = 'Najvišja ocena';
$string['grademethod'] = 'Metoda ocenjevanja';
$string['grademethod_help'] = '<p>Ko je dovoljenih več poskusov, obstajajo različni načini uporabe ocen za izračun končne ocene udeleženca za kviz.</p>

<h2>Najvišja ocena</h2>
<ul>
<p>Končna ocena je najvišja (najboljša) ocena izmed vseh poskusov.</p>
</ul>

<h2>Povprečna ocena</h2>
<ul>
<p>Končna ocena je povprečje (srednja vrednost) ocen vseh poskusov.</p>
</ul>

<h2>Prva ocena</h2>
<ul>
<p>Končna ocena je ocena pridobljena v prvem poskusu (drugi poskusi so prezrti).</p>
</ul>

<h2>Zadnja ocena</h2>
<ul>
<p>Končna ocena je ocena pridobljena v zadnjem izmed vseh poskusov.</p>
</ul>';
$string['gradesdeleted'] = 'Ocene kviza so bile izbrisane';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Točke za to oddajo: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'S prejšnjimi odbitki to da <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Ta oddaja povzroči odbitek {$a}.';
$string['gradingdetailszeropenalty'] = 'Za do oddajo ni odbitka.';
$string['gradingmethod'] = 'Metoda ocenjevanja: {$a}';
$string['groupoverrides'] = 'Povoženje skupin';
$string['groupsnone'] = 'V temu predmetu ni skupin';
$string['guestsno'] = 'Oprostite, gosti ne morejo videti ali poskusiti kvizov';
$string['hidebreaks'] = 'Skrij prelome strani';
$string['hidereordertool'] = 'Skrij orodje za preureditev';
$string['history'] = 'Zgodovina odgovorov:';
$string['howquestionsbehave_desc'] = 'Privzeta nastavitev obnašanja vprašanj v kvizu.';
$string['imagedisplay'] = 'Slika za prikaz';
$string['import'] = 'Uvozi';
$string['importcategory'] = 'Uvozi kategorijo';
$string['importerror'] = 'Prišlo je do napake med obdelavo uvoza';
$string['importfilearea'] = 'Uvoz iz datoteke, ki je že med datotekami predmeta...';
$string['importfileupload'] = 'Uvoz iz naložene datoteke...';
$string['importfromthisfile'] = 'Uvoz iz te datoteke';
$string['import_help'] = 'Ta funkcija vam omogoča uvoz vprašanj iz zunanjih datotek.

Če vaša datoteka vsebuje ne-acsii znake, potem mora uporabljati UTF-8 kodiranje. Bodite posebno previdni z datotekami ustvatrjenimi od Microsoft Office aplikacij, saj te pogosto uporabljajo posebno kodiranje ki ne bo pravilno delovalo.

Formati za Uvoz in Izvoz so dodani viri. Ostali neobvezni formati do lahko na voljo v Modulski ali Vtični podatkovni bazi.';
$string['importingquestions'] = 'Uvažanje {$a} vprašanj iz datoteke';
$string['importmax10error'] = 'V vprašanju je napaka. Ne morete imeti več kot deset odgovorov';
$string['importmaxerror'] = 'V vprašanju je napaka. Obstaja preveč odgovorov.';
$string['importquestions'] = 'Uvoz vprašanj iz datoteke';
$string['inactiveoverridehelp'] = '* Udeleženec nima prave skupine ali vloge za poskušanje kviza';
$string['incorrect'] = 'Napačno';
$string['indivresp'] = 'Odgovori posameznikov za vsak element';
$string['info'] = 'Informacije';
$string['infoshort'] = 'i';
$string['inprogress'] = 'V izvajanju';
$string['introduction'] = 'Uvod';
$string['invalidattemptid'] = 'Tak ID poskusa ne obstaja';
$string['invalidcategory'] = 'ID kategorije je neveljaven';
$string['invalidnumericanswer'] = 'Eden izmed vnesenih odgovorov ni veljavno število.';
$string['invalidnumerictolerance'] = 'Eno izmed vnesenih odstopanj ni veljavno število.';
$string['invalidoverrideid'] = 'Nepravilen povoženi id';
$string['invalidquestionid'] = 'Nepravilni id vprašanja';
$string['invalidquizid'] = 'Nepravilni ID kviza';
$string['invalidsource'] = 'Vir ni sprejet kot veljaven.';
$string['invalidsourcetype'] = 'Neveljavna vrsta vira.';
$string['invalidstateid'] = 'Nepravilni id stanja';
$string['lastanswer'] = 'Vaš zadnji odgovor je bil';
$string['layout'] = 'Postavitev';
$string['layoutasshown'] = 'Postavitev strani kot je prikazana.';
$string['layoutasshownwithpages'] = 'Postavitev strani kot je prikazana. <small>(Avtomatska nova stran vsakih {$a} vprašanj.)</small>';
$string['layoutshuffledandpaged'] = 'Vprašanja so naključno premešana s {$a} vprašanji na stran.';
$string['layoutshuffledsinglepage'] = 'Vprašanja so naključno premešana vsa na eni strani.';
$string['link'] = 'Povezava';
$string['listitems'] = 'Seznam elementov v kvizu';
$string['literal'] = 'Vrednost';
$string['loadingquestionsfailed'] = 'Nalaganje vprašanja ni bilo uspešno: {$a}';
$string['makecopy'] = 'Shrani kot novo vprašanje';
$string['managetypes'] = 'Upravljanje vrst vprašanj in strežnikov';
$string['manualgrading'] = 'Ocenjevanje';
$string['mark'] = 'Oddaj';
$string['markall'] = 'Oddaj stran';
$string['marks'] = 'Točke';
$string['marks_help'] = 'Numerične oznake za vsako vprašanje in skupni rezultat poskusov.';
$string['match'] = 'Ujemanje';
$string['matchanswer'] = 'Ustrezen odgovor';
$string['matchanswerno'] = 'Ujemajoč odgovor {$a}';
$string['max'] = 'Maks';
$string['messageprovider:attempt_overdue'] = 'Opozorilo, da je čas reševanja kviza potekel';
$string['messageprovider:confirmation'] = 'Potrditev vaših oddaj kviza';
$string['messageprovider:submission'] = 'Obvestila o oddajah kviza';
$string['min'] = 'Min';
$string['minutes'] = 'Minute';
$string['missingcorrectanswer'] = 'Pravilen odgovor mora biti naveden';
$string['missingitemtypename'] = 'Manjka ime';
$string['missingquestion'] = 'Kot kaže vprašanje ne obstaja.';
$string['modulename'] = 'Kviz';
$string['modulename_help'] = 'Kviz omogoča izvajalcu ustvarjati in postaviti kvize, ki vključujejo več izbir, drži/ne drži, ujemanje in ostale vrste kvizov. Vsak poskus je avtomatsko označen in učitelj lahko izbere, ali bo dal odziv in/ali prikazal pravilne odgovore.';
$string['modulenameplural'] = 'Kvizi';
$string['moveselectedonpage'] = 'Premakni izbrana vprašanja na stran: {$a}';
$string['multichoice'] = 'Več izbir';
$string['multipleanswers'] = 'Izberite vsaj en odgovor.';
$string['multiplier'] = 'Faktor';
$string['mustbesubmittedby'] = 'Rešitve morate oddati do {$a}.';
$string['name'] = 'Ime';
$string['navmethod'] = 'Navigacijska metoda';
$string['navmethod_free'] = 'Prosto';
$string['navmethod_help'] = 'Ko je izbrana "zaporedna" metoda mora študent napredovati skozi kviz zaporedno in se ne more vrniti na stran vprašanj nazaj ali preskočiti stran vprašanj naprej.';
$string['navmethod_seq'] = 'Zaporedno';
$string['navnojswarning'] = 'Opozorilo: te povezave ne bodo shranile vaših odgovorov. Uporabite gumb za napraj na dnu strani.';
$string['neverallononepage'] = 'Nikoli ne postavi vseh vprašanj na eno stran';
$string['newattemptfail'] = 'Napaka: Ni bilo možno začeti novega poskusa v kvizu';
$string['newpage'] = 'Nova stran';
$string['newpageevery'] = 'Avtomatsko začni novo stran';
$string['newpage_help'] = '<p>Za daljše kvize je smiselno raztegniti kviz prek večih strani z omejitvijo števila vprašanj na stran. Ob dodajanju vprašanj v kviz bodo samodejno vstavljeni prelomi strani glede na to nastavitev. Pozneje boste lahko tudi ročno premikali prelom strani na strani za urejanje.
</p>';
$string['noanswers'] = 'Ni izbranega odgovora!';
$string['noattempts'] = 'Za ta kviz še ni bilo opravljenega poskusa';
$string['noattemptsfound'] = 'Poskusov ni mogoče najti.';
$string['noattemptstoshow'] = 'Ni poskusov za prikaz';
$string['nocategory'] = 'Napačna ali nedoločena kategorija';
$string['noclose'] = 'Ni datuma zaključka';
$string['nocommentsyet'] = 'Še brez komentarjev.';
$string['noconnection'] = 'Trenutno ni povezave do spletnih storitev, ki bi lahko obdelale to vprašanje. Če želite več pomoči, povprašajte skrbnika';
$string['nodataset'] = 'nič - to ni nadomestni znak';
$string['nodatasubmitted'] = 'Nobenih podatkov ni bilo oddanih.';
$string['noessayquestionsfound'] = 'Ni najdenih ročno ocenjenih vprašanj';
$string['nogradewarning'] = 'Ne morete nastaviti splošnih odzivov, ki se razlikujejo po ocenah, saj kviz še ni ocenjen.';
$string['nomoreattempts'] = 'Ni več dovoljenih poskusov';
$string['none'] = 'Brez';
$string['noopen'] = 'Ni datuma odprtja';
$string['nooverridedata'] = 'Povoziti morate vsaj eno nastavitev kviza.';
$string['nopossibledatasets'] = 'Ni možnih naborov podatkov';
$string['noquestionintext'] = 'Besedilo vprašanja ne vsebuje ugnezdenih vprašanj';
$string['noquestions'] = 'Nobeno vprašanje še ni dodano';
$string['noquestionsfound'] = 'Nobenega vprašanja ni najti';
$string['noquestionsinquiz'] = 'V tem kvizu ni vprašanj.';
$string['noquestionsnotinuse'] = 'Naključno vprašanje ni v uporabi, ker je njegova kategorija prazna.';
$string['noquestionsonpage'] = 'Prazna stran';
$string['noresponse'] = 'Ni odgovora';
$string['noreview'] = 'Nimate dovoljenja za pregled tega kviza';
$string['noreviewattempt'] = 'Nimate dovoljenja za pregled tega poskusa.';
$string['noreviewshort'] = 'Ni dovoljeno';
$string['noreviewuntil'] = 'Nimate dovoljenja za pregled tega kviza do {$a}';
$string['noscript'] = 'JavaScript mora biti omogočen za nadaljevanje!';
$string['notavailabletostudents'] = 'Opomba: Ta kviz trenutno ni na voljo vašim udeležencem';
$string['notenoughsubquestions'] = 'Ni bilo določenih dovolj podvprašanj!<br />Se želite vrniti in popraviti to vprašanje?';
$string['notimedependentitems'] = 'Časovno odvisni elementi trenutno niso podprti v modulu kviza. Kot rešitev lahko uporabite nastavitev časovne omejitve za cel kviz. Želite izbrati drugačen element (ali uporabiti trenuten element kljub temu)?';
$string['notyetgraded'] = 'Še neocenjeno';
$string['notyetviewed'] = 'Še nepregledano';
$string['notyourattempt'] = 'To ni vaš poskus!';
$string['noview'] = 'Prijavljenemu uporabniku ni dovoljen ogled tega kviza';
$string['numattempts'] = '{$a->studentnum} udeležencev ({$a->studentstring}) je opravilo {$a->attemptnum} poskusov';
$string['numattemptsmade'] = '{$a} poskusov tega kviza';
$string['numberabbr'] = '#';
$string['numerical'] = 'Številčno';
$string['numquestionsx'] = 'Vprašanja: {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Samo izvajalci lahko izvozijo vprašanja';
$string['onlyteachersimport'] = 'Samo izvajalci s pravicami urejanja lahko uvozijo vprašanja';
$string['onthispage'] = 'Ta stran';
$string['open'] = 'Ni odgovorjeno';
$string['openclosedatesupdated'] = 'Datuma odprtja in zaprtja kviza sta bila posodobljena';
$string['optional'] = 'neobvezno';
$string['orderandpaging'] = 'Vrstni red in strani';
$string['orderandpaging_help'] = 'Številke 10, 20, 30, ... na nasprotni strani vsakega vprašanja določajo vrstni red vprašanj. Številke se povečujejo v korakih po 10, da pustijo prostor za vstavitev dodatnih vprašanj. Za zamenjavo vrstnega reda vprašanj, zamenjajte številke in kliknite gumb "Reorder questions".

Če želite dodati prelom strani po določeneih vprašanjih, obkljukajte kvadratke zraven vprašanj in kliknite gumb "Dodaj nove strani po izbranih vprašanjih".

Za razvrstitev vprašanj preko več strani, kliknite gumb "Ponovno ošteviči" in izberite želeno število vprašanj na stran.';
$string['orderingquiz'] = 'Vrstni red in strani';
$string['orderingquizx'] = 'Vrstni red in strani: {$a}';
$string['outcomesadvanced'] = 'Izidi so napredne nastavitve';
$string['outof'] = '{$a->grade} od možno največ {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od možne ocene {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Odziv za poskus';
$string['overallfeedback_help'] = '<p>Odziv za poskus je besedilo, ki se udeležencu prikaže po opravljenem poskusu kviza. Prikazano besedilo je lahko odvisno od ocene udeleženca za poskus.</p>

<p>Npr. če vnesete:</p>

<p>Meja ocene: 100%<br />
Odziv: Dobro opravljeno!<br />
Meja ocene: 40%<br />
Odziv: Gradiva tega tedna boste morali še enkrat predelati<br />
...<br />
Meja ocene: 0%</p>

<p>Udeleženci z oceno med 100 % in 40 % bodo po poskusu videli sporočilo "Dobro opravljeno", udeleženci z oceno med 39.99 % in 0 % pa bodo videli drugo sporočilo. To pomeni, da meje ocen določajo domete ocen, pri katerih je vsak niz odziva prikazan za točke znotraj enega izmed določenih dometov.</p>

<p>Meje ocen se lahko določijo kot odstotki (npr. "31.41%") ali kot številke (npr. "7"). Če vaš kviz sestavlja 10 točk, pomeni meja ocene 7 doseženih 7/10 točke  ali boljše.</p>';
$string['overdue'] = 'Zakasnelo';
$string['overduehandling'] = 'Ko poteče čas reševanja';
$string['overduehandlingautoabandon'] = 'Poskus mora biti zaključen preden poteče čas reševanja, sicer se ne štejejo.';
$string['overduehandlingautosubmit'] = 'Odprti poskusi se zaključijo in oddajo avtomatično';
$string['overduehandling_desc'] = 'Privzeto dejanje, če udeleženec ne reši kviza pred iztekom časa.';
$string['overduehandlinggraceperiod'] = 'Dovoli dodaten čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov';
$string['overduehandling_help'] = 'Ta nastavitev določa, kajs e zgodi, če udeleženec ne odda rezultatov kviza do izteka časa. Če udeleženec še rešuje kviz, bo števec časa samodejno oddal njegove rešitve, če pe je odjavljen, ta nastavitev določa, kaj naj se zgodi.';
$string['overduemustbesubmittedby'] = 'Poskus je potekel in odgovore bi že morali oddati. Če želite, da bo kviz ocenjen, ga morate oddati do {$a}, sicer ne boste dobili točk.';
$string['override'] = 'Povozi';
$string['overridedeletegroupsure'] = 'Ali ste prepričani da želite izbrisati povozitev skupine {$a}?';
$string['overridedeleteusersure'] = 'Ali ste prepričani da želite izbrisati povozitev uporabnika {$a}?';
$string['overridegroup'] = 'Povozi skupino';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Povozitve';
$string['overrideuser'] = 'Povozi uporabnika';
$string['overrideusereventname'] = '{$a->quiz} - Povozi';
$string['page-mod-quiz-edit'] = 'Uredi stran kviza';
$string['page-mod-quiz-x'] = 'Uredi stran kviza';
$string['pagesize'] = 'Število prikazanih poskusov na stran:';
$string['parent'] = 'Nadrejena kategorija';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['parsingquestions'] = 'Obdelovanje vprašanj iz datoteke za uvoz.';
$string['partiallycorrect'] = 'Delno pravilno';
$string['penalty'] = 'Odbitek';
$string['penaltyscheme'] = 'Uveljavi odbitke';
$string['penaltyscheme_help'] = '<p>Če kviz teče v načinu prilagajanja, potem sme udeleženec po napačnem odgovoru poskušati znova. V tem primeru boste morda želeli dodati odbitek za vsak napačen odgovor, ki naj se odšteje od končnega točkovanja za vprašanje. Višina odbitka se določa posamezno za vsako vprašanje ob nastavitvi ali urejanju vprašanja.</p>

<p>Ta nastavitev nima učinka, če kviz ne teče v načinu prilagajanja.</p>';
$string['percentcorrect'] = 'Odstotek pravilnosti';
$string['pleaseclose'] = 'Vaša zahteva je bila obdelana. Zdaj lahko zaprete to okno';
$string['pluginadministration'] = 'Administracija kviza';
$string['pluginname'] = 'Kviz';
$string['popup'] = 'Pokaži kviz v &quot;varnem&quot; oknu';
$string['popupblockerwarning'] = 'Te del testa se izvaja v varnem načinu, kar pomeni, da morate kviz reševati v varnem oknu. Prosimo, omogočite pojavna okna (popup windows). Hvala.';
$string['popupnotice'] = 'Udeleženci bodo videli ta kviz v varnem oknu';
$string['preprocesserror'] = 'Pred obdelavo je prišlo do napake!';
$string['preview'] = 'Predogled';
$string['previewquestion'] = 'Predogled vprašanja';
$string['previewquiz'] = 'Predogled {$a}';
$string['previewquiznow'] = 'Takojšnji predogled kviza';
$string['previous'] = 'Prejšnje stanje';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Imeti morate dovoljenje v objavljanju predmeta za dodajanje ali urejanje vprašanj te kategorije';
$string['qbrief'] = 'Vprašanje {$a}';
$string['qname'] = 'ime';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'Vrsta, ime';
$string['question'] = 'Vprašanje';
$string['questionbankcontents'] = 'Zbirka vprašanj';
$string['questionbankmanagement'] = 'Upravljanje z banko vprašanj';
$string['questionbehaviour'] = 'Obnašanje vprašanja';
$string['questioncats'] = 'Kategorije vprašanj';
$string['questiondeleted'] = 'To vprašanje je bilo izbrisano. Če želite več pomoči, povprašajte vašega izvajalca';
$string['questioninuse'] = 'Vprašanje \'{$a->questionname}\' se trenutno uporablja v: <br />{$a->quiznames}<br />Vprašanje ne bo izbrisano iz teh kvizov, temveč le iz seznama kategorije.';
$string['questionname'] = 'Ime vprašanja';
$string['questionnonav'] = '<span class="accesshide">Vprašanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Vprašanje {$a} ni bilo naloženo iz podatkovne baze';
$string['questionorder'] = 'Vrstni red vprašanja';
$string['questionposition'] = 'Nov vrstni red za vprašanje {$a}';
$string['questions'] = 'Vprašanja';
$string['questionsinclhidden'] = 'Vprašanja (vključno s skritimi)';
$string['questionsinthisquiz'] = 'Vprašanja v tem kvizu';
$string['questionsperpage'] = 'Vprašanj na stran';
$string['questiontext'] = 'Besedilo vprašanja';
$string['questiontextisempty'] = '[Prazno besedilo vprašanja]';
$string['questiontype'] = 'Vrsta vprašanja {$a}';
$string['questiontypesetupoptions'] = 'Možnosti nastavitev za vrste vprašanj:';
$string['quiz:addinstance'] = 'Dodajte nov kviz';
$string['quiz:attempt'] = 'Reševanje kvizov';
$string['quizavailable'] = 'Kviz je na voljo do: {$a}';
$string['quizclose'] = 'Zapri kviz';
$string['quizclosed'] = 'Kviz zaprt dne {$a}';
$string['quizcloses'] = 'Kviz se zapre';
$string['quizcloseson'] = 'Kviz se bo zaprl v {$a}';
$string['quiz:deleteattempts'] = 'Brisanje poskusov kviza';
$string['quiz:emailconfirmsubmission'] = 'Prejmi obvestilo preko e-pošte ob oddaji';
$string['quiz:emailnotifysubmission'] = 'Prejmi obvestila o oddajah preko e-pošte';
$string['quiz:emailwarnoverdue'] = 'Prejmi obvestilo, ko je poskus potekel in ga je treba oddati';
$string['quiz:grade'] = 'Ročno ocenjevanje kvizov';
$string['quiz:ignoretimelimits'] = 'Ignoriranje časovne omejitve kviza';
$string['quizisclosed'] = 'Ta kviz je zaprt';
$string['quizisclosedwillopen'] = 'Kviz je zaprt. Odpre se ob {$a}.';
$string['quizisopen'] = 'Ta kviz je odprt';
$string['quizisopenwillclose'] = 'Kviz odprt (zapre se {$a})';
$string['quiz:manage'] = 'Upravljanje kvizov';
$string['quiz:manageoverrides'] = 'Upravljanje povozitev kviza';
$string['quiznavigation'] = 'Navigacija po kvizu';
$string['quizopen'] = 'Odpri kviz';
$string['quizopenclose'] = 'Datumi odprtja in zaprtja';
$string['quizopenclose_help'] = 'Udeleženci lahko začnejo z reševanjem po odprtju kviza in morajo zaključiti reševanje pred zaprtjem.';
$string['quizopened'] = 'Kviz je odprt.';
$string['quizopenedon'] = 'Ta kviz se je odprl pri {$a}';
$string['quizopens'] = 'Kviz se odpre';
$string['quiz:preview'] = 'Predogled kvizov';
$string['quiz:regrade'] = 'Ponovno oceni poskuse kviza';
$string['quiz:reviewmyattempts'] = 'Pregled lastnih poskusov';
$string['quizsettings'] = 'Nastavitve kviza';
$string['quiztimer'] = 'Časomer kviza';
$string['quiz:view'] = 'Ogled informacij o kvizu';
$string['quiz:viewreports'] = 'Ogled poročil kviza';
$string['quizwillopen'] = 'Ta kviz se bo odpru {$a}';
$string['random'] = 'Naključno vprašanje';
$string['randomcreate'] = 'Ustvari naključna vprašanja';
$string['randomfromcategory'] = 'Naključno vprašanje iz kategorije:';
$string['randomfromexistingcategory'] = 'Naključno vprašanje iz obstoječe kategorije';
$string['randomnosubcat'] = 'Vprašanja samo iz te kategorije, ne iz njenih podkategorij.';
$string['randomquestionusinganewcategory'] = 'Naključno vprašanje, z uporabo nove kategorije';
$string['randomwithsubcat'] = 'Vprašanja iz te kategorije in njenih podkategorij.';
$string['readytosend'] = 'Poslali boste vaš cel kviz za ocenjevanje.  Ali ste prepričani, da želite nadaljevati?';
$string['reattemptquiz'] = 'Ponovni poskus kviza';
$string['recentlyaddedquestion'] = 'Nedavno dodano vprašanje!';
$string['recurse'] = 'Prikaži tudi vprašanja iz podkategorij';
$string['regrade'] = 'Ponovno oceni vse poskuse';
$string['regradecomplete'] = 'Vsi poskusi so bili ponovno ocenjeni';
$string['regradecount'] = '{$a->changed} izmed {$a->attempt} ocen je bilo spremenjenih';
$string['regradedisplayexplanation'] = 'Poskusi, ki se spremenijo med ponovnim ocenjevanjem so prikazani kot povezave na okno pregleda vprašanja';
$string['regradenotallowed'] = 'Nimate dovoljenja za ponovno ocenjevanje tega kviza';
$string['regradingquestion'] = 'Ponovno ocenjevanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocenjevanje kviza "{$a}"';
$string['remove'] = 'Odstrani';
$string['removeallquizattempts'] = 'Izbriši vse poskuse kviza';
$string['removeemptypage'] = 'Odstrani prazno stran';
$string['removeselected'] = 'Odstrani izbrano';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Strežnik {$a} ni uspel obdelati zahtevka RQP. Preverite, če je URL pravilen.';
$string['reorderquestions'] = 'Zamenjaj vrstni red vprašanj';
$string['reordertool'] = 'Pokaži orodje za spreminjanje vrstnega reda';
$string['repaginate'] = 'Preštevilči strani po {$a} vprašanj na stran';
$string['repaginatecommand'] = 'Ponastavi prelome strani v dokumentu';
$string['repaginatenow'] = 'Ponastavi prelome strani v dokumentu zdaj';
$string['replace'] = 'Zamenjaj';
$string['replacementoptions'] = 'Možnosti zamenjave';
$string['report'] = 'Poročila';
$string['reportanalysis'] = 'Analiza elementa';
$string['reportattemptsfrom'] = 'Poskusi';
$string['reportattemptsthatare'] = 'Poskusi, ki so';
$string['reportdisplayoptions'] = 'Prikaži možnosti';
$string['reportfullstat'] = 'Podrobna statistika';
$string['reportmulti_percent'] = 'Večkratni odstotki';
$string['reportmulti_q_x_student'] = 'Večkratne izbire udeležencev';
$string['reportmulti_resp'] = 'Posamezni odgovori';
$string['reportmustselectstate'] = 'Izbrati morate vsaj eno stanje';
$string['reportnotfound'] = 'Poročilo ni znano ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovno oceni poskuse';
$string['reportresponses'] = 'Podrobnosti odgovorov';
$string['reports'] = 'Poročila';
$string['reportshowonly'] = 'Prikaži le poskuse';
$string['reportsimplestat'] = 'Preprosta statistika';
$string['reportusersall'] = 'vseh uporabnikov, ki so reševali kviz';
$string['reportuserswith'] = 'vpisanih uporabnikov, ki so reševali kviz';
$string['reportuserswithorwithout'] = 'vpisanih uporabnikov, ki so že ali še niso reševali kviza';
$string['reportuserswithout'] = 'vpisanih uporabnikov, ki še niso reševali kviza';
$string['reportwhattoinclude'] = 'Kaj naj bo vključeno v poročilo';
$string['requirepassword'] = 'Zahtevaj geslo';
$string['requirepassword_help'] = '<p>To polje ni obvezno</p>

<p>Če tu navedete geslo, bodo udeleženci morali vnesti to geslo, preden bodo smeli poskusiti odgovarjati na kviz.</p>';
$string['requiresubnet'] = 'Zahtevaj omrežni naslov';
$string['requiresubnet_help'] = '<p>To polje ni obvezno.</p>

<p>Dostop do kviza lahko omejite za določene dele omrežja v lokalnem omrežju ali internetu z navedbo z vejicami ločenega seznama delnih ali celotnih IP naslovov.</p>

<p>To je še posebej uporabno za zaščito kviza, če želite, da bi recimo imele dostop do kviza samo osebe iz določene sobe.</p>

<p>Na primer:  <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>Obstajajo štiri vrste številk, ki jih lahko uporabite (ne morete uporabiti imen domen kot je npr. example.com):
<ol>
<li>Polni IP naslovi, kot je <b>192.168.10.1</b> se bodo ujemali samo z enim računalnikom (ali proxy-jem).</li>
<li>Delni naslovi, kot je <b>192.168</b> se bodo ujemali z vsemi naslovi, ki se začnejo s temi številkami.</li>
<li>CIDR zapis, kot je <b>231.54.211.0/20</b> vam omogoča natančnejše določanje dela omrežja.</li>
<li>Razpon IP naslovov <b>231.3.56.10-20</b> Razpon se nanaša na zadnji del naslova, kar pomeni vse IP naslove od 231.3.56.10 do 231.3.56.20.</li>
</ol>
</p>

<p>Presledki so prezrti.</p>';
$string['response'] = 'Odgovor';
$string['responses'] = 'Odgovori';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Nazaj na reševanje';
$string['reuseifpossible'] = 'ponovno uporabi predhodno odstranjene';
$string['reverttodefaults'] = 'Povrni na privzete nastavitve kviza';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dovoli pregled, po zaprtju kviza';
$string['reviewalways'] = 'Dovoli pregled kadarkoli';
$string['reviewattempt'] = 'Pregled poskusa';
$string['reviewbefore'] = 'Dovoli pregled, dokler je kviz odprt';
$string['reviewclosed'] = 'Po zaprtju kviza';
$string['reviewduring'] = 'Med poskusom';
$string['reviewimmediately'] = 'Takoj po poskusu';
$string['reviewnever'] = 'Nikoli ne dovoli pregleda';
$string['reviewofattempt'] = 'Pregled poskusa {$a}';
$string['reviewofpreview'] = 'Pregled predogleda';
$string['reviewopen'] = 'Pozneje, dokler je kviz še odprt';
$string['reviewoptions'] = 'Udeleženci lahko pregledujejo';
$string['reviewoptionsheading'] = 'Možnosti pregleda';
$string['reviewoptionsheading_help'] = '<p>Te nastavitve določajo, katere informacije lahko uporabniki vidijo, ko pregledujejo poskus ali poročila kviza.</p>

<p><em>Takoj po poskusu</em> pomeni znotraj dveh minut za tem, ko uporabnik zaključi poskus s klikom na \'Oddaj vse in zaključi\'.</p>

<p><em>Pozneje, dokler je kviz še odprt</em> pomeni čas za tem in do takrat, ko se kviz zapre.</p>

<p><em>Po zaprtju kviza</em> pomeni za datumom zaprtja kviza. Če kviz nima določen datum zaprtja, se to stanje nikoli ne doseže.</p>

<p>Na uporabnike z zmožnostjo \'Ogled skritih ocen\' [moodle/grade:viewhidden] (ponavadi so to izvajalci in skrbniki) ta nastavitev ne vpliva in bodo vedno lahko kadarkoli pregledovali vse informacije o poskusih udeležencev.</p>';
$string['reviewoverallfeedback'] = 'Celoten odziv';
$string['reviewoverallfeedback_help'] = 'Odziv po koncu reševanja glede na skupno oceno udeleženca.';
$string['reviewresponse'] = 'Pregled odgovora';
$string['reviewresponsetoq'] = 'Pregled odgovora (vprašanja {$a})';
$string['reviewthisattempt'] = 'Pregled vapih odgovorov za ta poskus';
$string['rqp'] = 'Oddaljeno vprašanje';
$string['rqps'] = 'Oddaljena vprašanja';
$string['sameasoverall'] = 'Enako kot pri splošnih ocenah';
$string['save'] = 'Shrani';
$string['saveandedit'] = 'Shrani spremembe in uredi vprašanja';
$string['savedfromdeletedcourse'] = 'Shranjeno iz izbrisanega predmeta "{$a}"';
$string['savegrades'] = 'Shrani ocene';
$string['savemyanswers'] = 'Shrani moje odgovore';
$string['savenosubmit'] = 'Shrani brez oddaje';
$string['saveoverrideandstay'] = 'Shrani in vnesi novo povozitev';
$string['savequiz'] = 'Shrani ta cel kviz';
$string['saving'] = 'Shranjujem';
$string['savingnewgradeforquestion'] = 'Shranjujem novo oceno za vprašanje z ID {$a}';
$string['savingnewmaximumgrade'] = 'Shranjujem novo najvišjo oceno.';
$string['score'] = 'Čisto število točk';
$string['scores'] = 'Točke';
$string['select'] = 'Izberi';
$string['selectall'] = 'Izberi vse';
$string['selectedattempts'] = 'Izbrani poskusi ...';
$string['selectnone'] = 'Počisti izbor';
$string['serveradded'] = 'Dodan strežnik';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije o strežniku';
$string['servers'] = 'Strežniki';
$string['serverurl'] = 'URL strežnika';
$string['shortanswer'] = 'Kratek odgovor';
$string['show'] = 'Pokaži';
$string['showall'] = 'Pokaži vsa vprašanja na eni strani';
$string['showblocks'] = 'Pokaži bloke med poskusi kviza';
$string['showblocks_help'] = 'Če nastavite na "da", bodo normalni bloki prikazani med poskusi kviza';
$string['showbreaks'] = 'Pokaži prelome strani';
$string['showcategorycontents'] = 'Prikaži vsebine kategorije {$a->arrow}';
$string['showcorrectanswer'] = 'Prikaži pravilne odgovore v povratni informaciji?';
$string['showdetailedmarks'] = 'Prikaži podrobnosti ocene';
$string['showeachpage'] = 'Prikaži eno stran na enkrat';
$string['showfeedback'] = 'Pokaži povratno informacijo po odgovoru?';
$string['showinsecurepopup'] = 'Za poskuse uporabi varno pojavno okno';
$string['shownoattempts'] = 'Pokaži udeležencem brez poskusa';
$string['shownoattemptsonly'] = 'Pokaži samo udeležence brez poskusov';
$string['showreport'] = 'Prikaži poročilo';
$string['showteacherattempts'] = 'Pokaži poskuse izvajalca';
$string['showuserpicture'] = 'Prikaži sliko uporabnika';
$string['showuserpicture_help'] = 'Če je omogočeno, bosta uporabnikovo ime in slika prikazana med reševanjem kviza in na  strani za pregled. To olajša nadzor identitete udeležencev med izpitom, ali so res oni prijavljeni.';
$string['shuffle'] = 'Premešaj';
$string['shuffleanswers'] = 'Pomešani odgovori';
$string['shuffledrandomly'] = 'Naključno pomešano';
$string['shufflequestions'] = 'Pomešana vprašanja';
$string['shufflequestionsselected'] = 'Nastavljena so bila pomešana vprašanja, zato nekatere dejavnosti povezane s stranmi nido na voljo. Za spremembo možnosti mešanja, {$a}';
$string['shufflewithin'] = 'Premešaj v vprašanjih';
$string['shufflewithin_help'] = '<p>Če omogočite to možnost, bodo deli, ki sestavljajo posamezna vprašanja, naključno premešani vsakič, ko bo udeleženec začel reševati kviz, seveda ob pogoju, da je to omogočeno tudi v nastavitvah vprašanja.</p>

<p>Namen je preprosto udeležencem nekoliko otežiti prepisovanje.</p>

<p>To velja samo za vprašanja, ki prikazujejo več delov, kot sta vprašanje z večimi izbirami in vprašanje ujemanja. Za vprašanja večih izbir je vrstni red premešan samo, če je ta možnost nastavljena na "Da". Za vprašanja ujemanja so odgovori vedno premešani, ta nastavitev nadzira ali se dodatno premeša vrstni red parov vprašanje - odgovor.</p>

<p>Ta možnost ni povezana z rabo Naključnih vprašanj.</p>';
$string['singleanswer'] = 'Izberite en odgovor.';
$string['sortage'] = 'Razvrsti po starosti';
$string['sortalpha'] = 'Razvrsti po imenu';
$string['sortsubmit'] = 'Razvrsti vprašanja';
$string['sorttypealpha'] = 'Razvrsti po vrsti, imenu';
$string['startagain'] = 'Začni znova';
$string['startattempt'] = 'Začni z reševanjem';
$string['startedon'] = 'Začeto dne';
$string['startnewpreview'] = 'Začni nov predogled';
$string['stateabandoned'] = 'Nikoli oddano';
$string['statefinished'] = 'Zaključeno';
$string['statefinisheddetails'] = 'Oddano {$a}';
$string['stateinprogress'] = 'V teku';
$string['statenotloaded'] = 'Stanje za vprašanje {$a} ni bilo naloženo iz baze podatkov.';
$string['stateoverdue'] = 'Poteklo';
$string['stateoverduedetails'] = 'Morate oddati do {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Ustavi se ob napaki';
$string['submitallandfinish'] = 'Oddaj vse in zaključi';
$string['subneterror'] = 'Oprostite, ta kviz je bil zaklenjen in je dostopen samo iz določenih lokacij.  Trenutno vaš računalnik ni eden izmed tistih, ki smejo uporabljati ta kviz.';
$string['subnetnotice'] = 'Ta kviz je bil zaklenjen in je dostopen samo iz določenih lokacij. Vaš računalnik ni v dovoljenem omrežju. Kot izvajalec smete kljub temu pregledovati.';
$string['subplugintype_quiz'] = 'Poročilo';
$string['subplugintype_quizaccess'] = 'Pravilo dostopa';
$string['subplugintype_quizaccess_plural'] = 'Pravilo dostopa';
$string['subplugintype_quiz_plural'] = 'Poročila';
$string['substitutedby'] = 'bo nadomeščeno z';
$string['summaryofattempt'] = 'Povzetek poskusa';
$string['summaryofattempts'] = 'Povzetek vaših predhodnih poskusov';
$string['temporaryblocked'] = 'Trenutno ne smete ponoviti poskusa v kvizu.<br />Ponovno boste lahko poskusili:';
$string['theattempt'] = 'Poskus';
$string['theattempt_help'] = 'Ali sme udeleženec pregledati svoje rešitve.';
$string['time'] = 'Čas';
$string['timecompleted'] = 'Dokončano';
$string['timedelay'] = 'Ne smete poskusiti kviza, ker še ni potekla časovna omejitev odkar ste pred tem odgovarjali na kviz';
$string['timeleft'] = 'Preostali čas';
$string['timelimit'] = 'Časovna omejitev';
$string['timelimitexeeded'] = 'Oprostite! Prekoračena časovna omejitev kviza!';
$string['timelimit_help'] = '<p align="center"><strong>Časovna omejitev</strong></p>

<p>Kot privzeto kvizi nimajo časovne omejitve, kar udeležencem za dokončanje kviza omogoča toliko časa, kolikor ga potrebujejo.</p>

<p>Če določite časovno omejitev, se za zagotovitev dokončanja kviza v tem časovnem okviru zgodi nekaj stvari </p>

<ul>
  <li>Podpora za skriptni jezik JavaScript v brskalniku postane obvezna - to omogoča, da merilec časa deluje pravilno.</li>
  <li>Prikaže se plavajoče okno z merilcem časa, ki odšteva čas na voljo</li>
  <li>Ko se čas izteče, se kviz samodejno odda izpolnjen tako, kot ga je udeleženec izpolnil do tistega trenutka.</li>
  <li>Če udeleženec uspe goljufati in porabi več kot 60 sekund preko dodeljenega časa, potem je kviz samodejno ocenjen z nič.</li>
</ul>';
$string['timelimitmin'] = 'Časovna omejitev (minute)';
$string['timelimitsec'] = 'Časovna omejitev (sekund)';
$string['timestr'] = '%H:%M:%S dne %d/%m/%y';
$string['timesup'] = 'Čas je potekel!';
$string['timetaken'] = 'Porabljeni čas';
$string['timing'] = 'Časovna uskladitev';
$string['tofile'] = 'v datoteko';
$string['tolerance'] = 'Dovoljeno odstopanje';
$string['toomanyrandom'] = 'Število zahtevanih naključnih vprašanj je večje od števila vprašanj, ki so še na voljo v tej kategoriji!';
$string['top'] = 'Vrh';
$string['totalmarksx'] = 'Skupna ocena: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Skupno {$a} vprašanj v kategoriji.';
$string['true'] = 'Drži';
$string['truefalse'] = 'Drži/Ne drži';
$string['type'] = 'Vrsta';
$string['unfinished'] = 'odprto';
$string['ungraded'] = 'Neocenjeno';
$string['unit'] = 'Enota';
$string['unknowntype'] = 'Vrsta vprašanja ni podprta v vrstici {$a}. Vprašanje bo prezrto';
$string['unusedcategorydeleted'] = 'Ta kategorija je bila izbrisana, ker po brisanju predmeta njena vprašanja niso bila več uporabljana.';
$string['updatesettings'] = 'Posodobi nastavitve kviza';
$string['updatingfinalgrades'] = 'Posodabljam končne ocene.';
$string['updatingthegradebook'] = 'Posodabljam redovalnico.';
$string['upgradesure'] = '<div style="color: red;">Še posebej bo modul kviza izvedel izčrpne spremembe v tabelah kviza in ta posodobitev še ni bila uspešno preizkušena. Močno vam priporočamo ustvarjanje varnostne kopije tabel podatkovne zbirke pred nadaljevanjem.</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ta kategorija je bila ohranjena in premaknjena na raven strani, ker je objavljena kategorija, ko jo še vedno uporabljajo drugi predmeti.';
$string['useroverrides'] = 'Uporabniške povozitve';
$string['usersnone'] = 'Do tega kviza nima noben udeleženec dostopa';
$string['validate'] = 'Preveri';
$string['viewallanswers'] = 'Ogled {$a} poskusov kviza';
$string['viewallreports'] = 'Ogled poročil za {$a} poskusov';
$string['viewed'] = 'Ogledani';
$string['warningmissingtype'] = '<b>To vprašanje je vrste, ki še ni nameščena v vaš Moodle.<br />Opozorite vašega skrbnika Moodle.</b>';
$string['wheregrade'] = 'Kje je moja ocena?';
$string['wildcard'] = 'Nadomestni znak';
$string['windowclosing'] = 'To okno bo v kratkem zaprto';
$string['withsummary'] = 's Povzetkom statistike';
$string['wronguse'] = 'Te strani ne morete uporabiti tako';
$string['xhtml'] = 'XHTML format';
$string['youneedtoenrol'] = 'Pred opravljanjem tega kviza se morate vključiti v ta predmet';
$string['yourfinalgradeis'] = 'Vaša končna ocena za ta kviz je {$a}';
