<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'bo nameščeno';
$string['action'] = 'Dejanje';
$string['actionchoice'] = 'Kaj želite narediti z datoteko \'{$a}\'?';
$string['actions'] = 'Dejanja';
$string['active'] = 'Aktivno';
$string['activeusers'] = 'Aktivni uporabniki';
$string['activities'] = 'Dejavnosti';
$string['activities_help'] = 'Dejavnosti, kot so forumi, kvizi in wiki, omogočajo dodajanje interaktivnih vsebin v učilnice.';
$string['activity'] = 'Dejavnost';
$string['activityclipboard'] = 'Premikanje te dejavnosti: {$a}';
$string['activityiscurrentlyhidden'] = 'Žal je ta dejavnost trenutno skrita';
$string['activitymodule'] = 'Modul dejavnosti';
$string['activitymodules'] = 'Moduli dejavnosti';
$string['activityreport'] = 'Poročilo dejavnosti';
$string['activityreports'] = 'Poročila dejavnosti';
$string['activityselect'] = 'Izberite to dejavnost, da jo premaknete drugam';
$string['activitysince'] = 'Dejavnost od {$a}';
$string['activityweighted'] = 'Dejavnost po uporabnikih';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj dejavnost...';
$string['addactivitytosection'] = 'Dodajte dejavnost v poglavje \'{$a}\'';
$string['addadmin'] = 'Dodaj skrbnika';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar...';
$string['addcountertousername'] = 'Ustvari uporabnika z dodajanjem številke k uporabniškemu imenu';
$string['addcreator'] = 'Dodaj ustvarjalca predmetov';
$string['adddots'] = 'Dodaj...';
$string['added'] = 'Dodan: {$a}';
$string['addedrecip'] = 'Dodan {$a} nov prejemnik';
$string['addedrecips'] = 'Dodano {$a} novih prejemnikov';
$string['addedtogroup'] = 'Dodan v skupino "{$a}"';
$string['addedtogroupnot'] = 'Ni dodan v skupino "{$a}"';
$string['addedtogroupnotenrolled'] = 'Ni dodan v skupino "{$a}", ker ni vpisan v predmet';
$string['addfilehere'] = 'Tukaj dodaj datoteko/e';
$string['addinganew'] = 'Dodajanje: {$a}';
$string['addinganewto'] = 'Dodajanje: {$a->what} v {$a->to}';
$string['addingdatatoexisting'] = 'Dodajanje podatkov v obstoječe';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Tukaj dodaj povezavo';
$string['addnewcategory'] = 'Dodaj novo kategorijo';
$string['addnewcourse'] = 'Dodaj nov predmet';
$string['addnewuser'] = 'Dodaj novega uporabnika';
$string['addnousersrecip'] = 'Dodaj na seznam prejemnikov uporabnike, ki niso dostopali do tega {$a}';
$string['addpagehere'] = 'Dodajte besedilo tukaj';
$string['addresource'] = 'Dodaj vir...';
$string['addresourceoractivity'] = 'Dodaj dejavnost ali vir';
$string['addresourcetosection'] = 'Dodajte vir v poglavje \'{$a}\'';
$string['address'] = 'Naslov';
$string['addstudent'] = 'Dodaj udeleženca';
$string['addsubcategory'] = 'Dodaj podkategorijo';
$string['addteacher'] = 'Dodaj izvajalca';
$string['admin'] = 'Skrbništvo';
$string['adminhelpaddnewuser'] = 'Za ročno ustvarjanje novega uporabniškega računa';
$string['adminhelpassignadmins'] = 'Skrbniki lahko naredijo vse in gredo kamorkoli na strani';
$string['adminhelpassigncreators'] = 'Ustvarjalci lahko ustvarijo nove predmete';
$string['adminhelpassignsiteroles'] = 'Dodeli opredeljene vloge spletnega mesta določenim uporabnikom';
$string['adminhelpassignstudents'] = 'Pojdite v predmet in dodajte udeležence v skrbniškem meniju';
$string['adminhelpauthentication'] = 'Uporabite lahko interne uporabniške račune ali zunanje zbirke podatkov';
$string['adminhelpbackup'] = 'Konfigurirajte samodejne varnostne kopije in njihov urnik';
$string['adminhelpconfiguration'] = 'Konfigurirajte kako naj stran zgleda in deluje';
$string['adminhelpconfigvariables'] = 'Konfigurirajte spremenljivke, ki vplivajo na splošno delovanje strani';
$string['adminhelpcourses'] = 'Določite predmete in kategorije ter jim dodelite osebe, uredite čakajoče predmete';
$string['adminhelpeditorsettings'] = 'Določite osnovne nastavitve za HTML urejevalnik';
$string['adminhelpedituser'] = 'Prebrskajte seznam uporabniških računov in uredite kateregakoli izmed njih';
$string['adminhelpenvironment'] = 'Preverite kako vaš strežnik ustreza trenutnim in bodočim zahtevam namestitve';
$string['adminhelpfailurelogs'] = 'Prebrskajte dnevnike neuspešnih prijav';
$string['adminhelplanguage'] = 'Za preverjanje in urejanje trenutnega jezikovnega paketa';
$string['adminhelplogs'] = 'Prebrskajte dnevnike vseh dejavnosti na tej strani';
$string['adminhelpmanageblocks'] = 'Upravljajte nameščene bloke in njihove nastavitve';
$string['adminhelpmanagedatabase'] = 'Neposreden dostop do podatkovne zbirke (bodite previdni!)';
$string['adminhelpmanagefilters'] = 'Izberite filtre besedil in njihove nastavitve';
$string['adminhelpmanagemodules'] = 'Upravljajte nameščene module in njihove nastavitve';
$string['adminhelpmanageroles'] = 'Ustvarite in opredelite vloge, ki se jih lahko določi uporabnikom';
$string['adminhelpmymoodle'] = 'Konfigurirajte bloke Moj Moodle za uporabnike';
$string['adminhelpreports'] = 'Poročila na ravni strani';
$string['adminhelpsitefiles'] = 'Za objavo splošnih datotek ali nalaganje zunanjih varnostnih kopij';
$string['adminhelpsitesettings'] = 'Določite izgled naslovne strani in spletnega mesta';
$string['adminhelpstickyblocks'] = 'Konfigurirajte lepljive bloke za celoten Moodle';
$string['adminhelpthemes'] = 'Izberite izgled strani (barve, pisave itd.)';
$string['adminhelpuploadusers'] = 'Uvoz novih uporabniških računov iz besedilne datoteke';
$string['adminhelpusers'] = 'Določite vaše uporabnike in nastavite preverjanje pristnosti';
$string['adminhelpxmldbeditor'] = 'Vmesnik za urejanje XMLDB datotek. Samo za razvijalce';
$string['administration'] = 'Skrbništvo';
$string['administrationsite'] = 'Skrbništvo strani';
$string['administrator'] = 'Skrbnik';
$string['administratordescription'] = 'Skrbniki lahko ponavadi naredijo karkoli, v vseh predmetih';
$string['administrators'] = 'Skrbniki';
$string['administratorsall'] = 'Vsi skrbniki';
$string['administratorsandteachers'] = 'Skrbniki in izvajalci';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno iskanje';
$string['advancedsettings'] = 'Dodatne nastavitve';
$string['again'] = 'ponovno';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX in Javascript';
$string['all'] = 'Vse';
$string['allactions'] = 'Vsa dejanja';
$string['allactivities'] = 'Vse dejavnosti';
$string['allcategories'] = 'Vse kategorije';
$string['allchanges'] = 'Vse spremembe';
$string['alldays'] = 'Vsi dnevi';
$string['allfieldsrequired'] = 'Vsa polja so zahtevana';
$string['allfiles'] = 'Vse datoteke';
$string['allgroups'] = 'Vse skupine';
$string['alllogs'] = 'Vsi dnevniki';
$string['allmods'] = 'Vsi {$a}';
$string['allow'] = 'Dovoli';
$string['allowinternal'] = 'Dovoli tudi notranje načine';
$string['allownone'] = 'Ne dovoli nič';
$string['allownot'] = 'Ne dovoli';
$string['allparticipants'] = 'Vsi sodelujoči';
$string['allteachers'] = 'Vsi izvajalci';
$string['alphanumerical'] = 'Sme vsebovati samo črke abecede, številke, vezaj (-) ali piko (.)';
$string['alreadyconfirmed'] = 'Registracija je bila že potrjena';
$string['always'] = 'Vedno';
$string['and'] = '{$a->one} in {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Vsak';
$string['appearance'] = 'Videz';
$string['approve'] = 'Odobri';
$string['areyousure'] = 'Ste prepričani?';
$string['areyousuretorestorethis'] = 'Ali želite nadaljevati?';
$string['areyousuretorestorethisinfo'] = 'Pozneje boste imeli možnost dodati to varnostno kopijo v obstoječ predmet ali ustvariti popolnoma nov predmet.';
$string['asc'] = 'Naraščajoče';
$string['assessment'] = 'Vrednotenje';
$string['assignadmins'] = 'Določi skrbnike';
$string['assigncreators'] = 'Določi ustvarjalce';
$string['assignsiteroles'] = 'Določi vloge spletnega mesta';
$string['authenticateduser'] = 'Avtenticiran uporabnik';
$string['authenticateduserdescription'] = 'Vsi prijavljeni uporabniki';
$string['authentication'] = 'Avtentikacija';
$string['authenticationplugins'] = 'Avtentikacijski vtičniki';
$string['autosubscribe'] = 'Samodejno naročanje foruma';
$string['autosubscribeno'] = 'Ne: ne naročaj me samodejno na forume';
$string['autosubscribeyes'] = 'Da: ko oddam objavo, me naroči na ta forum';
$string['availability'] = 'Razpoložljivost';
$string['availablecourses'] = 'Predmeti na voljo';
$string['back'] = 'Nazaj';
$string['backto'] = 'Nazaj na {$a}';
$string['backtocourselisting'] = 'Nazaj na seznam predmeta';
$string['backtopageyouwereon'] = 'Nazaj na stran kjer ste bili';
$string['backtoparticipants'] = 'Nazaj na seznam sodelujočih';
$string['backup'] = 'Varnostna kopija';
$string['backupactivehelp'] = 'Izberite, ali naj se varnostne kopije samodejno ustvarjajo ali ne';
$string['backupcancelled'] = 'Izdelava varnostne kopije preklicana';
$string['backupcoursefileshelp'] = 'Če je omogočeno, bodo datoteke predmeta vključene v samodejne varnostne kopije';
$string['backupdate'] = 'Datum varnostne kopije';
$string['backupdatenew'] = 'nbsp; {$a->TAG} je sedaj {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} je bil(a) {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Podrobnosti o varnostni kopiji';
$string['backupexecuteathelp'] = 'Izberite čas, ob katerem naj se izdelajo samodejne varnostne kopije.';
$string['backupfailed'] = 'Nekateri vaši predmeti niso bili shranjeni!';
$string['backupfilename'] = 'varnostna kopija';
$string['backupfinished'] = 'Varnostno kopiranje uspešno dokončano';
$string['backupfromthissite'] = 'Je bila varnostna kopija narejena na tej strani?';
$string['backupgradebookhistoryhelp'] = 'Če je omogočeno, bo zgodovina redovalnice vključena v samodejne varnostne kopije. Zgodovina ocen ne sme biti onemogočena v nastavitvah strežnika (disablegradehistory), če želite, da ta nastavitev deluje.';
$string['backupincludemoduleshelp'] = 'Izberite, ali želite vključiti module predmetov v samodejne varnostne kopije z uporabniškimi podatki ali brez';
$string['backupincludemoduleuserdatahelp'] = 'Izberite, ali želite v samodejne varnostne kopije vključite uporabniške podatke modula.';
$string['backupkeephelp'] = 'Koliko zadnjih varnostnih kopij za vsak predmet želite hraniti? (starejše bodo samodejno izbrisane)';
$string['backuplogdetailed'] = 'Podroben dnevnik izvajanja';
$string['backuploglaststatus'] = 'Dnevnik zadnjega izvajanja';
$string['backupmissinguserinfoperms'] = 'Opomba: Ta varnostna kopija ne vsebuje podatkov o uporabniku. Aktivnosti Vaja in Delavnica ne bosta vključeni v varnostno kopijo, ker ta dva modula nista združljiva s tem tipom varnostne kopije.';
$string['backupnext'] = 'Naslednja varnostna kopija';
$string['backupnonisowarning'] = 'Opozorilo: ta varnostna kopija izvira iz različice Moodla brez podpore Unicode (pred 1.6). Če ta varnostna kopija vsebuje besedilo, ki ni v kodni tabeli ISO-8850-1, se besedilo lahko POŠKODUJE, če ga boste poskušali obnoviti v to različico Moodla s podporo Unicode. Oglejte si <a href="http://docs.moodle.org/sl/Backup_FAQ">Pogosta vprašanja o varnostnem kopiranju</a> za več informacij o tem kako pravilno obnoviti to varnostno kopijo.';
$string['backupnotyetrun'] = 'Avtomatska varnostna kopija je v čakanju';
$string['backuporiginalname'] = 'Ime varnostne kopije';
$string['backuproleassignments'] = 'Vključi določitve vloge v varnostno kopijo za te vloge';
$string['backupsavetohelp'] = 'Celotna pot do imenika, kamor želite shraniti datoteke varnostne kopije<br />(pustite prazno za shranjevanje v privzet imenik predmeta)';
$string['backupsitefileshelp'] = 'Če je omogočeno, bodo datoteke strani, ki so v uporabi v predmetih, vključene v samodejne varnostne kopije';
$string['backuptakealook'] = 'Prosimo, oglejte si vaše dnevnike varnostnega kopiranja v:
  {$a}';
$string['backupuserfileshelp'] = 'Izberite ali naj se uporabniške datoteke (npr. slike profila) vključijo v samodejne varnostne kopije';
$string['backupversion'] = 'Različica varnostnih kopij';
$string['badges'] = 'Značke';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfiguriranje bloka {$a}';
$string['blockconfigbad'] = 'Ta blok ni bil pravilno narejen in zato ne more zagotavljati vmesnika za konfiguriranje.';
$string['blocks'] = 'Bloki';
$string['blocksaddedit'] = 'Dodaj/Uredi bloke';
$string['blockseditoff'] = 'Izključi urejanje blokov';
$string['blocksediton'] = 'Vključi urejanje blokov';
$string['blocksetup'] = 'Nastavitev tabel bloka';
$string['blocksuccess'] = '{$a} tabele so bile nastavljene pravilno';
$string['brief'] = 'Kratko';
$string['bycourseorder'] = 'Po vrstnem redu predmetov';
$string['byname'] = 'po {$a}';
$string['bypassed'] = 'Preskočeno';
$string['cachecontrols'] = 'Nadzor predpomnilnika';
$string['cancel'] = 'Prekliči';
$string['cancelled'] = 'Preklicano';
$string['categories'] = 'Kategorije predmetov';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija \'{$a}\' je bila dodana';
$string['categorycontents'] = 'Podkategorije in predmeti';
$string['categorycurrentcontents'] = 'Vsebina kategorije {$a}';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je bila izbrisana';
$string['categoryduplicate'] = 'Kategorija z imenom \'{$a}\' že obstaja!';
$string['categorymodifiedcancel'] = 'Kategorija je bila spremenjena! Prosimo, prekličite in poskusite znova.';
$string['categoryname'] = 'Ime kategorije';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je bila posodobljena';
$string['changedpassword'] = 'Spremenjeno geslo';
$string['changepassword'] = 'Spremeni geslo';
$string['changesmadereallygoaway'] = 'Naredili ste spremembe. Ste prepričani, da želite stran zapustiti in s tem izgubiti vaše spremembe?';
$string['changessaved'] = 'Spremembe so shranjene';
$string['check'] = 'Potrditev';
$string['checkall'] = 'Preveri vse';
$string['checkingbackup'] = 'Preverjanje varnostne kopije';
$string['checkingcourse'] = 'Preverjanje predmeta';
$string['checkingforbbexport'] = 'Preverjanje za izvoz BlackBoard';
$string['checkinginstances'] = 'Preverjanje primerkov';
$string['checkingsections'] = 'Preverjanje odsekov';
$string['checklanguage'] = 'Preverjanje jezika';
$string['checknone'] = 'Ne preveri ničesar';
$string['childcoursenotfound'] = 'Podrejenega predmeta ni bilo mogoče najti!';
$string['childcourses'] = 'Podrejeni predmeti';
$string['choose'] = 'Izberi';
$string['choosecourse'] = 'Izberi predmet';
$string['choosedots'] = 'Izberi...';
$string['chooselivelogs'] = 'Ali spremljaj trenutno dejavnost';
$string['chooselogs'] = 'Izberite kateri dnevnik želite videti';
$string['choosereportfilter'] = 'Izberite filter za poročilo';
$string['choosetheme'] = 'Izberite temo';
$string['chooseuser'] = 'Izberite uporabnika';
$string['city'] = 'Mesto/kraj';
$string['clambroken'] = 'Vaš skrbnik je omogočil protivirusno preverjanje za naložene datoteke, a je nekaj napačno konfiguriral.<br />Nalaganje vaše datoteke NI uspelo. Vašemu skrbniku je bilo poslano e-poštno obvestilo, da bo to lahko popravil.<br />Morda lahko poskusite naložiti to datoteko pozneje.';
$string['clamdeletedfile'] = 'Datoteka je bila izbrisana';
$string['clamdeletedfilefailed'] = 'Datoteke ni bilo možno izbrisati';
$string['clamemailsubject'] = '{$a} :: obsvetilo Clam AV';
$string['clamfailed'] = 'Clam AV se ni uspel zagnati. Vrnjeno sporočilo o napaki je bilo {$a}. Tu je rezultat iz Clam-a:';
$string['clamlost'] = 'Moodle je konfiguriran, da zažene Clam ob nalaganju datoteke, vendar je nastavljena pot do Clam AV, {$a}, neveljavna.';
$string['clamlostandactinglikevirus'] = 'Dodatno je Moodle konfiguriran tako, da so datoteke, če zagon Clam-a ni uspešen, obravnavane kot virusi. To v praksi pomeni, da noben udeleženec ne more uspešno naložiti datoteke, dokler tega ne popravite.';
$string['clammovedfile'] = 'Datoteka je bila premaknjena v imenik, ki ste ga navedli za karanteno, novo mesto je {$a}';
$string['clammovedfilebasic'] = 'Ta datoteka je bila premaknjena v imenik karantene.';
$string['clamquarantinedirfailed'] = 'Datoteke ni bilo možno premakniti v imenik karantene, ki ste ga navedli - {$a}. To morate popraviti, saj so datoteke, ki so okužene, izbrisane.';
$string['clamunknownerror'] = 'Neznana napaka v Clam-u.';
$string['cleaningtempdata'] = 'Čiščenje začasnih podatkov';
$string['clear'] = 'Počisti';
$string['clickhelpiconformoreinfo'] = '... se nadaljuje ... Za branje celotnega članka klikni na ikono pomoči';
$string['clickhere'] = 'Klikni sem ...';
$string['clicktochangeinbrackets'] = '{$a} (Kliknite za spremembo)';
$string['clicktohideshow'] = 'Klikni za razširitev ali zložitev';
$string['closewindow'] = 'Zapri to okno';
$string['collapseall'] = 'Zloži vse';
$string['commentincontext'] = 'Najdi ta komentar v kontekstu';
$string['comments'] = 'Komentarji';
$string['commentsnotenabled'] = 'Funkcija komentarjev ni omogočena';
$string['commentsrequirelogin'] = 'Za ogled komentarjev se morate prijaviti';
$string['comparelanguage'] = 'Primerjaj in uredi trenuten jezik';
$string['complete'] = 'Končano';
$string['completereport'] = 'Popolno poročilo';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potrdi';
$string['confirmcheckfull'] = 'Ali ste popolnoma prepričani, da želite potrditi {$a} ?';
$string['confirmed'] = 'Vaša registracija je bila potrjena';
$string['confirmednot'] = 'Vaša registracija še ni bila potrjena!';
$string['content'] = 'Vsebina';
$string['continue'] = 'Nadaljuj';
$string['continuetocourse'] = 'Kliknite tu za vstop v vaš predmet';
$string['convertingwikitomarkdown'] = 'Pretvarjanje Wiki v Markdown';
$string['cookiesenabled'] = 'Piškotki morajo biti omogočeni v vašem brskalniku';
$string['cookiesenabled_help'] = '<p>To mesto uporablja dva piškotka.</p>

<p>Bistven je piškotek seje, ki se običajno imenuje <b>MoodleSession</b>.  Temu piškotku morate dovoliti v vaš brskalnik, da zagotovite stalnost in ohranite vašo prijavo iz strani na stran. Ko se odjavite ali zaprete brskalnik, se ta piškotek uniči (v vašem brskalniku in na strežniku).</p>

<p>Drug piškotek je zgolj za udobje in se običajno imenuje nekaj podobnega kot <b>MOODLEID</b>.  Zapomni si vaše uporabniško ime v brskalniku. To pomeni, da bo ob vaši vrnitvi na to stran polje uporabniško ime na prijavni strani že izpolnjeno za vas. Varno lahko zavrnete ta piškotek - potem boste morali samo vsakič ponovno vnesti svoje uporabniško ime ob prijavi.</p>';
$string['cookiesnotenabled'] = 'Žal trenutno v vašem brskalniku piškotki niso omogočeni';
$string['copy'] = 'kopiraj';
$string['copyasnoun'] = 'kopiraj';
$string['copyingcoursefiles'] = 'Kopiranje datotek predmeta';
$string['copyingsitefiles'] = 'Kopiranje datotek strani, ki so v uporabi v predmetu';
$string['copyinguserfiles'] = 'Kopiranje uporabniških datotek';
$string['copyingzipfile'] = 'Kopiranje datoteke Zip';
$string['copyrightnotice'] = 'Obvestilo o avtorskih pravicah';
$string['coresystem'] = 'Osnovni sistem';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Privzeta cena';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Predmet';
$string['courseadministration'] = 'Skrbništvo predmeta';
$string['courseapprovedemail'] = 'Vaš zahtevani predmet, {$a->name}, je bil odobren in postali ste {$a->teacher}. Za dostop do vašega novega predmeta, pojdite na {$a->url}';
$string['courseapprovedemail2'] = 'Vaš zaprošeni predmet, {$a->name}, je bil odobren. Za dostop do predmeta pojdite na {$a->url}';
$string['courseapprovedfailed'] = 'Shranjevanje predmeta kot je bil odobrenega ni uspelo!';
$string['courseapprovedsubject'] = 'Vaš predmet je bil odobren!';
$string['courseavailable'] = 'Ta predmet je na voljo udeležencem';
$string['courseavailablenot'] = 'Ta predmet ni na voljo udeležencem';
$string['coursebackup'] = 'Varnostna kopija predmeta';
$string['coursecategories'] = 'Kategorije predmetov';
$string['coursecategory'] = 'Kategorija predmeta';
$string['coursecategorydeleted'] = 'Izbrisana kategorija predmetov {$a}';
$string['coursecategory_help'] = '<p>Vaš skrbnik je morda nastavil več kategorij predmetov.</p>

<p>Na primer: "Znanost", "Humanistične vede", "Javno zdravstvo" ipd.</p>

<p>Izberite tisto, ki najbolj ustreza vašemu predmetu. Izbor bo vplival na to, kje bo vaš predmet prikazan na seznamu predmetov ter bo udeležencem olajšal iskanje vašega predmet.</p>';
$string['coursecompletion'] = 'Zaključevanje predmeta';
$string['coursecompletions'] = 'Zaključevanja predmeta';
$string['coursecreators'] = 'Ustvarjalec predmeta';
$string['coursecreatorsdescription'] = 'Ustvarjalci predmeta lahko ustvarjajo nove predmete.';
$string['coursedeleted'] = 'Izbrisan predmet {$a}';
$string['coursedisplay'] = 'Postavitev predmeta';
$string['coursedisplay_help'] = 'Ta nastavitev določa, ali bo predmet v celoti prikazan na eni strani ali bo razdeljen na več strani';
$string['coursedisplay_multi'] = 'Prikaži eno sekcijo na stran';
$string['coursedisplay_single'] = 'Prikaži vse sekcije na eni strani';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Podedovane datoteke predmeta';
$string['coursefilesedit'] = 'Uredi podedovane datoteke predmeta';
$string['coursefileswarning'] = 'Datoteke predmeta so opuščene';
$string['coursefileswarning_help'] = 'Datoteke predmeta so opuščene od različice 2.0 naprej. Priporočamo uporabo zunanjih repozitorijev (baz podatkov).';
$string['courseformatdata'] = 'Podatki o obliki predmeta';
$string['courseformatoptions'] = 'Možnosti oblikovanja za {$a}';
$string['courseformats'] = 'Oblike predmeta';
$string['courseformatudpate'] = 'Posodobite obliko';
$string['coursegrades'] = 'Ocene predmeta';
$string['coursehelpcategory'] = 'Pozicionirajte predmet na seznam predmetov, s tem olajšate iskanje predmeta udeležencem.';
$string['coursehelpforce'] = 'Vsili način skupin za vsako dejavnost.';
$string['coursehelpformat'] = 'Prva stran predmeta bo prikazana v tej obliki.';
$string['coursehelphiddensections'] = 'Kako so skriti odseki v predmetu prikazani udeležencem.';
$string['coursehelpmaximumupload'] = 'Določite največjo velikost datoteke v predmetu (omejena je z omejitvijo nalaganja datotek na celotnem spletnem mestu).';
$string['coursehelpnewsitemsnumber'] = 'Število zadnjih elementov, ki se pojavijo na prvi strani predmeta, v bloku novic na desni <br/>(0 pomeni, da se blok novic ne bo pojavil).';
$string['coursehelpnumberweeks'] = 'Število tednov/tem, prikazanih na prvi strani predmeta.';
$string['coursehelpshowgrades'] = 'Omogoči prikaz redovalnice (ocen). To ne preprečuje prikaza ocen za posamezne dejavnosti.';
$string['coursehidden'] = 'Ta predmet je trenutno nedostopen za udeležence';
$string['courseinfo'] = 'Informacije o predmetu';
$string['courselegacyfiles'] = 'Podedovane datoteke predmeta';
$string['courselegacyfiles_help'] = 'Področje datotek predmeta zagotavlja delno povratno združljivost z Moodle 1.9 in prejšnjimi različami. Vse datoteke na tem področju so vedno dostopne vsem udeležencem v predmetu (če ustvarite povezavo do njih ali pa ne). Ni načina, da bi izvedeli, ali so te datoteke kjer koli uporabljene v Moodlu.

Če uporabljate to področje za shranjevanje datotek predmeta, pomislite na številna vprašanja zasebnosti in varnosti kot tudi morebitne manjkajoče datoteke varnostne kopije, če so na voljo v skupni rabi. Zato je priporočljivo, da ne uporabljate tega področja za shranjevanje, razen če res veste, kaj počnete.

Spodnja povezava omogoča več informacij o vsem tem - prikazani so boljši načini za upravljanje datotek v Moodle 2.';
$string['courselegacyfilesofcourse'] = 'Opuščene datoteke predmeta: {$a}';
$string['coursemessage'] = 'Sporočilo uporabnikom predmeta';
$string['coursenotaccessible'] = 'Ta predmet ne dovoljuje javnega dostopa';
$string['courseoverview'] = 'Pregled predmeta';
$string['courseoverviewfiles'] = 'Datoteke povzetka predmeta';
$string['courseoverviewfilesext'] = 'Končnice datotek povzetka predmeta';
$string['courseoverviewfiles_help'] = 'Datoteke povzetka predmeta, npr. slike, so prikazane v seznamu predmetov, skupaj s povzetkom.';
$string['courseoverviewfileslimit'] = 'Omejitev števila datotek povzetka predmeta';
$string['courseoverviewgraph'] = 'Graf pregleda predmeta';
$string['courseprofiles'] = 'Profili predmeta';
$string['coursereasonforrejecting'] = 'Vaši razlogi za odklon te zahteve';
$string['coursereasonforrejectingemail'] = 'To bo po e-pošti poslano osebi, ki je zahtevala predmet';
$string['coursereject'] = 'Zavrnite zahtevo za predmet';
$string['courserejected'] = 'Predmet je bil zavrnjen in kdor ga je zahteval, je bil o tem obveščen.';
$string['courserejectemail'] = 'Oprostite, predmet, ki ste ga zahtevali, je bil zavrnjen. Tu so našteti razlogi:

{$a}';
$string['courserejectreason'] = 'Naštejte razloge za zavrnitev tega predmeta<br />(to bo poslano osebi, ki je predmet zahtevala)';
$string['courserejectsubject'] = 'Vaš predmet je bil zavrnjen';
$string['coursereport'] = 'Poročilo predmeta';
$string['coursereports'] = 'Poročila predmeta';
$string['courserequest'] = 'Zahteva za predmet';
$string['courserequestdetails'] = 'Podrobnosti o predmetu, ki ga zahtevate';
$string['courserequestfailed'] = 'Vaše zahteve za predmet ni bilo možno shraniti.';
$string['courserequestintro'] = 'Uporabite ta obrazec za zahtevo predmeta, ki naj bo ustvarjen za vas.<br />Poskusite vnesti čim več informacij, da bo<br />skrbnik lažje razumel zakaj želite ta predmet.';
$string['courserequestreason'] = 'Razlogi zaradi katerih želite ta predmet';
$string['courserequestsuccess'] = 'Vaša zahteva za predmet je bila uspešno shranjena. V nekaj dneh pričakujte elektronsko sporočilo z rezultatom.';
$string['courserequestsupport'] = 'Dodatne informacije, ki lahko skrbniku pomagajo pri obravnavi zahtevka';
$string['courserestore'] = 'Obnavljanje predmeta';
$string['courses'] = 'Predmeti';
$string['coursesectionsummaries'] = 'Povzetek odseka predmeta';
$string['coursesettings'] = 'Privzete nastavitve predmeta';
$string['coursesmovedout'] = 'Predmet je bil premaknjen iz {$a}';
$string['coursespending'] = 'Predmeti, ki čakajo na odobritev';
$string['coursestart'] = 'Začetek predmeta';
$string['coursesummary'] = 'Povzetek predmeta';
$string['coursesummary_help'] = 'Povzetek predmeta je prikazan na seznamu predmetov. Iskalnik išče po besedilu povzetka predmeta in imena.';
$string['courseupdates'] = 'Posodobitve predmeta';
$string['create'] = 'Ustvari';
$string['createaccount'] = 'Ustvari moj nov račun';
$string['createcategory'] = 'Ustvari kategorijo';
$string['createfolder'] = 'Ustvari imenik v {$a}';
$string['createnewcategory'] = 'Ustvari novo kategorijo';
$string['createnewcourse'] = 'Ustvari nov predmet';
$string['createnewsubcategory'] = 'Ustvari novo podkategorijo';
$string['createsubcategoryof'] = 'Ustvari podkategorijo {$a}';
$string['createuser'] = 'Ustvarite uporabnika';
$string['createuserandpass'] = 'Izberite svoje uporabniško ime in geslo';
$string['createziparchive'] = 'Ustvari arhiv zip';
$string['creatingblocks'] = 'Ustvarjanje blokov';
$string['creatingblocksroles'] = 'Ustvarjanje lastnosti vlog na nivoju blokov';
$string['creatingblogsinfo'] = 'Ustvarjanje podatkov o blogih';
$string['creatingcategoriesandquestions'] = 'Ustvarjanje kategorij in vprašanj';
$string['creatingcoursemodules'] = 'Ustvarjanje modulov predmeta';
$string['creatingcourseroles'] = 'Ustvarjanje lastnosti vlog na nivoju predmetov';
$string['creatingevents'] = 'Ustvarjanje dogodkov';
$string['creatinggradebook'] = 'Ustvarjanje redovalnice';
$string['creatinggroupings'] = 'Ustvarjanje skupkov';
$string['creatinggroupingsgroups'] = 'Dodajanje skupin v skupke';
$string['creatinggroups'] = 'Ustvarjanje skupin';
$string['creatinglogentries'] = 'Ustvarjanje dnevniških zapiskov';
$string['creatingmessagesinfo'] = 'Ustvarjanje informacij o sporočilih';
$string['creatingmodroles'] = 'Ustvarjanje lastnosti vlog na nivoju modulov';
$string['creatingnewcourse'] = 'Ustvarjanje novega predmeta';
$string['creatingrolesdefinitions'] = 'Ustvarjanje definicij vlog';
$string['creatingscales'] = 'Ustvarjanje lestvic';
$string['creatingsections'] = 'Ustvarjanje odsekov';
$string['creatingtemporarystructures'] = 'Ustvarjanje začasnih struktur';
$string['creatinguserroles'] = 'Ustvarjanje lastnosti vlog na nivoju spletnega mesta';
$string['creatingusers'] = 'Ustvarjanje uporabnikov';
$string['creatingxmlfile'] = 'Ustvarjanje datoteke XML';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Trenutni predmet';
$string['currentcourseadding'] = 'Trenuten predmet, dodajanje podatkov vanj';
$string['currentcoursedeleting'] = 'Trenuten predmet, njegovo brisanje';
$string['currentlanguage'] = 'Trenuten jezik';
$string['currentlocaltime'] = 'vaš trenuten lokalni čas';
$string['currentlyselectedusers'] = 'Trenutno izbrani uporabniki';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacije o trenutni različici';
$string['currentversion'] = 'Trenutna različica';
$string['databasechecking'] = 'Nadgradnja podatkovne zbirke Moodle iz različice {$a->oldversion} v {$a->newversion}...';
$string['databaseperformance'] = 'Učinkovitost podatkovne zbirke';
$string['databasesetup'] = 'Nastavitev podatkovne zbirke';
$string['databasesuccess'] = 'Podatkovna zbirka je bila uspešno nadgrajena';
$string['databaseupgradebackups'] = 'Različica varnostne kopije je zdaj {$a}';
$string['databaseupgradeblocks'] = 'Različica blokov je zdaj {$a}';
$string['databaseupgradegroups'] = 'Različica skupin je sedaj {$a}';
$string['databaseupgradelocal'] = 'Prilagoditev lokalne podatkovne zbirke je zdaj različice {$a}';
$string['databaseupgrades'] = 'Nadgrajevanje podatkovne zbirke';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum spremembe';
$string['datemostrecentfirst'] = 'Datum - najnovejši prvi';
$string['datemostrecentlast'] = 'Datum - najnovejši zadnji';
$string['day'] = 'dan';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Dekodiranje notranjih povezav';
$string['default'] = 'Privzeto';
$string['defaultcoursestudent'] = 'Udeleženec';
$string['defaultcoursestudentdescription'] = 'Udeleženci imajo ponavadi manj privilegijev znotraj predmeta.';
$string['defaultcoursestudents'] = 'Udeleženci';
$string['defaultcoursesummary'] = 'Napišite jedrnat in zanimiv odstavek, ki pojasni za kaj gre v tem predmetu';
$string['defaultcourseteacher'] = 'Izvajalec';
$string['defaultcourseteacherdescription'] = 'Izvajalci lahko počnejo karkoli v predmetu, tudi spreminjajo dejavnosti in ocenjujejo udeležence.';
$string['defaultcourseteachers'] = 'Izvajalci';
$string['defaulteditor'] = 'Privzeti urejevalnik';
$string['delete'] = 'Izbriši';
$string['deleteablock'] = 'Izbriši blok';
$string['deleteall'] = 'Izbriši vse';
$string['deleteallcannotundo'] = 'Izbriši vse - ni mogoče razveljaviti';
$string['deleteallcomments'] = 'Izbriši vse komentarje';
$string['deleteallratings'] = 'Izbriši vse ocene';
$string['deletecategory'] = 'Izbriši kategorijo: {$a}';
$string['deletecategorycheck'] = 'Ste popolnoma prepričani, da želite v celoti izbrisati to kategorijo <b>\'{$a}\'</b>?<br />To bo premaknilo vse predmete v nadrejeno kategorijo, če obstaja, ali v Razno.';
$string['deletecategorycheck2'] = 'Če izbrišete to kategorijo, morate izbrati kaj se bo zgodilo s predmeti in podkategorijami, ki jih vsebuje.';
$string['deletecategoryempty'] = 'Ta kategorija je prazna.';
$string['deletecheck'] = 'Izbriši {$a} ?';
$string['deletecheckfiles'] = 'Ste popolnoma prepričani, da želite izbrisati te datoteke?';
$string['deletecheckfull'] = 'Ste popolnoma prepričani, da želite dokončno izbrisati {$a} ?';
$string['deletechecktype'] = 'Ste prepričani, da želite izbrisati {$a->type}?';
$string['deletechecktypename'] = 'Ste prepričani, da želite izbrisati {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Izbrisali boste te datoteke';
$string['deletecomment'] = 'Izbriši ta komentar';
$string['deletecompletely'] = 'Dokončno izbriši';
$string['deletecourse'] = 'Izbriši predmet';
$string['deletecoursecheck'] = 'Ste popolnoma prepričani, da želite dokončno izbrisati ta predmet in vse podatke, ki jih vsebuje?';
$string['deleted'] = 'Izbrisano';
$string['deletedactivity'] = 'Izbrisano {$a}';
$string['deletedcourse'] = '{$a} je bil popolnoma izbrisan';
$string['deletednot'] = 'Ni bilo možno izbrisati {$a} !';
$string['deletelogs'] = 'Izbriši dnevnike';
$string['deleteselected'] = 'Izbriši izbrano';
$string['deleteselectedkey'] = 'Izbriši izbran ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje obstoječih podatkov predmeta';
$string['deletingolddata'] = 'Brisanje starih podatkov';
$string['department'] = 'Oddelek';
$string['desc'] = 'Padajoče';
$string['description'] = 'Opis';
$string['deselectall'] = 'Počisti izbor';
$string['detailedless'] = 'Manj podrobno';
$string['detailedmore'] = 'Bolj podrobno';
$string['directory'] = 'Imenik';
$string['disable'] = 'Onemogoči';
$string['disabledcomments'] = 'Komentarji so onemogočeni';
$string['displayingfirst'] = 'Samo prvih {$a->count} {$a->things} je prikazanih';
$string['displayingrecords'] = 'Prikazanih {$a} zapisov';
$string['displayingusers'] = 'Prikazovanje uporabnikov {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na strani';
$string['dndenabled_inbox'] = 'Datoteke lahko dodate da jih povlečete in spustite sem.';
$string['dndnotsupported'] = 'Nalaganje z metodo "povleci in spusti" ni podprto';
$string['dndnotsupported_help'] = 'Vaš brskalnik ne podpira metode nalaganja "povleci in spusti".<br />Ta metoda je podprta v vseh zadnjih verzijah brskalnikov Chrome, Firefox in  Safari, kot tudi v Explorer v10 in višjih.';
$string['dndnotsupported_insentence'] = 'metoda "povleci in spusti" ni podprta';
$string['dnduploadwithoutcontent'] = 'Ta naložek nima nobene vsebine.';
$string['dndworkingfile'] = 'Za nalaganje, datoteke povlecite in spustite v sekcije predmeta';
$string['dndworkingfilelink'] = 'Za nalaganje, datoteke ali povezave povlecite in spustite v sekcije predmeta';
$string['dndworkingfiletext'] = 'Za nalaganje, datoteke ali tekst povlecite in spustite v sekcije predmeta';
$string['dndworkingfiletextlink'] = 'Za nalaganje, datoteke, tekst ali povezave povlecite in spustite v sekcije predmeta';
$string['dndworkinglink'] = 'Za nalaganje, povezave povlecite in spustite v sekcije predmeta';
$string['dndworkingtext'] = 'Za nalaganje, tekst povlecite in spustite v sekcije predmeta';
$string['dndworkingtextlink'] = 'Za nalaganje, tekst ali povezave povlecite in spustite v sekcije predmeta';
$string['documentation'] = 'Moodle dokumentacija';
$string['dontsortcategories'] = 'Ne razvrsti kategorij';
$string['dontsortcourses'] = 'Ne razvrsti predmetov';
$string['down'] = 'Dol';
$string['download'] = 'Prenos';
$string['downloadall'] = 'Prenesi vse';
$string['downloadexcel'] = 'Prenesi v Excel formatu';
$string['downloadfile'] = 'Prenesi datoteko';
$string['downloadods'] = 'Prenesi v formatu ODS';
$string['downloadtext'] = 'Prenesi v tekstovnem formatu';
$string['doyouagree'] = 'Ste prebrali te pogoje in jih razumeli?';
$string['droptoupload'] = 'Za nalaganje, spustite datoteke sem';
$string['duplicate'] = 'Podvoji';
$string['duplicateconfirm'] = 'Ste prepričani da želite podvojiti {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Vrnite se na predmet';
$string['duplicatecontedit'] = 'Uredite novo kopijo';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' je bilo uspešno podvojeno';
$string['duplicatinga'] = 'Podvajanje: {$a}';
$string['edhelpaspellpath'] = 'Za uporabo preverjanja črkovanja v urejevalniku, MORATE na vašem strežniku imeti nameščen <strong>aspell 0.50</strong> ali novejšo različico ter morate navesti pravilno pot za dostop do binarnih datotek aspell. Na sistemih Unix/Linux, je ta pot običajno <strong>/usr/bin/aspell</strong>, vendar je lahko tudi drugačna.';
$string['edhelpbgcolor'] = 'Določite barvo ozadja področja urejevalnika.<br />Veljavni vrednosti sta na primer: #FFFFFF ali white';
$string['edhelpcleanword'] = 'Ta nastavitev omogoči ali onemogoči filtriranje značilnega oblikovanja programa Word.';
$string['edhelpenablespelling'] = 'Omogoči ali onemogoči preverjanje črkovanja. Če je omogočeno, mora biti na strežniku nameščen <strong>aspell</strong>. Druga vrednost je <strong>privzet besednjak</strong>. Ta vrednost bo uporabljena, če aspell nima besednjaka za jezik uporabnika.';
$string['edhelpfontfamily'] = 'Lastnost družine pisave je seznam imen družin pisav in/ali generičnih imen družin. Imena družin morajo biti ločena z vejico.';
$string['edhelpfontlist'] = 'Določite pisave, ki so uporabljene v meniju spustnega seznama urejevalnika.';
$string['edhelpfontsize'] = 'Privzeta velikost pisave nastavi velikost pisave. <br />Veljavne vrednosti so na primer: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Uredi {$a}';
$string['editcategorysettings'] = 'Uredi nastavitve kategorije';
$string['editcategorythis'] = 'Uredi to kategorijo';
$string['editcoursesettings'] = 'Uredi nastavitve predmeta';
$string['editfiles'] = 'Uredi datoteke';
$string['editgroupprofile'] = 'Uredi profil skupine';
$string['editinga'] = 'Urejanje {$a}';
$string['editingteachershort'] = 'Urejevalnik';
$string['editlock'] = 'Te vrednosti ni možno urediti!';
$string['editmyprofile'] = 'Uredi profil';
$string['editorbgcolor'] = 'Barva ozadja';
$string['editorcleanonpaste'] = 'Počisti Word HTML ob lepljenju';
$string['editorcommonsettings'] = 'Splošne nastavitve';
$string['editordefaultfont'] = 'Privzeta pisava';
$string['editorenablespelling'] = 'Omogoči črkovanje';
$string['editorfontlist'] = 'Seznam pisav';
$string['editorfontsize'] = 'Privzeta velikost pisave';
$string['editorresettodefaults'] = 'Ponastavi na privzete vrednosti';
$string['editorsettings'] = 'Nastavitve urejevalnika';
$string['editorshortcutkeys'] = 'Tipke za bližnjice v urejevalniku';
$string['editsettings'] = 'Uredi nastavitve';
$string['editsummary'] = 'Uredi povzetek';
$string['editthisactivity'] = 'Uredi to dejavnost';
$string['editthiscategory'] = 'Uredi to kategorijo';
$string['edittitle'] = 'Uredi naslov';
$string['edittitleinstructions'] = 'Pritisnite tipko \'Escape\' za prekinitev, \'Enter\' za zaključek';
$string['edituser'] = 'Uredi uporabniške račune';
$string['email'] = 'Naslov e-pošte';
$string['emailactive'] = 'E-pošta aktivirana';
$string['emailagain'] = 'E-pošta (ponovno)';
$string['emailcharset'] = 'Nabor znakov za e-pošto';
$string['emailconfirm'] = 'Potrdite vaš račun';
$string['emailconfirmation'] = 'Pozdravljeni {$a->firstname},

Na \'{$a->sitename}\' je bil z vašim e-poštnim naslovom zahtevan nov uporabniški račun.

Za potrditev vašega novega računa obiščite ta spletni naslov:

{$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete. Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potrditev računa';
$string['emailconfirmsent'] = '<p>Na vaš naslov <b>{$a}</b> bi moralo biti poslano elektronsko sporočilo.</p>
   <p>Vsebuje enostavna navodila za dokončanje vaše registracije.</p>
   <p>Če bi še naprej imeli težave, se obrnite na skrbnika spletnega mesta.</p>';
$string['emaildigest'] = 'Vrsta e-poštnega izvlečka';
$string['emaildigestcomplete'] = 'Popoln (dnevna e-pošta s celotnimi objavami)';
$string['emaildigestoff'] = 'Brez izvlečkov (eno e-poštno sporočilo na objavo v forumu)';
$string['emaildigestsubjects'] = 'Zadeve (dnevna e-pošta samo z zadevami)';
$string['emaildisable'] = 'Ta naslov e-pošte je onemogočen';
$string['emaildisableclick'] = 'Kliknite tu, da bi onemogočili pošiljanje vse e-pošte na ta naslov';
$string['emaildisplay'] = 'Prikaz e-pošte';
$string['emaildisplaycourse'] = 'Samo drugim članom predmeta dovoli videti moj e-poštni naslov';
$string['emaildisplayhidden'] = 'e-naslov skrit';
$string['emaildisplayno'] = 'Pred vsemi skrij moj e-poštni naslov';
$string['emaildisplayyes'] = 'Vsem dovoli videti moj e-poštni naslov';
$string['emailenable'] = 'Ta naslov e-pošte je omogočen';
$string['emailenableclick'] = 'Kliknite tu, da bi ponovno omogočili pošiljanje vse e-pošte na ta naslov';
$string['emailexists'] = 'Ta  e-poštni naslov je že registriran.';
$string['emailformat'] = 'Oblika e-pošte';
$string['emailmustbereal'] = 'Opomba: vaš e-poštni naslov mora biti resničen';
$string['emailnotallowed'] = 'E-poštni naslovi teh domen niso dovoljeni ({$a})';
$string['emailnotfound'] = 'Tega elektronskega naslova ni bilo najti v podatkovni zbirki';
$string['emailonlyallowed'] = 'Ta e-pošta ni ena tistih, ki so dovoljene ({$a})';
$string['emailpasswordchangeinfo'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš uporabniški račun na spletnem mestu \'{$a->sitename}\'.

Za spremembo gesla pojdite na spodnjo povezavo:

{$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete. Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika strani,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš uporabniški račun na spletnem mestu \'{$a->sitename}\'.

Žal je bil uporabniški račun na tej strani onemogočen in ga ni mogoče ponastaviti. Obrnite se na skrbnika strani, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš
uporabniški račun na \'{$a->sitename}\'.

Žal gesel na tem spletnem mestu ni mogoče ponastaviti,
zato se obrnite na skrbnika strani,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Spremeni informacije o geslu';
$string['emailpasswordconfirmation'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetno vi) je zahteval novo geslo za vaš
uporabniški račun na \'{$a->sitename}\'.

Za potrditev tega, da se vam novo geslo pošlje prek e-pošte,
obiščite naslednji spletni naslov:

{$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete.  Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, povprašajte skrbnika spletnega mesta,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Potrditev spremembe gesla';
$string['emailpasswordconfirmmaybesent'] = '<p>Če ste vnesli pravilno uporabniško ime ali naslov, smo vam poslali sporočilo preko e-pošte.</p>
<p>V tem sporočilu najdete enostavna navodila za potrditev in izvedbo zamenjave gesla. V primeru težav se obrnite na skrbnika spletnega mesta.</p>';
$string['emailpasswordconfirmsent'] = 'Na vaš naslov <b>{$a}</b> je bilo poslano elektronsko sporočilo.
<br />Vsebuje enostavna navodila za potrditev in dokončanje te spremembe gesla.
Če bi še naprej imeli težave, se obrnite na skrbnika spletnega mesta.';
$string['emailpasswordsent'] = 'Hvala za potrditev spremembe gesla.
Elektronska pošta z vašim novim geslom je bila poslana na vaš naslov <br /><b>{$a->email}</b>.<br />
Novo geslo je bilo samodejno generirano - morda boste želeli
<a href="{$a->link}">spremeniti vaše geslo</a> v nekaj, kar si boste lažje zapomnili.';
$string['emailresetconfirmation'] = 'Pozdravljeni, {$a->firstname},

Na {$a->sitename} smo za vaš račun \'{$a->username}\' prejeli zahtevo za ponastavitev gesla.

Za potrditev te zahteve vas prosimo, da obiščete sledečo povezavo in nastavite novo geslo za vaš račun:

{$a->link}
(Ta povezava je veljavna še {$a->resetminutes} minut po sprožitvi zahteve za ponastavitev gesla)

Če te ponastavitve gesla niste zahtevali, vam ni potrebno storiti ničesar.

Če potrebujete pomoč, vas prosimo, da se obrnete na skrbnika spletnega mesta,
{$a->admin}';
$string['emailresetconfirmsent'] = 'E-pošta je bila poslana na vaš naslov na <b>{$a}</b>.
<br />V njej so enostavna navodila za potrditev in dokončanje spremembe gesla.
Če kljub temu še vedno naletite na težave, se obrnite na skrbnika spletnega mesta.';
$string['enable'] = 'Omogoči';
$string['encryptedcode'] = 'Šifrirana koda';
$string['english'] = 'Angleščina';
$string['entercourse'] = 'Kliknite za vstop v ta predmet';
$string['enteremail'] = 'Vnesite vaš e-poštni naslov';
$string['enteremailaddress'] = 'Vnesite vaš e-poštni naslov za ponastavitev vašega
   gesla in pošiljanje novega gesla prek elektronske pošte.';
$string['enterusername'] = 'Vnesite vaše uporabniško ime';
$string['entries'] = 'Vnosi';
$string['error'] = 'Napaka';
$string['errorcreatingactivity'] = 'Primerka dejavnosti \'{$a}\' ni bilo mogoče ustvariti';
$string['errorfiletoobig'] = 'Datoteka je večja od omejitve {$a} bajtov.';
$string['errornouploadrepo'] = 'Za to stran ni omogočeno nobeno skladišče za nalaganje';
$string['errorwhenconfirming'] = 'Niste še potrjeni, ker je prišlo do napake. Če ste kliknili na povezavo v e-pošti, da ste prišli sem, se prepričajte, da vrstica v vašem e-poštnem sporočilu ni prelomljena ali oblita. Morda boste morali uporabiti izrezovanje in lepljenje (copy - paste), da bi pravilno sestavili povezavo.';
$string['everybody'] = 'Vsakdo';
$string['executeat'] = 'Izvedi ob';
$string['existing'] = 'Obstoječe';
$string['existingadmins'] = 'Obstoječi skrbniki';
$string['existingcourse'] = 'Obstoječi predmet';
$string['existingcourseadding'] = 'Obstoječ predmet, dodajanje podatkov vanj';
$string['existingcoursedeleting'] = 'Obstoječ predmet, njegovo brisanje';
$string['existingcreators'] = 'Obstoječi ustvarjalci predmetov';
$string['existingstudents'] = 'Vpisani udeleženci';
$string['existingteachers'] = 'Obstoječi izvajalci';
$string['expandall'] = 'Razširi vse';
$string['explanation'] = 'Pojasnilo';
$string['extendenrol'] = 'Podaljšaj vpis (posamično)';
$string['extendperiod'] = 'Obdobje podaljšanja';
$string['failedloginattempts'] = '{$a->attempts} spodletelih prijav od vaše zadnje prijave';
$string['failedloginattemptsall'] = '{$a->attempts} spodletelih prijav za {$a->accounts} računov';
$string['feedback'] = 'Povratna informacija';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Datoteka z imenom {$a} že obstaja';
$string['filemissing'] = '{$a} manjka';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke in prenosi';
$string['filesfolders'] = 'Datoteke / imeniki';
$string['filetoolarge'] = 'je prevelika za naložitev';
$string['fileuploadwithcontent'] = 'Naložki datotek ne smejo vsebovati parametrov vsebine.';
$string['filloutallfields'] = 'Prosimo, izpolnite vsa polja tega obrazca';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Najdi več predmetov...';
$string['firstaccess'] = 'Prvi dostop';
$string['firstname'] = 'Ime';
$string['firsttime'] = 'Je to vaš prvi obisk?';
$string['folder'] = 'Mapa';
$string['folderclosed'] = 'Zaprta mapa';
$string['folderopened'] = 'Odprta mapa';
$string['followingoptional'] = 'Sledeči elementi so neobvezni';
$string['followingrequired'] = 'Sledeči elementi so zahtevani';
$string['force'] = 'Vsili';
$string['forcelanguage'] = 'Vsili jezik';
$string['forceno'] = 'Ne vsili';
$string['forcepasswordchange'] = 'Vsili spremembo gesla';
$string['forcepasswordchangecheckfull'] = 'Ste popolnoma prepričani, da želite vsiliti spremembo gesla za {$}?';
$string['forcepasswordchange_help'] = 'Od uporabnika ob naslednji prijavi zahtevaj, da spremeni geslo.';
$string['forcepasswordchangenot'] = 'Ne morem vsiliti spremembo gesla za {$a}';
$string['forcepasswordchangenotice'] = 'Za nadaljevanje morate spremeniti svoje geslo.';
$string['forcetheme'] = 'Vsili temo';
$string['forgotaccount'] = 'Izgubljeno geslo?';
$string['forgotten'] = 'Ste pozabili svoje uporabniško ime ali geslo?';
$string['forgottenduplicate'] = 'Ta naslov e-pošte uporablja več uporabniških računov, prosimo vnesite uporabniško ime';
$string['forgotteninvalidurl'] = 'Napačen naslov URL za spreminjanje gesla';
$string['format'] = 'Oblika';
$string['format_help'] = '<h2>LAMS oblika predmeta</h2>
<p class="indent">
Ta oblika nastavi vmesnik Learning Activity Management System (LAMS) kot vodilni v predmetu. Uporaba te oblike zahteva LAMS nastavitev s strani skrbnika.</p>

<h2>Oblika SCORM</h2>
<p class="indent">
Ta oblika prikaže SCORM paket v prvem odseku začetne strani predmeta. (Modul SCORM/AICC ponuja alternativno metodo za prikaz SCORM paketa v predmetu.)</p>

<h2>Družabna oblika</h2>
<p class="indent">
Ta oblika je usmerjena k enemu glavnemu forumu (družabnemu forumu), ki se pojavi na seznamu na glavni strani. Oblika je uporabna za situacije bolj proste oblike, morda celo niso predmeti. Uporablja se lahko na primer kot oglasna deska posameznega oddelka.</p>

<h2>Oblika poglavij</h2>
<p class="indent">
Predmet je organiziran v odseke s posameznimi poglavji. Vsako odsek s poglavjem je sestavljen iz dejavnosti.</p>

<h2>Tedenska oblika</h2>
<p class="indent">
Predmet je organiziran teden za tednom z jasnim datumom začetka in datumom konca. Vsak teden je sestavljen iz dejavnosti.</p>

<h2>Tedenska oblika - CSS/Brez tabel</h2>
<p class="indent">
Ta predmet je organiziran teden za tednom brez uporabe tabel pri postavitvi.</p>';
$string['formathtml'] = 'HTML format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Oblika golega besedila';
$string['formattext'] = 'Samodejno oblikovanje';
$string['formattexttype'] = 'Oblikovanje';
$string['framesetinfo'] = 'Ta dokument tipa frameset vsebuje:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombiniran seznam';
$string['frontpagecategorynames'] = 'Seznam kategorij';
$string['frontpagecourselist'] = 'Seznam predmetov';
$string['frontpagecoursesearch'] = 'Iskalnik predmetov';
$string['frontpagedescription'] = 'Opis naslovne strani';
$string['frontpagedescriptionhelp'] = 'Ta opis spletnega mesta bo prikazan na naslovni strani';
$string['frontpageenrolledcourselist'] = 'Vpisani predmeti';
$string['frontpageformat'] = 'Oblika naslovne strani';
$string['frontpageformatloggedin'] = 'Oblika naslovne strani po prijavi';
$string['frontpagenews'] = 'Elementi novic';
$string['frontpagesettings'] = 'Nastavitve naslovne strani';
$string['fulllistofcourses'] = 'Vsi predmeti';
$string['fullname'] = 'Polno ime';
$string['fullnamecourse'] = 'Polno ime';
$string['fullnamecourse_help'] = 'Polno ime predmeta je prikazano na vrhu vsake strani v predmetu in na seznamu predmetov.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Polno ime';
$string['fullprofile'] = 'Poln profil';
$string['fullsitename'] = 'Polno ime strani';
$string['functiondisabled'] = 'Ta funkcionalnost je trenutno onemogočena';
$string['general'] = 'Splošno';
$string['geolocation'] = 'širina - dolžina';
$string['gettheselogs'] = 'Pridobi te dnevniške zapise';
$string['go'] = 'Pojdi';
$string['gpl'] = 'Avtorske pravice (C) 1999 naprej  Martin Dougiamas  (http://moodle.com)

Ta program spada med prosto programje; lahko ga razširjate in/ali spreminjate
pod pogoji Splošnega dovoljenja GNU (GNU General Public License), kot ga je objavila
ustanova Free Software Foundation; bodisi različice 2 ali
(po vaši izbiri) katerekoli poznejše različice.

Ta program se razširja v upanju, da bo uporaben,
vendar BREZ VSAKRŠNEGA JAMSTVA; tudi brez posredne zagotovitve
CENOVNE VREDNOSTI ali PRIMERNOSTI ZA DOLOČEN NAMEN.

Za podrobnosti obiščite informativno stran o Moodle licenci:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) 1999 Martin Dougiamas (http://moodle.com)

Ta program je prost program: lahko ga razširjate in/ali spreminjate pod pogoji GNU General Public License, kot jo je objavila Free Software Foundation, različica 3 licence, ali katerekoli poznejše različice.

Ta program se razširja v upanju, da bo uporaben, vendar BREZ KAKRŠNEKOLI GARANCIJE, tudi brez posrednega jamstva CENOVNE VREDNOSTI ali PRIMERNOSTI ZA DOLOČEN NAMEN.

Glej Moodle License stran z informacijami za vse podrobnosti: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL licenca';
$string['grade'] = 'Ocena';
$string['grades'] = 'Ocene';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je bil za to stran omogočen. Če ne boste naložili vaše slike profila bo Moodle poskusil sliko profila za vas naložiti iz Gravatar-ja.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Dodaj novo skupino';
$string['groupaddusers'] = 'Dodaj izbrane v skupino';
$string['groupextendenrol'] = 'Podaljšaj vpis (skupno)';
$string['groupfor'] = 'za skupino';
$string['groupinfo'] = 'Informacije o izbrani skupini';
$string['groupinfoedit'] = 'Urejanje nastavitev skupine';
$string['groupinfomembers'] = 'Informacije o izbranih članih';
$string['groupinfopeople'] = 'Informacije o izbranih osebah';
$string['groupmembers'] = 'Člani skupine';
$string['groupmemberssee'] = 'Ogled članov skupine';
$string['groupmembersselected'] = 'Člani izbrane skupine';
$string['groupmode'] = 'Skupinski način';
$string['groupmodeforce'] = 'Vsili skupinski način';
$string['groupmy'] = 'Moja skupina';
$string['groupnonmembers'] = 'Osebe, ki niso v skupini';
$string['groupnotamember'] = 'Žal niste član te skupine';
$string['grouprandomassign'] = 'Naključno dodeli vse v skupine';
$string['groupremove'] = 'Odstrani izbrano skupino';
$string['groupremovemembers'] = 'Odstrani izbrane člane';
$string['groups'] = 'Skupine';
$string['groupsnone'] = 'Brez skupin';
$string['groupsseparate'] = 'Ločene skupine';
$string['groupsvisible'] = 'Vidne skupine';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gost imajo minimalna dovoljenja in ponavadi ne morejo nikjer vnašati besedila.';
$string['guestskey'] = 'Dovoljeno gostom, ki imajo ključ';
$string['guestsno'] = 'Gostom vstop ni dovoljen';
$string['guestsnotallowed'] = 'Žal \'{$a}\' ne dovoljuje vstopa gostom.';
$string['guestsyes'] = 'Dovoljeno gostom brez ključa';
$string['guestuser'] = 'Gostujoči uporabnik';
$string['guestuserinfo'] = 'Ta uporabnik je poseben uporabnik, ki mu je dovoljen bralni dostop do nekaterih predmetov.';
$string['help'] = 'Pomoč';
$string['helpprefix2'] = 'Pomoč za {$a}';
$string['helpwiththis'] = 'Pomoč pri tem';
$string['hiddenassign'] = 'Skrita zadolžitev';
$string['hiddenfromstudents'] = 'Skrito za udeležence';
$string['hiddensections'] = 'Skriti odseki';
$string['hiddensectionscollapsed'] = 'Skrita področja bodo prikazana v strnjeni obliki';
$string['hiddensections_help'] = '<p>Ta možnost vam omogoča, da se odločite kako se prikazujejo udeležencem skriti odseki.</p>

<p>Privzeto se prikaže majhno področje (v strnjeni obliki, običajno sivo), ki označuje, kje je skrit odsek, čeprav ne morejo dejansko videti skritih dejavnosti in besedil.  To je posebno uporabno v tedenski obliki, da so tedni brez pouka prazni.</p>

<p>Če se odločite, so lahko ti odseki popolnoma skriti, tako da udeleženci sploh ne vedo, da so odseki predmeta skriti.</p>';
$string['hiddensectionsinvisible'] = 'Skriti odseki so v celoti nevidni';
$string['hide'] = 'Skrij';
$string['hideadvancedsettings'] = 'Skrij dodatne nastavitve';
$string['hidepicture'] = 'Skrij sliko';
$string['hidesection'] = 'Skrij odsek {$a}';
$string['hidesettings'] = 'Skrij nastavitve';
$string['hideshowblocks'] = 'Skrij ali pokaži bloke';
$string['hits'] = 'Zadetki';
$string['hitsoncourse'] = 'Zadetki v predmetu {$a->coursename} od {$a->username}';
$string['hitsoncoursetoday'] = 'Današnji zadetki v predmetu {$a->coursename} od {$a->username}';
$string['home'] = 'Domov';
$string['hour'] = 'ura';
$string['hours'] = 'ure';
$string['howtomakethemes'] = 'Kako narediti nove teme';
$string['htmleditor'] = 'Uporaba urejevalnika HTML (samo nekateri brskalniki)';
$string['htmleditoravailable'] = 'Urejevalnik HTML je na voljo';
$string['htmleditordisabled'] = 'Onemogočili ste urejevalnik HTML v vašem uporabniškem profilu';
$string['htmleditordisabledadmin'] = 'Skrbnik je onemogočil urejevalnik HTML na tej strani';
$string['htmleditordisabledbrowser'] = 'Urejevalnik HTML ni na voljo, ker vaš spletni brskalnik ni združljiv';
$string['htmlfilesonly'] = 'samo datoteke HTML';
$string['htmlformat'] = 'Lepa oblika HTML';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'ICQ številka';
$string['idnumber'] = 'Identifikacijska številka';
$string['idnumbercourse'] = 'Identifikacijska številka predmeta';
$string['idnumbercoursecategory'] = 'Identifikacijska številka kategorije';
$string['idnumbercoursecategory_help'] = 'Identifikacijska številka kategorije predmetov se uporablja samo za ujemanje kategorije z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za to kategorijo ga uporabite tu, sicer lahko polje pustite prazno.';
$string['idnumbercourse_help'] = '<p>ID številka predmeta se uporablja samo za ujemanje tega predmeta z zunanjimi sistemi in se nikoli ne prikazuje v tem programu. Če imate uradno kodno ime za ta predmet ga uporabite tu, sicer lahko polje pustite prazno.</p>';
$string['idnumbergroup'] = 'Identifikacijska številka skupine';
$string['idnumbergroup_help'] = 'Identifikacijska številka skupine se uporablja samo za ujemanje te skupine z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za to skupino ga uporabite tu, sicer lahko polje pustite prazno.';
$string['idnumbergrouping'] = 'Identifikacijska številka skupka';
$string['idnumbergrouping_help'] = 'Identifikacijska številka skupka se uporablja samo za ujemanje tega skupka z zunanjimi sistemi in se nikoli ne prikazuje na tej strani. Če imate uradno kodno ime za ta skupek ga uporabite tu, sicer lahko polje pustite prazno.';
$string['idnumbermod'] = 'ID številka';
$string['idnumbermod_help'] = 'Nastavitev števila ID omogoča način prepoznavanja dejavnosti za potrebe izračuna skupne ocene. Če dejavnost ni vključena v noben izračun skupne ocene, potem je polje za število ID lahko prazno.

ID število lahko nastavite tudi v redovalnici, vendar ga lahko urejate samo na strani nastavitve dejavnosti.';
$string['idnumbertaken'] = 'Ta ID številka je že zasedena';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Uvozi';
$string['importdata'] = 'Uvoz podatkov predmeta';
$string['importdataexported'] = 'Uspešno izvoženi podatki iz predmeta \'from\'.<br /> Nadaljujte z uvažanjem v vaš predmet \'to\'.';
$string['importdatafinished'] = 'Uvoz dokončan! Nadaljujte v vaš predmet';
$string['importdatafrom'] = 'Najdi predmet za uvoz podatkov:';
$string['inactive'] = 'Nedejavno';
$string['include'] = 'Vključi';
$string['includeallusers'] = 'Vključi vse uporabnike';
$string['includecoursefiles'] = 'Vključi datoteke predmeta';
$string['includecourseusers'] = 'Vključi uporabnike predmeta';
$string['included'] = 'Vključeno';
$string['includelogentries'] = 'Vključi dnevniške zapiske';
$string['includemodules'] = 'Vključi module';
$string['includemoduleuserdata'] = 'Vključi uporabniške podatke modula';
$string['includeneededusers'] = 'Vključi potrebne uporabnike';
$string['includenoneusers'] = 'Ne vključi uporabnikov';
$string['includeroleassignments'] = 'Vključi določitve vlog';
$string['includesitefiles'] = 'Vključi datoteke strani, ki so v rabi v tem predmetu';
$string['includeuserfiles'] = 'Vključi uporabniške datoteke';
$string['increasesections'] = 'Povečaj število sekcij';
$string['info'] = 'Informacije';
$string['institution'] = 'Ustanova';
$string['instudentview'] = 'z vidika udeleženca';
$string['interests'] = 'Interesi';
$string['interestslist'] = 'Seznam interesov';
$string['interestslist_help'] = 'Vnesite svoje interese, ločene z vejicami';
$string['invalidemail'] = 'Neveljaven e-poštni naslov';
$string['invalidlogin'] = 'Neveljavna prijava, poskusite znova';
$string['invalidusername'] = 'Uporabniško ime lahko vsebuje samo alfanumerične male znake, podčrtaj (_), vezaj (-), piko (.) ali simbol (@)';
$string['invalidusernameupload'] = 'Neveljavno uporabniško ime';
$string['ip_address'] = 'IP naslov';
$string['jump'] = 'Skok';
$string['jumpto'] = 'Skok na...';
$string['keep'] = 'Obdrži';
$string['keepsearching'] = 'Nadaljuj z iskanjem';
$string['langltr'] = 'Smer jezika od leve proti desni';
$string['langrtl'] = 'Smer jezika od desne proti levi';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ta jezikovni paket je posodobljen! :-)';
$string['lastaccess'] = 'Zadnji dostop';
$string['lastedited'] = 'Zadnje urejanje';
$string['lastlogin'] = 'Zadnja prijava';
$string['lastmodified'] = 'Zadnja sprememba';
$string['lastname'] = 'Priimek';
$string['lastyear'] = 'Zadnje leto';
$string['latestlanguagepack'] = 'Preveri zadnji jezikovni paket na moodle.org';
$string['layouttable'] = 'Postavitvena tabela';
$string['leavetokeep'] = 'Pustite prazno za ohranitev trenutnega gesla';
$string['legacythemeinuse'] = 'Ta stran je prikazana v združljivostnem načinu, ker je vaša različica brskalnika prestara.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Bi se želeli zdaj prijaviti s polnim uporabniškim računom?';
$string['list'] = 'Seznam';
$string['listfiles'] = 'Seznam datotek v {$a}';
$string['listofallpeople'] = 'Seznam vseh oseb';
$string['listofcourses'] = 'Seznam predmetov';
$string['loadinghelp'] = 'Nalagam...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni vtičniki';
$string['localpluginsmanage'] = 'Upravljaj lokalne vtičnike';
$string['location'] = 'Lokacija';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Prijavljeni ste kot {$a}';
$string['loggedinasguest'] = 'Trenutno uporabljate gostujoč dostop';
$string['loggedinnot'] = 'Niste prijavljeni.';
$string['login'] = 'Prijava';
$string['loginalready'] = 'Ste že prijavljeni';
$string['loginas'] = 'Prijavite se kot';
$string['loginaspasswordexplain'] = '<p>Vnesti morate posebno "geslo za prijavo kot" za uporabo te možnosti.<br />Če gesla ne poznate, vprašajte skrbnika strežnika.</p>';
$string['login_failure_logs'] = 'Dnevniki spodletelih prijav';
$string['loginguest'] = 'Prijavite se kot gost';
$string['loginsite'] = 'Prijava v spletno mesto';
$string['loginsteps'] = 'Pozdravljeni! Za poln dostop do predmetov si boste morali vzeti
   minuto, da si ustvarite nov uporabniški račun na tej spletni strani.
   Vsak posamezni predmet lahko ima tudi enkratni
   "ključ za vpis", ki ga zdaj še ne boste potrebovali. Tu so
   koraki:
   <ol>
   <li>Izpolnite obrazec <a href="{$a}">Nov račun</a> z vašimi podrobnostmi.</li>
   <li>Elektronsko sporočilo bo nemudoma poslano na vaš e-poštni naslov.</li>
   <li>Preberite e-poštno sporočilo in kliknite na spletno povezavo v sporočilu.</li>
   <li>Vaš račun bo potrjen in prijavljeni boste.</li>
   <li>Nato izberite predmet, v katerem želite sodelovati.</li>
   <li>Če boste pozvani k vnosu "ključa za vpis" - uporabite tistega
   , ki vam ga je dal vaš izvajalec. S tem boste "vpisani" v
   predmet.</li>
   <li>Zdaj lahko dostopate do celotnega predmeta. Od zdaj naprej boste morali samo
   vnesti vaše osebno uporabniško ime in geslo (v obrazcu na tej strani)
   za prijavo in dostop do vseh predmetov v katere ste se vpisali.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Pozdravljeni!</p>
<p>Za poln dostop do predmetov si morate ustvariti uporabniški račun.</p>
<p>Vse kar morate narediti je, da si izmislite uporabniško ime in geslo in ju uporabite v obrazcu na tej strani!</p>
<p>Če je že kdo drug uporabil vaše uporabniško ime boste morali poskusiti znova z drugačnim uporabniškim imenom.</p>';
$string['loginto'] = 'Prijava v {$a}';
$string['logout'] = 'Odjava';
$string['logoutconfirm'] = 'Ali se res želite odjaviti?';
$string['logs'] = 'Dnevniki';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">več</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">več</a> ]';
$string['lookback'] = 'Poglej nazaj';
$string['mailadmins'] = 'Obvesti skrbnike';
$string['mailstudents'] = 'Obvesti udeležence';
$string['mailteachers'] = 'Obvesti izvajalce';
$string['maincoursepage'] = 'Glavna stran predmeta';
$string['makeafolder'] = 'Ustvari mapo';
$string['makeeditable'] = 'Če boste omogočili urejanje \'{$a}\' procesu spletnega strežnika (npr. Apache) boste lahko urejali to datoteko neposredno na tej strani';
$string['makethismyhome'] = 'Naredi to kot mojo privzeto domačo stran';
$string['manageblocks'] = 'Bloki';
$string['managecategorythis'] = 'Upravljajte s to kategorijo';
$string['managecourses'] = 'Upravljaj predmete';
$string['managedatabase'] = 'Podatkovna zbirka';
$string['manageeditorfiles'] = 'Urejaj datoteke, ki jih uporablja urejevalnik';
$string['managefilters'] = 'Filtri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Vloge in dovoljenja';
$string['markedthistopic'] = 'To poglavje je označeno kot trenutno poglavje';
$string['markthistopic'] = 'Označi to poglavje kot trenutno poglavje';
$string['matchingsearchandrole'] = 'Ujemanje \'{$a->iskanje}\' in {$a->vloga}';
$string['maxareabytesreached'] = 'Velikost datotek(e) je večja od prostora, ki je še na voljo na tem območju.';
$string['maxbytesforfile'] = 'Velikost datoteke {$a} presega največjo dovoljeno.';
$string['maxfilesize'] = 'Največja velikost za nove datoteke: {$a}';
$string['maxfilesreached'] = 'Dovoljeno vam je pripeti največ {$a} datotek k temu predmetu';
$string['maximumchars'] = 'Največ {$a} znakov';
$string['maximumgrade'] = 'Najvišja ocena';
$string['maximumgradex'] = 'Najvišja ocena: {$a}';
$string['maximumshort'] = 'Maks';
$string['maximumupload'] = 'Največja velikost naložene datoteke';
$string['maximumupload_help'] = '<p>Ta nastavitev določa največjo velikost datoteke, ki jo lahko naložijo udeleženci v predmetu. Omejena je z nastavitvijo skrbnika, ki velja za celotno spletno mesto.</p>

<p>To velikost je možno dodatno omejiti z nastavitvami znotraj posameznega modula dejavnosti.</p>';
$string['maxnumberweeks'] = 'Najvišje število tednov/tem';
$string['maxnumberweeks_desc'] = 'Ta nastavitev kontrolira največje število možnosti v "Številu tednov/tem" nastavitvah predmetov.';
$string['maxnumcoursesincombo'] = 'Brskaj <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsize'] = 'Maks velikost: {$a}';
$string['maxsizeandareasize'] = 'Največja dovoljena velikost novih datotek:  {$a->size}, celotna omejitev: {$a->areasize}';
$string['maxsizeandattachments'] = 'Največja velikost za nove datoteke: {$a->size}, največje število priponk: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Največja dovoljena velikost novih datotek:  {$a->size}, dovoljeno št. priponk:  {$a->attachments}, celotna omejitev: {$a->areasize}';
$string['memberincourse'] = 'Oseb v predmetu';
$string['messagebody'] = 'Telo sporočila';
$string['messagedselectedusers'] = 'Izbrani uporabniki so bili obveščeni in seznam prejemnikov je bil ponastavljen.';
$string['messagedselectedusersfailed'] = 'Nekaj je šlo narobe ob obveščanju izbranih uporabnikov. Nekateri so morda prejeli e-pošto.';
$string['messageprovider:availableupdate'] = 'Obvestila o razpoložljivih popravkih';
$string['messageprovider:backup'] = 'Obvestila varnostnega kopiranja
';
$string['messageprovider:badgecreatornotice'] = 'Obvestila ustvarjalca priznanja';
$string['messageprovider:badgerecipientnotice'] = 'Obvestila prejemnika priznanja';
$string['messageprovider:courserequestapproved'] = 'Obvestilo o odobritvi zahtevka za ustvarjanje novega predmeta';
$string['messageprovider:courserequested'] = 'Obvestilo o zahtevku za nov predmet';
$string['messageprovider:courserequestrejected'] = 'Obvestilo o zavrnitvi zahtevka za ustvarjanje novega predmeta';
$string['messageprovider:errors'] = 'Pomembne napake spletnega mesta';
$string['messageprovider:errors_help'] = 'To so pomembne napake, ki bi jih upravljalec moral poznati.';
$string['messageprovider:instantmessage'] = 'Osebna sporočila med uporabniki';
$string['messageprovider:instantmessage_help'] = 'Ta odsek določa podrobnosti dogodka, ko drugi uporabnik pošlje sporočilo neposredno vam na tem spletnem mestu.';
$string['messageprovider:notices'] = 'Obvestila o manjših problemih';
$string['messageprovider:notices_help'] = 'To so obvestila, ki bi lahko zanimale administratorja.';
$string['messageselect'] = 'Izberi tega uporabnika kot prejemnika sporočila';
$string['messageselectadd'] = 'Pošlji sporočilo';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Selitev ocen';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minuta';
$string['minutes'] = 'minut';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Izbrati morate kategorijo';
$string['missingcity'] = 'Manjka mesto/kraj';
$string['missingcountry'] = 'Manjka država';
$string['missingdescription'] = 'Manjka opis';
$string['missingemail'] = 'Manjka e-poštni naslov';
$string['missingfirstname'] = 'Manjka ime';
$string['missingfromdisk'] = 'Manjka iz diska';
$string['missingfullname'] = 'Manjka polno ime';
$string['missinglastname'] = 'Manjka priimek';
$string['missingname'] = 'Manjka ime';
$string['missingnewpassword'] = 'Manjka novo geslo';
$string['missingpassword'] = 'Manjka geslo';
$string['missingrecaptchachallengefield'] = 'Manjkajoče polje reCAPTCHA';
$string['missingreqreason'] = 'Manjka razlog';
$string['missingshortname'] = 'Manjka kratko ime';
$string['missingshortsitename'] = 'Manjka kratko ime strani';
$string['missingsitedescription'] = 'Manjka opis strani';
$string['missingsitename'] = 'Manjka ime strani';
$string['missingstrings'] = 'Preverite manjkajoče nize';
$string['missingstudent'] = 'Nekaj je potrebno izbrati';
$string['missingsummary'] = 'Manjka povzetek';
$string['missingteacher'] = 'Nekaj je potrebno izbrati';
$string['missingurl'] = 'Manjka URL';
$string['missingusername'] = 'Manjka uporabniško ime';
$string['modchooserdisable'] = 'Izklopi izbirnik aktivnosti';
$string['modchooserenable'] = 'Vklopi izbirnik aktivnosti';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podpira nalaganje datotek tipa {$a->type}';
$string['modified'] = 'Spremenjeno';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Nastavitev tabel modula';
$string['modulesuccess'] = '{$a} tabele so bile nastavljene pravilno';
$string['modulesused'] = 'Uporabljeni moduli';
$string['month'] = 'Mesec';
$string['months'] = 'Mesci';
$string['moodledocs'] = 'Moodle dokumentacija';
$string['moodledocslink'] = 'Moodle dokumentacija za to stran';
$string['moodlerelease'] = 'Moodle izdaja';
$string['moodleversion'] = 'Moodle različica';
$string['more'] = 'več';
$string['morehelp'] = 'Moodle pomoč';
$string['moreinformation'] = 'Več informacij o tej napaki';
$string['moreprofileinfoneeded'] = 'Povejte nam kaj več o sebi';
$string['mostrecently'] = 'na zadnje';
$string['move'] = 'Premakni';
$string['movecategorycontentto'] = 'Premakni v';
$string['movecategoryto'] = 'Premakni kategorijo v:';
$string['movecontent'] = 'Premakni {$a}';
$string['movecontentstoanothercategory'] = 'Premakni vsebino v drugo kategorijo';
$string['movecourseto'] = 'Premakni predmet v:';
$string['movedown'] = 'Premakni navzdol';
$string['movefilestohere'] = 'Premakni datoteke sem';
$string['movefull'] = 'Premakni {$a} na to mesto';
$string['movehere'] = 'Premakni sem';
$string['moveleft'] = 'Premakni levo';
$string['moveright'] = 'Premakni desno';
$string['movesection'] = 'Premakni odsek {$a}';
$string['moveselectedcategoriesto'] = 'Premakni izbrane kategorije v';
$string['moveselectedcoursesto'] = 'Premakni izbrane predmete v...';
$string['movetoanotherfolder'] = 'Premakni v drugo mapo';
$string['moveup'] = 'Premakni navzgor';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Novo geslo mora biti drugačno od trenutnega';
$string['mustconfirm'] = 'Potrditi morate svojo prijavo';
$string['mycourses'] = 'Moji predmeti';
$string['myfiles'] = 'Moje zasebne datoteke';
$string['myfilesmanage'] = 'Upravljaj moje zasebne datoteke';
$string['myhome'] = 'Moj dom';
$string['mymoodledashboard'] = 'Moja Moodle plošča';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Ime';
$string['nameforlink'] = 'Kako želite poimenovati to povezavo?';
$string['nameforpage'] = 'Ime';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['never'] = 'Nikoli';
$string['neverdeletelogs'] = 'Nikoli ne briši dnevnikov';
$string['new'] = 'Novo';
$string['newaccount'] = 'Nov račun';
$string['newcourse'] = 'Nov predmet';
$string['newpassword'] = 'Novo geslo';
$string['newpasswordfromlost'] = '<strong>OPOMBA:</strong> Vaše <strong>Trenutno geslo</strong> vam bo poslano <strong>v drugem</strong> izmed dveh sporočil, ki sestavljata postopek obnove pozabljenega gesla. Preverite, če ste prejeli vaše nadomestno geslo, preden nadaljujete na tej strani.';
$string['newpassword_help'] = 'Pustite prazno, da ohranite trenutno geslo.';
$string['newpasswordtext'] = 'Pozdravljeni {$a->firstname},

Geslo vašega računa na \'{$a->sitename}\' je bilo ponastavljeno
in izdano vam je bilo novo začasno geslo.

Vaši trenutni podatki za prijavo so:
   Uporabniško ime: {$a->username}
   Geslo: {$a->newpassword}

Obiščite to stran za spremembo vašega gesla:
   {$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete.  Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Pozdrav, skrbnik \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = '<p>Na ta strežnik lahko s svojega računalnika naložite sliko, ki bo uporabljena na raznih mestih za vašo predstavitev.</p>
<p>V ta namen so najboljše slike portreti, vendar lahko uporabite poljubno sliko.</p>
<p>Slika mora biti v obliki zapisa JPG ali PNG (npr. končnice imen datotek so običajno .jpg ali .png).</p>
<p>Datoteko slike lahko ustvarite na štiri različne načine:</p>

<ol>
<li>Če uporabljate digitalni fotoaparat, bodo vaše fotografije verjetno že na vašem računalniku v pravilni obliki zapisa.</li>
<li>Lahko uporabite skener za skeniranje natisnjene fotografije.  Poskrbite, da jo boste shranili v obliki zapisa JPG ali PNG.</li>
<li>Če ste umetniško nadarjeni, boste morda narisali sliko s pomočjo programa za risanje.</li>
</ol>
<p>Katerokoli metodo že uporabite, preverite, da je slika v formatu JPG ali PNG.</p>
<p>Za nalaganje slike kliknite gumb "Prebrskaj" oz. "Browse" na tej strani urejanja in izberite sliko na vašem lokalnem trdem disku.</p>
<p>OPOMBA: Poskrbite, da datoteka ni večja kot je navedena največja velikost, sicer datoteka ne bo naložena.</p>
<p>Nato kliknite "Posodobi moj profil" na dnu strani - datoteka slike bo obrezana v kvadrat in velikost bo spremenjena v 100 x 100 točk.</p>
<p>Ko boste spet na strani vašega profila se morda slika ne bo spremenila.  Če se to zgodi, pritisnite gumb "Osveži" (Reload) v vašem brskalniku.</p>';
$string['newsitem'] = 'element novice';
$string['newsitems'] = 'elementi novic';
$string['newsitemsnumber'] = 'Število elementov novic za prikaz';
$string['newsitemsnumber_help'] = '<p>Poseben forum z imenom "Novice" se pojavi v "tedenski" obliki predmeta in v obliki "poglavij".  To je primeren prostor za objavo obvestil, ki naj jih vidijo vsi udeleženci. (Privzeto so vsi udeleženci naročeni na ta forum in bodo prejeli vaša obvestila po elektronski pošti.)</p>

<p>Ta nastavitev določa, koliko zadnjih elementov se pojavi na domači strani predmeta v okvirju novic spodaj na desni strani.</p>

<p>Če tu nastavite "0 elementov novic", se okvir novic sploh ne bo prikazal.</p>';
$string['newuser'] = 'Nov uporabnik';
$string['newusernewpasswordsubj'] = 'Nov uporabniški račun';
$string['newusernewpasswordtext'] = 'Pozdravljeni {$a->firstname},

Za vas je bil ustvarjen nov uporabniški račun na \'{$a->sitename}\'
in izdano vam je bilo novo začasno geslo.

Vaši trenutni podatki za prijavo so:
   Uporabniško ime: {$a->username}
   Geslo: {$a->newpassword}
             (spremeniti boste morali svoje geslo
              ob prvi prijavi)

Za začetek uporabe \'{$a->sitename}\', se prijavite na naslovu
   {$a->link}

V večini e-poštnih odjemalcev, bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete.  Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Pozdrav, skrbnik \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Novi uporabniki';
$string['newwindow'] = 'novo okno';
$string['next'] = 'Naslednje';
$string['nextsection'] = 'Naslednji odsek';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Ni blokov, ki bi jih lahko dodali na to stran.';
$string['nobody'] = 'Nihče';
$string['nochange'] = 'Brez spremembe';
$string['nocomments'] = 'Ni komentarjev';
$string['nocourses'] = 'Ni predmetov';
$string['nocoursesfound'] = 'Nobenega predmeta z besedami \'{$a}\' ni najti';
$string['nocoursesyet'] = 'Ni predmetov v tej kategoriji';
$string['nodstpresets'] = 'Skrbnik ni omogočil podpore za poletni čas.';
$string['nofilesselected'] = 'Za obnovitev ni bila izbrana nobena datoteka';
$string['nofilesyet'] = 'V vaš predmet še ni naložene nobene datoteke';
$string['nograde'] = 'Ni ocene';
$string['nohelpforactivityorresource'] = 'Pomoč za ta vir ali aktivnost trenutno ne obstaja.';
$string['noimagesyet'] = 'V vaš predmet še ni naložene nobene slike';
$string['nologsfound'] = 'Ni bilo najdenih dnevniških zapisov';
$string['nomatchingusers'] = 'Ni uporabnikov, ki ustrezajo \'{$a}\'';
$string['nomorecourses'] = 'Ni možno najti večih ustreznih predmetov';
$string['nomoreidnumber'] = 'Ne uporabljaj ID številke v izogib navzkrižju';
$string['none'] = 'Brez';
$string['noneditingteacher'] = 'Izvajalec brez pravic urejanja';
$string['noneditingteacherdescription'] = 'Izvajalci brez pravic urejanja lahko poučujejo in ocenjujejo udeležence pri predmetu, vendar ne smejo spreminjati dejavnosti.';
$string['nonstandard'] = 'Ne-standardno';
$string['nopendingcourses'] = 'Ni predmetov, ki bi čakali na odobritev';
$string['nopotentialadmins'] = 'Ni možnih skrbnikov';
$string['nopotentialcreators'] = 'Ni možnih ustvarjalcev predmetov';
$string['nopotentialstudents'] = 'Ni možnih udeležencev';
$string['nopotentialteachers'] = 'Ni možnih izvajalcev';
$string['norecentactivity'] = 'Ni nedavnih dejavnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na e-poštni naslov, ki ni namenjen odgovorom. Če ste poskušali odgovoriti na objavo v forumu, namesto tega odgovorite z uporabo foruma {$a}.

To je vsebina vaše e-pošte:';
$string['noreplybouncesubject'] = '{$a} - odklonjena e-pošta.';
$string['noreplyname'] = 'Ne odgovarjajte na to e-pošto';
$string['noresults'] = 'Ni rezultata';
$string['normal'] = 'Navadno';
$string['normalfilter'] = 'Navadno iskanje';
$string['nosite'] = 'Ni bilo moč najti predmeta na nivoju strani.';
$string['nostudentsfound'] = 'Ni najdenih: {$a}';
$string['nostudentsingroup'] = 'V tej skupini še ni udeležencev';
$string['nostudentsyet'] = 'Noben udeleženec se še ni vpisal v ta predmet';
$string['nosuchemail'] = 'Ni takega e-poštnega naslova';
$string['notavailable'] = 'Ni na voljo';
$string['noteachersyet'] = 'V tem predmetu še ni izvajalcev';
$string['notenrolled'] = '{$a} ni vpisan v ta predmet';
$string['notenrolledprofile'] = 'Profil ni dostopen, ker uporabnik ni vpisan v ta predmet.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Pomnite:</strong> Možnost, da povozite datum, ko obnavljate to varnostno kopijo, je onemogočena, ker ni potrebnih dovoljenj.';
$string['noteuserschangednonetocourse'] = 'Opomba: uporabniki predmetov morajo biti obnovljeni, ko obnavljate uporabniške podatke (v dejavnostih, datotekah ali sporočilih). Ta nastavitev je bila spremenjena za vas.';
$string['nothingnew'] = 'Nič novega od vaše zadnje prijave';
$string['nothingtodisplay'] = 'Ničesar za prikaz';
$string['notice'] = 'Opomin';
$string['noticenewerbackup'] = 'Ta datoteka varnostne kopije je bila ustvarjena z Moodle {$a->backuprelease} ({$a->backupversion}) in je novejša od vaše trenutno nameščene različice Moodle {$a->serverrelease} ({$a->serverversion}). To lahko povzroči določena neskladja, saj združljivost za nazaj ne more biti zagotovljena.';
$string['notifications'] = 'Obvestila';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Uporabnik: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Te dnevnike si lahko ogledate na {$a}/course/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Tu je seznam spodletelih poskusov prijav v {$a} odkar ste bili zadnjič obveščeni';
$string['notifyloginfailuressubject'] = '{$a} :: obvestilo o spodletelih prijavah';
$string['notincluded'] = 'Ni vključeno';
$string['notingroup'] = 'Žal morate biti del skupine, da bi videli to dejavnost.';
$string['notpublic'] = 'Ni javno!';
$string['nousersfound'] = 'Ni bilo najdenih uporabnikov';
$string['nousersmatching'] = 'Nobenega uporabnika, ki bi ustrezal \'{$a}\' ni bilo možno najti';
$string['nousersyet'] = 'Ni še uporabnikov';
$string['novalidcourses'] = 'Ni veljavnega predmeta za prikaz';
$string['now'] = 'zdaj';
$string['numattempts'] = '{$a} spodletelih poskusov prijav';
$string['numberofcourses'] = 'Število predmetov';
$string['numberweeks'] = 'Število tednov/poglavij';
$string['numdays'] = '{$a} dni';
$string['numhours'] = '{$a} ur';
$string['numletters'] = '{$a} črk';
$string['numminutes'] = '{$a} minut';
$string['nummonths'] = '{$a} mesecev';
$string['numseconds'] = '{$a} sekund';
$string['numviews'] = '{$a} ogledov';
$string['numweeks'] = '{$a} tednov';
$string['numwords'] = '{$a} besed';
$string['numyears'] = '{$a} let';
$string['ok'] = 'V redu';
$string['oldpassword'] = 'Trenutno geslo';
$string['olduserdirectory'] = 'To je STAR imenik uporabnikov, ki ni več potreben. Lahko ga varno izbrišete. Datoteke, ki jih vsebuje, so bile skopirane v NOV imenik uporabnikov.';
$string['opentoguests'] = 'Dostop gostujočih uporabnikov';
$string['optional'] = 'neobvezno';
$string['options'] = 'možnosti';
$string['order'] = 'Vrstni red';
$string['originalpath'] = 'Izvirna pot';
$string['orphanedactivitiesinsectionno'] = 'Osirotele dejavnosti (sekcija {$a})';
$string['other'] = 'Drugo';
$string['outline'] = 'Oris';
$string['outlinereport'] = 'Orisano poročilo';
$string['page'] = 'Stran';
$string['pagea'] = 'Stran {$a}';
$string['pageheaderconfigablock'] = 'Konfiguriranje bloka v %fullname%';
$string['pagepath'] = 'Pot strani';
$string['pageshouldredirect'] = 'Ta stran bi se morala samodejno preusmeriti. Če se ni, kliknite na spodnjo povezavo.';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['parentcoursenotfound'] = 'Nadrejenega predmeta ni bilo mogoče najti!';
$string['parentfolder'] = 'Nadrejena mapa';
$string['participants'] = 'Sodelujoči';
$string['participantslist'] = 'Seznam udeležencev';
$string['participationratio'] = 'Količnik sodelovanja';
$string['participationreport'] = 'Poročilo o sodelovanju';
$string['password'] = 'Geslo';
$string['passwordchanged'] = 'Geslo je bilo spremenjeno';
$string['passwordconfirmchange'] = 'Potrditev spremembe gesla';
$string['passwordextlink'] = 'Sledeča povezava vam omogoča obnovo vašega pozabljenega gesla. S tem boste zapustili Moodle.';
$string['passwordforgotten'] = 'Pozabljeno geslo';
$string['passwordforgotteninstructions'] = 'Vaše podatke je potrebno najprej najti v podatkovni zbirki uporabnikov. V ustrezno polje vnesite <strong>bodisi</strong> vaše uporabniško ime ali naslov elektronske pošte, ki ste ga uporabili ob registraciji. Ni potrebno vnesti obojega.';
$string['passwordforgotteninstructions2'] = 'Če želite ponastaviti geslo, vpišite svoje uporabniško ime ali vaš e-poštni naslov. Če vas najdemo v bazi podatkov, bo e-sporočilo z navodili za dostop poslano na vaš e-poštni naslov.';
$string['passwordnohelp'] = 'Za iskanje vašega izgubljenega gesla ni na voljo pomoči. Za pomoč se obrnite na vašega skrbnika Moodle strani.';
$string['passwordrecovery'] = 'Da, potrebujem pomoč pri prijavi';
$string['passwordsdiffer'] = 'Ti dve gesli se ne ujemata';
$string['passwordsent'] = 'Geslo je bilo poslano';
$string['passwordsenttext'] = '<p>Elektronsko sporočilo je bilo poslano na vaš naslov: {$a->email}.</p>
   <p><b>Preverite vašo e-pošto za vaše novo geslo</b></p>
   <p>Novo geslo je bilo generirano samodejno, morda boste želeli
   <a href="{$a->link}">spremeniti geslo v nekaj, kar si boste lažje zapomnili</a>.</p>';
$string['path'] = 'Pot';
$string['pathnotexists'] = 'Pot ne obstaja na vašem strežniku!';
$string['pathslasherror'] = 'Po se ne sme zaključiti s poševnico!';
$string['paymentinstant'] = 'Uporabite spodnje gumbe za plačilo in vpis v nekaj minutah!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> čakajoče</small>)';
$string['paymentrequired'] = 'Ta predmet zahteva plačilo za vstop.';
$string['payments'] = 'Plačila';
$string['paymentsorry'] = 'Hvala za vaše plačilo! Žal vaše plačilo še ni bilo v celoti obdelano in zato še niste registrirani za vstop v predmet "{$a->fullname}". Prosimo, poskusite nadaljevati v predmet čez nekaj sekund, če bi imeli še naprej težave, pa na to opozorite skrbnika strani, morda vam lahko pomaga tudi {$a->teacher} predmeta.';
$string['paymentthanks'] = 'Hvala za vaše plačilo!  Zdaj ste vpisani v vaš predmet:<br />"{$a}"';
$string['pendingrequests'] = 'Nerešene zahteve';
$string['periodending'] = 'Konec obdobja ({$a})';
$string['personal'] = 'Osebno';
$string['personalprofile'] = 'Osebni profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobilni telefon';
$string['phpinfo'] = 'PHP informacije';
$string['pictureof'] = 'Slika od {$a}';
$string['pictureofuser'] = 'Slika uporabnika';
$string['pleaseclose'] = 'Prosimo, zaprite to okno.';
$string['pleasesearchmore'] = 'Poišči več';
$string['pleaseusesearch'] = 'Uporabite "Iskanje"';
$string['plugin'] = 'Vtičnik';
$string['plugincheck'] = 'Preverjanje vtičnikov';
$string['plugindeletefiles'] = 'Vsi podatki povezani z vtičnikom \'{$a->ime}\' so bili izbrisani iz baze podatkov. Da bi preprečili samodejno ponovno namestitev, morate izbrisati to mapo s strežnika: {$a->imenik}';
$string['pluginsetup'] = 'Nastavitev tabel vtičnikov';
$string['policyaccept'] = 'Razumem in se strinjam';
$string['policyagree'] = 'Za nadaljnjo uporabo tega spletnega mesta se morate strinjati s temi pravili. Ali se strinjate?';
$string['policyagreement'] = 'Pravila spletnega mesta';
$string['policyagreementclick'] = 'Povezava do pravil spletnega mesta';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Odpri datoteko v novem oknu';
$string['popupwindowname'] = 'Pojavno okno';
$string['post'] = 'Objava';
$string['posts'] = 'Objave';
$string['potentialadmins'] = 'Možni skrbniki';
$string['potentialcreators'] = 'Možni ustvarjalci predmetov';
$string['potentialstudents'] = 'Možni udeleženci';
$string['potentialteachers'] = 'Možni izvajalci';
$string['preferences'] = 'Nastavitve';
$string['preferredlanguage'] = 'Zaželeni jezik';
$string['preferredtheme'] = 'Prednostna tema';
$string['preprocessingbackupfile'] = 'Predprocesiranje varnostne kopije';
$string['preview'] = 'Predogled';
$string['previewhtml'] = 'Predogled oblike HTML';
$string['previeworchoose'] = 'Predogled ali izbor teme';
$string['previous'] = 'Prejšnje';
$string['previouslyselectedusers'] = 'Prej izbrani uporabniki ne ustrezajo \'{$a}\'';
$string['previoussection'] = 'Prejšnji odsek';
$string['primaryadminsetup'] = 'Nastavi skrbniški račun';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Ta opis v profilu ne bo prikazan dokler se ta oseba ne vpiše v vsaj en predmet.';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Opomba: do datotek, ki se nahajajo tu, lahko dostopajo vsi';
$string['publicsitefileswarning2'] = 'Pomnite: Do datotek, ki jih postavite sem, lahko dostopa vsakdo, ki ve (ali lahko ugane) URL. Zaradi varnostnih razlogov, je priporočljivo, da so vse datoteke varnostnih kopij izbrisane takoj po obnovitvi.';
$string['publicsitefileswarning3'] = 'Pomnite: Do datotek, ki jih postavite sem, lahko dostopa vsakdo, ki ve (ali ugane)  URL. <br /> Zaradi varnostnih razlogov naj bodo datoteke varnostnih kopij shranjene samo v mapi varnostnih kopij.';
$string['publish'] = 'Objavi';
$string['question'] = 'Vprašanje';
$string['questionsinthequestionbank'] = 'Vprašanja v zbirki vprašanj';
$string['readinginfofrombackup'] = 'Branje informacij iz varnostne kopije';
$string['readme'] = 'BERIME';
$string['recentactivity'] = 'Nedavne dejavnosti';
$string['recentactivityreport'] = 'Celotno poročilo nedavnih dejavnosti ...';
$string['recipientslist'] = 'Seznam prejemnikov';
$string['recreatedcategory'] = 'Ponovno ustvarjena kategorija {$a}';
$string['redirect'] = 'Preusmeritev';
$string['reducesections'] = 'Zmanjšaj število sekcij';
$string['refresh'] = 'Osveži';
$string['refreshingevents'] = 'Osveževanje dogodkov';
$string['registration'] = 'Registracija Moodle';
$string['registrationcontact'] = 'Stik iz javnosti';
$string['registrationcontactno'] = 'Ne, ne želim obrazca za stik na seznamu strani';
$string['registrationcontactyes'] = 'Da, ponudi obrazec za morebitne Moodlerje za stik z mano';
$string['registrationemail'] = 'E-poštna obvestila';
$string['registrationinfo'] = '<p>Ta stran vam omogoča registracijo vaše Moodle strani pri moodle.org.  Registracija je brezplačna.
Glavna ugodnost registracije je, da boste dodani v poštni seznam z nizkim obsegom
za pomembna obvestila kot so varnostna opozorila in nove izdaje Moodle.</p>
<p>Kot privzeto bodo vaše informacije ohranjene zasebno in ne bodo nikoli prodane ali posredovane komurkoli drugemu.  Edini
   namen zbiranja teh informacij je podpora in pomoč pri ustvarjanju statistične
   podobe skupnosti Moodle kot celote.</p>
<p>Če se tako odločite lahko dovolite objavo imena strani, države in URL naslova v javnem seznamu strani Moodle.</p>
<p>Vse nove registracije so ročno preverjene preden so dodane na seznam, ko ste dodani pa lahko kadarkoli posodobite registracijo (in vaš vnos v javnem seznamu) s ponovno oddajo tega obrazca.</p>';
$string['registrationinfotitle'] = 'Podatki o registraciji';
$string['registrationno'] = 'Ne, ne želim prejemati e-pošte';
$string['registrationsend'] = 'Pošlji registracijske informacije na moodle.org';
$string['registrationyes'] = 'Da, prosim obveščajte me o pomembnih zadevah';
$string['reject'] = 'Zavrni';
$string['rejectdots'] = 'Zavrni...';
$string['reload'] = 'Osveži';
$string['remoteappuser'] = 'Oddaljeni {$a} Uporabnik';
$string['remove'] = 'Odstrani';
$string['removeadmin'] = 'Odstrani skrbnika';
$string['removecreator'] = 'Odstrani ustvarjalca predmeta';
$string['removestudent'] = 'Odstrani udeleženca';
$string['removeteacher'] = 'Odstrani izvajalca';
$string['rename'] = 'Preimenuj';
$string['renamefileto'] = 'Preimenuj <b>{$a}</b> v';
$string['report'] = 'Poročilo';
$string['reports'] = 'Poročila';
$string['repositories'] = 'Repozitorij';
$string['requestcourse'] = 'Zahtevaj predmet';
$string['requestedby'] = 'Zahteval(a)';
$string['requestedcourses'] = 'Zahtevani predmeti';
$string['requestreason'] = 'Razlog za zahtevo predmeta';
$string['required'] = 'Zahtevano';
$string['requirespayment'] = 'Ta predmet zahteva plačilo za dostop';
$string['reset'] = 'Ponastavi';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Ponastavi predmet';
$string['resetinfo'] = 'Ta stran vam omogoča, da izpraznite uporabniške podatke iz predmeta in ohranite dejavnosti ter druge nastavitve.  Bodite pozorni, saj boste z izbiro spodnjih elementov in oddajo te strani trajno izbrisali izbrane uporabniške podatke iz tega predmeta!';
$string['resetnotimplemented'] = 'Ponastavitev ni bila implementirana';
$string['resetstartdate'] = 'Ponastavi datum začetka';
$string['resetstatus'] = 'Stanje';
$string['resettask'] = 'Opravilo';
$string['resettodefaults'] = 'Ponastavi na prevzete vrednosti';
$string['resource'] = 'Vir';
$string['resourcedisplayauto'] = 'Samodejno';
$string['resourcedisplaydownload'] = 'Vsili prenos';
$string['resourcedisplayembed'] = 'Vdelan';
$string['resourcedisplayframe'] = 'V okvirju';
$string['resourcedisplaynew'] = 'Novo okno';
$string['resourcedisplayopen'] = 'Odpri';
$string['resourcedisplaypopup'] = 'V pop-up (pojavno okno)';
$string['resources'] = 'Viri';
$string['resources_help'] = 'Vrste virov omogočajo dodajanje v predmet skoraj vseh spletnih vsebin.';
$string['restore'] = 'Obnovi';
$string['restorecancelled'] = 'Obnovitev preklicana';
$string['restorecannotassignroles'] = 'Obnovitev potrebuje določanje vlog, vi pa za to nimate dovoljenj';
$string['restorecannotcreateorassignroles'] = 'Obnovitev potrebuje ustvaritev ali dodelitev vlog, vi pa za to nimate dovoljenj';
$string['restorecannotcreateuser'] = 'Pri postopku obnavljanja je nujno ustvariti uporabnika \'{$a}\' iz varnostne kopije, vendar vi nimate dovoljenja za to';
$string['restorecannotoverrideperms'] = 'Obnovitev potrebuje povozitev dovoljenj, vi pa nimate dovoljenj za to';
$string['restorecoursenow'] = 'Obnovi ta predmet zdaj!';
$string['restoredaccount'] = 'Obnovljeni račun';
$string['restoredaccountinfo'] = 'Ta račun je bil uvožen z drugega strežnika, izgubljeno je bilo geslo. Za nastavitev novega gesla po e-pošti, kliknite "Nadaljuj"';
$string['restorefinished'] = 'Obnova je bila uspešno zaključena';
$string['restoreto'] = 'Obnovi v';
$string['restoretositeadding'] = 'Opozorilo: Obnovili boste na prvo stran spletne strani in dodali podatke na njo!';
$string['restoretositedeleting'] = 'Opozorilo: Obnovili boste na prvo stran spletne strani, najprej bodo izbrisani podatki!';
$string['restoreuserconflict'] = 'Poskus obnovitve uporabnika \'{$a}\' iz varnostne kopije bo sprožil konflikt';
$string['restoreuserinfofailed'] = 'Obnovitveni proces je bil ustavljen zaradi pomanjkanja vaših dovoljenj za obnovitev uporabniških podatkov.';
$string['restoreusersprecheck'] = 'Preverjanje uporabniških podatkov';
$string['restoreusersprecheckerror'] = 'Zaznanih je bilo nekaj problemov med preverjanjem uporabniških podatkov';
$string['restricted'] = 'Omejeno';
$string['returningtosite'] = 'Se vračate na to spletno stran?';
$string['returntooriginaluser'] = 'Vrni se na {$a}';
$string['revert'] = 'Povrni';
$string['role'] = 'Vloga';
$string['roleassignments'] = 'Dodelitve vlog';
$string['rolemappings'] = 'Preslikovanje vlog';
$string['rolerenaming'] = 'Preimenovanje vlog';
$string['rolerenaming_help'] = 'Ta možnost omogoča spremembo prikazanih imen za vloge v predmetu.
Če je spremenjeno le ime, se dovoljenja za vlogo ne spremenijo.
Nova imena vlog se pojavijo na vsaki strani predmeta in povsod v predmetu.
Če je preimenovana vloga ena izmed vlog, ki jo je administrator izbral kot vlogo upravljavca predmeta, potem se bo ime te vloge pokazalo tudi na seznamu predmetov.';
$string['roles'] = 'Vloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Število zadnjih člankov RSS';
$string['rsserror'] = 'Napaka pri branju RSS podatkov';
$string['rsserrorauth'] = 'Vaš vir RSS ne vsebuje veljavnega avtentikacijskega žetona';
$string['rsserrorguest'] = 'Ta vir uporablja dostop gosta za dostop do podatkov, vendar gosti nimajo pravic brati teh podatkov. Obiščite izvorno lokacijo vira (URL) kot veljavni uporabnik in si pridobite novo RSS povezavo od tam.';
$string['rsskeyshelp'] = 'Za zagotavljanje varnosti in zasebnosti vsebujejo URL naslovi RSS virov poseben žeton, ki identificira uporabnika za katerega so namenjeni. To prepreči drugim uporabnikom dostop do področij v Moodlu do katerih ne bi smeli imeti dostopa preko RSS virov.</p><p>Ta žeton se avtomatsko ustvari ob prvem dostopu v področje Moodla, ki ustvari RSS vir. Če menite, da je bil vaš žeton RSS vira kompromitiran lahko zahtevate novega z klikom na tukajšnjo povezavo za ponastavitev. Prosimo upoštevajte, da bo trenutni URL naslov RSS vira tako postal neveljaven.';
$string['rsstype'] = 'RSS vir za to dejavnost';
$string['saveandnext'] = 'Shrani in pokaži naslednjo';
$string['savechanges'] = 'Shrani spremembe';
$string['savechangesanddisplay'] = 'Shrani in prikaži';
$string['savechangesandreturntocourse'] = 'Shrani in se vrni na predmet';
$string['savecomment'] = 'Shrani komentar';
$string['savedat'] = 'Shranjeno ob:';
$string['savepreferences'] = 'Shrani nastavitve';
$string['saveto'] = 'Shrani v';
$string['scale'] = 'Lestvica';
$string['scale_help'] = '<p>Izvajalci lahko za predmet ustvarijo nove lestvice po meri za poljubne ocenjevane dejavnosti.</p>

<p>Ime lestvice naj bo fraza, ki jo jasno identificira: ime se bo pojavilo v seznamu za izbor lestvice in na gumbih kontekstno občutljive pomoči.</p>

<p>Sama lestvica je določena z urejenim seznamom vrednosti, razvrščenih od negativnih proti pozitivnim, ločenih z vejicami.  Na primer:</p>

<p class="indent"><i>Nerazveseljivo, Ne dovolj dobro, Povprečno, Dobro, Zelo dobro, Izvrstno!</i></p>

<p>Lestvice naj vsebujejo tudi dober opis, kaj pomenijo in kakšna je njihova pričakovana raba.  Ta opis se bo pojavil v straneh pomoči za izvajalce in udeležence.</p>

<p>Na vašem spletnem mestu lahko skrbnik sistema določi eno ali več "Standardnih" lestvic.  Te bodo na voljo v vseh predmetih.</p>';
$string['scales'] = 'Lestvice';
$string['scalescustom'] = 'Lestvice po meri';
$string['scalescustomcreate'] = 'Dodaj novo lestvico';
$string['scalescustomno'] = 'Ni še ustvarjenih lestvic po meri';
$string['scalesstandard'] = 'Standardne lestvice';
$string['scalestandard'] = 'Standardna lestvica';
$string['scalestandard_help'] = '<p>Standardna lestvica je na voljo za celo stran, v vseh predmetih.</p>';
$string['scalestip'] = 'Za ustvarjanje lestvic po meri uporabite povezavo \'Lestvice ...\' v skrbniškem meniju predmeta.';
$string['scalestip2'] = 'Za ustvarjanje lestvic po meri kliknite na povezavo Ocene v skrbniškem meniju predmeta, nato izberite Uredi, Lestvice.';
$string['schedule'] = 'Urnik';
$string['screenshot'] = 'Posnetek zaslona';
$string['search'] = 'Išči';
$string['searchagain'] = 'Išči znova';
$string['searchbyemail'] = 'Išči po e-poštnih naslovih';
$string['searchbyusername'] = 'Išči po uporabniških imenih';
$string['searchcourses'] = 'Išči predmete';
$string['searchhelp'] = 'Hkrati lahko iščete več besed.<br /><br />beseda : najdi poljubno ujemanje te besede v besedilu.<br />+beseda : najdene bodo samo natančno ujemajoče besede.<br />-beseda : ne vključi rezultatov, ki vsebujejo to besedo.';
$string['search_help'] = 'Za osnovno iskanje ene ali več besed kjerkoli v besedilu preprosto vpišite besede ločene s presledki. Uporabljajo se lahko vse besede daljše od dveh znakov.

Za napredno iskanje kliknite na gumb iskanje in ne vpišite ničesar v iskalno polje - tako boste prišli do naprednega iskalnega obrazca.';
$string['searchoptions'] = 'Možnosti iskanja';
$string['searchresults'] = 'Rezultati iskanja';
$string['sec'] = 's';
$string['seconds'] = 'sekunde';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dni';
$string['secondstotime518400'] = '6 dni';
$string['secondstotime604800'] = '1 teden';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Povezava za potrditev zamenjave gesla je bila že uporabljena, geslo ni bilo spremenjeno.';
$string['secs'] = 's';
$string['section'] = 'Odsek';
$string['sectionname'] = 'Ime sekcije';
$string['sections'] = 'Odseki';
$string['sectionusedefaultname'] = 'Uporabi privzeto ime sekcije';
$string['seealsostats'] = 'Poglej tudi: statistiko';
$string['selctauser'] = 'Izberi uporabnika';
$string['select'] = 'Izberi';
$string['selectacountry'] = 'Izberi državo';
$string['selectacourse'] = 'Izberi predmet';
$string['selectacoursesite'] = 'Izberi predmet ali stran';
$string['selectagroup'] = 'Izberite skupino';
$string['selectall'] = 'Izberi vse';
$string['selectamodule'] = 'Izberite modul dejavnosti';
$string['selectanaction'] = 'Izberite dejanje';
$string['selectanoptions'] = 'Izberite možnosti';
$string['selectaregion'] = 'Izberi območje';
$string['selectdefault'] = 'Izberi privzeto';
$string['selectedfile'] = 'Izbrana datoteka';
$string['selectednowmove'] = '{$a} datotek izbranih za premik. Zdaj pojdite v ciljno mapo in pritisnite \'Premakni datoteke sem\'';
$string['selectfiles'] = 'Izberi datoteke';
$string['selectmoduletoviewhelp'] = 'Izberite modul za ogled te pomoči.';
$string['selectnos'] = 'Izberi vse \'ne\'';
$string['selectperiod'] = 'Izberite obdobje';
$string['senddetails'] = 'Pošlji moje podrobnosti prek e-pošte';
$string['separate'] = 'Ločeno';
$string['separateandconnected'] = 'Ločeni in povezani načini znanja';
$string['separateandconnectedinfo'] = 'Lestvica temelji na teoriji ločenega in povezanega znanja. Ta teorija opisuje dva različna načina vrednotenja in učenja o stvareh, ki jih vidimo in slišimo. <ul> <li> <strong> Strokovnjaki ločenega znanja </ strong> ostajajo objektivni, ne da bi vključevali občutke in čustva. V pogovoru z drugimi ljudmi, jim je všeč, da branijo svoje ideje z uporabo logike, da bi našli luknje v idejah nasprotnika. </ li> <li> <strong> Strokovnjaki povezanega znanja </ strong> so bolj občutljivi do drugih ljudi. So empatični, radi poslušajo in postavljajo vprašanja toliko časa, da se lahko povežejo s človekom in "razumejo stvari iz svojega stališča". Učijo se prek izkušenj, ki so pripeljale do znanja, ki ga najdejo v drugih ljudeh. </ li> </ ul>';
$string['servererror'] = 'Pri komunikaciji z strežnikom je prišlo do napake.';
$string['serverlocaltime'] = 'Strežnikov lokalni čas';
$string['setcategorytheme'] = 'Določi temo kategorije';
$string['setpassword'] = 'Nastavi geslo';
$string['setpasswordinstructions'] = 'Spodaj dvakrat vnesite novo geslo in nato kliknite gumb \'Shrani spremembe\'.<br />Vaše novo geslo bo shranjeno in prijavljeni boste v sistem.';
$string['settings'] = 'Nastavitve';
$string['shortname'] = 'Kratko ime';
$string['shortnamecollisionwarning'] = '[*] = To kratko ime že uporablja predmet in ga bo potrebno pred odobritvijo spremeniti';
$string['shortnamecourse'] = 'Kratko ime predmeta';
$string['shortnamecourse_help'] = '<p>Mnoge ustanove imajo okrajšave za sklic na določen predmet, npr. OE01 ali STO1. Tudi če nimate takega kratkega imena za vaš predmet, si ga tu izmislite. Uporabljen bo na nekaterih mestih, kjer dolgo ime ni primerno (na primer v vrstici zadeve e-poštnega sporočila).</p>';
$string['shortnametaken'] = 'Kratko ime že uporablja drug predmet ({$a})';
$string['shortnameuser'] = 'Kratko ime uporabnika';
$string['shortsitename'] = 'Kratko ime za stran (npr. ena beseda)';
$string['show'] = 'Pokaži';
$string['showactions'] = 'Pokaži dejanja';
$string['showadvancedsettings'] = 'Pokaži dodatne nastavitve';
$string['showall'] = 'Pokaži vse {$a}';
$string['showallcourses'] = 'Pokaži vse predmete';
$string['showallusers'] = 'Pokaži vse uporabnike';
$string['showblockcourse'] = 'Prikaži seznam predmetov, ki vsebujejo blok';
$string['showcomments'] = 'Prikaži/skrij komentarje';
$string['showcommentsnonjs'] = 'Prikaži komentarje';
$string['showdescription'] = 'Prikaži opis na glavni strani predmeta';
$string['showdescription_help'] = 'Če je omogočeno bo zgornji uvod / opis prikazan na glavni strani predmeta, tik pod povezavo na dejavnost / vir.';
$string['showgrades'] = 'Prikaži ocene udeležencem';
$string['showgrades_help'] = '<p>Mnoge dejavnosti omogočajo nastavitev ocen.</p>

<p>Privzeto bodo rezultati vseh ocen v okviru predmeta na voljo na strani Ocene, ki je dostopna iz glavne strani predmeta.</p>

<p>Če izvajalec ne želi uporabljati ocen v predmetu ali želi skriti redovalnico pred udeleženci, lahko onemogoči prikaz redovalnice v Nastavitvah predmeta. To ne prepreči možnosti, da posamezna dejavnost uporablja ali ima nastavljene ocene, prav tako <strong>ne</strong> onemogoči prikaz ocen udeležencem znotraj posameznih dejavnosti.</p>';
$string['showlistofcourses'] = 'Pokaži seznam predmetov';
$string['showmodulecourse'] = 'Prikaži seznam predmetov, ki vsebujejo dejavnost';
$string['showonly'] = 'Pokaži samo';
$string['showperpage'] = 'Pokaži {$a} na stran';
$string['showrecent'] = 'Pokaži nedavne dejavnosti';
$string['showreports'] = 'Pokaži poročilo dejavnosti';
$string['showreports_help'] = '<p>Poročila dejavnosti so na voljo za vse udeležence, ki izkazujejo dejavnost v trenutnem predmetu.  Poleg seznamov njihovih prispevkov ta poročila vključujejo tudi podroben dnevnik dostopov.</p>

<p>Izvajalci imajo vedno dostop do teh poročil z gumbom, vidnim na strani profila vsake osebe.</p>

<p>Dostop udeležencev do njihovih lastnih poročil nadzoruje izvajalec prek nastavitev predmeta.  Za nekatere predmete so ta poročila lahko uporabno orodje, da se udeleženci soočijo z lastno predanostjo in prisotnostjo v okviru spletnega okolja; za druge predmete to morda ni potrebno.</p>

<p>Drug razlog za izklop utegne biti dejstvo, da lahko priprava poročil nekoliko obremeni strežnik.  Za velike ali dolge predmete je lahko bolj učinkovito, če pustite možnost izključeno.<p>';
$string['showsettings'] = 'Pokaži nastavitve';
$string['showtheselogs'] = 'Pokaži te dnevnike';
$string['showthishelpinlanguage'] = 'Prikaži pomoč v jeziku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od zadnje prijave';
$string['site'] = 'Spletno mesto';
$string['sitedefault'] = 'Privzeto za spletno mesto';
$string['siteerrors'] = 'Napake spletnega mesta';
$string['sitefiles'] = 'Datoteke spletnega mesta';
$string['sitefilesused'] = 'Datoteke strani, ki so v rabi v tem predmetu';
$string['sitehome'] = 'Prva stran spltnega mesta';
$string['sitelegacyfiles'] = 'Podedovane datoteke spletnega mesta';
$string['sitelogs'] = 'Dnevniki spletnega mesta';
$string['sitemessage'] = 'Obvesti uporabnike';
$string['sitenews'] = 'Novice spletnega mesta';
$string['sitepages'] = 'Strani spletnega mesta';
$string['sitepartlist'] = 'Nimate zahtevanih dovoljenj za ogled seznama udeležencev';
$string['sitepartlist0'] = 'Za ogled udeležencev spletnega mesta morate biti izvajalec spletnega mesta';
$string['sitepartlist1'] = 'Za ogled udeležencev spletnega mesta morate biti izvajalec';
$string['sites'] = 'Spletna mesta';
$string['sitesection'] = 'Vključi odsek poglavja';
$string['sitesettings'] = 'Nastavitve spletnega mesta';
$string['siteteachers'] = 'Izvajalci spletnega mesta';
$string['size'] = 'Velikost';
$string['sizeb'] = 'bajtov';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Preskočeno';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Družabni forum - zadnja poglavja';
$string['someallowguest'] = 'Nekateri predmeti morda omogočajo dostop gostom';
$string['someerrorswerefound'] = 'Nekatere informacije manjkajo ali so nepravilne. Spodaj si oglejte podrobnosti.';
$string['sort'] = 'Razvrsti';
$string['sortby'] = 'Razvrsti po';
$string['sortbyx'] = 'Razvrsti po {$a} naraščajoče';
$string['sortbyxreverse'] = 'Razvrsti po {$a} padajoče';
$string['sorting'] = 'Razvrščanje';
$string['sourcerole'] = 'Izvorna vloga';
$string['specifyname'] = 'Morate navesti ime.';
$string['standard'] = 'Standarni';
$string['starpending'] = '([*] = predmet čaka na odobritev)';
$string['startdate'] = 'Datum začetka predmeta';
$string['startdate_help'] = 'Ta nastavitev določa začetek prvega tedna predmeta v tedenski obliki. Določa tudi najbolj zgodnji datum prikaza dnevnikov dejavnosti v predmetu.';
$string['startingfrom'] = 'Začne se od';
$string['startsignup'] = 'Ustvari nov račun';
$string['state'] = 'Občina';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistični graf';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Prijave';
$string['statsmodedetailed'] = 'Podroben (uporabniški) pogled';
$string['statsmodegeneral'] = 'Splošen pogled';
$string['statsnodata'] = 'Za to kombinacijo predmeta in časovnega obdobja ni na voljo podatkov.';
$string['statsnodatauser'] = 'Za to kombinacijo predmeta, uporabnika in časovnega obdobja ni na voljo podatkov.';
$string['statsoff'] = 'Statistika trenutno ni omogočena';
$string['statsreads'] = 'Ogledi';
$string['statsreport1'] = 'Prijave';
$string['statsreport10'] = 'Uporabniška dejavnost';
$string['statsreport11'] = 'Najdejavnejši predmeti';
$string['statsreport12'] = 'Najdejavnejši predmeti (uteženo)';
$string['statsreport13'] = 'Predmeti z največ sodelovanja (vpisi)';
$string['statsreport14'] = 'Predmeti z največ sodelovanja (ogledi in objave)';
$string['statsreport2'] = 'Pogledi (vse vloge)';
$string['statsreport3'] = 'Objave (vse vloge)';
$string['statsreport4'] = 'Vse dejavnosti (vse vloge)';
$string['statsreport5'] = 'Vse dejavnosti (ogledi in objave)';
$string['statsreport7'] = 'Dejavnost uporabnika (ogledi in objave)';
$string['statsreport8'] = 'Vse dejavnosti uporabnika';
$string['statsreport9'] = 'Prijave (predmet strani)';
$string['statsreportactivity'] = 'Vse dejavnosti (vse vloge)';
$string['statsreportactivitybyrole'] = 'Vse dejavnosti (ogledi in objave)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Prijave';
$string['statsreportreads'] = 'Ogledi (vse vloge)';
$string['statsreporttype'] = 'Vrsta poročila';
$string['statsreportwrites'] = 'Objave (vse vloge)';
$string['statsstudentactivity'] = 'Dejavnost udeleženca';
$string['statsstudentreads'] = 'Ogledi udeleženca';
$string['statsstudentwrites'] = 'Objave udeleženca';
$string['statsteacheractivity'] = 'Dejavnost izvajalca';
$string['statsteacherreads'] = 'Ogledi izvajalca';
$string['statsteacherwrites'] = 'Objave izvajalca';
$string['statstimeperiod'] = 'Časovno obdobje - zadnjih:';
$string['statsuniquelogins'] = 'Enolične prijave';
$string['statsuseractivity'] = 'Vse dejavnosti';
$string['statsuserlogins'] = 'Prijave';
$string['statsuserreads'] = 'Ogledi';
$string['statsuserwrites'] = 'Objave';
$string['statswrites'] = 'Objave';
$string['status'] = 'Stanje';
$string['stringsnotset'] = 'Sledeči nizi niso določeni v {$a}';
$string['studentnotallowed'] = 'Žal v ta predmet ne morete vstopiti kot \'{$a}\'';
$string['students'] = 'Udeleženci';
$string['studentsandteachers'] = 'Udeleženci in izvajalci';
$string['subcategories'] = 'Podkategorije';
$string['subcategory'] = 'Podkategorija';
$string['subcategoryof'] = 'Podkategorija kategorije {$a}';
$string['submit'] = 'Pošlji';
$string['success'] = 'Uspešno';
$string['summary'] = 'Povzetek';
$string['summary_help'] = '<p>Smisel povzetka poglavja je zelo kratko besedilo, ki udeležence pripravi na dejavnosti v tem poglavju (ali tednu).</p>

<p>Vsak povzetek naj bo zelo kratek, tako da stran predmeta ne postane predolga.</p>

<p>Če se vam zdi, da morate povedati več kot stavek ali dva, potem

   razmislite o tem, da bi namesto tega dodali vir v to poglavje (na primer prva dejavnost

   bi lahko bila stran z imenom <b>O tem poglavju</b>).</p>';
$string['summaryof'] = 'Povzetek {$a}';
$string['supplyinfo'] = 'Prosimo, priskrbite nekaj informacij o sebi';
$string['suspended'] = 'Začasno onemogočen';
$string['suspendedusers'] = 'Začasno onemogočeni uporabniki';
$string['switchdevicedefault'] = 'Preklopi na standardno temo';
$string['switchdevicerecommended'] = 'Preklopi na priporočljivo temo za vašo napravo';
$string['switchrolereturn'] = 'Vrni se v mojo običajno vlogo';
$string['switchroleto'] = 'Zamenjaj vlogo v...';
$string['tag'] = 'Oznaka';
$string['tagalready'] = 'Ta oznaka že obstaja';
$string['tagmanagement'] = 'Dodaj / izbriši oznake ...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Ciljna vloga';
$string['teacheronly'] = 'samo za {$a}';
$string['teacherroles'] = 'vloge {$a}';
$string['teachers'] = 'Izvajalci';
$string['textediting'] = 'Ob urejanju besedila';
$string['texteditor'] = 'Uporaba standardnih spletnih obrazcev';
$string['textformat'] = 'Oblika golega besedila';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Tema';
$string['themes'] = 'Teme';
$string['themesaved'] = 'Nova tema je shranjena';
$string['therearecourses'] = 'Število predmetov: {$a}';
$string['thereareno'] = 'V tem predmetu ni {$a}';
$string['thiscategory'] = 'Ta kategorija';
$string['thiscategorycontains'] = 'Ta kategorija vsebuje';
$string['time'] = 'Čas';
$string['timezone'] = 'Časovni pas';
$string['to'] = 'Do';
$string['tocreatenewaccount'] = 'Preskoči za ustvarjanje novega računa';
$string['today'] = 'Danes';
$string['todaylogs'] = 'Današnji dnevniki';
$string['toeveryone'] = 'za vse';
$string['toomanybounces'] = 'Ta elektronski naslov je povzročil preveč odklonitev. <b>Morate</b> ga spremeniti za nadaljevanje.';
$string['toomanytoshow'] = 'Za prikaz je preveč uporabnikov.';
$string['toomanyusersmatchsearch'] = 'Preveč uporabnikov ({$a->count}), ki ustrezajo \'{$a->search}\'';
$string['toomanyuserstoshow'] = ' Preveč uporabnikov ({$a}) za prikaz';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Poglavje';
$string['topichide'] = 'Skrij to poglavje pred {$a}';
$string['topicoutline'] = 'Oris poglavij';
$string['topicshow'] = 'Pokaži to poglavje {$a}';
$string['total'] = 'Skupno';
$string['trackforums'] = 'Sledenje forumu';
$string['trackforumsno'] = 'Ne: ne vodi evidence mojih ogledov objav';
$string['trackforumsyes'] = 'Da: poudari nove objave zame';
$string['trysearching'] = 'Namesto tega poskusite z iskanjem.';
$string['turneditingoff'] = 'Izključi urejanje';
$string['turneditingon'] = 'Vključi urejanje';
$string['undecided'] = 'Neodločeno';
$string['unfinished'] = 'Nedokončano';
$string['unknowncategory'] = 'Neznana kategorija';
$string['unknownerror'] = 'Neznana napaka';
$string['unlimited'] = 'Neomejeno';
$string['unpacking'] = 'Razpakiranje {$a}';
$string['unsafepassword'] = 'Geslo ni varno - poskusite s čim drugim';
$string['untilcomplete'] = 'Do zaključka';
$string['unusedaccounts'] = 'Neuporabljeni računi bodo po {$a} dneh samodejno izpisani';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Unzip varnostne kopije';
$string['up'] = 'Gor';
$string['update'] = 'Posodobi';
$string['updated'] = 'Posodobljeno: {$a}';
$string['updatemymoodleoff'] = 'Ustavi prilagajanje te strani';
$string['updatemymoodleon'] = 'Prilogodi to stran';
$string['updatemyprofile'] = 'Posodobi profil';
$string['updatesevery'] = 'Posodobitev vsakih {$a} sekund';
$string['updatethis'] = 'Posodobi: {$a}';
$string['updatethiscourse'] = 'Posodobi ta predmet';
$string['updatinga'] = 'Posodabljanje: {$a}';
$string['updatingain'] = 'Posodabljanje {$a->what} v {$a->in}';
$string['upload'] = 'Naloži';
$string['uploadafile'] = 'Naloži datoteko';
$string['uploadcantwrite'] = 'Neuspešno zapisovanje datoteke na disk';
$string['uploadedfile'] = 'Datoteka uspešno naložena';
$string['uploadedfileto'] = 'Datoteka {$a->file} naložena v {$a->directory}';
$string['uploadedfiletoobig'] = 'Oprostite, datoteka je prevelika (omejitev je {$a} bajtov)';
$string['uploadextension'] = 'Nalaganje datoteke je ustavila končnica';
$string['uploadfailednotrecovering'] = 'Vaše nalaganje datotek je spodletelo, ker je prišlo do težave z eno izmed datotek {$a->name}.<br /> Tu je dnevnik težav:<br />{$a->problem}</br />Ni obnavljanja.';
$string['uploadfilelog'] = 'Dnevnik nalaganja za datoteko {$a}';
$string['uploadformlimit'] = 'Naložena datoteka presega z obrazcem nastavljeno omejitev največje velikosti';
$string['uploadlabel'] = 'Naslov:';
$string['uploadlimitwithsize'] = '{$a->contextname} omejitev nalaganja ({$a->displaysize})';
$string['uploadnewfile'] = 'Naloži novo datoteko';
$string['uploadnofilefound'] = 'Nobene datoteke ni bilo mogoče najti - ste prepričani, da ste izbrali datoteko za nalaganje?';
$string['uploadnotallowed'] = 'Nalaganje datotek ni dovoljeno';
$string['uploadnotempdir'] = 'Manjka začasna mapa';
$string['uploadoldfilesdeleted'] = 'Stare datoteke v vašem področju nalaganja so bile izbrisane';
$string['uploadpartialfile'] = 'Datoteka je bila samo delno naložena';
$string['uploadproblem'] = 'Ob nalaganju datoteke \'{$a}\' je prišlo do neznane težave (morda je bila prevelika?)';
$string['uploadrenamedchars'] = 'Datoteka je bila preimenovana iz {$a->oldname} v {$a->newname} zaradi neveljavnih znakov.';
$string['uploadrenamedcollision'] = 'Datoteka je bila preimenovana iz {$a->oldname} v {$a->newname} zaradi spora pri imenih datotek.';
$string['uploadserverlimit'] = 'Naložena datoteka presega na strežniku nastavljeno omejitev največje velikosti';
$string['uploadthisfile'] = 'Naloži to datoteko';
$string['url'] = 'URL';
$string['used'] = 'Uporabljeno';
$string['usedinnplaces'] = 'Uporabljeno na {$a} mestih';
$string['usemessageform'] = 'ali uporabite spodnji obrazec za pošiljanje sporočila izbranim udeležencem';
$string['user'] = 'Uporabnik';
$string['userconfirmed'] = 'Potrjeno {$a}';
$string['usercurrentsettings'] = 'Nastavitve mojega profila';
$string['userdata'] = 'Podatki uporabnika';
$string['userdeleted'] = 'Ta uporabniški račun je bil izbrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'To polje vam omogoča, da vnesete nekaj besedila o sebi, in bo nato prikazano na straneh vašega profila vidno drugim.';
$string['userdetails'] = 'Uporabnikove podrobnosti';
$string['userfiles'] = 'Uporabnikove datoteke';
$string['userlist'] = 'Seznam uporabnikov';
$string['username'] = 'Uporabniško ime';
$string['usernameemailmatch'] = 'Uporabniško ime in elektronski naslov se ne nanašata na istega uporabnika';
$string['usernameexists'] = 'To uporabniško ime že obstaja, izberite drugačnega';
$string['usernamelowercase'] = 'Dovoljene so samo male črke';
$string['usernamenotfound'] = 'To uporabniško ime ni bilo najdeno v podatkovni zbirki';
$string['usernameoremail'] = 'Vnesite uporabniško ime ali naslov e-pošte';
$string['usernotconfirmed'] = 'Ni bilo možno potrditi {$a}';
$string['userpic'] = 'Slika uporabnika';
$string['users'] = 'Uporabniki';
$string['userselectorautoselectunique'] = 'Če samo en uporabnik ustreza iskanju, ga izberi samodejno';
$string['userselectorpreserveselected'] = 'Obdrži izbrane uporabnike, četudi več ne utrezajo iskanju';
$string['userselectorsearchanywhere'] = 'Označi iskanje po besedilu povsod, kjer je uporabnikovo ime';
$string['usersnew'] = 'Novi uporabniki';
$string['usersnoaccesssince'] = 'Neaktivni za več kot';
$string['userswithfiles'] = 'Uporabniki z datotekami';
$string['useruploadtype'] = 'Tip uporabnikovega nalaganja {$a}';
$string['userviewingsettings'] = 'Nastavitve profila za {$a}';
$string['userzones'] = 'Uporabniška področja';
$string['usetheme'] = 'Uporabi temo';
$string['usingexistingcourse'] = 'Uporaba obstoječega predmeta';
$string['valuealreadyused'] = 'Ta vrednost je že v uporabi.';
$string['version'] = 'Različica';
$string['view'] = 'Ogled';
$string['viewallcourses'] = 'Poglej vse predmete';
$string['viewallcoursescategories'] = 'Poglej vse predmete in kategorije';
$string['viewallsubcategories'] = 'Preglejte vse podkategorije';
$string['viewfileinpopup'] = 'Ogled fatoteke v pojavnem oknu';
$string['viewmore'] = 'Pokaži več';
$string['viewprofile'] = 'Poglej profil';
$string['views'] = 'Ogledi';
$string['viewsolution'] = 'ogled rešitve';
$string['virusfound'] = 'Pozor skrbnik! Clam AV je našel virus v datoteki, ki jo je naložil {$a->user} v predmet {$a->course}. Tu je rezultat clamscan:';
$string['virusfoundlater'] = 'V datoteki, ki ste jo naložili dne {$a->date} z imenom {$a->filename} za predmet {$a->course} je bil najden virus.  Tu je povzetek dogajanja z vašo datoteko:

{$a->action}

Če je bilo to oddano delo, ga boste morda želeli ponovno oddati, da ga bo izvajalec predmeta lahko videl.';
$string['virusfoundlateradmin'] = 'Pozor skrbnik! V datoteki, ki jo je naložil uporabnik {$a->user} dne {$a->date} z imenom {$a->filename} za predmet {$a->course} je bil najden virus.  Tu je povzetek dogajanja z  datoteko:

{$a->action}

Obveščen je bil tudi uporabnik.';
$string['virusfoundlateradminnolog'] = 'Pozor skrbnik! V datoteki naloženi pod imenom {$a->filename} je bil odkrit virus. Moodle ni uspel ugotoviti uporabnika, ki je izvirno naložil datoteko.

Tu je povzetek dogajanja z  datoteko:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Virus je bil najden!';
$string['virusfounduser'] = 'Datoteka {$a->filename}, ki sto jo naložili, je bila preverjena s protivirusnim programom in označena kot okužena! Nalaganje vaše datoteke NI bilo uspešno.';
$string['virusplaceholder'] = 'V naloženi datoteki je bil odkrit virus in je bila premaknjena ali izbrisana, o čemer je bil obveščen tudi uporabnik.';
$string['visible'] = 'Vidno';
$string['visible_help'] = 'Ta možnost določa ali se predmet pojavi v seznamu predmetov. Uporabnikom, razen učiteljem in administratorjem, vstop v predmet ni dovoljen.';
$string['visibletostudents'] = 'Vidno za {$a}';
$string['warning'] = 'Opozorilo';
$string['warningdeleteresource'] = 'Opozorilo: na {$a} se sklicuje vir. Želite posodobiti vir?';
$string['webpage'] = 'Spletna stran';
$string['week'] = 'Teden';
$string['weekhide'] = 'Skrij ta teden pred {$a}';
$string['weeklyoutline'] = 'Tedenski oris';
$string['weeks'] = 'tednov';
$string['weekshow'] = 'Pokaži ta teden {$a}';
$string['welcometocourse'] = 'Dobrodošli v {$a}';
$string['welcometocoursetext'] = 'Dobrodošli v {$a->coursename}!

Če tega še niste storili, bi morali urediti stran z vašim profilom
v predmetu, tako bomo lahko zvedeli več o vas:

  {$a->profileurl}';
$string['whatforlink'] = 'Kaj želite storiti s povezavo?';
$string['whatforpage'] = 'Kaj želite storiti z besedilom?';
$string['whattocallzip'] = 'Kako želite poimenovati Zip datoteko?';
$string['whattodo'] = 'Kaj narediti';
$string['windowclosing'] = 'Okno se bi moralo zapreti somodejno. Če se ni, ga zaprite zdaj.';
$string['withchosenfiles'] = 'Z izbranimi datotekami';
$string['withdisablednote'] = '{$a} (onemogočen)';
$string['withoutuserdata'] = 'brez uporabniških podatkov';
$string['withselectedusers'] = 'Z izbranimi udeleženci ...';
$string['withselectedusers_help'] = '* Pošlji sporočilo - Za pošiljanje sporočil enemu ali več udeležencem

* Dodaj novo opombo - za dodajanje opombe k izbranemu udeležencu

* Dodaj skupno opombo - za dodajanje iste opombe več kot enemu udeležencu

* Podaljšaj vpis (posamezno) - za razširitev dostopa izbranim udeležencem, tudi če je obdobje vpisa nastavljeno

* Podaljšaj vpis (skupno) - za razširitev dostopa več kot enemu udeležencu prek iste vrednosti';
$string['withuserdata'] = 'z uporabniškimi podatki';
$string['wordforstudent'] = 'Vaša beseda za udeleženca';
$string['wordforstudenteg'] = 'npr. udeleženec, učenec, dijak, študent itn.';
$string['wordforstudents'] = 'Vaša beseda za udeležence';
$string['wordforstudentseg'] = 'npr. udeleženci, učenci, dijaki, študenti itn.';
$string['wordforteacher'] = 'Vaša beseda za izvajalca';
$string['wordforteachereg'] = 'npr. izvajalec, učitelj, profesor, mentor, predavatelj itn.';
$string['wordforteachers'] = 'Vaša beseda za izvajalce';
$string['wordforteacherseg'] = 'npr. izvajalci, učitelji, profesorji, mentorji, predavatelji itn.';
$string['writingblogsinfo'] = 'Pisanje informacij o blogih';
$string['writingcategoriesandquestions'] = 'Pisanje kategorij in vprašanj';
$string['writingcoursedata'] = 'Pisanje podatkov predmeta';
$string['writingeventsinfo'] = 'Pisanje informacij o dogodkih';
$string['writinggeneralinfo'] = 'Pisanje splošnih informacij';
$string['writinggradebookinfo'] = 'Pisanje informacij redovalnice';
$string['writinggroupingsgroupsinfo'] = 'Pisanje informacij o skupkih-skupinah';
$string['writinggroupingsinfo'] = 'Pisanje informacij o skupkih';
$string['writinggroupsinfo'] = 'Pisanje informacij o skupinah';
$string['writingheader'] = 'Pisanje glave';
$string['writingloginfo'] = 'Zapisovanje informacij dnevnika';
$string['writingmessagesinfo'] = 'Pisanje informacij o sporočilih';
$string['writingmoduleinfo'] = 'Pisanje informacij o modulih';
$string['writingscalesinfo'] = 'Pisanje informacij o lestvicah';
$string['writinguserinfo'] = 'Pisanje informacij o uporabnikih';
$string['wrongpassword'] = 'Nepravilno geslo za to uporabniško ime';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'leto';
$string['years'] = 'leta';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Ustvarili boste Zip datoteko, ki bo vsebovala';
$string['youaregoingtorestorefrom'] = 'Zagnali poste postopek obnavljanja za';
$string['youneedtoenrol'] = 'Za izvajanje tega dejanja morate biti vpisani v ta predmet.';
$string['yourlastlogin'] = 'Vaša zadnja prijave je bila';
$string['yourself'] = 'samega sebe';
$string['yourteacher'] = 'vaš {$a}';
$string['yourwordforx'] = 'Vaša beseda za \'{$a}\'';
$string['zippingbackup'] = 'Stiskanje varnostne kopije (ZIP)';
